
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise(function (resolveModule, reject) {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;

        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var g;g||=typeof Module != 'undefined' ? Module : {};var aa="object"==typeof window,ba="undefined"!=typeof WorkerGlobalScope,ca="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node&&"renderer"!=process.type;"use strict";
g.onRuntimeInitialized=function(){function a(f,l){switch(typeof l){case "boolean":fc(f,l?1:0);break;case "number":gc(f,l);break;case "string":hc(f,l,-1,-1);break;case "object":if(null===l)nb(f);else if(null!=l.length){var n=da(l,ea);ic(f,n,l.length,-1);fa(n)}else ya(f,"Wrong API use : tried to return a value of an unknown type ("+l+").",-1);break;default:nb(f)}}function b(f,l){for(var n=[],q=0;q<f;q+=1){var v=m(l+4*q,"i32"),A=jc(v);if(1===A||2===A)v=kc(v);else if(3===A)v=lc(v);else if(4===A){A=v;
v=mc(A);A=nc(A);for(var N=new Uint8Array(v),L=0;L<v;L+=1)N[L]=p[A+L];v=N}else v=null;n.push(v)}return n}function c(f,l){this.Qa=f;this.db=l;this.Oa=1;this.lb=[]}function d(f,l){this.db=l;l=ha(f)+1;this.eb=ia(l);if(null===this.eb)throw Error("Unable to allocate memory for the SQL string");t(f,w,this.eb,l);this.kb=this.eb;this.Za=this.pb=null}function e(f){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=f){var l=this.filename,n="/",q=l;n&&(n="string"==typeof n?n:ja(n),q=l?ka(n+"/"+l):
n);l=la(!0,!0);q=ma(q,l);if(f){if("string"==typeof f){n=Array(f.length);for(var v=0,A=f.length;v<A;++v)n[v]=f.charCodeAt(v);f=n}na(q,l|146);n=oa(q,577);pa(n,f,0,f.length,0);qa(n);na(q,l)}}this.handleError(r(this.filename,h));this.db=m(h,"i32");qb(this.db);this.fb={};this.Sa={}}var h=x(4),k=g.cwrap,r=k("sqlite3_open","number",["string","number"]),y=k("sqlite3_close_v2","number",["number"]),u=k("sqlite3_exec","number",["number","string","number","number","number"]),E=k("sqlite3_changes","number",["number"]),
H=k("sqlite3_prepare_v2","number",["number","string","number","number","number"]),rb=k("sqlite3_sql","string",["number"]),pc=k("sqlite3_normalized_sql","string",["number"]),sb=k("sqlite3_prepare_v2","number",["number","number","number","number","number"]),qc=k("sqlite3_bind_text","number",["number","number","number","number","number"]),tb=k("sqlite3_bind_blob","number",["number","number","number","number","number"]),rc=k("sqlite3_bind_double","number",["number","number","number"]),sc=k("sqlite3_bind_int",
"number",["number","number","number"]),tc=k("sqlite3_bind_parameter_index","number",["number","string"]),uc=k("sqlite3_step","number",["number"]),vc=k("sqlite3_errmsg","string",["number"]),wc=k("sqlite3_column_count","number",["number"]),xc=k("sqlite3_data_count","number",["number"]),yc=k("sqlite3_column_double","number",["number","number"]),ub=k("sqlite3_column_text","string",["number","number"]),zc=k("sqlite3_column_blob","number",["number","number"]),Ac=k("sqlite3_column_bytes","number",["number",
"number"]),Bc=k("sqlite3_column_type","number",["number","number"]),Cc=k("sqlite3_column_name","string",["number","number"]),Dc=k("sqlite3_reset","number",["number"]),Ec=k("sqlite3_clear_bindings","number",["number"]),Fc=k("sqlite3_finalize","number",["number"]),vb=k("sqlite3_create_function_v2","number","number string number number number number number number number".split(" ")),jc=k("sqlite3_value_type","number",["number"]),mc=k("sqlite3_value_bytes","number",["number"]),lc=k("sqlite3_value_text",
"string",["number"]),nc=k("sqlite3_value_blob","number",["number"]),kc=k("sqlite3_value_double","number",["number"]),gc=k("sqlite3_result_double","",["number","number"]),nb=k("sqlite3_result_null","",["number"]),hc=k("sqlite3_result_text","",["number","string","number","number"]),ic=k("sqlite3_result_blob","",["number","number","number","number"]),fc=k("sqlite3_result_int","",["number","number"]),ya=k("sqlite3_result_error","",["number","string","number"]),wb=k("sqlite3_aggregate_context","number",
["number","number"]),qb=k("RegisterExtensionFunctions","number",["number"]),xb=k("sqlite3_update_hook","number",["number","number","number"]);c.prototype.bind=function(f){if(!this.Qa)throw"Statement closed";this.reset();return Array.isArray(f)?this.Cb(f):null!=f&&"object"===typeof f?this.Db(f):!0};c.prototype.step=function(){if(!this.Qa)throw"Statement closed";this.Oa=1;var f=uc(this.Qa);switch(f){case 100:return!0;case 101:return!1;default:throw this.db.handleError(f);}};c.prototype.wb=function(f){null==
f&&(f=this.Oa,this.Oa+=1);return yc(this.Qa,f)};c.prototype.Gb=function(f){null==f&&(f=this.Oa,this.Oa+=1);f=ub(this.Qa,f);if("function"!==typeof BigInt)throw Error("BigInt is not supported");return BigInt(f)};c.prototype.Hb=function(f){null==f&&(f=this.Oa,this.Oa+=1);return ub(this.Qa,f)};c.prototype.getBlob=function(f){null==f&&(f=this.Oa,this.Oa+=1);var l=Ac(this.Qa,f);f=zc(this.Qa,f);for(var n=new Uint8Array(l),q=0;q<l;q+=1)n[q]=p[f+q];return n};c.prototype.get=function(f,l){l=l||{};null!=f&&
this.bind(f)&&this.step();f=[];for(var n=xc(this.Qa),q=0;q<n;q+=1)switch(Bc(this.Qa,q)){case 1:var v=l.useBigInt?this.Gb(q):this.wb(q);f.push(v);break;case 2:f.push(this.wb(q));break;case 3:f.push(this.Hb(q));break;case 4:f.push(this.getBlob(q));break;default:f.push(null)}return f};c.prototype.getColumnNames=function(){for(var f=[],l=wc(this.Qa),n=0;n<l;n+=1)f.push(Cc(this.Qa,n));return f};c.prototype.getAsObject=function(f,l){f=this.get(f,l);l=this.getColumnNames();for(var n={},q=0;q<l.length;q+=
1)n[l[q]]=f[q];return n};c.prototype.getSQL=function(){return rb(this.Qa)};c.prototype.getNormalizedSQL=function(){return pc(this.Qa)};c.prototype.run=function(f){null!=f&&this.bind(f);this.step();return this.reset()};c.prototype.sb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);f=ra(f);var n=da(f,ea);this.lb.push(n);this.db.handleError(qc(this.Qa,l,n,f.length-1,0))};c.prototype.Bb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);var n=da(f,ea);this.lb.push(n);this.db.handleError(tb(this.Qa,l,n,f.length,
0))};c.prototype.rb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);this.db.handleError((f===(f|0)?sc:rc)(this.Qa,l,f))};c.prototype.Eb=function(f){null==f&&(f=this.Oa,this.Oa+=1);tb(this.Qa,f,0,0,0)};c.prototype.tb=function(f,l){null==l&&(l=this.Oa,this.Oa+=1);switch(typeof f){case "string":this.sb(f,l);return;case "number":this.rb(f,l);return;case "bigint":this.sb(f.toString(),l);return;case "boolean":this.rb(f+0,l);return;case "object":if(null===f){this.Eb(l);return}if(null!=f.length){this.Bb(f,
l);return}}throw"Wrong API use : tried to bind a value of an unknown type ("+f+").";};c.prototype.Db=function(f){var l=this;Object.keys(f).forEach(function(n){var q=tc(l.Qa,n);0!==q&&l.tb(f[n],q)});return!0};c.prototype.Cb=function(f){for(var l=0;l<f.length;l+=1)this.tb(f[l],l+1);return!0};c.prototype.reset=function(){this.freemem();return 0===Ec(this.Qa)&&0===Dc(this.Qa)};c.prototype.freemem=function(){for(var f;void 0!==(f=this.lb.pop());)fa(f)};c.prototype.free=function(){this.freemem();var f=
0===Fc(this.Qa);delete this.db.fb[this.Qa];this.Qa=0;return f};d.prototype.next=function(){if(null===this.eb)return{done:!0};null!==this.Za&&(this.Za.free(),this.Za=null);if(!this.db.db)throw this.mb(),Error("Database closed");var f=sa(),l=x(4);ta(h);ta(l);try{this.db.handleError(sb(this.db.db,this.kb,-1,h,l));this.kb=m(l,"i32");var n=m(h,"i32");if(0===n)return this.mb(),{done:!0};this.Za=new c(n,this.db);this.db.fb[n]=this.Za;return{value:this.Za,done:!1}}catch(q){throw this.pb=ua(this.kb),this.mb(),
q;}finally{va(f)}};d.prototype.mb=function(){fa(this.eb);this.eb=null};d.prototype.getRemainingSQL=function(){return null!==this.pb?this.pb:ua(this.kb)};"function"===typeof Symbol&&"symbol"===typeof Symbol.iterator&&(d.prototype[Symbol.iterator]=function(){return this});e.prototype.run=function(f,l){if(!this.db)throw"Database closed";if(l){f=this.prepare(f,l);try{f.step()}finally{f.free()}}else this.handleError(u(this.db,f,0,0,h));return this};e.prototype.exec=function(f,l,n){if(!this.db)throw"Database closed";
var q=sa(),v=null;try{var A=wa(f),N=x(4);for(f=[];0!==m(A,"i8");){ta(h);ta(N);this.handleError(sb(this.db,A,-1,h,N));var L=m(h,"i32");A=m(N,"i32");if(0!==L){var K=null;v=new c(L,this);for(null!=l&&v.bind(l);v.step();)null===K&&(K={columns:v.getColumnNames(),values:[]},f.push(K)),K.values.push(v.get(null,n));v.free()}}return f}catch(O){throw v&&v.free(),O;}finally{va(q)}};e.prototype.each=function(f,l,n,q,v){"function"===typeof l&&(q=n,n=l,l=void 0);f=this.prepare(f,l);try{for(;f.step();)n(f.getAsObject(null,
v))}finally{f.free()}if("function"===typeof q)return q()};e.prototype.prepare=function(f,l){ta(h);this.handleError(H(this.db,f,-1,h,0));f=m(h,"i32");if(0===f)throw"Nothing to prepare";var n=new c(f,this);null!=l&&n.bind(l);return this.fb[f]=n};e.prototype.iterateStatements=function(f){return new d(f,this)};e.prototype["export"]=function(){Object.values(this.fb).forEach(function(l){l.free()});Object.values(this.Sa).forEach(z);this.Sa={};this.handleError(y(this.db));var f=xa(this.filename);this.handleError(r(this.filename,
h));this.db=m(h,"i32");qb(this.db);return f};e.prototype.close=function(){null!==this.db&&(Object.values(this.fb).forEach(function(f){f.free()}),Object.values(this.Sa).forEach(z),this.Sa={},this.Ya&&(z(this.Ya),this.Ya=void 0),this.handleError(y(this.db)),za("/"+this.filename),this.db=null)};e.prototype.handleError=function(f){if(0===f)return null;f=vc(this.db);throw Error(f);};e.prototype.getRowsModified=function(){return E(this.db)};e.prototype.create_function=function(f,l){Object.prototype.hasOwnProperty.call(this.Sa,
f)&&(z(this.Sa[f]),delete this.Sa[f]);var n=Aa(function(q,v,A){v=b(v,A);try{var N=l.apply(null,v)}catch(L){ya(q,L,-1);return}a(q,N)},"viii");this.Sa[f]=n;this.handleError(vb(this.db,f,l.length,1,0,n,0,0,0));return this};e.prototype.create_aggregate=function(f,l){var n=l.init||function(){return null},q=l.finalize||function(K){return K},v=l.step;if(!v)throw"An aggregate function must have a step function in "+f;var A={};Object.hasOwnProperty.call(this.Sa,f)&&(z(this.Sa[f]),delete this.Sa[f]);l=f+"__finalize";
Object.hasOwnProperty.call(this.Sa,l)&&(z(this.Sa[l]),delete this.Sa[l]);var N=Aa(function(K,O,Ta){var Z=wb(K,1);Object.hasOwnProperty.call(A,Z)||(A[Z]=n());O=b(O,Ta);O=[A[Z]].concat(O);try{A[Z]=v.apply(null,O)}catch(Hc){delete A[Z],ya(K,Hc,-1)}},"viii"),L=Aa(function(K){var O=wb(K,1);try{var Ta=q(A[O])}catch(Z){delete A[O];ya(K,Z,-1);return}a(K,Ta);delete A[O]},"vi");this.Sa[f]=N;this.Sa[l]=L;this.handleError(vb(this.db,f,v.length-1,1,0,0,N,L,0));return this};e.prototype.updateHook=function(f){this.Ya&&
(xb(this.db,0,0),z(this.Ya),this.Ya=void 0);f&&(this.Ya=Aa(function(l,n,q,v,A){switch(n){case 18:l="insert";break;case 23:l="update";break;case 9:l="delete";break;default:throw"unknown operationCode in updateHook callback: "+n;}q=q?B(w,q):"";v=v?B(w,v):"";if(A>Number.MAX_SAFE_INTEGER)throw"rowId too big to fit inside a Number";f(l,q,v,Number(A))},"viiiij"),xb(this.db,this.Ya,0))};g.Database=e};var Ba={...g},Ca="./this.program",Da=(a,b)=>{throw b;},C="",Ea,Fa;
if(ca){var fs=require("fs");require("path");C=__dirname+"/";Fa=a=>{a=Ga(a)?new URL(a):a;return fs.readFileSync(a)};Ea=async a=>{a=Ga(a)?new URL(a):a;return fs.readFileSync(a,void 0)};!g.thisProgram&&1<process.argv.length&&(Ca=process.argv[1].replace(/\\/g,"/"));process.argv.slice(2);"undefined"!=typeof module&&(module.exports=g);Da=(a,b)=>{process.exitCode=a;throw b;}}else if(aa||ba)ba?C=self.location.href:"undefined"!=typeof document&&document.currentScript&&(C=document.currentScript.src),C=C.startsWith("blob:")?
"":C.slice(0,C.replace(/[?#].*/,"").lastIndexOf("/")+1),ba&&(Fa=a=>{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}),Ea=async a=>{if(Ga(a))return new Promise((c,d)=>{var e=new XMLHttpRequest;e.open("GET",a,!0);e.responseType="arraybuffer";e.onload=()=>{200==e.status||0==e.status&&e.response?c(e.response):d(e.status)};e.onerror=d;e.send(null)});var b=await fetch(a,{credentials:"same-origin"});if(b.ok)return b.arrayBuffer();throw Error(b.status+
" : "+b.url);};var Ha=g.print||console.log.bind(console),Ia=g.printErr||console.error.bind(console);Object.assign(g,Ba);Ba=null;g.thisProgram&&(Ca=g.thisProgram);var Ja=g.wasmBinary;function Ka(a){this.exports=(
// EMSCRIPTEN_START_ASM
function instantiate(_a){function e(f){f.grow=function(b){var a=this.length;this.length=this.length+b;return a};f.set=function(c,d){this[c]=d};f.get=function(c){return this[c]};return f}var g;var h=new Uint8Array(123);for(var c=25;c>=0;--c){h[48+c]=52+c;h[65+c]=c;h[97+c]=26+c}h[43]=62;h[47]=63;function n(o,p,q){var i,j,c=0,k=p,l=q.length,m=p+(l*3>>2)-(q[l-2]=="=")-(q[l-1]=="=");for(;c<l;c+=4){i=h[q.charCodeAt(c+1)];j=h[q.charCodeAt(c+2)];o[k++]=h[q.charCodeAt(c)]<<2|i>>4;if(k<m)o[k++]=i<<4|j>>2;if(k<m)o[k++]=j<<6|h[q.charCodeAt(c+3)]}return o}function r(s){n(g,1024,"My40OS4xAHt9ACVzLiV6AGpzb25fcHJldHR5AGluZmluaXR5AGFmZmluaXR5AFJlYWxBZmZpbml0eQBidXN5AHRlbXBfc3RvcmVfZGlyZWN0b3J5AG5vdCBhIHdyaXRhYmxlIGRpcmVjdG9yeQBvcGVuRGlyZWN0b3J5AHNocmlua19tZW1vcnkAb3V0IG9mIG1lbW9yeQBmYWlsZWQgdG8gYWxsb2NhdGUgJXUgYnl0ZXMgb2YgbWVtb3J5AEhBVklORyBjbGF1c2Ugb24gYSBub24tYWdncmVnYXRlIHF1ZXJ5AEludENvcHkAU0NvcHkAVkRlc3Ryb3kATXVsdGlwbHkAcXVlcnlfb25seQB1bmxpa2VseQB0YWJsZSAiJXMiIGhhcyBtb3JlIHRoYW4gb25lIHByaW1hcnkga2V5AGZvcmVpZ24ga2V5AGpzb25fZ3JvdXBfYXJyYXkAanNvbmJfZ3JvdXBfYXJyYXkAanNvbl9hcnJheQBqc29uYl9hcnJheQBqdWxpYW5kYXkAZnRzNGF1eAB2YWN1dW1fJTAxNmxseAB1bml4AHNxbGl0ZV9yZW5hbWVfcXVvdGVmaXgAcHJlZml4AExJS0Ugb3IgR0xPQiBwYXR0ZXJuIHRvbyBjb21wbGV4AHVuaGV4AGNoYXJpbmRleABPcGVuQXV0b2luZGV4AGF1dG9tYXRpY19pbmRleABhdXRvLWluZGV4AG9ycGhhbiBpbmRleABEcm9wSW5kZXgAaWR4AFJlb3BlbklkeABwY3gAbWF4AE1lbU1heAAlMDJ4ADB4ACBGUk9NICclcScuJyVxJXMnIEFTIHgAQ1JFQVRFIFRBQkxFIHgAcncAcHNvdwBpbXBsaWVzX25vbm51bGxfcm93AG5vdwBpbnRlZ2VyIG92ZXJmbG93AHdpbmRvdwBzaGFkb3cAUmVzdWx0Um93AElmTnVsbFJvdwBuZXcAbm8gc3VjaCB2aWV3AGNhbm5vdCBtb2RpZnkgJXMgYmVjYXVzZSBpdCBpcyBhIHZpZXcAQ2Fubm90IGFkZCBhIGNvbHVtbiB0byBhIHZpZXcAY2Fubm90IFVQU0VSVCBhIHZpZXcAUHJldgBzdGRldgAgJWxsdQAlYyV1AEZhaWxlZCB0byByZWFkIHB0cm1hcCBrZXk9JXUAJS4qejoldQBPZmZzZXQgJXUgb3V0IG9mIHJhbmdlICV1Li4ldQBpbnZhbGlkIHBhZ2UgbnVtYmVyICV1AGZhaWxlZCB0byBnZXQgcGFnZSAldQAybmQgcmVmZXJlbmNlIHRvIHBhZ2UgJXUARnJhZ21lbnRhdGlvbiBvZiAldSBieXRlcyByZXBvcnRlZCBhcyAldSBvbiBwYWdlICV1AGZyZWVsaXN0IGxlYWYgY291bnQgdG9vIGJpZyBvbiBwYWdlICV1AE11bHRpcGxlIHVzZXMgZm9yIGJ5dGUgJXUgb2YgcGFnZSAldQAlcyBpcyAldSBidXQgc2hvdWxkIGJlICV1AHVuYWJsZSB0byB1c2UgZnVuY3Rpb24gJXMgaW4gdGhlIHJlcXVlc3RlZCBjb250ZXh0AFNvcnRlck5leHQAVk5leHQAaW5jb21wbGV0ZSBpbnB1dABidXN5X3RpbWVvdXQAbG9jYWxob3N0AGNhbm5vdCBkcm9wIGNvbHVtbiAiJXMiOiBubyBvdGhlciBjb2x1bW5zIGV4aXN0AHBlcnNpc3QAZm9yZWlnbl9rZXlfbGlzdABpbmRleF9saXN0AGZ1bmN0aW9uX2xpc3QAY29sbGF0aW9uX2xpc3QAZGF0YWJhc2VfbGlzdABtb2R1bGVfbGlzdABQUkFHTUEgdGFibGVfbGlzdABwcmFnbWFfbGlzdABzZXQgbGlzdABWYWx1ZUxpc3QAc3FsaXRlX3JlbmFtZV90ZXN0AFJvd1NldFRlc3QAU2VxdWVuY2VUZXN0AGZhc3QATGFzdABDYXN0AHNxcnQAU29ydGVyU29ydAAiXC9iZm5ydABqc29uX2luc2VydABqc29uYl9pbnNlcnQASWR4SW5zZXJ0AFNvcnRlckluc2VydAByZXN0YXJ0AGNvdABCaXROb3QASWZOb3QAUGFnZWNvdW50AGZyZWVsaXN0X2NvdW50AG1heF9wYWdlX2NvdW50AFJlc2V0Q291bnQAd2FsX2F1dG9jaGVja3BvaW50AHdhbF9jaGVja3BvaW50AENoZWNrcG9pbnQAU2F2ZXBvaW50AGEgQ0hFQ0sgY29uc3RyYWludAAlc09OIENPTkZMSUNUIGNsYXVzZSBkb2VzIG5vdCBtYXRjaCBhbnkgUFJJTUFSWSBLRVkgb3IgVU5JUVVFIGNvbnN0cmFpbnQAQ3Vyc29ySGludABfY29udGVudABwYXJlbnQARElTVElOQ1QgYWdncmVnYXRlcyBtdXN0IGhhdmUgZXhhY3RseSBvbmUgYXJndW1lbnQAY29tbWVudABBUEkgY2FsbGVkIHdpdGggZmluYWxpemVkIHByZXBhcmVkIHN0YXRlbWVudABBUEkgY2FsbGVkIHdpdGggTlVMTCBwcmVwYXJlZCBzdGF0ZW1lbnQATWF4UGdjbnQAZGVmYXVsdCB2YWx1ZSBvZiBjb2x1bW4gWyVzXSBpcyBub3QgY29uc3RhbnQATXVzdEJlSW50AENhbm5vdCBhZGQgYSBjb2x1bW4gd2l0aCBub24tY29uc3RhbnQgZGVmYXVsdABIYWx0AGxhbm9pdABzdGF0X2luaXQASW5pdABBdXRvQ29tbWl0AGFuYWx5c2lzX2xpbWl0AHNvZnRfaGVhcF9saW1pdABoYXJkX2hlYXBfbGltaXQAam91cm5hbF9zaXplX2xpbWl0AE9mZnNldExpbWl0AFNlZWtIaXQAT04gY2xhdXNlIHJlZmVyZW5jZXMgdGFibGVzIHRvIGl0cyByaWdodABTaGlmdFJpZ2h0AGhnaHQAU2hpZnRMZWZ0AE9mZnNldAByZXNldABqc29uX3NldABqc29uYl9zZXQAdG9vIG1hbnkgY29sdW1ucyBpbiByZXN1bHQgc2V0ACVyIE9SREVSIEJZIHRlcm0gZG9lcyBub3QgbWF0Y2ggYW55IGNvbHVtbiBpbiB0aGUgcmVzdWx0IHNldABzbmlwcGV0AHN0YXRfZ2V0AHNxbGl0ZV9jb21waWxlb3B0aW9uX2dldABzdHJpY3QATm9Db25mbGljdABqc29uX2dyb3VwX29iamVjdABqc29uYl9ncm91cF9vYmplY3QAanNvbl9vYmplY3QAanNvbmJfb2JqZWN0AGpzb25fZXh0cmFjdABqc29uYl9leHRyYWN0AFN1YnRyYWN0AGxzdGF0AGZzdGF0ACVzX3N0YXQAdGJsLGlkeCxzdGF0AHVuc3VwcG9ydGVkIGZpbGUgZm9ybWF0AGdyb3VwX2NvbmNhdABDb25jYXQATHQAR3QAZGVmZXJfZm9yZWlnbl9rZXlzAGFsd2F5cwBwYXJhbWV0ZXJzIGFyZSBub3QgYWxsb3dlZCBpbiB2aWV3cwBjb25jYXRfd3MAc3RhdHVzAHN5bmNocm9ub3VzAGluZGV4ICVzIGFscmVhZHkgZXhpc3RzAG91dHB1dCBmaWxlIGFscmVhZHkgZXhpc3RzACVzICVUIGFscmVhZHkgZXhpc3RzAHRyaWdnZXIgJVQgYWxyZWFkeSBleGlzdHMATm90RXhpc3RzAGlnbm9yZV9jaGVja19jb25zdHJhaW50cwBDSEVDSyBjb25zdHJhaW50cwBleHByZXNzaW9ucyBwcm9oaWJpdGVkIGluIFBSSU1BUlkgS0VZIGFuZCBVTklRVUUgY29uc3RyYWludHMAanNvbl9vYmplY3QoKSByZXF1aXJlcyBhbiBldmVuIG51bWJlciBvZiBhcmd1bWVudHMAanNvbl8lcygpIG5lZWRzIGFuIG9kZCBudW1iZXIgb2YgYXJndW1lbnRzACVzX3NlZ21lbnRzAHVuYWJsZSB0byBkZWxldGUvbW9kaWZ5IHVzZXItZnVuY3Rpb24gZHVlIHRvIGFjdGl2ZSBzdGF0ZW1lbnRzAHVuYWJsZSB0byBkZWxldGUvbW9kaWZ5IGNvbGxhdGlvbiBzZXF1ZW5jZSBkdWUgdG8gYWN0aXZlIHN0YXRlbWVudHMAb2Zmc2V0cwByZXZlcnNlX3Vub3JkZXJlZF9zZWxlY3RzAGlpc3Nzc3NzAGlzcwBzZXNzAHVuY29tcHJlc3MAY2Fubm90IG9wZW4gc2F2ZXBvaW50IC0gU1FMIHN0YXRlbWVudHMgaW4gcHJvZ3Jlc3MAY2Fubm90IHJlbGVhc2Ugc2F2ZXBvaW50IC0gU1FMIHN0YXRlbWVudHMgaW4gcHJvZ3Jlc3MAY2Fubm90IGNvbW1pdCB0cmFuc2FjdGlvbiAtIFNRTCBzdGF0ZW1lbnRzIGluIHByb2dyZXNzAGNhbm5vdCBWQUNVVU0gLSBTUUwgc3RhdGVtZW50cyBpbiBwcm9ncmVzcwBhY2Nlc3MAcGFyYW1ldGVycwByZWN1cnNpdmVfdHJpZ2dlcnMAdGhlIElOREVYRUQgQlkgY2xhdXNlIGlzIG5vdCBhbGxvd2VkIG9uIFVQREFURSBvciBERUxFVEUgc3RhdGVtZW50cyB3aXRoaW4gdHJpZ2dlcnMAdGhlIE5PVCBJTkRFWEVEIGNsYXVzZSBpcyBub3QgYWxsb3dlZCBvbiBVUERBVEUgb3IgREVMRVRFIHN0YXRlbWVudHMgd2l0aGluIHRyaWdnZXJzAHF1YWxpZmllZCB0YWJsZSBuYW1lcyBhcmUgbm90IGFsbG93ZWQgb24gSU5TRVJULCBVUERBVEUsIGFuZCBERUxFVEUgc3RhdGVtZW50cyB3aXRoaW4gdHJpZ2dlcnMAQ2hpbGQgcGFnZSBkZXB0aCBkaWZmZXJzAHVuYWJsZSB0byBjbG9zZSBkdWUgdG8gdW5maW5hbGl6ZWQgc3RhdGVtZW50cyBvciB1bmZpbmlzaGVkIGJhY2t1cHMAYWNvcwBJZlBvcwBjb21waWxlX29wdGlvbnMARElTVElOQ1QgaXMgbm90IHN1cHBvcnRlZCBmb3Igd2luZG93IGZ1bmN0aW9ucwBGSUxURVIgY2xhdXNlIG1heSBvbmx5IGJlIHVzZWQgd2l0aCBhZ2dyZWdhdGUgd2luZG93IGZ1bmN0aW9ucwBub24tZGV0ZXJtaW5pc3RpYyBmdW5jdGlvbnMAaW5kZXggZXhwcmVzc2lvbnMAU0VMRUNUcyB0byB0aGUgbGVmdCBhbmQgcmlnaHQgb2YgJXMgZG8gbm90IGhhdmUgdGhlIHNhbWUgbnVtYmVyIG9mIHJlc3VsdCBjb2x1bW5zAHZpcnR1YWwgdGFibGVzIGNhbm5vdCB1c2UgY29tcHV0ZWQgY29sdW1ucwBnZW5lcmF0ZWQgY29sdW1ucwB0YWJsZSAlcyBoYXMgJWQgdmFsdWVzIGZvciAlZCBjb2x1bW5zAHJhZGlhbnMAYWxsIFZBTFVFUyBtdXN0IGhhdmUgdGhlIHNhbWUgbnVtYmVyIG9mIHRlcm1zAGVtcHR5X3Jlc3VsdF9jYWxsYmFja3MATG9hZEFuYWx5c2lzAGZsZ3MAZmxhZ3MAdmZzACVkIGNvbHVtbnMgYXNzaWduZWQgJWQgdmFsdWVzAEpTT04gY2Fubm90IGhvbGQgQkxPQiB2YWx1ZXMAZmFpbGVkIG1lbW9yeSByZXNpemUgJXUgdG8gJXUgYnl0ZXMAcGFydGlhbCBpbmRleCBXSEVSRSBjbGF1c2VzAHNob3J0X2NvbHVtbl9uYW1lcwBmdWxsX2NvbHVtbl9uYW1lcwB1bmFibGUgdG8gb3BlbiBhIHRlbXBvcmFyeSBkYXRhYmFzZSBmaWxlIGZvciBzdG9yaW5nIHRlbXBvcmFyeSB0YWJsZXMAY2Fubm90IGNyZWF0ZSB0cmlnZ2VycyBvbiBzaGFkb3cgdGFibGVzAGNhbm5vdCBjcmVhdGUgdHJpZ2dlcnMgb24gdmlydHVhbCB0YWJsZXMAJXMgUkVUVVJOSU5HIGlzIG5vdCBhdmFpbGFibGUgb24gdmlydHVhbCB0YWJsZXMAY2Fubm90IGpvaW4gdXNpbmcgY29sdW1uICVzIC0gY29sdW1uIG5vdCBwcmVzZW50IGluIGJvdGggdGFibGVzAEFVVE9JTkNSRU1FTlQgbm90IGFsbG93ZWQgb24gV0lUSE9VVCBST1dJRCB0YWJsZXMAJXMgY2Fubm90IHVzZSB2YXJpYWJsZXMAdG9vIG1hbnkgU1FMIHZhcmlhYmxlcwBzdWJxdWVyaWVzAGNhbm5vdCB1c2Ugd2luZG93IGZ1bmN0aW9ucyBpbiByZWN1cnNpdmUgcXVlcmllcwBjb3VudF9jaGFuZ2VzAHRvdGFsX2NoYW5nZXMAZGVncmVlcwBSRVRVUk5JTkcgbWF5IG5vdCB1c2UgIlRBQkxFLioiIHdpbGRjYXJkcwB0aHJlYWRzAGFicwAuJS4qcwBDUkVBVEUgJXMgJS4qcwBDUkVBVEUlcyBJTkRFWCAlLipzAGludmFsaWQgdXJpIGF1dGhvcml0eTogJS4qcwB1bmtub3duIHRhYmxlIG9wdGlvbjogJS4qcwAlLipzJXMALCVzJXMlcwBTQ0FOICVzJXMlcwBzcWxpdGVfYWx0ZXJ0YWJfJXMAU0NBTiAlZCBDT05TVEFOVCBST1clcwAlUSVzADB4JXg6JXMAJWQ6JXMAJXM6ICVzLiVzLiVzAG1pc3NpbmcgZGF0YXR5cGUgZm9yICVzLiVzAGNhbm5vdCBzdG9yZSAlcyB2YWx1ZSBpbiAlcyBjb2x1bW4gJXMuJXMAbm9uLSVzIHZhbHVlIGluICVzLiVzAFRFWFQgdmFsdWUgaW4gJXMuJXMATlVMTCB2YWx1ZSBpbiAlcy4lcwBOVU1FUklDIHZhbHVlIGluICVzLiVzAG1hbGZvcm1lZCBpbnZlcnRlZCBpbmRleCBmb3IgRlRTJWQgdGFibGUgJXMuJXMAJXM6ICVzLiVzAG5vIHN1Y2ggdGFibGUgY29sdW1uOiAlcy4lcwAuLiVzACUuMThzLSVzAHN1YnJ0bnNpZzolZCwlcwAgVVNJTkcgSU5URUdFUiBQUklNQVJZIEtFWSAoJXMAdXNlIERST1AgVklFVyB0byBkZWxldGUgdmlldyAlcwByb3cgbm90IGluIFBSSU1BUlkgS0VZIG9yZGVyIGZvciAlcwBpbGxlZ2FsIGZpcnN0IGFyZ3VtZW50IHRvICVzAG1pc3VzZSBvZiBhbGlhc2VkIHdpbmRvdyBmdW5jdGlvbiAlcwB0b28gbWFueSBjb2x1bW5zIG9uICVzAHRvbyBtYW55IGNvbHVtbnMgaW4gJXMAJXMgcHJvaGliaXRlZCBpbiAlcwBDSEVDSyBjb25zdHJhaW50IGZhaWxlZCBpbiAlcwBub24tZGV0ZXJtaW5pc3RpYyB1c2Ugb2YgJXMoKSBpbiAlcwByZWNvdmVyZWQgJWQgcGFnZXMgZnJvbSAlcwBtaXN1c2Ugb2YgYWxpYXNlZCBhZ2dyZWdhdGUgJXMAJXMgJVQgY2Fubm90IHJlZmVyZW5jZSBvYmplY3RzIGluIGRhdGFiYXNlICVzAGNhbm5vdCBkZXRhY2ggZGF0YWJhc2UgJXMAYSBKT0lOIGNsYXVzZSBpcyByZXF1aXJlZCBiZWZvcmUgJXMAY2Fubm90IG9wZW4gdmFsdWUgb2YgdHlwZSAlcwBjYW5ub3QgZnN0YXQgZGIgZmlsZSAlcwByZWNvdmVyZWQgJWQgZnJhbWVzIGZyb20gV0FMIGZpbGUgJXMAUFJJTUFSWSBLRVkgbWlzc2luZyBvbiB0YWJsZSAlcwB1c2UgRFJPUCBUQUJMRSB0byBkZWxldGUgdGFibGUgJXMAU0VMRUNUICVzIE9SREVSIEJZIHJvd2lkICVzAFNFTEVDVCAlcyBXSEVSRSByb3dpZCBCRVRXRUVOICVsbGQgQU5EICVsbGQgT1JERVIgQlkgcm93aWQgJXMAdGhlcmUgaXMgYWxyZWFkeSBhbiBpbmRleCBuYW1lZCAlcwB0YWJsZSAlUyBoYXMgbm8gY29sdW1uIG5hbWVkICVzAHRoZXJlIGlzIGFscmVhZHkgYSB0YWJsZSBuYW1lZCAlcwBzdGF0ZW1lbnQgYWJvcnRzIGF0ICVkOiBbJXNdICVzAENPVkVSSU5HIElOREVYICVzAFNFTEVDVCAlcwB1bnN1cHBvcnRlZCB1c2Ugb2YgTlVMTFMgJXMAQVRUQUNIICVRIEFTICVzAFVTRSBURU1QIEItVFJFRSBGT1IgJXMALS0gVFJJR0dFUiAlcwBSSUdIVC1KT0lOICVzAD4/IEFORCAlcwAlejogJXMAcmVjdXJzaXZlIHJlZmVyZW5jZSBpbiBhIHN1YnF1ZXJ5OiAlcwB2dGFibGUgY29uc3RydWN0b3IgY2FsbGVkIHJlY3Vyc2l2ZWx5OiAlcwBubyBzdWNoIGluZGV4OiAlcwBubyBzdWNoIHdpbmRvdzogJXMAY2Fubm90IG92ZXJyaWRlICVzIG9mIHdpbmRvdzogJXMAY2Fubm90IG9wZW4gdmlldzogJXMAbm8gc3VjaCBzYXZlcG9pbnQ6ICVzAGNhbm5vdCBvcGVuIHRhYmxlIHdpdGggZ2VuZXJhdGVkIGNvbHVtbnM6ICVzAG5vIHN1Y2ggdmZzOiAlcwBtdWx0aXBsZSByZWN1cnNpdmUgcmVmZXJlbmNlczogJXMAZXJyb3IgaW4gJXMgJXMlcyVzOiAlcwB1bmFibGUgdG8gdmFsaWRhdGUgdGhlIGludmVydGVkIGluZGV4IGZvciBGVFMlZCB0YWJsZSAlcy4lczogJXMAZXJyb3IgaW4gJXMgJXMgYWZ0ZXIgJXM6ICVzAHVua25vd24gdG9rZW5pemVyOiAlcwBlcnJvciBwYXJzaW5nIHByZWZpeCBwYXJhbWV0ZXI6ICVzAHVucmVjb2duaXplZCBwYXJhbWV0ZXI6ICVzAHVucmVjb2duaXplZCBvcmRlcjogJXMAdW5yZWNvZ25pemVkIG1hdGNoaW5mbzogJXMAbm8gc3VjaCBjb2x1bW46ICVzAGZpbGUgcmVuYW1lZCB3aGlsZSBvcGVuOiAlcwBmaWxlIHVubGlua2VkIHdoaWxlIG9wZW46ICVzAHVuc3VwcG9ydGVkIGVuY29kaW5nOiAlcwBjYW5ub3QgbGltaXQgV0FMIHNpemU6ICVzAE1KIGRlbGV0ZTogJXMAdGFyZ2V0IG9iamVjdC9hbGlhcyBtYXkgbm90IGFwcGVhciBpbiBGUk9NIGNsYXVzZTogJXMAb2JqZWN0IG5hbWUgcmVzZXJ2ZWQgZm9yIGludGVybmFsIHVzZTogJXMAdW5rbm93biBkYXRhYmFzZTogJXMAdW5hYmxlIHRvIG9wZW4gZGF0YWJhc2U6ICVzAG5vIHN1Y2ggZGF0YWJhc2U6ICVzAHRoZXJlIGlzIGFscmVhZHkgYW5vdGhlciB0YWJsZSBvciBpbmRleCB3aXRoIHRoaXMgbmFtZTogJXMAZHVwbGljYXRlIGNvbHVtbiBuYW1lOiAlcwBkdXBsaWNhdGUgV0lUSCB0YWJsZSBuYW1lOiAlcwBubyBzdWNoIG1vZHVsZTogJXMAbXVsdGlwbGUgbGlua3MgdG8gZmlsZTogJXMAY2Fubm90IG9wZW4gdmlydHVhbCB0YWJsZTogJXMAbm8gc3VjaCB0YWJsZTogJXMAbXVsdGlwbGUgcmVmZXJlbmNlcyB0byByZWN1cnNpdmUgdGFibGU6ICVzAG5vIHN1Y2ggJXMgbW9kZTogJXMATUogY29sbGlkZTogJXMAbm8gc3VjaCBjb2xsYXRpb24gc2VxdWVuY2U6ICVzAGNpcmN1bGFyIHJlZmVyZW5jZTogJXMAY2Fubm90IG9wZW4gdGFibGUgd2l0aG91dCByb3dpZDogJXMAJXMgbW9kZSBub3QgYWxsb3dlZDogJXMAdnRhYmxlIGNvbnN0cnVjdG9yIGZhaWxlZDogJXMAYXV0b21hdGljIGV4dGVuc2lvbiBsb2FkaW5nIGZhaWxlZDogJXMAZGF0YWJhc2UgdGFibGUgaXMgbG9ja2VkOiAlcwBkYXRhYmFzZSBzY2hlbWEgaXMgbG9ja2VkOiAlcwB2dGFibGUgY29uc3RydWN0b3IgZGlkIG5vdCBkZWNsYXJlIHNjaGVtYTogJXMAYWJvcnQgYXQgJWQgaW4gWyVzXTogJXMALS0gJXMAJXogLSAlcwBvc191bml4LmM6JWQ6ICglZCkgJXMoJXMpIC0gJXMAd3IAcmlnaHRzdHIAbGVmdHN0cgBpbnN0cgBzdWJzdHIAZXhwcl9pbXBsaWVzX2V4cHIAaW52YWxpZCBhcmd1bWVudHMgdG8gZnRzNGF1eCBjb25zdHJ1Y3RvcgBtaXNzaW5nICVzIHBhcmFtZXRlciBpbiBmdHM0IGNvbnN0cnVjdG9yAHRoZSAiLiIgb3BlcmF0b3IAZnRzM2N1cnNvcgBuZWFyICIlVCI6IHN5bnRheCBlcnJvcgBpbnRlcm5hbCBxdWVyeSBwbGFubmVyIGVycm9yAHVua25vd24gZXJyb3IAZG9tYWluIGVycm9yAG5vdCBhbiBlcnJvcgBTUUwgbG9naWMgZXJyb3IAZGlzayBJL08gZXJyb3IAZmxvb3IAcm1kaXIAbWtkaXIAc2VnZGlyAGZ0czNfdG9rZW5pemVyAHVua25vd24gdG9rZW5pemVyAHBvd2VyAGxvd2VyAHNxbGl0ZV90ZW1wX21hc3RlcgBzcWxpdGVfbWFzdGVyAHBvcnRlcgBSZXNldFNvcnRlcgBGa0NvdW50ZXIAQVBJIGNhbGwgd2l0aCAlcyBkYXRhYmFzZSBjb25uZWN0aW9uIHBvaW50ZXIAc3RyZmlsdGVyAFZGaWx0ZXIARVNDQVBFIGV4cHJlc3Npb24gbXVzdCBiZSBhIHNpbmdsZSBjaGFyYWN0ZXIAdXBwZXIAcHJvcGVyAGNhbm5vdCB1c2UgUkVUVVJOSU5HIGluIGEgdHJpZ2dlcgBEcm9wVHJpZ2dlcgBzZWNvbmQgYXJndW1lbnQgdG8gbnRoX3ZhbHVlIG11c3QgYmUgYSBwb3NpdGl2ZSBpbnRlZ2VyAGFyZ3VtZW50IG9mIG50aWxlIG11c3QgYmUgYSBwb3NpdGl2ZSBpbnRlZ2VyAGZyYW1lIHN0YXJ0aW5nIG9mZnNldCBtdXN0IGJlIGEgbm9uLW5lZ2F0aXZlIGludGVnZXIAZnJhbWUgZW5kaW5nIG9mZnNldCBtdXN0IGJlIGEgbm9uLW5lZ2F0aXZlIGludGVnZXIASW50ZWdlcgBSb3dpZCAlbGxkIG91dCBvZiBvcmRlcgBSZW1haW5kZXIAZnJhbWUgc3RhcnRpbmcgb2Zmc2V0IG11c3QgYmUgYSBub24tbmVnYXRpdmUgbnVtYmVyAGZyYW1lIGVuZGluZyBvZmZzZXQgbXVzdCBiZSBhIG5vbi1uZWdhdGl2ZSBudW1iZXIAYWRkcgBwYWRyAGNoYXIAeWVhcgBDbGVhcgBCaXRPcgBzZXEAQ29sbFNlcQBFbHNlRXEAcmVnZXhwAE9wZW5EdXAATm9vcABKdW1wAC91c3IvdG1wAC92YXIvdG1wAHRlbXAAY3VycmVudF90aW1lc3RhbXAAQWdnU3RlcABtb2RlU3RlcAB2YXJpYW5jZVN0ZXAAbXVubWFwAG1tYXAAbXJlbWFwAHNxbGl0ZV9yZXR1cm5pbmdfJXAAdnRhYjolcABzc2Vuc3VvAGlsc3VvAGF1dG8AR290bwBpbnRvAGluY3JlbWVudGFsX3ZhY3V1bSBlbmFibGVkIHdpdGggYSBtYXggcm9vdHBhZ2Ugb2YgemVybwBJZk5vdFplcm8ARGVjckp1bXBaZXJvAEZrSWZaZXJvAHNlcW5vAGluZGV4X3hpbmZvAHRhYmxlX3hpbmZvAG1hdGNoaW5mbwBpbmRleF9pbmZvAHRhYmxlX2luZm8AT3BlblBzZXVkbwBmY2hvd24AQmVnaW5TdWJydG4AUmV0dXJuAGpzb24Abm8gcXVlcnkgc29sdXRpb24AaW5kZXggY29ycnVwdGlvbgBkYXRhYmFzZSBjb3JydXB0aW9uAGZyZWUgc3BhY2UgY29ycnVwdGlvbgBqc29uX2Vycm9yX3Bvc2l0aW9uAHVua25vd24gY29sdW1uICIlcyIgaW4gZm9yZWlnbiBrZXkgZGVmaW5pdGlvbgAlcy54QmVzdEluZGV4IG1hbGZ1bmN0aW9uAGF1dGhvcml6ZXIgbWFsZnVuY3Rpb24AJSNUKCkgbWF5IG5vdCBiZSB1c2VkIGFzIGEgd2luZG93IGZ1bmN0aW9uACclcycgaXMgbm90IGEgZnVuY3Rpb24ARnVuY3Rpb24AY2Fubm90IHN0YXJ0IGEgdHJhbnNhY3Rpb24gd2l0aGluIGEgdHJhbnNhY3Rpb24AY2Fubm90IGNoYW5nZSAlcyB3YWwgbW9kZSBmcm9tIHdpdGhpbiBhIHRyYW5zYWN0aW9uAHRlbXBvcmFyeSBzdG9yYWdlIGNhbm5vdCBiZSBjaGFuZ2VkIGZyb20gd2l0aGluIGEgdHJhbnNhY3Rpb24AY2Fubm90IFZBQ1VVTSBmcm9tIHdpdGhpbiBhIHRyYW5zYWN0aW9uAFNhZmV0eSBsZXZlbCBtYXkgbm90IGJlIGNoYW5nZWQgaW5zaWRlIGEgdHJhbnNhY3Rpb24AVHJhbnNhY3Rpb24AUGVybXV0YXRpb24AdW5rbm93biBvcGVyYXRpb24AdW5zdXBwb3J0ZWQgZnJhbWUgc3BlY2lmaWNhdGlvbgBSQU5HRSB3aXRoIG9mZnNldCBQUkVDRURJTkcvRk9MTE9XSU5HIHJlcXVpcmVzIG9uZSBPUkRFUiBCWSBleHByZXNzaW9uAHRvbyBtYW55IGxldmVscyBvZiB0cmlnZ2VyIHJlY3Vyc2lvbgB1c2VyX3ZlcnNpb24Ac3FsaXRlX3ZlcnNpb24AZGF0YV92ZXJzaW9uAHNjaGVtYV92ZXJzaW9uAHNxbGl0ZV9kcm9wX2NvbHVtbgBzcWxpdGVfcmVuYW1lX2NvbHVtbgBhZnRlciBkcm9wIGNvbHVtbgBubyBzdWNoIGNvbHVtbgBtdXN0IGhhdmUgYXQgbGVhc3Qgb25lIG5vbi1nZW5lcmF0ZWQgY29sdW1uAGNhbm5vdCB1c2UgREVGQVVMVCBvbiBhIGdlbmVyYXRlZCBjb2x1bW4AYWRkIGNvbHVtbgBDYW5ub3QgYWRkIGEgUFJJTUFSWSBLRVkgY29sdW1uAENhbm5vdCBhZGQgYSBVTklRVUUgY29sdW1uAGNhbm5vdCBhZGQgYSBTVE9SRUQgY29sdW1uAFZDb2x1bW4AYnVpbHRpbgBhc2luAGF0IG1vc3QgJWQgdGFibGVzIGluIGEgam9pbgBtaW4Ab3JpZ2luAFZCZWdpbgBtYWluAEV4cGxhaW4Ac2lnbgBzc2VuAG9wZW4ASWZOb3RPcGVuAFNvcnRlck9wZW4AVk9wZW4ASWZTaXplQmV0d2VlbgBoaWRkZW4AYXRhbgBtZWRpYW4AU2Vla1NjYW4AVkluaXRJbgBhdXRvX3ZhY3V1bQBpbmNyZW1lbnRhbF92YWN1dW0ASW5jclZhY3V1bQBzdW0AZmxleG51bQBwbQBkcm9wIGNvbHVtbiBmcm9tAC9kZXYvdXJhbmRvbQBBZGRJbW0AcnRyaW0AbHRyaW0AcmVhZG9ubHlfc2htACVzLXNobQB0bmVtAFJBSVNFKCkgbWF5IG9ubHkgYmUgdXNlZCB3aXRoaW4gYSB0cmlnZ2VyLXByb2dyYW0AUHJvZ3JhbQBQYXJhbQBmdWwAZmNudGwAaW9jdGwAaWdvbABsb2NraW5nIHByb3RvY29sAG5jb2wAbm90bnVsbABpZm51bGwAL2Rldi9udWxsAGRhdGFiYXNlIG9yIGRpc2sgaXMgZnVsbABOb3ROdWxsAFNvZnROdWxsAElzTnVsbABaZXJvT3JOdWxsAEhhbHRJZk51bGwAY29sbABjYWNoZV9zcGlsbABSb3dDZWxsAGNlaWwAZGV0YWlsAHBhZGwAdW5peC1leGNsAHRibAB3YWwAdmlydHVhbAB0b3RhbABpbmNyZW1lbnRhbABPcGVuRXBoZW1lcmFsAEFnZ0ZpbmFsAG5vcm1hbABJbmRleCBhbHJlYWR5IG9wdGltYWwAcGFydGlhbAByZWFsAFJlYWwAcGsAb2sAdW5saW5rAHJlYWRsaW5rAEZpbmlzaFNlZWsARGVmZXJyZWRTZWVrAG5vbG9jawBDdXJzb3JVbmxvY2sAYmxvY2sAJXMubG9jawBDdXJzb3JMb2NrAFRhYmxlTG9jawBpbnRlZ3JpdHlfY2hlY2sAZm9yZWlnbl9rZXlfY2hlY2sAcXVpY2tfY2hlY2sAY2VsbF9zaXplX2NoZWNrAGludGVncml0eS1jaGVjawBGa0NoZWNrAFR5cGVDaGVjawBWQ2hlY2sASW50ZWdyaXR5Q2sAcmV6aQBub2l0YXppAGl0aXZpAHNzZW5ldmkAaXRpAGlzc2lzaQBpc2lzaQBwaQBub2kAZ25pAHNpc3NpaQBpc3Npc2lpAHNzc2lpaQBzZWkAaXRpY2kAZXRhY2kAbGFjaQBjb3RoAG1vbnRoAGpzb25fYXJyYXlfbGVuZ3RoAG9jdGV0X2xlbmd0aABvdmVyZmxvdyBsaXN0IGxlbmd0aAB3ZHRoAHN0YXRfcHVzaABmbHVzaABhY29zaABhc2luaABhdGFuaABqc29uX3BhdGNoAGpzb25iX3BhdGNoAGRhdGF0eXBlIG1pc21hdGNoAGFyZ3VtZW50IHR5cGUgbWlzbWF0Y2gAYWJicmV2aWF0ZWQgcXVlcnkgYWxnb3JpdGhtIHNlYXJjaAB1bml4ZXBvY2gAc3FsaXRlX2F0dGFjaABzcWxpdGVfZGV0YWNoAGpzb25fZWFjaABhdmcAbmFyZwBzcWxpdGVfbG9nAHN0YXRlbWVudCB0b28gbG9uZwBjYW5ub3Qgb3BlbiAlcyBjb2x1bW4gZm9yIHdyaXRpbmcAc3Vic3RyaW5nAFN0cmluZwBjZWlsaW5nAGVuY29kaW5nAHN0cmluZyBvciBibG9iIHRvbyBiaWcAc3RyaW5nX2FnZwBSZWxlYXNlUmVnACUuMTZnACUhMC4xNWcAJSEuMTVnAHNzZW5sdWYAcHJpbnRmAHR5cGVvZgBtb2Rlb2YAb3V0IG9mAHJlbmFtZSBjb2x1bW5zIG9mAGluZgAtSW5mAG51bGxpZgBpaWYAb2ZmAHRpbWVkaWZmADAxMjM0NTY3ODlhYmNkZWYASWYAJWMlMDRkLSUwMmQtJTAyZCAlMDJkOiUwMmQ6JTA2LjNmACUuM2YANTBmADQwZgAlIS4qZgBnZXRwYWdlc2l6ZQBkb2NzaXplAG1tYXBfc2l6ZQBkZWZhdWx0X2NhY2hlX3NpemUAUFJBR01BICVRLnBhZ2Vfc2l6ZQBmdHMzdG9rZW5pemUAb3B0aW1pemUAanNvbl9yZW1vdmUAanNvbmJfcmVtb3ZlAE1vdmUAY2Fubm90IGNvbW1pdCAtIG5vIHRyYW5zYWN0aW9uIGlzIGFjdGl2ZQBjYW5ub3Qgcm9sbGJhY2sgLSBubyB0cmFuc2FjdGlvbiBpcyBhY3RpdmUAZXhjbHVzaXZlAHRydWUASXNUcnVlAHVuaXF1ZQBkZmx0X3ZhbHVlAENhbm5vdCBhZGQgYSBSRUZFUkVOQ0VTIGNvbHVtbiB3aXRoIG5vbi1OVUxMIGRlZmF1bHQgdmFsdWUAQWdnVmFsdWUAanNvbl9xdW90ZQBwd3JpdGUAT3BlbldyaXRlAG9uX2RlbGV0ZQBzZWN1cmVfZGVsZXRlAElkeERlbGV0ZQBwcml2YXRlAGFnZ3JlZ2F0ZQBWQ3JlYXRlAG9uX3VwZGF0ZQBWVXBkYXRlAGN1cnJlbnRfZGF0ZQBmYWxsb2NhdGUAZnRydW5jYXRlAHJlcGxpY2F0ZQBiYWQgcGFyYW1ldGVyIG9yIG90aGVyIEFQSSBtaXN1c2UAdG9vIG1hbnkgdGVybXMgaW4gJXMgQlkgY2xhdXNlAHRvbyBtYW55IHRlcm1zIGluIE9SREVSIEJZIGNsYXVzZQBhZ2dyZWdhdGUgZnVuY3Rpb25zIGFyZSBub3QgYWxsb3dlZCBpbiB0aGUgR1JPVVAgQlkgY2xhdXNlAFBBUlRJVElPTiBjbGF1c2UAYSBOQVRVUkFMIGpvaW4gbWF5IG5vdCBoYXZlIGFuIE9OIG9yIFVTSU5HIGNsYXVzZQBkYXRhYmFzZSAlcyBpcyBhbHJlYWR5IGluIHVzZQBBZ2dJbnZlcnNlAHJldmVyc2UAY2xvc2UAQ2xvc2UAZmFsc2UAYXR0ZW1wdCB0byB3cml0ZSBhIHJlYWRvbmx5IGRhdGFiYXNlAGNvcnJ1cHQgZGF0YWJhc2UAYXR0YWNoZWQgZGF0YWJhc2VzIG11c3QgdXNlIHRoZSBzYW1lIHRleHQgZW5jb2RpbmcgYXMgbWFpbiBkYXRhYmFzZQBmaWxlIGlzIG5vdCBhIGRhdGFiYXNlAHRlbXBfc3RvcmUAJXMgY2xhdXNlIHNob3VsZCBjb21lIGFmdGVyICVzIG5vdCBiZWZvcmUARXhwaXJlAHNxdWFyZQBleHByX2NvbXBhcmUAU29ydGVyQ29tcGFyZQBzdWJ0eXBlAFNldFN1YnR5cGUAR2V0U3VidHlwZQBDbHJTdWJ0eXBlAGpzb25fdHlwZQBJc1R5cGUASWZOb0hvcGUAaWx0bmUAdW5peC1ub25lAEluaXRDb3JvdXRpbmUARW5kQ29yb3V0aW5lAGljbmUAbG9jYWx0aW1lAHN0cmZ0aW1lAGRhdGV0aW1lAGN1cnJlbnRfdGltZQB0bmVtZQBhZnRlciByZW5hbWUAbm9uLXRleHQgZmlsZW5hbWUAVlJlbmFtZQBhbWJpZ3VvdXMgY29sdW1uIG5hbWUAdGVtcG9yYXJ5IHRyaWdnZXIgbWF5IG5vdCBoYXZlIHF1YWxpZmllZCBuYW1lAHNpbXBsZQBsb3dlcl9xdWFydGlsZQB1cHBlcl9xdWFydGlsZQB1bml4LWRvdGZpbGUAY2Fubm90IG9wZW4gZmlsZQB1bmFibGUgdG8gb3BlbiBkYXRhYmFzZSBmaWxlAGltbXV0YWJsZQBBYm9ydGFibGUAbGVnYWN5X2FsdGVyX3RhYmxlAHNxbGl0ZV9yZW5hbWVfdGFibGUAY2Fubm90IGNyZWF0ZSB0cmlnZ2VyIG9uIHN5c3RlbSB0YWJsZQB2aXJ0dWFsIHRhYmxlAG5vIHN1Y2ggdGFibGUAbnVtYmVyIG9mIGNvbHVtbnMgaW4gZm9yZWlnbiBrZXkgZG9lcyBub3QgbWF0Y2ggdGhlIG51bWJlciBvZiBjb2x1bW5zIGluIHRoZSByZWZlcmVuY2VkIHRhYmxlAGxvY2FsIHRpbWUgdW5hdmFpbGFibGUAYW5vdGhlciByb3cgYXZhaWxhYmxlAG5vIG1vcmUgcm93cyBhdmFpbGFibGUAVmFyaWFibGUARHJvcFRhYmxlAHV0ZjE2bGUAVVRGMTZsZQBVVEYtMTZsZQBjYXNlX3NlbnNpdGl2ZV9saWtlAFNldENvb2tpZQBSZWFkQ29va2llAGNhY2hlAGNvbHVtbiBpbmRleCBvdXQgb2YgcmFuZ2UAbm90aWZpY2F0aW9uIG1lc3NhZ2UAd2FybmluZyBtZXNzYWdlAGludmFsaWQgcm9vdHBhZ2UARXh0ZW5kcyBvZmYgZW5kIG9mIHBhZ2UATUFYX1BBR0VfQ09VTlQ9MHhmZmZmZmZmZQBqc29uX3RyZWUAQ3JlYXRlQnRyZWUAZGVlAGpvdXJuYWxfbW9kZQBsb2NraW5nX21vZGUAb3Bjb2RlAHVuaWNvZGUASm91cm5hbE1vZGUARGl2aWRlAGNvYWxlc2NlAHNxbGl0ZV9zZXF1ZW5jZQBTZXF1ZW5jZQBkaWZmZXJlbmNlAHZhcmlhbmNlAE9uY2UAVHJhY2UAanNvbl9yZXBsYWNlAGpzb25iX3JlcGxhY2UAdXRmMTZiZQBVVEYxNmJlAFVURi0xNmJlAE5lAExlAEdlADIwYzoyMGUAMjBiOjIwZQAlITAuMjBlAGdldGN3ZABNYWtlUmVjb3JkAHRoc3RuZHJkAGxpa2VsaWhvb2QAZmNobW9kAHJvdW5kAE5vdEZvdW5kAHN1YnNlY29uZABSZXdpbmQAU2Vla0VuZABCaXRBbmQAb2xkACVsbGQgJWxsZABubyBzdWNoIHJvd2lkOiAlbGxkAHJlYnVpbGQAWWllbGQAbGFzdF9pbnNlcnRfcm93aWQAJXMucm93aWQAU0VMRUNUKkZST00iJXciLiVzIE9SREVSIEJZIHJvd2lkAFNFTEVDVCpGUk9NIiV3Ii4lcyBXSEVSRSAlcyBPUkRFUiBCWSByb3dpZABJZHhSb3dpZABOZXdSb3dpZABTZWVrUm93aWQAZ2V0ZXVpZABpbnZhbGlkAGpzb25fdmFsaWQAZmtpZABfX2xhbmdpZAAleiwgbGFuZ2lkAGxhbmd1YWdlaWQAZG9jaWQAYXBwbGljYXRpb25faWQAc3FsaXRlX3NvdXJjZV9pZABub3QgYXV0aG9yaXplZABJbmRleCBvcHRpbWl6ZWQAbm90aW5kZXhlZAB1bmFibGUgdG8gaWRlbnRpZnkgdGhlIG9iamVjdCB0byBiZSByZWluZGV4ZWQAdmlld3MgbWF5IG5vdCBiZSBpbmRleGVkAHZpcnR1YWwgdGFibGVzIG1heSBub3QgYmUgaW5kZXhlZAB0YWJsZSAlcyBtYXkgbm90IGJlIGluZGV4ZWQAcmVhZF91bmNvbW1pdHRlZAByZWN1cnNpdmUgYWdncmVnYXRlIHF1ZXJpZXMgbm90IHN1cHBvcnRlZABxdWVyeSBhYm9ydGVkAHJvd3MgaW5zZXJ0ZWQAaW50ZXJydXB0ZWQAY2hlY2twb2ludGVkAGFjY2VzcyB0byAleiBpcyBwcm9oaWJpdGVkAGFjY2VzcyB0byB2aWV3ICIlcyIgcHJvaGliaXRlZAByb3dzIGRlbGV0ZWQAZ2VuZXJhdGVkAHJvd3MgdXBkYXRlZABub3R1c2VkAHJvdyB2YWx1ZSBtaXN1c2VkAHNxbGl0ZV9jb21waWxlb3B0aW9uX3VzZWQAUGFnZSAldTogbmV2ZXIgdXNlZABDb2x1bW5zVXNlZABzdG9yZWQAdmlydHVhbCB0YWJsZXMgbWF5IG5vdCBiZSBhbHRlcmVkAHZpZXcgJXMgbWF5IG5vdCBiZSBhbHRlcmVkAHRhYmxlICVzIG1heSBub3QgYmUgYWx0ZXJlZABzaGFyZWQAaW5kZXggYXNzb2NpYXRlZCB3aXRoIFVOSVFVRSBvciBQUklNQVJZIEtFWSBjb25zdHJhaW50IGNhbm5vdCBiZSBkcm9wcGVkAHRhYmxlICVzIG1heSBub3QgYmUgZHJvcHBlZAB2aWV3ICVzIGlzIGNpcmN1bGFybHkgZGVmaW5lZAB1bm9wZW5lZABkYXRhYmFzZSBkaXNrIGltYWdlIGlzIG1hbGZvcm1lZAAlcyBjb25zdHJhaW50IGZhaWxlZABGT1JFSUdOIEtFWSBjb25zdHJhaW50IGZhaWxlZABsYXJnZSBmaWxlIHN1cHBvcnQgaXMgZGlzYWJsZWQAZnRzM3Rva2VuaXplIGRpc2FibGVkAGRhdGFiYXNlICVzIGlzIGxvY2tlZABkYXRhYmFzZSBpcyBsb2NrZWQAZGF0YWJhc2UgdGFibGUgaXMgbG9ja2VkAGF1dGhvcml6YXRpb24gZGVuaWVkAGFjY2VzcyBwZXJtaXNzaW9uIGRlbmllZAB0YWJsZSAlUyBoYXMgJWQgY29sdW1ucyBidXQgJWQgdmFsdWVzIHdlcmUgc3VwcGxpZWQAdGVtcG9yYXJ5IHRhYmxlIG5hbWUgbXVzdCBiZSB1bnF1YWxpZmllZAB0YWJsZSAlcyBtYXkgbm90IGJlIG1vZGlmaWVkAGNvbmZsaWN0aW5nIE9OIENPTkZMSUNUIGNsYXVzZXMgc3BlY2lmaWVkAG5vIHRhYmxlcyBzcGVjaWZpZWQAZGF0YWJhc2UgaXMgYWxyZWFkeSBhdHRhY2hlZABkYXRhYmFzZSBzY2hlbWEgaGFzIGNoYW5nZWQAZXhjbHVkZWQAUGFnZSAldTogcG9pbnRlciBtYXAgcmVmZXJlbmNlZABSb3dTZXRBZGQARmlsdGVyQWRkAHByZWFkAFJvd1NldFJlYWQAT3BlblJlYWQAJTA0ZAAlMDNkACUwMmQ6JTAyZDolMDJkACUwNGQtJTAyZC0lMDJkACUyZAA0MGYtMjFhLTIxZAA1MGYtMjBhLTIwZAA0MGYtMjBhLTIwZABzcWxpdGVfc3RhdCVkAGNvbHVtbiVkAHNxbGl0ZV9hdXRvaW5kZXhfJXNfJWQAdmFyaWFibGUgbnVtYmVyIG11c3QgYmUgYmV0d2VlbiA/MSBhbmQgPyVkAHVuYWJsZSB0byBnZXQgdGhlIHBhZ2UuIGVycm9yIGNvZGU9JWQAayglZABVUERBVEUgJVEuc3FsaXRlX21hc3RlciBTRVQgcm9vdHBhZ2U9JWQgV0hFUkUgIyVkIEFORCByb290cGFnZT0jJWQAVVBEQVRFICVRLnNxbGl0ZV9tYXN0ZXIgU0VUIHR5cGU9JyVzJywgbmFtZT0lUSwgdGJsX25hbWU9JVEsIHJvb3RwYWdlPSMlZCwgc3FsPSVRIFdIRVJFIHJvd2lkPSMlZABVUERBVEUgJVEuc3FsaXRlX21hc3RlciBTRVQgdHlwZT0ndGFibGUnLCBuYW1lPSVRLCB0YmxfbmFtZT0lUSwgcm9vdHBhZ2U9MCwgc3FsPSVRIFdIRVJFIHJvd2lkPSMlZAB0b28gbWFueSBhdHRhY2hlZCBkYXRhYmFzZXMgLSBtYXggJWQAdG9vIG1hbnkgYXJndW1lbnRzIG9uICVzKCkgLSBtYXggJWQAZXhwZWN0ZWQgJWQgY29sdW1ucyBmb3IgJyVzJyBidXQgZ290ICVkAGF0dGVtcHQgdG8gb3BlbiAiJXMiIGFzIGZpbGUgZGVzY3JpcHRvciAlZABidHJlZUluaXRQYWdlKCkgcmV0dXJucyBlcnJvciBjb2RlICVkACVyICVzIEJZIHRlcm0gb3V0IG9mIHJhbmdlIC0gc2hvdWxkIGJlIGJldHdlZW4gMSBhbmQgJWQAc3ViLXNlbGVjdCByZXR1cm5zICVkIGNvbHVtbnMgLSBleHBlY3RlZCAlZABJTiguLi4pIGVsZW1lbnQgaGFzICVkIHRlcm0lcyAtIGV4cGVjdGVkICVkACVzTElTVCBTVUJRVUVSWSAlZABSRVVTRSBMSVNUIFNVQlFVRVJZICVkACVzU0NBTEFSIFNVQlFVRVJZICVkAFJFVVNFIFNVQlFVRVJZICVkAElOREVYICVkAHRvbyBtYW55IEZST00gY2xhdXNlIHRlcm1zLCBtYXg6ICVkAHJ3YwB1dGMAZGVzYwBhc2MAY2hlY2twb2ludF9mdWxsZnN5bmMAZnVsbF9mc3luYwBjaGFyaW5kZXhGdW5jAHNxcnRGdW5jAGNvdEZ1bmMAcmlnaHRGdW5jAGxlZnRGdW5jAGFjb3NGdW5jAGZsb29yRnVuYwBwb3dlckZ1bmMAc3RyZmlsdGVyRnVuYwBwcm9wZXJGdW5jAHBhZHJGdW5jAGV4cEZ1bmMAYXNpbkZ1bmMAc2lnbkZ1bmMAYXRhbkZ1bmMAY2VpbEZ1bmMAcGFkbEZ1bmMAY290aEZ1bmMAYWNvc2hGdW5jAGFzaW5oRnVuYwBhdGFuaEZ1bmMAbG9nRnVuYwByYWQyZGVnRnVuYwByZXZlcnNlRnVuYwBQdXJlRnVuYwBzcXVhcmVGdW5jAGRpZmZlcmVuY2VGdW5jAGRlZzJyYWRGdW5jAHBhZGNGdW5jAGF0bjJGdW5jAGxvZzEwRnVuYwBlbmMAbnVtZXJpYwAxPT1hcmdjAFNxbEV4ZWMAc3Vic2VjAHBhZGMAJS40YyVzJS4xNmMAc3FsaXRlLXNyYy9zcWxpdGUtYW1hbGdhbWF0aW9uLTM0OTAxMDAvZXh0ZW5zaW9uLWZ1bmN0aW9ucy5jACVzL2V0aWxxc18lbGx4JWMAdW5yZWNvZ25pemVkIG1hdGNoaW5mbyByZXF1ZXN0OiAlYwBHb3N1YgBnbG9iAHplcm9ibG9iAHJhbmRvbWJsb2IAQmxvYgBqc29uYgBpbGIAaXRpbGliAG1lbWRiAHJvdGEAZXZpdGEAbGFub2l0YQBldGEAUm93RGF0YQBTb3J0ZXJEYXRhAGljbmEAc3FsaXRlX3RlbXBfc2NoZW1hAHNxbGl0ZV9zY2hlbWEAd3JpdGFibGVfc2NoZW1hAHRydXN0ZWRfc2NoZW1hAGNvcnJ1cHQgc2NoZW1hAFBhcnNlU2NoZW1hAGlsbGEAZXppbGEAaXRpbGEAbXNpbGEAc3FsaXRlXwBwcmFnbWFfAFNRTElURV8AX1JPV0lEXwAlcyBhdCBsaW5lICVkIG9mIFslLjEwc10AYmluZCBvbiBhIGJ1c3kgcHJlcGFyZWQgc3RhdGVtZW50OiBbJXNdAG1hbGZvcm1lZCBNQVRDSCBleHByZXNzaW9uOiBbJXNdAFslbGxkXQBbXQBbAExFRlQtTU9TVCBTVUJRVUVSWQBDT01QT1VORCBRVUVSWQBBTlkAZ2VuZXJhdGVkIGNvbHVtbnMgY2Fubm90IGJlIHBhcnQgb2YgdGhlIFBSSU1BUlkgS0VZAEFVVE9JTkNSRU1FTlQgaXMgb25seSBhbGxvd2VkIG9uIGFuIElOVEVHRVIgUFJJTUFSWSBLRVkAZG9jaWQgSU5URUdFUiBQUklNQVJZIEtFWQBGT1JFSUdOIEtFWQBVU0UgVEVNUCBCLVRSRUUgRk9SICVzT1JERVIgQlkAVVNFIFRFTVAgQi1UUkVFIEZPUiBMQVNUICVkIFRFUk1TIE9GIE9SREVSIEJZAEdST1VQIEJZAGlpc1gAaXNpWABBVVRPTUFUSUMgUEFSVElBTCBDT1ZFUklORyBJTkRFWABBVVRPTUFUSUMgQ09WRVJJTkcgSU5ERVgALW1qJTA2WDklMDJYAFNDQU4gQ09OU1RBTlQgUk9XAFZJRVcAanNvbl9vYmplY3QoKSBsYWJlbHMgbXVzdCBiZSBURVhUAEZJUlNUAExBU1QARVhDRVBUAE5PVAAgSU5UAElkeExUAFNlZWtMVABTRVQgREVGQVVMVABNVVRFWF9PTUlUAENPTU1JVABMSU1JVABSSUdIVABJZHhHVABTZWVrR1QATEVGVABESVNUSU5DVABSRVNUUklDVABJTlRFUlNFQ1QAdG9vIG1hbnkgdGVybXMgaW4gY29tcG91bmQgU0VMRUNUAHVua25vd24gam9pbiB0eXBlOiAlVCVzJVQlcyVUAC0lVAB0b28gbWFueSBhcmd1bWVudHMgb24gZnVuY3Rpb24gJVQAdW5rbm93biBkYXRhYmFzZSAlVABmb3JlaWduIGtleSBvbiAlcyBzaG91bGQgcmVmZXJlbmNlIG9ubHkgb25lIGNvbHVtbiBvZiB0YWJsZSAlVABDUkVBVEUgVklSVFVBTCBUQUJMRSAlVABoZXggbGl0ZXJhbCB0b28gYmlnOiAlcyUjVABubyBzdWNoIGZ1bmN0aW9uOiAlI1QAbm90IGF1dGhvcml6ZWQgdG8gdXNlIGZ1bmN0aW9uOiAlI1QAREVGQVVMVF9SRUNVUlNJVkVfVFJJR0dFUlMARU5BQkxFX0ZUUzNfUEFSRU5USEVTSVMARElTQUJMRV9MRlMAJXMgJVMAU0NBTiAlUwBubyBzdWNoIGluZGV4OiAlUwBjYW5ub3QgY3JlYXRlICVzIHRyaWdnZXIgb24gdmlldzogJVMAbm8gc3VjaCB0cmlnZ2VyOiAlUwBjYW5ub3QgY3JlYXRlIElOU1RFQUQgT0YgdHJpZ2dlciBvbiB0YWJsZTogJVMATUFURVJJQUxJWkUgJSFTAENPLVJPVVRJTkUgJSFTAFVTSU5HIElOREVYICVzIEZPUiBJTi1PUEVSQVRPUgBVU0lORyBST1dJRCBTRUFSQ0ggT04gVEFCTEUgJXMgRk9SIElOLU9QRVJBVE9SAE1VTFRJLUlOREVYIE9SAFNRTElURV9UTVBESVIAQ1JFQVRFIEJMT09NIEZJTFRFUgBBRlRFUgBJTlRFR0VSAE9SREVSAE5FQVIAREVMRVRFIEZST00gJVEuJXMgV0hFUkUgJXM9JVEAbmFtZT0lUSBBTkQgc3FsPSVRAERFTEVURSBGUk9NICVRLnNxbGl0ZV9zZXF1ZW5jZSBXSEVSRSBuYW1lPSVRACwgeC4lUQBTRUxFQ1QgKiBGUk9NICVRLiVRAFVQREFURSAiJXciLnNxbGl0ZV9zZXF1ZW5jZSBzZXQgbmFtZSA9ICVRIFdIRVJFIG5hbWUgPSAlUQBVUERBVEUgIiV3Ii5zcWxpdGVfbWFzdGVyIFNFVCBzcWwgPSBwcmludGYoJyUlLiVkcywgJyxzcWwpIHx8ICVRIHx8IHN1YnN0cihzcWwsMStsZW5ndGgocHJpbnRmKCclJS4lZHMnLHNxbCkpKSBXSEVSRSB0eXBlID0gJ3RhYmxlJyBBTkQgbmFtZSA9ICVRAGJhZCBKU09OIHBhdGg6ICVRAFNFVFVQAEdST1VQAFJFQ1VSU0lWRSBTVEVQAFNOYU4AUU5hTgBtYWxmb3JtZWQgSlNPTgBOTyBBQ1RJT04AT01JVF9MT0FEX0VYVEVOU0lPTgBVTklPTgAgTEVGVC1KT0lOAEJFR0lOACxhcmcgSElEREVOACxzY2hlbWEgSElEREVOAFNDQU4AREVGQVVMVF9BVVRPVkFDVVVNACBOVU0AUE0AUlRSSU0AQU0AQ2Fubm90IGFkZCBhIE5PVCBOVUxMIGNvbHVtbiB3aXRoIGRlZmF1bHQgdmFsdWUgTlVMTABOT1QgTlVMTABTRVQgTlVMTABTRUxFQ1QgMSBGUk9NICVRLiclcV9zZWdtZW50cycgV0hFUkUgYmxvY2tpZD0/IEFORCBibG9jayBJUyBOVUxMAFVOSU9OIEFMTAAgUkVBTABDSEVDSwBhYm9ydCBkdWUgdG8gUk9MTEJBQ0sATUFUQ0gAU0VBUkNIAFVTSU5HAEVOQUJMRV9OT1JNQUxJWkUAIFVOSVFVRQBERUxFVEUAVVBEQVRFACV1LVJPVyBWQUxVRVMgQ0xBVVNFAFJFTEVBU0UATk9DQVNFAEJFRk9SRQBOT05FAElkeExFAFNlZWtMRQBUQUJMRQAxNkxFAElkeEdFAFNlZWtHRQAlcyBVU0lORyBURU1QIEItVFJFRQBDQVNDQURFADE2QkUAQU5EAFJPV0lEAE9JRABESVJFQ1RfT1ZFUkZMT1dfUkVBRABERVNDAFNFTEVDVCBpZHgsIHN0YXJ0X2Jsb2NrLCBsZWF2ZXNfZW5kX2Jsb2NrLCBlbmRfYmxvY2ssIHJvb3QgRlJPTSAlUS4nJXFfc2VnZGlyJyBXSEVSRSBsZXZlbCA9ID8gT1JERVIgQlkgaWR4IEFTQwBTRUxFQ1QgaWR4LCBzdGFydF9ibG9jaywgbGVhdmVzX2VuZF9ibG9jaywgZW5kX2Jsb2NrLCByb290IEZST00gJVEuJyVxX3NlZ2RpcicgV0hFUkUgbGV2ZWwgQkVUV0VFTiA/IEFORCA/T1JERVIgQlkgbGV2ZWwgREVTQywgaWR4IEFTQwBTRUxFQ1QgbGV2ZWwsIGlkeCwgZW5kX2Jsb2NrIEZST00gJVEuJyVxX3NlZ2RpcicgV0hFUkUgbGV2ZWwgQkVUV0VFTiA/IEFORCA/IE9SREVSIEJZIGxldmVsIERFU0MsIGlkeCBBU0MAU0VMRUNUIGlkeCBGUk9NICVRLiclcV9zZWdkaXInIFdIRVJFIGxldmVsPT8gT1JERVIgQlkgMSBBU0MAU1lTVEVNX01BTExPQwBCTE9CAEJCQgBAACVzOiAiJXMiIC0gc2hvdWxkIHRoaXMgYmUgYSBzdHJpbmcgbGl0ZXJhbCBpbiBzaW5nbGUtcXVvdGVzPwBVUERBVEUgT1IgRkFJTCAlUS4nJXFfc2VnZGlyJyBTRVQgbGV2ZWw9LTEsaWR4PT8gV0hFUkUgbGV2ZWw9PyBBTkQgaWR4PT8AVVBEQVRFICVRLiclcV9zZWdkaXInIFNFVCBpZHggPSA/IFdIRVJFIGxldmVsPT8gQU5EIGlkeD0/ACVzPT8AU0VMRUNUICVzIFdIRVJFIHJvd2lkPT8AU0VMRUNUIHNpemUgRlJPTSAlUS4nJXFfZG9jc2l6ZScgV0hFUkUgZG9jaWQ9PwBTRUxFQ1QgdmFsdWUgRlJPTSAlUS4nJXFfc3RhdCcgV0hFUkUgaWQ9PwA/LD8sPwBERUxFVEUgRlJPTSAlUS4nJXFfc2VnZGlyJyBXSEVSRSBsZXZlbCBCRVRXRUVOID8gQU5EID8AU0VMRUNUIG1heChsZXZlbCkgRlJPTSAlUS4nJXFfc2VnZGlyJyBXSEVSRSBsZXZlbCBCRVRXRUVOID8gQU5EID8AREVMRVRFIEZST00gJVEuJyVxX3NlZ21lbnRzJyBXSEVSRSBibG9ja2lkIEJFVFdFRU4gPyBBTkQgPwBVUERBVEUgJVEuJyVxX3NlZ2RpcicgU0VUIHN0YXJ0X2Jsb2NrID0gPywgcm9vdCA9ID9XSEVSRSBsZXZlbCA9ID8gQU5EIGlkeCA9ID8AU0VMRUNUIGlkeCwgc3RhcnRfYmxvY2ssIGxlYXZlc19lbmRfYmxvY2ssIGVuZF9ibG9jaywgcm9vdCBGUk9NICVRLiclcV9zZWdkaXInIFdIRVJFIGxldmVsID0gPyBBTkQgaWR4ID0gPwBERUxFVEUgRlJPTSAlUS4nJXFfc2VnZGlyJyBXSEVSRSBsZXZlbCA9ID8gQU5EIGlkeCA9ID8AREVMRVRFIEZST00gJVEuJyVxX3NlZ2RpcicgV0hFUkUgbGV2ZWwgPSA/AFNFTEVDVCBjb3VudCgqKSBGUk9NICVRLiclcV9zZWdkaXInIFdIRVJFIGxldmVsID0gPwBTRUxFQ1QgJXMgV0hFUkUgcm93aWQgPSA/AERFTEVURSBGUk9NICVRLiclcV9jb250ZW50JyBXSEVSRSByb3dpZCA9ID8AREVMRVRFIEZST00gJVEuJyVxX2RvY3NpemUnIFdIRVJFIGRvY2lkID0gPwAsID8APGV4cHI+ADxiPgA8Yj4uLi48L2I+AC0+PgAtPgBzZXBhcmF0b3JzPQB0b2tlbmNoYXJzPQBhdXRvbWVyZ2U9ADwASU5TRVJUIElOVE8gJVEuc3FsaXRlX21hc3RlciBWQUxVRVMoJ2luZGV4JywlUSwlUSwjJWQsJVEpOwBDUkVBVEUgVEFCTEUgJVEuJyVxX3NlZ21lbnRzJyhibG9ja2lkIElOVEVHRVIgUFJJTUFSWSBLRVksIGJsb2NrIEJMT0IpOwBDUkVBVEUgVEFCTEUgJVEuJyVxX2RvY3NpemUnKGRvY2lkIElOVEVHRVIgUFJJTUFSWSBLRVksIHNpemUgQkxPQik7AENSRUFURSBUQUJMRSBJRiBOT1QgRVhJU1RTICVRLiclcV9zdGF0JyhpZCBJTlRFR0VSIFBSSU1BUlkgS0VZLCB2YWx1ZSBCTE9CKTsAQ1JFQVRFIFRBQkxFICVRLiclcV9zZWdkaXInKGxldmVsIElOVEVHRVIsaWR4IElOVEVHRVIsc3RhcnRfYmxvY2sgSU5URUdFUixsZWF2ZXNfZW5kX2Jsb2NrIElOVEVHRVIsZW5kX2Jsb2NrIElOVEVHRVIscm9vdCBCTE9CLFBSSU1BUlkgS0VZKGxldmVsLCBpZHgpKTsAVVBEQVRFICVRLnNxbGl0ZV9tYXN0ZXIgU0VUIHRibF9uYW1lID0gJVEsIG5hbWUgPSBDQVNFIFdIRU4gdHlwZT0ndGFibGUnIFRIRU4gJVEgV0hFTiBuYW1lIExJS0UgJ3NxbGl0ZVhfYXV0b2luZGV4JSUnIEVTQ0FQRSAnWCcgICAgICBBTkQgdHlwZT0naW5kZXgnIFRIRU4gJ3NxbGl0ZV9hdXRvaW5kZXhfJyB8fCAlUSB8fCBzdWJzdHIobmFtZSwlZCsxOCkgRUxTRSBuYW1lIEVORCBXSEVSRSB0YmxfbmFtZT0lUSBDT0xMQVRFIG5vY2FzZSBBTkQgKHR5cGU9J3RhYmxlJyBPUiB0eXBlPSdpbmRleCcgT1IgdHlwZT0ndHJpZ2dlcicpOwBEUk9QIFRBQkxFIElGIEVYSVNUUyAlUS4nJXFfc2VnbWVudHMnO0RST1AgVEFCTEUgSUYgRVhJU1RTICVRLiclcV9zZWdkaXInO0RST1AgVEFCTEUgSUYgRVhJU1RTICVRLiclcV9kb2NzaXplJztEUk9QIFRBQkxFIElGIEVYSVNUUyAlUS4nJXFfc3RhdCc7JXMgRFJPUCBUQUJMRSBJRiBFWElTVFMgJVEuJyVxX2NvbnRlbnQnOwBBTFRFUiBUQUJMRSAlUS4nJXFfY29udGVudCcgIFJFTkFNRSBUTyAnJXFfY29udGVudCc7AEFMVEVSIFRBQkxFICVRLiclcV9zdGF0JyAgUkVOQU1FIFRPICclcV9zdGF0JzsAQUxURVIgVEFCTEUgJVEuJyVxX3NlZ21lbnRzJyBSRU5BTUUgVE8gJyVxX3NlZ21lbnRzJzsAQUxURVIgVEFCTEUgJVEuJyVxX3NlZ2RpcicgICBSRU5BTUUgVE8gJyVxX3NlZ2Rpcic7AEFMVEVSIFRBQkxFICVRLiclcV9kb2NzaXplJyAgUkVOQU1FIFRPICclcV9kb2NzaXplJzsAOm1lbW9yeToAZmlsZToALTllOTk5ADkuMGU5OTkAKy0gCgkwMTIzNDU2Nzg5AFx1MDAwOQBTdHJpbmc4AHV0ZjgAVVRGOABVVEYtOABERUZBVUxUX1NFQ1RPUl9TSVpFPTQwOTYAREVGQVVMVF9QQUdFX1NJWkU9NDA5NgBNQVhfVkFSSUFCTEVfTlVNQkVSPTMyNzY2AE1BWF9QQUdFX1NJWkU9NjU1MzYAVVRGMTYAVVRGLTE2AHA1AHRvbyBtYW55IHJlZmVyZW5jZXMgdG8gIiVzIjogbWF4IDY1NTM1AEZMQUdTIHBhcmFtZXRlciB0byBqc29uX3ZhbGlkKCkgbXVzdCBiZSBiZXR3ZWVuIDEgYW5kIDE1AHNxbGl0ZV9zdGF0NABmdHM0AHA0AERFRkFVTFRfRklMRV9GT1JNQVQ9NABJbnQ2NABwd3JpdGU2NABwcmVhZDY0AE1BTExPQ19TT0ZUX0xJTUlUPTEwMjQAc3FsaXRlX3N0YXQzAFNBVkVQT0lOVCBmdHMzAFJPTExCQUNLIFRPIGZ0czMAUkVMRUFTRSBmdHMzAHAzAEVOQUJMRV9GVFMzAHAyAGF0bjIAYXRhbjIAcmVtb3ZlX2RpYWNyaXRpY3M9MgBERUZBVUxUX1NZTkNIUk9OT1VTPTIAREVGQVVMVF9XQUxfU1lOQ0hST05PVVM9MgBhcmdjPT0zIHx8YXJnYz09MgBNQVhfREVGQVVMVF9QQUdFX1NJWkU9ODE5MgBTRUxFQ1QgdGJsLGlkeCxzdGF0IEZST00gJVEuc3FsaXRlX3N0YXQxAEFnZ1N0ZXAxAHJlbW92ZV9kaWFjcml0aWNzPTEAQVRPTUlDX0lOVFJJTlNJQ1M9MQBURU1QX1NUT1JFPTEAYXJnYz09MQB1bmljb2RlNjEAVVBEQVRFIE9SIEZBSUwgJVEuJyVxX3NlZ2RpcicgU0VUIGxldmVsPT8gV0hFUkUgbGV2ZWw9LTEAREVGQVVMVF9KT1VSTkFMX1NJWkVfTElNSVQ9LTEAU0VMRUNUIGxldmVsLCBjb3VudCgqKSBBUyBjbnQgRlJPTSAlUS4nJXFfc2VnZGlyJyAgIEdST1VQIEJZIGxldmVsIEhBVklORyBjbnQ+PT8gIE9SREVSIEJZIChsZXZlbCAlJSAxMDI0KSBBU0MsIDIgREVTQyBMSU1JVCAxAFNFTEVDVCAoU0VMRUNUIG1heChpZHgpIEZST00gJVEuJyVxX3NlZ2RpcicgV0hFUkUgbGV2ZWwgPSA/KSArIDEAU0VMRUNUJ0lOU0VSVCBJTlRPICVzLid8fHF1b3RlKG5hbWUpfHwnIFNFTEVDVCpGUk9NIiV3Ii4nfHxxdW90ZShuYW1lKUZST00gJXMuc3FsaXRlX3NjaGVtYSBXSEVSRSB0eXBlPSd0YWJsZSdBTkQgY29hbGVzY2Uocm9vdHBhZ2UsMSk+MABTRUxFQ1Qgc3FsIEZST00gIiV3Ii5zcWxpdGVfc2NoZW1hIFdIRVJFIHR5cGU9J3RhYmxlJ0FORCBuYW1lPD4nc3FsaXRlX3NlcXVlbmNlJyBBTkQgY29hbGVzY2Uocm9vdHBhZ2UsMSk+MAByZW1vdmVfZGlhY3JpdGljcz0wAE1BWF9XT1JLRVJfVEhSRUFEUz0wAERFRkFVTFRfV09SS0VSX1RIUkVBRFM9MABNQVhfTU1BUF9TSVpFPTAAREVGQVVMVF9NTUFQX1NJWkU9MABUSFJFQURTQUZFPTAAOTIyMzM3MjAzNjg1NDc3NTgwADIwMjUtMDItMTggMTM6Mzg6NTggODczZDRlMjc0YjQ5ODhkMjYwYmE4MzU0YTk3MTgzMjRhMWMyNjE4N2E0YWI0YzFjYzAyMjdjMDNkMGYxMGU3MABERUZBVUxUX1BDQUNIRV9JTklUU1o9MjAAbG9nMTAATUFYX0FUVEFDSEVEPTEwAFx1MDAATUFYX0NPTVBPVU5EX1NFTEVDVD01MDAAPzAwMABNQVhfQ09MVU1OPTIwMDAAREVGQVVMVF9DQUNIRV9TSVpFPS0yMDAwAERFRkFVTFRfV0FMX0FVVE9DSEVDS1BPSU5UPTEwMDAATUFYX0VYUFJfREVQVEg9MTAwMABNQVhfVFJJR0dFUl9ERVBUSD0xMDAwAE1BWF9GVU5DVElPTl9BUkc9MTAwMABcdTAwMDAATUFYX0xJS0VfUEFUVEVSTl9MRU5HVEg9NTAwMDAATUFYX1ZEQkVfT1A9MjUwMDAwMDAwAE1BWF9MRU5HVEg9MTAwMDAwMDAwMABNQVhfU1FMX0xFTkdUSD0xMDAwMDAwMDAwAHNlY29uZCBhcmd1bWVudCB0byAlI1QoKSBtdXN0IGJlIGEgY29uc3RhbnQgYmV0d2VlbiAwLjAgYW5kIDEuMABDT01QSUxFUj1jbGFuZy0yMS4wLjAAL3Byb2Mvc2VsZi9mZC8AJVEuAE4uAC0tACwAbm9za2lwc2NhbioAdW5vcmRlcmVkKgBzej1bMC05XSoAKHN1YnF1ZXJ5LSV1KQAoam9pbi0ldSkAQmFkIHB0ciBtYXAgZW50cnkga2V5PSV1IGV4cGVjdGVkPSgldSwldSkgZ290PSgldSwldSkAbWF4IHJvb3RwYWdlICgldSkgZGlzYWdyZWVzIHdpdGggaGVhZGVyICgldSkAQ1JFQVRFIFRBQkxFIHgodHlwZSB0ZXh0LG5hbWUgdGV4dCx0YmxfbmFtZSB0ZXh0LHJvb3RwYWdlIGludCxzcWwgdGV4dCkAQ1JFQVRFIFRBQkxFICVRLiVzKCVzKQBhdXRvbWF0aWMgaW5kZXggb24gJXMoJXMpAEFOWSglcykASU5TRVJUIElOVE8gJVEuJyVxX2NvbnRlbnQnIFZBTFVFUyglcykAQ1JFQVRFIFRBQkxFICVRLiclcV9jb250ZW50JyglcykAbWFsZm9ybWVkIGRhdGFiYXNlIHNjaGVtYSAoJXMpAE1FUkdFICglcykAQ1JFQVRFIFRBQkxFICVRLnNxbGl0ZV9zZXF1ZW5jZShuYW1lLHNlcSkAQ1JFQVRFIFRBQkxFIHgoaW5wdXQsIHRva2VuLCBzdGFydCwgZW5kLCBwb3NpdGlvbikAVVBEQVRFICIldyIuc3FsaXRlX21hc3RlciBTRVQgc3FsID0gc3FsaXRlX2Ryb3BfY29sdW1uKCVkLCBzcWwsICVkKSBXSEVSRSAodHlwZT09J3RhYmxlJyBBTkQgdGJsX25hbWU9JVEgQ09MTEFURSBub2Nhc2UpAG1lbWRiKCVwLCVsbGQpACVzKCVkKQB6ZXJvYmxvYiglZCkARlRTIGV4cHJlc3Npb24gdHJlZSBpcyB0b28gbGFyZ2UgKG1heGltdW0gZGVwdGggJWQpAEV4cHJlc3Npb24gdHJlZSBpcyB0b28gbGFyZ2UgKG1heGltdW0gZGVwdGggJWQpAChibG9iKQBVU0UgVEVNUCBCLVRSRUUgRk9SICVzKE9SREVSIEJZKQBVU0UgVEVNUCBCLVRSRUUgRk9SICVzKERJU1RJTkNUKQBVUERBVEUgIiV3Ii5zcWxpdGVfbWFzdGVyIFNFVCBzcWwgPSBzcWxpdGVfcmVuYW1lX2NvbHVtbihzcWwsIHR5cGUsIG5hbWUsICVRLCAlUSwgJWQsICVRLCAlZCwgJWQpIFdIRVJFIG5hbWUgTk9UIExJS0UgJ3NxbGl0ZVhfJSUnIEVTQ0FQRSAnWCcgIEFORCAodHlwZSAhPSAnaW5kZXgnIE9SIHRibF9uYW1lID0gJVEpAENSRUFURSBUQUJMRSB4KGtleSx2YWx1ZSx0eXBlLGF0b20saWQscGFyZW50LGZ1bGxrZXkscGF0aCxqc29uIEhJRERFTixyb290IEhJRERFTikAQ1JFQVRFIFRBQkxFIHgodGVybSwgY29sLCBkb2N1bWVudHMsIG9jY3VycmVuY2VzLCBsYW5ndWFnZWlkIEhJRERFTikAQ1JFQVRFIFRBQkxFIHgoJXMgJVEgSElEREVOLCBkb2NpZCBISURERU4sICVRIEhJRERFTikAKE5VTEwpACVjPykAU0VMRUNUIE5PVCBFWElTVFMoU0VMRUNUIGRvY2lkIEZST00gJVEuJyVxX2NvbnRlbnQnIFdIRVJFIHJvd2lkIT0/KQBSRVBMQUNFIElOVE8gJVEuJyVxX3NlZ2RpcicgVkFMVUVTKD8sPyw/LD8sPyw/KQBSRVBMQUNFIElOVE8gJVEuJyVxX3N0YXQnIFZBTFVFUyg/LD8pAFJFUExBQ0UgSU5UTyAlUS4nJXFfZG9jc2l6ZScgVkFMVUVTKD8sPykALCVzKD8pAFJFUExBQ0UgSU5UTyAlUS4nJXFfc2VnbWVudHMnKGJsb2NraWQsIGJsb2NrKSBWQUxVRVMoPywgPykAU0VMRUNUIGNvYWxlc2NlKChTRUxFQ1QgbWF4KGJsb2NraWQpIEZST00gJVEuJyVxX3NlZ21lbnRzJykgKyAxLCAxKQBJTlNFUlQgSU5UTyAlcy5zcWxpdGVfc2NoZW1hIFNFTEVDVCpGUk9NICIldyIuc3FsaXRlX3NjaGVtYSBXSEVSRSB0eXBlIElOKCd2aWV3JywndHJpZ2dlcicpIE9SKHR5cGU9J3RhYmxlJ0FORCByb290cGFnZT0wKQB3cm9uZyBudW1iZXIgb2YgYXJndW1lbnRzIHRvIGZ1bmN0aW9uIHNuaXBwZXQoKQBtaXN1c2Ugb2YgYWdncmVnYXRlOiAlcygpAG1pc3VzZSBvZiAlcyBmdW5jdGlvbiAlI1QoKQB3cm9uZyBudW1iZXIgb2YgYXJndW1lbnRzIHRvIGZ1bmN0aW9uICUjVCgpAHVuc2FmZSB1c2Ugb2YgJSNUKCkAT1JERVIgQlkgbWF5IG5vdCBiZSB1c2VkIHdpdGggbm9uLWFnZ3JlZ2F0ZSAlI1QoKQBGSUxURVIgbWF5IG5vdCBiZSB1c2VkIHdpdGggbm9uLWFnZ3JlZ2F0ZSAlI1QoKQB1bmtub3duIGZ1bmN0aW9uOiAlI1QoKQBtaXN1c2Ugb2YgYWdncmVnYXRlOiAlI1QoKQBhbWJpZ3VvdXMgcmVmZXJlbmNlIHRvICVzIGluIFVTSU5HKCkAVVBEQVRFIHRlbXAuc3FsaXRlX21hc3RlciBTRVQgc3FsID0gc3FsaXRlX3JlbmFtZV9jb2x1bW4oc3FsLCB0eXBlLCBuYW1lLCAlUSwgJVEsICVkLCAlUSwgJWQsIDEpIFdIRVJFIHR5cGUgSU4gKCd0cmlnZ2VyJywgJ3ZpZXcnKQBVUERBVEUgc3FsaXRlX3RlbXBfc2NoZW1hIFNFVCBzcWwgPSBzcWxpdGVfcmVuYW1lX3RhYmxlKCVRLCB0eXBlLCBuYW1lLCBzcWwsICVRLCAlUSwgMSksIHRibF9uYW1lID0gQ0FTRSBXSEVOIHRibF9uYW1lPSVRIENPTExBVEUgbm9jYXNlIEFORCAgIHNxbGl0ZV9yZW5hbWVfdGVzdCglUSwgc3FsLCB0eXBlLCBuYW1lLCAxLCAnYWZ0ZXIgcmVuYW1lJywgMCkgVEhFTiAlUSBFTFNFIHRibF9uYW1lIEVORCBXSEVSRSB0eXBlIElOICgndmlldycsICd0cmlnZ2VyJykALCVzKHguJ2MlZCVxJykASU5TRVJUIElOVE8gJVEuc3FsaXRlX21hc3RlciBWQUxVRVMoJ3RyaWdnZXInLCVRLCVRLDAsJ0NSRUFURSBUUklHR0VSICVxJykASU5TRVJUIElOVE8gJVEuJVEoJVEpIFZBTFVFUygnZmx1c2gnKQBTRUxFQ1QgMiAqIHRvdGFsKDEgKyBsZWF2ZXNfZW5kX2Jsb2NrIC0gc3RhcnRfYmxvY2spICAgRlJPTSAoU0VMRUNUICogRlJPTSAlUS4nJXFfc2VnZGlyJyAgICAgICAgIFdIRVJFIGxldmVsID0gPyBPUkRFUiBCWSBpZHggQVNDIExJTUlUID8gICkACikAQkxPT00gRklMVEVSIE9OICVTICgAU0VMRUNUIHNxbCBGUk9NICIldyIuc3FsaXRlX3NjaGVtYSBXSEVSRSB0eXBlPSdpbmRleCcAREVMRVRFIEZST00gJVEuc3FsaXRlX21hc3RlciBXSEVSRSBuYW1lPSVRIEFORCB0eXBlPSdpbmRleCcAbmFtZT0nJXEnIEFORCB0eXBlPSdpbmRleCcAREVMRVRFIEZST00gJVEuJyVxX2NvbnRlbnQnAERFTEVURSBGUk9NICVRLiclcV9zdGF0JwBERUxFVEUgRlJPTSAlUS4nJXFfc2VnbWVudHMnAERFTEVURSBGUk9NICVRLiclcV9zZWdkaXInAFNFTEVDVCA/IFVOSU9OIFNFTEVDVCBsZXZlbCAvICgxMDI0ICogPykgRlJPTSAlUS4nJXFfc2VnZGlyJwBTRUxFQ1QgbWF4KCBsZXZlbCAlJSAxMDI0ICkgRlJPTSAlUS4nJXFfc2VnZGlyJwBERUxFVEUgRlJPTSAlUS5zcWxpdGVfbWFzdGVyIFdIRVJFIG5hbWU9JVEgQU5EIHR5cGU9J3RyaWdnZXInAERFTEVURSBGUk9NICVRLnNxbGl0ZV9tYXN0ZXIgV0hFUkUgdGJsX25hbWU9JVEgYW5kIHR5cGUhPSd0cmlnZ2VyJwB0YmxfbmFtZT0nJXEnIEFORCB0eXBlIT0ndHJpZ2dlcicAJyUuKnEnACV6LCAnYyVkJXEnAHR5cGU9J3RyaWdnZXInIEFORCBuYW1lPSclcScALCB4LiclcScAaW5kZXggJyVxJwBERUxFVEUgRlJPTSAlUS4nJXFfZG9jc2l6ZScAVVBEQVRFICIldyIuc3FsaXRlX21hc3RlciBTRVQgc3FsID0gc3FsaXRlX3JlbmFtZV90YWJsZSglUSwgdHlwZSwgbmFtZSwgc3FsLCAlUSwgJVEsICVkKSBXSEVSRSAodHlwZSE9J2luZGV4JyBPUiB0YmxfbmFtZT0lUSBDT0xMQVRFIG5vY2FzZSlBTkQgICBuYW1lIE5PVCBMSUtFICdzcWxpdGVYXyUlJyBFU0NBUEUgJ1gnAFNFTEVDVCBDQVNFIFdIRU4gcXVpY2tfY2hlY2sgR0xPQiAnQ0hFQ0sqJyBUSEVOIHJhaXNlKEFCT1JULCdDSEVDSyBjb25zdHJhaW50IGZhaWxlZCcpIFdIRU4gcXVpY2tfY2hlY2sgR0xPQiAnbm9uLSogdmFsdWUgaW4qJyBUSEVOIHJhaXNlKEFCT1JULCd0eXBlIG1pc21hdGNoIG9uIERFRkFVTFQnKSBFTFNFIHJhaXNlKEFCT1JULCdOT1QgTlVMTCBjb25zdHJhaW50IGZhaWxlZCcpIEVORCAgRlJPTSBwcmFnbWFfcXVpY2tfY2hlY2soJVEsJVEpIFdIRVJFIHF1aWNrX2NoZWNrIEdMT0IgJ0NIRUNLKicgT1IgcXVpY2tfY2hlY2sgR0xPQiAnTlVMTConIE9SIHF1aWNrX2NoZWNrIEdMT0IgJ25vbi0qIHZhbHVlIGluKicAVVBEQVRFICIldyIuc3FsaXRlX21hc3RlciBTRVQgc3FsID0gc3FsaXRlX3JlbmFtZV9xdW90ZWZpeCglUSwgc3FsKVdIRVJFIG5hbWUgTk9UIExJS0UgJ3NxbGl0ZVhfJSUnIEVTQ0FQRSAnWCcgQU5EIHNxbCBOT1QgTElLRSAnY3JlYXRlIHZpcnR1YWwlJScAVVBEQVRFIHRlbXAuc3FsaXRlX21hc3RlciBTRVQgc3FsID0gc3FsaXRlX3JlbmFtZV9xdW90ZWZpeCgndGVtcCcsIHNxbClXSEVSRSBuYW1lIE5PVCBMSUtFICdzcWxpdGVYXyUlJyBFU0NBUEUgJ1gnIEFORCBzcWwgTk9UIExJS0UgJ2NyZWF0ZSB2aXJ0dWFsJSUnAHNxbGl0ZVxfJQAkACMAU0VMRUNUKkZST00iJXciAFNFTEVDVCpGUk9NIiV3Ii4iJXciAFNFTEVDVCByYWlzZShBQk9SVCwlUSkgRlJPTSAiJXciLiIldyIAQU5BTFlaRSAiJXciLiIldyIAZm9yZWlnbiBrZXkgbWlzbWF0Y2ggLSAiJXciIHJlZmVyZW5jaW5nICIldyIAZG91YmxlLXF1b3RlZCBzdHJpbmcgbGl0ZXJhbDogIiV3IgAuIiUuKnMiAHN5bnRheCBlcnJvciBhZnRlciBjb2x1bW4gbmFtZSAiJS4qcyIAJWMiJXMiACgiJXMiAGNhbm5vdCAlcyAlcyAiJXMiAGdlbmVyYXRlZCBjb2x1bW4gbG9vcCBvbiAiJXMiAGNhbm5vdCBJTlNFUlQgaW50byBnZW5lcmF0ZWQgY29sdW1uICIlcyIAZXJyb3IgaW4gZ2VuZXJhdGVkIGNvbHVtbiAiJXMiAGNhbm5vdCBVUERBVEUgZ2VuZXJhdGVkIGNvbHVtbiAiJXMiACVzIGluICIlcyIAdHJpZ2dlciAiJXMiIG1heSBub3Qgd3JpdGUgdG8gc2hhZG93IHRhYmxlICIlcyIAVVBTRVJUIG5vdCBpbXBsZW1lbnRlZCBmb3IgdmlydHVhbCB0YWJsZSAiJXMiAHVuc2FmZSB1c2Ugb2YgdmlydHVhbCB0YWJsZSAiJXMiAGNhbm5vdCBjcmVhdGUgYSBURU1QIGluZGV4IG9uIG5vbi1URU1QIHRhYmxlICIlcyIAbm8gc3VjaCBpbmRleDogIiVzIgB1bmtub3duIGRhdGF0eXBlIGZvciAlcy4lczogIiVzIgBjYW5ub3QgZHJvcCAlcyBjb2x1bW46ICIlcyIAbm8gc3VjaCBjb2x1bW46ICIlcyIAdW5yZWNvZ25pemVkIHRva2VuOiAiJXMiAFwiAG5vIHN1Y2ggY29sdW1uOiAiJVQiAHVucmVjb2duaXplZCB0b2tlbjogIiVUIgAuIgB3ZWVrZGF5IABub24tdW5pcXVlIGVudHJ5IGluIGluZGV4IAB3cm9uZyAjIG9mIGVudHJpZXMgaW4gaW5kZXggACB2YWx1ZXMgZGlmZmVyIGZyb20gaW5kZXggACBtaXNzaW5nIGZyb20gaW5kZXggACBvZiBpbmRleCAAcm93aWQgbm90IGF0IGVuZC1vZi1yZWNvcmQgZm9yIHJvdyAAJXIgAHN0YXJ0IG9mIAAlZCAlZCAlZCAlZCAAIFVTSU5HIENPVkVSSU5HIElOREVYIAAgVklSVFVBTCBUQUJMRSBJTkRFWCAAU0VMRUNUIDEgRlJPTSAiJXciLnNxbGl0ZV9tYXN0ZXIgV0hFUkUgbmFtZSBOT1QgTElLRSAnc3FsaXRlWF8lJScgRVNDQVBFICdYJyBBTkQgc3FsIE5PVCBMSUtFICdjcmVhdGUgdmlydHVhbCUlJyBBTkQgc3FsaXRlX3JlbmFtZV90ZXN0KCVRLCBzcWwsIHR5cGUsIG5hbWUsICVkLCAlUSwgJWQpPU5VTEwgAFNFTEVDVCAxIEZST00gdGVtcC5zcWxpdGVfbWFzdGVyIFdIRVJFIG5hbWUgTk9UIExJS0UgJ3NxbGl0ZVhfJSUnIEVTQ0FQRSAnWCcgQU5EIHNxbCBOT1QgTElLRSAnY3JlYXRlIHZpcnR1YWwlJScgQU5EIHNxbGl0ZV9yZW5hbWVfdGVzdCglUSwgc3FsLCB0eXBlLCBuYW1lLCAxLCAlUSwgJWQpPU5VTEwgACBVU0lORyAATEFTVCBURVJNIE9GIABDUkVBVEUgAENSRUFURSBUQUJMRSAAIEFORCAAQ09SUkVMQVRFRCAAUFJBR01BIABUcmVlICV1IHBhZ2UgJXUgY2VsbCAldTogAFRyZWUgJXUgcGFnZSAldTogAEZyZWVsaXN0OiAAVHJlZSAldSBwYWdlICV1IHJpZ2h0IGNoaWxkOiAALS0gACV6JVEsIAAiJXciIABAICAAICAgIAAsCiAgABEQACwKACoqKiBpbiBkYXRhYmFzZSAlcyAqKioKAAAAAAAAAABkCgEQAABzAAQFAABnAAEDHgB6AAQGAABxAAQJAABRAAQKAAB3AAQOAABjAAAIAABvCAAAAAJ1CgAQAAB4EAAAEAFYEAAAAARmAAEBAABlAAECHgBFAAECDgBHAAEDDgBpCgEQAABuAAAEAAAlAAAHAABwEAANAAFUAAALAABTAAAMAAByCgEPAAAAAAAAAAAwMTIzNDU2Nzg5QUJDREVGMDEyMzQ1Njc4OWFiY2RlZgAteDAAWDA=");n(g,31008,"ZXhwYW5kIDMyLWJ5dGUgawABAgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fICEiIyQlJicoKSorLC0uLzAxMjM0NTY3ODk6Ozw9Pj9AYWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXpbXF1eX2BhYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5ent8fX5/gIGCg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGys7S1tre4ubq7vL2+v8DBwsPExcbHyMnKy8zNzs/Q0dLT1NXW19jZ2tvc3d7f4OHi4+Tl5ufo6err7O3u7/Dx8vP09fb3+Pn6+/z9/v8BAAABAQAAAQABAAEBAAEAAAEAAIkAAACKAAAAiwAAAAQFAwUBBQEFAgUCBQEFAQUEBQMFAQUBBQIFAgUBBQEFAgUCBQIFAgUCBQIFAgUCBQQFAwUCBQIFAgUCBQIFAgWpAAAAZgAAAB8ABQFeAAABVAEAAEYAAAAqP1sAJV8AAQ==");n(g,31417,"AQEBAQE=");n(g,31440,"AQCAAEAAAIAAAAAAAAAAAAwMDAwMDAwMDAwAAAAAAAAACgoKCgoKAgICAgICAgICAgICAgICAgICAgKAAAAAQIAqKioqKioiIiIiIiIiIiIiIiIiIiIiIiIiIgAAAAAAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBSRUlOREVYRURFU0NBUEVBQ0hFQ0tFWUJFRk9SRUlHTk9SRUdFWFBMQUlOU1RFQUREQVRBQkFTRUxFQ1RBQkxFRlRIRU5ERUZFUlJBQkxFTFNFWENMVURFTEVURU1QT1JBUllJU05VTExTQVZFUE9JTlRFUlNFQ1RJRVNOT1ROVUxMSUtFWENFUFRSQU5TQUNUSU9OQVRVUkFMVEVSQUlTRVhDTFVTSVZFWElTVFNDT05TVFJBSU5UT0ZGU0VUUklHR0VSQU5HRU5FUkFURURFVEFDSEFWSU5HTE9CRUdJTk5FUkVGRVJFTkNFU1VOSVFVRVJZV0lUSE9VVEVSRUxFQVNFQVRUQUNIQkVUV0VFTk9USElOR1JPVVBTQ0FTQ0FERUZBVUxUQ0FTRUNPTExBVEVDUkVBVEVDVVJSRU5UX0RBVEVJTU1FRElBVEVKT0lOU0VSVE1BVENIUExBTkFMWVpFUFJBR01BVEVSSUFMSVpFREVGRVJSRURJU1RJTkNUVVBEQVRFVkFMVUVTVklSVFVBTFdBWVNXSEVOV0hFUkVDVVJTSVZFQUJPUlRBRlRFUkVOQU1FQU5EUk9QQVJUSVRJT05BVVRPSU5DUkVNRU5UQ0FTVENPTFVNTkNPTU1JVENPTkZMSUNUQ1JPU1NDVVJSRU5UX1RJTUVTVEFNUFJFQ0VESU5HRkFJTEFTVEZJTFRFUkVQTEFDRUZJUlNURk9MTE9XSU5HRlJPTUZVTExJTUlUSUZPUkRFUkVTVFJJQ1RPVEhFUlNPVkVSRVRVUk5JTkdSSUdIVFJPTExCQUNLUk9XU1VOQk9VTkRFRFVOSU9OVVNJTkdWQUNVVU1WSUVXSU5ET1dCWUlOSVRJQUxMWVBSSU1BUlk=");n(g,32340,"AgACAAgACQAOABAAFAAXABkAGQAdACEAJAApAC4AMAA1ADYAOwA+AEEAQwBFAE4AUQBWAFoAWgBeAGMAZQBpAG8AdwB7AHsAewB+AIEAhACJAI4AkgCTAJgAnACgAKgArgC1ALgAuAC7AL0AwwDGAM4A0wDYANsA3gDiAOwA7wD0APQA+AD8AAMBCQEPARUBFQEbARwBIAEnASsBMgE4AUQBTQFPAVUBWgFcAWMBZwFyAXkBegGBAYcBjQGSAZgBnAGfAagBrQGxAbcBuQG8AcUBxwHJAdIB1gHcAeIB6gHvAe8B7wH/AQgCCwIPAhQCGwIgAikCLQIwAjUCNwI7AkMCSQJMAlUCWgJiAmICZgJvAnQCeQJ/AoIChQKIAooCjwKTAg==");n(g,32641,"BwcFBAYEBQMGBwMGBgcHAwgCBgUEBAMKBAcGCQQCBgUJCQQHAwIEBAYLBgIHBQUJBgoEBgIDBwUJBgYEBQUKBgUHBAUHBgcHBgUHAwcEBwYMCQQGBQQHBgwICAIGBgcGBAUJBQUGAwQJDQICBAYGCAURDAcJBAQGBwUJBAQFAgUIBgQJBQgEAwkFBQYEBgICCQMH");n(g,32800,"6gMAAAAAAAAAQAAAAAAAAOsDAAAAAAAAAAAEAAAAAAD3Aw==");n(g,32843,"gAAAAADsAwAAAAAAAAAAQAAAAAAA7QMAAAAAAAAAAAEAAAAAAO4DAAAAAAAAAAgAAAAAAADvAwAAAAAAAAAAgAAAAAAA8AM=");n(g,32923,"AQAAAADxAw==");n(g,32939,"AgAAAADyAw==");n(g,32955,"EAAAAADzAwAAAAAAAAEAAAgAAAAA9AM=");n(g,32987,"BAAAAAD2Aw==");n(g,33003,"IAAAAAD1Aw==");n(g,33019,"QAAAAAD4AwAAAAAAAAIAAAAAAAAA+QMAAAAAAACAAAAAAAAAAPoDAAAAAAAAAAQAAAAAAAD7AwAAAAAAAAAQAAAAAAAA/AM=");n(g,33100,"EAAAAP0D");n(g,33116,"IAAAAP4D");n(g,33132,"QAAAAADKmjsAypo70AcAAOgDAAD0AQAAgLLmDugDAAAKAAAAUMMAAP5/AADoAwAAAAAAAAMAAACMAAAAjQAAAI4AAACPAAAAkAAAAJEAAACSAAAAkwAAAJQAAACVAAAAlgAAAJcAAACYAAAAmQAAAJoAAACbAAAAnAAAAJ0AAAADAAAAtAAAAI0AAACOAAAAjwAAAJAAAACRAAAAtQAAALYAAAC3AAAAlQAAAJYAAACXAAAAAAAAAJkAAACaAAAAmwAAAJwAAACdAAAAAQAAALgAAACNAAAAjgAAAI8AAACQAAAAkQAAALkAAAC6AAAAuwAAAJUAAACWAAAAlwAAAAAAAACZAAAAmgAAAJsAAACcAAAAnQAAAAMAAAC8AAAAvQAAAL4AAAC/AAAAwAAAAMEAAADCAAAAwwAAAAAAAADEAAAAAAAAAMU=");n(g,33480,"xgAAAMc=");n(g,33496,"AQAAANMAAADUAAAA1QAAANYAAADXAAAA2A==");n(g,33572,"2dUF+SChY9c=");n(g,33616,"U1FMaXRlIGZvcm1hdCAzAAABAgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fAAECAwQFBgcICQoLDA0ODwABAgMEBQYHAAECAwABAABCSU5BUlk=");n(g,33712,"wVUAAOtaAAD7TwAAKlAAAKIKAAA8DAAANCoAAJcKAADEOQAA8CwAAL8kAADSMwAANwwAAGEnAAChRgAAazYAAPM6AADpCwAA0yYAAA06AAD/MQAAPAoAAEs2AAA+CgAA0QYAAMRJAADuTwAABlAAAPtJAACALAAAUjYAAI0NAACgOgAAozoAAHM7AAAKDwAA1gkAAJssAADlCQAA6wkAALM6AACxCAAARQcAAL0IAADoTwAA9UkAAL5JAACpJgAAxToAAABQAADTQAAAuQkAAIItAAC5JwAAAhMAAP4tAADtLQAATDoAALwmAABKDgAATzoAAEcOAABSOgAAuCYAAKInAACsJwAA7CwAALwIAADAJAAAsUUAACwpAAAeKAAAeTYAABAuAAAhDAAA/CUAAOZbAAA9MQAAEigAABYuAAD1LQAAwEYAAKQ4AACrMgAA7gQAAO0EAADlBAAAai8AAMcGAACwJgAAJC0AAC4EAADbCQAAQCoAABA2AAATMwAABS4AAOAMAAAiLAAAci8AADIEAAB0OgAAbwoAAO44AADkOAAAQQYAAN5AAADCOgAApiYAANYMAADGDAAAyUAAAPENAAD8BAAA0DkAABwmAABADgAAgjMAAMYmAAA1CgAA/QUAAHEuAADVWgAAiiwAAMQJAAAAKAAAHTUAAKc9AAC8LAAAlQwAAPA5AABqOwAAIgoAACwuAACnMwAAagoAAAo2AAD7RgAA80YAAHc7AADTBgAAujoAABIKAAAcCgAApDMAANguAABhOwAAzS4AAPQEAACgJgAAciQAAIs5AAAQRgAAWkcAALYUAACtOAAAMwYAACMlAACyLgAAgy8AALlAAACKLQAAfiQAAFMGAACJDAAABDUAAAEnAAAFXQAAZzMAAH8uAADvNQAABy8AAOwuAAASLwAAXSwAAMAzAADzBAAAlSwAAHwvAADFLAAAISwAANk2AABCCgAAswsAADY2AAArNgAAIDYAAMNAAAASOgAACAsAAHcxAADOJgAAaSwAAI83");n(g,34496,"/04AAKNPAABiTwAAt0gAAAAAAAABAgACAgABAgEBAQIBAhABAQEBAQECAQEQEBAAAgI=");n(g,34561,"AQIDBAYICAAAAAAAAAEBAgIDAwQEBQUGBgcHCAgJCQoKCwsMDA0NDg4PDxAQERESEhMTFBQVFRYWFxcYGBkZGhobGxwcHR0eHh8fICAhISIiIyMkJCUlJiYnJygoKSkqKisrLCwtLS4uLy8wMDExMjIzMzQ0NTU2Njc3ODg5ORBAAkA=");n(g,34704,"ukkAAF1PAACeSQAAAlIAAE1PAAAAAQIDBAYIAAAAAADANgAAUCsAAMArAAAhACAAHgAcABo=");n(g,34768,"nTMAABoJAADhMQAA8jMAALcEAABTLgAAAQEDAAUABgAI");n(g,34824,"AQ==");n(g,34849,"BQwPEhUYGyMmLTUAAAAAYQBkAGQAcgAAAG8AcABjAG8AZABlAAAAcAAxAAAAcAAyAAAAcAAzAAAAcAA0AAAAcAA1AAAAYwBvAG0AbQBlAG4AdAAAAGkAZAAAAHAAYQByAGUAbgB0AAAAbgBvAHQAdQBzAGUAZAAAAGQAZQB0AGEAaQBs");n(g,34992,"jCYAALU5AAALXQAAXVwAAE5cAADNWwAAWFsAAFYLAADfOwAAHAsAAF89AAA5LgAAAAAAABAAQQCBAQGBg4MBAQMDARIBycnJyQFJSUlJyUnBAUFBwQFBQUFBQSYmQSMLgQEDAwMLCwsLCwsBAwMBQQEAAAICCAAQEBAAEAAQEAAAEBAAAAACAgIAABIeIEAAAAAQEABAQCYmJiYmJiYmJiYAQBJAQBAAAABAAEBAEBAAAAAAAEAAUABABAQAQFBAEAAAEAAAAAAAABAABhAABBo=");n(g,35213,"QBBQQAAQEAISEg==");n(g,35240,"2QAAANoAAADbAAAAAAAAANwAAADdAAAA3gAAAN8AAADgAAAA4QAAAOI=");n(g,35344,"RwwAAAEQ");n(g,35360,"wjsAAAIUAAAIAAAAAAAAAM0sAAADlQ==");n(g,35392,"CwYAAAQUAAAAgAAAAAAAANMIAAAFEDgBAAAAAAAAAABdMgAABpU=");n(g,35440,"IC4AAAeU");n(g,35456,"0DgAAAgC");n(g,35472,"Si8AAAQUAAAAACAAAAAAAKREAAAEFAAAEAAAAAAAAABMCQAACRAmAgAAAAAAAAAACBMAAAoQ");n(g,35536,"FhcAAAQUAAAAAAAAAQAAAAYrAAACGAAADwAAAAAAAABbCQAADBAvAwAAAAAAAAAAVTIAAA2VNwEAAAAAAAAAAE0OAAAEFAAAAAAIAAAAAACfFAAABBQAAAABAAAAAAAATDEAAA4U");n(g,35648,"LC8AAA9xKwQAAAAAAAAAACIJAAAQYQAIAAAAAAAAAABTDgAABBQAAABAAAAAAAAATAoAAAIY");n(g,35712,"YBUAAAQUAAAEAAAAAAAAAK9EAAAEFAAACAAAAAAAAAA+CQAAERAbBgAAAAAAAAAAZgwAABIQ");n(g,35776,"FA8AAAQUAAAAAgAAAAAAANksAAATAw==");n(g,35808,"6icAABRhFQMAAAAAAAAAADMJAAAVYSYFAAAAAAAAAADIJwAAFGEVBgEAAAAAAAAAHC8AABZx");n(g,35872,"mzkAABeR");n(g,35888,"dgwAABiQ");n(g,35904,"mTcAAAQUAAAAAAAEAAAAAKg5AAAakA==");n(g,35936,"WwoAABuR");n(g,35952,"SzIAABw=");n(g,35968,"aQkAAB0QCQEAAAAAAAAAAIkyAAAeIQ==");n(g,36e3,"XwoAABuR");n(g,36016,"cjIAAB+U");n(g,36032,"hwkAACAQCQEAAAAAAAAAAAUFAAAEFAAAAAAQAAAAAAA+LwAAFnE=");n(g,36080,"kTwAAAQUAAAAAAAABAAAAIURAAAEFAAAACAAAAAAAABxEAAABBQAAAAQAAAAAAAAEysAAAIUAAABAAAAAAAAAJYzAAAhEA==");n(g,36160,"TRUAAAQUAABAAAAAAAAAAHwEAAAiAg==");n(g,36192,"VgwAACMQ");n(g,36208,"nA4AACSV");n(g,36224,"9ScAACVhCAYAAAAAAAAAAHwJAAAmIQ8GAAAAAAAAAADUJwAAJWEIBwEAAAAAAAAAujUAACcU");n(g,36288,"QAQAACgE");n(g,36304,"ZBcAACkQ");n(g,36320,"PEcAAAQUAACAAAAAAAAAAOoqAAACFAAABgAAAAAAAAB1CgAAKg==");n(g,36368,"iAoAACsBMgMAAAAAAAAAACxHAAAEFAAAAQAACAAAAADfOwAArCYAAFo4AAASLQAAaCcAAMgzAACMMwAAkTAAAL47AAAgNwAARjYAALstAAAhMwAAty4AAKksAABTRwAAIDcAAEY2AAC2LQAA5yIAAIYNAADCJwAAvjsAACA3AACbRAAAGy4AAEoFAAAgNwAAKSwAAEY2AAD8RQAA7jAAAMgUAABPLgAAPQYAADAwAADRDAAAwxQAAKwmAAAgNwAAGjMAAFYsAAClLgAAWjgAAFs7AAAcCwAAmDsAAKwmAAAgNwAAgDcAADsEAAD6MAAA9DwAALE1AACVDgAAXTIAANgIAAADAgE=");n(g,36640,"VFyGUmkdAABeAFVIADUjVg8AKmE2WYcTAACMACiBABZrAAkAAHtQAE4GAEFnkwCIcwAAMABaGAARABtGFxoFPI5uegBJW0eRPXhKADEACykAcQAAAG0Kb3R9DjJ8AGQAEnmQOIKLWFMlHn4AAGwzg4AAIgAAhABiJicAFC11XQAAY3WiJzspfUQhhT9AMAJCpCYYixB3oAuEoVyBFRUrM1MNil80E0N6MIkGHHR3o0gJFHiYRkWDTlpgKJQwBXd+fAMaUncOIDGZXZMjH3mechFlCJCALwQeR2IHjS2CjFFhn5ZJGx1kLIZYfw8yJD0KJXdlZVZZKlWnSlRXj3eVEpJLXqaXdwxNTFuHkU9QpT4iQYh7");n(g,36933,"BAArAABqcgAAAAIAAI8AAAANAAAAAI0AAHc0AACJDAAAPgCKAIUAACQAABxNAAAAADsALw==");n(g,36995,"RQAAAAAAkgMAOgABSwAAAB8AAAAAAH8AaABAQj8AAAAAAC4AEAg=");n(g,37043,"UWUAcBUHQwBPYHYAAEQAAGMsADcATABfICE5GQBmAABX");n(g,37088,"HRwcHBwcHBwcBwccBwccHBwcHBwcHBwcHBwcHBwcHBwHDwgFBBYYCBESFRQXCxoQAwMDAwMDAwMDAwUTDA4NBgUBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQACAgkcHBwCCAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAICHAocGRwbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxseGxsbGxsbGxsbGxsbGxsbGwAAAAA8ADwAPAA8AAAAPAA8ADwAAAA8ADwAPAA8AAAAAAAAADwAAAAAADw=");n(g,37396,"PAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8");n(g,37438,"PAA8");n(g,37466,"PAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8ADwAPAA8");n(g,37728,"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");n(g,44112,"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");n(g,49728,"vwC/AL4AwADBAMEAwQDBAMAAwADAAMAAwADFAMcAyQDJAMgAyADGAMYAzQDNAM8AzwDQANIA0gDSANMA1wDYANkA2QDZANkA2QDZANkA2QDZANkA2QDZANkA4gDiAN4A3gDgAOAA4wDjAOMA4wDkAOQA5ADkAOQA4QDhAOUA5QDlAMwA5wDoAOgA6ADoAOgA6wDcANwA7ADsAO0A7QDAAO8A7wDAAMAAwADOAM4AzgDxAPQA9AD0APIA8gD+APIAAAEAAfUA9QD1AAEB9gD2APYAAgECAfcA9wAEAQQBAwEDAQMBAwEDAcoAygDwAPAACQEJAQkBCQEFAQUBBQEFAQYBBgEGAQsBBwEHAfsA+wDpAOkA3QDdAN0ADAEMAQwB+QD5APoA+gD8APwA/AD8AMAA+AD4AA4BDgEOAQ4BwAAPAQ8BDwEPAcAAwAASARIBEgESARIBEgETARABEAERAREBCgEKAdsA2wDbANsA2gDaANoA2wDbANsA2wDbANsA2wDbANsA2gDbANsA2wDbANsA2wDbANsA2wAVAdsA2wDbANsA2wDbANsA2wDbANsA2wDbABYBFgHbABcBFwHbANsA2wDbANsA2wAaARoBGwEbARkBCAH/AP8AGAEYAcAAHAEcAd8A3wDqAOoAHQEdAcAAwADAAB4BHgHAAMAAwADAAMAA1QDWAMAAIAEiASIBIgEjASMBIwElASUBIQEhAScBKAEoASYBJgEmASYB2wDbAO4A7gDuAMAAwADAACoBKgHAAMAAwADAAMAAwADAACsBwADAAMAALQEvATABMAExAQ0BDQE0ATQBNAEzATUB8wDzADYBNwE4ATgBOAE4ATgBOQE5ATkBPQE/AT8BQAFAAT4BPgFBAUEBQgFCAUIB/QAUARQBFAE8ATwBOwHaALsAvAC8AL0AvQC9AMIAwgDCAMQAxADAAM0AywDLAMMAwwDSANMA1ADUANEA0QDZANkA2QDMAOYA5gDnAOsA7QDxAPIAAQECAQsBEwHbABUBGQEIAR8BHwEfAR8BHwHVACQBJAEnASgBKQEpASwBLAEuAS4BLwEyATIBMgENATYBOAE=");n(g,50560,"SwAAACQACgBeAAAANQAJAIcAAABeAAEAVgAAAFAAAAAJAAsAJwACAEcAAAB6AAAAQgBDAEQARQBGAAAAAAAAALtGAACsCAAAAEYAAPQlAACtLgAA+ywAAIBOAADNTwAAdU8AAAIECAYGAAAAAAByb3dfbnVtYmVyAGRlbnNlX3JhbmsAcmFuawBwZXJjZW50X3JhbmsAY3VtZV9kaXN0AG50aWxlAGxlYWQAbGFnAADuxQAATQAAAFsAAABWAAAA+cUAAFoAAABbAAAAVgAAAATGAABaAAAAWwAAAFYAAAAJxgAAXQAAAFYAAABbAAAAFsYAAF0AAABXAAAAWwAAACDGAABNAAAAVgAAAFsAAAAmxgAATQAAAFsAAABbAAAAK8YAAE0AAABbAAAAVgAAAENBRERFQgAA1zkAAAgAAACVRwAAM1AAADlQAAAAAAAAWHgAAJ1JAAC5TgAAuUkAAFxPAAC5TgAAAwQDBwQEAAAKCgkJCAgHBwcGBgYFBQUEBAQEAwMDAwMDAgICAgICAm50aF92YWx1ZQBmaXJzdF92YWx1ZQA6OAAAAAAAAAAAkTAAAEAAAACnRgAAQgAAAN84AABBAAAAvyYAAEMAAAAYFhUXAAAkIBgVFxYtKSgqJyYkIA==");n(g,51056,"lCUAAMklAAAvJQAAJiYAAFom");n(g,51088,"OgAAADoAAAA3AAAAOgAAADo=");n(g,51120,"bmF0dXJhbGVmdG91dGVyaWdodGZ1bGxpbm5lcmNyb3Nz");n(g,51169,"BwQGBCgKBSAOBTATBDgXBQEcBQMAAADJOgAAAwAAANsGAAAD");n(g,51216,"NAACAH8AAABhAAIAgAAAAHo=");n(g,51248,"AgAAAGMAAQMyAQgARwACAGwBAgEyAQgARwABALsAAABUAQE=");n(g,51296,"AgABAGMAAQQQAQAARgACAGQABwCfRgAAfAgAALcuAAAfGBERExQ=");n(g,51344,"VgEAADwBBAB2AAMAVAMBAEYAAAB2AAMACQADAAAAAADiWgAAAQAAAOdaAAABAAAAxzgAAAIAAABDOgAAAwAAAL84AAACAAAAOzoAAAMAAABRWwAAAAAAAEtb");n(g,51448,"AgABAGQAAAACAAAAYwABAFQBAQAAAAAAb25vZmZhbHNleWVzdHJ1ZXh0cmFmdWxsAAABAgQJDA8UAgIDBQMEBQQBAAAAAQEDAg==");n(g,51540,"3VoAALc4AAAzOgAAJV8AAAMAAAAB");n(g,51572,"4w==");n(g,51588,"xDAAAAAAAAB4AAAAEz4AAAAAAgCuMwAAAAAE");n(g,51632,"vycAAAEAAACIBgAAAgAAAJNEAAAGAAAAtwQAAIA=");n(g,51672,"AQAAAAE=");n(g,51688,"5A==");n(g,51704,"0jAAAAAAAAD4XAAADg4AALtbAAAAAAAAFFwAAAAAAAAEAAAAAQ==");n(g,51752,"5Q==");n(g,51768,"LQwAAAAAAAACAAAAAQ==");n(g,51792,"5g==");n(g,51808,"NTAAAAAAAAABAAAAAQ==");n(g,51832,"5w==");n(g,51848,"ZA0AAAAAAAC9/+QEwP9O/0v/oAAvBI8ASP+JANoA3ADeAFL/5QAMARABEwFEATD/8gDr/tn/UQAZAhgDKgMsA0P/LgM/A6MAYQOwA3cDSAPEAzUERf8kAXv/EgGhAi4CqgIbAykDEv8Y/xL/GP9JAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBSQFJAUkBLQLIArUDxgPJA8sD0wNJBEsETwR2BHgEkQSUBLEEswTMBNkE4gTlBOcE7QTyBPcEAgULBRwFHgUgBSoFMAVDBUoFTAVPBVIFVQVXBV4FYAVlBXkFewV+BYQFhgWJBY0FlAWnBakFrQW2BUkBSQFJAUkBSQFJAUkBSQFJAUkBSQHq/2H/2wEk//QCJgD1AUkDygJJAXYAUQFdAWsByP9JAUkBSQFJATP/M/8z/68CVP9+/8f/FgONARAC8f6IAFQCVAJaADwBCgIdAtv/ywJRA9EDdAJYA9QD3wM5BE4EbwQ7BF7/0ADqBBoDqv+fACkAVQSfAlQDTAOkA5cE5gTgAZwEZAACAfEE9ATABAcFdf89AVgBPwBTAacBMwJ8AqQCLQOMA5IDtgM2BDwESgRTBWgFfwWfBbgFmwH3Bf4F/wUBBgUGBgYHBggGCQYLBg0GDgbeA4wE1AUPBhAGFAbBBBYGFwYYBsEFhQUbBuYFIAYzAiIGIwYkBiUGJgYnBqMFugXuBekF6gXrBewFwQTuBe4F+wUaBi4GxQXhBecF/QXoBdAFAgblBe0FCgbvBRUG0QUdBhwGKgYyBjMGNAb2BfgFEgYTBigGKQYeBisGMAY3BvAF8wVRBlwGLAYtBmAGMQY2BjkGRAZFBkYGSAZJBmkGcQZKBjgGOgZLBjsGUAZMBlIGTQZzBnYGPAY+BncGfwZyBokGkAaNBpQGdQaABoIGgwZ+BoUGiAaMBpYGjwabBpkGnAaeBj0GPwZTBl4GowakBkIGTwZwBnkGmgaiBnoGwQZ0Bp8GpgaoBqcGzQbaBt4G6AbpBusGfAZ9BoEG2AbcBt0G3wbgBuQG0QbZBuIG4wbhBuwGAAABAAAAOXg=");n(g,52704,"9CUAAK0uAACsCAAAu0YAAM8t");n(g,52736,"MDEyMzQ1Njc4OUFCQ0RFRmxhc3RfdmFsdWUAAAwADgAYAB8AOwB4OQAAAAAAAAAABnNlY29uZAAkINNXAACAPwZtaW51dGUA2TPhVAAAcEIEaG91cgAAALA58FEAAGFFA2RheQAAAABa/KNKAMCoRwVtb250aAAAgGgsSAA0HkoEeWVhcgAAAADkZUbAmfBLCQoNIA==");n(g,52928,"AQEAAQEBAQABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQFpSQMFBwAAAM0xAAC2WgAAaUkIBQcAAAAcBAAAtloAAG5OAwAEAAAAPk4AAM8tAABxUQQABAAAAD1OAADPLQAAc1MEAAQAAAA4TgAAzy0=");n(g,53241,"AQEAAAE=");n(g,53264,"AQ==");n(g,53488,"Cww=");n(g,53512,"YnRuAGZy");n(g,53536,"zy0AAA4zAAAjNQAA9CUAAPQlAACtLgAArS4AAKwIAACsCAAArAgAAKwIAACCBQAAzw0AAFh4AABYeAAAWHgAAFh4AABUAQAAVQEAAFYBAABXAQAAWAEAAFkBAABaAQAAAAAAAAEAAAAAAAAAWwEAAFwBAABdAQAAXgEAAF8BAABgAQAAYQEAAGIBAABjAQAAZAEAAGUB");n(g,53696,"2CMAAOUjAAAAAAAAhj8AAMw8AABFPwAAWD8AAIoEAAApNQAA6DwAAPUjAACmPgAATCoAANQtAABoNwAApS0AAAAAAAB0QAAAVTEAAOg+AABuMAAABTQAAPo+AABxPwAAAAAAAP84AACjNQAAGTkAAC45AAABAgUKDxQZGRkyMmQAAQMIEiE1TmeAsuRmAQAAZwEAAGgBAAAEAAAAaQEAAGoBAABrAQAAbAEAAG0BAABuAQAAbwEAAHABAABxAQAAcgEAAHMBAAB0AQAAdQEAAHYBAAB3AQAAeAEAAHkBAAB6AQAAewEAAHwBAAB9AQAAfgEAAH8BAACAAQAAAAAAAIEBAACCAQAAgwEAAIQBAACFAQ==");n(g,53984,"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");n(g,56944,"Z1UAALhmAAAbbQAAUG0AAG1tAADcbgAAN20AANJSAAArXgAAgmcAAL1nAAD8ZgAAV1AAAMdQAAAZVQAAgFMAAO5UAADCUwAAEGMAAJNVAABSZwAA6lIAABlTAAAsZwAAWHgAAFh4AABJUwAAiG0AAKxdAADoawAAt1QAAJNSAABMVAAA/VMAABFPAAC4UQAAxW0AAE5RAABKUgAAVV0AAAAAAACQAQAAkQEAAJIBAACTAQAAlAE=");n(g,57136,"lQEAAJYBAACXAQAAmAEAAJkB");n(g,57168,"AQEBAQEBAQEBAQAAAAAAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQAAAAABAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAAAAAQEBAAEBAQABAQEBAQABAQEBAQABAQECAQAAAAAAAOAnAAAJAAAAxQUAAAYAAACfEAAACAAAAJ0QAAAKAAAAFiYAAAUAAAAUCwAABwAAALE7AAAKAAAAATwAAAo=");n(g,57380,"AQ==");n(g,57392,"AQEBAQEBAQEBAQAAAAAAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQAAAAABAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAACITAAAAgAEAC9QAAADAQMAtUkAAAMBAgDBTAAABAABAFwNAACaAQAAaRAAAJsBAACJMgAAnAEAAOAnAACdAQAAFAsAAEMyAAAWJAAA3Q8AABYOAAAAAAAAngEAAJ4BAACfAQAAoAEAAKABAAChAQAAogEAAKMBAACkAQAApQEAAKYBAACnAQ==");n(g,57664,"4DAAALAfAQCBOQAAFCABAAAAAgADAAUABgAHAAgACQAiXQAAwmEAAKZOAACdYAAA0FsAAI5dAACzXwAABlsAADxgAABJSwAA7VoAAH9cAAC2YAAAlVwAAIpfAAA9UAAAfEsAAFFcAABkSwAAkU8AAP1bAABbYAAAjWAAAHBgAADBXAAA1mAAAAFhAABSYQAAHmEAAKNfAABnOQAAN1sAAGhhAADqYAAAHVsAADxhAAB1XwAA10kAAFtOAAD0UQAANl0AAMdfAABSTwAArkkAABlKAAAQSgAACE8AAMtJAAAiUA==");n(g,57904,"/RIAAAEAAQC3AQAAMSwAAAEAAQC4AQAAsCwAAAEAAQC5AQAAYFwAAAIAAQC6AQAAZVwAAAIAAQC6AQAARTAAAAEAAQC7AQAASzAAAAEAAQC8AQAAUTAAAAEAAQC9AQAA+TkAAAIAAQC+AQAAMhcAAAEAAQC/AQAAaRQAAAEAAQDAAQAA/hIAAAEAAQDBAQAAMiwAAAEAAQDCAQAAsSwAAAEAAQDDAQAAMQoAAAEAAQDEAQAARjAAAAEAAQDFAQAATDAAAAEAAQDGAQAAUjAAAAEAAQDHAQAA8S8AAAEAAQDIAQAAwiYAAAEAAQDJAQAA+jAAAAEAAQDKAQAAVWAAAAEAAQDLAQAAPiQAAAIAAQDMAQAAcSwAAAEAAQDNAQAA4AkAAAEAAQDOAQAA9jUAAAEAAQDPAQAANC4AAAEAAQDQAQAABCQAAAEAAQDRAQAAuy8AAAAAAQHSAQAA+zMAAAIAAQDTAQAA8wUAAAIAAQDUAQAA8wUAAAMAAQDUAQAA8yIAAAIAAQDVAQAA6iIAAAIAAQDWAQAADzUAAAEAAQDXAQAA+iQAAAEAAQDYAQAAQC4AAAIAAQDZAQAAkSYAAAIAAQDaAQAAH0YAAAIAAQDbAQAAtSQAAAIAAQDcAQAASgcAAAEAAADdAQAA3gEAAAQ6AAABAAAA3QEAAN8BAACwOQAAAQAAAOABAADhAQAAtSwAAAEAAADgAQAA4gEAACw3AAABAAAA4AEAAOMBAAA7NwAAAQAAAOABAADkAQ==");n(g,58546,"AQIDAAECAAACAgQFBQABAgYCAwABAAIAAgAAAAAAAAABAgMAAQIAAAICBAUFAAECBgIDAAEAAgAC");n(g,58736,"BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAgICAgICAgICAgICAgICAgMDAwMDAwMDBAQEBAQEBAQAAAAAgDAAAIAgDgCAIMgDAAAAAID///8A+P//AAD//wAAAAAAAPA/AAAAAAAA+D8AAAAAAAAAAAbQz0Pr/Uw+");n(g,58939,"QAO44j/+gitlRxVnQAAAAAAAADhDAAD6/kIudr86O568mvcMvb39/////98/PFRVVVVVxT+RKxfPVVWlPxfQpGcREYE/AAAAAAAAyELvOfr+Qi7mPyTEgv+9v84/tfQM1whrrD/MUEbSq7KDP4Q6Tpvg11U/");n(g,59070,"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");n(g,63026,"pQJbAPABtQWMBSUBgwYdA5QE/wDHAzEDCwa8AY8BfwPKBCsA2gavAEIDTgPcAQ4EFQChBg0BlAILAjgGZAK8Av8CXQPnBAsHzwLLBe8F2wXhAh4GRQKFAIICbANvBPEA8wMYBdkA2gNMBlQCewGdA70EAABRABUCuwCzA20A/wGFBC8F+QQ4AGUBRgGfALcGqAFzAlMB");n(g,63224,"IQQAAAAAAAAAAC8C");n(g,63256,"NQRHBFYE");n(g,63278,"oAQ=");n(g,63298,"RgVgBW4FYQYAAM8BAAAAAAAAAADJBukG+QYeBzkHSQdeBw==");n(g,63344,"T7thBWes3T8YLURU+yHpP5v2gdILc+8/GC1EVPsh+T/iZS8ifyt6PAdcFDMmpoE8vcvweogHcDwHXBQzJqaRPBgtRFT7Iek/GC1EVPsh6b/SITN/fNkCQNIhM3982QLA");n(g,63455,"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");n(g,66259,"QPsh+T8AAAAALUR0PgAAAICYRvg8AAAAYFHMeDsAAACAgxvwOQAAAEAgJXo4AAAAgCKC4zYAAAAAHfNpNQL/AARkACAAAAT//xAAAQABAAEA//8B/wH//////wH/Af8B/wH/Af8B/wH/Af//////Cv8gAP//A/8B/wT/HgAAAQX//////2MAAAhjAOgDAgAAAP//////AAAAAf8B//////////////8=");n(g,66441,"BA==");n(g,66454,"Af8B//////8AASAABACAAAAI//8B/wH/////////Af8G/wf/CP8J//////+8ArwCAQD//wEAAQD//wAA//////////8=");n(g,66538,"FA==");n(g,66570,"//8BAAr///////////8B/wH/AAAAAAAAAf8B/wH/");n(g,66618,"Af8AAAAAAAAB/wH/AQAAAAEAAAAB//////8AAAAAAf///wAAAAD/////////////KAAK//////8BAAr/////AP//////////");n(g,66790,"Af8B////AQD//////////////////wr//////wz/Df8=");n(g,66836,"5gEAAOYBAADnAQAA5wEAAOcBAADnAQAA5wEAAOcBAADmAQAA5gEAAOcBAADmAQAA5gEAAOYBAADmAQ==");n(g,66928,"5wEAAOcBAADmAQAA5gEAAAAAAADmAQAAAAAAAOcB");n(g,67104,"AwAAADQAAAAAAgAAAAAAAKkFAABEegAAfQAAAH4AAAB/AAAAgA==");n(g,67160,"gQAAAIIAAACDAAAAhAAAAIUAAACGAAAAhwAAAIgAAAADAAAANAAAAAACAAAAAAAAYTYAAEh6AAB9AAAAfgAAAH8AAACA");n(g,67248,"gQAAAIIAAACDAAAAhAAAAIUAAACGAAAAhwAAAIgAAAADAAAANAAAAAACAAAAAAAASjcAAEx6AAB9AAAAfgAAAH8AAACA");n(g,67336,"gQAAAIIAAACDAAAAhAAAAIUAAACGAAAAhwAAAIgAAAADAAAANAAAAAACAAAAAAAARS4AAER6AAB9AAAAfgAAAH8AAACA");n(g,67424,"gQAAAIIAAACDAAAAhAAAAIUAAACGAAAAhwAAAIgAAAAAAABAAAAAAAEAAAABAAABAAEAAP7//38AAAAAsAQAACgAAAAAAAE=");n(g,67656,"FA==");n(g,67668,"+g==");n(g,67715,"QA==");n(g,67732,"/v//f////38=");n(g,67764,"Bw==");n(g,67776,"eywAAJ4AAAAAAAAAFzUAAJ8AAAAAAAAAcxEAAKAAAAAAAAAAbToAAKEAAAAAAAAAFg4AAKIAAAAAAAAAAA4AAKMAAAAAAAAA8TMAAKQAAAAAAAAAlC0AAKUAAAAAAAAAzkAAAKYAAAAAAAAAzUA=");n(g,67896,"9Vs=");n(g,67908,"fDMAAKcAAAAAAAAAezM=");n(g,67932,"7Fs=");n(g,67944,"kzoAAKgAAAAAAAAA5zM=");n(g,67968,"vS4AAKkAAAAAAAAAbgQAAKoAAAAAAAAAECQAAKsAAAAAAAAACiQAAKwAAAAAAAAACygAAK0AAAAAAAAAfTsAAK4AAAAAAAAAJicAAK8AAAAAAAAAHycAALAAAAAAAAAAKyc=");n(g,68076,"NzIAALEAAAAAAAAAxC4AALIAAAAAAAAA+g0AALMAAAAAAAAAmi0=");n(g,68136,"4SYAANgmAADlJgAA7GEAAAIAAAAAAAAAAAQAAAAAAADWRgAAAAAAAMgAAAAAAAAAyQAAAMoAAADLAAAAzAAAAM0AAADOAAAAzwAAANAAAAAAAAAA0QAAANI=");n(g,68240,"LUgAAAJSAAC6SQAAs0wAAF1PAACeSQ==");n(g,68272,"AgAAAAFIxAABAAAAAAAAAOg=");n(g,68304,"kAYAAAAAAAACAAAAAUjEAAMAAAAAAAAA6A==");n(g,68344,"/TUAAAAAAAACAAAAAUjEAAIAAAAAAAAA6A==");n(g,68384,"CCMAAAAAAAABAAAAAUjEAAQAAAAAAAAA6A==");n(g,68424,"JQQAAAAAAAABAAAAASCA");n(g,68448,"6Q==");n(g,68464,"eT0AAAAAAAABAAAAASCA");n(g,68488,"6g==");n(g,68504,"bQ0AAAAAAAABAAAAAQzAAGMAAAAAAAAA6A==");n(g,68544,"EAUAAAAAAAACAAAAAQzAAGMAAAAAAAAA6A==");n(g,68584,"iDoAAAAAAAABAAAAAQzAAGMAAAAAAAAA6A==");n(g,68624,"EgUAAAAAAAABAAAAAQiAAAEAAAAAAAAA6w==");n(g,68664,"MS0AAAAAAAACAAAAAQiAAAEAAAAAAAAA6w==");n(g,68704,"MS0AAAAAAAABAAAAAQiAAAIAAAAAAAAA6w==");n(g,68744,"Ky0AAAAAAAACAAAAAQiAAAIAAAAAAAAA6w==");n(g,68784,"Ky0AAAAAAAABAAAAAQiAAAMAAAAAAAAA6w==");n(g,68824,"Mi0AAAAAAAACAAAAAQiAAAMAAAAAAAAA6w==");n(g,68864,"Mi0AAAAAAAD9/wAAIQiA");n(g,68888,"7A==");n(g,68904,"UiwAAAAAAAABAAAAIRCACAAAAAAAAAAA7QAAAO4AAADvAAAAAAAAAFIsAAAAAAAA/f8AACEIgAABAAAAAAAAAOw=");n(g,68984,"TwYAAAAAAAABAAAAIRCACAEAAAAAAAAA7QAAAO4AAADvAAAAAAAAAE8GAAAAAAAAAQAAAIEIgA==");n(g,69048,"8A==");n(g,69064,"pjEAAAAAAAABAAAAgQiQ");n(g,69088,"8Q==");n(g,69104,"GDYAAAAAAAABAAAAQQiA");n(g,69128,"8g==");n(g,69144,"KTAAAAAAAAABAAAAwQiA");n(g,69168,"8w==");n(g,69184,"DjAAAAAAAAACAAAAAQiA");n(g,69208,"9A==");n(g,69224,"+yIAAAAAAAD//wAAAQiA");n(g,69248,"9Q==");n(g,69264,"nzEAAAAAAAD//wAAAQiA");n(g,69288,"9Q==");n(g,69304,"LA4AAAAAAAABAAAAAQiA");n(g,69328,"9g==");n(g,69344,"vDkAAAAAAAD//wAAAQiA");n(g,69368,"9w==");n(g,69384,"liYAAAAAAAABAAAAAQiA");n(g,69408,"+A==");n(g,69424,"bBcAAAAAAAABAAAAAQiA");n(g,69448,"+Q==");n(g,69464,"mjoAAAAAAAACAAAAAQiA");n(g,69488,"+Q==");n(g,69504,"mjoAAAAAAAABAAAAAQiA");n(g,69528,"+g==");n(g,69544,"9CQAAAAAAAABAAAAAQiA");n(g,69568,"+w==");n(g,69584,"RCQAAAAAAAABAAAAAQiA");n(g,69608,"/A==");n(g,69624,"7wUAAAAAAAABAAAAAQiA");n(g,69648,"/Q==");n(g,69664,"7QUAAAAAAAACAAAAAQiA");n(g,69688,"/Q==");n(g,69704,"7QUAAAAAAAD9/wAAAQiA");n(g,69728,"/g==");n(g,69744,"OQ4AAAAAAAD8/wAAAQiA");n(g,69768,"/w==");n(g,69784,"iw4AAAAAAAACAAAAAQjA");n(g,69808,"6A==");n(g,69824,"wy0=");n(g,69836,"AQCA");n(g,69849,"AQ==");n(g,69864,"HS0AAAAAAAABAAAAAQCA");n(g,69888,"AQE=");n(g,69904,"tUYAAAAAAAACAAAAIQiA");n(g,69928,"AgE=");n(g,69944,"1jE=");n(g,69956,"ASCA");n(g,69968,"6A==");n(g,69984,"9yo=");n(g,69996,"ASCA");n(g,70008,"AwE=");n(g,70024,"0TsAAAAAAAACAAAAAQiA");n(g,70048,"BAE=");n(g,70064,"8zAAAAAAAAABAAAAAQiA");n(g,70088,"BQE=");n(g,70104,"dTM=");n(g,70116,"AQCA");n(g,70128,"BgE=");n(g,70144,"+To=");n(g,70156,"AQCA");n(g,70168,"BwE=");n(g,70184,"Khc=");n(g,70196,"AQCA");n(g,70208,"CAE=");n(g,70224,"JBcAAAAAAAADAAAAAQiA");n(g,70248,"CQE=");n(g,70264,"KzoAAAAAAAABAAAAAQiA");n(g,70288,"CgE=");n(g,70304,"rEYAAAAAAAACAAAAAQiA");n(g,70328,"CwE=");n(g,70344,"ASMAAAAAAAADAAAAAQiA");n(g,70368,"CwE=");n(g,70384,"ASMAAAAAAAACAAAAAQiA");n(g,70408,"CwE=");n(g,70424,"MzEAAAAAAAADAAAAAQiA");n(g,70448,"CwE=");n(g,70464,"MzEAAAAAAAABAAAAAQCA");n(g,70488,"DAEAAA0BAAANAQAADgEAAPcsAAAAAAAAAQAAAAEAgA==");n(g,70528,"DAEAAA8BAAAPAQAADgEAAF8uAAAAAAAAAQAAAAEAgA==");n(g,70568,"DAEAABABAAAQAQAADgEAAOow");n(g,70596,"AQGACAAAAAAAAAAAEQEAABIBAAASAQAAEwEAAGQKAAAAAAAAAQAAAAEAgAgAAAAAAAAAABEBAAASAQAAEgEAABMBAABkCgAAAAAAAAEAAAABAIA=");n(g,70688,"FAEAABUBAAAWAQAAFwEAADMOAAAAAAAAAgAAAAEAgA==");n(g,70728,"FAEAABUBAAAWAQAAFwEAADMOAAAAAAAAAgAAAAEAgA==");n(g,70768,"FAEAABUBAAAWAQAAFwEAAGwxAAAAAAAAAgAAAA0IgACoegAAAAAAACs=");n(g,70824,"p0YAAAAAAAACAAAABQiAAKx6AAAAAAAAKw==");n(g,70864,"3zgAAAAAAAADAAAABQiAAKx6AAAAAAAAKw==");n(g,70904,"3zgAAAAAAAABAAAAAQiA");n(g,70928,"GAE=");n(g,70944,"cSwAAAAAAAD8/wAAAQjA");n(g,70968,"6A==");n(g,70984,"1zkAAAAAAAD8/wAAAQjAAAUAAAAAAAAA6A==");n(g,71024,"3TEAAAAAAAD8/wAAAQjAAAUAAAAAAAAA6A==");n(g,71064,"3jEAAAAAAAAJAAAAAQiE");n(g,71088,"GQE=");n(g,71104,"NSsAAAAAAAAHAAAAAQiE");n(g,71128,"GgE=");n(g,71144,"rDcAAAAAAAAHAAAAAQiE");n(g,71168,"GwE=");n(g,71184,"pgkAAAAAAAADAAAAAQiE");n(g,71208,"HAE=");n(g,71224,"IisAAAAAAAACAAAAAQiE");n(g,71248,"HQE=");n(g,71264,"rgU=");n(g,71284,"AQCB");n(g,71296,"HgEAAB8BAAAfAQAAXgAAAO7F");n(g,71324,"AQCB");n(g,71336,"IAEAACEBAAAhAQAAXgAAAPnF");n(g,71364,"AQCB");n(g,71376,"IgEAACMBAAAjAQAAXgAAAATG");n(g,71404,"AQCB");n(g,71416,"JAEAACUBAAAlAQAAJgEAAAnG");n(g,71444,"AQCB");n(g,71456,"JwEAACgBAAAoAQAAKQEAABbGAAAAAAAAAQAAAAEAgQ==");n(g,71496,"KgEAACsBAAArAQAALAEAACDGAAAAAAAAAQAAAAEAgQ==");n(g,71536,"LQEAAC4BAAAvAQAAMAEAABDOAAAAAAAAAgAAAAEAgQ==");n(g,71576,"MQEAADIBAAAzAQAAXgAAABDHAAAAAAAAAQAAAAEAgQ==");n(g,71616,"NAEAADUBAAAzAQAAXgAAABrHAAAAAAAAAQAAAAEAgQ==");n(g,71656,"XgAAADMBAAAzAQAAXgAAACbGAAAAAAAAAgAAAAEAgQ==");n(g,71696,"XgAAADMBAAAzAQAAXgAAACbGAAAAAAAAAwAAAAEAgQ==");n(g,71736,"XgAAADMBAAAzAQAAXgAAACbGAAAAAAAAAQAAAAEAgQ==");n(g,71776,"XgAAADMBAAAzAQAAXgAAACvGAAAAAAAAAgAAAAEAgQ==");n(g,71816,"XgAAADMBAAAzAQAAXgAAACvGAAAAAAAAAwAAAAEAgQ==");n(g,71856,"XgAAADMBAAAzAQAAXgAAACvG");n(g,71888,"//8AAAEogACIBwEAAAAAADYB");n(g,71920,"iAUAAAAAAAD//wAAASiAAIgHAQAAAAAANwE=");n(g,71960,"ujAAAAAAAAD//wAAASiAAIgHAQAAAAAAOAE=");n(g,72e3,"4jMAAAAAAAD//wAAASiAAIgHAQAAAAAAOQE=");n(g,72040,"rzYAAAAAAAD//wAAASiAAIgHAQAAAAAAOgE=");n(g,72080,"njYAAAAAAAD//wAAASiAAIgHAQAAAAAAOwE=");n(g,72120,"lTYAAAAAAAACAAAAASiAAIgHAQAAAAAAPAE=");n(g,72160,"5TE=");n(g,72172,"ASCA");n(g,72184,"PQE=");n(g,72200,"pzY=");n(g,72212,"ASCA");n(g,72224,"PgE=");n(g,72240,"7yY=");n(g,72252,"ASCA");n(g,72264,"PwE=");n(g,72280,"2jMAAAAAAAABAAAAAYiAAQAAAAAAAAAAQAE=");n(g,72320,"JSgAAAAAAAABAAAAAYiAAAgAAAAAAAAAQAE=");n(g,72360,"xUYAAAAAAAD//wAAAQiQAQAAAAAAAAAAQQE=");n(g,72400,"cQUAAAAAAAD//wAAAQiQAQgAAAAAAAAAQQE=");n(g,72440,"fAUAAAAAAAABAAAAAYiA");n(g,72464,"QgE=");n(g,72480,"/C8AAAAAAAACAAAAAYiA");n(g,72504,"QgE=");n(g,72520,"/C8AAAAAAAABAAAAAYiA");n(g,72544,"QwE=");n(g,72560,"dygAAAAAAAD//wAAAYiAAQAAAAAAAAAARAE=");n(g,72600,"1g0AAAAAAAD//wAAAYiAAAgAAAAAAAAARAE=");n(g,72640,"4w0AAAAAAAACAAAAAYiAAQEAAAAAAAAARAE=");n(g,72680,"3VUAAAAAAAACAAAAAYiAAAIAAAAAAAAARAE=");n(g,72720,"2VUAAAAAAAD//wAAAYiQAQAAAAAAAAAARQE=");n(g,72760,"+QkAAAAAAAD//wAAAYiQAAgAAAAAAAAARQE=");n(g,72800,"BQoAAAAAAAD//wAAAQiQAQAAAAAAAAAARgE=");n(g,72840,"vQ0AAAAAAAD//wAAAQiQAQgAAAAAAAAARgE=");n(g,72880,"yQ0AAAAAAAACAAAAAYiAAQAAAAAAAAAARwE=");n(g,72920,"VzAAAAAAAAACAAAAAYiAAAgAAAAAAAAARwE=");n(g,72960,"YjAAAAAAAAABAAAAAYiA");n(g,72984,"SAE=");n(g,73e3,"EAQAAAAAAAACAAAAAYiA");n(g,73024,"SAE=");n(g,73040,"EAQAAAAAAAABAAAAAQiQAQAAAAAAAAAASQE=");n(g,73080,"cDMAAAAAAAD//wAAAYiAAQAAAAAAAAAAQAE=");n(g,73120,"kjIAAAAAAAD//wAAAYiAAAgAAAAAAAAAQAE=");n(g,73160,"njIAAAAAAAD//wAAAYiQAQAAAAAAAAAASgE=");n(g,73200,"GDoAAAAAAAD//wAAAYiQAAgAAAAAAAAASgE=");n(g,73240,"JToAAAAAAAD//wAAAYiQAQQAAAAAAAAARQE=");n(g,73280,"7QwAAAAAAAD//wAAAYiQAAwAAAAAAAAARQE=");n(g,73320,"9gwAAAAAAAABAAAAAYiA");n(g,73344,"SwE=");n(g,73360,"QTYAAAAAAAACAAAAAYiA");n(g,73384,"SwE=");n(g,73400,"QTYAAAAAAAABAAAAAYiA");n(g,73424,"TAE=");n(g,73440,"jTsAAAAAAAACAAAAAYiA");n(g,73464,"TAE=");n(g,73480,"jTsAAAAAAAABAAAAAQiQAQAAAAAAAAAATQEAAE4BAABPAQAAUAEAAE4FAAAAAAAAAQAAAAEIkAEIAAAAAAAAAE0BAABOAQAATwEAAFABAABfBQAAAAAAAAIAAAABCJABAAAAAAAAAABRAQAAUgEAAFMBAABQAQAAmA0AAAAAAAACAAAAAQiQAQgAAAAAAAAAUQEAAFIBAABTAQAAUAEAAKoN");n(g,73656,"qAEAAKkBAACqAQAAAAAAAKsBAACsAQAArQEAAK4BAACvAQAAsAEAALEB");n(g,73756,"qAEAAKkBAACqAQAAAAAAALIBAACsAQAArQEAAK4BAACvAQAAsAEAALEB");n(g,73848,"sCVR")}var t=new ArrayBuffer(16);var u=new Int32Array(t);var v=new Float32Array(t);var w=new Float64Array(t);function x(y){return u[y]}function z(y,A){u[y]=A}function B(){return w[0]}function C(A){w[0]=A}function D(E,A,F){E=E>>>0;F=F>>>0;if(E+F>g.length)throw"trap: invalid memory.fill";g.fill(A,E,E+F)}function G(E,H,F){g.copyWithin(E,H,H+F)}function I(){throw new Error("abort")}function Za(s){var J=new ArrayBuffer(22151168);var K=new Int8Array(J);var L=new Int16Array(J);var M=new Int32Array(J);var N=new Uint8Array(J);var O=new Uint16Array(J);var P=new Uint32Array(J);var Q=new Float32Array(J);var R=new Float64Array(J);var S=Math.imul;var T=Math.fround;var U=Math.abs;var V=Math.clz32;var W=Math.min;var X=Math.max;var Y=Math.floor;var Z=Math.ceil;var _=Math.trunc;var $=Math.sqrt;var aa=s.a;var ba=aa.a;var ca=aa.b;var da=aa.c;var ea=aa.d;var fa=aa.e;var ga=aa.f;var ha=aa.g;var ia=aa.h;var ja=aa.i;var ka=aa.j;var la=aa.k;var ma=aa.l;var na=aa.m;var oa=aa.n;var pa=aa.o;var qa=aa.p;var ra=aa.q;var sa=aa.r;var ta=aa.s;var ua=aa.t;var va=aa.u;var wa=aa.v;var xa=aa.w;var ya=aa.x;var za=aa.y;var Aa=aa.z;var Ba=aa.A;var Ca=aa.B;var Da=aa.C;var Ea=aa.D;var Fa=aa.E;var Ga=aa.F;var Ha=aa.G;var Ia=aa.H;var Ja=aa.I;var Ka=aa.J;var La=aa.K;var Ma=aa.L;var Na=5318064;var Oa=0;var Pa=0;var Qa=0;
// EMSCRIPTEN_START_FUNCS
function bs(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0,J=0,Q=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0;h=Na-560|0;Na=h;p=M[a+88>>2];u=M[a+104>>2];j=M[a>>2];v=N[j+84|0];if(M[a+160>>2]){Ku(a)}if(M[j+372>>2]){b=M[j+380>>2];C=b-(P[a+180>>2]%(b>>>0)|0)|0;E=0}else{C=-1;E=-1}a:{b:{c:{d:{e:{if(M[a+36>>2]==7){f=u;break e}M[a+56>>2]=0;M[a+60>>2]=0;M[a+36>>2]=0;M[j+456>>2]=0;if(M[j+296>>2]){g=9;f=u;break b}$=j+492|0;ea=a+164|0;W=a+216|0;fa=j+388|0;y=a+124|0;ga=a+236|0;f=S(M[a+32>>2],20)+u|0;aa=h+480|0;ba=h+520|0;ha=h+372|0;ia=h+376|0;while(1){c=J;Q=Q+1|0;J=Q?c:c+1|0;f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{va:{wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{Ka:{La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{Ua:{Va:{Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{nb:{ob:{pb:{qb:{rb:{sb:{tb:{ub:{vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{Gb:{Hb:{Ib:{Jb:{Kb:{Lb:{Mb:{Nb:{Ob:{Pb:{Qb:{Rb:{Sb:{Tb:{Ub:{Vb:{Wb:{Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{ic:{jc:{kc:{lc:{mc:{nc:{oc:{pc:{qc:{rc:{sc:{tc:{uc:{vc:{wc:{xc:{yc:{zc:{Ac:{Bc:{Cc:{Dc:{Ec:{Fc:{c=N[f|0];switch(c|0){case 8:case 184:break Lb;case 126:break ka;case 127:break la;case 128:break ma;case 129:break na;case 130:break oa;case 131:break pa;case 132:break qa;case 133:break ra;case 134:break sa;case 135:break ta;case 9:break h;case 136:break ua;case 138:break Ga;case 139:break Ha;case 140:break Ia;case 141:case 142:break Ja;case 143:break Ka;case 144:break Ma;case 145:break Na;case 146:break Oa;case 147:break Pa;case 10:break Ec;case 148:break Qa;case 149:break Ra;case 150:break Sa;case 151:break Ta;case 152:break Ua;case 153:break Va;case 154:break wc;case 155:break Wa;case 156:break Xa;case 157:break $a;case 11:break Cc;case 158:break ab;case 159:break cb;case 160:break eb;case 161:case 162:break ib;case 163:break Fc;case 164:case 165:break jb;case 166:break ob;case 167:break pb;case 168:break qb;case 169:break rb;case 12:break Bc;case 170:break sb;case 171:break tb;case 172:break ub;case 173:break vb;case 174:break wb;case 175:break xb;case 176:break zb;case 177:break Bb;case 178:break Db;case 179:break Eb;case 13:break ec;case 180:break Gb;case 181:break Hb;case 182:break Ib;case 183:break Jb;case 14:break _b;case 15:break Vb;case 16:break Ub;case 17:break Tb;case 0:break K;case 18:break Rb;case 19:break Xb;case 20:break Ob;case 21:case 22:case 23:case 24:break $;case 25:break da;case 26:break fa;case 27:case 28:case 29:break ea;case 30:break ia;case 31:break ja;case 32:case 137:break va;case 1:break L;case 33:break wa;case 34:case 35:break ya;case 36:break xa;case 37:break Da;case 38:break Fa;case 39:break Ea;case 40:case 41:case 42:case 45:break La;case 43:case 44:break Zb;case 46:break Ya;case 47:break Za;case 2:break M;case 48:break _a;case 49:break bb;case 50:break db;case 51:break Sb;case 52:break Pb;case 53:case 54:case 55:case 56:case 57:case 58:break bc;case 59:break ac;case 60:break fb;case 61:break gb;case 62:break nb;case 3:break kb;case 63:break Ab;case 64:break Kb;case 65:case 66:break Fb;case 67:break Dc;case 68:break Mb;case 69:break Ac;case 70:break zc;case 71:break yc;case 72:break xc;case 73:break uc;case 4:break lb;case 74:case 75:break tc;case 76:break sc;case 77:break rc;case 78:break qc;case 79:break pc;case 80:break oc;case 81:break nc;case 82:break mc;case 83:break lc;case 84:break kc;case 5:break mb;case 85:break hc;case 86:break fc;case 87:break dc;case 88:break cc;case 90:break $b;case 91:break Yb;case 92:break Qb;case 94:break Nb;case 95:break C;case 6:break yb;case 96:break D;case 97:break E;case 98:break F;case 99:break N;case 100:break P;case 101:break S;case 102:case 113:break R;case 103:case 104:case 105:case 106:break gc;case 107:case 108:case 109:case 110:case 111:break ic;case 112:break jc;case 7:break Cb;case 114:break T;case 115:break Wb;case 116:case 117:break U;case 118:break vc;case 119:break V;case 120:break W;case 121:break X;case 122:break Y;case 124:break ba;case 125:break ca;default:break f}}i=M[f+16>>2];break hb}b=S(M[f+4>>2],40)+p|0;d=(f-u|0)/20|0;M[b>>2]=d;M[b+4>>2]=d>>31;L[b+16>>1]=4;break h}b=S(M[f+4>>2],40)+p|0;if(!(N[b+16|0]&4)){break f}f=S(M[b>>2],20)+u|0;break f}d=M[f+12>>2];b=S(M[f+4>>2],40)+p|0;L[b+16>>1]=4;d=d-1|0;M[b>>2]=d;M[b+4>>2]=d>>31;if(!M[f+8>>2]){break f}break i}b=S(M[f+4>>2],40)+p|0;L[b+16>>1]=4;d=M[b>>2];c=(f-u|0)/20|0;M[b>>2]=c;M[b+4>>2]=c>>31;f=S(d,20)+u|0;break f}if(!(K[(S(M[f+12>>2],40)+p|0)+16|0]&1)){break f}}d=M[f+4>>2];b=M[W>>2];if(!(d|!b)){M[a+216>>2]=M[b+4>>2];M[a+224>>2]=M[a+224>>2]-1;d=M[a+44>>2];c=M[a+40>>2];M[j+104>>2]=c;M[j+108>>2]=d;k=M[j+112>>2];e=k+c|0;c=M[j+116>>2]+d|0;M[j+112>>2]=e;M[j+116>>2]=e>>>0<k>>>0?c+1|0:c;b=Mu(b);u=M[a+104>>2];d=u;if(M[f+8>>2]==4){b=M[(S(b,20)+d|0)+8>>2]-1|0}f=S(b,20)+d|0;p=M[a+88>>2];break f}M[a+36>>2]=d;K[a+148|0]=M[f+8>>2];if(d){b=M[f+12>>2];Gc:{if(!(N[f+1|0]|(b|0)<=0)){ma=h,na=zj(S(b,40)+p|0,1),M[ma+48>>2]=na;Qc(a,8932,h+48|0);break Gc}b=O[f+2>>1];if(b){M[h+96>>2]=M[(b<<2)+34492>>2];Qc(a,16071,h+96|0);b=M[f+16>>2];if(!b){break Gc}d=M[y>>2];M[h+84>>2]=b;M[h+80>>2]=d;ma=y,na=tb(j,7440,h+80|0),M[ma>>2]=na;break Gc}M[h+64>>2]=M[f+16>>2];Qc(a,8932,h- -64|0)}b=M[f+4>>2];d=M[a+200>>2];M[h+40>>2]=M[a+124>>2];M[h+36>>2]=d;M[h+32>>2]=(f-u|0)/20;Lc(b,8866,h+32|0)}q=5;if((Bj(a)|0)==5){break k}q=M[a+36>>2]?1:101;break j}b=Kc(a,f);d=M[f+4>>2];M[b>>2]=d;M[b+4>>2]=d>>31;break f}b=Kc(a,f);d=M[f+16>>2];c=M[d+4>>2];M[b>>2]=M[d>>2];M[b+4>>2]=c;break f}b=Kc(a,f);L[b+16>>1]=8;R[b>>3]=R[M[f+16>>2]>>3];break f}b=Kc(a,f);d=M[f+16>>2];e=jb(d);M[f+4>>2]=e;if((v|0)!=1){if(Bd(b,d,-1,-1,1,0)){break s}if(Yd(b,v)){break e}q=0;M[b+24>>2]=0;L[b+16>>1]=O[b+16>>1]|8192;if(N[f+1|0]==250){eb(j,M[f+16>>2])}K[f+1|0]=250;M[f+16>>2]=M[b+8>>2];e=M[b+12>>2];M[f+4>>2]=e}if(M[j+120>>2]<(e|0)){break s}K[f|0]=73}b=Kc(a,f);L[b+16>>1]=8706;M[b+8>>2]=M[f+16>>2];d=M[f+4>>2];K[b+18|0]=v;M[b+12>>2]=d;d=M[f+12>>2];if((d|0)<=0){break f}d=S(d,40)+p|0;if(M[d>>2]!=O[f+2>>1]|M[d+4>>2]){break f}L[b+16>>1]=8720;break f}c=Kc(a,f);b=M[f+8>>2];d=M[f+12>>2];e=M[f+4>>2];M[c+12>>2]=0;k=e?257:1;L[c+16>>1]=k;e=d-b|0;while(1){if((e|0)<=0){break f}b=c+40|0;dc(b);M[c+52>>2]=0;L[c+56>>1]=k;e=e-1|0;c=b;continue}}b=S(M[f+4>>2],40)+p|0;L[b+16>>1]=O[b+16>>1]&65472|1;break f}b=Kc(a,f);d=M[f+4>>2];c=M[f+16>>2];Hc:{if(!c){zp(b,d);if(!ue(b)){break Hc}break e}Bd(b,c,d,d>>31,0,0)}K[b+18|0]=v;break f}d=(M[a+100>>2]+S(M[f+4>>2],40)|0)-40|0;if(Bp(d)){break s}b=S(M[f+8>>2],40)+p|0;if(N[b+17|0]&144){dc(b)}c=M[d+16>>2];M[b+16>>2]=c;e=M[d+4>>2];M[b>>2]=M[d>>2];M[b+4>>2]=e;e=M[d+12>>2];M[b+8>>2]=M[d+8>>2];M[b+12>>2]=e;L[b+16>>1]=c&36799|8256;break f}c=S(M[f+8>>2],40)+p|0;e=S(M[f+4>>2],40)+p|0;i=M[f+12>>2];while(1){Cw(c,e);if(N[c+17|0]&64){if(lg(c)){break e}}c=c+40|0;e=e+40|0;i=i-1|0;if(i){continue}break}break f}c=S(M[f+8>>2],40)+p|0;e=S(M[f+4>>2],40)+p|0;i=M[f+12>>2];while(1){Lg(c,e,16384);k=O[c+16>>1];if(k&16384){if(lg(c)){break e}k=O[c+16>>1]}if(!(!(k&2048)|!(N[f+2|0]&2))){L[c+16>>1]=k&63487}if(!i){break f}e=e+40|0;c=c+40|0;i=i-1|0;continue}}Lg(S(M[f+8>>2],40)+p|0,S(M[f+4>>2],40)+p|0,16384);break f}b=S(M[f+4>>2],40)+p|0;Fc(S(M[f+8>>2],40)+p|0,M[b>>2],M[b+4>>2]);break f}q=0;g=$i(a,0);if(!g){break f}break b}M[a+28>>2]=(M[a+28>>2]|1)+2;M[a+120>>2]=S(M[f+4>>2],40)+p;if(N[j+87|0]){break e}if(N[j+94|0]&4){Ra[M[j+212>>2]](4,M[j+216>>2],a,0)|0}M[a+32>>2]=((f-u|0)/20|0)+1;q=100;break j}i=M[f+12>>2];b=S(i,40)+p|0;o=M[f+8>>2];d=S(o,40)+p|0;k=O[d+16>>1];c=S(M[f+4>>2],40)+p|0;n=O[c+16>>1];if((k|n)&1){dc(b);break f}Ic:{Jc:{if(!(n&18)){if(!Kh(c,v,0)){break Jc}break e}if(!(n&1024)){break Ic}if(ue(c)){break e}}n=O[c+16>>1]&-3;k=O[d+16>>1]}Kc:{Lc:{if(!(k&18)){if(!Kh(d,v,0)){break Lc}break e}if(!(k&1024)){break Kc}if(ue(d)){break e}}k=O[d+16>>1]&-3}e=M[d+12>>2]+M[c+12>>2]|0;if((e|0)>M[j+120>>2]){break s}i=(i|0)==(o|0);if(qh(b,e+2|0,i)){break e}L[b+16>>1]=O[b+16>>1]&62016|2;if(!i){i=M[d+12>>2];if(i){G(M[b+8>>2],M[d+8>>2],i)}L[d+16>>1]=k}k=M[c+12>>2];if(k){G(M[b+8>>2]+M[d+12>>2]|0,M[c+8>>2],k)}L[c+16>>1]=n;d=v>>>0>1?e&-2:e;K[d+M[b+8>>2]|0]=0;K[(d+M[b+8>>2]|0)+1|0]=0;K[b+18|0]=v;M[b+12>>2]=d;L[b+16>>1]=O[b+16>>1]|512;break f}i=S(M[f+12>>2],40)+p|0;o=S(M[f+4>>2],40)+p|0;b=O[o+16>>1];m=S(M[f+8>>2],40)+p|0;d=O[m+16>>1];if(b&d&4){break o}if((b|d)&1){break m}if(!(Du(o)&Du(m)&4)){break n}c=N[f|0];break o}b=M[f+4>>2];if(!b){break f}Fc(S(b,40)+p|0,0,0);break f}k=S(M[f+12>>2],40)+p|0;b=S(M[f+8>>2],40)+p|0;c=S(M[f+4>>2],40)+p|0;if((O[b+16>>1]|O[c+16>>1])&1){dc(k);break f}d=sb(b);b=Qa;e=sb(c);c=Qa;Mc:{Nc:{Oc:{Pc:{i=N[f|0];switch(i-103|0){case 0:break Pc;case 1:break Oc;default:break Nc}}d=d&e;b=b&c;break Mc}d=d|e;b=b|c;break Mc}if(!(c|e)){break Mc}l=-45-i|0;m=i;n=(c|0)<0;i=n;o=i?l:m;m=0-(((e|0)!=0)+c|0)|0;l=e>>>0<=4294967232&i|(c|0)<-1;e=i?l?64:0-e|0:e;c=i?l?0:m:c;if((c|0)>0){c=1}else{c=(c|0)>=0&e>>>0>=64}if(c){b=(o&255)!=105&(b|0)<0;d=0-b|0;b=0-((b|0)!=0)|0;break Mc}if((o&255)==105){o=d;i=e&31;if((e&63)>>>0>=32){c=d<<i;d=0}else{c=(1<<i)-1&o>>>32-i|b<<i;d=o<<i}b=c;break Mc}i=d;d=e&31;if((e&63)>>>0>=32){c=0;d=b>>>d|0}else{c=b>>>d|0;d=((1<<d)-1&b)<<32-d|i>>>d}if((b|0)>0|(b|0)>=0){b=c;break Mc}b=64-e|0;e=b&31;if((b&63)>>>0>=32){b=-1<<e;e=0}else{b=(1<<e)-1&-1>>>32-e;e=-1<<e;b=b|e}d=e|d;b=b|c}M[k>>2]=d;M[k+4>>2]=b;L[k+16>>1]=O[k+16>>1]&62016|4;break f}b=S(M[f+4>>2],40)+p|0;Jh(b);c=M[f+8>>2];d=c+M[b>>2]|0;m=M[b+4>>2]+(c>>31)|0;M[b>>2]=d;M[b+4>>2]=c>>>0>d>>>0?m+1|0:m;break f}Qc:{b=S(M[f+4>>2],40)+p|0;e=O[b+16>>1];if(e&4){break Qc}oe(b,67,v);e=O[b+16>>1];if(e&4){break Qc}if(M[f+8>>2]){break i}g=20;break b}L[b+16>>1]=e&62016|4;break f}b=S(M[f+4>>2],40)+p|0;if(!(N[b+16|0]&36)){break f}Cu(b);break f}b=S(M[f+4>>2],40)+p|0;if(N[b+17|0]&4){g=ue(b);if(g){break b}}g=Bu(b,N[f+8|0],v);break O}o=M[f+12>>2];k=S(o,40)+p|0;e=O[k+16>>1];m=M[f+4>>2];i=S(m,40)+p|0;n=O[i+16>>1];l=e&n;if(l&4){b=M[k>>2];d=M[i>>2];e=M[k+4>>2];k=M[i+4>>2];if(b>>>0>d>>>0&(e|0)>=(k|0)|(e|0)>(k|0)){if(N[c+31239|0]){break i}break p}if(b>>>0<d>>>0&(e|0)<=(k|0)|(e|0)<(k|0)){if(N[c+31227|0]){break i}A=-1;break f}if(N[c+31233|0]){break i}break q}b=O[f+2>>1];Rc:{Sc:{Tc:{d=e|n;Uc:{if(d&1){if(b&128){A=1;if(!(!(l&1)|e&256)){A=0;b=31233;break Rc}if(!(e&1)){break Sc}A=-1;break Uc}if(b&16){break i}break p}b=b&71;Vc:{if(b>>>0>=67){if(!(d&2)){break Vc}if((n&46)==2){tj(i,0);e=O[k+16>>1]}if((e&46)!=2){break Vc}tj(k,0);break Vc}if(!(d&2)|(b|0)!=66){break Vc}Wc:{Xc:{Yc:{if(n&2){L[i+16>>1]=n&65491;break Yc}if(n&44){break Xc}}c=e;break Wc}Kh(i,v,1);n=O[i+16>>1]&-3520|n&3517;c=(m|0)==(o|0)?n|2:e;e=c&65535}Zc:{_c:{if(e&2){L[k+16>>1]=O[k+16>>1]&65491;break _c}if(e&44){break Zc}}e=c;break Vc}Kh(k,v,1);e=O[k+16>>1]&-3520|c&3517}A=Ih(k,i,M[f+16>>2]);c=N[f|0];if((A|0)>=0){break Tc}}b=31227;break Rc}if(A){break Sc}A=0;b=31233;break Rc}b=31239}L[k+16>>1]=e;L[i+16>>1]=n;if(N[(c&255)+b|0]){break i}break f}if(A){break f}A=0;break i}c=0;i=0;i=K[f+2|0]&1?M[f-4>>2]+4|0:i;b=M[f+12>>2];o=(b|0)>0?b:0;k=M[f+16>>2];m=k+20|0;l=S(M[f+8>>2],40)+p|0;d=S(M[f+4>>2],40)+p|0;while(1){if((c|0)==(o|0)){break f}n=N[M[k+16>>2]+c|0];b=S(i?M[(c<<2)+i>>2]:c,40);r=b+d|0;b=b+l|0;e=Ih(r,b,M[m+(c<<2)>>2]);if(e){d=n&1;e=!(N[M[k+16>>2]+c|0]&2)|!(K[r+16|0]&1|K[b+16|0]&1)?e:0-e|0;A=d?0-e|0:e;break f}else{c=c+1|0;A=0;continue}}}if((A|0)<0){f=(S(M[f+4>>2],20)+u|0)-20|0;break f}if(!A){f=(S(M[f+8>>2],20)+u|0)-20|0;break q}f=(S(M[f+12>>2],20)+u|0)-20|0;break f}b=Hh(S(M[f+4>>2],40)+p|0,2);c=Hh(S(M[f+8>>2],40)+p|0,2);d=S(M[f+12>>2],40)+p|0;b=N[(S(b,3)+c|0)+(N[f|0]==44?34512:34521)|0];if((b|0)==2){L[d+16>>1]=O[d+16>>1]&62016|1;break f}M[d>>2]=b;M[d+4>>2]=0;L[d+16>>1]=O[d+16>>1]&62016|4;break f}c=S(M[f+8>>2],40)+p|0;b=Hh(S(M[f+4>>2],40)+p|0,M[f+12>>2])^M[f+16>>2];Fc(c,b,b>>31);break f}b=S(M[f+8>>2],40)+p|0;d=S(M[f+4>>2],40)+p|0;if(!(K[d+16|0]&1)){Fc(b,!Hh(d,0),0);break f}dc(b);break f}d=M[f+4>>2];b=S(M[f+8>>2],40)+p|0;dc(b);d=S(d,40)+p|0;if(K[d+16|0]&1){break f}L[b+16>>1]=4;ma=b,na=sb(d)^-1,M[ma>>2]=na;M[b+4>>2]=Qa^-1;break f}b=M[a+104>>2];d=M[a+216>>2];$c:{if(d){b=(f-b|0)/20|0;c=1<<(b&7);b=M[d+20>>2]+(b>>>3|0)|0;d=N[b|0];if(c&d){break i}K[b|0]=c|d;c=M[M[a+104>>2]+4>>2];break $c}c=M[b+4>>2];if((c|0)==M[f+4>>2]){break i}}M[f+4>>2]=c;break f}if(Hh(S(M[f+4>>2],40)+p|0,M[f+12>>2])){break i}break f}if(!Hh(S(M[f+4>>2],40)+p|0,!M[f+12>>2])){break i}break f}if(K[(S(M[f+4>>2],40)+p|0)+16|0]&1){break i}break f}b=M[f+4>>2];ad:{if((b|0)>=0){d=M[f+12>>2];b=M[M[a+96>>2]+(b<<2)>>2];if((d|0)<O[b+54>>1]){b=M[(b+(d<<2)|0)+84>>2];if(b>>>0>=12){b=b&1?4:8;break ad}b=N[b+34530|0];break ad}b=1<<M[f+16>>2]-1;break ad}b=1<<N[(O[(S(M[f+12>>2],40)+p|0)+16>>1]&63)+31312|0]-1}if(b&O[f+2>>1]){break i}break f}bd:{if(!(K[(S(M[f+4>>2],40)+p|0)+16|0]&1)){if(!(K[(S(M[f+12>>2],40)+p|0)+16|0]&1)){break bd}}dc(S(M[f+8>>2],40)+p|0);break f}Fc(S(M[f+8>>2],40)+p|0,0,0);break f}if(!(K[(S(M[f+4>>2],40)+p|0)+16|0]&1)){break i}break f}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(!b|!N[b+2|0]){break f}dc(S(M[f+12>>2],40)+p|0);break i}c=M[a+96>>2]+(M[f+4>>2]<<2)|0;r=M[f+8>>2];cd:while(1){l=M[c>>2];while(1){t=M[l+64>>2];dd:{ed:{e=M[a+28>>2];if((e|0)!=M[l+24>>2]){if(N[l+2|0]){if(N[l|0]!=3){break ed}b=M[l+28>>2];if((b|0)<=0){break ed}b=S(b,40)+p|0;d=M[b+12>>2];M[l+72>>2]=d;M[l+76>>2]=d;i=M[b+8>>2];M[l+68>>2]=i;break A}b=M[l+36>>2];if(N[l+3|0]){fd:{d=M[l+8>>2];if(d){d=M[(d+(r<<2)|0)+4>>2];if(d){break fd}}q=0;g=Au(l);if(g){break b}break B}r=d-1|0;c=l+32|0;continue cd}if(!N[b|0]){break B}break dd}if(N[M[l+36>>2]]){break dd}n=O[l+54>>1];break z}dc(S(M[f+12>>2],40)+p|0);break f}q=0;g=zu(l);if(!g){continue}break}break}break b}b=S(M[f+4>>2],40)+p|0;d=M[b>>2];c=((f-M[a+104>>2]|0)/20|0)-1|0;M[b>>2]=c;M[b+4>>2]=c>>31;f=(S(M[(S(d,20)+u|0)+8>>2],20)+u|0)-20|0;break f}b=N[j+94|0];gd:{if(!(b&65)|N[a+149|0]==254){break gd}e=M[f+16>>2];if(!e){e=M[a+200>>2];if(!e){break gd}}if(b&64){d=Na-160|0;Na=d;M[d+152>>2]=0;o=M[a>>2];b=M[o+120>>2];L[d+148>>1]=0;M[d+144>>2]=0;M[d+140>>2]=b;M[d+136>>2]=0;M[d+128>>2]=0;M[d+132>>2]=0;hd:{if(M[o+196>>2]>=2){c=e;while(1){l=N[e|0];if(!l){break hd}while(1){id:{c=c+1|0;if((l|0)==10){break id}l=N[c|0];if(l){continue}}break}b=d+128|0;Ab(b,30748,3);Ab(b,e,c-e|0);e=c;continue}}if(O[a+16>>1]){k=1;jd:while(1){if(!N[e|0]){break hd}i=0;l=1;m=0;c=e;while(1){kd:{if(l){b=_h(c,d+156|0);if(M[d+156>>2]!=157){break kd}i=b}Ab(d+128|0,e,m);if(!i){break hd}b=e+m|0;ld:{if(N[b|0]==63){if((i|0)>=2){Af(b+1|0,d+152|0);c=M[d+152>>2];break ld}M[d+152>>2]=k;c=k;break ld}c=Ew(a,b,i);M[d+152>>2]=c}e=c+1|0;k=(e|0)>(k|0)?e:k;e=b+i|0;b=M[a+100>>2]+S(c,40)|0;c=O[b-24>>1];if(c&1){Ab(d+128|0,20301,4);continue jd}i=b-40|0;if(c&36){b=M[i+4>>2];M[d+80>>2]=M[i>>2];M[d+84>>2]=b;rb(d+128|0,15078,d+80|0);continue jd}if(c&8){R[d+64>>3]=R[i>>3];rb(d+128|0,12688,d- -64|0);continue jd}if(c&2){c=b-32|0;m=N[o+84|0];if((m|0)!=1){i=d+88|0;D(i,0,40);M[d+108>>2]=o;b=M[b-28>>2];Bd(i,M[c>>2],b,b>>31,m,0);if((Yd(i,1)|0)==7){M[d+136>>2]=0;K[d+148|0]=7}ma=d,na=dK(M[d+96>>2],M[d+100>>2],32),M[ma+48>>2]=na;M[d+52>>2]=Qa;rb(d+128|0,28312,d+48|0);gd(d+88|0);continue jd}b=M[b-28>>2];M[d+36>>2]=M[c>>2];M[d+32>>2]=b;rb(d+128|0,28312,d+32|0);continue jd}if(c&1024){M[d+16>>2]=M[i>>2];rb(d+128|0,25710,d+16|0);continue jd}Ab(d+128|0,27928,2);c=0;i=M[b-28>>2];i=(i|0)>0?i:0;b=b-32|0;while(1){if((c|0)!=(i|0)){M[d>>2]=N[M[b>>2]+c|0];rb(d+128|0,1626,d);c=c+1|0;continue}break}Ab(d+128|0,29241,1);continue jd}m=b+m|0;c=b+c|0;l=N[c|0];continue}}}Ab(d+128|0,e,jb(e))}if(N[d+148|0]){ag(d+128|0)}b=Rd(d+128|0);Na=d+160|0;Ra[M[j+212>>2]](M[j+216>>2],b);ab(b);break gd}if(M[j+196>>2]>=2){M[h+112>>2]=e;b=tb(j,8890,h+112|0);Ra[M[j+212>>2]](1,M[j+216>>2],a,b)|0;eb(j,b);break gd}Ra[M[j+212>>2]](1,M[j+216>>2],a,e)|0}b=M[f+4>>2];if((b|0)>=M[16933]){if(N[f|0]==184){break f}c=1;b=M[a+108>>2];b=(b|0)<=1?1:b;while(1){if((b|0)!=(c|0)){d=M[a+104>>2]+S(c,20)|0;if(N[d|0]==15){M[d+4>>2]=0}c=c+1|0;continue}break}M[f+4>>2]=0;b=0}M[f+4>>2]=b+1;M[a+188>>2]=M[a+188>>2]+1;break i}b=M[f+4>>2];d=yu(p,f);b=S(b,40)+p|0;c=M[b+8>>2];b=M[b+12>>2]<<3;b=bK(d,Qa,b,b>>31);if(!(N[((Qa&7)<<29|b>>>3)+c|0]>>>(b&7)&1)){M[a+196>>2]=M[a+196>>2]+1;break i}M[a+192>>2]=M[a+192>>2]+1;break f}b=M[f+4>>2];d=yu(p,f);b=S(b,40)+p|0;c=M[b+8>>2];b=M[b+12>>2]<<3;b=bK(d,Qa,b,b>>31);d=((Qa&7)<<29|b>>>3)+c|0;K[d|0]=N[d|0]|1<<(b&7);break f}b=S(M[f+8>>2],40)+p|0;d=O[b+16>>1];c=S(M[f+4>>2],40)+p|0;if(K[c+16|0]&1){L[b+16>>1]=d&63487;break f}L[b+16>>1]=d|2048;K[b+19|0]=M[c>>2];break f}b=S(M[f+8>>2],40)+p|0;d=S(M[f+4>>2],40)+p|0;if(N[d+17|0]&8){Fc(b,N[d+19|0],0);break f}dc(b);break f}b=S(M[f+4>>2],40)+p|0;L[b+16>>1]=O[b+16>>1]&63487;break f}md:{d=S(M[f+12>>2],40)+p|0;b=M[f+16>>2];if((d|0)==M[b>>2]){n=O[b+26>>1];break md}K[b+24|0]=v;M[b>>2]=d;M[b+12>>2]=a;e=b+28|0;n=O[b+26>>1];c=n;while(1){if((c|0)<=0){break md}c=c-1|0;M[e+(c<<2)>>2]=(S(M[f+8>>2],40)+p|0)+S(c,40);continue}}L[d+16>>1]=O[d+16>>1]&62016|1;Ra[M[M[b+4>>2]+16>>2]](b,n,b+28|0);c=M[b+20>>2];if(!c){break f}g=q;if((c|0)>0){ma=h,na=gb(d),M[ma+336>>2]=na;Qc(a,8932,h+336|0);g=M[b+20>>2]}Zk(j,ga,M[b+16>>2],M[f+4>>2]);q=0;M[b+20>>2]=0;if(!g){break f}break b}d=Kc(a,f);e=M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2];b=M[e+4>>2];c=M[f+12>>2];if(c){k=M[b+48>>2];c=c>>>0<k>>>0?k:c}else{c=0}M[b+4>>2]=M[e>>2];b=M[b>>2];nd:{if(!c){c=M[b+160>>2];break nd}M[b+160>>2]=c}M[d>>2]=c;M[d+4>>2]=0;break f}b=Kc(a,f);M[b>>2]=M[M[M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2]+4>>2]+48>>2];M[b+4>>2]=0;break f}M[h+368>>2]=0;M[h+372>>2]=0;if(N[j+87|0]){break e}g=6;b=M[M[f+16>>2]+8>>2];if(!b){break b}d=M[b>>2];if(!d){break b}k=M[d+52>>2];if(!k){break f}c=0;d=M[f+8>>2];i=(d|0)>0?d:0;e=S(M[f+12>>2],40)+p|0;g=M[a+92>>2];o=N[j+92|0];while(1){if((c|0)!=(i|0)){M[g+(c<<2)>>2]=e;c=c+1|0;e=e+40|0;continue}break}K[j+92|0]=N[f+2|0];g=Ra[k|0](b,d,g,h+368|0)|0;K[j+92|0]=o;pf(a,b);if(!g){if(M[f+4>>2]){b=M[h+372>>2];M[j+40>>2]=M[h+368>>2];M[j+44>>2]=b}c=M[a+44>>2];b=M[a+40>>2]+1|0;c=b?c:c+1|0;M[a+40>>2]=b;M[a+44>>2]=c;break aa}if(!(!N[M[f+16>>2]+16|0]|(g&255)!=19)){c=2;q=0;od:{pd:{b=O[f+2>>1];switch(b-4|0){case 1:break od;case 0:break f;default:break pd}}c=b}K[a+148|0]=c;break b}b=M[a+44>>2];d=M[a+40>>2]+1|0;b=d?b:b+1|0;M[a+40>>2]=d;M[a+44>>2]=b;break b}d=M[j+36>>2];b=M[j+32>>2];M[j+32>>2]=b|67108864;M[j+36>>2]=d;d=M[M[f+16>>2]+8>>2];c=S(M[f+4>>2],40)+p|0;g=Yd(c,1);if(g){break b}g=Ra[M[M[d>>2]+76>>2]](d,M[c+8>>2])|0;if(!(b&67108864)){c=M[j+36>>2];M[j+32>>2]=M[j+32>>2]&-67108865;M[j+36>>2]=c}pf(a,d);L[a+152>>1]=O[a+152>>1]&65532;break O}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(N[b+2|0]){break f}c=M[b+36>>2];e=M[c>>2];d=M[e>>2];g=Ra[M[d+36>>2]](c)|0;pf(a,e);if(g){break b}q=0;if(!(Ra[M[d+40>>2]](M[b+36>>2])|0)){break h}break g}d=S(M[f+12>>2],40)+p|0;c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(N[c+2|0]){dc(d);break f}e=M[M[c+36>>2]>>2];g=M[e>>2];b=aa;M[b+16>>2]=0;M[b+20>>2]=0;M[b+8>>2]=0;M[b+12>>2]=0;M[b>>2]=0;M[b+4>>2]=0;K[h+496|0]=v;M[h+472>>2]=d;M[h+372>>2]=16777216;M[h+376>>2]=0;M[h+476>>2]=h+368;qd:{if(K[f+2|0]&1){dc(d);M[d>>2]=0;L[d+16>>1]=1025;break qd}L[d+16>>1]=O[d+16>>1]&62016|1}g=Ra[M[g+44>>2]](M[c+36>>2],h+472|0,M[f+8>>2])|0;pf(a,e);if(M[h+492>>2]>0){ma=h,na=gb(d),M[ma+320>>2]=na;Qc(a,8932,h+320|0);g=M[h+492>>2]}Yd(d,v);q=0;if(!g){break f}break b}c=0;b=S(M[f+12>>2],40)+p|0;d=M[b+40>>2];i=(d|0)>0?d:0;o=b+40|0;b=M[b>>2];m=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];e=M[m+36>>2];l=M[e>>2];k=M[l>>2];g=M[a+92>>2];while(1){if((c|0)!=(i|0)){n=g+(c<<2)|0;c=c+1|0;M[n>>2]=o+S(c,40);continue}break}g=Ra[M[k+32>>2]](e,b,M[f+16>>2],d,g)|0;pf(a,l);if(g){break b}q=0;b=Ra[M[k+40>>2]](e)|0;K[m+2|0]=0;if(b){break i}break f}d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];b=Bb(8,0);if(!b){break e}M[b>>2]=M[d+36>>2];M[b+4>>2]=S(M[f+12>>2],40)+p;d=Kc(a,f);L[d+16>>1]=1;Mw(d,b,2460,2);break f}M[h+368>>2]=0;c=S(M[f+8>>2],40)+p|0;dc(c);d=M[f+16>>2];b=M[d+52>>2];if(!b){break f}e=M[b+8>>2];g=M[e>>2];M[b+12>>2]=M[b+12>>2]+1;g=Ra[M[g+96>>2]](e,M[M[j+16>>2]+(M[f+4>>2]<<4)>>2],M[d>>2],M[f+12>>2],h+368|0)|0;_f(M[d+52>>2]);b=M[h+368>>2];if(!g){q=0;if(!b){break f}Bd(c,b,-1,-1,1,1);break f}ab(b);break b}M[h+368>>2]=0;g=6;b=M[M[f+16>>2]+8>>2];if(!b){break b}d=M[b>>2];if(!d){break b}g=Ra[M[d+24>>2]](b,h+368|0)|0;pf(a,b);if(g){break b}M[M[h+368>>2]>>2]=b;q=0;c=Kg(a,M[f+4>>2],0,2);if(c){M[c+36>>2]=M[h+368>>2];M[b+4>>2]=M[b+4>>2]+1;break f}Ra[M[d+28>>2]](M[h+368>>2])|0;break e}M[j+200>>2]=M[j+200>>2]+1;q=0;g=0;b=Hc(j,M[f+16>>2],M[M[j+16>>2]+(M[f+4>>2]<<4)>>2]);rd:{if(!b|N[b+43|0]!=1){break rd}c=M[b+52>>2];if(!c){break rd}while(1){if(c){if(M[M[c+8>>2]+4>>2]>0){g=6;break rd}else{c=M[c+24>>2];continue}}break}d=xu(j,b);c=M[M[d+4>>2]>>2];i=M[c+20>>2];if(!i){i=M[c+16>>2]}M[b+24>>2]=M[b+24>>2]+1;g=Ra[i|0](M[d+8>>2])|0;if(!g){M[d+8>>2]=0;M[b+52>>2]=0;_f(d)}Id(j,b)}M[j+200>>2]=M[j+200>>2]-1;if(!g){break f}break b}b=h+368|0;D(b,0,40);M[h+388>>2]=j;g=wj(b,S(M[f+8>>2],40)+p|0);b=gb(b);sd:{if(!b){break sd}td:{b=Hc(j,b,M[M[j+16>>2]+(M[f+4>>2]<<4)>>2]);c=M[M[b+48>>2]>>2];d=Sc(fa,c);ud:{if(!d){break ud}e=M[d>>2];g=M[e+4>>2];if(!g){break ud}if(M[e+20>>2]){break td}}M[h+304>>2]=c;ma=y,na=tb(j,8406,h+304|0),M[ma>>2]=na;g=1;break sd}g=tp(j,b,d,g,y);if(g){break sd}g=0;if(!Gd(j,b)){break sd}g=wu(j);if(g){break sd}vu(j,Gd(j,b));g=0}gd(h+368|0);break O}b=M[f+16>>2];vd:{wd:{d=M[j+384>>2];if(!(M[j+408>>2]|(d|0)<=0)){g=6;break wd}if(!b){break I}e=M[M[b+8>>2]>>2];if(!M[e+56>>2]){g=0;break vd}c=0;d=(d|0)>0?d:0;xd:{while(1){if((c|0)==(d|0)){break xd}g=c<<2;c=c+1|0;if((b|0)!=M[M[j+408>>2]+g>>2]){continue}break}g=0;break wd}g=wu(j);if(g){break wd}g=Ra[M[e+56>>2]](M[b+8>>2])|0;if(g){break vd}d=M[j+504>>2];c=M[j+508>>2];vu(j,b);g=0;d=c+d|0;if(!d){break vd}c=M[e+80>>2];if(!c){break vd}M[b+20>>2]=d;g=Ra[c|0](M[b+8>>2],d-1|0)|0;break vd}if(!b){break O}}pf(a,M[b+8>>2]);break O}c=N[f+12|0];if(!(N[j+36|0]&4?c:1)){break f}q=0;b=M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2];if(!N[b+9|0]){break f}d=M[f+8>>2];M[M[b+4>>2]+4>>2]=M[b>>2];e=c+1|0;g=Po(b,d,e&255);if(!g){k=M[b+4>>2];c=k+76|0;yd:{while(1){c=M[c>>2];if(c){if((d|0)==M[c+4>>2]&(b|0)==M[c>>2]){break yd}c=c+12|0;continue}break}c=zd(16,0);if(!c){break d}M[c>>2]=b;M[c+4>>2]=d;M[c+12>>2]=M[k+76>>2];M[k+76>>2]=c}if(N[c+8|0]>=(e&255)>>>0){break f}K[c+8|0]=e;break f}if((g&255)!=6){break b}M[h+288>>2]=M[f+16>>2];Qc(a,8761,h+288|0);break b}b=M[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+36>>2];K[b+1|0]=N[b+1|0]&191;break f}b=M[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+36>>2];K[b+1|0]=N[b+1|0]|64;break f}b=M[f+8>>2];if(!M[f+4>>2]){gg(j,b);break f}L[a+152>>1]=O[a+152>>1]&65532|b+1&3;break f}d=M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2];b=M[d+4>>2];M[b+4>>2]=M[d>>2];q=0;if(!N[b+17|0]){break i}d=M[b+48>>2];c=mb(M[M[b+12>>2]+56>>2]+36|0);e=Ox(b,d,c);zd:{if(!(c>>>0<d>>>0&d>>>0>=e>>>0)){g=db(74914);break zd}if(!c){break i}g=ng(b,0,0);if(g){break zd}cq(b);g=Cx(b,e,d,0);if(g){break zd}g=ac(M[M[b+12>>2]+72>>2]);d=M[M[b+12>>2]+56>>2];b=M[b+48>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[d+28|0]=b;K[d+29|0]=b>>>8;K[d+30|0]=b>>>16;K[d+31|0]=b>>>24}if(!g){q=g;break f}if((g|0)==101){break i}break b}q=0;e=M[f+4>>2];b=M[f+8>>2];i=b?S(b,40)+p|0:0;l=0;o=0;s=Na-208|0;Na=s;Ad:{if(!N[j+85|0]){Xf(y,j,10711);g=1;break Ad}if(M[j+184>>2]>=2){Xf(y,j,4424);g=1;break Ad}k=M[j+60>>2];Bd:{if(!i){g=30808;break Bd}b=O[i+16>>1];d=b&31;if((b&63)>>>0>=32){b=1<<d;c=0}else{c=1<<d;b=c-1&1>>>32-d}if(!(c&262148|b&262144)){Xf(y,j,14023);g=1;break Ad}g=gb(i);M[j+60>>2]=M[j+60>>2]&-8|6}ja=N[j+94|0];K[j+94|0]=0;ca=M[j+24>>2];M[j+24>>2]=ca|6;d=M[j+36>>2];T=d;n=M[j+32>>2];M[j+32>>2]=n&-268456450|513;M[j+36>>2]=d&-2;b=M[j+16>>2]+(e<<4)|0;z=M[b+4>>2];d=M[M[z+4>>2]>>2];if(!N[d+12|0]){o=!N[d+16|0]}d=M[b>>2];t=M[j+112>>2];ka=M[j+116>>2];w=M[j+104>>2];la=M[j+108>>2];pe(8,s+144|0);b=M[s+148>>2];M[s+80>>2]=M[s+144>>2];M[s+84>>2]=b;c=vd(42,s+96|0,1434,s+80|0);m=M[j+20>>2];M[s+68>>2]=c;M[s+64>>2]=g;g=Ti(j,y,7363,s- -64|0);M[j+60>>2]=k;Cd:{if(g){break Cd}g=M[j+16>>2];l=g+(m<<4)|0;k=M[l+4>>2];Dd:{if(i){b=M[M[M[k+4>>2]>>2]+64>>2];M[s+160>>2]=0;M[s+164>>2]=0;r=M[b>>2];if(r){if(Ra[M[r+24>>2]](b,s+160|0)|0){break Dd}b=M[s+160>>2];g=M[s+164>>2];if((g|0)>0){b=1}else{b=!!b&(g|0)>=0}if(b){break Dd}g=M[j+16>>2]}M[j+24>>2]=M[j+24>>2]|8;b=N[((e<<4)+g|0)+8|0]|M[j+32>>2]&24|32}else{b=33}r=Wv(z);gj(k,M[M[(M[j+16>>2]+(e<<4)|0)+12>>2]+80>>2]);Qk(k,Qk(z,0));no(k,b);g=mo(j,y,20096);if(g){break Cd}g=Kf(z,i?0:2,0);if(g){break Cd}b=M[z+4>>2];if(!(N[M[b>>2]+5|0]!=5|i)){M[j+100>>2]=0}g=7;if(gh(k,M[b+36>>2],r,0)){break Cd}if(o){if(gh(k,M[j+100>>2],r,0)){break Cd}}if(N[j+87|0]){break Cd}b=K[j+90|0];if((b|0)<0){b=lo(z)}ko(k,b);K[j+176|0]=m;M[s+48>>2]=d;g=Ti(j,y,24309,s+48|0);if(g){break Cd}M[s+32>>2]=d;g=Ti(j,y,27790,s+32|0);if(g){break Cd}K[j+176|0]=0;M[s+24>>2]=c;M[s+20>>2]=d;M[s+16>>2]=c;g=Ti(j,y,24172,s+16|0);M[j+24>>2]=M[j+24>>2]&-5;if(g){break Cd}M[s+4>>2]=d;M[s>>2]=c;g=Ti(j,y,26625,s);if(g){break Cd}r=0;while(1){if(r>>>0<=9){b=N[r+34792|0];Gh(z,b,s+92|0);d=r+34793|0;r=r+2|0;g=ek(k,b,M[s+92>>2]+N[d|0]|0);if(!g){continue}break Cd}break}Ed:{if(!i){d=M[z+4>>2];M[d+4>>2]=M[z>>2];b=M[k+4>>2];M[b+4>>2]=M[k>>2];d=M[M[d>>2]+64>>2];c=M[d>>2];Fd:{if(!c){break Fd}e=M[b+48>>2];b=M[b+36>>2];ma=s,na=ZJ(e,0,b,b>>31),M[ma+152>>2]=na;M[s+156>>2]=Qa;g=Ra[M[c+40>>2]](d,11,s+152|0)|0;if((g|0)==12){break Fd}if(g){break Cd}}c=s+160|0;D(c,0,48);b=M[k>>2];M[s+184>>2]=k;M[s+180>>2]=b;M[s+176>>2]=1;M[s+164>>2]=z;m=0;Z=0;x=Na-16|0;Na=x;b=M[c+24>>2];d=M[b+4>>2];M[d+4>>2]=M[b>>2];e=M[c+28>>2];if(!(e>>>0>6|!(1<<e&97))){X=M[d>>2];F=M[M[M[c+4>>2]+4>>2]>>2];Gd:{if(!(!M[c>>2]|N[d+20|0]!=2)){Z=1;e=5;break Gd}if(N[b+8|0]){Z=1;e=0;break Gd}e=Kf(b,0,0)}o=M[c+12>>2];Hd:{Id:{if(!(e|o)){e=7;if((gh(M[c+4>>2],M[M[M[c+24>>2]+4>>2]+36>>2],0,0)|0)==7){break Hd}o=M[c+12>>2];break Id}if(e){break Hd}}e=0;if(o){break Hd}e=Kf(M[c+4>>2],2,c+8|0);if(e){break Hd}M[c+12>>2]=1;e=0}b=M[M[c+4>>2]+4>>2];d=M[b+36>>2];r=M[M[c+24>>2]+4>>2];g=M[r+36>>2];o=N[M[b>>2]+5|0];Jd:{if(e){break Jd}Kd:{if((o|0)!=5){e=0;if(!(N[F+12|0]?1:N[F+16|0])){break Jd}if((d|0)!=(g|0)){break Kd}break Jd}e=0;if((d|0)==(g|0)){break Jd}}e=8}r=M[r+48>>2];while(1){Ld:{if((m|0)==2147483647){break Ld}b=M[c+16>>2];if(b>>>0>r>>>0|e){break Ld}e=0;if((b|0)!=((P[16864]/P[M[M[c+24>>2]+4>>2]+36>>2]|0)+1|0)){e=Ra[M[X+220>>2]](X,b,x+8|0,2)|0;if(!e){e=Iz(c,b,M[M[x+8>>2]+4>>2],0);sd(M[x+8>>2])}b=M[c+16>>2]}M[c+16>>2]=b+1;m=m+1|0;continue}break}Md:{Nd:{if((e|0)==101){break Nd}if(e){break Md}M[c+36>>2]=r;b=M[c+16>>2];M[c+32>>2]=(r-b|0)+1;if(b>>>0>r>>>0){break Nd}e=0;if(M[c+40>>2]){break Md}b=M[M[M[c+24>>2]+4>>2]>>2];M[c+44>>2]=M[b+96>>2];M[b+96>>2]=c;M[c+40>>2]=1;break Md}Od:{if(r){break Od}b=M[c+4>>2];e=M[b>>2];b=M[b+4>>2];M[b+48>>2]=0;M[b+4>>2]=e;r=1;e=Uq(b);if((e|0)==101){break Od}if(e){break Md}}e=ek(M[c+4>>2],1,M[c+8>>2]+1|0);if(e){break Md}b=M[c>>2];if(b){Jf(b)}if((o|0)==5){e=Dz(M[c+4>>2],2);if(e){break Md}}Pd:{if((d|0)>(g|0)){b=(d|0)/(g|0)|0;b=((b+r|0)-1|0)/(b|0)|0;o=b-((b|0)==((P[16864]/P[M[M[c+4>>2]+4>>2]+36>>2]|0)+1|0))|0;b=M[F+28>>2];H=M[F+64>>2];m=r>>31;e=0;while(1){if(!(b>>>0<o>>>0|e)){e=0;Qd:{if(((P[16864]/P[M[M[c+4>>2]+4>>2]+36>>2]|0)+1|0)==(o|0)){break Qd}e=Ra[M[F+220>>2]](F,o,x+8|0,0)|0;if(e){break Qd}e=ac(M[x+8>>2]);sd(M[x+8>>2])}o=o+1|0;continue}break}_=g>>31;o=ZJ(r,m,g,_);I=Qa;if(!e){e=Qq(F,0,1)}m=M[16864];b=m+d|0;d=b>>31;U=b>>>0>o>>>0&(d|0)>=(I|0)|(d|0)>(I|0);r=U?o:b;U=U?I:d;d=g+m|0;b=d>>31;while(1){if(!((b|0)>=(U|0)&d>>>0>=r>>>0|(b|0)>(U|0)|e)){M[x+8>>2]=0;e=(na=X,oa=_J(d,b,g,_)+1|0,pa=x+8|0,qa=0,ma=M[X+220>>2],Ra[ma](na|0,oa|0,pa|0,qa|0)|0);if(!e){e=Ra[M[M[H>>2]+12>>2]](H,M[M[x+8>>2]+4>>2],g,d,b)|0}sd(M[x+8>>2]);m=b+_|0;d=d+g|0;b=d>>>0<g>>>0?m+1|0:m;continue}break}if(e){break Md}e=Ra[M[M[H>>2]+24>>2]](H,x+8|0)|0;if(e){break Md}b=M[x+12>>2];if(P[x+8>>2]>o>>>0&(b|0)>=(I|0)|(b|0)>(I|0)){e=Ra[M[M[H>>2]+16>>2]](H,o,I)|0;if(e){break Md}}e=Pq(F,0);break Pd}M[F+28>>2]=S((g|0)/(d|0)|0,r);e=Qq(F,0,0)}if(e){break Md}b=ak(M[c+4>>2],0);e=b?b:101}if(!Z){qm(M[c+24>>2],0);ak(M[c+24>>2],0)}M[c+28>>2]=(e|0)==3082?7:e}Na=x+16|0;if(c){d=M[c+20>>2];b=M[c+24>>2];e=M[b+4>>2];M[e+4>>2]=M[b>>2];if(M[c>>2]){M[b+16>>2]=M[b+16>>2]-1}if(M[c+40>>2]){e=M[e>>2]+96|0;while(1){b=e;g=M[b>>2];e=g+44|0;if((c|0)!=(g|0)){continue}break}M[b>>2]=M[c+44>>2]}Qp(M[c+4>>2],0,0);b=M[c+28>>2];g=(b|0)!=101?b:0;b=M[c>>2];Rd:{if(!b){break Rd}Yc(b,g);Gm(M[c>>2]);if(!M[c>>2]){break Rd}ab(c)}Gm(d)}else{g=0}if(g){break Ed}b=M[z+4>>2];L[b+24>>1]=O[b+24>>1]&65533}g=oo(k);b=!g;if(!(i|g)){ko(z,lo(k));b=1}if(!b|i){break Cd}b=Wv(k);g=gh(z,M[M[k+4>>2]+36>>2],b,1);break Cd}b=M[M[M[s+164>>2]+4>>2]>>2];if(!N[b+12|0]){Qg(b)}break Cd}Xf(y,j,3776);g=1}M[j+112>>2]=t;M[j+116>>2]=ka;M[j+104>>2]=w;M[j+108>>2]=la;M[j+32>>2]=n;M[j+36>>2]=T;M[j+24>>2]=ca;K[j+176|0]=0;K[j+94|0]=ja;gh(z,-1,0,1);K[j+85|0]=1;if(l){Cf(M[l+4>>2]);M[l+12>>2]=0;M[l+4>>2]=0}Jf(j)}Na=s+208|0;if(!g){break f}break b}i=Kc(a,f);c=M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2];d=M[M[c+4>>2]>>2];b=N[d+5|0];Sd:{if(N[d+17|0]<=2){e=M[f+12>>2];k=(e|0)==-1?b:e;if(!M[M[d+68>>2]>>2]){break Sd}e=M[d+80>>2];g=M[d+84>>2];if((g|0)<0){e=1}else{e=!e&(g|0)<=0}if(e){break Sd}}k=b}g=33492;g=N[d+15|0]|M[d>>2]==68152?g:M[d+184>>2];e=b;Td:{Ud:{Vd:{if((k|0)==5){if(!jb(g)){break Ud}if(!Uu(d)|(b|0)==5){break Ud}break Vd}if((b|0)==(k|0)){break Ud}if((b|0)==5){break Vd}g=q;b=k;break Td}if(!(M[j+188>>2]<2?N[j+85|0]:0)){M[h+272>>2]=(k|0)==5?10086:12724;Qc(a,10597,h+272|0);break G}Wd:{Xd:{if((k|0)!=5){Yd:{if(!M[d+232>>2]){M[h+368>>2]=0;g=$f(d,1);if(g){break Wd}b=M[d>>2];g=Ra[M[b+32>>2]](b,M[d+236>>2],0,h+368|0)|0;if(!(g|!M[h+368>>2])){g=Tu(d)}if(g){break Wd}if(!M[d+232>>2]){break Yd}}g=Su(d);if(g){break Wd}g=zv(M[d+232>>2],j,N[d+11|0],M[d+168>>2],M[d+224>>2]);M[d+232>>2]=0;if(!g){break Yd}if(N[d+4|0]){break Wd}Og(d,1);break Wd}Fo(d,k);b=1;break Xd}if((b|0)==4){Fo(d,2)}b=5;g=q;if(g){break Td}b=2}g=Dz(c,b)}b=k;break Td}g=q}b=Fo(d,g?e:b);L[i+16>>1]=8706;q=0;c=0;c=(b|0)!=6?M[(b<<2)+34768>>2]:c;M[i+8>>2]=c;b=jb(c);K[i+18|0]=1;M[i+12>>2]=b;Yd(i,v);if(!g){break f}break b}M[h+376>>2]=-1;M[h+368>>2]=0;M[h+372>>2]=-1;g=_v(j,M[f+4>>2],M[f+8>>2],ha,ia);if(g){if((g|0)!=5){break b}M[h+368>>2]=1}e=S(M[f+12>>2],40)+p|0;c=0;while(1){if((c|0)==3){break I}b=M[(h+368|0)+(c<<2)>>2];Fc(e,b,b>>31);e=e+40|0;c=c+1|0;continue}}c=S(M[f+4>>2],40)+p|0;d=M[f+12>>2];Zd:{if(d){b=M[f+16>>2];M[h+396>>2]=0;M[h+388>>2]=0;M[h+392>>2]=0;M[h+380>>2]=0;M[h+384>>2]=0;d=S(d,40)+p|0;dc(d);M[h+368>>2]=d;M[h+372>>2]=b;M[h+376>>2]=c;K[h+392|0]=N[M[c+20>>2]+84|0];Ra[M[b+24>>2]](h+368|0);c=S(M[f+12>>2],40)+p|0;g=M[h+388>>2];break Zd}g=Eu(c,M[f+16>>2])}if(!g){Yd(c,v);break I}ma=h,qa=gb(c),M[ma+256>>2]=qa;Qc(a,8932,h+256|0);break b}d=O[f+2>>1];b=(d<<2)+35&524280;i=Ob(j,b+40|0,0);if(!i){break e}b=b+i|0;M[i>>2]=b;M[b+24>>2]=0;M[b+20>>2]=j;L[b+16>>1]=1;M[i+8>>2]=0;b=M[f+16>>2];M[i+16>>2]=(f-u|0)/20;M[i+4>>2]=b;K[i+25|0]=0;M[i+12>>2]=a;L[i+26>>1]=d;K[i+24|0]=v;M[i+20>>2]=0;M[f+16>>2]=i;L[f>>1]=61859}_d:{b=S(M[f+12>>2],40)+p|0;if((b|0)==M[i+8>>2]){n=O[i+26>>1];break _d}M[i+8>>2]=b;d=i+28|0;n=O[i+26>>1];c=n;while(1){if((c|0)<=0){break _d}c=c-1|0;M[d+(c<<2)>>2]=(S(M[f+8>>2],40)+p|0)+S(c,40);continue}}M[b+12>>2]=M[b+12>>2]+1;Ra[M[M[i+4>>2]+(M[f+4>>2]?28:16)>>2]](i,n,i+28|0);b=M[i+20>>2];if(!b){break f}g=q;if((b|0)>0){ma=h,qa=gb(M[i>>2]),M[ma+240>>2]=qa;Qc(a,8932,h+240|0);g=M[i+20>>2]}if(N[i+25|0]){b=M[f-16>>2];if(b){Fc(S(b,40)+p|0,1,0)}K[i+25|0]=0}gd(M[i>>2]);L[M[i>>2]+16>>1]=1;q=0;M[i+20>>2]=0;if(!g){break f}break b}d=S(M[f+4>>2],40)+p|0;b=M[d>>2];e=M[d+4>>2];if(!b&(e|0)==-2147483648){break f}c=b-1|0;M[d>>2]=c;b=e-!b|0;M[d+4>>2]=b;if(!(b|c)){break i}break f}d=S(M[f+4>>2],40)+p|0;b=M[d>>2];c=M[d+4>>2];if(!(b|c)){break f}if(!b&(c|0)<=0|(c|0)<0){break i}M[d>>2]=b-1;M[d+4>>2]=c-!b;break i}d=M[f+4>>2];e=M[f+12>>2];b=Kc(a,f);c=S(d,40)+p|0;d=M[c>>2];c=M[c+4>>2];M[h+368>>2]=d;M[h+372>>2]=c;if(!d&(c|0)<=0|(c|0)<0){d=-1;c=-1}else{c=S(e,40)+p|0;d=M[c>>2];e=d;c=M[c+4>>2];d=!!d&(c|0)>=0|(c|0)>0;c=Yk(h+368|0,d?e:0,d?c:0);d=c?-1:M[h+368>>2];c=c?-1:M[h+372>>2]}M[b>>2]=d;M[b+4>>2]=c;break f}d=S(M[f+4>>2],40)+p|0;b=M[d>>2];c=M[d+4>>2];if(!b&(c|0)<=0|(c|0)<0){break f}e=M[f+12>>2];M[d>>2]=b-e;M[d+4>>2]=c-((e>>31)+(b>>>0<e>>>0)|0);break i}c=M[W>>2];if(c){while(1){b=c;c=M[b+4>>2];if(c){continue}break}b=M[b+12>>2]}else{b=p}d=b+S(M[f+4>>2],40)|0;Jh(d);c=S(M[f+8>>2],40)+p|0;Jh(c);b=M[c>>2];c=M[c+4>>2];e=M[d+4>>2];if((c|0)<=(e|0)&P[d>>2]>=b>>>0|(c|0)<(e|0)){break f}M[d>>2]=b;M[d+4>>2]=c;break f}if(M[f+4>>2]){if(M[j+512>>2]|M[j+516>>2]){break f}if(!(M[j+520>>2]|M[j+524>>2])){break i}break f}if(M[a+64>>2]|M[a+68>>2]){break f}if(!(M[j+520>>2]|M[j+524>>2])){break i}break f}if(N[j+34|0]&8){d=M[f+8>>2];b=d+M[j+520>>2]|0;c=M[j+524>>2]+(d>>31)|0;M[j+520>>2]=b;M[j+524>>2]=b>>>0<d>>>0?c+1|0:c;break f}d=M[f+8>>2];b=d>>31;if(M[f+4>>2]){b=b+M[j+516>>2]|0;c=d;d=d+M[j+512>>2]|0;b=c>>>0>d>>>0?b+1|0:b;M[j+512>>2]=d;M[j+516>>2]=b;break f}m=b+M[a+68>>2]|0;b=d+M[a+64>>2]|0;m=b>>>0<d>>>0?m+1|0:m;M[a+64>>2]=b;M[a+68>>2]=m;break f}c=Kc(a,f);b=M[a+216>>2];Lg(c,(M[b+12>>2]+S(M[f+4>>2],40)|0)+S(M[(M[b+8>>2]+S(M[b+48>>2],20)|0)+4>>2],40)|0,16384);break f}c=M[f+12>>2];b=M[f+16>>2];$d:{if(!O[f+2>>1]){break $d}k=M[b+20>>2];e=W;while(1){d=M[e>>2];if(!d){break $d}e=d+4|0;if((k|0)!=M[d+24>>2]){continue}break}break f}e=M[a+224>>2];if((e|0)<M[j+160>>2]){ae:{be:{d=S(c,40)+p|0;if(!(N[d+16|0]&16)){c=M[b+12>>2];n=!c+(c+M[b+8>>2]|0)|0;e=S(n,40);c=(e+(((M[b+4>>2]+7|0)/8|0)+(c<<2)|0)|0)+88|0;i=ub(j,c,c>>31);if(!i){break e}gd(d);M[d+36>>2]=3;M[d+12>>2]=c;M[d+8>>2]=i;L[d+16>>1]=4112;M[i+60>>2]=n;M[i>>2]=a;l=M[b+12>>2];M[i+48>>2]=(f-u|0)/20;M[i+64>>2]=l;M[i+12>>2]=M[a+88>>2];M[i+56>>2]=M[a+20>>2];M[i+16>>2]=M[a+96>>2];M[i+44>>2]=M[a+24>>2];M[i+8>>2]=M[a+104>>2];M[i+52>>2]=M[a+108>>2];M[i+24>>2]=M[b+20>>2];c=i+88|0;d=e+c|0;while(1){if((c|0)==(d|0)){break be}M[c+20>>2]=j;L[c+16>>1]=0;c=c+40|0;continue}}l=M[b+12>>2];i=M[d+8>>2];c=O[i+64>>1];n=M[i+60>>2];break ae}e=M[a+224>>2];c=l}M[a+224>>2]=e+1;M[i+4>>2]=M[a+216>>2];d=M[j+44>>2];M[i+32>>2]=M[j+40>>2];M[i+36>>2]=d;d=M[a+44>>2];M[i+72>>2]=M[a+40>>2];M[i+76>>2]=d;d=M[a>>2];e=M[d+108>>2];M[i+80>>2]=M[d+104>>2];M[i+84>>2]=e;M[i+40>>2]=M[a+236>>2];M[a+216>>2]=i;M[a+40>>2]=0;M[a+44>>2]=0;M[a+236>>2]=0;p=i+88|0;M[a+88>>2]=p;d=S(n,40)+p|0;M[a+96>>2]=d;M[a+24>>2]=c&65535;M[a+20>>2]=n;d=d+(l<<2)|0;M[i+20>>2]=d;c=(M[b+4>>2]+7|0)/8|0;if(c){D(d,0,c)}u=M[b>>2];M[a+104>>2]=u;M[a+108>>2]=M[b+4>>2];f=u-20|0;break g}Qc(a,10949,0);break G}b=M[f+12>>2];o=M[f+16>>2];m=S(M[f+4>>2],40)+p|0;if(!(N[m+16|0]&16)){if(tu(m)){break e}}l=S(b,40)+p|0;b=l;d=M[b>>2];b=M[b+4>>2];if(o){c=M[m+8>>2];if((o|0)!=M[c+28>>2]){e=M[c+8>>2];if(e){if(!(K[c+26|0]&1)){e=su(e)}i=c+20|0;ce:{de:{while(1){k=M[i>>2];if(!k){break de}i=M[k+12>>2];if(i){ru(i,h+368|0,h+472|0);M[k+12>>2]=0;i=k+8|0;e=Eo(M[h+368>>2],e);continue}break}ma=k,qa=qu(e),M[ma+12>>2]=qa;break ce}k=pu(c);M[i>>2]=k;if(!k){break ce}M[k+8>>2]=0;M[k>>2]=0;M[k+4>>2]=0;ma=k,qa=qu(e),M[ma+12>>2]=qa}M[c+8>>2]=0;M[c+12>>2]=0;L[c+26>>1]=O[c+26>>1]|1}M[c+28>>2]=o}c=c+20|0;while(1){k=M[c>>2];if(k){c=k+12|0;while(1){e=M[c>>2];if(e){c=M[e>>2];i=M[e+4>>2];if(c>>>0<d>>>0&(i|0)<=(b|0)|(b|0)>(i|0)){c=8}else{if(c>>>0<=d>>>0&(b|0)>=(i|0)|(b|0)>(i|0)){break i}c=12}c=c+e|0;continue}break}c=k+8|0;continue}break}if((o|0)<0){break f}d=M[l>>2];b=M[l+4>>2]}ou(M[m+8>>2],d,b);break f}ee:{c=S(M[f+4>>2],40)+p|0;if(!(N[c+16|0]&16)){break ee}b=M[c+8>>2];d=O[b+26>>1];if(!(d&2)){if(!(d&1)){ma=b,qa=su(M[b+8>>2]),M[ma+8>>2]=qa;d=O[b+26>>1]}L[b+26>>1]=d|3}d=M[b+8>>2];if(!d){break ee}c=M[d>>2];e=M[d+4>>2];d=M[d+8>>2];M[b+8>>2]=d;if(!d){nu(b)}Fc(S(M[f+12>>2],40)+p|0,c,e);break g}dc(c);break h}d=M[f+8>>2];b=S(M[f+4>>2],40)+p|0;if(!(N[b+16|0]&16)){if(tu(b)){break e}}d=S(d,40)+p|0;ou(M[b+8>>2],M[d>>2],M[d+4>>2]);break f}k=S(M[f+4>>2],40)+p|0;m=M[k>>2];l=M[(M[j+16>>2]+(O[f+2>>1]<<4)|0)+4>>2];q=M[l+4>>2];c=M[q+4>>2];n=0;e=M[f+16>>2];i=M[e+4>>2];if(!i){n=M[e+8>>2]!=1}r=M[f+12>>2];o=M[f+8>>2];d=M[c+32>>2];t=M[c+36>>2];M[q+4>>2]=M[l>>2];D(aa,0,80);M[h+472>>2]=q;M[h+548>>2]=j;M[h+476>>2]=M[q>>2];b=M[q+48>>2];K[h+541|0]=1;M[h+528>>2]=100;M[h+532>>2]=1e9;M[h+488>>2]=m+1;M[h+484>>2]=b;M[h+524>>2]=h+368;fe:{if(!b){break fe}c=zd((b>>>3|0)+1|0,0);M[h+480>>2]=c;ge:{if(!c){break ge}m=fj(M[q+36>>2]);M[h+544>>2]=m;if(!m){break ge}m=b;b=(P[16864]/P[q+36>>2]|0)+1|0;if(m>>>0>=b>>>0){c=c+(b>>>3|0)|0;K[c|0]=N[c|0]|1<<(b&7)}if(!n){M[h+504>>2]=30707;b=M[M[q+12>>2]+56>>2];lu(h+472|0,1,mb(b+32|0),mb(b+36|0));M[h+504>>2]=0}b=S(r,40);m=e+4|0;he:{if(!i){break he}if(N[q+17|0]){e=0;l=(o|0)>0?o:0;c=0;while(1){if((c|0)!=(l|0)){n=M[m+(c<<2)>>2];e=e>>>0>n>>>0?e:n;c=c+1|0;continue}break}c=mb(M[M[q+12>>2]+56>>2]+52|0);if((c|0)==(e|0)){break he}M[h+228>>2]=c;M[h+224>>2]=e;Vc(h+472|0,25186,h+224|0);break he}if(!mb(M[M[q+12>>2]+56>>2]- -64|0)){break he}Vc(h+472|0,10091,0)}l=b+p|0;b=M[q+4>>2];c=M[b+32>>2];e=M[b+36>>2];M[b+32>>2]=c&-2097153;M[b+36>>2]=e;c=0;while(1){e=M[h+488>>2];if(!(!e|(c|0)>=(o|0))){M[h+552>>2]=0;M[h+556>>2]=0;n=l+S(c,40)|0;b=m+(c<<2)|0;e=M[b>>2];if(e){if(!(!N[q+17|0]|(!i|(e|0)==1))){Jg(h+472|0,e,1,0);e=M[b>>2]}M[h+508>>2]=e;Do(h+472|0,e,h+360|0,-1,2147483647);e=M[h+556>>2];b=M[h+552>>2]}else{e=0;b=0}Fc(n,b,e);c=c+1|0;continue}break}b=M[q+4>>2];M[b+32>>2]=d;M[b+36>>2]=t;c=1;if(!i){break fe}while(1){if(!e|P[h+484>>2]<c>>>0){break fe}d=1<<(c&7);b=c>>>3|0;ie:{if(!(d&N[b+M[h+480>>2]|0])){if(ma=(Zd(q,c)|0)==(c|0),qa=0,pa=N[q+17|0],pa?ma:qa){break ie}M[h+208>>2]=c;Vc(h+472|0,15763,h+208|0);if(!(d&N[b+M[h+480>>2]|0])){break ie}}if((Zd(q,c)|0)!=(c|0)|!N[q+17|0]){break ie}M[h+192>>2]=c;Vc(h+472|0,16537,h+192|0)}c=c+1|0;e=M[h+488>>2];continue}}M[h+488>>2]=0;M[h+492>>2]=1;M[h+496>>2]=7}d=k+40|0;tf(M[h+544>>2]);ab(M[h+480>>2]);c=M[h+492>>2];je:{if(!c){ag(ba);b=0;break je}b=Rd(ba)}q=M[h+496>>2];dc(d);ke:{if(c){if(q){break ke}e=M[k>>2];c=c-1|0;i=e-c|0;c=M[k+4>>2]-((c>>31)+(c>>>0>e>>>0)|0)|0;M[k>>2]=i;M[k+4>>2]=c;Bd(d,b,-1,-1,1,1)}Yd(d,v);break g}ab(b);break J}d=wd(M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+12>>2]+40|0,M[f+16>>2],0);if(!d){break f}le:{if(M[d+20>>2]!=M[d+24>>2]){break le}b=ku(d);if(!b){break le}i=b+56|0;while(1){b=i;c=M[b>>2];if(!c){break le}i=c+32|0;if((c|0)!=(d|0)){continue}break}M[b>>2]=M[i>>2]}Vh(j,d);M[j+24>>2]=M[j+24>>2]|1;break f}d=wd(M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+12>>2]+24|0,M[f+16>>2],0);if(d){b=M[d+12>>2];c=M[b+8>>2];me:{if((d|0)==(c|0)){M[b+8>>2]=M[d+20>>2];break me}while(1){b=c;if(!b){break me}c=M[b+20>>2];if((d|0)!=(c|0)){continue}break}M[b+20>>2]=M[d+20>>2]}Xk(j,d)}M[j+24>>2]=M[j+24>>2]|1;break f}Id(j,wd(M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+12>>2]+8|0,M[f+16>>2],0));M[j+24>>2]=M[j+24>>2]|1;break f}g=ju(j,M[f+4>>2]);break O}b=M[f+4>>2];ne:{oe:{if(!M[f+16>>2]){Yj(M[(M[j+16>>2]+(b<<4)|0)+12>>2]);M[j+24>>2]=M[j+24>>2]&-17;g=gp(j,b,y,O[f+2>>1]);M[j+24>>2]=M[j+24>>2]|1;L[a+152>>1]=O[a+152>>1]&65532;break oe}M[h+368>>2]=j;M[h+384>>2]=0;M[h+372>>2]=y;M[h+376>>2]=b;b=M[j+16>>2]+(b<<4)|0;M[h+392>>2]=M[M[M[b+4>>2]+4>>2]+48>>2];b=M[b>>2];M[h+184>>2]=M[f+16>>2];M[h+180>>2]=9309;M[h+176>>2]=b;b=tb(j,15158,h+176|0);if(!b){g=7;break ne}K[j+177|0]=1;M[h+388>>2]=0;M[h+380>>2]=0;d=ke(j,b,4,h+368|0,0);g=d?d:M[h+380>>2];if(!(g|M[h+388>>2])){g=db(100609)}ib(j,b);K[j+177|0]=0}if(!g){break I}}Jf(j);if((g|0)!=7){break b}break e}K[j+96|0]=N[j+96|0]+1;M[h+368>>2]=0;b=N[j+94|0];d=M[j+364>>2];c=M[f+4>>2];if(c&1){K[j+94|0]=0;M[j+364>>2]=0}e=M[j+496>>2];if(c&2){M[j+496>>2]=M[f+8>>2]}g=ke(j,M[f+16>>2],0,0,h+368|0);M[j+364>>2]=d;M[j+496>>2]=e;K[j+94|0]=b;K[j+96|0]=N[j+96|0]-1;b=M[h+368>>2];if(!(b|g)){break I}M[h+160>>2]=b;Qc(a,8932,h+160|0);ab(M[h+368>>2]);if((g|0)!=7){break b}break e}q=0;b=Kc(a,f);M[h+368>>2]=0;g=hu(M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2],h+368|0,M[f+12>>2]);if(g){break b}M[b>>2]=M[h+368>>2];M[b+4>>2]=0;break f}d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];b=M[d+36>>2];if(N[d|0]==1){Iu(j,b);break f}q=0;g=Wk(M[b+8>>2],M[b+64>>2],0);if(!g){break f}break b}M[h+368>>2]=0;M[h+372>>2]=0;g=Wk(M[(M[j+16>>2]+(M[f+8>>2]<<4)|0)+4>>2],M[f+4>>2],h+368|0);c=M[f+12>>2];if(!c){break O}i=M[h+372>>2];b=i+M[a+44>>2]|0;d=M[h+368>>2];k=M[a+40>>2];e=d+k|0;M[a+40>>2]=e;M[a+44>>2]=e>>>0<k>>>0?b+1|0:b;if((c|0)<=0){break O}b=S(c,40)+p|0;c=M[b>>2];m=i+M[b+4>>2]|0;e=d;d=c+d|0;m=e>>>0>d>>>0?m+1|0:m;M[b>>2]=d;M[b+4>>2]=m;break O}b=Kc(a,f);L[b+16>>1]=1;if(M[j+188>>2]>(M[j+200>>2]+1|0)){K[a+148|0]=2;g=6;break b}c=M[f+4>>2];i=M[f+12>>2];k=M[(M[j+16>>2]+(i<<4)|0)+4>>2];d=M[k+4>>2];M[d+4>>2]=M[k>>2];e=0;M[h+472>>2]=0;pe:{if(c>>>0>P[d+48>>2]){g=db(81028);break pe}g=Wk(k,c,0);if(g){break pe}g=xd(d,c,h+472|0,0);M[h+368>>2]=g;if(g){Rb(M[h+472>>2]);break pe}if(N[d+17|0]){Gh(k,4,h+360|0);n=M[h+360>>2];qe:{if((c|0)==(n|0)){c=M[h+472>>2];Fh(c,h+368|0);Rb(c);g=M[h+368>>2];if(g){break pe}e=0;break qe}Rb(M[h+472>>2]);o=h+356|0;g=xd(d,n,o,0);if(g){break pe}m=M[h+356>>2];g=Lo(d,m,1,0,c,0);Rb(m);if(g){break pe}M[h+356>>2]=0;ma=h,qa=xd(d,n,o,0),M[ma+368>>2]=qa;c=M[h+356>>2];Fh(c,h+368|0);Rb(c);g=M[h+368>>2];if(g){break pe}e=n}c=(P[16864]/P[d+36>>2]|0)+2|0;while(1){g=(c|0)==(n|0);n=n-1|0;if(g){continue}if((Zd(d,n)|0)==(n|0)){continue}break}g=ek(k,4,n);break pe}d=M[h+472>>2];Fh(d,h+368|0);Rb(d);g=M[h+368>>2]}M[b>>2]=e;M[b+4>>2]=e>>31;L[b+16>>1]=4;if(g){break b}q=0;if(!e){break f}d=M[(M[j+16>>2]+(i<<4)|0)+12>>2];c=d+16|0;b=M[f+4>>2];while(1){c=M[c>>2];if(c){k=M[c+8>>2];if(M[k+20>>2]!=(e|0)){continue}M[k+20>>2]=b;continue}break}c=d+32|0;while(1){c=M[c>>2];if(c){d=M[c+8>>2];if(M[d+44>>2]!=(e|0)){continue}M[d+44>>2]=b;continue}break}da=i+1|0;break f}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];M[h+472>>2]=M[b+40>>2];d=M[f+16>>2];K[h+494|0]=c>>>0<42?-1:0;L[h+492>>1]=d;M[h+476>>2]=S(M[f+12>>2],40)+p;b=M[b+36>>2];d=ai(b);if((d|0)<=0){g=db(100316);break b}M[h+392>>2]=0;M[h+388>>2]=j;L[h+384>>1]=0;c=d;d=h+368|0;g=uj(b,c,d);if(g){break b}q=0;b=Eh(M[h+380>>2],M[h+376>>2],h+472|0,0);Dh(d);if(((K[f|0]&1?b+1|0:0-b|0)|0)>0){break i}break f}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(!N[b+3|0]){break f}g=Au(b);break O}c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];g=fu(c);if(g){break b}if(!N[c+2|0]){b=M[c+36>>2];d=ai(b);M[h+392>>2]=0;M[h+388>>2]=j;L[h+384>>1]=0;g=uj(b,d,h+368|0);if(g){break b}b=M[h+376>>2];e=K[b|0];if((e|0)<0){Xd(b,h+360|0);e=M[h+360>>2]}re:{se:{if(e>>>0<3){break se}d=M[h+380>>2];if(d>>>0<e>>>0){break se}k=(b+e|0)-1|0;i=K[k|0];if((i|0)<0){Xd(k,h+356|0);i=M[h+356>>2]}if((i|0)==7|i-10>>>0<4294967287){break se}k=e;e=N[i+34560|0];if(d>>>0>=k+e>>>0){break re}}Dh(h+368|0);g=db(90337);break b}$h(b+(d-e|0)|0,i,h+472|0);b=M[h+472>>2];e=M[h+476>>2];d=e;Dh(h+368|0);if(N[f|0]==141){d=M[M[a+96>>2]+(M[f+12>>2]<<2)>>2];M[d+56>>2]=b;M[d+60>>2]=e;L[d+2>>1]=256;q=0;M[d+24>>2]=0;b=M[f+16>>2];M[d+32>>2]=c;M[d+8>>2]=b;break f}c=Kc(a,f);M[c>>2]=b;M[c+4>>2]=d;break I}dc(S(M[f+8>>2],40)+p|0);break I}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];d=M[b+36>>2];M[h+368>>2]=M[b+40>>2];c=M[f+12>>2];K[h+390|0]=0;L[h+388>>1]=c;M[h+372>>2]=S(M[f+8>>2],40)+p;g=Ch(d,h+368|0,h+472|0);if(g){break b}te:{if(!M[h+472>>2]){g=eu(d,4);if(g){break b}break te}if(!O[f+2>>1]|(M[j+32>>2]&268435457)==1){break te}g=779;Dl(779,100111,10300);break b}M[b+24>>2]=0;M[b+28>>2]=0;break I}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];r=S(M[f+8>>2],40)+p|0;if(N[r+17|0]&4){g=ue(r);if(g){break b}}e=M[b+36>>2];b=M[r+8>>2];d=K[b+1|0];i=d&255;M[h+368>>2]=i;if((d|0)<0){Xd(b+1|0,h+368|0);i=M[h+368>>2]}ue:{if(!((i|0)==7|i-1>>>0>8)){K[e+68|0]=K[e+68|0]&1;break ue}if(!(!(i&1)|(i|0)<11)){K[e+68|0]=N[e+68|0]&2;break ue}K[e+68|0]=0}m=M[r+12>>2];c=m+8|0;b=m;d=Bh(b,b>>31)+b|0;n=d>>31;g=0;b=M[e+4>>2];ve:{if(!b){break ve}we:{if(M[e+44>>2]){o=M[e+56>>2];k=o>>31;if(!(k|o)){break ve}i=b;l=b>>31;b=k;k=c+o|0;b=k>>>0<o>>>0?b+1|0:b;if(i>>>0<k>>>0&(b|0)>=(l|0)|(b|0)>(l|0)){break we}break ve}k=M[e+48>>2];l=b>>>0<k>>>0;i=M[e+52>>2];b=b>>31;if(l&(i|0)>=(b|0)|(b|0)<(i|0)){break we}b=M[e>>2];o=b>>31;if(!M[18550]|((o|0)>=(i|0)&b>>>0>=k>>>0|(i|0)<(o|0))){break ve}}g=du(e);M[e+56>>2]=0;M[e+48>>2]=0;M[e+52>>2]=0}b=n+M[e+52>>2]|0;k=d+M[e+48>>2]|0;b=k>>>0<d>>>0?b+1|0:b;M[e+48>>2]=k;M[e+52>>2]=b;if((d|0)>M[e+8>>2]){M[e+8>>2]=d}i=M[e+44>>2];xe:{if(i){k=M[e+40>>2];n=M[e+56>>2];o=c+n|0;d=M[e+60>>2];ye:{if((o|0)<=(d|0)){l=i;break ye}l=o>>31;b=d>>31;while(1){c=b<<1|d>>>31;d=d<<1;b=c;if(o>>>0>d>>>0&(l|0)>=(b|0)|(b|0)<(l|0)){continue}break}n=M[e+4>>2];c=n>>31;s=n;n=d>>>0<n>>>0&(b|0)<=(c|0)|(b|0)<(c|0);d=n?d:s;s=d;T=d>>>0>o>>>0;d=n?b:c;b=d;c=T&(l|0)<=(b|0)|(b|0)>(l|0);b=c?s:o;l=Ud(i,b,c?d:l);if(!l){break d}d=k?k-i|0:-1;ze:{if((d|0)<0){k=M[e+40>>2];break ze}k=d+l|0;M[e+40>>2]=k}M[e+60>>2]=b;M[e+44>>2]=l;n=M[e+56>>2]}M[e+56>>2]=(m+15&-8)+n;i=l+n|0;if(!k){break xe}M[i+4>>2]=k-l;break xe}i=lc(c,0);if(!i){break d}M[i+4>>2]=M[e+40>>2]}b=M[r+12>>2];if(b){G(i+8|0,M[r+8>>2],b)}M[i>>2]=M[r+12>>2];M[e+40>>2]=i;break O}b=S(M[f+8>>2],40)+p|0;d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];i=O[f+2>>1];if(i&1){m=M[a+44>>2];c=M[a+40>>2]+1|0;m=c?m:m+1|0;M[a+40>>2]=c;M[a+44>>2]=m}if(N[b+17|0]&4){g=ue(b);if(g){break b}i=O[f+2>>1]}c=M[b+12>>2];M[h+376>>2]=c;M[h+380>>2]=c>>31;M[h+368>>2]=M[b+8>>2];M[h+388>>2]=S(M[f+12>>2],40)+p;L[h+392>>1]=M[f+16>>2];g=cu(M[d+36>>2],h+368|0,i&138,i&16?M[d+28>>2]:0);M[d+24>>2]=0;break O}c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];g=Vk(M[c+36>>2]);break Ca}c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];g=vj(M[c+36>>2]);break Ca}c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];b=M[c+36>>2];if(N[b+64|0]){M[h+368>>2]=0;g=au(M[b+20>>2],h+368|0);if(g|!M[h+368>>2]){break Ca}break Aa}d=M[b+40>>2];M[b+40>>2]=M[d+4>>2];M[d+4>>2]=0;if(!M[b+44>>2]){Io(j,d)}if(!M[b+40>>2]){break Aa}M[c+24>>2]=0;break Ba}M[c+24>>2]=0;if((g|0)==101){break za}if(g){break b}}q=0;K[c+2|0]=0;b=(O[f+2>>1]<<2)+ea|0;M[b>>2]=M[b>>2]+1;break h}M[c+24>>2]=0}K[c+2|0]=1;q=0;break g}M[a+172>>2]=M[a+172>>2]+1}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];M[h+356>>2]=1;w=M[b+36>>2];T=b;Ae:{Be:{if(N[b|0]==1){if(!N[w+64|0]){b=1;if(!M[w+40>>2]){break Ae}M[h+356>>2]=0;g=$t(w+72|0,w+40|0);break Be}g=du(w);if(g){break b}z=w+72|0;x=0;g=0;o=0;while(1){Ce:{De:{Ee:{Fe:{if(!g){if(N[w+67|0]<=x>>>0){break Fe}s=z+S(x,80)|0;e=M[s+8>>2];g=e>>31;d=16;b=0;n=0;while(1){if(d>>>0<e>>>0&(b|0)<=(g|0)|(b|0)<(g|0)){n=n+1|0;c=b<<4|d>>>28;d=d<<4;b=c;continue}break}M[h+368>>2]=0;M[h+372>>2]=0;if((e|0)<=16){g=_t(s,e,h+368|0,h+472|0);m=M[h+472>>2];break Ce}r=0;m=Co(16);g=m?0:7;d=(n|0)<=1?1:n;l=0;while(1){b=M[s+8>>2];if((b|0)<=(r|0)|g){break Ce}b=b-r|0;g=_t(s,(b|0)>=16?16:b,h+368|0,h+360|0);if(!g){e=1;g=Zt(s,M[h+360>>2],h+472|0);i=1;c=1;while(1){if((d|0)==(i|0)){k=m;while(1){if(!(e>>>0>=n>>>0|g)){b=M[k+12>>2]+S(((l|0)/(c|0)|0)%16|0,56)|0;i=M[b+48>>2];Ge:{if(!i){g=Co(16);if(!g){g=7;break Ge}g=Zt(s,g,b+48|0);if(g){break Ge}i=M[b+48>>2]}c=(c|0)/16|0;k=M[i+4>>2];g=0}e=e+1|0;continue}break}b=M[h+472>>2];He:{if(!g){M[(M[k+12>>2]+S((l|0)%16|0,56)|0)+48>>2]=b;break He}Gu(b)}l=l+1|0}else{i=i+1|0;c=c<<4;continue}break}}r=r+16|0;continue}}Mg(o);break Ee}g=Yt(z,o);M[w+20>>2]=o;if(g){break Ee}g=0;break De}Mg(0)}M[h+356>>2]=0;break Be}Ie:{if(!g){o=m;break Ie}Mg(m)}x=x+1|0;continue}}g=Jw(w,h+356|0);M[b+24>>2]=0;K[b+3|0]=0}if(g){break b}b=M[h+356>>2]}K[T+2|0]=b;q=0;if(M[f+8>>2]<=0){break f}if(b){break i}break f}c=M[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+36>>2];g=Jw(c,h+368|0);if(g){break b}d=-1;b=-1;if(!M[h+368>>2]){d=Td(Xt(c),Qa);b=d>>31}c=M[f+12>>2];e=c>>>0>d>>>0;c=c>>31;if(e&(c|0)>=(b|0)|(b|0)<(c|0)){break I}c=M[f+16>>2];e=c>>31;if((e|0)>=(b|0)&c>>>0>=d>>>0|(b|0)<(e|0)){break _}break I}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];d=M[b+36>>2];M[h+368>>2]=0;if((c|0)==137){M[b+28>>2]=-1;if(!N[d|0]){break f}}g=Bo(d,h+368|0);d=M[h+368>>2];M[b+24>>2]=0;K[b+3|0]=0;K[b+2|0]=d;if(g){break b}q=0;if(M[f+8>>2]<=0){break f}if(d){break _}break f}b=M[f+4>>2];c=M[M[a+96>>2]+(b<<2)>>2];if(!c){c=Kg(a,b,1,3);if(!c){break e}K[c+4|0]=1;M[c+28>>2]=0;M[c+36>>2]=74336;K[c+5|0]=N[c+5|0]|8}M[c+24>>2]=0;K[c+2|0]=1;if(N[c|0]){break f}_k(M[c+36>>2]);break f}b=Kc(a,f);c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(N[c+2|0]){L[b+16>>1]=1;break f}d=b;Je:{if(N[c+3|0]){b=M[c+56>>2];c=M[c+60>>2];break Je}if(N[c|0]==2){c=M[c+36>>2];b=M[c>>2];g=Ra[M[M[b>>2]+48>>2]](c,h+368|0)|0;pf(a,b);if(g){break b}q=0;b=M[h+368>>2];c=M[h+372>>2];break Je}g=fu(c);if(g){break b}if(N[c+2|0]){L[b+16>>1]=1;break I}q=0;b=$k(M[c+36>>2]);c=Qa}M[d>>2]=b;M[d+4>>2]=c;break f}b=Kc(a,f);c=M[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+36>>2];d=ai(c);if(d>>>0>P[j+120>>2]){break s}g=uj(c,d,b);if(g){break b}q=0;if(M[f+12>>2]|!(N[b+17|0]&64)){break f}if(!lg(b)){break f}break e}b=M[f+8>>2];c=Wt(M[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+36>>2],h+368|0);b=S(b,40)+p|0;d=M[h+368>>2];if(bi(b,d)){break d}M[b+12>>2]=d;L[b+16>>1]=O[b+16>>1]&62016|16;if(d){G(M[b+8>>2],c,d)}q=0;M[M[M[a+96>>2]+(M[f+12>>2]<<2)>>2]+24>>2]=0;break f}e=M[f+12>>2];b=M[f+16>>2];c=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];d=M[c+40>>2];c=M[c+36>>2];i=M[c+32>>2];if(!i){i=Uk(d);M[c+32>>2]=i;if(!i){break d}L[i+20>>1]=b}e=S(e,40)+p|0;c=Wt(c,h+368|0);Yi(d,M[h+368>>2],c,i);c=0;b=(b|0)>0?b:0;while(1){if((b|0)!=(c|0)){d=S(c,40);c=c+1|0;if(!(K[(M[i+4>>2]+d|0)+16|0]&1)){continue}break _}break}q=0;if(Xi(M[e+12>>2],M[e+8>>2],i)){break i}break f}b=M[a+44>>2];d=M[a+40>>2];M[j+104>>2]=d;M[j+108>>2]=b;b=M[j+116>>2]+b|0;c=M[j+112>>2];d=c+d|0;M[j+112>>2]=d;M[j+116>>2]=c>>>0>d>>>0?b+1|0:b;M[a+40>>2]=0;M[a+44>>2]=0;break f}d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];b=M[f+8>>2];e=0;Ke:{if(N[f+1|0]!=251){k=0;break Ke}k=0;if(!M[j+248>>2]){break Ke}k=M[M[j+16>>2]+(K[d+1|0]<<4)>>2];e=M[f+16>>2];if(!(N[f+2|0]&2)|!N[d+4|0]){break Ke}ma=d,qa=$k(M[d+36>>2]),M[ma+56>>2]=qa;M[d+60>>2]=Qa}g=eu(M[d+36>>2],N[f+2|0]);M[d+24>>2]=0;M[d+28>>2]=0;if(g){break b}V=V+1|0;q=0;if(!(b&1)){break f}b=M[a+44>>2];c=M[a+40>>2]+1|0;b=c?b:b+1|0;M[a+40>>2]=c;M[a+44>>2]=b;b=M[j+248>>2];if(N[e+28|0]&128|(!b|!e)){break f}Ra[b|0](M[j+244>>2],9,k,M[e>>2],M[d+56>>2],M[d+60>>2]);break f}b=M[a+96>>2];k=M[b+(M[f+8>>2]<<2)>>2];c=M[b+(M[f+4>>2]<<2)>>2];b=M[f+12>>2];if(b){d=S(b,40)+p|0;b=M[d>>2];d=M[d+4>>2]}else{b=0;d=0}e=M[c+36>>2];o=M[e+20>>2];c=M[o+84>>2];t=M[k+36>>2];Ng(t);k=M[t+44>>2];Le:{if(k>>>0<=127){K[c|0]=k;n=c+1|0;break Le}n=of(c,k,0)+c|0}if(!M[e+112>>2]){n=of(n,b,d)+n|0}c=O[t+48>>1];k=M[t+40>>2];d=c+k|0;s=M[M[t+116>>2]+60>>2];if(d>>>0>s>>>0){g=db(80435);break b}r=M[t+44>>2];i=M[e+116>>2];m=O[i+14>>1];if(!((r|0)!=(c|0)|m>>>0<=c>>>0)){if(c){G(n,k,c)}M[o+88>>2]=(c+n|0)-M[o+84>>2];break I}M[h+368>>2]=0;w=M[M[t+20>>2]>>2];M[h+472>>2]=0;e=r;if(m>>>0<e>>>0){b=O[i+16>>1];g=b;b=$J(e-b|0,0-(b>>>0>e>>>0)|0,M[M[i+52>>2]+40>>2]-4|0,0)+b|0;e=(b|0)>(m|0)?g:b}b=(n-M[o+84>>2]|0)+e|0;g=b+4|0;i=b;b=e>>>0<r>>>0;M[o+88>>2]=b?g:i;l=0;if(c>>>0<r>>>0){if(s>>>0<d+4>>>0){g=db(80460);break b}l=mb(d)}m=b?e+n|0:0;b=0;while(1){r=r-e|0;while(1){if(c){d=c>>>0>e>>>0?e:c;if(d){G(n,k,d)}k=d+k|0;n=d+n|0;e=e-d|0;c=c-d|0}else{c=0}Me:{if(!e){g=M[h+368>>2];i=!g;break Me}sd(M[h+472>>2]);i=0;M[h+472>>2]=0;g=Ra[M[w+220>>2]](w,l,h+472|0,2)|0;M[h+368>>2]=g;if(g){break Me}d=M[M[h+472>>2]+4>>2];k=d+4|0;l=mb(d);c=M[M[t+20>>2]+40>>2]-4|0;continue}break}if(!(!m|(!i|!r))){M[h+356>>2]=0;ma=h,qa=rf(o,h+356|0,h+360|0,0,0),M[ma+368>>2]=qa;d=M[h+360>>2];d=d<<24|(d&65280)<<8|(d>>>8&65280|d>>>24);K[m|0]=d;K[m+1|0]=d>>>8;K[m+2|0]=d>>>16;K[m+3|0]=d>>>24;if(!(!N[o+17|0]|!b)){Hd(o,M[h+360>>2],4,M[b+4>>2],h+368|0)}Rb(b);b=M[h+356>>2];if(b){m=M[b+56>>2];K[m|0]=0;K[m+1|0]=0;K[m+2|0]=0;K[m+3|0]=0;n=m+4|0;d=M[o+40>>2]-4|0;e=d>>>0<r>>>0?d:r}g=M[h+368>>2]}if(g?0:r){continue}break}Rb(b);sd(M[h+472>>2]);break O}e=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];b=M[f+8>>2];c=S(M[f+12>>2],40)+p|0;d=M[c>>2];c=M[c+4>>2];m=c;M[h+376>>2]=d;M[h+380>>2]=c;c=S(b,40);k=0;b=0;Ne:{if(N[f+1|0]!=251){break Ne}b=0;if(!M[j+248>>2]){break Ne}k=M[f+16>>2];b=M[M[j+16>>2]+(K[e+1|0]<<4)>>2]}i=c+p|0;o=O[f+2>>1];Oe:{if(!(o&1)){break Oe}c=M[a+44>>2];g=M[a+40>>2]+1|0;c=g?c:c+1|0;M[a+40>>2]=g;M[a+44>>2]=c;if(!(o&32)){break Oe}M[j+40>>2]=d;M[j+44>>2]=m}M[h+384>>2]=M[i+8>>2];M[h+396>>2]=M[i+12>>2];g=0;n=0;n=o&16?M[e+28>>2]:n;g=N[i+17|0]&4?M[i>>2]:g;M[h+368>>2]=0;M[h+400>>2]=g;g=cu(M[e+36>>2],h+368|0,o&138,n);M[e+24>>2]=0;K[e+3|0]=0;if(g){break b}if(k){Ra[M[j+248>>2]](M[j+244>>2],O[f+2>>1]&4?23:18,b,M[k>>2],d,m)}V=V+1|0;break I}M[h+368>>2]=0;M[h+372>>2]=0;M[h+472>>2]=0;k=Kc(a,f);e=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(!(N[e+5|0]&2)){g=Bo(M[e+36>>2],h+472|0);if(g){break b}Pe:{if(M[h+472>>2]){M[h+368>>2]=1;M[h+372>>2]=0;break Pe}d=$k(M[e+36>>2]);M[h+368>>2]=d;b=Qa;M[h+372>>2]=b;if((d|0)==-1&(b|0)==2147483647){K[e+5|0]=N[e+5|0]|2;break Pe}d=d+1|0;b=d?b:b+1|0;M[h+368>>2]=d;M[h+372>>2]=b}q=0}d=M[f+12>>2];if(d){c=M[W>>2];if(c){while(1){b=c;c=M[b+4>>2];if(c){continue}break}b=M[b+12>>2]}else{b=p}c=b+S(d,40)|0;Jh(c);g=13;d=M[c>>2];b=M[c+4>>2];if((d|0)==-1&(b|0)==2147483647|N[e+5|0]&2){break b}m=M[h+372>>2];i=m;o=M[h+368>>2];if((i|0)<=(b|0)&o>>>0<=d>>>0|(b|0)>(i|0)){o=d+1|0;b=o?b:b+1|0;m=b;M[h+368>>2]=o;M[h+372>>2]=b}M[c>>2]=o;M[c+4>>2]=m}Qe:{if(N[e+5|0]&2){c=0;while(1){Re:{pe(8,h+368|0);m=M[h+372>>2]&1073741823;b=M[h+368>>2]+1|0;m=b?m:m+1|0;M[h+368>>2]=b;M[h+372>>2]=m;b=zh(M[e+36>>2],b,m,0,h+472|0);d=M[h+472>>2];if(b|d){break Re}i=c>>>0<99;c=c+1|0;if(i){continue}}break}if(b){break Qe}q=0;if(!d){break Qe}}M[e+24>>2]=0;K[e+3|0]=0;b=M[h+372>>2];M[k>>2]=M[h+368>>2];M[k+4>>2]=b;break f}g=b?b:13;break b}c=Kc(a,f);b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];e=b;d=M[b+16>>2];b=M[b+20>>2];k=b;i=d+1|0;b=i?b:b+1|0;M[e+16>>2]=i;M[e+20>>2]=b;M[c>>2]=d;M[c+4>>2]=k;break f}c=M[f+12>>2];break ha}c=M[f+12>>2];b=S(c,40)+p|0;if(N[b+16|0]&36){break ha}d=h+368|0;G(d,b,40);oe(d,67,v);if(!(O[h+384>>1]&4)){break i}b=M[h+368>>2];c=M[h+372>>2];break ga}d=S(c,40)+p|0;b=M[d>>2];c=M[d+4>>2]}d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];e=M[d+36>>2];q=0;M[h+352>>2]=0;g=zh(e,b,c,0,h+352|0);M[d+24>>2]=0;M[d+56>>2]=b;M[d+60>>2]=c;L[d+2>>1]=0;b=M[h+352>>2];M[d+28>>2]=b;if(b){if(M[f+8>>2]){q=g;break i}g=db(99019);break b}if(!g){break f}break b}if(M[f+16>>2]<=O[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+6>>1]){break f}}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];d=S(M[f+12>>2],40)+p|0;M[h+372>>2]=d;c=M[f+16>>2];L[h+388>>1]=c;Se:{if(c&65535){d=M[b+40>>2];K[h+390|0]=0;M[h+368>>2]=d;g=Ch(M[b+36>>2],h+368|0,b+28|0);break Se}if(N[d+17|0]&4){if(ue(d)){break e}}d=Uk(M[b+40>>2]);if(!d){break e}c=M[h+372>>2];Yi(M[b+40>>2],M[c+12>>2],M[c+8>>2],d);K[d+22|0]=0;g=Ch(M[b+36>>2],d,b+28|0);ib(j,d)}if(g){break b}M[b+24>>2]=0;K[b+3|0]=0;d=M[b+28>>2];K[b+2|0]=(d|0)!=0;c=N[f|0];if((c|0)==29){if(!d){break _}break I}if(d){break _}Te:{switch(c-26|0){case 1:c=0;b=M[h+372>>2];d=O[h+388>>1];while(1){if((c|0)==(d|0)){break I}e=S(c,40);c=c+1|0;if(!(K[(b+e|0)+16|0]&1)){continue}break};break _;case 0:break Te;default:break I}}L[b+6>>1]=M[f+16>>2];break I}b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(!b|N[b+2|0]){break h}break f}d=M[f+8>>2];b=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];c=O[b+6>>1];if((d|0)>(c|0)){L[b+6>>1]=d;break f}d=M[f+12>>2];if((d|0)>=(c|0)){break f}L[b+6>>1]=d;break f}b=M[M[a+96>>2]+(M[f+24>>2]<<2)>>2];if(N[M[b+36>>2]]){break f}k=f+20|0;i=M[f+4>>2];M[h+472>>2]=M[b+40>>2];d=M[f+36>>2];K[h+494|0]=0;L[h+492>>1]=d;M[h+476>>2]=S(M[f+32>>2],40)+p;Ue:{while(1){d=M[b+36>>2];c=ai(d);if((c|0)<=0){g=db(90370);break b}M[h+392>>2]=0;M[h+388>>2]=j;L[h+384>>1]=0;e=c;c=h+368|0;g=uj(d,e,c);if(g){break b}d=Eh(M[h+380>>2],M[h+376>>2],h+472|0,0);Dh(c);if((d|0)>0){k=O[f+2>>1]?f:k;break Ue}if((d|0)>=0){k=f;break Ue}if((i|0)<=0){break aa}M[b+24>>2]=0;i=i-1|0;g=vj(M[b+36>>2]);if(!g){continue}break}if((g|0)!=101){break b}}q=0;f=k;break i}q=0;break f}d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];M[d+24>>2]=0;L[d+2>>1]=0;Ve:{We:{if(N[d+4|0]){e=S(M[f+12>>2],40)+p|0;o=O[e+16>>1];if((o&46)==2){tj(e,0)}b=sb(e);i=Qa;k=O[e+16>>1];L[e+16>>1]=o;Xe:{if(k&36){break Xe}if(!(k&8)){if(k&1|c>>>0>22){break i}l=0;g=Bo(M[d+36>>2],h+472|0);if(g){break b}break Ve}e=Wi(b,i,R[e>>3]);if((e|0)>0){c=((c&1)+c|0)-1|0;break Xe}c=((e|0)!=0&c)+c|0}k=0;g=zh(M[d+36>>2],b,i,0,h+472|0);M[d+56>>2]=b;M[d+60>>2]=i;if(!g){break We}break b}l=1;b=M[d+36>>2];e=N[b+3|0];g=M[d+40>>2];k=M[f+16>>2];K[h+390|0]=c&1?1:-1;L[h+388>>1]=k;M[h+368>>2]=g;g=M[f+12>>2];K[h+394|0]=0;M[h+372>>2]=S(g,40)+p;g=Ch(b,h+368|0,h+472|0);if(g){break b}b=e&2;k=b>>>1|0;if(!b){break We}if(!N[h+394|0]){break Ve}}b=M[h+472>>2];if(c>>>0>=23){if(b|(c|0)!=24?(b|0)>=0:0){break Z}g=vj(M[d+36>>2]);if(!g){break Z}if((g|0)==101){break _}break b}if(!(b|(c|0)!=21?(b|0)<=0:0)){g=Vk(M[d+36>>2]);if(!g){break Z}if((g|0)!=101){break b}break _}if(N[M[d+36>>2]]){break _}break Z}k=l;if(!M[h+472>>2]){break Z}}q=0;break i}q=0;f=(k?20:0)+f|0;break f}c=M[a+96>>2];e=M[f+4>>2];b=M[c+(e<<2)>>2];if(b){aj(a,b);e=M[f+4>>2];c=M[a+96>>2]}M[c+(e<<2)>>2]=0;break f}b=Kg(a,M[f+4>>2],M[f+12>>2],3);if(!b){break e}K[b+2|0]=1;d=M[f+8>>2];M[b+36>>2]=74336;K[b+4|0]=1;M[b+28>>2]=d;break f}d=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];b=M[d+16>>2];c=M[d+20>>2];e=c;k=b+1|0;c=k?c:c+1|0;M[d+16>>2]=k;M[d+20>>2]=c;if(!(b|e)){break i}break f}d=Kg(a,M[f+4>>2],M[f+8>>2],1);if(!d){break e}b=M[f+16>>2];M[d+40>>2]=b;c=M[f+12>>2];g=O[b+6>>1]<<2;b=ub(j,g+172|0,0);M[d+36>>2]=b;if(!b){break d}e=M[M[j+16>>2]+4>>2];k=b+152|0;M[b+28>>2]=k;g=g+20|0;if(g){G(k,M[d+40>>2],g)}g=0;M[b+164>>2]=0;if(c){L[b+158>>1]=c}d=M[e+4>>2];M[d+4>>2]=M[e>>2];d=M[d+36>>2];K[b+67|0]=1;M[b+12>>2]=d;K[b+65|0]=0;K[b+66|0]=255;M[b+84>>2]=b;M[b+24>>2]=j;Ye:{if(N[j+86|0]==2){break Ye}c=S(d,M[16917]);M[b>>2]=c;e=d>>31;o=e;k=M[M[M[j+16>>2]+12>>2]+80>>2];i=k>>31;m=(i|0)<0;e=ZJ(m?-1024:d,m?-1:e,k,i);k=Qa;if((k|0)>0){k=1}else{k=(k|0)>=0&e>>>0>=536870912}e=k?536870912:e;M[b+4>>2]=(c|0)>(e|0)?c:e;if(N[67472]){break Ye}M[b+60>>2]=d;d=lc(d,o);M[b+44>>2]=d;g=d?0:7}if(O[b+160>>1]>12){break O}d=M[b+172>>2];if(N[M[b+168>>2]]&2|((d|0)!=M[j+8>>2]?d:0)){break O}K[b+68|0]=3;break O}b=M[f+12>>2];if((b|0)>0){b=S(b,40)+p|0;M[b+8>>2]=30808;M[b+12>>2]=0}b=M[f+4>>2];c=M[M[a+96>>2]+(b<<2)>>2];Ze:{if(!(!(!c|N[c+5|0]&8)&M[f+8>>2]<=L[c+52>>1])){c=Kg(a,b,M[f+8>>2],0);if(!c){break e}K[c+5|0]=N[c+5|0]|1;g=mj(M[j>>2],0,j,c+8|0,O[f+2>>1]|5,1054);if(g){break b}g=Kf(M[c+8>>2],1,0);if(!g){b=M[f+16>>2];M[c+40>>2]=b;_e:{if(b){k=0;g=hu(M[c+8>>2],c+48|0,O[f+2>>1]|2);if(g){break _e}g=Tk(M[c+8>>2],M[c+48>>2],4,b,M[c+36>>2]);break _e}k=1;M[c+48>>2]=1;g=Tk(M[c+8>>2],1,4,0,M[c+36>>2])}K[c+4|0]=k}K[c+5|0]=N[c+5|0]&251|(O[f+2>>1]!=8?4:0);if(!g){break Ze}Cf(M[c+8>>2]);M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]=0;break b}M[c+24>>2]=0;M[c+16>>2]=0;M[c+20>>2]=0;g=Wk(M[c+8>>2],M[c+48>>2],0);if(g){break b}}K[c+2|0]=1;break I}d=M[M[a+96>>2]+(M[f+8>>2]<<2)>>2];b=Kg(a,M[f+4>>2],L[d+52>>1],0);if(!b){break e}K[b+2|0]=1;c=N[b+5|0]|1;K[b+5|0]=c;M[b+40>>2]=M[d+40>>2];K[b+4|0]=N[d+4|0];M[b+48>>2]=M[d+48>>2];c=N[d+5|0]&4|c&-5;K[b+5|0]=c;e=M[d+8>>2];K[b+5|0]=c|8;M[b+8>>2]=e;K[d+5|0]=N[d+5|0]|8;q=Tk(M[b+8>>2],M[b+48>>2],4,M[b+40>>2],M[b+36>>2]);break f}e=M[M[a+96>>2]+(M[f+4>>2]<<2)>>2];if(!e|M[e+48>>2]!=M[f+8>>2]){break R}_k(M[e+36>>2]);break Q}if((O[a+152>>1]&3)==1){g=516;break b}d=M[f+12>>2];b=M[j+16>>2]+(d<<4)|0;o=M[b+4>>2];k=M[f+8>>2];i=0;$e:{if((c|0)!=113){n=0;break $e}c=O[f+2>>1];e=c&8;b=N[M[b+12>>2]+76|0];if(b>>>0<N[a+149|0]){K[a+149|0]=b}n=e|4;if(!(c&16)){break $e}b=S(k,40)+p|0;Jh(b);k=M[b>>2]}c=M[f+4>>2];e=N[f+1|0];af:{if((e|0)!=253){b=0;if((e|0)!=248){break af}i=M[f+16>>2];b=O[i+8>>1];break af}b=M[f+16>>2]}e=Kg(a,c,b,0);if(!e){break e}K[e+2|0]=1;K[e+1|0]=d;M[e+48>>2]=k;K[e+5|0]=N[e+5|0]|4;q=Tk(o,k,n,i,M[e+36>>2]);M[e+40>>2]=i;K[e+4|0]=N[f+1|0]!=248}K[M[e+36>>2]+3|0]=N[f+2|0]&3;if(q){break J}break I}b=M[j+16>>2]+(M[f+4>>2]<<4)|0;g=ek(M[b+4>>2],M[f+8>>2],M[f+12>>2]);bf:{cf:{switch(M[f+8>>2]-1|0){case 0:M[M[b+12>>2]>>2]=M[f+12>>2]-O[f+2>>1];M[j+24>>2]=M[j+24>>2]|1;e=M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+12>>2]+16|0;df:while(1){e=M[e>>2];if(!e){break bf}b=M[e+8>>2];if(N[b+43|0]){continue}c=b+48|0;while(1){b=M[c>>2];if(!b){continue df}Vi(j,M[b+28>>2]);M[b+28>>2]=0;Vi(j,M[b+32>>2]);M[b+32>>2]=0;c=b+4|0;continue}};case 1:break cf;default:break bf}}K[M[b+12>>2]+76|0]=M[f+12>>2]}if(M[f+4>>2]!=1){break O}gg(j,0);L[a+152>>1]=O[a+152>>1]&65532}if(!g){break I}break b}Gh(M[(M[j+16>>2]+(M[f+4>>2]<<4)|0)+4>>2],M[f+12>>2],h+368|0);b=Kc(a,f);d=M[h+368>>2];M[b>>2]=d;M[b+4>>2]=d>>31;break f}M[h+368>>2]=0;ef:{d=M[f+8>>2];if(!d){break ef}b=M[j+32>>2]&1048576;if(!(b|M[j+36>>2]&2)){break ef}q=b?8:11;break J}c=M[j+16>>2]+(M[f+4>>2]<<4)|0;b=M[c+4>>2];ff:{if(b){q=Kf(b,d,h+368|0);if(q){if((q&255)!=5){break J}M[a+36>>2]=q;M[a+32>>2]=(f-u|0)/20;break j}if(!(N[a+152|0]&32)|!M[f+8>>2]|(M[j+188>>2]<2?N[j+85|0]:0)){break ff}e=M[a+48>>2];if(!e){d=M[j+508>>2]+1|0;M[j+508>>2]=d;e=d+M[j+504>>2]|0;M[a+48>>2]=e}q=_i(j,0,e-1|0);if(!q){d=M[a+48>>2];e=M[b+4>>2];M[e+4>>2]=M[b>>2];q=Jq(M[e>>2],d)}b=M[j+516>>2];M[a+72>>2]=M[j+512>>2];M[a+76>>2]=b;b=M[j+524>>2];M[a+80>>2]=M[j+520>>2];M[a+84>>2]=b}if(q){break J}}if(!O[f+2>>1]|M[h+368>>2]==M[f+12>>2]&M[M[c+12>>2]+4>>2]==M[f+16>>2]){break I}eb(j,M[y>>2]);ma=y,qa=_b(j,16500),M[ma>>2]=qa;b=M[f+4>>2];if(M[M[(M[j+16>>2]+(b<<4)|0)+12>>2]>>2]!=M[h+368>>2]){rj(j,b)}L[a+152>>1]=O[a+152>>1]&65516|1;q=17;break J}d=M[f+8>>2];b=M[f+4>>2];gf:{if((b|0)!=N[j+85|0]){hf:{if(d){ah(j,516);c=1;break hf}if(!(!b|M[j+192>>2]<=0)){g=5;b=4369;break gf}q=$i(a,1);if(q){break j}c=b}K[j+85|0]=c;q=5;if((Bj(a)|0)==5){M[a+32>>2]=(f-u|0)/20;K[j+85|0]=1-b;break k}Kj(j);q=M[a+36>>2]?1:101;break j}g=1;b=b?d?13017:12976:10549}Qc(a,b,0);break b}k=M[f+16>>2];e=0;c=$;d=M[f+4>>2];jf:{if(!d){if(M[j+192>>2]>0){Qc(a,4264,0);g=5;break b}d=jb(k);g=_i(j,0,M[j+504>>2]+M[j+508>>2]|0);if(g){break b}b=Ob(j,d+33|0,0);if(!b){break jf}c=b+32|0;M[b>>2]=c;d=d+1|0;if(d){G(c,k,d)}kf:{if(N[j+85|0]){K[j+93|0]=1;K[j+85|0]=0;break kf}M[j+504>>2]=M[j+504>>2]+1}M[b+24>>2]=M[j+492>>2];M[j+492>>2]=b;d=M[j+516>>2];M[b+8>>2]=M[j+512>>2];M[b+12>>2]=d;d=M[j+524>>2];M[b+16>>2]=M[j+520>>2];M[b+20>>2]=d;break jf}while(1){b=M[c>>2];if(!b){break H}if(hb(M[b>>2],k)){c=b+24|0;e=e+1|0;continue}break}if(!((d|0)!=1|M[j+192>>2]<=0)){Qc(a,4315,0);g=5;break b}l=0;lf:{mf:{nf:{if(M[b+24>>2]){break nf}c=N[j+93|0];l=(c|0)!=0;if(!c|(d|0)!=1){break nf}q=$i(a,1);if(q){break j}K[j+85|0]=1;q=5;if((Bj(a)|0)==5){M[a+32>>2]=(f-u|0)/20;K[j+85|0]=0;break k}g=M[a+36>>2];if(!g){break mf}K[j+85|0]=0;break b}c=M[j+504>>2];n=1;if((d|0)==2){k=M[j+24>>2]&1;o=!k;i=0;while(1){if(M[j+20>>2]>(i|0)){g=i<<4;q=0;i=i+1|0;g=wx(M[(M[j+16>>2]+g|0)+4>>2],516,o);if(!g){continue}break b}break}n=!k}e=(e^-1)+c|0;i=0;while(1){if(M[j+20>>2]>(i|0)){c=i<<4;q=0;i=i+1|0;g=Ho(M[(M[j+16>>2]+c|0)+4>>2],d,e);if(!g){continue}break b}break}if(!n){gg(j,0);Jf(j);M[j+24>>2]=M[j+24>>2]|1}if(!q){break lf}break J}K[j+93|0]=0;l=1}while(1){c=M[$>>2];if((c|0)!=(b|0)){M[j+492>>2]=M[c+24>>2];eb(j,c);M[j+504>>2]=M[j+504>>2]-1;continue}break}of:{pf:{if((d|0)==1){M[j+492>>2]=M[b+24>>2];ib(j,b);if(l){break pf}M[j+504>>2]=M[j+504>>2]-1;break of}c=M[b+12>>2];M[j+512>>2]=M[b+8>>2];M[j+516>>2]=c;c=M[b+20>>2];M[j+520>>2]=M[b+16>>2];M[j+524>>2]=c}if((d|0)!=2&l){break jf}}g=_i(j,d,e);if(g){break b}}if(N[a+151|0]!=3){break I}q=101;break j}g=q;break b}q=0;break f}M[h+144>>2]=k;Qc(a,7618,h+144|0)}g=1;break b}k=M[M[M[a+96>>2]+(M[f+4>>2]<<2)>>2]+36>>2];qf:{if(M[f+12>>2]){d=Xt(k);b=Qa;break qf}q=0;rf:{g=Zf(k);if((g|0)==16){break rf}d=0;b=0;while(1){if(g){break b}if(M[j+296>>2]){break rf}sf:{e=M[k+116>>2];tf:{if(!N[e+8|0]){i=O[e+24>>1];if(N[e+1|0]){break tf}c=i&65535;d=c+d|0;b=c>>>0>d>>>0?b+1|0:b;break tf}e=O[e+24>>1];d=e+d|0;b=d>>>0<e>>>0?b+1|0:b;while(1){if(!N[k+68|0]){break sf}Ao(k);e=M[k+116>>2];i=O[e+24>>1];c=O[k+70>>1];if(i>>>0<=c>>>0){continue}break}L[k+70>>1]=c+1}c=O[k+70>>1];if((c|0)==(i&65535)){c=(M[e+56>>2]+N[e+9|0]|0)+8|0}else{c=M[e+64>>2]+(c<<1)|0;c=M[e+56>>2]+(O[e+26>>1]&(N[c|0]<<8|N[c+1|0]))|0}g=Ig(k,mb(c));continue}break}g=Zf(k);if(g){break b}break qf}d=0;b=0}c=Kc(a,f);M[c>>2]=d;M[c+4>>2]=b;break g}e=S(M[f+4>>2],40)+p|0;l=e+S(M[f+8>>2],40)|0;d=S(M[f+12>>2],40);k=M[f+16>>2];if(k){i=N[k|0];c=e;while(1){oe(c,i<<24>>24,v);b=k;uf:{if(N[b|0]!=69){break uf}k=O[c+16>>1];if(!(k&4)){break uf}L[c+16>>1]=k&65499|32}c=c+40|0;k=b+1|0;i=N[b+1|0];if(i){continue}break}}t=d+p|0;k=0;o=0;m=0;d=0;b=0;s=l-40|0;i=s;while(1){r=i;w=O[i+16>>1];vf:{if(w&1){M[i+28>>2]=w<<21>>31&10;k=k+1|0;break vf}if(w&36){k=k+1|0;i=M[r>>2];l=M[r+4>>2];c=l>>31;n=c^i;c=c^l;if(!c&n>>>0<=127){if(!(!l&i>>>0>1|(l|0)!=0|N[a+149|0]<4)){M[r+28>>2]=i|8;break vf}M[r+28>>2]=1;d=d+1|0;b=d?b:b+1|0;break vf}if(!c&n>>>0<=32767){M[r+28>>2]=2;d=d+2|0;b=d>>>0<2?b+1|0:b;break vf}if(!c&n>>>0<=8388607){M[r+28>>2]=3;d=d+3|0;b=d>>>0<3?b+1|0:b;break vf}if(!c&n>>>0<=2147483647){M[r+28>>2]=4;d=d+4|0;b=d>>>0<4?b+1|0:b;break vf}if((c|0)==32767|c>>>0<32767){M[r+28>>2]=5;d=d+6|0;b=d>>>0<6?b+1|0:b;break vf}d=d+8|0;b=d>>>0<8?b+1|0:b;if(w&32){M[r+28>>2]=7;R[r>>3]=+(i>>>0)+ +(l|0)*4294967296;L[r+16>>1]=w&65495|8;break vf}M[r+28>>2]=6;break vf}if(w&8){M[r+28>>2]=7;d=d+8|0;b=d>>>0<8?b+1|0:b;k=k+1|0;break vf}n=M[r+12>>2];l=(w>>>1&1|n<<1)+12|0;wf:{if(!(w&1024)){break wf}c=M[r>>2];l=(c<<1)+l|0;if(b|d){if(ue(r)){break e}n=M[r>>2]+n|0;break wf}m=(c>>31)+m|0;o=c+o|0;m=o>>>0<c>>>0?m+1|0:m}M[r+28>>2]=l;d=d+n|0;b=d>>>0<n>>>0?b+1|0:b;k=Bh(l,0)+k|0}i=r-40|0;if((e|0)!=(r|0)){continue}break}c=d;if((k|0)<=126){d=k+1|0}else{d=k;k=Bh(k,0);d=d+k|0;d=((Bh(d,d>>31)|0)>(k|0))+d|0}k=d>>31;b=k+b|0;i=c+d|0;c=m+(i>>>0<d>>>0?b+1|0:b)|0;b=i+o|0;c=b>>>0<o>>>0?c+1|0:c;l=M[t+24>>2];n=l>>31;xf:{if((c|0)<=(n|0)&b>>>0<=l>>>0|(c|0)<(n|0)){M[t+8>>2]=M[t+32>>2];break xf}n=b;b=M[j+120>>2];n=n>>>0>b>>>0;b=b>>31;if(n&(b|0)<=(c|0)|(b|0)<(c|0)){break s}if(bi(t,i)){break e}}L[t+16>>1]=16;M[t+12>>2]=i;if(m|o){L[t+16>>1]=1040;M[t>>2]=o}b=M[t+8>>2];yf:{if((d|0)<=127){K[b|0]=d;i=b+1|0;break yf}i=of(b,d,k)+b|0}k=b+d|0;while(1){o=e;c=M[e+28>>2];zf:{if(c>>>0<=7){K[i|0]=c;i=i+1|0;if(!c){break zf}d=M[e>>2];b=M[e+4>>2];Af:{Bf:{Cf:{Df:{Ef:{Ff:{e=N[c+34560|0];switch(e-1|0){case 0:break Af;case 1:break Bf;case 2:break Cf;case 3:break Df;case 5:break Ef;default:break Ff}}c=b;b=d<<8|(d&65280)>>>8;K[k+6|0]=b;K[k+7|0]=b>>>8;b=c>>>16|0;d=(c&65535)<<16|d>>>16}c=d<<8|(d&65280)>>>8;K[k+4|0]=c;K[k+5|0]=c>>>8;d=(b&65535)<<16|d>>>16;b=b>>>16|0}K[k+3|0]=d;c=b;b=b>>>8|0;d=(c&255)<<24|d>>>8}K[k+2|0]=d;c=b;b=b>>>8|0;d=(c&255)<<24|d>>>8}K[k+1|0]=d;d=(b&255)<<24|d>>>8}K[k|0]=d;k=e+k|0;break zf}if(c>>>0<=127){K[i|0]=c;i=i+1|0;if(c>>>0<14){break zf}b=M[o+12>>2];if((b|0)<=0){break zf}if(b){G(k,M[o+8>>2],b)}k=M[o+12>>2]+k|0;break zf}i=of(i,c,0)+i|0;b=M[o+12>>2];if(!b){break zf}if(b){G(k,M[o+8>>2],b)}k=M[o+12>>2]+k|0}e=o+40|0;if((o|0)!=(s|0)){continue}break}break f}c=S(M[f+4>>2],40)+p|0;i=M[f+16>>2];e=N[i|0];while(1){oe(c,e<<24>>24,v);b=i;Gf:{if(N[b|0]!=69){break Gf}e=O[c+16>>1];if(!(e&4)){break Gf}d=M[c>>2];k=M[c+4>>2];Hf:{if(k+32768>>>0<65536){n=65499;d=32;break Hf}R[c>>3]=+(d>>>0)+ +(k|0)*4294967296;n=65521;d=8}L[c+16>>1]=d|e&n}c=c+40|0;i=b+1|0;e=N[b+1|0];if(e){continue}break}break f}e=S(M[f+4>>2],40)+p|0;k=M[f+16>>2];o=M[k+4>>2];c=0;while(1){if(L[k+34>>1]<=(c|0)){break f}If:{Jf:{b=o+S(c,12)|0;d=O[b+10>>1];if(!(d&96)){break Jf}if(d&32){break If}if(!M[f+12>>2]){break Jf}e=e+40|0;break If}oe(e,K[b+5|0],v);Kf:{d=O[e+16>>1];if(d&1){break Kf}Lf:{Mf:{Nf:{Of:{Pf:{i=N[b+4|0]>>>4|0;switch(i-2|0){case 0:break Mf;case 1:case 2:break Pf;case 3:break Nf;case 4:break Of;default:break Kf}}if(d&4){break Kf}break Lf}if(d&2){break Kf}break Lf}Qf:{Rf:{if(d&4){b=M[e>>2];i=M[e+4>>2];m=i+32768|0;if((m|0)==65536|m>>>0>65536){break Rf}i=32;b=65499;break Qf}if(d&40){break Kf}break Lf}R[e>>3]=+(b>>>0)+ +(i|0)*4294967296;i=8;b=65523}L[e+16>>1]=b&d|i;break Kf}if(d&16){break Kf}}c=M[(i<<2)+68236>>2];e=M[k>>2];M[h+140>>2]=M[b>>2];M[h+136>>2]=e;M[h+132>>2]=c;M[h+128>>2]=M[(N[(d&63)+31312|0]<<2)+34700>>2];Qc(a,6224,h+128|0);g=3091;break b}e=e+40|0}c=c+1|0;continue}}ma=l,qa=ai(b),M[ma+72>>2]=qa;d=O[b+48>>1];c=M[M[b+116>>2]+60>>2];i=M[b+40>>2];M[l+68>>2]=i;b=c-i|0;M[l+76>>2]=(b|0)<(d|0)?(b|0)>0?b:0:d;e=M[a+28>>2]}M[l+24>>2]=e;b=K[i|0];M[t>>2]=b&255;e=1;if((b|0)<0){e=Xd(i,t)}n=0;L[l+54>>1]=0;M[l+44>>2]=e;i=M[t>>2];if(i>>>0>P[l+76>>2]){M[l+76>>2]=0;M[l+68>>2]=0;b=M[t>>2];if(b>>>0>98307){break r}if(b>>>0<=P[l+72>>2]){break z}break r}m=M[l+68>>2];break y}if((n&65535)>>>0>r>>>0){break w}e=M[l+44>>2];i=M[t>>2];if(e>>>0>=i>>>0){break x}m=M[l+68>>2];if(m){break y}b=h+368|0;D(b,0,40);g=uj(M[l+36>>2],M[t>>2],b);if(g){break b}i=M[t>>2];e=M[l+44>>2];n=O[l+54>>1];q=0;m=M[h+376>>2]}w=l+84|0;k=i+m|0;e=e+m|0;i=n&65535;d=M[t+(i<<2)>>2];b=0;while(1){o=K[e|0];c=o&255;M[h+472>>2]=c;n=w+(i<<2)|0;M[n>>2]=c;Sf:{if((o|0)>=0){o=N[c+34560|0];e=e+1|0;break Sf}s=Xd(e,h+472|0);c=M[h+472>>2];M[n>>2]=c;o=c>>>0>=128?c-12>>>1|0:N[c+34560|0];e=e+s|0}n=i+1|0;s=t+(n<<2)|0;d=d+o|0;b=d>>>0<o>>>0?b+1|0:b;M[s>>2]=d;if(i>>>0<r>>>0){i=n;if(e>>>0<k>>>0){continue}}break}Tf:{if(e>>>0>=k>>>0){if(M[l+72>>2]!=(d|0)|b|e>>>0>k>>>0){break Tf}break v}if(!b&P[l+72>>2]>=d>>>0){break v}}if(!M[t>>2]){n=0;e=k;break v}if(M[l+68>>2]){break r}gd(h+368|0);break r}M[h+472>>2]=0;break u}M[h+472>>2]=M[(l+(r<<2)|0)+84>>2];break t}L[l+54>>1]=n;M[l+44>>2]=e-m;if(M[l+68>>2]){break u}gd(h+368|0);n=O[l+54>>1]}if((n&65535)>>>0>r>>>0){break t}b=S(M[f+12>>2],40)+p|0;if(N[f+1|0]==246){Lg(b,M[f+16>>2],8192);break f}dc(b);break f}c=S(M[f+12>>2],40)+p|0;if(N[c+17|0]&144){dc(c)}b=t+(r<<2)|0;if(P[l+76>>2]>=P[b+4>>2]){d=M[l+68>>2]+M[b>>2]|0;b=M[h+472>>2];if(b>>>0<=11){$h(d,b,c);break f}K[c+18|0]=v;b=b-12>>>1|0;M[c+12>>2]=b;e=b+2|0;Uf:{if((e|0)>M[c+24>>2]){if((b|0)>M[j+120>>2]){break s}L[c+16>>1]=1;if(qh(c,e,0)){break e}k=M[c+8>>2];break Uf}k=M[c+32>>2];M[c+8>>2]=k}if(b){G(k,d,b)}K[b+M[c+8>>2]|0]=0;K[(b+M[c+8>>2]|0)+1|0]=0;L[c+16>>1]=O[((M[h+472>>2]&1)<<1)+34542>>1];break f}K[c+18|0]=v;e=M[h+472>>2];Vf:{d=O[f+2>>1]&192;Wf:{Xf:{if(d){if((d|0)==128){break Wf}if(e>>>0<12){break Xf}if(!(e&1)|(d|0)==192){break Wf}}if(e>>>0>127){break Vf}}if(N[e+34560|0]){break Vf}}$h(31408,e,c);break f}b=M[b>>2];d=e>>>0>=128?e-12>>>1|0:N[e+34560|0];k=M[c+20>>2];q=18;Yf:{if((d|0)>M[k+120>>2]){break Yf}o=M[a+28>>2];n=N[c+18|0];Zf:{_f:{$f:{if(!(M[l+40>>2]|d>>>0<4001)){ag:{if(N[l+5|0]&16){q=M[l+80>>2];break ag}q=ub(k,32,0);M[l+80>>2]=q;if(!q){break Zf}K[l+5|0]=N[l+5|0]|16}i=M[q>>2];bg:{cg:{if(!i){break cg}if(!(M[q+16>>2]!=(r|0)|(o|0)!=M[q+20>>2]|M[q+24>>2]!=(V|0))){k=M[q+8>>2];m=M[q+12>>2];t=Rt(M[l+36>>2]);i=M[q>>2];if((k|0)==(t|0)&(Qa|0)==(m|0)){break bg}if(!i){break cg}}Zg(i)}i=zo(d+3|0,0);M[q>>2]=i;if(!i){break Zf}m=Ko(M[l+36>>2],b,d,i);if(m){break _f}b=d+i|0;K[b+2|0]=0;K[b|0]=0;K[b+1|0]=0;M[q+24>>2]=V;M[q+20>>2]=o;M[q+16>>2]=r;ma=q,qa=Rt(M[l+36>>2]),M[ma+8>>2]=qa;M[q+12>>2]=Qa}b=i-8|0;q=b;k=M[b>>2];b=M[b+4>>2];k=k+1|0;b=k?b:b+1|0;M[q>>2]=k;M[q+4>>2]=b;if(e&1){m=Bd(c,i,d,0,n,9);L[c+16>>1]=O[c+16>>1]|512;break $f}m=Bd(c,i,d,0,0,9);break $f}m=St(M[l+36>>2],b,d,c);if(m){break _f}$h(M[c+8>>2],e,c);m=0;if(!(e&1)|(n|0)!=1){break $f}K[d+M[c+8>>2]|0]=0;L[c+16>>1]=O[c+16>>1]|512}L[c+16>>1]=O[c+16>>1]&49151}q=m;break Yf}q=7}if(!q){break f}if((q|0)==18){break s}g=q;if((g|0)!=7){break b}break e}Qc(a,12629,0);g=18;break b}b=M[u+12>>2];if((b|0)>0){f=(S(b,20)+u|0)-20|0;break f}g=db(96759);break b}A=0;break f}A=1;break f}e=M[o>>2];b=M[o+4>>2];d=M[m+4>>2];k=M[m>>2];M[h+368>>2]=k;M[h+372>>2]=d;dg:{eg:{fg:{switch((c&255)-107|0){case 1:if(!Vt(h+368|0,e,b)){break l}break n;case 2:gg:{if(!!e&(b|0)>=0|(b|0)>0){n=aK(-1,2147483647,e,b)>>>0<k>>>0;c=Qa;if(n&(c|0)<=(d|0)|(c|0)<(d|0)){break n}c=aK(0,-2147483648,e,b);l=0-c|0;c=0-(Qa+((c|0)!=0)|0)|0;if((c|0)<=(d|0)&k>>>0>=l>>>0|(c|0)<(d|0)){break gg}break n}if((b|0)>0|(b|0)>=0){break gg}if(!!k&(d|0)>=0|(d|0)>0){c=aK(0,-2147483648,k,d);l=0-c|0;c=0-(Qa+((c|0)!=0)|0)|0;if((c|0)==(b|0)&e>>>0>=l>>>0|b>>>0>c>>>0){break gg}break n}if((d|0)>0|(d|0)>=0){break gg}if(!e&(b|0)==-2147483648|!k&(d|0)==-2147483648){break n}c=aK(-1,2147483647,0-e|0,0-(((e|0)!=0)+b|0)|0);l=0-(((k|0)!=0)+d|0)|0;n=Qa;if((l|0)==(n|0)&c>>>0<0-k>>>0|l>>>0>n>>>0){break n}}b=ZJ(e,b,k,d);d=Qa;break eg;case 3:if(!(b|e)){break m}if(!k&(d|0)==-2147483648&(b&e)==-1){break n}b=_J(k,d,e,b);d=Qa;break eg;case 0:break dg;default:break fg}}if(!(b|e)){break m}c=d;d=(b&e)==-1;b=$J(k,c,d?1:e,d?0:b);d=Qa}M[h+368>>2]=b;M[h+372>>2]=d;break l}if(!Yk(h+368|0,e,b)){break l}}B=Kb(o);Y=Kb(m);hg:{ig:{jg:{switch(N[f|0]-107|0){case 1:B=Y-B;break ig;case 2:B=B*Y;break ig;case 3:if(B==0){break m}B=Y/B;break ig;default:b=sb(o);c=Qa;d=sb(m);M[h+368>>2]=d;e=Qa;M[h+372>>2]=e;if(!(b|c)){break m}k=b;b=(b&c)==-1;B=+($J(d,e,b?1:k,b?0:c)>>>0)+ +(Qa|0)*4294967296;break hg;case 0:break jg}}B=B+Y}if(B!=B){break m}}R[i>>3]=B;L[i+16>>1]=O[i+16>>1]&62016|8;break f}dc(i);break f}b=M[h+372>>2];M[i>>2]=M[h+368>>2];M[i+4>>2]=b;L[i+16>>1]=O[i+16>>1]&62016|4;break f}M[a+36>>2]=5}c=1;break a}f=(S(M[f+8>>2],20)+u|0)-20|0;break f}f=(S(M[f+8>>2],20)+u|0)-20|0}if(M[j+296>>2]){break c}while(1){if((E|0)==(J|0)&C>>>0>Q>>>0|E>>>0>J>>>0){break f}b=M[j+372>>2];if(!b){break f}d=M[j+380>>2];C=d+C|0;m=E;E=d>>>0>C>>>0?m+1|0:m;if(!(Ra[b|0](M[j+376>>2])|0)){continue}break}C=-1;E=-1;break c}f=f+20|0;continue}}Lb(j);Qc(a,1162,0)}g=7;break b}g=9}c=0}while(1){kg:{lg:{mg:{ng:{if(!c){c=7;og:{if(N[j+87|0]){break og}c=g;if((c|0)!=8458){break og}c=db(102667)}if(!(M[a+124>>2]|(c|0)==3082)){ma=h,qa=Yg(c),M[ma+16>>2]=qa;Qc(a,8932,h+16|0)}M[a+36>>2]=c;Cm(j,c);b=M[a+200>>2];M[h+8>>2]=M[a+124>>2];M[h+4>>2]=b;M[h>>2]=(f-u|0)/20;Lc(c,7275,h);if(N[a+151|0]==2){Bj(a)}pg:{if((c|0)!=11){if((c|0)!=3082){break pg}Lb(j);break pg}if(N[j+85|0]){break pg}d=M[j+36>>2]|2;M[j+32>>2]=M[j+32>>2];M[j+36>>2]=d}q=1;b=da&255;if(!b){da=0;break ng}rj(j,b-1|0);break ng}if((E|0)==(J|0)&C>>>0>Q>>>0|E>>>0>J>>>0){break lg}b=M[j+372>>2];if(!b){break lg}d=M[j+380>>2];C=d+C|0;c=E;E=d>>>0>C>>>0?c+1|0:c;if(Ra[b|0](M[j+376>>2])|0){break mg}}c=1;continue}g=9;C=-1;E=-1;break kg}M[a+180>>2]=M[a+180>>2]+Q;Na=h+560|0;return q}c=0;continue}}
function pj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0,I=0,J=0;o=Na-1280|0;Na=o;t=M[a>>2];C=M[t+124>>2];if(!M[t+184>>2]){M[t+296>>2]=0}M[a+248>>2]=b;M[a+12>>2]=0;D=o+52|0;M[o+48>>2]=D;M[o+40>>2]=a;M[o+44>>2]=o+1240;M[o+52>>2]=0;M[o+36>>2]=D;H=M[t+264>>2];M[t+264>>2]=a;s=-1;a:while(1){c=s;while(1){b:{y=_h(b,o+1252|0);C=C-y|0;c:{if((C|0)<0){M[a+12>>2]=18;M[a+40>>2]=M[a+40>>2]+1;break c}s=M[o+1252>>2];d:{if((s|0)<165){break d}if(M[t+296>>2]){M[a+12>>2]=9;M[a+40>>2]=M[a+40>>2]+1;break c}if((s|0)==184){break b}e:{f:{if(!N[b|0]){y=0;s=0;switch(c|0){case 0:break c;case 1:break e;default:break f}}g:{h:{switch(s-183|0){default:i:{switch(s-165|0){case 0:M[o+1272>>2]=b+6;s=60;c=o+1272|0;if((ul(c)|0)!=60){break e}s=(ul(c)|0)==24?165:60;break e;case 1:M[o+1272>>2]=b+4;s=60;if((c|0)!=23){break e}c=ul(o+1272|0);s=(c|0)==60?166:(c|0)==22?166:60;break e;case 2:break i;default:break g}}M[o+1272>>2]=b+6;if((c|0)==23){s=167;if((ul(o+1272|0)|0)==22){break e}}s=60;break e;case 0:break d;case 1:break g;case 2:break h}}if(N[t+36|0]&64){break b}}M[o+1276>>2]=y;M[o+1272>>2]=b;M[o+32>>2]=o+1272;cb(a,29984,o+32|0);break c}s=1}M[o+1252>>2]=s}M[a+216>>2]=y;M[a+212>>2]=b;c=N[a+216|0]|N[a+217|0]<<8|(N[a+218|0]<<16|N[a+219|0]<<24);E=c;z=N[a+212|0]|N[a+213|0]<<8|(N[a+214|0]<<16|N[a+215|0]<<24);M[o+1256>>2]=z;M[o+1260>>2]=c;h=O[M[o+36>>2]>>1];f=M[o+40>>2];j:{while(1){c=h&65535;k:{if(c>>>0>582){break k}h=c<<1;g=O[h+38144>>1];c=s;l:{while(1){e=c&65535;c=e+g<<1;if(O[c+39312>>1]==(e|0)){break l}c=O[(e<<1)+37344>>1];if(c){continue}break}m:{if(!e){break m}c=g+102<<1;if(O[c+39312>>1]!=102){break m}h=O[c+44112>>1];break k}h=O[h+48528>>1];break k}h=O[c+44112>>1]}e=h&65535;if(e>>>0>=1257){n:{if(N[e+36471|0]|P[o+36>>2]<P[o+44>>2]){break n}c=o+36|0;if(!jw(c)){break n}iw(c);break j}c=M[o+1260>>2];M[o+24>>2]=M[o+1256>>2];M[o+28>>2]=c;c=0;g=0;h=0;q=0;i=Na-768|0;Na=i;d=M[o+36>>2];o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{va:{wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{Ka:{La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{Ua:{Va:{Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{nb:{ob:{pb:{qb:{rb:{sb:{tb:{ub:{vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{Gb:{Hb:{Ib:{Jb:{Kb:{Lb:{Mb:{Nb:{Ob:{Pb:{Qb:{Rb:{Sb:{Tb:{Ub:{Vb:{Wb:{Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{ic:{jc:{kc:{lc:{mc:{nc:{oc:{pc:{qc:{rc:{sc:{tc:{uc:{vc:{wc:{xc:{yc:{zc:{Ac:{Bc:{Cc:{Dc:{Ec:{Fc:{Gc:{Hc:{Ic:{Jc:{Kc:{Lc:{Mc:{Nc:{Oc:{Pc:{Qc:{Rc:{Sc:{Tc:{Uc:{Vc:{Wc:{Xc:{Yc:{Zc:{_c:{$c:{ad:{bd:{cd:{dd:{ed:{fd:{gd:{hd:{id:{jd:{kd:{ld:{md:{nd:{od:{pd:{qd:{rd:{sd:{td:{ud:{vd:{wd:{xd:{yd:{zd:{Ad:{Bd:{Cd:{Dd:{Ed:{Fd:{Gd:{Hd:{Id:{Jd:{Kd:{Ld:{Md:{Nd:{Od:{Pd:{Qd:{Rd:{Sd:{Td:{Ud:{Vd:{Wd:{Xd:{Yd:{Zd:{_d:{$d:{ae:{be:{ce:{de:{ee:{fe:{ge:{he:{ie:{je:{ke:{le:{me:{ne:{oe:{pe:{qe:{re:{se:{te:{ue:{ve:{F=e-1257|0;switch(F|0){case 99:break za;case 101:case 134:case 144:case 234:case 237:case 242:break Aa;case 102:break Ba;case 103:break Ca;case 104:break Da;case 105:case 117:case 258:case 259:break Ea;case 107:case 110:break Fa;case 108:break Ga;case 109:break Ha;case 111:break Ia;case 112:break Ja;case 113:break Ka;case 114:break La;case 115:break Ma;case 116:case 131:break Na;case 118:break Oa;case 119:break Pa;case 120:break Qa;case 121:break Ra;case 122:break Sa;case 123:break Ta;case 124:break Ua;case 125:break Va;case 126:break Wa;case 127:break Xa;case 128:break Ya;case 129:break Za;case 130:break _a;case 132:break $a;case 133:break ab;case 135:case 145:break bb;case 136:break cb;case 137:break db;case 138:break eb;case 139:break fb;case 140:case 143:break gb;case 141:break hb;case 142:break ib;case 146:case 148:case 153:case 155:case 232:case 233:case 252:break jb;case 147:case 154:case 156:case 231:case 251:break kb;case 149:break lb;case 150:break mb;case 151:break nb;case 152:break ob;case 157:break pb;case 158:break qb;case 159:break rb;case 160:break sb;case 161:break tb;case 162:break ub;case 163:break vb;case 164:break wb;case 165:break xb;case 166:break yb;case 167:break zb;case 168:break Ab;case 169:break Bb;case 170:break Cb;case 171:break Db;case 172:break Eb;case 0:break ve;case 175:break Fb;case 176:break Gb;case 177:break Hb;case 178:break Ib;case 179:break Jb;case 180:break Kb;case 181:break Lb;case 182:break Mb;case 183:case 184:break Nb;case 185:break Ob;case 1:break ue;case 186:break Pb;case 187:break Qb;case 188:break Rb;case 189:break Sb;case 190:break Tb;case 191:break Ub;case 192:break Vb;case 193:break Wb;case 194:break Xb;case 195:break Yb;case 2:break te;case 196:break Zb;case 197:break _b;case 198:case 199:case 200:case 201:case 202:case 203:case 204:break $b;case 205:break ac;case 206:break bc;case 207:break cc;case 208:break dc;case 209:break ec;case 210:break fc;case 211:break gc;case 3:break se;case 212:break hc;case 213:break ic;case 214:case 215:break jc;case 216:break kc;case 217:break lc;case 218:case 221:break mc;case 220:break nc;case 223:break oc;case 224:break pc;case 225:break qc;case 4:break re;case 226:break rc;case 227:break sc;case 228:break tc;case 229:break uc;case 230:break vc;case 235:break wc;case 236:break xc;case 238:case 243:break yc;case 239:break zc;case 240:case 282:break Ac;case 5:case 6:case 7:case 324:break qe;case 241:break Bc;case 244:break Cc;case 245:break Dc;case 248:break Ec;case 249:break Fc;case 250:break Gc;case 253:break Hc;case 254:break Ic;case 255:break Jc;case 256:break Kc;case 8:case 9:break pe;case 257:break Lc;case 260:break Mc;case 261:break Nc;case 262:break Oc;case 263:break Pc;case 264:break Qc;case 265:case 266:break Rc;case 267:break Sc;case 268:case 287:break Tc;case 269:case 288:break Uc;case 10:break oe;case 270:break Vc;case 271:break Wc;case 272:break Xc;case 273:break Yc;case 274:break Zc;case 275:break _c;case 276:break $c;case 277:break ad;case 278:break bd;case 279:break cd;case 11:break ne;case 280:break dd;case 281:break ed;case 283:break fd;case 284:break gd;case 285:break hd;case 286:break id;case 289:break jd;case 290:break kd;case 291:break ld;case 292:break md;case 12:break me;case 293:break nd;case 294:break od;case 295:break pd;case 296:break qd;case 297:break rd;case 298:break sd;case 299:break td;case 300:break ud;case 301:break vd;case 302:case 303:case 304:break wd;case 13:break le;case 305:case 306:break xd;case 307:break yd;case 308:break zd;case 309:break Ad;case 310:break Bd;case 311:break Cd;case 312:break Dd;case 313:break Ed;case 314:break Fd;case 315:break Gd;case 14:break ke;case 316:break Hd;case 317:break Id;case 318:break Jd;case 319:break Kd;case 320:break Ld;case 321:break Md;case 322:break Nd;case 323:break Od;case 326:case 328:case 330:break Pd;case 15:case 18:case 47:case 62:case 72:case 81:case 100:case 246:break je;case 329:break Qd;case 331:break Rd;case 332:break Sd;case 333:case 334:break Td;case 335:break Ud;case 336:break Vd;case 337:break Wd;case 339:break Xd;case 340:break Yd;case 341:break Zd;case 16:break ie;case 342:break _d;case 343:break $d;case 17:break he;case 19:break ge;case 20:break fe;case 21:break ee;case 22:break de;case 23:break ce;case 24:break be;case 25:break ae;case 26:case 65:case 106:break r;case 27:break s;case 28:break t;case 29:break u;case 30:break v;case 31:break w;case 32:case 67:break x;case 33:break y;case 34:break z;case 35:break A;case 36:break B;case 37:break C;case 38:break D;case 39:break E;case 40:break F;case 41:break G;case 42:break H;case 43:break I;case 44:break J;case 45:break K;case 46:break L;case 48:break M;case 49:break N;case 50:break O;case 51:break P;case 52:break Q;case 53:break R;case 54:break S;case 55:break T;case 56:break U;case 57:break V;case 58:break W;case 59:break X;case 60:break Y;case 61:case 76:case 173:break Z;case 63:case 80:case 219:case 222:case 247:break _;case 64:break $;case 66:break aa;case 68:break ba;case 69:break ca;case 70:break da;case 71:break ea;case 73:case 75:break fa;case 74:break ga;case 77:break ha;case 78:case 174:break ia;case 79:break ja;case 82:break ka;case 83:break la;case 84:break ma;case 85:break na;case 86:break oa;case 87:break pa;case 88:break qa;case 89:case 91:break ra;case 90:break sa;case 92:break ta;case 93:break ua;case 94:break va;case 95:break wa;case 96:case 97:break xa;case 98:break ya;default:break o}}if(M[f+244>>2]){break o}K[f+223|0]=1;break o}if(M[f+244>>2]){break o}K[f+223|0]=2;break o}if(N[f+18|0]){break o}c=M[f>>2];we:{if(M[f+40>>2]){if(!N[c+87|0]){break o}c=7;break we}xe:{ye:{ze:{g=M[f+8>>2];if(g){break ze}if(N[c+177|0]){break xe}g=Cb(f);if(g){break ze}M[f+12>>2]=1;g=0;break ye}Ae:{if(!N[f+163|0]){break Ae}h=M[f+148>>2];if(!M[h+96>>2]){break Ae}Ub(g,83);j=fb(g,36,M[h+92>>2]);k=M[h+100>>2];e=0;while(1){if(M[h+96>>2]>(e|0)){bb(g,94,M[h+92>>2],e,e+k|0);e=e+1|0;continue}break}$a(g,84,k,e);$a(g,39,M[h+92>>2],j+1|0);h=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(j,20)|0)+8>>2]=h}Ub(g,70);h=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2])+8>>2]=h;e=0;while(1){Be:{if(!(M[f+96>>2]>>>e&1)){break Be}se(g,e);h=M[(M[c+16>>2]+(e<<4)|0)+12>>2];lb(g,2,e,M[f+92>>2]>>>e&1,M[h>>2],M[h+4>>2]);if(N[c+177|0]){break Be}h=M[g+108>>2];if((h|0)<=0){break Be}L[(M[g+104>>2]+S(h,20)|0)-18>>1]=1}e=e+1|0;if((e|0)<M[c+20>>2]){continue}break}e=0;while(1){if(M[f+228>>2]>(e|0)){nb(g,170,0,0,0,Gd(c,M[M[f+276>>2]+(e<<2)>>2]),-11);e=e+1|0;continue}break}e=0;M[f+228>>2]=0;Ce:{c=M[f+120>>2];if(!c){break Ce}h=M[f+8>>2];while(1){if((c|0)<=(e|0)){break Ce}c=M[f+124>>2]+(e<<4)|0;nb(h,169,M[c>>2],M[c+4>>2],N[c+8|0],M[c+12>>2],-1);e=e+1|0;c=M[f+120>>2];continue}}De:{c=M[f+128>>2];if(!c){break De}j=M[f+8>>2];k=M[f>>2];while(1){if(!c){break De}h=M[c+12>>2];e=M[c+8>>2];Pd(f,0,e,M[M[(M[k+16>>2]+(e<<4)|0)+12>>2]+72>>2],102);m=h-1|0;Uc(j,m,M[M[c+4>>2]>>2]);e=hg(j,12,50560);if(!e){break De}M[e+72>>2]=h;M[e+64>>2]=m;M[e+52>>2]=h;M[e+8>>2]=h;M[e+124>>2]=h;M[e+112>>2]=h;L[e+62>>1]=16;M[e+208>>2]=h;M[e+144>>2]=h;m=h+2|0;M[e+12>>2]=m;M[e+148>>2]=m;M[e+88>>2]=h+1;if(!M[f+44>>2]){M[f+44>>2]=1}c=M[c>>2];continue}}Ee:{c=M[f+72>>2];if(!c){break Ee}e=0;K[f+23|0]=0;h=c+8|0;while(1){if(M[c>>2]<=(e|0)){break Ee}j=h+(e<<4)|0;kc(f,M[j>>2],M[j+12>>2]);e=e+1|0;continue}}Fe:{if(!N[f+163|0]){break Fe}c=M[f+148>>2];e=M[c+96>>2];if(!e){break Fe}$a(g,117,M[c+92>>2],e)}Xb(g,1)}c=1;if(M[f+40>>2]){break we}yw(g,f)}c=101}M[f+12>>2]=c;break o}e=M[d-8>>2];j=M[f>>2];if(gc(f,22,20096,0,0)){break o}c=Cb(f);if(!c){break o}Ge:{if((e|0)==7){break Ge}h=(e|0)==9?2:1;e=0;while(1){if(M[j+20>>2]<=(e|0)){break Ge}k=M[(M[j+16>>2]+(e<<4)|0)+4>>2];He:{if(k){g=0;if(K[M[k+4>>2]+24|0]&1){break He}}g=h}$a(c,2,e,g);se(c,e);e=e+1|0;continue}}Ub(c,1);break o}M[d+16>>2]=7;break o}M[d+4>>2]=O[d+2>>1];break o}c=O[d-10>>1]==12;if(gc(f,22,c?20341:18914,0,0)){break o}e=Cb(f);if(!e){break o}$a(e,1,1,c);break o}Tn(f,0,d+4|0);break o}Tn(f,1,d+4|0);break o}Tn(f,2,d+4|0);break o}Sn(f,d-8|0,d+4|0,M[d-44>>2],0,0,M[d-20>>2]);break o}nt(f);break o}M[d+16>>2]=0;break o}M[d-20>>2]=1;break o}M[d+4>>2]=!N[M[f>>2]+177|0];break o}Rn(f,d-20|0,d-8|0,M[d+4>>2],0);break o}Rn(f,0,0,0,M[d+4>>2]);pc(M[f>>2],M[d+4>>2]);break o}M[d+16>>2]=0;break o}c=d-20|0;M[c>>2]=M[d+4>>2]|M[c>>2];break o}c=M[d+4>>2];Ie:{e=M[d+8>>2];if((e|0)!=5){break Ie}if(Eb(c,15195,5)){break Ie}M[d-8>>2]=640;break o}M[d-8>>2]=0;M[i+4>>2]=c;M[i>>2]=e;cb(f,6069,i);break o}c=M[d+4>>2];Je:{Ke:{e=M[d+8>>2];if((e|0)!=6){break Ke}if(Eb(c,3462,6)){break Ke}c=65536;break Je}M[i+20>>2]=c;M[i+16>>2]=e;cb(f,6069,i+16|0);c=0}M[d+4>>2]=c;break o}c=N[d+8|0]|N[d+9|0]<<8|(N[d+10|0]<<16|N[d+11|0]<<24);j=N[d+4|0]|N[d+5|0]<<8|(N[d+6|0]<<16|N[d+7|0]<<24);M[i+712>>2]=j;M[i+716>>2]=c;e=d-8|0;g=N[e+4|0]|N[e+5|0]<<8|(N[e+6|0]<<16|N[e+7|0]<<24);M[i+704>>2]=N[e|0]|N[e+1|0]<<8|(N[e+2|0]<<16|N[e+3|0]<<24);M[i+708>>2]=g;n=M[f+252>>2];if(!n){break o}g=M[f>>2];if(M[g+128>>2]<=L[n+34>>1]){M[i+48>>2]=M[n>>2];cb(f,6630,i+48|0);break o}if(N[f+224|0]<=1){mt(i+704|0)}Le:{Me:{if(c>>>0<16){break Me}if(Eb((c+j|0)-6|0,3680,6)){break Le}e=j-1|0;c=c-6|0;p=1;while(1){k=65;if(!c){break q}if(K[N[c+e|0]+31408|0]&1){c=c-1|0;continue}break}M[i+716>>2]=c;if(c>>>0<9){break Me}if(Eb((c+j|0)-9|0,15688,9)){break Le}c=c-9|0;while(1){if(!c){break q}if(K[N[c+e|0]+31408|0]&1){c=c-1|0;continue}break}M[i+716>>2]=c}if(c>>>0>=3){break Le}k=65;p=1;break p}mt(i+712|0);j=M[i+712>>2];c=M[i+716>>2];p=1;e=0;while(1){if((e|0)==6){k=65;break p}Ne:{if(N[e+50920|0]!=(c|0)){break Ne}if(Eb(j,M[(e<<2)+68240>>2],c)){break Ne}p=(e&3)==1?5:1;q=(e<<4)+16|0;k=N[e+50864|0];c=0;break p}e=e+1|0;continue}}c=O[d+2>>1];e=M[d+8>>2];M[i+688>>2]=M[d+4>>2];M[i+692>>2]=e;j=De(f,c,i+688|0);Oe:{if(!j){break Oe}g=M[j+8>>2];if(N[g|0]==48){h=(N[g+1|0]&223)==88}K[j|0]=156;e=g;while(1){c=N[e|0];Pe:{Qe:{if((c|0)!=95){K[g|0]=c;g=g+1|0;c=N[e|0];if(!((c|0)==46|(c|0)==101)&(c|0)!=69){break Pe}K[j|0]=154;break Qe}c=N[e-1|0];Re:{if(!h){if(c-58>>>0<4294967286|N[e+1|0]-58>>>0<4294967286){break Re}break Qe}if(!(N[c+31408|0]&8)){break Re}if(N[N[e+1|0]+31408|0]&8){break Qe}}M[i+672>>2]=M[j+8>>2];cb(f,29935,i+672|0)}c=N[e|0]}e=e+1|0;if(c&255){continue}break}Se:{if(h){K[j|0]=156;break Se}if(N[j|0]!=156){break Oe}}if(!Af(M[j+8>>2],i+712|0)){break Oe}M[j+8>>2]=M[i+712>>2];M[j+4>>2]=M[j+4>>2]|2048}M[d+4>>2]=j;break o}M[d-44>>2]=M[d-8>>2];break o}c=d-8|0;e=ub(M[f>>2],100,0);M[c>>2]=e;if(!e){break o}e=Kd(M[f>>2],M[d+4>>2],M[d+8>>2],0);M[M[c>>2]>>2]=e;break o}M[d-32>>2]=M[d-8>>2];break o}c=ub(M[f>>2],100,0);Te:{if(c){K[c+16|0]=167;M[c+40>>2]=M[d+4>>2];break Te}kb(M[f>>2],M[d+4>>2])}M[d+4>>2]=c;break o}c=M[d+4>>2];Ue:{if(c){M[c+40>>2]=M[d-8>>2];break Ue}kb(M[f>>2],M[d-8>>2])}M[d-8>>2]=M[d+4>>2];break o}M[d-8>>2]=M[d+4>>2];break o}K[d+4|0]=N[d+2|0];break o}K[d-8|0]=N[d-10|0];break o}K[d-8|0]=N[d+4|0];break o}K[d+16|0]=0;break o}c=d-8|0;M[d-4>>2]=M[c>>2];M[c>>2]=O[d+2>>1];break o}M[d-4>>2]=0;M[d-8>>2]=O[d-10>>1];break o}c=d-56|0;I=c,J=Qn(f,M[c>>2],M[d-32>>2],M[d-28>>2],M[d-8>>2],M[d-4>>2],N[d+4|0]),M[I>>2]=J;break o}c=d-20|0;I=c,J=Qn(f,M[c>>2],M[d-8>>2],M[d-4>>2],86,0,N[d+4|0]),M[I>>2]=J;break o}I=d,J=Qn(f,0,91,0,86,0,0),M[I+16>>2]=J;break o}c=d-8|0;I=c,J=Ri(f,M[d+4>>2],0,0,c),M[I>>2]=J;break o}c=d-44|0;I=c,J=Ri(f,M[d+4>>2],0,M[d-8>>2],c),M[I>>2]=J;break o}I=d-32|0,J=Ri(f,M[d+4>>2],0,M[d-8>>2],0),M[I>>2]=J;break o}c=d-56|0;I=c,J=Ri(f,M[d+4>>2],M[d-20>>2],M[d-8>>2],c),M[I>>2]=J;break o}I=d-44|0,J=Ri(f,M[d+4>>2],M[d-20>>2],M[d-8>>2],0),M[I>>2]=J;break o}e=d-44|0;c=d-8|0;if(M[c>>2]){g=Kd(M[f>>2],M[e>>2],M[d-40>>2],0);M[M[c>>2]>>2]=g;c=M[c>>2]}else{c=0}M[e>>2]=c;break o}c=d-20|0;lt(f,M[d+4>>2],M[c>>2]);M[M[d+4>>2]+36>>2]=M[c>>2];M[c>>2]=M[d+4>>2];break o}c=d-20|0;I=c,J=jt(f,M[c>>2],M[d+4>>2]),M[I>>2]=J;break o}I=d,J=jt(f,0,M[d+4>>2]),M[I+4>>2]=J;break o}K[f+27|0]=1;break o}g=d-56|0;k=N[d-32|0];h=M[d-8>>2];j=M[d-44>>2];e=M[f>>2];c=ub(e,24,0);Ve:{if(N[e+87|0]){xb(e,j);pc(e,h);break Ve}M[c+4>>2]=j;M[c+8>>2]=h;e=zc(M[f>>2],g);K[c+20|0]=k;M[c>>2]=e}M[g>>2]=c;break o}K[d-20|0]=2;break o}K[d-8|0]=0;break o}K[d+4|0]=1;break o}it(f,M[d+4>>2]);break o}c=M[d+4>>2];e=M[f+268>>2];We:{if(!e){M[f+268>>2]=c;c=M[d+8>>2];break We}c=(c+M[d+8>>2]|0)-e|0}M[f+272>>2]=c;break o}ht(f);M[f+268>>2]=0;M[f+272>>2]=0;break o}Sn(f,d-32|0,d-20|0,0,0,1,M[d-44>>2]);c=M[f+252>>2];if(!c){break o}K[c+43|0]=1;e=M[f>>2];Wg(f,c,zc(e,d+4|0));Wg(f,c,0);Wg(f,c,_b(e,M[c>>2]));M[f+208>>2]=(M[d+4>>2]+M[d+8>>2]|0)-M[f+204>>2];g=M[c+48>>2];if(!g){break o}gc(f,29,M[c>>2],M[g>>2],M[M[M[f>>2]+16>>2]+(Mb(e,M[c+60>>2])<<4)>>2]);break o}gt(f,d+4|0);break o}gt(f,0);break o}j=M[f>>2];Xe:{Ye:{p=M[d-56>>2];h=mf(f,0,p+8|0);if(!h){break Ye}c=0;if(Jk(f,h)){break Xe}c=0;if(ft(f,h,0)){break Xe}c=M[j+16>>2];l=Mb(j,M[h+60>>2]);k=M[c+(l<<4)>>2];if(gc(f,26,k,M[h>>2],0)){break Ye}q=d-20|0;e=zc(j,q);c=0;if(!e){break Xe}n=d+4|0;m=L[h+34>>1];c=(m|0)>0?m:0;while(1){Ze:{if((c|0)!=(g|0)){if(hb(M[M[h+4>>2]+S(g,12)>>2],e)){break Ze}c=g}_e:{$e:{af:{if((c|0)==(m|0)){M[i+592>>2]=q;cb(f,29963,i+592|0);break af}m=(l|0)==1;Qi(f,k,m,30808,0);et(f,k,m);g=M[f+132>>2];K[(g?g:f)+21|0]=1;g=zc(j,n);if(g){break $e}}g=0;break _e}n=N[M[n>>2]];q=M[h>>2];M[i+668>>2]=q;M[i+664>>2]=m;M[i+656>>2]=g;n=N[n+31408|0]&128;M[i+660>>2]=n;M[i+652>>2]=c;M[i+648>>2]=q;M[i+644>>2]=k;M[i+640>>2]=k;sc(f,25896,i+640|0);h=M[h>>2];M[i+624>>2]=n;M[i+620>>2]=g;M[i+616>>2]=c;M[i+612>>2]=h;M[i+608>>2]=k;sc(f,27100,i+608|0);Ik(f,l,1);Qi(f,k,m,14010,1)}c=e;break Xe}g=g+1|0;continue}}c=0}Gc(j,p);eb(j,c);eb(j,g);break o}nt(f);j=M[d+4>>2];g=M[f>>2];bf:{if(N[g+87|0]){break bf}h=mf(f,0,j+8|0);if(!h){break bf}cf:{switch(N[h+43|0]-1|0){case 0:cb(f,15802,0);break bf;case 1:cb(f,1810,0);break bf;default:break cf}}if(Jk(f,h)){break bf}c=M[f+132>>2];K[(c?c:f)+21|0]=1;l=Mb(g,M[h+60>>2]);c=ub(g,64,0);if(!c){break bf}M[f+252>>2]=c;M[c+24>>2]=1;e=L[h+34>>1];L[c+34>>1]=e;I=c,J=ub(g,S((e-1|0)/8|0,96)+96|0,0),M[I+4>>2]=J;M[i+576>>2]=M[h>>2];e=tb(g,6123,i+576|0);M[c>>2]=e;k=M[c+4>>2];if(!k|!e){break bf}e=S(L[c+34>>1],12);if(e){G(k,M[h+4>>2],e)}e=0;while(1){if(L[c+34>>1]>(e|0)){k=M[c+4>>2]+S(e,12)|0;m=_b(g,M[k>>2]);M[k>>2]=m;I=k,J=Uf(m),K[I+7|0]=J;e=e+1|0;continue}break}I=c,J=xc(g,M[h+52>>2],0),M[I+52>>2]=J;M[c+60>>2]=M[(M[g+16>>2]+(l<<4)|0)+12>>2];M[c+44>>2]=M[h+44>>2]}Gc(g,j);break o}w=M[d-32>>2];p=M[f>>2];df:{if(N[p+87|0]){break df}l=mf(f,0,w+8|0);if(!l){break df}if(Jk(f,l)){break df}if(ft(f,l,1)){break df}e=d+4|0;j=zc(p,e);if(!j){break df}q=Pn(l,j);ef:{if((q|0)<0){M[i+512>>2]=e;cb(f,29963,i+512|0);break ef}c=O[(M[l+4>>2]+S(q,12)|0)+10>>1];if(c&9){M[i+564>>2]=j;M[i+560>>2]=c&1?18603:20387;cb(f,29886,i+560|0);break ef}if(L[l+34>>1]<=1){M[i+528>>2]=j;cb(f,2282,i+528|0);break ef}e=M[p+16>>2];c=Mb(p,M[l+60>>2]);e=M[e+(c<<4)>>2];if(gc(f,26,e,M[l>>2],j)){break ef}g=(c|0)==1;Qi(f,e,g,30808,0);et(f,e,g);M[i+556>>2]=M[l>>2];M[i+552>>2]=q;M[i+548>>2]=c;M[i+544>>2]=e;sc(f,25567,i+544|0);Ik(f,c,2);Qi(f,e,g,11082,1);if(M[f+40>>2]|N[(M[l+4>>2]+S(q,12)|0)+10|0]&32){break ef}h=Cb(f);n=M[f+44>>2];M[f+44>>2]=n+1;Pd(f,n,c,l,113);v=fb(h,36,n);e=M[f+48>>2];r=e+1|0;M[f+48>>2]=r;ff:{if(!(N[l+28|0]&128)){$a(h,135,n,r);k=e+2|0;g=0;c=0;e=M[f+48>>2]+L[l+34>>1]|0;break ff}c=qc(l);M[f+48>>2]=r+O[c+52>>1];k=e+2|0;e=0;while(1){g=O[c+50>>1];if(g>>>0>e>>>0){bb(h,94,n,e,e+k|0);e=e+1|0;continue}break}e=M[f+48>>2]}u=e+1|0;M[f+48>>2]=u;e=0;while(1){if(L[l+34>>1]>(e|0)){gf:{if((e|0)==(q|0)){break gf}x=S(e,12);A=x+M[l+4>>2]|0;if(N[A+10|0]&32){break gf}hf:{if(c){m=We(c,e<<16>>16);B=We(c,q<<16>>16);if((m|0)<O[c+50>>1]){break gf}m=(k+m|0)-((m|0)>(B|0))|0;break hf}m=g+k|0}jf:{if(L[l+32>>1]==(e|0)){$a(h,75,0,m);break jf}B=N[A+5|0];if((B|0)==69){K[A+5|0]=67}Ed(h,l,n,e,m);K[(x+M[l+4>>2]|0)+5|0]=B}g=g+1|0}e=e+1|0;continue}break}if(!g){M[f+48>>2]=M[f+48>>2]+1;$a(h,75,0,k);g=1}bb(h,97,k,g,u);kf:{if(c){lb(h,138,n,u,k,O[c+50>>1]);break kf}bb(h,128,n,u,r)}c=M[h+108>>2];if((c|0)>0){L[(M[h+104>>2]+S(c,20)|0)-18>>1]=2}$a(h,39,n,v+1|0);e=M[h+108>>2];M[(N[M[h>>2]+87|0]?74356:M[h+104>>2]+S(v,20)|0)+8>>2]=e}c=j}eb(p,c);Gc(p,w);break o}n=d-4|0;p=d-8|0;M[n>>2]=M[f+216>>2]+(M[f+212>>2]-M[p>>2]|0);if(M[f+40>>2]){break o}h=M[f>>2];c=M[h+16>>2];e=M[f+252>>2];k=Mb(h,M[e+60>>2]);g=M[c+(k<<4)>>2];l=M[e+4>>2]+S(L[e+34>>1],12)|0;c=Tc(e,l-12|0);j=M[e>>2]+16|0;q=Hc(h,j,g);if(gc(f,26,g,M[q>>2],0)){break o}r=l-2|0;m=O[r>>1];if(m&1){cb(f,11211,0);break o}if(M[e+8>>2]){cb(f,11243,0);break o}lf:{if(!(m&96)){c=c?N[M[c+12>>2]]!=122?c:0:0;if(!(!(N[h+33|0]&64)|(!M[e+48>>2]|!c))){Hk(f,g,j,13100)}if(!(c|!(N[l-8|0]&15))){Hk(f,g,j,20170);break lf}if(!c){break lf}M[i+712>>2]=0;if(oj(h,c,1,65,i+712|0)){break o}c=M[i+712>>2];if(!c){Hk(f,g,j,3059)}Xc(c);break lf}if(!(m&64)){break lf}Hk(f,g,j,11270)}m=Kd(h,M[p>>2],M[n>>2],0);if(m){c=m+M[n>>2]|0;while(1){mf:{c=c-1|0;if(m>>>0>=c>>>0){break mf}n=N[c|0];if((n|0)!=59&!(K[n+31408|0]&1)){break mf}K[c|0]=0;continue}break}c=M[e+44>>2];M[i+496>>2]=j;M[i+492>>2]=c;M[i+488>>2]=m;M[i+484>>2]=c;M[i+480>>2]=g;sc(f,19833,i+480|0);ib(h,m)}c=Cb(f);if(!c){break o}h=Gb(f);bb(c,99,k,h,2);se(c,k);$a(c,86,h,-2);$a(c,50,h,M[c+108>>2]+2|0);bb(c,100,k,2,3);zb(f,h);Ik(f,k,3);if(!(M[e+16>>2]|(N[r|0]&96?N[l-8|0]&15:0)|K[q+30|0]&1)){break o}M[i+468>>2]=g;M[i+464>>2]=j;sc(f,28592,i+464|0);break o}m=M[d-32>>2];k=M[f>>2];nf:{if(N[k+87|0]){break nf}j=mf(f,0,m+8|0);if(!j){break nf}e=M[k+16>>2];l=Mb(M[f>>2],M[j+60>>2]);h=M[e+(l<<4)>>2];e=zc(k,d+4|0);if(!e){break nf}of:{pf:{qf:{if(Hc(k,e,h)){break qf}if(nf(k,e,h)){break qf}if(!dt(k,j,e)){break pf}}M[i+448>>2]=e;cb(f,8291,i+448|0);break of}if(Jk(f,j)){break of}if(Gk(f,e,14426,e)){break of}c=M[j>>2];if(N[j+43|0]==2){M[i+320>>2]=c;cb(f,15836,i+320|0);break of}if(gc(f,26,h,c,0)){break of}if(lf(f,j)){break of}if(N[j+43|0]==1){c=Gd(k,j);g=M[M[M[c+8>>2]>>2]+76>>2]?c:0}n=Cb(f);if(!n){break of}c=M[f+132>>2];K[(c?c:f)+21|0]=1;c=M[j>>2];q=mw(c);M[i+436>>2]=c;p=(l|0)==1;M[i+432>>2]=p;M[i+428>>2]=e;M[i+424>>2]=c;M[i+420>>2]=h;M[i+416>>2]=h;sc(f,28408,i+416|0);M[i+404>>2]=c;M[i+400>>2]=q;M[i+396>>2]=e;M[i+392>>2]=e;M[i+388>>2]=e;M[i+384>>2]=h;sc(f,22450,i+384|0);if(Hc(k,14816,h)){M[i+376>>2]=M[j>>2];M[i+372>>2]=e;M[i+368>>2]=h;sc(f,19775,i+368|0)}if(!p){M[i+356>>2]=e;M[i+352>>2]=h;M[i+348>>2]=c;M[i+344>>2]=e;M[i+340>>2]=c;M[i+336>>2]=h;sc(f,27231,i+336|0)}if(g){c=M[f+48>>2]+1|0;M[f+48>>2]=c;Uc(n,c,e);nb(n,177,c,0,0,g,-11)}Ik(f,l,1);Qi(f,h,p,14010,0)}c=e}Gc(k,m);eb(k,c);break o}ct(f,d-8|0,d+4|0);break o}ct(f,0,0);break o}bt(f,d-8|0,d+4|0);break o}bt(f,0,0);break o}c=M[d+4>>2];at(f,25,51672,c,0,0,c);break o}c=M[d-32>>2];at(f,24,51556,c,c,M[d-8>>2],M[d+4>>2]);break o}c=M[d+4>>2];g=M[f>>2];rf:{if(N[g+87|0]){break rf}k=M[d-8>>2];if(de(f)){break rf}m=c+8|0;l=M[c+8>>2];h=M[c+52>>2];e=0;sf:{while(1){if(M[g+20>>2]>(e|0)){j=e>>>0<2^e;tf:{if(h){if(!Lk(g,j,h)){break tf}}j=Sc(M[(M[g+16>>2]+(j<<4)|0)+12>>2]+40|0,l);if(j){break sf}}e=e+1|0;continue}break}uf:{if(!k){M[i+304>>2]=m;cb(f,19405,i+304|0);break uf}Pi(f,h)}K[f+17|0]=1;break rf}$s(f,j)}Gc(g,c);break o}M[d+4>>2]=3;break o}M[d+4>>2]=1;break o}c=ob(f,72,M[d-8>>2],0);M[d-56>>2]=c;if(!c){break o}K[c+1|0]=M[d-32>>2];break o}c=ob(f,72,0,0);M[d-32>>2]=c;if(!c){break o}K[c+1|0]=4;break o}h=d-20|0;j=M[h>>2];e=M[d-8>>2];k=M[d+4>>2];g=M[f>>2];c=ub(g,48,0);vf:{if(!c){pc(g,e);break vf}M[c+8>>2]=e;L[c>>1]=2955;I=c,J=_s(g,j,k),M[I+36>>2]=J}M[h>>2]=c;break o}c=M[d-8>>2];h=M[f>>2];j=d-56|0;g=Nn(f,129,d-32|0,M[j>>2],M[d+4>>2]);if(g){wf:{if(N[f+224|0]>1){e=c;c=0;break wf}e=qb(h,c,1)}K[g+1|0]=11;M[g+20>>2]=e}kb(h,c);M[j>>2]=g;break o}h=M[d-8>>2];m=M[d-68>>2];c=M[d-20>>2];k=M[d-32>>2];j=M[f>>2];l=d-80|0;e=Nn(f,128,d-44|0,M[l>>2],M[d+4>>2]);xf:{if(e){yf:{if(N[f+224|0]>1){g=c;c=0;break yf}g=le(j,c,1)}M[e+32>>2]=h;M[e+28>>2]=k;M[e+8>>2]=g;K[e+1|0]=m;if(!h){break xf}Fk(f,M[h>>2]);break xf}ye(j,k);Kk(j,h)}pc(j,c);M[l>>2]=e;break o}m=M[d-80>>2];g=M[d-8>>2];c=M[d-32>>2];h=M[d-20>>2];k=M[f>>2];l=d-92|0;j=Nn(f,130,d-68|0,M[l>>2],M[d+4>>2]);if(j){zf:{if(N[f+224|0]>=2){M[j+20>>2]=g;M[j+24>>2]=c;g=0;e=h;c=0;h=0;break zf}I=j,J=xc(k,c,1),M[I+24>>2]=J;I=j,J=qb(k,g,1),M[I+20>>2]=J;e=xh(k,h,1)}K[j+1|0]=m;M[j+16>>2]=e}xb(k,c);kb(k,g);Gc(k,h);M[l>>2]=j;break o}cb(f,4588,0);break o}cb(f,4504,0);break o}e=M[d+8>>2];c=d-20|0;M[c>>2]=M[d+4>>2];M[c+4>>2]=e;cb(f,4673,0);break o}c=M[d-8>>2];M[c+44>>2]=c;break o}c=d-20|0;e=M[d-8>>2];M[M[M[c>>2]+44>>2]+40>>2]=e;M[M[c>>2]+44>>2]=e;break o}M[d-8>>2]=M[d+4>>2];break o}M[d+16>>2]=0;break o}M[d-20>>2]=130;M[d-16>>2]=M[d+4>>2];break o}M[d+8>>2]=0;M[d+4>>2]=O[d+2>>1];break o}M[d+16>>2]=33;break o}M[d-8>>2]=66;break o}M[d+4>>2]=O[d+2>>1];break o}w=d-68|0;r=d-80|0;m=M[d-92>>2];n=M[d-20>>2];c=M[d-40>>2];A=M[d-44>>2];q=M[d-56>>2];l=M[f>>2];h=M[d+4>>2];Af:{Bf:{Cf:{u=d-116|0;v=M[u>>2];Df:{if(v){if(M[d+-64>>2]){cb(f,14071,0);break Bf}M[i+704>>2]=r;k=1;if(n){break Df}break Cf}k=Tf(f,r,w,i+704|0);if(!n|(k|0)<0){break Bf}}if(N[l+87|0]){break Bf}if(!(!N[l+177|0]|(k|0)==1)){eb(l,M[n+52>>2]);M[n+52>>2]=0}e=wh(f,n);k=N[l+177|0]|(M[d+-64>>2]|!e)?k:M[e+60>>2]==M[M[l+16>>2]+28>>2]?1:k;if(N[l+87|0]){break Bf}e=M[f>>2];M[i+712>>2]=f;e=M[e+16>>2]+(k<<4)|0;M[i+752>>2]=M[e>>2];M[i+744>>2]=M[e+12>>2];M[i+716>>2]=f;M[i+720>>2]=11;M[i+724>>2]=12;M[i+728>>2]=13;M[i+732>>2]=0;L[i+736>>1]=0;K[i+748|0]=(k|0)==1;M[i+756>>2]=9499;e=M[i+704>>2];M[i+760>>2]=e;j=i+712|0;M[i+740>>2]=j;if(Mn(j,n)){break Bf}j=0;Ef:{p=wh(f,n);if(!p){break Ef}if(N[p+43|0]==1){cb(f,5600,0);break Ef}Ff:{if(!(N[p+29|0]&16)){break Ff}if(!vh(l)){break Ff}cb(f,5560,0);break Ef}g=zc(l,e);if(!g){break Cf}if(Gk(f,g,9499,M[p>>2])){break Bf}Gf:{if(N[f+224|0]>1){break Gf}if(!Sc(M[(M[l+16>>2]+(k<<4)|0)+12>>2]+40|0,g)){break Gf}if(!m){M[i+288>>2]=e;cb(f,3824,i+288|0);break Bf}ud(f,k);break Bf}m=M[p>>2];if(!Eb(m,18301,7)){cb(f,14272,0);break Af}e=N[p+43|0];if(!((q|0)==66|(e|0)!=2)){M[i+260>>2]=n+8;M[i+256>>2]=(q|0)==33?20444:19629;cb(f,19368,i+256|0);break Ef}if(!((e|0)==2|(q|0)!=66)){M[i+272>>2]=n+8;cb(f,19425,i+272|0);break Ef}if(N[f+224|0]<=1){j=M[l+16>>2];x=Mb(l,M[p+60>>2]);e=M[j+(x<<4)>>2];x=(x|0)==1;if(gc(f,v?5:x?5:7,g,m,v?M[j+16>>2]:e)){break Bf}j=0;if(gc(f,18,x?9290:9309,0,e)){break Af}}j=ub(l,36,0);if(!j){break Bf}M[j>>2]=g;e=_b(l,M[n+8>>2]);M[j+4>>2]=e;M[j+20>>2]=M[(M[l+16>>2]+(k<<4)|0)+12>>2];g=M[p+60>>2];K[j+9|0]=(q|0)==66?1:(q|0)==33?1:2;K[j+8|0]=A;M[j+24>>2]=g;Hf:{if(N[f+224|0]>=2){kd(f,e,M[n+8>>2]);g=h;h=0;break Hf}g=qb(l,h,1)}M[j+16>>2]=c;M[j+12>>2]=g;M[f+260>>2]=j;g=0;c=0;break Af}if(N[l+176|0]!=1){break Af}K[l+178|0]=N[l+178|0]|1;break Af}g=0}j=0}eb(l,g);Gc(l,n);ye(l,c);kb(l,h);if(!M[f+260>>2]){Vh(l,j)}if(!M[d+-64>>2]){c=M[r+4>>2];M[u>>2]=M[r>>2];M[u+4>>2]=c;break o}c=M[w+4>>2];M[u>>2]=M[w>>2];M[u+4>>2]=c;break o}e=M[d-8>>2];q=M[d-32>>2];j=M[f>>2];c=M[f+260>>2];g=M[d+8>>2];h=M[d+4>>2];M[f+260>>2]=0;If:{if(M[f+40>>2]|!c){break If}r=g+(h-q|0)|0;n=M[c>>2];m=Mb(j,M[c+20>>2]);M[c+28>>2]=e;g=c+28|0;while(1){if(e){M[e+4>>2]=c;e=M[e+40>>2];continue}break}M[i+704>>2]=n;e=jb(n);M[i+712>>2]=f;M[i+708>>2]=e;e=M[j+16>>2]+(m<<4)|0;M[i+752>>2]=M[e>>2];e=M[e+12>>2];M[i+756>>2]=9499;M[i+744>>2]=e;K[i+748|0]=(m|0)==1;L[i+736>>1]=0;M[i+732>>2]=0;M[i+728>>2]=13;M[i+724>>2]=12;M[i+720>>2]=11;M[i+716>>2]=f;M[i+760>>2]=i+704;M[i+740>>2]=i+712;k=i+716|0;e=g;while(1){l=M[e>>2];if(l){e=0;if(oc(k,M[l+8>>2])){break If}if(Nb(k,M[l+20>>2])){break If}if(ec(k,M[l+24>>2])){break If}if(Mn(i+712|0,M[l+16>>2])){break If}h=l+32|0;while(1){p=M[h>>2];if(p){if(ec(k,M[p>>2])){break If}if(Nb(k,M[p+4>>2])){break If}if(ec(k,M[p+8>>2])){break If}h=p+16|0;if(!Nb(k,M[p+12>>2])){continue}break If}break}e=l+40|0;continue}break}e=0;if(Nb(k,M[c+12>>2])){break If}Jf:{if(N[f+224|0]>=2){M[f+260>>2]=c;c=0;break Jf}if(N[j+177|0]){break Jf}Kf:{if(!vh(j)){break Kf}while(1){g=M[g>>2];if(!g){break Kf}Lf:{h=M[g+12>>2];if(h){if(Ln(j,h)){break Lf}}g=g+40|0;continue}break}h=M[c>>2];M[i+244>>2]=M[g+12>>2];M[i+240>>2]=h;cb(f,29656,i+240|0);break If}h=Cb(f);if(!h){break If}jd(f,0,m);g=Kd(j,q,r,0);k=M[M[j+16>>2]+(m<<4)>>2];l=M[c+4>>2];M[i+236>>2]=g;M[i+232>>2]=l;M[i+228>>2]=n;M[i+224>>2]=k;sc(f,27511,i+224|0);eb(j,g);Sf(f,m);M[i+208>>2]=n;uh(h,m,tb(j,28331,i+208|0),0)}if(!N[j+177|0]){break If}g=wd(M[(M[j+16>>2]+(m<<4)|0)+12>>2]+40|0,n,c);if(g){Lb(j);c=g;break If}g=M[c+24>>2];if((g|0)==M[c+20>>2]){g=Sc(g+8|0,M[c+4>>2]);M[c+32>>2]=M[g+56>>2];M[g+56>>2]=c}c=0}Vh(j,c);On(j,e);break o}Oi(f,d-44|0,d-32|0,d-8|0,1);break o}Oi(f,d-32|0,d-20|0,d+4|0,1);break o}Oi(f,d-44|0,d-32|0,d-8|0,0);break o}Oi(f,d-32|0,d-20|0,d+4|0,0);break o}Oi(f,d-8|0,d+4|0,0,0);break o}Zs(f,d-8|0,M[d+4>>2]);break o}Zs(f,0,M[d+4>>2]);break o}g=M[d+4>>2];h=M[f>>2];Mf:{if(N[h+87|0]){break Mf}e=M[d-8>>2];if(de(f)){break Mf}c=nf(h,M[g+8>>2],M[g+52>>2]);if(!c){Nf:{if(!e){M[i+160>>2]=g+8;cb(f,19350,i+160|0);break Nf}Pi(f,M[g+52>>2]);Ek(f)}K[f+17|0]=1;break Mf}if(N[c+55|0]&3){M[i+192>>2]=0;cb(f,15898,i+192|0);break Mf}j=M[c+12>>2];e=Mb(h,M[c+24>>2]);k=(e|0)==1;m=M[M[h+16>>2]+(e<<4)>>2];if(gc(f,9,k?9290:9309,0,m)){break Mf}if(gc(f,k?12:10,M[c>>2],M[j>>2],m)){break Mf}j=Cb(f);if(!j){break Mf}jd(f,1,e);k=M[M[h+16>>2]+(e<<4)>>2];M[i+180>>2]=M[c>>2];M[i+176>>2]=k;sc(f,27844,i+176|0);Ys(f,e,1597,M[c>>2]);Sf(f,e);Xs(f,M[c+44>>2],e);nb(j,152,e,0,0,M[c>>2],0)}Gc(h,g);break o}c=d-20|0;I=c,J=Ws(f,0,c,M[d-8>>2],M[d+4>>2]),M[I>>2]=J;break o}c=d-44|0;I=c,J=Ws(f,M[c>>2],d-20|0,M[d-8>>2],M[d+4>>2]),M[I>>2]=J;break o}M[d+16>>2]=0;break o}M[d+4>>2]=2;break o}c=d-44|0;Ni(f,d-80|0,d-68|0,Od(f,0,c,0),M[d-20>>2],M[d-116>>2],d-128|0,M[d+4>>2],0,M[d-92>>2],0);if(N[f+224|0]<2){break o}e=M[f+256>>2];if(!e){break o}Ce(f,M[e>>2],c);break o}M[d-20>>2]=M[d-8>>2];break o}I=d,J=ed(M[f>>2],M[d+4>>2]),M[I+4>>2]=J;break o}c=d-20|0;I=c,J=Wb(f,M[c>>2],M[d+4>>2]),M[I>>2]=J;break o}c=d-32|0;e=ed(M[f>>2],M[d-20>>2]);M[c>>2]=e;I=c,J=Wb(f,e,M[d+4>>2]),M[I>>2]=J;break o}c=d-44|0;e=Wb(f,M[c>>2],M[d-20>>2]);M[c>>2]=e;I=c,J=Wb(f,e,M[d+4>>2]),M[I>>2]=J;break o}g=d-44|0;e=ob(f,158,M[d-32>>2],0);M[g>>2]=e;if(e){c=M[d-20>>2];h=M[d-8>>2];if(h){c=Wb(f,c,h);e=M[g>>2]}M[e+20>>2]=c;Dk(f,M[g>>2]);break o}xb(M[f>>2],M[d-20>>2]);kb(M[f>>2],M[d-8>>2]);break o}c=ob(f,20,0,0);M[d-32>>2]=c;Gg(f,c,M[d-8>>2]);break o}c=Od(f,0,d-20|0,d-8|0);e=td(f,0,c,0,0,0,0,0,0);g=M[d+4>>2];if(g){Vs(f,e?c:0,g)}c=d-44|0;g=ob(f,50,M[c>>2],0);M[c>>2]=g;Gg(f,g,e);if(!M[d-32>>2]){break o}I=c,J=ob(f,19,M[c>>2],0),M[I>>2]=J;break o}c=d-44|0;e=ob(f,50,M[c>>2],0);M[c>>2]=e;Gg(f,e,M[d-8>>2]);if(!M[d-32>>2]){break o}I=c,J=ob(f,19,M[c>>2],0),M[I>>2]=J;break o}c=ob(f,139,0,0);M[d-20>>2]=c;Gg(f,c,M[d-8>>2]);break o}e=d-8|0;c=M[e>>2];if(!c){c=d-44|0;Us(f,M[c>>2]);e=c;c=wc(M[f>>2],118,M[d-32>>2]?13070:13603);M[e>>2]=c;if(!c){break o}Ck(c);break o}Of:{Pf:{if(M[c>>2]!=1){break Pf}Qf:{g=M[c+8>>2];if(!Nd(f,g)){c=M[e>>2];break Qf}c=M[e>>2];h=d-44|0;if(N[M[h>>2]]==177){break Qf}M[c+8>>2]=0;xb(M[f>>2],M[e>>2]);c=ob(f,173,g,0);I=h,J=ob(f,54,M[h>>2],c),M[I>>2]=J;break Of}if(M[c>>2]!=1|N[g|0]!=139){break Pf}h=d-44|0;c=ob(f,50,M[h>>2],0);M[h>>2]=c;Gg(f,c,M[g+20>>2]);M[g+20>>2]=0;xb(M[f>>2],M[e>>2]);break Of}h=d-44|0;c=ob(f,50,M[h>>2],0);M[h>>2]=c;if(!c){xb(M[f>>2],M[e>>2]);break Of}g=M[c+12>>2];if(N[g|0]==177){j=M[e>>2];l=j+8|0;m=M[M[g+20>>2]>>2];c=0;e=0;while(1){Rf:{Sf:{if(M[j>>2]>(e|0)){g=1;k=M[l+(e<<4)>>2];if(N[k|0]==177){g=M[M[k+20>>2]>>2]}if((g|0)==(m|0)){g=td(f,M[k+20>>2],0,0,0,0,0,512,0);M[k+20>>2]=0;if(!g){break Rf}if(!c){break Sf}M[g+52>>2]=c;K[g|0]=136;break Sf}M[i+152>>2]=m;M[i+144>>2]=g;M[i+148>>2]=(g|0)>1?8933:30808;cb(f,17385,i+144|0)}if(c){if(M[c+52>>2]){M[c+4>>2]=M[c+4>>2]|1024}xf(M[f>>2],j);Bk(f,c);Gg(f,M[h>>2],c);break Of}xf(M[f>>2],j);break Of}c=g}e=e+1|0;continue}}M[c+20>>2]=M[e>>2];Dk(f,M[h>>2])}if(!M[d-32>>2]){break o}c=d-44|0;I=c,J=ob(f,19,M[c>>2],0),M[I>>2]=J;break o}g=Wb(f,ed(M[f>>2],M[d-20>>2]),M[d+4>>2]);c=d-44|0;e=ob(f,49,M[c>>2],0);M[c>>2]=e;Tf:{if(e){M[e+20>>2]=g;break Tf}xb(M[f>>2],g)}if(!M[d-32>>2]){break o}I=c,J=ob(f,19,M[c>>2],0),M[I>>2]=J;break o}M[d+4>>2]=0;break o}c=d-20|0;e=ed(M[f>>2],M[c>>2]);I=c,J=Be(f,Wb(f,e,M[d+4>>2]),d-8|0,0),M[I>>2]=J;break o}e=N[d-10|0]+66|0;c=M[d+4>>2];if(!(!c|N[c|0]!=173)){K[c|0]=e;M[d-8>>2]=c;break o}I=d-8|0,J=ob(f,e&255,c,0),M[I>>2]=J;break o}I=d-8|0,J=ob(f,O[d-10>>1],M[d+4>>2],0),M[I>>2]=J;break o}e=d-44|0;c=ob(f,46,M[e>>2],M[d+4>>2]);M[e>>2]=c;Ak(f,M[d+4>>2],c,52);break o}e=d-56|0;c=ob(f,45,M[e>>2],M[d+4>>2]);M[e>>2]=c;Ak(f,M[d+4>>2],c,51);break o}e=d-32|0;c=ob(f,46,M[e>>2],M[d+4>>2]);M[e>>2]=c;Ak(f,M[d+4>>2],c,52);break o}e=d-20|0;c=ob(f,45,M[e>>2],M[d+4>>2]);M[e>>2]=c;Ak(f,M[d+4>>2],c,51);break o}c=d-20|0;I=c,J=ob(f,52,M[c>>2],0),M[I>>2]=J;break o}c=d-8|0;I=c,J=ob(f,O[d+2>>1],M[c>>2],0),M[I>>2]=J;break o}e=d-28|0;c=M[e>>2];M[e>>2]=c&2147483647;g=d-44|0;e=Be(f,Wb(f,Wb(f,ed(M[f>>2],M[d-20>>2]),M[g>>2]),M[d+4>>2]),d-32|0,0);M[g>>2]=e;if((c|0)<0){e=ob(f,19,e,0);M[g>>2]=e}if(!e){break o}M[e+4>>2]=M[e+4>>2]|256;break o}e=d-4|0;c=M[e>>2];M[e>>2]=c&2147483647;g=d-20|0;e=Be(f,Wb(f,ed(M[f>>2],M[d+4>>2]),M[g>>2]),d-8|0,0);M[g>>2]=e;if((c|0)<0){e=ob(f,19,e,0);M[g>>2]=e}if(!e){break o}M[e+4>>2]=M[e+4>>2]|256;break o}e=M[d+8>>2];g=d-8|0;M[g>>2]=M[d+4>>2];M[g+4>>2]=e;M[d-4>>2]=e|-2147483648;break o}c=d-20|0;I=c,J=ob(f,O[d-10>>1],M[c>>2],M[d+4>>2]),M[I>>2]=J;break o}c=d-20|0;I=c,J=ce(f,M[c>>2],M[d+4>>2]),M[I>>2]=J;break o}c=Wb(f,M[d-32>>2],M[d-8>>2]);g=d-44|0;e=ob(f,177,0,0);M[g>>2]=e;if(e){M[e+20>>2]=c;if(!M[c>>2]){break o}e=M[g>>2];M[e+4>>2]=M[e+4>>2]|M[M[c+8>>2]+4>>2]&4194824;break o}xb(M[f>>2],c);break o}I=d,J=Be(f,0,d+4|0,0),M[I+4>>2]=J;break o}c=d-44|0;e=Be(f,0,c,0);Kn(f,e,M[d+4>>2]);M[c>>2]=e;break o}e=d-92|0;c=Be(f,M[d-56>>2],e,M[d-68>>2]);Kn(f,c,M[d+4>>2]);Ts(f,c,M[d-20>>2]);M[e>>2]=c;break o}c=d-56|0;e=Be(f,M[d-20>>2],c,M[d-32>>2]);Kn(f,e,M[d+4>>2]);M[c>>2]=e;break o}c=d-32|0;I=c,J=Be(f,0,c,0),M[I>>2]=J;break o}c=d-80|0;e=Be(f,M[d-44>>2],c,M[d-56>>2]);Ts(f,e,M[d-8>>2]);M[c>>2]=e;break o}c=d-44|0;I=c,J=Be(f,M[d-8>>2],c,M[d-20>>2]),M[I>>2]=J;break o}c=Ec(M[f>>2],36,d-8|0,1);M[d-56>>2]=c;Ss(M[f>>2],c,M[d-32>>2],0);break o}c=d-20|0;I=c,J=Rs(f,M[c>>2],d+4|0,1),M[I>>2]=J;break o}Uf:{c=M[d+4>>2];if(!(N[c|0]==35&N[c+1|0]-58>>>0>4294967285)){l=M[d+8>>2];c=M[d+8>>2];M[i+136>>2]=M[d+4>>2];M[i+140>>2]=c;n=De(f,157,i+136|0);M[d+4>>2]=n;if(!n){break o}m=M[f>>2];p=M[n+8>>2];g=K[p+1|0];c=g>>31;h=c;Vf:{if(!(c|g)){g=O[f+220>>1]+1|0;L[f+220>>1]=g;break Vf}Wf:{Xf:{if(N[p|0]==63){Yf:{if((l|0)==2){e=0;c=g-48|0;g=h-(g>>>0<48)|0;break Yf}e=(ig(p+1|0,i+712|0,l-1|0,1)|0)!=0;c=M[i+712>>2];g=M[i+716>>2]}h=M[m+156>>2];j=e;e=g;g=h>>31;if(j|(!c&(e|0)<=0|(e|0)<0)|((g|0)<=(e|0)&c>>>0>h>>>0|(e|0)>(g|0))){break Uf}g=c<<16>>16;if((g|0)<=L[f+220>>1]){break Xf}L[f+220>>1]=g;e=M[f+240>>2];break Wf}e=M[f+240>>2];g=Dw(e,p,l);if(g&65535){break Vf}g=O[f+220>>1]+1|0;L[f+220>>1]=g;break Wf}e=M[f+240>>2];Zf:{if(e){j=M[e+4>>2];c=2;while(1){h=(c<<2)+e|0;if(M[h>>2]==(g|0)){c=h+8|0;break Zf}c=M[h+4>>2]+c|0;if((j|0)>(c|0)){continue}break}}c=0}if(c){break Vf}}q=((l|0)/4|0)+3|0;c=q;r=c>>31;_f:{$f:{if(e){j=M[e+4>>2];k=c+j|0;c=M[e>>2];if((k|0)<=(c|0)){c=e;break $f}h=c>>31<<1|c>>>31;j=c<<1}else{h=0;j=10}c=j;h=h+r|0;c=c+q|0;h=j>>>0>c>>>0?h+1|0:h;k=c;c=ld(m,e,c<<2,h<<2|c>>>30);if(!c){c=e;break _f}if(e){j=M[c+4>>2]}else{M[c+4>>2]=2;j=2}M[c>>2]=k;k=j+q|0}e=(j<<2)+c|0;M[e>>2]=g<<16>>16;M[e+4>>2]=q;M[c+4>>2]=k;e=e+8|0;if(l){G(e,p,l)}K[e+l|0]=0}M[f+240>>2]=c}L[n+32>>1]=g;if(M[m+156>>2]>=g<<16>>16){break o}cb(f,5827,0);Rg(M[f>>2],n);break o}e=M[d+8>>2];c=M[d+4>>2];M[i+712>>2]=c;M[i+716>>2]=e;if(!N[f+18|0]){hw(f,i+712|0);M[d+4>>2]=0;break o}e=ob(f,176,0,0);M[d+4>>2]=e;if(!e){break o}Af(c+1|0,e+28|0);break o}M[i+128>>2]=h;cb(f,16741,i+128|0);Rg(M[f>>2],n);break o}c=Ec(M[f>>2],156,d+4|0,1);if(c){M[c+36>>2]=M[d+4>>2]-M[f+248>>2]}M[d+4>>2]=c;break o}c=O[d+2>>1];e=M[d+8>>2];M[i+120>>2]=M[d+4>>2];M[i+124>>2]=e;I=d,J=De(f,c,i+120|0),M[I+4>>2]=J;break o}c=d-44|0;e=M[c+4>>2];M[i+112>>2]=M[c>>2];M[i+116>>2]=e;e=De(f,60,i+112|0);g=d-20|0;h=M[g+4>>2];M[i+104>>2]=M[g>>2];M[i+108>>2]=h;g=De(f,60,i+104|0);h=M[d+8>>2];M[i+96>>2]=M[d+4>>2];M[i+100>>2]=h;g=ob(f,142,g,De(f,60,i+96|0));if(N[f+224|0]>=2){kd(f,0,e)}I=c,J=ob(f,142,e,g),M[I>>2]=J;break o}c=d-20|0;e=M[c+4>>2];M[i+88>>2]=M[c>>2];M[i+92>>2]=e;e=De(f,60,i+88|0);g=M[d+8>>2];M[i+80>>2]=M[d+4>>2];M[i+84>>2]=g;I=c,J=ob(f,142,e,De(f,60,i+80|0)),M[I>>2]=J;break o}c=M[d+8>>2];M[i+72>>2]=M[d+4>>2];M[i+76>>2]=c;I=d,J=De(f,60,i+72|0),M[I+4>>2]=J;break o}M[d-20>>2]=M[d-8>>2];break o}I=d,J=Jn(f,0,d+4|0),M[I+4>>2]=J;break o}c=d-20|0;I=c,J=Jn(f,M[c>>2],d+4|0),M[I>>2]=J;break o}M[d-20>>2]=M[d-8>>2];break o}M[d+16>>2]=0;break o}zk(f,M[d+4>>2]);break o}I=d-80|0,J=Mi(M[f>>2],0,0,M[d-20>>2],M[d-8>>2],0),M[I>>2]=J;break o}I=d-44|0,J=Mi(M[f>>2],0,0,0,0,0),M[I>>2]=J;break o}I=d-92|0,J=Mi(M[f>>2],M[d-56>>2],M[d-32>>2],0,0,M[d+4>>2]),M[I>>2]=J;break o}I=d-128|0,J=Mi(M[f>>2],M[d-92>>2],M[d-68>>2],M[d-20>>2],M[d-8>>2],M[d+4>>2]),M[I>>2]=J;break o}M[d-8>>2]=0;zk(f,M[d+4>>2]);break o}M[d+16>>2]=0;break o}In(f,M[d-44>>2],0,M[d-32>>2],M[d-68>>2],0);break o}In(f,M[d-32>>2],M[d-8>>2],M[d-20>>2],M[d-56>>2],M[d+4>>2]);break o}I=d-44|0,J=Qs(f,0,M[d-32>>2],M[d+4>>2]),M[I>>2]=J;break o}c=ed(M[f>>2],M[d+4>>2]);e=d-20|0;Fg(f,c,e,1);M[e>>2]=c;break o}c=d-68|0;I=c,J=Qs(f,M[c>>2],M[d-32>>2],M[d+4>>2]),M[I>>2]=J;break o}e=d-44|0;c=Wb(f,M[e>>2],M[d+4>>2]);M[e>>2]=c;Fg(f,c,d-20|0,1);break o}c=d-56|0;Hn(f,M[c>>2],d-44|0);g=d-20|0;Ps(f,M[g>>2],2451);e=M[d-8>>2];ag:{if(!e){e=M[c>>2];break ag}if(M[e>>2]>=2){e=td(f,0,e,0,0,0,0,2048,0);M[i+712>>2]=0;M[i+716>>2]=0;e=Ve(f,0,0,0,i+712|0,e,0)}e=Os(f,M[c>>2],e);M[c>>2]=e}Gn(f,e,M[g>>2],M[d+4>>2],M[d-68>>2],0);break o}zk(f,M[d+4>>2]);M[d-32>>2]=M[d-20>>2];break o}zk(f,M[d+4>>2]);M[d-8>>2]=0;break o}c=d-20|0;Hn(f,M[c>>2],d-8|0);Fn(f,M[c>>2],M[d+4>>2]);break o}I=d-32|0,J=ob(f,149,M[d+4>>2],M[d-20>>2]),M[I>>2]=J;break o}I=d-32|0,J=ob(f,149,M[d-20>>2],M[d+4>>2]),M[I>>2]=J;break o}I=d-8|0,J=ob(f,149,M[d+4>>2],0),M[I>>2]=J;break o}M[d-8>>2]=M[d+4>>2];break o}M[d+16>>2]=0;break o}M[d-8>>2]=1;break o}M[d-8>>2]=0;break o}M[d+16>>2]=-1;break o}M[d+4>>2]=1;break o}M[d+4>>2]=0;break o}e=d-20|0;c=ed(M[f>>2],M[e>>2]);M[e>>2]=c;Ns(c,M[d-8>>2],M[d+4>>2]);break o}e=d-44|0;c=Wb(f,M[e>>2],M[d-20>>2]);M[e>>2]=c;Ns(c,M[d-8>>2],M[d+4>>2]);break o}M[d-20>>2]=M[d+4>>2];break o}c=d-8|0;M[c>>2]=0;M[c+4>>2]=1;break o}e=M[d+8>>2];c=d-20|0;M[c>>2]=M[d+4>>2];M[c+4>>2]=e;break o}M[d+16>>2]=0;M[d+20>>2]=0;break o}M[d-32>>2]=0;M[d-28>>2]=M[d-8>>2];break o}M[d-4>>2]=0;M[d-8>>2]=M[d+4>>2];break o}c=d-32|0;I=c,J=En(f,c,d-20|0,d-8|0),M[I>>2]=J;break o}c=d-20|0;I=c,J=En(f,c,d-8|0,0),M[I>>2]=J;break o}c=d-8|0;I=c,J=En(f,c,0,0),M[I>>2]=J;break o}M[d+4>>2]=1;break o}c=d-20|0;e=Od(f,0,c,0);M[c>>2]=e;if(!e){break o}e=zc(M[f>>2],d+4|0);M[M[c>>2]+12>>2]=e;break o}c=d-44|0;e=Od(f,0,c,d-20|0);M[c>>2]=e;if(!e){break o}e=zc(M[f>>2],d+4|0);M[M[c>>2]+12>>2]=e;break o}c=d-20|0;I=c,J=Od(f,0,c,d+4|0),M[I>>2]=J;break o}I=d,J=Od(f,0,d+4|0,0),M[I+4>>2]=J;break o}e=d-20|0;g=d+4|0;c=Od(f,0,e,g);if(!(!c|N[f+224|0]<2)){Ce(f,M[c+8>>2],g)}M[e>>2]=c;break o}c=d+4|0;e=Od(f,0,c,0);if(!(!e|N[f+224|0]<2)){Ce(f,M[e+8>>2],c)}M[c>>2]=e;break o}M[d+16>>2]=0;M[d+20>>2]=0;break o}c=d-56|0;h=M[c>>2];if(!(h|M[d-4>>2]|(M[d+4>>2]|M[d+8>>2]))){M[c>>2]=M[d-32>>2];break o}g=d-32|0;e=M[g>>2];if(!(!e|M[e>>2]!=1)){e=c;c=Ve(f,h,0,0,d-8|0,0,d+4|0);M[e>>2]=c;if(c){e=(c+S(M[c>>2],48)|0)-40|0;c=M[g>>2];M[e>>2]=M[c+8>>2];bg:{if(N[c+21|0]&4){h=N[e+13|0]|N[e+14|0]<<8|4;K[e+13|0]=h;K[e+14|0]=h>>>8;M[e+44>>2]=M[c+52>>2];M[c+52>>2]=0;h=(N[c+21|0]|N[c+22|0]<<8)&65531;K[c+21|0]=h;K[c+22|0]=h>>>8;if(!(N[M[M[e+44>>2]>>2]+5|0]&8)){break bg}h=N[e+13|0]|N[e+14|0]<<8|16384;K[e+13|0]=h;K[e+14|0]=h>>>8;break bg}M[e+44>>2]=M[c+52>>2];M[c+52>>2]=0}if(N[c+21|0]&8){M[e+32>>2]=M[c+40>>2];M[c+40>>2]=0;h=(N[c+21|0]|N[c+22|0]<<8)&65527;K[c+21|0]=h;K[c+22|0]=h>>>8;h=N[e+13|0]|N[e+14|0]<<8|8;K[e+13|0]=h;K[e+14|0]=h>>>8}M[c+8>>2]=0}Gc(M[f>>2],M[g>>2]);break o}Ms(e);e=td(f,0,M[g>>2],0,0,0,0,2048,0);I=c,J=Ve(f,M[c>>2],0,0,d-8|0,e,d+4|0),M[I>>2]=J;break o}c=d-56|0;I=c,J=Ve(f,M[c>>2],0,0,d-8|0,M[d-32>>2],d+4|0),M[I>>2]=J;break o}e=d-80|0;c=Ve(f,M[e>>2],d-68|0,d-56|0,d-8|0,0,d+4|0);M[e>>2]=c;Vs(f,c,M[d-32>>2]);break o}e=d-56|0;c=Ve(f,M[e>>2],d-44|0,d-32|0,d-20|0,0,d+4|0);M[e>>2]=c;Hn(f,c,d-8|0);break o}c=d-44|0;I=c,J=Ve(f,M[c>>2],d-32|0,d-20|0,d-8|0,0,d+4|0),M[I>>2]=J;break o}c=M[d-8>>2];if(!c){break o}e=M[c>>2];if((e|0)<=0){break o}K[(c+S(e,48)|0)-28|0]=M[d+4>>2];break o}c=M[d+4>>2];M[d-8>>2]=c;Ms(c);break o}M[d+16>>2]=0;break o}e=M[d+8>>2];c=d-8|0;M[c>>2]=M[d+4>>2];M[c+4>>2]=e;break o}c=ob(f,180,0,0);if(!(!c|N[c+4|0]&3)){M[c+36>>2]=M[d+4>>2]-M[f+248>>2]}e=d-20|0;g=M[e+4>>2];M[i+64>>2]=M[e>>2];M[i+68>>2]=g;c=ob(f,142,De(f,60,i- -64|0),c);e=d-44|0;I=e,J=Wb(f,M[e>>2],c),M[I>>2]=J;break o}c=wc(M[f>>2],180,0);if(!(!c|N[c+4|0]&3)){M[c+36>>2]=M[d+4>>2]-M[f+248>>2]}e=d-20|0;I=e,J=Wb(f,M[e>>2],c),M[I>>2]=J;break o}c=d-44|0;e=Wb(f,M[c>>2],M[d-20>>2]);M[c>>2]=e;if(M[d+8>>2]){Fg(f,e,d+4|0,1);e=M[c>>2]}if(!e){break o}c=(M[e>>2]<<4)+e|0;if(M[c-4>>2]){break o}c=c-8|0;I=c,J=Dn(M[f>>2],M[d-32>>2],M[d-8>>2]),M[I+4>>2]=J;e=(N[c+9|0]|N[c+10|0]<<8)&65532|1;K[c+9|0]=e;K[c+10|0]=e>>>8;break o}M[d+16>>2]=0;break o}M[d+4>>2]=2;break o}M[d+4>>2]=1;break o}g=M[d-8>>2];l=d-44|0;e=M[l>>2];cg:{dg:{eg:{if(N[f+27|0]|N[M[f>>2]+177|0]){break eg}if(!Ls(f,g)){break eg}fg:{if(M[M[e+32>>2]>>2]){break fg}h=M[e+28>>2];if(!Ls(f,h)){break eg}j=h+8|0;while(1){if(M[h>>2]<=(c|0)){break fg}k=c<<4;c=c+1|0;if(!rc(M[j+k>>2])){continue}break}break eg}if(!N[f+224|0]){break dg}}gg:{if(M[M[e+32>>2]>>2]){Ks(f,e);c=512;break gg}c=1536;if(!M[e+52>>2]){break gg}c=M[e+4>>2]&1536}c=td(f,g,0,0,0,0,0,c,0);M[e+4>>2]=M[e+4>>2]&-1025;if(!c){c=e;break cg}M[c+52>>2]=e;K[c|0]=136;break cg}c=M[e+32>>2];hg:{ig:{if(!M[c>>2]){h=0;k=Cb(f);c=td(f,0,0,0,0,0,0,0,0);if(!(N[M[f>>2]+24|0]&16)){de(f)}if(!c){break ig}j=M[c+32>>2];M[j>>2]=1;h=M[e+52>>2];M[c+52>>2]=h;K[c|0]=N[e|0];if(h){M[c+4>>2]=M[c+4>>2]|512}K[e|0]=139;M[e+52>>2]=0;M[j+40>>2]=2;M[j+24>>2]=-1;h=N[j+21|0]|N[j+22|0]<<8|64;K[j+21|0]=h;K[j+22|0]=h>>>8;h=j+8|0;if(!sh(f,h,e,0)){break hg}j=M[j+52>>2];n=M[k+108>>2]+1|0;M[j+4>>2]=n;m=M[f+48>>2]+1|0;M[f+48>>2]=m;M[j+8>>2]=m;bb(k,11,m,0,n);k=M[j+8>>2];M[i+728>>2]=0;M[i+732>>2]=0;M[i+720>>2]=0;M[i+724>>2]=0;M[i+716>>2]=k;K[i+712|0]=13;k=M[f+48>>2];M[i+724>>2]=k+3;m=M[M[e+28>>2]>>2];M[i+728>>2]=m;M[f+48>>2]=(k+m|0)+2;M[e+4>>2]=M[e+4>>2]|1024;Rc(f,e,i+712|0);M[j+12>>2]=M[i+724>>2];break hg}M[c+40>>2]=M[c+40>>2]+1;h=c+8|0}c=e}jg:{if(M[f+40>>2]){break jg}e=M[h+44>>2];h=M[e>>2];if(M[M[h+28>>2]>>2]!=M[g>>2]){Js(f,h);break jg}kf(f,g,M[e+12>>2],0,0);fb(M[f+8>>2],12,M[e+8>>2])}xb(M[f>>2],g)}M[l>>2]=c;break o}Ks(f,M[d+4>>2]);break o}I=d-32|0,J=td(f,M[d-8>>2],0,0,0,0,0,512,0),M[I>>2]=J;break o}c=td(f,M[d-80>>2],M[d-68>>2],M[d-56>>2],M[d-44>>2],M[d-32>>2],M[d-8>>2],M[d-92>>2],M[d+4>>2]);M[d-104>>2]=c;if(c){M[c+72>>2]=M[d-20>>2];break o}io(M[f>>2],M[d-20>>2]);break o}I=d-92|0,J=td(f,M[d-68>>2],M[d-56>>2],M[d-44>>2],M[d-32>>2],M[d-20>>2],M[d-8>>2],M[d-80>>2],M[d+4>>2]),M[I>>2]=J;break o}M[d-8>>2]=136;break o}M[d+4>>2]=O[d+2>>1];break o}g=d-20|0;c=M[g>>2];kg:{lg:{e=M[d+4>>2];if(!e){break lg}if(M[e+52>>2]){M[i+716>>2]=0;Bk(f,e);e=td(f,0,Ve(f,0,0,0,i+712|0,e,0),0,0,0,0,0,0);if(!e){break lg}}h=d-8|0;j=M[h>>2];M[e+52>>2]=c;K[e|0]=j;if(c){M[c+4>>2]=M[c+4>>2]&-1025}M[e+4>>2]=M[e+4>>2]&-1025;if(M[h>>2]==136){break kg}K[f+22|0]=1;break kg}pc(M[f>>2],c);e=0}M[g>>2]=e;break o}c=M[d+4>>2];if(!c){break o}Bk(f,c);break o}I=d-32|0,J=Is(f,M[d+4>>2],M[d-8>>2]),M[I>>2]=J;break o}I=d-20|0,J=Is(f,M[d+4>>2],M[d-8>>2]),M[I>>2]=J;break o}M[i+736>>2]=M[12430];c=M[12429];M[i+728>>2]=M[12428];M[i+732>>2]=c;c=M[12427];M[i+720>>2]=M[12426];M[i+724>>2]=c;c=M[12425];M[i+712>>2]=M[12424];M[i+716>>2]=c;mg:{if(!(N[M[f>>2]+24|0]&64)){if(de(f)){break mg}}Rc(f,M[d+4>>2],i+712|0)}pc(M[f>>2],M[d+4>>2]);break o}Hs(f,M[d+4>>2],1,M[d-8>>2]);break o}c=M[d-56>>2];h=M[d-80>>2];j=M[d-20>>2];g=M[d+4>>2];M[i+700>>2]=0;e=M[f>>2];ng:{if(L[f+220>>1]>0){cb(f,3687,0);break ng}k=d-44|0;m=d-32|0;Sn(f,k,m,h,1,0,c);c=M[f+252>>2];if(M[f+40>>2]|!c){break ng}M[c+28>>2]=M[c+28>>2]|512;Tf(f,k,m,i+700|0);h=Mb(e,M[c+60>>2]);k=M[f>>2];M[i+712>>2]=f;k=M[k+16>>2]+(h<<4)|0;M[i+752>>2]=M[k>>2];M[i+744>>2]=M[k+12>>2];M[i+716>>2]=f;M[i+720>>2]=11;M[i+724>>2]=12;M[i+728>>2]=13;M[i+732>>2]=0;L[i+736>>1]=0;K[i+748|0]=(h|0)==1;M[i+756>>2]=1856;M[i+760>>2]=M[i+700>>2];M[i+740>>2]=i+712;if(oc(i+716|0,g)){break ng}M[g+4>>2]=M[g+4>>2]|2097152;og:{if(N[f+224|0]>1){h=g;g=0;break og}h=le(e,g,1)}M[c+44>>2]=h;h=xc(e,j,1);K[c+43|0]=2;M[c+16>>2]=h;if(N[e+87|0]){break ng}c=M[f+212>>2];h=M[d-92>>2];c=(N[c|0]==59?c:M[f+216>>2]+c|0)-h|0;k=h-1|0;while(1){h=c+k|0;c=c-1|0;if(K[N[h|0]+31408|0]&1){continue}break}M[i+708>>2]=1;M[i+704>>2]=h;Rn(f,0,i+704|0,0,0)}pc(e,g);if(N[f+224|0]>=2){Gs(f,j)}xb(e,j);break o}Hs(f,M[d+4>>2],0,M[d-8>>2]);break o}M[d+4>>2]=5;break o}M[d+4>>2]=4;break o}M[d-20>>2]=M[d+4>>2];break o}M[d+16>>2]=11;break o}Fs(f,M[d-68>>2],d-32|0,M[d-20>>2],M[d-8>>2]);Es(f,M[d+4>>2]);break o}Ds(f,M[d-20>>2],M[d-32>>2],M[d-8>>2]);break o}Ni(f,0,0,0,M[d-20>>2],M[d+4>>2],0,0,0,0,1);break o}Cs(f,M[d-32>>2],M[d+4>>2],M[d-20>>2],0);break o}M[f+88>>2]=0;break o}M[d-8>>2]=0;break o}M[d-8>>2]=1;break o}M[d-8>>2]=M[d+4>>2];break o}M[d-20>>2]=0;break o}M[d-8>>2]=0;break o}M[d+4>>2]=7;break o}M[d+4>>2]=10;break o}M[d-8>>2]=9;break o}M[d-8>>2]=8;break o}M[d-16>>2]=65280;M[d-20>>2]=M[d+4>>2]<<8;break o}M[d-16>>2]=255;M[d-20>>2]=M[d+4>>2];break o}c=d-20|0;M[c>>2]=0;M[c+4>>2]=0;break o}c=d-8|0;M[c>>2]=0;M[c+4>>2]=0;break o}c=d-8|0;M[c>>2]=M[d+4>>2]|M[c>>2]&(M[d+8>>2]^-1);break o}M[d+16>>2]=0;break o}M[d+4>>2]=1;break o}Bs(f,M[d-20>>2],d+4|0);break o}Bs(f,M[d-8>>2],0);break o}c=M[f+252>>2];if(!c|N[f+224|0]>1){break o}e=L[c+34>>1];h=M[f>>2];g=zc(h,d+4|0);if(!g){break o}pg:{if(!Li(f,g)){break pg}j=e-1|0;k=S(j,12);As(h,k+M[c+4>>2]|0,g);e=c+8|0;while(1){e=M[e>>2];if(!e){break pg}if((j|0)==L[M[e+4>>2]>>1]){I=M[e+32>>2],J=eg(k+M[c+4>>2]|0),M[I>>2]=J}e=e+20|0;continue}}ib(h,g);break o}Es(f,M[d+4>>2]);break o}Fs(f,0,d-20|0,M[d-8>>2],M[d+4>>2]);break o}Ds(f,M[d-8>>2],M[d-20>>2],M[d+4>>2]);break o}Ni(f,0,0,0,0,M[d+4>>2],0,0,0,0,1);break o}Cs(f,0,M[d-8>>2],M[d+4>>2],M[d-20>>2]);break o}c=M[f+252>>2];if(!c){break o}e=L[c+34>>1];if((e|0)<=0){break o}e=M[c+4>>2]+S(e,12)|0;g=e-8|0;K[g|0]=N[g|0]&240|M[d+4>>2]&15;M[c+28>>2]=M[c+28>>2]|2048;if(!(N[e-2|0]&8)){break o}e=c+8|0;while(1){e=M[e>>2];if(!e){break o}if(L[M[e+4>>2]>>1]==(L[c+34>>1]-1|0)){g=N[e+55|0]|N[e+56|0]<<8|8;K[e+55|0]=g;K[e+56|0]=g>>>8}e=e+20|0;continue}}c=M[d+8>>2];M[i+56>>2]=M[d+4>>2];M[i+60>>2]=c;c=De(f,118,i+56|0);if(c){Ck(c)}e=c;c=M[d+4>>2];Ki(f,e,c,c+M[d+8>>2]|0);break o}Ki(f,ob(f,174,M[d+4>>2],0),M[d-20>>2],M[d-8>>2]+M[d-4>>2]|0);break o}Ki(f,M[d+4>>2],M[d-20>>2],M[d-8>>2]+M[d-4>>2]|0);break o}Ki(f,M[d-8>>2],M[d-20>>2]+1|0,M[d+4>>2]);break o}c=M[d-8>>2];Ki(f,M[d+4>>2],c,c+M[d-4>>2]|0);break o}c=M[d+8>>2];M[f+84>>2]=M[d+4>>2];M[f+88>>2]=c;break o}c=M[o+28>>2];M[d+16>>2]=M[o+24>>2];M[d+20>>2]=c;break o}M[d+16>>2]=M[o+24>>2];break o}M[d-4>>2]=(M[d+8>>2]+M[d+4>>2]|0)-M[d-8>>2];break o}M[d-52>>2]=(M[d+4>>2]+M[d+8>>2]|0)-M[d-56>>2];break o}M[d-28>>2]=(M[d+4>>2]+M[d+8>>2]|0)-M[d-32>>2];break o}M[d+16>>2]=0;M[d+20>>2]=0;break o}c=0}m=M[i+708>>2];e=0;h=(c|0)!=0;l=h;h=c+h|0;e=l>>>0>h>>>0?1:e;l=h+m|0;h=l>>>0<h>>>0?e+1|0:e;e=l+1|0;h=e?h:h+1|0;l=md(g,e,h);if(!l){break o}if(N[f+224|0]>=2){Ce(f,l,i+704|0)}if(m){G(l,M[i+704>>2],m)}e=0;K[l+m|0]=0;zf(l);r=Uf(l);h=L[n+34>>1];u=(h|0)>0?h:0;m=M[n+4>>2];w=h>>31;qg:{rg:{while(1){if((e|0)!=(u|0)){sg:{v=m+S(e,12)|0;if((r|0)!=N[v+7|0]){break sg}if(hb(l,M[v>>2])){break sg}M[i+32>>2]=l;cb(f,8350,i+32|0);break rg}e=e+1|0;continue}break}e=ZJ(h,w,12,0);h=Qa;e=e+12|0;h=e>>>0<12?h+1|0:h;e=ld(g,m,e,h);if(e){break qg}}ib(g,l);break o}M[n+4>>2]=e;e=e+S(L[n+34>>1],12)|0;M[e+4>>2]=0;M[e+8>>2]=0;M[e>>2]=l;K[e+7|0]=r;tg:{if(!c){K[e+6|0]=p;K[e+4|0]=q;break tg}g=(jb(l)+l|0)+1|0;if(c){G(g,j,c)}K[c+g|0]=0;zf(g);k=Si(g,e);L[e+10>>1]=O[e+10>>1]|4}K[e+5|0]=k;L[n+34>>1]=O[n+34>>1]+1;L[n+36>>1]=O[n+36>>1]+1;M[f+88>>2]=0}c=S(K[F+37728|0],12)+d|0;e=O[c>>1];M[o+36>>2]=c+12;g=O[(F<<1)+49728>>1];L[c+14>>1]=g;h=O[(g+L[(e<<1)+51856>>1]<<1)+44112>>1];L[c+12>>1]=h;Na=i+768|0;continue}break}if(e>>>0<=1253){c=M[o+36>>2]+12|0;M[o+36>>2]=c;ug:{if(P[o+44>>2]>=c>>>0){break ug}g=o+36|0;f=jw(g);c=M[o+36>>2];if(!f){break ug}M[o+36>>2]=c-12;iw(g);break j}M[c+4>>2]=z;M[c+8>>2]=E;L[c+2>>1]=s;L[c>>1]=e>>>0>582?h+412|0:h;break j}if((e|0)==1255){M[o+36>>2]=M[o+36>>2]-12;break j}M[o+1264>>2]=z;M[o+1268>>2]=E;M[o+1272>>2]=z;M[o+1276>>2]=E;c=M[o+40>>2];vg:{if(N[z|0]){hw(c,o+1272|0);break vg}cb(c,2242,0)}M[o+40>>2]=c;qp(o+36|0,s&65535,o+1264|0)}b=b+y|0;if(!M[a+12>>2]){continue a}}h=M[o+36>>2];while(1){c=M[o+48>>2];if(c>>>0<h>>>0){c=O[h+2>>1];if(c>>>0>=206){qp(o+36|0,c,h+4|0)}h=h-12|0;continue}break}if((c|0)!=(D|0)){ab(c)}if(N[t+87|0]){M[a+12>>2]=7}c=M[a+4>>2];wg:{if(!c){h=0;c=M[a+12>>2];if(!c|(c|0)==101){break wg}I=o,J=Yg(c),M[I+16>>2]=J;c=tb(t,8932,o+16|0);M[a+4>>2]=c}h=1;if(N[a+25|0]&16){break wg}e=M[a+12>>2];M[o+4>>2]=M[a+248>>2];M[o>>2]=c;Lc(e,29645,o)}M[a+248>>2]=b;ab(M[a+276>>2]);b=M[a+252>>2];if(!(N[a+224|0]|!b)){Id(t,b)}b=M[a+260>>2];if(!(!b|N[a+224|0]>1)){Vh(t,b)}a=M[a+240>>2];if(a){cc(t,a)}M[t+264>>2]=H;Na=o+1280|0;return h}b=b+y|0;continue}}}
function Rc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0,J=0,P=0,Q=0,R=0,T=0,U=0,V=0;f=Na-368|0;Na=f;q=M[a>>2];d=1;n=Cb(a);a:{if(M[a+40>>2]|!b){break a}if(gc(a,21,0,0,0)){break a}if(N[c|0]<=6){d=M[b+48>>2];if(d){rd(a,44,d);M[b+48>>2]=0}M[b+4>>2]=M[b+4>>2]&-4194306|4194304}je(a,b,0);d=1;b:{c:{if(M[a+40>>2]){break c}i=M[b+4>>2];if(i&8388608){h=M[b+32>>2];if(os(h+8|0,h)){b=M[h+12>>2];if(!b){b=M[M[h+16>>2]>>2]}M[f+192>>2]=b;cb(a,8125,f+192|0);break c}M[b+4>>2]=i&-8388609}if(N[c|0]==9){ns(a,b)}d:{if(!(M[b+52>>2]|!M[b+68>>2]|(N[b+6|0]&16|N[a+224|0]>1))){o=Cb(a);p=M[b+44>>2];r=M[b+40>>2];s=M[b+36>>2];l=M[b+32>>2];g=M[a>>2];M[f+208>>2]=0;h=M[b+68>>2];v=M[b+4>>2];i=ub(g,64,0);if(!i){Ap(g,7);break d}M[f+300>>2]=0;M[f+304>>2]=0;M[f+292>>2]=0;M[f+296>>2]=0;M[f+288>>2]=46;M[f+284>>2]=47;M[f+280>>2]=a;e=f+280|0;oc(e,b);d=M[b+4>>2];if(!(d&8)){M[f+288>>2]=0;M[f+284>>2]=48;ec(e,M[b+48>>2]);d=M[b+4>>2]}M[b+32>>2]=0;M[b+36>>2]=0;M[b+40>>2]=0;M[b+44>>2]=0;M[b+4>>2]=d&-1048585|1048576;k=Hi(a,Hi(a,0,M[h+8>>2],1),M[h+12>>2],1);e:{if(!k){break e}d=M[b+48>>2];if(!d){break e}e=M[d>>2];m=M[k>>2];if((e|0)>(m|0)){break e}M[k>>2]=e;if(!Qf(k,d,-1)){xb(g,M[b+48>>2]);M[b+48>>2]=0}M[k>>2]=m}d=M[a+44>>2];M[h+48>>2]=d;M[a+44>>2]=d+4;d=f+208|0;wn(a,h,l,M[b+28>>2],i,d);wn(a,h,l,M[b+48>>2],i,d);d=M[f+208>>2];if(d){e=M[d>>2]}else{e=0}M[h+76>>2]=e;e=Hi(a,Hi(a,d,M[h+8>>2],0),M[h+12>>2],0);M[f+208>>2]=e;d=h;while(1){if(d){m=M[M[d+72>>2]+20>>2];f:{if(N[M[d+44>>2]+6|0]&16){wn(a,h,l,m,i,f+208|0);e=M[f+208>>2];if(e){m=M[e>>2]}else{m=0}K[d+96|0]=1;M[d+80>>2]=m;break f}M[d+80>>2]=e?M[e>>2]:0;e=Hi(a,e,m,0);M[f+208>>2]=e}m=M[d+40>>2];if(m){e=Wb(a,e,qb(g,m,0));M[f+208>>2]=e}m=M[a+48>>2];j=m+1|0;M[d+52>>2]=j;m=m+2|0;M[a+48>>2]=m;M[d+56>>2]=m;$a(o,75,0,j);d=M[d+36>>2];continue}break}if(!e){d=wc(g,156,25046);e=ed(M[a>>2],d);M[f+208>>2]=e}d=td(a,e,l,s,r,p,k,0,0);e=Od(a,0,0,0);M[b+32>>2]=e;g:{h:{if(!e){pc(g,d);h=1;break h}h=1;if(!sh(a,e+8|0,d,0)){break h}e=M[b+32>>2];k=N[e+21|0]|N[e+22|0]<<8|16;K[e+21|0]=k;K[e+22|0]=k>>>8;vk(a,M[b+32>>2]);M[d+4>>2]=M[d+4>>2]|134217792;e=Bn(a,d,64);M[d+4>>2]=M[d+4>>2]|v&8;if(!e){h=0;break h}G(i,e,64);M[i+28>>2]=M[i+28>>2]|16384;M[M[b+32>>2]+16>>2]=i;M[f+288>>2]=0;M[f+292>>2]=0;M[f+304>>2]=0;M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=49;M[f+280>>2]=0;M[f+284>>2]=0;M[f+292>>2]=50;M[f+284>>2]=51;oc(f+280|0,d);break g}e=i}d=N[g+87|0];rd(a,52,e);if(!h|d){break d}}h=M[b+32>>2];d=M[b+4>>2];i=0;D(f+212|0,0,36);M[f+208>>2]=M[b+48>>2];s=d>>>3&1;while(1){i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{g=M[b+52>>2];if(!g){if(M[h>>2]<=(i|0)){break s}k=0;m=h+8|0;r=S(i,48);g=m+r|0;if(N[g+13|0]&4){k=M[M[g+44>>2]>>2]}j=M[g+8>>2];d=N[g+12|0];u:{if(!(d&72)){break u}if(!vn(M[b+36>>2],M[g+16>>2],d&64)|N[q+81|0]&32){break u}e=N[g+12|0];v:{if(!(e&8)){break v}if(e&16){e=e&247;K[g+12|0]=e;break v}K[g+12|0]=e&199;Gi(M[b+36>>2],M[g+16>>2],0);e=N[g+12|0]}d=i;if(!(e&64)){break u}while(1){d=d+1|0;e=M[h>>2];if((d|0)<(e|0)){e=m+S(d,48)|0;l=N[e+12|0];if(!(l&16)){continue}if(l&8){K[e+12|0]=l&239}else{K[e+12|0]=l&199;Gi(M[b+36>>2],M[e+16>>2],1)}continue}break}while(1){if((e|0)<=0){break u}l=(m+S(e,48)|0)-36|0;d=N[l|0];K[l|0]=d&191;e=e-1|0;if(!(d&16)){continue}break}}if(!k){break j}d=M[M[k+28>>2]>>2];e=L[j+34>>1];if((d|0)!=(e|0)){b=M[j>>2];M[f+8>>2]=d;M[f+4>>2]=b;M[f>>2]=e;cb(a,17164,f);break d}if(N[M[g+36>>2]+18|0]?0:N[g+14|0]&2){break j}d=M[k+4>>2];if(d&8){break j}e=M[k+48>>2];w:{if(!e){break w}x:{if(!M[b+48>>2]&M[h>>2]<2|d&134225920|(M[k+60>>2]|N[b+7|0]&8)){break x}if(N[q+82|0]&4){break x}rd(a,44,e);M[k+48>>2]=0;break w}if(!(N[b+6|0]&4)|i){break w}d=0;if(N[h+68|0]&34|M[h>>2]==1){break i}}m=M[a>>2];if(M[b+68>>2]|K[m+80|0]&1){break k}g=M[b+32>>2];k=r+g|0;d=M[M[k+52>>2]>>2];if(M[d+68>>2]){break k}u=M[a+264>>2];z=M[k+24>>2];e=M[d+32>>2];h=M[d+60>>2];if(!h){break t}if(M[b+60>>2]|M[h+16>>2]){break k}o=M[b+4>>2];if(o&256){break k}break l}m=M[a>>2];M[f+272>>2]=M[c+24>>2];d=M[c+20>>2];M[f+264>>2]=M[c+16>>2];M[f+268>>2]=d;d=M[c+12>>2];M[f+256>>2]=M[c+8>>2];M[f+260>>2]=d;d=M[c+4>>2];M[f+248>>2]=M[c>>2];M[f+252>>2]=d;l=Cb(a);i=N[f+248|0];if((i|0)==12){$a(l,117,M[f+252>>2],M[M[b+28>>2]>>2]);K[f+248|0]=14;i=14}y:{k=M[b+4>>2];if(!(k&1024)){break y}n=M[b+60>>2];j=!n;h=1;e=b;while(1){if(M[e+68>>2]){break y}d=M[e+52>>2];if(d){h=h+j|0;e=d;continue}break}M[f+176>>2]=h;M[f+180>>2]=(h|0)==1?30808:19500;o=0;fc(a,0,6142,f+176|0);while(1){d=0;if(!e){break n}Pf(a,e,-1,0,0,f+248|0,1,1);if(n){break o}L[e+2>>1]=h;e=M[e+56>>2];continue}}z:{if(!(k&8192)){break z}d=b;while(1){if(!d){break z}if(N[d+5|0]&32){d=M[d+52>>2];continue}break}A:{if(M[b+68>>2]){cb(a,5861,0);break A}g=M[a+8>>2];e=M[b+32>>2];h=M[M[b+28>>2]>>2];d=0;if(gc(a,33,0,0,0)){break A}j=M[a+60>>2]-1|0;M[a+60>>2]=j;L[b+2>>1]=320;Fi(a,b,j);p=M[b+60>>2];M[b+60>>2]=0;r=M[b+12>>2];q=M[b+8>>2];M[b+8>>2]=0;M[b+12>>2]=0;i=M[e>>2];n=(i|0)>0?i:0;e=e+8|0;k=M[b+48>>2];B:{while(1){i=0;if((d|0)==(n|0)){break B}i=S(d,48);d=d+1|0;i=e+i|0;if(!(N[i+13|0]&128)){continue}break}i=M[i+16>>2]}n=M[a+44>>2];d=n+1|0;M[a+44>>2]=d;C:{if(N[b|0]==135){M[a+44>>2]=n+2;e=k?6:5;break C}d=0;e=k?7:8}M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;M[f+284>>2]=n;K[f+280|0]=e;o=M[a+48>>2]+1|0;M[a+48>>2]=o;bb(g,121,i,o,h);D:{if(k){e=ls(a,b);nb(g,117,n,M[k>>2]+2|0,0,e,-8);M[f+304>>2]=k;break D}$a(g,117,n,h)}E:{if(!d){h=M[b+4>>2];break E}U=b,V=$a(g,117,d,0),M[U+20>>2]=V;h=M[b+4>>2]|32;M[b+4>>2]=h}M[b+48>>2]=0;e=b;F:{while(1){d=e;if(h&8){cb(a,15522,0);break F}K[d|0]=136;e=M[d+52>>2];h=M[e+4>>2];if(h&8192){continue}break}M[e+56>>2]=0;fc(a,1,19997,0);h=Rc(a,e,f+280|0);M[e+56>>2]=b;if(h){break F}s=$a(g,36,n,j);fb(g,136,i);G:{if(k){bb(g,94,n,M[k>>2]+1|0,o);break G}$a(g,134,n,o)}fb(g,130,n);h=M[a+60>>2]-1|0;M[a+60>>2]=h;Ei(g,r,h);Pf(a,b,i,0,0,f+248|0,h,j);if(q){$a(g,61,q,j)}pb(g,h);M[d+52>>2]=0;fc(a,1,20009,0);Rc(a,b,f+280|0);M[d+52>>2]=e;Xb(g,s);pb(g,j)}xb(M[a>>2],M[b+48>>2]);M[b+60>>2]=p;M[b+48>>2]=k}o=0;d=0;break q}q=M[b+48>>2];if(!q){break r}g=M[a+60>>2];t=g-2|0;M[a+60>>2]=t;n=M[a+8>>2];r=M[a>>2];m=M[q>>2];p=N[b|0];if((p|0)==136){break p}h=1;H:while(1){if(N[r+87|0]|M[M[b+28>>2]>>2]<(h|0)){break p}d=0;i=(m|0)>0?m:0;e=q+8|0;while(1){I:{if((d|0)!=(i|0)){if(O[e+12>>1]!=(h|0)){break I}}else{d=i}J:{if((d|0)!=(m|0)){break J}d=wc(r,156,0);if(!d){d=7;break m}M[d+8>>2]=h;M[d+4>>2]=M[d+4>>2]|2048;q=Wb(a,q,d);M[b+48>>2]=q;if(!q){q=0;break J}L[((m<<4)+q|0)+20>>1]=h;m=m+1|0}h=h+1|0;continue H}e=e+16|0;d=d+1|0;continue}}}o=M[b+4>>2];break l}d=M[b+36>>2];if(!(N[q+81|0]&128|(!d|N[d|0]!=44))){M[f+280>>2]=a;M[f+284>>2]=M[a>>2]+87;while(1){M[f+304>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;M[f+296>>2]=0;d=M[b+32>>2];K:{if(!(!d|M[d>>2]<=0)){e=3;if(N[d+20|0]&64){break K}}e=1}M[f+300>>2]=e;d=f+280|0;ks(d,M[b+36>>2]);if(M[f+288>>2]){M[f+348>>2]=0;M[f+352>>2]=0;M[f+344>>2]=46;M[f+340>>2]=53;M[f+336>>2]=a;M[f+356>>2]=0;M[f+360>>2]=d;Nb(f+336|0,M[b+36>>2]);eb(M[M[f+280>>2]>>2],M[f+304>>2])}if(M[f+292>>2]){continue}break}}L:{if(!(N[b+4|0]&8)|O[q+80>>1]&513){break L}d=M[b+28>>2];if(M[b+36>>2]|M[d>>2]!=1|(M[b+44>>2]|M[b+40>>2])){break L}if(M[b+48>>2]){break L}d=M[d+8>>2];if(N[d|0]!=169){break L}if(hc(M[d+8>>2],2660)|M[d+20>>2]){break L}i=M[b+32>>2];if(K[d+7|0]&1|M[i>>2]!=1|!(N[i+21|0]&4)){break L}e=M[M[i+52>>2]>>2];if(!M[e+52>>2]|N[e+7|0]&4){break L}i=i+8|0;while(1){if(M[e+36>>2]|(M[e+52>>2]?N[e|0]!=136:0)|(M[e+60>>2]|N[e+4|0]&8)){break L}e=M[e+52>>2];if(e){continue}break}k=M[a>>2];e=js(k,i);Gc(k,M[b+32>>2]);U=b,V=ub(M[a>>2],56,0),M[U+32>>2]=V;g=0;while(1){M:{h=g;if(!e){break M}L[e+2>>1]=0;i=M[e+52>>2];M[e+52>>2]=0;M[e+56>>2]=0;M[e+4>>2]=M[e+4>>2]&-265|8;rd(a,44,M[e+28>>2]);g=d;if(i){g=qb(k,d,0)}U=e,V=ed(M[a>>2],g),M[U+28>>2]=V;g=ob(a,139,0,0);Gg(a,g,e);e=i;if(!h){continue}g=ob(a,107,g,h);continue}break}M[M[b+28>>2]+8>>2]=h;M[b+4>>2]=M[b+4>>2]&-9;if(N[q+87|0]){break d}h=M[b+32>>2]}t=h+8|0;m=0;while(1){N:{O:{if(M[h>>2]>(m|0)){g=t+S(m,48)|0;P:{if(M[g+24>>2]|M[g+28>>2]){break P}d=M[g>>2];if(!d){break P}Q:{if(K[g+15|0]&1){e=M[M[q+16>>2]+(Mb(M[a>>2],M[g+44>>2])<<4)>>2];break Q}e=0;if(N[g+13|0]&4){break Q}e=M[g+44>>2]}gc(a,20,d,30808,e)}if(!(N[g+13|0]&4)){break N}p=M[g+44>>2];if(M[p+4>>2]){break N}r=M[p>>2];U=a,V=is(b)+M[a+232>>2]|0,M[U+232>>2]=V;d=M[q+80>>2];R:{if(d&4096){break R}if(N[g+14|0]&2){e=M[g+36>>2];if(!N[e+18|0]|M[e>>2]>1){break R}}hs(a,r,M[b+36>>2],h,m);d=M[q+80>>2]}if(d&67108864|(N[g+13|0]|N[g+14|0]<<8)&528){break O}o=M[g+8>>2];l=M[M[g+44>>2]>>2];d=l;while(1){if(d){if(N[d+4|0]&9){break O}e=M[d+52>>2];if(N[d|0]!=136?e:0){break O}i=M[d+68>>2];d=e;if(!i){continue}break O}break}k=M[g+24>>2];v=M[g+28>>2];S:{e=M[l+48>>2];if(!e){break S}d=0;i=M[e>>2];u=(i|0)>0?i:0;w=e+20|0;while(1){if((d|0)==(u|0)){break S}e=O[w+(d<<4)>>1];if(e){e=e-1&65535;i=e>>>0>=63?63:e;e=i&31;if((i&63)>>>0>=32){j=1<<e;i=0}else{i=1<<e;j=i-1&1>>>32-e}k=i|k;v=j|v}d=d+1|0;continue}}d=L[o+34>>1];o=(d|0)>0?d:0;i=0;e=0;while(1){if(!e&(i|0)==(o|0)){break O}d=i&31;T:{if((i&63)>>>0>=32){j=1<<d;u=0}else{u=1<<d;j=u-1&1>>>32-d}d=!e&i>>>0>=63|(e|0)!=0;if(k&(d?0:u)|v&(d?-2147483648:j)){break T}u=i<<4;d=l;while(1){if(!d){break T}j=M[(u+M[d+28>>2]|0)+8>>2];if(N[j|0]!=122){K[j|0]=122;M[j+4>>2]=M[j+4>>2]&-532481;M[d+4>>2]=M[d+4>>2]|16777216}d=M[d+52>>2];continue}}i=i+1|0;e=i?e:e+1|0;continue}}w=M[b+44>>2];i=M[b+40>>2];t=M[b+36>>2];r=M[b+28>>2];d=M[b+4>>2];K[f+248|0]=d&1;U:{if((d&9)!=1){break U}if(Qf(M[f+208>>2],r,-1)|N[q+80|0]&4|M[b+68>>2]){break U}M[b+4>>2]=M[b+4>>2]&-2;d=0;i=xc(q,r,0);M[b+40>>2]=i;V:{if(!i){break V}e=M[i>>2];e=(e|0)>0?e:0;g=i+20|0;while(1){if((d|0)==(e|0)){break V}k=g+(d<<4)|0;d=d+1|0;L[k>>1]=d;continue}}M[b+4>>2]=M[b+4>>2]|8;K[f+248|0]=2}d=M[f+208>>2];if(d){e=Ue(a,d,0,M[r>>2]);d=M[a+44>>2];M[a+44>>2]=d+1;M[f+216>>2]=d;d=nb(n,117,d,(M[M[f+208>>2]>>2]+M[r>>2]|0)+1|0,0,e,-8)}else{d=-1}M[f+228>>2]=d;W:{if(N[c|0]!=12){break W}$a(n,117,M[c+4>>2],M[r>>2]);if(!(N[b+5|0]&8)){break W}e=r+8|0;m=M[r>>2];d=m;while(1){X:{if((d|0)<2){break X}d=d-1|0;g=e+(d<<4)|0;if(N[g+9|0]&64){break X}kb(q,M[g>>2]);eb(q,M[g+4>>2]);m=M[r>>2]-1|0;M[r>>2]=m;continue}break}d=0;g=(m|0)>0?m:0;while(1){if((d|0)==(g|0)){break W}k=e+(d<<4)|0;if(!(N[k+9|0]&64)){K[M[k>>2]]=122}d=d+1|0;continue}}R=M[a+60>>2]-1|0;M[a+60>>2]=R;if(!(N[b+5|0]&64)){L[b+2>>1]=320}if(M[b+60>>2]){Fi(a,b,R)}Y:{if(M[b+8>>2]){break Y}d=M[f+228>>2];if((d|0)<0){break Y}K[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(d,20)|0)|0]=119;K[f+240|0]=N[f+240|0]|1}d=0;Z:{if(!(K[b+4|0]&1)){break Z}d=M[a+44>>2];M[a+44>>2]=d+1;M[f+252>>2]=d;U=f,V=nb(n,117,d,0,0,Ue(a,M[b+28>>2],0,0),-8),M[U+256>>2]=V;d=3;e=M[n+108>>2];if((e|0)<=0){break Z}L[(M[n+104>>2]+S(e,20)|0)-18>>1]=8}K[f+249|0]=d;_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{if(!(i|s)){e=0;m=M[b+4>>2]&16384|(N[f+248|0]?256:0);i=M[b+68>>2];ma:{if(!i){break ma}d=M[M[M[M[M[b+32>>2]+52>>2]>>2]+28>>2]>>2];g=Cb(a);$a(g,117,M[i+48>>2],d);d=M[i+48>>2];$a(g,114,d+1|0,d);d=M[i+48>>2];$a(g,114,d+2|0,d);d=M[i+48>>2];$a(g,114,d+3|0,d);d=M[i+8>>2];if(d){d=M[d>>2];k=M[a+48>>2];l=k+1|0;M[i+68>>2]=l;d=d+k|0;M[a+48>>2]=d;bb(g,75,0,l,d)}d=M[a+48>>2]+1|0;M[a+48>>2]=d;M[i+84>>2]=d;$a(g,71,1,d);if(!N[i+20|0]){d=i;while(1){if(!d){break ma}k=M[d+44>>2];na:{if(!(!(N[k+5|0]&16)|N[d+17|0]==91)){l=Ue(a,M[M[d+72>>2]+20>>2],0,0);k=M[a+44>>2];M[a+44>>2]=k+1;M[d+60>>2]=k;j=M[a+48>>2];M[d+64>>2]=j+1;M[a+48>>2]=j+3;if(!(!l|N[M[M[d+44>>2]+32>>2]+1|0]!=105)){K[M[l+16>>2]]=1;k=M[d+60>>2]}$a(g,117,k,2);Jc(g,l,-8);$a(g,71,0,M[d+64>>2]+1|0);break na}k=M[k+32>>2];if(!((k|0)!=50960&(k|0)!=50970)){l=M[a+48>>2];M[d+64>>2]=l+1;k=M[a+44>>2];M[a+44>>2]=k+1;M[d+60>>2]=k;M[a+48>>2]=l+2;$a(g,114,k,M[i+48>>2]);break na}if((k|0)!=50726&(k|0)!=50731){break na}k=M[a+44>>2];M[a+44>>2]=k+1;M[d+60>>2]=k;$a(g,114,k,M[i+48>>2])}d=M[d+36>>2];continue}}d=M[a+48>>2];k=d+1|0;M[i+88>>2]=k;d=d+2|0;M[a+48>>2]=d;M[i+92>>2]=d;d=M[a+44>>2];M[a+44>>2]=d+1;M[i+60>>2]=d;$a(g,71,1,k);$a(g,71,0,M[i+92>>2]);$a(g,114,M[i+60>>2],M[i+48>>2])}m=jf(a,h,t,M[f+208>>2],M[b+28>>2],b,m,L[b+2>>1]);if(!m){break _}d=L[m+50>>1];if((d|0)<L[b+2>>1]){L[b+2>>1]=d}oa:{if(!N[f+248|0]){break oa}d=N[m+47|0];if(!d){break oa}K[f+249|0]=d}e=M[f+208>>2];pa:{if(e){d=K[m+45|0];h=(d|0)>0?d:0;M[f+212>>2]=h;if(N[m+48|0]&4){d=m+S(N[m+44|0],96)|0;d=M[d+720>>2]?m+28|0:d+680|0}else{d=m+28|0}M[f+236>>2]=M[d>>2];if((h|0)!=M[e>>2]){break pa}M[f+208>>2]=0}d=M[f+228>>2];if((d|0)<0){break pa}be(n,d)}if(!i){break la}C=M[a+60>>2];z=C-3|0;M[a+60>>2]=z;E=M[a+48>>2]+1|0;M[a+48>>2]=E;i=M[b+68>>2];v=M[i+12>>2];j=Cb(a);d=M[b+32>>2];A=M[d+24>>2];t=L[M[d+16>>2]+34>>1];w=M[a+60>>2]-1|0;M[a+60>>2]=w;D(f+300|0,0,36);M[f+296>>2]=E;M[f+288>>2]=j;M[f+284>>2]=i;M[f+280>>2]=a;J=C-1|0;M[f+292>>2]=J;p=M[i+48>>2];M[f+320>>2]=p;B=p+3|0;M[f+328>>2]=B;d=2;F=p+2|0;M[f+312>>2]=F;qa:{switch(N[i+17|0]-87|0){case 0:if(N[i+16|0]==90){break aa}if(!gs(a,M[i+24>>2])){break aa}break ca;case 4:break qa;default:break ba}}if(M[i+88>>2]){break aa}d=i;while(1){if(d){e=M[M[d+44>>2]+32>>2];if((e|0)==50731|(e|0)==50726|((e|0)==50960|(e|0)==50970)){break aa}d=M[d+36>>2];continue}break}if(N[i+18|0]!=89){break ca}if(N[i+16|0]==90){break aa}if(!gs(a,M[i+28>>2])){break aa}d=3;break ba}ra:{if(i){d=M[b+28>>2];e=d+8|0;d=M[d>>2];while(1){if((d|0)>0){L[e+14>>1]=0;e=e+16|0;d=d-1|0;continue}break}d=M[i>>2];k=i+8|0;e=k;while(1){if((d|0)>0){L[e+14>>1]=0;e=e+16|0;d=d-1|0;continue}break}if(L[b+2>>1]>=67){L[b+2>>1]=66}p=1;e=M[f+208>>2];if(!e){break ra}g=M[i>>2];if((g|0)!=M[e>>2]){break ra}d=0;g=(g|0)>0?g:0;l=e+16|0;while(1){if((d|0)!=(g|0)){m=d<<4;K[(m+k|0)+8|0]=K[l+m|0]&1;d=d+1|0;continue}break}p=(Qf(i,e,-1)|0)!=0;break ra}L[b+2>>1]=0;p=1}s=M[a+60>>2]-1|0;M[a+60>>2]=s;j=ub(q,44,0);if(j){rd(a,54,j)}e=0;if(N[q+87|0]){break _}M[j+40>>2]=M[b+16>>2];M[f+308>>2]=0;M[f+312>>2]=0;M[f+300>>2]=0;M[f+304>>2]=0;M[f+292>>2]=0;M[f+296>>2]=0;M[f+288>>2]=j;M[f+284>>2]=h;M[f+280>>2]=a;d=i?M[i>>2]:0;M[j+16>>2]=i;L[j+2>>1]=d;d=f+280|0;uk(d,r);uk(d,M[f+208>>2]);if(w){if(i){M[f+352>>2]=0;M[f+356>>2]=0;M[f+344>>2]=0;M[f+348>>2]=0;M[f+340>>2]=55;M[f+336>>2]=a;M[f+360>>2]=b;Nb(f+336|0,M[b+44>>2]);t=M[b+36>>2]}sn(f+280|0,w)}M[j+28>>2]=M[j+24>>2];k=0;sa:{if(M[b+40>>2]|M[b+44>>2]|M[j+36>>2]!=1){break sa}g=M[M[j+32>>2]>>2];d=M[g+20>>2];if(!d|M[d>>2]!=1|(K[g+7|0]&1|K[q+82|0]&1)){break sa}g=M[g+8>>2];ta:{if(!hb(g,11346)){m=hf(M[d+8>>2])?2:0;k=1;break ta}if(hb(g,1615)){break sa}m=1;k=2}e=xc(q,d,0);if(!e){e=0;break sa}K[e+16|0]=m}fs(j,f+280|0);if(N[q+87|0]){break _}if(i){o=0;d=0;if(M[j+36>>2]!=1){break ea}d=M[j+32>>2];if(M[d+8>>2]<0){break fa}g=M[d>>2];if(!g){break fa}d=0;if(N[g+5|0]&16){break ea}d=M[g+20>>2];if(!d){break fa}d=qb(q,M[d+8>>2],0);o=Wb(a,xc(q,i,0),d);d=o?1280:0;break ea}ua:{if(M[b+36>>2]){break ua}i=M[b+28>>2];if(M[i>>2]!=1){break ua}d=M[b+32>>2];if(M[d>>2]!=1|N[d+21|0]&4|(M[b+44>>2]|M[j+36>>2]!=1)){break ua}g=M[d+16>>2];if(N[g+43|0]){break ua}d=M[i+8>>2];if(N[d|0]!=169|(j|0)!=M[d+40>>2]|(!(K[M[M[j+32>>2]+4>>2]+5|0]&1)|M[d+4>>2]&16777220)){break ua}k=Mb(M[a>>2],M[g+60>>2]);m=M[a+44>>2];M[a+44>>2]=m+1;l=M[g+20>>2];ud(a,k);i=0;Dd(a,k,M[g+20>>2],0,M[g>>2]);if(N[g+28|0]&128){i=qc(g)}va:{if(K[M[b+32>>2]+21|0]&1){break va}h=g+8|0;while(1){d=M[h>>2];if(!d){break va}wa:{if(N[d+55|0]&4){break wa}h=L[d+48>>1];if(M[d+36>>2]|(h|0)>=L[g+40>>1]|((h|0)>=L[i+48>>1]?i:0)){break wa}i=d}h=d+20|0;continue}}if(i){l=M[i+44>>2];d=tk(a,i)}else{d=0}lb(n,102,m,l,k,1);if(d){Vd(n,-1,d,-8)}d=M[a+48>>2];h=d+1|0;M[j+12>>2]=h;k=d;d=M[j+24>>2];M[a+48>>2]=M[j+36>>2]+(k+d|0);$a(n,98,m,d+h|0);fb(n,122,m);if(N[a+223|0]!=2){break ga}xa:{if(!i){g=M[g>>2];h=30808;d=30808;break xa}ya:{if(!(N[g+28|0]&128)){g=M[g>>2];break ya}g=M[g>>2];h=30808;d=30808;if(((N[i+55|0]|N[i+56|0]<<8)&3)==2){break xa}}h=M[i>>2];d=30199}M[f+104>>2]=h;M[f+100>>2]=d;M[f+96>>2]=g;fc(a,0,6111,f+96|0);break ga}l=M[j+36>>2];if(!M[j+28>>2]){break ka}g=0;d=(l|0)>0?l:0;while(1){za:{if((d|0)!=(g|0)){i=M[j+32>>2]+S(g,24)|0;if(K[M[i>>2]+7|0]&1|!(N[M[i+4>>2]+4|0]&32)){break za}}else{g=d}if((g|0)!=(l|0)){break ja}m=M[a+48>>2]+1|0;M[a+48>>2]=m;i=0;$a(n,71,0,m);l=M[j+36>>2];d=0;break ha}g=g+1|0;continue}}Pf(a,b,-1,f+208|0,f+248|0,c,M[m+28>>2],M[m+32>>2]);Cd(m);e=0;break $}if((l|0)!=1){break ja}m=0;d=M[j+32>>2];if(M[d+8>>2]<0){l=1;break ia}l=1;i=M[M[d>>2]+20>>2];d=i?1280:0;break ha}m=0}i=0;d=0}g=M[a+48>>2];M[j+12>>2]=g+1;M[a+48>>2]=M[j+24>>2]+(g+l|0);es(a,j);d=jf(a,h,t,e,i,b,d|k,0);if(!d){break _}h=N[d+47|0];ds(a,m,j,h);Aa:{if(!h){break Aa}i=M[j+32>>2];if(!i){break Aa}rn(a,h,M[i+8>>2],M[i+12>>2])}if(m){$a(n,71,1,m)}if(!(!N[d+45|0]|(!k|!(N[d+48|0]&4)))){i=d+760|0;h=N[d+44|0];Ba:{Ca:{while(1){if((h|0)<=0){break Ca}h=h-1|0;g=i+S(h,96)|0;if(!(N[M[g+80>>2]+40|0]&4)){continue}break}i=g+16|0;break Ba}i=d+32|0}Xb(n,M[i>>2])}Cd(d);cs(a,j)}M[f+208>>2]=0;Dc(a,w,s,16);Pf(a,b,-1,0,0,c,s,s);break da}d=0}g=M[a+44>>2];M[a+44>>2]=g+1;M[j+4>>2]=g;v=Ue(a,i,0,M[j+24>>2]);J=nb(n,119,M[j+4>>2],O[j+2>>1],0,v,-8);F=M[a+60>>2];B=F-2|0;M[a+60>>2]=B;g=M[i>>2];x=M[a+48>>2];z=x+4|0;H=g+z|0;M[a+48>>2]=g+H;A=x+2|0;$a(n,71,0,A);C=x+5|0;bb(n,75,0,C,z+M[i>>2]|0);$a(n,10,z,B);t=jf(a,h,t,i,o,b,d|((p?0:512)|(N[f+248|0]==2?128:64)),0);if(!t){xb(q,o);break _}if(M[a+76>>2]){g=M[j+28>>2];M[j+24>>2]=g;if(O[j+2>>1]){h=0;k=(g|0)>0?g:0;g=M[M[b+40>>2]>>2]-1|0;while(1){if((h|0)!=(k|0)){l=L[(M[j+20>>2]+(h<<4)|0)+14>>1];g=(g|0)>(l|0)?g:l;h=h+1|0;continue}break}L[j+2>>1]=g+1}fs(j,f+280|0)}h=M[a+48>>2];M[j+12>>2]=h+1;M[a+48>>2]=M[j+36>>2]+(h+M[j+24>>2]|0);g=0;E=N[t+47|0];l=0;u=M[i>>2];h=K[t+45|0];I=(h|0)>0?h:0;y=(u|0)==(I|0);if(!y){M[f+112>>2]=N[f+248|0]?K[b+4|0]&1?18704:18951:18704;h=0;fc(a,0,7379,f+112|0);g=M[j+24>>2];l=(g|0)>0?g:0;m=M[i>>2];k=m;g=k;while(1){if((h|0)!=(l|0)){P=L[(M[j+20>>2]+(h<<4)|0)+14>>1]>=(g|0);g=P+g|0;k=k+P|0;h=h+1|0;continue}break}h=0;g=vc(a,k);kf(a,i,g,0,0);K[j|0]=1;while(1){if((h|0)<M[j+24>>2]){l=M[j+20>>2]+(h<<4)|0;if(L[l+14>>1]>=(m|0)){kc(a,M[l+4>>2],g+m|0);m=m+1|0}h=h+1|0;continue}break}K[j|0]=0;h=Gb(a);bb(n,97,g,k,h);$a(n,139,M[j+4>>2],h);zb(a,h);ad(a,g,k);Cd(t);l=M[a+44>>2];M[a+44>>2]=l+1;M[j+8>>2]=l;g=Gb(a);bb(n,121,l,g,k);$a(n,34,M[j+4>>2],s);K[j+1|0]=1}Da:{if(!M[a+76>>2]){break Da}h=0;M[f+360>>2]=0;M[f+352>>2]=0;M[f+356>>2]=0;M[f+344>>2]=0;M[f+348>>2]=0;M[f+336>>2]=0;M[f+340>>2]=0;M[f+340>>2]=56;while(1){if(M[j+36>>2]<=(h|0)){break Da}Nb(f+336|0,M[M[j+32>>2]+S(h,24)>>2]);h=h+1|0;continue}}Ea:{if(!(N[q+80|0]&4|p)){if(!(N[t+48|0]&8|(u|0)!=(I|0))){u=M[n+108>>2];break Ea}M[f+208>>2]=0;be(n,M[f+228>>2])}u=M[n+108>>2];if(y){break Ea}bb(n,133,M[j+4>>2],g,l)}g=H+1|0;m=i+8|0;h=0;while(1){k=M[i>>2];if((h|0)<(k|0)){p=m+(h<<4)|0;k=O[p+12>>1];Fa:{if(!y){bb(n,94,l,h,g+h|0);break Fa}K[j|0]=1;kc(a,M[p>>2],g+h|0)}Ga:{if(!k){break Ga}k=M[(M[b+28>>2]+(k<<4)|0)-8>>2];p=$c(k);if(!p){break Ga}p=N[p|0];if((p|0)==170|(p|0)==176){break Ga}qn(k,h+C|0)}h=h+1|0;continue}break}if(v){M[v>>2]=M[v>>2]+1}nb(n,90,C,g,k,v,-8);l=M[n+108>>2];h=l+1|0;bb(n,14,h,0,h);h=x+3|0;k=F-1|0;$a(n,10,h,k);Di(a,g,C,M[i>>2]);$a(n,50,A,s);$a(n,10,z,B);g=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(l,20)|0)+8>>2]=g;i=x+1|0;ds(a,i,j,E);$a(n,71,1,i);Ha:{if(!y){$a(n,37,M[j+4>>2],u);break Ha}Cd(t);be(n,J)}xb(q,o);$a(n,10,h,k);Xb(n,s);g=M[n+108>>2];$a(n,71,1,A);fb(n,67,h);pb(n,k);k=M[n+108>>2];$a(n,50,i,k+2|0);fb(n,67,h);cs(a,j);k=k+1|0;Dc(a,w,k,16);Pf(a,b,-1,f+208|0,f+248|0,c,k,g);fb(n,67,h);pb(n,B);es(a,j);$a(n,71,0,i);fb(n,67,z);if(!d|!E){break da}d=M[j+32>>2];rn(a,E,M[d+8>>2],M[d+12>>2])}pb(n,s);break $}d=1}M[f+304>>2]=d}d=M[a+48>>2];y=d+t|0;e=y+2|0;M[a+48>>2]=e;M[f+308>>2]=e;l=0;h=e;g=0;Ia:{switch(N[i+17|0]-87|0){case 0:case 2:h=y+3|0;M[a+48>>2]=h;g=h;break;default:break Ia}}Ja:{switch(N[i+18|0]-87|0){case 0:case 2:h=h+1|0;M[a+48>>2]=h;l=h;break;default:break Ja}}x=d+1|0;d=0;u=0;o=0;s=0;if(N[i+16|0]!=77){k=v?M[v>>2]:0;s=x+M[i+76>>2]|0;o=M[i+8>>2];if(o){s=M[o>>2]+s|0}o=h+k|0;u=o+1|0;M[f+316>>2]=u;o=k+o|0;I=o+1|0;M[f+324>>2]=I;o=k+o|0;H=o+1|0;M[f+332>>2]=H;M[a+48>>2]=k+o;o=h+1|0}h=y+1|0;k=(t|0)>0?t:0;while(1){if((d|0)!=(k|0)){bb(j,94,A,d,d+x|0);d=d+1|0;continue}break}bb(j,97,x,t,h);t=0;y=0;d=M[i+8>>2];if(d){k=M[d>>2];y=M[i+76>>2];A=Ue(a,d,0,0);t=M[a+48>>2]+1|0;M[a+48>>2]=t;x=x+y|0;d=bb(j,90,x,M[i+68>>2],k);Jc(j,A,-8);y=d+2|0;bb(j,14,y,d+4|0,y);y=fb(j,10,t);bb(j,80,x,M[i+68>>2],k-1|0)}x=p+1|0;$a(j,127,x,e);bb(j,128,x,h,e);P=bb(j,53,M[i+84>>2],0,e);k=Cb(a);d=i;h=0;while(1){if(d){A=M[d+44>>2];e=0;$a(k,75,0,M[d+52>>2]);Q=M[M[d+72>>2]+20>>2];if(Q){e=M[Q>>2]}Q=(e|0)<(h|0);Ka:{if(M[i+88>>2]){break Ka}T=M[A+32>>2];if(!((T|0)!=50960&(T|0)!=50970)){$a(k,71,0,M[d+64>>2]);$a(k,71,0,M[d+64>>2]+1|0)}if(!(N[A+5|0]&16)){break Ka}A=M[d+60>>2];if(!A){break Ka}fb(k,146,A);$a(k,71,0,M[d+64>>2]+1|0)}h=Q?h:e;d=M[d+36>>2];continue}break}d=M[a+48>>2];M[a+48>>2]=d+h;M[f+300>>2]=d+1;if(g){kc(a,M[i+24>>2],g);pn(a,g,N[i+16|0]==90?3:0)}if(l){kc(a,M[i+28>>2],l);pn(a,l,N[i+16|0]==90?4:1)}La:{if(N[i+16|0]!=90){d=N[i+17|0];if(!g){break La}e=d&255;if((e|0)!=N[i+18|0]){break La}d=bb(j,(e|0)==87?58:56,g,0,l);e=f+280|0;on(e,0);fb(j,36,p);as(e);fb(j,146,p);$a(j,9,0,w);e=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(d,20)|0)+8>>2]=e}d=N[i+17|0]}Ma:{Na:{if((d&255)==87){if(!l|N[i+16|0]==90){break Na}bb(j,108,g,l,g);d=N[i+17|0]}if((d&255)==91){break Ma}}fb(j,36,F)}fb(j,36,p);fb(j,36,B);if(!(!o|!v)){bb(j,80,s,o,M[v>>2]-1|0);bb(j,80,o,u,M[v>>2]-1|0);bb(j,80,o,I,M[v>>2]-1|0);bb(j,80,o,H,M[v>>2]-1|0)}$a(j,9,0,w);e=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(P,20)|0)+8>>2]=e;if(o){$r(a,v,s,o,w)}d=N[i+17|0];Oa:{if((d|0)==87){d=f+280|0;nc(d,3,0,0);if(N[i+18|0]==91){break Oa}if(N[i+16|0]==90){e=M[a+60>>2]-1|0;M[a+60>>2]=e;h=M[j+108>>2];Ci(d,58,p,l,B,e);nc(d,2,g,0);nc(d,1,0,0);$a(j,9,0,h);pb(j,e);break Oa}d=f+280|0;nc(d,1,l,0);nc(d,2,g,0);break Oa}if(N[i+18|0]==89){Pa:{if((d|0)==89){e=N[i+16|0];d=f+280|0;nc(d,3,l,0);if((e|0)!=90){break Pa}nc(d,2,g,0);nc(d,1,0,0);break Oa}nc(f+280|0,3,l,0)}d=f+280|0;nc(d,1,0,0);nc(d,2,g,0);break Oa}e=f+280|0;nc(e,3,0,0);if(N[i+18|0]==91){break Oa}if(N[i+16|0]==90){h=M[j+108>>2];d=0;if(l){d=M[a+60>>2]-1|0;M[a+60>>2]=d;Ci(e,58,p,l,B,d)}e=f+280|0;nc(e,1,0,0);nc(e,2,g,0);if(!l){break Oa}$a(j,9,0,h);pb(j,d);break Oa}d=0;if(l){d=bb(j,50,l,0,1)}e=f+280|0;nc(e,1,0,0);nc(e,2,g,0);if(!l){break Oa}e=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(d,20)|0)+8>>2]=e}pb(j,w);Cd(m);m=0;if(M[i+8>>2]){m=$a(j,71,0,t);e=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(y,20)|0)+8>>2]=e}M[f+308>>2]=0;k=fb(j,36,x);d=N[i+17|0];Qa:{if(N[i+18|0]==89){Ra:{if((d|0)==89){d=N[i+16|0];e=f+280|0;nc(e,3,l,0);if((d|0)!=90){break Ra}nc(e,2,g,0);break Ra}nc(f+280|0,3,l,0)}nc(f+280|0,1,0,0);d=M[j+108>>2];h=N[M[j>>2]+87|0];break Qa}e=f+280|0;nc(e,3,0,0);if((d|0)==87){Sa:{if(N[i+16|0]==90){d=M[j+108>>2];h=nc(e,2,g,1);o=nc(e,1,0,1);break Sa}d=M[j+108>>2];if(N[i+18|0]==91){e=f+280|0;o=nc(e,1,g,1);h=nc(e,2,0,1);break Sa}e=f+280|0;o=nc(e,1,l,1);h=nc(e,2,g,1)}$a(j,9,0,d);d=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(h,20)|0)+8>>2]=d;e=nc(f+280|0,1,0,1);$a(j,9,0,d);d=M[j+108>>2];h=N[M[j>>2]+87|0];Ta:{if(h){M[18591]=d;e=74356;break Ta}g=M[j+104>>2];M[(g+S(o,20)|0)+8>>2]=d;e=g+S(e,20)|0}M[e+8>>2]=d;break Qa}d=M[j+108>>2];e=f+280|0;l=nc(e,1,0,1);nc(e,2,g,0);$a(j,9,0,d);d=M[j+108>>2];h=N[M[j>>2]+87|0];M[(h?74356:M[j+104>>2]+S(l,20)|0)+8>>2]=d}M[(h&255?74356:M[j+104>>2]+S(k,20)|0)+8>>2]=d;fb(j,146,p);if(M[i+8>>2]){d=M[i+88>>2];if(d){$a(j,71,1,d);$a(j,71,0,M[i+92>>2])}e=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(m,20)|0)+4>>2]=e;fb(j,67,t)}e=0;$a(n,9,0,z);pb(n,J);M[f+236>>2]=0;d=C-2|0;Pf(a,b,-1,f+208|0,f+248|0,c,d,z);pb(n,d);fb(n,67,E);pb(n,z)}if(N[f+249|0]==3){M[f+80>>2]=18951;fc(a,0,7379,f+80|0)}d=M[f+208>>2];if(d){k=M[r>>2];r=M[f+232>>2];t=M[a+60>>2]-1|0;M[a+60>>2]=t;i=M[d>>2];d=M[f+212>>2];s=i-d|0;u=M[b+28>>2];m=M[a+8>>2];j=M[c+4>>2];v=N[c|0];Ua:{if(!((s|0)!=1?d:0)){M[f+48>>2]=d?30601:30808;fc(a,0,18627,f+48|0);break Ua}M[f+64>>2]=s;fc(a,0,18658,f- -64|0)}d=M[f+224>>2];if(d){$a(m,10,M[f+220>>2],d);Xb(m,r);pb(m,M[f+224>>2])}l=M[f+216>>2];Va:{Wa:{Xa:{Ya:{switch(v-9|0){case 0:case 4:break Xa;case 1:break Ya;default:break Wa}}if(!M[b+12>>2]){break Xa}$a(m,75,0,M[c+12>>2])}p=0;g=M[c+12>>2];break Va}p=Gb(a);if((v&253)==12){k=0;g=Gb(a);break Va}g=vc(a,k)}o=1;Za:{if(K[f+240|0]&1){d=M[a+48>>2]+1|0;M[a+48>>2]=d;i=M[a+44>>2];M[a+44>>2]=i+1;if(M[f+224>>2]){b=Ub(m,15)}else{b=0}bb(m,121,i,d,(k+s|0)+1|0);if(b){h=M[m+108>>2];M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(b,20)|0)+8>>2]=h}h=$a(m,34,l,r);bb(m,133,l,d,i);o=0;break Za}h=$a(m,35,l,r);Ei(m,M[b+12>>2],t);if(M[b+12>>2]>0){$a(m,86,M[b+8>>2],-1)}i=l}u=u+8|0;d=0;w=(k|0)>0?k:0;s=o+s|0;b=s-1|0;while(1){if((d|0)==(w|0)){d=k;while(1){if((d|0)>0){d=d-1|0;o=O[(u+(d<<4)|0)+12>>1];bb(m,94,i,o?o-1|0:b,d+g|0);b=b-!o|0;continue}break}d=h+1|0;_a:{$a:{ab:{bb:{cb:{switch(v-9|0){case 3:case 5:bb(m,94,i,s,g);$a(m,127,j,p);bb(m,128,j,g,p);b=M[m+108>>2];if((b|0)<=0){break bb}L[(M[m+104>>2]+S(b,20)|0)-18>>1]=8;break bb;case 6:b=M[c+8>>2];c=b>>>31|0;i=c+g|0;h=k-c|0;c=Gb(a);bb(m,97,i,h,c);if((b|0)<0){bb(m,128,j,c,g);break bb}lb(m,138,j,c,g,b);break bb;case 0:$a(m,84,M[c+12>>2],k);break bb;case 1:break bb;case 2:break ab;default:break cb}}fb(m,12,M[c+4>>2])}if(!p){break _a}zb(a,g);break $a}nb(m,97,g,k,p,M[c+20>>2],k);lb(m,138,j,p,g,k);if(!p){break _a}ad(a,g,k)}zb(a,p)}pb(m,t);$a(m,K[f+240|0]&1?37:39,l,d);b=M[f+220>>2];if(b){fb(m,67,b)}pb(m,r)}else{b=!O[(u+(d<<4)|0)+12>>1]+b|0;d=d+1|0;continue}break}}pb(n,R);d=M[a+40>>2]>0;break c}d=1;break c}i=M[a+264>>2];M[a+264>>2]=M[g>>2];e=M[b+4>>2];db:{eb:{fb:{k=(N[g+13|0]|N[g+14|0]<<8)&512;gb:{hb:{if(!k){break hb}d=M[g+36>>2];l=N[d+18|0];if(!l){break gb}if((l|0)==2){break hb}if(M[d>>2]>1){break gb}}ib:{if(N[h+20|0]&64|N[M[a>>2]+83|0]&2){break ib}d=M[h>>2];if(_r(h,g,m+1|0,d)){break ib}if(!m){if(N[h+68|0]&2|(d|0)==1){break eb}if(e&268435456){break ib}break eb}l=m;d=g;if(e&268435456){break ib}while(1){if(N[d+12|0]&34){break ib}if(!l){break eb}l=l-1|0;e=d-35|0;d=d-48|0;if(!(N[e|0]&4)){continue}break}}if(!k){break fb}d=M[g+36>>2]}e=M[d+4>>2];if((e|0)<=0){break fb}$a(n,10,M[d+8>>2],e);e=M[g+16>>2];g=M[d+12>>2];if((e|0)!=(g|0)){$a(n,114,e,g)}L[r+2>>1]=O[d+16>>1];break db}d=_r(h,g,0,m);if(d){e=M[d+44>>2];k=M[e+4>>2];if(k){$a(n,10,M[e+8>>2],k)}$a(n,114,M[g+16>>2],M[d+16>>2]);L[r+2>>1]=O[M[e>>2]+2>>1];break db}d=M[a+48>>2]+1|0;M[a+48>>2]=d;M[p+8>>2]=d;e=Ub(n,9);k=e+1|0;M[p+4>>2]=k;l=N[g+13|0]|N[g+14|0]<<8;d=l|32;K[g+13|0]=d;K[g+14|0]=d>>>8;d=0;if(!(l&16)){d=Ub(n,15)}M[f+284>>2]=M[g+16>>2];K[f+280|0]=12;M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;M[f+32>>2]=g;fc(a,1,19471,f+32|0);Rc(a,r,f+280|0);L[M[g+8>>2]+38>>1]=O[r+2>>1];if(d){M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(d,20)|0)+8>>2]=M[n+108>>2]}$a(n,67,M[p+8>>2],k);k=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(e,20)|0)+8>>2]=k;M[a+32>>2]=0;K[a+19|0]=0;if(((N[g+13|0]|N[g+14|0]<<8)&528)!=512){break db}d=M[g+36>>2];M[d+4>>2]=M[p+4>>2];M[d+8>>2]=M[p+8>>2];M[d+12>>2]=M[g+16>>2];L[d+16>>1]=O[r+2>>1];break db}d=M[n+108>>2];e=M[a+48>>2]+1|0;M[a+48>>2]=e;M[p+8>>2]=e;k=e;e=d+1|0;bb(n,11,k,0,e);M[p+4>>2]=e;M[f+284>>2]=M[p+8>>2];K[f+280|0]=13;M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;M[f+16>>2]=g;fc(a,1,19487,f+16|0);Rc(a,r,f+280|0);L[M[g+8>>2]+38>>1]=O[r+2>>1];e=N[g+13|0]|N[g+14|0]<<8|64;K[g+13|0]=e;K[g+14|0]=e>>>8;M[p+12>>2]=M[f+292>>2];rh(n,M[p+8>>2]);M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(d,20)|0)+8>>2]=M[n+108>>2];M[a+32>>2]=0;K[a+19|0]=0}if(N[q+87|0]){break d}d=is(b);M[a+264>>2]=i;M[a+232>>2]=M[a+232>>2]-d}m=m+1|0;continue}}if(!M[g+52>>2]){fc(a,1,18462,0);fc(a,1,18443,0)}jb:{kb:{switch(N[b|0]-135|0){case 1:o=0;M[f+280>>2]=0;M[g+8>>2]=M[b+8>>2];M[g+12>>2]=M[b+12>>2];M[g+60>>2]=M[b+60>>2];d=Rc(a,g,f+248|0);M[g+60>>2]=0;if(d){break n}M[b+52>>2]=0;d=M[g+8>>2];M[b+8>>2]=d;M[b+12>>2]=M[g+12>>2];e=0;lb:{if(!d){break lb}e=fb(l,17,d);d=M[b+12>>2];if(!d){break lb}bb(l,160,M[b+8>>2],d+1|0,d)}fc(a,1,20306,0);d=Rc(a,b,f+248|0);o=M[b+52>>2];M[b+52>>2]=g;U=b,V=ie(L[b+2>>1],L[g+2>>1]),L[U+2>>1]=V;h=M[b+60>>2];mb:{if(!h){break mb}if(!gf(M[h+12>>2],f+280|0,a)){break mb}h=M[f+280>>2];if((h|0)<=0){break mb}i=L[b+2>>1];h=Td(h,0);if((i|0)<=(h|0)){break mb}L[b+2>>1]=h}if(!e){break jb}h=M[l+108>>2];M[(N[M[l>>2]+87|0]?74356:M[l+104>>2]+S(e,20)|0)+8>>2]=h;break jb;case 0:case 2:nb:{if((i|0)==1){e=M[f+252>>2];break nb}e=M[a+44>>2];M[a+44>>2]=e+1;U=b,V=$a(l,117,e,0),M[U+20>>2]=V;d=nn(b);M[d+4>>2]=M[d+4>>2]|32}M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;M[f+284>>2]=e;K[f+280|0]=1;h=f+280|0;d=Rc(a,g,h);if(d){break o}M[b+52>>2]=0;k=M[b+60>>2];M[b+60>>2]=0;d=N[b|0];K[f+280|0]=(d|0)==137?2:1;U=f,V=Bi(d),M[U+144>>2]=V;fc(a,1,20493,f+144|0);d=Rc(a,b,h);M[b+48>>2]=0;o=M[b+52>>2];M[b+52>>2]=g;if(N[b|0]==135){U=b,V=ie(L[b+2>>1],L[g+2>>1]),L[U+2>>1]=V}kb(m,M[b+60>>2]);M[b+8>>2]=0;M[b+12>>2]=0;M[b+60>>2]=k;if(N[m+87|0]|(i|0)==1){break jb}h=M[a+60>>2];i=h-2|0;M[a+60>>2]=i;h=h-1|0;Fi(a,b,h);$a(l,36,e,h);g=M[l+108>>2];Pf(a,b,e,0,0,f+248|0,i,h);pb(l,i);$a(l,39,e,g);pb(l,h);$a(l,122,e,0);break jb;default:break kb}}e=M[a+44>>2];M[a+44>>2]=e+2;o=0;U=b,V=$a(l,117,e,0),M[U+20>>2]=V;d=nn(b);M[d+4>>2]=M[d+4>>2]|32;M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;M[f+284>>2]=e;K[f+280|0]=1;i=f+280|0;d=Rc(a,g,i);if(d){break n}h=e+1|0;d=$a(l,117,h,0);M[b+52>>2]=0;M[b+24>>2]=d;k=M[b+60>>2];M[b+60>>2]=0;M[f+284>>2]=h;U=f,V=Bi(N[b|0]),M[U+128>>2]=V;fc(a,1,20493,f+128|0);d=Rc(a,b,i);o=M[b+52>>2];M[b+52>>2]=g;i=L[g+2>>1];if((i|0)<L[b+2>>1]){L[b+2>>1]=i}kb(m,M[b+60>>2]);M[b+60>>2]=k;if(d){break jb}g=M[a+60>>2];i=g-2|0;M[a+60>>2]=i;g=g-1|0;Fi(a,b,g);$a(l,36,e,g);k=Gb(a);n=$a(l,134,e,k);lb(l,28,h,i,k,0);zb(a,k);Pf(a,b,e,0,0,f+248|0,i,g);pb(l,i);$a(l,39,e,n);pb(l,g);$a(l,122,h,0);$a(l,122,e,0)}if(M[b+56>>2]){break q}ph(a)}if(M[a+40>>2]|!(N[b+4|0]&32)){break n}i=M[M[b+28>>2]>>2];h=Of(m,i,1);if(!h){d=7;break n}e=0;k=(i|0)>0?i:0;g=h+20|0;while(1){ob:{if((e|0)==(k|0)){k=b;break ob}n=sk(a,b,e);M[g>>2]=n;if(!n){M[g>>2]=M[m+8>>2]}g=g+4|0;e=e+1|0;continue}break}while(1){pb:{if(k){m=k+20|0;e=0;while(1){if((e|0)==2){break pb}j=m+(e<<2)|0;g=M[j>>2];if((g|0)<0){break pb}M[(N[M[l>>2]+87|0]?74356:M[l+104>>2]+S(g,20)|0)+8>>2]=i;M[h>>2]=M[h>>2]+1;Vd(l,g,h,-8);M[j>>2]=-1;e=e+1|0;continue}}bj(h);break n}k=M[k+52>>2];continue}}i=0;o=0;u=Ob(r,(m<<2)+4|0,0);if(u){M[u>>2]=m;e=q+8|0;h=((m|0)>0?m:0)+1|0;d=1;while(1){if((d|0)!=(h|0)){M[u+(d<<2)>>2]=O[e+12>>1]-1;e=e+16|0;d=d+1|0;continue}break}o=ls(a,b)}k=g-1|0;l=0;qb:{if((p|0)!=136){l=M[a+48>>2]+1|0;d=M[M[b+28>>2]>>2];M[a+48>>2]=l+d;$a(n,71,0,l);rb:{i=Of(r,d,1);if(!i){break rb}e=(d|0)>0?d:0;h=i+20|0;d=0;while(1){if((d|0)==(e|0)){break rb}U=h+(d<<2)|0,V=sk(a,b,d),M[U>>2]=V;K[M[i+16>>2]+d|0]=0;d=d+1|0;continue}}d=0;e=b;if((p+121&255)>>>0>1){break qb}}d=1;sb:{if(N[r+82|0]&32){break sb}e=b;while(1){h=M[e+52>>2];if(!(!h|(p|0)!=N[e|0])){d=d+1|0;e=h;continue}break}if(d>>>0<4){d=1;break sb}g=2;e=b;while(1)if(d>>>0<=g>>>0){d=1;break qb}else{g=g+2|0;e=M[e+52>>2];continue}}e=b}j=M[e+52>>2];M[e+52>>2]=0;M[j+56>>2]=0;U=j,V=xc(M[a>>2],q,0),M[U+48>>2]=V;mn(a,b,M[b+48>>2],19643);mn(a,j,M[j+48>>2],19643);Fi(a,b,k);h=0;g=0;tb:{if((p|0)!=136){break tb}q=M[b+8>>2];if(!q){break tb}h=M[a+48>>2];g=h+2|0;M[a+48>>2]=g;s=M[b+12>>2];h=h+1|0;$a(n,80,s?s+1|0:q,h);$a(n,80,h,g)}kb(r,M[b+60>>2]);M[b+60>>2]=0;w=M[a+48>>2];x=w+4|0;M[a+48>>2]=x;M[f+296>>2]=0;M[f+300>>2]=0;M[f+352>>2]=0;M[f+356>>2]=0;M[f+288>>2]=0;M[f+292>>2]=0;q=w+1|0;M[f+284>>2]=q;K[f+280|0]=13;M[f+344>>2]=0;M[f+348>>2]=0;v=w+2|0;M[f+340>>2]=v;K[f+336|0]=13;U=f,V=Bi(N[b|0]),M[U+160>>2]=V;fc(a,1,25463,f+160|0);s=bb(n,11,q,0,M[n+108>>2]+1|0);M[j+8>>2]=h;fc(a,1,18946,0);Rc(a,j,f+280|0);rh(n,q);h=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(s,20)|0)+8>>2]=h;s=0;z=bb(n,11,v,0,h+1|0);h=M[b+8>>2];B=M[b+12>>2];M[b+12>>2]=0;M[b+8>>2]=g;fc(a,1,18927,0);g=f+336|0;Rc(a,b,g);M[b+8>>2]=h;M[b+12>>2]=B;rh(n,v);h=w+3|0;w=Zr(a,b,f+280|0,c,h,l,i,k);if(d){s=Zr(a,b,g,c,x,l,i,k)}bj(i);ub:{vb:{if((p+119&255)>>>0>=2){i=$a(n,10,x,s);g=$a(n,12,v,k);Xb(n,i);U=b,V=ie(L[b+2>>1],L[j+2>>1]),L[U+2>>1]=V;break vb}i=k;g=i;if((p|0)!=138){break vb}c=g;l=L[j+2>>1];if((l|0)>=L[b+2>>1]){break ub}L[b+2>>1]=l;break ub}c=$a(n,10,h,w);$a(n,12,q,k);Xb(n,c)}h=$a(n,10,h,w);$a(n,12,q,i);Xb(n,t);wb:{if((p|0)==136){i=h;break wb}if((p|0)==138){i=h;h=i+1|0;break wb}i=$a(n,12,q,i);Xb(n,t)}l=M[n+108>>2];if(d){$a(n,10,x,s)}$a(n,12,v,c);Xb(n,t);p=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(z,20)|0)+8>>2]=p;$a(n,12,q,g);$a(n,12,v,c);pb(n,t);nb(n,89,0,0,0,u,-14);nb(n,90,M[f+292>>2],M[f+348>>2],m,o,-8);c=M[n+108>>2];if((c|0)>0){L[(M[n+104>>2]+S(c,20)|0)-18>>1]=1}bb(n,14,h,i,l);pb(n,k);c=M[e+52>>2];if(c){rd(a,57,c)}M[e+52>>2]=j;M[j+56>>2]=e;xb(r,M[j+48>>2]);M[j+48>>2]=0;ph(a);d=M[a+40>>2]!=0;break m}o=0}M[c+12>>2]=M[f+260>>2];M[c+16>>2]=M[f+264>>2];if(!o){break m}rd(a,57,o)}if(!M[b+56>>2]){break b}break a}t=M[e>>2];if(!t){break k}l=M[d+4>>2];if(l&1|(M[g>>2]>1|s?h:0)){break k}j=M[b+48>>2];if((M[d+48>>2]?j:0)|(M[d+48>>2]?s:0)){break k}xb:{if(h){if(M[b+36>>2]){break k}if(!(l&8192|o&1)){break xb}break k}if(l&8192){break k}}p=k+8|0;h=N[p+12|0];v=h&96;yb:{if(!v){t=0;break yb}if(N[M[e+16>>2]+43|0]==1|(t|0)>1){break k}t=1;if(h&16|o&1){break k}}w=(i|0)<=0;if(!(N[e+20|0]&64?w:1)){break k}k=0;l=0;zb:{if(!M[d+52>>2]){break zb}if(M[d+48>>2]|s){break k}h=d;if(v|o&1){break k}while(1){if(h){if(N[h+4|0]&9){break k}e=M[h+52>>2];if(N[h|0]!=136?e:0){break k}l=M[h+32>>2];if(M[h+68>>2]|M[l>>2]<=0){break k}h=e;if(!(N[l+20|0]&64)|w){continue}break k}break}Ab:{if(!j){break Ab}h=0;e=M[j>>2];e=(e|0)>0?e:0;l=j+20|0;while(1){if((e|0)==(h|0)){break Ab}j=h<<4;h=h+1|0;if(O[j+l>>1]){continue}break}break k}if(o&8192){break k}e=M[d+28>>2];l=e+8|0;o=0;while(1){if(M[e>>2]>(o|0)){j=o<<4;w=rc(M[j+l>>2]);h=d;while(1){h=M[h+52>>2];if(h){if((rc(M[(j+M[h+28>>2]|0)+8>>2])|0)==(w|0)){continue}break k}break}o=o+1|0;continue}break}l=0;if(M[g>>2]<2){break zb}if(N[m+82|0]&128|M[a+112>>2]>500){break k}e=M[a+44>>2];j=e>>31<<2|e>>>30;e=(e<<2)+4|0;j=e>>>0<4?j+1|0:j;e=ub(m,e,j);if(!e){break zb}M[e>>2]=M[a+44>>2];l=e}M[a+264>>2]=M[p>>2];gc(a,21,0,0,0);M[a+264>>2]=u;if(N[p+13|0]&4){k=js(m,p)}e=d+52|0;eb(m,M[p>>2]);eb(m,M[p+4>>2]);M[p>>2]=0;M[p+4>>2]=0;while(1){h=M[e>>2];if(h){d=M[b+52>>2];j=M[p+8>>2];o=M[b+60>>2];u=M[b+48>>2];M[p+8>>2]=0;M[b+60>>2]=0;M[b+48>>2]=0;M[b+52>>2]=0;e=le(m,b,0);M[b+48>>2]=u;M[b+60>>2]=o;K[b|0]=136;M[p+8>>2]=j;Bb:{if(!e){e=d;break Bb}j=M[a+112>>2]+1|0;M[a+112>>2]=j;M[e+16>>2]=j;if(!(N[m+87|0]|!l)){Yr(a,l,M[e+32>>2],i);M[f+288>>2]=0;M[f+292>>2]=0;M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=46;M[f+280>>2]=0;M[f+284>>2]=0;M[f+304>>2]=l;M[f+284>>2]=58;oc(f+280|0,e)}M[e+52>>2]=d;if(d){M[d+56>>2]=e}M[e+56>>2]=b}M[b+52>>2]=e;e=h+52|0;continue}break}eb(m,l);Cb:{if(N[m+87|0]){sh(a,p,k,0);break Cb}d=M[p+8>>2];if(d){e=M[d+24>>2];Db:{if((e|0)==1){e=M[a+132>>2];rd(e?e:a,59,d);break Db}M[d+24>>2]=e-1}M[p+8>>2]=0}B=i+1|0;C=r|12;d=k;h=b;while(1){Eb:{if(!h){break Eb}e=g+r|0;u=M[d+32>>2];l=M[u>>2];o=0;o=(b|0)==(h|0)?N[p+12|0]:o;e=N[e+20|0];g=M[h+32>>2];if((l|0)>=2){g=ln(a,g,l-1|0,B);if(!g){break Eb}M[h+32>>2]=g}w=e&64;e=0;x=(l|0)>0?l:0;j=g+8|0;E=u+8|0;u=M[u+24>>2];while(1){if((e|0)!=(x|0)){l=j+S(e+i|0,48)|0;if(N[l+14|0]&8){ye(m,M[l+40>>2])}y=E+S(e,48)|0;G(l,y,48);K[l+12|0]=w|N[l+12|0];D(y,0,48);e=e+1|0;continue}break}e=j+C|0;K[e|0]=w|(N[e|0]&64|o);l=M[d+48>>2];if(!(!l|N[h+6|0]&64)){e=0;o=M[l>>2];o=(o|0)>0?o:0;w=l+20|0;while(1){if((e|0)!=(o|0)){L[w+(e<<4)>>1]=0;e=e+1|0;continue}break}M[h+48>>2]=l;M[d+48>>2]=0}e=M[d+36>>2];M[d+36>>2]=0;if(v){oh(e,u,1)}if(e){l=M[h+36>>2];if(l){e=ob(a,44,e,l)}M[h+36>>2]=e}if(!N[m+87|0]){M[f+292>>2]=t;M[f+288>>2]=u;M[f+284>>2]=z;M[f+280>>2]=a;M[f+296>>2]=M[d+28>>2];U=f,V=Xr(d),M[U+300>>2]=V;kn(f+280|0,h,0)}M[h+4>>2]=M[h+4>>2]|M[d+4>>2]&256;e=M[d+60>>2];if(e){M[h+60>>2]=e;M[d+60>>2]=0}e=0;while(1){if((e|0)!=(x|0)){l=j+S(e+i|0,48)|0;if(M[l+8>>2]){M[f+288>>2]=0;M[f+292>>2]=0;M[f+296>>2]=0;M[f+300>>2]=0;M[f+288>>2]=46;M[f+280>>2]=0;M[f+284>>2]=0;M[f+304>>2]=l;M[f+284>>2]=60;M[l+24>>2]=0;M[l+28>>2]=0;oc(f+280|0,h)}e=e+1|0;continue}break}d=M[d+52>>2];h=M[h+52>>2];continue}break}M[f+348>>2]=0;M[f+352>>2]=0;M[f+356>>2]=0;M[f+360>>2]=0;M[f+344>>2]=46;M[f+340>>2]=47;M[f+336>>2]=a;oc(f+336|0,k);pc(m,k)}i=-1;if(M[a+40>>2]){break d}}if(N[q+87|0]){break d}h=M[b+32>>2];if(N[c|0]<9){break j}M[f+208>>2]=M[b+48>>2]}d=i}i=d+1|0;continue}}d=1;e=0}xb(q,e)}ph(a)}Na=f+368|0;return d}function jf(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0,J=0,P=0,Q=0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;u=Na-160|0;Na=u;m=M[a+8>>2];H=M[a>>2];M[u+60>>2]=0;M[u+52>>2]=0;M[u+56>>2]=0;a:{if(!d){break a}if(M[d>>2]<64){n=d;break a}g=g&24319|8192}d=M[b>>2];b:{c:{if((d|0)>=65){M[u>>2]=64;cb(a,11318,u);break c}l=g&32?1:d;i=S(l,96);k=(l|0)<=1?856:i+767&-8;j=Ob(H,k+72|0,0);if(N[H+87|0]){eb(H,j);break c}M[j+12>>2]=e;M[j+8>>2]=n;M[j+4>>2]=b;M[j>>2]=a;K[j+44|0]=l;M[j+20>>2]=-1;M[j+24>>2]=-1;d=M[a+60>>2]-1|0;M[a+60>>2]=d;L[j+42>>1]=h;L[j+40>>1]=g;M[j+32>>2]=d;M[j+28>>2]=d;d=L[a+160>>1];M[j+16>>2]=f;M[j+36>>2]=d;D(j+45|0,0,35);V=j+760|0;d=i+72|0;if(d){D(V,0,d)}M[j+500>>2]=0;M[j+504>>2]=-99;d=j+k|0;M[u+48>>2]=d;I=j+80|0;M[u+44>>2]=I;M[u+40>>2]=j;L[d+48>>1]=3;L[d+44>>1]=0;M[d+52>>2]=d+60;M[d+40>>2]=0;K[j+89|0]=0;M[j+100>>2]=0;M[j+84>>2]=0;M[j+104>>2]=j+112;M[j+92>>2]=0;M[j+96>>2]=8;M[j+80>>2]=j;Jm(I,c,44);d:{if(l){v=j+504|0;o=b+8|0;while(1){c=o+S(p,48)|0;d=M[c+16>>2];i=M[j+500>>2];M[j+500>>2]=i+1;M[v+(i<<2)>>2]=d;e:{if(!(N[c+13|0]&8)){break e}y=M[c+32>>2];if(!y){break e}k=M[c+8>>2];t=y+8|0;d=0;q=0;while(1){if(M[y>>2]<=(q|0)){break e}i=L[k+34>>1];i=(d|0)>(i|0)?d:i;f:{while(1){if((d|0)==(i|0)){break f}if(!(N[(M[k+4>>2]+S(d,12)|0)+10|0]&2)){d=d+1|0;continue}break}i=Ec(M[a>>2],168,0,0);if(!i){break e}Q=M[c+16>>2];M[i+44>>2]=k;L[i+32>>1]=d;M[i+28>>2]=Q;Q=M[c+28>>2];_=c,$=M[c+24>>2]|vr(i),M[_+24>>2]=$;M[c+28>>2]=Qa|Q;i=ob(a,54,i,ob(a,173,qb(M[a>>2],M[t+(q<<4)>>2],0),0));oh(i,M[c+16>>2],N[c+12|0]&24?1:2);he(I,i,1);q=q+1|0;d=d+1|0;continue}break}c=M[k>>2];M[u+36>>2]=q;M[u+32>>2]=c;cb(a,17128,u+32|0)}p=p+1|0;if((p|0)<M[b>>2]){continue}break}break d}if(n){K[j+45|0]=M[n>>2]}if(!(!(g&256)|N[H+80|0]&16)){K[j+47|0]=1}c=M[j+16>>2];if(!c|N[c+5|0]&4){break d}fc(a,0,18794,0)}nr(b,I);if(!(!f|!M[f+60>>2])){c=0;g:{if(M[f+40>>2]){break g}y=M[f+4>>2];if(y&9){break g}d=M[f+32>>2];if(M[d>>2]!=1|N[M[d+16>>2]+43|0]!=1){break g}i=M[I+12>>2];v=(i|0)>0?i:0;d=M[d+24>>2];k=M[f+48>>2];while(1){if((c|0)!=(v|0)){i=M[I+24>>2]+S(c,48)|0;if(!(N[i+10|0]&4|N[i+14|0])){if((d|0)!=M[i+20>>2]|(M[i+32>>2]|M[i+36>>2])){break g}}c=c+1|0;continue}break}h:{if(!k){break h}c=0;i=M[k>>2];i=(i|0)>0?i:0;k=k+8|0;while(1){if((c|0)==(i|0)){break h}v=k+(c<<4)|0;o=M[v>>2];if(N[o|0]!=168|(d|0)!=M[o+28>>2]){break g}c=c+1|0;if(!(N[v+8|0]&2)){continue}break}break g}c=M[f+12>>2];i:{if(!c){break i}if(y&256){break g}pA(I,c,M[M[f+60>>2]+16>>2],d,74);if(!M[f+12>>2]){break i}if(K[f+5|0]&1){break g}}pA(I,M[f+8>>2],M[M[f+60>>2]+12>>2],d,73)}}j:{if(M[a+40>>2]){break j}W=j+496|0;c=I;d=0;while(1){if(M[c+20>>2]>(d|0)){c=M[c+24>>2]+S(d,48)|0;k:{if(N[c+10|0]&2|(M[c+40>>2]|M[c+44>>2])){break k}f=M[c>>2];if(l){M[u+72>>2]=0;M[u+76>>2]=0;M[u+80>>2]=0;M[u+84>>2]=0;M[u+88>>2]=0;M[u+72>>2]=62;M[u+64>>2]=0;M[u+68>>2]=0;M[u+68>>2]=72;L[u+84>>1]=1;Nb(u- -64|0,f);if(!O[u+84>>1]){break k}}if(N[b+20|0]&64?N[f+4|0]&2:0){break k}Dc(a,f,M[j+32>>2],16);L[c+10>>1]=O[c+10>>1]|4}d=d+1|0;c=M[u+44>>2];continue}break}l:{if(!(g&256)){break l}if(N[H+80|0]&16){L[j+40>>1]=O[j+40>>1]&65279;g=g&32511;break l}m:{if(M[b>>2]!=1){break m}c=M[e>>2];i=(c|0)>0?c:0;k=e+8|0;y=M[b+16>>2];f=M[b+24>>2];d=0;n:{while(1){if((d|0)!=(i|0)){c=$c(M[k+(d<<4)>>2]);o:{if(!c){break o}p:{switch(N[c|0]-168|0){case 0:case 2:break p;default:break o}}if((f|0)!=M[c+28>>2]){break o}if(L[c+32>>1]<0){break n}}d=d+1|0;continue}break}d=y+8|0;while(1){c=M[d>>2];if(!c){break m}if(!(M[c+36>>2]|!N[c+54|0])){q=0;while(1){q:{if(O[c+50>>1]<=q>>>0){break q}if(!mr(I,f,q,-1,-1,2,c)){y=M[M[c+32>>2]+(q<<2)>>2];d=0;while(1){if(M[e>>2]<=(d|0)){break q}r:{v=M[k+(d<<4)>>2];i=$c(v);s:{if(!i){break s}t:{switch(N[i|0]-168|0){case 0:case 2:break t;default:break s}}if(O[i+32>>1]!=O[M[c+4>>2]+(q<<1)>>1]|(f|0)!=M[i+28>>2]){break s}if(!hb(M[Lf(a,v)>>2],y)){break r}}d=d+1|0;continue}break}if(!KA(c,q)){break q}}q=q+1|0;continue}break}if(O[c+50>>1]==(q|0)){break n}}d=c+20|0;continue}}K[j+47|0]=1;break l}if(n){break l}M[j+8>>2]=e;L[j+40>>1]=O[j+40>>1]|128}u:{v:{w:{x:{y:{z:{A:{c=M[u+40>>2];B:{if(N[c+40|0]&32|(l|0)!=1){break B}k=M[c+4>>2];i=M[k+16>>2];if(N[i+43|0]==1|N[k+21|0]&3){break B}n=M[k+24>>2];f=M[u+48>>2];L[f+46>>1]=0;M[f+40>>2]=0;y=c+80|0;d=Im(u- -64|0,y,n,-1,130,0);while(1){if(d){if(!(M[d+32>>2]|M[d+36>>2])){break A}d=ti(u- -64|0);continue}break}d=i+8|0;while(1){i=M[d>>2];if(i){C:{if(M[i+36>>2]|!N[i+54|0]){break C}d=O[i+50>>1];if(d>>>0>3){break C}v=N[i+55|0]&8?130:2;o=0;D:{while(1){d=d&65535;if(o>>>0>=d>>>0){break D}d=Im(u- -64|0,y,n,o,v,i);E:{while(1){if(!d){break E}if(M[d+32>>2]|M[d+36>>2]){d=ti(u- -64|0);continue}break}M[M[f+52>>2]+(o<<2)>>2]=d;o=o+1|0;d=O[i+50>>1];continue}break}d=O[i+50>>1]}if((d|0)!=(o|0)){break C}t=4609;M[f+40>>2]=4609;F:{if(!(N[i+55|0]&32)){if(M[i+64>>2]&M[k+32>>2]|M[i+68>>2]&M[k+36>>2]){break F}}t=4673;M[f+40>>2]=4673}M[f+32>>2]=i;L[f+24>>1]=o;L[f+44>>1]=o;d=39;break z}d=i+20|0;continue}break}t=M[f+40>>2];if(t){break y}c=M[u+40>>2]}q=M[M[c>>2]>>2];d=M[c+4>>2];f=N[c+44|0];M[u+60>>2]=2e4;p=d+8|0;Q=p+S(f,48)|0;s=c+496|0;o=M[u+48>>2];i=0;n=0;t=0;while(1){if(p>>>0>=Q>>>0){break x}K[o+16|0]=i;M[u+60>>2]=M[u+60>>2]+1e3;_=o,$=Qe(s,M[p+16>>2]),M[_+8>>2]=$;M[o+12>>2]=Qa;c=N[p+12|0];G:{if(c&98|n){t=c&64?1:t;A=r|A;E=w|E;n=c>>>4&1;break G}A=t?A:0;E=t?E:0;t=(t|0)!=0;n=0}y=0;v=0;H:{I:{c=p;J:{if(N[M[c+8>>2]+43|0]==1){while(1){K:{k=y;f=v;d=c;c=d+48|0;if(Q>>>0<=c>>>0){break K}if(!(f|k)){y=0;v=0;if(!(N[d+60|0]&34)){continue}}y=Qe(s,M[d+64>>2])|k;v=f|Qa;continue}break}d=JA(u+40|0,A,E,k,f);break J}k=0;f=0;d=IA(u+40|0,A,E)}L:{if(!d){if(!N[M[u+44>>2]+9|0]){r=r|M[o+8>>2];w=w|M[o+12>>2];break L}d=HA(u+40|0,A,E,k,f)}r=r|M[o+8>>2];w=w|M[o+12>>2];if((d|0)==101){break I}if(d){break w}}if(N[q+87|0]){break x}break H}Lc(28,12439,0)}p=p+48|0;i=i+1|0;continue}}t=4353;M[f+40>>2]=4353;M[M[f+52>>2]>>2]=d;L[f+24>>1]=1;L[f+44>>1]=1;d=33}L[f+20>>1]=d}L[f+22>>1]=1;M[c+840>>2]=f;M[f+8>>2]=1;M[f+12>>2]=0;L[c+50>>1]=1;M[c+764>>2]=n;d=M[c+8>>2];if(d){K[c+45|0]=M[d>>2]}if(K[c+41|0]&1){K[c+47|0]=1}if(N[u+89|0]<2){break v}M[f+40>>2]=t|2097152;break v}d=0}GA(q,o);if(d){break u}FA(j,0);if(N[H+87|0]){break u}if(M[j+8>>2]){f=0;d=j+60|0;i=j+840|0;k=N[j+44|0];while(1){M:{if((f|0)==(k|0)){break M}c=M[i+S(f,96)>>2];if(!c){break M}N:{n=M[c+40>>2];if(n&1024){break N}if(!(n&13)){break M}n=N[c+16|0];c=d;while(1){c=M[c>>2];if(!c){break N}if(!(O[c+40>>1]&16399|(n|0)!=N[c+16|0])){M[c>>2]=-1;M[c+4>>2]=-1}c=c+56|0;continue}}f=f+1|0;continue}break}c=L[j+50>>1];FA(j,((c|0)>0?c:0)+1<<16>>16);if(N[H+87|0]){break j}}if(!(K[j+41|0]&1)){break v}L[j+50>>1]=O[j+50>>1]-30}if(!(M[j+8>>2]|!(N[H+33|0]&16))){A=0;E=0;c=M[j+4>>2];k=c+8|0;c=M[c>>2];c=(c|0)>0?c:0;while(1){if((c|0)!=(A|0)|E){d=k+S(A,48)|0;f=N[d+13|0]|N[d+14|0]<<8;if(M[M[M[d+44>>2]>>2]+48>>2]?!(f&512)|!(f&4)|N[M[d+36>>2]+18|0]:1){i=M[j+76>>2];d=A&31;if((A&63)>>>0>=32){f=1<<d;n=0}else{n=1<<d;f=n-1&1>>>32-d}M[j+72>>2]=n|M[j+72>>2];M[j+76>>2]=f|i}i=E;A=A+1|0;E=A?i:i+1|0;continue}break}}if(M[a+40>>2]){break j}A=-1;E=-1;d=N[j+44|0];O:{P:{if(!(g&9216|(!e|d>>>0<2))){d=M[H+80>>2];if(d&256){break P}c=j+496|0;k=ef(c,M[j+12>>2]);f=Qa;d=M[j+8>>2];if(d){k=ef(c,d)|k;f=f|Qa}l=j+760|0;c=M[j+4>>2];s=c+8|0;e=N[j+44|0];A=e;E=0;z=N[c+20|0]&64;r=-1;w=-1;Q:while(1){x=E;n=A;if((x|0)>=0&n>>>0>=2|(x|0)>0){E=x-!n|0;A=n-1|0;B=l+S(A,96)|0;c=M[B+80>>2];i=s+S(N[c+16|0],48)|0;if((N[i+12|0]&24)!=8|!(K[j+41|0]&1|N[c+41|0]&16)){continue}y=M[c+8>>2];q=M[c+12>>2];if(k&y|f&q){continue}c=M[j+104>>2];p=c+S(M[j+92>>2],48)|0;d=c;while(1){if(d>>>0<p>>>0){if(y&M[d+40>>2]|q&M[d+44>>2]){v=M[d>>2];if(!(K[v+4|0]&1)|M[v+36>>2]!=M[i+16>>2]){continue Q}}R:{if(!z){break R}v=M[d>>2];if(!(N[v+4|0]&2)){break R}if(M[v+36>>2]==M[i+16>>2]){continue Q}}d=d+48|0;continue}break}d=A&31;if((A&63)>>>0>=32){i=-1<<d;d=0}else{i=(1<<d)-1&-1>>>32-d;d=-1<<d;i=i|d}t=d;v=i;d=M[j+72>>2];Q=M[j+76>>2];i=Q>>>1|0;M[j+72>>2]=((Q&1)<<31|d>>>1)&t|(t^-1)&d;M[j+76>>2]=i&v|(v^-1)&Q;d=y^-1;i=q^-1;while(1){if(c>>>0<p>>>0){if(y&M[c+40>>2]|q&M[c+44>>2]){L[c+10>>1]=O[c+10>>1]|4}c=c+48|0;continue}break}c=e&255;S:{if(!x&(c|0)==(n|0)){break S}c=S(c-n|0,96);if(!c){break S}G(B,l+S(n,96)|0,c)}r=d&r;w=i&w;e=e-1|0;K[j+44|0]=e;continue}break}d=N[j+44|0];l=d;E=w;A=r}if((d&255)>>>0<2){break O}d=M[H+80>>2]}if(d&524288){break O}c=0;d=0;k=j+840|0;n=N[j+44|0];while(1){T:{if((c|0)==(n|0)){break T}e=M[k+S(c,96)>>2];f=M[(M[j+4>>2]+S(N[e+16|0],48)|0)+16>>2];i=M[f+28>>2];if(!(i&16)){break T}M[f+28>>2]=i|256;U:{if(!c){break U}i=M[e+40>>2];if((i&8388609)!=8388609|!(i&768)|L[f+38>>1]>=d<<16>>16){break U}M[e+40>>2]=i&-4194369|4194304}c=c+1|0;d=O[e+22>>1]+d|0;continue}break}}c=M[j>>2];L[c+160>>1]=O[c+160>>1]+O[j+50>>1];v=0;V:{if(!(g&4)){break V}e=M[j+840>>2];d=M[e+40>>2];W:{if(d&4096){f=M[b+16>>2];o=1;break W}v=0;if(!(g&8)){break V}f=M[b+16>>2];v=0;if(N[f+43|0]==1){break V}if(!(g&16)){v=0;if(d&8192){break V}}o=2;v=0;if(N[H+83|0]&8){break V}}K[j+46|0]=o;v=0;if(!(d&64)){break V}v=0;if(M[f+28>>2]&128){break V}M[e+40>>2]=d&-65;v=g&8}y=(l|0)>0?l:0;X=b+8|0;r=g&32;Q=!h|!r;i=0;o=V;while(1){if((i|0)!=(y|0)){l=S(N[o+60|0],48)+X|0;e=M[l+8>>2];n=Mb(H,M[e+60>>2]);t=M[o+80>>2];X:{if(N[e+29|0]&64){break X}c=N[e+43|0];if((c|0)==2){break X}d=M[t+40>>2];if(d&1024){nb(m,173,M[l+16>>2],0,0,Gd(H,e),-11);break X}if((c|0)==1){break X}if(!(N[l+12|0]&80?0:r|d&64)){c=M[l+16>>2];if(N[j+46|0]){M[j+20>>2]=c;d=113}else{d=102}Pd(a,c,n,e,d);if(!(N[j+46|0]|L[e+34>>1]>63|(N[e+28|0]&224|(N[t+41|0]|N[t+42|0]<<8)&16448))){k=M[l+24>>2];f=M[l+28>>2];d=0;while(1){if(f|k){d=d+1|0;k=(f&1)<<31|k>>>1;f=f>>>1|0;continue}break}Vd(m,-1,d,-3)}c=M[m+108>>2];if((c|0)<=0){break X}L[(M[m+104>>2]+S(c,20)|0)-18>>1]=v;break X}Dd(a,n,M[e+20>>2],0,M[e>>2])}Y:{if(!(N[t+41|0]&2)){break Y}f=M[t+32>>2];Z:{_:{$:{if(!(!(N[e+28|0]&128)|!r)){if(((N[f+55|0]|N[f+56|0]<<8)&3)==2){break $}}if(N[j+46|0]){d=M[l+8>>2]+8|0;c=h;while(1){d=M[d>>2];if(!d|(d|0)==(f|0)){break _}d=d+20|0;c=c+1|0;continue}}d=101;c=h;if(!Q){break Z}c=M[a+44>>2];M[a+44>>2]=c+1;if(!(!(N[f+56|0]&16)|K[H+83|0]&1)){p=0;q=a+76|0;w=M[f+12>>2];while(1){aa:{if(O[f+52>>1]<=p>>>0){break aa}d=L[M[f+4>>2]+(p<<1)>>1];ba:{if((d|0)==-2){k=M[(M[f+40>>2]+(p<<4)|0)+8>>2]}else{if((d|0)<0){break ba}d=M[w+4>>2]+S(d,12)|0;if(!(N[d+10|0]&32)){break ba}k=Tc(w,d)}if(Nd(0,k)){break ba}d=md(M[a>>2],24,0);if(!d){break aa}M[d+20>>2]=M[a+76>>2];_=d,$=qb(M[a>>2],k,0),M[_>>2]=$;k=M[l+16>>2];M[d+12>>2]=p;M[d+8>>2]=c;M[d+4>>2]=k;K[d+16|0]=(N[l+12|0]&88)!=0;if(zi(M[a>>2],f)){K[d+17|0]=N[M[f+16>>2]+p|0]}M[q>>2]=d;if(M[d+20>>2]){break ba}rd(a,91,q)}p=p+1|0;continue}break}}d=102;k=M[f+36>>2];if(!k|N[l+12|0]&16){break Z}lr(a,f,k,0,c,l);break Z}M[o+8>>2]=M[o+4>>2];break Y}M[j+24>>2]=c;d=113}M[o+8>>2]=c;bb(m,d,c,M[f+44>>2],n);Ld(a,f);c=M[t+40>>2];if(K[j+40|0]&1|(!(c&15)|c&1605634)|N[j+47|0]==2){break Y}c=M[m+108>>2];if((c|0)<=0){break Y}L[(M[m+104>>2]+S(c,20)|0)-18>>1]=2}if((n|0)>=0){ud(a,n)}ca:{if(!(N[l+12|0]&16)){break ca}c=kr(j,20);M[o+56>>2]=c;if(!c){break ca}d=M[a+44>>2];M[a+44>>2]=d+1;M[c>>2]=d;d=M[a+48>>2]+1|0;M[a+48>>2]=d;M[c+4>>2]=d;$a(m,77,65536,d);d=M[a+48>>2]+1|0;M[a+48>>2]=d;M[c+8>>2]=d;$a(m,75,0,d);da:{if(!(N[e+28|0]&128)){$a(m,117,M[c>>2],1);c=Of(M[a>>2],1,0);if(!c){break da}M[c+20>>2]=0;K[M[c+16>>2]]=0;Jc(m,c,-8);break da}d=M[c>>2];c=qc(e);$a(m,117,d,O[c+50>>1]);Ld(a,c)}M[t+40>>2]=M[t+40>>2]&-65;K[j+47|0]=3;K[j+45|0]=0}o=o+96|0;i=i+1|0;continue}break}M[j+52>>2]=M[m+108>>2];if(N[H+87|0]){break j}Z=j+772|0;Q=y;y=0;v=0;while(1){ea:{if((y|0)!=(Q|0)|v){if(M[a+40>>2]){break j}l=S(y,96)+V|0;c=M[M[l+80>>2]+40>>2];d=S(N[l+60|0],48)+X|0;e=N[d+13|0]|N[d+14|0]<<8;fa:{if(!(e&32)){break fa}d=M[d+44>>2];p=0;if(!(e&16)){p=Ub(m,15)}$a(m,10,M[d+8>>2],M[d+4>>2]);if(!p){break fa}M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(p,20)|0)+8>>2]=M[m+108>>2]}if(c&4210688){ga:{if(c&16384){o=0;r=0;w=0;p=0;F=Na-16|0;Na=F;s=M[a+8>>2];J=Ub(s,15);e=M[I+24>>2];P=e+S(M[I+12>>2],48)|0;i=M[M[I>>2]+4>>2];c=i+S(N[l+60|0],48)|0;z=c+8|0;t=M[c+16>>2];B=M[l+80>>2];c=0;ha:{while(1){if(e>>>0<P>>>0){ia:{if(N[e+10|0]&2){break ia}d=M[e>>2];if(!or(d,i,N[l+60|0],0)){break ia}p=ce(a,p,qb(M[a>>2],d,0))}ja:{if(!gr(e,z,A,E)){break ja}f=M[e+24>>2];d=f&31;if((f&63)>>>0>=32){q=1<<d;d=0}else{h=1<<d;q=h-1&1>>>32-d;d=h}h=(f|0)>63;d=h?0:d;h=h?-2147483648:q;if(!(o&255)){k=M[t>>2];M[F+4>>2]=M[M[t+4>>2]+S(f,12)>>2];M[F>>2]=k;Lc(284,25326,F)}o=1;if(d&r|h&w){break ja}f=c+1|0;if(si(M[a>>2],B,f)){break ha}M[M[B+52>>2]+(c<<2)>>2]=e;r=d|r;w=h|w;c=f}e=e+48|0;continue}break}M[B+40>>2]=16961;L[B+24>>1]=c;L[B+44>>1]=c;if(N[t+43|0]==2){h=r^-1;d=w^-1}else{h=M[z+24>>2]&(r^-1);d=M[z+28>>2]&(w^-1|-2147483648)}x=L[t+34>>1];ka:{C=M[t+28>>2];if(!(C&128)){break ka}e=(x|0)>0?x:0;k=0;f=0;while(1){if(!f&(e|0)==(k|0)){break ka}if(K[(M[t+4>>2]+S(k,12)|0)+10|0]&1){if(!f&k>>>0>=63|f){d=d|-2147483648;break ka}i=k&31;n=h;if((k&63)>>>0>=32){q=1<<i;h=0}else{h=1<<i;q=h-1&1>>>32-i}i=h;i=!(i&r|q&w);h=n|(i?h:0);d=(i?q:0)|d}k=k+1|0;f=k?f:f+1|0;continue}}e=(x|0)>=63?63:x;n=(e|0)>0?e:0;k=0;f=0;while(1){if((k|0)!=(n|0)|f){i=c;e=h;c=k&31;if((k&63)>>>0>=32){c=d>>>c|0}else{c=((1<<c)-1&d)<<32-c|e>>>c}c=i+(c&1)|0;k=k+1|0;f=k?f:f+1|0;continue}break}o=0;U=(x-63&M[z+28>>2]>>31)+c|0;x=qs(M[a>>2],U+((C^-1)>>>7&1)<<16>>16,0,F+12|0);if(!x){break ha}M[B+32>>2]=x;M[x+12>>2]=t;M[x>>2]=1563;c=M[I+24>>2];k=0;f=0;r=0;w=0;e=0;while(1){if(c>>>0>=P>>>0){while(1){if((k|0)!=(n|0)|f){i=h;c=k&31;if((k&63)>>>0>=32){c=d>>>c|0}else{c=((1<<c)-1&d)<<32-c|i>>>c}if(c&1){L[M[x+4>>2]+(e<<1)>>1]=k;M[M[x+32>>2]+(e<<2)>>2]=33696;e=e+1|0}k=k+1|0;f=k?f:f+1|0;continue}break}}else{la:{if(!gr(c,z,A,E)){break la}C=M[c+24>>2];q=C&31;if((C&63)>>>0>=32){i=1<<q;T=0}else{T=1<<q;i=T-1&1>>>32-q}R=(C|0)>63;q=R?0:T;R=R?-2147483648:i;if(r&q|w&R){break la}i=M[c>>2];L[M[x+4>>2]+(e<<1)>>1]=C;C=Ug(a,i);if(C){C=M[C>>2]}else{C=33696}r=q|r;w=w|R;M[M[x+32>>2]+(e<<2)>>2]=C;e=e+1|0;i=M[i+12>>2];if(!i){break la}o=(rc(i)|0)!=66?1:o}c=c+48|0;continue}break}ma:{c=M[z+28>>2];if((c|0)>0){c=1}else{c=(c|0)>=0}if(c){break ma}c=63;while(1){if(L[t+34>>1]<=(c|0)){break ma}L[M[x+4>>2]+(e<<1)>>1]=c;M[M[x+32>>2]+(e<<2)>>2]=33696;c=c+1|0;e=e+1|0;continue}}if(!(N[t+28|0]&128)){L[M[x+4>>2]+(e<<1)>>1]=65535;M[M[x+32>>2]+(e<<2)>>2]=33696}c=M[a+44>>2];M[a+44>>2]=c+1;M[l+8>>2]=c;$a(s,116,c,U+1|0);Ld(a,x);if(!(!(o&255)|N[M[a>>2]+82|0]&8)){oA(a,M[I>>2],l);c=M[a+48>>2]+1|0;M[a+48>>2]=c;M[l+52>>2]=c;$a(s,77,1e4,c)}na:{if(N[z+13|0]&64){d=M[z+44>>2];c=M[d+8>>2];t=$a(s,71,0,0);bb(s,11,c,0,M[d+4>>2]);c=fb(s,12,c);break na}t=0;c=fb(s,36,M[l+4>>2])}o=0;if(p){o=M[a+60>>2]-1|0;M[a+60>>2]=o;Dc(a,p,o,16);M[B+40>>2]=M[B+40>>2]|131072}f=Gb(a);d=Xm(a,x,M[l+4>>2],f,0,0,0,0);h=M[l+52>>2];if(h){lb(s,183,h,0,d,O[B+24>>1])}$a(s,138,M[l+8>>2],f);h=M[s+108>>2];if((h|0)>0){L[(M[s+104>>2]+S(h,20)|0)-18>>1]=16}if(p){pb(s,o)}oa:{if(N[z+13|0]&64){e=d+e|0;M[(N[M[s>>2]+87|0]?74356:M[s+104>>2]+S(t,20)|0)+8>>2]=e;tA(a,c,M[l+4>>2],M[M[z+44>>2]+12>>2],M[l+8>>2]);Xb(s,c);d=(N[z+13|0]|N[z+14|0]<<8)&65471;K[z+13|0]=d;K[z+14|0]=d>>>8;d=M[s+108>>2];break oa}$a(s,39,M[l+4>>2],c+1|0);d=M[s+108>>2];if((d|0)<=0){break oa}L[(M[s+104>>2]+S(d,20)|0)-18>>1]=3}M[(N[M[s>>2]+87|0]?74356:M[s+104>>2]+S(c,20)|0)+8>>2]=d;zb(a,f);d=M[s+108>>2];M[(N[M[s>>2]+87|0]?74356:M[s+104>>2]+S(J,20)|0)+8>>2]=d}kb(M[a>>2],p);Na=F+16|0;break ga}d=y;c=l;n=M[c+80>>2];o=M[j>>2];x=M[o+80>>2];M[o+80>>2]=0;B=M[o+76>>2];M[o+76>>2]=0;F=j+760|0;h=M[o+8>>2];C=Ub(h,15);while(1){oA(o,j,c);t=M[o+60>>2]-1|0;M[o+60>>2]=t;q=M[c+4>>2];r=M[o+48>>2]+1|0;M[o+48>>2]=r;M[c+52>>2]=r;J=M[j+4>>2];P=N[c+60|0];p=L[M[(J+S(P,48)|0)+16>>2]+38>>1];if((p|0)<=609){e=(p|0)/10|0;w=e<<16>>16;f=p-S(e,10)|0;e=f<<16>>16;i=e>>31;f=f&65535;k=f>>>0>4;s=k?e-2|0:f?e-1|0:0;f=k?i-(e>>>0<2)|0:f?i-!e|0:0;i=s+8|0;f=i>>>0<8?f+1|0:f;k=i;e=f;z=i;s=w-3|0;f=s&31;if((s&63)>>>0>=32){i=i<<f;f=0}else{i=(1<<f)-1&z>>>32-f|e<<f;f=z<<f}pa:{if((p|0)>=30){break pa}i=3-w|0;f=i&31;if((i&63)>>>0>=32){i=0;f=e>>>f|0}else{i=e>>>f|0;f=((1<<f)-1&e)<<32-f|k>>>f}}e=f}else{i=2147483647;e=-1}f=!i&e>>>0>=1e7|(i|0)!=0;e=f?1e7:e;$a(h,77,!(f?0:i)&e>>>0<=1e4?1e4:e,r);k=fb(h,36,q);f=M[j+104>>2];e=f+S(M[j+92>>2],48)|0;while(1){if(e>>>0>f>>>0){qa:{if(N[f+10|0]&2){break qa}if(!or(M[f>>2],J,P,0)){break qa}Dc(o,M[f>>2],t,16)}f=f+48|0;continue}break}ra:{if(K[n+41|0]&1){e=Gb(o);$a(h,135,q,e);lb(h,183,M[c+52>>2],0,e,1);zb(o,e);break ra}p=M[n+32>>2];f=0;e=O[n+24>>1];i=vc(o,e);while(1){if((e|0)!=(f|0)){Jr(o,p,q,f,f+i|0);f=f+1|0;continue}break}lb(h,183,M[c+52>>2],0,i,e);ad(o,i,e)}pb(h,t);$a(h,39,M[c+4>>2],k+1|0);e=M[h+108>>2];i=N[M[h>>2]+87|0];M[(i?74356:M[h+104>>2]+S(k,20)|0)+8>>2]=e;M[n+40>>2]=M[n+40>>2]&-4194305;sa:{if(N[M[o>>2]+82|0]&16){break sa}c=d+1|0;f=N[j+44|0];k=((c|0)>(f|0)?c:f)-1|0;while(1){if((d|0)==(k|0)){break sa}d=d+1|0;c=F+S(d,96)|0;if(N[(M[j+4>>2]+S(N[c+60|0],48)|0)+20|0]&72){continue}n=M[c+80>>2];if(!n|(A&M[n>>2]|E&M[n+4>>2]|(M[n+40>>2]&4194308)!=4194304)){continue}break}if((d|0)<(f|0)){continue}}break}M[(i?74356:M[h+104>>2]+S(C,20)|0)+8>>2]=e;M[o+80>>2]=x;M[o+76>>2]=B}if(N[H+87|0]){break j}}EA(a,b,l,g);M[l+32>>2]=M[m+108>>2];r=M[l+80>>2];x=M[a>>2];f=N[l+60|0];d=M[j+4>>2]+S(f,48)|0;w=M[d+24>>2];_=l,$=(Qe(W,w)^-1)&A,M[_+88>>2]=$;M[l+92>>2]=(Qa^-1)&E;c=M[j+76>>2];h=M[j+72>>2];i=M[a+60>>2];e=i-1|0;M[l+12>>2]=e;M[l+16>>2]=e;U=i-2|0;M[a+60>>2]=U;M[l+24>>2]=U;P=d+8|0;d=y&31;if((y&63)>>>0>=32){q=c>>>d|0}else{q=((1<<d)-1&c)<<32-d|h>>>d}if(!(!f|!(N[P+12|0]&8))){c=M[a+48>>2]+1|0;M[a+48>>2]=c;M[l>>2]=c;$a(m,71,0,c)}s=q&1;d=y;while(1){if((d|0)<=0){d=0;break ea}c=S(d,96)+V|0;if(M[c>>2]|M[c+56>>2]){break ea}d=d-1|0;continue}}M[j+56>>2]=M[m+108>>2];break b}c=N[P+13|0]|N[P+14|0]<<8;ta:{ua:{if(c&64){n=0;c=M[P+44>>2];d=M[c+8>>2];bb(m,11,d,0,M[c+4>>2]);c=$a(m,12,d,e);K[l+61|0]=9;M[l+68>>2]=c;break ua}f=M[r+40>>2];if(f&1024){i=O[r+44>>1];e=vc(a,i+2|0);k=e+2|0;n=M[l+12>>2];d=0;while(1){if((d|0)!=(i|0)){c=M[M[r+52>>2]+(d<<2)>>2];va:{if(!c){break va}f=d+k|0;if(K[c+12|0]&1){if(M[r+36>>2]&(d>>>0<32?1<<d:0)){h=M[a+44>>2];M[a+44>>2]=h+1;o=M[a+48>>2]+1|0;M[a+48>>2]=o;eB(a,M[c>>2],h);bb(m,175,h,f,o);break va}Hm(a,c,l,d,s,f);n=M[l+16>>2];break va}jk(a,M[M[c>>2]+16>>2],f,1);if(!(N[r+28|0]&2)|N[c+15|0]!=74){break va}$a(m,71,0,M[M[j+16>>2]+12>>2])}d=d+1|0;continue}break}$a(m,71,M[r+24>>2],e);$a(m,71,i,e+1|0);nb(m,6,w,n,e,M[r+32>>2],K[r+28|0]&1?-6:-1);K[r+28|0]=N[r+28|0]&254;if(N[x+87|0]){M[r+32>>2]=0}M[l+64>>2]=w;K[l+61|0]=N[j+46|0]?-69:63;M[l+68>>2]=M[m+108>>2];n=0;d=0;while(1){if((d|0)==(i|0)){break ua}h=M[M[r+52>>2]+(d<<2)>>2];wa:{if(!(!(O[r+30>>1]>>>d&1)|d>>>0>15)){wg(l,h);break wa}if(N[x+87|0]|(!(K[h+12|0]&1)|M[r+36>>2]&(d>>>0<32?1<<d:0))){break wa}f=0;c=M[l+72>>2];e=(c|0)>0?c:0;c=d+k|0;while(1){xa:{if((e|0)!=(f|0)){p=74356;if(!N[M[m>>2]+87|0]){p=M[m+104>>2]+S(M[(M[l+76>>2]+S(f,20)|0)+4>>2],20)|0}o=N[p|0];ya:{if((o|0)!=135){if((o|0)!=94|(c|0)!=M[p+12>>2]){break xa}f=M[p+8>>2];e=c;break ya}if((c|0)!=M[p+8>>2]){break xa}f=c;e=M[p+12>>2]}bb(m,o,M[p+4>>2],f,e)}e=ob(a,54,0,0);if(!N[x+87|0]){f=M[M[h>>2]+12>>2];h=M[h+28>>2];if((h|0)>0){f=M[(M[f+20>>2]+(h<<4)|0)-8>>2]}M[e+12>>2]=f;f=wc(x,176,0);M[e+16>>2]=f;if(f){M[f+28>>2]=c;Dc(a,e,M[l+24>>2],16)}M[e+12>>2]=0}kb(x,e);break wa}f=f+1|0;continue}}d=d+1|0;continue}}d=M[S(d,96)+Z>>2];za:{Aa:{Ba:{Ca:{Da:{if(!(!(f&256)|!(f&5))){d=M[M[r+52>>2]>>2];c=M[a+48>>2]+1|0;M[a+48>>2]=c;d=Hm(a,d,l,0,s,c);if((d|0)!=(c|0)){zb(a,c)}c=M[l+16>>2];if(M[l+52>>2]){$a(m,13,d,c);lb(m,64,M[l+52>>2],c,d,1);CA(a,j,y,c,A,E)}bb(m,30,w,c,d);break Da}if((f&258)==258){q=0;i=0;n=0;if(f&32){n=1;i=M[M[r+52>>2]>>2]}q=f&16?M[M[r+52>>2]+(n<<2)>>2]:q;c=s?i:q;h=s?q:i;Ea:{if(h){f=M[h>>2];d=M[f+16>>2];Fa:{if(ze(d)){d=Gb(a);jk(a,M[f+16>>2],d,1);i=d;f=N[f|0]&2|1;break Fa}i=Oc(a,d,u- -64|0);wg(l,h);d=M[u+64>>2];f=N[f|0]-55|0}bb(m,N[f+51024|0],w,e,i);zb(a,d);break Ea}$a(m,s?32:36,w,d)}n=0;Ga:{if(!c){d=187;f=0;break Ga}d=M[c>>2];f=M[a+48>>2]+1|0;M[a+48>>2]=f;jk(a,M[d+16>>2],f,1);Ha:{Ia:{if(!ze(M[d+16>>2])){Ja:{switch(N[d|0]-55|0){case 0:case 2:break Ja;default:break Ia}}d=s?56:58;break Ha}d=s?57:55;break Ga}d=s?57:55}wg(l,c)}M[l+68>>2]=M[m+108>>2];M[l+64>>2]=w;K[l+61|0]=s^39;if((d|0)==187){break ua}c=M[a+48>>2]+1|0;M[a+48>>2]=c;$a(m,135,w,c);bb(m,d,f,e,c);c=M[m+108>>2];if((c|0)<=0){break ua}L[(M[m+104>>2]+S(c,20)|0)-18>>1]=83;break ua}if(f&512){k=O[r+26>>1];z=0;i=0;o=0;d=O[r+24>>1];n=d;if(f&32){o=M[M[r+52>>2]+(d<<2)>>2];n=d+1|0;i=k}c=O[r+28>>1];F=M[l+8>>2];e=M[r+32>>2];Ka:{if(!(f&16)){f=0;break Ka}f=M[M[r+52>>2]+(n<<2)>>2];if(K[f+11|0]&1){h=M[a+48>>2]+1|0;M[a+48>>2]=h;M[l+44>>2]=h;$a(m,71,1,h);M[l+48>>2]=M[m+108>>2];h=M[l+44>>2]<<1;M[l+44>>2]=h;M[l+44>>2]=h|s^N[d+M[e+28>>2]|0]==1}i=c>>>0<i>>>0?i:c;if(o){break Ka}h=L[M[e+4>>2]+(d<<1)>>1];La:{if((h|0)>=0){if(!(N[(M[M[e+12>>2]+4>>2]+S(h,12)|0)+4|0]&15)){break La}break Ka}if((h|0)!=-2){break Ka}}z=1}h=0;if((M[r+40>>2]&524336)==524288){h=M[a+48>>2]+1|0;M[a+48>>2]=h;M[l+36>>2]=h;if(M[l>>2]){$a(m,71,0,h)}i=M[a+60>>2]-1|0;M[a+60>>2]=i;M[l+40>>2]=i;z=1;i=1}C=1;if((q&1)==(N[d+M[e+28>>2]|0]!=0|0)|d>>>0>=O[e+52>>1]){break Aa}q=k&255;C=!z;z=0;n=o;break za}if(f&8192){B=M[a+44>>2];M[a+44>>2]=B+1;s=M[a+48>>2]+1|0;M[a+48>>2]=s;F=M[a+60>>2]-1|0;M[a+60>>2]=F;h=M[P+8>>2];J=M[M[r+52>>2]>>2];r=M[J+24>>2];M[l+64>>2]=s;K[l+61|0]=67;c=N[j+44|0];Ma:{if(c>>>0>=2){d=c-y|0;o=Ob(x,S(d,48)|8,0);if(!o){break ta}d=d&255;M[o>>2]=d;M[o+4>>2]=d;e=o+8|0;G(e,P,48);d=1;c=c+Y|0;c=(c|0)<=1?1:c;f=M[j+4>>2]+8|0;while(1){if((c|0)==(d|0)){break Ma}G(e+S(d,48)|0,f+S(N[(l+S(d,96)|0)+60|0],48)|0,48);d=d+1|0;continue}}o=M[j+4>>2]}i=0;C=0;t=0;if(!(N[j+40|0]&16)){Na:{if(!(N[h+28|0]&128)){C=M[a+48>>2]+1|0;M[a+48>>2]=C;$a(m,75,0,C);break Na}c=qc(h);C=M[a+44>>2];M[a+44>>2]=C+1;$a(m,117,C,O[c+50>>1]);Ld(a,c)}t=M[a+48>>2]+1|0;M[a+48>>2]=t}R=$a(m,71,0,s);d=0;p=M[j+92>>2];Oa:{if((p|0)<2){break Oa}while(1){if((d|0)<(p|0)){c=M[j+104>>2]+S(d,48)|0;Pa:{if((c|0)==(J|0)|O[c+10>>1]&32774|!(O[c+12>>1]&16383)){break Pa}c=M[c>>2];if(N[c+6|0]&64){break Pa}i=ce(a,i,qb(x,c,0));p=M[j+92>>2]}d=d+1|0;continue}break}if(!i){i=0;break Oa}i=ob(a,65580,0,i)}e=0;fc(a,1,19580,0);z=0;c=0;while(1){Qa:{Ra:{Sa:{if(M[r+12>>2]>(c|0)){d=M[r+24>>2]+S(c,48)|0;if((w|0)!=M[d+20>>2]&!(N[d+13|0]&4)){break Qa}f=qb(x,M[d>>2],0);if(N[x+87|0]){break Sa}d=f;if(i){M[i+12>>2]=d;d=i}M[u+16>>2]=c+1;fc(a,1,17510,u+16|0);q=jf(a,o,d,0,0,0,32,B);if(!q){break Sa}d=0;EA(a,o,q+760|0,0);Ta:{if(N[j+40|0]&16){break Ta}p=(M[r+12>>2]-1|0)==(c|0)?-1:c;if(!(N[h+28|0]&128)){$a(m,135,w,t);d=lb(m,47,C,0,t,p);break Ta}T=qc(h);k=O[T+50>>1];n=vc(a,k);while(1){if((d|0)!=(k|0)){Ed(m,h,w,L[M[T+4>>2]+(d<<1)>>1],d+n|0);d=d+1|0;continue}break}Ua:{Va:{if(!p){d=0;break Va}d=lb(m,29,C,0,n,k);if((p|0)<0){break Ua}}bb(m,97,n,k,t);lb(m,138,C,t,n,k);if(!p){break Ua}p=M[m+108>>2];if((p|0)<=0){break Ua}L[(M[m+104>>2]+S(p,20)|0)-18>>1]=16}ad(a,n,k)}$a(m,10,s,F);if(d){M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(d,20)|0)+8>>2]=M[m+108>>2]}k=N[q+48|0];d=0;n=M[q+840>>2];Wa:{if(!(N[n+41|0]&2)){break Wa}p=e;e=M[n+32>>2];if((p|0)!=(e|0)?c:0){break Wa}if(!(N[h+28|0]&128)){d=e;break Wa}d=((N[e+55|0]|N[e+56|0]<<8)&3)!=2?e:0}if(k&1){K[j+48|0]=N[j+48|0]|1}z=k&2?1:z;Cd(q);ph(a);break Ra}ph(a);M[l+72>>2]=e;if(e){M[l+8>>2]=B}if(i){M[i+12>>2]=0;me(x,i)}d=M[m+108>>2];M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(R,20)|0)+4>>2]=d;Xb(m,M[l+12>>2]);pb(m,F);M[l+68>>2]=M[m+108>>2];if(N[j+44|0]>=2){ib(x,o)}n=0;if(z){break ua}wg(l,J);break ua}d=e}kb(x,f);e=d}c=c+1|0;continue}}if(!(c&128)){break Ca}}K[l+61|0]=187;break Ba}M[l+64>>2]=w;K[l+61|0]=N[s+51040|0];c=$a(m,N[s+51042|0],w,d);K[l+63|0]=1;M[l+68>>2]=c+1}n=0;break ua}n=f;f=o;q=c;c=k}if(!(!(y|v)|!(N[r+42|0]&16))){fb(m,136,F)}o=0;B=BA(a,l,s,i,u- -64|0);i=M[u+64>>2];if(!(!i|!q)){o=_b(x,d+i|0)}J=M[l+(h?40:16)>>2];T=1;R=1;R=f?(N[f+12|0]&40)!=0:R;T=n?(N[n+12|0]&40)!=0:T;Xa:{if(f){k=M[M[f>>2]+16>>2];p=d+B|0;jk(a,k,p,c);AA(m,l,f);Ya:{if(N[f+10|0]&128){break Ya}if(!hf(k)){break Ya}$a(m,51,p,J)}if(i){zA(k,c,d+i|0)}c=c+d|0;p=1;z=0;if(ze(k)){R=1;break Xa}wg(l,f);i=M[u+64>>2];break Xa}if(z){R=0;$a(m,75,0,d+B|0);z=1;c=d+1|0;p=1;break Xa}if(!h){p=(d|0)!=0;z=0;c=d;break Xa}z=0;$a(m,75,0,d+B|0);p=1;c=d+1|0}jr(a,B,c-z|0,i);k=O[r+46>>1];Za:{if(k){t=0;if((c|0)==(k|0)){break Za}}if(h){$a(m,71,1,h)}k=M[l+52>>2];if(k){lb(m,64,k,J,B,d);CA(a,j,y,J,A,E)}t=0;k=s|(R<<1|(p?4:0));p=N[k+51028|0];_a:{if(!(M[r+40>>2]&1048576)|(k|0)!=6){break _a}k=fb(m,124,(L[M[e+8>>2]>>1]+9|0)/10|0);if(!(f|n)){t=k;break _a}f=M[m+108>>2];if((f|0)>0){L[(M[m+104>>2]+S(f,20)|0)-18>>1]=1}M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(k,20)|0)+8>>2]=f+1}lb(m,p,F,J,B,c);if(!h){break Za}$a(m,9,0,M[m+108>>2]+2|0);lb(m,N[(s|(c>>>0<2?2:6))+51028|0],F,J,B,c-R|0)}$a:{if(n){c=M[M[n>>2]+16>>2];f=d+B|0;jk(a,c,f,q);AA(m,l,n);ab:{if(N[n+10|0]&128){break ab}if(!hf(c)){break ab}$a(m,51,f,J)}if(o){zA(c,q,o);jr(a,f,q,o)}f=d+q|0;if(ze(c)){T=1;break $a}wg(l,n);i=M[u+64>>2];break $a}if(C){f=d;break $a}if(!h){$a(m,75,0,d+B|0);T=0}f=d+1|0}if(i){cc(x,i)}if(o){cc(x,o)}c=M[m+108>>2];M[l+68>>2]=c;bb:{if(!f){break bb}if(h){$a(m,17,h,c+3|0)}lb(m,N[(s<<1|T)+51036|0],F,J,B,f);if(!t){break bb}M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(t,20)|0)+8>>2]=M[m+108>>2]}if(h){$a(m,16,h,M[m+108>>2]+2|0);lb(m,N[(s<<1|z)+51036|0],F,J,B,f+z|0)}c=M[r+40>>2];if(c&262144){bb(m,125,F,d,d);c=M[r+40>>2]}cb:{if(!(!(c&64)|O[j+40>>1]&4128)){n=0;break cb}c=M[e+12>>2];db:{if(!(N[c+28|0]&128)){c=M[j>>2];f=M[c+8>>2];K[j+48|0]=N[j+48|0]|1;bb(f,141,F,0,w);n=e;if(!(O[j+40>>1]&4128)){break cb}d=M[c+132>>2];if(M[(d?d:c)+92>>2]){break cb}d=M[c>>2];i=M[e+12>>2];c=L[i+34>>1];c=(c<<2)+4|0;c=ub(d,c&-4,0);if(!c){break cb}M[c>>2]=L[i+34>>1];k=c+4|0;d=O[e+52>>1];n=(d>>>0<=1?1:d)-1|0;d=0;while(1){if((d|0)!=(n|0)){o=L[M[e+4>>2]+(d<<1)>>1];q=Pc(i,o);if((o|0)<0){d=d+1|0}else{d=d+1|0;M[k+(q<<2)>>2]=d}continue}break}Vd(f,-1,c,-14);break db}n=e;if((w|0)==(F|0)){break cb}d=0;c=qc(c);f=vc(a,O[c+50>>1]);while(1){i=O[c+50>>1];if(i>>>0>d>>>0){bb(m,94,F,We(e,L[M[c+4>>2]+(d<<1)>>1]),d+f|0);d=d+1|0;continue}break}lb(m,28,w,U,f,i)}n=e}eb:{if(M[l>>2]){break eb}c=M[e+36>>2];if(!c){break eb}yA(c,w,I)}fb:{gb:{c=M[r+40>>2];if(c&4096){break gb}hb:{if(!M[l+72>>2]|h){break hb}d=M[r+32>>2];if(O[r+46>>1]|!N[d+54|0]){break hb}e=O[d+50>>1];d=O[r+24>>1];if((e|0)!=(d|0)){break hb}f=0;while(1){if((d|0)==(f|0)){break gb}e=f<<2;f=f+1|0;if(!(O[M[M[r+52>>2]+e>>2]+12>>1]&384)){continue}break}}if(s){K[l+61|0]=38;break fb}K[l+61|0]=39;break fb}K[l+61|0]=187}M[l+64>>2]=F;K[l+62|0]=c>>>16&1;if(c&15){break ua}K[l+63|0]=1}e=n?1:2;while(1){c=M[j+92>>2];d=M[j+104>>2];i=0;while(1){if((c|0)>0){f=O[d+10>>1];ib:{if(f&6){break ib}h=M[l+88>>2];o=M[l+92>>2];if(h&M[d+40>>2]|o&M[d+44>>2]){K[j+48|0]=N[j+48|0]|2;break ib}k=M[d>>2];q=N[P+12|0];if(q&88){p=M[k+4>>2];if(!(p&3)|(p&1?0:q&8)){break ib}if(Qe(W,M[k+36>>2])&h|o&Qa){break ib}}jb:{kb:{if((e|0)==1){if(!xA(k,M[l+4>>2],n)){i=2;break ib}f=O[d+10>>1];break kb}if(e>>>0>2){break jb}}if(!(f&4096)){break jb}i=i?i:3;break ib}q=0;lb:{if(!(f&512)){break lb}f=M[l+44>>2];if(!f){break lb}q=fb(m,f&1|16,f>>>1|0)}Dc(a,k,U,16);if(q){M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(q,20)|0)+8>>2]=M[m+108>>2]}L[d+10>>1]=O[d+10>>1]|4}d=d+48|0;c=c-1|0;continue}break}e=i;if((e|0)>0){continue}break}c=M[j+100>>2];d=M[j+104>>2];while(1){if((c|0)>0){mb:{if(N[d+10|0]&6){break mb}e=O[d+12>>1];if(N[P+12|0]&88|(!(e&130)|!(e&2048)|(w|0)!=M[d+20>>2])){break mb}h=M[d>>2];e=mr(I,w,M[d+24>>2],A,E,131,0);if(!e|N[e+10|0]&4){break mb}f=M[e>>2];if(!(!(K[e+12|0]&1)|!(N[f+5|0]&16))&M[M[M[f+20>>2]+28>>2]>>2]>1){break mb}i=u- -64|0;G(i,f,52);M[u+76>>2]=M[h+12>>2];Dc(a,i,U,16);L[e+10>>1]=O[e+10>>1]|4}d=d+48|0;c=c-1|0;continue}break}e=M[l+56>>2];if(e){nb:{h=M[(M[j+4>>2]+S(N[l+60|0],48)|0)+16>>2];if(!(N[h+28|0]&128)){c=1;n=vc(a,2);f=n+1|0;$a(m,135,M[l+4>>2],f);break nb}i=qc(h);c=O[i+50>>1];n=vc(a,c+1|0);f=n+1|0;d=0;while(1){if((c|0)==(d|0)){break nb}Ed(m,h,w,L[M[i+4>>2]+(d<<1)>>1],d+f|0);d=d+1|0;continue}}h=lb(m,29,M[e>>2],0,f,c);bb(m,97,f,c,n);lb(m,138,M[e>>2],n,f,c);lb(m,183,M[e+4>>2],0,f,c);d=M[m+108>>2];if((d|0)>0){L[(M[m+104>>2]+S(d,20)|0)-18>>1]=16}M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(h,20)|0)+8>>2]=d;ad(a,n,c+1|0)}ob:{c=M[l>>2];pb:{qb:{if(c){M[l+28>>2]=M[m+108>>2];$a(m,71,1,c);d=M[l+56>>2];if(d){break qb}break pb}d=M[l+56>>2];if(!d){break ob}}$a(m,74,0,M[d+8>>2]);M[d+12>>2]=M[m+108>>2];K[a+26|0]=N[a+26|0]+1}d=M[j+104>>2];c=0;while(1){if(M[j+100>>2]<=(c|0)){break ob}if(!(N[P+12|0]&64|(N[d+10|0]&6|(M[l+88>>2]&M[d+40>>2]|M[l+92>>2]&M[d+44>>2])!=0))){Dc(a,M[d>>2],U,16);L[d+10>>1]=O[d+10>>1]|4}d=d+48|0;c=c+1|0;continue}}A=M[l+88>>2];E=M[l+92>>2]}M[j+28>>2]=M[l+24>>2];Y=Y-1|0;y=y+1|0;v=y?v:v+1|0;continue}}if(!j){break c}}L[a+160>>1]=M[j+36>>2];wA(H,j)}j=0}Na=u+160|0;return j}function Oi(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,P=0,Q=0,R=0;g=Na-496|0;Na=g;h=M[a>>2];f=Cb(a);a:{if(!f){break a}$a(f,166,1,1);M[a+48>>2]=2;b=Tf(a,b,c,g+492|0);if((b|0)<0){break a}k=M[h+16>>2];if((b|0)==1){if(Mz(a)){break a}}y=zc(h,M[g+492>>2]);if(!y){break a}m=k+(b<<4)|0;b:{if(e){M[g+432>>2]=d;i=tb(h,19043,g+432|0);break b}i=zc(h,d)}e=M[c+4>>2]?M[m>>2]:0;c:{if(gc(a,19,y,i,e)){break c}M[g+476>>2]=0;M[g+472>>2]=i;M[g+468>>2]=y;M[g+464>>2]=0;M[h+456>>2]=0;k=1;d:{if(e){l=Hg(h,e);j=0;if((l|0)<0){break d}}j=M[(M[h+16>>2]+(l<<4)|0)+4>>2]}if(j){k=g+464|0;l=M[j+4>>2];M[l+4>>2]=M[j>>2];j=M[h+456>>2];l=M[M[l>>2]+64>>2];r=M[l>>2];if(r){k=Ra[M[r+40>>2]](l,14,k)|0}else{k=12}M[h+456>>2]=j}if((k|0)!=12){if(!k){_m(f,1);Nf(f,0,0,M[g+464>>2],-1);Zm(f,M[g+464>>2]);ab(M[g+464>>2]);break c}b=M[g+464>>2];if(b){M[g>>2]=b;cb(a,8932,g);ab(M[g+464>>2])}M[a+12>>2]=k;M[a+40>>2]=M[a+40>>2]+1;break c}l=vw(y);if(!l){break c}j=N[l+5|0];if(j&1){if(de(a)){break c}j=N[l+5|0]}if(!(j&2|(i?j&4:0))){EB(f,l)}q=-1;j=0;e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{switch(N[l+4|0]-1|0){case 12:se(f,b);if(!i){M[a+48>>2]=M[a+48>>2]+2;a=hg(f,9,51248);M[a+124>>2]=-2e3;M[a+24>>2]=b;M[a+4>>2]=b;break c}c=Xe(i);jd(a,0,b);a=(c|0)<0?(c|0)==-2147483648?2147483647:0-c|0:c;bb(f,100,b,3,a);M[M[m+12>>2]+80>>2]=a;gj(M[m+4>>2],a);break c;case 30:a=M[m+4>>2];if(!i){if(a){a=M[M[a+4>>2]+36>>2];b=a>>31}else{a=0;b=0}Ad(f,a,b);break c}b=Xe(i);M[h+100>>2]=b;if((gh(a,b,0,0)|0)!=7){break c}Lb(h);break c;case 32:a=M[m+4>>2];G:{if(!i){break G}if(!hb(i,2513)){q=2;break G}q=jj(i,0)}H:{if(M[c+4>>2]){break H}c=0;if((q|0)<0){break H}while(1){if(M[h+20>>2]<=(c|0)){break H}Ym(M[(M[h+16>>2]+(c<<4)|0)+4>>2],q);c=c+1|0;continue}}Ad(f,Ym(a,q),0);break c;case 26:M[g+456>>2]=0;M[g+460>>2]=0;ud(a,b);d=M[a+48>>2]+1|0;M[a+48>>2]=d;I:{if((N[y|0]&223)==80){$a(f,178,b,d);break I}a=0;J:{if(!i){break J}if(vf(i,g+456|0)){break J}c=M[g+456>>2];e=M[g+460>>2];if((e|0)<0){break J}a=!e&c>>>0>=4294967294|e?-2:c}bb(f,179,b,d,a)}$a(f,84,d,1);break c;case 25:K:{L:{M:{N:{if(!i){break N}if(hb(i,13060)){if(hb(i,11912)){break N}b=0}else{b=1}if(M[c+4>>2]){break L}c=2;while(1){if(M[h+20>>2]<=(c|0)){break M}Mr(M[M[M[(M[h+16>>2]+(c<<4)|0)+4>>2]+4>>2]>>2],b);c=c+1|0;continue}}b=-1;if(M[c+4>>2]){break L}a=N[h+89|0];break K}K[h+89|0]=b}a=Mr(M[M[M[m+4>>2]+4>>2]>>2],b)}Zm(f,(a|0)==1?13060:11912);break c;case 22:O:{P:{if(!i){break P}d=0;a=jb(i);while(1){if((d|0)==6){break P}if(Eb(i,M[(d<<2)+34768>>2],a)){d=d+1|0;continue}break}if((d|0)!=2){break O}if(N[h+35|0]&16){break P}d=2;break O}d=-1;if(M[c+4>>2]){break O}M[c+4>>2]=1;b=0}a=M[h+20>>2];while(1){if((a|0)>0){a=a-1|0;if(!M[(M[h+16>>2]+(a<<4)|0)+4>>2]|(M[c+4>>2]?(a|0)!=(b|0):0)){continue}se(f,a);bb(f,4,a,1,d);continue}break};$a(f,84,1,1);break c;case 23:b=M[M[M[m+4>>2]+4>>2]>>2];M[g+456>>2]=-2;M[g+460>>2]=-1;if(!i){break E}vf(i,g+456|0);c=M[g+460>>2];d=(c|0)<0;a=d?-1:M[g+456>>2];M[b+176>>2]=a;c=d?-1:c;M[b+180>>2]=c;b=M[b+232>>2];if(!b){break e}M[b+16>>2]=a;M[b+20>>2]=c;break e;case 2:c=M[m+4>>2];if(!i){Ad(f,lo(c),0);break c}a=0;Q:{if(!hb(i,13926)){break Q}a=1;if(!hb(i,11752)){break Q}a=2;if(!hb(i,11877)){break Q}a=Xe(i);a=a>>>0<3?a&255:0}K[h+90|0]=a;if(ko(c,a)){break c}c=a-1|0;if(c>>>0>1){break c}d=M[f+108>>2];a=hg(f,5,51296);M[a+92>>2]=c;M[a+84>>2]=b;M[a+48>>2]=d+4;M[a+24>>2]=b;M[a+4>>2]=b;se(f,b);break c;case 18:M[g+456>>2]=0;R:{S:{if(!i){break S}if(!Af(i,g+456|0)){break S}c=M[g+456>>2];if((c|0)>0){break R}}c=2147483647}jd(a,0,b);$a(f,71,c,1);a=fb(f,62,b);fb(f,84,1);$a(f,86,1,-1);$a(f,50,1,a);b=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(a,20)|0)+8>>2]=b;break c;case 5:if(!i){a=M[M[m+12>>2]+80>>2];Ad(f,a,a>>31);break c}a=Xe(i);M[M[m+12>>2]+80>>2]=a;gj(M[m+4>>2],a);break c;case 6:if(!i){if(N[h+32|0]&32){a=Qk(M[m+4>>2],0);b=a>>31}else{a=0;b=0}Ad(f,a,b);break c}M[g+456>>2]=1;b=Af(i,g+456|0);a=M[g+456>>2];if(b){Qk(M[m+4>>2],a)}a=jj(i,(a|0)!=0);c=M[h+36>>2];M[h+32>>2]=M[h+32>>2]&-33|(a?32:0);M[h+36>>2]=c;Lr(h);break c;case 27:Ad(f,0,0);break c;case 38:if(!i){Ad(f,N[h+86|0],0);break c}c=N[i|0]-48&255;T:{if(c>>>0<=2){break T}if(!hb(i,14208)){c=1;break T}c=hb(i,1207)?0:2}b=M[a>>2];if(N[b+86|0]==(c|0)){break c}if(DB(a)){break c}K[b+86|0]=c;break c;case 39:if(!i){Zm(f,M[18520]);break c}U:{if(!N[i|0]){break U}b=M[h>>2];if(!(P=Ra[M[b+32>>2]](b,i,1,g+456|0)|0,Q=1,R=M[g+456>>2],R?P:Q)){break U}cb(a,1109,0);break c}if(N[h+86|0]<=1){DB(a)}ab(M[18520]);if(N[i|0]){M[g+16>>2]=i;P=74080,Q=Hb(8932,g+16|0),M[P>>2]=Q;break c}M[18520]=0;break c;case 35:if(!i){a=N[m+8|0];Ad(f,a-1|0,0-!a|0);break c}if(!N[h+85|0]){cb(a,10751,0);break c}if((b|0)==1){break c}a=Tv(i,0,1);K[m+9|0]=1;K[m+8|0]=(a&7)==7?1:a+1&7;Lr(h);break c;case 3:if(!i){EB(f,l);Ad(f,(M[l+8>>2]&M[h+32>>2]|M[l+12>>2]&M[h+36>>2])!=0,0);break c}a=M[l+8>>2];b=N[h+85|0];a=b?a:a&-16385;c=M[l+12>>2];c=b?c:c;V:{if(jj(i,0)){d=M[h+36>>2];b=M[h+32>>2];if(a&1&(b&268435456)!=0){break V}M[h+32>>2]=a|b;M[h+36>>2]=c|d;break V}b=M[h+36>>2]&(c^-1);M[h+32>>2]=M[h+32>>2]&(a^-1);M[h+36>>2]=b;if(!c&(a|0)==524288){M[h+520>>2]=0;M[h+524>>2]=0;break V}if(!(a&1)){break V}if(hb(i,3303)){break V}Jf(h)}Ub(f,166);Lr(h);break c;case 7:break p;case 8:break j;case 9:break u;case 11:break i;case 13:break r;case 14:break o;case 15:break n;case 16:break k;case 17:break B;case 19:break g;case 20:break h;case 21:break q;case 28:break l;case 29:break y;case 31:break m;case 33:break x;case 34:break A;case 36:break F;case 37:break f;case 40:break C;case 41:break w;case 42:break v;case 0:break D;case 1:break t;default:break z}}if(!i){break c}Pi(a,e);o=yf(a,2,i,e);if(!o){break c}p=qc(o);M[a+48>>2]=7;lf(a,o);e=M[o+4>>2];k=0;b=0;while(1){j=L[o+34>>1];if((j|0)<=(b|0)){break c}c=O[e+10>>1];W:{X:{if(!(c&98)){q=0;d=0;break X}if(!(M[l+8>>2]|M[l+12>>2])){k=k+1|0;break W}if(c&32){q=1;d=2;break X}q=(c&64)>>>6|0;d=q?3:1}a=c&1;Y:{if(!a|!p){break Y}c=1;a=((j|0)>0?j:0)+1|0;while(1){if((a|0)==(c|0)){break Y}if(L[(M[p+4>>2]+(c<<1)|0)-2>>1]==(b|0)){a=c}else{c=c+1|0;continue}break}}c=Tc(o,e);m=M[l+8>>2]|M[l+12>>2]?12237:12206;r=M[e>>2];v=pl(e,30808);j=0;u=(N[e+4|0]&15)!=0;j=!c|q?j:M[c+8>>2];M[g+56>>2]=d;M[g+52>>2]=a;M[g+48>>2]=j;M[g+44>>2]=u;M[g+40>>2]=v;M[g+36>>2]=r;M[g+32>>2]=b-k;Ae(f,1,m,g+32|0)}e=e+12|0;b=b+1|0;continue}}a=M[b+176>>2];c=M[b+180>>2];break e}Z:{if(!i){break Z}if(vf(i,g+456|0)){break Z}a=M[g+456>>2];if(M[g+460>>2]<0){break Z}M[h+496>>2]=a&2147483647}a=M[h+496>>2];Ad(f,a,a>>31);break c}_:{if(!i){break _}if(vf(i,g+456|0)|M[g+460>>2]<0){break _}M[h+164>>2]=0}a=M[h+164>>2];Ad(f,a,a>>31);break c}$:{if(!i){break $}if(vf(i,g+456|0)){break $}b=wp(-1,-1);a=M[g+456>>2];d=M[g+460>>2];c=Qa;if(!a&(d|0)<=0|(d|0)<0|!!(c|b)&((c|0)<=(d|0)&a>>>0>=b>>>0|(c|0)<(d|0))){break $}wp(a,d)}Ad(f,wp(-1,-1),Qa);break c}aa:{if(!i){break aa}if(vf(i,g+456|0)){break aa}Iw(M[g+456>>2],M[g+460>>2])}Ad(f,Iw(-1,-1),Qa);break c}ba:{if(!i){c=M[h+500>>2];break ba}a=Xe(i);M[h+456>>2]=0;b=a;a=(a|0)>0;c=a?b:0;M[h+500>>2]=c;M[h+452>>2]=a?h:0;M[h+448>>2]=a?42:0}Ad(f,c,c>>31);break c}ca:{da:{if(!i){c=65534;break da}c=Xe(i);if(!(c&2)){break c}l=0;j=0;if(!(c&16)){break ca}}l=0;j=0;if(M[h+496>>2]-1>>>0<1999){break ca}p=2e3;l=1;j=2}r=M[a+44>>2];M[a+44>>2]=r+1;o=e?b:M[h+20>>2]-1|0;n=c&65536;t=c&1;u=t|2;q=0;while(1){if((b|0)<=(o|0)){ea:{if((b|0)==1){break ea}ud(a,b);s=b<<4;k=M[(s+M[h+16>>2]|0)+12>>2]+16|0;while(1){k=M[k>>2];if(!k){break ea}m=M[k+8>>2];if(N[m+43|0]){continue}if(!Eb(M[m>>2],18301,7)){continue}d=O[m+38>>1];e=0;c=m+8|0;while(1){c=M[c>>2];if(c){d=N[c+55|0]&128?d:-1;c=c+20|0;e=e+1|0;continue}break}if(!(n|M[m+28>>2]&256)&(!M[m+8>>2]|d<<16>>16>=0)){continue}q=q+1|0;if((q|0)==2){jd(a,0,b)}Pd(a,r,b,m,102);fa:{if(d<<16>>16>=0){c=d&65535;lb(f,33,r,u+M[f+108>>2]|0,c>>>0<=32?-1:c-33|0,c+33|0);break fa}$a(f,36,r,u+M[f+108>>2]|0)}v=(e+v|0)+1|0;c=M[s+M[h+16>>2]>>2];M[g+420>>2]=M[m>>2];M[g+416>>2]=c;c=tb(h,29332,g+416|0);if(t){d=Gb(a);nb(f,118,0,d,0,c,-6);$a(f,84,d,1)}else{nb(f,148,j,p,0,c,-6)}continue}}b=b+1|0;continue}break}Ub(f,166);if(N[h+87|0]|l^1|(v|0)<101){break c}b=(S(p,100)>>>0)/(v>>>0)|0;c=b>>>0>100;a=74356;a=N[M[f>>2]+87|0]?a:M[f+104>>2];b=c?b:100;c=0;d=M[f+108>>2];d=(d|0)>0?d:0;while(1){if((c|0)==(d|0)){break c}e=S(c,20)+a|0;if(N[e|0]==148){M[e+8>>2]=b}c=c+1|0;continue}}a=0;Fe(h);while(1){if(M[h+20>>2]>(a|0)){b=M[(M[h+16>>2]+(a<<4)|0)+4>>2];if(b){Ra[M[16903]](M[M[M[M[b+4>>2]>>2]+228>>2]+52>>2])}a=a+1|0;continue}break}break c}ga:{ha:{ia:{ja:{if(!i){if(M[h+268>>2]==18){break ja}break ha}c=Xe(i);a=(c|0)>0;M[h+272>>2]=a?c:0;M[h+268>>2]=a?18:0;if((c|0)<=0){break ha}break ia}c=M[h+272>>2]}a=c>>31;break ga}c=0;a=0}Ad(f,c,a);break c}c=M[c>>2]?b:12;b=0;ka:{if(!i){break ka}b=1;if(!hb(i,11752)){break ka}b=2;if(!hb(i,2601)){break ka}b=hb(i,13298)?0:3}M[a+48>>2]=3;bb(f,3,c,b,1);$a(f,84,1,3);break c}M[a+48>>2]=1;c=0;while(1){if((c|0)==42){break s}a=M[(c<<2)+57696>>2];if(!a){break s}Uc(f,1,a);$a(f,84,1,1);c=c+1|0;continue}}c=M[l+8>>2];se(f,b);if(!(!i|N[l+5|0]&8)){a=hg(f,2,51448);M[a+28>>2]=c;M[a+24>>2]=b;M[a+4>>2]=b;b=Xe(i);L[a+22>>1]=1;M[a+32>>2]=b;if(!(N[h+35|0]&16)|(c|0)!=1){break c}K[a+20|0]=187;break c}a=hg(f,3,51456);M[a+32>>2]=c;M[a+24>>2]=b;M[a+4>>2]=b}a=M[f+108>>2];b=(a|0)<=1?1:a;a=1;la:{while(1){if((a|0)==(b|0)){break la}c=S(a,20);a=a+1|0;d=c;c=M[f+104>>2];if(N[d+c|0]!=166){continue}break}K[c+20|0]=187}break c}if(!i){if(de(a)){break c}Zm(f,M[(N[M[a>>2]+84|0]<<3)+51376>>2]);break c}if(N[h+24|0]&64){break c}c=51376;ma:{while(1){b=M[c>>2];if(!b){break ma}if(hb(i,b)){c=c+8|0;continue}break}a=N[c+4|0];a=a?a:2;K[M[M[h+16>>2]+12>>2]+77|0]=a;kp(h,a);break c}M[g+400>>2]=i;cb(a,8060,g+400|0);break c}e=N[y|0];F=M[c>>2];M[a+48>>2]=6;B=100;M[g+456>>2]=100;E=F?b:-1;c=e&223;q=0;na:{if(!i){break na}if(Af(M[d>>2],g+456|0)){b=M[g+456>>2];B=(b|0)<=0?100:b;M[g+456>>2]=B;break na}q=yf(a,0,i,(E|0)>=0?M[M[h+16>>2]+(E<<4)>>2]:0);B=M[g+456>>2]}C=(c|0)==81;$a(f,71,B-1|0,1);J=h+388|0;v=(q|0)!=0;while(1){oa:{pa:{if(M[h+20>>2]<=(z|0)){break pa}if((z|0)!=(E|0)?F:0){break oa}ud(a,z);b=0;K[a+23|0]=0;k=z<<4;l=M[(k+M[h+16>>2]|0)+12>>2]+16|0;c=l;qa:while(1){c=M[c>>2];if(c){d=M[c+8>>2];if((d|0)!=(q|0)?q:0){continue}e=d+8|0;b=((M[d+28>>2]^-1)>>>7&1)+b|0;while(1){d=M[e>>2];if(!d){continue qa}e=d+20|0;b=b+1|0;continue}}break}if(!b){break oa}e=Ob(h,(b+v<<2)+4|0,0);if(!e){break pa}if(q){M[e+4>>2]=0;d=1}else{d=0}c=l;ra:while(1){c=M[c>>2];if(c){b=M[c+8>>2];if((b|0)!=(q|0)?q:0){continue}if(!(N[b+28|0]&128)){d=d+1|0;M[e+(d<<2)>>2]=M[b+20>>2]}b=b+8|0;while(1){b=M[b>>2];if(!b){continue ra}d=d+1|0;M[e+(d<<2)>>2]=M[b+44>>2];b=b+20|0;continue}}break}M[e>>2]=d;b=d+8|0;if((b|0)>M[a+48>>2]){M[a+48>>2]=b}bb(f,75,0,8,b);M[a+32>>2]=0;K[a+19|0]=0;nb(f,155,1,d,8,e,-14);b=M[f+108>>2];if((b|0)>0){L[(M[f+104>>2]+S(b,20)|0)-18>>1]=z}b=fb(f,51,2);M[g+384>>2]=M[k+M[h+16>>2]>>2];nb(f,118,0,3,0,tb(h,30785,g+384|0),-6);bb(f,112,2,3,3);nh(f);c=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(b,20)|0)+8>>2]=c;Uc(f,2,30048);b=l;k=v;sa:while(1){b=M[b>>2];if(!b){k=l;ta:while(1){k=M[k>>2];if(k){n=M[k+8>>2];if(((n|0)!=(q|0)?q:0)|N[n+43|0]){continue}c=0;o=0;A=0;if(!(!(N[n+28|0]&128)|C)){o=qc(n);A=vc(a,O[o+50>>1]);bb(f,75,1,A,(O[o+50>>1]+A|0)-1|0)}hn(a,n,102,0,1,0,g+452|0,g+448|0);$a(f,71,0,7);d=n+8|0;b=d;while(1){b=M[b>>2];if(b){$a(f,71,0,c+8|0);c=c+1|0;b=b+20|0;continue}break}m=M[g+452>>2];$a(f,36,m,0);G=$a(f,86,7,1);ua:{if(!(N[n+28|0]&128)){c=0;b=L[n+34>>1];e=(b|0)>0?b:0;b=-1;while(1){if((c|0)!=(e|0)){b=!(N[(M[n+4>>2]+S(c,12)|0)+10|0]&32)+b|0;c=c+1|0;continue}break}b=b-(L[n+32>>1]==(b|0))|0;break ua}b=O[qc(n)+52>>1]-1|0}if((b|0)>=0){bb(f,94,m,b,3);Kr(f,3)}va:{if(!o|C){break va}c=lb(f,41,m,0,A,O[o+50>>1]);fb(f,51,A);M[g+368>>2]=M[n>>2];nb(f,118,0,3,0,tb(h,6528,g+368|0),-6);nh(f);b=M[f+108>>2];wa:{if(N[M[f>>2]+87|0]){M[18591]=b;c=74356;break wa}c=M[f+104>>2]+S(c,20)|0;M[c+8>>2]=b;c=c+20|0}M[c+8>>2]=b;c=0;while(1){if(O[o+50>>1]<=c>>>0){break va}Jr(a,o,m,c,c+A|0);c=c+1|0;continue}}H=M[n+28>>2]&65536;c=0;while(1){xa:{ya:{za:{Aa:{if(L[n+34>>1]>(c|0)){if(L[n+32>>1]==(c|0)){break xa}D=S(c,12);s=D+M[n+4>>2]|0;Ba:{if(H){j=N[s+4|0];t=j>>>0>31;b=t;break Ba}j=N[s+4|0];t=0;b=K[s+5|0]>65}u=b;if(!(b|j&15)){break xa}if(N[s+10|0]&32){r=3;Ed(f,n,m,c,3);p=5;j=-1;break ya}if(!O[s+8>>1]){break Aa}M[g+444>>2]=0;oj(h,Tc(n,s),N[h+84|0],N[s+5|0],g+444|0);b=M[g+444>>2];if(!b){break Aa}e=O[b+16>>1];Xc(b);p=N[(e&63)+31312|0];break za}b=M[n+16>>2];if(!(!b|N[h+33|0]&2)){b=xc(h,b,0);if(!N[h+87|0]){M[a+56>>2]=m+1;c=M[a+60>>2];e=c-2|0;M[a+60>>2]=e;j=b+8|0;p=c-1|0;c=M[b>>2];while(1){if((c|0)>=2){c=c-1|0;Dc(a,M[j+(c<<4)>>2],p,0);continue}break}Re(a,M[j>>2],e,16);pb(f,p);M[a+56>>2]=0;M[g+352>>2]=M[n>>2];nb(f,118,0,3,0,tb(h,6696,g+352|0),-6);nh(f);pb(f,e)}xb(h,b)}Ca:{if(C){break Ca}e=-1;t=0;r=M[g+448>>2];j=0;while(1){b=M[d>>2];if(!b){break Ca}c=M[a+60>>2]-1|0;M[a+60>>2]=c;if((b|0)!=(o|0)){e=Xm(a,b,m,0,0,g+444|0,j,e);$a(f,86,t+8|0,1);j=r+t|0;c=lb(f,29,j,c,e,O[b+52>>1]);Uc(f,3,30167);bb(f,112,7,3,3);Uc(f,4,30104);bb(f,112,4,3,3);p=Uc(f,4,M[b>>2]);bb(f,112,4,3,3);u=nh(f);M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(c,20)|0)+8>>2]=M[f+108>>2];if(!(N[n+28|0]&128)){$a(f,142,j,3);c=bb(f,54,3,0,(O[b+52>>1]+e|0)-1|0);Uc(f,3,30136);bb(f,112,7,3,3);Uc(f,4,30125);Xb(f,p-1|0);M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(c,20)|0)+8>>2]=M[f+108>>2]}d=0;c=0;while(1){if(O[b+50>>1]>c>>>0){if(M[M[b+32>>2]+(c<<2)>>2]!=33696){if(!d){d=M[a+60>>2]-1|0;M[a+60>>2]=d}bb(f,94,j,c,3);bb(f,53,3,d,c+e|0)}c=c+1|0;continue}break}if(d){c=Ub(f,9);pb(f,d);Uc(f,3,30167);bb(f,112,7,3,3);Uc(f,4,30077);Xb(f,p-1|0);M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(c,20)|0)+8>>2]=M[f+108>>2]}if(N[b+54|0]){d=M[a+60>>2]-1|0;M[a+60>>2]=d;c=0;while(1){if(O[b+50>>1]>c>>>0){s=L[M[b+4>>2]+(c<<1)>>1];Da:{if((s|0)>=0){if(N[(M[n+4>>2]+S(s,12)|0)+4|0]&15){break Da}}$a(f,51,c+e|0,d)}c=c+1|0;continue}break}c=fb(f,39,j);Xb(f,d);s=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(c,20)|0)+8>>2]=s;lb(f,41,j,d,e,O[b+50>>1]);Uc(f,3,30021);Xb(f,p);pb(f,d)}d=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(u,20)|0)+8>>2]=d;Ir(a,M[g+444>>2]);j=b}t=t+1|0;d=b+20|0;continue}}$a(f,39,m,G);c=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:(M[f+104>>2]+S(G,20)|0)-20|0)+8>>2]=c;if(!o){continue ta}ad(a,A,O[o+50>>1]);continue ta}p=5}Ea:{if(N[n+28|0]&128){r=We(qc(n),c<<16>>16);break Ea}r=Pc(n,c<<16>>16)}j=m}b=M[a+60>>2];w=b-2|0;M[a+60>>2]=w;I=b-1|0;Fa:{if(!(N[s+4|0]&15)){break Fa}e=lb(f,18,j,w,r,p);x=M[f+108>>2];Ga:{if((j|0)<0){b=e;if((x|0)<=0){break Ga}L[(M[f+104>>2]+S(x,20)|0)-18>>1]=15;break Ga}if((x|0)>0){L[(M[f+104>>2]+S(x,20)|0)-18>>1]=13}bb(f,94,j,r,3);CB(f,n,c,3);b=$a(f,52,3,w)}x=M[n>>2];M[g+340>>2]=M[s>>2];M[g+336>>2]=x;nb(f,118,0,3,0,tb(h,6307,g+336|0),-6);if(!u){break Fa}Xb(f,I);u=M[f+108>>2];Ha:{if(N[M[f>>2]+87|0]){M[18591]=u;b=74356;break Ha}x=S(e,20);e=M[f+104>>2];M[(x+e|0)+8>>2]=u;b=e+S(b,20)|0}M[b+8>>2]=u}Ia:{Ja:{if(t){lb(f,18,j,w,r,p);b=M[f+108>>2];if((b|0)>0){L[(M[f+104>>2]+S(b,20)|0)-18>>1]=N[(N[s+4|0]>>>4|0)+51327|0]}b=M[(N[s+4|0]>>>2&60)+68236>>2];e=M[n>>2];M[g+296>>2]=M[D+M[n+4>>2]>>2];M[g+292>>2]=e;M[g+288>>2]=b;b=tb(h,6265,g+288|0);break Ja}if(H){break Ia}b=K[s+5|0];if((b|0)==66){lb(f,18,j,w,r,p);b=M[f+108>>2];if((b|0)>0){L[(M[f+104>>2]+S(b,20)|0)-18>>1]=28}b=M[n>>2];M[g+308>>2]=M[D+M[n+4>>2]>>2];M[g+304>>2]=b;b=tb(h,6327,g+304|0);break Ja}if((b|0)<67){break Ia}lb(f,18,j,w,r,p);b=M[f+108>>2];if((b|0)>0){L[(M[f+104>>2]+S(b,20)|0)-18>>1]=27}if((j|0)>=0){Ed(f,n,m,c,3)}nb(f,96,3,1,0,20992,-1);lb(f,18,-1,w,3,p);b=M[f+108>>2];if((b|0)>0){L[(M[f+104>>2]+S(b,20)|0)-18>>1]=28}b=M[n>>2];M[g+324>>2]=M[D+M[n+4>>2]>>2];M[g+320>>2]=b;b=tb(h,6287,g+320|0)}nb(f,118,0,3,0,b,-6)}pb(f,I);nh(f);pb(f,w)}c=c+1|0;continue}}break}while(1){l=M[l>>2];if(!l){break oa}b=M[l+8>>2];if(((b|0)!=(q|0)?q:0)|N[b+43|0]!=1){continue}if(L[b+34>>1]<=0){if(!Sc(J,M[M[b+48>>2]>>2])){continue}}lf(a,b);c=M[b+52>>2];if(!c){continue}c=M[c+8>>2];if(!c){continue}c=M[c>>2];if(!c|M[c>>2]<4|!M[c+96>>2]){continue}bb(f,174,z,3,C);M[b+24>>2]=M[b+24>>2]+1;Jc(f,b,-16);b=fb(f,51,3);nh(f);M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(b,20)|0)+8>>2]=M[f+108>>2];continue}}c=M[b+8>>2];if((c|0)!=(q|0)?q:0){continue}Ka:{if(!(N[c+28|0]&128)){d=k+1|0;break Ka}d=c+8|0;e=k;while(1){d=M[d>>2];if(!(!d|((N[d+55|0]|N[d+56|0]<<8)&3)==2)){d=d+20|0;e=e+1|0;continue}break}d=k;k=e}k=k+8|0;c=c+8|0;while(1){c=M[c>>2];if(!c){k=d;continue sa}if(!M[c+36>>2]){e=bb(f,54,d+8|0,0,k);Uc(f,4,M[c>>2]);bb(f,112,4,2,3);nh(f);M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(e,20)|0)+8>>2]=M[f+108>>2]}c=c+20|0;d=d+1|0;continue}}}a=hg(f,7,51344);if(a){M[a+116>>2]=16038;K[a+101|0]=255;M[a+56>>2]=11962;K[a+41|0]=255;M[a+8>>2]=1-B}b=M[f+108>>2]-2|0;M[(N[M[f>>2]+87|0]?74356:M[f+104>>2])+12>>2]=b;break c}z=z+1|0;continue}}if(!i){break c}a=jj(i,0);b=a?12:4;a=a?51552:31404;c=2;while(1){if((c|0)==4){break c}rl(h,14559,c,1,a,43,0,0,0,0,0);d=re(h,14559,c,1,0);M[d+4>>2]=b|M[d+4>>2]&-2097157;c=c+1|0;continue}}c=M[a+48>>2];l=c+5|0;M[a+48>>2]=l;v=c+3|0;u=c+2|0;m=c+1|0;o=M[M[(M[h+16>>2]+(b<<4)|0)+12>>2]+16>>2];while(1){if(!o){break c}La:{if(i){d=yf(a,0,i,e);o=0;break La}d=M[o+8>>2];o=M[o>>2]}if(!M[d+48>>2]|(N[d+43|0]|!d)){continue}c=M[h+16>>2];b=Mb(h,M[d+60>>2]);e=M[c+(b<<4)>>2];ud(a,b);Dd(a,b,M[d+20>>2],0,M[d>>2]);c=l+L[d+34>>1]|0;if((c|0)>M[a+48>>2]){M[a+48>>2]=c}Pd(a,0,b,d,102);Uc(f,m,M[d>>2]);k=1;j=d+48|0;c=j;while(1){p=M[c>>2];if(p){c=Hc(h,M[p+8>>2],e);Ma:{if(!c){break Ma}M[g+456>>2]=0;Dd(a,b,M[c+20>>2],0,M[c>>2]);if(wi(a,c,p,g+456|0,0)){break c}r=M[g+456>>2];if(!r){Pd(a,k,b,c,102);break Ma}bb(f,102,k,M[r+44>>2],b);Ld(a,r)}c=p+4|0;k=k+1|0;continue}break}if(M[a+44>>2]<(k|0)){M[a+44>>2]=k}t=1;r=fb(f,36,0);while(1){k=M[j>>2];if(k){p=Hc(h,M[k+8>>2],e);M[g+452>>2]=0;M[g+456>>2]=0;if(p){wi(a,p,k,g+456|0,g+452|0)}j=M[a+60>>2]-1|0;M[a+60>>2]=j;b=M[k+20>>2];c=l+b|0;if((c|0)>M[a+48>>2]){M[a+48>>2]=c}n=k+36|0;c=0;while(1){if((b|0)>(c|0)){b=M[g+452>>2];q=M[(b?b+(c<<2)|0:n+(c<<3)|0)>>2];b=c+l|0;Ed(f,d,0,q,b);$a(f,51,b,j);c=c+1|0;b=M[k+20>>2];continue}break}c=M[g+456>>2];Na:{if(c){nb(f,96,l,b,0,zi(h,c),M[k+20>>2]);lb(f,29,t,j,l,M[k+20>>2]);break Na}if(!p){break Na}bb(f,30,t,M[f+108>>2]+2|0,l);Xb(f,j)}$a(f,M[d+28>>2]&128?75:135,0,u);b=M[k+8>>2];M[g+276>>2]=t-1;M[g+272>>2]=b;Ae(f,v,18719,g+272|0);$a(f,84,m,4);pb(f,j);eb(h,M[g+452>>2]);j=k+4|0;t=t+1|0;continue}break}$a(f,39,0,r+1|0);c=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(r,20)|0)+8>>2]=c;continue}}if(!i){break c}d=Hc(h,i,e);if(!d|N[d+43|0]){break c}b=M[d+48>>2];if(!b){break c}c=Mb(h,M[d+60>>2]);M[a+48>>2]=8;ud(a,c);while(1){if(!b){break c}a=b+36|0;c=0;while(1){if(M[b+20>>2]>(c|0)){e=a+(c<<3)|0;k=M[M[d+4>>2]+S(M[e>>2],12)>>2];e=M[e+4>>2];l=M[b+8>>2];o=BB(N[b+26|0]);p=N[b+25|0];M[g+268>>2]=20451;P=g,Q=BB(p),M[P+264>>2]=Q;M[g+260>>2]=o;M[g+256>>2]=e;M[g+252>>2]=k;M[g+248>>2]=l;M[g+244>>2]=c;M[g+240>>2]=j;Ae(f,1,4235,g+240|0);c=c+1|0;continue}break}j=j+1|0;b=M[b+4>>2];continue}}while(1){if((j|0)==66){break c}M[g+224>>2]=M[(j<<4)+35344>>2];Ae(f,1,8933,g+224|0);j=j+1|0;continue}}M[a+48>>2]=1;c=h+396|0;while(1){c=M[c>>2];if(!c){break c}M[g+208>>2]=M[M[c+8>>2]+4>>2];Ae(f,1,8933,g+208|0);continue}}b=M[h+24>>2];M[a+48>>2]=6;b=b>>>5&1;a=0;while(1){if((a|0)!=23){c=(a<<2)+74084|0;while(1){c=M[c>>2];if(c){AB(f,c,1,b);c=c+36|0;continue}break}a=a+1|0;continue}break}c=h+424|0;while(1){c=M[c>>2];if(!c){break c}AB(f,M[c+8>>2],0,b);continue}}M[a+48>>2]=2;c=h+440|0;b=0;while(1){c=M[c>>2];if(!c){break c}M[g+196>>2]=M[M[c+8>>2]>>2];M[g+192>>2]=b;Ae(f,1,5312,g+192|0);b=b+1|0;continue}}M[a+48>>2]=3;c=0;while(1){if(M[h+20>>2]<=(c|0)){break c}a=M[h+16>>2]+(c<<4)|0;b=M[a+4>>2];if(b){a=M[a>>2];P=g,Q=Sv(b),M[P+184>>2]=Q;M[g+180>>2]=a;M[g+176>>2]=c;Ae(f,1,4244,g+176|0)}c=c+1|0;continue}}if(!i){break c}b=Hc(h,i,e);if(!b){break c}c=Mb(h,M[b+60>>2]);M[a+48>>2]=5;ud(a,c);c=b+8|0;b=0;while(1){a=M[c>>2];if(!a){break c}c=N[a+55|0]|N[a+56|0]<<8;d=N[a+54|0];e=M[a>>2];M[g+160>>2]=M[a+36>>2]!=0;M[g+148>>2]=e;M[g+152>>2]=(d|0)!=0;M[g+156>>2]=M[((c&3)<<2)+51316>>2];M[g+144>>2]=b;Ae(f,1,12213,g+144|0);c=a+20|0;b=b+1|0;continue}}if(!i){break c}b=nf(h,i,e);if(!b){b=yf(a,2,i,e);if(!b|!(N[b+28|0]&128)){break c}b=qc(b);if(!b){break c}}c=Mb(h,M[b+24>>2]);d=!(M[l+8>>2]|M[l+12>>2]);k=O[(d?50:52)+b>>1];M[a+48>>2]=d?3:6;o=M[b+12>>2];ud(a,c);c=0;while(1){if((c|0)==(k|0)){break c}d=L[M[b+4>>2]+(c<<1)>>1];if((d|0)>=0){e=M[M[o+4>>2]+S(d,12)>>2]}else{e=0}M[g+136>>2]=e;M[g+132>>2]=d;M[g+128>>2]=c;Ae(f,1,18713,g+128|0);if(M[l+8>>2]|M[l+12>>2]){d=N[M[b+28>>2]+c|0];e=M[M[b+32>>2]+(c<<2)>>2];M[g+120>>2]=O[b+50>>1]>c>>>0;M[g+116>>2]=e;M[g+112>>2]=d;Ae(f,4,18718,g+112|0)}$a(f,84,1,M[a+48>>2]);c=c+1|0;continue}}M[a+48>>2]=6;Pi(a,e);while(1){if(M[h+20>>2]<=(o|0)){break c}a=M[h+16>>2];Oa:{if(e){if(hc(e,M[a+(o<<4)>>2])){break Oa}}l=o<<4;k=M[(l+a|0)+12>>2];a=M[k+12>>2];while(1){b=k+16|0;Pa:{Qa:while(1){c=b;if(!a){break Pa}while(1){c=M[c>>2];if(!c){a=0;continue Qa}d=M[c+8>>2];if(O[d+34>>1]){continue}break}break}M[g+96>>2]=M[d>>2];b=tb(h,29257,g+96|0);if(b){wl(h,b,16,g+456|0);cd(M[g+456>>2]);ib(h,b)}if(N[h+87|0]){cb(M[h+264>>2],1162,0);M[M[h+264>>2]+12>>2]=7}a=a-1|0;k=M[(l+M[h+16>>2]|0)+12>>2];continue}break}b=k+16|0;while(1){b=M[b>>2];if(!b){break Oa}c=M[b+8>>2];if(i){if(hc(i,M[c>>2])){continue}}a=1856;Ra:{Sa:{switch(N[c+43|0]-1|0){case 0:a=11863;break Ra;case 1:break Ra;default:break Sa}}a=N[c+29|0]&16?1728:14426}k=M[l+M[h+16>>2]>>2];d=M[c>>2];Ta:{if(Eb(d,18301,7)){break Ta}j=d+7|0;if(!hb(j,9316)){d=18206;break Ta}if(hb(j,9297)){break Ta}d=18187}j=L[c+34>>1];c=M[c+28>>2];M[g+84>>2]=c>>>16&1;M[g+80>>2]=c>>>7&1;M[g+76>>2]=j;M[g+72>>2]=a;M[g+68>>2]=d;M[g+64>>2]=k;Ae(f,1,12245,g- -64|0);continue}}o=o+1|0;continue}}Ad(f,a,c)}ib(h,y);eb(h,i)}Na=g+496|0}function XA(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;e=Na-288|0;Na=e;g=M[a+24>>2];f=M[g>>2];m=b;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{d=N[b|0];switch(d-45|0){case 0:case 1:break z;case 2:case 3:case 14:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:break j;case 4:case 8:case 9:case 10:case 11:case 12:case 13:break y;case 5:break w;case 6:case 7:break C;case 15:break A;case 31:break D;default:break E}}F:{switch(d-139|0){case 1:case 2:break j;case 0:break w;case 3:break B;default:break F}}if((d|0)==20){break w}if((d|0)==157){break x}if((d|0)!=172){break j}l=M[f>>2];if(K[b+7|0]&1){d=M[b+44>>2];h=N[d+16|0]!=167?d:0}m=N[l+84|0];t=M[g+24>>2];q=M[b+20>>2];if(q){c=M[q>>2]}d=M[b+8>>2];j=re(l,d,c,m,0);if(j){break v}j=re(M[f>>2],d,-2,m,0);d=(j|0)!=0;i=!j;break u}a=M[g+4>>2];K[b|0]=168;M[b+44>>2]=M[a+16>>2];M[b+28>>2]=M[a+24>>2];L[b+32>>1]=O[b+32>>1]-1;K[b+1|0]=68;break j}d=g;while(1){if(!(!d|c>>>0>7)){M[(e+224|0)+(c<<2)>>2]=M[d+16>>2];c=c+1|0;d=M[d+12>>2];continue}break}Nb(a,M[b+12>>2]);d=1;if(N[f+224|0]>1){break a}m=M[b+12>>2];if(hf(m)){break a}c=g;while(1){if(c){if(!(N[c+26|0]&16)){break a}c=M[c+12>>2];continue}break}a=N[b|0];K[b|0]=156;M[b+8>>2]=(a|0)==52;M[b+4>>2]=M[b+4>>2]|2048;c=0;while(1){if(!(!g|c>>>0>7)){M[g+16>>2]=M[(e+224|0)+(c<<2)>>2];c=c+1|0;g=M[g+12>>2];continue}break}kb(M[f>>2],m);M[b+12>>2]=0;break a}a=M[b+12>>2];if(N[g+24|0]&40){Lm(f,g,9068,0,b)}d=M[b+16>>2];G:{if(N[d|0]==60){break G}c=M[a+8>>2];a=M[d+12>>2];d=M[d+16>>2]}m=d;j=M[a+8>>2];if(N[f+224|0]<2){break A}kd(f,b,m);kd(f,b+44|0,a)}r=M[f>>2];M[e+224>>2]=0;n=M[m+8>>2];M[b+28>>2]=-1;if(!c|N[g+24|0]&6){break g}t=M[r+20>>2];a=(t|0)>0?t:0;d=0;while(1){H:{I:{if((a|0)==(d|0)){d=a;break I}i=M[r+16>>2];l=d<<4;if(hb(M[i+l>>2],c)){break H}v=M[(i+l|0)+12>>2]}if((d|0)!=(t|0)){l=c;break g}l=c;if(hb(11364,c)){break g}a=M[r+16>>2];l=M[a>>2];v=M[a+12>>2];break g}d=d+1|0;continue}}c=$c(M[b+16>>2]);if(!c){break y}g=N[c|0];if((g|0)!=171&(g|0)!=60){break y}d=2;if((XA(a,c)|0)==2){break a}if(N[c|0]!=171){break y}K[b+2|0]=N[b|0];K[b|0]=175;d=0;break a}if(N[M[f>>2]+87|0]){break j}g=Zc(M[b+12>>2]);J:{K:{if(N[b|0]==49){a=M[b+20>>2];c=Zc(M[a+8>>2]);if((g|0)!=(c|0)){break J}a=a+24|0;break K}a=b+16|0}c=Zc(M[a>>2])}if((c|0)==(g|0)){break j}cb(f,15719,0);Rg(M[f>>2],b);break j}if(!(N[g+24|0]&46)){break j}Lm(f,g,4474,b,b);break j}if(!(N[b+5|0]&16)){break j}c=M[g+16>>2];L:{if(N[g+24|0]&46){Lm(f,g,5850,b,b);break L}oc(a,M[b+20>>2])}if((c|0)!=M[g+16>>2]){M[b+4>>2]=M[b+4>>2]|64;a=M[b+20>>2];M[a+4>>2]=M[a+4>>2]|536870912}M[g+24>>2]=M[g+24>>2]|64;break j}i=M[j+20>>2];M:{if(!(N[j+5|0]&4)){break M}M[b+4>>2]=M[b+4>>2]|524288;if((c|0)==2){N:{O:{d=M[q+24>>2];if(N[d|0]==154){d=M[d+8>>2];Jd(d,e+224|0,jb(d),1);w=R[e+224>>3];if(!(w>1)){break O}}M[b+28>>2]=-1;break N}w=w*134217728;if(U(w)<2147483647){d=~~w}else{d=-2147483648}M[b+28>>2]=d;if((d|0)>=0){break M}}M[e+96>>2]=b;cb(f,24962,e+96|0);M[g+20>>2]=M[g+20>>2]+1;break M}M[b+28>>2]=N[M[j+32>>2]]==117?8388608:125829120}P:{switch(gc(f,31,0,M[j+32>>2],0)|0){case 1:M[e+80>>2]=b;cb(f,19237,e+80|0);M[g+20>>2]=M[g+20>>2]+1;default:K[b|0]=122;break f;case 0:break P}}Q:{o=M[j+4>>2];if(!(o&1048576)&M[b+4>>2]>=0){break Q}d=0;l=(c|0)>0?c:0;m=q+8|0;while(1){if((d|0)==(l|0)){break Q}c=M[m+(d<<4)>>2];M[c+4>>2]=M[c+4>>2]|-2147483648;d=d+1|0;continue}}if(o&10240){M[b+4>>2]=M[b+4>>2]|1048576}c=M[g+24>>2];R:{if(!(o&2048)){if(!(c&42)){break R}Lm(f,g,4998,0,b);o=M[j+4>>2];break R}K[b+2|0]=c&46;if(!(c&262144)){break R}M[b+4>>2]=M[b+4>>2]|1073741824}k=(i|0)!=0;if(!(N[f+18|0]|!(o&262144)|N[M[f>>2]+24|0]&32)){break t}S:{if(!(o&2621440)){i=1;break S}i=1;if(N[f+224|0]>1){break S}rB(f,b,j)}d=1}c=f+224|0;if(N[f+224|0]>=2){break m}if(j){break s}j=0;break r}c=f+224|0;j=0;if(N[f+224|0]>=2){break m}i=1;k=0;break q}if(!h){break r}if(!M[j+24>>2]){break o}}T:{if(!k){break T}l=M[g+24>>2];m=M[j+4>>2]&65536;if(!(!h|l&16384?!(l&1)|!(m?h:1):1)){break T}M[e+4>>2]=b;M[e>>2]=h|m?1721:13238;cb(f,26822,e);break i}if(d){break p}}if(N[M[f>>2]+177|0]){break p}M[e+48>>2]=b;cb(f,19215,e+48|0);M[g+20>>2]=M[g+20>>2]+1;if(k){break n}break h}if(!i){M[e+32>>2]=b;cb(f,26850,e+32|0);M[g+20>>2]=M[g+20>>2]+1;if(!k){break h}break n}if(k){break n}if(K[b+7|0]&1){M[e+16>>2]=b;cb(f,26964,e+16|0);break i}if(!M[b+12>>2]){break h}GB(f,b);break i}M[e+64>>2]=b;cb(f,10474,e- -64|0);M[g+20>>2]=M[g+20>>2]+1;if(!k){break h}}M[g+24>>2]=M[g+24>>2]&(!h^-16385);break l}if(M[b+12>>2]|K[b+7|0]&1){break l}ec(a,q);d=1;if(!k){break a}break k}ec(a,q)}d=M[b+12>>2];if(d){ec(a,M[d+20>>2])}U:{V:{W:{X:{Y:{if(!(M[f+40>>2]|!h)){i=M[g+32>>2];if(N[c|0]>1){break V}b=i?M[i+72>>2]:0;c=M[h>>2];Z:{if(!(N[h+16|0]|!c)){c=uB(f,b,c);b=M[f>>2];if(!c){break W}D=h,E=xc(b,M[c+8>>2],0),M[D+8>>2]=E;D=h,E=xc(M[f>>2],M[c+12>>2],0),M[D+12>>2]=E;D=h,E=qb(M[f>>2],M[c+24>>2],0),M[D+24>>2]=E;D=h,E=qb(M[f>>2],M[c+28>>2],0),M[D+28>>2]=E;K[h+17|0]=N[c+17|0];K[h+18|0]=N[c+18|0];d=N[c+16|0];K[h+16|0]=d;K[h+20|0]=N[c+20|0];break Z}lt(f,h,b);d=N[h+16|0]}_:{if(!(M[h+24>>2]|M[h+28>>2])|(d&255)!=90){break _}b=M[h+12>>2];if(M[b>>2]==1?b:0){break _}cb(f,10878,0);break X}if(!(K[j+6|0]&1)){break X}if(M[h+40>>2]){break Y}l=M[f>>2];c=M[j+32>>2];d=0;while(1){if((d|0)==8){break X}b=d<<4;d=d+1|0;m=b+50736|0;if((c|0)!=M[m>>2]){continue}break}kb(l,M[h+24>>2]);kb(l,M[h+28>>2]);K[h+20|0]=0;K[h+18|0]=M[m+12>>2];b=N[m+8|0];K[h+17|0]=b;K[h+16|0]=M[m+4>>2];M[h+24>>2]=0;M[h+28>>2]=0;if((b|0)!=87){break X}D=h,E=wc(l,156,24170),M[D+24>>2]=E;break X}K[b+2|0]=0;K[b|0]=169;if(K[b+7|0]&1){Nb(a,M[M[b+44>>2]+40>>2])}d=g;while(1){if(!d){break U}c=M[d+4>>2];M[e+232>>2]=0;M[e+236>>2]=0;M[e+240>>2]=0;M[e+244>>2]=0;M[e+224>>2]=0;M[e+228>>2]=0;M[e+280>>2]=0;M[e+284>>2]=0;M[e+272>>2]=0;M[e+276>>2]=0;M[e+232>>2]=84;M[e+236>>2]=85;M[e+228>>2]=86;M[e+248>>2]=e+264;a=M[f>>2];M[e+268>>2]=c;M[e+264>>2]=a;c=e+224|0;ec(c,M[b+20>>2]);a=M[b+12>>2];if(a){ec(c,M[a+20>>2])}if(K[b+7|0]&1){Nb(e+224|0,M[M[b+44>>2]+40>>2])}a=M[e+280>>2];if(a){cc(M[f>>2],a)}a=O[e+244>>1];if(!(!a|a&1)){K[b+2|0]=(N[d+28|0]+N[b+2|0]|0)+1;d=M[d+12>>2];continue}break}if(!j){break U}K[b+2|0]=N[b+2|0]+N[d+28|0];M[d+24>>2]=M[d+24>>2]|M[j+4>>2]&134221824^134217744;break U}cb(f,4935,0)}M[h+44>>2]=j;b=M[f>>2]}if(N[b+87|0]){break j}}ec(a,M[h+8>>2]);ec(a,M[h+12>>2]);Nb(a,M[h+40>>2]);$A(i,h);M[g+24>>2]=M[g+24>>2]|32768}M[g+24>>2]=M[g+24>>2]|t&16385;break f}d=M[f+40>>2]?2:0;break a}M[g+20>>2]=M[g+20>>2]+1}ec(a,q);break f}t=f+136|0;B=b+44|0;x=168;a=0;p=g;while(1){$:{z=M[p+4>>2];if(!z){k=0;break $}i=z+8|0;k=0;A=0;while(1){aa:{ba:{ca:{da:{if(M[z>>2]>(A|0)){u=M[i+8>>2];if(!(N[i+14|0]&64)){break da}s=M[M[M[i+44>>2]>>2]+28>>2];h=s+8|0;o=0;d=0;while(1){ea:{if(M[s>>2]>(d|0)){M[e+264>>2]=0;y=h+(d<<4)|0;if(!WA(y,n,j,l,e+264|0)){break ea}fa:{if(!M[e+264>>2]){ga:{if((k|0)<=0){break ga}ha:{if(N[i+14|0]&8){if((zg(M[i+40>>2],n)|0)>=0){break ha}}xb(r,M[e+224>>2]);M[e+224>>2]=0;break ga}c=N[i+12|0];if(!(c&16)){break ea}if(!(c&8)){xb(r,M[e+224>>2]);k=0;M[e+224>>2]=0;break ga}wr(f,e+224|0,a,L[b+32>>1])}o=1;k=k+1|0;break fa}if((k|0)>0){break ea}}L[b+32>>1]=d;c=N[y+9|0]|N[y+10|0]<<8;a=c|64;K[y+9|0]=a;K[y+10|0]=a>>>8;q=q+1|0;a=i;if(!(c&128)){break ea}}if(!j){break aa}if(!o){break ca}break aa}d=d+1|0;continue}}if(!a){a=0;break $}M[b+28>>2]=M[a+16>>2];c=M[a+8>>2];M[b+44>>2]=c;if(N[a+12|0]&72){M[b+4>>2]=M[b+4>>2]|2097152}v=M[c+60>>2];break $}if(!j){break ba}}ia:{if(!l){break ia}if(M[u+60>>2]!=(v|0)){break aa}if(v){break ia}if(N[l+1|0]|N[l|0]!=42){break aa}}c=M[i+4>>2];if(c){if(hb(j,c)){break aa}if(N[f+224|0]<2){break ba}kd(f,0,B);break ba}if(!hb(j,M[u>>2])){break ba}if(M[u+20>>2]!=1){break aa}if(!VA(j,u,l)){break aa}}o=Uf(n);c=0;d=L[u+34>>1];s=(d|0)>0?d:0;d=M[u+4>>2];ja:{while(1){if((c|0)==(s|0)){break ja}ka:{la:{if((o|0)!=N[d+7|0]){break la}if(hb(M[d>>2],n)){break la}ma:{if((k|0)<=0){break ma}na:{if(N[i+14|0]&8){if((zg(M[i+40>>2],n)|0)>=0){break na}}xb(r,M[e+224>>2]);M[e+224>>2]=0;break ma}h=N[i+12|0];if(!(h&16)){break la}if(!(h&8)){xb(r,M[e+224>>2]);k=0;M[e+224>>2]=0;break ma}wr(f,e+224|0,a,L[b+32>>1])}L[b+32>>1]=L[u+32>>1]==(c|0)?-1:c;k=k+1|0;if(!(N[i+14|0]&64)){break ka}kk(i,c);break ka}d=d+12|0;c=c+1|0;continue}break}a=i}if(k){break aa}c=M[u+28>>2]&512;a=c?a:i;q=!(c>>>9|0)+q|0;k=0}i=i+48|0;A=A+1|0;continue}}oa:{if(k|l){break oa}h=0;c=M[f+136>>2];pa:{if(!c){break pa}d=N[f+162|0];qa:{if(N[f+163|0]){if(!(N[p+25|0]&4)){break pa}ra:{if(!j){break ra}if(!hb(j,M[c>>2])){break ra}if(!VA(j,c,0)){break pa}}h=(d|0)!=129;break qa}sa:{if(!j|(d|0)==129){break sa}if(hb(1755,j)){break sa}h=1;break qa}if(!j|(d|0)==128){break pa}if(hb(15049,j)){break pa}}M[b+28>>2]=h;h=c}ta:{if(!j|!(M[p+24>>2]&512)){break ta}c=M[p+8>>2];if(!c){break ta}if(hb(16528,j)){break ta}h=M[M[c+32>>2]+16>>2];M[b+28>>2]=2}ua:{if(!h){break ua}k=Uf(n);c=0;s=L[h+34>>1];i=(s|0)>0?s:0;q=q+1|0;d=M[h+4>>2];v=M[h+60>>2];va:{wa:{while(1){if((c|0)==(i|0)){break wa}xa:{if((k|0)==N[d+7|0]){if(!hb(M[d>>2],n)){break xa}}d=d+12|0;c=c+1|0;continue}break}i=L[h+32>>1]==(c|0)?-1:c;if((s|0)>(i|0)){break va}}if(!lj(n)){break va}i=N[h+29|0]&2?i:-1}if((i|0)>=(s|0)){break ua}ya:{c=M[b+28>>2];if((c|0)==2){if(N[f+224|0]>=2){M[b+44>>2]=h;L[b+32>>1]=i;k=1;a=0;x=168;break oa}D=b,E=M[M[p+8>>2]+36>>2]+Pc(h,i<<16>>16)|0,M[D+28>>2]=E;k=1;break ya}M[B>>2]=h;if(N[f+163|0]){L[b+32>>1]=i;K[b+2|0]=168;k=1;D=b,E=((M[p+8>>2]+Pc(h,i<<16>>16)|0)+S(c,L[h+34>>1]+1|0)|0)+1|0,M[D+28>>2]=E;break ya}L[b+32>>1]=i;za:{if((i|0)<0){K[b+1|0]=68;break za}a=i>>>0>31?-1:1<<i;if(!c){M[f+152>>2]=a|M[f+152>>2];break za}M[f+156>>2]=a|M[f+156>>2]}k=1;a=0;x=78;break oa}a=0;x=176;break oa}k=0}Aa:{if(!(!a|((q|0)<=0|k))){o=M[p+24>>2];if(o&40){break Aa}if(!lj(n)){break Aa}c=!((N[a+13|0]|N[a+14|0]<<8)&16384);if(c?N[M[a+8>>2]+29|0]&2:0){break Aa}if(c){L[b+32>>1]=65535}K[b+1|0]=68;k=q;break e}if(k){break e}o=M[p+24>>2]}Ba:{if(!(o&128)|j){break Ba}d=0;s=M[p+8>>2];c=M[s>>2];i=(c|0)>0?c:0;c=s+8|0;while(1){if((d|0)==(i|0)){break Ba}Ca:{h=c+(d<<4)|0;if(N[h+9|0]&3){break Ca}k=M[h+4>>2];if(hc(k,n)){break Ca}c=M[h>>2];a=M[c+4>>2];if(!(!(a&16)|o&1)){M[e+208>>2]=k;cb(f,6789,e+208|0);d=2;break a}if(!(!(a&32768)|(o&16384?(g|0)==(p|0):0))){M[e+192>>2]=k;cb(f,6593,e+192|0);d=2;break a}if((Zc(c)|0)!=1){cb(f,15719,0);d=2;break a}UA(f,s,d,b,C);if(N[f+224|0]<2){break b}kd(f,0,b);break b}d=d+1|0;continue}}C=C+1|0;p=M[p+12>>2];if(p){continue}break}Da:{if(j){d=1;break Da}Ea:{if(!(N[b+4|0]&128)){break Ea}Fa:{if(N[r+177|0]){break Fa}c=M[r+32>>2];if(K[g+26|0]&1){if((c&1342177281)==1073741825){break Fa}d=29}else{d=30}if(!(c>>>d&1)){break Ea}}M[e+176>>2]=n;Lc(28,29395,e+176|0);c=M[f+8>>2];Ga:{if(!c){break Ga}g=jb(n);d=Ob(r,g+5|0,0);if(!d){break Ga}M[d>>2]=M[c+208>>2];M[c+208>>2]=d;a=g+1|0;if(!a){break Ga}G(d+4|0,n,a)}M[b+44>>2]=0;M[b+48>>2]=0;K[b|0]=118;break f}d=1;if(Ck(b)){break a}}p=0;k=0;break d}d=1;break a}c=1;d=0;if((k|0)==1){break c}}Ha:{Ia:{c=M[e+224>>2];if(c){if(M[c>>2]==(k-1|0)){c=M[b+4>>2];if(!(c&8388608)){break Ia}M[b+4>>2]=c&-8388609;break Ha}xf(r,c)}c=d?11100:14049;Ja:{if(l){M[e+172>>2]=n;M[e+168>>2]=j;M[e+164>>2]=l;M[e+160>>2]=c;cb(f,6184,e+160|0);break Ja}if(j){M[e+152>>2]=n;M[e+148>>2]=j;M[e+144>>2]=c;cb(f,6397,e+144|0);break Ja}if(!(!d|!(N[m+4|0]&128))){M[e+132>>2]=n;M[e+128>>2]=11100;cb(f,21005,e+128|0);break Ja}M[e+116>>2]=n;M[e+112>>2]=c;cb(f,7843,e+112|0)}Rg(M[f>>2],b);K[f+17|0]=1;M[g+20>>2]=M[g+20>>2]+1;c=0;x=122;break c}kb(r,M[b+12>>2]);M[b+12>>2]=0;kb(r,M[b+16>>2]);M[b+16>>2]=0}wr(f,e+224|0,a,L[b+32>>1]);M[b+8>>2]=14807;K[b|0]=172;M[b+20>>2]=M[e+224>>2];break b}if(!(N[b+6|0]&129)){kb(r,M[b+12>>2]);M[b+12>>2]=0;kb(r,M[b+16>>2]);M[b+16>>2]=0;M[b+4>>2]=M[b+4>>2]|8388608}Ka:{if(!a){break Ka}if(L[b+32>>1]>=0){d=M[a+28>>2];D=a,E=M[a+24>>2]|vr(b),M[D+24>>2]=E;M[a+28>>2]=Qa|d;break Ka}d=N[a+13|0]|N[a+14|0]<<8|32768;K[a+13|0]=d;K[a+14|0]=d>>>8}K[b|0]=x;d=2;if(!c){break a}}c=M[f>>2];La:{if(!M[c+364>>2]){break La}a=N[b|0];d=(a|0)!=78;if(d&(a|0)!=168){break La}i=M[p+4>>2];l=Mb(c,v);if((l|0)<0){break La}if(d){d=0;a=M[i>>2];m=(a|0)>0?a:0;c=i+8|0;while(1){if((d|0)==(m|0)){break La}a=S(d,48);d=d+1|0;a=a+c|0;if(M[b+28>>2]!=M[a+16>>2]){continue}break}t=a+8|0}m=M[t>>2];if(!m){break La}d=M[m>>2];Ma:{Na:{c=L[b+32>>1];if((c|0)>=0){break Na}c=L[m+32>>1];if((c|0)>=0){break Na}a=20531;break Ma}a=M[M[m+4>>2]+S(c,12)>>2]}if((TA(f,d,a,l)|0)!=2){break La}K[b|0]=122}while(1){d=1;M[g+16>>2]=M[g+16>>2]+1;if((g|0)==(p|0)){break a}g=M[g+12>>2];continue}}Na=e+288|0;return d|0}function so(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0,J=0,Q=0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0;d=Na-288|0;Na=d;X=a+72|0;W=a+120|0;l=M[a+116>>2];U=d- -64|0;R=d+88|0;Y=d+15|0;while(1){a:{b:{if(M[l+20>>2]>=0){break b}if(!Yf(l)){break b}b=0;break a}c:{d:{if(!N[l+12|0]){b=0;if((S(M[l+20>>2],3)|0)<=M[M[a+20>>2]+40>>2]<<1){break a}J=N[a+68|0];if(!J){break a}break d}J=N[a+68|0];if(J){break d}b=M[a+20>>2]+8|0;e:{while(1){b=M[b>>2];if(!b){break e}if(!(!(N[b|0]|(a|0)==(b|0))&M[b+116>>2]==M[a+116>>2])){b=b+24|0;continue}break}b=db(79805);break a}M[d+24>>2]=0;M[d+240>>2]=0;e=M[l+52>>2];f:{b=ac(M[l+72>>2]);g:{if(b){c=0;break g}_=d,$=rf(e,d+24|0,d+240|0,M[l+4>>2],0),M[_+48>>2]=$;c=M[d+24>>2];b=d+48|0;Et(l,c,b);if(N[e+17|0]){Hd(e,M[d+240>>2],5,M[l+4>>2],b)}b=M[d+48>>2];if(!b){break f}}M[a+124>>2]=0;Rb(c);break a}b=N[l+12|0]<<1;if(b){G(c+28|0,l+28|0,b)}b=N[l+12|0]<<2;if(b){G(c+36|0,l+36|0,b)}K[c+12|0]=N[l+12|0];Oh(l,N[M[c+56>>2]]&247);b=M[l+56>>2]+N[l+9|0]|0;e=M[d+240>>2];e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[b+8|0]=e;K[b+9|0]=e>>>8;K[b+10|0]=e>>>16;K[b+11|0]=e>>>24;M[a+124>>2]=c;M[a+120>>2]=l;b=0;L[a+70>>1]=0;L[a+72>>1]=0;K[a+68|0]=1;break c}if(M[M[l+72>>2]+32>>2]>=2){b=db(79865);break a}b=(J<<24>>24)-1|0;q=O[(b<<1)+X>>1];k=M[(b<<2)+W>>2];b=ac(M[k+72>>2]);h:{if(b){break h}if(M[k+20>>2]<0){b=Yf(k);if(b){break h}}i:{if(!N[l+2|0]|N[l+12|0]!=1){break i}b=O[l+28>>1];if(M[k+4>>2]==1|(b|0)!=O[l+24>>1]|(q|0)!=O[k+24>>1]){break i}if(!b){b=db(78713);break h}c=M[l+52>>2];b=rf(c,d+24|0,d+208|0,0,0);if(b){break h}b=M[l+36>>2];M[d+176>>2]=b;_=d,$=Ra[M[l+76>>2]](l,b)|0,L[_+144>>1]=$;f=M[d+24>>2];Oh(f,13);M[d+52>>2]=l;M[d+48>>2]=1;M[d+60>>2]=d+144;M[d+56>>2]=d+176;b=M[l+60>>2];M[d+108>>2]=2147483647;M[d+88>>2]=2;M[d+64>>2]=b;b=Dt(d+48|0,0,1,f);M[d+240>>2]=b;if(!b){M[f+20>>2]=(M[c+40>>2]-(O[f+18>>1]+O[d+144>>1]|0)|0)-2;j:{if(!N[c+17|0]){break j}b=d+240|0;Hd(c,M[d+208>>2],5,M[k+4>>2],b);if(O[d+144>>1]<=O[f+16>>1]){break j}cj(f,f,M[d+176>>2],b)}b=M[l+64>>2]+(O[l+24>>1]<<1)|0;o=M[l+56>>2]+(O[l+26>>1]&(N[b-2|0]<<8|N[b-1|0]))|0;b=0;while(1){k:{e=b+1|0;c=e+o|0;M[d+176>>2]=c;h=b+o|0;if(K[h|0]>=0){break k}r=b>>>0<8;b=e;if(r){continue}}break}e=h+10|0;g=Y;while(1){l:{b=c+1|0;M[d+176>>2]=b;c=K[c|0];K[g|0]=c;g=g+1|0;if((c|0)>=0){break l}c=b;if(e>>>0>b>>>0){continue}}break}b=M[d+240>>2];if(!b){b=d+11|0;b=ro(k,O[k+24>>1],b,g-b|0,0,M[l+4>>2])}c=M[k+56>>2]+N[k+9|0]|0;e=M[d+208>>2];e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[c+8|0]=e;K[c+9|0]=e>>>8;K[c+10|0]=e>>>16;K[c+11|0]=e>>>24;qf(f);break h}Rb(f);break h}Q=fj(M[M[a+20>>2]+36>>2]);b=N[a+3|0];M[d+284>>2]=0;K[d+136|0]=0;M[d+132>>2]=0;D(d+48|0,0,60);M[d+108>>2]=2147483647;if(Q){u=b&1;x=0;b=M[k+56>>2];c=O[k+24>>1];e=N[k+12|0];y=c+e|0;if(y>>>0>=2){x=0;m:{if(!q){break m}x=(q+u|0)-2|0;if((q|0)==(y|0)){break m}x=q-1|0}y=2-u|0}f=c;c=(x-e|0)+y|0;n=(b+N[k+9|0]|0)+8|0;n:{if((f|0)==(c|0)){break n}c=M[k+64>>2]+(c<<1)|0;n=b+(O[k+26>>1]&(N[c|0]<<8|N[c+1|0]))|0}v=M[k+52>>2];C=y+1|0;c=0;m=mb(n);b=y;e=0;o:{p:{while(1){q:{if(!c){c=b<<2;f=c+(d+272|0)|0;o=Ui(v,m,f,0);M[d+284>>2]=o;if(!o){break q}}m=0;b=(b<<2)+4|0;if(!b){break p}D(d+272|0,0,b);break p}r:{f=M[f>>2];if(M[f+20>>2]>=0){break r}o=Yf(f);M[d+284>>2]=o;if(!o){break r}m=0;if(!c){break p}D(d+272|0,0,c);break p}e=(O[f+24>>1]+e|0)+4|0;if(b){c=N[k+12|0];b=b-1|0;o=x+b|0;if(!(!c|(o|0)!=O[k+28>>1])){f=b<<2;c=M[k+36>>2];M[f+(d+232|0)>>2]=c;m=mb(c);_=f+(d+144|0)|0,$=Ra[M[k+76>>2]](k,c)|0,M[_>>2]=$;c=0;K[k+12|0]=0;continue}f=b<<2;h=f+(d+232|0)|0;c=M[k+64>>2]+(o-c<<1)|0;c=M[k+56>>2]+(O[k+26>>1]&(N[c|0]<<8|N[c+1|0]))|0;M[h>>2]=c;m=mb(c);g=f+(d+144|0)|0;f=Ra[M[k+76>>2]](k,c)|0;M[g>>2]=f;s:{if(!(N[v+24|0]&12)){break s}r=c-M[k+56>>2]|0;if(M[v+40>>2]<(r+f|0)){break s}if(f){G(r+Q|0,c,f)}M[h>>2]=(c-M[k+56>>2]|0)+Q}Sk(k,o-N[k+12|0]|0,f,d+284|0);c=M[d+284>>2];continue}break}M[d+140>>2]=m;b=e+3&2147483644;c=M[v+36>>2]+S(b,6)|0;m=lc(c,c>>31);M[d+56>>2]=m;if(!m){M[d+284>>2]=7;m=0;break p}t=M[d+272>>2];M[d+52>>2]=t;z=(b<<2)+m|0;M[d+60>>2]=z;r=z+(b<<1)|0;V=N[t+8|0];F=V<<2;p=N[t+2|0];c=0;j=0;h=0;while(1){t:{if((h|0)!=(C|0)){o=h<<2;e=M[o+(d+272|0)>>2];f=M[e+56>>2];if(N[f|0]!=N[M[t+56>>2]]){_=d,$=db(79137),M[_+284>>2]=$;break p}b=O[e+18>>1];i=O[e+26>>1];g=O[e+24>>1];A=g+N[e+12|0]<<1;if(A){D(z+(c<<1)|0,0,A)}b=b+f|0;A=N[e+12|0];if(!A){break t}s=O[e+28>>1];if(s>>>0<=g>>>0){g=0;while(1)if((g|0)==(s|0)){s=e+36|0;g=0;while(1){if((g|0)!=(A|0)){M[(c<<2)+m>>2]=M[s+(g<<2)>>2];g=g+1|0;c=c+1|0;continue}break}M[d+48>>2]=c;break t}else{M[(c<<2)+m>>2]=f+(i&(N[b+1|0]|N[b|0]<<8));g=g+1|0;c=c+1|0;b=b+2|0;continue}}_=d,$=db(79161),M[_+284>>2]=$;break p}A=(F+M[v+40>>2]|0)-12|0;b=0;j=0;while(1){u:{if((j|0)==(C|0)){f=0;r=M[d+48>>2];o=C;break u}f=b<<2;e=j<<2;c=M[e+(d+272|0)>>2];M[f+U>>2]=M[c+60>>2];g=f+R|0;f=M[e+(d+176|0)>>2];M[g>>2]=f;if(b){o=b-1|0;r=(f|0)==M[(o<<2)+R>>2]?o:b}else{r=0}if(!p){r=r+1|0;b=r<<2;M[b+U>>2]=M[k+60>>2];M[b+R>>2]=f+1}o=e+(d+144|0)|0;g=A-M[c+20>>2]|0;M[o>>2]=g;h=c+36|0;b=0;while(1){if(b>>>0<N[c+12|0]){g=((Ra[M[c+76>>2]](c,M[h+(b<<2)>>2])|0)+g|0)+2|0;M[o>>2]=g;b=b+1|0;continue}break}M[e+(d+208|0)>>2]=f;b=r+1|0;j=j+1|0;continue}break}while(1){v:{if((f|0)<(o|0)){e=f+2|0;w=f<<2;b=d+208|0;h=w+b|0;g=b;c=f+1|0;b=c<<2;B=g+b|0;g=b;b=d+144|0;j=g+b|0;s=b+w|0;b=M[s>>2];while(1){w:{if((b|0)<=(A|0)){M[s>>2]=b;g=M[h>>2];e=(g|0)>(r|0)?g:r;while(1){if((e|0)==(g|0)){break v}B=d+48|0;i=Vf(B,g)+2|0;b=i+b|0;if((A|0)<(b|0)){break w}M[s>>2]=b;g=g+1|0;x:{if(p){break x}i=0;if((g|0)>=(r|0)){break x}i=Vf(B,g)+2|0}M[j>>2]=M[j>>2]-i;continue}}if((c|0)>=(o|0)){if(f>>>0>=4){M[s>>2]=b;_=d,$=db(79262),M[_+284>>2]=$;break p}M[j>>2]=0;M[B>>2]=r;o=e}E=d+48|0;i=M[h>>2];H=i-1|0;I=Vf(E,H)+2|0;g=I;y:{if(p){break y}g=0;if((i|0)>=(r|0)){break y}g=Vf(E,i)+2|0}b=b-I|0;M[j>>2]=g+M[j>>2];M[h>>2]=H;continue}break}M[h>>2]=g;b=f?M[(d+w|0)+204>>2]:0;f=c;if((b|0)<(g|0)){continue}_=d,$=db(79295),M[_+284>>2]=$;break p}w=o-1|0;h=w;while(1){z:{A:{if((h|0)>0){B=h<<2;b=d+144|0;E=B+b|0;e=M[E>>2];c=b;j=h-1|0;b=j<<2;H=c+b|0;i=M[H>>2];I=b+(d+208|0)|0;b=M[I>>2];g=b-p|0;Vf(d+48|0,g);Z=(h|0)!=(w|0)?-2:0;while(1){c=b-1|0;s=Vf(d+48|0,c);f=O[z+(g<<1)>>1];B:{if(!e){f=f+2|0;break B}if(u){break A}f=(e+f|0)+2|0;if((f|0)>((i+Z|0)-s|0)){break A}}M[I>>2]=c;g=g-1|0;i=(i-s|0)-2|0;s=(b|0)>1;e=f;b=c;if(s){continue}break}break z}b=0;g=(o|0)>0?o:0;j=q-x|0;h=N[M[t+56>>2]];c=0;while(1){if((c|0)!=(g|0)){C:{if(c>>>0<=y>>>0){f=c<<2;i=f+(d+272|0)|0;e=M[i>>2];M[f+(d+240|0)>>2]=e;M[i>>2]=0;f=ac(M[e+72>>2]);M[d+284>>2]=f;i=(c|0)==(j|0);c=c+1|0;if(f|M[M[e+72>>2]+32>>2]==((i?2:1)|0)){break C}_=d,$=db(79372),M[_+284>>2]=$;break o}e=rf(v,d+24|0,d+140|0,u?1:M[d+140>>2],0);M[d+284>>2]=e;if(e){break o}e=M[d+24>>2];Oh(e,h);f=c<<2;M[f+(d+176|0)>>2]=r;M[f+(d+240|0)>>2]=e;c=c+1|0;if(!N[v+17|0]){continue}Hd(v,M[e+4>>2],5,M[k+4>>2],d+284|0);if(!M[d+284>>2]){continue}break o}if(!f){continue}break o}break}while(1){if((b|0)!=(g|0)){c=b<<2;M[c+(d+112|0)>>2]=M[M[c+(d+240|0)>>2]+4>>2];b=b+1|0;continue}break}e=0;j=g-1|0;u=(j|0)>0?j:0;while(1){if((e|0)!=(u|0)){f=e;c=e;e=c+1|0;b=e;while(1){if((b|0)!=(g|0)){m=d+240|0;c=P[M[m+(b<<2)>>2]+4>>2]<P[M[m+(c<<2)>>2]+4>>2]?b:c;b=b+1|0;continue}break}if((c|0)==(f|0)){continue}b=c<<2;c=d+240|0;b=M[b+c>>2];m=M[b+4>>2];c=M[c+(f<<2)>>2];f=M[c+4>>2];i=M[c+72>>2];q=O[i+28>>1];t=M[v+36>>2];z=M[16864];s=O[M[b+72>>2]+28>>1];L[i+28>>1]=s;Mh(i,((z>>>0)/(t>>>0)|0)+1|0);i=M[b+72>>2];L[i+28>>1]=q;Mh(i,f);i=M[c+72>>2];L[i+28>>1]=s;Mh(i,m);M[c+4>>2]=m;M[b+4>>2]=f;continue}break}c=d+240|0;e=M[c+(j<<2)>>2];b=M[e+4>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[n|0]=b;K[n+1|0]=b>>>8;K[n+2|0]=b>>>16;K[n+3|0]=b>>>24;if(!(h&8|(o|0)==(C|0))){b=M[e+56>>2];c=M[M[(y<<2)+((o|0)>(C|0)?c:d+272|0)>>2]+56>>2];c=N[c+8|0]|N[c+9|0]<<8|(N[c+10|0]<<16|N[c+11|0]<<24);K[b+8|0]=c;K[b+9|0]=c>>>8;K[b+10|0]=c>>>16;K[b+11|0]=c>>>24}D:{E:{F:{G:{H:{if(!N[v+17|0]){break H}m=M[d+240>>2];c=N[m+12|0]+O[m+24>>1]|0;i=!p;h=0;j=m;b=0;e=0;while(1){if((e|0)>=(r|0)){break H}n=e+i|0;f=M[M[d+56>>2]+(e<<2)>>2];while(1){if((c|0)==(e|0)){b=b+1|0;m=M[((g|0)>(b|0)?d+240|0:d+272|0)+(b<<2)>>2];c=(n+O[m+24>>1]|0)+N[m+12|0]|0;continue}break}I:{if(M[(d+208|0)+(h<<2)>>2]==(e|0)){h=h+1|0;j=M[(d+240|0)+(h<<2)>>2];if(!p){break I}}if(!(M[j+4>>2]!=M[(d+112|0)+(b<<2)>>2]|(b|0)>=(g|0)|f>>>0<P[m+56>>2])){if(f>>>0<P[m+60>>2]){break I}}if(!V){Hd(v,mb(f),5,M[j+4>>2],d+284|0)}if(Vf(d+48|0,e)>>>0>O[j+16>>1]){cj(j,m,f,d+284|0)}if(M[d+284>>2]){break G}r=M[d+48>>2]}e=e+1|0;continue}}n=0;z=M[d+60>>2];m=M[d+56>>2];j=0;while(1){J:{if((j|0)!=(u|0)){f=n+Q|0;b=j<<2;e=M[b+(d+208|0)>>2];q=O[z+(e<<1)>>1];i=q+F|0;h=M[(e<<2)+m>>2];c=M[b+(d+240|0)>>2];K:{if(!N[c+8|0]){b=M[c+56>>2];q=N[h|0]|N[h+1|0]<<8|(N[h+2|0]<<16|N[h+3|0]<<24);K[b+8|0]=q;K[b+9|0]=q>>>8;K[b+10|0]=q>>>16;K[b+11|0]=q>>>24;break K}if(p){e=e-1|0;Ra[M[c+80>>2]](c,M[(e<<2)+m>>2],d+24|0);i=of(f+4|0,M[d+24>>2],M[d+28>>2])+4|0;h=f;f=0;break K}h=h-4|0;if((q|0)!=4){break K}i=Ra[M[k+76>>2]](k,h)|0}b=0;while(1){q=b<<2;b=b+1|0;if(M[q+R>>2]<=(e|0)){continue}break}b=M[q+U>>2];if(b>>>0<=h>>>0|b>>>0>=h+i>>>0){break J}_=d,$=db(79573),M[_+284>>2]=$;break D}f=1-g|0;F=!p;s=M[d+52>>2];x=M[d+208>>2];L:{while(1){if((f|0)<(g|0)){b=f>>31;b=(b^f)-b|0;B=b+(d+132|0)|0;M:{if(N[B|0]){break M}N:{O:{if((f|0)<0){c=b-1|0;e=c<<2;if(M[e+(d+176|0)>>2]>=M[e+(d+208|0)>>2]){break O}break M}if(!f){h=0;i=0;j=x;break N}c=b-1|0}i=r;i=b>>>0<=y>>>0?F+M[(d+176|0)+(c<<2)>>2]|0:i;e=c<<2;c=d+208|0;h=F+M[e+c>>2]|0;j=M[c+(b<<2)>>2]-h|0}E=b<<2;n=M[E+(d+240|0)>>2];p=M[n+64>>2];u=N[n+9|0];q=M[n+56>>2];t=N[n+12|0];b=O[n+24>>1];e=b;if((h|0)>(i|0)){c=Ct(n,i,h-i|0,d+48|0);if((c|0)>(b|0)){b=78599;break E}e=b<<1;if(e){w=M[n+64>>2];G(w,w+(c<<1)|0,e)}e=b-c|0}c=t+(b+i|0)|0;b=h+j|0;if((c|0)>(b|0)){e=e-Ct(n,b,c-b|0,d+48|0)|0}c=q+u|0;b=q+(N[c+5|0]<<8|N[c+6|0])|0;M[d+24>>2]=b;P:{Q:{u=p+(j<<1)|0;if(u>>>0>b>>>0|b>>>0>P[n+60>>2]){break Q}if((h|0)<(i|0)){b=i-h|0;b=(b|0)>(j|0)?j:b;p=M[n+64>>2];t=e<<1;if(t){G(p+(b<<1)|0,p,t)}if(go(n,u,d+24|0,p,h,b,d+48|0)){break Q}e=b+e|0}H=n+28|0;b=0;while(1){if(N[n+12|0]>b>>>0){w=O[H+(b<<1)>>1]+i|0;p=w-h|0;if(!((p|0)<0|(j|0)<=(p|0))){t=M[n+64>>2]+(p<<1)|0;R:{if((e|0)<=(p|0)){break R}p=e-p<<1;if(!p){break R}G(t+2|0,t,p)}p=d+48|0;Vf(p,w);if(go(n,u,d+24|0,t,w,1,p)){break Q}e=e+1|0}b=b+1|0;continue}break}if(go(n,u,d+24|0,M[n+64>>2]+(e<<1)|0,e+h|0,j-e|0,d+48|0)){break Q}K[n+12|0]=0;L[n+24>>1]=j;K[c+3|0]=j>>>8;K[c+4|0]=N[n+24|0];b=M[d+24>>2]-q|0;b=b<<8|(b&65280)>>>8;K[c+5|0]=b;K[c+6|0]=b>>>8;break P}b=h;c=j;if((c|0)<=0){b=78673;break E}while(1){if((c|0)>0){e=z+(b<<1)|0;if(!O[e>>1]){_=e,$=Ra[M[s+76>>2]](s,M[(b<<2)+m>>2])|0,L[_>>1]=$}c=c-1|0;b=b+1|0;continue}break}b=Dt(d+48|0,h,j,n);if(b){break L}}K[B|0]=1;M[n+20>>2]=A-M[E+(d+144|0)>>2]}f=f+1|0;continue}break}M[d+284>>2]=0;S:{if(O[k+24>>1]|(J|0)!=1){break S}b=M[d+240>>2];if(M[b+20>>2]<N[k+9|0]){break S}_=d,$=to(b,-1),M[_+284>>2]=$;c=d+284|0;Et(b,k,c);Fh(b,c);break F}if(!N[v+17|0]){break F}b=0;if(V){break F}while(1){if((b|0)==(g|0)){break F}c=M[(d+240|0)+(b<<2)>>2];Hd(v,mb(M[c+56>>2]+8|0),5,M[c+4>>2],d+284|0);b=b+1|0;continue}}M[d+284>>2]=b;break D}n=i+n|0;b=j+x|0;j=j+1|0;b=ro(k,b,h,i,f,M[c+4>>2]);if(!b){continue}break}M[d+284>>2]=b;break D}m=M[d+56>>2];break D}c=(o|0)>(C|0)?o:C;b=g;while(1){if((b|0)==(c|0)){break D}Fh(M[(d+272|0)+(b<<2)>>2],d+284|0);b=b+1|0;continue}}_=d,$=db(b),M[_+284>>2]=$}c=g;break o}c=b;f=e}M[E>>2]=f;M[H>>2]=i;b=0;b=(h|0)!=1?M[(d+B|0)+200>>2]:b;h=j;if((b|0)<(c|0)){continue}break}_=d,$=db(79339),M[_+284>>2]=$;break p}M[h>>2]=e;o=c;f=c;continue}}g=(f+O[e+18>>1]|0)+(O[e+24>>1]<<1)|0;while(1){if(b>>>0<g>>>0){M[(c<<2)+m>>2]=f+(i&(N[b+1|0]|N[b|0]<<8));c=c+1|0;M[d+48>>2]=c;b=b+2|0;continue}break}M[o+(d+176|0)>>2]=c;if(!(p|h>>>0>=y>>>0)){b=z+(c<<1)|0;g=M[o+(d+144|0)>>2];L[b>>1]=g;f=j+r|0;i=g&65535;if(i){G(f,M[o+(d+232|0)>>2],i)}f=f+F|0;M[(c<<2)+m>>2]=f;g=O[b>>1]-F|0;L[b>>1]=g;j=j+i|0;T:{if(!N[e+8|0]){b=M[e+56>>2];b=N[b+8|0]|N[b+9|0]<<8|(N[b+10|0]<<16|N[b+11|0]<<24);K[f|0]=b;K[f+1|0]=b>>>8;K[f+2|0]=b>>>16;K[f+3|0]=b>>>24;break T}while(1){if((g&65535)>>>0>3){break T}K[j+r|0]=0;g=O[b>>1]+1|0;L[b>>1]=g;j=j+1|0;continue}}c=c+1|0;M[d+48>>2]=c}h=h+1|0;continue}}c=0}b=0;eb(0,m);while(1){if((b|0)==(C|0)){b=0;c=(c|0)>0?c:0;while(1){if((b|0)!=(c|0)){Rb(M[(d+240|0)+(b<<2)>>2]);b=b+1|0;continue}break}b=M[d+284>>2]}else{Rb(M[(d+272|0)+(b<<2)>>2]);b=b+1|0;continue}break}}else{b=7}if(T){tf(T)}T=Q}K[l+12|0]=0;Rb(l);c=N[a+68|0]-1|0;K[a+68|0]=c;c=M[(c<<24>>24<<2)+W>>2]}l=c;M[a+116>>2]=c;if(!b){continue}}break}if(T){tf(T)}Na=d+288|0;return b}function Vg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0,A=0,B=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0;f=Na-176|0;Na=f;y=N[a+21|0]&2;if(y){w=M[c>>2];c=c+4|0}m=c;B=f+56|0;G=f+80|1;while(1){a:{b:{c:{d:{e:{f:{d=N[b|0];g:{if((d|0)==37){o=b;break g}c=b;if(!d){break f}while(1){h:{o=c+1|0;d=N[c+1|0];if((d|0)==37){break h}c=o;if(d){continue}}break}Ab(a,b,o-b|0);g=b;if(!N[o|0]){break f}}i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{e=N[o+1|0];if(e){o=o+1|0;h=-1;q=0;s=0;D=0;t=0;E=0;u=0;z=0;r=0;j=m;u:{while(1){c=e<<24>>24;i=1;v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{b=e&255;switch(b-32|0){case 13:break v;case 14:break x;case 16:break D;case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:break z;case 0:case 11:break G;case 1:break E;case 2:case 4:case 5:case 6:case 7:case 8:case 9:case 15:break u;case 3:break F;case 10:break y;case 12:break C;default:break H}}if((b|0)!=108){break u}c=N[o+1|0];if((c|0)==108){break B}q=1;o=o+1|0;break A}i=z;u=e;break v}E=1;break w}t=1;break w}D=1;break w}s=44;break w}q=2;c=N[o+2|0];o=o+2|0}c=c<<24>>24;break u}while(1){b=o+1|0;d=c-48|0;c=K[o+1|0];if((c-48&255)>>>0<=9){c=S(d,10)+c|0;o=b;continue}break}r=d&2147483647;d=c&255;if((d|0)==46){break w}i=z;if((d|0)==108){break v}o=b;break u}I:{if(y){c=tl(w);break I}c=M[j>>2];j=j+4|0}b=(c|0)<0;r=b?(c|0)!=-2147483648?0-c|0:0:c;i=b?1:z;b=N[o+1|0];if((b|0)==46|(b|0)==108){break v}c=b<<24>>24;o=o+1|0;z=i;break u}J:{K:{e=N[o+1|0];if((e|0)!=42){b=o+1|0;o=0;while(1){c=e<<24>>24;if((e-48&255)>>>0>9){break K}o=(S(o,10)+c|0)-48|0;e=N[b+1|0];b=b+1|0;continue}}L:{if(y){c=tl(w);break L}c=M[j>>2];j=j+4|0}h=(c|0)<0?(c|0)==-2147483648?-1:0-c|0:c;b=o+2|0;c=K[o+2|0];break J}h=o&2147483647}if((c|0)!=108){o=b;break u}o=b-1|0}i=z}e=N[o+1|0];z=i;o=o+1|0;if(e){continue}break}c=0}e=0;while(1){if((e|0)==23){break f}b=S(e,6);e=e+1|0;A=b+30816|0;if(K[A|0]!=(c|0)){continue}break}M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{v=N[A+3|0];switch(v|0){case 0:case 15:break W;case 1:case 2:case 3:break U;case 4:break T;case 5:case 6:break Q;case 7:break S;case 8:break R;case 9:case 10:case 14:break P;case 11:break O;case 12:break M;case 13:break X;case 16:break V;default:break f}}s=0;q=1;break V}s=0}Y:{if(K[A+2|0]&1){Z:{if(y){m=j;b=tl(w);c=Qa;break Z}if((q|0)==2){c=j+7&-8;m=c+8|0;b=M[c>>2];c=M[c+4>>2];break Z}m=j+4|0;b=M[j>>2];c=b>>31}d=c>>31;b=b^d;p=b-d|0;l=(c^d)-((b>>>0<d>>>0)+d|0)|0;j=(c|0)<0?45:u;break Y}if(y){p=tl(w);l=Qa;m=j;j=0;break Y}_:{if((q|0)==2){b=j+7&-8;m=b+8|0;p=M[b>>2];l=M[b+4>>2];break _}m=j+4|0;p=M[j>>2];l=0}j=0}if(D){b=r-((j&255)!=0)|0;h=(b|0)<(h|0)?h:b}$:{if((h|0)<37){q=0;c=f+80|0;b=70;break $}b=0;d=(h>>>0)/3|0;e=d;c=h+10|0;d=d+c|0;b=e>>>0>d>>>0?1:b;e=c;c=s&255;d=c?d:e;c=mp(a,d,c?b:0);if(!c){break f}q=c;b=d}b=b+c|0;u=b-1|0;g=u;if((v|0)==15){c=aK(p,l,10,0);n=Qa;e=ZJ(c,n,10,0);d=p-e|0;e=l-(Qa+(e>>>0>p>>>0)|0)|0;g=b-3|0;c=(H=(bK(c,n,10,0)|0)!=1|Qa?d:0,I=0,J=!e&d>>>0<=3,J?H:I)<<1;K[g|0]=N[c+14975|0];K[b-2|0]=N[c+14976|0]}v=N[A+4|0]+30960|0;b=N[A+1|0];n=p;d=l;while(1){g=g-1|0;i=n;e=d;c=aK(i,d,b,0);t=Qa;H=g,I=N[(i-ZJ(c,t,b,0)|0)+v|0],K[H|0]=I;n=c;d=t;if(!e&b>>>0<=i>>>0|e){continue}break}c=u-g|0;while(1){if((c|0)<(h|0)){g=g-1|0;K[g|0]=48;c=c+1|0;continue}break}aa:{if(!(s&255)){break aa}b=c-1|0;e=(b|0)/3|0;i=(b-S(e,3)|0)+1|0;g=g-e|0;c=0;while(1){if((e|0)<=0){break aa}b=c+g|0;K[b|0]=N[b+e|0];i=i-1|0;if(!i){c=c+1|0;K[g+c|0]=s;i=3;e=e-1|0}c=c+1|0;continue}}if(j&255){g=g-1|0;K[g|0]=j}ba:{if(!E|!(l|p)){break ba}b=N[A+5|0];if(!b){break ba}c=b+30993|0;while(1){b=N[c|0];if(!b){break ba}g=g-1|0;K[g|0]=b;c=c+1|0;continue}}h=u-g|0;break a}if(y){k=0;b=M[w+4>>2];if((b|0)>=M[w>>2]){break j}M[w+4>>2]=b+1;k=Kb(M[M[w+8>>2]+(b<<2)>>2]);break j}b=j+7&-8;m=b+8|0;k=R[b>>3];break i}q=0;if(y){r=0;h=0;m=j;break a}M[M[j>>2]>>2]=M[a+16>>2];break N}K[f+80|0]=37;g=f+80|0;h=1;q=0;m=j;break a}ca:{if(y){c=jp(w);if(c){b=N[c|0];K[f+80|0]=b;e=1;if(b>>>0<192){break ca}while(1){b=K[c+1|0];if((b|0)>-65){break ca}c=c+1|0;K[(f+80|0)+e|0]=b;e=e+1|0;if((e|0)!=4){continue}break}e=4;break ca}K[f+80|0]=0;e=1;break ca}b=j+4|0;c=M[j>>2];da:{if(c>>>0<=127){K[f+80|0]=c;e=1;break da}if(c>>>0<=2047){K[f+81|0]=c&63|128;K[f+80|0]=c>>>6|192;e=2;break da}if(c>>>0<=65535){K[f+82|0]=c&63|128;K[f+80|0]=c>>>12|224;K[f+81|0]=c>>>6&63|128;e=3;break da}K[f+83|0]=c&63|128;K[f+82|0]=c>>>6&63|128;K[f+81|0]=c>>>12&63|128;K[f+80|0]=c>>>18&7|240;e=4}j=b}b=f+80|0;t=1;q=0;if((h|0)<2){break l}c=h-1|0;r=r-c|0;if(!(z&255|(r|0)<2)){Wh(a,r-1|0,32);r=0}Ab(a,f+80|0,e);n=1;d=0;while(1){if((c|0)<2){break l}g=M[a+8>>2];l=n;m=c-1|0;n=(d|0)<=0&m>>>0>n>>>0|(d|0)<0;m=n?l:m;d=n?d:0;n=ZJ(m,d,e,0);i=M[a+16>>2];p=n+i|0;h=Qa;l=i>>>0>p>>>0?h+1|0:h;if((l|0)>0){l=1}else{l=g>>>0<=p>>>0&(l|0)>=0}if(l){nl(a,n,h)}if(N[a+20|0]){break l}Ab(a,M[a+4>>2]+(M[a+16>>2]-n|0)|0,n);n=m<<1;d=d<<1|m>>>31;c=c-m|0;continue}}if(y){b=jp(w);b=b?b:30808;q=0;break p}m=j+4|0;g=M[j>>2];b=g?g:30808;q=0;if(!g|(v|0)!=6){break q}if(M[a+16>>2]|(!M[a+12>>2]|r|(h|0)>=0)){break r}if(N[a+20|0]){j=m;b=g;q=b;break o}M[a+4>>2]=g;H=a,I=uf(M[a>>2],g),M[H+8>>2]=I;H=a,I=yb(g)&2147483647,M[H+16>>2]=I;K[a+21|0]=N[a+21|0]|4;break s}b=(v|0)==14;ea:{if(y){i=jp(w);break ea}i=M[j>>2];j=j+4|0}s=b?34:39;u=(v|0)==10;g=i?i:u?20301:26284;m=h;e=h>>31;n=0;d=0;p=0;l=0;while(1){fa:{if(!(e|m)){break fa}c=N[g+n|0];if(!c){break fa}b=(c|0)==(s|0);ga:{if(!(c>>>0>191?t:0)){c=d;n=n+1|0;d=n?c:c+1|0;break ga}while(1){n=n+1|0;d=n?d:d+1|0;if(K[g+n|0]<-64){continue}break}}p=b+p|0;l=p>>>0<b>>>0?l+1|0:l;b=m;m=b-1|0;e=e-!b|0;continue}break}b=f+80|0;q=0;l=d+l|0;m=n+p|0;l=m>>>0<p>>>0?l+1|0:l;c=l;m=m+3|0;c=m>>>0<3?c+1|0:c;if((c|0)>=0&m>>>0>=71|(c|0)>0){q=mp(a,m,c);b=q;if(!b){break f}}m=0;e=0;p=0;l=0;i=u&(i|0)!=0;if(i){K[b|0]=39;p=1}h=!!n&(d|0)>=0|(d|0)>0;n=h?n:0;h=h?d:0;while(1){if(!((m|0)==(n|0)&(e|0)==(h|0))){u=N[g+m|0];K[b+p|0]=u;d=l;c=p+1|0;d=c?d:d+1|0;if((s|0)!=(u|0)){p=c;l=d}else{K[b+c|0]=s;p=p+2|0;l=p>>>0<2?l+1|0:l}c=e;m=m+1|0;e=m?c:c+1|0;continue}break}if(i){K[b+p|0]=39;p=p+1|0}e=p;K[b+e|0]=0;break l}if(!(K[a+21|0]&1)){break f}b=M[j>>2];if(E){if(!b|N[b+5|0]&8){break N}Sd(a,M[b+8>>2]);Rg(M[a>>2],b);break N}if(!b){break N}c=M[b+4>>2];if(!c){break N}Ab(a,M[b>>2],c);d=M[a>>2];if(!d|M[d+68>>2]!=-2){break N}c=M[d+264>>2];if(!c){break N}c=M[c+248>>2];if(!c){break N}b=M[b>>2];if(b>>>0<c>>>0){break N}if(b>>>0>=yb(c)+c>>>0){break N}M[d+68>>2]=b-c}m=j+4|0;break s}if(!(K[a+21|0]&1)){break f}m=j+4|0;c=M[j>>2];d=M[c+4>>2];if(t?0:d){break t}b=M[c>>2];if(b){ha:{if(K[c+15|0]&1|N[c+13|0]&4){break ha}d=M[c+44>>2];if(!d){break ha}Sd(a,d);Ab(a,25068,1);b=M[c>>2]}Sd(a,b);break s}if(d){break t}if(!(N[c+13|0]&4)){break s}b=M[M[c+44>>2]>>2];d=M[b+4>>2];if(d&2048){M[f+32>>2]=M[b+16>>2];rb(a,25122,f+32|0);break s}if(d&1024){M[f+16>>2]=M[c+32>>2];rb(a,20408,f+16|0);break s}M[f>>2]=M[b+16>>2];rb(a,25108,f);break s}Ab(a,29251,1);break f}Sd(a,d)}q=0;r=0;h=0;break a}j=m;q=g;b=g;break p}j=m}if((h|0)<0){break o}if(!t){break m}c=b;while(1){if((h|0)<=0){break n}d=N[c|0];if(!d){break n}h=h-1|0;c=c+1|0;if(d>>>0<192){continue}while(1){d=c;c=c+1|0;if(K[d|0]<-64){continue}break}c=d;continue}}e=yb(b)&2147483647;break l}e=c-b|0;t=1;break l}c=0;while(1){if((c|0)==(h|0)){break k}if(N[b+c|0]){c=c+1|0;continue}else{h=c;break k}}}ia:{if(!t){break ia}c=e;if((r|0)<=0){break ia}while(1){if((c|0)<=0){break ia}c=c-1|0;r=(K[c+b|0]<-64)+r|0;continue}}h=e}g=b;m=j;break a}m=j}e=(h|0)<0?6:(h|0)>=1e8?1e8:h;ja:{ka:{switch(v-1|0){case 0:h=0-e|0;break ja;case 2:h=e>>>0<=1?1:e;e=h;break ja;default:break ka}}h=e+1|0}M[f+52>>2]=B;K[f+41|0]=0;p=t;la:{ma:{na:{if(k<0){K[f+40|0]=45;k=-k;break na}K[f+40|0]=43;if(k!=0){break na}M[f+52>>2]=25046;M[f+44>>2]=1;M[f+48>>2]=1;c=1;break ma}C(+k);b=x(1)|0;c=x(0)|0;oa:{if((b&2146435072)==2146435072){M[f+44>>2]=0;M[f+48>>2]=0;c=!c&(b|0)==2146435072?1:2;K[f+41|0]=c;i=B;break oa}M[f+168>>2]=0;M[f+172>>2]=0;R[f+160>>3]=k;c=0;pa:{if(k>0x7ffffffffffffc00){while(1){if(k>9223372036854774e103){qe(f+160|0,1e-100,-19991899802602883e-133);c=c+100|0;k=R[f+160>>3];continue}break}while(1){if(k>9223372036854774e13){qe(f+160|0,1e-10,-3643219731549774e-42);c=c+10|0;k=R[f+160>>3];continue}break}while(1){if(!(k>0x7ffffffffffffc00)){break pa}qe(f+160|0,.1,-5551115123125783e-33);c=c+1|0;k=R[f+160>>3];continue}}while(1){if(k<9223372036854775e-98){qe(f+160|0,1e100,-15902891109759918e67);c=c-100|0;k=R[f+160>>3];continue}break}while(1){if(k<92233720.36854775){qe(f+160|0,1e10,0);c=c-10|0;k=R[f+160>>3];continue}break}while(1){if(!(k<0xccccccccccccc80)){break pa}qe(f+160|0,10,0);c=c-1|0;k=R[f+160>>3];continue}}if(k<0x10000000000000000&k>=0){b=~~k>>>0;if(U(k)>=1){d=~~(k>0?W(Y(k*2.3283064365386963e-10),4294967295):Z((k-+(~~k>>>0>>>0))*2.3283064365386963e-10))>>>0}else{d=0}}else{b=0;d=0}k=R[f+168>>3];qa:{if(k<0){k=-k;if(k<0x10000000000000000&k>=0){j=~~k>>>0;if(U(k)>=1){l=~~(k>0?W(Y(k*2.3283064365386963e-10),4294967295):Z((k-+(~~k>>>0>>>0))*2.3283064365386963e-10))>>>0}else{l=0}}else{j=0;l=0}n=b-j|0;d=d-((b>>>0<j>>>0)+l|0)|0;break qa}if(k<0x10000000000000000&k>=0){j=~~k>>>0;if(U(k)>=1){l=~~(k>0?W(Y(k*2.3283064365386963e-10),4294967295):Z((k-+(~~k>>>0>>>0))*2.3283064365386963e-10))>>>0}else{l=0}}else{j=0;l=0}d=l+d|0;n=b+j|0;d=n>>>0<b>>>0?d+1|0:d}j=p?26:16;i=23;while(1){if(d|n){b=n;n=aK(n,d,10,0);d=Qa;H=i+B|0,I=b-ZJ(n,d,10,0)|48,K[H|0]=I;i=i-1|0;continue}break}g=23-i|0;M[f+44>>2]=g;b=c+g|0;M[f+48>>2]=b;ra:{sa:{if((h|0)>0){break sa}h=b-h|0;if(!h){b=i+B|0;if(K[b+1|0]<53){break ra}K[b|0]=48;h=1;g=M[f+44>>2]+1|0;M[f+44>>2]=g;M[f+48>>2]=M[f+48>>2]+1;i=i-1|0;break sa}if((h|0)<=0){break ra}}if((g|0)<=(j|0)&(h|0)>=(g|0)){break ra}g=h>>>0<j>>>0?h:j;M[f+44>>2]=g;d=(i+B|0)+1|0;if(K[d+g|0]<53){break ra}ta:{while(1){g=g-1|0;b=d+g|0;c=N[b|0]+1|0;K[b|0]=c;if(c<<24>>24<58){break ta}K[b|0]=48;if(g){continue}break}K[M[f+52>>2]+i|0]=49;g=M[f+44>>2]+1|0;M[f+44>>2]=g;M[f+48>>2]=M[f+48>>2]+1;i=i-1|0;break ra}g=M[f+44>>2]}b=i+B|0;i=b+1|0;M[f+52>>2]=i;while(1){if(!(N[b+g|0]!=48|(g|0)<=0)){g=g-1|0;M[f+44>>2]=g;continue}break}c=N[f+41|0]}ua:{switch(c&255){default:if(D){K[i|0]=57;M[f+44>>2]=1;M[f+48>>2]=1e3;c=1e3;break ma}K[f+84|0]=N[12757];M[f+80>>2]=N[12753]|N[12754]<<8|(N[12755]<<16|N[12756]<<24);b=f+80|0;if(N[f+40|0]==45){break c}g=G;if(!(u&255)){break b}K[f+80|0]=u;break c;case 0:break ua;case 2:break la}}c=M[f+48>>2]}j=N[f+40|0];va:{if((v|0)==3){v=(c|0)<-3|(c|0)>(e|0);e=(v?-1:0-c|0)+e|0;n=!E;break va}v=(v|0)==2;n=t}i=v?0:c-1|0;d=(i|0)>0?i:0;c=e>>31;b=e+r|0;c=b>>>0<r>>>0?c+1|0:c;l=b;b=b+d|0;c=l>>>0>b>>>0?c+1|0:c;b=b+15|0;l=b>>>0<15?c+1|0:c;d=l;c=(i+2>>>0)/3|0;g=c;c=b+c|0;d=g>>>0>c>>>0?d+1|0:d;g=c;F=s&255;c=!F|(i|0)<=0;b=c?b:g;c=c?l:d;wa:{if(b>>>0<71&(c|0)<=0|(c|0)<0){g=f+80|0;q=0;break wa}q=mp(a,b,c);g=q;if(!g){break f}}s=g;b=(j|0)==45?45:u;d=b&255;if(d){K[g|0]=b;s=g+1|0}l=(e|0)>0|E|t;j=0;xa:{if((i|0)>=0){h=0;while(1){b=s;if((i|0)<0){break xa}t=48;if(M[f+44>>2]>(h|0)){t=N[M[f+52>>2]+h|0];h=h+1|0}K[b|0]=t;s=b+1|0;if(!(!F|((i>>>0)%3|i>>>0<2))){K[b+1|0]=44;s=b+2|0}i=i-1|0;continue}}K[s|0]=48;j=i+1|0;h=0;b=s+1|0}c=b;b=l&255;if(!b){break e}K[c|0]=46;i=0;break d}g=D?11727:20030;break b}Na=f+176|0;return}i=1}while(1){if(!i){c=c+1|0;i=1;continue}ya:{if(!((e|0)<=0|(j|0)>=0)){K[c|0]=48;j=j+1|0;e=e-1|0;break ya}while(1){if((e|0)>0){i=48;if(M[f+44>>2]>(h|0)){i=N[M[f+52>>2]+h|0];h=h+1|0}e=e-1|0;K[c|0]=i;c=c+1|0;continue}break}za:{if(!(n&255)|!b){break za}while(1){Aa:{Ba:{b=c-1|0;switch(N[b|0]-46|0){case 0:break Aa;case 2:break Ba;default:break za}}K[b|0]=0;c=b;continue}break}if(p){K[c|0]=48;c=c+1|0;break za}K[b|0]=0;c=b}if(v){b=M[f+48>>2];j=(b|0)<=0;K[c+1|0]=j?45:43;K[c|0]=N[N[A+4|0]+30960|0];e=j?1-b|0:b-1|0;if(e>>>0<100){b=c+2|0}else{b=(e>>>0)/100|0;K[c+2|0]=b+48;e=e-S(b,100)|0;b=c+3|0}c=((e&255)>>>0)/10|0;K[b|0]=c|48;K[b+1|0]=e-S(c,10)|48;c=b+2|0}K[c|0]=0;h=c-g|0;if(!D|z&255|(r|0)<=(h|0)){break a}c=r-h|0;e=r;while(1){if((c|0)<=(e|0)){K[e+g|0]=N[(e-c|0)+g|0];e=e-1|0;continue}break}e=(d|0)!=0;while(1)if(c){K[e+g|0]=48;e=e+1|0;c=c-1|0;continue}else{h=r;break a}}i=0;continue}}g=b}q=0;h=jb(g)}Ca:{Da:{b=r-h|0;if((b|0)>0){if(z&255){break Da}Wh(a,b,32)}Ab(a,g,h);break Ca}Ab(a,g,h);Wh(a,b,32)}if(q){ib(M[a>>2],q)}b=o+1|0;continue}}function gy(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0,J=0,L=0,O=0,P=0;f=Na-112|0;Na=f;M[f+16>>2]=0;M[f+8>>2]=0;M[f+12>>2]=0;i=Bb(648,0);a:{if(!i){k=7;break a}M[f+24>>2]=0;M[f+12>>2]=0;e=Tb(a,22,f+24|0,0);M[f+96>>2]=e;if(!e){e=1;d=M[f+24>>2];Jb(d,1,1,0);b:{if((Db(d)|0)==100){j=Ye(d,0);h=Wd(d,0);if(!j){break b}fe(f+8|0,h,f+96|0);g=M[f+96>>2];if(g){e=0;break b}g=M[f+8>>2];if(!(!g|!h)){G(g,j,h)}M[f+12>>2]=h}g=0}e=(L=wb(d),O=g,P=e,P?L:O)}x=i+584|0;F=i+568|0;H=(c|0)<=2?2:c;I=i+108|0;C=i+76|0;J=i- -64|0;s=i+40|0;v=i+56|0;c:{while(1){d:{if((b|0)<=0|e){break d}h=M[a+260>>2];M[f+4>>2]=0;Tb(a,28,f+4|0,0);d=M[f+4>>2];fd(d,1,H);j=-1;if((Db(d)|0)==100){r=dd(d,0);p=Qa;j=Md(d,1)}l=h<<10;o=l>>31;e=wb(d);M[f+20>>2]=e;g=0;e:{if(e){break e}q=M[f+12>>2];if(!q){break e}h=0;d=0;M[f+24>>2]=0;M[f+28>>2]=0;m=M[f+8>>2];M[f+96>>2]=0;e=267;k=q-1|0;f:{if(K[m+k|0]<0){break f}n=m-1|0;g=k>>31&k;g:{while(1){if((k|0)>0){if(K[k+n|0]>=0){g=k;break g}else{k=k-1|0;continue}}break}if((q|0)>0){break f}}h=m-2|0;d=((g|0)>0?1:g)-1|0;while(1){h:{if((g|0)<2){e=d;break h}k=g+h|0;e=g-1|0;g=e;if(K[k|0]<0){continue}}break}M[f+12>>2]=e;h=Ic(e+m|0,f+24|0)+e|0;d=h+m|0;e=K[d|0];i:{if((e|0)<0){d=yc(d,f+96|0);break i}M[f+96>>2]=e;d=1}e=(q|0)!=(d+h|0)?267:0;h=M[f+24>>2];d=M[f+28>>2]}M[f+20>>2]=e;j:{if((j|0)>=0){k=$J(r,p,l,o);g=Qa;o=$J(h,d,l,o)>>>0>k>>>0;k=Qa;if(o&(k|0)>=(g|0)|(g|0)<(k|0)){break j}}p=(c|0)>(j|0)?c:j;g=M[f+96>>2];j=(g|0)>(p|0)?p:g;E=1;g=1;r=h;p=d;break e}M[f+12>>2]=q;g=0}if((j|0)<=0){break d}k=267;d=l;if((r|0)!=0&(d|0)<=(p|0)|(d|0)<(p|0)|(p|0)<0){break c}D(i,0,648);M[i+580>>2]=1;k:{if(e){break k}l=0;M[f+24>>2]=0;e=Tb(a,8,f+24|0,0);if(!e){h=M[f+24>>2];d=p;e=r+1|0;d=e?d:d+1|0;Jb(h,1,e,d);Db(h);l=Md(h,0);e=wb(h)}M[f+20>>2]=e;l:{m:{if((l|0)==1&g?0:l){break m}e=Tb(a,15,f+24|0,0);if(e){break l}m=1;h=M[f+24>>2];d=h;e=r+2|0;o=e>>>0<2?p+1|0:p;Jb(d,1,e,o);d=p;e=r+1|0;d=(e?d:d+1|0)&2147483647;e=(e&-1024)+1024|0;d=e>>>0<1024?d+1|0:d;Jb(h,2,e,d);if((Db(h)|0)==100){m=(lh(h,0)|0)!=5}e=wb(h);M[f+20>>2]=e;if(m){break m}M[i+580>>2]=M[i+580>>2]|2}if(e){break k}M[f+24>>2]=0;D(x,0,64);d=j<<2;h=Bb(d,0);M[x>>2]=h;if(!h){e=7;break l}if(d){D(h,0,d)}e=Tb(a,12,f+24|0,0);if(e){break l}d=M[f+24>>2];Jb(d,1,r,p);e=0;m=0;while(1){n:{if(m){break n}if((Db(d)|0)!=100|(e|0)>=(j|0)){break n}m=My(e,0,dd(d,1),Qa,dd(d,2),Qa,dd(d,3),Qa,Ye(d,4),Wd(d,4),M[i+584>>2]+(e<<2)|0);M[i+588>>2]=M[i+588>>2]+1;e=e+1|0;continue}break}e=(L=m,O=wb(d),P=m,P?L:O);M[f+20>>2]=e;if(e){break k}e=0;if(M[i+588>>2]!=(j|0)){break k}e=Vj(a,x,F);M[f+20>>2]=e;if(e){break k}k=li(a,x);M[f+20>>2]=k;o:{p:{q:{if(!(k?(k|0)!=100:0)){if(!(g^1|(l|0)<=0)){w=M[i+636>>2];z=M[i+632>>2];M[f+84>>2]=0;e=Tb(a,32,f+84|0,0);if(e){break o}M[f+96>>2]=0;M[f+100>>2]=0;q=M[f+84>>2];d=q;g=p;h=r+1|0;g=h?g:g+1|0;Jb(d,1,h,g);A=l-1|0;fd(d,2,A);r:{if((Db(d)|0)==100){m=dd(d,1);t=Qa;j=dd(d,2);l=Qa;Ix(d,3,f+96|0,s);d=M[s>>2];h=M[s+4>>2];if((h|0)<0){M[s>>2]=0-d;M[s+4>>2]=0-(((d|0)!=0)+h|0);d=1;h=0}K[i+48|0]=!(d|h);n=Wd(q,4);u=Ye(q,4);if(u){break r}wb(q);e=n?7:267;break o}e=wb(q);break o}o=M[f+96>>2];h=M[f+100>>2];y=h;e=0;M[f+24>>2]=0;g=Tb(a,34,f+24|0,0);if(!g){d=M[f+24>>2];Jb(d,1,o,h);e=(Db(d)|0)==100;g=wb(d)}M[f+88>>2]=g;if(!e|g){break q}M[f+80>>2]=0;M[f+76>>2]=0;g=dh(a,j,l,f+80|0,f+76|0);M[f+88>>2]=g;j=1;if(!g){g=Vp(f+24|0,M[f+80>>2],M[f+76>>2]);while(1){if(!(!M[f+24>>2]|g)){g=Rl(f+24|0);continue}break}M[f+88>>2]=g;d=M[f+48>>2];h=Gx(z,w,d,M[f+52>>2]);ab(d);j=(h|0)>0?e:0}ab(M[f+80>>2]);break p}M[f+24>>2]=0;M[f+96>>2]=0;e=Tb(a,29,f+24|0,0);if(e){break o}d=M[f+24>>2];Jb(d,1,r,p);h=M[i+588>>2];Jb(d,2,h,h>>31);j=0;if((Db(d)|0)==100){j=Md(d,0)}e=wb(d);if(e){break o}e=Tb(a,10,f+96|0,0);if(e){break o}e=M[f+96>>2];if((Db(e)|0)==100){d=dd(e,0);M[i+24>>2]=d;g=Qa;M[i+28>>2]=g;h=d;d=j<<4;o=d;h=h+d|0;d=(d>>31)+g|0;M[i+32>>2]=h-1;M[i+36>>2]=(h>>>0<o>>>0?d+1|0:d)-!h}e=wb(e);if(e){break o}e=og(a,M[i+32>>2],M[i+36>>2],0,0);if(e){break o}M[i+16>>2]=l;M[i>>2]=j;M[i+8>>2]=r;M[i+12>>2]=p;l=j>>31;e=M[i+24>>2];m=M[i+28>>2];h=0;d=0;while(1)if(!d&(h|0)==16){e=0;break o}else{g=(h<<5)+v|0;q=ZJ(h,d,j,l);o=m+Qa|0;q=e+q|0;o=q>>>0<e>>>0?o+1|0:o;M[g>>2]=q;M[g+4>>2]=o;h=h+1|0;d=h?d:d+1|0;continue}}eh(x);break c}j=e}s:{if(g){l=g;break s}l=g;if(!j){break s}e=K[u|0];if((e-1&255)>>>0>=15){wb(q);e=267;break o}h=e&255;d=0;M[i+32>>2]=o;M[i+36>>2]=y;M[i+24>>2]=m;M[i+28>>2]=t;M[i+16>>2]=A;M[i+8>>2]=r;M[i+12>>2]=p;j=((o-m|0)+1|0)/16|0;M[i>>2]=j;w=j>>31;while(1){if(!(!d&(h|0)==15)){h=h+1|0;g=h?d:d+1|0;l=(h<<5)+v|0;d=g;g=ZJ(h,d,j,w);o=t+Qa|0;g=g+m|0;o=g>>>0<m>>>0?o+1|0:o;M[l>>2]=g;M[l+4>>2]=o;continue}break}d=S(e,j);j=d;g=d+m|0;d=(d>>31)+t|0;h=(e<<5)+v|0;M[h>>2]=g;M[h+4>>2]=g>>>0<j>>>0?d+1|0:d;d=M[a+232>>2];fe(h+20|0,((d|0)<(n|0)?n:d)+20|0,f+88|0);g=M[f+88>>2];if(!g){if(n){G(M[h+20>>2],u,n)}M[h+24>>2]=n;d=n+M[h+20>>2]|0;K[d|0]=0;K[d+1|0]=0;K[d+2|0]=0;K[d+3|0]=0;K[d+4|0]=0;K[d+5|0]=0;K[d+6|0]=0;K[d+7|0]=0;K[d+16|0]=0;K[d+17|0]=0;K[d+18|0]=0;K[d+19|0]=0;K[d+8|0]=0;K[d+9|0]=0;K[d+10|0]=0;K[d+11|0]=0;K[d+12|0]=0;K[d+13|0]=0;K[d+14|0]=0;K[d+15|0]=0}l=g;while(1){if((e|0)<0|l){break s}l=0;h=f+24|0;D(h,0,48);d=(e<<5)+v|0;j=M[d+20>>2];t:{if(!j){break t}g=Vp(h,j,M[d+24>>2]);while(1){if(!(!M[f+24>>2]|g)){g=Rl(f+24|0);continue}break}M[f+88>>2]=g;h=M[f+52>>2];fe(d+8|0,h,f+88|0);g=M[f+88>>2];l=g;if(g){break t}if(!(!h|(h|0)<=0)){G(M[d+8>>2],M[f+48>>2],h)}M[d+12>>2]=h;if((e|0)<=0){g=0;l=0;break t}M[f+80>>2]=0;M[f+76>>2]=0;g=M[f+44>>2];j=d-32|0;h=M[f+40>>2];M[j>>2]=h;M[j+4>>2]=g;L=f,O=dh(a,h,g,f+80|0,f+76|0),M[L+88>>2]=O;g=d-12|0;d=M[f+76>>2];h=M[a+232>>2];fe(g,((d|0)>(h|0)?d:h)+20|0,f+88|0);g=M[f+88>>2];if(!g){if(d){G(M[j+20>>2],M[f+80>>2],d)}M[j+24>>2]=d;d=d+M[j+20>>2]|0;K[d|0]=0;K[d+1|0]=0;K[d+2|0]=0;K[d+3|0]=0;K[d+4|0]=0;K[d+5|0]=0;K[d+6|0]=0;K[d+7|0]=0;K[d+16|0]=0;K[d+17|0]=0;K[d+18|0]=0;K[d+19|0]=0;K[d+8|0]=0;K[d+9|0]=0;K[d+10|0]=0;K[d+11|0]=0;K[d+12|0]=0;K[d+13|0]=0;K[d+14|0]=0;K[d+15|0]=0}ab(M[f+80>>2]);l=g}ab(M[f+48>>2]);e=e-1|0;continue}}e=(L=g,O=wb(q),P=l,P?L:O)}M[f+20>>2]=e;u:{v:{if(e){break v}if(M[i>>2]){w:{if(k){while(1){o=M[i+644>>2];A=M[i+640>>2];t=M[i+636>>2];u=M[i+632>>2];M[f+96>>2]=0;j=Qj(M[i+64>>2],M[i+68>>2],u,t);d=t-j|0;x:{if((d|0)<=0){e=267;break x}h=(_d(j,j>>31)+d|0)+_d(d,0)|0;d=o;y=_d(d,d>>31)+d|0;k=h+y|0;e=M[i+80>>2];y:{if((e|0)<=0|M[a+232>>2]>=(e+k|0)){break y}g=M[i+56>>2];d=M[i>>2];m=d;l=d+M[i+24>>2]|0;d=M[i+28>>2]+(d>>31)|0;h=M[i+60>>2];d=l>>>0<m>>>0?d+1|0:d;if((h|0)>=(d|0)&g>>>0>=l>>>0|(d|0)<(h|0)){break y}e=og(a,g,h,M[i+76>>2],e);M[f+96>>2]=e;M[i+4>>2]=M[i+4>>2]+1;h=M[i+56>>2];d=M[i+60>>2];if(!e){e=1;l=j+1|0;while(1){z:{if((e|0)==16){n=0;break z}M[f+24>>2]=0;g=(e<<5)+v|0;w=M[g+12>>2];j=Qj(M[g+8>>2],w,u,l);k=l-j|0;if((k|0)<=0){n=267;break z}m=j>>31;z=(_d(j,m)+k|0)+_d(k,0)|0;B=g;n=M[g+24>>2];A:{B:{if(!(M[a+232>>2]<(z+n|0)?w:0)){q=g+8|0;w=g+20|0;C:{if(n){break C}fe(w,M[a+232>>2],f+24|0);if(M[f+24>>2]){n=M[g+24>>2];break C}K[M[g+20>>2]]=e;n=uc(M[g+20>>2]+1|0,h,d)+1|0;M[g+24>>2]=n}d=f+24|0;fe(w,n+z|0,d);fe(q,l,d);h=0;d=0;n=M[f+24>>2];if(n){break A}n=M[g+24>>2];if(M[g+12>>2]){n=uc(M[g+20>>2]+n|0,j,m)+M[g+24>>2]|0;M[g+24>>2]=n}m=uc(M[g+20>>2]+n|0,k,0)+M[g+24>>2]|0;M[g+24>>2]=m;if(k){G(m+M[g+20>>2]|0,j+u|0,k)}M[g+24>>2]=k+M[g+24>>2];if(l){G(M[g+8>>2],u,l)}n=0;g=l;break B}n=og(a,M[g>>2],M[g+4>>2],M[g+20>>2],n);K[M[g+20>>2]]=e;j=M[g+20>>2]+1|0;h=h+1|0;d=h?d:d+1|0;L=g,O=uc(j,h,d)+1|0,M[L+24>>2]=O;j=g;h=M[g>>2];g=M[g+4>>2];d=g;k=h+1|0;g=k?d:d+1|0;M[j>>2]=k;M[j+4>>2]=g;g=0}M[B+12>>2]=g}if(n){break z}e=e+1|0;if(d|h){continue}}break}M[f+96>>2]=n;h=M[v>>2];d=M[v+4>>2]}e=0;M[i+80>>2]=0;M[i+68>>2]=0;h=h+1|0;d=h?d:d+1|0;M[i+56>>2]=h;M[i+60>>2]=d;k=(_d(t,t>>31)+(t+y|0)|0)+1|0}d=M[s+4>>2]+(k>>31)|0;h=k+M[s>>2]|0;d=h>>>0<k>>>0?d+1|0:d;M[s>>2]=h;M[s+4>>2]=d;fe(C,e+k|0,f+96|0);e=M[f+96>>2];if(e){break x}if(!M[i+80>>2]){M[i+80>>2]=1;K[M[i+76>>2]]=0}e=Fx(C,J,u,t,A,o);if(e){break x}e=li(a,x)}k=M[i+4>>2];if(!((e|0)!=100|(k|0)<(b|0))){M[f+20>>2]=0;break w}if((e|0)==100){continue}break}M[f+20>>2]=e;if(e){break v}}k=M[i+4>>2]}u=k^-1;l=M[i+588>>2];e=0;n=0;while(1){if(!((l|0)<=0|e)){l=l-1|0;g=0;d=M[i+588>>2];d=(d|0)>0?d:0;k=0;while(1){if((d|0)!=(k|0)){h=k<<2;k=k+1|0;g=M[M[x>>2]+h>>2];if(M[g>>2]!=(l|0)){continue}}break}if(M[g+40>>2]){o=M[g>>2];m=M[g+60>>2];q=M[g+64>>2];M[f+32>>2]=0;h=0;d=0;M[f+24>>2]=0;M[f+28>>2]=0;M[f+104>>2]=0;M[f+96>>2]=0;M[f+100>>2]=0;M[f+88>>2]=0;M[f+92>>2]=0;M[f+84>>2]=0;k=0;t=0;e=Tb(a,32,f+84|0,0);if(!e){e=M[f+84>>2];Jb(e,1,r,p);fd(e,2,o);if((Db(e)|0)!=100){g=0}else{g=Ye(e,4);j=Wd(e,4);k=dd(e,1);t=Qa;g=Ex(g,j,f+24|0,q,m,f+88|0)}e=(L=g,O=wb(e),P=g,P?L:O)}while(1){D:{if(e){break D}g=M[f+88>>2];j=M[f+92>>2];if(!(g|j)){break D}M[f+80>>2]=0;M[f+76>>2]=0;e=dh(a,g,j,f+80|0,f+76|0);E:{if(e){break E}e=Ex(M[f+80>>2],M[f+76>>2],f+96|0,q,m,f+88|0);if(e){break E}e=og(a,g,j,M[f+96>>2],M[f+100>>2])}ab(M[f+80>>2]);h=g;d=j;continue}break}F:{if(!(d|h)|e){break F}M[f+80>>2]=0;e=Tb(a,17,f+80|0,0);if(e){break F}e=M[f+80>>2];Jb(e,1,k,t);Jb(e,2,h-1|0,d-!h|0);Db(e);e=wb(e)}G:{if(e){break G}M[f+80>>2]=0;e=Tb(a,33,f+80|0,0);if(e){break G}g=M[f+80>>2];Jb(g,1,h,d);jg(g,2,M[f+24>>2],M[f+28>>2],0);Jb(g,3,r,p);fd(g,4,o);Db(g);e=wb(g);Ge(g,1)}ab(M[f+24>>2]);ab(M[f+96>>2]);n=n+1|0}else{e=Mx(a,g);if(e){continue}h=M[g>>2];M[f+24>>2]=0;e=Tb(a,30,f+24|0,0);if(e){continue}d=M[f+24>>2];Jb(d,1,r,p);fd(d,2,h);Db(d);e=wb(d)}continue}break}H:{if(e){break H}e=0;if(M[i+588>>2]==(n|0)){break H}k=0;M[f+24>>2]=0;M[f+96>>2]=0;l=0;g=0;j=0;I:{e=Tb(a,35,f+24|0,0);if(e){break I}d=M[f+24>>2];Jb(d,1,r,p);m=0;while(1){J:{l=Db(d);if((l|0)==100){if((g|0)<(m|0)){e=j;break J}m=m+16|0;e=Mc(j,m<<2,0);if(e){break J}e=7}else{e=0}e=(L=e,O=wb(d),P=(l|0)==100,P?L:O);if(e){l=M[f+96>>2];break I}e=Tb(a,31,f+96|0,0);l=M[f+96>>2];if(e){break I}Jb(l,2,r,p);e=0;break I}L=(g<<2)+e|0,O=Md(d,0),M[L>>2]=O;g=g+1|0;j=e;continue}}K[a+240|0]=1;while(1){if(!(g>>>0<=k>>>0|e)){e=0;d=M[(k<<2)+j>>2];if((d|0)!=(k|0)){fd(l,3,d);fd(l,1,k);Db(l);e=wb(l)}k=k+1|0;continue}break}K[a+240|0]=0;ab(j)}b=b+u|0;M[f+20>>2]=e;h=1;if(!n){break u}fe(f+8|0,M[f+12>>2]+20|0,f+20|0);E=1;e=M[f+20>>2];if(e){break v}h=M[f+8>>2];d=M[f+12>>2];d=uc(h+d|0,r,p)+d|0;L=f,O=uc(d+h|0,n,0)+d|0,M[L+12>>2]=O}e=0}d=M[s>>2];h=0-d|0;d=0-(M[s+4>>2]+((d|0)!=0)|0)|0;M[s>>2]=h;M[s+4>>2]=d;h=0}M[f+24>>2]=e;k=15;K:{while(1){if((k|0)<0){break K}d=(k<<5)+v|0;if(M[d+24>>2]<=0){ab(M[d+20>>2]);ab(M[d+8>>2]);k=k-1|0;continue}break}L:{if(k){break L}fe(I,11,f+24|0);k=1;e=M[f+24>>2];if(e){break L}K[M[i+108>>2]]=1;L=i,O=uc(M[i+108>>2]+1|0,M[i+56>>2],M[i+60>>2])+1|0,M[L+112>>2]=O;e=0}g=0;while(1){if((g|0)!=(k|0)){d=(g<<5)+v|0;j=M[d+24>>2];if(!((j|0)<=0|e)){e=og(a,M[d>>2],M[d+4>>2],M[d+20>>2],j)}ab(M[d+20>>2]);ab(M[d+8>>2]);g=g+1|0;continue}break}j=(k<<5)+v|0;if(!e){g=M[i+12>>2];d=M[i+8>>2]+1|0;g=d?g:g+1|0;o=M[i+16>>2];k=M[i+24>>2];q=M[i+28>>2];m=M[i+56>>2];y=M[i+60>>2];B=M[i+32>>2];n=M[i+36>>2];if(N[i+48|0]){e=0;l=0}else{e=M[s+4>>2];l=M[s>>2]}e=Xp(a,d,g,o,k,q,m,y,B,n,l,e,M[j+20>>2],M[j+24>>2])}ab(M[j+20>>2]);ab(M[j+8>>2]);M[f+20>>2]=e}if(N[i+48|0]|!h){break k}d=p;h=r+1|0;d=h?d:d+1|0;Kx(a,h,d,M[s>>2],M[s+4>>2]);break k}M[f+20>>2]=e}eh(x);continue}break}k=e}M:{if(!E|k){break M}M[f+24>>2]=0;k=Tb(a,23,f+24|0,0);if(k){break M}a=M[f+24>>2];Jb(a,1,1,0);jg(a,2,M[f+8>>2],M[f+12>>2],0);Db(a);k=wb(a);Ge(a,1)}ab(i);ab(M[f+8>>2])}Na=f+112|0;return k}function In(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,P=0,Q=0,R=0,T=0,U=0,V=0;j=Na-320|0;Na=j;M[j+156>>2]=0;M[j+152>>2]=0;y=M[a>>2];a:{if(M[a+40>>2]){s=c;break a}M[j+128>>2]=0;s=0;b:{if(!c){break b}if(!(M[c+52>>2]|!(N[c+5|0]&2))){G=M[c+28>>2];M[c+28>>2]=0;pc(y,c);s=0;break b}s=c}c:{k=wh(a,b);if(!k){break c}c=M[k>>2];l=M[y+16>>2];z=Mb(y,M[k+60>>2]);if(gc(a,18,c,0,M[l+(z<<4)>>2])){break c}C=M[k+28>>2];F=Ai(a,k,128,0,j+120|0);I=N[k+43|0];if(lf(a,k)){break c}if(jn(a,k,F)){break c}n=Cb(a);if(!n){break c}if(!N[a+18|0]){L[n+152>>1]=O[n+152>>1]|16}jd(a,(s|F)!=0,z);d:{e:{if(M[a+280>>2]|(!s|d|F)|(M[s+64>>2]|N[k+43|0]==1)){break e}i=e;f:{if((i|0)!=11){break f}if(L[k+32>>1]>=0){i=N[k+42|0];if((i|0)!=11){break f}}i=2}c=M[s+32>>2];if(M[c>>2]!=1|N[c+21|0]&4|(M[s+36>>2]|M[s+48>>2])){break e}if(M[s+40>>2]|M[s+60>>2]|(M[s+52>>2]|K[s+4|0]&1)){break e}l=M[s+28>>2];if(M[l>>2]!=1|N[M[l+8>>2]]!=180){break e}p=M[a>>2];q=mf(a,0,c+8|0);if(!q|M[q+20>>2]==M[k+20>>2]&M[q+60>>2]==M[k+60>>2]){break e}c=M[q+28>>2];l=M[k+28>>2];if(N[q+43|0]|(c^l)&128){break e}h=O[k+34>>1];if(O[k+32>>1]!=O[q+32>>1]|(c&65536?0:l&65536)|(h|0)!=O[q+34>>1]){break e}while(1){if(h<<16>>16>(t|0)){l=S(t,12);c=l+M[k+4>>2]|0;h=O[c+10>>1]&96;l=l+M[q+4>>2]|0;if((h|0)!=(O[l+10>>1]&96)){break e}if(h){if(mc(0,Tc(q,l),Tc(k,c),-1)){break e}}if(N[c+5|0]!=N[l+5|0]){break e}if(hc(eg(c),eg(l))|(N[l+4|0]&15?0:N[c+4|0]&15)){break e}g:{if(!t|O[c+10>>1]&96){break g}c=Tc(k,c);l=Tc(q,l);if((!c|0)==((l|0)!=0|0)){break e}if(!c){break g}if(Wc(M[c+8>>2],M[l+8>>2])){break e}}t=t+1|0;h=O[k+34>>1];continue}break}l=q+8|0;h=0;c=k+8|0;m=c;while(1){g=M[m>>2];if(g){h=N[g+54|0]?1:h;m=l;while(1){m=M[m>>2];if(!m){break e}if(!JB(g,m)){m=m+20|0;continue}break}if(!(M[m+44>>2]!=M[g+44>>2]|M[q+60>>2]!=M[k+60>>2])){m=M[16930];if(!m){break e}if(!(Ra[m|0](411)|0)){break e}}m=g+20|0;continue}break}g=M[k+16>>2];if(!(!g|N[p+24|0]&4)){if(Qf(M[q+16>>2],g,-1)){break e}}m=M[p+36>>2];h:{if(M[p+32>>2]&16384){if(m&1){break e}if(!M[k+48>>2]){break h}break e}if(m&1){break e}}v=Mb(p,M[q+60>>2]);g=Cb(a);ud(a,v);u=M[a+44>>2];M[a+44>>2]=u+2;m=IB(a,z,k);w=Gb(a);$a(g,75,0,w);r=Gb(a);o=u+1|0;Pd(a,o,z,k,113);if(!(N[p+24|0]&4|!(h|(M[k+8>>2]?L[k+32>>1]<0:0))&i-3>>>0>4294967293)){h=$a(g,36,o,0);x=Ub(g,9);t=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(h,20)|0)+8>>2]=t}i:{if(!(N[q+28|0]&128)){Pd(a,u,v,q,102);h=$a(g,36,u,0);j:{if(L[k+32>>1]>=0){t=$a(g,135,u,r);if(!(N[p+24|0]&4)){B=bb(g,31,o,0,r);Or(a,i,k);E=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(B,20)|0)+8>>2]=E}HB(a,m,r);break j}if(!(M[k+8>>2]|N[p+24|0]&8)){t=$a(g,127,o,r);break j}t=$a(g,135,u,r)}i=169;if(N[p+24|0]&4){fb(g,137,o);i=152}bb(g,129,o,u,r);bb(g,128,o,w,r);if(!(N[p+24|0]&4)){Vd(g,-1,k,-5)}m=M[g+108>>2];if((m|0)>0){L[(M[g+104>>2]+S(m,20)|0)-18>>1]=i}$a(g,39,u,t);$a(g,122,u,0);$a(g,122,o,0);break i}Dd(a,z,M[k+20>>2],1,M[k>>2]);h=0;Dd(a,v,M[q+20>>2],0,M[q>>2])}while(1){i=l;k:{l:{m:{n:{c=M[c>>2];if(c){while(1){o:{i=M[i>>2];if(!i){break o}if(JB(c,i)){break o}i=i+20|0;continue}break}bb(g,102,u,M[i+44>>2],v);Ld(a,i);bb(g,113,o,M[c+44>>2],z);Ld(a,c);m=M[g+108>>2];if((m|0)>0){L[(M[g+104>>2]+S(m,20)|0)-18>>1]=1}t=$a(g,36,u,0);if(N[p+24|0]&4){B=O[i+52>>1];m=0;while(1){if((m|0)==(B|0)){break n}E=m<<2;m=m+1|0;if(!hc(33696,M[E+M[i+32>>2]>>2])){continue}break}break m}if(!(N[q+28|0]&128)){break m}m=((N[c+55|0]|N[c+56|0]<<8)&3)==2?9:8;break l}if(h){i=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(h,20)|0)+8>>2]=i}zb(a,r);zb(a,w);if(!x){i=0;B=0;C=0;break d}en(a);$a(g,70,0,0);i=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(x,20)|0)+8>>2]=i;$a(g,122,o,0);break e}fb(g,137,o);$a(g,129,o,u);m=152;break k}m=8}bb(g,134,u,w,1)}$a(g,138,o,w);i=M[g+108>>2];if((i|0)>0){L[(M[g+104>>2]+S(i,20)|0)-18>>1]=m}$a(g,39,u,t+1|0);m=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(t,20)|0)+8>>2]=m;$a(g,122,u,0);$a(g,122,o,0);c=c+20|0;continue}}E=IB(a,z,k);c=M[a+48>>2];q=c+1|0;i=L[k+34>>1];l=q+i|0;M[a+48>>2]=l;p=q;if(N[k+43|0]==1){M[a+48>>2]=l+1;p=c+2|0}P=C&128;o=!(O[k+28>>1]&1088);p:{q:{r:{s:{if(!d){c=-1;B=0;break s}B=ub(y,i<<2&-4,0);if(!B){i=0;break c}m=d+4|0;c=-1;l=0;while(1){if(M[d>>2]<=(l|0)){break s}h=M[m+(l<<2)>>2];u=Uf(h);i=0;g=L[k+34>>1];r=(g|0)>0?g:0;t:{while(1){if((i|0)!=(r|0)){u:{g=M[k+4>>2]+S(i,12)|0;if((u|0)!=N[g+7|0]){break u}v=M[g>>2];if(hb(h,v)){break u}h=(i<<2)+B|0;if(!M[h>>2]){M[h>>2]=l+1}if(!(N[g+10|0]&96)){o=(i|0)==(l|0)?o:0;c=L[k+32>>1]==(i|0)?l:c;break t}M[j+112>>2]=v;cb(a,29537,j+112|0);break r}i=i+1|0;continue}break}if(lj(h)){o=0;c=l;if(!P){break t}}M[j+100>>2]=h;M[j+96>>2]=b+8;cb(a,7209,j+96|0);K[a+17|0]=1;break r}l=l+1|0;continue}}u=p+1|0;v:{w:{x:{y:{if(s){i=M[s+32>>2];z:{if(!(M[s+52>>2]|(M[i>>2]!=1|!(N[i+21|0]&64)))){l=M[i+52>>2];M[j+128>>2]=M[l+8>>2];v=M[l+12>>2];w=M[M[M[l>>2]+28>>2]>>2];M[j+80>>2]=i+8;fc(a,0,19342,j+80|0);if(!(o&255)|L[k+34>>1]!=(w|0)){break z}p=v-1|0;q=p-(N[k+43|0]==1)|0;u=v;break z}l=M[a+48>>2]+1|0;M[a+48>>2]=l;i=0;h=M[n+108>>2];bb(n,11,l,0,h+1|0);M[j+140>>2]=0;M[j+144>>2]=0;M[j+132>>2]=0;M[j+136>>2]=0;M[j+128>>2]=l;K[j+124|0]=13;M[j+136>>2]=o&255?u:0;M[j+140>>2]=L[k+34>>1];if(Rc(a,s,j+124|0)|M[a+40>>2]){break a}v=M[j+136>>2];rh(n,l);l=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(h,20)|0)+8>>2]=l;w=M[M[s+28>>2]>>2]}if(F){break w}o=Cb(a);i=M[o+108>>2];l=0;if(N[k+43|0]==1){l=Gd(M[a>>2],k)}t=(i|0)<=1?1:i;m=k+8|0;h=1;while(1){r=0;if((h|0)==(t|0)){break y}i=74356;i=N[M[o>>2]+87|0]?i:M[o+104>>2]+S(h,20)|0;g=N[i|0];A:{if((g|0)!=173){if((g|0)!=102|(z|0)!=M[i+12>>2]){break A}g=m;r=M[i+8>>2];if((r|0)==M[k+20>>2]){break w}while(1){i=M[g>>2];if(!i){break A}g=i+20|0;if((r|0)!=M[i+44>>2]){continue}break}break w}if(M[i+16>>2]==(l|0)){break w}}h=h+1|0;continue}}M[j+204>>2]=0;M[j+208>>2]=0;M[j+196>>2]=0;M[j+200>>2]=0;M[j+188>>2]=0;M[j+192>>2]=0;M[j+180>>2]=0;M[j+184>>2]=0;M[j+176>>2]=a;v=0;w=0;if(G){w=M[G>>2];if(Te(j+176|0,G)){break x}}r=-1}z=1;break v}i=0;s=0;break a}r=M[a+44>>2];M[a+44>>2]=r+1;i=Gb(a);l=Gb(a);$a(n,117,r,w);h=fb(n,12,M[j+128>>2]);bb(n,97,v,w,i);$a(n,127,r,l);bb(n,128,r,i,l);Xb(n,h);g=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(h,20)|0)+8>>2]=g;zb(a,i);zb(a,l);z=0}B:{if((w|0)<=0|d){break B}g=0;C:{h=M[k+28>>2];c=L[k+32>>1];if(!(h&96)|(c|0)<0){break C}i=c;while(1){if((i|0)<=0){break C}c=c-((N[(M[k+4>>2]+S(i,12)|0)-2|0]&96)!=0)|0;i=i-1|0;continue}}l=L[k+34>>1];D:{if(!(h&98)){break D}h=(l|0)>0?l:0;i=0;while(1){if((h|0)==(i|0)){break D}g=((N[(M[k+4>>2]+S(i,12)|0)+10|0]&98)!=0)+g|0;i=i+1|0;continue}}i=l-g|0;if((i|0)==(w|0)){break B}M[j+72>>2]=w;M[j+68>>2]=i;M[j+64>>2]=b+8;cb(a,16287,j- -64|0);break r}E:{if(!d){break E}i=M[d>>2];if((i|0)==(w|0)){break E}M[j+52>>2]=i;M[j+48>>2]=w;cb(a,5200,j+48|0);break r}i=0;C=0;if(!(N[a+18|0]|!(K[y+36|0]&1)|(M[a+136>>2]|N[a+163|0]))){C=M[a+48>>2]+1|0;M[a+48>>2]=C;$a(n,71,0,C)}if((I|0)==2){break p}l=hn(a,k,113,0,-1,0,j+156|0,j+152|0);i=Ob(y,(l<<2)+8|0,0);if(i){break q}}i=0;break a}g=0;l=(l|0)>0?l:0;h=k+8|0;while(1){if((g|0)!=(l|0)){h=M[h>>2];m=M[a+48>>2]+1|0;M[a+48>>2]=m;M[(g<<2)+i>>2]=m;M[a+48>>2]=M[a+48>>2]+O[h+52>>1];g=g+1|0;h=h+20|0;continue}break}h=M[a+48>>2]+1|0;M[a+48>>2]=h;M[(l<<2)+i>>2]=h}if(f){F:{switch(N[k+43|0]-1|0){case 0:M[j+32>>2]=M[k>>2];cb(a,29704,j+32|0);break a;case 1:cb(a,1840,0);break a;default:break F}}if(Fk(a,M[f>>2])){break a}Q=M[j+156>>2];M[b+24>>2]=Q;R=j+228|0;T=M[j+152>>2];l=f;while(1){M[l+44>>2]=T;M[l+40>>2]=Q;M[l+36>>2]=u;M[l+32>>2]=b;G:{if(!M[l>>2]){break G}A=0;M[j+316>>2]=0;M[j+308>>2]=0;M[j+312>>2]=0;M[j+300>>2]=0;M[j+304>>2]=0;M[j+292>>2]=0;M[j+296>>2]=0;M[j+288>>2]=b;M[j+284>>2]=a;h=l;while(1){if(!h){break G}g=M[h>>2];if(!g){break G}m=j+284|0;if(Te(m,g)){break a}if(id(m,M[h+4>>2])){break a}J=M[b+24>>2];H:{g=M[b+16>>2];H=M[h>>2];I:{if(N[g+28|0]&128|M[H>>2]!=1){break I}m=M[H+8>>2];if(N[m|0]!=168){break I}if(O[m+32>>1]==65535){break H}}D(j+176|0,0,104);M[j+256>>2]=J;K[j+228|0]=168;M[j+188>>2]=R;K[j+176|0]=114;U=H+8|0;g=g+8|0;while(1){x=M[g>>2];if(x){J:{if(!N[x+54|0]){break J}m=M[H>>2];if((m|0)!=O[x+50>>1]){break J}g=M[x+36>>2];if(g){m=M[h+4>>2];if(!m){break J}if(mc(a,m,g,J)){break J}m=O[x+50>>1]}o=0;while(1){if((m|0)!=(o|0)){M[j+184>>2]=M[M[x+32>>2]+(o<<2)>>2];g=O[M[x+4>>2]+(o<<1)>>1];K:{if((g|0)==65534){t=M[(M[x+40>>2]+(o<<4)|0)+8>>2];if(N[t|0]==114){break K}M[j+188>>2]=t;t=j+176|0;break K}L[j+260>>1]=g;M[j+188>>2]=R;t=j+176|0}g=0;while(1){if((g|0)==(m|0)){break J}V=g<<4;g=g+1|0;if(mc(0,M[U+V>>2],t,J)>>>0>1){continue}break}o=o+1|0;continue}break}M[h+28>>2]=x;if((an(f,x)|0)==(h|0)){break H}K[h+21|0]=1;break H}g=x+20|0;continue}break}if(M[h+28>>2]){break H}L:{if(!(M[h+16>>2]|A)){K[j+160|0]=0;break L}M[j+16>>2]=A+1;vd(16,j+160|0,30172,j+16|0)}M[j>>2]=j+160;cb(a,2751,j);break a}A=A+1|0;h=M[h+16>>2];continue}}l=M[l+16>>2];if(l){continue}break}}M:{if(!z){o=fb(n,36,r);l=M[n+108>>2];break M}if(!s){l=0;o=0;break M}l=fb(n,12,M[j+128>>2]);if((c|0)>=0){$a(n,80,c+v|0,p)}o=l}x=G+8|0;t=0;h=u;g=0;while(1){m=L[k+34>>1];if((g|0)<(m|0)){N:{if(L[k+32>>1]==(g|0)){fb(n,76,h);break N}O:{P:{m=M[k+4>>2]+S(g,12)|0;A=O[m+10>>1];Q:{if(A&98){t=t+1|0;if(A&32){h=h-1|0;break N}if(A&64){if(!(K[j+120|0]&1)){break N}fb(n,76,h);break N}if(d){break Q}pk(a,Tc(k,m),h);break N}if(!d){break P}}A=M[(g<<2)+B>>2];if(!A){pk(a,Tc(k,m),h);break N}m=A-1|0;break O}if(!w){pk(a,Tc(k,m),h);break N}m=g-t|0}if(!z){bb(n,94,r,m,h);break N}if(s){if((u|0)==(v|0)){break N}$a(n,81,m+v|0,h);break N}m=M[x+(m<<4)>>2];A=Se(a,m,h);if((A|0)==(h|0)){break N}$a(n,M[m+4>>2]&4194304?80:81,A,h)}h=h+1|0;g=g+1|0;continue}break}v=M[a+60>>2]-1|0;M[a+60>>2]=v;if(K[j+120|0]&1){h=vc(a,m+1|0);R:{if((c|0)<0){$a(n,71,-1,h);break R}S:{if(!z){bb(n,94,r,c,h);break S}kc(a,M[x+(c<<4)>>2],h)}g=fb(n,52,h);$a(n,71,-1,h);m=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(g,20)|0)+8>>2]=m;fb(n,13,h)}g=h+1|0;bb(n,80,p+1|0,g,L[k+36>>1]-1|0);if(N[k+28|0]&96){qk(a,g,k)}if((I|0)!=2){Eg(n,k,g)}yi(a,F,128,0,1,k,h+(L[k+34>>1]^-1)|0,e,v);ad(a,h,L[k+34>>1]+1|0)}T:{if((I|0)==2){break T}if(N[k+43|0]==1){$a(n,75,0,q)}U:{if((c|0)>=0){V:{if(!z){bb(n,94,r,c,p);break V}if(s){break V}W:{h=M[x+(c<<4)>>2];if(N[h|0]!=122){break W}g=1;if(N[k+43|0]==1){break W}bb(n,127,M[j+156>>2],p,E);break U}kc(a,h,p)}X:{if(N[k+43|0]!=1){h=fb(n,52,p);bb(n,127,M[j+156>>2],p,E);g=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(h,20)|0)+8>>2]=g;break X}$a(n,51,p,M[n+108>>2]+2|0)}fb(n,13,p);g=0;break U}if(!(!P&N[k+43|0]!=1)){g=0;$a(n,75,0,p);break U}bb(n,127,M[j+156>>2],p,E);g=1}HB(a,E,p);if(N[k+28|0]&96){qk(a,p+1|0,k)}if(N[k+43|0]==1){c=Gd(y,k);Ur(a,k);nb(n,7,1,L[k+34>>1]+2|0,q,c,-11);c=M[n+108>>2];if((c|0)>0){L[(M[n+104>>2]+S(c,20)|0)-18>>1]=(e|0)==11?2:e}c=M[a+132>>2];K[(c?c:a)+21|0]=1;break T}M[j+176>>2]=0;h=M[j+156>>2];m=M[j+152>>2];LB(a,k,i,h,m,q,0,(c^-1)>>>31|0,e&255,v,j+176|0,0,f);if(N[y+33|0]&64){bn(a,k,0,q,0,0)}Qr(a,k,h,m,q,i,0,g,!(M[j+176>>2]?M[n+232>>2]:0))}if(C){$a(n,86,C,1)}if(F){yi(a,F,128,0,2,k,(u-L[k+34>>1]|0)-2|0,e,v)}pb(n,v);if(!z){$a(n,39,r,l);e=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(o,20)|0)+8>>2]=e;fb(n,122,r);break d}if(!s){break d}Xb(n,l);e=M[n+108>>2];M[(N[M[n>>2]+87|0]?74356:M[n+104>>2]+S(o,20)|0)+8>>2]=e}if(!(N[a+18|0]|M[a+136>>2])){en(a)}if(!C){break a}Tr(n,C,15578);break a}B=0}Gc(y,b);xb(y,G);Kk(y,f);pc(y,s);if(d){ye(y,d);eb(y,B)}if(i){cc(y,i)}Na=j+320|0}function vg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0;s=Na-16|0;Na=s;e=M[b>>2];n=M[e>>2];t=M[n>>2];a:{if(N[t+87|0]){break a}d=M[b+24>>2]+S(c,48)|0;j=M[d>>2];M[e+496>>2]=0;w=e+496|0;l=df(w,M[j+12>>2]);q=Qa;o=N[j|0];b:{if((o|0)==50){if(mB(n,j)){break a}e=M[j+20>>2];c:{if(N[j+5|0]&16){e=fr(w,e);break c}e=ef(w,e)}f=Qa;M[d+32>>2]=e;M[d+36>>2]=f;i=e|l;h=f|q;break b}e=df(w,M[j+16>>2]);M[d+32>>2]=e;f=Qa;M[d+36>>2]=f;if(!M[j+12>>2]|(N[j+5|0]|N[j+6|0]<<8)&1040|M[j+20>>2]){i=Dm(w,j);h=Qa;break b}i=e|l;h=f|q}if(M[w>>2]){L[d+10>>1]=O[d+10>>1]|4096}e=M[j+4>>2];d:{if(!(e&3)){break d}f=Qe(w,M[j+36>>2]);k=Qa;if(e&1){h=h|k;r=h>>>1|0;i=f|i;v=(h&1)<<31|i>>>1;if((k|0)==(r|0)&f>>>0>v>>>0|k>>>0>r>>>0){B=f-1|0;C=k-!f|0;break d}cb(n,3229,0);break a}r=h>>>1|0;if((k|0)==(r|0)&f>>>0>((h&1)<<31|i>>>1)>>>0|k>>>0>r>>>0){break d}if(!(!(N[a+20|0]&64)|M[a>>2]<=0)){cb(n,3229,0);break a}e=e&-4;M[j+4>>2]=e}M[d+40>>2]=i;M[d+44>>2]=h;M[d+16>>2]=-1;M[d+20>>2]=-1;L[d+12>>1]=0;e:{f:{if(lA(o)){e=Rf(M[j+12>>2]);f=Rf(M[j+16>>2]);k=l&M[d+32>>2]|q&M[d+36>>2]?2048:16383;g=M[d+28>>2];if((g|0)>0){e=M[(M[e+20>>2]+(g<<4)|0)-8>>2]}if(kA(a,s,e,o)){M[d+20>>2]=M[s>>2];M[d+24>>2]=M[s+4>>2];G=d,H=jA(o)&k,L[G+12>>1]=H}if((o|0)==45){L[d+10>>1]=O[d+10>>1]|2048}g:{if(!f){break g}if(!kA(a,s,f,o)|N[f+4|0]&32){break g}e=j;f=d;h:{if(M[d+20>>2]<0){break h}e=qb(t,e,0);if(N[t+87|0]){kb(t,e);break a}d=he(b,e,3);if(!d){break a}f=M[b+24>>2];ug(b,d,c);d=S(d,48)+f|0;if((o|0)==45){L[d+10>>1]=O[d+10>>1]|2048}f=M[b+24>>2]+S(c,48)|0;L[f+10>>1]=O[f+10>>1]|8;if(N[M[n>>2]+80|0]&128){break h}g=N[e|0];if((g|0)!=54&(g|0)!=45|K[e+4|0]&1){break h}g=rc(M[e+12>>2]);p=rc(M[e+16>>2]);if((g|0)!=(p|0)&((g|0)<67|(p|0)<67)){break h}g=Ug(n,e);if(!(!g|M[g+12>>2]==15)){g=M[e+16>>2];p=Lf(n,M[e+12>>2]);g=Lf(n,g);if(hb(M[p>>2],M[g>>2])){break h}}m=2048;L[f+12>>1]=O[f+12>>1]|2048}g=M[e+12>>2];i:{j:{if(N[g|0]==177){break j}p=M[e+16>>2];if(N[p|0]==177){break j}if((fg(n,g,p)|0)==(fg(n,M[e+16>>2],M[e+12>>2])|0)){break i}}M[e+4>>2]=M[e+4>>2]^1024}G=e,H=dK(M[e+12>>2],M[e+16>>2],32),M[G+12>>2]=H;M[e+16>>2]=Qa;g=N[e|0];if(g>>>0>=55){K[e|0]=(g-55^2)+55}M[d+20>>2]=M[s>>2];g=M[s+4>>2];M[d+40>>2]=i;M[d+44>>2]=h;M[d+32>>2]=l|B;M[d+36>>2]=q|C;M[d+24>>2]=g;G=d,H=k&jA(N[e|0])+m,L[G+12>>1]=H;d=f;break f}if((o|0)!=51){break f}f=M[j+4>>2];if(f&1){break f}if(hf(e)){break f}M[j+8>>2]=13603;K[j|0]=171;M[j+4>>2]=f|536870912;L[d+12>>1]=0;M[d+40>>2]=0;M[d+44>>2]=0;break f}k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{f=N[j|0];switch(f-49|0){case 0:break t;case 1:case 2:break e;case 3:break r;default:break u}}if((f|0)==43){break s}if((f|0)!=172){break e}if(N[b+8|0]!=44){break f}e=M[j+20>>2];if(!e){break f}k=M[n>>2];h=M[e>>2];f=re(k,M[j+8>>2],h,1,0);if(!f){break f}x=M[f+4>>2];if(!(x&4)){break f}e=M[j+20>>2];f=M[f+8>>2];y=N[f+2|0];g=N[f+1|0];i=N[f|0];if((h|0)>=3){f=M[e+40>>2];if(N[f|0]!=118){break f}f=M[f+8>>2];p=N[f|0];if(!p|(N[f+1|0]|(i|0)==(p|0)|(g|0)==(p|0))){break f}}q=M[e+24>>2];o=Rf(M[e+8>>2]);r=N[o|0];if((r|0)!=157){break p}if(!(N[k+34|0]&128)){break q}break n}if(N[b+8|0]!=44){break f}e=M[j+20>>2]+8|0;f=S(c,48);while(1){if((g|0)==2){break f}d=ob(n,N[g+50982|0],qb(t,M[j+12>>2],0),qb(t,M[e+(g<<4)>>2],0));ik(d,j);d=he(b,d,3);vg(a,b,d);i=M[b+24>>2];ug(b,d,c);g=g+1|0;d=f+i|0;continue}}E=S(c,48);r=E+M[b+24>>2]|0;y=M[r>>2];x=M[b>>2];A=M[x>>2];q=M[A>>2];k=ub(q,424,0);M[r+24>>2]=k;v:{if(!k){break v}L[r+10>>1]=O[r+10>>1]|16;e=k+32|0;D(e,0,384);K[k+9|0]=0;M[k>>2]=x;M[k+20>>2]=0;M[k+4>>2]=0;M[k+24>>2]=e;M[k+12>>2]=0;M[k+16>>2]=8;Jm(k,y,43);nr(a,k);if(N[q+87|0]){break v}v=x+496|0;e=M[k+24>>2];f=M[k+12>>2];m=-1;o=-1;l=-1;u=-1;while(1){if(!(!(m|o)|(f|0)<=0)){d=O[e+12>>1];w:{if(!(d&511)){d=Ob(q,416,0);if(!d){l=0;u=0;break w}M[e+24>>2]=d;M[e+20>>2]=-1;L[e+12>>1]=1024;L[e+10>>1]=O[e+10>>1]|32;i=d+32|0;D(i,0,384);h=M[b>>2];K[d+9|0]=0;M[d>>2]=h;M[d+20>>2]=0;M[d+4>>2]=0;M[d+24>>2]=i;M[d+12>>2]=0;M[d+16>>2]=8;Jm(d,M[e>>2],44);nr(a,d);M[d+4>>2]=b;l=0;u=0;i=0;h=0;x:{if(N[q+87|0]){break x}g=0;z=M[d+12>>2];z=(z|0)>0?z:0;d=M[d+24>>2];while(1){if((g|0)==(z|0)){break x}if(!(!lA(N[M[d>>2]])&O[d+12>>1]!=64)){i=Qe(v,M[d+20>>2])|i;h=h|Qa}d=d+48|0;g=g+1|0;continue}}m=i&m;o=h&o;break w}g=O[e+10>>1];if(g&8){break w}i=Qe(v,M[e+20>>2]);h=Qa;if(g&2){i=Qe(v,M[(M[k+24>>2]+S(M[e+16>>2],48)|0)+20>>2])|i;h=h|Qa}d=d&2;l=d?i&l:0;u=d?h&u:0;m=i&m;o=h&o}f=f-1|0;e=e+48|0;continue}break}M[k+416>>2]=m;M[k+420>>2]=o;e=-1;M[r+20>>2]=-1;L[r+12>>1]=512;y:{if(!(m|o)){break y}K[b+9|0]=1;if(M[k+12>>2]!=2){break y}f=M[k+24>>2];z:while(1){i=iA(f,p);if(!i){break y}p=p+1|0;g=0;while(1){h=iA(f+48|0,g);if(!h){continue z}A:{if((O[h+10>>1]|O[i+10>>1])&128){break A}d=O[i+12>>1];if(!(d&62)){break A}f=O[h+12>>1];if(!(f&62)){break A}d=d|f;if(d&65497?d&65509:0){break A}if(mc(0,M[M[i>>2]+12>>2],M[M[h>>2]+12>>2],-1)){break A}if(mc(0,M[M[i>>2]+16>>2],M[M[h>>2]+16>>2],-1)){break A}h=qb(M[M[M[b>>2]>>2]>>2],M[i>>2],0);if(!h){break A}m=d&d+63?d&24?8:32:d;d=54;while(1){f=d;d=d+1|0;if((m|0)!=2<<f-54){continue}break}K[h|0]=f;vg(a,b,he(b,h,3))}g=g+1|0;f=M[k+24>>2];continue}}}if(!(l|u)){break v}f=0;while(1){if(!(F>>>0>1|f)){g=M[k+12>>2];d=M[k+24>>2];while(1){if((g|0)<=0){break v}g=g-1|0;L[d+10>>1]=O[d+10>>1]&65471;B:{i=M[d+20>>2];if((i|0)!=(e|0)){if(Qe(v,i)&l|u&Qa){break B}}d=d+48|0;continue}break}h=M[M[d>>2]+12>>2];f=1;m=M[d+24>>2];p=(m|0)!=-2;while(1){if(!(!f|(g|0)<0)){C:{D:{if((i|0)!=M[d+20>>2]){L[d+10>>1]=O[d+10>>1]&65471;break D}f=0;if((m|0)!=M[d+24>>2]){break C}e=M[d>>2];if(!p){if(mc(A,M[e+12>>2],h,-1)){break C}e=M[d>>2]}e=rc(M[e+16>>2]);if((rc(M[M[d>>2]+12>>2])|0)!=(e|0)?e:0){break C}L[d+10>>1]=O[d+10>>1]|64}f=1}d=d+48|0;g=g-1|0;continue}break}F=F+1|0;e=i;continue}break}if(!f){break v}d=M[k+24>>2];g=M[k+12>>2];e=0;f=0;while(1){if((g|0)>0){if(N[d+10|0]&64){f=qb(q,M[M[d>>2]+16>>2],0);e=Wb(M[x>>2],e,f);f=M[M[d>>2]+12>>2]}g=g-1|0;d=d+48|0;continue}break}d=ob(A,50,qb(q,f,0),0);if(d){ik(d,y);M[d+20>>2]=e;e=he(b,d,3);vg(a,b,e);ug(b,e,c);break v}xb(q,e)}d=E+M[b+24>>2]|0;break f}f=M[j+12>>2];if(N[f|0]!=168|(e&1|L[f+32>>1]<0)){break f}i=he(b,ob(n,55,qb(t,f,0),Ec(t,122,0,0)),131);if(!i){break f}e=M[b+24>>2]+S(i,48)|0;M[e+32>>2]=0;M[e+36>>2]=0;M[e+20>>2]=M[f+28>>2];d=L[f+32>>1];L[e+12>>1]=4;M[e+24>>2]=d;ug(b,i,c);d=M[b+24>>2]+S(c,48)|0;L[d+10>>1]=O[d+10>>1]|8;f=M[d+44>>2];M[e+40>>2]=M[d+40>>2];M[e+44>>2]=f;break f}f=L[o+32>>1];u=yr(M[n+244>>2],f);E:{if(!u){break E}h=O[u+16>>1];e=h&31;if((h&63)>>>0>=32){h=1<<e;l=0}else{l=1<<e;h=l-1&1>>>32-e}if(!(l&262148|h&262144)){break E}m=gb(u)}e=M[n+8>>2];M[e+228>>2]=M[e+228>>2]|((f|0)>31?-2147483648:1<<f-1);break o}if((r|0)!=118){break n}m=M[o+8>>2]}if(!m){g=1;break m}e=0;while(1){f=e;h=e+m|0;l=N[h|0];e=(l|0)==(i|0);F:{G:{if(!l){break G}v=l<<24>>24;l=v&255;if((l|0)==(i|0)|(g|0)==(l|0)|(l|0)==(y|0)){break G}e=f+1|0;if(!((l|0)!=(p|0)|K[m+e|0]<=0)){e=f+2|0;continue}if((v|0)>=0){continue}M[s>>2]=h;H:{if((v|0)==-1){break H}if((nd(s)|0)==65533){break H}if(N[k+84|0]!=2){break F}}e=0}g=1;if((f|0)<=1){i=0;if(N[m|0]==(p|0)|(f|0)!=1){break l}}if(N[h-1|0]==255){break m}l=0;l=N[h+1|0]|!e?l:N[k+84|0]!=2;I:{i=wc(k,118,m);if(!i){break I}g=0;h=M[i+8>>2];K[h+f|0]=0;e=0;while(1){if((f|0)>(g|0)){g=(K[g+h|0]==(p|0))+g|0;K[e+h|0]=N[g+h|0];e=e+1|0;g=g+1|0;continue}break}f=e+h|0;K[f|0]=0;J:{if(N[q|0]!=168){break J}if((rc(q)|0)!=66){break J}if(N[q+7|0]&3){break I}g=M[q+44>>2];if(!g|N[g+43|0]!=1){break I}}if(!((Jd(h,s,e,1)|0)>0|(e|0)==1&N[h|0]==45)){f=f-1|0;g=N[f|0];K[f|0]=g+1;e=Jd(h,s,e,1);K[f|0]=g;if((e|0)<=0){break I}}me(k,i);Xc(u);break f}g=0;if((r|0)!=157){break k}e=M[n+8>>2];f=L[o+32>>1];M[e+228>>2]=M[e+228>>2]|((f|0)>31?-2147483648:1<<f-1);if(!l){break l}if(!N[M[o+8>>2]+1|0]){break k}f=Gb(n);Se(n,o,f);if(N[M[e>>2]+87|0]){e=74356}else{e=(M[e+104>>2]+S(M[e+108>>2],20)|0)-20|0}M[e+12>>2]=0;zb(n,f);break k}e=M[s>>2]-m|0;continue}}g=1}i=0}l=0}Xc(u);if(g){break f}h=M[M[j+20>>2]+24>>2];e=qb(t,i,0);K:{k=x&8;if(k|N[M[n>>2]+87|0]){break K}L[d+10>>1]=O[d+10>>1]|1024;d=0;while(1){g=M[i+8>>2]+d|0;f=N[g|0];if(!f){break K}K[g|0]=f&(N[f+31408|0]^-1|223);K[M[e+8>>2]+d|0]=N[f+31024|0];d=d+1|0;continue}}if(!N[t+87|0]){d=M[e+8>>2];d=(jb(d)+d|0)-1|0;if(!k){f=N[d|0];K[d|0]=N[f+31024|0];l=(f|0)!=64?l:0}while(1){f=N[d|0];if(!((f|0)!=191|P[e+8>>2]>=d>>>0)){K[d|0]=128;d=d-1|0;continue}break}K[d|0]=f+1}d=k?33696:20437;f=ob(n,58,ui(n,qb(t,h,0),d),i);ik(f,j);f=he(b,f,259);e=ob(n,57,ui(n,qb(t,h,0),d),e);ik(e,j);e=he(b,e,259);vg(a,b,f);vg(a,b,e);d=M[b+24>>2]+S(c,48)|0;if(!l){break f}ug(b,f,c);ug(b,e,c)}f=N[j|0]}L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{e=f&255;switch(e-50|0){case 0:break S;case 1:case 2:case 3:break R;case 4:break T;default:break U}}if((e|0)!=45){break R}}V:{i=M[j+12>>2];e=Zc(i);if((e|0)<2){break V}h=M[j+16>>2];if((Zc(h)|0)!=(e|0)|(N[h+5|0]&16?N[i+5|0]&16:0)|N[b+8|0]!=44){break V}d=0;while(1){if((d|0)==(e|0)){break Q}f=Pr(n,M[j+12>>2],d,e);i=Pr(n,M[j+16>>2],d,e);f=ob(n,N[j|0],f,i);ik(f,j);vg(a,b,he(b,f,32769));d=d+1|0;continue}}if((f&255)!=50){break R}}if(M[d+28>>2]){break R}d=M[j+12>>2];if(!(N[j+5|0]&16)|N[d|0]!=177){break R}e=M[j+20>>2];if((N[e+5|0]&2?0:M[e+52>>2])|M[e+68>>2]|N[b+8|0]!=44){break R}g=0;while(1){if((Zc(d)|0)<=(g|0)){break L}e=he(b,j,32770);g=g+1|0;M[(M[b+24>>2]+S(e,48)|0)+28>>2]=g;vg(a,b,e);ug(b,e,c);d=M[j+12>>2];continue}}if(N[b+8|0]!=44){break L}a=f&255;if((a|0)==172){e=M[j+20>>2];if(!e|M[e>>2]!=2){break N}W:{a=M[e+24>>2];if(N[a|0]!=168|N[M[a+44>>2]+43|0]!=1){break W}f=M[j+8>>2];d=0;while(1){if((d|0)==4){break W}i=d<<3;d=d+1|0;i=i+50992|0;if(hb(f,M[i>>2])){continue}break}e=M[e+8>>2];m=N[i+4|0];g=1;break M}a=M[e+8>>2];if(N[a|0]!=168){break N}d=M[a+44>>2];if(N[d+43|0]!=1){break N}d=M[Gd(t,d)+8>>2];f=M[M[d>>2]+72>>2];if(!f){break N}m=Ra[f|0](d,2,M[j+8>>2],s,s+12|0)|0;if((m|0)<150){break N}e=M[e+24>>2];g=1;break M}if(a>>>0>53){break N}m=0;d=(f&255)-46|0;if(d>>>0>7){break N}e=0;a=0;g=0;if(!(1<<d&193)){break M}d=M[j+16>>2];e=M[j+12>>2];if(N[e|0]==168){g=N[M[e+44>>2]+43|0]==1}if(!d){a=e;e=0;break O}if(N[d|0]!=168|N[M[d+44>>2]+43|0]!=1){break P}g=g+1|0;a=d;break O}a=M[b+24>>2]+S(c,48)|0;L[a+12>>1]=8192;L[a+10>>1]=O[a+10>>1]|6;break L}a=e;e=d}m=68;X:{Y:{d=f&255;switch(d-52|0){case 1:break M;case 0:break Y;default:break X}}m=70;break M}if((d|0)!=46){m=0;break M}m=69;break M}m=0;e=0;a=0;g=0}while(1){d=a;a=e;if((g|0)<=0){break L}g=g-1|0;e=df(w,e);i=Qa;f=e;e=d;if(f&df(w,d)|Qa&i){continue}d=ob(n,47,0,qb(t,a,0));if(!(!(K[j+4|0]&1)|!d)){M[d+4>>2]=M[d+4>>2]|1;M[d+36>>2]=M[j+36>>2]}h=he(b,d,3);l=M[b+24>>2]+S(h,48)|0;d=l;M[d+32>>2]=f;M[d+36>>2]=i;M[d+20>>2]=M[e+28>>2];f=L[e+32>>1];K[d+15|0]=m;L[d+12>>1]=64;M[d+24>>2]=f;ug(b,h,c);d=M[b+24>>2]+S(c,48)|0;L[d+10>>1]=O[d+10>>1]|8;f=M[d+44>>2];M[l+40>>2]=M[d+40>>2];M[l+44>>2]=f;continue}}a=M[b+24>>2]+S(c,48)|0;b=M[a+32>>2];c=C|M[a+36>>2];M[a+32>>2]=b|B;M[a+36>>2]=c}Na=s+16|0}function Se(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=Na-128|0;Na=g;f=M[a+8>>2];M[g+60>>2]=0;M[g+56>>2]=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{while(1){z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{if(!b){break J}if(!(!M[a+76>>2]|N[b+6|0]&128)){e=c;l=Na-32|0;Na=l;d=a+76|0;while(1){K:{L:{h=M[d>>2];M:{if(!h){e=-1;break M}k=M[h+4>>2];if((k|0)<0){break L}o=M[a+56>>2];N:{if(!o){d=k;break N}d=-1;if((k|0)!=(o-1|0)){break L}}if(mc(0,b,M[h>>2],d)){break L}k=rc(b);O:{if(k>>>0<=65){if(N[h+17|0]!=65){break L}break O}d=N[h+17|0];if((k|0)==66){if((d|0)==66){break O}break L}if((d|0)!=67){break L}}if(M[b+4>>2]<0){M[l+12>>2]=0;M[l+16>>2]=0;M[l+28>>2]=0;M[l+20>>2]=0;M[l+24>>2]=0;M[l+8>>2]=83;M[l+4>>2]=a;mk(l+4|0,b);if(O[l+24>>1]){break L}}d=M[a+8>>2];if(N[h+16|0]){k=M[d+108>>2];bb(d,20,M[h+8>>2],k+3|0,e);bb(d,94,M[h+8>>2],M[h+12>>2],e);Xb(d,0);h=M[a+76>>2];M[a+76>>2]=0;kc(a,b,e);M[a+76>>2]=h;h=M[d+108>>2];M[(N[M[d>>2]+87|0]?74356:(M[d+104>>2]+S(k,20)|0)+40|0)+8>>2]=h;break M}bb(d,94,M[h+8>>2],M[h+12>>2],e)}Na=l+32|0;d=e;break K}d=h+20|0;continue}break}if((d|0)>=0){break a}}P:{e=N[b|0];switch(e-103|0){case 10:case 13:case 14:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:case 32:case 33:case 34:case 35:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:case 50:case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:case 64:case 77:break J;case 12:break r;case 15:break g;case 36:break w;case 51:break f;case 52:break h;case 53:break d;case 54:break i;case 55:break F;case 65:break H;case 66:break u;case 67:break I;case 68:break e;case 69:break v;case 70:case 78:break A;case 71:break q;case 72:break s;case 73:break j;case 74:break D;case 75:break x;case 76:break E;case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:break p;case 11:break B;default:break P}}Q:{switch(e-19|0){case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 18:case 19:case 20:case 21:case 22:case 23:case 28:case 29:break J;case 0:break r;case 1:break w;case 17:break k;case 26:case 27:break n;case 30:break z;case 31:break y;case 32:case 33:break t;case 34:case 35:case 36:case 37:case 38:case 39:break o;case 24:case 25:break p;default:break Q}}if((e|0)==72){break G}if((e|0)==78){break C}}$a(f,75,0,c);break b}e=L[b+34>>1];d=M[b+40>>2];if((e|0)<M[d+24>>2]){if(!N[d|0]){d=e+M[d+12>>2]|0;break a}if(N[d+1|0]){a=M[d+20>>2]+(e<<4)|0;b=M[a>>2];bb(f,94,M[d+8>>2],L[a+14>>1],c);if(!b){break b}a=L[a+12>>1];if((a|0)<0|N[(M[b+4>>2]+S(a,12)|0)+5|0]!=69){break b}fb(f,87,c);break b}if(M[b+44>>2]){break H}bb(f,94,M[b+28>>2],L[b+32>>1],c);break b}$a(f,75,0,c);break l}if(N[b+4|0]&32){d=Se(a,M[b+12>>2],c);a=68;c=L[b+32>>1];R:{if((c|0)<0){break R}b=M[b+44>>2];if((c|0)>=L[b+34>>1]){break R}a=K[(M[b+4>>2]+S(c,12)|0)+5|0];if((a|0)<66){break a}}nb(f,96,d,1,0,(a<<1&254)+50476|0,-1);break a}i=M[b+28>>2];if((i|0)<0){d=M[a+56>>2];if((d|0)<0){e=L[b+32>>1];if((e|0)<0){d=d^-1;break a}i=M[b+44>>2];d=Pc(i,e)-d|0;b=M[i+4>>2]+S(e,12)|0;e=O[b+10>>1];if(e&96){if(e&256){M[g>>2]=M[b>>2];cb(a,29507,g);d=0;break a}c=e|256;L[b+10>>1]=c;if(e&128){Hr(a,i,b,d);c=O[b+10>>1]}L[b+10>>1]=c&65151;break a}if(N[b+5|0]!=69){break a}$a(f,81,d,c);fb(f,87,c);break b}i=d-1|0;break c}e=M[a+80>>2];if(!e){break c}d=L[b+32>>1];while(1){if(!e){break c}if((d|0)!=M[e+12>>2]|M[e+4>>2]!=(i|0)){e=M[e+20>>2];continue}else{j=M[a+8>>2];if(N[e+16|0]){m=fb(j,20,M[e+8>>2])}d=Se(a,M[e>>2],c);nb(M[a+8>>2],96,d,1,0,e+17|0,1);if(m){e=M[j+108>>2];S:{if(N[M[j>>2]+87|0]){M[18591]=e;j=74356;break S}j=M[j+104>>2]+S(m,20)|0;M[j+8>>2]=e}M[j+12>>2]=d}if(d){break a}break c}}}if(!(M[a+136>>2]|N[a+18|0])){d=0;cb(a,11600,0);break a}T:{switch(N[b+1|0]-2|0){case 2:$a(f,70,0,4);break l;case 0:d=M[a+132>>2];K[(d?d:a)+21|0]=1;break;default:break T}}d=Oc(a,M[b+12>>2],g+60|0);bb(f,70,M[a+136>>2]?1811:1,K[b+1|0],d);break l}m=M[b+20>>2];j=M[m>>2];k=M[a+60>>2]-1|0;M[a+60>>2]=k;d=M[a>>2];e=0;h=M[b+12>>2];if(h){n=qb(d,h,0);if(N[d+87|0]){kb(d,n);break l}qn(n,Gr(a,n,g+60|0));i=g+72|0;D(i,0,52);M[g+84>>2]=n;K[g+72|0]=54;M[g+60>>2]=0}m=m+8|0;l=j-1|0;while(1){if((e|0)<(l|0)){o=m+(e<<4)|0;b=M[o>>2];U:{if(!h){i=b;break U}M[g+88>>2]=b}b=M[a+60>>2]-1|0;M[a+60>>2]=b;Dc(a,i,b,16);kc(a,M[o+16>>2],c);Xb(f,k);pb(f,b);e=e+2|0;continue}break}V:{if(j&1){kc(a,M[m+(l<<4)>>2],c);break V}$a(f,75,0,c)}kb(d,n);sB(f);pb(f,k);break l}e=N[a+23|0];W:{d=M[b+40>>2];if(!d){break W}if(!N[d|0]){c=M[d+12>>2]+L[b+34>>1]|0;break l}if(!N[d+1|0]){break W}bb(f,94,M[d+8>>2],L[(M[d+20>>2]+(L[b+34>>1]<<4)|0)+14>>1],c);break l}d=bb(f,20,M[b+28>>2],0,c);K[a+23|0]=0;kc(a,M[b+12>>2],c);K[a+23|0]=e;e=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(d,20)|0)+8>>2]=e;break l}cb(a,15719,0);break l}d=M[b+44>>2];e=L[b+32>>1];$a(f,157,(Pc(d,e)+S(M[b+28>>2],L[d+34>>1]+1|0)|0)+1|0,c);if(N[(M[d+4>>2]+S(e,12)|0)+5|0]!=69|(e|0)<0){break l}fb(f,87,c);break l}if(N[b+5|0]&2){break A}kc(a,M[b+12>>2],c);fb(f,180,c);break b}b=M[b+12>>2];continue}break}Fr(a,b,c,0,0);break b}e=M[a+60>>2];d=e-2|0;M[a+60>>2]=d;$a(f,75,0,c);k=a;a=e-1|0;Wm(k,b,a,d);$a(f,71,1,c);pb(f,a);$a(f,86,c,0);pb(f,d);break b}c=M[b+12>>2];e=M[c+28>>2];if(!(N[a+26|0]<=N[c+2|0]?e:0)){e=ok(a,c);M[c+28>>2]=e;K[c+2|0]=N[a+26|0]}d=M[b+28>>2];i=Zc(c);if((d|0)!=(i|0)){M[g+52>>2]=i;M[g+48>>2]=d;cb(a,5330,g+48|0);e=M[c+28>>2]}d=e+L[b+32>>1]|0;break a}d=0;if(N[M[a>>2]+87|0]){break a}X:{if(!(!(N[b+5|0]&16)|(e|0)!=139)){d=M[M[M[b+20>>2]+28>>2]>>2];if((d|0)!=1){break X}}d=ok(a,b);break a}Er(a,d,1);break l}if(K[b+7|0]&1){d=M[M[b+44>>2]+56>>2];break a}l=M[a>>2];d=N[l+84|0];Y:{if(!N[a+23|0]){break Y}if(!Vm(a,b)){break Y}d=Um(a,b,-1);break a}h=M[b+20>>2];if(h){j=M[h>>2]}Z:{_:{$:{d=re(l,M[b+8>>2],j,d,0);if(!(!d|M[d+20>>2])){e=M[d+4>>2];if(!(!h|!(e&4194304))){e=M[a+8>>2];aa:{switch(M[d+8>>2]){case 0:b=M[h>>2];d=M[a+60>>2]-1|0;M[a+60>>2]=d;kc(a,M[h+8>>2],c);i=(b|0)<=1?1:b;j=h+8|0;b=1;while(1){if((b|0)!=(i|0)){$a(e,52,c,d);kc(a,M[j+(b<<4)>>2],c);b=b+1|0;continue}break};sB(e);pb(e,d);break b;case 5:b=g+72|0;D(b,0,52);M[g+92>>2]=h;K[g+72|0]=158;d=Se(a,b,c);break a;default:d=Se(a,M[h+8>>2],c);break a;case 3:$a(e,71,mc(0,M[h+8>>2],M[h+24>>2],-1),c);break b;case 2:$a(e,71,Tm(a,M[h+8>>2],M[h+24>>2],-1),c);break b;case 1:a=M[h+24>>2];if(N[a|0]==168){$a(e,71,vn(M[h+8>>2],M[a+28>>2],1),c);break b}$a(e,75,0,c);break b;case 4:break aa}}a=rc(M[h+8>>2]);if((a|0)>=65){a=M[(a<<2)+50364>>2]}else{a=13926}Uc(e,c,a);break b}if(e&2621440){rB(a,b,d)}k=(j|0)>0?j:0;m=h+8|0;e=0;while(1){if((e|0)!=(k|0)){ba:{if(e>>>0>31){break ba}if(!Nd(a,M[(e<<4)+m>>2])){break ba}n=1<<e|n}if(!(!(N[d+4|0]&32)|i)){i=Fd(a,M[(e<<4)+m>>2])}e=e+1|0;continue}break}ca:{if(!h){k=0;break ca}da:{if(n){e=M[a+48>>2];M[a+48>>2]=e+j;k=e+1|0;break da}k=vc(a,j)}e=M[d+4>>2]&192;ea:{if(!e){break ea}o=M[m>>2];if((N[o|0]&253)!=168){break ea}K[o+2|0]=e}kf(a,h,k,0,2)}if((j|0)>=2){m=K[b+5|0]&1?h+24|0:m;break $}if((j|0)==1){break $}break _}M[g+32>>2]=b;cb(a,27012,g+32|0);break l}e=M[m>>2];M[g+72>>2]=0;M[g+124>>2]=0;if(!e|N[e|0]!=168){break _}e=M[e+44>>2];if(!e|N[e+43|0]!=1){break _}e=M[Gd(l,e)+8>>2];h=M[M[e>>2]+72>>2];if(!h){break _}if(!(Ra[h|0](e,j,M[d+32>>2],g+72|0,g+124|0)|0)){break _}e=ub(l,jb(M[d+32>>2])+41|0,0);if(!e){break _}G(e,d,40);h=e+40|0;M[e+32>>2]=h;d=M[d+32>>2];m=jb(d)+1|0;if(m){G(h,d,m)}M[e+16>>2]=M[g+72>>2];M[e+8>>2]=M[g+124>>2];M[e+4>>2]=M[e+4>>2]|16;break Z}e=d}if(N[e+4|0]&32){if(!i){i=M[l+8>>2]}nb(f,85,0,0,0,i,-2)}nk(a,n,k,c,j,e,N[b+2|0]);if(!j|n){break b}ad(a,k,j);break b}fa:{d=M[b+40>>2];ga:{if(!d){break ga}e=L[b+34>>1];if((e|0)<0){break ga}if((e|0)<M[d+36>>2]){break fa}}M[g+16>>2]=b;cb(a,27036,g+16|0);break l}d=M[d+24>>2]+(e+M[d+12>>2]|0)|0;break a}$a(f,71,1,c);b=fb(f,e,Oc(a,M[b+12>>2],g+60|0));$a(f,71,0,c);d=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(b,20)|0)+8>>2]=d;break l}e=Oc(a,M[b+12>>2],g+60|0);d=vi(M[b+16>>2]);lb(f,91,e,c,d^1,d^N[b+2|0]==45);break l}$a(f,e,Oc(a,M[b+12>>2],g+60|0),c);break l}ha:{ia:{ja:{d=M[b+12>>2];switch(N[d|0]-154|0){case 0:break ia;case 2:break ja;default:break ha}}qB(a,d,1,c);break b}Cr(f,M[d+8>>2],1,c);break b}M[g+76>>2]=67584;M[g+80>>2]=0;K[g+72|0]=156;d=Oc(a,g+72|0,g+60|0);bb(f,108,Oc(a,M[b+12>>2],g+56|0),d,c);break l}d=Oc(a,M[b+12>>2],g+60|0);bb(f,e,Oc(a,M[b+16>>2],g+56|0),d,c);break l}q=1;d=0;break m}e=(e|0)==45?54:53;m=128;d=1}k=M[b+12>>2];if(ze(k)){h=M[b+16>>2];d=M[a+8>>2];i=Zc(k);f=M[a+60>>2]-1|0;M[a+60>>2]=f;if(M[a+40>>2]){break l}b=M[b+4>>2];if((Zc(h)|0)!=(i|0)){cb(a,15719,0);break l}r=b>>>10&1;s=pB(a,k);t=pB(a,h);$a(d,71,1,c);j=(e|0)==53?54:(e|0)==58?55:(e|0)==56?57:e;u=i-2|0;l=i-1|0;i=0;b=0;while(1){M[g+72>>2]=0;M[g+124>>2]=0;M[g+68>>2]=0;M[g+64>>2]=0;if(i){M[(N[M[d>>2]+87|0]?74356:M[d+104>>2]+S(i,20)|0)+8>>2]=M[d+108>>2]}n=oB(a,k,b,s,g+68|0,g+72|0);o=oB(a,h,b,t,g- -64|0,g+124|0);i=M[d+108>>2];p=j&255;Sm(a,M[g+68>>2],M[g+64>>2],p,n,o,f,m,r);zb(a,M[g+72>>2]);zb(a,M[g+124>>2]);ka:{la:{switch(p-55|0){case 0:case 2:break la;default:break ka}}if((b|0)>=(l|0)){break ka}i=Ub(d,59)}ma:{if(!q){$a(d,71,0,c);break ma}bb(d,92,n,c,o)}if((b|0)!=(l|0)){na:{if((p|0)==54){$a(d,52,c,f);j=54;break na}$a(d,9,0,f);j=(b|0)==(u|0)?e:j}b=b+1|0;continue}break}j=M[d+108>>2];M[(N[M[d>>2]+87|0]?74356:M[d+104>>2]+S(i,20)|0)+8>>2]=j;pb(d,f);if((e|0)!=53){break l}$a(d,19,c,c);break l}i=Oc(a,k,g+60|0);j=Oc(a,M[b+16>>2],g+56|0);$a(f,71,1,c);Sm(a,k,M[b+16>>2],e,i,j,M[f+108>>2]+2|0,m,M[b+4>>2]>>>10&1);if(d){$a(f,71,0,c);break l}bb(f,92,i,c,j)}d=c;zb(a,M[g+60>>2]);zb(a,M[g+56>>2]);break a}kc(a,M[b+12>>2],c);$a(f,88,c,Si(M[b+8>>2],0));break b}d=M[b+28>>2];break a}$a(f,78,L[b+32>>1],c);break b}a=M[b+8>>2]+2|0;b=jb(a)-1|0;nb(f,77,(b|0)/2|0,c,0,pt(M[f>>2],a,b),-6);break b}Uc(f,c,M[b+8>>2]);break b}Cr(f,M[b+8>>2],0,c);break b}$a(f,71,vi(b),c);break b}qB(a,b,0,c);break b}d=N[b+2|0];Ed(M[a+8>>2],M[b+44>>2],i,L[b+32>>1],c);if(!d){break b}b=74356;a=M[a+8>>2];if(!N[M[a>>2]+87|0]){b=(M[a+104>>2]+S(M[a+108>>2],20)|0)-20|0}a=N[b|0];if((a|0)!=176){if((a|0)!=94){break b}L[b+2>>1]=d;break b}L[b+2>>1]=d&1}d=c}Na=g+128|0;return d}function Je(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=Na-16|0;Na=k;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{if(a>>>0<=244){e=M[18596];g=a>>>0<11?16:a+11&504;a=g>>>3|0;b=e>>>a|0;if(b&3){c=a+((b^-1)&1)|0;b=c<<3;a=b+74424|0;b=M[b+74432>>2];d=M[b+8>>2];k:{if((a|0)==(d|0)){m=74384,n=cK(-2,c)&e,M[m>>2]=n;break k}M[d+12>>2]=a;M[a+8>>2]=d}a=b+8|0;c=c<<3;M[b+4>>2]=c|3;b=b+c|0;M[b+4>>2]=M[b+4>>2]|1;break a}i=M[18598];if(i>>>0>=g>>>0){break j}if(b){c=2<<a;a=YJ((0-c|c)&b<<a);c=a<<3;b=c+74424|0;c=M[c+74432>>2];d=M[c+8>>2];l:{if((b|0)==(d|0)){e=cK(-2,a)&e;M[18596]=e;break l}M[d+12>>2]=b;M[b+8>>2]=d}M[c+4>>2]=g|3;h=c+g|0;a=a<<3;f=a-g|0;M[h+4>>2]=f|1;M[a+c>>2]=f;if(i){a=(i&-8)+74424|0;d=M[18601];b=1<<(i>>>3);m:{if(!(b&e)){M[18596]=b|e;b=a;break m}b=M[a+8>>2]}M[a+8>>2]=d;M[b+12>>2]=d;M[d+12>>2]=a;M[d+8>>2]=b}a=c+8|0;M[18601]=h;M[18598]=f;break a}l=M[18597];if(!l){break j}c=M[(YJ(l)<<2)+74688>>2];f=(M[c+4>>2]&-8)-g|0;b=c;while(1){n:{a=M[b+16>>2];if(!a){a=M[b+20>>2];if(!a){break n}}d=(M[a+4>>2]&-8)-g|0;b=d>>>0<f>>>0;f=b?d:f;c=b?a:c;b=a;continue}break}j=M[c+24>>2];a=M[c+12>>2];if((c|0)!=(a|0)){b=M[c+8>>2];M[b+12>>2]=a;M[a+8>>2]=b;break b}b=M[c+20>>2];if(b){d=c+20|0}else{b=M[c+16>>2];if(!b){break i}d=c+16|0}while(1){h=d;a=b;d=a+20|0;b=M[a+20>>2];if(b){continue}d=a+16|0;b=M[a+16>>2];if(b){continue}break}M[h>>2]=0;break b}g=-1;if(a>>>0>4294967231){break j}b=a+11|0;g=b&-8;h=M[18597];if(!h){break j}i=31;f=0-g|0;if(a>>>0<=16777204){a=V(b>>>8|0);i=((g>>>38-a&1)-(a<<1)|0)+62|0}b=M[(i<<2)+74688>>2];o:{p:{q:{if(!b){a=0;break q}a=0;c=g<<((i|0)!=31?25-(i>>>1|0)|0:0);while(1){r:{e=(M[b+4>>2]&-8)-g|0;if(e>>>0>=f>>>0){break r}d=b;f=e;if(f){break r}f=0;a=b;break p}e=M[b+20>>2];b=M[((c>>>29&4)+b|0)+16>>2];a=e?(e|0)==(b|0)?a:e:a;c=c<<1;if(b){continue}break}}if(!(a|d)){d=0;a=2<<i;a=(0-a|a)&h;if(!a){break j}a=M[(YJ(a)<<2)+74688>>2]}if(!a){break o}}while(1){c=(M[a+4>>2]&-8)-g|0;b=c>>>0<f>>>0;f=b?c:f;d=b?a:d;b=M[a+16>>2];if(b){a=b}else{a=M[a+20>>2]}if(a){continue}break}}if(!d|M[18598]-g>>>0<=f>>>0){break j}i=M[d+24>>2];a=M[d+12>>2];if((d|0)!=(a|0)){b=M[d+8>>2];M[b+12>>2]=a;M[a+8>>2]=b;break c}b=M[d+20>>2];if(b){c=d+20|0}else{b=M[d+16>>2];if(!b){break h}c=d+16|0}while(1){e=c;a=b;c=a+20|0;b=M[a+20>>2];if(b){continue}c=a+16|0;b=M[a+16>>2];if(b){continue}break}M[e>>2]=0;break c}d=M[18598];if(d>>>0>=g>>>0){a=M[18601];b=d-g|0;s:{if(b>>>0>=16){c=a+g|0;M[c+4>>2]=b|1;M[a+d>>2]=b;M[a+4>>2]=g|3;break s}M[a+4>>2]=d|3;b=a+d|0;M[b+4>>2]=M[b+4>>2]|1;c=0;b=0}M[18598]=b;M[18601]=c;a=a+8|0;break a}c=M[18599];if(c>>>0>g>>>0){b=c-g|0;M[18599]=b;a=M[18602];c=a+g|0;M[18602]=c;M[c+4>>2]=b|1;M[a+4>>2]=g|3;a=a+8|0;break a}a=0;f=g+47|0;if(M[18714]){b=M[18716]}else{M[18717]=-1;M[18718]=-1;M[18715]=4096;M[18716]=4096;M[18714]=k+12&-16^1431655768;M[18719]=0;M[18707]=0;b=4096}e=f+b|0;h=0-b|0;b=e&h;if(b>>>0<=g>>>0){break a}i=M[18706];if(i){j=M[18704];d=j+b|0;if(d>>>0<=j>>>0|d>>>0>i>>>0){break a}}t:{if(!(N[74828]&4)){u:{v:{w:{x:{d=M[18602];if(d){a=74832;while(1){i=M[a>>2];if(i>>>0<=d>>>0&d>>>0<i+M[a+4>>2]>>>0){break x}a=M[a+8>>2];if(a){continue}break}}c=ei(0);if((c|0)==-1){break u}e=b;a=M[18715];d=a-1|0;if(d&c){e=(b-c|0)+(c+d&0-a)|0}if(e>>>0<=g>>>0){break u}d=M[18706];if(d){h=M[18704];a=h+e|0;if(a>>>0<=h>>>0|a>>>0>d>>>0){break u}}a=ei(e);if((c|0)!=(a|0)){break w}break t}e=h&e-c;c=ei(e);if((c|0)==(M[a>>2]+M[a+4>>2]|0)){break v}a=c}if((a|0)==-1){break u}if(g+48>>>0<=e>>>0){c=a;break t}c=M[18716];c=c+(f-e|0)&0-c;if((ei(c)|0)==-1){break u}e=c+e|0;c=a;break t}if((c|0)!=-1){break t}}M[18707]=M[18707]|4}c=ei(b);a=ei(0);if((c|0)==-1|(a|0)==-1|a>>>0<=c>>>0){break e}e=a-c|0;if(e>>>0<=g+40>>>0){break e}}a=M[18704]+e|0;M[18704]=a;if(a>>>0>P[18705]){M[18705]=a}y:{f=M[18602];if(f){a=74832;while(1){b=M[a>>2];d=M[a+4>>2];if((b+d|0)==(c|0)){break y}a=M[a+8>>2];if(a){continue}break}break g}a=M[18600];if(!(a>>>0<=c>>>0?a:0)){M[18600]=c}a=0;M[18709]=e;M[18708]=c;M[18604]=-1;M[18605]=M[18714];M[18711]=0;while(1){b=a<<3;d=b+74424|0;M[b+74432>>2]=d;M[b+74436>>2]=d;a=a+1|0;if((a|0)!=32){continue}break}a=e-40|0;b=-8-c&7;d=a-b|0;M[18599]=d;b=b+c|0;M[18602]=b;M[b+4>>2]=d|1;M[(a+c|0)+4>>2]=40;M[18603]=M[18718];break f}if(M[a+12>>2]&8|(c>>>0<=f>>>0|b>>>0>f>>>0)){break g}M[a+4>>2]=d+e;a=-8-f&7;b=a+f|0;M[18602]=b;c=M[18599]+e|0;a=c-a|0;M[18599]=a;M[b+4>>2]=a|1;M[(c+f|0)+4>>2]=40;M[18603]=M[18718];break f}a=0;break b}a=0;break c}if(P[18600]>c>>>0){M[18600]=c}d=c+e|0;a=74832;z:{while(1){b=M[a>>2];if((b|0)!=(d|0)){a=M[a+8>>2];if(a){continue}break z}break}if(!(N[a+12|0]&8)){break d}}a=74832;while(1){A:{b=M[a>>2];if(b>>>0<=f>>>0){d=b+M[a+4>>2]|0;if(d>>>0>f>>>0){break A}}a=M[a+8>>2];continue}break}a=e-40|0;b=-8-c&7;h=a-b|0;M[18599]=h;b=b+c|0;M[18602]=b;M[b+4>>2]=h|1;M[(a+c|0)+4>>2]=40;M[18603]=M[18718];a=(d+(39-d&7)|0)-47|0;b=a>>>0<f+16>>>0?f:a;M[b+4>>2]=27;a=M[18711];M[b+16>>2]=M[18710];M[b+20>>2]=a;a=M[18709];M[b+8>>2]=M[18708];M[b+12>>2]=a;M[18710]=b+8;M[18709]=e;M[18708]=c;M[18711]=0;a=b+24|0;while(1){M[a+4>>2]=7;c=a+8|0;a=a+4|0;if(c>>>0<d>>>0){continue}break}if((b|0)==(f|0)){break f}M[b+4>>2]=M[b+4>>2]&-2;c=b-f|0;M[f+4>>2]=c|1;M[b>>2]=c;B:{if(c>>>0<=255){a=(c&-8)+74424|0;b=M[18596];c=1<<(c>>>3);C:{if(!(b&c)){M[18596]=b|c;b=a;break C}b=M[a+8>>2]}M[a+8>>2]=f;M[b+12>>2]=f;d=8;c=12;break B}a=31;if(c>>>0<=16777215){a=V(c>>>8|0);a=((c>>>38-a&1)-(a<<1)|0)+62|0}M[f+28>>2]=a;M[f+16>>2]=0;M[f+20>>2]=0;b=(a<<2)+74688|0;D:{d=M[18597];e=1<<a;E:{if(!(d&e)){M[18597]=d|e;M[b>>2]=f;break E}a=c<<((a|0)!=31?25-(a>>>1|0)|0:0);d=M[b>>2];while(1){b=d;if((c|0)==(M[b+4>>2]&-8)){break D}d=a>>>29|0;a=a<<1;e=(d&4)+b|0;d=M[e+16>>2];if(d){continue}break}M[e+16>>2]=f}M[f+24>>2]=b;b=f;a=b;d=12;c=8;break B}a=M[b+8>>2];M[a+12>>2]=f;M[b+8>>2]=f;M[f+8>>2]=a;a=0;d=12;c=24}M[d+f>>2]=b;M[c+f>>2]=a}a=M[18599];if(a>>>0<=g>>>0){break e}b=a-g|0;M[18599]=b;a=M[18602];c=a+g|0;M[18602]=c;M[c+4>>2]=b|1;M[a+4>>2]=g|3;a=a+8|0;break a}M[18595]=48;a=0;break a}M[a>>2]=c;M[a+4>>2]=M[a+4>>2]+e;i=(-8-c&7)+c|0;M[i+4>>2]=g|3;e=b+(-8-b&7)|0;f=g+i|0;h=e-f|0;F:{if(M[18602]==(e|0)){M[18602]=f;a=M[18599]+h|0;M[18599]=a;M[f+4>>2]=a|1;break F}if(M[18601]==(e|0)){M[18601]=f;a=M[18598]+h|0;M[18598]=a;M[f+4>>2]=a|1;M[a+f>>2]=a;break F}a=M[e+4>>2];if((a&3)==1){j=a&-8;c=M[e+12>>2];G:{if(a>>>0<=255){b=M[e+8>>2];if((b|0)==(c|0)){m=74384,n=M[18596]&cK(-2,a>>>3|0),M[m>>2]=n;break G}M[b+12>>2]=c;M[c+8>>2]=b;break G}g=M[e+24>>2];H:{if((c|0)!=(e|0)){a=M[e+8>>2];M[a+12>>2]=c;M[c+8>>2]=a;break H}I:{a=M[e+20>>2];if(a){b=e+20|0}else{a=M[e+16>>2];if(!a){break I}b=e+16|0}while(1){d=b;c=a;b=a+20|0;a=M[a+20>>2];if(a){continue}b=c+16|0;a=M[c+16>>2];if(a){continue}break}M[d>>2]=0;break H}c=0}if(!g){break G}a=M[e+28>>2];b=(a<<2)+74688|0;J:{if(M[b>>2]==(e|0)){M[b>>2]=c;if(c){break J}m=74388,n=M[18597]&cK(-2,a),M[m>>2]=n;break G}K:{if(M[g+16>>2]==(e|0)){M[g+16>>2]=c;break K}M[g+20>>2]=c}if(!c){break G}}M[c+24>>2]=g;a=M[e+16>>2];if(a){M[c+16>>2]=a;M[a+24>>2]=c}a=M[e+20>>2];if(!a){break G}M[c+20>>2]=a;M[a+24>>2]=c}h=h+j|0;e=e+j|0;a=M[e+4>>2]}M[e+4>>2]=a&-2;M[f+4>>2]=h|1;M[f+h>>2]=h;if(h>>>0<=255){a=(h&-8)+74424|0;b=M[18596];c=1<<(h>>>3);L:{if(!(b&c)){M[18596]=b|c;b=a;break L}b=M[a+8>>2]}M[a+8>>2]=f;M[b+12>>2]=f;M[f+12>>2]=a;M[f+8>>2]=b;break F}c=31;if(h>>>0<=16777215){a=V(h>>>8|0);c=((h>>>38-a&1)-(a<<1)|0)+62|0}M[f+28>>2]=c;M[f+16>>2]=0;M[f+20>>2]=0;a=(c<<2)+74688|0;M:{b=M[18597];d=1<<c;N:{if(!(b&d)){M[18597]=b|d;M[a>>2]=f;break N}c=h<<((c|0)!=31?25-(c>>>1|0)|0:0);b=M[a>>2];while(1){a=b;if((M[a+4>>2]&-8)==(h|0)){break M}b=c>>>29|0;c=c<<1;d=(b&4)+a|0;b=M[d+16>>2];if(b){continue}break}M[d+16>>2]=f}M[f+24>>2]=a;M[f+12>>2]=f;M[f+8>>2]=f;break F}b=M[a+8>>2];M[b+12>>2]=f;M[a+8>>2]=f;M[f+24>>2]=0;M[f+12>>2]=a;M[f+8>>2]=b}a=i+8|0;break a}O:{if(!i){break O}b=M[d+28>>2];c=(b<<2)+74688|0;P:{if(M[c>>2]==(d|0)){M[c>>2]=a;if(a){break P}h=cK(-2,b)&h;M[18597]=h;break O}Q:{if(M[i+16>>2]==(d|0)){M[i+16>>2]=a;break Q}M[i+20>>2]=a}if(!a){break O}}M[a+24>>2]=i;b=M[d+16>>2];if(b){M[a+16>>2]=b;M[b+24>>2]=a}b=M[d+20>>2];if(!b){break O}M[a+20>>2]=b;M[b+24>>2]=a}R:{if(f>>>0<=15){a=f+g|0;M[d+4>>2]=a|3;a=a+d|0;M[a+4>>2]=M[a+4>>2]|1;break R}M[d+4>>2]=g|3;e=d+g|0;M[e+4>>2]=f|1;M[f+e>>2]=f;if(f>>>0<=255){a=(f&-8)+74424|0;b=M[18596];c=1<<(f>>>3);S:{if(!(b&c)){M[18596]=b|c;b=a;break S}b=M[a+8>>2]}M[a+8>>2]=e;M[b+12>>2]=e;M[e+12>>2]=a;M[e+8>>2]=b;break R}a=31;if(f>>>0<=16777215){a=V(f>>>8|0);a=((f>>>38-a&1)-(a<<1)|0)+62|0}M[e+28>>2]=a;M[e+16>>2]=0;M[e+20>>2]=0;b=(a<<2)+74688|0;T:{c=1<<a;U:{if(!(c&h)){M[18597]=c|h;M[b>>2]=e;M[e+24>>2]=b;break U}a=f<<((a|0)!=31?25-(a>>>1|0)|0:0);b=M[b>>2];while(1){c=b;if((M[b+4>>2]&-8)==(f|0)){break T}h=a>>>29|0;a=a<<1;h=b+(h&4)|0;b=M[h+16>>2];if(b){continue}break}M[h+16>>2]=e;M[e+24>>2]=c}M[e+12>>2]=e;M[e+8>>2]=e;break R}a=M[c+8>>2];M[a+12>>2]=e;M[c+8>>2]=e;M[e+24>>2]=0;M[e+12>>2]=c;M[e+8>>2]=a}a=d+8|0;break a}V:{if(!j){break V}b=M[c+28>>2];d=(b<<2)+74688|0;W:{if(M[d>>2]==(c|0)){M[d>>2]=a;if(a){break W}m=74388,n=cK(-2,b)&l,M[m>>2]=n;break V}X:{if(M[j+16>>2]==(c|0)){M[j+16>>2]=a;break X}M[j+20>>2]=a}if(!a){break V}}M[a+24>>2]=j;b=M[c+16>>2];if(b){M[a+16>>2]=b;M[b+24>>2]=a}b=M[c+20>>2];if(!b){break V}M[a+20>>2]=b;M[b+24>>2]=a}Y:{if(f>>>0<=15){a=f+g|0;M[c+4>>2]=a|3;a=a+c|0;M[a+4>>2]=M[a+4>>2]|1;break Y}M[c+4>>2]=g|3;h=c+g|0;M[h+4>>2]=f|1;M[f+h>>2]=f;if(i){a=(i&-8)+74424|0;d=M[18601];b=1<<(i>>>3);Z:{if(!(b&e)){M[18596]=b|e;b=a;break Z}b=M[a+8>>2]}M[a+8>>2]=d;M[b+12>>2]=d;M[d+12>>2]=a;M[d+8>>2]=b}M[18601]=h;M[18598]=f}a=c+8|0}Na=k+16|0;return a|0}function HJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,P=0,Q=0,R=0;i=Na-240|0;Na=i;g=M[a>>2];o=M[g>>2];s=M[b+4>>2];M[b+4>>2]=s|64;q=2;a:{if(N[o+87|0]){break a}if(s&64){q=1;break a}if(O[a+20>>1]){c=M[g+112>>2]+1|0;M[g+112>>2]=c;M[b+16>>2]=c}c=M[b+64>>2];y=M[b+28>>2];x=M[b+32>>2];b:{c:{if(!(!M[g+280>>2]|!(s&2097152))){if(!c){c=ub(o,36,0);M[b+64>>2]=c;if(!c){break a}}M[c+4>>2]=1;break c}if(!c){break b}}if(M[g+40>>2]){break b}M[c+8>>2]=M[g+280>>2];M[g+280>>2]=c}vk(g,x);A=x+8|0;f=A;while(1){d:{e:{f:{g:{h:{i:{j:{k:{if(M[x>>2]>(j|0)){if(M[f+8>>2]){break e}d=M[f>>2];if(!d){if(oc(a,M[M[f+44>>2]>>2])){break a}c=M[M[f+44>>2]>>2];d=ub(M[g>>2],64,0);M[f+8>>2]=d;if(!d){break a}M[d+24>>2]=1;e=M[g>>2];k=M[f+4>>2];l:{if(k){e=_b(e,k);break l}M[i>>2]=f;e=tb(e,19498,i)}M[d>>2]=e;while(1){e=c;c=M[c+52>>2];if(c){continue}break}Nm(g,M[e+28>>2],d+34|0,d+4|0);K[d+43|0]=2;L[d+32>>1]=65535;L[d+38>>1]=200;M[d+28>>2]=M[d+28>>2]|16896;if(!M[g+40>>2]){break g}break a}m:{p=M[g+280>>2];if(M[g+40>>2]|!p|(!(M[f+44>>2]?K[f+15|0]&1:1)|N[f+14|0]&4)){break m}while(1){if(!p){break m}c=0;e=M[p>>2];e=(e|0)>0?e:0;k=p+12|0;n:{o:{while(1){if((c|0)==(e|0)){break o}n=S(c,24);c=c+1|0;n=k+n|0;l=M[n>>2];if(hb(d,l)){continue}break}c=M[n+12>>2];if(!c){break n}M[i+112>>2]=l;cb(g,c,i+112|0);break f}if(M[p+4>>2]){break m}p=M[p+8>>2];continue}break}d=M[g>>2];if(OA(g,f)){break a}l=ub(d,64,0);if(!l){break a}c=M[n+16>>2];if(!c){c=ub(d,20,0);M[n+16>>2]=c;p:{if(c){if(rd(g,52,c)){break p}}ib(d,l);break a}K[c+18|0]=N[n+20|0]}M[f+8>>2]=l;M[l+24>>2]=1;e=_b(d,M[n>>2]);L[l+38>>1]=200;L[l+32>>1]=65535;M[l>>2]=e;M[l+28>>2]=M[l+28>>2]|16896;sh(g,f,M[n+8>>2],1);if(N[d+87|0]){break a}d=M[M[f+44>>2]>>2];M[d+4>>2]=M[d+4>>2]|67108864;e=N[f+13|0]|N[f+14|0]<<8;if(e&2){M[i+96>>2]=M[f+32>>2];cb(g,29833,i+96|0);break a}M[f+36>>2]=c;e=e|512;K[f+13|0]=e;K[f+14|0]=e>>>8;M[c>>2]=M[c>>2]+1;t=-1;c=N[d|0];m=c;k=d;q:{v=(c+121&255)>>>0>1;if(v){break q}while(1){if((m&255)!=(c&255)){break q}c=0;e=M[k+32>>2];h=M[e>>2];h=(h|0)>0?h:0;m=e+8|0;while(1){if((c|0)!=(h|0)){e=m+S(c,48)|0;r=M[e>>2];r:{if(!r){break r}u=N[e+15|0];if(u&2|N[e+13|0]&4|!(M[e+44>>2]?u&1:1)){break r}if(hb(r,M[n>>2])){break r}M[e+8>>2]=l;M[l+24>>2]=M[l+24>>2]+1;r=N[e+13|0]|N[e+14|0]<<8|128;K[e+13|0]=r;K[e+14|0]=r>>>8;r=M[k+4>>2];if(r&8192){break k}M[k+4>>2]=r|8192;if((t|0)<0){t=M[g+44>>2];M[g+44>>2]=t+1}M[e+16>>2]=t}c=c+1|0;continue}break}if(!(N[k+5|0]&32)){break q}c=N[d|0];k=M[k+52>>2];m=N[k|0];continue}}M[n+12>>2]=8609;h=M[g+280>>2];M[g+280>>2]=p;s:{if(N[d+5|0]&32){M[k+64>>2]=M[d+64>>2];c=oc(a,k);M[k+64>>2]=0;if(!c){break s}break d}if(oc(a,d)){break d}}M[g+280>>2]=p;c=d;while(1){e=c;c=M[c+52>>2];if(c){continue}break}e=M[e+28>>2];c=M[n+4>>2];if(!c){c=e;break h}if(!e){break h}e=M[e>>2];k=M[c>>2];if((e|0)==(k|0)){break h}a=M[n>>2];M[i+72>>2]=k;M[i+68>>2]=e;M[i+64>>2]=a;cb(g,5187,i- -64|0);break d}c=mf(g,0,f);M[f+8>>2]=c;if(!c){break a}d=M[c+24>>2];if(d>>>0>=65535){M[i+16>>2]=M[c>>2];cb(g,23387,i+16|0);M[f+8>>2]=0;break a}M[c+24>>2]=d+1;if(N[c+43|0]!=1){if(OA(g,f)){break a}if(!N[c+43|0]){break g}}d=N[a+20|0];if(lf(g,c)){break a}t:{u:{switch(N[c+43|0]-1|0){case 1:if(!(N[o+35|0]&128|M[c+60>>2]==M[M[o+16>>2]+28>>2])){M[i+32>>2]=M[c>>2];cb(g,15644,i+32|0)}sh(g,f,M[c+44>>2],1);break t;case 0:break u;default:break t}}if(!(K[f+14|0]&1)){break t}e=M[c+52>>2];if(!e|N[e+18|0]<=(M[o+32>>2]>>>7&1)>>>0){break t}M[i+48>>2]=M[c>>2];cb(g,29750,i+48|0)}e=O[c+34>>1];L[c+34>>1]=65535;L[a+20>>1]=1;if(N[f+13|0]&4){oc(a,M[M[f+44>>2]>>2])}L[a+20>>1]=d;L[c+34>>1]=e;break g}if(M[g+40>>2]){break f}d=M[b+32>>2];h=d+56|0;k=d+8|0;n=k;a=0;while(1){if((M[d>>2]-1|0)<=(a|0)){u=0;m=M[y>>2];d=(m|0)>0?m:0;B=y+8|0;c=0;while(1){if((c|0)!=(d|0)){a=M[(c<<4)+B>>2];e=N[a|0];v:{if((e|0)!=142){if((e|0)!=180){break v}break j}if(N[M[a+16>>2]]==180){break j}}c=c+1|0;u=M[a+4>>2]|u;continue}break}h=M[b+28>>2];break i}w:{if(!M[n+8>>2]){break w}l=M[h+8>>2];if(!l){break w}x:{y:{e=N[h+12|0];if(e&4){if(M[h+40>>2]|N[h+14|0]&8){break y}j=0;f=0;while(1){if((f|0)<L[l+34>>1]){c=M[l+4>>2]+S(f,12)|0;z:{if(N[c+10|0]&2){break z}p=M[c>>2];if(!tr(d,0,a,p,0,0,1)){break z}c=Jn(g,j,0);j=0;if(!c){break z}j=_b(M[g>>2],p);M[c+(M[c>>2]<<2)>>2]=j;j=c}f=f+1|0;continue}break}if(j){M[h+40>>2]=j;c=N[h+13|0]|N[h+14|0]<<8|10240;K[h+13|0]=c;K[h+14|0]=c>>>8}if(M[g+40>>2]){break f}}q=e&32?1:2;e=M[h+40>>2];if(!(N[h+14|0]&8)){break x}v=a+1|0;r=e+4|0;p=M[g>>2];f=0;while(1){if(M[e>>2]<=(f|0)){break w}A:{c=M[r+(f<<2)>>2];t=Pn(l,c);if((t|0)>=0){if(tr(d,0,a,c,i+236|0,i+232|0,(N[h+13|0]|N[h+14|0]<<8)>>>13&1)){break A}}M[i+128>>2]=c;cb(g,5689,i+128|0);break f}j=M[i+232>>2];m=sr(p,d,M[i+236>>2],j);kk(k+S(M[i+236>>2],48)|0,j);j=0;B:{if(!(N[d+20|0]&64)){break B}while(1){C:{if(tr(d,M[i+236>>2]+1|0,a,c,i+236|0,i+232|0,(N[h+13|0]|N[h+14|0]<<8)>>>13&1)){u=k+S(M[i+236>>2],48)|0;if(N[u+14|0]&8){if((zg(M[u+40>>2],c)|0)>=0){break C}}M[i+144>>2]=c;cb(g,27063,i+144|0)}if(!j){break B}m=Be(g,Wb(g,j,m),50872,0);break B}j=Wb(g,j,m);u=M[i+232>>2];m=sr(p,d,M[i+236>>2],u);kk(k+S(M[i+236>>2],48)|0,u);continue}}j=sr(p,d,v,t);kk(h,t);c=ob(g,54,m,j);if(c){M[c+4>>2]=q|M[c+4>>2];M[c+36>>2]=M[j+28>>2]}Q=b,R=ce(g,M[b+36>>2],c),M[Q+36>>2]=R;f=f+1|0;continue}}M[i+160>>2]=0;cb(g,13492,i+160|0);break f}if(!e){break w}oh(e,M[h+16>>2],q);Q=b,R=ce(g,M[b+36>>2],M[h+40>>2]),M[Q+36>>2]=R;M[h+40>>2]=0;c=N[h+13|0]|N[h+14|0]<<8|4096;K[h+13|0]=c;K[h+14|0]=c>>>8}n=n+48|0;h=h+48|0;a=a+1|0;continue}}M[i+80>>2]=M[n>>2];cb(g,8500,i+80|0);break a}v=s&2048;D=M[M[g>>2]+32>>2]&68;h=0;while(1){D:{if((m|0)>(z|0)){c=(z<<4)+B|0;n=M[c>>2];E=M[n+4>>2];a=0;s=0;f=n;d=N[f|0];if((d|0)!=180){E:{if((d|0)==142){f=M[f+16>>2];if(N[f|0]==180){break E}}h=Wb(g,h,n);if(h){a=(M[h>>2]<<4)+h|0;M[a-4>>2]=M[c+4>>2];d=(N[a+1|0]|N[a+2|0]<<8)&65532|(N[c+9|0]|N[c+10|0]<<8)&3;K[a+1|0]=d;K[a+2|0]=d>>>8;M[c+4>>2]=0}M[c>>2]=0;break D}s=M[M[n+12>>2]+8>>2]}C=M[f+36>>2];e=A;d=0;while(1){F:{G:{H:{I:{f=M[x>>2];if((f|0)<=(d|0)){break I}q=M[e+8>>2];k=M[e+4>>2];if(!k){k=M[q>>2]}if(N[o+87|0]){break I}J:{if(N[e+14|0]&64){r=M[M[M[e+44>>2]>>2]+28>>2];l=0;break J}K:{if(!s){break K}if(!hb(s,k)){break K}d=d+1|0;break F}r=0;j=Mb(o,M[q+60>>2]);l=25106;if((j|0)<0){break J}l=M[M[o+16>>2]+(j<<4)>>2]}m=0;p=d+1|0;if(!(N[e+62|0]&8)|!v|(p|0)>=(f|0)){break H}t=M[e+88>>2];j=t+4|0;c=0;while(1){if(M[t>>2]<=(c|0)){break G}w=M[j+(c<<2)>>2];f=wc(o,60,w);if(!(!f|N[f+4|0]&3)){M[f+36>>2]=C}h=Wb(g,h,f);if(h){f=M[h>>2];M[i+208>>2]=w;f=(f<<4)+h|0;Q=f-4|0,R=tb(o,6435,i+208|0),M[Q>>2]=R;w=(N[f+1|0]|N[f+2|0]<<8)&65404|130;K[f+1|0]=w;K[f+2|0]=w>>>8}c=c+1|0;continue}}if(a){break D}if(s){M[i+224>>2]=s;cb(g,8482,i+224|0);break D}cb(g,16451,0);break D}t=0}c=L[q+34>>1]+(!(N[q+29|0]&2)&(v|0)!=0)|0;w=(c|0)>0?c:0;F=!(s|v)&(d|0)!=0;G=r+12|0;H=d^-1;I=r+8|0;J=r+17|0;while(1){L:{if((m|0)==(w|0)){break L}d=0;M:{N:{if(L[q+34>>1]==(m|0)){while(1){if((d|0)==3){break M}j=M[(d<<2)+50880>>2];c=0;while(1){if((c|0)==(m|0)){break N}f=S(c,12);c=c+1|0;if(hc(j,M[f+M[q+4>>2]>>2])){continue}break}d=d+1|0;continue}}c=M[q+4>>2]+S(m,12)|0;j=M[c>>2];O:{if(!r){break O}d=m<<4;f=d+J|0;if(((N[f|0]|N[f+1|0]<<8)&3)==3){break M}if(!s){break O}if(!WA(d+I|0,0,s,0,0)){break M}}c=O[c+10>>1];if(!(c&2?N[b+6|0]&2:1)){break M}if(!(c&1024)|s){break N}if(!v){break M}}if(!(!F|!(N[e+14|0]&8))){a=1;if((zg(M[e+40>>2],j)|0)>=0){break M}}a=wc(o,60,j);c=M[x>>2];P:{Q:{if((c|0)>=2){if(v|!(N[e+12|0]&64)){break Q}f=c+H|0;d=e;while(1){if((f|0)<=0){break Q}c=d;d=c+48|0;f=f-1|0;if(!(N[c+62|0]&8)){continue}c=M[c+88>>2];if(!c){continue}if((zg(c,j)|0)<0){continue}break}}if(N[g+224|0]<2){break P}}c=wc(o,60,k);a=ob(g,142,c,a);R:{if(N[g+224|0]<2){break R}d=M[n+12>>2];if(!d){break R}kd(g,c,d)}if(!l){break P}a=ob(g,142,wc(o,60,l),a)}if(!(!a|N[a+4|0]&3)){M[a+36>>2]=C}h=Wb(g,h,a);if(!h){a=1;h=0;break L}c=((M[h>>2]<<4)+h|0)-8|0;S:{if(!(!v|N[g+224|0]>1)){T:{if(r){a=_b(o,M[(m<<4)+G>>2]);break T}M[i+200>>2]=j;M[i+196>>2]=k;M[i+192>>2]=l;a=tb(o,6188,i+192|0)}M[c+4>>2]=a;d=(N[c+9|0]|N[c+10|0]<<8)&-4|(L[q+34>>1]==(m|0)?3:2);K[c+9|0]=d;K[c+10|0]=d>>>8;U:{if(N[e+14|0]&8){if((zg(M[e+40>>2],j)|0)>=0){break U}}if(t){if((zg(t,j)|0)>=0){break U}}a=1;if(!(N[(M[q+4>>2]+S(m,12)|0)+11|0]&4)|L[q+34>>1]<=(m|0)){break M}}a=d|256;K[c+9|0]=a;K[c+10|0]=a>>>8;break S}if(!P&(D|0)==4){M[i+180>>2]=j;M[i+176>>2]=k;Q=c,R=tb(o,6429,i+176|0),M[Q+4>>2]=R;a=(N[c+9|0]|N[c+10|0]<<8)&65532;K[c+9|0]=a;K[c+10|0]=a>>>8;break S}Q=c,R=_b(o,j),M[Q+4>>2]=R;a=(N[c+9|0]|N[c+10|0]<<8)&65532;K[c+9|0]=a;K[c+10|0]=a>>>8}a=1}m=m+1|0;continue}break}d=p}e=e+48|0;continue}}xf(o,y);M[b+28>>2]=h;break i}u=u|E;z=z+1|0;m=M[y>>2];continue}}q=0;if(!h){break a}if(M[h>>2]>M[o+128>>2]){cb(g,3328,0);break f}if(!(u&4194312)){break a}M[b+4>>2]=M[b+4>>2]|262144;break a}Nm(g,c,l+34|0,l+4|0);if(!v){M[n+12>>2]=M[d+4>>2]&8192?7701:7447;oc(a,d)}M[n+12>>2]=0;M[g+280>>2]=h}if(!(N[f+13|0]&2)){break e}if(!NA(g,f)){break e}}q=2;break a}f=f+48|0;j=j+1|0;continue}break}M[g+280>>2]=h}Na=i+240|0;return q|0}function Gn(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,P=0,Q=0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0;q=Na-80|0;Na=q;J=M[a>>2];a:{if(M[a+40>>2]){break a}i=wh(a,b);if(!i){break a}W=Mb(M[a>>2],M[i+60>>2]);E=Ai(a,i,130,c,q+40|0);l=M[b>>2]>=2?M[c>>2]:l;P=N[i+43|0];if(lf(a,i)){break a}if(jn(a,i,E)){break a}w=M[a+44>>2];C=w+1|0;M[a+44>>2]=C;if(N[i+28|0]&128){s=qc(i)}g=C;m=w;F=i+8|0;r=F;while(1){j=M[r>>2];if(j){h=g+1|0;M[a+44>>2]=h;m=(j|0)==(s|0)?g:m;X=X+1|0;r=j+20|0;g=h;continue}break}if(f){C=M[f+44>>2];m=M[f+40>>2];M[a+44>>2]=w}M[b+24>>2]=m;r=Ob(J,((L[i+34>>1]+X<<2)+X|0)+6|0,0);if(!r){r=0;break a}R=(L[i+34>>1]<<2)+r|0;n=R+(X<<2)|0;T=n+4|0;p=X+1|0;o=!p;if(!o){D(T,1,p)}g=0;K[p+T|0]=0;h=L[i+34>>1];h=(h|0)>0?h:0;while(1){if((g|0)!=(h|0)){M[(g<<2)+r>>2]=-1;g=g+1|0;continue}break}h=q- -64|0;M[h>>2]=0;M[h+4>>2]=0;M[q+72>>2]=0;M[q+76>>2]=0;M[q+56>>2]=0;M[q+60>>2]=0;M[q+52>>2]=f;M[q+48>>2]=b;M[q+44>>2]=a;M[q+68>>2]=512;k=Cb(a);if(!k){break a}_=c+8|0;u=-1;j=0;while(1){b:{c:{d:{if(M[c>>2]>(j|0)){h=(j<<4)+_|0;y=Uf(M[h+4>>2]);if(!l){if(id(q+44|0,M[h>>2])){break a}}g=0;v=L[i+34>>1];z=(v|0)>0?v:0;while(1){if((g|0)!=(z|0)){e:{t=M[i+4>>2]+S(g,12)|0;if((y|0)!=N[t+7|0]){break e}v=M[t>>2];if(hb(v,M[h+4>>2])){break e}if(L[i+32>>1]==(g|0)){Y=M[h>>2];U=1;u=j;break c}if(!s){h=O[t+10>>1];break d}h=O[t+10>>1];if(!(h&1)){break d}ba=1;break c}g=g+1|0;continue}break}g=M[h+4>>2];f:{if(s){break f}if(!lj(g)){break f}Y=M[h>>2];v=20531;U=1;g=-1;u=j;break b}M[q>>2]=g;cb(a,7984,q);K[a+17|0]=1;break a}$=U+ba|0;g:{if(!(N[i+28|0]&96)){break g}h=0;g=0;while(1){j=h;h:{if(L[i+34>>1]>(g|0)){j=(g<<2)+r|0;if(M[j>>2]>=0){break h}v=M[i+4>>2]+S(g,12)|0;if(!(N[v+10|0]&96)){break h}if(!dn(Tc(i,v),r,U)){break h}M[j>>2]=99999;h=1;break h}h=0;g=0;if(j){continue}break g}g=g+1|0;continue}}h=N[i+43|0]==1;M[b+32>>2]=h?-1:0;M[b+36>>2]=h?-1:0;aa=$&255;G=rk(a,i,r,aa);j=(aa|0)!=0|G>>>0>1;v=n+5|0;y=(e|0)==5;t=(e|0)!=11;while(1){i:{j:{k:{l:{h=M[F>>2];if(h){if(!(j|(h|0)==(s|0))){g=M[h+36>>2];if(!g){break l}if(!dn(g,r,U)){break l}}g=M[a+48>>2]+1|0;M[a+48>>2]=g+O[h+52>>1];break k}M[q+36>>2]=y;h=M[a+48>>2]+1|0;M[a+48>>2]=h;ca=(A<<2)+R|0;M[ca>>2]=h;if(!(o|!y)){D(T,1,p)}if(!N[a+18|0]){L[k+152>>1]=O[k+152>>1]|16}n=0;jd(a,(E|G)!=0,W);j=0;A=0;g=N[i+43|0];if((g|0)!=1){j=M[a+48>>2];n=j+1|0;da=M[ca>>2];m:{if(!(E|ba)){v=n;if(!G){break m}}A=j+2|0;v=L[i+34>>1]+n|0}h=v;j=h+1|0;h=$&255|E|G;p=h?j:v;M[a+48>>2]=p+L[i+34>>1];Q=h?j:n;j=p+1|0}n:{o:{p:{q:{if((P|0)!=2){h=0;W=0;F=0;v=0;if(!l){break q}break o}h=M[a+264>>2];M[a+264>>2]=M[i>>2];F=0;if(l){v=a;break p}Wr(a,i,d,m);v=a}if(id(q+44|0,d)){W=h;break n}g=N[i+43|0];F=1}W=h}if((g&255)==1){j=M[a+8>>2];m=M[a>>2];w=Gd(m,i);f=M[b+24>>2];h=L[i+34>>1];p=M[a+44>>2];M[a+44>>2]=p+1;t=h+2|0;l=$a(j,117,p,t);h=M[a+48>>2];o=h+t|0;M[a+48>>2]=o;u=h+1|0;r:{s:{t:{u:{if(M[b>>2]>=2){v:{if(!(N[i+28|0]&128)){if(Y){s=0;f=qb(m,Y,0);break v}s=0;f=ob(a,76,0,0);break v}s=qc(i);f=L[M[s+4>>2]>>1];h=M[(f<<2)+r>>2];if((h|0)>=0){f=qb(m,M[(h<<4)+_>>2],0);break v}f=cn(a,f)}A=ed(M[a>>2],f);g=0;while(1){if(L[i+34>>1]<=(g|0)){break u}f=M[(g<<2)+r>>2];w:{if((f|0)>=0){h=qb(m,M[(f<<4)+_>>2],0);break w}h=cn(a,g);if(!h){h=0;break w}K[h+2|0]=1}g=g+1|0;A=Wb(a,A,h);continue}}C=o+2|0;M[a+48>>2]=C;n=jf(a,b,d,0,0,0,4,0);if(!n){break n}m=h+3|0;g=0;while(1){if((g|0)<L[i+34>>1]){B=M[(g<<2)+r>>2];x:{if((B|0)>=0){kc(a,M[(B<<4)+_>>2],g+m|0);break x}bb(j,176,f,g,g+m|0);B=M[j+108>>2];if((B|0)<=0){break x}L[(M[j+104>>2]+S(B,20)|0)-18>>1]=1}g=g+1|0;continue}break}y:{if(!(N[i+28|0]&128)){$a(j,135,f,u);h=h+2|0;if(Y){kc(a,Y,h);break y}$a(j,135,f,h);break y}g=L[M[qc(i)+4>>2]>>1];bb(j,176,f,g,u);$a(j,81,g+m|0,h+2|0)}if(N[n+46|0]){break s}f=M[a+132>>2];K[(f?f:a)+20|0]=1;f=o+1|0;bb(j,97,u,t,f);$a(j,127,p,C);bb(j,128,p,f,C);break t}NB(a,p,s,A,b,d);xb(m,A);n=0}if(M[b>>2]==1){Cd(n)}g=0;f=(t|0)>0?t:0;l=fb(j,36,p);while(1)if((f|0)==(g|0)){f=1;break r}else{bb(j,94,p,g,g+u|0);g=g+1|0;continue}}be(j,l);fb(j,122,f);f=0}Ur(a,i);nb(j,7,0,t,u,w,-11);h=M[j+108>>2];if((h|0)>0){L[(M[j+104>>2]+S(h,20)|0)-18>>1]=(e|0)==11?2:e}e=M[a+132>>2];K[(e?e:a)+21|0]=1;if(f){$a(j,39,p,l+1|0);e=M[j+108>>2];M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(l,20)|0)+8>>2]=e;$a(j,122,p,0);break n}Cd(n);break n}t=M[a+60>>2]-1|0;M[a+60>>2]=t;if(!(M[a+136>>2]|!(K[J+36|0]&1)|(N[a+163|0]|(N[a+18|0]|f)))){Z=M[a+48>>2]+1|0;M[a+48>>2]=Z;$a(k,71,0,Z)}z:{A:{B:{C:{D:{E:{F:{G:{if(!(!F|N[i+28|0]&128)){h=0;bb(k,75,0,da,n);x=M[a+44>>2];M[a+44>>2]=x+1;H=bb(k,117,x,0,da);p=0;break G}h=M[a+48>>2];B=s?L[s+50>>1]:0;z=B<<16>>16;o=h+z|0;p=(o+l|0)+1|0;M[a+48>>2]=p;h=h+1|0;if(f){break F}g=0;g=(P|0)==2?L[i+34>>1]:g;x=M[a+44>>2];M[a+44>>2]=x+1;if(s){bb(k,75,0,h,o)}o=(l+z|0)+g|0;H=$a(k,117,x,o);H:{if(!s){break H}g=tk(a,s);if(!g){break H}L[g+8>>1]=o;Jc(k,g,-8)}if(F){break G}NB(a,x,s,c,b,d);m=(P|0)==2?x:m}if(!l){break D}z=B<<16>>16;break E}if(!l){break C}}y=1;g=M[a+132>>2];K[(g?g:a)+20|0]=1;o=0;ea=1;p=h;break z}if(!f){break B}}Dc(a,d,t,16);o=1;break A}g=4;if(!(y|E|($&255|(N[a+18|0]|G))|(N[d+6|0]&64?d:0))){g=12}V=jf(a,b,d,0,0,0,g,C);if(!V){break n}o=1;ea=K[V+48|0]&1;l=M[V+24>>2];I=M[V+20>>2];g=N[V+46|0];if((g|0)==1){break A}o=M[a+132>>2];K[(o?o:a)+20|0]=1;o=2;if((g|0)!=2){o=g;break A}if((l|0)==(m|0)|(l|0)<0){break A}o=N[(l-w|0)+T|0]?0:2}I:{J:{K:{L:{if(N[i+28|0]&128){g=0;z=B<<16>>16;y=(z|0)>0?z:0;while(1){if((g|0)==(y|0)){break L}Ed(k,i,m,L[M[s+4>>2]+(g<<1)>>1],g+h|0);g=g+1|0;continue}}$a(k,135,m,n);if(!o){g=M[a+48>>2]+1|0;M[a+48>>2]=g;M[ca>>2]=g;bb(k,128,x,da,n);break K}if(!H){break I}be(k,H);break I}if(o){y=0;if(!H){break J}be(k,H);break J}nb(k,97,h,z,p,zi(J,s),z);lb(k,138,x,p,h,z)}o=0;break I}p=h;break z}y=0;z=0}H=0;M:{if(f){l=t;break M}if((o|0)!=2&F){Cd(V)}N:{if((P|0)==2){break N}g=0;O:{if(!o){break O}if((I|0)>=0){K[(I-w|0)+T|0]=0}if((l|0)>=0){K[(l-w|0)+T|0]=0}g=0;if((o|0)!=2|(((l^-1)>>31)+X|0)<=0){break O}g=Ub(k,15)}hn(a,i,113,0,w,T,q+32|0,q+28|0);if(!g){break N}gn(k,g)}if(o){if(!((m|0)==(I|0)|(l|0)==(m|0))){lb(k,28,m,t,p,z)}l=t;if((o|0)!=1){l=M[a+60>>2]-1|0;M[a+60>>2]=l}$a(k,51,s?p:n,t);break M}if(!(!s&(y^1))){l=M[a+60>>2]-1|0;M[a+60>>2]=l;$a(k,36,x,t);H=M[k+108>>2];if(y){if((P|0)==2){break M}if(s){g=0;w=B<<16>>16;I=(w|0)>0?w:0;while(1){if((g|0)!=(I|0)){bb(k,94,x,g,g+h|0);g=g+1|0;continue}break}lb(k,28,m,l,h,w);break M}$a(k,135,x,n);bb(k,31,m,l,n);break M}$a(k,134,x,p);lb(k,28,m,l,p,0);break M}$a(k,36,x,t);l=M[a+60>>2]-1|0;M[a+60>>2]=l;H=$a(k,135,x,n);bb(k,31,m,l,n)}if(U){P:{if(F){kc(a,Y,Q);break P}bb(k,94,x,u,Q)}fb(k,13,Q)}Q:{if(!(E|ba|G)){break Q}g=0;if(G){h=MB(a,i)}else{h=g}w=h|Sr(a,E,c,0,3,i,e);I=(w|0)==-1;while(1){R:{S:{if(L[i+34>>1]>(g|0)){h=O[(M[i+4>>2]+S(g,12)|0)+10>>1];u=Pc(i,g<<16>>16)+A|0;T:{if(I){break T}if(g>>>0<=31){if(w>>>g&1|h&1){break T}break S}if(!(h&1)){break S}}Ed(k,i,m,g,u);break R}if(s|U){break Q}$a(k,80,n,Q);break Q}$a(k,75,0,u)}g=g+1|0;continue}}w=B<<16>>16;B=Sr(a,E,c,1,1,i,e);I=(P|0)==2;h=j;g=0;while(1){A=L[i+34>>1];if((g|0)<(A|0)){U:{if(L[i+32>>1]==(g|0)){$a(k,75,0,h);break U}u=O[(M[i+4>>2]+S(g,12)|0)+10>>1];if(u&96){h=(u<<26>>31)+h|0;break U}u=M[(g<<2)+r>>2];if((u|0)>=0){if(y){bb(k,94,x,u+(I?A:w)|0,h);break U}kc(a,M[(u<<4)+_>>2],h);break U}if(B>>>g&1|(!(K[q+40|0]&1)|g>>>0>31)){Ed(k,i,m,g,h);ea=0;break U}$a(k,75,0,h)}h=h+1|0;g=g+1|0;continue}break}if(N[i+28|0]&96){qk(a,j,i)}V:{W:{if(!(K[q+40|0]&1)){break W}Eg(k,i,j);yi(a,E,130,c,1,i,n,e,l);if((P|0)==2){break V}X:{if(s){lb(k,28,m,l,p,z);break X}bb(k,31,m,l,n)}g=0;h=j;while(1){if((g|0)<L[i+34>>1]){u=O[(M[i+4>>2]+S(g,12)|0)+10>>1];Y:{if(u&96){h=(u<<26>>31)+h|0;break Y}if(L[i+32>>1]==(g|0)|M[(g<<2)+r>>2]>=0){break Y}Ed(k,i,m,g,h)}h=h+1|0;g=g+1|0;continue}break}if(!(N[i+28|0]&96)){break W}qk(a,j,i)}if((P|0)==2){break V}h=$&255;LB(a,i,R,m,C,Q,n,h,e&255,l,q+36|0,r,0);Z:{if(!(h|M[q+36>>2])){break Z}if(s){lb(k,28,m,l,p,z);break Z}bb(k,31,m,l,n)}if(G){bn(a,i,n,0,r,aa)}Rr(a,i,m,C,R,-1);if(ea){fb(k,143,m)}if(!(!($&255)&G>>>0<=1)){$a(k,130,m,0)}if(G){bn(a,i,0,Q,r,aa);Qr(a,i,m,C,Q,R,(o|0)==2?6:4,0,0);KB(a,i,c,n,r,aa);break V}Qr(a,i,m,C,Q,R,(o|0)==2?6:4,0,0)}if(Z){$a(k,86,Z,1)}if(E){yi(a,E,130,c,2,i,n,e,l)}_:{$:{switch(o-1|0){case 1:pb(k,l);Cd(V);break _;case 0:break _;default:break $}}pb(k,l);$a(k,39,x,H)}pb(k,t);if(!(N[a+18|0]|(M[a+136>>2]|f))){en(a)}if(!Z){break n}Tr(k,Z,15698)}if(!v){break a}M[v+264>>2]=W;break a}g=0;while(1){if(O[h+50>>1]<=g>>>0){break j}aa:{n=L[M[h+4>>2]+(g<<1)>>1];ba:{if((n|0)>=0){if(M[(n<<2)+r>>2]<0){break ba}break aa}if(dn(M[(M[h+40>>2]+(g<<4)|0)+8>>2],r,U)){break aa}}g=g+1|0;continue}break}g=M[a+48>>2]+1|0;M[a+48>>2]=g+O[h+52>>1];if(t){break k}y=N[h+54|0]==5?1:y}if(g){break i}}g=0;K[v+A|0]=0}M[(A<<2)+R>>2]=g;A=A+1|0;F=h+20|0;continue}}if(!(h&96)){break c}M[q+16>>2]=v;cb(a,29609,q+16|0);break a}M[(g<<2)+r>>2]=j}ca:{switch(gc(a,23,M[i>>2],v,M[M[J+16>>2]+(W<<4)>>2])-1|0){case 1:M[(g<<2)+r>>2]=-1;break;case 0:break a;default:break ca}}j=j+1|0;continue}}eb(J,r);Gc(J,b);xb(J,c);kb(J,d);Na=q+80|0}function xy(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0;h=Na-432|0;Na=h;M[h+424>>2]=0;z=N[M[e>>2]+3|0];M[h+420>>2]=0;B=yb(M[e+4>>2]);i=yb(M[e+8>>2]);a:{b:{k=(d<<2)-8|0;o=Bb(k,0);if(!o){break b}p=!k;if(!p){D(o,0,k)}u=Bb(k,0);if(!u){break b}if(!p){D(u,0,k)}A=B+1|0;y=i+1|0;v=(z|0)!=52;i=0;p=0;r=3;while(1){c:{d:{e:{f:{g:{h:{i:{j:{if(!((d|0)<=(r|0)|i)){j=M[(r<<2)+e>>2];k:{if(M[h+420>>2]){break k}if(yb(j)>>>0<9){break k}if(Eb(j,12928,8)){break k}k=K[j+8|0];if((k|0)<0|N[k+57344|0]){break k}i=dy(c,j+9|0,h+420|0,g);M[h+424>>2]=i;break c}i=j;l:{if(v){break l}while(1){k=N[i|0];if(!k){break l}if((k|0)!=61){i=i+1|0;continue}break}M[h+48>>2]=i+1;k=Hb(8932,h+48|0);if(!k){break j}l=i-j|0;ni(k);i=0;m:{n:{while(1){if((i|0)==8){break n}o:{C=i<<3;if((l|0)==M[C+57284>>2]){if(!Eb(j,M[C+57280>>2],l)){break o}}i=i+1|0;continue}break}p:{switch(i|0){case 0:q:{if((yb(k)|0)!=4){break q}if(Eb(k,23625,4)){break q}E=1;break m}M[h+16>>2]=k;$d(g,7957,h+16|0);E=1;M[h+424>>2]=1;break m;case 1:ab(p);p=k;k=0;break m;case 2:ab(m);m=k;k=0;break m;case 3:ab(w);w=k;k=0;break m;case 4:r:{s:{t:{switch(yb(k)-3|0){case 0:if(Eb(k,17568,3)){break s}break r;case 1:break t;default:break s}}if(!Eb(k,17563,4)){break r}}M[h+32>>2]=k;$d(g,7934,h+32|0);M[h+424>>2]=1}F=(N[k|0]&223)==68;break m;case 5:ab(s);s=k;k=0;break m;case 6:ab(t);t=k;k=0;break m;case 7:break p;default:break n}}M[(x<<2)+u>>2]=k;x=x+1|0;k=0;break m}M[h>>2]=j;$d(g,7907,h);M[h+424>>2]=1}ab(k);i=M[h+424>>2];break c}k=yb(j);M[(n<<2)+o>>2]=j;n=n+1|0;q=(k+q|0)+1|0;i=0;break c}if(!s|i){break f}ab(m);ab(w);if(n){m=0;i=M[h+424>>2];break g}ab(o);M[h+400>>2]=M[e+4>>2];M[h+404>>2]=s;n=0;M[h+428>>2]=0;k=Hb(19755,h+400|0);i=7;u:{if(!k){break u}d=ow(b,k,h+428|0);i=0;if(!d){break u}H=h,I=yg(b),M[H+384>>2]=I;$d(g,8932,h+384|0);i=d}ab(k);o=0;if(i){break h}i=0;m=M[h+428>>2];if(m){n=O[m+144>>1]}k=0;d=0;while(1){if((i|0)!=(n|0)){j=yb(Mm(m,i))+1|0;k=j+k|0;d=j>>>0>k>>>0?d+1|0:d;i=i+1|0;continue}break}i=n<<2;j=i+k|0;d=i>>>0>j>>>0?d+1|0:d;o=Bb(j,d);if(!o){i=7;break i}l=i+o|0;i=0;j=0;while(1){if((j|0)==(n|0)){break i}q=Mm(m,j);d=yb(q)+1|0;if(d){G(l,q,d)}M[(j<<2)+o>>2]=l;j=j+1|0;l=d+l|0;continue}}i=7;M[h+424>>2]=7;break c}cd(m);q=k}M[h+424>>2]=i;m=0;if(!t|i){break g}while(1){v:{w=0;if((m|0)==(n|0)){break v}if(hc(t,M[(m<<2)+o>>2])){m=m+1|0;continue}else{while(1){if(m>>>0<n>>>0){d=(m<<2)+o|0;m=m+1|0;M[d>>2]=M[(m<<2)+o>>2];continue}break}n=n-1|0}}break}m=0;break e}w=0}if(i){break d}}if(!n){M[o>>2]=2836;n=1;q=8}if(!M[h+420>>2]){c=dy(c,14117,h+420|0,g);M[h+424>>2]=c;if(c){break d}}l=1;w:{if(!p){break w}j=N[p|0];if(!j){break w}l=2;i=p;while(1){c=j&255;x:{if((c|0)!=44){if(c){break x}break w}l=l+1|0}j=N[i+1|0];i=i+1|0;continue}}y:{z:{c=S(l,24);v=Bb(c,0);if(!v){r=7;l=0;break z}r=0;if(c){D(v,0,c)}if(!p){break z}j=1;i=p;while(1){if((j|0)>=(l|0)){break z}M[h+428>>2]=0;c=cy(i,h+428|0);if(c){d=c+i|0;c=M[h+428>>2];A:{if(!(c?(c|0)<=1e7:0)){l=l-1|0;break A}M[S(j,24)+v>>2]=c;j=j+1|0}i=d+1|0;continue}break}M[h+424>>2]=1;M[h+368>>2]=p;$d(g,7872,h+368|0);l=0;r=M[h+424>>2];break y}M[h+424>>2]=r}d=0;if(r){break a}k=S(l,24);c=(k+((((y+B|0)+q|0)+n|0)+(n<<2)|0)|0)+297|0;d=Bb(c,0);if(!d){M[h+424>>2]=7;d=0;break a}i=0;if(c){D(d,0,c)}M[d+272>>2]=0;M[d+24>>2]=n;M[d+12>>2]=b;c=d+296|0;M[d+28>>2]=c;b=M[h+420>>2];M[d+268>>2]=1048576;M[d+36>>2]=b;b=(z|0)==52;K[d+238|0]=b&!E;K[d+237|0]=b;K[d+239|0]=F;K[d+236|0]=b;M[d+48>>2]=255;b=c+(n<<2)|0;M[d+264>>2]=b;M[d+44>>2]=t;M[d+40>>2]=s;if(k){G(b,v,k)}M[d+260>>2]=l;c=(l|0)>0?l:0;while(1){b=M[d+264>>2];if((c|0)!=(i|0)){b=b+S(i,24)|0;M[b+8>>2]=0;M[b+12>>2]=0;L[b+4>>1]=257;M[b+16>>2]=0;M[b+20>>2]=0;i=i+1|0;continue}break}b=b+S(l,24)|0;M[d+32>>2]=b;b=b+n|0;M[d+20>>2]=b;if(y){G(b,M[e+8>>2],y)}b=b+y|0;M[d+16>>2]=b;if(A){G(b,M[e+4>>2],A)}e=(n|0)>0?n:0;i=b+A|0;j=0;while(1){if((e|0)==(j|0)){b=0;k=(x|0)>0?x:0;q=0;while(1){if((e|0)==(q|0)){B:{i=0;while(1){if((i|0)==(k|0)){break B}c=M[(i<<2)+u>>2];if(c){M[h+352>>2]=c;$d(g,7984,h+352|0);b=1}i=i+1|0;continue}}}else{i=0;s=q<<2;j=yb(M[s+M[d+28>>2]>>2]);while(1){if((i|0)!=(k|0)){t=(i<<2)+u|0;c=M[t>>2];C:{if(!c){break C}if((yb(c)|0)!=(j|0)){break C}if(Eb(M[s+M[d+28>>2]>>2],c,j)){break C}K[M[d+32>>2]+q|0]=1;ab(c);M[t>>2]=0}i=i+1|0;continue}break}q=q+1|0;continue}break}M[h+424>>2]=b;if(!(!m^(w|0)!=0|b)){M[h+424>>2]=1;M[h+336>>2]=m?4253:4255;$d(g,9027,h+336|0)}i=0;M[h+428>>2]=0;D:{if(!M[d+40>>2]){E:{if(!w){l=0;b=30808;break E}l=by(w);b=l}Ze(h+424|0,h+428|0,15292,0);while(1){if((i|0)<M[d+24>>2]){M[h+72>>2]=M[M[d+28>>2]+(i<<2)>>2];M[h+68>>2]=i;M[h+64>>2]=b;Ze(h+424|0,h+428|0,27496,h- -64|0);i=i+1|0;continue}break}if(M[d+44>>2]){M[h+288>>2]=15274;Ze(h+424|0,h+428|0,19748,h+288|0)}ab(l);break D}Ze(h+424|0,h+428|0,15195,0);while(1){if((i|0)<M[d+24>>2]){M[h+304>>2]=M[M[d+28>>2]+(i<<2)>>2];Ze(h+424|0,h+428|0,28360,h+304|0);i=i+1|0;continue}break}b=M[d+44>>2];if(!b){break D}M[h+320>>2]=b;Ze(h+424|0,h+428|0,19748,h+320|0)}c=M[d+16>>2];j=30808;l=M[d+40>>2];if(l){b=30808}else{l=M[d+20>>2];b=2835}M[h+280>>2]=b;M[h+276>>2]=l;M[h+272>>2]=c;Ze(h+424|0,h+428|0,1634,h+272|0);M[d+224>>2]=M[h+428>>2];i=0;M[h+428>>2]=0;l=0;if(m){l=by(m);j=l}Ze(h+424|0,h+428|0,21953,0);while(1){if((i|0)<M[d+24>>2]){M[h+80>>2]=j;Ze(h+424|0,h+428|0,26491,h+80|0);i=i+1|0;continue}break}if(M[d+44>>2]){Ze(h+424|0,h+428|0,21951,0)}ab(l);M[d+228>>2]=M[h+428>>2];s=0;F:{if(M[h+424>>2]){break F}if(a){i=0;M[h+428>>2]=0;b=M[d+12>>2];if(!M[d+40>>2]){c=M[d+44>>2];j=Hb(18589,0);G:{H:{while(1){if(!j){break H}if(M[d+24>>2]>(i|0)){M[h+248>>2]=M[M[d+28>>2]+(i<<2)>>2];M[h+244>>2]=i;M[h+240>>2]=j;i=i+1|0;j=Hb(28319,h+240|0);continue}break}if(!c){break G}M[h+260>>2]=c;M[h+256>>2]=j;j=Hb(15270,h+256|0);if(j){break G}}M[h+428>>2]=7;j=0}c=M[d+16>>2];e=M[d+20>>2];M[h+232>>2]=j;M[h+224>>2]=c;M[h+228>>2]=e;Me(h+428|0,b,25399,h+224|0);ab(j)}c=M[d+20>>2];M[h+208>>2]=M[d+16>>2];M[h+212>>2]=c;c=h+428|0;Me(c,b,22080,h+208|0);e=M[d+20>>2];M[h+192>>2]=M[d+16>>2];M[h+196>>2]=e;Me(c,b,22297,h+192|0);if(N[d+238|0]){e=M[d+20>>2];M[h+176>>2]=M[d+16>>2];M[h+180>>2]=e;Me(c,b,22152,h+176|0)}if(N[d+237|0]){eq(h+428|0,d)}b=M[h+428>>2];M[h+424>>2]=b;b=!b}else{b=1}if(!((z|0)==52|a)){K[d+237|0]=2}if(b){M[h+160>>2]=M[d+16>>2];a=Hb(12904,h+160|0);I:{if(!a){i=7;break I}i=ow(M[d+12>>2],a,h+428|0);if((i|0)!=23){if(i){break I}b=M[h+428>>2];Db(b);H=d,I=Md(b,0),M[H+244>>2]=I;i=cd(b);break I}M[d+244>>2]=1024;i=0}ab(a);M[h+424>>2]=i;M[d+232>>2]=M[d+244>>2]-35;if(i){break F}a=M[d+44>>2];b=M[d+12>>2];M[h+144>>2]=1;pp(b,1,h+144|0);pp(M[d+12>>2],2,0);M[h+128>>2]=M[M[d+28>>2]>>2];a=a?a:15261;j=Hb(30754,h+128|0);i=1;while(1){if(!(!j|M[d+24>>2]<=(i|0))){M[h+100>>2]=M[M[d+28>>2]+(i<<2)>>2];M[h+96>>2]=j;i=i+1|0;j=Hb(30752,h+96|0);continue}break}b=M[d+20>>2];M[h+120>>2]=a;M[h+116>>2]=b;M[h+112>>2]=j;l=7;a=Hb(26230,h+112|0);if(!(!j|!a)){l=qj(M[d+12>>2],a)}ab(a);ab(j);M[h+424>>2]=l;break F}M[d+232>>2]=M[d+244>>2]-35}t=0;break a}M[h+428>>2]=0;c=j<<2;k=bq(M[c+o>>2],h+428|0);b=M[h+428>>2];if(!((b|0)<=0|!b)){G(i,k,b)}b=b+i|0;K[b|0]=0;ni(i);M[c+M[d+28>>2]>>2]=i;j=j+1|0;i=b+1|0;continue}}v=0;d=0;break a}r=r+1|0;continue}}M[h+424>>2]=7;u=0;p=0;d=0}ab(p);ab(v);ab(m);ab(w);ab(s);ab(t);i=0;a=(x|0)>0?x:0;while(1){if((a|0)!=(i|0)){ab(M[(i<<2)+u>>2]);i=i+1|0;continue}break}ab(o);ab(u);b=M[h+424>>2];J:{if(b){if(d){mq(d);break J}a=M[h+420>>2];if(!a){break J}Ra[M[M[a>>2]+8>>2]](a)|0;break J}M[f>>2]=d}Na=h+432|0;return b}function sg(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=T(0),r=0,s=0,t=0,u=0;h=Na-176|0;Na=h;D(d,0,48);a:{b:{if(!b){if(!bk(a)){break b}o=xz(a,d);break a}o=1;e=M[c>>2];c:{if((N[(O[e+16>>1]&63)+31312|0]-1&255)>>>0<=1){wz(d,Kb(e));break c}g=gb(e);if(!g){break a}i=N[g|0];M[h+88>>2]=h+112;M[h+84>>2]=h+116;M[h+80>>2]=h+168;d:{e=g+((i|0)==45)|0;if((If(e,16659,h+80|0)|0)!=3){break d}f=e+10|0;while(1){e=f;f=e+1|0;l=N[e|0];if(K[l+31408|0]&1|(l|0)==84){continue}break}if(Oq(e,d)){if(N[e|0]){break d}K[d+42|0]=0}L[d+40>>1]=256;e=M[h+168>>2];M[d+8>>2]=(i|0)==45?0-e|0:e;M[d+12>>2]=M[h+116>>2];M[d+16>>2]=M[h+112>>2];Nq(d);if(!M[d+28>>2]){break c}Cc(d);break c}if(!Oq(g,d)){break c}e:{if(!hb(g,1700)){if(bk(a)){break e}}if((Jd(g,h+120|0,jb(g),1)|0)>0){wz(d,R[h+120>>3]);break c}if(hb(g,17944)){if(hb(g,15017)){break b}}if(!bk(a)){break b}K[d+44|0]=N[d+44|0]|4}if(xz(a,d)){break a}}r=(b|0)<=1?1:b;s=d+8|0;t=h+128|0;n=1;while(1){f:{g:{h:{if((n|0)!=(r|0)){e=(n<<2)+c|0;g=gb(M[e>>2]);Fb(M[e>>2]);if(!g){break a}l=N[g|0];e=N[l+31024|0];f=e-43|0;if(f>>>0>14|!(1<<f&32741)){break h}f=1;e=g+1|0;while(1){i:{k=f+g|0;i=N[k|0];j:{if(!i|(i|0)==58|K[i+31408|0]&1){break j}if((i|0)!=45){break i}k:{switch(f-5|0){case 1:M[h+64>>2]=h+116;if((If(e,12841,h- -64|0)|0)==1){break j}break i;case 0:break k;default:break i}}M[h+48>>2]=h+116;if((If(e,12845,h+48|0)|0)!=1){break i}}l:{if((Jd(g,h+168|0,f,1)|0)<=0){break l}m:{if(N[k|0]!=45){e=g;break m}i=1;n:{switch(l-43|0){case 0:case 2:break n;default:break g}}o:{if((f|0)==5){M[h+24>>2]=h+108;M[h+20>>2]=h+112;M[h+16>>2]=h+116;if((If(e,16683,h+16|0)|0)!=3){break l}break o}M[h+40>>2]=h+108;M[h+36>>2]=h+112;M[h+32>>2]=h+116;g=e;if((If(e,16671,h+32|0)|0)!=3){break l}}e=M[h+112>>2];if((e|0)>11){break l}f=M[h+108>>2];if((f|0)>30){break l}cf(d);K[d+40|0]=0;i=M[d+12>>2];k=M[d+8>>2];m=M[h+116>>2];p:{if((l|0)==45){f=0-f|0;M[h+108>>2]=f;k=k-m|0;e=i-e|0;break p}k=k+m|0;e=e+i|0}q:{if((e|0)>0){i=(e-1>>>0)/12|0;break q}i=0-((12-e>>>0)/12|0)|0}M[d+8>>2]=i+k;M[d+12>>2]=e+S(i,-12);Nq(d);Cc(d);i=0;K[d+41|0]=0;K[d+42|0]=0;e=M[d+4>>2];m=M[d>>2];k=ZJ(f,f>>31,864e5,0);f=m+k|0;e=Qa+e|0;M[d>>2]=f;M[d+4>>2]=f>>>0<k>>>0?e+1|0:e;e=N[g+11|0];if(!e){break g}i=1;if(!(K[e+31408|0]&1)){break g}M[h+4>>2]=h+100;M[h>>2]=h+104;f=2;e=g+12|0;if((If(e,14933,h)|0)!=2){break g}}if(N[e+f|0]==58){g=N[e|0];f=h+120|0;D(f,0,48);i=1;if(Oq((g-58>>>0<4294967286)+e|0,f)){break g}Cc(f);e=M[h+120>>2];f=M[h+124>>2];Cc(d);i=0;M[d+28>>2]=0;K[d+41|0]=0;K[d+42|0]=0;k=M[d+4>>2];m=M[d>>2];e=$J(e-432e5|0,f-(e>>>0<432e5)|0,864e5,0);g=(l|0)==45;l=g?0-e|0:e;f=m+l|0;m=k;k=Qa;e=m+(g?0-(k+((e|0)!=0)|0)|0:k)|0;M[d>>2]=f;M[d+4>>2]=f>>>0<l>>>0?e+1|0:e;break g}f=f+g|0;while(1){e=f;f=e+1|0;if(K[N[e|0]+31408|0]&1){continue}break}i=1;g=jb(e);if(g-11>>>0<4294967288){break g}i=N[(e+g|0)-1|0];Cc(d);j=R[h+168>>3];f=0;K[d+43|0]=0;u=j<0?-.5:.5;i=g-((i&223)==83)|0;while(1){r:{if((f|0)==6){i=1}else{g=(f<<4)+52784|0;if((i|0)!=N[g|0]){break r}if(Eb(g+1|0,e,i)){break r}q=Q[g+8>>2];if(!(+T(-q)<j)|!(+q>j)){break r}s:{t:{u:{switch(f-4|0){case 0:cf(d);e=U(j)<2147483647?~~j:-2147483648;f=e+M[d+12>>2]|0;v:{if((f|0)>0){i=(f-1>>>0)/12|0;break v}i=0-((12-f>>>0)/12|0)|0}M[d+12>>2]=S(i,-12)+f;M[d+8>>2]=i+M[d+8>>2];break t;case 1:break u;default:break s}}cf(d);e=U(j)<2147483647?~~j:-2147483648;M[d+8>>2]=e+M[d+8>>2]}Nq(d);K[d+40|0]=0;j=j-+(e|0)}Cc(d);i=M[d>>2];j=j*1e3*+Q[g+12>>2]+u;if(U(j)<0x8000000000000000){f=~~j>>>0;if(U(j)>=1){e=~~(j>0?W(Y(j*2.3283064365386963e-10),4294967295):Z((j-+(~~j>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}}else{f=0;e=-2147483648}e=e+M[d+4>>2]|0;k=f;f=f+i|0;e=k>>>0>f>>>0?e+1|0:e;M[d>>2]=f;M[d+4>>2]=e;i=0}M[d+28>>2]=0;K[d+41|0]=0;K[d+42|0]=0;break g}f=f+1|0;continue}}i=1;break g}f=f+1|0;continue}}Cc(d);if(N[d+44|0]&2){break a}c=M[d+4>>2];if((c|0)==108096&P[d>>2]>275971583|c>>>0>108096){break a}o=0;if(!N[d+41|0]|(b|0)!=1|M[d+16>>2]<29){break a}K[d+41|0]=0;break a}w:{x:{y:{z:{switch(e-97|0){default:switch(e-115|0){case 0:break w;case 2:break y;case 4:break x;default:break a};case 0:if(hb(g,10076)|n>>>0>1){break a}g=N[d+44|0];if(!(N[d+40|0]|!(g&1))){j=R[d+32>>3];if(!(j>=-21086676e4)|!(j<=253402300799)){break f}K[d+42|0]=0;L[d+40>>1]=1;M[d+28>>2]=0;j=j*1e3+21086676e7+.5;if(U(j)<0x8000000000000000){e=~~j>>>0;if(U(j)>=1){f=~~(j>0?W(Y(j*2.3283064365386963e-10),4294967295):Z((j-+(~~j>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}}else{e=0;f=-2147483648}M[d>>2]=e;M[d+4>>2]=f}K[d+44|0]=g&254;break f;case 2:if(hb(g,12612)){break a}Cc(d);K[d+43|0]=0;M[d+28>>2]=0;K[d+41|0]=0;K[d+42|0]=0;break f;case 5:if(hb(g,9220)){break a}Cc(d);K[d+41|0]=0;K[d+42|0]=0;M[d+28>>2]=0;e=M[d>>2];g=M[d+4>>2];f=K[d+43|0];ZJ(f,f>>31,0,864e5);f=Qa;i=f>>31;M[d>>2]=e-f;M[d+4>>2]=g-((e>>>0<f>>>0)+i|0);break f;case 9:if(hb(g,1416)|n>>>0>1|!N[d+40|0]){break a}e=N[d+44|0];if(!(e&1)){break a}K[d+44|0]=e&254;break f;case 1:case 3:case 4:case 6:case 7:case 8:case 10:break a;case 11:break z}}if(hb(g,13963)){break a}if(!bk(a)){break a}i=0;e=N[d+44|0];if(!(e&16)){i=vz(d,a);e=N[d+44|0]}K[d+44|0]=e&231|16;break g}A:{if(hb(g,12474)){break A}e=N[d+44|0];if(!(e&1)){break A}if(n>>>0>1){break a}j=R[d+32>>3]*1e3+21086676e7;if(!(j>=0)|!(j<4642690608e5)){break a}K[d+42|0]=0;L[d+40>>1]=1;M[d+28>>2]=0;K[d+44|0]=e&254;j=j+.5;if(U(j)<0x8000000000000000){e=~~j>>>0;if(U(j)>=1){f=~~(j>0?W(Y(j*2.3283064365386963e-10),4294967295):Z((j-+(~~j>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}}else{e=0;f=-2147483648}M[d>>2]=e;M[d+4>>2]=f;break f}if(hb(g,17559)){break a}if(!bk(a)){break a}if(N[d+44|0]&8){break f}Cc(d);g=0;m=0;e=0;i=M[d+4>>2];p=i;l=M[d>>2];f=l;while(1){D(t,0,40);K[h+160|0]=1;k=f-g|0;g=i-((f>>>0<g>>>0)+m|0)|0;i=g;f=k;M[h+120>>2]=f;M[h+124>>2]=g;g=h+120|0;if(vz(g,a)){break a}Cc(g);k=M[h+120>>2];g=k-l|0;k=M[h+124>>2]-((k>>>0<l>>>0)+p|0)|0;m=k;if(g|k){k=e>>>0<3;e=e+1|0;if(k){continue}}break}D(s,0,40);K[d+44|0]=8;K[d+40|0]=1;M[d>>2]=f;M[d+4>>2]=i;break f}if(Eb(g,30012,8)){break a}e=g+8|0;if((Jd(e,h+168|0,jb(e),1)|0)<=0){break a}j=R[h+168>>3];if(!(j>=0)|!(j<7)){break a}e=U(j)<2147483647?~~j:-2147483648;if(+(e|0)!=j){break a}cf(d);K[d+40|0]=0;M[d+28>>2]=0;Cc(d);K[d+41|0]=0;K[d+42|0]=0;M[d+28>>2]=0;g=e>>31;f=e;e=M[d+4>>2];k=e;i=M[d>>2];l=i+1296e5|0;e=l>>>0<1296e5?e+1|0:e;e=$J(_J(l,e,864e5,0),Qa,7,0);l=Qa;m=(g|0)<=(l|0)&e>>>0>f>>>0|(g|0)<(l|0);p=m?e-7|0:e;f=ZJ(f-p|0,g-((f>>>0<p>>>0)+(m?l-(e>>>0<7)|0:l)|0)|0,864e5,0);e=k+Qa|0;f=f+i|0;e=f>>>0<i>>>0?e+1|0:e;M[d>>2]=f;M[d+4>>2]=e;break f}if(Eb(g,30176,9)){if(hb(g,17944)){if(hb(g,15017)){break a}}K[d+44|0]=N[d+44|0]|4;break f}if(!(N[d+40|0]|N[d+41|0]|N[d+42|0])){break a}ck(d);K[d+42|0]=1;M[d+32>>2]=0;M[d+36>>2]=0;M[d+20>>2]=0;M[d+24>>2]=0;K[d+40|0]=0;M[d+28>>2]=0;K[d+44|0]=N[d+44|0]&254;e=g+9|0;if(!hb(e,12278)){M[d+16>>2]=1;break f}if(!hb(e,9883)){M[d+12>>2]=1;M[d+16>>2]=1;break f}i=(hb(e,1422)|0)!=0}if(i){break a}}n=n+1|0;continue}}o=1}Na=h+176|0;return o}function LB(a,b,c,d,e,f,g,h,i,j,k,l,m){var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,P=0,Q=0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0;G=Na-16|0;Na=G;n=L[b+34>>1];o=M[a+8>>2];z=M[a>>2];p=M[b+28>>2];if(p&128){y=qc(b);H=O[y+50>>1]}else{H=1}a:{if(!(p&2048)){break a}w=(n|0)>0?n:0;p=f+1|0;n=1;while(1){q=n^-1;n=0;while(1){if((n|0)!=(w|0)){v=M[b+4>>2]+S(n,12)|0;r=N[v+4|0]&15;b:{if(!r|L[b+32>>1]==(n|0)){break b}s=O[v+10>>1]&96;x=!s;if(!((x|u)&1)){t=t+1|0;break b}if(!(s|!l)&M[(n<<2)+l>>2]<0){break b}c:{d:{e:{f:{s=(i|0)==11?(r|0)==11?2:r:i;if((s|0)==5){if(!O[v+8>>1]|u&1){break f}r=Pc(b,n<<16>>16)+p|0;s=fb(o,52,r);lk(a,Tc(b,v),r);A=A+1|0;M[(N[M[o>>2]+87|0]?74356:M[o+104>>2]+S(s,20)|0)+8>>2]=M[o+108>>2];break b}if(q&x){break b}D=Pc(b,n<<16>>16)+p|0;switch(s-1|0){case 0:case 2:break d;case 1:break e;default:break c}}D=Pc(b,n<<16>>16)+p|0}r=M[a+132>>2];K[(r?r:a)+21|0]=1;s=2}r=M[b>>2];M[G+4>>2]=M[v>>2];M[G>>2]=r;v=tb(z,6429,G);bb(o,69,1299,s,D);Jc(o,v,-6);v=M[o+108>>2];if((v|0)<=0){break b}L[(M[o+104>>2]+S(v,20)|0)-18>>1]=1;break b}$a(o,51,D,j)}n=n+1|0;continue}break}if((!(t|A)|u)&1){break a}u=1;n=0;if(!(N[b+28|0]&96)|(A|0)<=0){continue}qk(a,p,b);continue}}v=0;p=M[b+16>>2];if(!(!p|N[z+33|0]&2)){M[a+56>>2]=f^-1;s=(i|0)==11?2:i;t=p+8|0;w=f+1|0;n=0;while(1){if((n|0)<M[p>>2]){q=t+(n<<4)|0;r=M[q>>2];g:{if(l){if(!dn(r,l,h)){break g}}if(!J){Eg(o,b,w);J=1}u=M[a+60>>2]-1|0;M[a+60>>2]=u;r=qb(z,r,0);if(!N[z+87|0]){Re(a,r,u,16)}kb(z,r);h:{if((s|0)==4){Xb(o,j);s=4;break h}s=(s|0)==5?2:s;Ii(a,275,s,M[q+4>>2],0,3)}pb(o,u)}n=n+1|0;continue}break}M[a+56>>2]=0}r=b+8|0;l=M[b+8>>2];U=1;i:{j:{if(!m){m=0;break j}if(!M[m>>2]){n=N[m+20|0];i=n?6:4;m=n?m:0;break j}if(!l){break j}while(1){if(l){v=v+1|0;l=M[l+20>>2];continue}break}t=ub(z,S(v,10),0);if(!t){break i}M[m+24>>2]=t;w=t+(v<<3)|0;u=0;l=m;while(1){if(!(!l|!M[l>>2])){p=0;n=r;q=M[l+28>>2];k:{if(!q){break k}while(1){n=M[n>>2];if(!(!n|(n|0)==(q|0))){p=p+1|0;n=n+20|0;continue}break}q=p+w|0;if(N[q|0]){break k}K[q|0]=1;q=t+(u<<3)|0;M[q+4>>2]=p;M[q>>2]=n;u=u+1|0}l=M[l+16>>2];continue}break}U=0;n=0;p=r;while(1){l=M[p>>2];if(l){if(!N[n+w|0]){p=t+(u<<3)|0;M[p+4>>2]=n;M[p>>2]=l;u=u+1|0}n=n+1|0;p=l+20|0;continue}else{l=v}break}v=t}n=M[z+32>>2];l:{if(!(n&24576)){u=0;break l}m:{if(n&8192){F=Ai(a,b,129,0,0);if(F){break m}}F=0;u=0;if(!rk(a,b,0,0)){break l}}B=M[a+48>>2]+1|0;M[a+48>>2]=B;$a(o,71,0,B);u=M[a+60>>2]-1|0;M[a+60>>2]=u}n:{if(!h){t=0;break n}t=0;if(y){break n}p=M[a+60>>2]-1|0;M[a+60>>2]=p;n=i;if((n|0)==11){n=N[b+42|0];n=(n|0)==11?2:n}o:{if(!m){break o}t=an(m,0);if(t){n=N[t+20|0]?6:4}if((m|0)==(t|0)){break o}P=Ub(o,9)}if(!((i|0)==5|(n|0)!=5|(!M[r>>2]|P))){I=Ub(o,9)+1|0}p:{if(!g){break p}bb(o,54,f,p,g);w=M[o+108>>2];if((w|0)<=0){break p}L[(M[o+104>>2]+S(w,20)|0)-18>>1]=144}bb(o,31,d,p,f);q:{r:{s:{switch(n-1|0){default:n=2;case 0:case 1:case 2:Or(a,n,b);break r;case 4:if(B){n=M[a+132>>2];K[(n?n:a)+20|0]=1;fn(a,b,F,d,e,f,1,0,5,1,-1);$a(o,86,B,1);Q=1;n=1;break q}if(!M[r>>2]){Q=1;n=0;break q}Q=1;n=M[a+132>>2];K[(n?n:a)+20|0]=1;Rr(a,b,d,e,0,-1);n=0;break q;case 5:Pz(a,m,b,0,d);break;case 3:break s}}Xb(o,j)}n=0}V=n;pb(o,p);if(!(!m|(m|0)==(t|0))){W=Ub(o,9);break n}if(!I){I=0;break n}aa=Ub(o,9);p=M[o+108>>2];M[(N[M[o>>2]+87|0]?74356:(M[o+104>>2]+S(I,20)|0)-20|0)+8>>2]=p}t:{if(!U){x=M[v+4>>2];p=M[v>>2];break t}x=0;p=l}n=(g|0)!=0;ba=n&(F|0)!=0;ca=P+1|0;da=g+1|0;Z=f^-1;X=f+1|0;ea=!(n&!h);D=0;w=u;while(1){u:{v:{w:{if(p){h=(x<<2)+c|0;if(!M[h>>2]){break u}x:{if(!m){break x}t=an(m,p);if(!P|(t|0)!=(m|0)){break x}M[(N[M[o>>2]+87|0]?74356:M[o+104>>2]+S(P,20)|0)+8>>2]=M[o+108>>2]}E=M[a+60>>2]-1|0;M[a+60>>2]=E;if(!J){Eg(o,b,X);J=1}if(M[p+36>>2]){$a(o,75,0,M[h>>2]);M[a+56>>2]=Z;MA(a,M[p+36>>2],E);M[a+56>>2]=0}C=e+x|0;_=M[h>>2];r=_+1|0;n=0;while(1){q=O[p+52>>1];if(n>>>0<q>>>0){y:{z:{A:{B:{C:{q=O[M[p+4>>2]+(n<<1)>>1];switch(q-65534|0){case 0:break C;case 1:break A;default:break B}}M[a+56>>2]=Z;lk(a,M[(M[p+40>>2]+(n<<4)|0)+8>>2],n+r|0);M[a+56>>2]=0;break y}q=q<<16>>16;if(O[b+32>>1]!=(q&65535)){break z}}$a(o,82,f,n+r|0);break y}$a(o,81,Pc(b,q)+X|0,n+r|0)}n=n+1|0;continue}break}bb(o,97,r,q,M[h>>2]);n=(p|0)!=(y|0);if(!(n|ea)){break v}h=N[p+54|0];if(!h){break v}q=t?N[t+20|0]?6:4:(i|0)==11?(h|0)==11?2:h:i;D:{if(n|M[p+20>>2]|(q|0)!=5|x){break D}h=M[z+32>>2];if(h&8192){if(Ai(a,b,129,0,0)){break D}h=M[z+32>>2]}if(!(h&16384)){break v}if(M[b+48>>2]){break D}if(!Dg(b)){break v}}R=lb(o,27,C,E,r,O[p+50>>1]);h=r;T=(p|0)==(y|0);if(!T){h=vc(a,H)}if(!g&(q|0)!=5){break w}if(!(N[b+28|0]&128)){$a(o,142,C,h);if(!g){break w}bb(o,54,h,E,g);n=M[o+108>>2];if((n|0)<=0){break w}L[(M[o+104>>2]+S(n,20)|0)-18>>1]=144;break w}n=0;E:{if(T){break E}while(1){if(O[y+50>>1]<=n>>>0){break E}bb(o,94,C,We(p,L[M[y+4>>2]+(n<<1)>>1]),h+n|0);n=n+1|0;continue}}if(!g){break w}fa=((N[p+55|0]|N[p+56|0]<<8)&3)==2?r:h;s=O[y+50>>1];A=s+M[o+108>>2]|0;n=0;Y=53;while(1){if((s&65535)>>>0<=n>>>0){break w}s=Li(a,M[M[y+32>>2]+(n<<2)>>2]);$=(O[y+50>>1]-1|0)==(n|0);Y=$?54:Y;A=$?E:A;nb(o,Y,Pc(b,L[M[y+4>>2]+(n<<1)>>1])+da|0,A,n+fa|0,s,-2);s=M[o+108>>2];if((s|0)>0){L[(M[o+104>>2]+S(s,20)|0)-18>>1]=144}n=n+1|0;s=O[y+50>>1];continue}}if(I){Xb(o,I);h=M[o+108>>2];M[(N[M[o>>2]+87|0]?74356:M[o+104>>2]+S(aa,20)|0)+8>>2]=h}if(V){$a(o,17,B,w);F:{if(!y){G:{if(!g){break G}bb(o,54,f,u,g);e=M[o+108>>2];if((e|0)<=0){break G}L[(M[o+104>>2]+S(e,20)|0)-18>>1]=144}bb(o,31,d,u,f);Or(a,2,b);break F}Xb(o,u)}pb(o,w)}H:{if(N[b+28|0]&128){break H}bb(o,97,X,L[b+36>>1],M[(x<<2)+c>>2]);if(J){break H}Eg(o,b,0)}M[k>>2]=Q;break i}I:{J:{switch(q-1|0){case 0:case 1:case 2:pr(a,q,p);break I;case 5:Pz(a,m,b,p,C);case 3:Xb(o,j);break I;default:break J}}n=M[o+108>>2];if(B){q=M[a+132>>2];K[(q?q:a)+20|0]=1;V=V+1|0}K:{if(ba){fb(o,167,d);fn(a,b,F,d,e,h,H<<16>>16,0,5,T,C);fb(o,168,d);break K}fn(a,b,F,d,e,h,H<<16>>16,0,5,T,C)}Q=1;if(!B){break I}$a(o,86,B,1);A=Ub(o,9);pb(o,w);w=M[a+60>>2]-1|0;M[a+60>>2]=w;if(M[p+36>>2]){$a(o,51,_,w)}s=n-R|0;while(1){if((s|0)>0){n=74356;n=N[M[o>>2]+87|0]?n:M[o+104>>2]+S(R,20)|0;q=N[n|0];L:{if((q|0)==142){break L}C=O[n+2>>1];nb(o,q,M[n+4>>2],K[q+35040|0]&1?w:M[n+8>>2],M[n+12>>2],M[n+16>>2],K[n+1|0]);n=M[o+108>>2];if((n|0)<=0){break L}L[(M[o+104>>2]+S(n,20)|0)-18>>1]=C}R=R+1|0;s=s-1|0;continue}break}pr(a,2,p);p=M[o+108>>2];M[(N[M[o>>2]+87|0]?74356:M[o+104>>2]+S(A,20)|0)+8>>2]=p}pb(o,E);if((h|0)!=(r|0)){ad(a,h,H)}if(!t){break u}n=t;if(!W){break u}while(1){n=M[n+16>>2];if(!(!n|!M[n>>2]|!M[n+28>>2])){if(N[n+21|0]){continue}break u}break}Xb(o,ca);M[(N[M[o>>2]+87|0]?74356:M[o+104>>2]+S(W,20)|0)+8>>2]=M[o+108>>2];W=0;break u}pb(o,E)}if(U){l=M[l+20>>2];p=l;x=x+1|0}else{p=0;D=D+1|0;x=D;if((x|0)>=(l|0)){continue}h=(x<<3)+v|0;p=M[h>>2];x=M[h+4>>2]}continue}}Na=G+16|0}function qg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=Na-16|0;Na=k;g=M[a+12>>2];a:{b:{c:{d:{e:{while(1){f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{h=b+g|0;c=N[h|0];switch(c|0){case 0:break a;case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 14:case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:case 33:case 35:case 36:case 37:case 38:case 40:case 41:case 42:break e;case 58:break t;case 9:case 10:case 13:case 32:break u;case 11:case 12:case 47:break g;case 34:break w;case 39:break x;case 43:break r;case 44:break s;case 45:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:break q;case 46:break p;default:break y}}d=c-225|0;if(d>>>0<=14){break v}break k}K[a+37|0]=1;c=N[h|0]}i=c&255;j=b+1|0;c=j;f=7;while(1){z:{d=N[c+g|0];if(!N[d+52896|0]){e=c;break z}e=c+1|0;d=N[g+e|0];if(!N[d+52896|0]){break z}e=c+2|0;d=N[g+e|0];if(!N[d+52896|0]){break z}c=c+3|0;continue}if((d|0)!=(i|0)){A:{if((d|0)==92){h=e+g|0;B:{C:{D:{E:{F:{G:{c=e+1|0;d=N[g+c|0];switch(d-110|0){case 0:case 4:case 6:break E;case 1:case 2:case 3:case 5:case 9:break l;case 7:break F;case 8:break C;case 10:break D;default:break G}}H:{switch(d-10|0){case 1:case 2:break l;case 0:break C;case 3:break B;default:break H}}I:{switch(d-47|0){case 0:break E;case 1:break C;default:break I}}J:{switch(d-98|0){case 0:case 4:break E;case 1:case 2:case 3:break l;default:break J}}if((d|0)==34){break E}if((d|0)==39){break C}if((d|0)==92){break E}if((d|0)!=226|N[h+2|0]!=128){break l}if((N[h+3|0]&254)==168){break C}break l}if(!Gq(h+2|0)){break l}}f=(f&255)==7?8:f;break A}if(!Fq(h+2|0)){break l}}K[a+37|0]=1;f=9;break A}d=e+2|0;e=N[d+g|0];K[a+37|0]=1;c=(e|0)==10?d:c;f=9;break A}K:{if(d<<24>>24<=31){if(!d){M[a+28>>2]=e;break c}K[a+37|0]=1;f=9;break K}f=(d|0)==34?9:f}c=e}c=c+1|0;continue}break}yd(a,f&255,(b^-1)+e|0,g+j|0);c=e+1|0;break a}if(!(1<<d&16391)){break k}break g}b=(Fl(h+1|0,52880)+b|0)+1|0;continue}M[a+28>>2]=b;c=-5;break a}M[a+28>>2]=b;c=-4;break a}K[a+37|0]=1;c=N[h|0]}if(c<<24>>24>48){break n}f=b+1|0;i=f+g|0;d=N[i|0];L:{if((c&255)==48){if(!(!(N[N[h+2|0]+31408|0]&8)|(d|32)!=120)){e=1;K[a+37|0]=1;d=b+3|0;while(1){c=d;d=d+1|0;if(N[N[c+g|0]+31408|0]&8){continue}break}break m}if(d-58>>>0<4294967286){break n}break L}if(d-58>>>0<=4294967285){e=1;if((d|0)==46){break o}if((d|0)!=105&(d|0)!=73){break d}if(Eb(i,12749,3)){break d}K[a+37|0]=1;M:{if(N[h|0]==45){yd(a,5,6,23215);break M}yd(a,5,5,23216)}c=(Eb(h+4|0,1077,5)?4:9)+b|0;break a}if((d|0)!=48){break n}c=N[h+2|0];if(c-58>>>0>=4294967286){break L}if(!(N[N[h+3|0]+31408|0]&8)|(c|32)!=120){break n}e=1;K[a+37|0]=1;d=b+4|0;while(1){c=d;d=d+1|0;if(N[N[c+g|0]+31408|0]&8){continue}break}break m}M[a+28>>2]=f;break c}if(N[h+1|0]-58>>>0<=4294967285){break d}e=3}K[a+37|0]=1}c=b;i=1;while(1){f=e|2;while(1){d=c;c=d+1|0;j=N[g+c|0];if(j-58>>>0>4294967285){continue}if((j|0)==46){d=e&2;e=f;if(!d){continue}break j}break}l=d+g|0;f=K[l|0];if((j&223)==69){if((f|0)<=47){if((f|0)!=46){break j}f=d-1|0;if(f>>>0<b>>>0|N[g+f|0]-58>>>0<4294967286){break j}K[a+37|0]=1;e=e|1}if(!i){break j}N:{O:{f=d+2|0;d=N[f+g|0];switch(d-43|0){case 0:case 2:break O;default:break N}}d=N[l+3|0];c=f}e=e|2;i=0;if((d-58&255)>>>0>245){continue}break j}break}if((f|0)>47){break m}if((f|0)!=46){break j}d=d-1|0;if(d>>>0<b>>>0|N[d+g|0]-58>>>0<4294967286){break j}K[a+37|0]=1;e=e|1}d=a;a=(N[h|0]==43)+b|0;yd(d,e+3&255,c-a|0,a+g|0);break a}M[a+28>>2]=c;break c}if((c|0)==194){break g}P:{Q:{switch(c-91|0){default:R:{switch(c-123|0){default:if((c|0)==102){break P}if((c|0)==110){break f}if((c|0)!=116){break e}if(di(h,13070,4)){break d}c=b+4|0;if(N[N[g+c|0]+31408|0]&6){break d}im(a,1);break a;case 1:break e;case 0:break R;case 2:break i}}h=M[a+4>>2];yd(a,12,M[a+20>>2]-b|0,0);c=O[a+32>>1]+1|0;L[a+32>>1]=c;if((c&65535)>>>0>=1001){break d}i=g+2|0;f=M[a+4>>2];S:{while(1){T:{j=M[a+4>>2];U:{V:{W:{X:{b=b+1|0;d=qg(a,b);if((d|0)<=0){if((d|0)==-2){b=M[a+28>>2];e=4;if((f|0)==M[a+4>>2]){break U}K[a+37|0]=1;break U}c=jm(b+g|0);M[k+12>>2]=7;b=b+c|0;e=g+b|0;c=N[e|0];if(!(N[c+31408|0]&66)){if((c|0)!=92){break X}if(!lz(e+1|0,k+12|0)){break X}}d=b;while(1){c=d;d=d+1|0;l=g+d|0;m=N[l|0];if(N[m+31408|0]&70){if(!jm(l)){continue}}if((m|0)==92){if(lz(c+i|0,k+12|0)){continue}}break}yd(a,N[k+12|0],d-b|0,e);K[a+37|0]=1}c=-1;if(N[a+35|0]){break a}if((N[j+M[a>>2]|0]&15)-11>>>0<=4294967291){break d}b=N[d+g|0];if((b|0)!=58){break W}d=d+1|0;break V}e=1;if((d|0)==-1){break U}M[a+28>>2]=b;break U}Y:{if(!N[b+53232|0]){break Y}while(1){b=d;d=d+1|0;c=N[g+d|0];if(N[c+53232|0]){continue}break}if((c|0)!=58){break Y}d=b+2|0;break V}Z:{_:{c=qg(a,d);switch(c+5|0){case 4:break a;case 0:break Z;default:break _}}M[a+28>>2]=d;break c}d=M[a+28>>2]+1|0}b=qg(a,d);if((b|0)<=0){c=-1;if((b|0)==-1){break a}M[a+28>>2]=d;break a}e=6;d=b+g|0;c=N[d|0];if((c|0)==44){break U}if((c|0)==125){break S}if(N[c+53232|0]){b=(Fl(d+1|0,52880)+b|0)+1|0;c=N[g+b|0];if((c|0)==44){break U}if((c|0)==125){break S}}$:{switch(qg(a,b)+4|0){case 0:break $;case 2:break T;default:break d}}b=M[a+28>>2]}c=-1;switch(e-4|0){case 0:break S;case 2:continue;default:break a}}break}b=M[a+28>>2]}Dq(a,h,M[a+4>>2]-f|0);L[a+32>>1]=O[a+32>>1]-1;c=b+1|0;break a;case 1:break e;case 0:break Q;case 2:break h}}e=M[a+4>>2];yd(a,11,M[a+20>>2]-b|0,0);c=-1;if(N[a+35|0]){break a}d=M[a+4>>2];c=O[a+32>>1]+1|0;L[a+32>>1]=c;if((c&65535)>>>0>=1001){break d}c=b;aa:{while(1){b=c+1|0;c=qg(a,b);if((c|0)<=0){ba:{switch(c+3|0){case 0:c=M[a+28>>2];if((d|0)==M[a+4>>2]){break aa}K[a+37|0]=1;break aa;case 2:break a;default:break ba}}M[a+28>>2]=b;break c}f=c+g|0;b=N[f|0];if((b|0)==44){continue}if((b|0)==93){break aa}if(N[b+53232|0]){c=(Fl(f+1|0,52880)+c|0)+1|0;b=N[g+c|0];if((b|0)==44){continue}if((b|0)==93){break aa}}ca:{switch(qg(a,c)+4|0){case 0:c=M[a+28>>2];continue;case 1:break ca;default:break j}}break}c=M[a+28>>2]}Dq(a,e,M[a+4>>2]-d|0);L[a+32>>1]=O[a+32>>1]-1;c=c+1|0;break a}if(di(h,13603,5)){break d}c=b+5|0;if(N[N[g+c|0]+31408|0]&6){break d}im(a,2);break a}M[a+28>>2]=c;break c}M[a+28>>2]=b;c=-2;break a}M[a+28>>2]=b;c=-3;break a}c=jm(h);if(!c){break d}K[a+37|0]=1;b=b+c|0;continue}break}if(di(h,11727,4)){break e}d=b+4|0;if(!(N[N[d+g|0]+31408|0]&6)){break b}}d=0;while(1){if((d|0)==5){break d}da:{f=(d<<4)+53152|0;if(N[f|0]!=(c|0)&N[f+1|0]!=(c|0)){break da}e=K[f+2|0];if(Eb(h,M[f+8>>2],e)){break da}e=b+e|0;if(N[N[e+g|0]+31408|0]&6){break da}ea:{if(N[f+3|0]==5){yd(a,5,5,23216);break ea}im(a,0)}K[a+37|0]=1;c=e;break a}d=d+1|0;continue}}M[a+28>>2]=b}c=-1;break a}im(a,0);c=d}Na=k+16|0;return c}function Rn(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;k=Na-192|0;Na=k;a:{if(!(c|e)){break a}g=M[a+252>>2];if(!g){break a}m=M[a>>2];b:{c:{d:{if(!e){if(Ln(m,M[g>>2])){M[g+28>>2]=M[g+28>>2]|4096}s=m+177|0;if(!N[m+177|0]){break b}f=M[m+172>>2];if(!N[g+43|0]){break c}if(f){break d}M[g+20>>2]=0;break b}if(N[m+177|0]){break d}s=m+177|0;break b}cb(a,30808,0);break a}M[g+20>>2]=f;if((f|0)!=1){break b}M[g+28>>2]=M[g+28>>2]|1}e:{if(!(d&65536)){break e}M[g+28>>2]=M[g+28>>2]|65536;f=0;while(1){if(L[g+34>>1]<=(f|0)){break e}j=M[g+4>>2]+S(f,12)|0;h=N[j+4|0];if(h>>>0<=15){b=M[j>>2];c=M[g>>2];if(N[j+10|0]&4){w=k,x=pl(j,30808),M[w+152>>2]=x;M[k+148>>2]=b;M[k+144>>2]=c;cb(a,29853,k+144|0);break a}M[k+132>>2]=b;M[k+128>>2]=c;cb(a,6197,k+128|0);break a}if((h&240)==16){K[j+5|0]=65}if(!(!(K[j+10|0]&1)|(h&15|L[g+32>>1]==(f|0)))){K[j+4|0]=h|2;M[g+28>>2]=M[g+28>>2]|2048}f=f+1|0;continue}}f:{if(!(d&128)){break f}f=M[g+28>>2];if(f&8){cb(a,5753,0);break a}if(!(f&4)){M[k+112>>2]=M[g>>2];cb(a,7018,k+112|0);break a}M[g+28>>2]=f|640;j=M[a+8>>2];o=M[a>>2];if(!(N[o+178|0]&2)){f=0;while(1){if((f|0)<L[g+34>>1]){h=M[g+4>>2]+S(f,12)|0;g:{if(!(K[h+10|0]&1)){break g}i=N[h+4|0];if(i&15){break g}K[h+4|0]=i|2}f=f+1|0;continue}break}M[g+28>>2]=M[g+28>>2]|2048}f=M[a+148>>2];if(f){M[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(f,20)|0)+12>>2]=2}f=L[g+32>>1];h:{if((f|0)>=0){f=M[M[g+4>>2]+S(f,12)>>2];M[k+164>>2]=f;w=k,x=jb(f),M[w+168>>2]=x;f=Ec(o,60,k+164|0,0);i:{f=ed(M[a>>2],f);if(f){if(N[a+224|0]>=2){kd(a,M[f+8>>2],g+32|0)}K[f+16|0]=N[a+222|0];L[g+32>>1]=65535;Ni(a,0,0,0,f,N[g+42|0],0,0,0,0,2);if(!M[a+40>>2]){break i}}M[g+28>>2]=M[g+28>>2]&-129;break f}h=qc(g);break h}h=qc(g);f=1;i=1;while(1){if(f>>>0<O[h+50>>1]){j:{if(yk(h,i,h,f)){L[h+52>>1]=O[h+52>>1]-1;break j}l=M[h+32>>2];M[l+(i<<2)>>2]=M[l+(f<<2)>>2];l=M[h+28>>2];K[l+i|0]=N[f+l|0];l=M[h+4>>2];L[l+(i<<1)>>1]=O[l+(f<<1)>>1];i=i+1|0}f=f+1|0;continue}break}L[h+50>>1]=i}f=N[h+55|0]|N[h+56|0]<<8;i=f|32;K[h+55|0]=i;K[h+56|0]=i>>>8;if(!(N[o+178|0]&2)){f=f|40;K[h+55|0]=f;K[h+56|0]=f>>>8}l=O[h+50>>1];L[h+52>>1]=l;k:{if(!j){break k}f=M[h+44>>2];if(!f){break k}K[(N[M[j>>2]+87|0]?74356:M[j+104>>2]+S(f,20)|0)|0]=9}M[h+44>>2]=M[g+20>>2];f=g+8|0;while(1){l:{m:{f=M[f>>2];if(!f){f=0;j=L[g+34>>1];i=(j|0)>0?j:0;j=0;while(1){if((f|0)==(i|0)){break m}if(!zs(M[h+4>>2],l,f)){j=!(N[(M[g+4>>2]+S(f,12)|0)+10|0]&32)+j|0}f=f+1|0;continue}}if(((N[f+55|0]|N[f+56|0]<<8)&3)==2){break l}i=0;j=0;while(1){if((i|0)!=(l|0)){j=(yk(f,O[f+50>>1],h,i)^1)+j|0;i=i+1|0;continue}break}i=O[f+50>>1];if(!j){L[f+52>>1]=i;break l}if(ys(o,f,i+j|0)){break f}j=O[f+50>>1];i=0;while(1){if((i|0)==(l|0)){break l}if(!yk(f,O[f+50>>1],h,i)){L[M[f+4>>2]+(j<<1)>>1]=O[M[h+4>>2]+(i<<1)>>1];M[M[f+32>>2]+(j<<2)>>2]=M[M[h+32>>2]+(i<<2)>>2];if(N[M[h+28>>2]+i|0]){n=N[f+55|0]|N[f+56|0]<<8|1024;K[f+55|0]=n;K[f+56|0]=n>>>8}j=j+1|0}i=i+1|0;continue}}if(ys(o,h,j+l|0)){break f}f=0;while(1){if((f|0)<L[g+34>>1]){j=M[h+4>>2];if(!(zs(j,l,f)|N[(M[g+4>>2]+S(f,12)|0)+10|0]&32)){L[j+(l<<1)>>1]=f;M[M[h+32>>2]+(l<<2)>>2]=33696;l=l+1|0}f=f+1|0;continue}break}xs(h);break f}f=f+20|0;continue}}o=Mb(m,M[g+60>>2]);f=M[g+16>>2];n:{if(!f){break n}Ji(a,g,4,0,f);if(!M[a+40>>2]){break n}xb(m,M[g+16>>2]);M[g+16>>2]=0}o:{if(!(N[g+28|0]&96)){f=L[g+34>>1];break o}j=0;i=0;while(1){f=L[g+34>>1];if((f|0)>(i|0)){f=S(i,12);h=f+M[g+4>>2]|0;p:{if(N[h+10|0]&96){if(!Ji(a,g,8,Tc(g,h),0)){break p}Cn(a,g,f+M[g+4>>2]|0,Ec(m,122,0,0));break p}j=j+1|0}i=i+1|0;continue}break}if(j){break o}cb(a,11115,0);break a}i=M[g+4>>2];h=0;while(1){if((f|0)>0){f=f-1|0;h=N[i+6|0]+h|0;i=i+12|0;continue}break}w=g,x=Td((O[g+32>>1]>>>15|0)+h<<2,0),L[w+40>>1]=x;f=g+8|0;while(1){f=M[f>>2];if(f){ws(f);f=f+20|0;continue}break}q:{if(!N[s|0]){l=Cb(a);if(!l){break a}fb(l,122,0);t=N[g+43|0];r:{if(e){if(N[a+224|0]){M[a+12>>2]=1;M[a+40>>2]=M[a+40>>2]+1;break a}f=M[a+44>>2];M[a+44>>2]=f+1;h=M[a+48>>2];i=h+3|0;M[a+48>>2]=i;d=M[a+132>>2];K[(d?d:a)+21|0]=1;bb(l,113,f,M[a+104>>2],o);j=M[l+108>>2];if((j|0)>0){L[(M[l+104>>2]+S(j,20)|0)-18>>1]=16}n=h+1|0;bb(l,11,n,0,j+1|0);if(M[a+40>>2]){break a}d=Bn(a,e,65);if(!d){break a}p=O[d+34>>1];L[g+34>>1]=p;L[g+36>>1]=p;M[g+4>>2]=M[d+4>>2];M[d+4>>2]=0;L[d+34>>1]=0;Id(m,d);M[k+180>>2]=0;M[k+184>>2]=0;M[k+172>>2]=0;M[k+176>>2]=0;M[k+168>>2]=n;K[k+164|0]=13;Rc(a,e,k+164|0);if(M[a+40>>2]){break a}rh(l,n);n=M[l+108>>2];M[(N[M[l>>2]+87|0]?74356:M[l+104>>2]+S(j,20)|0)+8>>2]=n;j=fb(l,12,M[k+168>>2]);h=h+2|0;bb(l,97,M[k+176>>2],M[k+180>>2],h);d=0;Eg(l,g,0);$a(l,127,f,i);bb(l,128,f,h,i);Xb(l,j);h=M[l+108>>2];M[(N[M[l>>2]+87|0]?74356:M[l+104>>2]+S(j,20)|0)+8>>2]=h;fb(l,122,f);f=L[g+34>>1];j=(f|0)>0?f:0;h=M[g+4>>2];i=0;while(1){if((i|0)!=(j|0)){i=i+1|0;d=(vs(M[h>>2])+d|0)+5|0;h=h+12|0;continue}break}d=vs(M[g>>2])+d|0;p=(d+S(f,6)|0)+35|0;q=lc(p,p>>31);if(!q){Lb(m);break r}d=(d|0)<50;v=d?27767:27766;j=d?25073:30774;n=vd(p,q,30623,0);w=k,x=jb(n),M[w+164>>2]=x;us(n,k+164|0,M[g>>2]);h=M[k+164>>2];K[h+n|0]=40;f=d?30808:30775;i=h+1|0;h=M[g+4>>2];d=0;while(1){r=i+n|0;u=p-i|0;if((d|0)<L[g+34>>1]){w=k,x=jb(vd(u,r,f,0))+i|0,M[w+164>>2]=x;us(n,k+164|0,M[h>>2]);f=M[k+164>>2];r=M[(K[h+5|0]<<2)+50636>>2];i=jb(r);if(i){G(f+n|0,r,i)}i=f+i|0;M[k+164>>2]=i;h=h+12|0;d=d+1|0;f=j;continue}break}M[k+96>>2]=v;vd(u,r,8932,k+96|0);break r}d=d?a+212|0:c;f=M[d>>2];j=M[a+204>>2];i=f-j|0;i=N[f|0]!=59?M[d+4>>2]+i|0:i;M[k+88>>2]=j;M[k+84>>2]=i;M[k+80>>2]=t?18812:20469;q=tb(m,6006,k+80|0)}f=M[M[m+16>>2]+(o<<4)>>2];d=M[g>>2];j=M[a+104>>2];M[k+72>>2]=M[a+100>>2];M[k+68>>2]=q;M[k- -64>>2]=j;M[k+60>>2]=d;M[k+56>>2]=d;M[k+52>>2]=t?1856:14426;M[k+48>>2]=f;sc(a,16894,k+48|0);eb(m,q);Sf(a,o);s:{if(N[a+224|0]|!(N[g+28|0]&8)){break s}d=M[m+16>>2]+(o<<4)|0;if(M[M[d+12>>2]+72>>2]){break s}M[k+32>>2]=M[d>>2];sc(a,25474,k+32|0)}M[k+16>>2]=M[g>>2];uh(l,o,tb(m,28278,k+16|0),0);if(N[g+28|0]&96){d=M[M[m+16>>2]+(o<<4)>>2];M[k+4>>2]=M[g>>2];M[k>>2]=d;nb(l,148,1,0,0,tb(m,29273,k),-6)}if(!N[s|0]){break q}}if(wd(M[g+60>>2]+8|0,M[g>>2],g)){Lb(m);break a}M[a+252>>2]=0;M[m+24>>2]=M[m+24>>2]|1;if(Wc(M[g>>2],14816)){break q}M[M[g+60>>2]+72>>2]=g}if(N[g+43|0]|e){break a}M[g+44>>2]=(M[(M[b>>2]?b:c)>>2]-M[a+204>>2]|0)+13}Na=k+192|0}function Ni(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;m=Na-224|0;Na=m;o=M[a>>2];M[m+168>>2]=0;M[m+164>>2]=0;a:{if(M[a+40>>2]|N[a+224|0]==1&(k|0)!=2){break a}if(de(a)){break a}if(Fk(a,e)){break a}b:{c:{d:{if(d){b=Tf(a,b,c,m+168|0);if((b|0)<0){break a}e:{if(N[o+177|0]){break e}n=wh(a,d);if(M[c+4>>2]|!n){break e}b=M[n+60>>2]==M[M[o+16>>2]+28>>2]?1:b}c=M[a>>2];M[m+172>>2]=a;c=M[c+16>>2]+(b<<4)|0;M[m+212>>2]=M[c>>2];M[m+204>>2]=M[c+12>>2];M[m+176>>2]=a;M[m+180>>2]=11;M[m+184>>2]=12;M[m+188>>2]=13;M[m+192>>2]=0;L[m+196>>1]=0;K[m+208|0]=(b|0)==1;M[m+216>>2]=1581;u=M[m+168>>2];M[m+220>>2]=u;c=m+172|0;M[m+200>>2]=c;Mn(c,d);c=mf(a,0,d+8|0);if(!c){break a}if(!(M[M[o+16>>2]+28>>2]==M[c+60>>2]|(b|0)!=1)){M[m+144>>2]=M[c>>2];cb(a,29783,m+144|0);break c}r=0;if(!(N[c+28|0]&128)){break d}r=qc(c);break d}c=M[a+252>>2];if(!c){break a}b=Mb(o,M[c+60>>2]);r=0}n=M[o+16>>2];l=M[c>>2];if(!(Eb(l,18301,7)|!d|N[o+177|0])){M[m>>2]=l;cb(a,15477,m);break c}f:{switch(N[c+43|0]-1|0){case 1:cb(a,15418,0);break b;case 0:cb(a,15443,0);break b;default:break f}}n=(b<<4)+n|0;g:{h:{i:{if(u){p=zc(o,u);if(!p){break c}if(Gk(a,p,1581,M[c>>2])){break b}if(N[a+224|0]>1){break g}j:{if(N[o+177|0]){break j}if(!Hc(o,p,M[n>>2])){break j}M[m+128>>2]=p;cb(a,7241,m+128|0);break b}if(!nf(o,p,M[n>>2])){break i}if(!j){M[m+112>>2]=p;cb(a,3752,m+112|0);break b}ud(a,b);Ek(a);break b}p=c+8|0;j=1;while(1){p=M[p>>2];if(p){j=j+1|0;p=p+20|0;continue}break}M[m+100>>2]=j;M[m+96>>2]=l;p=tb(o,16718,m+96|0);if(!p){break c}if(!N[a+224|0]){break h}K[p+7|0]=N[p+7|0]+1}if(N[a+224|0]>1){break g}}j=(b|0)==1;l=M[n>>2];if(gc(a,18,j?9290:9309,0,l)){break b}if(gc(a,j?3:1,p,M[c>>2],l)){break b}}k:{if(!e){e=M[c+4>>2]+S(L[c+34>>1],12)|0;j=e-2|0;L[j>>1]=O[j>>1]|8;e=M[e-12>>2];M[m+156>>2]=e;v=m,w=jb(e),M[v+160>>2]=w;e=Ec(o,60,m+156|0,0);e=ed(M[a>>2],e);if(e){K[(M[e>>2]<<4)+e|0]=(i|0)!=-1?i:0;break k}e=0;break b}Ps(a,e,1581);if(M[a+40>>2]){break b}}l=M[e>>2];s=(l|0)>0?l:0;j=e+8|0;i=0;while(1){if((i|0)!=(s|0)){t=M[(i<<4)+j>>2];if(N[t|0]==114){q=(jb(M[t+8>>2])+q|0)+1|0}i=i+1|0;continue}break}i=jb(p);l=qs(o,l+(r?O[r+50>>1]:1)<<16>>16,(i+q|0)+1|0,m+164|0);l:{m:{if(!N[o+87|0]){q=M[m+164>>2];M[l>>2]=q;s=i+1|0;i=s+q|0;M[m+164>>2]=i;if(s){G(q,p,s)}K[l+54|0]=f;M[l+12>>2]=c;q=(N[l+55|0]|N[l+56|0]<<8)&65524|((f?8:0)|k);K[l+55|0]=q;K[l+56|0]=q>>>8;M[l+24>>2]=M[(M[o+16>>2]+(b<<4)|0)+12>>2];L[l+50>>1]=M[e>>2];if(h){Ji(a,c,2,h,0);M[l+36>>2]=h}h=N[M[n+12>>2]+76|0];if(N[a+224|0]>=2){M[l+40>>2]=e;e=0}s=h>>>0>3;h=0;while(1){if(O[l+50>>1]>h>>>0){rs(M[j>>2]);Ji(a,c,32,M[j>>2],0);n:{if(!M[a+40>>2]){n=Rf(M[j>>2]);o:{if(N[n|0]!=168){if(M[a+252>>2]==(c|0)){M[m+164>>2]=i;cb(a,3903,0);h=0;break l}if(!M[l+40>>2]){M[l+40>>2]=e;e=0}L[M[l+4>>2]+(h<<1)>>1]=65534;n=(N[l+55|0]|N[l+56|0]<<8)&61431|4096;K[l+55|0]=n;K[l+56|0]=n>>>8;q=-2;break o}q=L[n+32>>1];p:{if((q|0)<0){q=L[c+32>>1];break p}n=M[c+4>>2];t=S(q,12);if(!(N[(n+t|0)+4|0]&15)){n=(N[l+55|0]|N[l+56|0]<<8)&65527;K[l+55|0]=n;K[l+56|0]=n>>>8;n=M[c+4>>2]}if(!(N[(n+t|0)+10|0]&32)){break p}n=N[l+55|0]|N[l+56|0]<<8|6144;K[l+55|0]=n;K[l+56|0]=n>>>8}L[M[l+4>>2]+(h<<1)>>1]=q}n=M[j>>2];q:{if(N[n|0]==114){q=M[n+8>>2];n=jb(q)+1|0;if(n){G(i,q,n)}n=i+n|0;break q}if((q|0)<0){n=i;i=0;break q}n=i;i=eg(M[c+4>>2]+S(q,12)|0)}i=i?i:33696;if(N[o+177|0]){break n}if(Li(a,i)){break n}i=n}M[m+164>>2]=i;break m}M[M[l+32>>2]+(h<<2)>>2]=i;K[M[l+28>>2]+h|0]=s?N[j+8|0]:0;j=j+16|0;h=h+1|0;i=n;continue}break}M[m+164>>2]=i;r:{if(r){j=0;while(1){if(O[r+50>>1]<=j>>>0){break r}s:{if(yk(l,O[l+50>>1],r,j)){L[l+52>>1]=O[l+52>>1]-1;break s}L[M[l+4>>2]+(h<<1)>>1]=O[M[r+4>>2]+(j<<1)>>1];M[M[l+32>>2]+(h<<2)>>2]=M[M[r+32>>2]+(j<<2)>>2];K[M[l+28>>2]+h|0]=N[M[r+28>>2]+j|0];h=h+1|0}j=j+1|0;continue}}L[M[l+4>>2]+(h<<1)>>1]=65535;M[M[l+32>>2]+(h<<2)>>2]=33696}Kt(l);if(!M[a+252>>2]){ws(l)}xs(l);t:{if(!d|O[l+52>>1]<L[c+34>>1]){break t}i=N[l+55|0]|N[l+56|0]<<8;h=i|32;K[l+55|0]=h;K[l+56|0]=h>>>8;h=0;j=L[c+34>>1];j=(j|0)>0?j:0;while(1){if((h|0)==(j|0)){break t}u:{if(L[c+32>>1]==(h|0)){break u}if((We(l,h<<16>>16)|0)>=0){break u}h=i&65503;K[l+55|0]=h;K[l+56|0]=h>>>8;break t}h=h+1|0;continue}}v:{w:{x:{y:{if(M[a+252>>2]!=(c|0)){break y}h=c+8|0;while(1){i=M[h>>2];if(!i){break y}z:{n=O[i+50>>1];A:{if((n|0)!=O[l+50>>1]){break A}h=0;while(1){if((h|0)==(n|0)){break z}j=h<<1;if(O[j+M[i+4>>2]>>1]!=O[j+M[l+4>>2]>>1]){break A}j=h<<2;h=h+1|0;if(!hb(M[j+M[i+32>>2]>>2],M[j+M[l+32>>2]>>2])){continue}break}}h=i+20|0;continue}break}b=N[i+54|0];f=N[l+54|0];B:{if((b|0)==(f|0)){break B}if(!((b|0)==11|(f|0)==11)){M[m+80>>2]=0;cb(a,16409,m+80|0);b=N[i+54|0]}if((b&255)!=11){break B}K[i+54|0]=N[l+54|0]}if((k|0)==2){b=(N[i+55|0]|N[i+56|0]<<8)&65532|2;K[i+55|0]=b;K[i+56|0]=b>>>8}h=0;if(N[a+224|0]<2){break l}M[l+20>>2]=M[a+256>>2];break x}C:{if(N[a+224|0]>1){break C}if(N[o+177|0]){D:{if(!d){break D}M[l+44>>2]=M[o+172>>2];if(!Lt(l)){break D}cb(a,14654,0);v=a,w=db(126495),M[v+12>>2]=w;h=0;break l}if(wd(M[l+24>>2]+24|0,M[l>>2],l)){Lb(o);break m}M[o+24>>2]=M[o+24>>2]|1;break C}if(!(M[c+28>>2]&128?d:1)){break C}i=M[a+48>>2]+1|0;M[a+48>>2]=i;h=Cb(a);if(!h){break v}jd(a,1,b);v=l,w=Ub(h,187),M[v+44>>2]=w;bb(h,147,b,i,2);if(g){g=M[a+212>>2];j=M[a+216>>2];k=N[(g+j|0)-1|0];n=M[u>>2];M[m+72>>2]=n;M[m+64>>2]=f?20386:30808;M[m+68>>2]=(j+(g-n|0)|0)-((k|0)==59);f=tb(o,6021,m- -64|0)}else{f=0}g=M[M[o+16>>2]+(b<<4)>>2];j=M[l>>2];k=M[c>>2];M[m+48>>2]=f;M[m+44>>2]=i;M[m+40>>2]=k;M[m+36>>2]=j;M[m+32>>2]=g;sc(a,22021,m+32|0);eb(o,f);if(d){xn(a,l,i);Sf(a,b);M[m+16>>2]=M[l>>2];uh(h,b,tb(o,27904,m+16|0),0);$a(h,166,0,1)}f=M[h+108>>2];M[(N[M[h>>2]+87|0]?74356:M[h+104>>2]+S(M[l+44>>2],20)|0)+8>>2]=f}if(!(N[o+177|0]?0:d)){M[l+20>>2]=M[c+8>>2];M[c+8>>2]=l;break w}if(N[a+224|0]<2){break v}}M[a+256>>2]=l}h=0;break b}h=0}if(l){break l}break b}h=0}Xk(o,l);break b}p=0}c=c+8|0;while(1){b=c;f=M[c>>2];if(!f){break a}c=f+20|0;if(N[f+54|0]!=5){continue}break}while(1){a=M[c>>2];if(!a|N[a+54|0]==5){break a}M[b>>2]=a;M[f+20>>2]=M[a+20>>2];M[a+20>>2]=f;b=a+20|0;continue}}kb(o,h);xb(o,e);Gc(o,d);eb(o,p);Na=m+224|0}function Db(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;d=Na-224|0;Na=d;a:{if(ms(a)){e=_c(91561);break a}w=a+104|0;s=a+136|0;n=M[a>>2];h=n;while(1){b:{c:{e=N[a+151|0];if((e|0)==2){break c}while(1){d:{switch((e&255)-1|0){case 0:if(N[a+152|0]&3){M[a+36>>2]=17;e=1;if(K[a+150|0]>=0){break b}e=un(a);break b}e=M[h+184>>2];if(!e){M[h+296>>2]=0}if(!(!M[a+200>>2]|(N[h+177|0]|!(N[h+94|0]&130)))){tn(M[h>>2],s);e=M[h+184>>2]}M[h+184>>2]=e+1;c=O[a+152>>1];if(!(c&64)){M[h+192>>2]=M[h+192>>2]+1;c=O[a+152>>1]}if(c&128){M[h+188>>2]=M[h+188>>2]+1}K[a+151|0]=2;M[a+32>>2]=0;break c;case 2:break d;default:break c}}wb(a);e=N[a+151|0];continue}}e:{f:{g:{h:{c=O[a+152>>1]&12;if(c){j=M[a+88>>2];q=j+40|0;o=M[a>>2];b=1;b=(c|0)!=4?K[o+35|0]&1:b;pi(q,8);if(M[a+36>>2]==7){Lb(o);e=1;break e}f=0;i=0;g=O[a+152>>1]&12;p=M[a+108>>2];i=b?M[a+88>>2]+360|0:i;if(!i){l=0;break h}e=0;l=0;if(N[i+16|0]&16){l=M[i+8>>2];f=M[i+12>>2]>>>2|0}while(1){if((e|0)==(f|0)){break h}p=M[M[(e<<2)+l>>2]+4>>2]+p|0;e=e+1|0;continue}}M[h+196>>2]=M[h+196>>2]+1;e=bs(a);M[h+196>>2]=M[h+196>>2]-1;if((e|0)!=100){break e}break g}c=M[a+32>>2];x=(g|0)!=8;while(1){k=c+1|0;if((c|0)>=(p|0)){M[a+36>>2]=0;e=101;break f}g=w;i:{e=c;b=M[a+108>>2];if((c|0)<(b|0)){break i}e=c-b|0;b=0;while(1){g=M[(b<<2)+l>>2];m=M[g+4>>2];if((m|0)>(e|0)){break i}b=b+1|0;e=e-m|0;continue}}t=M[g>>2];j:{if(!i){break j}r=t+S(e,20)|0;if(N[r+1|0]!=252){break j}b=0;g=(f|0)>0?f:0;m=f+1|0;u=m<<2;while(1){k:{if((b|0)!=(g|0)){if(M[(b<<2)+l>>2]!=M[r+16>>2]){break k}}else{b=g}if((b|0)!=(f|0)){break j}b=qh(i,u,(f|0)!=0);M[a+36>>2]=b;if(b){e=1;break f}l=M[i+8>>2];M[l+(f<<2)>>2]=M[r+16>>2];M[i+12>>2]=u;L[i+16>>1]=O[i+16>>1]&62016|16;p=M[M[r+16>>2]+4>>2]+p|0;f=m;break j}b=b+1|0;continue}}l:{if(x){break l}b=N[t+S(e,20)|0];if((b|0)==188){break l}g=(c|0)<=0;c=k;if(g|(b|0)!=8){continue}}break}M[a+32>>2]=k;if(M[o+296>>2]){M[a+36>>2]=9;Qc(a,15592,0);e=1;break e}L[d+220>>1]=0;M[d+216>>2]=0;M[d+208>>2]=0;M[d+212>>2]=1e9;M[d+200>>2]=0;M[d+204>>2]=0;b=11642;m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{c=t+S(e,20)|0;switch(N[c+1|0]-239|0){case 0:break q;case 2:break y;case 3:break s;case 4:break x;case 5:break v;case 6:break t;case 7:break u;case 9:break B;case 10:break z;case 12:break r;case 13:break n;case 14:break w;case 15:break A;default:break p}}f=M[c+16>>2];M[d+16>>2]=O[f+6>>1];rb(d+200|0,16822,d+16|0);m=f+20|0;b=0;while(1){if(O[f+6>>1]>b>>>0){k=N[M[f+16>>2]+b|0];g=M[m+(b<<2)>>2];if(g){g=M[g>>2]}else{g=30808}y=d,z=Wc(g,33696)?g:21001,M[y+8>>2]=z;M[d+4>>2]=k&2?25067:30808;M[d>>2]=k&1?25071:30808;rb(d+200|0,6103,d);b=b+1|0;continue}break}Ab(d+200|0,27767,1);break m}b=M[c+16>>2];f=N[b+4|0];M[d+32>>2]=M[b>>2];M[d+36>>2]=M[(f<<2)+33712>>2];rb(d+200|0,6440,d+32|0);break m}b=M[c+16>>2];f=M[b+32>>2];M[d+52>>2]=L[b>>1];M[d+48>>2]=f;rb(d+200|0,25703,d+48|0);break m}b=M[M[c+16>>2]+4>>2];f=M[b+32>>2];M[d+68>>2]=L[b>>1];M[d+64>>2]=f;rb(d+200|0,25703,d- -64|0);break m}b=M[c+16>>2];f=M[b+4>>2];M[d+80>>2]=M[b>>2];M[d+84>>2]=f;rb(d+200|0,15078,d+80|0);break m}M[d+96>>2]=M[c+16>>2];rb(d+200|0,17552,d+96|0);break m}R[d+112>>3]=R[M[c+16>>2]>>3];rb(d+200|0,12674,d+112|0);break m}b=M[c+16>>2];f=O[b+16>>1];if(f&2){g=b+8|0;break o}if(f&36){f=M[b+4>>2];M[d+144>>2]=M[b>>2];M[d+148>>2]=f;rb(d+200|0,15078,d+144|0);break m}if(f&8){R[d+128>>3]=R[b>>3];rb(d+200|0,12674,d+128|0);break m}b=f&1?20301:25823;break n}M[d+160>>2]=M[M[c+16>>2]+8>>2];rb(d+200|0,10054,d+160|0);break m}f=M[c+16>>2];g=M[f>>2];b=1;while(1){if(b>>>0<=g>>>0){M[d+180>>2]=M[f+(b<<2)>>2];M[d+176>>2]=(b|0)==1?91:44;rb(d+200|0,1878,d+176|0);b=b+1|0;continue}break}Ab(d+200|0,18439,1);break m}g=M[c+16>>2];break o}b=M[c+16>>2];f=M[b>>2];M[d+196>>2]=M[b+8>>2];M[d+192>>2]=f;rb(d+200|0,6449,d+192|0);break m}g=c+16|0}b=M[g>>2];if(!b){break m}}Sd(d+200|0,b)}if(N[d+220|0]&7){Lb(o)}f=Rd(d+200|0);C:{if((O[a+152>>1]&12)==8){b=M[c+4>>2];Fc(q,b,b>>31);b=M[c+8>>2];Fc(j+80|0,b,b>>31);c=M[c+12>>2];Fc(j+120|0,c,c>>31);c=160;break C}Fc(q,e,e>>31);Bd(j+80|0,M[(N[c|0]<<2)+33728>>2],-1,-1,1,0);b=M[c+4>>2];Fc(j+120|0,b,b>>31);b=M[c+8>>2];Fc(j+160|0,b,b>>31);b=M[c+12>>2];Fc(j+200|0,b,b>>31);Fc(j+280|0,O[c+2>>1],0);dc(j+320|0);c=240}e=1;Bd(c+j|0,f,-1,-1,1,1);M[a+120>>2]=q;c=N[o+87|0];M[a+36>>2]=c?7:0;if(c){break e}}e=100;M[h+64>>2]=100;break a}M[a+32>>2]=k}c=M[s>>2];b=M[s+4>>2];if((b|0)>0){g=1}else{g=!!c&(b|0)>=0}if(g){Nr(h,a)}M[a+120>>2]=0;D:{if((e|0)==101){if(!N[h+85|0]){e=101;break D}e=0;g=0;while(1){if(M[h+20>>2]>(e|0)){f=M[h+16>>2]+(e<<4)|0;c=M[f+4>>2];E:{if(!c){break E}b=M[c+4>>2];M[b+4>>2]=M[c>>2];c=M[M[b>>2]+232>>2];if(!c){break E}b=M[c+12>>2];M[c+12>>2]=0;if((b|0)<=0){break E}c=M[h+268>>2];if(!c|g){break E}g=Ra[c|0](M[h+272>>2],h,M[f>>2],b)|0}e=e+1|0;continue}break}M[a+36>>2]=g;e=g?1:101;break D}if(K[a+150|0]>=0){break D}e=un(a)}M[h+64>>2]=e;if((qd(M[a>>2],M[a+36>>2])|0)!=7){break b}M[a+36>>2]=7;e=K[a+150|0]<0?7:e}e=M[h+72>>2]&e;if((e|0)!=17){break a}if((v|0)==50){e=17;break a}g=M[a+32>>2];b=Na-256|0;Na=b;f=M[a>>2];e=wk(f,a?M[a+200>>2]:0,-1,N[a+150|0],a,b+12|0,0);F:{if(e){if((e|0)!=7){break F}Lb(f);break F}f=b+16|0;c=M[b+12>>2];G(f,c,240);G(c,a,240);G(a,f,240);f=M[c+8>>2];M[c+8>>2]=M[a+8>>2];M[a+8>>2]=f;f=M[c+4>>2];M[c+4>>2]=M[a+4>>2];M[a+4>>2]=f;f=M[c+200>>2];M[c+200>>2]=M[a+200>>2];M[a+200>>2]=f;f=M[c+204>>2];M[c+204>>2]=M[a+204>>2];M[a+204>>2]=f;M[a+228>>2]=M[c+228>>2];K[a+150|0]=N[c+150|0];G(a+164|0,c+164|0,36);M[a+184>>2]=M[a+184>>2]+1;f=0;while(1){if(L[c+16>>1]>(f|0)){k=S(f,40);Cw(k+M[a+100>>2]|0,k+M[c+100>>2]|0);f=f+1|0;continue}break}c=M[b+12>>2];M[c+36>>2]=0;Mf(c)}Na=b+256|0;G:{if(e){c=gb(M[n+288>>2]);eb(n,M[a+124>>2]);if(N[n+87|0]){break G}y=a,z=_b(n,c),M[y+124>>2]=z;e=qd(n,e);M[a+36>>2]=e;break a}wb(a);if((g|0)>=0){K[a+149|0]=254}v=v+1|0;h=M[a>>2];continue}break}e=7;M[a+36>>2]=7;M[a+124>>2]=0}Na=d+224|0;return e|0}function cG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,O=0,P=0,Q=0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0;d=Na-208|0;Na=d;a:{if((b|0)>=7){Pb(a,26748,-1);break a}if(Ql(a,3420,M[c>>2],d+12|0)){break a}s=15;t=-1;x=21966;H=21972;I=21962;b:{switch(b-2|0){case 4:s=sb(M[c+20>>2]);case 3:t=sb(M[c+16>>2]);case 2:x=gb(M[c+12>>2]);case 1:H=gb(M[c+8>>2]);case 0:I=gb(M[c+4>>2]);break;default:break b}}if(I?!x|!H:1){$b(a);break a}if(!s){vb(a,30808,-1,0);break a}n=M[d+12>>2];if(Wl(a,n)){break a}L=M[n>>2];M[d+128>>2]=0;M[d+120>>2]=0;M[d+124>>2]=0;if(!M[n+16>>2]){vb(a,30808,0,0);break a}b=(s|0)<=-64?-64:s;b=(b|0)>=64?64:b;U=b-1|0;V=0-b|0;u=1;while(1){v=V;v=(s|0)>=0?(u+U|0)/(u|0)|0:v;y=0;J=0;K=0;z=0;A=0;c:{d:while(1){if((u|0)!=(y|0)){w=(d+16|0)+S(y,24)|0;b=w;M[b>>2]=0;M[b+4>>2]=0;M[b+16>>2]=0;M[b+20>>2]=0;M[b+8>>2]=0;M[b+12>>2]=0;q=0;B=-1;while(1){e:{f:{if(M[L+24>>2]>(q|0)){if((q|0)!=(t|0)&(t|0)>=0){break e}f=Pl(n,d+200|0,0);if(f){break c}b=Oe(S(M[d+200>>2],40),0);M[d+152>>2]=b;if(!b){f=7;break c}M[d+144>>2]=v;M[d+140>>2]=q;M[d+156>>2]=-1;M[d+148>>2]=M[d+200>>2];M[d+136>>2]=n;f=Df(M[n+16>>2],115,d+136|0);o=M[d+152>>2];if(f){C=0;D=0;b=0;O=0;P=0;Q=0;m=0;break f}k=0;b=M[d+200>>2];g=(b|0)>0?b:0;b=0;while(1){if((b|0)==(g|0)){g=0;j=0;p=0;l=0;c=-1}else{i=M[(S(b,40)+o|0)+16>>2];e=b&63;c=e&31;if((e&63)>>>0>=32){h=1<<c;e=0}else{e=1<<c;h=e-1&1>>>32-c}c=i?e:0;J=c|J;K=K|(i?h:0);b=b+1|0;continue}break}g:while(1){m=c;P=p;Q=l;C=g;D=j;O=k;h:while(1){i:{j:{if(M[d+156>>2]>=0){c=0;b=M[d+148>>2];g=(b|0)>0?b:0;k=2147483647;o=M[d+152>>2];while(1){if((c|0)==(g|0)){break j}e=S(c,40)+o|0;if(M[e+16>>2]){i=M[e+8>>2];h=i;j=i>>>0<k>>>0;e=M[e+12>>2];i=k>>31;k=j&(e|0)<=(i|0)|(e|0)<(i|0)?h:k}c=c+1|0;continue}}c=0;M[d+156>>2]=0;while(1){b=M[d+148>>2];if((c|0)>=(b|0)){break i}b=M[d+152>>2]+S(c,40)|0;Up(b+16|0,b+8|0,M[d+144>>2]);c=c+1|0;continue}}if((k|0)==2147483647){b=q;break f}e=(k-M[d+144>>2]|0)+1|0;M[d+156>>2]=e;i=k+1|0;c=0;while(1){if((b|0)<=(c|0)){break i}b=M[d+152>>2]+S(c,40)|0;Up(b+16|0,b+8|0,i);Up(b+32|0,b+24|0,e);c=c+1|0;b=M[d+148>>2];continue}}k=M[d+156>>2];R=k>>31;o=0;p=0;l=0;g=0;j=0;c=0;while(1){k:{if((b|0)>(o|0)){E=M[d+152>>2]+S(o,40)|0;e=M[E+32>>2];if(!e){break k}M[d+204>>2]=e;b=M[E+28>>2];e=b;i=M[E+24>>2];M[d+160>>2]=i;M[d+164>>2]=b;h=o&63;b=h&31;if((h&63)>>>0>=32){h=1<<b;r=0}else{r=1<<b;h=r-1&1>>>32-b}T=r;b=g|T;W=h;r=j|h;while(1){l:{h=M[d+144>>2];F=h+k|0;G=F>>31;if(!(i>>>0<k>>>0&(e|0)<=(R|0)|(e|0)<(R|0)|((G|0)<=(e|0)&i>>>0>=F>>>0|(e|0)>(G|0)))){e=M[E>>2];e=(e|0)>(h|0)?h:e;F=(e|0)>0?e:0;G=T&(g|z);X=W&(j|A);i=i-k|0;e=i&31;if((i&63)>>>0>=32){h=1<<e;g=0}else{g=1<<e;h=g-1&1>>>32-e}Y=g;g=h;i=0;e=0;while(1){if(!(!e&(i|0)==(F|0))){j=i&31;if((i&63)>>>0>=32){h=0;j=g>>>j|0}else{h=g>>>j|0;j=((1<<j)-1&g)<<32-j|Y>>>j}p=j|p;l=h|l;i=i+1|0;e=i?e:e+1|0;continue}break}c=(G|X?1:1e3)+c|0;if(N[M[d+204>>2]]>=2){break l}j=r;g=b}b=M[d+148>>2];break k}Pj(d+204|0,d+160|0);i=M[d+160>>2];e=M[d+164>>2];g=b;j=r;continue}}if((c|0)<=(m|0)){continue h}continue g}o=o+1|0;continue}}}}y=y+1|0;z=z|M[w+8>>2];A=A|M[w+12>>2];continue d}ab(o);if(f){break c}if((m|0)<=(B|0)){break e}c=w;M[c+16>>2]=P;M[c+20>>2]=Q;M[c+8>>2]=C;M[c+12>>2]=D;M[c+4>>2]=O;M[c>>2]=b;B=m}q=q+1|0;continue}}break}if(!(((z|0)!=(J|0)|(A|0)!=(K|0))&(u|0)!=4)){B=u-1|0;f=0;k=0;while(1){if(k>>>0>=u>>>0|f){break c}r=M[n>>2];M[d+188>>2]=0;b=(d+16|0)+S(k,24)|0;i=M[b+16>>2];e=M[b+20>>2];m=M[b+4>>2];b=M[b>>2]+1|0;j=ff(M[n+12>>2],b);c=M[n+12>>2];m:{if(!j){f=(lh(c,b)|0)!=5?7:0;break m}q=Wd(c,b);b=M[r+36>>2];s=M[b>>2];f=pg(b,M[n+20>>2],j,q,d+184|0);if(f){break m}c=0;w=M[d+184>>2];t=0;n:{o:while(1){f=0;while(1){if(f){break n}M[d+176>>2]=-1;M[d+172>>2]=0;M[d+168>>2]=0;p:{f=Ra[M[s+20>>2]](w,d+180|0,d+176|0,d+172|0,d+168|0,d+188|0)|0;if(f){if((f|0)!=101){break n}b=j+t|0;break p}f=0;b=M[d+188>>2];if((m|0)>(b|0)){continue}q:{if(c){break q}p=0;l=0;r:{s:{t:{if(!(e|i)){i=0;e=0;break t}f=M[d+172>>2];C=f+j|0;D=M[n+20>>2];while(1){c=p;p=c+1|0;l=p?l:l+1|0;b=0;h=i;g=c&31;if((c&63)>>>0>=32){g=e>>>g|0}else{g=((1<<g)-1&e)<<32-g|h>>>g}if(!(g&1)){continue}break}while(1){g=b;b=b+1|0;p=i;l=(g^-1)+v|0;h=l&31;if((l&63)>>>0>=32){h=e>>>h|0}else{h=((1<<h)-1&e)<<32-h|p>>>h}if(!(h&1)){continue}break}b=c-g|0;c=(b|0)/2|0;if((b|0)<2){break t}M[d+136>>2]=0;g=M[r+36>>2];b=M[g>>2];f=pg(g,D,C,q-f|0,d+160|0);if(f){break s}g=c+v|0;f=0;c=M[d+160>>2];u:{while(1){if(!f){if((g|0)<=M[d+136>>2]){Ra[M[b+16>>2]](c)|0;break u}else{M[d+200>>2]=0;M[d+196>>2]=0;M[d+192>>2]=0;f=Ra[M[b+20>>2]](c,d+204|0,d+200|0,d+196|0,d+192|0,d+136|0)|0;continue}}break}Ra[M[b+16>>2]](c)|0;if((f|0)!=101){break s}}b=M[d+136>>2]+(((f|0)!=0)-v|0)|0;c=(b|0)>0?b:0;m=c+m|0;b=c&31;if((c&63)>>>0>=32){h=0;i=e>>>b|0}else{h=e>>>b|0;i=((1<<b)-1&e)<<32-b|i>>>b}e=h}v:{if(!(!k&(m|0)<=0)){f=mg(d+120|0,x,-1);break v}b=M[d+172>>2];if(!b){break r}f=mg(d+120|0,j,b)}if(!f){break r}}c=1;continue}b=M[d+188>>2];if((m|0)<=(b|0)){break q}c=1;continue o}if((m+v|0)<=(b|0)){f=0;b=x;if((k|0)==(B|0)){break p}break n}f=0;if((b|0)>(m|0)){f=mg(d+120|0,j+t|0,M[d+172>>2]-t|0)}c=b-m|0;b=c&31;if((c&63)>>>0>=32){l=1<<b;c=0}else{c=1<<b;l=c-1&1>>>32-b}b=c&i;c=e&l;if(!(!(b|c)|f)){f=mg(d+120|0,I,-1)}w:{if(f){break w}g=d+120|0;h=M[d+172>>2];f=mg(g,h+j|0,M[d+168>>2]-h|0);if(f|!(b|c)){break w}f=mg(g,H,-1)}c=1;t=M[d+168>>2];continue}break}break}f=mg(d+120|0,b,-1)}Ra[M[s+16>>2]](w)|0}k=k+1|0;continue}}u=u+1|0;continue}break}Ne(L);if(f){ee(a,f);ab(M[d+120>>2]);break a}vb(a,M[d+120>>2],-1,1)}Na=d+208|0}function Gp(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,A=0,D=0;q=Na-48|0;Na=q;C(+a);k=x(1)|0;c=x(0)|0;a:{b:{i=k&2147483647;c:{if(i>>>0<=1074752122){if((k&1048575)==598523){break c}if(i>>>0<=1073928572){if((k|0)>0|(k|0)>=0){a=a+-1.5707963267341256;e=a+-6077100506506192e-26;R[b>>3]=e;R[b+8>>3]=a-e+-6077100506506192e-26;d=1;break a}a=a+1.5707963267341256;e=a+6077100506506192e-26;R[b>>3]=e;R[b+8>>3]=a-e+6077100506506192e-26;d=-1;break a}if((k|0)>0|(k|0)>=0){a=a+-3.1415926534682512;e=a+-1.2154201013012384e-10;R[b>>3]=e;R[b+8>>3]=a-e+-1.2154201013012384e-10;d=2;break a}a=a+3.1415926534682512;e=a+1.2154201013012384e-10;R[b>>3]=e;R[b+8>>3]=a-e+1.2154201013012384e-10;d=-2;break a}if(i>>>0<=1075594811){if(i>>>0<=1075183036){if((i|0)==1074977148){break c}if((k|0)>0|(k|0)>=0){a=a+-4.712388980202377;e=a+-1.8231301519518578e-10;R[b>>3]=e;R[b+8>>3]=a-e+-1.8231301519518578e-10;d=3;break a}a=a+4.712388980202377;e=a+1.8231301519518578e-10;R[b>>3]=e;R[b+8>>3]=a-e+1.8231301519518578e-10;d=-3;break a}if((i|0)==1075388923){break c}if((k|0)>0|(k|0)>=0){a=a+-6.2831853069365025;e=a+-2.430840202602477e-10;R[b>>3]=e;R[b+8>>3]=a-e+-2.430840202602477e-10;d=4;break a}a=a+6.2831853069365025;e=a+2.430840202602477e-10;R[b>>3]=e;R[b+8>>3]=a-e+2.430840202602477e-10;d=-4;break a}if(i>>>0>1094263290){break b}}j=a*.6366197723675814+6755399441055744+-6755399441055744;if(U(j)<2147483647){d=~~j}else{d=-2147483648}e=a+j*-1.5707963267341256;m=j*6077100506506192e-26;u=e-m;d:{if(u<-.7853981633974483){d=d-1|0;j=j+-1;m=j*6077100506506192e-26;e=a+j*-1.5707963267341256;break d}if(!(u>.7853981633974483)){break d}d=d+1|0;j=j+1;m=j*6077100506506192e-26;e=a+j*-1.5707963267341256}a=e-m;R[b>>3]=a;C(+a);c=x(1)|0;x(0)|0;k=i>>>20|0;e:{if((k-(c>>>20&2047)|0)<17){break e}m=e;a=j*6077100506303966e-26;e=e-a;m=j*20222662487959506e-37-(m-e-a);a=e-m;R[b>>3]=a;C(+a);c=x(1)|0;x(0)|0;if((k-(c>>>20&2047)|0)<50){break e}m=e;a=j*20222662487111665e-37;e=e-a;m=j*84784276603689e-45-(m-e-a);a=e-m;R[b>>3]=a}R[b+8>>3]=e-a-m;break a}if(i>>>0>=2146435072){a=a-a;R[b>>3]=a;R[b+8>>3]=a;break a}d=q+16|0;f=d|8;z(0,c|0);z(1,k&1048575|1096810496);a=+B();c=1;while(1){e=+((U(a)<2147483647?~~a:-2147483648)|0);R[d>>3]=e;a=(a-e)*16777216;l=c;c=0;d=f;if(l){continue}break}R[q+32>>3]=a;d=2;while(1){c=d;d=c-1|0;s=q+16|0;if(R[s+(c<<3)>>3]==0){continue}break}f=0;g=Na-560|0;Na=g;d=(i>>>20|0)-1046|0;l=(d-3|0)/24|0;t=(l|0)>0?l:0;i=S(t,-24)+d|0;l=M[15869];r=c+1|0;h=r-1|0;if((l+h|0)>=0){d=l+r|0;c=t-h|0;while(1){R[(g+320|0)+(f<<3)>>3]=(c|0)<0?0:+M[(c<<2)+63488>>2];c=c+1|0;f=f+1|0;if((d|0)!=(f|0)){continue}break}}o=i-24|0;d=0;f=(l|0)>0?l:0;p=(r|0)<=0;while(1){f:{if(p){a=0;break f}n=d+h|0;c=0;a=0;while(1){a=R[(c<<3)+s>>3]*R[(g+320|0)+(n-c<<3)>>3]+a;c=c+1|0;if((r|0)!=(c|0)){continue}break}}R[(d<<3)+g>>3]=a;c=(d|0)==(f|0);d=d+1|0;if(!c){continue}break}A=47-i|0;v=48-i|0;w=(i|0)<25;D=i-25|0;d=l;while(1){g:{a=R[(d<<3)+g>>3];c=0;f=d;if((d|0)>0){while(1){p=(g+480|0)+(c<<2)|0;e=a*5.960464477539063e-8;if(U(e)<2147483647){h=~~e}else{h=-2147483648}e=+(h|0);a=e*-16777216+a;if(U(a)<2147483647){h=~~a}else{h=-2147483648}M[p>>2]=h;f=f-1|0;a=R[(f<<3)+g>>3]+e;c=c+1|0;if((d|0)!=(c|0)){continue}break}}a=Hj(a,o);a=a+Y(a*.125)*-8;if(U(a)<2147483647){p=~~a}else{p=-2147483648}a=a-+(p|0);h:{i:{j:{k:{if(!w){f=(d<<2)+g|0;h=M[f+476>>2];c=h>>v;n=f;f=h-(c<<v)|0;M[n+476>>2]=f;p=c+p|0;h=f>>A;break k}if(o){break j}h=M[((d<<2)+g|0)+476>>2]>>23}if((h|0)<=0){break h}break i}h=2;if(a>=.5){break i}h=0;break h}c=0;n=0;f=1;if((d|0)>0){while(1){f=(g+480|0)+(c<<2)|0;y=M[f>>2];l:{m:{if(n){n=16777215}else{if(!y){break m}n=16777216}M[f>>2]=n-y;n=1;f=0;break l}n=0;f=1}c=c+1|0;if((d|0)!=(c|0)){continue}break}}n:{if(w){break n}c=8388607;o:{switch(D|0){case 1:c=4194303;break;case 0:break o;default:break n}}n=(d<<2)+g|0;M[n+476>>2]=M[n+476>>2]&c}p=p+1|0;if((h|0)!=2){break h}a=1-a;h=2;if(f){break h}a=a-Hj(1,o)}p:{q:{if(a==0){f=0;c=d;if((l|0)>=(c|0)){break p}while(1){c=c-1|0;f=M[(g+480|0)+(c<<2)>>2]|f;if((c|0)>(l|0)){continue}break}if(!f){break p}while(1){o=o-24|0;d=d-1|0;if(!M[(g+480|0)+(d<<2)>>2]){continue}break}break q}a=Hj(a,24-i|0);r:{if(a>=16777216){o=(g+480|0)+(d<<2)|0;e=a*5.960464477539063e-8;if(U(e)<2147483647){c=~~e}else{c=-2147483648}a=+(c|0)*-16777216+a;if(U(a)<2147483647){f=~~a}else{f=-2147483648}M[o>>2]=f;d=d+1|0;o=i;break r}c=U(a)<2147483647?~~a:-2147483648}M[(g+480|0)+(d<<2)>>2]=c}a=Hj(1,o);if((d|0)>=0){c=d;while(1){f=c;R[(c<<3)+g>>3]=a*+M[(g+480|0)+(c<<2)>>2];c=c-1|0;a=a*5.960464477539063e-8;if(f){continue}break}f=d;while(1){a=0;c=0;i=d-f|0;o=(i|0)>(l|0)?l:i;if((o|0)>=0){while(1){a=R[(c<<3)+66256>>3]*R[(c+f<<3)+g>>3]+a;r=(c|0)!=(o|0);c=c+1|0;if(r){continue}break}}R[(g+160|0)+(i<<3)>>3]=a;c=(f|0)>0;f=f-1|0;if(c){continue}break}}a=0;if((d|0)>=0){c=d;while(1){f=c;c=c-1|0;a=a+R[(g+160|0)+(f<<3)>>3];if(f){continue}break}}R[q>>3]=h?-a:a;a=R[g+160>>3]-a;c=1;if((d|0)>0){while(1){a=a+R[(g+160|0)+(c<<3)>>3];f=(c|0)!=(d|0);c=c+1|0;if(f){continue}break}}R[q+8>>3]=h?-a:a;Na=g+560|0;d=p&7;break g}c=1;while(1){f=c;c=c+1|0;if(!M[(g+480|0)+(l-f<<2)>>2]){continue}break}f=d+f|0;while(1){h=d+r|0;d=d+1|0;R[(g+320|0)+(h<<3)>>3]=M[(t+d<<2)+63488>>2];c=0;a=0;if((r|0)>0){while(1){a=R[(c<<3)+s>>3]*R[(g+320|0)+(h-c<<3)>>3]+a;c=c+1|0;if((r|0)!=(c|0)){continue}break}}R[(d<<3)+g>>3]=a;if((d|0)<(f|0)){continue}break}d=f;continue}break}a=R[q>>3];if((k|0)<0){R[b>>3]=-a;R[b+8>>3]=-R[q+8>>3];d=0-d|0;break a}R[b>>3]=a;R[b+8>>3]=R[q+8>>3]}Na=q+48|0;return d}function Cd(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;i=a+760|0;w=M[a+4>>2];x=w+8|0;b=N[a+44|0];l=M[a>>2];u=M[l>>2];e=M[l+8>>2];A=M[e+108>>2];while(1){if((b|0)>0){f=b-1|0;c=S(f,96)+i|0;g=M[c+56>>2];if(g){pb(e,M[c+24>>2]);M[c+24>>2]=0;M[g+16>>2]=M[e+108>>2];bb(e,67,M[g+8>>2],M[g+12>>2],1);y=y+1|0}j=M[c+80>>2];a:{if(N[c+61|0]!=187){d=0;b:{if(!(N[j+41|0]&2)|(N[a+47|0]!=2|N[a+44|0]!=(b|0))){break b}b=M[j+32>>2];if(!(N[b+55|0]&128)){break b}g=O[j+30>>1];if(!g|L[M[b+8>>2]+(g<<1)>>1]<36){break b}d=M[l+48>>2]+1|0;b=0;while(1){if((b|0)!=(g|0)){bb(e,94,M[c+8>>2],b,b+d|0);b=b+1|0;continue}break}M[l+48>>2]=(g+M[l+48>>2]|0)+1;d=lb(e,N[c+61|0]==38?21:24,M[c+8>>2],0,d,g);$a(e,9,1,M[c+68>>2])}b=M[c+24>>2];if(b){pb(e,b)}bb(e,N[c+61|0],M[c+64>>2],M[c+68>>2],N[c+62|0]);b=M[e+108>>2];if((b|0)>0){L[(M[e+104>>2]+S(b,20)|0)-18>>1]=N[c+63|0]}if(M[c+36>>2]){pb(e,M[c+40>>2]);$a(e,61,M[c+36>>2],M[c+68>>2]-1|0)}if(!d){break a}M[(N[M[e>>2]+87|0]?74356:M[e+104>>2]+S(d,20)|0)+8>>2]=M[e+108>>2];break a}b=M[c+24>>2];if(!b){break a}pb(e,b)}c:{if(!(N[j+41|0]&8)|M[c+72>>2]<=0){break c}pb(e,M[c+16>>2]);d=M[c+72>>2];b=M[c+76>>2]+S(d,20)|0;while(1){if((d|0)<=0){break c}m=b-16|0;g=b-20|0;h=N[M[e>>2]+87|0];if(h){k=74356}else{k=(M[e+104>>2]+S(M[m>>2],20)|0)+20|0}n=M[e+108>>2];M[k+8>>2]=n;k=b-4|0;if(N[k|0]!=187){p=b-8|0;d:{if(!M[p>>2]){break d}h=M[j+40>>2]&263168;if(M[c>>2]){$a(e,25,M[g>>2],(((h|0)==262144)+n|0)+2|0)}if((h|0)!=262144){break d}lb(e,26,M[c+8>>2],M[e+108>>2]+2|0,M[b-12>>2],M[p>>2]);if(N[M[e>>2]+87|0]){b=74356}else{b=(M[e+104>>2]+S(M[m>>2],20)|0)+20|0}M[b+8>>2]=M[e+108>>2]}$a(e,N[k|0],M[g>>2],M[m>>2]);h=N[M[e>>2]+87|0];n=M[e+108>>2]}if(h){b=74356}else{b=(M[e+104>>2]+S(M[m>>2],20)|0)-20|0}M[b+8>>2]=n;d=d-1|0;b=g;continue}}pb(e,M[c+12>>2]);b=M[c+56>>2];if(b){bb(e,67,M[b+8>>2],0,1)}b=M[c+20>>2];if(b){Xb(e,b);b=M[e+108>>2];e:{if(N[M[e>>2]+87|0]){M[18591]=b;g=74356;break e}g=M[e+104>>2]+S(M[c+20>>2],20)|0;M[g+8>>2]=b;g=g-40|0}M[g+8>>2]=b}b=M[c+48>>2];if(b){$a(e,61,M[c+44>>2]>>>1|0,b)}b=f;d=M[c>>2];if(!d){continue}g=M[j+40>>2];f=fb(e,50,d);if(!(g&64)){d=S(N[c+60|0],48)+x|0;if(N[d+13|0]&64){n=M[M[d+44>>2]+12>>2];bb(e,75,0,n,(n+L[M[d+8>>2]+34>>1]|0)-1|0)}fb(e,136,M[c+4>>2])}d=g&8192;f:{g:{h:{if(!(g&512)){if(!d){break f}if(M[c+72>>2]){break h}break f}if(!d){break g}}g=M[c+72>>2];bb(e,101,M[c+8>>2],M[g+44>>2],Mb(u,M[g+24>>2]));Ld(l,g)}fb(e,136,M[c+8>>2])}i:{if(N[c+61|0]==67){$a(e,10,M[c+64>>2],M[c+28>>2]);break i}Xb(e,M[c+28>>2])}d=M[e+108>>2];M[(N[M[e>>2]+87|0]?74356:M[e+104>>2]+S(f,20)|0)+8>>2]=d;continue}break}g=l+76|0;n=0;while(1){if(N[a+44|0]>n>>>0){j:{if(M[i+56>>2]){h=0;k=0;j=Na+-64|0;Na=j;q=M[i+80>>2];m=M[i+56>>2];f=M[a>>2];c=M[f+8>>2];b=M[a+4>>2]+S(N[i+60|0],48)|0;M[j>>2]=M[M[b+16>>2]>>2];fc(f,1,7416,j);v=(n|0)>0?n:0;s=a+760|0;p=b+8|0;b=0;while(1){if((b|0)!=(v|0)){o=s+S(b,96)|0;t=M[o+80>>2];d=M[t+8>>2];t=M[t+12>>2];r=M[a+4>>2]+S(N[o+60|0],48)|0;if(N[r+21|0]&64){r=M[r+52>>2];z=M[r+12>>2];bb(c,75,0,z,(z+M[M[M[r>>2]+28>>2]>>2]|0)-1|0)}fb(c,136,M[o+4>>2]);o=M[o+8>>2];if(o){fb(c,136,o)}h=d|h;k=k|t;b=b+1|0;continue}break}d=0;k:{if(N[p+12|0]&64){break k}o=(M[q+8>>2]|h)^-1;k=(k|M[q+12>>2])^-1;b=0;while(1){if(M[a+92>>2]<=(b|0)){break k}h=M[a+104>>2]+S(b,48)|0;if(O[h+12>>1]!=8192?O[h+10>>1]&32770:0){break k}l:{if(M[h+40>>2]&o|k&M[h+44>>2]){break l}h=M[h>>2];if(N[h+4|0]&3){break l}d=ce(f,d,qb(M[f>>2],h,0))}b=b+1|0;continue}}M[j+8>>2]=1;M[j+12>>2]=1;G(j+16|0,p,48);K[j+28|0]=0;K[f+26|0]=N[f+26|0]+1;o=jf(f,j+8|0,d,0,0,0,4096,0);if(o){q=M[i+4>>2];b=M[f+48>>2];h=b+1|0;M[f+48>>2]=h;v=M[o+28>>2];m:{p=M[p+8>>2];if(!(N[p+28|0]&128)){$a(c,135,q,h);k=1;break m}s=qc(p);k=O[s+50>>1];M[f+48>>2]=b+k;b=0;while(1){if((b|0)==(k|0)){break m}Ed(c,p,q,L[M[s+4>>2]+(b<<1)>>1],b+h|0);b=b+1|0;continue}}b=lb(c,64,M[m+4>>2],0,h,k);lb(c,29,M[m>>2],v,h,k);h=M[c+108>>2];M[(N[M[c>>2]+87|0]?74356:M[c+104>>2]+S(b,20)|0)+8>>2]=h;$a(c,10,M[m+8>>2],M[m+12>>2]);Cd(o)}kb(M[f>>2],d);ph(f);K[f+26|0]=N[f+26|0]-1;Na=j- -64|0;break j}b=S(N[i+60|0],48)+x|0;if(N[b+13|0]&64){tA(l,M[i+32>>2],M[i+4>>2],M[M[b+44>>2]+12>>2],0);break j}c=M[b+8>>2];d=N[u+87|0];j=M[i+80>>2];b=M[j+40>>2];n:{if(b&576){b=j+32|0;break n}if(!(b&8192)){break j}b=i+72|0}m=M[b>>2];if(d|!m){break j}d=A;d=!N[a+46|0]|N[M[m+12>>2]+28|0]&128?d:M[a+56>>2];o:{if(!(N[m+56|0]&16)){break o}b=g;while(1){b=M[b>>2];if(!b){break o}if(M[b+8>>2]==M[i+8>>2]){M[b+4>>2]=-1;M[b+8>>2]=-1}b=b+20|0;continue}}b=74356;f=d;d=M[i+32>>2]+1|0;f=S(f-d|0,20);b=N[M[e>>2]+87|0]?b:M[e+104>>2]+S(d,20)|0;h=f+b|0;while(1){p:{if(M[b+4>>2]!=M[i+4>>2]){break p}q:{d=N[b|0];if((d|0)!=20){if((d|0)!=135){if((d|0)!=94){break p}f=M[b+8>>2];k=M[c+28>>2];if(k&128){f=O[M[qc(c)+4>>2]+(f<<1)>>1];break q}d=0;if(!(k&32)){break q}while(1){if(f<<16>>16<(d|0)){break q}f=(O[(M[c+4>>2]+S(d,12)|0)+10>>1]>>>5&1)+f|0;d=d+1|0;continue}}d=M[i+8>>2];K[b|0]=142;M[b+4>>2]=d;break p}M[b+4>>2]=M[i+8>>2];break p}d=We(m,f<<16>>16);if((d|0)>=0){M[b+8>>2]=d;M[b+4>>2]=M[i+8>>2];break p}d=M[j+40>>2];if(!(d&67108928)){break p}if(d&64){cb(l,9120,0);M[l+12>>2]=2;break p}M[j+40>>2]=d&-67108929;sA(l,M[i+32>>2]-1|0,w,i,O[a+40>>1])}b=b+20|0;if(h>>>0>b>>>0){continue}break}}i=i+96|0;n=n+1|0;continue}break}pb(e,M[a+32>>2]);L[l+160>>1]=M[a+36>>2];wA(u,a);K[l+26|0]=N[l+26|0]-y}function Bj(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=Na-80|0;Na=g;d=M[a>>2];if(N[d+87|0]){M[a+36>>2]=7}c=M[a+216>>2];if(c){while(1){b=c;c=M[b+4>>2];if(c){continue}break}Mu(b);M[a+224>>2]=0;M[a+216>>2]=0}Lu(a);pi(M[a+88>>2],M[a+20>>2]);while(1){b=M[a+220>>2];if(b){M[a+220>>2]=M[b+4>>2];e=b+88|0;f=e+S(M[b+60>>2],40)|0;c=0;while(1){if(M[b+64>>2]>(c|0)){j=M[f+(c<<2)>>2];if(j){aj(M[b>>2],j)}c=c+1|0;continue}break}pi(e,M[b+60>>2]);Zk(M[M[b>>2]>>2],b+40|0,-1,0);ib(M[M[b>>2]>>2],b);continue}break}if(M[a+236>>2]){Zk(M[a>>2],a+236|0,-1,0)}a:{b:{if(!(N[a+152|0]&128)){break b}Ku(a);c=0;b=M[a+36>>2];c:{d:{if(!b){break d}e:{f:{e=b&255;if(e>>>0>13){break f}b=1;if(!(1<<e&9856)){break f}j=0;f=O[a+152>>1];c=1;if(!(!(f&64)|(e|0)!=9)){break c}if(!(f&32)|(e|0)!=13&(e|0)!=7){break e}j=2;c=0;break c}j=0;if(N[a+148|0]==3){break d}b=0;c=1;break c}ah(d,516);Kj(d);K[d+85|0]=1;M[a+40>>2]=0;M[a+44>>2]=0;c=1;if(M[a+36>>2]){break c}}b=c;$i(a,0);j=0;c=1}l=c;g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{if(!(!N[d+85|0]|!M[d+408>>2]&M[d+384>>2]>0|M[d+192>>2]!=(!(N[a+152|0]&64)|0))){c=M[a+36>>2];if(!(N[a+148|0]!=3|b?c:0)){c=1;if($i(a,1)){if(N[a+152|0]&64){break a}b=787;break l}b=M[d+32>>2];c=M[d+36>>2];if(c&2){M[d+32>>2]=b;M[d+36>>2]=c&-3;b=11;break l}f=M[d+408>>2];b=0;M[d+408>>2]=0;c=0;while(1){if(!(M[d+384>>2]<=(c|0)|b)){b=0;e=M[M[f+(c<<2)>>2]+8>>2];r:{if(!e){break r}h=M[M[e>>2]+60>>2];if(!h){break r}b=Ra[h|0](e)|0;pf(a,e)}c=c+1|0;continue}break}M[d+408>>2]=f;f=0;c=0;while(1){if(b){break m}if(M[d+20>>2]>(c|0)){b=0;h=M[d+16>>2]+(c<<4)|0;e=M[h+4>>2];if(!(!e|N[e+8|0]!=2)){b=M[e+4>>2];M[b+4>>2]=M[e>>2];b=M[b>>2];if(!(1<<N[b+5|0]&52|N[h+8|0]==1|N[b+12|0])){i=!N[b+16|0]+i|0}f=1;b=ov(b)}c=c+1|0;continue}break}s:{if(!f){break s}b=M[d+232>>2];if(!b){break s}if(!(Ra[b|0](M[d+228>>2])|0)){break s}b=531;break l}b=0;t:{e=Sv(M[M[d+16>>2]+4>>2]);u:{if(!jb(e)){c=0;break u}c=0;if((i|0)>1){break t}}while(1){if(M[d+20>>2]<=(c|0)|b){break o}b=M[(M[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=qm(b,0)}else{b=0}c=c+1|0;continue}}i=M[d>>2];M[g+76>>2]=0;b=jb(e);M[g+56>>2]=0;M[g+52>>2]=e;M[g+48>>2]=0;n=tb(d,17956,g+48|0);if(!n){b=7;break m}k=n+4|0;e=k+b|0;v:{while(1){w:{if(!c){break w}if(c>>>0>=101){M[g+16>>2]=k;Lc(13,8111,g+16|0);b=M[i+28>>2];if(!b){break v}Ra[b|0](i,k,0)|0;break v}if((c|0)!=1){break w}M[g+32>>2]=k;Lc(13,8563,g+32|0)}pe(4,g+68|0);b=M[g+68>>2];M[g>>2]=b>>>8;M[g+4>>2]=b&255;vd(13,e,18781,g);b=Ra[M[i+32>>2]](i,k,0,g+72|0)|0;if(!b){c=c+1|0;if(M[g+72>>2]){continue}}break}if(b){break p}}c=0;b=Ju(i,k,g+76|0,16406,0);if(b){break p}f=0;e=0;h=M[g+76>>2];x:{while(1){if(M[d+20>>2]<=(c|0)){break x}y:{b=M[(M[d+16>>2]+(c<<4)|0)+4>>2];z:{if(!b|N[b+8|0]!=2){break z}m=M[M[M[b+4>>2]>>2]+188>>2];if(!m){break z}b=(p=h,q=m,r=jb(m)+1|0,s=f,t=e,o=M[M[h>>2]+12>>2],Ra[o](p|0,q|0,r|0,s|0,t|0)|0);m=jb(m);if(b){break y}b=m+1|0;f=b+f|0;e=b>>>0>f>>>0?e+1|0:e}c=c+1|0;continue}break}Lh(h);c=M[i+28>>2];if(!c){break p}Ra[c|0](i,k,0)|0;break p}if(Ra[M[M[h>>2]+48>>2]](h)&1024){break q}b=Ra[M[M[h>>2]+20>>2]](h,2)|0;if(!b){break q}Lh(h);c=M[i+28>>2];if(!c){break p}Ra[c|0](i,k,0)|0;break p}if(!((c|0)!=17|M[d+184>>2]<2)){M[a+40>>2]=0;M[a+44>>2]=0;break k}ah(d,0);M[a+40>>2]=0;M[a+44>>2]=0;break k}if(!l){break j}j=1;if(!M[a+36>>2]){break j}A:{switch(N[a+148|0]-2|0){default:ah(d,516);Kj(d);j=0;break i;case 1:break j;case 0:break A}}j=2;break j}b=0;c=0;B:{while(1){if(b){break B}if(M[d+20>>2]>(c|0)){b=M[(M[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=qm(b,k)}else{b=0}c=c+1|0;continue}break}Lh(h);b=M[i+28>>2];if(b){b=Ra[b|0](i,k,1)|0}else{b=0}ib(d,n);if(b){break m}c=0;b=M[18582];if(b){Ra[b|0]()}while(1){if(M[d+20>>2]>(c|0)){b=M[(M[d+16>>2]+(c<<4)|0)+4>>2];if(b){ak(b,1)}c=c+1|0;continue}break}b=M[18583];if(!b){break n}Ra[b|0]();break n}Lh(h)}ib(d,n);break m}c=0;while(1){if(b){break m}if(M[d+20>>2]<=(c|0)){break n}b=M[(M[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=ak(b,0)}else{b=0}c=c+1|0;continue}}Fu(d,64);M[d+512>>2]=0;M[d+516>>2]=0;M[d+520>>2]=0;M[d+524>>2]=0;c=M[d+36>>2];M[d+32>>2]=M[d+32>>2]&-524289;M[d+36>>2]=c;M[d+24>>2]=M[d+24>>2]&-2;break k}c=5;if((b|0)!=5){break l}b=5;if(N[a+152|0]&64){break a}}Cm(d,b);M[a+36>>2]=b;ah(d,0);M[a+40>>2]=0;M[a+44>>2]=0}M[d+508>>2]=0;b=0;if(l){break g}}if(!M[M[a>>2]+508>>2]|!M[a+48>>2]){break h}c=0;e=0;f=M[a+48>>2]-1|0;b=M[a>>2];h=(j|0)!=2;while(1){if(M[b+20>>2]>(e|0)){l=M[(M[b+16>>2]+(e<<4)|0)+4>>2];if(l){C:{if(!h){i=Ho(l,2,f);if(i){break C}}i=Ho(l,1,f)}c=c?c:i}e=e+1|0;continue}break}M[b+508>>2]=M[b+508>>2]-1;M[a+48>>2]=0;D:{E:{if(!c){if((j|0)==2){c=_i(b,2,f);if(c){break E}}c=_i(b,1,f)}if((j|0)!=2){break D}}e=M[a+76>>2];M[b+512>>2]=M[a+72>>2];M[b+516>>2]=e;e=M[a+84>>2];M[b+520>>2]=M[a+80>>2];M[b+524>>2]=e}if(!c){break h}b=M[a+36>>2];if(!((b&255)!=19?b:0)){M[a+36>>2]=c;eb(d,M[a+124>>2]);M[a+124>>2]=0}ah(d,516);Kj(d)}K[d+85|0]=1;M[a+40>>2]=0;M[a+44>>2]=0}b=j}if(!(N[a+152|0]&16)){break b}f=0;e=0;if((b|0)!=2){e=M[a+44>>2];b=e+M[d+116>>2]|0;f=M[a+40>>2];j=M[d+112>>2];c=f+j|0;M[d+112>>2]=c;M[d+116>>2]=c>>>0<j>>>0?b+1|0:b}M[d+104>>2]=f;M[d+108>>2]=e;M[a+40>>2]=0;M[a+44>>2]=0}M[d+184>>2]=M[d+184>>2]-1;b=O[a+152>>1];if(!(b&64)){M[d+192>>2]=M[d+192>>2]-1;b=O[a+152>>1]}if(b&128){M[d+188>>2]=M[d+188>>2]-1}K[a+151|0]=3;if(!N[d+87|0]){c=M[a+36>>2]==5?5:0;break a}M[a+36>>2]=7;c=0}Na=g+80|0;return c}function FA(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,H=0,I=0,J=0,P=0,Q=0;h=Na-16|0;Na=h;v=M[a>>2];o=N[a+44|0];p=1;a:{if(o>>>0<2){break a}p=5;if((o|0)==2){break a}p=1;if(M[v+40>>2]){break a}b:{if(o>>>0<5){break b}c=N[a+48|0];if(c&16|N[M[v>>2]+83|0]&32){break b}K[a+48|0]=c|16;p=M[a+4>>2]+8|0;d=M[a+60>>2];g=1;while(1){if((e|0)==(o|0)){break b}c:{s=p+S(e,48)|0;if(!(N[s+12|0]&34)){break c}if(e+4>>>0>o>>>0){break b}c=e&255;while(1){if(!d){d=0;break c}if(c>>>0<N[d+16|0]){break c}d=M[d+56>>2];continue}}l=0;i=0;m=0;c=d;while(1){d:{if(!c){break d}k=p+S(N[c+16|0],48)|0;if(N[k+12|0]&34){break d}e:{if(!(g&M[c>>2]|f&M[c+4>>2])){break e}n=M[c+8>>2];r=M[c+12>>2];if(n&(l|j)|r&(i|x)){break e}if(M[k+8>>2]==M[s+8>>2]){j=g|j;x=f|x;break e}l=l|n;i=i|r;m=m+1|0}c=M[c+56>>2];continue}break}f:{if((m|0)<4){break f}K[a+48|0]=N[a+48|0]|32;m=32768;c=d;while(1){g:{if(!c){break g}n=N[c+16|0];if(n>>>0>=e>>>0){if(e>>>0<n>>>0){break g}n=L[c+20>>1];m=m<<16>>16;m=(m|0)<(n|0)?n:m}c=M[c+56>>2];continue}break}n=((m&65535)==32767?32767:m+1|0)<<16>>16;c=d;while(1){if(!c){break f}if(!(O[c+44>>1]|!(l&M[c+8>>2]|i&M[c+12>>2])|(n|0)<=L[c+20>>1])){L[c+20>>1]=n}c=M[c+56>>2];continue}}f=f<<1|g>>>31;g=g<<1;e=e+1|0;continue}}p=N[a+48|0]&32?18:12}h:{if(!b){break h}c=M[a+8>>2];if(!c){break h}t=M[c>>2]}g=o<<2;c=S(g+32|0,p)+t<<1;n=Ob(M[v>>2],c,c>>31);if(n){f=t<<1;d=p<<5;e=d+n|0;c=e;M[c>>2]=0;M[c+4>>2]=0;M[c+24>>2]=0;M[c+28>>2]=0;M[c+16>>2]=0;M[c+20>>2]=0;M[c+8>>2]=0;M[c+12>>2]=0;w=c+d|0;c=p<<1;d=n;while(1){if((c|0)>0){M[d+24>>2]=w;d=d+32|0;c=c-1|0;w=g+w|0;continue}break}i:{if(!t){w=0;break i}if(!f){break i}D(w,0,f)}c=L[v+160>>1];L[e+16>>1]=(c|0)>=48?48:c;if(t){K[e+22|0]=o?-1:t}F=b-10|0;H=b-66|0;x=a+60|0;I=(b|0)>10;c=1;f=n;m=0;while(1){g=e;if((o|0)!=(y|0)){e=0;J=(c|0)>0?c:0;z=y<<2;P=y&65535;l=g;B=0;while(1){if((B|0)!=(J|0)){c=x;while(1){k=M[c>>2];if(k){d=M[l+4>>2];u=d;j:{c=M[l>>2];if(M[k>>2]&(c^-1)|M[k+4>>2]&(d^-1)){break j}s=M[k+8>>2];A=M[k+12>>2];if(c&s|d&A){break j}j=L[l+16>>1];if((j|0)<3?N[k+41|0]&64:0){break j}d=j+O[k+20>>1]<<16>>16;i=L[k+18>>1];if(i){d=ie(i,d)}i=ie(d,L[l+20>>1]);d=O[k+22>>1];r=K[l+22|0];k:{if((r|0)<0){M[h+8>>2]=0;M[h+12>>2]=0;r=Fm(a,M[a+8>>2],l,O[a+40>>1],P,k,h+8|0);break k}q=M[l+12>>2];M[h+8>>2]=M[l+8>>2];M[h+12>>2]=q}Q=d+j|0;l:{if(!((r|0)<0|(r|0)>=(t|0))){j=(r<<1)+w|0;d=O[j>>1];if(!d){d=(M[M[M[a+16>>2]+28>>2]>>2]+59|0)/30|0;d=Td(d,d>>31);if(r){q=(S(t-r|0,100)|0)/(t|0)|0;d=Td(q,q>>31)+(d+H|0)|0}else{d=b+d|0}q=O[a+40>>1];m:{if(q&16384){d=(r?16:10)+d|0;q=L[a+42>>1];q=(b|0)>(q|0)?q:b;break m}q=I?(q&256)>>>8|0?F:b:b}d=Em(q<<16>>16)+d|0;L[j>>1]=d}j=ie(i,d<<16>>16)+3|0;break l}j=i;i=i-2|0}q=c|s;u=u|A;s=Q<<16>>16;d=0;A=(e|0)>0?e:0;c=f;n:{o:{while(1){if((d|0)!=(A|0)){if(M[c>>2]==(q|0)&M[c+4>>2]==(u|0)&(N[c+22|0]^r)<<24>>24>=0){break o}c=c+32|0;d=d+1|0;continue}break}c=e;d=(p|0)>(c|0);p:{if(d){break p}if(j<<16>>16>m<<16>>16){break j}c=E;if((j&65535)!=(m&65535)){break p}if(i<<16>>16>=C<<16>>16){break j}}c=(c<<5)+f|0;e=d+e|0;break n}d=L[c+18>>1];if((d|0)<j<<16>>16){break j}if((d&65535)!=(j&65535)){break n}d=L[c+16>>1];if((d|0)<(s|0)){break j}if((d|0)!=(s|0)){break n}if(L[c+20>>1]<i<<16>>16){break j}if(O[c+20>>1]!=(i&65535)){break n}u=1;d=M[M[c+24>>2]+z>>2];if(!(!(N[k+41|0]&2)|!(N[d+41|0]&2))){u=L[M[k+32>>2]+48>>1]>=L[M[d+32>>2]+48>>1]}if(u){break j}}d=M[k+12>>2]|M[l+4>>2];M[c>>2]=M[k+8>>2]|M[l>>2];M[c+4>>2]=d;d=M[h+8>>2];u=M[h+12>>2];K[c+22|0]=r;L[c+20>>1]=i;L[c+18>>1]=j;L[c+16>>1]=s;M[c+8>>2]=d;M[c+12>>2]=u;if(z){G(M[c+24>>2],M[l+24>>2],z)}M[M[c+24>>2]+z>>2]=k;if((e|0)<(p|0)){break j}C=L[f+16>>1];m=O[f+18>>1];d=1;E=0;c=f;while(1){if((d|0)==(p|0)){break j}i=L[c+50>>1];q:{if((i|0)>m<<16>>16){j=L[c+52>>1]}else{if((i&65535)!=(m&65535)){break q}j=L[c+52>>1];if((j|0)<=C<<16>>16){break q}}C=j;m=i;E=d}c=c+32|0;d=d+1|0;continue}}c=k+56|0;continue}break}l=l+32|0;B=B+1|0;continue}break}y=y+1|0;c=e;e=f;f=g;continue}break}r:{if(c){f=(c|0)<=1?1:c;d=g;c=1;while(1)if((c|0)==(f|0)){e=a+760|0;c=0;while(1){if((c|0)!=(o|0)){f=e+S(c,96)|0;g=M[M[d+24>>2]+(c<<2)>>2];M[f+80>>2]=g;g=N[g+16|0];K[f+60|0]=g;M[f+4>>2]=M[(M[a+4>>2]+S(g,48)|0)+24>>2];c=c+1|0;continue}break}s:{if(N[a+47|0]|(!b|(O[a+40>>1]&384)!=256)){break s}b=o-1|0;if((Fm(a,M[a+12>>2],d,128,b&65535,M[M[d+24>>2]+(b<<2)>>2],h+8|0)|0)!=M[M[a+12>>2]>>2]){break s}K[a+47|0]=2}f=N[a+48|0];K[a+48|0]=f&251;c=M[a+8>>2];t:{if(!c){break t}b=K[d+22|0];K[a+45|0]=b;e=O[a+40>>1];u:{if(e&128){if((b|0)!=M[c>>2]){break u}K[a+47|0]=2;break u}g=M[d+12>>2];M[a+72>>2]=M[d+8>>2];M[a+76>>2]=g;if((b|0)<=0){K[a+45|0]=0;if(!o){break u}b=o-1|0;f=M[M[d+24>>2]+(b<<2)>>2];g=M[f+40>>2];if(g&4096|(g&260)==260){break u}M[h+8>>2]=0;M[h+12>>2]=0;b=Fm(a,c,d,2048,b,f,h+8|0);c=M[a+8>>2];if((b|0)==M[c>>2]){K[a+48|0]=N[a+48|0]|4;b=M[h+12>>2];M[a+72>>2]=M[h+8>>2];M[a+76>>2]=b}e=O[a+40>>1];break u}if(!(e&3)|(!o|(b|0)!=1)){break u}K[a+48|0]=f|4}if(!(e&512)|!o|M[c>>2]!=K[a+45|0]){break t}M[h+8>>2]=0;M[h+12>>2]=0;b=o-1|0;if((Fm(a,c,d,0,b,M[M[d+24>>2]+(b<<2)>>2],h+8|0)|0)!=M[M[a+8>>2]>>2]){break t}K[a+48|0]=N[a+48|0]|8;b=M[h+12>>2];M[a+72>>2]=M[h+8>>2];M[a+76>>2]=b}L[a+50>>1]=O[d+16>>1];break r}else{e=g+(c<<5)|0;d=L[d+18>>1]>L[e+18>>1]?e:d;c=c+1|0;continue}}cb(v,10282,0)}ib(M[v>>2],n)}Na=h+16|0}function Fm(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,P=0,Q=0,R=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;r=Na-16|0;Na=r;a:{b:{P=M[M[a>>2]>>2];if(N[P+80|0]&64?e:0){break b}u=O[b>>1];if(u>>>0>63){break b}Q=d&2051?387:386;_=a+496|0;E=b+16|0;$=d&64;aa=d&192;ba=a+80|0;F=b+8|0;R=d&128;ca=d&2048;i=u&31;if((u&63)>>>0>=32){h=-1<<i;i=0}else{h=(1<<i)-1&-1>>>32-i;i=-1<<i;h=h|i}G=i^-1;D=h^-1;T=e;s=1;while(1){c:{d:{e:{f:{g:{h:{i:{j:{if(!(!(s&255)|((m|0)==(D|0)&l>>>0>=G>>>0|m>>>0>D>>>0)|(!C&y>>>0>T>>>0|(C|0)!=0))){if(y|C){U=U|M[o+12>>2];V=V|M[o+8>>2]}o=f;if(!C&y>>>0<T>>>0){o=M[M[c+24>>2]+(y<<2)>>2];if(ca){break d}}if(N[o+41|0]&4){if((d&640)!=128&N[o+29|0]!=0|(l|0)==(G|0)&(m|0)==(D|0)){break j}break c}if(R){L[o+30>>1]=0}n=V^-1;p=U^-1;z=M[(M[a+4>>2]+S(N[o+16|0],48)|0)+24>>2];j=0;i=0;while(1){if((j|0)!=(u|0)|i){e=j&31;if((j&63)>>>0>=32){h=1<<e;k=0}else{k=1<<e;h=k-1&1>>>32-e}v=k;k:{if(v&l|h&m){break k}q=(j<<4)+F|0;k=$c(M[q>>2]);if(!k){break k}l:{switch(N[k|0]-168|0){case 0:case 2:break l;default:break k}}if(M[k+28>>2]!=(z|0)){break k}t=mr(ba,z,L[k+32>>1],n,p,Q,0);if(!t){break k}A=O[t+12>>1];if((A|0)==1){x=O[o+44>>1];e=0;while(1){if((e|0)==(x|0)){break k}B=e<<2;e=e+1|0;if((t|0)!=M[B+M[o+52>>2]>>2]){continue}break}}if(!(!(A&130)|L[k+32>>1]<0)){e=M[a>>2];k=Lf(e,M[q>>2]);e=Ug(e,M[t>>2]);if(!e){break k}if(hb(M[k>>2],M[e>>2])){break k}}l=l|v;m=h|m}j=j+1|0;i=j?i:i+1|0;continue}break}M[r+8>>2]=l;M[r+12>>2]=m;e=M[o+40>>2];if(e&4096){break g}m:{if(e&256){n:{if(!M[o+36>>2]|N[P+83|0]&16){break n}l=0;m=0;p=0;k=M[r+8>>2];t=M[r+12>>2];h=M[o+36>>2];while(1){i=m;e=i;j=l;l=j+1|0;m=l?e:e+1|0;n=k;e=j&31;if((j&63)>>>0>=32){e=t>>>e|0}else{e=((1<<e)-1&t)<<32-e|n>>>e}if(e&1){continue}break}e=M[h>>2];m=(e|0)>0?e:0;v=b+8|0;q=h+8|0;e=y&31;if((y&63)>>>0>=32){h=1<<e;l=0}else{l=1<<e;h=l-1&1>>>32-e}A=l;l=h;h=0;o:{while(1){if((h|0)==(m|0)){e=m;break o}p:{e=M[b>>2];n=e>>31;if((n|0)<=(i|0)&e>>>0<=j>>>0|(i|0)>(n|0)){break p}x=q+(h<<4)|0;B=O[x+12>>1];if(!B){break p}e=h;q:{w=v+(j<<4)|0;n=M[w>>2];switch(N[n|0]-168|0){case 0:case 2:break q;default:break o}}if(M[n+28>>2]!=(z|0)|L[n+32>>1]!=(B-1|0)){break p}r:{if(N[a+40|0]&64){break r}n=N[x+8|0];x=N[w+8|0];e=n^x;if(e&2){break p}if(h){e=1;if((x&1)==(n&1^p)){break r}break o}p=0;if(!(e&1)){break r}if(N[o+43|0]&2){e=0;break o}k=l|M[g+4>>2];M[g>>2]=A|M[g>>2];M[g+4>>2]=k;k=M[r+8>>2];t=M[r+12>>2];p=1}H=k;k=j&31;if((j&63)>>>0>=32){e=1<<k;n=0}else{n=1<<k;e=n-1&1>>>32-k}k=H|n;e=e|t;t=e;M[r+8>>2]=k;M[r+12>>2]=e;j=j+1|0;i=j?i:i+1|0;h=h+1|0;continue}break}e=h}if(!e){break n}p=0;A=0;s=0;t=0;break m}p=0;A=0;t=1;break m}p=M[o+32>>2];h=0;if(!p|N[p+55|0]&4){break a}s=!(e&32768)&N[p+54|0]!=0;A=O[p+50>>1];t=O[p+52>>1]}i=y&31;if((y&63)>>>0>=32){e=1<<i;h=0}else{h=1<<i;e=h-1&1>>>32-i}H=h;n=e;k=0;l=M[r+8>>2];m=M[r+12>>2];x=0;W=0;B=0;while(1){s:{if((k|0)!=(t|0)){e=1;i=O[o+24>>1];t:{if(i>>>0<=k>>>0|O[o+46>>1]>k>>>0){break t}v=M[o+52>>2];h=M[v+(k<<2)>>2];j=O[h+12>>1];if(j&Q){s=j&384?0:s;break s}if(!(j&1)){break t}j=i-1|0;q=M[h>>2];h=k;while(1){if((h|0)==(j|0)){break t}h=h+1|0;if((q|0)!=M[M[v+(h<<2)>>2]>>2]){continue}break}e=0}u:{if(!p){h=-1;v=0;break u}j=O[M[p+4>>2]+(k<<1)>>1];q=M[p+12>>2];h=((j|0)==O[q+32>>1]?-1:j)<<16>>16;v=K[M[p+28>>2]+k|0]&1;if(!(s&255)){s=0;break u}if((h|0)>=0){if(i>>>0>k>>>0){break u}s=N[(M[q+4>>2]+S(h,12)|0)+4|0]&15?s:0;break u}s=(h|0)!=-2?s:0}j=0;i=0;while(1){if(!(e&255)){break i}X=!i&j>>>0>=u>>>0|(i|0)!=0;if(X){break i}w=l;q=j&31;v:{if((j&63)>>>0>=32){w=m>>>q|0}else{w=((1<<q)-1&m)<<32-q|w>>>q}if(w&1){break v}w=j<<4;Y=w+F|0;I=M[Y>>2];q=$c(I);if(!q){break v}e=aa?e:0;w:{x:{if((h|0)>=-1){y:{switch(N[q|0]-168|0){case 0:case 2:break y;default:break v}}if(M[q+28>>2]!=(z|0)|L[q+32>>1]!=(h|0)){break v}if((h|0)!=-1){break x}break w}if(Bm(q,M[(M[p+40>>2]+(k<<4)|0)+8>>2],z)){break v}I=M[Y>>2]}if(hb(M[Lf(M[a>>2],I)>>2],M[M[p+32>>2]+(k<<2)>>2])){break v}}if(R){L[o+30>>1]=k+1}z:{if($|X){break z}if(B){B=1;if(((v^W)&255)==(K[w+E|0]&1)){break z}break i}B=1;e=K[w+E|0]&1;W=e^v;if((e|0)==(v|0)){break z}i=n|M[g+4>>2];M[g>>2]=H|M[g>>2];M[g+4>>2]=i}if(N[w+E|0]&2){if(O[o+24>>1]!=(k|0)){break i}M[o+40>>2]=M[o+40>>2]|524288}x=(h|0)==-1?1:x;e=j&31;if((j&63)>>>0>=32){i=1<<e;h=0}else{h=1<<e;i=h-1&1>>>32-e}l=h|l;m=i|m;break s}j=j+1|0;i=j?i:i+1|0;continue}}M[r+8>>2]=l;M[r+12>>2]=m;break h}k=k+1|0;continue}}if((l|0)!=(G|0)|(m|0)!=(D|0)){break c}}h=u;break a}M[r+8>>2]=l;M[r+12>>2]=m;s=k?k>>>0>=A>>>0?s:0:0}e=1;if(x&255){break f}}if(!(s&255)){break e}e=s}s=e;i=da|M[o+12>>2];da=i;Z=Z|M[o+8>>2];k=Z^-1;t=i^-1;j=0;i=0;while(1){if((j|0)!=(u|0)|i){h=j&31;if((j&63)>>>0>=32){e=1<<h;n=0}else{n=1<<h;e=n-1&1>>>32-h}A:{if(n&l|e&m){break A}p=M[(j<<4)+F>>2];h=df(_,p);z=Qa;B:{if(!(h|z)){if(Nd(0,p)){break B}break A}if(h&k|t&z){break A}}l=l|n;m=e|m}j=j+1|0;i=j?i:i+1|0;continue}break}M[r+8>>2]=l;M[r+12>>2]=m;break d}s=0}e=C;y=y+1|0;C=y?e:e+1|0;continue}break}h=255;if(s&255){break a}while(1){if(u>>>0<2&(J|0)<=0|(J|0)<0){break b}J=J-!u|0;u=u-1|0;a=u&31;if((u&63)>>>0>=32){i=-1<<a;a=0}else{b=(1<<a)-1&-1>>>32-a;a=-1<<a;i=b|a}if(((a|l)&(i|m))!=-1){continue}break}h=u;break a}h=0}Na=r+16|0;return h<<24>>24}function zG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Na-48|0;Na=h;g=M[a+12>>2];j=M[a+8>>2];k=M[a+4>>2];a:{while(1){m=101;if((g|0)>=(j|0)){break a}b:{while(1){i=j;if((g|0)==(i|0)){break b}i=K[g+k|0];if(!((i|0)<0|(N[(i-48&255)+57168|0]?i>>>0>=48:0))){g=g+1|0;M[a+12>>2]=g;continue}break}i=g}n=i;i=(g|0)>(j|0)?g:j;c:{while(1){if((g|0)==(i|0)){break c}d:{l=K[g+k|0];if((l|0)>=0){if(!N[(l-48&255)+57168|0]|l>>>0<48){break d}}g=g+1|0;M[a+12>>2]=g;continue}break}i=g}if((i|0)<=(n|0)){continue}break}l=M[a+20>>2];i=i-n|0;if((i|0)>M[a+24>>2]){g=i+20|0;M[a+24>>2]=g;l=Mc(l,g,g>>31);m=7;if(!l){break a}M[a+20>>2]=l}m=k+n|0;e:{f:{if(i-21>>>0<=4294967277){break f}g=0;k=22;while(1){if((g|0)!=(i|0)){j=N[g+m|0];g:{if((j-65&255)>>>0<=25){j=j|32;break g}if((j-97&255)>>>0>25){break f}}K[(h+16|0)+k|0]=j;k=k-1|0;g=g+1|0;continue}break}K[h+39|0]=0;K[h+40|0]=0;K[h+41|0]=0;K[h+42|0]=0;K[h+43|0]=0;g=h+k|0;M[h+12>>2]=g+17;h:{if(N[g+17|0]!=115){break h}g=h+12|0;if(Vb(g,4248,4471,0)){break h}if(Vb(g,12252,12271,0)){break h}if(Vb(g,4471,4471,0)){break h}M[h+12>>2]=M[h+12>>2]+1}g=M[h+12>>2];i=h+12|0;i:{if(Vb(i,14743,14744,112)){break i}j:{if(!Vb(i,12226,30808,113)){if(!Vb(i,14804,30808,113)){break i}if((g|0)!=M[h+12>>2]){break j}break i}if((g|0)==M[h+12>>2]){break i}}g=h+12|0;if(Vb(g,18179,13313,0)){break i}if(Vb(g,18124,14515,0)){break i}if(Vb(g,12185,12942,0)){break i}k:{g=M[h+12>>2];if(!_e(g)){break k}i=N[g|0];if((i|0)!=N[g+1|0]){break k}i=i-108|0;if(1<<i&16513?i>>>0<=14:0){break k}M[h+12>>2]=g+1;break i}if(!By(g)){break i}if(!Ay(g)){break i}g=g-1|0;M[h+12>>2]=g;K[g|0]=101}g=M[h+12>>2];l:{if(N[g|0]!=121){break l}if(!Cy(g+1|0)){break l}K[g|0]=105}m:{n:{switch(N[g+1|0]-97|0){case 0:g=h+12|0;if(Vb(g,18151,13313,112)){break m}Vb(g,3110,10873,112);break m;case 2:g=h+12|0;if(Vb(g,13958,14847,112)){break m}Vb(g,18182,14856,112);break m;case 4:Vb(h+12|0,12175,12942,112);break m;case 6:Vb(h+12|0,11680,12538,112);break m;case 11:g=h+12|0;if(Vb(g,18123,14515,112)){break m}if(Vb(g,18278,11956,112)){break m}if(Vb(g,13915,2991,112)){break m}if(Vb(g,14209,14955,112)){break m}Vb(g,10070,3748,112);break m;case 14:g=h+12|0;if(Vb(g,12180,12942,112)){break m}if(Vb(g,18153,13313,112)){break m}Vb(g,18140,13313,112);break m;case 18:g=h+12|0;if(Vb(g,18295,11956,112)){break m}if(Vb(g,12194,13066,112)){break m}if(Vb(g,12695,11664,112)){break m}Vb(g,10062,3748,112);break m;case 19:break n;default:break m}}g=h+12|0;if(Vb(g,18289,11956,112)){break m}if(Vb(g,12188,13066,112)){break m}Vb(g,18127,14515,112)}o:{p:{q:{r:{s:{g=N[M[h+12>>2]];switch(g-105|0){case 0:break r;case 1:case 2:break o;case 3:break q;default:break s}}if((g|0)==115){break p}if((g|0)!=101){break o}g=h+12|0;if(Vb(g,12262,17925,112)){break o}if(Vb(g,18145,30808,112)){break o}Vb(g,18283,11956,112);break o}Vb(h+12|0,12256,17925,112);break o}g=h+12|0;if(Vb(g,12268,17925,112)){break o}Vb(g,12699,30808,112);break o}Vb(h+12|0,11382,30808,112)}t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{g=M[h+12>>2];switch(N[g+1|0]-97|0){case 0:break E;case 2:break D;case 4:break C;case 8:break B;case 11:break A;case 13:break z;case 14:break y;case 18:break x;case 19:break w;case 20:break v;case 21:case 25:break u;default:break t}}if(N[g|0]!=108){break t}g=g+2|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if(N[g|0]!=101|N[g+2|0]!=110){break t}F:{switch(N[g+3|0]-97|0){case 0:case 4:break F;default:break t}}g=g+4|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if(N[g|0]!=114){break t}g=g+2|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if(N[g|0]!=99){break t}g=g+2|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if(N[g|0]!=101|N[g+2|0]!=98|(N[g+3|0]|8)!=105){break t}g=g+4|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if(N[g|0]!=116){break t}G:{switch(N[g+2|0]-97|0){case 0:g=g+3|0;if(!ge(g)){break t}M[h+12>>2]=g;break t;case 4:break G;default:break t}}g=h+12|0;if(Vb(g,14004,30808,114)){break t}if(Vb(g,11595,30808,114)){break t}Vb(g,13917,30808,114);break t}if(N[g|0]==117){g=g+2|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if((N[g+3|0]-115&255)>>>0>1){break t}Vb(h+12|0,12222,30808,114);break t}if(N[g|0]!=109|N[g+2|0]!=105){break t}g=g+3|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}g=h+12|0;if(Vb(g,18159,30808,114)){break t}Vb(g,12202,30808,114);break t}if(N[g|0]!=115|N[g+2|0]!=111){break t}g=g+3|0;if(!ge(g)){break t}M[h+12>>2]=g;break t}if(N[g|0]!=101|N[g+2|0]!=105){break t}g=g+3|0;if(!ge(g)){break t}M[h+12>>2]=g}g=M[h+12>>2];H:{if(N[g|0]!=101){break H}i=g+1|0;if(!ge(i)){if(!By(i)){break H}if(Ay(i)){break H}}M[h+12>>2]=i;g=i}if(!(!ge(g)|N[g|0]!=108|N[g+1|0]!=108)){g=g+1|0;M[h+12>>2]=g}j=yb(g);M[c>>2]=j;k=0;while(1){K[j+l|0]=k;k=N[g|0];if(!k){break e}j=j-1|0;g=g+1|0;continue}}k=0;g=0;while(1){if((g|0)!=(i|0)){j=N[g+m|0];o=(j-65&255)>>>0<26;K[g+l|0]=o?j|32:j;k=o?k:(j-48&255)>>>0<10?1:k;g=g+1|0;continue}break}j=k?3:10;if(j<<1<(i|0)){g=i-j|0;while(1){if((g|0)>=(i|0)){i=j}else{K[j+l|0]=N[g+l|0];j=j+1|0;g=g+1|0;continue}break}}K[i+l|0]=0;M[c>>2]=i}M[b>>2]=M[a+20>>2];M[d>>2]=n;M[e>>2]=M[a+12>>2];b=a;a=M[a+16>>2];M[b+16>>2]=a+1;M[f>>2]=a;m=0}Na=h+48|0;return m|0}function cu(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=Na+-64|0;Na=f;M[f+48>>2]=d;n=M[a+8>>2];a:{b:{if(!(N[a+1|0]&32)){break b}e=ng(M[n+4>>2],M[a+64>>2],a);M[f+52>>2]=e;if(e){break a}if(!d|K[a+68|0]>=0){break b}e=db(80138);break a}if(N[a|0]>=3){e=Zf(a);M[f+52>>2]=e;if(e&-17){break a}}c:{e=M[a+112>>2];if(!e){if(N[n+11|0]){yo(n,M[a+64>>2],M[b+8>>2],M[b+12>>2],0)}if(!(!(N[a+1|0]&2)|(M[b+8>>2]!=M[a+32>>2]|M[b+12>>2]!=M[a+36>>2]))){if(!O[a+50>>1]|M[a+44>>2]!=(M[b+32>>2]+M[b+28>>2]|0)){break c}e=Pt(a,b);break a}if(d){break c}e=zh(a,M[b+8>>2],M[b+12>>2],c>>>3&1,f+48|0);M[f+52>>2]=e;if(e){break a}break c}if(!(c&2|d)){d=O[b+24>>1];d:{if(d){M[f+8>>2]=e;e=M[b+20>>2];K[f+34|0]=0;K[f+30|0]=0;L[f+28>>1]=d;M[f+12>>2]=e;e=Ch(a,f+8|0,f+48|0);break d}e=Ot(a,M[b>>2],M[b+8>>2],M[b+12>>2],c>>>3&1,f+48|0)}M[f+52>>2]=e;if(e){break a}d=M[f+48>>2]}if(d){break c}Ng(a);d=M[a+32>>2];if((d|0)!=M[b+8>>2]|M[a+36>>2]!=M[b+12>>2]){break c}b=M[b>>2];M[f+40>>2]=0;M[f+36>>2]=d;M[f+24>>2]=b;e=Pt(a,f+8|0);break a}g=M[a+116>>2];if(M[g+20>>2]<0){if(N[a|0]>=2){e=db(80261);break a}e=Yf(g);M[f+52>>2]=e;if(e){break a}}d=M[n+4>>2];m=M[d+84>>2];e:{f:{if(c>>>0>=128){M[f+52>>2]=0;k=M[d+88>>2];if((k|0)<=3){K[m+3|0]=0;k=4;d=M[n+4>>2]}if(!N[d+17|0]|O[g+14>>1]>=k>>>0){break f}Ra[M[g+80>>2]](g,m,f+8|0);if(M[f+20>>2]==O[f+24>>1]){break f}Hd(M[n+4>>2],mb((k+m|0)-4|0),3,M[g+4>>2],f+52|0);e=M[f+52>>2];if(!e){break f}break a}e=N[g+10|0];g:{if(N[g+1|0]){p=M[b+16>>2];d=M[b+28>>2];j=d+M[b+32>>2]|0;h:{if(j>>>0<=127){K[e+m|0]=j;h=1;break h}h=of(e+m|0,j,j>>31)&255}e=h+e|0;e=of(e+m|0,M[b+8>>2],M[b+12>>2])+e|0;break g}p=M[b>>2];d=M[b+8>>2];i:{if(d>>>0<=127){K[e+m|0]=d;h=1;break i}h=of(e+m|0,d,d>>31)&255}e=h+e|0;j=d}l=e+m|0;i=O[g+14>>1];if((i|0)>=(j|0)){k=e+j|0;if((k|0)<=3){K[j+l|0]=0;k=4}if(d){G(l,p,d)}e=j-d|0;if(!e){break f}D(d+l|0,0,e);break f}o=M[g+52>>2];k=M[o+40>>2];h=O[g+16>>1];M[f+60>>2]=0;r=h;h=h+((j-h>>>0)%(k-4>>>0)|0)|0;i=(h|0)>(i|0)?r:h;e=e+i|0;h=e+m|0;k=e+4|0;while(1){e=(i|0)>(j|0)?j:i;j:{if((e|0)<=(d|0)){if(!e){break j}G(l,p,e);break j}if((d|0)>0){e=d;if(!e){break j}G(l,p,e);break j}if(!e){break j}D(l,0,e)}j=j-e|0;if((j|0)>0){d=d-e|0;p=e+p|0;l=e+l|0;i=i-e|0;if(i){continue}M[f+56>>2]=0;l=M[f+60>>2];e=l;if(N[o+17|0]){r=M[16864];while(1){i=e;e=e+1|0;if((e|0)==(Zd(o,e)|0)|(i|0)==((r>>>0)/P[o+36>>2]|0)){continue}break}M[f+60>>2]=e}e=rf(o,f+56|0,f+60|0,e,0);M[f+8>>2]=e;k:{if(!(!N[o+17|0]|e)){i=M[f+60>>2];Hd(o,i,l?4:3,l,f+8|0);e=M[f+8>>2];if(!e){break k}Rb(M[f+56>>2]);break e}if(e){break e}i=M[f+60>>2]}e=h;h=i<<24|(i&65280)<<8|(i>>>8&65280|i>>>24);K[e|0]=h;K[e+1|0]=h>>>8;K[e+2|0]=h>>>16;K[e+3|0]=h>>>24;Rb(q);q=M[f+56>>2];h=M[q+56>>2];e=h;K[e|0]=0;K[e+1|0]=0;K[e+2|0]=0;K[e+3|0]=0;i=M[o+40>>2]-4|0;l=M[q+56>>2]+4|0;continue}break}Rb(q)}L[a+50>>1]=0;d=O[a+70>>1];e=M[f+48>>2];l:{if(!e){if(O[g+24>>1]<=d>>>0){e=db(80303);break a}e=ac(M[g+72>>2]);if(e){break a}e=M[g+64>>2]+(d<<1)|0;e=M[g+56>>2]+(O[g+26>>1]&(N[e|0]<<8|N[e+1|0]))|0;if(!N[g+8|0]){h=N[e|0]|N[e+1|0]<<8|(N[e+2|0]<<16|N[e+3|0]<<24);K[m|0]=h;K[m+1|0]=h>>>8;K[m+2|0]=h>>>16;K[m+3|0]=h>>>24}h=f+8|0;Ra[M[g+80>>2]](g,e,h);if(M[f+20>>2]!=O[f+24>>1]){h=vo(g,e,h)}else{h=0}M[f+52>>2]=h;K[a+1|0]=N[a+1|0]&251;h=O[f+26>>1];if(!((h|0)!=(k|0)|M[f+20>>2]!=O[f+24>>1]|(O[g+16>>1]<=k>>>0?N[M[n+4>>2]+17|0]:0))){if(e>>>0<(M[g+56>>2]+N[g+9|0]|0)+10>>>0){e=db(80330);break a}if(P[g+60>>2]<e+k>>>0){e=db(80333);break a}if(k){G(e,m,k)}e=0;break a}Sk(g,d,h,f+52|0);e=M[f+52>>2];if(!e){break l}break a}if(!O[g+24>>1]|(e|0)>=0){break l}d=d+1|0;L[a+70>>1]=d;K[a+1|0]=N[a+1|0]&249;d=d&65535}m:{n:{o:{n=k+2|0;p:{if((n|0)>M[g+20>>2]){e=N[g+12|0];K[g+12|0]=e+1;M[((e<<2)+g|0)+36>>2]=m;L[((e<<1)+g|0)+28>>1]=d;break p}e=ac(M[g+72>>2]);if(e){break m}e=N[g+9|0];j=M[g+56>>2];M[f+8>>2]=0;h=e+j|0;i=N[h+5|0]<<8|N[h+6|0];l=O[g+18>>1]+(O[g+24>>1]<<1)|0;q:{if(i>>>0<l>>>0){e=72625;if(i){break n}i=65536;if(M[M[g+52>>2]+40>>2]==65536){break q}break n}e=72628;if(M[M[g+52>>2]+40>>2]<(i|0)){break n}}r:{s:{t:{if(!N[h+2|0]){if(!N[h+1|0]){break s}if(l+2>>>0<=i>>>0){break t}break s}if(l+2>>>0>i>>>0){break s}}e=uo(g,k,f+8|0);if(e){e=e-j|0;if((l|0)>=(e|0)){break o}break r}e=M[f+8>>2];if(e){break m}}if((l+n|0)>(i|0)){e=M[g+20>>2]-n|0;e=to(g,(e|0)>=4?4:e);if(e){break m}i=((N[h+6|0]|N[h+5|0]<<8)-1&65535)+1|0}e=i-k|0;i=e<<8|(e&65280)>>>8;K[h+5|0]=i;K[h+6|0]=i>>>8}i=e>>>8|0;M[g+20>>2]=M[g+20>>2]-(n&65535);if(k){G(e+j|0,m,k)}h=M[g+64>>2]+(d<<1)|0;d=O[g+24>>1]-d<<1;if(d){G(h+2|0,h,d)}K[h+1|0]=e;K[h|0]=i;L[g+24>>1]=O[g+24>>1]+1;e=j+N[g+9|0]|0;d=N[e+4|0]+1|0;K[e+4|0]=d;if((d|0)!=(d&255)){d=j+N[g+9|0]|0;K[d+3|0]=N[d+3|0]+1}if(!N[M[g+52>>2]+17|0]){break p}M[f+8>>2]=0;cj(g,g,m,f+8|0);e=M[f+8>>2];if(e){break m}}e=0;break m}e=db(72645);break m}e=db(e)}if(!N[g+12|0]){break a}K[a+1|0]=N[a+1|0]&249;e=so(a);K[M[a+116>>2]+12|0]=0;K[a|0]=1;if(!(c&2)|e){break a}Nh(a);e=0;u:{if(!M[a+112>>2]){break u}c=lc(M[b+8>>2],M[b+12>>2]);M[a+16>>2]=c;if(!c){e=7;break u}d=M[b+8>>2];if(!d){break u}G(c,M[b>>2],d)}K[a|0]=3;c=M[b+12>>2];M[a+56>>2]=M[b+8>>2];M[a+60>>2]=c;break a}Rb(q)}Na=f- -64|0;return e}function mj(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;j=Na-112|0;Na=j;a:{b:{c:{if(b){i=N[b|0];if(!Wc(b,23200)){g=!i;break c}if(i){break b}}g=1;if(N[c+86|0]!=2){break b}}p=1;q=e|2;break a}i=f&128;p=i>>>7|0;q=i>>>6|e}h=7;i=zd(48,0);d:{if(!i){break d}M[i+36>>2]=1;M[i>>2]=c;K[i+8|0]=0;M[i+32>>2]=i;e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{m=(f&256)>>>8|0?(g|p)&1?f&-769|512:f:f;if(!(!(m&64)&p|g|!(m&131072))){g=M[a+8>>2]+1|0;f=jb(b)+1|0;e=lc((f|0)<(g|0)?g:f,0);K[i+9|0]=1;if(!e){break e}p:{if(p){if(!f){break p}G(e,b,f);break p}K[e|0]=0;h=Ra[M[a+36>>2]](a,b,g,e)|0;if((h|512)==512){break p}ab(e);break e}f=74324;q:{while(1){f=M[f>>2];if(!f){break q}r:{g=M[f>>2];if(!(Wc(e,M[g+184>>2])|M[g>>2]!=(a|0))){g=M[c+20>>2];while(1){if((g|0)<=0){break r}g=g-1|0;h=M[(M[c+16>>2]+(g<<4)|0)+4>>2];if(!h|M[h+4>>2]!=(f|0)){continue}break}ab(e);ab(i);h=19;break d}f=f+72|0;continue}break}M[i+4>>2]=f;M[f+68>>2]=M[f+68>>2]+1}ab(e);if(f){break o}}M[j+16>>2]=0;M[j+20>>2]=0;f=zd(92,0);if(!f){h=7;break f}M[j+108>>2]=4096;n=M[a+4>>2];e=0;M[f>>2]=0;r=q&2;if(r){if(!b){t=1;g=1;break m}if(!N[b|0]){e=b;g=1;break m}l=_b(0,b);if(!l){break h}t=1;u=1;k=jb(l);break l}if(!b){t=1;break n}if(!N[b|0]){e=b;break n}g=M[a+8>>2]+1|0;e=g<<1;l=lc(e,e>>31);if(!l){break h}K[l|0]=0;h=m&16777216;e=Ra[M[a+36>>2]](a,b,g,l)|0;k=jb(l);s=(jb(b)+b|0)+1|0;g=s;while(1){if(N[g|0]){g=(yb(g)+g|0)+1|0;g=(yb(g)+g|0)+1|0;continue}break}h=(e|0)==512?h?1550:0:e;if(!h){if(M[a+8>>2]>=(k+8|0)){e=b;o=(g-s|0)+1|0;break k}h=ne(62119)}ab(l);break g}if(!N[i+9|0]){break i}break j}g=0}u=g;k=0}o=1}h=7;n=((n|0)<=64?64:n)+7&2147483640;g=zd((((S(k,3)+(n<<1)|0)+o|0)+(M[a+4>>2]+7&-8)|0)+322|0,0);if(!g){eb(0,l);break g}h=g+296|0;M[g+64>>2]=h;M[g+228>>2]=g+240;h=h+(M[a+4>>2]+7&-8)|0;M[g+72>>2]=h;h=h+n|0;M[g+68>>2]=h;h=h+n|0;K[h|0]=g;K[h+1|0]=g>>>8;K[h+2|0]=g>>>16;K[h+3|0]=g>>>24;h=h+8|0;M[g+184>>2]=h;s:{if(k){n=!k;if(!n){G(h,l,k)}h=h+k|0;t:{if(s){h=h+1|0;if(o){G(h,s,o)}h=h+o|0;break t}h=h+2|0}M[g+188>>2]=h;if(!n){G(h,l,k)}h=h+k|0;K[h|0]=45;K[h+1|0]=106;K[h+2|0]=111;K[h+3|0]=117;K[h+4|0]=114;K[h+5|0]=110;K[h+6|0]=97;K[h+7|0]=108;h=h+9|0;M[g+236>>2]=h;if(!n){G(h,l,k)}h=h+k|0;K[h|0]=45;K[h+1|0]=119;K[h+2|0]=97;K[h+3|0]=108;eb(0,l);break s}M[g+236>>2]=0;M[g+188>>2]=0}M[g+152>>2]=m;M[g>>2]=a;k=0;u:{v:{w:{if(!(!N[e|0]|t)){M[j+104>>2]=0;h=Ra[M[a+24>>2]](a,M[g+184>>2],M[g+64>>2],m&17334143,j+104|0)|0;a=1;e=M[j+104>>2];k=e>>>7&1;K[g+16|0]=k;if(h){break v}m=e&1;e=M[g+64>>2];h=M[e>>2];if(h){a=!(Ra[M[h+48>>2]](e)&8192)}x:{if(m){break x}dp(g);e=M[g+156>>2];if(e>>>0<=P[j+108>>2]){break x}M[j+108>>2]=e>>>0>=8192?8192:e}v=g,w=Rk(M[g+184>>2],12005,0),K[v+13|0]=w;y:{if(!a){break y}if(Rk(M[g+184>>2],14213,0)){break y}a=0;break w}m=1}K[g+13|0]=1;K[g+17|0]=1;K[g+18|0]=4;m=m&1;a=1}h=Xh(g,j+108|0,-1);if(h){break v}o=M[j+108>>2];h=M[g+228>>2];D(h,0,56);M[h+48>>2]=g;M[h+44>>2]=r?0:19;e=2;K[h+41|0]=2;K[h+40|0]=!(r>>>1|0);M[h+32>>2]=1;M[h+36>>2]=88;M[h+24>>2]=100;M[h+28>>2]=1;h=Ev(h,o);if(!h){break u}}a=M[g+64>>2];b=M[a>>2];if(b){Ra[M[b+4>>2]](a)|0;M[a>>2]=0}tf(M[g+224>>2]);ab(g);break g}M[g+160>>2]=-2;K[g+12|0]=a;K[g+19|0]=a;K[g+4|0]=a;K[g+15|0]=u;K[g+14|0]=m;a=q&1;K[g+6|0]=!a;Dv(g,35);M[g+176>>2]=-1;M[g+180>>2]=-1;L[g+148>>1]=88;dp(g);z:{if(!a){e=4;if(!(k|r)){break z}}K[g+5|0]=e}M[g+216>>2]=20;M[g+220>>2]=M[g+44>>2]?6:7;M[f>>2]=g;a=M[c+52>>2];M[g+136>>2]=M[c+48>>2];M[g+140>>2]=a;D(j,0,100);a=M[g+64>>2];e=M[a>>2];A:{if(!e){break A}h=Ra[M[e+8>>2]](a,j,100,0,0)|0;if((h|0)==522){break A}if(h){break g}}M[f+4>>2]=c;K[f+16|0]=q;g=M[f>>2];M[g+192>>2]=21;M[g+196>>2]=f;a=M[g+64>>2];e=M[a>>2];if(e){Ra[M[e+40>>2]](a,15,g+192|0)|0;g=M[f>>2]}M[i+4>>2]=f;M[f+8>>2]=0;M[f+12>>2]=0;if(N[g+14|0]){L[f+24>>1]=O[f+24>>1]|1}a=N[j+17|0]<<16|N[j+16|0]<<8;M[f+36>>2]=a;e=f+36|0;B:{if(!(!(a&a+131071)&a-65537>>>0>=4294902271)){a=0;M[e>>2]=0;if(!b|p){break B}K[f+17|0]=0;K[f+18|0]=0;break B}a=N[j+20|0];L[f+24>>1]=O[f+24>>1]|2;b=M[j+52>>2];K[f+17|0]=(b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24))!=0;b=M[j+64>>2];K[f+18|0]=(b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24))!=0}h=Xh(g,e,a);if(h){break g}M[f+68>>2]=1;M[f+40>>2]=M[f+36>>2]-a;if(!N[i+9|0]){break i}M[f+72>>2]=M[18581];M[18581]=f}g=0;a=M[c+20>>2];a=(a|0)>0?a:0;while(1){if((a|0)==(g|0)){break i}b=M[(M[c+16>>2]+(g<<4)|0)+4>>2];if(!b|!N[b+9|0]){g=g+1|0;continue}else{while(1){g=b;b=M[g+28>>2];if(b){continue}break}b=M[i+4>>2];if(b>>>0<P[g+4>>2]){M[i+28>>2]=0;M[i+24>>2]=g;M[g+28>>2]=i;break i}C:{while(1){a=g;g=M[g+24>>2];if(!g){c=0;g=i;h=a;b=24;break C}if(b>>>0>P[g+4>>2]){continue}break}M[i+24>>2]=g;c=a;h=i;b=28}M[b+i>>2]=c;M[g+28>>2]=h;M[a+24>>2]=i}break}}M[d>>2]=i;a=M[i+4>>2];M[a+4>>2]=M[i>>2];if(!M[a+52>>2]){gj(i,-2e3)}h=0;a=M[M[f>>2]+64>>2];b=M[a>>2];if(!b){break d}Ra[M[b+40>>2]](a,30,f+4|0)|0;break d}h=7}a=M[f>>2];if(!a){break f}Bv(a,0)}ab(f);ab(i);M[d>>2]=0;break d}ab(i)}Na=j+112|0;return h}function Zp(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;m=Na-96|0;Na=m;g=mi(a,b,c,d,0,0,1,0,m+8|0);a:{if(g){break a}r=M[m+12>>2];if(!r){break a}b:{c:{if((d|0)==-1){e=c;k=e>>31;l=b;n=l>>31;break c}g=Tb(a,15,m+72|0,0);if(g){break a}f=M[m+72>>2];e=c;l=b;n=l>>31;k=M[a+260>>2];h=ZJ(l,n,k,k>>31);t=e+h|0;k=e>>31;i=k+Qa|0;Jb(f,1,t<<10,(h>>>0>t>>>0?i+1|0:i)<<10|t>>>22);h=M[a+260>>2];j=ZJ(h,h>>31,l,n);h=k+Qa|0;j=e+j|0;h=j>>>0<e>>>0?h+1|0:h;Jb(f,2,j<<10|1023,h<<10|j>>>22);if((Db(f)|0)==100){q=dd(f,0);p=Qa}g=wb(f);if(g){break a}if((d|0)!=-2){t=q;w=p;break c}B=1;g=3;if((r|0)!=1){t=q;w=p;break b}t=q;w=p;if(M[M[M[m+8>>2]>>2]+56>>2]){break b}g=101;break a}q=M[a+260>>2];f=q>>31;j=d+1|0;r=j>>31;g=Tb(a,8,m+72|0,0);d:{if(g){break d}p=M[m+72>>2];h=M[a+260>>2];h=ZJ(l,n,h,h>>31);i=k+Qa|0;h=e+h|0;i=(h>>>0<e>>>0?i+1|0:i)<<10|h>>>22;h=j+(h<<10)|0;i=i+r|0;Jb(p,1,h,h>>>0<j>>>0?i+1|0:i);h=0;if((Db(p)|0)==100){h=Md(p,0)}g=wb(p);if(g){break d}g=0;z=h;if((h|0)<16){break d}z=0;g=Zp(a,b,c,j)}if(g){break a}l=ZJ(l,n,q,f);h=k+Qa|0;i=e;e=e+l|0;h=r+((i>>>0>e>>>0?h+1|0:h)<<10|e>>>22)|0;q=j+(e<<10)|0;p=q>>>0<j>>>0?h+1|0:h;g=(d|0)==-1?1:(w|0)>=(p|0)&q>>>0<=t>>>0|(p|0)<(w|0)?1:3}M[m+80>>2]=0;M[m+72>>2]=0;M[m+76>>2]=0;M[m+84>>2]=g;g=Vj(a,m+8|0,m+72|0);f=0;e:{f:{g:{h:{while(1){if(g){break f}i:{g=li(a,m+8|0);if((g|0)!=100){if(g){break f}if((d|0)==-1){break h}k=M[m+12>>2];e=M[m+8>>2];g=0;M[m+92>>2]=0;h=0;while(1){if((h|0)>=(k|0)|g){break i}g=Mx(a,M[e+(h<<2)>>2]);h=h+1|0;continue}}h=M[m+68>>2];x=M[m+64>>2];l=M[m+60>>2];y=M[m+56>>2];if(!f){g=7;f=Bb(64,0);if(!f){continue}D(f,0,64);e=M[a+232>>2];e=Bb(e,e>>31);M[f+48>>2]=e;if(!e){continue}M[f+40>>2]=M[a+232>>2];g=Tb(a,10,m+92|0,0);if(g){continue}j=M[m+92>>2];if((Db(j)|0)==100){k=dd(j,0);M[f+8>>2]=k;e=Qa;M[f+12>>2]=e;M[f+16>>2]=k;M[f+20>>2]=e}g=wb(j);if(g){continue}}v=M[f+44>>2];g=267;u=Qj(M[f+24>>2],M[f+28>>2],y,l);o=l-u|0;if((o|0)<=0){continue}e=h>>31;s=e;j=(_d(u,u>>31)+(h+o|0)|0)+_d(o,0)|0;r=_d(h,e);e=j+r|0;k=e>>31;j:{if((v|0)<=0){break j}j=M[a+232>>2];n=j;i=k;A=j>>31;j=e+v|0;i=j>>>0<v>>>0?i+1|0:i;if((A|0)>=(i|0)&j>>>0<=n>>>0|(i|0)<(A|0)){break j}i=M[f+20>>2];j=i;e=M[f+16>>2];if((e|0)==-1&(i|0)==2147483647){continue}k=e+1|0;i=k?i:i+1|0;M[f+16>>2]=k;M[f+20>>2]=i;g=og(a,e,j,M[f+48>>2],v);if(g){continue}M[a+52>>2]=M[a+52>>2]+1;g=Yp(a,f,y,u+1|0);if(g){continue}v=0;M[f+28>>2]=0;e=(_d(l,l>>31)+(r+(h+l|0)|0)|0)+1|0;k=e>>31;o=l;u=0}i=k+M[f+60>>2]|0;j=e+M[f+56>>2]|0;i=j>>>0<e>>>0?i+1|0:i;M[f+56>>2]=j;M[f+60>>2]=i;n=M[f+48>>2];j=M[f+40>>2];i=e>>>0>j>>>0;j=j>>31;if(i&(k|0)>=(j|0)|(j|0)<(k|0)){g=7;n=Mc(n,e,k);if(!n){continue}M[f+40>>2]=e;M[f+48>>2]=n}e=uc(n+v|0,u,u>>31)+v|0;e=uc(e+M[f+48>>2]|0,o,o>>31)+e|0;if(o){G(e+M[f+48>>2]|0,u+y|0,o)}e=e+o|0;e=uc(e+M[f+48>>2]|0,h,s)+e|0;if(h){G(e+M[f+48>>2]|0,x,h)}M[f+44>>2]=e+h;k:{if((l|0)<=M[f+32>>2]){o=M[f+24>>2];break k}g=7;i=l<<1;o=Mc(M[f+36>>2],i,l>>31<<1|l>>>31);if(!o){continue}M[f+36>>2]=o;M[f+24>>2]=o;M[f+32>>2]=i}if(l){G(o,y,l)}M[f+28>>2]=l;g=0;continue}break}if(g){break f}l:{if(B){g=Tb(a,26,m+92|0,0);if(g){break f}g=M[m+92>>2];l=c;j=b>>31;e=M[a+260>>2];k=ZJ(b,j,e,e>>31);e=l+k|0;h=l>>31;i=h+Qa|0;Jb(g,1,e<<10,(e>>>0<k>>>0?i+1|0:i)<<10|e>>>22);e=M[a+260>>2];b=ZJ(e,e>>31,b,j);i=h+Qa|0;b=b+l|0;i=b>>>0<l>>>0?i+1|0:i;Jb(g,2,b<<10|1023,i<<10|b>>>22);break l}g=Tb(a,16,m+92|0,0);if(g){break f}g=M[m+92>>2];e=M[a+260>>2];b=ZJ(e,e>>31,b,b>>31);e=b+c|0;h=Qa+(c>>31)|0;k=((b>>>0>e>>>0?h+1|0:h)<<10|e>>>22)+(d>>31)|0;b=e<<10;c=b+d|0;Jb(g,1,c,b>>>0>c>>>0?k+1|0:k)}Db(g);g=wb(g);if(g|!f){break f}break g}if(f){break g}g=0;break a}m:{if(M[f>>2]){h=M[f+20>>2];x=h;r=M[f+16>>2];b=r+1|0;h=b?h:h+1|0;M[f+16>>2]=b;M[f+20>>2]=h;g=og(a,r,x,M[f+48>>2],M[f+44>>2]);if(g){break m}h=M[f+16>>2];j=M[f+20>>2];l=M[f+8>>2];n=M[f+12>>2];b=f;c=1;while(1){b=M[b>>2];if(M[b>>2]){o=b+8|0;g=0;e=h;k=j;while(1){s=M[o>>2];if(!(!s|g)){o=s+4|0;i=Lx(s,c,l,n);g=og(a,e,k,i+M[s+36>>2]|0,M[s+32>>2]-i|0);i=M[s+12>>2]+1|0;s=i;l=i+l|0;i=(i>>31)+n|0;n=l>>>0<s>>>0?i+1|0:i;e=e+1|0;k=e?k:k+1|0;continue}break}if(g){break m}c=c+1|0;l=h;n=j;h=e;j=k;continue}break}e=Lx(b,c,l,n);g=Xp(a,q,p,z,M[f+8>>2],M[f+12>>2],r,x,h-1|0,j-!h|0,M[f+56>>2],M[f+60>>2],e+M[b+36>>2]|0,M[b+32>>2]-e|0);break m}g=Xp(a,q,p,z,0,0,0,0,0,0,M[f+56>>2],M[f+60>>2],M[f+48>>2],M[f+44>>2])}M[a+52>>2]=M[a+52>>2]+1;if(g){break f}if((d|0)!=-1){g=0;if((p|0)>=(w|0)&q>>>0>=t>>>0|(p|0)>(w|0)){break f}}g=Kx(a,q,p,M[f+56>>2],M[f+60>>2]);break e}if(!f){break a}}ab(M[f+48>>2]);ab(M[f+36>>2]);Jx(M[f>>2]);ab(f)}eh(m+8|0);Na=m+96|0;return g}function br(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;q=Na-96|0;Na=q;r=M[M[a>>2]>>2];a:{if(M[r+40>>2]){i=M[r+12>>2];break a}e=M[a+8>>2];u=M[e+40>>2];f=u&32?24:447;j=N[c+55|0]|N[c+56|0]<<8;b:{if(!(j&260)){break b}f=j&4?f&387:f;if(!(j&256)){break b}f=N[b+13|0]&2?f:f&316}s=M[r>>2];v=O[e+22>>1];y=M[e>>2];z=M[e+4>>2];A=O[e+46>>1];B=O[e+28>>1];C=O[e+26>>1];t=O[e+44>>1];l=O[e+24>>1];f=Im(q,M[a+4>>2],M[b+16>>2],l,f,c);L[e+18>>1]=0;D=t+1|0;E=L[M[c+8>>2]>>1];x=Em(E);G=(x|0)>9;j=0;c:{while(1){if(!f|i){break c}d:{n=O[f+12>>1];e:{if(!(!(N[f+10|0]&128)&(n|0)!=256)){i=0;if(KA(c,l)){break e}}i=0;h=M[e+8>>2];k=M[e+12>>2];if(h&M[f+32>>2]|k&M[f+36>>2]|(O[f+10>>1]&256?(n|0)==16:0)){break e}if(N[b+12|0]&88){if(!dr(f,b)){break e}}f:{if(N[c+54|0]){g=2;if((O[c+50>>1]-1|0)==(l|0)){break f}}g=1}K[a+16|0]=g|N[a+16|0];L[e+44>>1]=t;L[e+28>>1]=B;L[e+26>>1]=C;L[e+24>>1]=l;M[e+40>>2]=u;g=t;if(g>>>0>=O[e+48>>1]){if(si(s,e,D)){break d}h=M[e+8>>2];k=M[e+12>>2];g=O[e+44>>1]}p=g+1|0;L[e+44>>1]=p;o=M[e+52>>2];M[o+(g<<2)>>2]=f;k=(z|M[f+36>>2])&(k^-1);M[e>>2]=(y|M[f+32>>2])&(h^-1);M[e+4>>2]=k;g:{if(n&1){h=M[f>>2];h:{if(N[h+5|0]&16){g=p&65535;p=(g>>>0<=1?1:g)-1|0;g=0;k=46;while(1){if((g|0)==(p|0)){break h}w=M[o+(g<<2)>>2];if(w){k=(h|0)!=M[w>>2]?k:0}g=g+1|0;continue}}k=0;g=M[h+20>>2];if(!g){break h}g=M[g>>2];if(!g){break h}k=Td(g,g>>31)&65535}i:{if(!(!(N[c+55|0]&128)|!G)){h=k<<16>>16;if(!(((O[M[c+8>>2]+(l<<1)>>1]-(k+x|0)|0)+Em(h)|0)+10&32768)){break i}if(N[s+82|0]&2|(d|0)>1){break e}M[e+40>>2]=M[e+40>>2]|1048576}h=k}i=M[e+40>>2]|4;M[e+40>>2]=i;break g}if(n&130){g=L[M[c+4>>2]+(l<<1)>>1];k=M[e+40>>2];i=k|1;M[e+40>>2]=i;h=4097;j:{k:{if((g|0)==-1){break k}if((g|0)<0|d){break j}g=O[c+50>>1];if((g-1|0)!=(l|0)){break j}if(!(N[c+54|0]?!(n&2)|(g|0)!=1:1)|N[c+55|0]&8){break k}h=65537}i=h|k;M[e+40>>2]=i}h=0;if(N[q+25|0]<2){break g}i=i|2097152;M[e+40>>2]=i;break g}if(n&256){i=M[e+40>>2]|8;M[e+40>>2]=i;h=0;break g}p=M[b+16>>2];g=1;j=Zc(M[M[f>>2]+12>>2]);h=O[c+52>>1]-l|0;j=(h|0)>(j|0)?j:h;j=(j|0)<=1?1:j;l:{while(1){if((g|0)==(j|0)){break l}k=M[f>>2];m=M[k+16>>2];h=m+20|0;i=g<<4;k=M[(i+M[M[k+12>>2]+20>>2]|0)+8>>2];h=N[m+5|0]&16?M[m+20>>2]+28|0:h;m:{if(N[k|0]!=168|(p|0)!=M[k+28>>2]){break m}m=g+l|0;if(O[k+32>>1]!=O[M[c+4>>2]+(m<<1)>>1]){break m}o=M[c+28>>2];if(N[o+m|0]!=N[l+o|0]){break m}o=M[(i+M[h>>2]|0)+8>>2];w=mh(o,rc(k));h=68;i=L[k+32>>1];n:{if((i|0)<0){break n}F=M[c+12>>2];if((i|0)>=L[F+34>>1]){break n}h=N[(M[F+4>>2]+S(i,12)|0)+5|0]}if((w&255)!=(h&255)){break m}h=fg(r,k,o);if(!h){break m}if(hb(M[h>>2],M[M[c+32>>2]+(m<<2)>>2])){break m}g=g+1|0;continue}break}j=g}g=M[e+40>>2];if(n&36){L[e+26>>1]=j;i=g|34;M[e+40>>2]=i;h=0;j=f;m=0;if(!(K[f+11|0]&1)){break g}if(si(s,e,O[e+44>>1]+1|0)){break d}j=O[e+44>>1];L[e+44>>1]=j+1;m=f+48|0;M[M[e+52>>2]+(j<<2)>>2]=m;L[e+28>>1]=1;i=M[e+40>>2]|16;M[e+40>>2]=i;j=f;break g}L[e+28>>1]=j;i=g|18;M[e+40>>2]=i;h=0;if(g&32){j=M[(M[e+52>>2]+(O[e+44>>1]<<2)|0)-8>>2]}else{j=0}m=f}o:{p:{if(i&2){g=L[e+22>>1];f=bA(m,bA(j,g));g=g+((j?-1:0)-((m|0)!=0)|0)|0;f=(!j|!m|L[j+8>>1]<=0?f:L[m+8>>1]>0?f-20|0:f)<<16>>16;f=(f|0)<=10?10:f;f=(f|0)>(g|0)?g:f;break p}g=O[e+24>>1]+1|0;L[e+24>>1]=g;f=L[f+8>>1];if(!(L[M[c+4>>2]+(l<<1)>>1]<0|(f|0)>0)){f=O[e+22>>1]+(f-h|0)|0;break p}f=M[c+8>>2]+((g&65535)<<1)|0;f=O[e+22>>1]+(O[f>>1]-O[f-2>>1]|0)|0;L[e+22>>1]=f;if(!(n&256)){break o}f=f+10|0}L[e+22>>1]=f}if(((N[c+55|0]|N[c+56|0]<<8)&3)==3){g=f+16|0}else{g=(((S(L[c+48>>1],15)|0)/L[M[b+8>>2]+40>>1]|0)+(f&65535)|0)+1|0}g=ie(x,g<<16>>16);if(!(i&67109184)){g=ie(g,f+16<<16>>16)}h=d+h|0;L[e+22>>1]=h+f;L[e+20>>1]=g+h;cr(M[a+4>>2],e,E);i=hk(a,e);g=f;f=M[e+40>>2];L[e+22>>1]=f&2?v:g;q:{if(f&16){break q}f=O[e+24>>1];if(f>>>0>=O[c+52>>1]){break q}if(f>>>0>=O[c+50>>1]){if(((N[c+55|0]|N[c+56|0]<<8)&3)==2){break q}}if(f>>>0>=4){Om(r)}br(a,b,c,h<<16>>16)}L[e+22>>1]=v}f=ti(q);continue}break}i=0}L[e+46>>1]=A;L[e+28>>1]=B;L[e+26>>1]=C;L[e+24>>1]=l;M[e>>2]=y;M[e+4>>2]=z;M[e+40>>2]=u;L[e+44>>1]=t;L[e+22>>1]=v;if((l|0)!=(A|0)){break a}f=l+1|0;if(N[s+81|0]&64|((l|0)!=(t|0)|f>>>0>=O[c+50>>1]|((N[c+55|0]|N[c+56|0]<<8)&192)!=128)){break a}f=f<<1;if(L[f+M[c+8>>2]>>1]<42){break a}i=si(s,e,D);if(i){break a}L[e+24>>1]=O[e+24>>1]+1;L[e+46>>1]=O[e+46>>1]+1;j=O[e+44>>1];L[e+44>>1]=j+1;i=0;M[M[e+52>>2]+(j<<2)>>2]=0;M[e+40>>2]=M[e+40>>2]|32768;j=M[c+8>>2];f=O[j+(l<<1)>>1]-O[f+j>>1]|0;L[e+22>>1]=O[e+22>>1]-f;br(a,b,c,(d+f|0)+5<<16>>16);L[e+46>>1]=l;L[e+24>>1]=l;L[e+22>>1]=v;M[e+40>>2]=u}Na=q+96|0;return i}function YF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=Na-80|0;Na=d;a:{if(Ql(a,10208,M[c>>2],d+12|0)){break a}if((b|0)>=2){e=gb(M[c+4>>2])}f=M[d+12>>2];b=M[f+16>>2];if(!b){te(a,30808,0,0);break a}o=e?e:1611;p=M[f>>2];M[d+40>>2]=0;M[d+44>>2]=0;M[d+32>>2]=0;M[d+36>>2]=0;M[d+24>>2]=0;M[d+28>>2]=0;M[d+16>>2]=f;M[d+20>>2]=M[p+24>>2];b:{c:{d:{e:{c=M[f+92>>2];if(c){if(!Wc(M[c+12>>2],o)){m=1;break e}ay(c);M[f+92>>2]=0;b=M[f+16>>2]}M[d+64>>2]=0;Df(b,119,d- -64|0);b=M[d+64>>2];M[f+24>>2]=b;M[d+24>>2]=b;e=0;b=0;while(1){f:{g:{h:{c=N[b+o|0];if(c){g=c<<24>>24;M[d+64>>2]=0;h=c-108|0;if(h>>>0>13){break h}if(1<<h&12432){break f}if(h){if((h|0)!=2){break h}if(N[p+236|0]){break f}break g}if(!N[p+238|0]){break g}break f}b=e>>>29|0;h=yb(o);g=e<<3;c=g+h|0;b=h>>>0>c>>>0?b+1|0:b;c=c+25|0;b=c>>>0<25?b+1|0:b;c=Oe(c,b);if(c){M[c+16>>2]=20;b=e<<2;M[(b+c|0)+20>>2]=b+24;b=(c+g|0)+24|0;M[c+12>>2]=b;M[c+4>>2]=e;e=h+1|0;if(e){G(b,o,e)}K[c|0]=1;M[f+88>>2]=1;M[f+92>>2]=c;break e}M[f+88>>2]=1;M[f+92>>2]=0;break d}i:{switch(c-97|0){case 1:case 2:break f;case 0:break i;default:break g}}if(N[p+236|0]){break f}}M[d>>2]=g;$d(d- -64|0,18046,d);b=a;a=M[d+64>>2];Pb(b,a,-1);ab(a);break b}b=b+1|0;e=Sp(d+16|0,g)+e|0;continue}}j:{if(!N[c+1|0]){K[c+1|0]=1;h=c+20|0;q=120;break j}if(!N[c+2|0]){K[c+2|0]=1;h=((M[c+4>>2]<<2)+c|0)+24|0;q=120;break j}h=Bb(M[c+4>>2]<<2,0);if(!h){break d}q=1;if(!M[c+8>>2]){break j}b=M[c+4>>2]<<2;if(!b){break j}G(h,c+20|0,b)}M[d+44>>2]=h;M[d+24>>2]=M[f+24>>2];r=M[f>>2];M[d+72>>2]=0;v=d+32|0;e=h;c=0;while(1){k:{l:{m:{n:{o:{p:{q:{r:{s:{if(c){break s}u=o+t|0;b=N[u|0];if(!b){break s}c=b<<24>>24;K[d+40|0]=c;t:{u:{v:{w:{switch(b-108|0){default:switch(b-97|0){case 0:break t;case 1:break o;case 2:break v;default:break r};case 0:break l;case 1:case 3:case 5:case 6:break q;case 2:break u;case 4:break w;case 7:break n}}c=0;if(m){break k}M[e>>2]=M[d+24>>2];break k}c=0;if(m){break k}M[e>>2]=M[d+20>>2];break k}if(m){break p}M[d+64>>2]=0;M[d+68>>2]=0;c=Rp(r,d+72|0,d- -64|0,0,0);M[d+76>>2]=c;M[M[d+44>>2]>>2]=M[d+64>>2];break k}if(m){break p}c=Rp(r,d+72|0,d- -64|0,d+60|0,d+56|0);M[d+76>>2]=c;if(c){break k}c=M[d+68>>2];j=c;i=M[d+64>>2];e=_J(i,c,2,0);g=Qa;c=0;b=0;while(1){if(M[d+20>>2]<=(b|0)){break k}n=Ic(M[d+60>>2],d+48|0)+M[d+60>>2]|0;M[d+60>>2]=n;if(n>>>0>P[d+56>>2]){c=267;break m}else{k=M[d+44>>2]+(b<<2)|0;l=e+M[d+48>>2]|0;n=l>>>0<e>>>0?g+1|0:g;w=k,x=_J(l,n,i,j),M[w>>2]=x;b=b+1|0;continue}}}wb(M[d+72>>2]);x:{if(m){break x}b=M[f+92>>2];g=b+8|0;M[g>>2]=1;e=M[b+4>>2]<<2;if(!e){break x}G((e+g|0)+16|0,b+20|0,e)}if(c){break c}te(a,h,M[M[f+92>>2]+4>>2]<<2,q);break b}if((b|0)==121){break o}}b=M[f+16>>2];c=Pl(f,0,0);M[d+76>>2]=c;if(c){break k}if(!m){if(M[f+28>>2]){c=Rp(r,d+72|0,v,0,0);M[d+76>>2]=c;if(c){break k}}w=d,x=Df(b,121,d+16|0),M[w+76>>2]=x;iq(f,d+76|0);c=M[d+76>>2];if(c){break k}}Df(b,122,d+16|0)}c=0;break k}b=Sp(d+16|0,c)<<2;if(b){D(e,0,b)}c=Bx(M[f+16>>2],d+16|0);break m}c=Pl(f,0,0);M[d+76>>2]=c;if(c){break k}i=Oe(M[f+24>>2]<<4,0);if(!i){c=7;break m}Df(M[f+16>>2],123,i);j=0;b=M[d+24>>2];e=(b|0)>0?b:0;b=0;c=0;while(1){if((c|0)!=(e|0)){g=(c<<4)+i|0;b=b-M[M[M[g>>2]+20>>2]+64>>2]|0;M[g+4>>2]=b;c=c+1|0;continue}break}while(1){l=0;k=0;e=0;y:{z:{if(M[d+20>>2]<=(j|0)){c=0;break z}while(1){if(M[d+24>>2]>(e|0)){b=(e<<4)+i|0;c=Ol(f,M[b>>2],j,b+8|0);if(c){break z}if(M[b+8>>2]){M[b+12>>2]=M[b+4>>2];Ax(b);if(!M[b+8>>2]){c=267;break z}k=k+1|0}e=e+1|0;continue}break}while(1){if((k|0)<=0){break y}c=0;b=M[d+24>>2];n=(b|0)>0?b:0;g=0;e=0;while(1){if((c|0)!=(n|0)){b=(c<<4)+i|0;A:{if(!M[b+8>>2]){b=0;break A}g=(M[b+12>>2]>=M[g+12>>2]?g:0)?g:b;B:{if(e){s=1;if(M[b+12>>2]!=M[b-4>>2]){break B}}s=e+1|0}b=s;l=(b|0)>(l|0)?b:l}c=c+1|0;e=b;continue}break}k=k-Ax(g)|0;continue}}ab(i);break m}M[M[d+44>>2]+(j<<2)>>2]=l;j=j+1|0;continue}}M[d+76>>2]=c;break k}b=M[f+32>>2];g=M[f+36>>2];M[d+64>>2]=0;c=Tb(r,21,d- -64|0,0);e=M[d+64>>2];C:{D:{if(!c){Jb(e,1,b,g);if((Db(e)|0)==100){if((lh(e,0)|0)==4){break D}}b=wb(e);c=b?b:267;e=0}M[d+76>>2]=c;break C}c=0;M[d+76>>2]=0;b=Ye(e,0);g=b+Wd(e,0)|0;while(1){if(M[d+20>>2]<=(c|0)){break C}b=Ul(b,g,d- -64|0)+b|0;if(g>>>0<b>>>0){M[d+76>>2]=267}else{M[M[d+44>>2]+(c<<2)>>2]=M[d+64>>2];c=c+1|0;continue}break}}wb(e);c=M[d+76>>2]}e=M[d+44>>2]+(Sp(d+16|0,K[u|0])<<2)|0;M[d+44>>2]=e;t=t+1|0;continue}}h=0;c=7}ee(a,c);if(!q){break b}Ra[q|0](h)}Ne(p)}Na=d+80|0}function vy(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=Na-32|0;Na=h;M[h+4>>2]=0;u=1;t=c;while(1){a:{b:{c:{d:{e:{f:{if(!m){M[h>>2]=0;M[a+24>>2]=0;o=t>>31&t;i=b;g=t;while(1){if((g|0)>0){f=N[i|0]-9|0;if(f>>>0>23|!(1<<f&8388639)){break f}i=i+1|0;g=g-1|0;continue}break}if((t|0)<0){break e}m=101;p=0;break a}i=M[h+4>>2];M[e>>2]=c-t;f=(m|0)==101?i?u?1:m:m:m;a=0;if((f|0)==101){break c}break d}o=g}q=i-b|0;r=i+1|0;k=0;p=0;g=0;while(1){g:{h:{i:{if((g|0)!=4){f=g<<3;if(N[f+57477|0]>1){break h}j=f+57472|0;f=N[j+4|0];if((o|0)<(f|0)){break h}if(Qb(i,M[j>>2],f)){break h}M[h+28>>2]=10;v=N[j+6|0];if(!((v|0)!=1|N[i+4|0]!=47|(N[i+5|0]-48&255)>>>0>9)){f=(cy(f+r|0,h+28|0)+f|0)+1|0}j=N[f+i|0];j:{if(j>>>0>=42){break j}l=j&31;if((j&63)>>>0>=32){l=773>>>l|0}else{l=((1<<l)-1&773)<<32-l|15873>>>l}if(!(l&1)){break j}m=j&31;if((j&63)>>>0>=32){n=772>>>m|0}else{n=((1<<m)-1&772)<<32-m|1>>>m}l=Oe(48,0);if(l){M[l>>2]=v;M[l+4>>2]=M[h+28>>2];M[h>>2]=l;p=f+q|0;m=0;k=l;if(n&1){break j}break g}m=7;if(!(n&1)){break a}}f=j-34|0;if(f>>>0>7|!(1<<f&193)){break i}break g}k:{l:{m:{g=N[i|0];switch(g-40|0){case 0:break k;case 1:break l;default:break m}}if((g|0)==34){g=1;f=(o|0)<=1?1:o;while(1){n:{if((g|0)!=(f|0)){if(N[g+i|0]!=34){break n}f=g}m=1;p=(f+q|0)+1|0;if((f|0)==(o|0)){break a}j=M[a>>2];q=M[j>>2];k=0;o=0;l=0;g=0;o:{p:{q:{v=f-1|0;m=pg(j,M[a+4>>2],r,v,h+28|0);if(m){break q}j=0;f=0;m=0;while(1){if(m){break q}M[h+20>>2]=0;M[h+16>>2]=0;M[h+12>>2]=0;M[h+8>>2]=0;m=Ra[M[q+20>>2]](M[h+28>>2],h+24|0,h+20|0,h+16|0,h+12|0,h+8|0)|0;if(m){j=j+1|0;f=j?f:f+1|0;continue}n=ZJ(j,f,24,0);n=n+144|0;k=$p(k,n&-8,0);g=M[h+20>>2]+l|0;o=$p(o,g,g>>31);if(!o|!k){break p}g=S(j,24)+k|0;M[g+120>>2]=0;M[g+124>>2]=0;M[g+136>>2]=0;M[g+140>>2]=0;M[g+128>>2]=0;M[g+132>>2]=0;n=M[h+20>>2];if(n){G(l+o|0,M[h+24>>2],n)}w=M[h+20>>2];M[g+124>>2]=w;n=M[h+12>>2];if((n|0)<(v|0)){n=N[n+r|0]==42}else{n=0}M[g+128>>2]=n;l=l+w|0;n=M[h+16>>2];if((n|0)>0){n=N[i+n|0]==94}else{n=0}M[g+132>>2]=n;j=j+1|0;f=j?f:f+1|0;g=j;continue}}if((m|0)!=101){break o}f=S(g,24);k=$p(k,(f+l|0)+144|0,0);if(!k){m=7;k=0;break o}D(k,0,120);i=k+48|0;M[k+20>>2]=i;M[k>>2]=5;j=M[a+20>>2];M[k+112>>2]=g;M[k+116>>2]=j;g=(f+k|0)+120|0;m=0;if(o){if(l){G(g,o,l)}i=M[k+20>>2]}f=M[i+64>>2];f=(f|0)>0?f:0;j=i+76|0;l=i+72|0;i=0;while(1){if((f|0)==(i|0)){break o}r=S(i,24);M[r+l>>2]=g;i=i+1|0;g=M[j+r>>2]+g|0;continue}}m=7}g=M[h+28>>2];if(g){Ra[M[q+16>>2]](g)|0}ab(o);if(m){ab(k);k=0}M[h>>2]=k;break g}g=g+1|0;continue}}p=0;g=M[a+16>>2];k=(g|0)>0?g:0;f=M[a+20>>2];g=0;while(1){r:{s:{if((g|0)==(k|0)){g=f;break s}m=M[M[a+8>>2]+(g<<2)>>2];j=yb(m);if((j|0)>=(o|0)|N[i+j|0]!=58){break r}if(Eb(m,i,j)){break r}p=(j+q|0)+1|0}i=0;o=t-p|0;l=(o|0)>0?o:0;f=b+p|0;j=M[a>>2];q=M[j>>2];while(1){t:{if((i|0)!=(l|0)){k=N[f+i|0]-34|0;if(k>>>0>7|!(1<<k&193)){break t}l=i}k=0;m=pg(j,M[a+4>>2],f,l,h+28|0);if(!m){M[h+20>>2]=0;M[h+16>>2]=0;M[h+12>>2]=0;M[h+8>>2]=0;r=M[h+28>>2];j=Ra[M[q+20>>2]](r,h+24|0,h+20|0,h+16|0,h+12|0,h+8|0)|0;u:{if(!j){k=Oe(M[h+20>>2]+144|0,0);if(!k){k=0;l=M[h+12>>2];m=7;break u}M[k+116>>2]=g;M[k+112>>2]=1;M[k>>2]=5;M[k+20>>2]=k+48;g=M[h+20>>2];j=k+144|0;M[k+120>>2]=j;M[k+124>>2]=g;if(g){G(j,M[h+24>>2],g)}l=M[h+12>>2];if(!((o|0)<=(l|0)|N[f+l|0]!=42)){M[k+128>>2]=1;l=l+1|0;M[h+12>>2]=l}g=f-1|0;f=M[a+12>>2];i=M[h+16>>2];while(1){if(!(!f|(i|0)<=0|N[g+i|0]!=94)){M[k+132>>2]=1;i=i-1|0;continue}break}M[h+16>>2]=i;m=0;break u}m=l?(j|0)!=101?j:0:j}Ra[M[q+16>>2]](r)|0}M[h>>2]=k;p=l+p|0;break g}i=i+1|0;continue}}g=g+1|0;continue}}M[a+32>>2]=M[a+32>>2]-1;p=q+1|0;m=101;break a}M[h+28>>2]=0;m=1;g=M[a+32>>2];M[a+32>>2]=g+1;if((g|0)>999){break g}m=vy(a,r,o-1|0,h,h+28|0);p=(q+M[h+28>>2]|0)+1|0;k=M[h>>2];break g}if(!j){break g}}g=g+1|0;continue}break}if(!k|m){break a}v:{w:{j=M[k>>2];if((j|0)==5){g=0;l=(u|0)!=0;i=1;break w}l=(u|0)!=0;f=M[k+12>>2];i=(f|0)!=0;g=!f;if(f|!u){break w}f=1;break v}x:{y:{if(!(g|l)){f=Oe(48,0);if(f){break y}f=7;break v}if(s){break x}s=0;break b}M[f>>2]=3;$x(h+4|0,s,f);s=f}if(!(!((j|0)!=1|i)&M[s>>2]!=5)){if(i^1|(j|0)==5|M[s>>2]!=1){break b}}k=M[h>>2];f=1}Le(k);i=M[h+4>>2]}Le(i);i=0;Le(0);a=f}M[d>>2]=i;Na=h+32|0;return a}z:{A:{B:{if(i){f=M[h>>2];if(!M[h+4>>2]){break B}M[s+16>>2]=f;M[f+8>>2]=s;break A}$x(h+4|0,s,M[h>>2]);f=M[h>>2];break z}M[h+4>>2]=f}}s=f;m=0;u=g}b=b+p|0;t=t-p|0;continue}}function nG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Na-32|0;Na=f;M[f+16>>2]=0;M[f+12>>2]=0;a:{b:{c:{d:{e:{f:{g:{h:{if((b|0)<2){break h}h=M[a+24>>2];i=O[M[c>>2]+16>>1];e=i&31;i:{if((i&63)>>>0>=32){i=1<<e;j=0}else{j=1<<e;i=j-1&1>>>32-e}if(!(j&-1431655766|i&-1431655766)){break i}i=M[((h<<2)+c|0)+8>>2];g=O[i+16>>1];e=g&31;if((g&63)>>>0>=32){g=1<<e;j=0}else{j=1<<e;g=j-1&1>>>32-e}if(j&-1431655766|g&-1431655766){break i}b=gb(i);c=Fb(i);if(!b){g=7;break c}j:{switch(c-7|0){case 1:if(Eb(b,12937,8)){break f}g=oy(a,0);break c;case 0:if(Eb(b,15083,7)){break f}g=ny(a,0);if(g){break c}M[f+24>>2]=0;M[f>>2]=M[a+224>>2];b=Hb(7325,f);if(!b){g=7;M[f+28>>2]=7;break e}g=th(M[a+12>>2],b,-1,f+24|0,0);M[f+28>>2]=g;ab(b);if(g){break e}b=M[a+24>>2];b=ZJ(b,b>>31,12,0);e=Qa;b=b+12|0;e=b>>>0<12?e+1|0:e;d=Bb(b,e);if(!d){g=7;M[f+28>>2]=7;break e}g=0;if(b){D(d,0,b)}b=(M[a+24>>2]<<2)+4|0;e=b+d|0;l=e+b|0;break d;default:break j}}if((c|0)==15){break g}if((c|0)>=7){break f}g=1;if((c|0)!=5){break c}if(Eb(b,12351,5)){break c}g=Sj(a);break c}if(!(sb(M[((h<<2)+c|0)+16>>2])&-2147483648)){break h}M[f+16>>2]=19;break b}h=M[a+24>>2];e=h>>31<<3|h>>>29;h=(h<<3)+8|0;e=h>>>0<8?e+1|0:e;g=Bb(h,e);if(!g){M[f+16>>2]=7;break b}m=M[a+24>>2]+1|0;e=m<<3;if(e){D(g,0,e)}k:{if(M[a+272>>2]){M[f+16>>2]=0;break k}e=Tb(a,16,f+28|0,0);if(e){M[f+16>>2]=e;break a}e=M[f+28>>2];Ge(e,0);Db(e);e=wb(e);M[f+16>>2]=e;if(e){break a}}j=1;h=1;l:{if((b|0)<2){break l}h=1;if(M[a+40>>2]){break l}l=M[((M[a+24>>2]<<2)+c|0)+12>>2];e=O[l+16>>1];h=e&31;if((e&63)>>>0>=32){e=1<<h;k=0}else{k=1<<h;e=k-1&1>>>32-h}i=k;if(i&-1431655766|e&-1431655766){l=M[c+4>>2];e=O[l+16>>1];h=e&31;if((e&63)>>>0>=32){e=1<<h;k=0}else{k=1<<h;e=k-1&1>>>32-h}i=k}h=1;if(i&-1431655766|e&-1431655766){break l}i=M[c>>2];e=O[i+16>>1];h=e&31;if((e&63)>>>0>=32){e=1<<h;k=0}else{k=1<<h;e=k-1&1>>>32-h}if(!(k&-1431655766|e&-1431655766)){e=sb(i);i=Qa;h=1;if((sb(l)|0)==(e|0)&(Qa|0)==(i|0)){break l}}h=N[M[a+12>>2]+92|0];m:{if((h|0)==5){e=my(a,l,f+12|0,g);break m}e=ly(a,c,d)}M[f+16>>2]=e;if(e){break a}h=(h|0)==5}l=M[c>>2];e=O[l+16>>1];i=e&31;if((e&63)>>>0>=32){e=1<<i;k=0}else{k=1<<i;e=k-1&1>>>32-i}if(!(k&-1431655766|e&-1431655766)){e=my(a,l,f+12|0,g);M[f+16>>2]=e;j=!e}i=(m<<2)+g|0;if(!(!j|(b|0)<2)){b=sb(M[((M[a+24>>2]<<2)+c|0)+16>>2]);n:{o:{p:{if(!h){break p}e=ly(a,c,d);M[f+16>>2]=e;if(!e){break p}if(M[a+40>>2]|(e|0)!=19){break n}d=267;break o}e=b;b=hq(a,0,b,M[d>>2],M[d+4>>2]);M[f+16>>2]=b;if(b){break n}b=2;while(1){if((M[a+24>>2]+2|0)<=(b|0)){d=0;break o}d=b-2|0;if(!N[d+M[a+32>>2]|0]){h=(b<<2)+c|0;d=gq(a,e,gb(M[h>>2]),d,i+(d<<2)|0);if(d){break o}d=Fb(M[h>>2]);h=i+(M[a+24>>2]<<2)|0;M[h>>2]=d+M[h>>2]}b=b+1|0;continue}}M[f+16>>2]=d}if(N[a+238|0]){ky(f+16|0,a,i)}M[f+12>>2]=M[f+12>>2]+1}if(!N[a+236|0]){break a}jy(f+16|0,a,i,g,M[f+12>>2]);break a}if(Eb(b,12122,15)){break f}M[f+28>>2]=0;b=hy(a,f+28|0);g=b|M[f+28>>2]?b:267;break c}if(!Eb(b,22012,6)){M[f+24>>2]=b+6;e=f+24|0;h=fq(e);b=8;d=M[f+24>>2];c=N[d|0];if((c|0)==44){g=1;if(!N[d+1|0]){break c}M[f+24>>2]=d+1;b=fq(e);c=N[M[f+24>>2]]}g=1;if(c&255|(b|0)<2){break c}M[f+28>>2]=0;q:{if(!N[a+237|0]){eq(f+28|0,a);g=M[f+28>>2];if(g){break q}}g=gy(a,h,b)}Ne(a);break c}g=1;if(c>>>0<11){break c}if(Eb(b,22008,10)){break c}M[f+28>>2]=b+10;M[f+24>>2]=0;M[f+20>>2]=0;b=fq(f+28|0);M[a+48>>2]=(b|0)==1?8:(b|0)>16?8:b;if(!N[a+237|0]){eq(f+24|0,a);g=M[f+24>>2];if(g){break c}}g=Tb(a,23,f+20|0,0);if(g){break c}b=M[f+20>>2];Jb(b,1,2,0);fd(b,2,M[a+48>>2]);Db(b);g=wb(b);break c}e=0;d=0}j=M[f+24>>2];while(1){r:{if(g){break r}if((Db(j)|0)!=100){break r}c=0;h=dq(a,j);g=hq(a,0,h,dd(j,0),Qa);b=(M[a+24>>2]<<2)+4|0;if(b){D(d,0,b)}while(1){s:{if(g){break s}b=c;if((b|0)>=M[a+24>>2]){break s}c=b+1|0;g=0;if(N[b+M[a+32>>2]|0]){continue}g=gq(a,h,ff(j,c),b,(b<<2)+d|0);b=Wd(j,c);i=(M[a+24>>2]<<2)+d|0;M[i>>2]=b+M[i>>2];continue}break}M[f+28>>2]=g;b=0;if(N[a+238|0]){ky(f+28|0,a,d);g=M[f+28>>2]}if(g){cd(j);j=0;g=1}else{while(1){if((b|0)<=M[a+24>>2]){c=b<<2;h=c+e|0;M[h>>2]=M[h>>2]+M[c+d>>2];b=b+1|0;continue}break}m=m+1|0}continue}break}if(N[a+236|0]){jy(f+28|0,a,e,l,m)}ab(d);if(!j){g=M[f+28>>2];break c}b=cd(j);c=M[f+28>>2];g=c?c:b}M[f+16>>2]=g}g=0}ab(g);Ne(a);Na=f+32|0;return M[f+16>>2]}function _h(a,b){var c=0,d=0,e=0,f=0,g=0;d=1;e=1;c=1;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{f=N[a|0];switch(N[f+37088|0]){case 0:break k;case 1:break l;case 11:break H;case 12:break y;case 13:break x;case 14:break z;case 15:break w;case 16:break B;case 17:break G;case 18:break F;case 19:break E;case 20:break D;case 2:case 27:break g;case 21:break C;case 22:break A;case 23:break u;case 24:break t;case 25:break s;case 26:break q;case 29:break i;case 30:break j;case 3:break p;case 4:case 5:break m;case 6:break n;case 7:break I;case 8:break r;case 9:break o;case 10:break v;default:break h}}while(1){c=e;e=c+1|0;if(K[N[a+c|0]+31408|0]&1){continue}break}M[b>>2]=184;return c}J:{c=N[a+1|0];if((c|0)!=62){if((c|0)!=45){break J}c=2;while(1){d=N[a+c|0];if(!(!d|(d|0)==10)){c=c+1|0;continue}break}M[b>>2]=185;return c}M[b>>2]=113;return N[a+2|0]==62?3:2}M[b>>2]=108;break b}M[b>>2]=22;break b}M[b>>2]=23;break b}M[b>>2]=1;break b}M[b>>2]=107;break b}M[b>>2]=109;break b}if(N[a+1|0]!=42){break f}c=N[a+2|0];if(!c){break f}d=3;K:{while(1){e=(c&255)==42;c=N[a+d|0];if(!(e&(c|0)==47)){if(!(c&255)){break K}d=d+1|0;continue}break}d=d+1|0}M[b>>2]=185;return d}M[b>>2]=111;break b}M[b>>2]=54;return N[a+1|0]==61?2:1}L:{switch(N[a+1|0]-60|0){case 1:M[b>>2]=56;break a;case 2:M[b>>2]=53;break a;case 0:M[b>>2]=105;break a;default:break L}}M[b>>2]=57;break b}M:{switch(N[a+1|0]-61|0){case 0:M[b>>2]=58;break a;case 1:M[b>>2]=106;break a;default:break M}}M[b>>2]=55;break b}if(N[a+1|0]!=61){M[b>>2]=186;break b}M[b>>2]=53;break a}if(N[a+1|0]!=124){M[b>>2]=104;break b}M[b>>2]=112;break a}M[b>>2]=25;break b}M[b>>2]=103;break b}M[b>>2]=115;break b}N:{while(1){c=N[a+d|0];if(!c){break N}O:{if((c|0)==(f|0)){d=d+1|0;if(N[d+a|0]!=(f|0)){break O}}d=d+1|0;continue}break}if((f|0)==39){M[b>>2]=118;return d}M[b>>2]=60;return d}M[b>>2]=186;return d}if(N[a+1|0]-58>>>0>4294967285){break p}M[b>>2]=142;break b}f=156;M[b>>2]=156;d=N[a|0];if(!(N[N[a+2|0]+31408|0]&8)|((d|0)!=48|(N[a+1|0]|32)!=120)){break e}c=3;while(1){d=N[a+c|0];if(!(N[d+31408|0]&8)){if((d|0)!=95){break d}M[b>>2]=183}c=c+1|0;continue}}P:{while(1){c=60;if((f|0)==93){break P}f=N[a+d|0];if(f){d=d+1|0;continue}break}c=186}M[b>>2]=c;return d}M[b>>2]=157;while(1){c=d;d=c+1|0;if(N[a+c|0]-58>>>0>=4294967286){continue}break}break c}M[b>>2]=157;e=0;Q:{while(1){d=N[a+c|0];if(!d){break Q}R:{S:{if(N[d+31408|0]&70){e=e+1|0;break S}if(!((d|0)!=40|(e|0)<=0)){while(1){d=c;c=c+1|0;f=N[c+a|0];if(!f){break R}g=(f|0)!=41;if(g&!(K[f+31408|0]&1)){continue}break}if(g){break R}c=d+2|0;break Q}if((d|0)!=58){break Q}d=c+1|0;if(N[d+a|0]!=58){break Q}c=d}c=c+1|0;continue}break}M[b>>2]=186}if(e){break c}M[b>>2]=186;return c}if(N[N[a+1|0]+37088|0]>=3){break g}c=2;while(1){d=c;c=c+1|0;e=N[a+d|0];if(N[e+37088|0]<3){continue}break}if(N[e+31408|0]&70){break g}M[b>>2]=60;return kw(a,d,b)}if(N[a+1|0]!=39){break g}M[b>>2]=155;d=2;while(1){c=d;d=c+1|0;e=N[a+c|0];if(N[e+31408|0]&8){continue}break}T:{if((e|0)==39){d=1;if(!(c&1)){break T}}M[b>>2]=186;while(1){b=N[a+c|0];if(!(!b|(b|0)==39)){c=c+1|0;continue}break}d=(b|0)!=0}return c+d|0}if(N[a+1|0]!=187|N[a+2|0]!=191){break g}M[b>>2]=184;return 3}M[b>>2]=186;return 0}M[b>>2]=186;break b}while(1){d=c;c=c+1|0;if(N[N[a+d|0]+31408|0]&70){continue}break}M[b>>2]=60;c=d;break c}M[b>>2]=110;break b}c=0;U:{V:{while(1){W:{e=d&255;if(e-58>>>0<=4294967285){if((e|0)!=95){if((e|0)!=46){break U}e=154;if((f|0)!=156){break W}d=0;break V}M[b>>2]=183;f=183}c=c+1|0;d=N[c+a|0];continue}break}d=1}while(1){if(!d){M[b>>2]=e;f=e;d=1;continue}while(1){c=c+1|0;d=N[c+a|0];if(d-58>>>0>4294967285){continue}break}e=183;if((d|0)!=95){break U}d=0;continue}}if(((d|32)&255)!=101){break d}d=a+c|0;e=N[d+1|0];if(e-58>>>0<=4294967285){X:{switch(e-43|0){case 0:case 2:break X;default:break d}}if(N[d+2|0]-58>>>0<=4294967285){break d}}if((f|0)==156){M[b>>2]=154}c=c+2|0;while(1){d=N[a+c|0];if(d-58>>>0<=4294967285){if((d|0)!=95){break d}M[b>>2]=183}c=c+1|0;continue}}while(1){if(!(N[N[a+c|0]+31408|0]&70)){break c}M[b>>2]=186;c=c+1|0;continue}}return c}return 1}return 2}function pd(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=Na-128|0;Na=j;a:{if(M[c>>2]|N[b+32|0]){break a}i=b+32|0;h=N[a+52|0];K[b+33|0]=1;b:{c:{d:{switch(M[b>>2]-1|0){case 0:case 2:i=M[b+16>>2];f=M[b+12>>2];if(N[f+34|0]){pd(a,i,c);a=M[i+28>>2];M[b+24>>2]=M[i+24>>2];M[b+28>>2]=a;K[b+32|0]=N[i+32|0];break a}e=N[i+34|0];pd(a,f,c);if(e){a=M[f+28>>2];M[b+24>>2]=M[f+24>>2];M[b+28>>2]=a;K[b+32|0]=N[f+32|0];break a}pd(a,i,c);while(1){if(N[f+32|0]){e=M[f+28>>2];M[b+24>>2]=M[f+24>>2];M[b+28>>2]=e;e=1;break b}m=N[i+32|0];if(m){e=M[f+24>>2];g=M[f+28>>2];break c}e=M[f+24>>2];g=M[f+28>>2];if(M[c>>2]){break c}d=M[i+24>>2];k=M[i+28>>2];d=(d>>>0<e>>>0&(k|0)<=(g|0)|(g|0)>(k|0))-((g|0)<=(k|0)&d>>>0>e>>>0|(g|0)<(k|0))|0;d=h?0-d|0:d;if(!d){break c}pd(a,(d|0)<0?f:i,c);continue};case 3:m=h?-1:1;g=M[b+12>>2];d=M[b+16>>2];e=g;e:{if(N[d+32|0]){break e}e=M[g+24>>2];f=M[d+24>>2];h=M[g+28>>2];k=M[d+28>>2];f=S(m,(e>>>0>f>>>0&(h|0)>=(k|0)|(h|0)>(k|0))-((h|0)<=(k|0)&f>>>0>e>>>0|(h|0)<(k|0))|0);h=N[g+32|0];if(!h){e=g;if((f|0)<0){break e}}e=d;if(h){break e}e=d;if((f|0)>0){break e}pd(a,g,c);e=d}pd(a,e,c);K[i|0]=N[g+32|0]?N[d+32|0]!=0:0;a=M[g+24>>2];e=M[g+28>>2];f:{if(!N[d+32|0]){c=M[d+24>>2];d=M[d+28>>2];if(N[g+32|0]|(S(m,(a>>>0>c>>>0&(e|0)>=(d|0)|(d|0)<(e|0))-(a>>>0<c>>>0&(d|0)>=(e|0)|(d|0)>(e|0))|0)|0)>=0){break f}}M[b+24>>2]=a;M[b+28>>2]=e;break a}M[b+24>>2]=c;M[b+28>>2]=d;break a;case 1:g=M[b+12>>2];f=M[b+16>>2];if(!N[f+33|0]){pd(a,f,c)}pd(a,g,c);e=N[g+32|0];if(!e){while(1){g:{if(M[c>>2]|N[f+32|0]){break g}e=M[g+24>>2];d=M[f+24>>2];i=M[g+28>>2];k=M[f+28>>2];e=(e>>>0>d>>>0&(i|0)>=(k|0)|(i|0)>(k|0))-((i|0)<=(k|0)&d>>>0>e>>>0|(i|0)<(k|0))|0;if(((h?0-e|0:e)|0)<=0){break g}pd(a,f,c);continue}break}e=N[g+32|0]}a=M[g+24>>2];c=M[g+28>>2];K[b+32|0]=e;M[b+24>>2]=a;M[b+28>>2]=c;break a;default:break d}}h=M[b+20>>2];ii(h);m=M[a>>2];h:{if(M[h+40>>2]){K[j+127|0]=0;i:{j:{if(M[h+64>>2]==1){k=Tx(m,M[h+92>>2],h+16|0,h+28|0,h+32|0);f=!M[h+28>>2];break j}p=N[a+52|0];D(j+16|0,0,96);q=p?-1:1;while(1){a=0;e=0;g=0;l=0;if(f){break j}while(1){if(!(N[j+127|0]|(M[h+64>>2]<=(a|0)|k))){f=(j+16|0)+S(a,24)|0;k=Sx(m,h,a,f,j+127|0);if(!M[f>>2]){d=M[f+8>>2];f=M[f+12>>2];if(l){o=d;n=e;e=(d>>>0<e>>>0&(f|0)<=(g|0)|(f|0)<(g|0))-(d>>>0>e>>>0&(f|0)>=(g|0)|(f|0)>(g|0))|0;d=((p?0-e|0:e)|0)<0;e=d?o:n;g=d?f:g}else{e=d;g=f}l=1}a=a+1|0;continue}break}a=0;while(1){d=M[h+64>>2];if((a|0)<(d|0)){while(1){k:{if(N[j+127|0]|k){break k}d=(j+16|0)+S(a,24)|0;if(M[d>>2]){break k}l=M[d+8>>2];f=M[d+12>>2];if((S(q,(e>>>0<l>>>0&(g|0)<=(f|0)|(f|0)>(g|0))-((f|0)<=(g|0)&e>>>0>l>>>0|(f|0)<(g|0))|0)|0)>=0){break k}k=Sx(m,h,a,d,j+127|0);f=M[d+8>>2];n=f;d=M[d+12>>2];f=(S(q,(f>>>0>e>>>0&(d|0)>=(g|0)|(d|0)>(g|0))-(f>>>0<e>>>0&(d|0)<=(g|0)|(d|0)<(g|0))|0)|0)>0;e=f?n:e;g=f?d:g;a=f?0:a;continue}break}a=a+1|0;continue}break}f=N[j+127|0];if(f){continue}a=M[(S(d,24)+j|0)+12>>2];d=a>>31;l=a+8|0;d=l>>>0<8?d+1|0:d;d=Bb(l,d);if(!d){break i}l=a+1|0;if(l){G(d,M[(S(M[h+64>>2],24)+j|0)+8>>2],l)}a=a+d|0;K[a|0]=0;K[a+1|0]=0;K[a+2|0]=0;K[a+3|0]=0;K[a+4|0]=0;K[a+5|0]=0;K[a+6|0]=0;K[a+7|0]=0;a=0;o=0;l:{while(1){n=M[h+64>>2];l=n-1|0;if((l|0)<=(a|0)){break l}m:{l=(j+16|0)+S(a,24)|0;if(!M[l>>2]){M[j+12>>2]=M[l+16>>2];M[j+8>>2]=d;M[j+4>>2]=d;if(!hi(j+4|0,n+(a^-1)|0,0,1,j+12|0,j+8|0)){break m}o=M[j+4>>2]-d|0}a=a+1|0;continue}break}l=M[h+64>>2]-1|0}if((a|0)!=(l|0)){ab(d);continue}break}M[h+32>>2]=o;M[h+28>>2]=d;M[h+16>>2]=e;M[h+20>>2]=g;M[h+24>>2]=1;f=0}K[i|0]=f;break h}k=7;break h}n:{o:{e=N[a+52|0];a=N[m+239|0];if((e|0)==(a|0)){break o}e=M[h+4>>2];if(!e){break o}_l(a,M[h>>2],e,h+8|0,h+16|0,h+32|0,i);M[h+28>>2]=M[h+8>>2];break n}Rx(m,h,i)}}M[c>>2]=k;a=M[h+20>>2];M[b+24>>2]=M[h+16>>2];M[b+28>>2]=a;break a}M[b+24>>2]=e;M[b+28>>2]=g;e=(m|0)!=0}K[b+32|0]=e;if(!e|M[b>>2]!=1){break a}p:{b=M[i+20>>2];if(!M[b>>2]){break p}while(1){if(M[c>>2]|N[i+32|0]){break p}e=M[b+32>>2];if(e){D(M[b+28>>2],0,e)}pd(a,i,c);continue}}q:{b=M[f+20>>2];if(!b|!M[b>>2]){break q}while(1){if(M[c>>2]|N[f+32|0]){break q}e=M[b+32>>2];if(e){D(M[b+28>>2],0,e)}pd(a,f,c);continue}}K[f+32|0]=1;K[i+32|0]=1}Na=j+128|0}function Zv(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,Q=0;m=Na-144|0;Na=m;M[m+12>>2]=0;l=8;if(!N[a+46|0]){u=c;k=cg(a,1,1);a:{if(k){break a}K[a+45|0]=1;b:{c:{if(!c){u=0;break c}u=0;k=al(a,d,e,0,1);if((k|0)==5){d=0;break c}if(k){u=c;break b}K[a+44|0]=1;u=c}k=jv(a,m+12|0)}if(k){break a}t=M[a+68>>2];q=O[a+66>>1];q=(q<<16|q)&130560;d:{if(!(!t|(g|0)==(q|0))){k=db(69476);break d}v=M[M[a+32>>2]>>2];e:{if(P[v+96>>2]>=t>>>0){k=0}else{r=v+100|0;E=M[a+72>>2];k=0;l=1;while(1){if((l|0)!=5){n=r+(l<<2)|0;g=M[n>>2];f:{if(g>>>0>=t>>>0){break f}o=l+3|0;k=al(a,d,e,o,1);if((k|0)==5){t=g;d=0;break f}if(k){break e}M[n>>2]=(l|0)!=1?-1:t;Ee(a,o,1);k=0}l=l+1|0;continue}break}g:{if(P[v+96>>2]>=t>>>0){break g}o=M[v+96>>2];z=M[a+68>>2];s=z+33>>>12|0;k=0;g=(z>>>0>=4096?4096:z)<<1;n=g;l=(S(s,20)+(z<<1)|0)+28|0;g=g+l|0;k=n>>>0>g>>>0?1:k;p=Bb(g,k);if(!p){k=7;p=0;break e}k=0;if(l){D(p,0,l)}M[p+4>>2]=s+1;C=p+8|0;y=l+p|0;g=o+34>>>12|0;while(1){if(!(g>>>0>s>>>0|k)){k=hl(a,g,m+16|0);if(!k){h:{if((g|0)==(s|0)){l=M[m+24>>2];o=z-l|0;break h}l=M[m+24>>2];o=M[m+16>>2]-M[m+20>>2]>>2}n=M[p+4>>2];r=l+1|0;M[m+24>>2]=r;w=(S(n,20)+C|0)+(l<<1)|0;l=0;B=(o|0)>0?o:0;while(1){if((l|0)!=(B|0)){L[w+(l<<1)>>1]=l;l=l+1|0;continue}break}x=M[m+20>>2];l=0;M[m+140>>2]=0;M[m+136>>2]=0;D(m+32|0,0,104);A=0;while(1){if((A|0)!=(B|0)){M[m+140>>2]=1;M[m+136>>2]=w+(A<<1);l=0;while(1){if(A>>>l&1){n=(m+32|0)+(l<<3)|0;Xu(x,M[n+4>>2],M[n>>2],m+136|0,m+140|0,y);l=l+1|0;continue}break}n=(m+32|0)+(l<<3)|0;M[n+4>>2]=M[m+136>>2];M[n>>2]=M[m+140>>2];A=A+1|0;continue}break}while(1){l=l+1|0;if(l>>>0<=12){if(!(o>>>l&1)){continue}n=(m+32|0)+(l<<3)|0;Xu(x,M[n+4>>2],M[n>>2],m+136|0,m+140|0,y);continue}break}o=S(g,20)+C|0;M[o+12>>2]=M[m+140>>2];M[o+16>>2]=r;M[o+8>>2]=x;M[o+4>>2]=w}g=g+1|0;continue}break}if(k){ab(p);p=0;break g}k=al(a,d,e,3,1);if(k){break g}B=M[v+96>>2];M[v+128>>2]=t;i:{j:{x=f>>>2&3;if(!x){break j}f=M[a+8>>2];l=Ra[M[M[f>>2]+20>>2]](f,x)|0;if(!l){break j}break i}F=m,G=ZJ(q,0,E,0),M[F+32>>2]=G;M[m+36>>2]=Qa;f=M[a+4>>2];Ra[M[M[f>>2]+40>>2]](f,39,0)|0;f=M[a+4>>2];l=Ra[M[M[f>>2]+24>>2]](f,m+16|0)|0;if(l){break i}l=M[m+20>>2];k=M[m+36>>2];g=M[m+16>>2];f=M[m+32>>2];k:{if((l|0)>=(k|0)&g>>>0>=f>>>0|(k|0)<(l|0)){break k}o=ZJ(M[a+68>>2],0,q,0);n=o+g|0;g=Qa+l|0;g=o>>>0>n>>>0?g+1|0:g;o=n+65536|0;g=o>>>0<65536?g+1|0:g;if((g|0)<=(k|0)&f>>>0>o>>>0|(g|0)<(k|0)){l=db(67403);break i}g=M[a+4>>2];f=M[g>>2];if(!f){break k}Ra[M[f+40>>2]](g,5,m+32|0)|0}l=0}o=q|24;w=0;while(1){l:{k=l;if(l){break l}y=M[p+4>>2];r=M[p>>2];f=-1;m:while(1){if((y|0)>0){y=y-1|0;s=S(y,20)+C|0;l=M[s>>2];g=M[s+12>>2];n=(g|0)<(l|0)?l:g;while(1){if((l|0)==(n|0)){continue m}k=O[M[s+4>>2]+(l<<1)>>1];g=M[M[s+8>>2]+(k<<2)>>2];if(g>>>0>r>>>0){if(f>>>0<=g>>>0){continue m}w=k+M[s+16>>2]|0;f=g;continue m}else{l=l+1|0;M[s>>2]=l;continue}}}break}M[p>>2]=f;if((f|0)==-1){k=0;break l}if(M[b+296>>2]){k=N[b+87|0]?7:9;break l}l=0;if(t>>>0<w>>>0|w>>>0<=B>>>0|f>>>0>E>>>0){continue}n=M[a+8>>2];g=q;k=ZJ(w-1|0,0,o,0);r=Qa;k=k+56|0;r=k>>>0<56?r+1|0:r;k=Ra[M[M[n>>2]+8>>2]](n,h,g,k,r)|0;if(k){break l}g=M[a+4>>2];k=(G=g,H=h,I=q,J=ZJ(q,0,f-1|0,0),Q=Qa,F=M[M[g>>2]+12>>2],Ra[F](G|0,H|0,I|0,J|0,Q|0)|0);if(!k){continue}}break}f=M[a+4>>2];b=M[f>>2];if(b){Ra[M[b+40>>2]](f,37,0)|0}n:{if(k){break n}o:{if(M[M[M[a+32>>2]>>2]+16>>2]!=(t|0)){break o}f=M[a+4>>2];k=(Q=f,J=ZJ(q,0,M[a+72>>2],0),I=Qa,F=M[M[f>>2]+16>>2],Ra[F](Q|0,J|0,I|0)|0);if(k){break n}if(!x){break o}b=M[a+4>>2];k=Ra[M[M[b>>2]+20>>2]](b,x)|0;if(k){break n}}M[v+96>>2]=t;k=0}Ee(a,3,1)}k=(k|0)!=5?k:0}if(k|!u){break e}if(P[v+96>>2]<P[a+68>>2]){k=5;break e}if((u|0)<2){k=0;break e}pe(4,m+32|0);k=al(a,d,e,4,4);if(k){break e}k=0;if((u|0)==3){uv(a,M[m+32>>2]);b=M[a+8>>2];k=Ra[M[M[b>>2]+16>>2]](b,0,0)|0}Ee(a,4,4)}ab(p)}if(k?(k|0)!=5:0){break a}if(i){M[i>>2]=M[a+68>>2]}if(!j){break a}M[j>>2]=M[M[M[a+32>>2]>>2]+96>>2]}if(M[m+12>>2]){D(a+52|0,0,48)}Vo(a);if(N[a+45|0]){Ee(a,1,1);K[a+45|0]=0}l=(c|0)==(u|0)?k:k?k:5}Na=m+144|0;return l}function IA(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=Na-96|0;Na=h;L[h+18>>1]=65535;o=M[a>>2];e=M[a+8>>2];j=M[o+4>>2]+S(N[e+16|0],48)|0;k=j+8|0;m=M[j+16>>2];r=M[a+4>>2];j=N[j+21|0]|N[j+22|0]<<8;a:{if(j&2){f=M[k+36>>2];break a}if(N[m+28|0]&128){f=M[m+8>>2];break a}f=h+24|0;D(f,0,72);M[h+72>>2]=65539;K[h+78|0]=5;K[h+79|0]=3;K[h+80|0]=0;M[h+32>>2]=h+20;M[h+28>>2]=h+18;L[h+76>>1]=1;M[h+36>>2]=m;d=O[m+38>>1];L[h+22>>1]=0;L[h+20>>1]=d;if(j&1){break a}M[h+44>>2]=M[m+8>>2]}b:{if(M[a+12>>2]|O[o+40>>1]&4128|(N[k+12|0]&16|(!(N[M[M[o>>2]>>2]+33|0]&128)|j&147))){break b}d=M[r+24>>2];l=d+S(M[r+12>>2],48)|0;j=L[m+38>>1];p=Em(j);j=j+p|0;i=j-25|0;n=j+28|0;while(1){if(d>>>0>=l>>>0|g){break b}g=0;c:{if(M[e+8>>2]&M[d+32>>2]|M[e+12>>2]&M[d+36>>2]){break c}if(!gr(d,k,0,0)){break c}L[e+24>>1]=1;M[e+44>>2]=1;M[e+32>>2]=0;M[M[e+52>>2]>>2]=d;d:{if(N[m+43|0]!=2){j=n;if(!(N[m+29|0]&64)){break d}}j=i}L[e+22>>1]=43;j=j<<16>>16;L[e+18>>1]=(j|0)>0?j:0;M[e+40>>2]=16384;v=e,w=ie(p,43),L[v+20>>1]=w;g=c|M[d+36>>2];M[e>>2]=b|M[d+32>>2];M[e+4>>2]=g;g=hk(a,e)}d=d+48|0;continue}}j=1;while(1){e:{f:{g:{if(!(!f|g)){d=M[f+36>>2];if(d){if(!gA(M[k+16>>2],N[k+12|0],r,d)){break f}}if(N[f+56|0]&2){break f}p=O[M[f+8>>2]>>1];L[e+28>>1]=0;M[e+24>>2]=0;M[e+44>>2]=0;L[e+18>>1]=0;K[e+17|0]=0;M[e+36>>2]=0;M[e+32>>2]=f;L[e+22>>1]=p;M[e>>2]=b;M[e+4>>2]=c;g=1;h:{if(N[f+55|0]&4){break h}n=M[M[a>>2]+8>>2];if(!n){break h}l=M[k+16>>2];s=n+8|0;d=0;while(1){g=M[n>>2]<=(d|0);if(g){break h}i:{j:{i=$c(M[s+(d<<4)>>2]);if(!i){break j}k:{l:{switch(N[i|0]-168|0){case 0:case 2:break l;default:break k}}if((l|0)!=M[i+28>>2]){break k}i=L[i+32>>1];if((i|0)<0){break h}q=O[f+50>>1];g=0;i=i&65535;while(1){if((g|0)==(q|0)){break j}t=g<<1;g=g+1|0;if((i|0)!=O[t+M[f+4>>2]>>1]){continue}break}break i}g=M[f+40>>2];if(!g){break j}q=g+8|0;g=0;while(1){if(O[f+50>>1]<=g>>>0){break j}if(O[M[f+4>>2]+(g<<1)>>1]==65534){if(!Bm(i,M[q+(g<<4)>>2],l)){break i}}g=g+1|0;continue}}d=d+1|0;continue}break}g=0}n=p<<16>>16;m:{d=N[f+55|0]|N[f+56|0]<<8;if((d&3)==3){M[e+40>>2]=256;L[e+20>>1]=n+16;K[e+17|0]=g?0:j;cr(r,e,n);d=N[k+13|0]|N[k+14|0]<<8;if(!(d&4)){break m}if(d&64){M[e+40>>2]=M[e+40>>2]|33554432}M[e+36>>2]=M[M[M[k+44>>2]>>2]+48>>2];break m}n:{o:{if(d&32){M[h+8>>2]=0;M[h+12>>2]=0;d=576;break o}i=M[f+68>>2]&M[k+28>>2];d=M[f+64>>2]&M[k+24>>2];M[h+8>>2]=d;M[h+12>>2]=i;l=M[f+36>>2];if(l){lr(M[o>>2],f,l,h+8|0,0,0);i=M[h+12>>2];d=M[h+8>>2]}M[e+40>>2]=512;p:{if(d|(i|0)!=-2147483648){l=N[f+55|0]|N[f+56|0]<<8;if(!(l&4096)|!(d|i)|l&2048){break p}}s=M[k+16>>2];l=0;d=Na-48|0;Na=d;q=M[o+16>>2];q:{if(!q){break q}if(!(N[f+56|0]&16)){t=O[f+52>>1];i=0;while(1){if((i|0)==(t|0)){break q}u=i<<1;i=i+1|0;if(L[M[f+4>>2]+u>>1]<63){continue}break}}M[d+16>>2]=0;M[d+20>>2]=0;M[d+24>>2]=0;M[d+28>>2]=0;M[d+16>>2]=46;M[d+8>>2]=0;M[d+12>>2]=0;M[d+40>>2]=s;M[d+36>>2]=f;M[d+12>>2]=93;M[d+32>>2]=d+36;L[d+44>>1]=0;oc(d+8|0,q);l=N[d+45|0]?0:N[d+44|0]?67108864:64}Na=d+48|0;if(!l){break n}M[h+8>>2]=0;M[h+12>>2]=0;d=M[e+40>>2]|l;break o}if(d|i){break n}d=576;if(M[o+16>>2]|!(N[m+28|0]&128)){break o}i=M[16930];if(!i){break n}if(!(Ra[i|0](700)|0)){break n}}M[e+40>>2]=d}d=j;r:{if(!g){break r}d=0;if(N[k+13|0]&2|(M[f+36>>2]|N[m+28|0]&128)){break r}if(N[f+55|0]&4|(M[h+8>>2]|M[h+12>>2])|(N[o+40|0]&4|L[f+48>>1]>=L[m+40>>1])){break g}if(!N[67471]|N[M[M[o>>2]>>2]+80|0]&32){break g}}K[e+17|0]=d;L[e+20>>1]=(p+((S(L[f+48>>1],15)|0)/L[m+40>>1]|0)|0)+1;if(M[h+8>>2]|M[h+12>>2]){d=n+16|0;l=M[k+16>>2];g=0;while(1){s:{if(M[o+92>>2]<=(g|0)){break s}p=M[o+104>>2]+S(g,48)|0;if(!xA(M[p>>2],l,f)){break s}g=g+1|0;i=L[p+8>>1];if((i|0)>0){i=N[p+12|0]&130?-20:-1}d=d+i|0;continue}break}v=e,w=ie(L[e+20>>1],d<<16>>16),L[v+20>>1]=w}cr(r,e,n);if(!(N[k+12|0]&16)|!M[f+40>>2]){break m}L[e+22>>1]=n;break g}g=hk(a,e);L[e+22>>1]=n;if(!g){break g}}Na=h+96|0;return g}K[a+16|0]=0;g=br(a,k,f,0);if(N[a+16|0]!=1){break e}M[m+28>>2]=M[m+28>>2]|256;break e}g=0}j=j+1|0;f=N[k+13|0]&2?0:M[f+20>>2];continue}}function rf(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=Na-16|0;Na=k;M[k+12>>2]=0;o=M[a+12>>2];s=mb(M[o+56>>2]+36|0);r=M[a+48>>2];a:{if(s>>>0>=r>>>0){f=db(77239);break a}b:{c:{if(s){d:{e:{switch(e-1|0){case 0:if(d>>>0>r>>>0){break d}f=ej(a,d,k+11|0,0);if(f){break a}h=N[k+11|0]==2;break d;case 1:break e;default:break d}}h=1}f=ac(M[o+72>>2]);if(f){break a}g=M[o+56>>2];f=s-1|0;f=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);K[g+36|0]=f;K[g+37|0]=f>>>8;K[g+38|0]=f>>>16;K[g+39|0]=f>>>24;while(1){n=j;g=M[j+56>>2];f:{if(j){break f}g=M[o+56>>2]+32|0}m=mb(g);if(!(m>>>0<=r>>>0&s>>>0>=t>>>0)){j=0;f=db(77295);break b}j=0;i=k+12|0;f=dj(a,m,i,0);if(f){break b}g:{h:{j=M[k+12>>2];p=M[j+56>>2];l=mb(p+4|0);g=h;i:{if(!(l|g)){f=ac(M[j+72>>2]);if(f){break b}M[c>>2]=m;h=M[o+56>>2];g=M[j+56>>2];g=N[g|0]|N[g+1|0]<<8|(N[g+2|0]<<16|N[g+3|0]<<24);K[h+32|0]=g;K[h+33|0]=g>>>8;K[h+34|0]=g>>>16;K[h+35|0]=g>>>24;M[b>>2]=j;j=0;f=0;g=i;break i}if((M[a+40>>2]>>>2|0)-2>>>0<l>>>0){f=db(77324);break b}if(!(!g|!((e|0)==2&d>>>0>m>>>0)&(d|0)!=(m|0))){M[c>>2]=m;M[b>>2]=j;f=ac(M[j+72>>2]);if(f){break b}if(!l){if(!n){h=M[o+56>>2];g=M[j+56>>2];g=N[g|0]|N[g+1|0]<<8|(N[g+2|0]<<16|N[g+3|0]<<24);K[h+32|0]=g;K[h+33|0]=g>>>8;K[h+34|0]=g>>>16;K[h+35|0]=g>>>24;j=0;f=0;g=k+12|0;break i}f=ac(M[n+72>>2]);if(f){break b}h=M[n+56>>2];g=M[j+56>>2];g=N[g|0]|N[g+1|0]<<8|(N[g+2|0]<<16|N[g+3|0]<<24);K[h|0]=g;K[h+1|0]=g>>>8;K[h+2|0]=g>>>16;K[h+3|0]=g>>>24;j=0;f=0;g=k+12|0;break i}h=mb(M[j+56>>2]+8|0);if(h>>>0>r>>>0){f=db(77358);break b}f=dj(a,h,k+4|0,0);if(f){break b}g=M[k+4>>2];f=ac(M[g+72>>2]);if(f){Rb(g);break b}f=M[g+56>>2];i=M[j+56>>2];i=N[i|0]|N[i+1|0]<<8|(N[i+2|0]<<16|N[i+3|0]<<24);K[f|0]=i;K[f+1|0]=i>>>8;K[f+2|0]=i>>>16;K[f+3|0]=i>>>24;i=M[g+56>>2];f=l-1|0;l=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);K[i+4|0]=l;K[i+5|0]=l>>>8;K[i+6|0]=l>>>16;K[i+7|0]=l>>>24;f=f<<2;if(f){G(M[g+56>>2]+8|0,M[j+56>>2]+12|0,f)}Rb(g);j:{if(!n){g=M[o+56>>2];h=h<<24|(h&65280)<<8|(h>>>8&65280|h>>>24);K[g+32|0]=h;K[g+33|0]=h>>>8;K[g+34|0]=h>>>16;K[g+35|0]=h>>>24;break j}f=ac(M[n+72>>2]);if(f){break b}g=M[n+56>>2];h=h<<24|(h&65280)<<8|(h>>>8&65280|h>>>24);K[g|0]=h;K[g+1|0]=h>>>8;K[g+2|0]=h>>>16;K[g+3|0]=h>>>24}j=0;f=0;g=k+12|0;break i}if(!l){break h}k:{if(!d){h=0;break k}i=p+8|0;h=0;f=0;if((e|0)==2){while(1){if((f|0)==(l|0)){break k}if(mb((f<<2)+i|0)>>>0<=d>>>0){h=f;break k}else{f=f+1|0;continue}}}f=mb(i)-d|0;m=(f|0)<0?(f|0)==-2147483648?2147483647:0-f|0:f;f=1;while(1){if((f|0)==(l|0)){break k}q=mb((f<<2)+i|0)-d|0;u=(q|0)<0?(q|0)==-2147483648?2147483647:0-q|0:q;q=u>>>0<m>>>0;m=q?u:m;h=q?f:h;f=f+1|0;continue}}i=(h<<2)+p|0;f=mb(i+8|0);if(!(f>>>0<=r>>>0&f>>>0>1)){f=db(77423);break b}if(!(!g|(!((e|0)!=2|d>>>0<=f>>>0)|(d|0)==(f|0)))){f=0;h=1;break g}M[c>>2]=f;f=ac(M[j+72>>2]);if(f){break b}g=h;h=l-1|0;if(g>>>0<h>>>0){g=(l<<2)+p|0;g=N[g+4|0]|N[g+5|0]<<8|(N[g+6|0]<<16|N[g+7|0]<<24);K[i+8|0]=g;K[i+9|0]=g>>>8;K[i+10|0]=g>>>16;K[i+11|0]=g>>>24}h=h<<24|(h&65280)<<8|(h>>>8&65280|h>>>24);K[p+4|0]=h;K[p+5|0]=h>>>8;K[p+6|0]=h>>>16;K[p+7|0]=h>>>24;g=M[c>>2];f=M[a+64>>2];h=1;l:{if(!f){break l}h=0;if(g>>>0>P[f>>2]){break l}h=ol(f,g)^1}f=dj(a,g,b,h);if(f){h=0;break g}f=ac(M[M[b>>2]+72>>2]);if(!f){h=0;break h}Rb(M[b>>2]);g=b}h=0;M[g>>2]=0;break g}f=0}t=t+1|0;Rb(n);g=h;h=1;if(g){continue}break}break c}e=N[a+19|0];f=ac(M[o+72>>2]);if(f){break a}d=M[a+48>>2];f=d+1|0;M[a+48>>2]=f;if((d|0)==(P[16864]/P[a+36>>2]|0)){f=d+2|0;M[a+48>>2]=f}h=!e;m:{if(!N[a+17|0]){break m}if((Zd(a,f)|0)!=(f|0)){break m}M[k>>2]=0;f=dj(a,f,k,h);if(f){break a}d=M[k>>2];f=ac(M[d+72>>2]);Rb(d);if(f){break a}d=M[a+48>>2];f=d+1|0;M[a+48>>2]=f;if((d|0)!=(P[16864]/P[a+36>>2]|0)){break m}f=d+2|0;M[a+48>>2]=f}d=M[M[a+12>>2]+56>>2];e=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);K[d+28|0]=e;K[d+29|0]=e>>>8;K[d+30|0]=e>>>16;K[d+31|0]=e>>>24;d=c;c=M[a+48>>2];M[d>>2]=c;f=dj(a,c,b,h);if(f){break a}f=ac(M[M[b>>2]+72>>2]);if(!f){f=0;break b}Rb(M[b>>2]);M[b>>2]=0}n=0}Rb(j);Rb(n)}Na=k+16|0;return f}function KH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=Na-432|0;Na=d;a:{if(!b){break a}k=gb(M[c>>2]);if(!k){break a}e=b-1|0;b=d+384|0;if(sg(a,e,c+4|0,b)){break a}c=M[M[M[a>>2]+20>>2]+120>>2];L[d+380>>1]=0;M[d+376>>2]=0;M[d+372>>2]=c;M[d+368>>2]=0;M[d+360>>2]=0;M[d+364>>2]=0;Cc(b);cf(b);c=0;b=0;while(1){e=N[b+k|0];b:{if((e|0)!=37){if(e){break b}if(b>>>0>c>>>0){Ab(d+360|0,c+k|0,b-c|0)}wm(a,d+360|0);break a}if(b>>>0>c>>>0){Ab(d+360|0,c+k|0,b-c|0)}c=b+2|0;c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{b=b+1|0;f=N[k+b|0];switch(f-70|0){case 12:break o;case 13:break m;case 14:break l;case 15:break j;case 16:break i;case 17:break h;case 19:break g;case 30:case 31:break d;case 32:break y;case 36:break t;case 0:break x;case 39:break r;case 45:break n;case 47:case 49:break k;case 1:case 33:break w;case 2:case 37:break v;case 3:case 38:break u;case 4:break s;case 5:case 6:case 8:case 9:case 11:case 18:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 34:case 35:case 40:case 41:case 43:case 44:case 46:case 48:break e;case 7:break q;case 10:case 42:break p;default:break f}}h=R[d+416>>3];R[d+16>>3]=h>59.999?59.999:h;rb(d+360|0,12829,d+16|0);break b}M[d+32>>2]=M[d+392>>2];e=M[d+400>>2];M[d+36>>2]=M[d+396>>2];M[d+40>>2]=e;rb(d+360|0,16640,d+32|0);break b}j=d+312|0;G(j,d+384|0,48);K[d+353|0]=0;g=M[d+312>>2];i=M[d+316>>2];e=M[d+388>>2];l=M[d+384>>2]+432e5|0;e=l>>>0<432e5?e+1|0:e;e=S(3-((_J(l,e,864e5,0)|0)%7|0)|0,864e5);l=e;g=e+g|0;e=(e>>31)+i|0;M[d+312>>2]=g;M[d+316>>2]=g>>>0<l>>>0?e+1|0:e;ck(j);e=M[d+320>>2];if((f|0)==103){M[d+48>>2]=(e|0)%100;rb(d+360|0,16650,d+48|0);break b}M[d+64>>2]=e;rb(d+360|0,16615,d- -64|0);break b}M[d+80>>2]=M[d+404>>2];rb(d+360|0,(f|0)==72?16650:16655,d+80|0);break b}e=M[d+404>>2];e=(e|0)>12?e-12|0:e;M[d+96>>2]=e?e:12;rb(d+360|0,(f|0)==73?16650:16655,d+96|0);break b}m=d,n=sm(d+384|0)+1|0,M[m+112>>2]=n;rb(d+360|0,16620,d+112|0);break b}R[d+128>>3]=(+P[d+384>>2]+ +M[d+388>>2]*4294967296)/864e5;rb(d+360|0,12674,d+128|0);break b}M[d+144>>2]=M[d+396>>2];rb(d+360|0,16650,d+144|0);break b}M[d+160>>2]=M[d+408>>2];rb(d+360|0,16650,d+160|0);break b}if(M[d+404>>2]>=12){Ab(d+360|0,(f|0)==112?20158:11523,2);break b}Ab(d+360|0,(f|0)==112?20167:11661,2);break b}e=M[d+408>>2];M[d+176>>2]=M[d+404>>2];M[d+180>>2]=e;rb(d+360|0,16630,d+176|0);break b}e=M[d+384>>2];f=M[d+388>>2];if(N[d+428|0]&4){R[d+208>>3]=(+(e-1045635584>>>0)+ +(f-((e>>>0<1045635584)+49096|0)|0)*4294967296)/1e3;rb(d+360|0,12836,d+208|0);break b}e=_J(e,f,1e3,0);M[d+192>>2]=e-413362496;M[d+196>>2]=Qa-((e>>>0<413362496)+49|0);rb(d+360|0,15078,d+192|0);break b}h=R[d+416>>3];if(U(h)<2147483647){e=~~h}else{e=-2147483648}M[d+224>>2]=e;rb(d+360|0,16650,d+224|0);break b}e=M[d+408>>2];M[d+240>>2]=M[d+404>>2];M[d+244>>2]=e;h=R[d+416>>3];if(U(h)<2147483647){e=~~h}else{e=-2147483648}M[d+248>>2]=e;rb(d+360|0,16625,d+240|0);break b}g=d+360|0;e=M[d+388>>2];j=M[d+384>>2]+1296e5|0;e=j>>>0<1296e5?e+1|0:e;i=g;e=(_J(j,e,864e5,0)|0)%7|0;g=e+48|0;Wh(i,1,((f|0)==117?e?g:55:g)<<24>>24);break b}f=sm(d+384|0);e=M[d+388>>2];g=M[d+384>>2]+1296e5|0;e=g>>>0<1296e5?e+1|0:e;m=d,n=((f-((_J(g,e,864e5,0)|0)%7|0)|0)+7|0)/7|0,M[m+256>>2]=n;rb(d+360|0,16650,d+256|0);break b}f=d+312|0;G(f,d+384|0,48);K[d+353|0]=0;g=M[d+312>>2];j=M[d+316>>2];e=M[d+388>>2];i=M[d+384>>2]+432e5|0;e=i>>>0<432e5?e+1|0:e;e=S(3-((_J(i,e,864e5,0)|0)%7|0)|0,864e5);i=e;g=e+g|0;e=(e>>31)+j|0;M[d+312>>2]=g;M[d+316>>2]=g>>>0<i>>>0?e+1|0:e;ck(f);m=d,n=((sm(f)|0)/7|0)+1|0,M[m+272>>2]=n;rb(d+360|0,16650,d+272|0);break b}f=sm(d+384|0);e=M[d+388>>2];g=M[d+384>>2]+432e5|0;e=g>>>0<432e5?e+1|0:e;m=d,n=((f-((_J(g,e,864e5,0)|0)%7|0)|0)+7|0)/7|0,M[m+288>>2]=n;rb(d+360|0,16650,d+288|0);break b}M[d+304>>2]=M[d+392>>2];rb(d+360|0,16615,d+304|0);break b}if((f|0)==37){break c}}ag(d+360|0);break a}M[d>>2]=M[d+400>>2];rb(d+360|0,(f|0)==100?16650:16655,d);break b}Wh(d+360|0,1,37)}b=b+1|0;continue}}Na=d+432|0}function bF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,A=0;if((b|0)==2){a:{if((Sb(M[c>>2])|0)!=5){if((Sb(M[c+4>>2])|0)!=5){break a}}Yb(a);return}e=Kb(M[c>>2]);h=Kb(M[c+4>>2]);M[18595]=0;v=a;i=1;C(+h);g=x(1)|0;b:{c:{d:{p=x(0)|0;l=g;j=g&2147483647;e:{if(!(p|j)){break e}C(+e);a=x(1)|0;s=x(0)|0;b=a;if(!s&(a|0)==1072693248){break e}d=e+h;n=a&2147483647;if(!(!(n>>>0>2146435072|(n|0)==2146435072&(s|0)!=0|j>>>0>2146435072)&(!p|(j|0)!=2146435072))){break b}c=0;f:{g:{h:{i:{j:{k:{if((a|0)>0|(a|0)>=0){break k}c=2;if(j>>>0>1128267775){break k}c=0;if(j>>>0<1072693248){break k}r=j>>>20|0;if(j>>>0<1094713344){break j}o=1075-r|0;r=p>>>o|0;if((p|0)!=r<<o){break k}c=2-(r&1)|0}o=c;if(p){break h}if((j|0)!=2146435072){break i}if(!(n-1072693248|s)){break e}if(n>>>0<1072693248){break g}d=(g|0)>0|(g|0)>=0?h:0;break b}if(p){break h}c=1043-r|0;p=j>>>c|0;if((j|0)!=p<<c){break i}o=2-(p&1)|0}if((j|0)==1072693248){d=e;if((g|0)>0|(g|0)>=0){break b}d=1/d;break b}d=e*e;if(!w&(l|0)==1073741824){break b}if((l|0)!=1071644672|w|(a|0)<0){break h}d=$(e);break b}f=U(e);if(s){break f}l:{if((b|0)<0){if((b|0)==-2147483648|(b|0)==-1074790400|(b|0)==-1048576){break l}break f}if(!b|(b|0)==2146435072){break l}if((b|0)!=1072693248){break f}}i=(g|0)<0?1/f:f;if((a|0)>0|(a|0)>=0){break e}if(!(n-1072693248|o)){d=i-i;d=d/d;break b}d=(o|0)==1?-i:i;break b}d=(g|0)>0|(g|0)>=0?0:-h;break b}m:{if((a|0)>0|(a|0)>=0){break m}n:{switch(o|0){case 0:d=e-e;d=d/d;break b;case 1:break n;default:break m}}i=-1}o:{if(j>>>0>=1105199105){if(j>>>0>=1139802113){d=(g|0)<0?Infinity:0;if(n>>>0<=1072693247){break b}d=(l|0)>0?Infinity:0;break b}e=i*1e300*1e300;k=i*1e-300*1e-300;d=(g|0)<0?e:k;if(n>>>0<=1072693246){break b}d=(l|0)>0?e:k;if(n>>>0>=1072693249){break b}d=f+-1;e=d*1.9259629911266175e-8+d*d*(.5-d*(d*-.25+.3333333333333333))*-1.4426950408889634;m=e;e=d*1.4426950216293335;C(+(m+e));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=m-(d-e);break o}d=f*9007199254740992;a=n>>>0<1048576;e=a?d:f;C(+d);b=x(1)|0;x(0)|0;b=a?b:n;l=b&1048575;c=l|1072693248;b=(b>>20)+(a?-1076:-1023)|0;a=0;p:{if(l>>>0<235663){break p}if(l>>>0<767610){a=1;break p}c=l|1071644672;b=b+1|0}l=((a<<18)+(c>>>1|0)|0)+537395200|0;a=a<<3;y=R[a+58912>>3];C(+e);x(1)|0;o=0;z(0,x(0)|o);z(1,c|0);f=+B();k=R[a+58896>>3];q=f-k;t=1/(k+f);e=q*t;C(+e);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();A=d;z(0,o|0);z(1,l|0);u=d*d;m=q;q=+B();f=t*(m-d*q-d*(k-q+f));m=f*(e+d);d=e*e;k=m+d*d*(d*(d*(d*(d*(d*.20697501780033842+.23066074577556175)+.272728123808534)+.33333332981837743)+.4285714285785502)+.5999999999999946);C(+(u+3+k));c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();q=A*d;e=f*d+e*(k-(d+-3-u));C(+(q+e));c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();e=y+(d*-7.028461650952758e-9+(e-(d-q))*.9617966939259756);m=e;f=R[a+58928>>3];e=d*.9617967009544373;k=+(b|0);C(+(f+(m+e)+k));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=m-(d-k-f-e)}z(0,0);z(1,g|0);f=+B();e=(h-f)*d+h*e;d=d*f;h=e+d;C(+h);a=x(1)|0;b=x(0)|0;q:{c=a;if((a|0)>=1083179008){if(b|a-1083179008){break d}if(!(e+8008566259537294e-32>h-d)){break q}break d}if((c&2147482624)>>>0<1083231232){break q}if(b|c+1064252416){break c}if(!(e<=h-d)){break q}break c}a=0;g=c&2147483647;if(g>>>0>=1071644673){b=c+(1048576>>>(g>>>20|0)-1022|0)|0;g=b>>>20&2047;a=(b&1048575|1048576)>>>1043-g|0;a=(c|0)<0?0-a|0:a;z(0,0);z(1,b&-1048576>>g-1023);d=d-+B();C(+(e+d));c=x(1)|0;x(0)|0}z(0,0);z(1,c|0);h=+B();f=h*.6931471824645996;h=(e-(h-d))*.6931471805599453+h*-1.904654299957768e-9;d=f+h;e=d*d;e=d-e*(e*(e*(e*(e*4.1381367970572385e-8+-16533902205465252e-22)+6613756321437934e-20)+-.0027777777777015593)+.16666666666666602);m=d*e/(e+-2);e=d;d=h-(d-f);d=e-(m-(e*d+d))+1;C(+d);b=x(1)|0;c=x(0)|0;b=(a<<20)+b|0;r:{if((b|0)<=1048575){e=Hj(d,a);break r}z(0,c|0);z(1,b|0);e=+B()}i=i*e}d=i;break b}d=i*1e300*1e300;break b}d=i*1e-300*1e-300}Zb(v,d);return}ba(23737,17968,546,17673);I()}function Vy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;i=Na-80|0;Na=i;M[i+4>>2]=b;a:{if(!d){f=1;break a}e=i+4|0;while(1){M[e>>2]=b;if(b){m=P[b+24>>2]<=c>>>0;e=m?b+16|0:e;f=f+m|0;b=M[b+16>>2];continue}break}b=M[i+4>>2]}M[a+208>>2]=M[a+208>>2]+f;if(M[b+24>>2]==1){pq(b)}p=N[a+11|0];e=M[a+168>>2];m=M[a+172>>2];g=M[a+232>>2];h=M[M[g+32>>2]>>2];if(Qb(g+52|0,h,48)){k=M[h+16>>2]+1|0}else{k=0}b:{if(!O[g+40>>1]){c:{d:{if(!M[h+96>>2]){break d}pe(4,i+8|0);f=cg(g,4,4);if((f|0)==5){break d}if(f){break c}uv(g,M[i+8>>2]);Ee(g,4,4)}Pg(g,3);L[g+40>>1]=65535;M[i+16>>2]=0;while(1){f=tv(g,i+8|0,1,i+16|0);if((f|0)==-1){continue}break}}if(f){break b}}q=e;n=M[g+68>>2];e:{if(n){break e}M[i+16>>2]=-2113503433;M[i+20>>2]=417475840;K[i+27|0]=e;K[i+26|0]=(m&255)<<24|e>>>8;K[i+25|0]=(m&65535)<<16|e>>>16;K[i+24|0]=(m&16777215)<<8|e>>>24;j=M[g+112>>2];M[i+28>>2]=j<<24|(j&65280)<<8|(j>>>8&65280|j>>>24);if(!j){pe(8,g+84|0)}j=M[g+88>>2];M[i+32>>2]=M[g+84>>2];M[i+36>>2]=j;f=i+16|0;bg(1,f,24,0,i+8|0);j=M[i+8>>2];M[i+40>>2]=j<<24|(j&65280)<<8|(j>>>8&65280|j>>>24);h=M[i+12>>2];M[i+44>>2]=h<<24|(h&65280)<<8|(h>>>8&65280|h>>>24);M[g+36>>2]=q;M[g+76>>2]=j;M[g+80>>2]=h;K[g+65|0]=0;K[g+47|0]=1;j=M[g+8>>2];f=Ra[M[M[j>>2]+12>>2]](j,f,32,0,0)|0;if(f){break b}if(!N[g+48|0]){break e}j=p>>>2&3;if(!j){break e}h=M[g+8>>2];f=Ra[M[M[h>>2]+20>>2]](h,j)|0;if(f){break b}}if(M[g+36>>2]!=(q|0)){f=db(69216);break b}M[i+56>>2]=g;v=M[g+8>>2];M[i+76>>2]=q;M[i+72>>2]=p;M[i+64>>2]=0;M[i+68>>2]=0;M[i+60>>2]=v;e=e+24|0;l=e>>31;r=e;u=l;m=ZJ(e,l,n,0);e=Qa;j=m+32|0;m=j>>>0<32?e+1|0:e;e=b;while(1){if(e){f=i+56|0;f:{g:{h:{if(!k){break h}if(d){h=c;if(!M[e+16>>2]){break g}}M[i+16>>2]=0;ap(g,M[e+24>>2],i+16|0);h=M[i+16>>2];if(h>>>0<k>>>0){break h}if(h>>>0<=M[g+104>>2]-1>>>0){M[g+104>>2]=h}f=M[g+8>>2];l=M[e+4>>2];o=ZJ(r,u,h-1|0,0);h=Qa;o=o+56|0;h=o>>>0<56?h+1|0:h;f=Ra[M[M[f>>2]+12>>2]](f,l,q,o,h)|0;if(f){break b}L[e+28>>1]=O[e+28>>1]&65471;break f}h=0;if(!d){break g}h=M[e+16>>2]?0:c}f=sv(f,e,h,j,m);if(f){break b}L[e+28>>1]=O[e+28>>1]|64;m=m+u|0;j=j+r|0;m=j>>>0<r>>>0?m+1|0:m;n=n+1|0;w=e}e=M[e+16>>2];continue}break}i:{if(!d){f=0;k=0;break i}if(M[g+104>>2]){h=M[g+36>>2]+24|0;k=tc(h);if(!k){f=7;break b}e=M[g+104>>2];j:{if((e|0)==1){o=h>>31;f=24;e=0;break j}o=h>>31;f=ZJ(h,o,e-2|0,0);e=Qa;f=f+48|0;e=f>>>0<48?e+1|0:e}l=M[g+8>>2];f=Ra[M[M[l>>2]+8>>2]](l,k,8,f,e)|0;z=g,A=mb(k),M[z+76>>2]=A;x=k+4|0;z=g,A=mb(x),M[z+80>>2]=A;e=M[g+104>>2];M[g+104>>2]=0;y=k+24|0;while(1){if(!(e>>>0>n>>>0|f)){s=M[g+8>>2];t=ZJ(h,o,e-1|0,0);l=Qa;t=t+32|0;l=t>>>0<32?l+1|0:l;f=Ra[M[M[s>>2]+8>>2]](s,k,h,t,l)|0;if(!f){f=i+16|0;rv(g,mb(k),mb(x),y,f);s=M[g+8>>2];f=Ra[M[M[s>>2]+12>>2]](s,f,24,t,l)|0}e=e+1|0;continue}break}ab(k);if(f){break b}}o=p&3;k:{if(!o){k=0;f=0;break k}l:{if(!N[g+49|0]){k=0;break l}e=m;h=wv(M[g+8>>2]);f=h+j|0;k=f-1|0;e=(f>>>0<h>>>0?e+1|0:e)-!f|0;h=$J(k,e,h,0);l=k-h|0;e=e-(Qa+(h>>>0>k>>>0)|0)|0;p=e;M[i+64>>2]=l;M[i+68>>2]=e;k=0;h=j;e=m;while(1){if(h>>>0<l>>>0&(e|0)<=(p|0)|(e|0)<(p|0)){f=sv(i+56|0,w,c,h,e);if(f){break b}k=k+1|0;e=e+u|0;h=h+r|0;e=h>>>0<r>>>0?e+1|0:e;continue}break}if((j|0)==(l|0)&(m|0)==(p|0)){break l}f=0;break k}f=Ra[M[M[v>>2]+20>>2]](v,o)|0}if(!N[g+47|0]){break i}e=M[g+16>>2];m=M[g+20>>2];if((m|0)<0){break i}j=ZJ(r,u,k+n|0,0);l=Qa;j=j+32|0;l=j>>>0<32?l+1|0:l;h=e;e=e>>>0<j>>>0&(l|0)>=(m|0)|(l|0)>(m|0);qv(g,e?j:h,e?l:m);K[g+47|0]=0}n=M[g+68>>2];e=b;while(1){if(!(!e|f)){f=0;if(N[e+28|0]&64){n=n+1|0;f=$o(g,n,M[e+24>>2])}e=M[e+16>>2];continue}break}while(1){if(!((k|0)<=0|f)){k=k-1|0;n=n+1|0;f=$o(g,n,M[w+24>>2]);continue}break}if(f){break b}M[g+68>>2]=n;L[g+66>>1]=q&65280|q>>>16;if(d){M[g+72>>2]=c;M[g+60>>2]=M[g+60>>2]+1;_o(g);M[g+12>>2]=n}f=0;if(!M[a+96>>2]){break b}while(1){if(!b){break b}pv(M[a+96>>2],M[b+24>>2],M[b+4>>2]);b=M[b+16>>2];continue}}Na=i+80|0;return f}function JA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;n=Na-16|0;Na=n;M[n+8>>2]=0;s=M[a>>2];o=M[a+8>>2];h=M[s+4>>2]+S(N[o+16|0],48)|0;q=h+8|0;l=M[h+16>>2];t=M[s+8>>2];u=M[s>>2];x=M[a+4>>2];i=x;while(1){if(i){h=0;g=M[i+12>>2];j=(g|0)>0?g:0;f=M[i+24>>2];while(1){if((h|0)!=(j|0)){m=O[f+10>>1];L[f+10>>1]=m&65471;a:{if(!(O[f+12>>1]&63487)|m&128|(d&M[f+32>>2]|e&M[f+36>>2])|M[f+20>>2]!=M[q+16>>2]){break a}if(N[q+12|0]&88){if(!dr(f,q)){break a}}L[f+10>>1]=m|64;k=k+1|0}f=f+48|0;h=h+1|0;continue}break}i=M[i+4>>2];continue}break}b:{c:{if(!t){break c}r=M[t>>2];h=(r|0)>0?r:0;e=t+8|0;f=0;d:{while(1){if((f|0)==(h|0)){break d}e:{d=e+(f<<4)|0;g=M[d>>2];f:{if(Nd(0,g)){break f}if(N[d+8|0]&2){break e}d=N[g|0];if((d|0)!=114){if((d|0)!=168|M[g+28>>2]!=M[q+16>>2]){break e}break f}d=M[g+12>>2];if(N[d|0]!=168|M[d+28>>2]!=M[q+16>>2]){break e}d=L[d+32>>1];L[g+32>>1]=d;if((d|0)<0){break f}i=M[g+8>>2];d=eg(M[l+4>>2]+S(d&65535,12)|0);if(hc(i,d?d:33696)){break e}}f=f+1|0;continue}break}h=f}if((h|0)!=(r|0)){break c}d=O[s+40>>1];if(!(!(d&128)|(N[q+13|0]|N[q+14|0]<<8)<<16>>16<0)){h=d>>>9&1|2;break b}h=d>>>6&1;break b}r=0;h=0}e=r<<3;g=ub(M[u>>2],(e+S(k,24)|0)+96|0,0);g:{if(!g){cb(u,1162,0);f=7;break g}v=((k<<2)+g|0)+92|0;M[g+4>>2]=v;s=S(k,12)+v|0;M[g+12>>2]=s;M[g+16>>2]=e+s;e=M[q+28>>2];d=M[q+24>>2];M[g+64>>2]=d;M[g+68>>2]=e;h:{if(!(N[l+28|0]&128)){break h}l=qc(l);m=O[l+50>>1];f=0;while(1){if((f|0)==(m|0)){break h}j=L[M[l+4>>2]+(f<<1)>>1];j=(j|0)>=63?63:j;k=j&31;if((j&63)>>>0>=32){j=1<<k;i=0}else{i=1<<k;j=i-1&1>>>32-k}d=i|d;M[g+64>>2]=d;e=e|j;M[g+68>>2]=e;f=f+1|0;continue}}M[g+84>>2]=0;M[g+80>>2]=h;M[g+76>>2]=u;M[g+72>>2]=x;i=0;e=x;h=0;while(1){if(e){d=M[e+12>>2]+h|0;d=(d|0)<(h|0)?h:d;f=M[e+24>>2];while(1){if((d|0)!=(h|0)){m=O[f+10>>1];if(m&64){j=M[f+24>>2];k=S(p,12)+v|0;M[k+8>>2]=h;M[k>>2]=j;j=O[f+12>>1];l=j&16383;i:{if((l|0)==1){if(m<<16>>16>=0){i=((p|0)<32?1<<p:0)|i;M[g+84>>2]=i}K[k+4|0]=2;break i}if((l|0)==64){K[k+4|0]=N[f+15|0];break i}if(l&384){if((l|0)==256){K[k+4|0]=71;break i}K[k+4|0]=72;break i}K[k+4|0]=j;if(!(l&60)){break i}if(!ze(M[M[f>>2]+16>>2])){break i}w=((p|0)<16?1<<p:0)|w;if((l|0)!=4){if((l|0)!=16){break i}K[k+4|0]=8;break i}K[k+4|0]=32}p=p+1|0}f=f+48|0;h=h+1|0;continue}break}e=M[e+4>>2];h=d;continue}break}M[g>>2]=p;m=(r|0)>0?r:0;j=t+8|0;i=0;f=0;while(1){if((f|0)!=(m|0)){h=j+(f<<4)|0;e=M[h>>2];if(!Nd(0,e)){d=s+(i<<3)|0;M[d>>2]=L[e+32>>1];K[d+4|0]=K[h+8|0]&1;i=i+1|0}f=f+1|0;continue}break}M[g+8>>2]=i;L[o+44>>1]=0;M[o+40>>2]=1024;L[o+18>>1]=0;K[o+28|0]=N[o+28|0]&254;h=M[g>>2];if(si(M[u>>2],o,h)){hA(M[u>>2],g);f=7;break g}e=w&65535;d=n+12|0;f=ri(a,b,c,-1,-1,0,g,e,d,n+8|0);if(M[n+8>>2]){f=ri(a,b,c,-1,-1,0,g,e,d,0)}j:{if(f){break j}e=M[n+12>>2];r=c^-1;d=r&M[o+4>>2];k=d;t=b^-1;v=t&M[o>>2];if(!(d|v)){f=0;if(!e){break j}}i=0;f=0;s=(h|0)>0?h:0;if(e){f=ri(a,b,c,-1,-1,1,g,w&65535,n+12|0,0);d=r&M[o+4>>2];A=d;y=t&M[o>>2];i=!(d|y)}h=!i;l=w&65535;while(1){if(f){break j}d=-1;e=-1;f=0;while(1){if((f|0)!=(s|0)){m=op(x,M[(M[g+4>>2]+S(f,12)|0)+8>>2]);j=t&M[m+32>>2];p=r&M[m+36>>2];m=(p|0)==(e|0)&d>>>0>j>>>0|e>>>0>p>>>0;q=m?j:d;j=(p|0)==(z|0)&j>>>0>B>>>0|p>>>0>z>>>0;d=j?q:d;e=j?m?p:e:e;f=f+1|0;continue}break}if((d&e)!=-1){f=0;B=d;z=e;if((d|0)==(v|0)&(e|0)==(k|0)|(d|0)==(y|0)&(e|0)==(A|0)){continue}f=ri(a,b,c,b|d,c|e,0,g,l,n+12|0,0);if((b|0)!=M[o>>2]|(c|0)!=M[o+4>>2]){continue}i=M[n+12>>2]?i:1;h=0;continue}break}f=0;if(h&1){f=ri(a,b,c,b,c,0,g,w&65535,n+12|0,0);i=M[n+12>>2]?i:1}if(f|i){break j}f=ri(a,b,c,b,c,1,g,w&65535,n+12|0,0)}hA(M[u>>2],g)}Na=n+16|0;return f}function NJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=Na-48|0;Na=d;m=1;c=M[b+4>>2];a:{if(c&4){break a}h=M[a>>2];f=M[a+24>>2];if(!(c&64)){je(h,b,f);m=M[h+40>>2]?2:1;break a}j=M[b+52>>2];k=M[h>>2];c=b;while(1){if(c){M[c+4>>2]=M[c+4>>2]|4;M[d+36>>2]=0;M[d+28>>2]=0;M[d+32>>2]=0;M[d+20>>2]=0;M[d+24>>2]=0;M[d+12>>2]=0;M[d+16>>2]=0;M[d+40>>2]=c;M[d+8>>2]=h;m=2;if(id(d+8|0,M[c+60>>2])){break a}if(K[c+6|0]&1){M[M[M[M[c+32>>2]+52>>2]>>2]+48>>2]=M[c+48>>2];M[c+48>>2]=0}if(f){M[f+28>>2]=M[f+28>>2]+1}a=0;while(1){g=M[c+32>>2];if(M[g>>2]>(a|0)){e=g+S(a,48)|0;b:{if(!(N[e+21|0]&4)){break b}g=M[M[e+52>>2]>>2];if(N[g+4|0]&4){break b}i=f?M[f+16>>2]:0;n=M[h+264>>2];o=M[e+8>>2];if(o){M[h+264>>2]=o;g=M[M[e+52>>2]>>2]}SA(h,g,f);M[h+264>>2]=n;if(M[h+40>>2]){break a}if(!f){break b}g=(N[e+21|0]|N[e+22|0]<<8)&65519|((i|0)<M[f+16>>2]?16:0);K[e+21|0]=g;K[e+22|0]=g>>>8}a=a+1|0;continue}break}c:{if(!f){break c}a=M[f+28>>2];if(!a){break c}M[f+28>>2]=a-1}M[d+20>>2]=f;M[d+12>>2]=g;M[d+32>>2]=16385;if(Te(d+8|0,M[c+28>>2])){break a}g=M[c+40>>2];a=M[d+32>>2];d:{if(g|a&16){M[c+4>>2]=M[c+4>>2]|a&134221824|8;a=a&-16385;break d}a=a&-16402}e=M[c+28>>2];a=a|128;M[d+32>>2]=a;M[d+16>>2]=e;e=M[c+44>>2];if(e){if(!(N[c+4|0]&8)){cb(h,1214,0);break a}if(id(d+8|0,e)){break a}a=M[d+32>>2]}M[d+32>>2]=a|1048576;if(id(d+8|0,M[c+36>>2])){break a}M[d+32>>2]=M[d+32>>2]&-1048577;a=0;while(1){e=M[c+32>>2];if(M[e>>2]>(a|0)){e=e+S(a,48)|0;if(N[e+21|0]&8){if(Te(d+8|0,M[e+40>>2])){break a}}a=a+1|0;continue}break}e:{if(N[h+224|0]<2){break e}i=c+72|0;while(1){a=M[i>>2];if(!a){break e}e=d+8|0;if(Te(e,M[a+12>>2])){break a}i=a+36|0;if(!Te(e,M[a+8>>2])){continue}break}break a}M[d+20>>2]=0;M[d+32>>2]=M[d+32>>2]|16385;if(K[c+6|0]&1){a=M[M[M[c+32>>2]+52>>2]>>2];M[c+48>>2]=M[a+48>>2];M[a+48>>2]=0}a=M[c+48>>2];if(!(!a|!l&(j|0)!=0)){if(RA(d+8|0,c,a,19643)){break a}}if(N[k+87|0]){break a}M[d+32>>2]=M[d+32>>2]&-16385;f:{if(!g){break f}if(RA(d+8|0,c,g,20003)|N[k+87|0]){break a}a=0;e=M[g>>2];e=(e|0)>0?e:0;i=g+8|0;while(1){if((a|0)==(e|0)){break f}if(N[M[i>>2]+4|0]&16){cb(h,13416,0);break a}else{i=i+16|0;a=a+1|0;continue}}}a=M[c+56>>2];if(!(!a|M[M[c+28>>2]>>2]==M[M[a+28>>2]>>2])){Js(h,a);break a}l=l+1|0;c=M[c+52>>2];continue}break}m=1;if(!j){break a}k=M[b+48>>2];if(!k){break a}a=M[k>>2];l=M[h>>2];g:{if((a|0)<=M[l+128>>2]){c=0;e=(a|0)>0?a:0;o=k+17|0;a=0;while(1){if((a|0)!=(e|0)){g=o+(a<<4)|0;f=(N[g|0]|N[g+1|0]<<8)&65531;K[g|0]=f;K[g+1|0]=f>>>8;a=a+1|0;continue}break}while(1){f=b;M[f+56>>2]=c;c=f;b=M[c+52>>2];if(b){continue}break}e=k+8|0;g=1;h:while(1){if(!(g?f:0)){a=0;b=M[k>>2];b=(b|0)>0?b:0;m=1;while(1){if((a|0)==(b|0)){break a}c=a<<4;a=a+1|0;if(N[c+o|0]&4){continue}break}M[d>>2]=a;cb(h,3359,d);break g}p=M[f+28>>2];a=0;c=e;i=0;while(1){g=a;i:{j:{if(M[k>>2]>(i|0)){M[d+44>>2]=-1;if(N[c+9|0]&4){break j}j=$c(M[c>>2]);if(!j){break j}k:{if(gf(j,d+44|0,0)){b=M[d+44>>2];a=M[p>>2];if((b|0)>0&(a|0)>=(b|0)){break k}ur(h,19643,i+1|0,a,j);break g}b=QA(p,j);if(!b){b=0;a=qb(l,j,0);l:{if(N[l+87|0]){break l}b=PA(h,f,a);if(N[h+224|0]<2|(b|0)<=0){break l}PA(h,f,j)}kb(l,a)}a=1;if((b|0)<=0){break i}}if(N[h+224|0]<=1){n=wc(l,156,0);if(!n){break g}M[n+8>>2]=b;M[n+4>>2]=M[n+4>>2]|2048;a=M[c>>2];m:{if((j|0)==(a|0)){M[c>>2]=n;break m}while(1){m=a;a=M[a+12>>2];if(N[a|0]==114){continue}break}M[m+12>>2]=n}me(l,j);L[c+12>>1]=b}a=N[c+9|0]|N[c+10|0]<<8|4;K[c+9|0]=a;K[c+10|0]=a>>>8;break j}f=M[f+56>>2];continue h}a=g}c=c+16|0;i=i+1|0;continue}}}cb(h,13382,0)}m=2}Na=d+48|0;return m|0}function Kf(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;a:{b:{if(N[a+9|0]){break b}g=N[a+8|0];if(!g){break b}if(!b|(g|0)!=1){break a}}m=c;k=Na-16|0;Na=k;d=M[a+4>>2];c=M[a>>2];M[d+4>>2]=c;e=M[d>>2];j=b;c:{d:{g=a;a=N[a+8|0];if((a|0)==2|!b&(a|0)==1){break d}if(!(N[e+14|0]|!(N[c+35|0]&2))){L[d+24>>1]=O[d+24>>1]&65534}a=O[d+24>>1];if(!(!j|!(a&1))){b=8;break c}e:{f:{g:{if(j){if(a&128|N[d+20|0]==2){break g}if((j|0)<2){break e}a=d+76|0;while(1){b=M[a>>2];if(!b){break e}a=b+12|0;b=M[b>>2];if((g|0)==(b|0)){continue}break}break f}if(!(a&128)){break e}}b=M[d+80>>2]}if(!M[b>>2]){break e}b=262;break c}b=Po(g,1,1);if(b){break c}a=O[d+24>>1];L[d+24>>1]=a&65519;if(!M[d+48>>2]){L[d+24>>1]=a|16}n=d+36|0;a=0;while(1){h:{i:{if(!M[d+12>>2]){b=Wu(M[d>>2]);if(b){break h}b=xd(d,1,k+12|0,0);if(b){break h}h=M[d>>2];c=M[h+28>>2];l=M[k+12>>2];f=M[l+56>>2];a=mb(f+28|0);j:{if(a){if((N[f+24|0]|N[f+25|0]<<8|(N[f+26|0]<<16|N[f+27|0]<<24))==(N[f+92|0]|N[f+93|0]<<8|(N[f+94|0]<<16|N[f+95|0]<<24))){break j}}a=c}k:{l:{m:{if(a?N[M[d+4>>2]+35|0]&2:1){h=M[d+40>>2];a=0;break m}b=26;if(Qb(f,33616,16)){break k}if(N[f+18|0]>=3){L[d+24>>1]=O[d+24>>1]|1}i=N[f+19|0];if(i>>>0>2){break k}n:{if(N[d+24|0]&32|(i|0)!=2){break n}M[k+8>>2]=0;h=Vu(h,k+8|0);if(h){break l}if(M[k+8>>2]){break n}Lj(l);b=0;break i}if(Qb(f+21|0,30765,3)){break k}i=N[f+17|0]<<16|N[f+16|0]<<8;if(i-1&i|i>>>0>65536|i>>>0<257){break k}o=N[f+20|0];h=i-o|0;if((i|0)!=M[n>>2]){Lj(l);M[d+36>>2]=i;M[d+40>>2]=h;L[d+24>>1]=O[d+24>>1]|2;fp(d);b=Xh(M[d>>2],n,o);break i}o:{if(a>>>0<=c>>>0){break o}a=c;if((M[M[d+4>>2]+32>>2]&268435457)==1){break o}b=db(74173);break k}if(h>>>0<480){break k}M[d+40>>2]=h;M[d+36>>2]=i;L[d+24>>1]=O[d+24>>1]|2;p=d,q=(mb(f+52|0)|0)!=0,K[p+17|0]=q;p=d,q=(mb(f- -64|0)|0)!=0,K[p+18|0]=q}M[d+48>>2]=a;M[d+12>>2]=l;L[d+30>>1]=h-35;a=(((h<<5)-384>>>0)/255|0)-23|0;L[d+32>>1]=a;L[d+28>>1]=a;a=(((h<<6)-768>>>0)/255|0)-23|0;L[d+26>>1]=a;a=a&65535;K[d+21|0]=a>>>0>=127?127:a;b=0;break i}b=h}Lj(l);M[d+12>>2]=0;break h}p:{q:{r:{if(!j){break r}if(a){break r}b=8;if(K[d+24|0]&1){break h}b=M[e+44>>2];if(b){break q}K[e+22|0]=N[M[g>>2]+86|0]==2;if(N[e+17|0]==1){a=M[e+232>>2];s:{if(a){if(!(N[a+43|0]|!N[e+4|0])){b=$f(e,4);if(b){break q}bv(M[e+232>>2],1);a=M[e+232>>2]}b=8;if(N[a+46|0]){break h}b=cg(a,0,1);if(b){break q}K[a+44|0]=1;if(!Qb(a+52|0,M[M[a+32>>2]>>2],48)){break s}Ee(a,0,1);K[a+44|0]=0;break p}b=$f(e,2);if(!(b|(j|0)<2)){b=Uo(e,4)}if(b){break q}}K[e+17|0]=2;M[e+80>>2]=0;M[e+84>>2]=0;a=M[e+28>>2];M[e+40>>2]=a;M[e+36>>2]=a;M[e+32>>2]=a}a=Uq(d)}b=a;if(b){break h}t:{if(N[g+8|0]){break t}M[d+44>>2]=M[d+44>>2]+1;if(!N[g+9|0]){break t}K[g+40|0]=1;M[g+44>>2]=M[d+76>>2];M[d+76>>2]=g+32}a=j?2:1;K[g+8|0]=a;if(a>>>0>N[d+20|0]){K[d+20|0]=a}if(!j){break d}M[d+80>>2]=g;L[d+24>>1]=O[d+24>>1]&65471|((j|0)>1?64:0);a=M[d+12>>2];if(M[d+48>>2]==(mb(M[a+56>>2]+28|0)|0)){break d}b=ac(M[a+72>>2]);if(b){break c}a=M[a+56>>2];b=M[d+48>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[a+28|0]=b;K[a+29|0]=b>>>8;K[a+30|0]=b>>>16;K[a+31|0]=b>>>24;break d}if((b|0)!=517){break h}}b=N[d+20|0]?517:5;break h}a=0;if(!b){continue}}Oo(d);if(N[d+20|0]|(b&255)!=5){break c}a=b;if(Cv(d)){continue}break}break c}if(m){p=m,q=mb(M[M[d+12>>2]+56>>2]+40|0),M[p>>2]=q}if(!j){b=0;break c}b=Jq(e,M[M[g>>2]+504>>2])}Na=k+16|0;return b}g=M[a+4>>2];if(c){p=c,q=mb(M[M[g+12>>2]+56>>2]+40|0),M[p>>2]=q}if(!b){return 0}return Jq(M[g>>2],M[M[a>>2]+504>>2])}function Fn(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;j=Na-48|0;Na=j;M[j+44>>2]=0;M[j+40>>2]=0;r=M[a>>2];a:{if(M[a+40>>2]){break a}g=wh(a,b);if(!g){break a}y=Ai(a,g,129,0,0);w=N[g+43|0];m=1;if(!y){m=(rk(a,g,0,0)|0)!=0}if(lf(a,g)){break a}if(jn(a,g,y)){break a}d=M[g>>2];i=M[r+16>>2];f=Mb(r,M[g+60>>2]);s=gc(a,9,d,0,M[i+(f<<4)>>2]);if((s|0)==1){break a}n=M[a+44>>2];i=n+1|0;M[a+44>>2]=i;M[b+24>>2]=n;d=i;k=g+8|0;h=k;while(1){h=M[h>>2];if(h){d=d+1|0;M[a+44>>2]=d;q=q+1|0;h=h+20|0;continue}break}h=0;if((w|0)==2){A=M[a+264>>2];M[a+264>>2]=M[g>>2];z=a}e=Cb(a);b:{if(!e){break b}if(!N[a+18|0]){L[e+152>>1]=O[e+152>>1]|16}jd(a,m,f);if((w|0)==2){Wr(a,g,c,n);M[j+44>>2]=n;M[j+40>>2]=n}M[j+36>>2]=0;M[j+28>>2]=0;M[j+32>>2]=0;M[j+20>>2]=0;M[j+24>>2]=0;M[j+12>>2]=0;M[j+16>>2]=0;M[j+8>>2]=b;M[j+4>>2]=a;if(id(j+4|0,c)){break b}if(!(N[a+18|0]|!(K[r+36|0]&1)|(M[a+136>>2]|N[a+163|0]))){p=M[a+48>>2]+1|0;M[a+48>>2]=p;$a(e,71,0,p)}c:{if(!(((c|s)!=0|m)&1|N[g+43|0]==1)){Dd(a,f,M[g+20>>2],1,M[g>>2]);if(!(N[g+28|0]&128)){nb(e,145,M[g+20>>2],f,p?p:-1,M[g>>2],-1)}h=p?p:-1;while(1){d=M[k>>2];if(d){d:{if(!(!(N[g+28|0]&128)|((N[d+55|0]|N[d+56|0]<<8)&3)!=2)){bb(e,145,M[d+44>>2],f,h);break d}$a(e,145,M[d+44>>2],f)}k=d+20|0;continue}else{d=0;break c}}}f=1;s=(N[j+28|0]&64)>>>6|0?20:m&1?20:28;e:{if(!(N[g+28|0]&128)){x=M[a+48>>2]+1|0;M[a+48>>2]=x;m=0;$a(e,75,0,x);d=0;break e}d=M[a+48>>2];m=qc(g);f=L[m+50>>1];M[a+48>>2]=d+f;u=M[a+44>>2];M[a+44>>2]=u+1;o=$a(e,117,u,f);Ld(a,m);d=d+1|0}t=jf(a,b,c,0,0,0,s,i);if(!t){break b}i=d;k=M[t+20>>2];s=M[t+24>>2];v=N[t+46|0];if((v|0)!=1){d=M[a+132>>2];K[(d?d:a)+20|0]=1}if(K[t+48|0]&1){fb(e,143,n)}if(p){$a(e,86,p,1)}f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{if(m){d=0;l=(f|0)>0?f:0;while(1){if((d|0)!=(l|0)){Ed(e,g,n,L[M[m+4>>2]+(d<<1)>>1],d+i|0);d=d+1|0;continue}break}if(!v){break p}l=i;break q}i=1;l=M[a+48>>2]+1|0;M[a+48>>2]=l;$a(e,135,n,l);if(!v){break n}}d=Ob(r,q+2|0,0);if(!d){Cd(t);break b}h=q+1|0;if(h){D(d,1,h)}K[d+h|0]=0;if((k|0)>=0){K[(k-n|0)+d|0]=0}h=s;if((h|0)>0){i=1}else{i=(h|0)>=0}if(i){K[(s-n|0)+d|0]=0}if(o){be(e,o)}h=M[a+60>>2]-1|0;M[a+60>>2]=h;if((w|0)!=2){break o}i=f;break k}l=M[a+48>>2]+1|0;M[a+48>>2]=l;nb(e,97,i,f,l,zi(M[a>>2],m),f);lb(e,138,u,l,i,f);i=0;break m}q=0;if((v|0)!=2){k=0;i=f;o=0;break l}k=0;q=1;o=Ub(e,15);i=f;break l}$a(e,156,x,l)}Cd(t);k=1;q=0;d=0;o=0;f=0;if((w|0)==2){break j}}hn(a,g,113,8,n,d,j+44|0,j+40|0);if(q){gn(e,o)}q=d;f=h;if(k){break j}}k=0;if(N[g+43|0]==1){o=0;break h}f=M[j+44>>2];if(N[(f-n|0)+d|0]){lb(e,28,f,h,l,i)}o=0;break i}r:{if(m){k=fb(e,36,u);o=1;if(N[g+43|0]==1){bb(e,94,u,0,l);break r}$a(e,134,u,l);break r}o=1;k=bb(e,46,x,0,l)}d=q;h=f}if(N[g+43|0]!=1){break g}}f=Gd(r,g);Ur(a,g);i=M[a+132>>2];K[(i?i:a)+21|0]=1;s:{if((v|0)!=1){break s}fb(e,122,n);if(M[a+132>>2]){break s}K[a+20|0]=0}nb(e,7,0,1,l,f,-11);f=M[e+108>>2];if((f|0)<=0){break f}L[(M[e+104>>2]+S(f,20)|0)-18>>1]=2;break f}fn(a,g,y,M[j+44>>2],M[j+40>>2],l,i,!N[a+18|0],11,v,s)}if(!o){pb(e,h);Cd(t);break c}if(m){$a(e,39,u,k+1|0);h=M[e+108>>2];M[(N[M[e>>2]+87|0]?74356:M[e+104>>2]+S(k,20)|0)+8>>2]=h;break c}Xb(e,k);h=M[e+108>>2];M[(N[M[e>>2]+87|0]?74356:M[e+104>>2]+S(k,20)|0)+8>>2]=h}if(!(N[a+18|0]|M[a+136>>2])){en(a)}if(p){Tr(e,p,15675)}h=d}if(!z){break a}M[z+264>>2]=A}Gc(r,b);kb(r,c);if(h){cc(r,h)}Na=j+48|0}function Eh(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;i=Na+-64|0;Na=i;k=M[c+4>>2];a:{b:{c:{d:{e:{if(d){d=K[b+1|0];f:{if((d|0)>=0){m=2;d=d&255;break f}m=Xd(b+1|0,i+16|0)+1&255;d=M[i+16>>2]}k=k+40|0;n=1;o=N[b|0];d=o+(d>>>0>=128?d-12>>>1|0:N[d+34560|0])|0;break e}d=K[b|0];g:{if((d|0)>=0){m=1;o=d&255;break g}m=Xd(b,i+60|0);o=M[i+60>>2]}d=o}l=d;h:{if(l>>>0<=a>>>0){q=c+23|0;while(1){i:{j:{k:{l:{m:{e=O[k+16>>1];if(e&36){d=N[b+m|0];if(d>>>0>=10){h=(d|0)==10?-1:1;a=0;break b}if((d|0)==7){break m}h=-1;if(!d){break c}g=b+l|0;r=M[k+4>>2];t=M[k>>2];n:{o:{switch(d-1|0){case 0:e=K[g|0];f=e>>31;break n;case 1:e=N[g+1|0]|K[g|0]<<8;f=e>>31;break n;case 2:e=N[g+2|0]|(N[g+1|0]<<8|K[g|0]<<16);f=e>>31;break n;case 3:e=N[g|0]|N[g+1|0]<<8|(N[g+2|0]<<16|N[g+3|0]<<24);e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);f=e>>31;break n;case 4:e=N[g+3|0];f=e>>>16|0;p=e<<16;j=f;e=N[g+2|0];f=e>>>8|0;p=e<<24|p;j=f|j;e=N[g+4|0];f=e>>>24|0;s=N[g+5|0]|(e<<8|p);j=f|j;f=N[g+1|0]|K[g|0]<<8;e=s;f=f|j;break n;case 5:e=N[g+4|0]|N[g+5|0]<<8|(N[g+6|0]<<16|N[g+7|0]<<24);j=N[g|0]|N[g+1|0]<<8|(N[g+2|0]<<16|N[g+3|0]<<24);p=j<<24|(j&65280)<<8;g=j&16711680;f=g<<24;g=g>>>8|0;w=f;s=j&-16777216;f=s>>>24|0;e=w|s<<8|(((e&255)<<24|j>>>8)&-16777216|((e&16777215)<<8|j>>>24)&16711680|(e>>>8&65280|e>>>24));j=g|f|p;f=0;f=j|(f|f);break n;default:break o}}e=d-8|0;f=0}if(e>>>0<t>>>0&(f|0)<=(r|0)|(f|0)<(r|0)){break c}if((f|0)<=(r|0)&e>>>0<=t>>>0|(f|0)<(r|0)){break i}break d}p:{if(e&8){d=N[b+m|0];if(d>>>0>=10){h=(d|0)==10?-1:1;a=0;break b}h=-1;if((d|0)!=7){if(!d){break c}$h(b+l|0,d,i+16|0);h=Wi(M[i+16>>2],M[i+20>>2],R[k>>3]);break l}d=1;if(qo(b+l|0,i+16|0)){break c}u=R[i+16>>3];v=R[k>>3];if(u<v){break c}if(u>v){break p}break j}if(e&2){d=b+m|0;e=K[d|0];q:{if((e|0)>=0){e=e&255;break q}Xd(d,i+12|0);e=M[i+12>>2]}if(e>>>0<12){h=-1;d=e;break c}d=1;if(!(e&1)){break d}f=e-12>>>1|0;M[i+28>>2]=f;r:{if(f+l>>>0<=a>>>0){h=M[c>>2];if(O[h+8>>1]>n>>>0){break r}}x=q,y=db(89935),K[x|0]=y;break h}j=M[(h+(n<<2)|0)+20>>2];if(j){K[i+34|0]=N[h+4|0];d=M[h+12>>2];L[i+32>>1]=2;M[i+36>>2]=d;M[i+24>>2]=b+l;d=e;h=Tt(i+16|0,k,j,q);break l}j=M[k+12>>2];h=Qb(b+l|0,M[k+8>>2],(f|0)<(j|0)?f:j);if(h){break c}d=e;h=f-j|0;break l}f=b+m|0;d=N[f|0];if(e&16){h=-1;if(d<<24>>24<0){Xd(f,i+12|0);d=M[i+12>>2]}if(d&1|d>>>0<12){break c}e=d-12>>>1|0;if(e+l>>>0<=a>>>0){if(N[k+17|0]&4){if(!po(b+l|0,e)){break p}h=e-M[k>>2]|0;break l}f=M[k+12>>2];h=Qb(b+l|0,M[k+8>>2],(e|0)<(f|0)?e:f);if(h){d=1;break c}h=e-f|0;break l}x=q,y=db(89965),K[x|0]=y;break h}h=1;s:{switch(d-7|0){case 3:break i;case 0:break s;case 1:case 2:break c;default:break k}}if(qo(b+l|0,i+16|0)){break j}}d=1;break d}qo(b+l|0,i+16|0);d=7;h=0-Wi(M[k>>2],M[k+4>>2],R[i+16>>3])|0}if(!h){break i}break c}if(d){break c}break i}d=7}t:{n=n+1|0;if((n|0)==O[c+20>>1]){break t}l=(d>>>0>=128?d-12>>>1|0:N[d+34560|0])+l|0;if(l>>>0>a>>>0){break t}m=Bh(d,0)+m|0;if(o>>>0<=m>>>0){x=q,y=db(90016),K[x|0]=y;break h}k=k+40|0;continue}break}K[c+26|0]=1;h=K[c+22|0];break a}x=c,y=db(89854),K[x+23|0]=y}h=0;break a}h=1}a=!d}b=N[M[M[c>>2]+16>>2]+n|0];if(!b|((b&1)==((a?1:L[k+16>>1]&1)|0)?b&2:0)){break a}h=0-h|0}Na=i- -64|0;return h}function Ff(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;i=Na-16|0;Na=i;j=jc(a,b,i+12|0);a:{if(!j){K[c+25|0]=N[c+25|0]|2;a=M[a+4>>2]+1|0;break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{h=M[a>>2]+b|0;switch(N[h|0]&15){case 0:break r;case 11:break f;case 12:break g;case 1:break q;case 2:break p;case 3:case 5:break o;case 4:break n;case 6:break m;case 7:case 8:break l;case 9:break k;case 10:break e;default:break h}}Nc(c,11727,4);a=b+1|0;break a}Nc(c,13070,4);a=b+1|0;break a}Nc(c,13603,5);a=b+1|0;break a}f=M[i+12>>2];if(!f){break d}af(c,h+j|0,f);break b}f=M[i+12>>2];if(!f){break d}a=2;s:{t:{u:{k=h+j|0;switch(N[k|0]-43|0){case 0:break t;case 2:break u;default:break s}}bc(c,45)}a=3}l=a>>>0>f>>>0?a:f;while(1){v:{if((a|0)!=(l|0)){h=N[a+k|0];if(N[h+31408|0]&8){break v}K[c+25|0]=N[c+25|0]|2}M[i>>2]=g;M[i+4>>2]=e;gm(100,c,d?23222:1873,i);break b}w:{if(e>>>0>268435455){d=1;break w}e=e<<4|g>>>28;g=h+(h<<1<<24>>24>>>7&9)&15|g<<4}a=a+1|0;continue}}f=M[i+12>>2];if(!f){break d}a=0;e=h+j|0;d=N[e|0];if((d|0)==45){bc(c,45);d=N[e+1|0];a=1}if((d&255)!=46){break j}d=0;break i}bc(c,34);f=M[i+12>>2];af(c,(M[a>>2]+b|0)+j|0,f);bc(c,34);break b}f=M[i+12>>2];bc(c,34);g=h+j|0;e=f;while(1){a=0;x:{y:{if(!e){break y}z:{while(1){if((a|0)==(e|0)){break z}d=a+g|0;h=N[d|0];if(!((h|0)!=39&!N[h+52896|0])){a=a+1|0;continue}break}A:{if(!a){d=g;break A}Nc(c,g,a);e=e-a|0}a=K[d|0];if((a|0)==34){Nc(c,29960,2);break x}if((a|0)<=31){k=M[c+8>>2];g=M[c+20>>2];h=M[c+12>>2];l=M[c+16>>2]+7|0;g=l>>>0<7?g+1|0:g;if((h|0)==(g|0)&k>>>0<l>>>0|g>>>0>h>>>0){if(fh(c,7)){break y}a=N[d|0]}jz(c,a&255);break x}if(e>>>0<=1){K[c+25|0]=N[c+25|0]|2;break y}B:{C:{D:{E:{F:{a=N[d+1|0];switch(a-10|0){case 0:break B;case 1:case 2:break C;case 3:break E;default:break F}}G:{H:{switch(a-118|0){default:if((a|0)==226){break D}if((a|0)==48){break G}if((a|0)!=39){break C}bc(c,39);break B;case 0:Nc(c,23246,6);break B;case 1:break C;case 2:break H}}if(e>>>0<=3){e=2;K[c+25|0]=N[c+25|0]|2;break B}Nc(c,24683,4);d=d+2|0;Nc(c,d,2);e=e-2|0;break B}Nc(c,24855,6);break B}if((e|0)==2){e=2;break B}a=N[d+2|0]==10;d=a?d+1|0:d;e=e-a|0;break B}if(!(!(N[d+2|0]!=128|e>>>0<4)&(N[d+3|0]&254)==168)){e=2;K[c+25|0]=N[c+25|0]|2;break B}d=d+2|0;e=e-2|0;break B}Nc(c,d,2)}e=e-2|0;g=d+2|0;continue}Nc(c,g,e)}bc(c,34);break b}e=e-1|0;g=d+1|0;continue}}d=1}while(1){if(!d){bc(c,48);d=1;continue}while(1){if((a|0)==(f|0)){break b}d=a+e|0;bc(c,K[d|0]);a=a+1|0;if((f|0)!=(a|0)&N[a+e|0]-58>>>0>=4294967286|N[d|0]!=46){continue}break}d=0;continue}}f=M[i+12>>2];break c}bc(c,123);d=b+j|0;f=M[i+12>>2];g=d+f|0;while(1){if(!(N[c+25|0]|d>>>0>=g>>>0)){d=Ff(a,d,c);bc(c,e&1?44:58);e=e+1|0;continue}break}if(!(!(e&1)&d>>>0<=g>>>0)){K[c+25|0]=N[c+25|0]|2}if(!(N[c+25|0]|!f)){a=M[c+16>>2];d=M[c+20>>2]-!a|0;a=a-1|0;M[c+16>>2]=a;M[c+20>>2]=d}bc(c,125);break b}bc(c,91);d=b+j|0;f=M[i+12>>2];e=d+f|0;while(1){if(!(N[c+25|0]|d>>>0>=e>>>0)){d=Ff(a,d,c);bc(c,44);continue}break}if(d>>>0>e>>>0){K[c+25|0]=N[c+25|0]|2}if(!(N[c+25|0]|!f)){a=M[c+16>>2];d=M[c+20>>2]-!a|0;a=a-1|0;M[c+16>>2]=a;M[c+20>>2]=d}bc(c,93);break b}f=M[i+12>>2];mm(c,h+j|0,f);break b}f=0}K[c+25|0]=N[c+25|0]|2}a=(b+j|0)+f|0}Na=i+16|0;return a}function MD(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=Na-48|0;Na=g;M[g+36>>2]=0;M[g+32>>2]=0;M[b>>2]=0;d=ve();if(!d){d=1;d=N[67468]?!N[67469]:d;f=M[16916]?131078:6;e=f&-655129;M[g+40>>2]=e;c=zd(536,0);a:{if(!c){break a}if(!d){M[c+12>>2]=8}K[c+97|0]=109;M[c+20>>2]=2;L[c+308>>1]=0;M[c+304>>2]=1;M[c+16>>2]=c+460;M[c+72>>2]=f&33554432?-1:255;G(c+120|0,33136,48);K[c+90|0]=255;K[c+85|0]=1;M[c+164>>2]=0;d=M[16908];i=M[16909];M[c+180>>2]=68240;M[c+100>>2]=0;M[c+48>>2]=d;M[c+52>>2]=i;i=M[c+36>>2]|112;M[c+32>>2]=M[c+32>>2]|-536575776;M[c+36>>2]=i;M[c+432>>2]=0;M[c+436>>2]=0;M[c+440>>2]=0;M[c+444>>2]=0;M[c+388>>2]=0;M[c+392>>2]=0;M[c+396>>2]=0;M[c+400>>2]=0;nj(c,33696,1,15);nj(c,33696,3,15);nj(c,33696,2,15);nj(c,20437,1,16);nj(c,20161,1,17);if(N[c+87|0]){break a}M[c+60>>2]=e;b:{if(!(1<<(f&7)&70)){a=_c(184992);break b}a=Xv(0,a?a:23200,g+40|0,c,g+36|0,g+32|0)}if(a){if((a|0)==7){Lb(c)}d=M[g+32>>2];M[g>>2]=d;ae(c,a,d?8932:0,g);ab(d);break a}a=mj(M[c>>2],M[g+36>>2],c,M[c+16>>2]+4|0,0,M[g+40>>2]|256);if(a){Yc(c,(a|0)==3082?7:a);break a}a=M[M[c+16>>2]+4>>2];M[M[a+4>>2]+4>>2]=M[a>>2];a=ql(c,a);M[M[c+16>>2]+12>>2]=a;if(!N[c+87|0]){kp(c,N[a+77|0])}d=ql(c,0);a=M[c+16>>2];K[a+24|0]=1;M[a+16>>2]=9962;K[a+8|0]=3;M[a>>2]=11364;M[a+28>>2]=d;K[c+97|0]=118;if(N[c+87|0]){break a}Yc(c,0);if((Yh(c,20350,2)|0)==7){Lb(c)}d=0;a=lp(c);while(1){if(!(d>>>0>2|a)){a=Ra[M[(d<<2)+53836>>2]](c)|0;d=d+1|0;continue}break}c:{if(!a){d=0;d:{if(!M[18518]){break d}a=1;while(1){if(!a){break d}e:{if(P[18518]<=d>>>0){M[g+44>>2]=0;a=0;f=0;break e}e=M[M[18519]+(d<<2)>>2];M[g+44>>2]=0;a=1;f=0;if(!e){break e}e=Ra[e|0](c,g+44|0,0)|0;f=M[g+44>>2];if(!e){break e}M[g+16>>2]=f;ae(c,e,8722,g+16|0);a=0;f=M[g+44>>2]}ab(f);d=d+1|0;continue}}if(!lp(c)){break c}break a}Yc(c,a)}i=M[16871];a=M[16872];f=0;d=Pk(M[c+332>>2]);e=Pk(M[c+336>>2]);d=Pk(M[c+340>>2])+d|0;k=Pk(M[c+344>>2]);if((M[c+316>>2]-((d+e|0)+k|0)|0)<=0){if(N[c+312|0]){ab(M[c+352>>2])}f:{g:{if((a|0)<=0){break g}d=((i|0)<=7?7:i)&2147483640;if(!d){break g}f=d>>>0>=65528?65528:d;d=ZJ(f,0,(a|0)>0?a:0,0);e=Qa;a=M[18582];if(a){Ra[a|0]()}a=lc(d,e);h=M[18583];if(h){Ra[h|0]()}h:{if(!a){a=0;break h}d=Ra[M[16877]](a)|0;e=d>>31}if((i|0)>=384){h=_J(d,e,f+384|0,0);j=ZJ(h,h>>31,f,0);j=_J(d-j|0,e-(Qa+(d>>>0<j>>>0)|0)|0,128,0);break f}if((i|0)>=256){h=_J(d,e,f+128|0,0);j=ZJ(h,h>>31,f,0);j=_J(d-j|0,e-(Qa+(d>>>0<j>>>0)|0)|0,128,0);break f}h=_J(d,e,f,0);break f}a=0}M[c+332>>2]=0;M[c+336>>2]=0;M[c+352>>2]=a;L[c+310>>1]=f;L[c+308>>1]=f;i:{if(a){d=0;i=(h|0)>0?h:0;e=0;while(1){if((e|0)!=(i|0)){M[a>>2]=d;M[c+332>>2]=a;e=e+1|0;d=a;a=a+f|0;continue}break}M[c+348>>2]=a;M[c+340>>2]=0;M[c+344>>2]=0;d=0;f=(j|0)>0?j:0;e=0;while(1){if((e|0)!=(f|0)){M[a>>2]=d;M[c+340>>2]=a;e=e+1|0;d=a;a=a+128|0;continue}break}M[c+304>>2]=0;M[c+356>>2]=a;K[c+312|0]=1;d=h+j|0;break i}M[c+340>>2]=0;M[c+344>>2]=0;K[c+312|0]=0;L[c+308>>1]=0;M[c+304>>2]=1;M[c+356>>2]=0;M[c+348>>2]=0;M[c+352>>2]=0;a=0;d=0}M[c+360>>2]=a;M[c+316>>2]=d}M[c+272>>2]=1e3;M[c+268>>2]=18}d=lp(c);j:{if((d&255)==7){fw(c,0);c=0;break j}if(!d){break j}K[c+97|0]=186}M[b>>2]=c;ip(M[g+36>>2])}Na=g+48|0;return d|0}function ri(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0;o=Na+-64|0;Na=o;s=M[g+16>>2];u=M[a+4>>2];k=M[a+8>>2];r=N[k+16|0];l=M[a>>2];t=M[l+4>>2];l=M[l>>2];q=M[g>>2];M[i>>2]=0;M[k>>2]=b;M[k+4>>2]=c;v=(q|0)>0?q:0;b=M[g+4>>2];while(1){if((m|0)!=(v|0)){c=op(u,M[b+8>>2]);K[b+5|0]=0;p=M[c+32>>2];w=(d&p)!=(p|0);p=M[c+36>>2];if(!(!j&(N[c+15|0]-75&255)>>>0>253|(O[c+12>>1]&f|(w|(e&p)!=(p|0))))){K[b+5|0]=1}b=b+12|0;m=m+1|0;continue}break}b=q<<3;if(b){D(s,0,b)}M[g+88>>2]=0;M[g+56>>2]=0;M[g+48>>2]=25;M[g+52>>2]=0;M[g+40>>2]=-1568170194;M[g+44>>2]=1416446638;M[g+32>>2]=0;M[g+20>>2]=0;M[g+24>>2]=0;b=M[l>>2];e=t+S(r,48)|0;d=M[e+16>>2];c=M[Gd(b,d)+8>>2];M[b+56>>2]=M[b+56>>2]+1;f=Ra[M[M[c>>2]+12>>2]](c,g)|0;b=M[l>>2];M[b+56>>2]=M[b+56>>2]-1;a:{if(!f|(f|0)==19){break a}if((f|0)==7){Lb(b);break a}b=M[c+8>>2];if(!b){y=o,z=Yg(f),M[y+32>>2]=z;cb(l,8932,o+32|0);break a}M[o+48>>2]=b;cb(l,8932,o+48|0)}b:{if(!N[M[d+52>>2]+17|0]){break b}b=0;d=M[M[l>>2]+20>>2];d=(d|0)>0?d:0;while(1){if((b|0)!=(d|0)){ud(l,b);b=b+1|0;continue}break}if(!M[l+92>>2]){break b}b=0;while(1){if((b|0)==(d|0)){break b}jd(l,0,b);b=b+1|0;continue}}ab(M[c+8>>2]);m=0;M[c+8>>2]=0;c:{if(f){if((f|0)!=19){break c}Am(g);f=0;break c}b=q<<2;if(b){D(M[k+52>>2],0,b)}M[k+32>>2]=0;M[k+36>>2]=0;M[k+24>>2]=0;M[k+28>>2]=0;f=M[g+4>>2];c=-1;d:{e:{while(1){if((m|0)!=(v|0)){f:{p=(m<<3)+s|0;d=M[p>>2];if((d|0)<=0){break f}g:{h:{if((d|0)>(q|0)){break h}b=M[f+8>>2];if((b|0)<0){break h}b=op(u,b);if(!b){break h}d=d-1|0;r=M[k+52>>2]+(d<<2)|0;if(M[r>>2]){break h}if(N[f+5|0]){break g}}M[o+16>>2]=M[M[e+16>>2]>>2];cb(l,10425,o+16|0);break e}t=M[k+4>>2]|M[b+36>>2];M[k>>2]=M[k>>2]|M[b+32>>2];M[k+4>>2]=t;M[r>>2]=b;i:{if(!N[p+4|0]){break i}if(!(h>>>m&1|m>>>0>15)){L[k+30>>1]=O[k+30>>1]|1<<d}if(N[b+15|0]!=74){break i}K[k+28|0]=N[k+28|0]|2}p=(c|0)<(d|0);j:{if(M[g+88>>2]&(m>>>0<32?1<<m:0)){M[k+36>>2]=M[k+36>>2]|1<<d;break j}if(!(K[b+12|0]&1)){break j}M[g+32>>2]=0;M[g+56>>2]=M[g+56>>2]&-2;M[i>>2]=1}c=p?d:c;if((N[b+15|0]-75&255)>>>0<254){break f}b=0;if(!M[i>>2]){while(1){if((b|0)==(m|0)){break f}d=b<<3;b=b+1|0;if(M[d+s>>2]>0){continue}break}}Am(g);M[j>>2]=1;f=0;break c}f=f+12|0;m=m+1|0;continue}break}L[k+44>>1]=c+1;c=((c|0)<0?-1:c)+1|0;b=0;while(1){if((b|0)==(c|0)){break d}d=b<<2;b=b+1|0;if(M[M[k+52>>2]+d>>2]){continue}break}M[o>>2]=M[M[e+16>>2]>>2];cb(l,10425,o)}Am(g);f=1;break c}M[k+24>>2]=M[g+20>>2];K[k+28|0]=N[k+28|0]&254|K[g+28|0]&1;M[g+28>>2]=0;M[k+32>>2]=M[g+24>>2];K[k+29|0]=M[g+32>>2]?M[g+8>>2]:0;b=N[g+56|0];L[k+18>>1]=0;K[k+28|0]=b<<1&4|N[k+28|0]&251;n=R[g+40>>3];b=0;k:{if(n<=1){break k}if(n<=2e9){if(n<0x10000000000000000&n>=0){b=~~n>>>0;if(U(n)>=1){c=~~(n>0?W(Y(n*2.3283064365386963e-10),4294967295):Z((n-+(~~n>>>0>>>0))*2.3283064365386963e-10))>>>0}else{c=0}}else{b=0;c=0}b=Td(b,c);break k}C(+n);b=x(1)|0;x(0)|0;b=S(b>>>20|0,10)-10220|0}L[k+20>>1]=b<<16>>16;y=k,z=Td(M[g+48>>2],M[g+52>>2]),L[y+22>>1]=z;M[k+40>>2]=M[k+40>>2]&-4097|M[g+56>>2]<<12&4096;f=hk(a,k);if(!(K[k+28|0]&1)){break c}ab(M[k+32>>2]);K[k+28|0]=N[k+28|0]&254}Na=o- -64|0;return f}function Do(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;f=Na-144|0;Na=f;M[f+136>>2]=d;M[f+140>>2]=e;M[f+132>>2]=0;B=M[a+44>>2];C=M[a+40>>2];D=M[a+32>>2];rt(a);o=-1;a:{b:{if(!M[a+16>>2]){break b}if(!b){break a}r=M[a>>2];t=M[r+40>>2];if($n(a,b)){break a}M[a+40>>2]=b;M[a+32>>2]=30689;i=xd(r,b,f+132|0,0);if(i){M[f+96>>2]=i;Vc(a,16784,f+96|0);if((i|0)!=3082){break b}M[a+24>>2]=7;break b}j=M[f+132>>2];E=N[j|0];K[j|0]=0;i=Th(j);if(i){M[f+80>>2]=i;Vc(a,17247,f+80|0);break b}i=Yf(j);if(i){M[f+64>>2]=i;Vc(a,10337,f- -64|0);break b}p=N[j+9|0];s=M[j+56>>2];M[a+32>>2]=30663;n=p+s|0;l=N[n+3|0]<<8|N[n+4|0];m=(N[n+6|0]|N[n+5|0]<<8)-1|0;k=N[j+8|0];if(N[j+1|0]?k:1){g=M[a+84>>2];i=M[a+80>>2]+l|0;g=l>>>0>i>>>0?g+1|0:g;M[a+80>>2]=i;M[a+84>>2]=g}i=m&65535;u=1;g=l-1|0;m=g<<1;A=(s+(p-(k<<2)|0)|0)+12|0;c:{if(!k){o=mb(n+8|0);if(N[r+17|0]){M[a+32>>2]=30718;Jg(a,o,5,b)}o=Do(a,o,f+136|0,d,e);u=0;break c}h=M[a+72>>2];M[h>>2]=0}l=i+1|0;v=m+A|0;p=t-5|0;x=t-4|0;y=1;k=g;while(1){if(!(!M[a+16>>2]|(k|0)<0)){M[a+44>>2]=k;q=N[v+1|0]|N[v|0]<<8;d:{if(!(q>>>0>i>>>0&q>>>0<=x>>>0)){M[f+40>>2]=x;M[f+36>>2]=l;M[f+32>>2]=q;Vc(a,1920,f+32|0);y=0;break d}z=q+s|0;Ra[M[j+80>>2]](j,z,f+104|0);if(q+O[f+122>>1]>>>0>t>>>0){y=0;Vc(a,14671,0);break d}if(N[j+1|0]){m=M[f+136>>2];w=M[f+140>>2];d=M[f+104>>2];e=M[f+108>>2];e:{f:{if(u){if(d>>>0>m>>>0&(e|0)>=(w|0)|(e|0)>(w|0)){break f}break e}if(d>>>0<m>>>0&(e|0)<=(w|0)|(e|0)<(w|0)){break e}}M[f+48>>2]=d;M[f+52>>2]=e;Vc(a,9732,f+48|0);d=M[f+104>>2];e=M[f+108>>2]}M[f+136>>2]=d;M[f+140>>2]=e;u=0}e=M[f+116>>2];d=O[f+120>>1];if(e>>>0>d>>>0){d=((e+p|0)-d>>>0)/(x>>>0)|0;e=mb((O[f+122>>1]+z|0)-4|0);if(N[r+17|0]){Jg(a,e,3,b)}lu(a,0,e,d)}if(!N[j+8|0]){e=mb(z);if(N[r+17|0]){Jg(a,e,5,b)}u=0;d=Do(a,e,f+136|0,M[f+136>>2],M[f+140>>2]);if((d|0)==(o|0)){break d}Vc(a,4768,0);o=d;break d}Zn(h,(q+O[f+122>>1]|0)-1|q<<16)}v=v-2|0;k=k-1|0;continue}break}d=M[f+140>>2];M[c>>2]=M[f+136>>2];M[c+4>>2]=d;M[a+32>>2]=0;if(y){if(M[a+16>>2]<=0){break b}g:{if(N[j+8|0]){break g}h=M[a+72>>2];M[h>>2]=0;while(1){if((g|0)<0){break g}c=(g<<1)+A|0;c=N[c|0]<<8|N[c+1|0];Zn(h,((Ra[M[j+76>>2]](j,c+s|0)|0)+c|0)-1|c<<16);g=g-1|0;continue}}g=n+2|0;c=n+1|0;while(1){d=N[g|0]|N[c|0]<<8;if(d){c=d+s|0;Zn(h,(d+(N[c+2|0]<<8|N[c+3|0])|0)-1|d<<16);g=c+1|0;continue}else{k=M[h>>2];l=0;h:{i:{while(1){if(!k){break i}d=M[h+4>>2];c=(k<<2)+h|0;M[h+4>>2]=M[c>>2];M[c>>2]=-1;k=k-1|0;M[h>>2]=k;g=1;while(1){j:{e=g<<1;if(e>>>0>k>>>0){break j}p=(g<<2)+h|0;m=M[p>>2];c=e|1;g=P[(e<<2)+h>>2]>P[(c<<2)+h>>2]?c:e;e=(g<<2)+h|0;c=M[e>>2];if(m>>>0<c>>>0){break j}M[p>>2]=c;M[e>>2]=m;k=M[h>>2];continue}break}c=i&65535;e=d>>>16|0;if(c>>>0<e>>>0){l=e+((c^-1)+l|0)|0;i=d;continue}break}M[f+20>>2]=b;M[f+16>>2]=e;Vc(a,2111,f+16|0);if(!M[h>>2]){break h}break b}c=i&65535}d=((c^-1)+t|0)+l|0;c=N[n+7|0];if((d|0)==(c|0)){break b}M[f+8>>2]=b;M[f+4>>2]=c;M[f>>2]=d;Vc(a,2020,f);break b}}}K[j|0]=E}Rb(M[f+132>>2]);M[a+44>>2]=B;M[a+40>>2]=C;M[a+32>>2]=D;h=o+1|0}Na=f+144|0;return h}function pm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=Na-16|0;Na=i;a:{if(d>>>0>=1001){f=b+1|0;break a}k=jc(a,b,i+12|0);if(!k){f=b+1|0;break a}e=b+k|0;h=M[i+12>>2];if((e+h|0)!=(c|0)){f=b+1|0;break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{g=M[a>>2];j=N[g+b|0]&15;switch(j|0){case 10:break a;case 0:case 1:case 2:break o;case 3:break n;case 4:break m;case 5:case 6:break l;case 7:break k;case 8:case 9:break j;case 11:break e;case 12:break f;default:break g}}f=(h+k|0)!=1?b+1|0:0;break a}if(!h){f=b+1|0;break a}if(N[e+g|0]==45){if((h|0)==1){break h}e=e+1|0}a=c>>>0<e>>>0?e:c;while(1){if((a|0)==(e|0)){break d}b=e+g|0;f=e+1|0;e=f;if(N[b|0]-58>>>0>=4294967286){continue}break}break a}if(h>>>0<=2){f=b+1|0;break a}a=N[e+g|0];if((a|0)==45){if((h|0)==3){f=b+1|0;break a}e=e+1|0;a=N[g+e|0]}if((a&255)!=48){f=b+1|0;break a}if((N[(e+g|0)+1|0]|32)!=120){f=e+2|0;break a}e=e+2|0;while(1){if(c>>>0<=e>>>0){break d}a=e+g|0;f=e+1|0;e=f;if(N[N[a|0]+31408|0]&8){continue}break}break a}if(h>>>0<=1){f=b+1|0;break a}f=N[e+g|0];if((f|0)==45){if((h|0)==2){break i}e=e+1|0;f=N[g+e|0]}if((f&255)==46){f=e+1|0;if((j|0)==5|N[g+f|0]-58>>>0<4294967286){break a}f=e+2|0;d=1;break b}d=0;if((j|0)!=5|(f&255)!=48){break c}f=e+1|0;if(e+3>>>0>c>>>0){break a}a=N[f+g|0];if((a|0)==46|(a|0)==101){break b}if((a|0)!=69){break a}break b}a=c>>>0>e>>>0?c:e;while(1){if((a|0)==(e|0)){break d}b=N[e+g|0];c=N[b+52896|0];f=e+1|0;e=f;if(c|(b|0)==39){continue}break}break a}b=(j|0)!=8;while(1){if(c>>>0<=e>>>0){break d}p:{q:{d=e+g|0;a=N[d|0];if((a|0)==39|N[a+52896|0]){break q}if((a|0)==34){if(b){break q}f=e+1|0;break a}if(a>>>0<=31){if(b){break q}f=e+1|0;break a}f=e+1|0;if((a|0)!=92|f>>>0>=c>>>0){break a}a=N[f+g|0];if(dx(2544,a,9)){break p}if((a|0)==117){if(e+5>>>0>=c>>>0){break a}if(Gq(d+2|0)){break p}break a}if((j|0)!=9){break a}M[i+8>>2]=0;a=hm(d,c-e|0,i+8|0);if(M[i+8>>2]==629145){break a}f=(a+e|0)-1|0;break p}f=e}e=f+1|0;continue}}f=b+1|0;break a}f=b+1|0;break a}f=b+1|0;break a}h=d+1|0;b=0;while(1){if(c>>>0>e>>>0){d=jc(a,e,i+12|0);if(!d){f=e+1|0;break a}d=M[i+12>>2]+(d+e|0)|0;if(d>>>0>c>>>0){f=e+1|0;break a}if(!(b&1|(N[e+g|0]&15)-11>>>0>4294967291)){f=e+1|0;break a}f=pm(a,e,d,h);if(f){break a}b=b+1|0;e=d;continue}break}f=e+1&0-(b&1);break a}d=d+1|0;while(1){if(c>>>0<=e>>>0){break d}b=jc(a,e,i+12|0);if(!b){f=e+1|0;break a}b=M[i+12>>2]+(b+e|0)|0;if(b>>>0>c>>>0){f=e+1|0;break a}f=pm(a,e,b,d);e=b;if(!f){continue}break}break a}f=0;break a}f=e}a=c-1|0;j=(j|0)!=5;while(1){r:{s:{if(c>>>0>f>>>0){h=f+g|0;e=N[h|0];if(e-58>>>0>4294967285){break s}t:{if(!((e|0)==101|(e|0)==69)){if((e|0)!=46){break t}if(d&255){f=f+1|0;break a}d=1;if(j){break s}u:{if((a|0)==(f|0)){f=a;break u}e=f;if(N[h+1|0]-58>>>0>4294967285){break r}}f=f+1|0;break a}if((d&255)==2){f=f+1|0;break a}if((a|0)==(f|0)){f=c;break a}d=2;v:{e=f;h=e+1|0;switch(N[h+g|0]-43|0){case 0:case 2:break v;default:break r}}e=h;if((a|0)!=(e|0)){break r}f=f+2|0;break a}f=f+1|0;break a}f=d&255?0:b+1|0;break a}e=f}f=e+1|0;continue}}Na=i+16|0;return f}function Jd(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;i=Na-16|0;Na=i;M[b>>2]=0;M[b+4>>2]=0;a:{if(!c){break a}b:{if((d|0)==1){e=a;d=1;j=1;break b}e=3-d|0;c=c&-2;while(1){c:{if((c|0)<=(e|0)){j=1}else{if(!N[a+e|0]){break c}j=-100}c=e^1;e=(d&1)+a|0;d=2;break b}e=e+2|0;continue}}k=a+c|0;while(1){if(e>>>0>=k>>>0){break a}m=N[e|0];if(K[m+31408|0]&1){e=d+e|0;continue}break}a=((m|0)==45?d:(m|0)==43?d:0)+e|0;d:{e:{f:{g:while(1){if(a>>>0>=k>>>0){e=1;break f}c=N[a|0];if(c-58>>>0>=4294967286){n=n+1|0;a=a+d|0;e=c<<24>>24;g=ZJ(g,f,10,0);c=e+g|0;f=Qa+(e>>31)|0;f=c>>>0<g>>>0?f+1|0:f;g=c-48|0;c=f-(c>>>0<48)|0;f=c;if((c|0)==429496729&g>>>0<2576980376|c>>>0<429496729){continue}while(1){if(N[a|0]-58>>>0<4294967286|a>>>0>=k>>>0){continue g}o=o+1|0;a=a+d|0;continue}}break}h:{if((c|0)!=46){break h}j=j+1|0;while(1){a=a+d|0;if(k>>>0<=a>>>0){break h}c=N[a|0];if(c-58>>>0<4294967286){break h}if((f|0)==429496729&g>>>0>2576980375|f>>>0>429496729){continue}n=n+1|0;o=o-1|0;e=c<<24>>24;g=ZJ(g,f,10,0);c=e+g|0;f=Qa+(e>>31)|0;f=c>>>0<g>>>0?f+1|0:f;g=c-48|0;f=f-(c>>>0<48)|0;continue}}e=1;if(a>>>0<k>>>0){break e}}p=1;break d}i:{if((N[a|0]|32)!=101){p=1;break i}j=j+1|0;a=a+d|0;if(k>>>0<=a>>>0){break d}j:{k:{switch(N[a|0]-43|0){case 2:a=a+d|0;e=-1;break j;case 0:break k;default:break j}}a=a+d|0}while(1){if(a>>>0>=k>>>0){break i}c=N[a|0];if(c-58>>>0<4294967286){break i}l=(l|0)>=1e4?1e4:((c<<24>>24)+S(l,10)|0)-48|0;a=a+d|0;p=1;continue}}while(1){if(!(K[N[a|0]+31408|0]&1)|a>>>0>=k>>>0){break d}a=a+d|0;continue}}l:{if(f|g){e=S(e,l)+o|0;while(1){if(!((f|0)==429496729&g>>>0>2576980171|f>>>0>429496729|(e|0)<=0)){e=e-1|0;g=ZJ(g,f,10,0);f=Qa;continue}break}while(1){c=aK(g,f,10,0);d=Qa;if(!((ZJ(c,d,10,0)|0)!=(g|0)|(Qa|0)!=(f|0)|(e|0)>=0)){e=e+1|0;g=c;f=d;continue}break}h=+(g>>>0)+ +(f>>>0)*4294967296;R[i>>3]=h;q=0;m:{if(!(h<=0xfffffffffffff800)){break m}if(h<0x10000000000000000&h>=0){c=~~h>>>0;if(U(h)>=1){d=~~(h>0?W(Y(h*2.3283064365386963e-10),4294967295):Z((h-+(~~h>>>0>>>0))*2.3283064365386963e-10))>>>0}else{d=0}}else{c=0;d=0}if((f|0)==(d|0)&c>>>0<=g>>>0|d>>>0<f>>>0){q=+(g-c>>>0)+ +(f-((c>>>0>g>>>0)+d|0)>>>0)*4294967296;break m}q=-(+(c-g>>>0)+ +(d-((c>>>0<g>>>0)+f|0)>>>0)*4294967296)}R[i+8>>3]=q;n:{if((e|0)>0){while(1)if(e>>>0<100){while(1)if(e>>>0<10){while(1){if((e|0)<=0){break n}qe(i,10,0);e=e-1|0;continue}}else{qe(i,1e10,0);e=e-10|0;continue}}else{qe(i,1e100,-15902891109759918e67);e=e-100|0;continue}}while(1)if((e|0)>-100){while(1)if((e|0)>-10){while(1){if((e|0)>=0){break n}qe(i,.1,-5551115123125783e-33);e=e+1|0;continue}}else{qe(i,1e-10,-3643219731549774e-42);e=e+10|0;continue}}else{qe(i,1e-100,-19991899802602883e-133);e=e+100|0;continue}}h=R[i>>3]+R[i+8>>3];h=h==h?h:Infinity;R[b>>3]=h;if((m|0)!=45){break l}h=-h}else{h=(m|0)==45?-0:0}R[b>>3]=h}if(!(!((a|0)==(k|0)&(n|0)>0&p)|(j|0)<=0)){l=j;break a}o:{if((j|0)<2){break o}l=-1;if((p^-1)&(j|0)!=3){break o}if((n|0)>0){break a}}l=0}Na=i+16|0;return l}function Ie(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;a:{if(!a){break a}d=a-8|0;b=M[a-4>>2];a=b&-8;f=d+a|0;b:{if(b&1){break b}if(!(b&2)){break a}b=M[d>>2];d=d-b|0;if(d>>>0<P[18600]){break a}a=a+b|0;c:{d:{e:{if(M[18601]!=(d|0)){c=M[d+12>>2];if(b>>>0<=255){e=M[d+8>>2];if((e|0)!=(c|0)){break e}j=74384,k=M[18596]&cK(-2,b>>>3|0),M[j>>2]=k;break b}h=M[d+24>>2];if((c|0)!=(d|0)){b=M[d+8>>2];M[b+12>>2]=c;M[c+8>>2]=b;break c}e=M[d+20>>2];if(e){b=d+20|0}else{e=M[d+16>>2];if(!e){break d}b=d+16|0}while(1){g=b;c=e;b=c+20|0;e=M[c+20>>2];if(e){continue}b=c+16|0;e=M[c+16>>2];if(e){continue}break}M[g>>2]=0;break c}b=M[f+4>>2];if((b&3)!=3){break b}M[18598]=a;M[f+4>>2]=b&-2;M[d+4>>2]=a|1;M[f>>2]=a;return}M[e+12>>2]=c;M[c+8>>2]=e;break b}c=0}if(!h){break b}b=M[d+28>>2];e=(b<<2)+74688|0;f:{if(M[e>>2]==(d|0)){M[e>>2]=c;if(c){break f}j=74388,k=M[18597]&cK(-2,b),M[j>>2]=k;break b}g:{if(M[h+16>>2]==(d|0)){M[h+16>>2]=c;break g}M[h+20>>2]=c}if(!c){break b}}M[c+24>>2]=h;b=M[d+16>>2];if(b){M[c+16>>2]=b;M[b+24>>2]=c}b=M[d+20>>2];if(!b){break b}M[c+20>>2]=b;M[b+24>>2]=c}if(d>>>0>=f>>>0){break a}b=M[f+4>>2];if(!(b&1)){break a}h:{i:{j:{k:{if(!(b&2)){if(M[18602]==(f|0)){M[18602]=d;a=M[18599]+a|0;M[18599]=a;M[d+4>>2]=a|1;if(M[18601]!=(d|0)){break a}M[18598]=0;M[18601]=0;return}i=M[18601];if((i|0)==(f|0)){M[18601]=d;a=M[18598]+a|0;M[18598]=a;M[d+4>>2]=a|1;M[a+d>>2]=a;return}a=(b&-8)+a|0;c=M[f+12>>2];if(b>>>0<=255){e=M[f+8>>2];if((e|0)==(c|0)){j=74384,k=M[18596]&cK(-2,b>>>3|0),M[j>>2]=k;break i}M[e+12>>2]=c;M[c+8>>2]=e;break i}h=M[f+24>>2];if((c|0)!=(f|0)){b=M[f+8>>2];M[b+12>>2]=c;M[c+8>>2]=b;break j}e=M[f+20>>2];if(e){b=f+20|0}else{e=M[f+16>>2];if(!e){break k}b=f+16|0}while(1){g=b;c=e;b=c+20|0;e=M[c+20>>2];if(e){continue}b=c+16|0;e=M[c+16>>2];if(e){continue}break}M[g>>2]=0;break j}M[f+4>>2]=b&-2;M[d+4>>2]=a|1;M[a+d>>2]=a;break h}c=0}if(!h){break i}b=M[f+28>>2];e=(b<<2)+74688|0;l:{if(M[e>>2]==(f|0)){M[e>>2]=c;if(c){break l}j=74388,k=M[18597]&cK(-2,b),M[j>>2]=k;break i}m:{if(M[h+16>>2]==(f|0)){M[h+16>>2]=c;break m}M[h+20>>2]=c}if(!c){break i}}M[c+24>>2]=h;b=M[f+16>>2];if(b){M[c+16>>2]=b;M[b+24>>2]=c}b=M[f+20>>2];if(!b){break i}M[c+20>>2]=b;M[b+24>>2]=c}M[d+4>>2]=a|1;M[a+d>>2]=a;if((d|0)!=(i|0)){break h}M[18598]=a;return}if(a>>>0<=255){b=(a&-8)+74424|0;e=M[18596];a=1<<(a>>>3);n:{if(!(e&a)){M[18596]=a|e;a=b;break n}a=M[b+8>>2]}M[b+8>>2]=d;M[a+12>>2]=d;M[d+12>>2]=b;M[d+8>>2]=a;return}c=31;if(a>>>0<=16777215){b=V(a>>>8|0);c=((a>>>38-b&1)-(b<<1)|0)+62|0}M[d+28>>2]=c;M[d+16>>2]=0;M[d+20>>2]=0;b=(c<<2)+74688|0;o:{p:{e=M[18597];g=1<<c;q:{if(!(e&g)){M[18597]=e|g;M[b>>2]=d;c=24;break q}c=a<<((c|0)!=31?25-(c>>>1|0)|0:0);b=M[b>>2];while(1){e=b;if((M[b+4>>2]&-8)==(a|0)){break p}b=c>>>29|0;c=c<<1;g=(b&4)+e|0;b=M[g+16>>2];if(b){continue}break}M[g+16>>2]=d;b=e;c=24}e=d;g=d;a=8;break o}b=M[e+8>>2];M[b+12>>2]=d;M[e+8>>2]=d;c=8;g=0;a=24}M[c+d>>2]=b;M[d+12>>2]=e;M[a+d>>2]=g;a=M[18604]-1|0;M[18604]=a?a:-1}}function li(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;e=Na-32|0;Na=e;t=M[b+4>>2];a:{if(!t){break a}w=N[a+239|0]?108:109;m=M[b>>2];x=(t|0)<=1?1:t;u=M[b+12>>2];c=M[u+12>>2];z=c&34;A=c&2;y=c&1;B=c&4;C=c&16;D=c&32;E=!(c&8);b:while(1){f=0;while(1){c=M[b+8>>2];if((c|0)>(f|0)){c=M[(f<<2)+m>>2];c:{if(N[c+4|0]){nq(c);break c}d=Ly(a,c);if(d){break a}}f=f+1|0;continue}break}ki(m,t,c,110);d=0;M[b+8>>2]=0;i=M[m>>2];if(!M[i+40>>2]){break a}g=M[i+60>>2];M[b+52>>2]=g;k=M[i+64>>2];M[b+48>>2]=k;c=M[u>>2];if(!(!c|C)){l=M[u+4>>2];if((l|0)>(g|0)|(g|0)>(l|0)&E){break a}if(Qb(k,c,l)){break a}}j=1;while(1){d:{if((j|0)==(x|0)){j=x;break d}c=M[(j<<2)+m>>2];if(!M[c+40>>2]|(g|0)!=M[c+60>>2]){break d}if(Qb(k,M[c+64>>2],g)){break d}j=j+1|0;continue}break}e:{if((j|0)!=1|z){break e}c=M[i+56>>2];f:{g:{h:{i:{if(N[a+239|0]){if(c){break e}M[b+60>>2]=M[i+76>>2];break i}a=M[i+76>>2];M[b+60>>2]=a;if(c){break h}}M[b+56>>2]=M[i+72>>2];break g}d=Iy(b,M[i+72>>2],a,a>>31);M[b+56>>2]=M[b+16>>2];if(d){break f}}d=100}M[b+8>>2]=1;break a}f=0;while(1){if((f|0)!=(j|0)){Hy(a,M[(f<<2)+m>>2]);f=f+1|0;continue}break}ki(m,j,j,w);k=0;n=0;h=0;while(1){j:{c=M[m>>2];if(M[c+80>>2]){M[e+12>>2]=0;M[e+8>>2]=0;l=M[c+88>>2];o=M[c+92>>2];$l(a,c,e+12|0,e+8|0);f=1;while(1){if((f|0)==(j|0)){f=j;break j}g=M[(f<<2)+m>>2];if(!M[g+80>>2]|((l|0)!=M[g+88>>2]|(o|0)!=M[g+92>>2])){break j}$l(a,g,0,0);f=f+1|0;continue}}if((h|0)>0){d=Gy(b,h+20|0,0);if(d){break a}a=M[b+16>>2]+h|0;K[a|0]=0;K[a+1|0]=0;K[a+2|0]=0;K[a+3|0]=0;K[a+4|0]=0;K[a+5|0]=0;K[a+6|0]=0;K[a+7|0]=0;K[a+16|0]=0;K[a+17|0]=0;K[a+18|0]=0;K[a+19|0]=0;K[a+8|0]=0;K[a+9|0]=0;K[a+10|0]=0;K[a+11|0]=0;K[a+12|0]=0;K[a+13|0]=0;K[a+14|0]=0;K[a+15|0]=0;M[b+60>>2]=h;M[b+8>>2]=j;M[b+56>>2]=M[b+16>>2];d=100;break a}M[b+8>>2]=j;continue b}if(B){Fy(M[u+8>>2],0,e+12|0,e+8|0)}k:{s=M[e+8>>2];l:{if((s|0)<=0?A:0){break l}v=h>>31;m:{if(!(!N[a+239|0]|(h|0)<=0)){if((n|0)<=(o|0)&k>>>0<=l>>>0|(n|0)<(o|0)){break k}i=n-((k>>>0<l>>>0)+o|0)|0;g=k-l|0;break m}if(((n|0)>=(o|0)&k>>>0>=l>>>0|(n|0)>(o|0))&(h|0)>0){break k}i=o-((k>>>0>l>>>0)+n|0)|0;g=l-k|0}c=_d(g,i)+(y?s+1|0:0)|0;p=c;r=c+h|0;c=(c>>31)+v|0;c=r>>>0<p>>>0?c+1|0:c;p=r+20|0;c=p>>>0<20?c+1|0:c;d=Gy(b,p,c);if(d){break a}q=M[b+16>>2]+h|0;if(D){p=M[e+12>>2];M[e+28>>2]=p;r=0;d=0;n:{switch(N[p|0]-1|0){case 1:c=uc(q,g,i);K[c+q|0]=2;r=1;d=c+1|0;default:Ef(0,e+28|0);break;case 0:break n}}v=p+s|0;while(1){c=M[e+28>>2];if(v>>>0>c>>>0){c=c+1|0;c=Ic(c,e+16|0)+c|0;M[e+28>>2]=c;if(N[c|0]==2){if(!r){d=uc(d+q|0,g,i)+d|0}K[d+q|0]=1;c=d+1|0;c=uc(c+q|0,M[e+16>>2],M[e+20>>2])+c|0;K[c+q|0]=2;d=c+1|0;r=1}Ef(0,e+28|0);continue}break}if(r){K[d+q|0]=0;d=d+1|0}k=d?l:k;n=d?o:n;h=d+h|0;break l}h=uc(q,g,i)+h|0;if(y){if(s){G(M[b+16>>2]+h|0,M[e+12>>2],s)}c=h+s|0;K[c+M[b+16>>2]|0]=0;h=c+1|0}k=l;n=o}ki(m,j,f,w);continue}break}break}d=267}Na=e+32|0;return d}function jv(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;f=Na-80|0;Na=f;c=fl(a,0,f+16|0);a:{if(c){if((c|0)!=1288){break a}K[a+43|0]=2;K[a+50|0]=1;M[b>>2]=1}b:{c:{d:{e:{if(M[f+16>>2]){if(!hv(a,b)){break e}}if(!(N[a+50|0]|!(N[a+46|0]&2))){c=Rh(a,0);if(c){break d}Pg(a,0);c=264;if(!N[a+50|0]){break a}break c}o=N[a+44|0];if(!o){c=cg(a,0,1);if(c){break d}}K[a+44|0]=1;c=fl(a,0,f+16|0);d=0;f:{if(c){break f}if(!hv(a,b)){c=0;d=1;break f}d=N[a+45|0];p=d+1|0;q=2-d|0;c=cg(a,p,q);if(!c){D(a+52|0,0,48);d=M[a+8>>2];c=Ra[M[M[d>>2]+24>>2]](d,f+72|0)|0;g:{if(c){break g}d=M[f+72>>2];e=M[f+76>>2];if((e|0)<0){c=1}else{c=d>>>0<33&(e|0)<=0}h:{if(c){break h}d=M[a+8>>2];h=f+32|0;c=Ra[M[M[d>>2]+8>>2]](d,h,32,0,0)|0;if(c){break g}i:{e=N[f+35|0];if((e&254|(N[f+33|0]<<16|N[f+32|0]<<24|N[f+34|0]<<8))!=931071618){break i}j=N[f+42|0]<<8;c=N[f+41|0]<<16|N[f+40|0]<<24;d=j|(c|N[f+43|0]);if(d-1&d|d-65537>>>0<4294902271){break i}M[a+36>>2]=d;g=e&1;K[a+65|0]=g;e=M[f+44>>2];M[a+112>>2]=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);e=M[f+52>>2];M[a+84>>2]=M[f+48>>2];M[a+88>>2]=e;bg(!g,h,24,0,a+76|0);e=M[f+56>>2];if(M[a+76>>2]!=(e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24))){break i}e=M[f+60>>2];if(M[a+80>>2]!=(e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24))){break i}e=M[f+36>>2];if((e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24))!=3007e3){c=ne(66593);break g}g=Bb(d+32792|0,0);if(!g){c=7;break g}w=j|c>>>16;r=g+24|0;s=d+r|0;e=M[f+72>>2];h=d+24|0;j=_J(e-32|0,M[f+76>>2]-(e>>>0<32)|0,h,0);x=(j+33>>>12|0)+1|0;c=0;while(1){j:{if((i|0)==(x|0)){break j}c=fl(a,i,f+28|0);m=M[f+28>>2];if(!m){break j}t=i<<2;M[t+M[a+32>>2]>>2]=s;e=i<<12;d=e|4062;y=d>>>0<j>>>0?d:j;d=i?e-33|0:1;e=0;while(1){k:{u=!e&d>>>0>y>>>0|(e|0)!=0;if(u){break k}v=M[a+8>>2];c=h;k=ZJ(d-1|0,e-!d|0,c,0);l=Qa;k=k+32|0;l=k>>>0<32?l+1|0:l;c=Ra[M[M[v>>2]+8>>2]](v,g,c,k,l)|0;if(c){break k}if(!iv(a,f+24|0,f+20|0,r,g)){c=0;break k}c=$o(a,d,M[f+24>>2]);if(c){break k}c=M[f+20>>2];if(c){M[a+72>>2]=c;M[a+68>>2]=d;L[a+66>>1]=w;z=M[a+76>>2];A=M[a+80>>2]}d=d+1|0;e=d?e:e+1|0;c=0;continue}break}M[t+M[a+32>>2]>>2]=m;d=i?0:136;e=32768-d|0;if(e){G(d+m|0,d+s|0,e)}if(!u){break j}i=i+1|0;continue}break}ab(g);if(c){break g}break h}}M[a+80>>2]=A;M[a+76>>2]=z;_o(a);d=M[M[a+32>>2]>>2];M[d+96>>2]=0;M[d+128>>2]=M[a+68>>2];M[d+100>>2]=0;e=d+100|0;c=1;l:{while(1){if((c|0)!=5){h=c+3|0;n=cg(a,h,1);if((n|0)!=5){if(n){break l}m:{n:{if((c|0)!=1){break n}g=M[a+68>>2];if(!g){break n}M[d+104>>2]=g;break m}M[e+(c<<2)>>2]=-1}Ee(a,h,1)}c=c+1|0;continue}break}if(!M[a+72>>2]){break l}d=M[a+68>>2];M[f+4>>2]=M[a+108>>2];M[f>>2]=d;Lc(283,6981,f)}c=n}Ee(a,p,q)}M[b>>2]=1;d=0}if(!o){K[a+44|0]=0;Ee(a,0,1)}if(!d){break d}}if(M[a+52>>2]==3007e3){break d}c=ne(67847)}if(!N[a+50|0]){break a}if(c){break c}c=0;break b}Wo(a,0);K[a+50|0]=0;c=(c|0)==522?-1:c}K[a+43|0]=0}Na=f+80|0;return c}function Ry(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;m=Na-32|0;Na=m;a:{b:{if((d|0)>=0){M[m+16>>2]=0;k=Tb(a,12,m+16|0,0);j=M[m+16>>2];if(k){break b}k=M[a+260>>2];k=ZJ(k,k>>31,b,b>>31);b=k+c|0;c=Qa+(c>>31)|0;q=d;d=(b>>>0<k>>>0?c+1|0:c)<<10|b>>>22;c=b<<10;k=q+c|0;b=d;Jb(j,1,k,c>>>0>k>>>0?b+1|0:b);k=0;break b}j=M[a+264>>2];c:{if(!j|M[a+288>>2]!=(b|0)){break c}r=4;j=(j+S(c,24)|0)+4|0;d:{e:{f:{t=g|h;g:{if(t){j=j+8|0;r=0;while(1){j=M[j>>2];M[m+16>>2]=j;h:{if(j){if(f){k=M[j+12>>2];if(M[j+16>>2]<(f|0)){continue}if(Qb(k,e,f)){continue}}if((n|0)!=(r|0)){k=q;break h}n=n+16|0;k=Mc(q,n<<2,0);if(k){break h}break f}if(r>>>0>=2){n=q;l=Na-208|0;Na=l;M[l+8>>2]=1;M[l+12>>2]=0;s=r<<2;i:{if(!s){break i}M[l+16>>2]=4;M[l+20>>2]=4;j=4;o=4;p=2;while(1){k=j;j=(o+4|0)+j|0;M[(l+16|0)+(p<<2)>>2]=j;p=p+1|0;o=k;if(j>>>0<s>>>0){continue}break}s=(n+s|0)-4|0;j:{if(s>>>0<=n>>>0){p=1;j=1;k=0;break j}p=1;j=1;while(1){k:{if((p&3)==3){Dp(n,j,l+16|0);Il(l+8|0,2);j=j+2|0;break k}k=l+16|0;o=j-1|0;l:{if(P[k+(o<<2)>>2]>=s-n>>>0){Hl(n,p,M[l+12>>2],j,0,k);break l}Dp(n,j,l+16|0)}if((j|0)==1){Gl(l+8|0,1);j=0;break k}Gl(l+8|0,o);j=1}p=M[l+8>>2]|1;M[l+8>>2]=p;n=n+4|0;if(s>>>0>n>>>0){continue}break}k=M[l+12>>2]}Hl(n,p,k,j,0,l+16|0);o=M[l+12>>2];p=M[l+8>>2];if(!(o|((j|0)!=1|(p|0)!=1))){break i}while(1){m:{if((j|0)<=1){k=cx(p,o);Il(l+8|0,k);k=j+k|0;break m}p=l+8|0;Gl(p,2);M[l+8>>2]=M[l+8>>2]^7;Il(p,1);o=n-4|0;s=l+16|0;k=j-2|0;Hl(o-M[s+(k<<2)>>2]|0,M[l+8>>2],M[l+12>>2],j-1|0,1,s);Gl(p,1);j=M[l+8>>2]|1;M[l+8>>2]=j;Hl(o,j,M[l+12>>2],k,1,s)}j=k;n=n-4|0;o=M[l+12>>2];p=M[l+8>>2];if(o|((j|0)!=1|(p|0)!=1)){continue}break}}Na=l+208|0;r=r<<2;break g}n=1;k=0;if((r|0)!=1){break e}r=4;break g}M[(r<<2)+k>>2]=j;r=r+1|0;j=M[m+16>>2];q=k;continue}}j=Oy(j,e,f);M[m+16>>2]=j;if(!j){break c}q=m+16|0}o=r+100|0;j=Bb(o,0);if(!j){break f}k=0;if(o){D(j,0,o)}o=j+96|0;M[j+56>>2]=o;M[j>>2]=2147483647;if(r){G(o,q,r)}n=1;break d}n=0;k=7}j=0}if(t){ab(q)}if(!j|n^1){break c}k=Ny(i,j)}j=0;if((d|0)==-1){break a}if(k){break b}k=0;M[m+16>>2]=0;d=Tb(a,13,m+16|0,0);j=M[m+16>>2];if(d){k=d;break b}q=c;t=b>>31;d=M[a+260>>2];n=ZJ(b,t,d,d>>31);d=n+c|0;o=c>>31;s=o+Qa|0;c=d;d=(c>>>0<n>>>0?s+1|0:s)<<10|c>>>22;Jb(j,1,c<<10,d);c=M[a+260>>2];b=ZJ(c,c>>31,b,t);c=o+Qa|0;b=b+q|0;c=b>>>0<q>>>0?c+1|0:c;Jb(j,2,b<<10|1023,c<<10|b>>>22)}o=g?m+8|0:0;q=g|h;h=!q;while(1){if(k){break a}k=Db(j);if((k|0)!=100){break a}M[m+28>>2]=0;u=m,v=dd(j,1),M[u+16>>2]=v;M[m+20>>2]=Qa;u=m,v=dd(j,2),M[u+8>>2]=v;M[m+12>>2]=Qa;c=dd(j,3);g=Qa;n=Wd(j,4);t=Ye(j,4);b=M[m+16>>2];d=M[m+20>>2];n:{if(!t|(!e|!(b|d))){break n}k=oq(a,e,f,t,n,m+16|0,o);if(k){break a}b=M[m+16>>2];d=M[m+20>>2];if(q){break n}M[m+8>>2]=b;M[m+12>>2]=d}k=My(M[i+4>>2]+1|0,h,b,d,M[m+8>>2],M[m+12>>2],c,g,t,n,m+28|0);if(k){break a}k=Ny(i,M[m+28>>2]);continue}}a=wb(j);Na=m+32|0;return(k|0)==101?a:k}function Hm(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;a:{b:{c:{d:{e:{h=M[b>>2];k=N[h|0];switch(k-51|0){case 0:break c;case 1:case 2:break b;case 3:break d;default:break e}}if((k|0)!=45){break b}}f=Se(a,M[h+16>>2],f);break a}$a(M[a+8>>2],75,0,f);break a}k=a;p=Na-16|0;Na=p;m=M[c+80>>2];f:{if(N[m+41|0]&4){break f}a=M[m+32>>2];if(!a){break f}e=N[M[a+28>>2]+d|0]!=0^e}n=M[b>>2];t=M[k+8>>2];a=0;h=(d|0)>0?d:0;g:{while(1){h:{if((a|0)==(h|0)){a=O[m+44>>1];g=(a|0)<(d|0)?d:a;h=0;a=d;while(1){if((a|0)==(g|0)){break h}h=(M[M[M[m+52>>2]+(a<<2)>>2]>>2]==(n|0))+h|0;a=a+1|0;continue}}g=M[M[m+52>>2]+(a<<2)>>2];if(!g|M[g>>2]!=(n|0)){a=a+1|0;continue}else{wg(c,b);break g}}break}M[p+12>>2]=0;a=M[n+4>>2];i:{if(!(M[M[M[n+20>>2]+28>>2]>>2]!=1?a&4096:0)){s=Rm(k,n,4,0,0,p+12|0);break i}if(!(M[n+28>>2]?a&33554432:0)){o=M[k>>2];j=qb(o,n,0);s=5;j:{if(N[o+87|0]){break j}a=j+20|0;while(1){l=M[a>>2];if(l){u=M[l+28>>2];g=0;q=0;q=(l|0)==M[j+20>>2]?M[M[j+12>>2]+20>>2]:q;y=q+8|0;z=u+8|0;i=0;a=d;while(1){if(O[m+44>>1]>(a|0)){r=M[M[m+52>>2]+(a<<2)>>2];k:{if(M[r>>2]!=(n|0)){break k}r=M[r+28>>2];v=r-1<<4;w=v+z|0;x=M[w>>2];if(!x){break k}g=Wb(k,g,x);M[w>>2]=0;if(g){L[((M[g>>2]<<4)+g|0)+4>>1]=r}if(!q){break k}r=y+v|0;i=Wb(k,i,M[r>>2]);M[r>>2]=0}a=a+1|0;continue}break}xb(o,u);if(q){xf(o,q);M[M[j+12>>2]+20>>2]=i}M[l+28>>2]=g;a=M[k+112>>2]+1|0;M[k+112>>2]=a;M[l+16>>2]=a;if(!(!i|M[i>>2]!=1)){a=M[i+8>>2];M[i+8>>2]=0;kb(o,M[j+12>>2]);M[j+12>>2]=a}l:{if(!g){break l}_z(M[l+48>>2],g);_z(M[l+40>>2],g);a=0;i=M[g>>2];i=(i|0)>0?i:0;g=g+20|0;while(1){if((a|0)==(i|0)){break l}L[g+(a<<4)>>1]=0;a=a+1|0;continue}}a=l+52|0;continue}break}i=0;if(N[o+87|0]){break j}i=ub(M[k>>2],h<<2,0);s=Rm(k,j,4,0,i,p+12|0);M[n+28>>2]=M[p+12>>2]}kb(o,j);break i}a=M[k>>2];g=Zc(M[n+12>>2]);i=ub(a,((h|0)>(g|0)?h:g)<<2,0);s=Rm(k,n,4,0,i,p+12|0)}g=((s|0)==4|0)==(e|0);e=M[p+12>>2];$a(t,g?36:32,e,0);a=M[m+40>>2];M[m+40>>2]=a|2048;if(!M[c+72>>2]){j=M[k+60>>2]-1|0;M[k+60>>2]=j;M[c+16>>2]=j}if(!(a&1048576|(d|0)<=0)){M[m+40>>2]=a|264192}j=M[c+72>>2];a=j+h|0;M[c+72>>2]=a;m:{n:{h=M[c+76>>2];a=kr(M[M[b+4>>2]>>2],S(a,20));o:{if(!(!h|!a)){l=M[h-8>>2];if(l){G(a,h,l)}M[c+76>>2]=a;break o}M[c+76>>2]=a;if(!a){break n}}q=g?39:38;o=f-d|0;h=a+S(j,20)|0;s=(s|0)!=1;a=d;j=0;while(1){if(O[m+44>>1]>(a|0)){if(M[M[M[m+52>>2]+(a<<2)>>2]>>2]==(n|0)){l=a+o|0;p:{if(!s){g=$a(t,135,e,l);break p}q:{if(!i){g=0;break q}g=M[(j<<2)+i>>2];j=j+1|0}g=bb(t,94,e,g,l)}M[h+4>>2]=g;fb(t,51,l);r:{if((a|0)==(d|0)){K[h+16|0]=q;M[h>>2]=e;if((d|0)>0){M[h+12>>2]=d;M[h+8>>2]=o;break r}M[h+12>>2]=0;break r}K[h+16|0]=187}h=h+20|0}a=a+1|0;continue}break}if((N[m+41|0]|N[m+42|0]<<8)&4100|(d|0)<=0){break m}bb(t,125,M[c+8>>2],0,d);break m}M[c+72>>2]=0}eb(M[k>>2],i)}Na=p+16|0}if(!(N[b+13|0]&8?N[M[c+80>>2]+42|0]&32:0)){wg(c,b)}return f}function fi(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Na-16|0;Na=h;a:{b:{while(1){d=M[c>>2];e=(d|0)!=0;if(d){break a}c:{switch(M[b>>2]-1|0){case 0:case 2:d:{if(!fi(a,M[b+12>>2],c)){break d}if(!fi(a,M[b+16>>2],c)){break d}if(M[c>>2]){break b}e=1;if(M[b>>2]!=1){break a}d=M[b+8>>2];if(M[d>>2]==1?d:0){break a}d=b;while(1){e=M[d+12>>2];if(e){d=M[M[M[d+16>>2]+20>>2]+32>>2];f=d;g=f+g|0;d=(f>>31)+i|0;i=g>>>0<f>>>0?d+1|0:d;d=e;continue}break}e=g;g=M[M[d+20>>2]+32>>2];f=g;e=e+f|0;g=(f>>31)+i|0;g=(e>>>0<f>>>0?g+1|0:g)<<1|e>>>31;i=(e<<1)+10|0;g=i>>>0<10?g+1|0:g;g=Bb(i,g);if(!g){M[c>>2]=7;ab(0);break d}c=M[d+20>>2];M[h+8>>2]=M[c+28>>2];M[h+4>>2]=M[c+64>>2];e=1;while(1){e:{if(!e){break e}d=M[d+8>>2];if(!d|M[d>>2]!=1){break e}e=Px(M[d+4>>2],g,h+8|0,h+4|0,M[M[d+16>>2]+20>>2]);continue}break}c=M[M[b+16>>2]+20>>2];M[h+8>>2]=M[c+28>>2];M[h+4>>2]=M[c+64>>2];c=b;while(1){c=M[c+12>>2];if(!(!c|!e)){e=Px(M[M[c+8>>2]+4>>2],g,h+8|0,h+4|0,M[(M[c>>2]==1?M[c+16>>2]:c)+20>>2]);continue}break}ab(g);if(e){break b}}e=0;if(M[b>>2]!=1){break a}c=M[b+8>>2];if(M[c>>2]==1?c:0){break a}while(1){c=M[b+20>>2];if(!c){c=M[b+16>>2];if(M[c+24>>2]==M[a+32>>2]&M[c+28>>2]==M[a+36>>2]){ii(M[c+20>>2])}b=M[b+12>>2];continue}break};if(M[b+24>>2]!=M[a+32>>2]|M[b+28>>2]!=M[a+36>>2]){break a}ii(c);break a;case 3:e=(fi(a,M[b+12>>2],c)|fi(a,M[b+16>>2],c))!=0;break a;case 1:if(!fi(a,M[b+12>>2],c)){break a}n=n^1;b=M[b+16>>2];continue;default:break c}}break}f:{g:{h:{if(!M[a+28>>2]){break h}if(N[b+34|0]){break g}if(M[b+24>>2]!=M[a+32>>2]|M[b+28>>2]!=M[a+36>>2]){break h}f=M[b+20>>2];if(M[f+28>>2]){break f}}e=0;if(N[b+32|0]|(M[b+24>>2]!=M[a+32>>2]|M[b+28>>2]!=M[a+36>>2])){break a}e=M[M[b+20>>2]+32>>2]>0;break a}f=M[b+20>>2];ii(f)}l=M[f+24>>2]?M[f+28>>2]:l;o=f+88|0;g=-1;e=0;d=0;i:{j:{k:{l:{while(1){if(M[f+64>>2]>(d|0)){k=M[S(d,24)+o>>2];if(k){m:{i=M[k+12>>2];if(i){i=M[i>>2];i=Bb(i,i>>31);if(i){break m}break j}ab(e);ab(l);M[f+28>>2]=0;M[f+32>>2]=0;d=0;break i}m=Ic(M[M[k+12>>2]+4>>2],h+8|0);k=M[k+12>>2];j=M[k>>2]-m|0;if(j){G(i,m+M[k+4>>2]|0,j)}if(e){M[h+8>>2]=i;M[h+4>>2]=e;M[h>>2]=i;hi(h+8|0,d-g|0,0,1,h+4|0,h);ab(e);j=M[h+8>>2]-i|0;if(!j){break l}}e=i;g=d}d=d+1|0;continue}break}d=0;n:{if((g|0)<0){break n}i=M[f+44>>2];if((i|0)<0){M[f+32>>2]=j;M[f+28>>2]=e;g=M[a+32>>2];i=M[a+36>>2];M[f+24>>2]=1;M[f+16>>2]=g;M[f+20>>2]=i;break n}m=M[f+28>>2];k=g>>>0<i>>>0;M[h+4>>2]=k?m:e;M[h+8>>2]=k?e:m;j=j+8|0;j=Oe(j,j>>31);M[h>>2]=j;if(!j){break k}M[f+28>>2]=j;j=0;o:{if(hi(h,k?i-g|0:g-i|0,0,1,h+8|0,h+4|0)){M[f+24>>2]=1;j=M[h>>2]-M[f+28>>2]|0;break o}ab(M[h>>2]);M[f+28>>2]=0}M[f+32>>2]=j;ab(e)}if(M[f+28>>2]==(l|0)){break i}ab(l);break i}ab(i);ab(l);M[f+28>>2]=0;M[f+32>>2]=0;d=0;break i}ab(e)}d=7}M[c>>2]=d;c=M[f+28>>2];d=M[a+36>>2];M[b+24>>2]=M[a+32>>2];M[b+28>>2]=d;e=(c|0)!=0;break a}e=1}Na=h+16|0;return e^n}function So(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=Na-48|0;Na=f;e=M[a>>2];M[f+16>>2]=0;M[f+12>>2]=1;M[f+8>>2]=M[a+168>>2];a:{b:{c=M[a+68>>2];c=Ra[M[M[c>>2]+24>>2]](c,f+24|0)|0;if(c){break b}d=M[a+224>>2];c=Ro(M[a+68>>2],d,M[M[a>>2]+8>>2]+1|0);c:{if(c){break c}if(!N[d|0]){c=0;break c}c=Ra[M[e+32>>2]](e,d,0,f+12|0)|0}d:{e:{if(!M[f+12>>2]|c){break e}M[a+80>>2]=0;M[a+84>>2]=0;j=a+80|0;i=b;f:while(1){c=av(a,b,M[f+24>>2],M[f+28>>2],f+20|0,f+16|0);if(c){if((c|0)==101){break d}break b}c=M[a+156>>2];e=M[f+20>>2];if((e|0)==-1){e=M[f+24>>2];g=e-c|0;e=M[f+28>>2]-(c>>>0>e>>>0)|0;d=M[a+172>>2];h=M[a+168>>2]+8|0;d=h>>>0<8?d+1|0:d;e=_J(g,e,h,d);M[f+20>>2]=e}d=M[j>>2];g=M[j+4>>2];g:{if(b|e){break g}h=M[a+92>>2];k=M[a+88>>2];l=k+c|0;if((d|0)!=(l|0)|(g|0)!=((k>>>0>l>>>0?h+1|0:h)|0)){break g}e=M[f+24>>2];h=e-d|0;l=M[f+28>>2]-((d>>>0>e>>>0)+g|0)|0;e=M[a+172>>2];k=M[a+168>>2]+8|0;e=k>>>0<8?e+1|0:e;e=_J(h,l,k,e);M[f+20>>2]=e}h:{if((c|0)!=(d|0)|g){break h}d=M[f+16>>2];c=lq(a,d);if(c){break b}M[a+28>>2]=d;if(d>>>0<=P[a+160>>2]){break h}M[a+160>>2]=d}d=e+m|0;g=0;while(1){if((e|0)==(g|0)){m=d;continue f}if(i){Qg(a)}i:{c=cl(a,j,0,1,0);if(c){if((c|0)==101){break i}if((c|0)==522){break d}break e}g=g+1|0;m=m+1|0;i=0;continue}break}c=M[f+28>>2];M[j>>2]=M[f+24>>2];M[j+4>>2]=c;i=0;continue}}if(c){break b}}c=Xh(a,f+8|0,-1);K[a+19|0]=N[a+12|0];if(c){break a}l=M[a+224>>2]+4|0;c=Ro(M[a+68>>2],l,M[M[a>>2]+8>>2]+1|0);if(c){break a}if((N[a+17|0]-4&255)>>>0<=252){c=Pq(a,0);if(c){break a}}c=Uj(a,N[l|0]!=0,0);if(c){break a}if(!(!N[l|0]|!M[f+12>>2])){e=0;c=M[a+224>>2];K[c|0]=0;K[c+1|0]=0;K[c+2|0]=0;K[c+3|0]=0;c=7;h=M[a>>2];d=M[h+4>>2]<<1;g=zd(d,d>>31);j:{if(!g){break j}d=Ra[M[h+24>>2]](h,l,g,16385,0)|0;if(d){c=d;break j}j=M[h+4>>2];d=Ra[M[M[g>>2]+24>>2]](g,f+40|0)|0;if(d){c=d;break j}n=M[h+8>>2]+1|0;d=M[f+44>>2]+(n>>31)|0;i=n+M[f+40>>2]|0;d=i>>>0<n>>>0?d+1|0:d;i=i+6|0;d=i>>>0<6?d+1|0:d;d=lc(i,d);if(!d){break j}K[d|0]=0;K[d+1|0]=0;K[d+2|0]=0;K[d+3|0]=0;k:{i=d+4|0;e=M[f+40>>2];c=Ra[M[M[g>>2]+8>>2]](g,i,e,0,0)|0;l:{if(c){break l}k=g+j|0;p=(e+i|0)+2|0;K[i+M[f+40>>2]|0]=0;K[(i+M[f+40>>2]|0)+1|0]=0;e=i;while(1){c=e-i|0;o=c>>>0<P[f+40>>2];j=M[f+44>>2];c=c>>31;if(o&(j|0)>=(c|0)|(c|0)<(j|0)){c=Ra[M[h+32>>2]](h,e,0,f+36|0)|0;if(c){break l}m:{if(!M[f+36>>2]){break m}j=Ra[M[h+24>>2]](h,e,k,16385,0)|0;if(j){break k}j=Ro(k,p,n);o=M[k>>2];if(o){Ra[M[o+4>>2]](k)|0;M[k>>2]=0}if(j){break k}if(!N[p|0]){break m}if(!Wc(p,l)){break l}}e=(jb(e)+e|0)+1|0;continue}break}c=M[g>>2];if(c){Ra[M[c+4>>2]](g)|0;M[g>>2]=0}c=M[h+28>>2];if(!c){c=0;break l}c=Ra[c|0](h,l,0)|0}e=d;break j}e=d;c=j}ab(e);if(!g){break a}e=M[g>>2];if(e){Ra[M[e+4>>2]](g)|0;M[g>>2]=0}ab(g);break a}c=0;break a}K[a+19|0]=N[a+12|0]}if(!(!b|!m)){M[f+4>>2]=M[a+188>>2];M[f>>2]=m;Lc(539,6762,f)}dp(a);Na=f+48|0;return c}function Kl(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=a+b|0;c=M[a+4>>2];a:{b:{if(c&1){break b}if(!(c&2)){break a}c=M[a>>2];b=c+b|0;c:{d:{e:{a=a-c|0;if((a|0)!=M[18601]){d=M[a+12>>2];if(c>>>0<=255){e=M[a+8>>2];if((e|0)!=(d|0)){break e}j=74384,k=M[18596]&cK(-2,c>>>3|0),M[j>>2]=k;break b}g=M[a+24>>2];if((a|0)!=(d|0)){c=M[a+8>>2];M[c+12>>2]=d;M[d+8>>2]=c;break c}e=M[a+20>>2];if(e){c=a+20|0}else{e=M[a+16>>2];if(!e){break d}c=a+16|0}while(1){h=c;d=e;c=d+20|0;e=M[d+20>>2];if(e){continue}c=d+16|0;e=M[d+16>>2];if(e){continue}break}M[h>>2]=0;break c}c=M[f+4>>2];if((c&3)!=3){break b}M[18598]=b;M[f+4>>2]=c&-2;M[a+4>>2]=b|1;M[f>>2]=b;return}M[e+12>>2]=d;M[d+8>>2]=e;break b}d=0}if(!g){break b}c=M[a+28>>2];e=(c<<2)+74688|0;f:{if(M[e>>2]==(a|0)){M[e>>2]=d;if(d){break f}j=74388,k=M[18597]&cK(-2,c),M[j>>2]=k;break b}g:{if(M[g+16>>2]==(a|0)){M[g+16>>2]=d;break g}M[g+20>>2]=d}if(!d){break b}}M[d+24>>2]=g;c=M[a+16>>2];if(c){M[d+16>>2]=c;M[c+24>>2]=d}c=M[a+20>>2];if(!c){break b}M[d+20>>2]=c;M[c+24>>2]=d}h:{i:{j:{k:{c=M[f+4>>2];if(!(c&2)){if(M[18602]==(f|0)){M[18602]=a;b=M[18599]+b|0;M[18599]=b;M[a+4>>2]=b|1;if(M[18601]!=(a|0)){break a}M[18598]=0;M[18601]=0;return}i=M[18601];if((i|0)==(f|0)){M[18601]=a;b=M[18598]+b|0;M[18598]=b;M[a+4>>2]=b|1;M[a+b>>2]=b;return}b=(c&-8)+b|0;d=M[f+12>>2];if(c>>>0<=255){e=M[f+8>>2];if((e|0)==(d|0)){j=74384,k=M[18596]&cK(-2,c>>>3|0),M[j>>2]=k;break i}M[e+12>>2]=d;M[d+8>>2]=e;break i}g=M[f+24>>2];if((d|0)!=(f|0)){c=M[f+8>>2];M[c+12>>2]=d;M[d+8>>2]=c;break j}e=M[f+20>>2];if(e){c=f+20|0}else{e=M[f+16>>2];if(!e){break k}c=f+16|0}while(1){h=c;d=e;c=d+20|0;e=M[d+20>>2];if(e){continue}c=d+16|0;e=M[d+16>>2];if(e){continue}break}M[h>>2]=0;break j}M[f+4>>2]=c&-2;M[a+4>>2]=b|1;M[a+b>>2]=b;break h}d=0}if(!g){break i}c=M[f+28>>2];e=(c<<2)+74688|0;l:{if(M[e>>2]==(f|0)){M[e>>2]=d;if(d){break l}j=74388,k=M[18597]&cK(-2,c),M[j>>2]=k;break i}m:{if(M[g+16>>2]==(f|0)){M[g+16>>2]=d;break m}M[g+20>>2]=d}if(!d){break i}}M[d+24>>2]=g;c=M[f+16>>2];if(c){M[d+16>>2]=c;M[c+24>>2]=d}c=M[f+20>>2];if(!c){break i}M[d+20>>2]=c;M[c+24>>2]=d}M[a+4>>2]=b|1;M[a+b>>2]=b;if((a|0)!=(i|0)){break h}M[18598]=b;return}if(b>>>0<=255){c=(b&-8)+74424|0;d=M[18596];b=1<<(b>>>3);n:{if(!(d&b)){M[18596]=b|d;b=c;break n}b=M[c+8>>2]}M[c+8>>2]=a;M[b+12>>2]=a;M[a+12>>2]=c;M[a+8>>2]=b;return}d=31;if(b>>>0<=16777215){c=V(b>>>8|0);d=((b>>>38-c&1)-(c<<1)|0)+62|0}M[a+28>>2]=d;M[a+16>>2]=0;M[a+20>>2]=0;c=(d<<2)+74688|0;o:{e=M[18597];h=1<<d;p:{if(!(e&h)){M[18597]=e|h;M[c>>2]=a;M[a+24>>2]=c;break p}d=b<<((d|0)!=31?25-(d>>>1|0)|0:0);c=M[c>>2];while(1){e=c;if((M[c+4>>2]&-8)==(b|0)){break o}c=d>>>29|0;d=d<<1;h=e+(c&4)|0;c=M[h+16>>2];if(c){continue}break}M[h+16>>2]=a;M[a+24>>2]=e}M[a+12>>2]=a;M[a+8>>2]=a;return}b=M[e+8>>2];M[b+12>>2]=a;M[e+8>>2]=a;M[a+24>>2]=0;M[a+12>>2]=e;M[a+8>>2]=b}}function Rm(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;p=Na-32|0;Na=p;m=Cb(a);o=M[a+44>>2];M[a+44>>2]=o+1;a:{if(!d){d=0;break a}if(!(N[b+5|0]&16)){break a}g=M[M[b+20>>2]+28>>2];r=M[g>>2];k=(r|0)>0?r:0;j=g+8|0;while(1){b:{q=d;if((h|0)!=(k|0)){if(!hf(M[j+(h<<4)>>2])){break b}d=h}else{d=k}d=(d|0)!=(r|0)?q:0;break a}h=h+1|0;continue}}c:{d:{if(M[a+40>>2]|(M[b+4>>2]&4160)!=4096){break d}k=M[b+20>>2];if(M[k+52>>2]|N[k+4|0]&9|(M[k+60>>2]|M[k+36>>2])){break d}g=M[k+32>>2];if(M[g>>2]!=1|N[g+21|0]&4){break d}j=M[g+16>>2];if(N[j+43|0]==1){break d}g=M[k+28>>2];n=M[g>>2];v=(n|0)>0?n:0;s=g+8|0;while(1){if((i|0)!=(v|0)){g=i<<4;i=i+1|0;if(N[M[g+s>>2]]==168){continue}break d}break}if(!k){break d}t=Mb(M[a>>2],M[j+60>>2]);ud(a,t);Dd(a,t,M[j+20>>2],0,M[j>>2]);if(!((n|0)!=1|L[M[s>>2]+32>>1]>=0)){c=Ub(m,15);Pd(a,o,t,j,102);M[p>>2]=M[j>>2];fc(a,0,19533,p);a=M[m+108>>2];M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(c,20)|0)+8>>2]=a;i=1;break c}h=0;i=1;while(1){if(!(!(i&1)|(h|0)>=(n|0))){k=Ag(M[b+12>>2],h);i=68;g=L[M[(h<<4)+s>>2]+32>>1];if(!((g|0)<0|(g|0)>=L[j+34>>1])){i=N[(M[j+4>>2]+S(g,12)|0)+5|0]}g=i<<24>>24;i=(g|0)>66|(mh(k,g)-65&255)>>>0<2;h=h+1|0;continue}break}if(!(i&1)){break d}h=j+8|0;g=n&31;if((n&63)>>>0>=32){k=-1<<g;i=0}else{i=-1<<g;k=i|(1<<g)-1&-1>>>32-g}x=i;r=c>>>0<4;i=0;while(1){l=M[h>>2];if(!(!l|i)){i=0;g=O[l+52>>1];e:{if(M[l+36>>2]|((g|0)<(n|0)|g>>>0>62)){break e}f:{if(r){break f}if(O[l+50>>1]>(n|0)){break e}if(g>>>0<=n>>>0){break f}if(!N[l+54|0]){break e}}q=0;u=0;while(1){g:{if((i|0)==(v|0)){break g}h=0;j=Ag(M[b+12>>2],i);g=M[(i<<4)+s>>2];j=fg(a,j,g);while(1){if((h|0)==(n|0)){break g}h:{if(O[M[l+4>>2]+(h<<1)>>1]==O[g+32>>1]){if(!j){break h}if(!hb(M[j>>2],M[M[l+32>>2]+(h<<2)>>2])){break h}}h=h+1|0;continue}break}j=h&31;if((h&63)>>>0>=32){g=1<<j;j=0}else{w=1<<j;g=w-1&1>>>32-j;j=w}if(q&j|g&u){break g}if(e){M[(i<<2)+e>>2]=h}q=j|q;u=g|u;i=i+1|0;continue}break}i=0;if(((q^x)&(k^u))!=-1){break e}j=Ub(m,15);M[p+16>>2]=M[l>>2];fc(a,0,19502,p+16|0);bb(m,102,o,M[l+44>>2],t);Ld(a,l);h=N[M[l+28>>2]];i:{if(!d){break i}g=M[a+48>>2]+1|0;M[a+48>>2]=g;M[d>>2]=g;if((n|0)!=1){break i}fB(m,o,g)}g=M[m+108>>2];i=h+3|0;M[(N[M[m>>2]+87|0]?74356:M[m+104>>2]+S(j,20)|0)+8>>2]=g}h=l+20|0;continue}break}if(i){break c}}j:{if(!(c&1)|N[b+5|0]&16){break j}k=M[b+12>>2];M[b+12>>2]=0;g=Nd(a,b);M[b+12>>2]=k;if(M[M[b+20>>2]>>2]>2?g:0){break j}o=-1;M[a+44>>2]=M[a+44>>2]-1;i=5;break c}g=O[a+160>>1];k:{if(c>>>0>=4){h=0;L[a+160>>1]=0;break k}if(!d){h=0;break k}h=M[a+48>>2]+1|0;M[a+48>>2]=h;M[d>>2]=h}eB(a,b,o);if(h){fB(m,o,h)}L[a+160>>1]=g;i=2}l:{if(!e|i-5>>>0>4294967293){break l}h=0;a=Zc(M[b+12>>2]);a=(a|0)>0?a:0;while(1){if((a|0)==(h|0)){break l}M[(h<<2)+e>>2]=h;h=h+1|0;continue}}M[f>>2]=o;Na=p+32|0;return i}function Ol(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=Na-48|0;Na=e;g=M[a>>2];o=M[b+20>>2];M[d>>2]=0;j=M[o+68>>2];a:{if((j|0)!=(c|0)&(j|0)<M[g+24>>2]){break a}h=M[b+28>>2];i=h;j=M[b+24>>2];M[e+16>>2]=j;M[e+20>>2]=h;h=M[o+28>>2];M[e+28>>2]=h;b:{if(!N[b+32|0]&((j|0)==M[a+32>>2]&(i|0)==M[a+36>>2])){break b}M[e+12>>2]=0;n=N[g+239|0];h=0;j=b;while(1){b=M[b+8>>2];if(b){h=N[b+32|0]?1:h;g=M[b>>2];j=(g|0)==1?b:j;f=(g|0)==4?1:f;continue}break}if(!f){f=0;break a}b=j;while(1){if(N[b+34|0]){b=M[b+8>>2];continue}break}c:{if(!M[o+40>>2]){break c}g=N[b+32|0];Oj(a,b,e+12|0);d:{while(1){f=M[e+12>>2];if(f){break a}f=N[b+32|0];if(f){break d}pd(a,b,e+12|0);if(M[b+24>>2]!=M[e+16>>2]|M[b+28>>2]!=M[e+20>>2]|g){continue}break}f=M[e+12>>2];if(f){break a}f=N[b+32|0]}if((g|0)==(f&255)){break c}f=267;break a}e:{if(!(h&255)){break e}while(1){if(N[b+32|0]){break e}pd(a,b,e+12|0);f=M[e+12>>2];if(!f){continue}break}break a}h=1;while(1){f:{if(j){i=M[(M[j>>2]==1?M[j+16>>2]:j)+20>>2];b=M[i+48>>2];M[e+28>>2]=b;f=M[i+60>>2];M[e+16>>2]=M[i+56>>2];M[e+20>>2]=f;f=M[i+4>>2];g:{if(N[a+52|0]==(n|0)){if(!f){f=0;break g}l=f+M[i>>2]>>>0<=b>>>0;f=1;break g}g=1;h:{if(!f){break h}g=0;if(!b){break h}g=P[i>>2]>=b>>>0}K[e+44|0]=g;while(1){i:{if(b){l=N[e+44|0];f=M[e+16>>2];g=M[a+32>>2];m=M[e+20>>2];k=M[a+36>>2];f=(f>>>0>g>>>0&(m|0)>=(k|0)|(k|0)<(m|0))-(f>>>0<g>>>0&(k|0)>=(m|0)|(k|0)>(m|0))|0;if(l|((n?0-f|0:f)|0)<=0){break f}break i}l=N[e+44|0];if(!l){break i}b=0;break f}_l(n,M[i>>2],M[i+4>>2],e+28|0,e+16|0,e+32|0,e+44|0);b=M[e+28>>2];continue}}while(1){j:{if(!f){l=1;break j}k:{l:{m:{n:{if(b){f=M[e+16>>2];g=M[a+32>>2];m=M[e+20>>2];k=M[a+36>>2];g=(f>>>0>g>>>0&(m|0)>=(k|0)|(k|0)<(m|0))-(f>>>0<g>>>0&(k|0)>=(m|0)|(k|0)>(m|0))|0;if(((n?0-g|0:g)|0)>=0|l){break l}g=M[i+4>>2];k=M[i>>2];M[e+44>>2]=b;xe(0,e+44|0);g=g+k|0;b=M[e+44>>2];while(1){if(b>>>0>=g>>>0){break k}if(N[b|0]){break n}b=b+1|0;continue}}if(l){break l}b=M[i>>2];b=Ic(b,e+16|0)+b|0;break m}k=Ic(b,e+32|0);g=M[e+32>>2];p=n?0-g|0:g;l=p+f|0;f=M[e+36>>2];f=(n?0-(f+((g|0)!=0)|0)|0:f)+m|0;M[e+16>>2]=l;M[e+20>>2]=l>>>0<p>>>0?f+1|0:f;b=b+k|0}l=0;break j}M[e+28>>2]=b;break f}f=0;continue}f=1;continue}}h=h?M[o+48>>2]:0;M[e+28>>2]=h;break b}M[i+48>>2]=b;f=M[e+20>>2];b=M[e+16>>2];M[i+56>>2]=b;M[i+60>>2]=f;h=!l&(M[a+32>>2]==(b|0)&M[a+36>>2]==(f|0))?h:0;j=M[j+12>>2];continue}}f=0;if(!h){break a}o:{if(N[h|0]==1){a=h+1|0;M[e+28>>2]=a;b=K[h+1|0];p:{if((b|0)<0){b=yc(a,e+32|0);break p}M[e+32>>2]=b;b=1}h=b+a|0;M[e+28>>2]=h;break o}M[e+32>>2]=0}while(1){a=M[e+32>>2];if((a|0)<(c|0)){Ef(0,e+28|0);a=M[e+28>>2];if(!N[a|0]){break a}b=a+1|0;a=K[a+1|0];q:{if((a|0)<0){a=yc(b,e+32|0);break q}M[e+32>>2]=a;a=1}h=a+b|0;M[e+28>>2]=h;continue}break}M[d>>2]=(a|0)==(c|0)?N[h|0]?h:0:0}Na=e+48|0;return f}function eB(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=Na-48|0;Na=h;g=M[a+8>>2];d=M[b+4>>2];e=0;a:{b:{if(d&64){break b}e=0;if(M[a+56>>2]){break b}c:{if(!(d&4096)|N[M[b+20>>2]+4|0]&2){break c}e=Ob(M[a>>2],24,0);if(!e){break c}M[e>>2]=M[M[b+20>>2]+16>>2];q=e,r=Ar(a,b),M[q+8>>2]=r;j=e}d:{f=M[b+4>>2];if(!(f&33554432)){if(!j){break d}k=M[j>>2];if(!(N[a+28|0]>>>(k&7)&1)){break d}d=74356;i=74356;e=M[a+8>>2];if(!N[M[e>>2]+87|0]){i=M[e+104>>2];d=i+20|0;i=(i+S(M[e+108>>2],20)|0)-20|0}while(1){if(d>>>0>=i>>>0){break d}e:{f:{if(N[d+1|0]!=239){break f}e=M[d+16>>2];if(!N[e+4|0]|(k|0)!=M[e>>2]){break f}if(!Wc(M[j+8>>2],M[e+8>>2])){break e}}d=d+20|0;continue}break}M[b+44>>2]=M[e+16>>2];M[b+48>>2]=M[e+20>>2];e=M[e+12>>2];M[b+4>>2]=f|33554432;M[b+28>>2]=e}e=Ub(g,15);if(N[b+5|0]&16){M[h+16>>2]=M[M[b+20>>2]+16>>2];fc(a,0,17448,h+16|0)}$a(g,10,M[b+48>>2],M[b+44>>2]);$a(g,114,c,M[b+28>>2]);c=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(e,20)|0)+8>>2]=c;if(!j){break a}eb(M[a>>2],M[j+8>>2]);ib(M[a>>2],j);break a}M[b+4>>2]=f|33554432;e=M[a+48>>2]+1|0;M[a+48>>2]=e;M[b+48>>2]=e;q=b,r=$a(g,74,0,e)+1|0,M[q+44>>2]=r;if(j){K[j+4|0]=0;M[j+16>>2]=M[b+44>>2];e=M[b+48>>2];M[j+12>>2]=c;M[j+20>>2]=e;K[a+28|0]=1<<(M[j>>2]&7);Vd(g,-1,j,-17)}e=Ub(g,15)}m=M[b+12>>2];i=Zc(m);M[b+28>>2]=c;o=$a(g,117,c,i);k=Of(M[a>>2],i,1);f=M[b+20>>2];g:{h:{i:{j:{if(N[b+5|0]&16){n=M[f+28>>2];M[h+4>>2]=M[f+16>>2];M[h>>2]=e?30808:30643;fc(a,1,17429,h);if((i|0)!=M[n>>2]){break h}M[h+36>>2]=0;M[h+28>>2]=0;M[h+32>>2]=0;M[h+24>>2]=c;K[h+20|0]=11;q=h,r=Ar(a,b),M[q+40>>2]=r;M[f+8>>2]=0;d=M[a>>2];if(!(!e|N[d+82|0]&8)){d=M[a+48>>2]+1|0;M[a+48>>2]=d;l=$a(g,77,1e4,d);M[h+28>>2]=d;d=M[a>>2]}f=le(d,f,0);d=M[a>>2];if(!N[d+87|0]){p=!Rc(a,f,h+20|0);d=M[a>>2]}pc(d,f);eb(M[a>>2],M[h+40>>2]);if(!l){break i}f=M[h+28>>2];k:{if(!N[M[g>>2]+87|0]){d=M[g+104>>2]+S(e,20)|0;M[d+12>>2]=f;if(!f){break k}break j}M[18592]=f;d=74356;if(f){break j}}be(g,l);break i}if(!f){break h}d=rc(m);K[h+20|0]=d;i=65;l:{if((d|0)>=65){i=67;if((d|0)!=69){break l}}K[h+20|0]=i}if(k){q=k,r=Fd(a,M[b+12>>2]),M[q+20>>2]=r}l=f+8|0;d=Gb(a);m=Gb(a);i=M[f>>2];while(1){if((i|0)>0){f=M[l>>2];m:{if(e){if(Nd(a,f)){break m}be(g,e-1|0);be(g,e);M[b+4>>2]=M[b+4>>2]&-33554433}e=0}kc(a,f,d);nb(g,97,d,1,m,h+20|0,1);lb(g,138,c,m,d,1);l=l+16|0;i=i-1|0;continue}break}zb(a,d);zb(a,m);break h}M[d+12>>2]=f}if(!p){break g}d=0;i=(i|0)>0?i:0;f=k+20|0;l=n+8|0;while(1){if((d|0)==(i|0)){break h}q=f+(d<<2)|0,r=fg(a,Ag(m,d),M[l+(d<<4)>>2]),M[q>>2]=r;d=d+1|0;continue}}if(j){K[j+4|0]=1}if(k){Vd(g,o,k,-8)}if(!e){break a}fb(g,136,c);j=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(e,20)|0)+8>>2]=j;bb(g,67,M[b+48>>2],M[b+44>>2],1);M[a+32>>2]=0;K[a+19|0]=0;break a}bj(k)}Na=h+48|0}function Pf(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;r=Na-16|0;Na=r;q=e?N[e+1|0]:q;m=M[f+4>>2];o=N[f|0];i=M[a+8>>2];l=d?M[d>>2]?d:0:l;if(!(q|l)){Ei(i,M[b+12>>2],g)}k=M[M[b+28>>2]>>2];j=M[f+12>>2];a:{if(!j){if(l){p=M[M[l>>2]>>2]+((N[l+32|0]^-1)&1)|0;d=p+M[a+48>>2]|0}else{d=M[a+48>>2]}j=d+1|0;M[f+12>>2]=j;M[a+48>>2]=d+k;break a}d=M[a+48>>2];if((d|0)>=(j+k|0)){break a}M[a+48>>2]=d+k}M[f+16>>2]=k;d=0;b:{c:{if((c|0)>=0){n=(k|0)>0?k:0;while(1){if((d|0)==(n|0)){break c}bb(i,94,c,d,d+j|0);d=d+1|0;continue}}n=1;d:{if(o-9>>>0<2){break d}if((o|0)==3){break c}if((o|0)==13){break d}n=0}e:{if(!(!l|q|(o&253)==12)){d=M[l+4>>2];while(1){c=M[l>>2];if(M[c>>2]>(d|0)){c=O[(c+(d<<4)|0)+20>>1];if(c){d=d+1|0;L[(M[b+28>>2]+(c<<4)|0)+4>>1]=d-M[l+4>>2]}else{d=d+1|0}continue}break}c=M[b+28>>2];d=M[c>>2];t=(d|0)>0?d:0;u=c+20|0;c=j;d=0;while(1){if((d|0)!=(t|0)){s=O[(d<<4)+u>>1];c=s?0:c;d=d+1|0;k=k-((s|0)!=0)|0;continue}break}n=n|12;break e}c=j}K[r+12|0]=n;M[r+8>>2]=j;if(!(!M[b+8>>2]|!(n&8)|(p|0)<=0)){M[l+36>>2]=r+8;c=0;break b}vA(a,b,r+8|0);break b}c=j}f:{if(!q){break f}d=N[e+1|0];n=uA(a,d,M[e+4>>2],g,M[b+28>>2],j);rn(a,d,n,M[e+8>>2]);if(l){break f}Ei(i,M[b+12>>2],g)}g:{h:{i:{j:{k:{switch(o-1|0){case 0:c=Gb(a);bb(i,97,j,k,c);lb(i,138,m,c,j,k);zb(a,c);break j;case 1:bb(i,140,m,j,k);break j;case 4:case 7:case 11:case 13:e=p+1|0;d=vc(a,e);f=d+p|0;bb(i,97,j,k,f);if((o|0)==5){g=m+1|0;lb(i,29,g,M[i+108>>2]+4|0,d,0);lb(i,138,g,d,j,k)}l:{if(l){ir(a,l,b,f,c,1,p);break l}c=Gb(a);$a(i,127,m,c);bb(i,128,m,d,c);f=M[i+108>>2];if((f|0)>0){L[(M[i+104>>2]+S(f,20)|0)-18>>1]=8}zb(a,c)}ad(a,d,e);break j;case 14:if(l){break h}c=M[f+8>>2];a=Gb(a);$a(i,51,j,h);d=c>>>31|0;bb(i,97,d+j|0,k-d|0,a);if((c|0)<0){bb(i,128,m,a,j);break i}lb(i,138,m,a,j,c);break i;case 10:if(l){ir(a,l,b,j,c,k,p);M[f+8>>2]=0;break g}c=Gb(a);nb(i,97,j,k,c,M[f+20>>2],k);lb(i,138,m,c,j,k);d=M[f+8>>2];if(d){lb(i,183,d,0,j,k);fc(a,0,19609,0)}zb(a,c);break i;case 2:$a(i,71,1,m);break j;case 9:if(l){break h}break i;case 8:case 12:if(l){break h}if((o|0)==13){fb(i,12,M[f+4>>2]);break i}$a(i,84,j,k);break i;case 5:case 6:break k;default:break j}}n=M[f+24>>2];c=M[n>>2];f=Gb(a);g=c+2|0;e=vc(a,g);q=e+c|0;d=q+1|0;p=0;o=(o|0)!=6;if(!o){p=lb(i,29,m+1|0,0,j,k)}bb(i,97,j,k,d);m:{if(o){break m}$a(i,138,m+1|0,d);d=M[i+108>>2];if((d|0)<=0){break m}L[(M[i+104>>2]+S(d,20)|0)-18>>1]=16}d=0;c=(c|0)>0?c:0;j=j-1|0;k=n+20|0;while(1){if((c|0)!=(d|0)){$a(i,81,j+O[k+(d<<4)>>1]|0,d+e|0);d=d+1|0;continue}break}$a(i,126,m,q);bb(i,97,e,g,f);lb(i,138,m,f,e,g);if(p){d=M[i+108>>2];M[(N[M[i>>2]+87|0]?74356:M[i+104>>2]+S(p,20)|0)+8>>2]=d}zb(a,f);ad(a,e,g)}if(l){break g}}a=M[b+8>>2];if(!a){break g}$a(i,61,a,h);break g}ir(a,l,b,j,c,k,p)}Na=r+16|0}function Yd(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(!(N[a+16|0]&2)){K[a+18|0]=b;return 0}if(N[a+18|0]!=(b|0)){f=a;k=b;a:{b:{if(!((b|0)==1|N[a+18|0]==1)){if(lg(a)){break b}b=M[a+8>>2];a=b+(M[a+12>>2]&-2)|0;while(1){if(a>>>0>b>>>0){h=N[b+1|0];K[b+1|0]=N[b|0];K[b|0]=h;b=b+2|0;continue}break}K[f+18|0]=k;a=0;break a}i=M[f+12>>2];c:{if((k|0)==1){i=i&-2;M[f+12>>2]=i;h=i<<1|1;b=i>>31<<1|i>>>31;break c}a=i>>31<<1|i>>>31;h=(i<<1)+2|0;b=h>>>0<2?a+1|0:a}a=M[f+8>>2];h=md(M[f+20>>2],h,b);if(!h){break b}j=a+i|0;b=h;d:{e:{f:{g:{h:{switch(N[f+18|0]-1|0){case 0:if((k|0)!=2){break f}c=h;g=a;i:while(1){if(g>>>0>=j>>>0){break e}b=g+1|0;j:{e=N[g|0];if(e>>>0<192){g=b;break j}g=a+i|0;d=N[e+33440|0];while(1){k:{if(b>>>0<j>>>0){e=N[b|0];if((e&192)==128){break k}g=b}e=65533;if((d&-2)==65534|d>>>0<128|(d&-2048)==55296){break j}if(d>>>0<=65535){e=d;break j}K[c+2|0]=d;K[c+3|0]=d>>>8&3|220;b=d-65536|0;K[c+1|0]=b>>>18&3|216;K[c|0]=b>>>10&192|d>>>10&63;c=c+4|0;continue i}d=e&63|d<<6;b=b+1|0;continue}}K[c|0]=e;K[c+1|0]=e>>>8;c=c+2|0;continue};default:while(1){if(a>>>0>=j>>>0){break g}c=N[a+1|0];e=N[a|0];d=c|e<<8;g=a+2|0;if(!((e&248)!=216|g>>>0>=j>>>0)){g=N[a+2|0];e=N[a+3|0];K[b+3|0]=e&63|128;d=(d<<10&983040)+65536|0;K[b|0]=d>>>18|240;c=c<<10;K[b+1|0]=(d|c&61440)>>>12&63|128;K[b+2|0]=(c|(e|g<<8&768))>>>6&63|128;b=b+4|0;a=a+4|0;continue}if(d>>>0<=127){K[b|0]=c;b=b+1|0}else{if(e>>>0<=7){K[b+1|0]=c&63|128;K[b|0]=d>>>6|192;b=b+2|0}else{K[b+2|0]=c&63|128;K[b|0]=e>>>4|224;K[b+1|0]=d>>>6&63|128;b=b+3|0}}a=g;continue};case 1:break h}}while(1){if(a>>>0>=j>>>0){break g}c=N[a|0];e=N[a+1|0];d=c|e<<8;g=a+2|0;if(!((e&248)!=216|g>>>0>=j>>>0)){g=N[a+3|0];e=N[a+2|0];K[b+3|0]=e&63|128;d=(d<<10&983040)+65536|0;K[b|0]=d>>>18|240;c=c<<10;K[b+1|0]=(d|c&61440)>>>12&63|128;K[b+2|0]=(c|(e|g<<8&768))>>>6&63|128;b=b+4|0;a=a+4|0;continue}if(d>>>0<=127){K[b|0]=c;b=b+1|0}else{if(e>>>0<=7){K[b+1|0]=c&63|128;K[b|0]=d>>>6|192;b=b+2|0}else{K[b+2|0]=c&63|128;K[b|0]=e>>>4|224;K[b+1|0]=d>>>6&63|128;b=b+3|0}}a=g;continue}}M[f+12>>2]=b-h;break d}c=h;l:while(1){if(a>>>0>=j>>>0){break e}b=a+1|0;m:{e=N[a|0];if(e>>>0<192){a=b;break m}d=N[e+33440|0];while(1){n:{if(b>>>0>=j>>>0){a=j}else{a=N[b|0];if((a&192)==128){break n}a=b}e=65533;if((d&-2)==65534|d>>>0<128|(d&-2048)==55296){break m}if(d>>>0<=65535){e=d;break m}K[c+3|0]=d;K[c+2|0]=d>>>8&3|220;b=d-65536|0;K[c+1|0]=b>>>10&192|d>>>10&63;K[c|0]=b>>>18&3|216;c=c+4|0;continue l}d=a&63|d<<6;b=b+1|0;continue}}b=e<<8|(e&65280)>>>8;K[c|0]=b;K[c+1|0]=b>>>8;c=c+2|0;continue}}M[f+12>>2]=c-h;K[c|0]=0;b=c+1|0}K[b|0]=0;a=O[f+16>>1];gd(f);K[f+18|0]=k;M[f+32>>2]=h;M[f+8>>2]=h;L[f+16>>1]=a&2109|514;l=f,m=uf(M[f+20>>2],h),M[l+24>>2]=m;a=0;break a}a=7}}else{a=0}return a}function Pe(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=Na-128|0;Na=g;h=-3;a:{b:{c:{f=N[c|0];d:{if((f|0)!=91){if((f|0)!=46){if(f){break a}e:{f:{if(!N[a+39|0]){break f}if(!lm(a,M[a+44>>2])){break f}c=jc(a,b,g+124|0)+M[g+124>>2]|0;h=b;g:{switch(N[a+39|0]-1|0){case 0:h=d?d:b;$e(a,h,c+(d?b-d|0:0)|0,0,0);break e;case 2:break e;default:break g}}$e(a,b,c,M[a+52>>2],M[a+44>>2])}h=b}M[a+48>>2]=d;break a}f=c+1|0;l=M[a>>2];j=N[l+b|0];h:{i:{e=N[c+1|0];if((e|0)!=34){d=0;while(1){c=e&255;if(!c|(c|0)==46|(c|0)==91){break i}d=d+1|0;e=N[f+d|0];continue}}c=c+2|0;e=1;while(1){d=N[e+f|0];j:{if((d|0)!=92){if(!d){break a}if((d|0)!=34){break j}i=e+1|0;d=e-1|0;o=!dx(c,92,d);break h}d=e+1|0;e=N[d+f|0]?d:e}e=e+1|0;continue}}o=1;c=f;i=d;if(!d){break a}}h=-2;if((j&15)!=12){break a}e=jc(a,b,g+124|0)+b|0;m=e+M[g+124>>2]|0;while(1){if(e>>>0<m>>>0){h=-1;k=N[e+l|0]&15;if(k-11>>>0<4294967292){break a}p=g+124|0;j=jc(a,e,p);if(!j){break a}n=M[g+124>>2];q=e+j|0;j=n+q|0;if(j>>>0>=m>>>0){break a}n=oz(c,d,o,l+q|0,n,(k|0)==7|(k|0)==10);k=N[j+l|0]&15;if(n){if(k>>>0>12){break a}c=jc(a,j,p);if(!c|M[g+124>>2]+(c+j|0)>>>0>m>>>0){break a}h=Pe(a,j,f+i|0,e);if(M[a+40>>2]){break d}break a}if(k>>>0>12){break a}e=jc(a,j,g+124|0);if(!e){break a}e=M[g+124>>2]+(e+j|0)|0;continue}break}if(e>>>0>m>>>0){break b}h=-2;if(N[a+39|0]<3){break a}h=g+12|0;D(h,0,56);M[g+28>>2]=M[a+16>>2];yd(h,o?10:9,d,0);K[a+35|0]=N[a+35|0]|N[g+47|0];h=nz(a,g+68|0,f+i|0);k:{if(h>>>0>4294967292){break k}i=M[g+16>>2];f=i+d|0;if(!lm(a,f+M[g+72>>2]|0)){break k}$e(a,e,0,0,f+M[g+72>>2]|0);if(N[a+35|0]){break k}if(i){G(M[a>>2]+e|0,M[g+12>>2],i)}i=e+i|0;if(d){G(i+M[a>>2]|0,c,d)}c=M[g+72>>2];if(c){G((i+M[a>>2]|0)+d|0,M[g+68>>2],c)}if(!M[a+40>>2]){break k}Hq(a,b)}Gf(g+68|0);Gf(g+12|0);break a}if((N[M[a>>2]+b|0]&15)!=11){break c}d=0;j=jc(a,b,g+124|0);e=1;while(1){f=N[c+e|0];if(f-58>>>0>=4294967286){e=e+1|0;d=((f<<24>>24)+S(d,10)|0)-48|0;continue}break}if(!((f|0)==93&e>>>0>=2)){if(N[c+1|0]!=35){break a}d=uz(a,b);e=2;f=N[c+2|0];if((f|0)==45){f=N[c+3|0];if(f-58>>>0<4294967286){break a}e=3;while(1){i=((f<<24>>24)+S(i,10)|0)-48|0;e=e+1|0;f=N[e+c|0];if(f-58>>>0>4294967285){continue}break}if(d>>>0<i>>>0){break c}d=d-i|0}if((f|0)!=93){break a}}f=b+j|0;h=f+M[g+124>>2]|0;while(1){if(f>>>0<h>>>0){if(!d){h=Pe(a,f,(c+e|0)+1|0,0);if(M[a+40>>2]){break d}break a}i=jc(a,f,g+124|0);if(!i){break b}d=d-1|0;f=M[g+124>>2]+(f+i|0)|0;continue}break}if(f>>>0>h>>>0){break b}if(d){break c}h=-2;if(N[a+39|0]<3){break a}h=nz(a,g+68|0,(c+e|0)+1|0);l:{if(h>>>0>4294967292){break l}if(!lm(a,M[g+72>>2])){break l}$e(a,f,0,M[g+68>>2],M[g+72>>2])}Gf(g+68|0);if(!M[a+40>>2]){break a}}Hq(a,b);break a}h=-2;break a}h=-1}Na=g+128|0;return h}function BC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=Na-1088|0;Na=g;n=d&1048320;l=d&4;j=0;a:{if(!l){break a}j=1;if((n|0)==2048){break a}j=1;if((n|0)==16384){break a}j=1;if((n|0)==524288){break a}j=0}if(M[18553]!=42){M[18553]=42;pe(0,0)}D(c,0,52);b:{c:{d:{e:{if((n|0)==256){f=uu(b,d);if(f){h=M[f>>2];break e}h=-1;f=Bb(12,0);if(f){break e}f=7;break b}h=-1;if(b){break d}i=g+16|0;f=mu(M[a+8>>2],i);if(f){break b}break c}M[c+28>>2]=f}i=b}k=d&1;p=d&8;f:{g:{if((h|0)>=0){f=d;break g}M[g+1072>>2]=0;M[g+12>>2]=0;M[g+8>>2]=0;m=d&526336;h:{i:{if(m){h=jb(i);while(1){f=0;if((h|0)<2){break i}j:{h=h-1|0;switch(N[i+h|0]-45|0){case 1:break i;case 0:break j;default:continue}}break}if(h){G(g+544|0,i,h)}f=g+544|0;K[f+h|0]=0;f=gu(f,g+1072|0,g+12|0,g+8|0);break i}o=384;if(p){break h}o=0;if(!(d&64)){break h}f=bu(i,12717);if(!f){break h}f=gu(f,g+1072|0,g+12|0,g+8|0)}if(f){break b}o=M[g+1072>>2]}f=d&2;l=f|(d<<3&128|l<<4)|131072;h=Ah(i,l,o);k:{if((h|0)>=0){f=d;break k}l:{m:{n:{if(!j|M[18595]!=2){break n}m=0;if(!(Ra[M[16951]](i,0)|0)){break n}k=1544;break m}m=1;k=0;if(!f|M[18595]==31){break m}f=d&-8|1;k=uu(i,f);o:{if(k){h=M[k>>2];ab(k);break o}h=Ah(i,l&131200,o)}k=0;if((h|0)>=0){break l}}f=(q=Qd(ne(44994),11387,i,44994),r=k,s=m,s?q:r);break f}m=d&526336;k=1}if(!o|!m){break g}l=M[g+8>>2];d=M[g+12>>2];if(Ra[M[17008]]()|0){break g}Ra[M[17005]](h,d,l)|0}if(e){M[e>>2]=f}d=M[c+28>>2];if(d){M[d>>2]=h;M[d+4>>2]=f&3}if(p){Ra[M[16993]](i)|0}M[c+32>>2]=b;M[c+4>>2]=a;M[c+12>>2]=h;d=p<<2;d=k?d|2:d;d=(n|0)==256?d:d|128;e=j?d|8:d;d=e|f&64;L[c+18>>1]=d;if(Rk(d<<25>>31&b,1675,1)){L[c+18>>1]=O[c+18>>1]|16}if(!Wc(M[a+16>>2],11845)){L[c+18>>1]=O[c+18>>1]|1}d=33260;p:{q:{r:{if(e&128){break r}d=Ra[M[M[a+20>>2]>>2]](b,c)|0;if((d|0)==33184){if(Ra[M[16960]](M[c+12>>2],g+544|0)|0){a=M[18595];M[c+20>>2]=a;f=(a|0)==61?22:10;break p}M[g+1072>>2]=0;M[g+1076>>2]=0;a=M[g+636>>2];M[g+1080>>2]=M[g+632>>2];M[g+1084>>2]=a;M[g+1072>>2]=M[g+544>>2];d=74208;s:{t:{while(1){d=M[d>>2];if(d){if(!Qb(g+1072|0,d,16)){break t}d=d+44|0;continue}break}d=Bb(56,0);if(!d){f=7;break p}D(d+16|0,0,40);b=g+1080|0;a=M[b+4>>2];M[d+8>>2]=M[b>>2];M[d+12>>2]=a;a=M[g+1076>>2];M[d>>2]=M[g+1072>>2];M[d+4>>2]=a;if(N[67468]){M[d+16>>2]=8}M[d+36>>2]=1;a=M[18552];M[d+48>>2]=0;M[d+44>>2]=a;if(a){M[a+48>>2]=d}M[18552]=d;break s}M[d+36>>2]=M[d+36>>2]+1}M[c+8>>2]=d;d=33184;break r}if((d|0)!=33336){break r}d=yb(b)+6|0;a=Bb(d,d>>31);if(!a){break q}M[g>>2]=b;q=c,r=vd(d,a,12031,g),M[q+24>>2]=r;d=33336}M[c>>2]=d;f=0;M[c+20>>2]=0;Mt(c);break b}M[c+20>>2]=0;M[c+24>>2]=0;Wf(c,h,44546);f=7;break f}Wf(c,h,44461);M[c+20>>2]=0}ab(M[c+28>>2])}Na=g+1088|0;return f|0}function Lo(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Na-32|0;Na=h;l=M[b+4>>2];a:{if(l>>>0<=2){g=db(74696);break a}i=M[b+72>>2];j=M[a>>2];if(N[j+12|0]){g=ac(i);if(g){break a}}g=O[i+28>>1];if(g&2){g=em(i);if(g){break a}g=O[i+28>>1]}if(!(!(g&8)|f)){k=M[i+24>>2]}L[i+28>>1]=g&65527;f=Qh(j,e);b:{if(!f){break b}g=M[f+32>>2];m=M[f+36>>2];if((m|0)>0){g=1}else{g=(m|0)>=0&g>>>0>=2}if(g){xg(f);g=db(64534);break a}L[i+28>>1]=O[i+28>>1]|O[f+28>>1]&8;if(N[j+12|0]){Mh(f,M[j+28>>2]+1|0);break b}el(f)}g=M[i+24>>2];Mh(i,e);bl(i);if(!(!f|!N[j+12|0])){Mh(f,g);xg(f)}if(k){g=Ra[M[j+220>>2]](j,k,h+8|0,0)|0;if(g){if(P[j+32>>2]<k>>>0){break a}d=M[j+224>>2];e=0;c:{b=M[j+60>>2];if(!b){break c}a=k-1|0;while(1){c=M[b+8>>2];if(c){f=c;c=(a>>>0)/(c>>>0)|0;a=a-S(f,c)|0;b=M[((c<<2)+b|0)+12>>2];if(b){continue}break c}break}if(P[b>>2]<=4e3){b=(a>>>3|0)+b|0;c=N[b+12|0];n=b,o=cK(-2,a&7)&c,K[n+12|0]=o;break c}f=b+12|0;G(d,f,500);D(f,0,500);M[b+4>>2]=0;i=a+1|0;c=0;while(1){if((c|0)==125){break c}j=d+(c<<2)|0;a=M[j>>2];if(!(!a|(a|0)==(i|0))){e=e+1|0;M[b+4>>2]=e;a=(a-1>>>0)%125|0;while(1){l=f+(a<<2)|0;if(M[l>>2]){a=a+1|0;a=a>>>0<=124?a:0;continue}break}M[l>>2]=M[j>>2]}c=c+1|0;continue}}break a}f=M[h+8>>2];L[f+28>>1]=O[f+28>>1]|8;bl(f);xg(M[h+8>>2])}M[h>>2]=0;M[b+4>>2]=e;d:{if((c&251)==1){g=Nu(b);if(g){break a}g=0;if((c|0)!=1){break d}break a}b=mb(M[b+56>>2]);if(!b){break d}Hd(a,b,4,e,h);g=M[h>>2];if(g){break a}}g=xd(a,d,h+4|0,0);if(g){break a}b=M[h+4>>2];g=ac(M[b+72>>2]);if(g){Rb(b);break a}e:{f:{if((c|0)==4){f=M[b+56>>2];if((mb(f)|0)!=(l|0)){g=db(74621);break e}g=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[f|0]=g;K[f+1|0]=g>>>8;K[f+2|0]=g>>>16;K[f+3|0]=g>>>24;break f}if(!N[b|0]){g=Th(b);if(g){break e}}i=O[b+24>>1];g=0;j=(c|0)!=3;g:{while(1){if((g|0)==(i|0)){break g}k=M[b+56>>2];f=M[b+64>>2]+(g<<1)|0;f=k+(O[b+26>>1]&(N[f|0]<<8|N[f+1|0]))|0;h:{i:{if(!j){Ra[M[b+80>>2]](b,f,h+8|0);if(P[h+20>>2]<=O[h+24>>1]){break i}f=f+O[h+26>>1]|0;if(f>>>0>M[b+56>>2]+M[M[b+52>>2]+40>>2]>>>0){g=db(74640);break e}k=f-4|0;if((mb(k)|0)!=(l|0)){break i}K[k|0]=e>>>24;K[f-1|0]=e;K[f-2|0]=e>>>8;K[f-3|0]=e>>>16;break f}if(f+4>>>0>k+M[M[b+52>>2]+40>>2]>>>0){g=db(74649);break e}if((mb(f)|0)==(l|0)){break h}}g=g+1|0;continue}break}g=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[f|0]=g;K[f+1|0]=g>>>8;K[f+2|0]=g>>>16;K[f+3|0]=g>>>24;break f}j:{if((c|0)==5){f=M[b+56>>2]+N[b+9|0]|0;if((mb(f+8|0)|0)==(l|0)){break j}}g=db(74661);break e}g=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[f+8|0]=g;K[f+9|0]=g>>>8;K[f+10|0]=g>>>16;K[f+11|0]=g>>>24}g=0}M[h>>2]=g;Rb(b);if(g){break a}Hd(a,e,c,d,h);g=M[h>>2]}Na=h+32|0;return g}function ev(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;j=Na-16|0;Na=j;e=M[a+44>>2];a:{if(e){break a}e=0;f=M[a+104>>2];if((f|0)<=(c|0)){break a}d=((b|0)!=1)+c|0;c=d;while(1){if((c|0)<(f|0)){dg(M[(M[a+100>>2]+S(c,48)|0)+16>>2]);c=c+1|0;f=M[a+104>>2];continue}break}M[a+104>>2]=d;if((b|0)==1){d=M[a+100>>2]+S(d,48)|0;if(!M[d+28>>2]){break a}b=M[a+72>>2];c=M[b>>2];if(!c){break a}if((c|0)==33496){i=M[d+24>>2];c=M[a+172>>2];e=M[a+168>>2]+4|0;c=e>>>0<4?c+1|0:c;e=Zo(b,ZJ(i,0,e,c),Qa)}M[a+56>>2]=M[d+24>>2];break a}if(!(M[a+232>>2]|M[M[a+68>>2]>>2])){break a}b:{c:{if(!d){break c}b=M[a+100>>2]+S(d,48)|0;h=b-48|0;if(!h){break c}c=b-28|0;m=kj(M[c>>2]);if(!m){e=7;break a}b=0;break b}c=a+32|0;h=0;b=1}M[a+28>>2]=M[c>>2];K[a+19|0]=N[a+12|0];d:{e:{f:{i=b;if(b){d=M[a+232>>2];if(!d){f=a+80|0;d=M[a+80>>2];k=M[a+84>>2];break f}M[a+28>>2]=M[a+32>>2];g:{if(!N[d+44|0]){break g}i=M[d+68>>2];G(d+52|0,M[M[d+32>>2]>>2],48);c=M[d+68>>2];while(1){h:{if(e){break h}b=c+1|0;if(b>>>0>i>>>0){break h}c=c+34|0;if(c>>>0<=4095){c=(M[M[d+32>>2]>>2]+(b<<2)|0)+132|0}else{c=M[M[d+32>>2]+(c>>>10&4194300)>>2]+((c&4095)<<2)|0}e=$u(a,M[c>>2]);c=b;continue}break}if((i|0)==M[d+68>>2]){break g}Yo(d)}c=uq(M[a+228>>2]);while(1){if(!c|e){break a}b=M[c+16>>2];e=$u(a,M[c+24>>2]);c=b;continue}}f=a+80|0;d=M[a+80>>2];k=M[a+84>>2];if(M[a+232>>2]){break f}b=M[h+8>>2];c=M[h+12>>2];g=M[h+4>>2];M[f>>2]=M[h>>2];M[f+4>>2]=g;g=!(b|c);b=g?d:b;c=g?k:c;while(1){if(e){break d}g=M[f+4>>2];if((c|0)<=(g|0)&b>>>0<=P[f>>2]|(c|0)<(g|0)){break e}e=cl(a,f,m,1,1);continue}}M[f>>2]=0;M[f+4>>2]=0}e=0}i:while(1){j:{if(e){break j}c=M[f+4>>2];if((k|0)<=(c|0)&d>>>0<=P[f>>2]|(c|0)>(k|0)){break j}M[j>>2]=0;e=av(a,0,d,k,j,j+12|0);b=M[j>>2];k:{if(b){break k}b=0;g=M[a+92>>2];l=M[a+156>>2];c=l+M[a+88>>2]|0;g=c>>>0<l>>>0?g+1|0:g;if((c|0)!=M[a+80>>2]|(g|0)!=M[a+84>>2]){break k}l=d-c|0;c=k-(g+(c>>>0>d>>>0)|0)|0;b=M[a+172>>2];g=M[a+168>>2]+8|0;b=g>>>0<8?b+1|0:b;b=_J(l,c,g,b)}c=0;while(1){if(b>>>0<=c>>>0|e){continue i}l=M[f+4>>2];if((k|0)<=(l|0)&d>>>0<=P[f>>2]|(k|0)<(l|0)){continue i}c=c+1|0;e=cl(a,f,m,1,1);continue}}break}l:{if(i){break l}c=M[h+24>>2];b=M[a+172>>2];i=M[a+168>>2]+4|0;b=i>>>0<4?b+1|0:b;n=j,o=ZJ(c,0,i,b),M[n>>2]=o;M[j+4>>2]=Qa;b=M[a+232>>2];m:{if(!b){break m}if(M[h+44>>2]==M[b+112>>2]){i=M[h+32>>2]}else{M[h+32>>2]=0;M[h+44>>2]=M[b+112>>2];i=0}e=0;if(i>>>0>=P[b+68>>2]){break m}M[b+68>>2]=i;M[b+76>>2]=M[h+36>>2];M[b+80>>2]=M[h+40>>2];Yo(b);c=M[h+24>>2]}while(1){if(P[a+56>>2]<=c>>>0|e){break l}c=c+1|0;e=cl(a,j,m,0,1);continue}}dg(m);if(e){break a}M[f>>2]=d;M[f+4>>2]=k;e=0}Na=j+16|0;return e}function Oz(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;p=e+9|0;if((p|0)>M[a+48>>2]){M[a+48>>2]=p}q=M[a>>2];g=Cb(a);a:{if(!b|!g|N[b+43|0]){break a}i=M[b>>2];if(i){h=Zh(29243,i,31404,92)}else{h=1}if(!h){break a}h=M[q+16>>2];t=Mb(q,M[b+60>>2]);if(gc(a,28,i,0,M[h+(t<<4)>>2])){break a}v=e+8|0;z=e+7|0;A=e+5|0;l=e+4|0;B=e+3|0;s=e+2|0;w=e+1|0;Dd(a,t,M[b+20>>2],0,M[b>>2]);i=M[a+44>>2];h=f+2|0;M[a+44>>2]=(h|0)<(i|0)?i:h;Pd(a,f,t,b,102);x=e+6|0;Uc(g,x,M[b>>2]);h=b+8|0;o=f+1|0;y=1;while(1){j=M[h>>2];if(j){b:{if((c|0)!=(j|0)?c:0){break b}c:{d:{i=N[j+55|0]|N[j+56|0]<<8;e:{if(!(!(N[b+28|0]&128)|(i&3)!=2)){k=M[b>>2];h=O[j+50>>1];break e}k=M[j>>2];h=O[j+52>>1];if(i&8){break d}}i=h;break c}i=O[j+50>>1]}r=M[j+36>>2];Uc(g,z,k);k=i-1|0;n=k+p|0;if((n|0)>M[a+48>>2]){M[a+48>>2]=n}y=r?y:0;bb(g,102,o,M[j+44>>2],t);Ld(a,j);$a(g,71,M[q+496>>2],A);$a(g,71,h,s);$a(g,71,O[j+50>>1],B);bb(g,98,o,l,M[q+80>>2]>>>11&1);nk(a,0,s,w,4,51736,0);r=fb(g,36,o);$a(g,71,0,s);f:{if(i>>>0<2){i=M[g+108>>2];break f}n=M[a+60>>2]-1|0;M[a+60>>2]=n;u=Ob(q,k<<2,0);if(!u){break b}Ub(g,9);i=M[g+108>>2];if(!(!N[j+54|0]|((k|0)!=1|O[j+50>>1]!=1))){$a(g,52,p,n)}h=0;while(1){if((h|0)!=(k|0)){m=h<<2;C=Li(a,M[m+M[j+32>>2]>>2]);$a(g,71,h,s);bb(g,94,o,h,l);D=m+u|0,E=nb(g,53,l,0,h+p|0,C,-2),M[D>>2]=E;m=M[g+108>>2];if((m|0)>0){L[(M[g+104>>2]+S(m,20)|0)-18>>1]=128}h=h+1|0;continue}break}$a(g,71,k,s);Xb(g,n);m=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:(M[g+104>>2]+S(i,20)|0)-20|0)+8>>2]=m;h=0;while(1){if((h|0)!=(k|0)){if(N[M[g>>2]+87|0]){m=74356}else{m=M[g+104>>2]+S(M[(h<<2)+u>>2],20)|0}M[m+8>>2]=M[g+108>>2];bb(g,94,o,h,h+p|0);h=h+1|0;continue}break}pb(g,n);ib(q,u)}nk(a,1,w,l,2,51776,0);g:{if(M[q+496>>2]){h=fb(g,51,l);k=fb(g,16,l);n=lb(g,24,o,0,p,1);M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(h,20)|0)+8>>2]=M[g+108>>2];$a(g,39,o,i);i=M[g+108>>2];h:{if(N[M[g>>2]+87|0]){M[18591]=i;h=74356;break h}h=M[g+104>>2];M[(h+S(k,20)|0)+8>>2]=i;h=h+S(n,20)|0}M[h+8>>2]=i;break g}$a(g,39,o,i)}if(M[j+36>>2]){M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(r,20)|0)+8>>2]=M[g+108>>2];r=0}nk(a,0,w,v,1,51816,0);nb(g,97,x,3,l,20999,0);$a(g,127,d,e);bb(g,128,d,l,e);i=M[g+108>>2];if((i|0)>0){L[(M[g+104>>2]+S(i,20)|0)-18>>1]=8}if(!r){break b}M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(r,20)|0)+8>>2]=i}h=j+20|0;continue}break}if(!(y&255)|c){break a}$a(g,98,f,v);b=fb(g,17,v);$a(g,75,0,z);nb(g,97,x,3,l,20999,0);$a(g,127,d,e);bb(g,128,d,l,e);a=M[g+108>>2];if((a|0)>0){L[(M[g+104>>2]+S(a,20)|0)-18>>1]=8}M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(b,20)|0)+8>>2]=a}}function dh(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;q=Na-16|0;Na=q;r=a+252|0;g=M[a+252>>2];a:{b:{if(g){m=Na-16|0;Na=m;c:{if(!g){a=_c(103256);break c}p=M[g+20>>2];a=M[g+16>>2];d:{if(!a){a=4;break d}M[a+36>>2]=0;a=xw(g,b,c,m+12|0);if(!a){break d}b=M[m+12>>2];M[m>>2]=b;ae(p,a,b?8932:0,m);eb(p,b)}a=qd(p,a)}Na=m+16|0;break b}e:{g=M[a+248>>2];if(g){break e}M[q>>2]=M[a+20>>2];g=Hb(4058,q);M[a+248>>2]=g;if(g){break e}a=7;break a}h=M[a+12>>2];m=M[a+16>>2];p=g;f=Na-352|0;Na=f;M[f+348>>2]=0;M[r>>2]=0;j=ub(h,32,0);f:{g:{h:{i:{j:while(1){k:{a=f+60|0;xm(a,h);if(!j){break k}eb(h,M[f+348>>2]);M[f+348>>2]=0;Fe(h);l:{k=yf(a,0,p,m);if(k){g=N[k+43|0];i=8452;m:{if((g|0)==1){break m}a=M[k+28>>2];i=8632;if(a&128){break m}i=7640;if(a&96){break m}if((g|0)!=2){break l}i=7597}M[f+16>>2]=p;cb(f+60|0,i,f+16|0)}n=1;if(!M[f+64>>2]){break h}eb(h,0);M[f+348>>2]=M[f+64>>2];M[f+64>>2]=0;break h}M[j+28>>2]=k;t=j,u=M[M[h+16>>2]+(Mb(h,M[k+60>>2])<<4)>>2],M[t+24>>2]=u;a=0;i=L[k+34>>1];g=(i|0)>0?i:0;while(1){n:{if((a|0)!=(g|0)){if(hb(M[M[k+4>>2]+S(a,12)>>2],12025)){break n}g=a}if((g|0)==(i|0)){eb(h,0);M[f+32>>2]=12025;t=f,u=tb(h,29914,f+32|0),M[t+348>>2]=u;n=1;break h}l=zw(f+60|0);M[j+16>>2]=l;o:{p:{if(l){a=M[k+60>>2];i=Mb(h,a);lb(l,2,i,0,M[a>>2],M[a+4>>2]);a=M[l+108>>2];if((a|0)>0){L[(M[l+104>>2]+S(a,20)|0)-18>>1]=1}o=hg(l,6,31376);se(l,i);if(N[h+87|0]){break p}M[o+4>>2]=i;a=M[k+20>>2];M[o+12>>2]=0;M[o+8>>2]=a;Vd(l,2,M[k>>2],0);if(N[h+87|0]){break p}a=M[k+20>>2];M[o+32>>2]=i;M[o+28>>2]=a;K[o+21|0]=253;M[o+36>>2]=L[k+34>>1]+1;M[o+68>>2]=L[k+34>>1];L[f+280>>1]=0;M[f+104>>2]=1;M[f+108>>2]=1;yw(l,f+60|0)}a=N[h+87|0];M[j+20>>2]=h;L[j+8>>1]=g;if(a){break o}n=xw(j,b,c,f+348|0);if((n|0)!=17|s>>>0>48){break o}s=s+1|0;qi(f+60|0);n=17;continue j}M[j+20>>2]=h;L[j+8>>1]=g}if(n){break i}break k}a=a+1|0;continue}}break}n=0;if(N[h+87|0]){break i}M[r>>2]=j;break f}if(!j){break g}}a=M[j+16>>2];if(!a){break g}Mf(a)}eb(h,j)}a=M[f+348>>2];M[f>>2]=a;ae(h,n,a?8932:0,f);eb(h,a);qi(f+60|0);a=qd(h,n);Na=f+352|0}if(!a){a=0;c=M[r>>2];b=0;q:{if(!c){break q}b=0;if(!M[c+16>>2]){break q}b=M[c>>2]}M[e>>2]=b;if(!d){break a}c=b>>31;a=b+20|0;c=a>>>0<20?c+1|0:c;e=Bb(a,c);r:{if(!e){e=0;a=7;break r}a=rw(M[r>>2],e,b,0);b=b+e|0;K[b+16|0]=0;K[b+17|0]=0;K[b+18|0]=0;K[b+19|0]=0;K[b+8|0]=0;K[b+9|0]=0;K[b+10|0]=0;K[b+11|0]=0;K[b+12|0]=0;K[b+13|0]=0;K[b+14|0]=0;K[b+15|0]=0;K[b|0]=0;K[b+1|0]=0;K[b+2|0]=0;K[b+3|0]=0;K[b+4|0]=0;K[b+5|0]=0;K[b+6|0]=0;K[b+7|0]=0;if(!a){a=0;break r}ab(e);e=0}M[d>>2]=e;break a}a=(a|0)==1?267:a}Na=q+16|0;return a}function Xv(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;m=Na+-64|0;Na=m;i=jb(b);a:{b:{c:{d:{e:{f:{o=M[c>>2];g:{if(!(o&64)){if(!N[67470]){break f}if(i>>>0>4){break g}break f}if(i>>>0<5){break f}}if(Qb(b,23209,5)){break f}k=i+8|0;while(1){if((h|0)!=(i|0)){l=N[b+h|0]==38;k=k+l|0;g=l>>>0>k>>>0?g+1|0:g;h=h+1|0;continue}break}g=Bb(k,g);if(!g){break d}o=o|64;K[g|0]=0;K[g+1|0]=0;K[g+2|0]=0;K[g+3|0]=0;l=g+4|0;g=5;h:{if(N[b+5|0]!=47|N[b+6|0]!=47){break h}h=7;while(1){g=N[b+h|0];if(!(!g|(g|0)==47)){h=h+1|0;continue}break}if((h|0)==7){g=h;break h}g=16;if((h|0)==16){if(!Qb(2272,b+7|0,9)){break h}}M[m+4>>2]=b+7;M[m>>2]=h-7;h=1;g=Hb(6041,m);break c}s=b+2|0;while(1){p=l+n|0;t=p-1|0;h=N[b+g|0];i:{j:{k:{l:{m:{n:while(1){i=h&255;if(!i|(i|0)==35){break i}k=g+1|0;o:{if((i|0)!=37){break o}q=N[b+k|0];if(!(N[q+31408|0]&8)){break o}r=N[g+s|0];if(!(N[r+31408|0]&8)){break o}g=g+3|0;h=(r<<1<<24>>24>>>7&9)+r&15|q+(q<<1<<24>>24>>>7&9)<<4;if(h&255){break j}while(1){h=N[b+g|0];if(!h|(h|0)==35|!j&(h|0)==63){continue n}p:{if((j|0)==1){if((h|0)==38|(h|0)==61){continue n}break p}if((j|0)!=2){break p}if((h|0)==38){continue n}}g=g+1|0;continue}}if((j|0)!=1){break m}if(!((i|0)==61|(i|0)==38)){j=1;break k}if(!N[t|0]){g=k;while(1){j=1;k=b+g|0;h=N[k|0];if(!h|(h|0)==35|N[k-1|0]==38){continue n}g=g+1|0;continue}}break}j=2;if((i|0)!=38){break l}h=0;K[p|0]=0;j=1;n=n+1|0;break k}if(!(!j&(i|0)==63)&((j|0)!=2|(i|0)!=38)){break k}j=1}h=0}g=k}K[l+n|0]=h;n=n+1|0;continue}break}if((j|0)==1){K[p|0]=0;n=n+1|0}b=l+n|0;K[b|0]=0;K[b+1|0]=0;K[b+2|0]=0;K[b+3|0]=0;h=jb(l)+l|0;while(1){if(!N[h+1|0]){break e}g=h+1|0;h=jb(g);b=(g+h|0)+1|0;k=jb(b);q:{r:{s:{switch(h-3|0){case 0:if(Qb(5326,g,3)){break q}a=b;break q;case 2:j=14585;if(Qb(14585,g,5)){break q}n=393216;i=-393217;g=51600;break r;case 1:break s;default:break q}}if((N[g|0]|N[g+1|0]<<8|(N[g+2|0]<<16|N[g+3|0]<<24))!=1701080941){break q}n=o&135;i=-136;j=4467;g=51632}h=0;t:{u:{while(1){q=g+(h<<3)|0;p=M[q>>2];if(!p){break u}v:{if((jb(p)|0)==(k|0)){if(!Qb(b,p,k)){break v}}h=h+1|0;continue}break}g=M[q+4>>2];if(g){break t}}M[m+36>>2]=b;M[m+32>>2]=j;h=1;g=Hb(8543,m+32|0);break c}if((g&-129)>(n|0)){M[m+52>>2]=b;M[m+48>>2]=j;h=3;g=Hb(8668,m+48|0);break c}o=g|i&o}h=b+k|0;continue}}g=Bb(i+8|0,0);if(!g){break d}K[g|0]=0;K[g+1|0]=0;K[g+2|0]=0;K[g+3|0]=0;l=g+4|0;if(i){G(l,b,i)}b=i+l|0;K[b|0]=0;K[b+1|0]=0;K[b+2|0]=0;K[b+3|0]=0;o=o&-65}b=Xl(a);M[d>>2]=b;h=0;if(b){break b}M[m+16>>2]=a;h=1;g=Hb(7685,m+16|0);break c}h=7;break a}M[f>>2]=g;ip(l);l=0}M[c>>2]=o;M[e>>2]=l}Na=m- -64|0;return h}function Ch(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=32;f=M[b>>2];a:{if(O[f+8>>1]>13){break a}d=M[b+4>>2];e=O[d+16>>1];j=N[M[f+16>>2]];b:{if(!j){i=255;h=1;break b}if(j&2){break a}i=1;h=255}K[b+25|0]=h;K[b+24|0]=i;if(e&4){f=M[d+4>>2];M[b+8>>2]=M[d>>2];M[b+12>>2]=f;l=33;break a}if(M[f+20>>2]|e&57){break a}M[b+8>>2]=M[d+8>>2];M[b+16>>2]=M[d+12>>2];l=34}K[b+23|0]=0;c:{d:{e:{f:{if(N[a|0]){break f}d=M[a+116>>2];if(!N[d+8|0]){break f}f=0;e=K[a+68|0];e=(e|0)>0?e:0;j=a+72|0;i=a+120|0;while(1){if((e|0)!=(f|0)){k=f<<1;g=f<<2;f=f+1|0;if(O[j+k>>1]>=O[M[g+i>>2]+24>>1]){continue}break f}break}g:{h=O[d+24>>1]-1|0;d=O[a+70>>1];if((h|0)!=(d|0)){break g}d=Qt(a,d,b,l);if((d|0)>0|N[b+23|0]){break g}M[c>>2]=d;return 0}h:{if(K[a+68|0]<=0){break h}if((Qt(a,0,b,l)|0)>0|N[b+23|0]){break h}K[a+1|0]=N[a+1|0]&243;f=M[a+116>>2];if(N[f|0]){break e}return db(76794)}K[b+23|0]=0}e=Zf(a);if((e|0)==16){break c}if(e){break d}f=M[a+116>>2]}m=a+120|0;p=a+72|0;n=a+32|0;o=a+116|0;e=O[f+24>>1];i:{j:{while(1){e=(e&65535)-1|0;j=e;i=0;k:{while(1){d=M[f+64>>2]+(e&-2)|0;d=M[f+68>>2]+(O[f+26>>1]&(N[d|0]<<8|N[d+1|0]))|0;g=d+1|0;k=e>>1;e=N[d|0];l:{if(e>>>0<=N[f+11|0]){e=Ra[l|0](e,g,b)|0;break l}m:{g=K[g|0];if((g|0)<0){break m}e=g|e<<7&16256;if(e>>>0>O[f+14>>1]){break m}e=Ra[l|0](e,d+2|0,b)|0;break l}Ra[M[f+80>>2]](f,d-N[f+10|0]|0,n);n:{d=M[n>>2];h=d;if((d|0)>=2){e=M[a+20>>2];if((d>>>0)/P[e+40>>2]>>>0<=P[e+48>>2]){break n}}e=db(76881);break i}d=d+18|0;g=lc(d,0);if(!g){e=7;break i}L[a+70>>1]=k;e=yl(a,0,h,g);d=g+h|0;K[d+16|0]=0;K[d+17|0]=0;K[d+8|0]=0;K[d+9|0]=0;K[d+10|0]=0;K[d+11|0]=0;K[d+12|0]=0;K[d+13|0]=0;K[d+14|0]=0;K[d+15|0]=0;K[d|0]=0;K[d+1|0]=0;K[d+2|0]=0;K[d+3|0]=0;K[d+4|0]=0;K[d+5|0]=0;K[d+6|0]=0;K[d+7|0]=0;K[a+1|0]=N[a+1|0]&251;if(e){ab(g);break i}e=Xi(h,g,b);ab(g)}o:{p:{if((e|0)<0){i=k+1|0;break p}if(!e){break o}j=k-1|0}if((i|0)>(j|0)){break k}e=i+j|0;continue}break}e=0;M[c>>2]=0;L[a+70>>1]=k;if(!N[b+23|0]){break i}e=db(76913);break i}if(N[f+8|0]){L[a+70>>1]=k;M[c>>2]=e;e=0;break i}d=M[f+56>>2];if(O[f+24>>1]<=(i|0)){h=(d+N[f+9|0]|0)+8|0}else{h=O[f+26>>1];f=M[f+64>>2]+(i<<1)|0;h=d+(h&(N[f|0]<<8|N[f+1|0]))|0}f=mb(h);L[a+50>>1]=0;K[a+1|0]=N[a+1|0]&249;d=K[a+68|0];if((d|0)>=19){return db(76944)}L[(d<<1)+p>>1]=i;M[(d<<2)+m>>2]=M[a+116>>2];K[a+68|0]=d+1;L[a+70>>1]=0;e=Ui(M[a+20>>2],f,o,N[a+2|0]);if(e){break j}f=M[o>>2];e=O[f+24>>1];if(N[f+1|0]==N[a+69|0]?e:0){continue}break}Rb(f);e=db(76955)}b=N[a+68|0]-1|0;K[a+68|0]=b;M[a+116>>2]=M[(b<<24>>24<<2)+m>>2]}L[a+50>>1]=0}return e}M[c>>2]=-1;return 0}function tv(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Na+-64|0;Na=h;f=M[d>>2];M[d>>2]=f+1;a:{if((f|0)>=5){e=15;if(f>>>0>99){break a}g=M[a>>2];d=f-8|0;Ra[M[g+60>>2]](g,f>>>0<=8?1:S(S(d,d),39))|0}b:{c:{d:{e:{f:{g:{if(!c){if(!N[a+50|0]){e=jv(a,b);if(e){if((e|0)!=5){break a}e=-1;if(!M[M[a+32>>2]>>2]){break a}b=Rh(a,2);if(!b){Pg(a,2);break a}e=(b|0)==5?261:b;break a}if(!N[a+50|0]){break g}}c=Rh(a,3);if(c){e=(c|0)==5?-1:c;d=0;break b}d=0;L[a+40>>1]=0;c=M[a+4>>2];e=Ra[M[M[c>>2]+52>>2]](c,0,32768,0,h+12|0)|0;if((e|0)==8){break e}if((e|0)!=1288){break b}G(a+52|0,M[M[a+32>>2]>>2],48);c=M[a+8>>2];e=Ra[M[M[c>>2]+24>>2]](c,h+56|0)|0;if(e){break b}g=M[h+56>>2];c=M[h+60>>2];if((c|0)<0){c=1}else{c=(c|0)<=0&g>>>0<=31}if(c){M[b>>2]=1;e=M[a+68>>2]?-1:0;break b}c=M[a+8>>2];e=Ra[M[M[c>>2]+8>>2]](c,h+16|0,32,0,0)|0;if(e){break b}if(M[h+32>>2]!=(N[a+84|0]|N[a+85|0]<<8|(N[a+86|0]<<16|N[a+87|0]<<24))|M[h+36>>2]!=(N[a+88|0]|N[a+89|0]<<8|(N[a+90|0]<<16|N[a+91|0]<<24))){e=-1;break b}j=M[a+36>>2]+24|0;c=j>>31;m=c;d=Bb(j,c);if(!d){e=7;d=0;break b}n=d+24|0;c=ZJ(M[a+68>>2],0,M[a+36>>2]+24|0,0);f=Qa;k=c+32|0;f=k>>>0<32?f+1|0:f;o=M[a+80>>2];l=M[a+76>>2];while(1){c=f+m|0;g=j+k|0;c=g>>>0<j>>>0?c+1|0:c;i=M[h+60>>2];if(P[h+56>>2]<g>>>0&(i|0)<=(c|0)|(c|0)>(i|0)){break d}i=M[a+8>>2];e=Ra[M[M[i>>2]+8>>2]](i,d,j,k,f)|0;if(e){break c}if(!iv(a,h+8|0,h+4|0,n,d)){break d}if(M[h+4>>2]){e=-1;break c}else{k=g;f=c;continue}}}j=a+32|0;l=M[M[a+32>>2]>>2]+96|0;e=0;break f}j=a+32|0;b=M[M[a+32>>2]>>2];l=b+96|0;e=0;if(M[b+96>>2]!=M[a+68>>2]){break f}e=Rh(a,3);gl(a);if((e|0)==5){break f}if(e){break a}if(Qb(M[M[a+32>>2]>>2],a+52|0,48)){Pg(a,3);e=-1;break a}e=0;L[a+40>>1]=0;break a}i=l+4|0;g=M[a+68>>2];b=0;d=1;c=0;while(1){if((d|0)!=5){k=M[i+(d<<2)>>2];f=k>>>0>g>>>0|c>>>0>k>>>0;c=f?c:k;b=f?b:d;d=d+1|0;continue}break}h:{i:{if(N[a+46|0]&2){break i}d=1;if(b?c>>>0>=g>>>0:0){break h}while(1){if((d|0)==5){break i}f=d+3|0;e=cg(a,f,1);if((e|0)!=5){if(e){break a}M[i+(d<<2)>>2]=g;Ee(a,f,1);c=g;b=d;break h}else{d=d+1|0;e=5;continue}}}if(b){break h}e=(e|0)==5?-1:1288;break a}d=b+3|0;g=Rh(a,d);if(g){e=(g&255)==5?-1:g;break a}M[a+100>>2]=M[l>>2]+1;gl(a);j:{if(M[i+(b<<2)>>2]==(c|0)){if(!Qb(M[M[j>>2]>>2],a+52|0,48)){break j}}Pg(a,d);e=-1;break a}L[a+40>>1]=b;e=0;break a}e=-1;break b}e=0}M[a+80>>2]=o;M[a+76>>2]=l}ab(d);if(!e){break a}d=0;while(1){if((d|0)<M[a+24>>2]){c=d<<2;ab(M[c+M[a+32>>2]>>2]);M[c+M[a+32>>2]>>2]=0;d=d+1|0;continue}break}K[a+50|0]=0;Xo(a);M[b>>2]=1}Na=h- -64|0;return e}function nI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;b=Na-352|0;Na=b;i=M[M[a>>2]+20>>2];n=gb(M[c>>2]);k=gb(M[c+12>>2]);m=gb(M[c+16>>2]);d=sb(M[c+20>>2]);o=gb(M[c+24>>2]);p=sb(M[c+28>>2]);f=sb(M[c+32>>2]);a:{if(!o|(!n|!m)){break a}g=d;if((d|0)<0){break a}q=M[i+364>>2];Fe(i);h=Hc(i,m,k);if(!h|(d|0)>=L[h+34>>1]){break a}l=M[M[h+4>>2]+S(d,12)>>2];M[b+344>>2]=0;M[b+336>>2]=0;M[b+340>>2]=0;M[b+328>>2]=0;M[b+332>>2]=0;M[b+336>>2]=(d|0)==L[h+32>>1]?-1:d;M[i+364>>2]=0;d=b+40|0;e=fk(d,k,i,n,f);M[b+32>>2]=0;M[b+24>>2]=0;M[b+28>>2]=0;M[b+20>>2]=96;M[b+16>>2]=97;M[b+340>>2]=h;M[b+36>>2]=b+328;M[b+12>>2]=d;b:{if(e){break b}c:{d:{d=M[b+292>>2];if(d){e:{switch(N[d+43|0]){case 2:d=M[d+44>>2];M[d+4>>2]=M[d+4>>2]&-2097153;M[b+52>>2]=0;je(b+40|0,d,0);e=N[i+87|0]?7:M[b+52>>2];if(e){break b}oc(b+12|0,d);break c;case 0:break e;default:break c}}h=hc(m,M[d>>2]);M[b+340>>2]=d;if(h){break d}if((g|0)<L[d+34>>1]){hd(b+40|0,b+328|0,M[M[d+4>>2]+S(g,12)>>2]);d=M[b+292>>2]}f=b+12|0;if(M[b+336>>2]<0){hd(b+40|0,b+328|0,d+32|0);d=M[b+292>>2]}ec(f,M[d+16>>2]);e=M[b+292>>2]+8|0;while(1){d=M[e>>2];if(d){ec(b+12|0,M[d+40>>2]);e=d+20|0;continue}break}e=M[b+296>>2];while(1)if(e){ec(b+12|0,M[e+40>>2]);e=M[e+20>>2];continue}else{e=0;while(1){d=M[b+292>>2];if(L[d+34>>1]<=(e|0)){break d}Nb(b+12|0,Tc(d,M[d+4>>2]+S(e,12)|0));e=e+1|0;continue}}}f=M[b+296>>2];if(f){d=b+12|0;ec(d,M[f+40>>2]);Nb(d,M[M[b+296>>2]+36>>2]);break c}e=um(b+40|0);if(e){break b}e=M[b+300>>2]+28|0;while(1){g=M[e>>2];if(g){d=M[g+12>>2];f:{if(!d){break f}f=b+40|0;if((yf(f,0,d,k)|0)!=(h|0)){break f}d=M[g+32>>2];if(d){Hz(f,b+328|0,M[d+8>>2],l)}f=b+40|0;d=b+328|0;Gz(f,d,M[g+28>>2],l);Hz(f,d,M[g+24>>2],l)}e=g+40|0;continue}break}d=M[b+300>>2];f=b+12|0;if((h|0)==M[b+176>>2]){Gz(b+40|0,b+328|0,M[d+16>>2],l);d=M[b+300>>2]}Tq(f,d);break c}e=d+48|0;while(1){j=M[e>>2];if(!j){break c}k=j+40|0;f=j+36|0;e=0;while(1){if((e|0)<M[j+20>>2]){g:{if(h){break g}d=(e<<3)+f|0;if((g|0)!=M[d>>2]){break g}hd(b+40|0,b+328|0,d)}h:{if(hc(M[j+8>>2],m)){break h}d=M[k+(e<<3)>>2];if(hc(d,l)){break h}hd(b+40|0,b+328|0,d)}e=e+1|0;continue}break}e=j+4|0;continue}}e=Sq(a,b+328|0,n,o,p)}i:{j:{k:{switch(e|0){case 1:break k;case 0:break i;default:break j}}if((M[i+32>>2]&268435457)!=1){break j}He(a,M[c>>2]);break i}if(M[b+44>>2]){Rq(a,30808,M[c+4>>2],M[c+8>>2],b+40|0);break i}ee(a,e)}dk(b+40|0);tm(i,M[b+328>>2]);M[i+364>>2]=q}Na=b+352|0}function oJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Na+-64|0;Na=e;b=M[M[a>>2]+20>>2];M[e+60>>2]=0;M[e+56>>2]=0;M[e+48>>2]=0;d=gb(M[c>>2]);i=d?d:30808;c=gb(M[c+4>>2]);a:{b:{c:{d:{e:{f:{g:{h:{i:{if(N[b+178|0]&4){M[e+52>>2]=0;c=Xl(18134);M[e+44>>2]=c;if(!c){break a}c=mj(c,51596,b,e+52|0,0,256);if(c){break b}c=M[e+52>>2];f=ql(b,c);if(f){d=M[b+16>>2]+(N[b+176|0]<<4)|0;g=M[d+4>>2];if(g){Cf(g)}M[d+12>>2]=f;M[d+4>>2]=c;K[b+95|0]=0;break i}Cf(c);c=7;break b}j:{d=M[b+20>>2];f=M[b+148>>2];k:{if((d|0)<(f+2|0)){f=c?c:30808;c=0;g=(d|0)>0?d:0;while(1){if((c|0)==(g|0)){break j}h=Lk(b,c,f);c=c+1|0;if(!h){continue}break}M[e+16>>2]=f;d=tb(b,13542,e+16|0);break k}M[e+32>>2]=f;d=tb(b,17091,e+32|0)}M[e+48>>2]=d;c=0;break e}c=M[b+16>>2];l:{if((c|0)==(b+460|0)){c=Ob(b,48,0);if(!c){break a}d=M[b+16>>2];g=M[d+4>>2];M[c>>2]=M[d>>2];M[c+4>>2]=g;g=M[d+28>>2];M[c+24>>2]=M[d+24>>2];M[c+28>>2]=g;g=M[d+20>>2];M[c+16>>2]=M[d+16>>2];M[c+20>>2]=g;g=M[d+12>>2];M[c+8>>2]=M[d+8>>2];M[c+12>>2]=g;break l}c=ld(b,c,(d<<4)+16|0,0);if(!c){break a}}M[b+16>>2]=c;d=(M[b+20>>2]<<4)+c|0;M[d>>2]=0;M[d+4>>2]=0;M[d+8>>2]=0;M[d+12>>2]=0;M[e+52>>2]=M[b+60>>2];c=Xv(M[M[b>>2]+16>>2],i,e+52|0,e+44|0,e+60|0,e+56|0);if(c){if((c|0)==7){Lb(b)}b=a;a=M[e+56>>2];Pb(b,a,-1);ab(a);break a}c=M[b+36>>2];if(c&32){g=M[e+52>>2];c=!(c&16)?g&-5:g}else{c=M[e+52>>2]&-8|1}c=c|256;M[e+52>>2]=c;h=M[e+60>>2];c=mj(M[e+44>>2],h,b,d+4|0,0,c);M[b+20>>2]=M[b+20>>2]+1;k=d,l=_b(b,f),M[k>>2]=l;K[b+95|0]=0;if((c|0)==19){break h}if(c){break g}c=M[d+4>>2]}f=ql(b,c);M[d+12>>2]=f;m:{if(!f){g=0;c=7;break m}g=1;c=0;if(!N[f+76|0]|N[f+77|0]==N[b+84|0]){break m}g=0;k=e,l=tb(b,13663,0),M[k+48>>2]=l;c=1}f=M[d+4>>2];j=M[f+4>>2];M[j+4>>2]=M[f>>2];Mr(M[j>>2],N[b+89|0]);Ym(M[d+4>>2],Ym(M[M[b+16>>2]+4>>2],-1));no(M[d+4>>2],M[b+32>>2]&56|3);K[d+8|0]=3;if(!g){break f}c=M[d>>2]?0:7;break f}k=e,l=tb(b,16471,0),M[k+48>>2]=l;c=1}K[d+8|0]=3}ip(h);if(!c){Fe(b);K[b+176|0]=0;M[b+24>>2]=M[b+24>>2]&-17;if(N[b+178|0]&4){break a}c=hp(b,e+48|0);if(!c){break a}}if(N[b+178|0]&4){d=M[e+48>>2];break e}d=M[b+20>>2]-1|0;f=M[(M[b+16>>2]+(d<<4)|0)+4>>2];if(f){Cf(f);f=M[b+16>>2]+(d<<4)|0;M[f+12>>2]=0;M[f+4>>2]=0}Jf(b);M[b+20>>2]=d;n:{if(!((c|0)!=3082&(c|0)!=7)){Lb(b);eb(b,M[e+48>>2]);d=tb(b,1162,0);break n}d=M[e+48>>2];if(d){break d}M[e>>2]=i;d=tb(b,8242,e)}M[e+48>>2]=d}if(!d){break c}}Pb(a,d,-1);eb(b,M[e+48>>2])}if(!c){break a}}ee(a,c)}Na=e- -64|0}function hi(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=Na-48|0;Na=g;M[g+44>>2]=M[a>>2];h=M[e>>2];M[g+40>>2]=h;l=M[f>>2];M[g+36>>2]=l;M[g+32>>2]=0;M[g+28>>2]=0;a:{b:{if(N[h|0]==1){o=h+1|0;k=K[h+1|0];c:{if((k|0)<0){h=yc(o,g+32|0);k=M[g+32>>2];break c}M[g+32>>2]=k;h=1}M[g+40>>2]=h+o;if(!k){break b}}if(N[l|0]==1){h=1;o=l+1|0;i=K[l+1|0];d:{if((i|0)<0){h=yc(o,g+28|0);i=M[g+28>>2];break d}M[g+28>>2]=i}M[g+36>>2]=h+o;if(!i){break b}}o=b;r=b>>31;s=(c|0)!=0;while(1){e:{f:{if((i|0)==(k|0)){k=M[g+44>>2];M[g+16>>2]=0;M[g+20>>2]=0;M[g+8>>2]=0;M[g+12>>2]=0;M[g>>2]=0;M[g+4>>2]=0;if(i){K[k|0]=1;b=k+1|0;t=g,u=uc(b,i,i>>31)+b|0,M[t+44>>2]=u}gi(g+40|0,g+8|0);h=M[g+8>>2];i=h-2|0;j=M[g+12>>2];b=j-(h>>>0<2)|0;n=b;M[g+8>>2]=i;M[g+12>>2]=b;gi(g+36|0,g);l=M[g>>2];b=l-2|0;p=M[g+4>>2];m=p-(l>>>0<2)|0;M[g>>2]=b;M[g+4>>2]=m;if(h>>>0<2&(j|0)<=0|(j|0)<0|(l>>>0<2&(p|0)<=0|(p|0)<0)){break e}while(1){h=n+r|0;l=i+o|0;h=l>>>0<o>>>0?h+1|0:h;g:{while(1){if(!((m|0)<=(n|0)&b>>>0<=i>>>0|(m|0)<(n|0)|d|((h|0)<=(m|0)&b>>>0>l>>>0|(h|0)<(m|0))?(b|0)!=(l|0)|(h|0)!=(m|0):0)){p=g+44|0;k=g+16|0;j=c?n:m;q=(c?i:b)+2|0;j=q>>>0<2?j+1|0:j;Ux(p,k,q,j);j=M[g+16>>2];p=M[g+20>>2]-(j>>>0<2)|0;j=j-2|0;M[g+16>>2]=j;M[g+20>>2]=p;k=0}if(!((b>>>0>i>>>0&(m|0)>=(n|0)|(m|0)>(n|0))&((h|0)<=(m|0)&b>>>0>l>>>0|(h|0)<(m|0)|s))){if(N[M[g+36>>2]]<2){break g}gi(g+36|0,g);j=M[g>>2];b=j-2|0;j=M[g+4>>2]-(j>>>0<2)|0;m=j;M[g>>2]=b;M[g+4>>2]=j;continue}break}if(N[M[g+40>>2]]<2){break g}gi(g+40|0,g+8|0);h=M[g+8>>2];i=h-2|0;h=M[g+12>>2]-(h>>>0<2)|0;n=h;M[g+8>>2]=i;M[g+12>>2]=h;continue}break}if(k){M[g+44>>2]=k}Ef(0,g+40|0);Ef(0,g+36|0);b=M[g+40>>2];if(!N[b|0]){break e}i=M[g+36>>2];if(!N[i|0]){break e}h=b+1|0;b=K[b+1|0];h:{if((b|0)<0){b=yc(h,g+32|0);break h}M[g+32>>2]=b;b=1}M[g+40>>2]=b+h;b=i+1|0;i=K[i+1|0];i:{if((i|0)<0){n=yc(b,g+28|0);break i}M[g+28>>2]=i;n=1}M[g+36>>2]=n+b;break f}if((i|0)>(k|0)){Ef(0,g+40|0);b=M[g+40>>2];if(!N[b|0]){break e}i=b+1|0;b=K[b+1|0];j:{if((b|0)<0){b=yc(i,g+32|0);break j}M[g+32>>2]=b;b=1}M[g+40>>2]=b+i;break f}Ef(0,g+36|0);b=M[g+36>>2];if(!N[b|0]){break e}i=b+1|0;b=K[b+1|0];k:{if((b|0)<0){b=yc(i,g+28|0);break k}M[g+28>>2]=b;b=1}M[g+36>>2]=b+i}i=M[g+28>>2];k=M[g+32>>2];continue}break}xe(0,g+36|0);xe(0,g+40|0);M[e>>2]=M[g+40>>2];M[f>>2]=M[g+36>>2];c=M[g+44>>2];b=0;if((c|0)==M[a>>2]){break a}K[c|0]=0;M[a>>2]=c+1;b=1;break a}b=0}Na=g+48|0;return b}function rG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=Na-128|0;Na=f;d=1;g=M[a>>2];a:{if(M[g+56>>2]){break a}i=b&65535;if(i){k=M[e>>2];d=1}else{d=0}if(b&65536){j=M[(d<<2)+e>>2];d=d+1|0}if(b&131072){m=M[(d<<2)+e>>2];d=d+1|0}l=b&262144?M[(d<<2)+e>>2]:l;kq(a);o=a,p=wy(m,0,-2147483648),M[o+72>>2]=p;M[a+76>>2]=Qa;o=a,p=wy(l,-1,2147483647),M[o+80>>2]=p;M[a+84>>2]=Qa;if(c){c=N[c|0]==68}else{c=N[g+239|0]}L[a+4>>1]=b;K[a+52|0]=c;b:{if(i>>>0>=2){h=gb(k);if(!h){d=O[k+16>>1];c=d&31;if((d&63)>>>0>=32){d=1<<c;e=0}else{e=1<<c;d=e-1&1>>>32-c}if(!(e&-1431655766|d&-1431655766)){break b}}M[a+20>>2]=0;d=0;if(j){d=sb(j);M[a+20>>2]=d}c=N[g+236|0];e=M[g+36>>2];j=M[g+28>>2];n=M[g+24>>2];M[f+108>>2]=0;M[f+100>>2]=0;M[f+104>>2]=0;M[f+96>>2]=i-2;M[f+92>>2]=n;M[f+84>>2]=j;M[f+80>>2]=d;M[f+76>>2]=e;M[f+88>>2]=c;e=a+16|0;c:{if(!h){c=0;M[e>>2]=0;break c}i=g+8|0;d=vy(f+76|0,h,yb(h),e,f+124|0);c=M[e>>2];d:{if(!(!M[f+108>>2]|d)){Le(c);M[e>>2]=0;break d}e:{if(d){break e}if(!c){c=0;break c}d=Yl(e,12);c=M[e>>2];if(d){break e}d=uy(c,12);if(!d){break c}}Le(c);M[e>>2]=0;if((d|0)==1){break d}if((d|0)!=18){break a}M[f+64>>2]=12;$d(i,25723,f- -64|0);d=1;break a}M[f+48>>2]=h;$d(i,18398,f+48|0);d=1;break a}d=M[a>>2];M[f+76>>2]=0;M[f+124>>2]=0;M[f+120>>2]=0;ty(a,c,f+124|0,f+120|0,f+76|0);f:{if(M[f+76>>2]){break f}c=M[f+124>>2];if(!N[d+236|0]|(c|0)<2){break f}d=S(c,24);c=Bb(d+(M[f+120>>2]<<3)|0,0);if(!c){M[f+76>>2]=7;break f}M[f+116>>2]=c;h=c+d|0;M[f+112>>2]=h;d=0;sy(a,0,M[a+16>>2],f+116|0,f+112|0,f+76|0);i=(M[f+116>>2]-c|0)/24|0;if(!M[f+76>>2]){j=M[f+112>>2]-h>>2;e=ry(a,0,c,i);while(1){if(!((d|0)>=(j|0)|e)){e=ry(a,M[h+(d<<2)>>2],c,i);d=d+1|0;continue}break}M[f+76>>2]=e}ab(c)}jq(a,M[a+16>>2],f+76|0);d=M[f+76>>2];Ne(g);if(d){break a}M[a+32>>2]=0;M[a+36>>2]=0;M[a+40>>2]=M[a+44>>2]}g:{h:{i:{switch(b&65535){case 0:b=M[g+224>>2];j:{if(l|m){c=M[a+72>>2];d=M[a+76>>2];e=N[a+52|0];h=M[a+84>>2];M[f+16>>2]=M[a+80>>2];M[f+20>>2]=h;M[f+24>>2]=e?20562:20976;M[f+8>>2]=c;M[f+12>>2]=d;M[f>>2]=b;b=Hb(7112,f);break j}c=N[a+52|0];M[f+32>>2]=b;M[f+36>>2]=c?20562:20976;b=Hb(7084,f+32|0)}if(!b){break b}M[g+56>>2]=M[g+56>>2]+1;d=wl(M[g+12>>2],b,1,a+12|0);M[g+56>>2]=M[g+56>>2]-1;ab(b);break h;case 1:break i;default:break g}}d=qy(a);if(d){break a}d=vp(M[a+12>>2],1,k)}if(d){break a}}d=py(a);break a}d=7}Na=f+128|0;return d|0}function Zh(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=Na-16|0;Na=e;M[e+8>>2]=b;M[e+12>>2]=a;k=N[c|0];i=N[c+1|0];l=N[c+3|0];a:{b:{c:while(1){b=M[e+12>>2];a=K[b|0];d:{if((a|0)>=0){M[e+12>>2]=b+1;break d}a=nd(e+12|0)}e:{f:{g:{if(a){if((a|0)==(k|0)){while(1){b=M[e+12>>2];a=K[b|0];h:{if((a|0)>=0){M[e+12>>2]=b+1;break h}a=nd(e+12|0)}if(!(!((a|0)==(i|0)&(i|0)!=0)&(a|0)!=(k|0))){if((a|0)!=(i|0)){continue}if(nd(e+8|0)){continue}break b}break}if(!a){g=0;break a}if((a|0)==(d|0)){if(N[c+2|0]){b=M[e+12>>2]-1|0;f=M[e+8>>2];while(1){h=N[f|0];if(!h){break b}g=Zh(b,f,c,d);if((g|0)!=1){break a}f=f+1|0;a=f;if(h>>>0<192){continue}while(1){g=K[a|0];f=a;a=a+1|0;if((g|0)<-64){continue}break}continue}}a=nd(e+12|0);if(!a){break b}}if(a>>>0<128){break e}f=M[e+12>>2];while(1){g=M[e+8>>2];b=K[g|0];i:{if((b|0)>=0){M[e+8>>2]=g+1;break i}b=nd(e+8|0)}if(!b){break b}if((a|0)!=(b|0)){continue}g=Zh(f,M[e+8>>2],c,d);if((g|0)==1){continue}break}break a}if((a|0)==(d|0)){j:{if(!N[c+2|0]){a=nd(e+12|0);if(a){break j}g=1;break a}g=1;j=nd(e+8|0);if(!j){break a}a=0;m=0;h=0;b=e+12|0;f=nd(b);if((f|0)==94){m=1;f=nd(b)}if((f|0)!=93){break g}h=(j|0)==93;b=0;break f}o=M[e+12>>2]}f=M[e+8>>2];b=K[f|0];k:{if((b|0)>=0){M[e+8>>2]=f+1;break k}b=nd(e+8|0)}if((a|0)==(b|0)){continue}if(!(!l|(a|b)>>>0>127)){if(N[(a&255)+31024|0]==N[(b&255)+31024|0]){continue}}g=1;if(!b|(a|0)!=(i|0)){break a}if(M[e+12>>2]!=(o|0)){continue}break a}g=N[M[e+8>>2]]!=0;break a}b=1}while(1){l:{m:{n:{o:{if(!b){a=0;break o}b=a;a=f;p:{if((a|0)!=45){if((a|0)==93){break m}if(!a){break a}break p}n=N[M[e+12>>2]];if(!b|(n|0)==93){break p}if(n){break n}}h=(a|0)==(j|0)?1:h}f=nd(e+12|0);b=1;continue}h=(p=h,q=nd(e+12|0)>>>0>=j>>>0?1:h,r=b>>>0>j>>>0,r?p:q);break l}if((h|0)!=(m|0)){continue c}break a}b=0;continue}}break}q:{if(l){K[e+7|0]=0;f=N[a+31024|0];a=(N[a+31408|0]^-1|-33)&a;break q}f=0}K[e+6|0]=f;K[e+5|0]=a;h=M[e+12>>2];a=M[e+8>>2];while(1){g=Na-32|0;Na=g;b=e+5|0;f=K[b|0];r:{if(!(N[b+1|0]?f:0)){b=fx(a,f);break r}Ml(g,32);f=N[b|0];if(f){while(1){i=g+(f>>>3&28)|0;M[i>>2]=M[i>>2]|1<<f;f=N[b+1|0];b=b+1|0;if(f){continue}break}}b=a;f=N[a|0];if(!f){break r}while(1){if(M[g+(f>>>3&28)>>2]>>>f&1){break r}f=N[b+1|0];b=b+1|0;if(f){continue}break}}Na=g+32|0;a=(b-a|0)+a|0;if(!N[a|0]){break b}a=a+1|0;g=Zh(h,a,c,d);if((g|0)==1){continue}break}break a}g=2}Na=e+16|0;return g}function KB(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,H=0;j=Na-48|0;Na=j;a:{if(!(N[M[a>>2]+33|0]&64)){break a}y=c?-126:-127;z=b+32|0;A=M[12800];B=M[12801];C=M[12798];D=M[12799];k=Dg(b);v=(c|0)!=0;E=v<<2;while(1){if(!k){break a}b:{if(e){if(!Zq(b,k,e,f)){break b}}h=M[a>>2];q=M[h+36>>2]&8?0:N[(k+v|0)+25|0];if(!!(M[h+32>>2]&524288)&(q|0)==7){break b}w=k+E|0;i=M[w+28>>2];c:{if(i|!q){break c}i=0;M[j+44>>2]=0;M[j+40>>2]=0;if(wi(a,b,k,j+44|0,j+40|0)){break c}m=0;l=(q|0)!=7;r=l&((c|0)!=0|(q|0)!=10);n=k+36|0;s=q-9|0;t=0;o=0;while(1){if(M[k+20>>2]>(i|0)){M[j+32>>2]=C;M[j+36>>2]=D;M[j+24>>2]=A;M[j+28>>2]=B;g=M[j+40>>2];p=M[(g?g+(i<<2)|0:n)>>2];g=z;u=M[b+4>>2];x=M[j+44>>2];if(x){g=M[x+4>>2]+(i<<1)|0}g=M[S(L[g>>1],12)+u>>2];M[j+8>>2]=g;F=j,H=jb(g),M[F+12>>2]=H;p=S(p,12);g=M[p+M[M[k>>2]+4>>2]>>2];M[j+16>>2]=g;F=j,H=jb(g),M[F+20>>2]=H;u=j+32|0;g=j+8|0;m=ce(a,m,ob(a,54,ob(a,142,Ec(h,60,u,0),Ec(h,60,g,0)),Ec(h,60,j+16|0,0)));if(c){o=ce(a,o,ob(a,45,ob(a,142,Ec(h,60,u,0),Ec(h,60,g,0)),ob(a,142,Ec(h,60,j+24|0,0),Ec(h,60,g,0))))}if(r){d:{e:{f:{switch(s|0){case 1:g=ob(a,142,Ec(h,60,j+24|0,0),Ec(h,60,j+8|0,0));break d;case 0:break f;default:break e}}g=M[k>>2];p=M[g+4>>2]+p|0;if(N[p+10|0]&96){break e}g=Tc(g,p);if(!g){break e}g=qb(h,g,0);break d}g=Ec(h,122,0,0)}t=Wb(a,t,g);Fg(a,t,j+16|0,0)}i=i+1|0;continue}break}eb(h,M[j+40>>2]);r=0;s=M[M[k>>2]>>2];n=jb(s);g:{if(l){g=m;m=0;break g}g=Mb(h,M[b+60>>2]);l=ob(a,72,wc(h,118,16092),0);if(l){K[l+1|0]=2}i=Od(a,0,0,0);if(i){F=i,H=_b(h,s),M[F+8>>2]=H;F=i,H=_b(h,M[M[h+16>>2]+(g<<4)>>2]),M[F+52>>2]=H}g=0;m=td(a,ed(M[a>>2],l),i,m,0,0,0,0,0)}L[h+308>>1]=0;M[h+304>>2]=M[h+304>>2]+1;i=ub(h,n+85|0,0);h:{if(!i){break h}l=i+84|0;M[i+48>>2]=l;r=i+36|0;M[i+28>>2]=r;if(n){G(l,s,n)}F=i,H=qb(h,g,1),M[F+56>>2]=H;F=i,H=xc(h,t,1),M[F+60>>2]=H;F=i,H=le(h,m,1),M[F+44>>2]=H;if(!o){o=0;break h}o=ob(a,19,o,0);F=i,H=qb(h,o,1),M[F+12>>2]=H}n=M[h+304>>2]-1|0;M[h+304>>2]=n;L[h+308>>1]=n?0:O[h+310>>1];kb(h,g);kb(h,o);xb(h,t);pc(h,m);if(N[h+87|0]==1){Vi(h,i);i=0;break c}g=139;i:{j:{k:{switch(q-7|0){case 3:break k;case 0:break i;default:break j}}if(c){break j}g=129;break i}g=130}M[r+4>>2]=i;K[r|0]=g;g=M[b+60>>2];M[i+24>>2]=g;M[i+20>>2]=g;M[w+28>>2]=i;K[i+8|0]=y}if(!i){break b}Uz(a,i,b,d,2,0)}k=M[k+12>>2];continue}}Na=j+48|0}function hy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;c=Na-128|0;Na=c;M[c+20>>2]=0;a:{d=Tb(a,27,c+20|0,0);if(d){break a}e=M[c+20>>2];fd(e,1,M[a+288>>2]);fd(e,2,M[a+260>>2]);d=0;while(1){b:{c:{if(d){break c}if((Db(e)|0)!=100){break c}d=0;m=Md(e,0);e=0;while(1){if(M[a+260>>2]<=(e|0)){break b}j=0;k=0;if(!d){M[c+120>>2]=0;M[c+124>>2]=19;M[c+112>>2]=0;M[c+116>>2]=0;d:{g=c+48|0;d=mi(a,m,e,-2,0,0,0,1,g);if(d){break d}d=Vj(a,g,c+112|0);if(d){break d}e:while(1){d=li(a,c+48|0);if((d|0)!=100){break d}h=M[c+108>>2];d=M[c+104>>2];g=0;f=0;M[c+40>>2]=0;M[c+44>>2]=0;M[c+32>>2]=0;M[c+36>>2]=0;l=d+h|0;d=Ic(d,c+40|0)+d|0;while(1){if(d>>>0>=l>>>0){continue e}M[c+24>>2]=0;M[c+28>>2]=0;d=Ic(d,c+24|0)+d|0;if(l>>>0<=d>>>0){continue}i=M[c+28>>2];h=M[c+24>>2];if(!i&h>>>0<=1){M[c+32>>2]=0;M[c+36>>2]=0;if(h|i){d=Ic(d,c+32|0)+d|0;g=0;f=0;continue}d=Ic(d,c+24|0)+d|0;h=M[c+24>>2];f=M[c+28>>2];g=M[c+40>>2];i=M[c+44>>2];if(N[a+239|0]){M[c+40>>2]=g-h;M[c+44>>2]=i-((g>>>0<h>>>0)+f|0);g=0;f=0;continue}f=f+i|0;i=g;g=g+h|0;f=i>>>0>g>>>0?f+1|0:f;M[c+40>>2]=g;M[c+44>>2]=f;g=0;f=0}else{n=M[c+96>>2];o=M[c+100>>2];p=M[c+40>>2];q=M[c+44>>2];r=M[c+32>>2];f=f+i|0;i=h;h=g+h|0;f=(i>>>0>h>>>0?f+1|0:f)-(h>>>0<2)|0;g=h-2|0;j=Wp(n,o,m,e,p,q,r,g)^j;k=k^Qa}continue}}}eh(c+48|0)}e=e+1|0;t=j^t;u=k^u;continue}}j=0;k=0;e=wb(e);if(d){break a}if(e){d=e;break a}n=M[M[a+36>>2]>>2];M[c>>2]=M[a+224>>2];e=Hb(7325,c);f:{if(!e){d=7;e=0;break f}d=th(M[a+12>>2],e,-1,c+48|0,0);ab(e);e=M[c+48>>2]}g:while(1){h:{if(d){break h}if((Db(e)|0)!=100){break h}d=0;m=dd(e,0);o=Qa;l=dq(a,e);h=0;while(1){if(d){continue g}g=h;if((h|0)>=M[a+24>>2]){continue g}h=h+1|0;d=0;if(N[g+M[a+32>>2]|0]){continue}d=ff(e,h);f=pg(M[a+36>>2],l,d,-1,c+112|0);i=M[c+112>>2];i:while(1){if(!f){M[c+32>>2]=0;M[c+24>>2]=0;M[c+16>>2]=0;M[c+12>>2]=0;f=Ra[M[n+20>>2]](i,c+40|0,c+32|0,c+24|0,c+16|0,c+12|0)|0;if(f){continue}p=M[c+40>>2];q=M[c+32>>2];r=M[c+12>>2];j=Wp(p,q,l,0,m,o,g,r)^j;k=k^Qa;d=1;s=M[a+260>>2];s=(s|0)<=1?1:s;while(1){if((d|0)==(s|0)){continue i}v=M[M[a+264>>2]+S(d,24)>>2];if((v|0)<=(q|0)){j=Wp(p,v,l,d,m,o,g,r)^j;k=k^Qa}d=d+1|0;continue}}break}if(i){Ra[M[n+16>>2]](i)|0}d=(f|0)!=101?f:0;continue}}break}cd(e);break a}e=M[c+20>>2];continue}}M[b>>2]=!d&((j|0)==(t|0)&(k|0)==(u|0));Na=c+128|0;return(d|0)!=267?d:0}function Wu(a){var b=0,c=0,d=0,e=0,f=0,g=0;c=Na-32|0;Na=c;a:{b:{b=M[a+232>>2];c:{d:{e:{if(!b){f:{if(N[a+17|0]){break f}b=Uo(a,1);if(b){break c}g:{h:{if(N[a+18|0]<=1){d=M[a>>2];f=1;M[c>>2]=1;g=M[M[a+68>>2]>>2];if(!g){b=Ra[M[d+32>>2]](d,M[a+188>>2],0,c)|0;if(b|!M[c>>2]){break h}}M[c+28>>2]=0;b=M[a+64>>2];b=Ra[M[M[b>>2]+36>>2]](b,c+28|0)|0;i:{if(b|M[c+28>>2]){break i}b=No(a,c+24|0);if(b){break i}if(!(M[c+24>>2]|g)){b=M[18582];if(b){Ra[b|0]()}j:{if($f(a,2)){break j}b=M[d+28>>2];if(b){Ra[b|0](d,M[a+188>>2],0)|0}if(N[a+4|0]){break j}Og(a,1)}b=0;d=M[18583];if(!d){break i}Ra[d|0]();break i}k:{if(!g){M[c+20>>2]=2049;b=Ra[M[d+24>>2]](d,M[a+188>>2],M[a+68>>2],2049,c+20|0)|0;if((b|0)==14){break k}if(b){break i}}K[c+20|0]=0;b=M[a+68>>2];f=Ra[M[M[b>>2]+8>>2]](b,c+20|0,1,0,0)|0;d=(f|0)==522;l:{if(g){break l}b=M[a+68>>2];g=M[b>>2];if(!g){break l}Ra[M[g+4>>2]](b)|0;M[b>>2]=0}b=d?0:f;f=!N[c+20|0];break i}f=0;b=0}if(b){break c}if(f){break g}}b=776;if(N[a+14|0]){break c}b=$f(a,4);if(b){break c}m:{n:{o:{if(!M[M[a+68>>2]>>2]){b=0;if(N[a+5|0]==2){break o}d=M[a>>2];b=Ra[M[d+32>>2]](d,M[a+188>>2],0,c)|0;f=M[a+68>>2];if(!(!M[c>>2]|b)){M[c+28>>2]=0;b=Ra[M[d+24>>2]](d,M[a+188>>2],f,2050,c+28|0)|0;p:{if(b){break p}b=0;if(!(K[c+28|0]&1)){break p}b=ne(62640);f=M[a+68>>2];d=M[f>>2];if(!d){break p}Ra[M[d+4>>2]](f)|0;M[f>>2]=0}f=M[a+68>>2]}if(!M[f>>2]){break o}}b=yv(a);if(b){break m}b=So(a,!N[a+12|0]);K[a+17|0]=0;break n}if(N[a+4|0]){break n}Og(a,1)}if(!b){break g}}b=Tj(a,b);break c}if(b){break c}}if(N[a+12|0]){break f}if(N[a+24|0]){b=M[a+64>>2];b=Ra[M[M[b>>2]+8>>2]](b,c,16,24,0)|0;if(b){if((b|0)!=522){break d}M[c+8>>2]=0;M[c+12>>2]=0;M[c>>2]=0;M[c+4>>2]=0}if(Qb(a+112|0,c,16)){Qg(a)}if(N[a+12|0]){break f}}b=M[a>>2];e=Ra[M[b+32>>2]](b,M[a+236>>2],0,c)|0;if(e){break f}q:{if(M[c>>2]){e=No(a,c+28|0);if(e){break f}if(!M[c+28>>2]){b=M[a>>2];e=M[b+28>>2];if(e){break q}e=0;break f}e=Vu(a,0);break f}e=0;if(N[a+5|0]!=5){break f}K[a+5|0]=0;break f}e=Ra[e|0](b,M[a+236>>2],0)|0}b=M[a+232>>2];if(!b){break e}}M[c+28>>2]=0;Xo(b);b=M[a+232>>2];M[c>>2]=0;while(1){e=tv(b,c+28|0,0,c);if((e|0)==-1){continue}break}if(!(M[c+28>>2]|e)){break e}Qg(a)}if(!(N[a+12|0]|N[a+17|0])){b=e;if(b){break d}b=No(a,a+28|0);break d}b=e}if(!b){break b}}kl(a);break a}K[a+24|0]=1;K[a+17|0]=1;b=0}Na=c+32|0;return b}function xD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;k=Na-112|0;Na=k;m=Ra[M[17020]]()|0;h=M[a+36>>2];a:{b:{if(h){f=M[h>>2];break b}j=Bb(16,0);if(!j){g=7;break a}M[j>>2]=0;M[j+4>>2]=0;M[j+8>>2]=0;M[j+12>>2]=0;c:{l=M[a+8>>2];f=M[l+40>>2];if(f){break c}o=M[a+32>>2];d:{if(Ra[M[16960]](M[a+12>>2],k+16|0)|0){g=1802;break d}i=yb(o);h=i+74|0;f=Bb(h,0);if(!f){g=7;break d}if(h){D(f,0,h)}h=f+68|0;M[f+8>>2]=h;M[k>>2]=o;i=vd(i+6|0,h,11588,k);M[f+12>>2]=-1;h=M[a+8>>2];M[h+40>>2]=f;M[f>>2]=h;if(N[67468]){M[f+4>>2]=8}if(N[l+29|0]){break c}e:{if(!Rk(M[a+32>>2],11575,0)){g=Ah(i,131138,M[k+20>>2]&511);M[f+12>>2]=g;break e}g=M[f+12>>2]}if((g|0)<0){g=Ah(i,131072,M[k+20>>2]&511);M[f+12>>2]=g;if((g|0)<0){g=Qd(ne(43342),11387,i,43342);break d}K[f+22|0]=1}i=M[k+32>>2];h=M[k+28>>2];if(!(Ra[M[17008]]()|0)){Ra[M[17005]](g,h,i)|0}g=Jv(a,f);if((g|0)==1288|!g){break c}}Iv(a);ab(j);break a}M[j>>2]=f;M[f+28>>2]=M[f+28>>2]+1;M[a+36>>2]=j;M[j+4>>2]=M[f+32>>2];M[f+32>>2]=j;if(g){break a}}f:{if(N[f+23|0]){g=Jv(a,f);if(g){break f}K[f+23|0]=0}g=0;n=((m|0)<=32768?32768:m)>>>15|0;a=n+b|0;j=a-((a|0)%(n|0)|0)|0;if((j|0)<=O[f+20>>1]){break f}M[f+16>>2]=c;g:{h:{a=M[f+12>>2];if((a|0)<0){break h}if(Ra[M[16960]](a,k+16|0)|0){g=4874;break f}i=M[k+44>>2];l=S(c,j);h=l>>31;a=M[k+40>>2];if((i|0)>=(h|0)&l>>>0<=a>>>0|(h|0)<(i|0)){break h}if(!d){break f}d=_J(a,i,4096,0);a=(l|0)/4096|0;h=(a|0)>(d|0)?a:d;l=h>>31;a=d>>31;while(1){if((d|0)==(h|0)&(a|0)==(l|0)){break h}if((Hv(M[f+12>>2],d<<12|4095,a<<12|d>>>20,30808,1,k+12|0)|0)!=1){break g}d=d+1|0;a=d?a:a+1|0;continue}}a=ww(M[f+24>>2],j<<2);if(!a){g=3082;break f}M[f+24>>2]=a;d=S(c,n);o=d>>31;a=O[f+20>>1];l=c>>31;while(1){a=a&65535;if((j|0)<=(a|0)){break f}i=M[f+12>>2];i:{if((i|0)>=0){m=(q=0,r=d,s=N[f+22|0]?1:3,t=1,u=i,v=ZJ(a,0,c,l),w=Qa,p=M[17011],Ra[p](q|0,r|0,s|0,t|0,u|0,v|0,w|0)|0);if((m|0)!=-1){break i}g=5386;Qd(5386,10022,M[f+8>>2],43513);break f}m=Bb(d,o);if(!m){g=7;break f}if(!d){break i}D(m,0,d)}i=O[f+20>>1];h=M[f+24>>2]+(i<<2)|0;a=0;while(1){if((a|0)!=(n|0)){M[h+(a<<2)>>2]=S(a,c)+m;a=a+1|0;continue}break}a=i+n|0;L[f+20>>1]=a;continue}}g=4874;Qd(4874,13180,M[f+8>>2],43486)}M[e>>2]=O[f+20>>1]>(b|0)?M[M[f+24>>2]+(b<<2)>>2]:0;g=g?g:N[f+22|0]?8:g}Na=k+112|0;return g|0}function Hs(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Na-80|0;Na=g;j=M[a>>2];a:{if(N[j+87|0]){break a}if(de(a)){break a}if(d){K[j+91|0]=N[j+91|0]+1}e=mf(a,c,b+8|0);b:{if(!d){if(!e){break a}break b}K[j+91|0]=N[j+91|0]-1;if(e){break b}Pi(a,M[b+52>>2]);Ek(a);break a}h=Mb(j,M[e+60>>2]);if(N[e+43|0]==1){if(lf(a,e)){break a}}d=(h|0)==1;f=M[M[j+16>>2]+(h<<4)>>2];if(gc(a,9,d?9290:9309,0,f)){break a}c:{if(c){d=d?15:17}else{if(N[e+43|0]==1){d=30;i=M[M[Gd(j,e)+4>>2]+4>>2];break c}d=(h|0)==1?13:11}i=0}if(gc(a,d,M[e>>2],i,f)){break a}if(gc(a,9,M[e>>2],0,f)){break a}d:{d=M[e>>2];e:{f:{if(!Eb(d,18301,7)){f=d+7|0;if(!Eb(f,3606,4)){break d}f=Eb(f,4474,10);break f}f=M[e+28>>2];if(f&4096){if(vh(j)){break e}}f=f&32768}if(!f){break d}}M[g+64>>2]=d;cb(a,15971,g- -64|0);break a}f=N[e+43|0];g:{if(c){if((f|0)==2){break g}M[g+48>>2]=d;cb(a,7050,g+48|0);break a}if((f|0)!=2){break g}M[g>>2]=d;cb(a,6496,g);break a}if(!Cb(a)){break a}jd(a,1,h);h:{if(c){break h}Ys(a,h,11855,M[e>>2]);i=M[a>>2];if(N[e+43|0]|!(N[i+33|0]&64)){break h}f=Cb(a);d=0;if(!Dg(e)){d=e+48|0;while(1){d=M[d>>2];if(!d){break h}if(!N[d+24|0]){d=d+4|0;if(!(N[i+34|0]&8)){continue}}break}d=M[a+60>>2]-1|0;M[a+60>>2]=d;$a(f,49,1,d)}K[a+165|0]=1;Fn(a,xh(i,b,0),0);K[a+165|0]=0;if(!(N[i+34|0]&8)){$a(f,49,0,M[f+108>>2]+2|0);Ii(a,787,2,0,-1,4)}if(!d){break h}pb(f,d)}i=M[a>>2];d=M[i+16>>2];k=Cb(a);jd(a,1,h);if(N[e+43|0]==1){Ub(k,170)}f=d+(h<<4)|0;d=ps(a,e);while(1){if(d){$s(a,d);d=M[d+32>>2];continue}break}if(N[e+28|0]&8){d=M[f>>2];M[g+36>>2]=M[e>>2];M[g+32>>2]=d;sc(a,19703,g+32|0)}d=M[f>>2];M[g+20>>2]=M[e>>2];M[g+16>>2]=d;sc(a,28211,g+16|0);d=N[e+43|0];i:{j:{if(!c){if((d|0)==1){break j}f=e+8|0;m=M[e+20>>2];d=0;while(1){n=d-1|0;d=n>>>0>=m>>>0?m:0;c=f;while(1){c=M[c>>2];if(c){l=M[c+44>>2];d=l>>>0>n>>>0?d:d>>>0<l>>>0?l:d;c=c+20|0;continue}break}if(d){Xs(a,d,Mb(M[a>>2],M[e+60>>2]));continue}break}d=N[e+43|0]}if((d&255)!=1){break i}}nb(k,172,h,0,0,M[e>>2],0);c=M[a+132>>2];K[(c?c:a)+21|0]=1}nb(k,151,h,0,0,M[e>>2],0);Sf(a,h);a=M[(M[i+16>>2]+(h<<4)|0)+12>>2];if(!(N[a+78|0]&2)){break a}a=a+16|0;while(1){a=M[a>>2];if(a){c=M[a+8>>2];if(N[c+43|0]!=2){continue}Vn(i,c);continue}break}a=M[(M[i+16>>2]+(h<<4)|0)+12>>2];L[a+78>>1]=O[a+78>>1]&65533}Gc(j,b);Na=g+80|0}function Wm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;i=Na-16|0;Na=i;M[i+12>>2]=0;M[i+4>>2]=0;o=M[b+12>>2];g=N[a+23|0];if(!mB(a,b)){q=Ar(a,b);j=M[a>>2];k=Zc(M[b+12>>2]);r=ub(j,k<<2,0);a:{if(N[M[a>>2]+87|0]){break a}f=M[a+8>>2];s=(c|0)!=(d|0);m=Rm(a,b,3,s?i+12|0:0,r,i+4|0);K[a+23|0]=0;t=Gr(a,o,i+8|0);K[a+23|0]=g;g=(k|0)>0?k:0;while(1){b:{if((e|0)==(g|0)){e=g;break b}if(M[(e<<2)+r>>2]!=(e|0)){break b}e=e+1|0;continue}break}h=t;c:{if((e|0)==(k|0)){break c}h=vc(a,k);e=0;while(1){if((e|0)==(g|0)){break c}bb(f,80,e+t|0,M[(e<<2)+r>>2]+h|0,0);e=e+1|0;continue}}d:{if((m|0)==5){o=M[a+60>>2]-1|0;M[a+60>>2]=o;n=M[b+20>>2];e=0;m=Fd(a,M[b+12>>2]);b=0;if((c|0)!=(d|0)){b=Gb(a);bb(f,103,h,h,b)}l=n+8|0;while(1){if((e|0)<M[n>>2]){j=l+(e<<4)|0;g=Oc(a,M[j>>2],i);e:{if(!b){break e}if(!hf(M[j>>2])){break e}bb(f,103,b,g,b)}zb(a,M[i>>2]);f:{g:{if(!(!s&(M[n>>2]-1|0)<=(e|0))){nb(f,(h|0)==(g|0)?52:54,h,o,g,m,-2);g=M[f+108>>2];if((g|0)<=0){break f}j=N[q|0];break g}nb(f,(h|0)==(g|0)?51:53,h,c,g,m,-2);g=M[f+108>>2];if((g|0)<=0){break f}j=N[q|0]|16}L[(M[f+104>>2]+S(g,20)|0)-18>>1]=j<<24>>24}e=e+1|0;continue}break}if(b){$a(f,51,b,d);Xb(f,c)}pb(f,o);zb(a,b);break d}e=0;j=c;if((c|0)!=(d|0)){l=M[a+60>>2]-1|0;M[a+60>>2]=l;j=l}while(1){if((e|0)!=(g|0)){if(M[a+40>>2]){break a}if(hf(Ag(M[b+12>>2],e))){$a(f,51,e+h|0,j)}e=e+1|0;continue}break}h:{if((m|0)==1){p=M[i+4>>2];bb(f,30,p,c,h);j=Ub(f,9);break h}nb(f,96,h,k,0,q,k);if(!s){i:{if(!(N[b+7|0]&2)){break i}e=74356;e=N[M[f>>2]+87|0]?e:M[f+104>>2]+S(M[b+44>>2],20)|0;if(N[e|0]!=15){break i}b=M[e+12>>2];if((b|0)<=0){break i}lb(f,64,b,c,h,k)}lb(f,28,M[i+4>>2],c,h,k);break d}p=M[i+4>>2];j=lb(f,29,p,0,h,k)}j:{if((k|0)!=1){break j}b=M[i+12>>2];if(!b){break j}$a(f,52,b,c)}if(!s){Xb(f,c)}if(l){pb(f,l)}m=$a(f,36,p,c);b=c;if((k|0)>=2){b=M[a+60>>2]-1|0;M[a+60>>2]=b}e=0;while(1){if((e|0)!=(g|0)){n=Gb(a);l=Fd(a,Ag(o,e));bb(f,94,p,e,n);nb(f,53,e+h|0,b,n,l,-2);zb(a,n);e=e+1|0;continue}break}$a(f,9,0,d);if((k|0)>=2){pb(f,b);$a(f,39,p,m+1|0);$a(f,9,0,c)}b=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(j,20)|0)+8>>2]=b}if((h|0)==(t|0)){break a}zb(a,h)}eb(M[a>>2],r);eb(M[a>>2],q)}Na=i+16|0}function jH(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;k=Na-16|0;Na=k;i=b+8|0;j=a-8|0;a:{if(!j){d=Je(i);break a}if(i>>>0>=4294967232){M[18595]=48;d=0;break a}f=i>>>0<11?16:i+11&-8;a=0;e=j-8|0;h=M[e+4>>2];c=h&-8;b:{if(!(h&3)){if(f>>>0<256){break b}if(c>>>0>=f+4>>>0){a=e;if(c-f>>>0<=M[18716]<<1>>>0){break b}}a=0;break b}g=c+e|0;c:{if(c>>>0>=f>>>0){a=c-f|0;if(a>>>0<16){break c}M[e+4>>2]=h&1|f|2;d=e+f|0;M[d+4>>2]=a|3;M[g+4>>2]=M[g+4>>2]|1;Kl(d,a);break c}if(M[18602]==(g|0)){d=c+M[18599]|0;if(d>>>0<=f>>>0){break b}M[e+4>>2]=h&1|f|2;a=e+f|0;d=d-f|0;M[a+4>>2]=d|1;M[18599]=d;M[18602]=a;break c}if(M[18601]==(g|0)){c=c+M[18598]|0;if(c>>>0<f>>>0){break b}a=c-f|0;d:{if(a>>>0>=16){M[e+4>>2]=h&1|f|2;d=e+f|0;M[d+4>>2]=a|1;c=c+e|0;M[c>>2]=a;M[c+4>>2]=M[c+4>>2]&-2;break d}M[e+4>>2]=c|h&1|2;a=c+e|0;M[a+4>>2]=M[a+4>>2]|1;a=0}M[18601]=d;M[18598]=a;break c}d=M[g+4>>2];if(d&2){break b}l=c+(d&-8)|0;if(l>>>0<f>>>0){break b}n=l-f|0;c=M[g+12>>2];e:{if(d>>>0<=255){a=M[g+8>>2];if((a|0)==(c|0)){p=74384,q=M[18596]&cK(-2,d>>>3|0),M[p>>2]=q;break e}M[a+12>>2]=c;M[c+8>>2]=a;break e}m=M[g+24>>2];f:{if((c|0)!=(g|0)){a=M[g+8>>2];M[a+12>>2]=c;M[c+8>>2]=a;break f}g:{a=M[g+20>>2];if(a){d=g+20|0}else{a=M[g+16>>2];if(!a){break g}d=g+16|0}while(1){o=d;c=a;d=a+20|0;a=M[a+20>>2];if(a){continue}d=c+16|0;a=M[c+16>>2];if(a){continue}break}M[o>>2]=0;break f}c=0}if(!m){break e}a=M[g+28>>2];d=(a<<2)+74688|0;h:{if(M[d>>2]==(g|0)){M[d>>2]=c;if(c){break h}p=74388,q=M[18597]&cK(-2,a),M[p>>2]=q;break e}i:{if(M[m+16>>2]==(g|0)){M[m+16>>2]=c;break i}M[m+20>>2]=c}if(!c){break e}}M[c+24>>2]=m;a=M[g+16>>2];if(a){M[c+16>>2]=a;M[a+24>>2]=c}a=M[g+20>>2];if(!a){break e}M[c+20>>2]=a;M[a+24>>2]=c}if(n>>>0<=15){M[e+4>>2]=h&1|l|2;a=e+l|0;M[a+4>>2]=M[a+4>>2]|1;break c}M[e+4>>2]=h&1|f|2;a=e+f|0;M[a+4>>2]=n|3;d=e+l|0;M[d+4>>2]=M[d+4>>2]|1;Kl(a,n)}a=e}d=a+8|0;if(a){break a}e=Je(i);d=0;if(!e){break a}a=M[j-4>>2];a=(a&3?-4:-8)+(a&-8)|0;Ll(e,j,a>>>0<i>>>0?a:i);Ie(j);d=e}a=d;j:{if(a){M[a>>2]=b;M[a+4>>2]=b>>31;a=a+8|0;break j}a=M[j>>2];M[k+4>>2]=b;M[k>>2]=a;Lc(7,5389,k);a=0}Na=k+16|0;return a|0}function yi(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;k=Na-208|0;Na=k;v=(c|0)!=130;while(1){if(b){l=N[b+8|0];a:{if((l|0)!=(c|0)&(!N[b+10|0]|v|(l|0)!=128)|N[b+9|0]!=(e|0)){break a}if(!Yq(M[b+16>>2],d)){break a}if(!N[b+10|0]){Uz(a,b,f,g,h,i);break a}if(M[a+132>>2]|!N[a+163|0]){break a}q=M[a+148>>2];if((q+8|0)!=(b|0)){break a}s=M[a>>2];t=M[a+8>>2];l=k+100|0;D(l,0,76);j=k+40|0;D(j,0,56);w=k,x=xc(s,M[q+4>>2],0),M[w+128>>2]=x;M[k+40>>2]=1;M[k+132>>2]=j;M[k+56>>2]=f;j=M[f>>2];M[k+64>>2]=-1;M[k+48>>2]=j;je(a,l,0);if(!M[a+40>>2]){ns(a,l)}xb(s,M[k+128>>2]);r=M[q+4>>2];u=r+8|0;n=M[a>>2];o=0;l=0;while(1){if((o|0)<M[r>>2]){m=u+(o<<4)|0;j=M[m>>2];b:{if(!j){break b}c:{p=N[j|0];if((p|0)!=180){if((p|0)!=142|N[M[j+16>>2]]!=180){break c}cb(a,5946,0)}j=0;while(1){if(L[f+34>>1]<=(j|0)){break b}p=S(j,12);m=p+M[f+4>>2]|0;d:{if(N[m+10|0]&2){break d}l=Wb(a,l,wc(n,60,M[m>>2]));if(N[n+87|0]){break d}m=(M[l>>2]<<4)+l|0;w=m-4|0,x=_b(n,M[p+M[f+4>>2]>>2]),M[w>>2]=x;p=(N[m+1|0]|N[m+2|0]<<8)&65532;K[m+1|0]=p;K[m+2|0]=p>>>8}j=j+1|0;continue}}l=Wb(a,l,qb(n,j,0));if(N[n+87|0]){break b}p=M[m+4>>2];if(!p){break b}j=(M[l>>2]<<4)+l|0;w=j-4|0,x=_b(n,p),M[w>>2]=x;m=(N[j+1|0]|N[j+2|0]<<8)&65532|(N[m+9|0]|N[m+10|0]<<8)&3;K[j+1|0]=m;K[j+2|0]=m>>>8}o=o+1|0;continue}break}e:{if(M[a+40>>2]){break e}D(k+4|0,0,36);if(!M[q+96>>2]){M[q+96>>2]=M[l>>2];j=M[a+44>>2];M[a+44>>2]=j+1;M[q+92>>2]=j}M[k+28>>2]=1024;M[k+12>>2]=g;M[k+4>>2]=a;j=N[b+8|0];M[a+136>>2]=f;K[a+162|0]=j;if(Te(k+4|0,l)|N[s+87|0]){break e}n=M[l>>2];j=M[a+48>>2];M[k+184>>2]=0;M[k+188>>2]=0;M[k+192>>2]=0;M[k+196>>2]=0;M[k+184>>2]=79;M[k+176>>2]=0;M[k+180>>2]=0;M[k+200>>2]=f;M[k+180>>2]=65;o=k+176|0;ec(o,l);if(O[k+196>>1]){M[k+184>>2]=46;M[k+180>>2]=80;ec(o,l)}M[a+48>>2]=(n+M[a+48>>2]|0)+2;o=j+1|0;M[q+100>>2]=o;j=0;n=(n|0)>0?n:0;m=l+8|0;while(1){if((j|0)!=(n|0)){r=M[m+(j<<4)>>2];u=j+o|0;pk(a,r,u);if((rc(r)|0)==69){fb(t,87,u)}j=j+1|0;continue}break}j=n+o|0;bb(t,97,o,n,j);n=j+1|0;$a(t,127,M[q+92>>2],n);bb(t,128,M[q+92>>2],j,n)}xb(s,l);M[a+136>>2]=0;K[a+162|0]=0}b=M[b+32>>2];continue}break}Na=k+208|0}function RG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;k=M[a+4>>2];o=k+M[a+8>>2]|0;k=k+M[a+12>>2]|0;p=M[a>>2];while(1){q=k;if(k>>>0>=o>>>0){return 101}k=q+1|0;g=N[q|0];if(g>>>0>=192){h=N[g+33440|0];while(1){a:{if(k>>>0>=o>>>0){k=o;break a}g=N[k|0];if((g&192)!=128){break a}h=g&63|h<<6;k=k+1|0;continue}break}g=(h&-2)==65534?65533:h>>>0<128?65533:(h&-2048)==55296?65533:h}if(!Wy(p,g)){continue}break}i=M[a+20>>2];j=i;while(1){h=M[a+24>>2];if((h-4|0)<=(j-i|0)){h=h- -64|0;h=Mc(i,h,h>>31);if(!h){return 7}i=M[a+20>>2];M[a+20>>2]=h;M[a+24>>2]=M[a+24>>2]- -64;j=h+(j-i|0)|0}b:{c:{d:{e:{f:{if((g|0)<=127){if(g-65>>>0>=26){break f}g=g|32;break e}if(g>>>0>65535){break d}r=M[p+4>>2];h=162;l=-1;i=0;while(1){if((h|0)>=(i|0)){m=(h+i|0)/2|0;n=O[(m<<2)+55632>>1]>(g|0);h=n?m-1|0:h;l=n?l:m;i=n?i:m+1|0;continue}break}i=l<<2;l=i+55632|0;h=O[l>>1];g:{if((h+N[i+55635|0]|0)<=(g|0)){break g}i=g^h;h=N[l+2|0];if(i&h&1){break g}g=O[(h&254)+56288>>1]+g&65535}if(!r){break f}s=g<<3|7;h=125;l=0;i=0;while(1){if((h|0)>=(i|0)){m=(h+i|0)/2|0;n=O[(m<<1)+56448>>1]>s>>>0;i=n?i:m+1|0;h=n?m-1|0:h;l=n?l:m;continue}break}i=l+56704|0;if((r|0)!=2&K[i|0]<0){break f}h=O[(l<<1)+56448>>1];if((h>>>3|0)+(h&7)>>>0<g>>>0){break e}g=N[i|0]&127}if(!g){break b}}if((g|0)<=127){K[j|0]=g;j=j+1|0;break b}if(g>>>0<=2047){K[j+1|0]=g&63|128;K[j|0]=g>>>6|192;j=j+2|0;break b}if(g>>>0>65535){break c}K[j+2|0]=g&63|128;K[j|0]=g>>>12|224;K[j+1|0]=g>>>6&63|128;j=j+3|0;break b}g=g-66560>>>0<40?g+40|0:g}K[j+3|0]=g&63|128;K[j+2|0]=g>>>6&63|128;K[j+1|0]=g>>>12&63|128;K[j|0]=g>>>18&7|240;j=j+4|0}h:{if(k>>>0>=o>>>0){h=k;break h}h=k+1|0;g=N[k|0];if(g>>>0>=192){i=N[g+33440|0];while(1){i:{if(h>>>0>=o>>>0){h=o;break i}g=N[h|0];if((g&192)!=128){break i}i=g&63|i<<6;h=h+1|0;continue}break}g=(i&-2)==65534?65533:i>>>0<128?65533:(i&-2048)==55296?65533:i}if(!Wy(p,g)){if(!sq(g)){break h}}i=M[a+20>>2];k=h;continue}break}M[a+12>>2]=h-M[a+4>>2];h=b;b=M[a+20>>2];M[h>>2]=b;M[c>>2]=j-b;b=M[a+4>>2];M[d>>2]=q-b;M[e>>2]=k-b;b=a;a=M[a+16>>2];M[b+16>>2]=a+1;M[f>>2]=a;return 0}function cl(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Na-16|0;Na=h;k=M[a+224>>2];i=M[(d?68:72)+a>>2];f=sf(i,M[b>>2],M[b+4>>2],h+8|0);a:{if(f){break a}g=M[a+168>>2];f=M[b+4>>2];j=M[b>>2]+4|0;f=j>>>0<4?f+1|0:f;f=Ra[M[M[i>>2]+8>>2]](i,k,g,j,f)|0;if(f){break a}l=M[b>>2];f=M[a+172>>2];g=(d<<2)+4|0;j=g;g=g+M[a+168>>2]|0;j=M[b+4>>2]+(j>>>0>g>>>0?f+1|0:f)|0;l=g+l|0;j=l>>>0<g>>>0?j+1|0:j;M[b>>2]=l;M[b+4>>2]=j;f=101;g=M[h+8>>2];if(!g|M[a+164>>2]==(g|0)){break a}f=0;if(P[a+28>>2]<g>>>0){break a}if(Vv(c,g)){break a}b:{if(!d){break b}f=sf(i,l-4|0,j-(l>>>0<4)|0,h+4|0);if(f){break a}if(e){break b}f=101;if((_u(a,k)|0)!=M[h+4>>2]){break a}}if(c){f=Tg(c,g);if(f){break a}}c:{if((g|0)!=1){break c}c=N[k+20|0];if((c|0)==L[a+150>>1]){break c}L[a+150>>1]=c}d:{e:{f:{g:{if(!M[a+232>>2]){c=Qh(a,g);M[h+12>>2]=c;if(!d){break g}break f}c=0;M[h+12>>2]=0;if(d){break f}break e}if(!c){c=0;b=1;break d}b=!(N[c+28|0]&8);break d}if(N[a+7|0]){break e}e=M[b+4>>2];i=M[a+92>>2];b=(e|0)<=(i|0)&P[b>>2]<=P[a+88>>2]|(e|0)<(i|0);break d}b=1}h:{i:{e=M[a+64>>2];i=M[e>>2];if(!i){break i}f=N[a+17|0];j:{if(f>>>0<=3){if(b&!f){break j}break i}if(!b){break i}}b=M[a+168>>2];d=ZJ(b,M[a+172>>2],g-1|0,0);f=Ra[M[i+12>>2]](e,k,b,d,Qa)|0;if(P[a+36>>2]<g>>>0){M[a+36>>2]=g}b=M[a+96>>2];if(!b){break h}lv(b,g,k);break h}f=0;if(c|d){break h}K[a+21|0]=N[a+21|0]|2;f=Ra[M[a+220>>2]](a,g,h+12|0,1)|0;K[a+21|0]=N[a+21|0]&253;if(f){break a}bl(M[h+12>>2]);c=M[h+12>>2];f=0}if(!c){break a}b=M[c+4>>2];c=M[a+168>>2];if(c){G(b,k,c)}Ra[M[a+216>>2]](M[h+12>>2]);if((g|0)==1){c=N[b+28|0]|N[b+29|0]<<8|(N[b+30|0]<<16|N[b+31|0]<<24);d=N[b+24|0]|N[b+25|0]<<8|(N[b+26|0]<<16|N[b+27|0]<<24);K[a+112|0]=d;K[a+113|0]=d>>>8;K[a+114|0]=d>>>16;K[a+115|0]=d>>>24;K[a+116|0]=c;K[a+117|0]=c>>>8;K[a+118|0]=c>>>16;K[a+119|0]=c>>>24;c=N[b+36|0]|N[b+37|0]<<8|(N[b+38|0]<<16|N[b+39|0]<<24);b=N[b+32|0]|N[b+33|0]<<8|(N[b+34|0]<<16|N[b+35|0]<<24);K[a+120|0]=b;K[a+121|0]=b>>>8;K[a+122|0]=b>>>16;K[a+123|0]=b>>>24;K[a+124|0]=c;K[a+125|0]=c>>>8;K[a+126|0]=c>>>16;K[a+127|0]=c>>>24}ll(M[h+12>>2])}Na=h+16|0;return f}function Gt(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;g=Na-16|0;Na=g;M[g+12>>2]=0;a:{if(!(c>>>0>=2&P[a+48>>2]>=c>>>0)){d=db(77550);break a}h=M[a+12>>2];b:{if(b){d=M[b+72>>2];f=M[d+32>>2];e=M[d+36>>2];f=f+1|0;e=f?e:e+1|0;M[d+32>>2]=f;M[d+36>>2]=e;d=M[d+12>>2];e=d;f=M[d+16>>2];d=M[d+20>>2];f=f+1|0;d=f?d:d+1|0;M[e+16>>2]=f;M[e+20>>2]=d;break b}b=Ht(a,c)}M[g+8>>2]=b;d=ac(M[h+72>>2]);M[g+4>>2]=d;c:{d:{e:{if(d){break e}d=M[h+56>>2];f=mb(d+36|0);e=f+1|0;e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[d+36|0]=e;K[d+37|0]=e>>>8;K[d+38|0]=e>>>16;K[d+39|0]=e>>>24;f:{if(!(N[a+24|0]&4)){break f}if(!b){d=xd(a,c,g+8|0,0);b=M[g+8>>2];if(d){break e}}d=ac(M[b+72>>2]);M[g+4>>2]=d;if(d){break d}d=M[M[b+52>>2]+36>>2];if(!d){break f}D(M[b+56>>2],0,d)}if(N[a+17|0]){Hd(a,c,2,0,g+4|0);d=M[g+4>>2];if(d){break e}}g:{if(!f){e=0;break g}e=mb(M[h+56>>2]+32|0);if(e>>>0>P[a+48>>2]){d=db(77597);break e}d=xd(a,e,g+12|0,0);if(d){break e}f=M[g+12>>2];i=mb(M[f+56>>2]+4|0);d=M[a+40>>2]>>>2|0;if(i>>>0>d-2>>>0){d=db(77608);break e}if(d-8>>>0<=i>>>0){break g}d=ac(M[f+72>>2]);if(d){break e}d=M[f+56>>2];e=i+1|0;e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[d+4|0]=e;K[d+5|0]=e>>>8;K[d+6|0]=e>>>16;K[d+7|0]=e>>>24;d=M[f+56>>2]+(i<<2)|0;e=c<<24|(c&65280)<<8|(c>>>8&65280|c>>>24);K[d+8|0]=e;K[d+9|0]=e>>>8;K[d+10|0]=e>>>16;K[d+11|0]=e>>>24;h:{if(!b|N[a+24|0]&4){break h}d=M[b+72>>2];e=M[d+20>>2];if(N[e+12|0]){break h}h=O[d+28>>1];if(M[e+104>>2]|!(h&2)){break h}L[d+28>>1]=h&65515|16}i:{d=M[a+64>>2];if(d){break i}d=kj(M[a+48>>2]);M[a+64>>2]=d;if(d){break i}d=7;break e}if(P[d>>2]<c>>>0){d=0;break e}d=Tg(d,c);break e}if(!b){d=xd(a,c,g+8|0,0);b=M[g+8>>2];if(d){break e}}d=ac(M[b+72>>2]);if(d){break d}a=M[b+56>>2];d=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);K[a|0]=d;K[a+1|0]=d>>>8;K[a+2|0]=d>>>16;K[a+3|0]=d>>>24;d=0;a=M[b+56>>2];K[a+4|0]=0;K[a+5|0]=0;K[a+6|0]=0;K[a+7|0]=0;a=M[h+56>>2];c=c<<24|(c&65280)<<8|(c>>>8&65280|c>>>24);K[a+32|0]=c;K[a+33|0]=c>>>8;K[a+34|0]=c>>>16;K[a+35|0]=c>>>24;break d}if(b){break d}b=0;break c}K[b|0]=0}Rb(b);Rb(M[g+12>>2])}Na=g+16|0;return d}function nm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Na-208|0;Na=e;j=M[M[c>>2]+20>>2];f=jc(a,b,e+20|0);a:{if(!f){Pb(c,20034,-1);break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{h=M[a>>2]+b|0;switch(N[h|0]&15){case 0:break n;case 1:break m;case 2:break l;case 3:case 4:break k;case 5:case 6:break j;case 7:case 10:break i;case 8:case 9:break h;case 11:case 12:break g;default:break c}}if(M[e+20>>2]){break c}Yb(c);break a}if(M[e+20>>2]){break c}Ac(c,1);break a}if(M[e+20>>2]){break c}Ac(c,0);break a}M[e+24>>2]=0;M[e+28>>2]=0;d=M[e+20>>2];if(!d){break c}g=N[f+h|0];if((g|0)==45){if((d|0)==1){break c}f=f+1|0;d=d-1|0}i=Kd(j,f+h|0,d,d>>31);if(!i){break d}h=vf(i,e+24|0);ib(j,i);if(!h){a=M[e+24>>2];b=(g|0)==45;g=b?0-a|0:a;d=(a|0)!=0;a=M[e+28>>2];i=b?0-(d+a|0)|0:a;break b}k=(g|0)!=45;if(!k){g=0;i=-2147483648;if((h|0)==3){break b}}if(k|(h|0)==1){break f}d=d+1|0;f=f-1|0;break e}d=M[e+20>>2];if(!d){break c}break e}vb(c,f+h|0,M[e+20>>2],-1);break a}i=M[e+20>>2];g=md(j,i+1|0,0);if(!g){break d}h=f+h|0;a=0;b=0;while(1){if(b>>>0<i>>>0){d=b+h|0;f=N[d|0];o:{if((f|0)==92){j=hm(d,i-b|0,e+24|0);d=M[e+24>>2];p:{if(d>>>0<=127){K[a+g|0]=d;a=a+1|0;break p}if(d>>>0<=2047){f=a+g|0;K[f+1|0]=d&63|128;K[f|0]=d>>>6|192;a=a+2|0;break p}if(d>>>0<=65535){f=a+g|0;K[f+2|0]=d&63|128;K[f|0]=d>>>12|224;K[f+1|0]=d>>>6&63|128;a=a+3|0;break p}if((d|0)==629145){break p}f=a+g|0;K[f+3|0]=d&63|128;K[f|0]=d>>>18|240;K[f+2|0]=d>>>6&63|128;K[f+1|0]=d>>>12&63|128;a=a+4|0}b=(b+j|0)-1|0;break o}K[a+g|0]=f;a=a+1|0}b=b+1|0;continue}break}K[a+g|0]=0;vb(c,g,a,5);break a}if(!(!(N[M[c+4>>2]+8|0]&8)|d)){te(c,h,M[e+20>>2]+f|0,-1);break a}a=M[e+20>>2];D(e+160|0,0,48);M[e+156>>2]=a+f;M[e+152>>2]=h;M[e+24>>2]=c;L[e+48>>1]=1;M[e+40>>2]=0;M[e+44>>2]=0;M[e+32>>2]=100;M[e+36>>2]=0;M[e+28>>2]=e+50;a=e+24|0;Ff(e+152|0,0,a);bf(a,0,0);break a}if((h|0)==1){break c}}a=Kd(j,(M[a>>2]+b|0)+f|0,d,d>>31);if(!a){break d}b=Jd(a,e+8|0,jb(a),1);ib(j,a);if((b|0)<=0){break c}Zb(c,R[e+8>>3]);break a}$b(c);break a}Pb(c,20034,-1);break a}ic(c,g,i)}Na=e+208|0}function Hf(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=Na-16|0;Na=m;e=O[b+16>>1];h=e&31;if((e&63)>>>0>=32){e=1<<h;f=0}else{f=1<<h;e=f-1&1>>>32-h}k=f;a:{if(k&-1431655766|e&-1431655766){break a}b:{if(!(k&262148|e&262144)){break b}l=gb(b);if(!l){break b}n=Fb(b);d=yp(a);if(!d){break b}h=M[d+4>>2];j=(h|0)>0?h:0;f=d+8|0;d=0;c:{while(1){d:{if((d|0)==(j|0)){while(1){if((i|0)==(j|0)){break c}e:{g=M[f+(i<<2)>>2];if((n|0)!=M[g+20>>2]){break e}if(Qb(M[g+12>>2],l,n)){break e}d=i;break d}i=i+1|0;continue}}g=M[f+(d<<2)>>2];if((l|0)==M[g+12>>2]){break d}d=d+1|0;continue}break}if((d|0)>=(h|0)){break c}i=h-1|0;if((i|0)>(d|0)){h=h+(d^-1)<<2;if(h){d=f+(d<<2)|0;G(d,d+4|0,h)}M[f+(i<<2)>>2]=g}M[g+24>>2]=M[g+24>>2]+1;d=g;if(!(c&1)){break a}break b}g=0}l=c>>>0<2?a:0;h=c&1;k=k&65537;n=e&65536;i=M[M[a>>2]+20>>2];f:{g:{while(1){d=ub(i,56,0);if(!d){break g}D(d,0,56);M[d+24>>2]=1;M[d+16>>2]=i;if(g){b=M[g+4>>2];c=md(i,b,0);M[d>>2]=c;if(!c){break g}if(b){G(c,M[g>>2],b)}M[d+8>>2]=b;M[d+4>>2]=b;K[d+37|0]=N[g+37|0];bd(g);break a}h:{i:{j:{k:{l:{if(!(k|n)){break l}p=d,q=od(b),M[p>>2]=q;e=Fb(b);M[d+4>>2]=e;if(!e){M[d>>2]=0;break l}f=M[d>>2];if(!f){break l}f=N[f|0]&15;m:{if(f>>>0>12){break m}j=jc(d,0,m+12|0);if(!j){break m}o=e;e=M[m+12>>2];if((o|0)!=(e+j|0)){break m}if(!e|f>>>0>2){break k}}M[d>>2]=0;M[d+4>>2]=0}p=d,q=gb(b),M[p+12>>2]=q;e=Fb(b);M[d+20>>2]=e;if(N[i+87|0]){break g}if(!e){break h}if(!om(d,l)){break i}if(c>>>0<2){break j}K[d+34|0]=1;break a}if(!h){break a}if(lm(d,0)){break a}break g}bd(d);break f}n:{o:{p:{if(!b){break p}e=O[b+16>>1];if(!(e&18)|!(e&4096)){break p}if(M[b+36>>2]==9){break o}}e=M[d+20>>2];e=zo(e,e>>31);if(!e){break g}f=M[d+20>>2];if(f){G(e,M[d+12>>2],f)}M[d+12>>2]=e;K[e+M[d+20>>2]|0]=0;break n}e=M[d+12>>2]-8|0;f=e;j=M[e>>2];e=M[e+4>>2];j=j+1|0;e=j?e:e+1|0;M[f>>2]=j;M[f+4>>2]=e}K[d+36|0]=1;if((pz(a,d)|0)==7){break g}g=d;if(h){continue}break a}break}if(c>>>0>=2){K[d+34|0]=1;break a}bd(d);Pb(a,20034,-1);break f}bd(g);bd(d);$b(a)}d=0}Na=m+16|0;return d}function bn(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=Na-16|0;Na=k;a:{m=M[a>>2];if(N[b+43|0]|!(N[m+33|0]&64)){break a}t=c+1|0;h=b+48|0;g=M[m+16>>2];o=Mb(m,M[b+60>>2]);r=M[g+(o<<4)>>2];s=N[a+165|0];while(1){j=M[h>>2];if(j){M[k+12>>2]=0;M[k+8>>2]=0;b:{c:{if(!e){break c}if(!hc(M[b>>2],M[j+8>>2])){break c}if(!Wz(b,j,e,f)){break b}}i=M[j+8>>2];d:{e:{f:{if(N[a+165|0]){g=Hc(m,i,r);break f}g=yf(a,0,i,r)}if(g){if(!wi(a,g,j,k+12|0,k+8|0)){break e}}if(N[m+87|0]|!s){break a}if(g){break b}l=j+36|0;i=Cb(a);g=M[j+20>>2];n=(g+M[i+108>>2]|0)+1|0;h=0;while(1){if((h|0)>=(g|0)){break d}$a(i,51,Pc(M[j>>2],L[l+(h<<3)>>1])+t|0,n);h=h+1|0;g=M[j+20>>2];continue}}n=M[k+8>>2];if(!n){M[k+4>>2]=M[j+36>>2];n=k+4|0}l=g+32|0;i=0;p=M[k+12>>2];h=0;while(1){if(M[j+20>>2]>(h|0)){q=(h<<2)+n|0;if(M[q>>2]==L[b+32>>1]){M[q>>2]=-1}if(M[m+364>>2]){i=l;q=M[g>>2];u=M[g+4>>2];if(p){i=M[p+4>>2]+(h<<1)|0}i=(TA(a,q,M[S(L[i>>1],12)+u>>2],o)|0)==2}h=h+1|0;continue}break}Dd(a,o,M[g+20>>2],0,M[g>>2]);M[a+44>>2]=M[a+44>>2]+1;if(c){Tz(a,o,g,p,j,n,c,-1,i)}g:{if(!d){break g}l=M[a+132>>2];l=M[(l?l:a)+140>>2];h:{if(!l){break h}l=M[l>>2];if((l|0)==M[j+28>>2]&N[j+25|0]==8){break g}if((l|0)!=M[j+32>>2]){break h}if(N[j+26|0]==8){break g}}Tz(a,o,g,p,j,n,d,1,i)}eb(m,M[k+8>>2]);break b}$a(i,158,N[j+24|0],-1)}h=j+4|0;continue}break}l=(e|0)!=0;h=Dg(b);while(1){if(!h){break a}M[k+12>>2]=0;M[k+8>>2]=0;i:{if(e){if(!Zq(b,h,e,f)){break i}}if(!(M[a+132>>2]|(N[h+24|0]|N[m+34|0]&8))){if(!N[a+20|0]){break i}}if(wi(a,b,h,k+12|0,k+8|0)){if(!s){break a}if(!N[m+87|0]){break i}break a}i=Od(a,0,0,0);if(i){g=M[h>>2];M[i+16>>2]=g;M[i+8>>2]=M[g>>2];M[g+24>>2]=M[g+24>>2]+1;g=M[a+44>>2];M[a+44>>2]=g+1;M[i+24>>2]=g;if(d){Sz(a,i,b,M[k+12>>2],h,M[k+8>>2],d,-1)}j:{if(!c){break j}g=N[(h+l|0)+25|0];j=M[m+36>>2];Sz(a,i,b,M[k+12>>2],h,M[k+8>>2],c,1);if(N[h+24|0]|!((j&8)>>>3|(g&253)!=8)){break j}g=M[a+132>>2];K[(g?g:a)+21|0]=1}M[i+8>>2]=0;Gc(m,i)}eb(m,M[k+8>>2])}h=M[h+12>>2];continue}}Na=k+16|0}function eu(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=Na-32|0;Na=e;i=M[a+8>>2];g=M[i+4>>2];a:{b:{c:{c=N[a|0];if(c){if(c>>>0<3){break c}c=sj(a);if(c){break a}c=0;if(N[a|0]){break a}}d=M[a+116>>2];c=O[d+24>>1];j=O[a+70>>1];if(c>>>0<=j>>>0){c=db(80565);break a}k=K[a+68|0];h=M[d+64>>2];f=h+(j<<1)|0;l=N[f|0];f=N[f+1|0];m=O[d+26>>1];n=M[d+56>>2];if(M[d+20>>2]<0){if(Yf(d)){break b}h=M[d+64>>2];c=O[d+24>>1]}f=(m&(f|l<<8))+n|0;if(f>>>0<(c&65535)+h>>>0){c=db(80572);break a}h=0;l=b&2;d:{if(!l){break d}e:{if(!N[d+8|0]){break e}h=1;if(((M[d+20>>2]+(Ra[M[d+76>>2]](d,f)|0)|0)+2|0)>((M[g+40>>2]<<1>>>0)/3|0)){break e}if(O[d+24>>1]!=1){break d}}c=Qu(a);M[e+28>>2]=c;h=0;if(c){break a}}if(!N[d+8|0]){c=Vk(a);if(c){break a}}if(N[a+1|0]&32){c=ng(g,M[a+64>>2],a);if(c){break a}}if(!(M[a+112>>2]|!N[i+11|0])){yo(i,M[a+64>>2],M[a+32>>2],M[a+36>>2],0)}c=ac(M[d+72>>2]);if(c){break a}Ra[M[d+80>>2]](d,f,e);if(M[e+12>>2]!=O[e+16>>1]){b=vo(d,f,e)}else{b=0}M[e+28>>2]=b;Sk(d,j,O[e+18>>1],e+28|0);c=M[e+28>>2];if(c){break a}if(!N[d+8|0]){f=a+116|0;b=M[f>>2];if(M[b+20>>2]<0){c=Yf(b);if(c){break a}}c=M[b+64>>2]+(O[b+24>>1]<<1)|0;c=O[b+26>>1]&(N[c-2|0]<<8|N[c-1|0]);if(c>>>0<=3){c=db(80663);break a}f=M[M[((K[a+68|0]-1|0)>(k|0)?((k<<2)+a|0)+124|0:f)>>2]+4>>2];i=c+M[b+56>>2]|0;c=Ra[M[b+76>>2]](b,i)|0;g=M[g+84>>2];m=ac(M[b+72>>2]);M[e+28>>2]=m;if(!m){o=e,p=ro(d,j,i-4|0,c+4|0,g,f),M[o+28>>2]=p}Sk(b,O[b+24>>1]-1|0,c,e+28|0);c=M[e+28>>2];if(c){break a}}if((S(M[M[a+116>>2]+20>>2],3)|0)>M[M[a+20>>2]+40>>2]<<1){c=so(a);if(c){break a}}if(K[a+68|0]>(k|0)){qf(M[a+116>>2]);c=N[a+68|0]-1|0;K[a+68|0]=c;b=a+120|0;while(1){g=c<<24>>24;if((k|0)<(g|0)){K[a+68|0]=c-1;Rb(M[b+(g<<2)>>2]);c=N[a+68|0];continue}break}M[a+116>>2]=M[b+(g<<2)>>2];c=so(a);if(c){break a}}if(h){K[a|0]=2;b=O[d+24>>1];if(b>>>0<=j>>>0){M[a+4>>2]=-1;L[a+70>>1]=b-1;c=0;break a}M[a+4>>2]=1;c=0;break a}b=Zf(a);if(l){Nh(a);K[a|0]=3}c=(b|0)!=16?b:0;break a}c=db(80556);break a}c=db(80569)}Na=e+32|0;return c}function aG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=Na-176|0;Na=d;a:{if(Ql(a,4201,M[c>>2],d+28|0)){break a}e=M[d+28>>2];if(Wl(a,e)){break a}j=M[e>>2];m=M[M[j+36>>2]>>2];M[d+168>>2]=0;M[d+160>>2]=0;M[d+164>>2]=0;if(!M[e+16>>2]){vb(a,30808,0,0);break a}M[d+152>>2]=0;M[d+156>>2]=0;M[d+144>>2]=0;M[d+148>>2]=0;M[d+136>>2]=0;M[d+140>>2]=0;M[d+128>>2]=0;M[d+132>>2]=0;c=Pl(e,0,d+172|0);b:{if(c){break b}b=Oe(S(M[d+172>>2],24),0);M[d+152>>2]=b;c:{if(!b){break c}b=M[e+36>>2];c=M[e+32>>2];M[d+128>>2]=e;M[d+144>>2]=c;M[d+148>>2]=b;c=Df(M[e+16>>2],117,d+128|0);if(c){break b}b=0;while(1){if(M[j+24>>2]<=(b|0)){c=0;break b}M[d+116>>2]=0;M[d+112>>2]=0;M[d+108>>2]=0;M[d+136>>2]=0;M[d+132>>2]=b;M[d+104>>2]=0;c=Df(M[e+16>>2],118,d+128|0);if(c){break b}k=b+1|0;c=ff(M[e+12>>2],k);f=Wd(M[e+12>>2],k);d:{if(!c){if((lh(M[e+12>>2],k)|0)!=5){break c}break d}c=pg(M[j+36>>2],M[e+20>>2],c,f,d+124|0);if(c){break b}l=M[d+124>>2];c=Ra[M[m+20>>2]](l,d+120|0,d+116|0,d+112|0,d+108|0,d+104|0)|0;while(1){f=M[d+172>>2];p=(f|0)>0?f:0;q=M[d+152>>2];e:{while(1){if(c){break e}c=0;f=2147483647;g=0;while(1){if((c|0)!=(p|0)){i=S(c,24)+q|0;if(M[i>>2]){n=M[i+8>>2];o=M[i+16>>2];h=n-o|0;r=h;s=f;t=f>>>0>h>>>0;h=M[i+12>>2]-(M[i+20>>2]+(n>>>0<o>>>0)|0)|0;f=f>>31;h=t&(h|0)<=(f|0)|(f|0)>(h|0);f=h?r:s;g=h?i:g}c=c+1|0;continue}break}c=101;if(!g){continue}break}f:{if(N[M[g>>2]]<=1){M[g>>2]=0;break f}Pj(g,g+8|0)}c=0;l=M[d+124>>2];while(1){if(!(M[d+104>>2]>=(f|0)|c)){c=Ra[M[m+20>>2]](l,d+120|0,d+116|0,d+112|0,d+108|0,d+104|0)|0;continue}break}if(!c){M[d>>2]=b;c=M[d+112>>2];M[d+8>>2]=c;M[d+12>>2]=M[d+108>>2]-c;M[d+4>>2]=(g-M[d+152>>2]|0)/24;c=mg(d+160|0,vd(64,d+32|0,30186,d),-1);continue}if((c|0)!=101){continue}c=M[j+40>>2]?101:267;continue}break}Ra[M[m+16>>2]](l)|0;if((c|0)!=101){break b}}b=k;continue}}c=7}ab(M[d+152>>2]);Ne(j);if(c){ee(a,c);ab(M[d+160>>2]);break a}vb(a,M[d+160>>2],M[d+164>>2]-1|0,1)}Na=d+176|0}function pe(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;c=Na+-64|0;Na=c;a:{if(ve()){break a}if(!(b?(a|0)>0:0)){M[18485]=0;break a}if(M[18485]){d=N[74068]}else{d=Xl(0);e=M[7755];M[18487]=M[7754];M[18488]=e;e=M[7753];M[18485]=M[7752];M[18486]=e;b:{if(!d){D(73956,0,44);break b}e=M[16935];if(e){D(73960,0,40);M[18489]=e;break b}Ra[M[d+56>>2]](d,44,73956)|0;h=M[18497]}M[18500]=h;K[74068]=0;M[18497]=0;d=0}c:while(1){d=d&255;if((d|0)>=(a|0)){if(a){G(b,(d-a|0)+74004|0,a)}K[74068]=N[74068]-a;break a}if(d){if(d){G(b,74004,d)}d=N[74068];b=d+b|0;a=a-d|0}d=0;M[18497]=M[18497]+1;G(c,73940,64);f=M[c+44>>2];k=M[c+60>>2];n=M[c+12>>2];h=M[c+28>>2];i=M[c+40>>2];s=M[c+56>>2];o=M[c+8>>2];e=M[c+24>>2];t=M[c+36>>2];p=M[c+52>>2];u=M[c+4>>2];j=M[c+20>>2];q=M[c+32>>2];l=M[c+48>>2];r=M[c>>2];m=M[c+16>>2];while(1)if((d|0)==10){M[c+48>>2]=l;M[c>>2]=r;M[c+16>>2]=m;M[c+32>>2]=q;M[c+20>>2]=j;M[c+52>>2]=p;M[c+4>>2]=u;M[c+36>>2]=t;M[c+24>>2]=e;M[c+56>>2]=s;M[c+8>>2]=o;M[c+40>>2]=i;M[c+28>>2]=h;M[c+60>>2]=k;M[c+12>>2]=n;M[c+44>>2]=f;d=0;while(1){if((d|0)!=16){h=d<<2;M[h+74004>>2]=M[h+73940>>2]+M[c+h>>2];d=d+1|0;continue}break}d=64;K[74068]=64;continue c}else{g=m;v=q;m=m+r|0;q=cK(m^l,16);l=v+q|0;r=cK(g^l,12);g=r;r=m+r|0;v=cK(r^q,8);q=l+v|0;m=cK(g^q,7);g=f;f=h+n|0;k=cK(f^k,16);l=g+k|0;h=cK(l^h,12);g=e;e=e+o|0;n=cK(e^s,16);i=n+i|0;w=cK(g^i,12);e=w+e|0;o=h+f|0;s=o+m|0;x=cK(e^n,8);f=cK(s^x,16);g=j;j=j+u|0;n=cK(j^p,16);t=n+t|0;y=cK(g^t,12);j=y+j|0;g=m;p=cK(j^n,8);z=p+t|0;m=f+z|0;u=cK(g^m,12);n=u+s|0;s=cK(f^n,8);t=s+m|0;m=cK(t^u,7);g=e;k=cK(k^o,8);e=k+l|0;f=cK(e^h,7);o=g+f|0;p=cK(o^p,16);h=p+q|0;f=cK(h^f,12);o=f+o|0;p=cK(p^o,8);q=h+p|0;h=cK(q^f,7);g=j;j=i+x|0;f=cK(j^w,7);i=g+f|0;l=cK(i^v,16);e=l+e|0;g=i;i=cK(e^f,12);u=g+i|0;l=cK(l^u,8);f=e+l|0;e=cK(f^i,7);g=k;k=cK(y^z,7);i=k+r|0;v=cK(g^i,16);j=v+j|0;w=cK(j^k,12);r=w+i|0;k=cK(v^r,8);i=j+k|0;j=cK(i^w,7);d=d+1|0;continue}}}Na=c- -64|0}function kI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;b=Na-384|0;Na=b;h=M[M[a>>2]+20>>2];e=gb(M[c>>2]);j=gb(M[c+12>>2]);i=gb(M[c+16>>2]);k=gb(M[c+20>>2]);d=sb(M[c+24>>2]);if(!(!k|(!j|!i))){m=M[h+364>>2];M[h+364>>2]=0;Fe(h);M[b+88>>2]=0;M[b+80>>2]=0;M[b+84>>2]=0;M[b+72>>2]=0;M[b+76>>2]=0;f=Hc(h,i,e);M[b- -64>>2]=0;M[b+56>>2]=0;M[b+60>>2]=0;M[b+84>>2]=f;M[b+52>>2]=98;M[b+48>>2]=99;M[b+68>>2]=b+72;g=b+96|0;M[b+44>>2]=g;d=fk(g,e,h,j,d);a:{if(d){break a}d=M[h+32>>2];f=d&67108864;b:{c:{e=M[b+348>>2];if(e){l=N[e+43|0];if((l|0)==2){if(f){break b}d=M[e+44>>2];M[b+36>>2]=0;M[b+40>>2]=0;M[b+28>>2]=0;M[b+32>>2]=0;M[b+20>>2]=0;M[b+24>>2]=0;M[b+12>>2]=0;M[b+16>>2]=0;M[b+8>>2]=g;M[d+4>>2]=M[d+4>>2]&-2097153;je(g,M[e+44>>2],b+8|0);if(M[b+136>>2]){break c}oc(b+44|0,M[e+44>>2]);break b}d:{if(!(d&16384)&(f|0)!=0|(l|0)==1){break d}d=e+48|0;while(1){d=M[d>>2];if(!d){break d}g=M[d+8>>2];if(!hc(g,i)){hd(b+96|0,b+72|0,g)}d=d+4|0;continue}}d=M[e>>2];if(hc(i,d)){break b}M[b+84>>2]=e;i=b+96|0;g=b+72|0;if(!f){ec(b+44|0,M[e+16>>2]);d=M[e>>2]}hd(i,g,d);break b}d=M[b+352>>2];if(d){hd(b+96|0,b+72|0,M[d>>2]);if(f){break b}Nb(b+44|0,M[M[b+352>>2]+36>>2]);break b}e=M[b+356>>2];d=M[e+4>>2];if(!(hc(d,i)|M[M[b+84>>2]+60>>2]!=M[e+24>>2])){hd(b+96|0,b+72|0,d)}if(f){break b}d=um(b+96|0);if(d){break a}Tq(b+44|0,e);d=e+28|0;while(1){e=M[d>>2];if(!e){break b}d=M[e+12>>2];e:{if(!d){break e}if(hb(d,i)){break e}hd(b+96|0,b+72|0,d)}d=0;f:{f=M[e+16>>2];if(!f){break f}while(1){if(M[f>>2]<=(d|0)){break f}g=M[(S(d,48)+f|0)+8>>2];if(!hc(g,i)){hd(b+96|0,b+72|0,g);f=M[e+16>>2]}d=d+1|0;continue}}d=e+40|0;continue}}d=M[b+108>>2];if(d){break a}}d=Sq(a,b+72|0,j,k,1)}g:{h:{i:{switch(d|0){case 0:break g;case 1:break i;default:break h}}if((M[h+32>>2]&268435457)!=1){break h}He(a,M[c+12>>2]);break g}if(M[b+100>>2]){Rq(a,30808,M[c+4>>2],M[c+8>>2],b+96|0);break g}ee(a,d)}dk(b+96|0);tm(h,M[b+72>>2]);M[h+364>>2]=m}Na=b+384|0}function np(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Na-32|0;Na=h;M[h+28>>2]=0;a:{while(1){b:{c:{d:{g=N[b|0];switch(g-173|0){case 0:break c;case 1:case 2:break a;case 3:break b;default:break d}}if((g|0)!=181){break a}}b=M[b+12>>2];continue}break}g=N[b+2|0]}e:{f:{g:{h:{i:{j:{k:{l:{m:{if((g|0)!=174){if((g|0)!=36){k=30808;i=1;break m}f=Si(M[b+8>>2],0)&255;j=np(a,M[b+12>>2],c,f,e);a=M[e>>2];if(!a){break e}Bu(a,f,c);oe(M[e>>2],d<<24>>24,c);break e}n:{b=M[b+12>>2];g=N[b|0];switch(g-154|0){case 0:case 2:break n;default:break l}}k=25071;i=-1;l=-1;if(N[b+5|0]&8){break m}f=M[b+8>>2];if(N[f|0]!=48){break m}if((N[f+1|0]&223)==88){break l}}o:{p:{switch(g-154|0){case 0:case 2:break o;case 1:break j;default:break p}}f=0;switch(g-118|0){case 1:case 2:case 3:break h;case 4:break k;case 0:break o;default:break i}}f=tg(a);if(!f){break g}q:{if(N[b+5|0]&8){a=M[b+8>>2];Fc(f,ZJ(i,l,a,a>>31),Qa);break q}r:{if((g|0)!=156){break r}if(vf(M[b+8>>2],h+16|0)){break r}Fc(f,ZJ(M[h+16>>2],M[h+20>>2],i,l),Qa);break q}M[h+4>>2]=M[b+8>>2];M[h>>2]=k;b=tb(a,6118,h);if(!b){break f}ym(f,b,5)}s:{if((d|0)==65){if((g|0)==154){Jd(M[f+8>>2],f,M[f+12>>2],1);L[f+16>>1]=8;break s}if((g|0)!=156){break s}oe(f,67,1);break s}oe(f,d<<24>>24,1)}a=O[f+16>>1];if(a&44){L[f+16>>1]=a&65533}if((c|0)==1){break h}j=Yd(f,c);break h}a=np(a,b,c,d,h+28|0);f=M[h+28>>2];if(a|!f){break h}Ut(f);b=O[f+16>>1];t:{if(b&8){R[f>>3]=-R[f>>3];break t}a=M[f>>2];g=M[f+4>>2];if(!a&(g|0)==-2147483648){M[f>>2]=0;M[f+4>>2]=1138753536;L[f+16>>1]=b&62016|8;break t}M[f>>2]=0-a;M[f+4>>2]=0-(g+((a|0)!=0)|0)}oe(f,d<<24>>24,c);break h}f=tg(a);if(!f){break g}dc(f);break h}f=tg(a);if(!f){break g}b=M[b+8>>2]+2|0;c=jb(b)-1|0;d=(c|0)/2|0;Bd(f,pt(a,b,c),d,0,0,5);break h}if((g|0)!=171){break h}f=tg(a);if(!f){f=0;break h}L[f+16>>1]=4;M[f>>2]=!N[M[b+8>>2]+4|0];M[f+4>>2]=0;oe(f,d<<24>>24,c)}M[e>>2]=f;break e}f=0}Lb(a);eb(a,0);Xc(f);j=7}Na=h+32|0;return j}function yl(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=Na-16|0;Na=g;h=M[a+116>>2];a:{if(O[a+70>>1]>=O[h+24>>1]){b=db(75880);break a}l=M[a+20>>2];Ng(a);e=M[a+40>>2];n=e-M[h+56>>2]|0;h=O[a+48>>1];if(n>>>0>M[l+40>>2]-h>>>0){b=db(75895);break a}b:{c:{if(b>>>0<h>>>0){i=h>>>0<b+c>>>0?h-b|0:c;c=c-i|0;h=d+i|0;b=Pu(b+e|0,d,i);break c}f=b-h|0;h=d;b=0}d:{if(b|!c){break d}b=M[l+40>>2];n=e;e=O[a+48>>1];p=g,q=mb(n+e|0),M[p+8>>2]=q;i=b-4|0;e:{if(!(N[a+1|0]&4)){b=((M[a+44>>2]+(b-e|0)|0)-5>>>0)/(i>>>0)|0;f:{g:{j=M[a+12>>2];if(!j){break g}e=b<<2;if((Ra[M[16877]](j)|0)<(e|0)){break g}k=M[a+12>>2];break f}e=M[16930];if(e){if(Ra[e|0](413)|0){break b}}k=Ud(M[a+12>>2],b<<3,0);if(!k){break b}M[a+12>>2]=k;e=b<<2}j=0;if(e){D(k,0,e)}K[a+1|0]=N[a+1|0]|4;break e}j=(f>>>0)/(i>>>0)|0;b=M[M[a+12>>2]+(j<<2)>>2];if(!b){j=0;break e}M[g+8>>2]=b;f=f-S(i,j)|0}while(1){b=M[g+8>>2];if(!b){b=0;break d}if(b>>>0>P[l+48>>2]){b=db(75966);break a}e=M[a+12>>2]+(j<<2)|0;M[e>>2]=b;h:{if(f>>>0>=i>>>0){e=M[e+4>>2];i:{if(e){M[g+8>>2]=e;b=0;break i}b=Ou(l,b,0,g+8|0)}f=f-i|0;break h}k=i>>>0<c+f>>>0?i-f|0:c;j:{k:{l:{if(f){break l}e=M[l>>2];m=M[e+64>>2];o=M[m>>2];if(!o|M[M[e+228>>2]>>2]){break l}n=M[e+232>>2];if(n){M[g+12>>2]=0;ap(n,b,g+12|0);if(M[g+12>>2]){break l}m=M[e+64>>2];o=M[m>>2]}if(!(Ra[M[o+48>>2]](m)&32768)){break l}e=h-4|0;if(e>>>0<d>>>0){break l}f=N[e|0]|N[e+1|0]<<8|(N[e+2|0]<<16|N[e+3|0]<<24);m=M[M[l>>2]+64>>2];b=(q=m,r=e,s=k+4|0,t=ZJ(M[l+36>>2],0,b-1|0,0),u=Qa,p=M[M[m>>2]+8>>2],Ra[p](q|0,r|0,s|0,t|0,u|0)|0);p=g,u=mb(e),M[p+8>>2]=u;K[e|0]=f;K[e+1|0]=f>>>8;K[e+2|0]=f>>>16;K[e+3|0]=f>>>24;break k}e=M[l>>2];b=Ra[M[e+220>>2]](e,b,g+4|0,2)|0;if(b){break j}b=M[M[g+4>>2]+4>>2];p=g,u=mb(b),M[p+8>>2]=u;b=Pu((b+f|0)+4|0,h,k);sd(M[g+4>>2])}f=0}c=c-k|0;if(!c){break a}h=h+k|0}j=j+1|0;if(!b){continue}break}}if(!c|b){break a}b=db(76050);break a}b=7}Na=g+16|0;return b}function Vz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;e=Na-384|0;Na=e;f=M[a+132>>2];l=f?f:a;h=l;f=h+140|0;a:{while(1){f=M[f>>2];if(f){if(M[f>>2]==(b|0)&M[f+12>>2]==(d|0)){break a}f=f+4|0;continue}break}f=0;g=M[a>>2];i=ub(g,24,0);b:{if(!i){break b}M[i+4>>2]=M[h+140>>2];M[h+140>>2]=i;h=ub(g,28,0);M[i+8>>2]=h;if(!h){break b}f=M[l+8>>2];M[h+24>>2]=M[f+232>>2];M[f+232>>2]=h;M[i+16>>2]=-1;M[i+20>>2]=-1;M[i+12>>2]=d;M[i>>2]=b;f=e+32|0;xm(f,g);M[e+348>>2]=0;M[e+352>>2]=0;M[e+340>>2]=0;M[e+344>>2]=0;M[e+332>>2]=0;M[e+336>>2]=0;M[e+324>>2]=0;M[e+328>>2]=0;M[e+168>>2]=c;M[e+164>>2]=l;M[e+320>>2]=f;M[e+296>>2]=M[b>>2];K[e+194|0]=N[b+8|0];L[e+192>>1]=O[a+160>>1];K[e+57|0]=N[a+25|0];j=Cb(f);c:{if(j){c=M[b>>2];if(c){M[e+16>>2]=c;Vd(j,-1,tb(g,7402,e+16|0),-6)}c=M[b+12>>2];if(c){c=qb(g,c,0);d:{if(N[g+87|0]){break d}if(id(e+320|0,c)){break d}m=M[e+92>>2]-1|0;M[e+92>>2]=m;Dc(e+32|0,c,m,16)}kb(g,c)}f=b+28|0;g=M[e+32>>2];n=M[e+40>>2];o=(d|0)!=11;while(1){f=M[f>>2];if(f){K[e+196|0]=o?d:N[f+1|0];c=M[f+36>>2];if(c){M[e>>2]=c;nb(n,184,2147483647,1,0,tb(g,8890,e),-6)}e:{f:{switch(N[f|0]-128|0){case 2:c=e+32|0;k=zm(c,f);Gn(c,k,xc(g,M[f+24>>2],0),qb(g,M[f+20>>2],0),N[e+196|0],0);Ub(n,131);break e;case 0:c=e+32|0;k=zm(c,f);In(c,k,le(g,M[f+8>>2],0),aB(g,M[f+28>>2]),N[e+196|0],Rz(g,M[f+32>>2]));Ub(n,131);break e;case 1:c=e+32|0;k=zm(c,f);Fn(c,k,qb(g,M[f+20>>2],0));Ub(n,131);break e;default:break f}}c=le(g,M[f+8>>2],0);K[e+356|0]=4;M[e+376>>2]=0;M[e+368>>2]=0;M[e+372>>2]=0;M[e+360>>2]=0;M[e+364>>2]=0;Rc(e+32|0,c,e+356|0);pc(g,c)}f=f+40|0;continue}break}if(m){pb(j,m)}Ub(j,70);Qz(a,e+32|0);if(!M[a+40>>2]){c=M[j+104>>2];sw(j,l+108|0);M[h+4>>2]=M[j+108>>2];M[j+104>>2]=0;M[h>>2]=c}M[h+8>>2]=M[e+80>>2];c=M[e+76>>2];M[h+20>>2]=b;M[h+12>>2]=c;M[i+16>>2]=M[e+184>>2];M[i+20>>2]=M[e+188>>2];Go(j);break c}Qz(a,e+32|0)}qi(e+32|0);f=i}M[M[a>>2]+68>>2]=-1}Na=e+384|0;return f}function bH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=M[a+56>>2]+((b>>>0)%P[a+52>>2]<<2)|0;a:{b:{while(1){d=M[d>>2];if(!d){break b}if(M[d+8>>2]!=(b|0)){d=d+16|0;continue}break}if(!M[d+24>>2]){break a}return dm(d)|0}if(!c){return 0}h=b;b=0;d=M[a>>2];c:{d:{if((c|0)!=1){break d}e=M[a+48>>2]-M[a+44>>2]|0;if(e>>>0>=P[d+12>>2]|e>>>0>=P[a+32>>2]){break c}if(!bz(a)){break d}if(e>>>0>P[a+44>>2]){break c}}if(P[a+48>>2]>=P[a+52>>2]){gz(a)}e:{f:{g:{if(!M[a+20>>2]){break g}b=M[d+48>>2];if(O[b+14>>1]){break g}if(P[a+28>>2]>M[a+48>>2]+1>>>0){if(!bz(a)){break g}b=M[d+48>>2]}zq(b,0);b=dm(b);e=M[b+20>>2];if(M[e+16>>2]==M[a+16>>2]){break f}yq(b)}h:{i:{b=M[a+60>>2];j:{if(b){break j}if(M[a+48>>2]){break i}b=M[18571];if(!b|P[a+28>>2]<3){break i}d=M[18582];if(d){Ra[d|0]();b=M[18571]}k:{if((b|0)>0){d=M[a+16>>2];f=d>>31;b=ZJ(d,f,b,0);e=Qa;break k}d=M[a+16>>2];f=d>>31;e=b>>31<<10|b>>>22;g=b<<10;b=0-g|0;e=0-(e+((g|0)!=0)|0)|0}g=b;d=ZJ(d,f,M[a+28>>2],0);f=d;d=b>>>0<d>>>0;b=Qa;d=d&(e|0)<=(b|0)|(b|0)>(e|0);d=lc(d?g:f,d?e:b);M[a+64>>2]=d;b=M[18583];if(b){Ra[b|0]()}if(d){b=Ra[M[16877]](d)|0;f=M[a+16>>2];e=(b|0)/(f|0)|0;c=M[a+60>>2];g=M[a+8>>2];while(1){b=d+g|0;M[b+28>>2]=0;M[b+16>>2]=c;M[b+12>>2]=1;M[b>>2]=d;M[b+4>>2]=b+32;d=d+f|0;c=b;e=e-1|0;if(e){continue}break}break j}b=M[a+60>>2];if(!b){break i}}M[a+60>>2]=M[b+16>>2];M[b+16>>2]=0;break h}b=(c|0)!=1;l:{if(b){break l}c=M[18582];if(!c){break l}Ra[c|0]()}c=fj(M[a+16>>2]);m:{if(b){break m}b=M[18583];if(!b){break m}Ra[b|0]()}b=0;if(!c){break c}b=c+M[a+8>>2]|0;M[b+28>>2]=0;M[b+12>>2]=0;M[b>>2]=c;M[b+4>>2]=b+32}c=M[a+4>>2];M[c>>2]=M[c>>2]+1;break e}M[d+16>>2]=M[d+16>>2]+(M[a+20>>2]-M[e+20>>2]|0)}M[a+48>>2]=M[a+48>>2]+1;c=M[a+52>>2];M[b+8>>2]=h;c=(h>>>0)%(c>>>0)<<2;d=M[c+M[a+56>>2]>>2];M[b+24>>2]=0;M[b+20>>2]=a;M[b+16>>2]=d;M[M[b+4>>2]>>2]=0;M[c+M[a+56>>2]>>2]=b;if(h>>>0<=P[a+36>>2]){break c}M[a+36>>2]=h}d=b}return d|0}function yw(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;o=Na-16|0;Na=o;M[a+128>>2]=M[b+240>>2];M[b+240>>2]=0;t=L[b+220>>1];p=M[a>>2];c=M[b+48>>2];q=M[b+44>>2];M[o+12>>2]=M[b+108>>2];e=M[a+104>>2];f=M[b+52>>2];i=M[a+108>>2];sw(a,o+12|0);g=S(i,20)+7&-8;f=f-g&-8;c=c+q|0;m=(!q&(c|0)>0)+c|0;c=O[a+152>>1]&-33|(N[b+20|0]?N[b+21|0]?32:0:0);L[a+152>>1]=c;b=N[b+223|0];if(b){b=b<<2&12;L[a+144>>1]=b^12;m=(m|0)<=10?10:m;c=b|c&-13}L[a+152>>1]=c&65532;c=f;f=S(m,40);i=c-f|0;k=c>>31;d=k;h=d-(c>>>0<f>>>0)|0;b=e+g|0;l=c>>>0<f>>>0&(d|0)<=0|(d|0)<0;M[a+88>>2]=l?0:i+b|0;c=l?c:i;i=S(t,40);d=c-i|0;e=l?k:h;g=e-(c>>>0<i>>>0)|0;r=c>>>0<i>>>0&(e|0)<=0|(e|0)<0;M[a+100>>2]=r?0:b+d|0;c=r?c:d;d=r?e:g;e=0;g=(M[o+12>>2]<<2)+7|0;e=g>>>0<7?1:e;g=g&-8;n=c-g|0;k=e&1;e=k;h=c>>>0<g>>>0;j=d-(e+h|0)|0;h=(d|0)<=(e|0)&h|(d|0)<(e|0);M[a+92>>2]=h?0:b+n|0;c=h?c:n;e=h?d:j;d=0;n=q<<2;j=n+7|0;d=j>>>0<7?1:d;j=j&-8;u=(c-j|0)+b|0;s=d&1;d=s;b=c>>>0<j>>>0&(d|0)>=(e|0)|(d|0)>(e|0);M[a+96>>2]=b?0:u;d=l?f:0;c=d+(r?i:0)|0;e=0;e=c>>>0<d>>>0?e+1|0:e;l=h?g:0;c=l+c|0;d=(h?k:0)+e|0;d=(c>>>0<l>>>0?d+1|0:d)+(b?s:0)|0;a:{b:{e=b?j:0;c=e+c|0;d=c>>>0<e>>>0?d+1|0:d;c:{if(c|d){e=Ob(p,c,d);M[a+212>>2]=e;if(N[p+87|0]){break c}b=M[a+88>>2];d:{if(b){break d}b=0;h=c>>>0<f>>>0;if(h&!d){break d}d=d-h|0;c=c-f|0;b=c+e|0}M[a+88>>2]=b;b=M[a+100>>2];e:{if(b){break e}b=0;f=c>>>0<i>>>0;if(f&!d){break e}d=d-f|0;c=c-i|0;b=c+e|0}M[a+100>>2]=b;b=M[a+92>>2];f:{if(b){break f}b=0;f=c>>>0<g>>>0;if(f&(d|0)<=(k|0)|(d|0)<(k|0)){break f}d=d-(f+k|0)|0;c=c-g|0;b=c+e|0}M[a+92>>2]=b;b=M[a+96>>2];g:{if(b){break g}b=0;if(c>>>0<j>>>0&(d|0)<=(s|0)|(d|0)<(s|0)){break g}b=(c-j|0)+e|0}M[a+96>>2]=b;break b}if(!N[p+87|0]){break b}}L[a+16>>1]=0;M[a+20>>2]=0;M[a+24>>2]=0;break a}L[a+16>>1]=t;M[a+24>>2]=q;sp(M[a+100>>2],t,p,1);M[a+20>>2]=m;sp(M[a+88>>2],m,p,0);if(!n){break a}D(M[a+96>>2],0,n)}nB(a);Na=o+16|0}function BJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Na+-64|0;Na=g;d=M[a+24>>2];h=M[d+8>>2];e=M[d+4>>2];f=M[d>>2];a:{b:{c:{d:{e:{f:{g:{c=N[b|0];switch(c-168|0){case 0:case 2:break f;case 1:break c;default:break g}}if((c|0)==179){break f}if(!(N[d+26|0]&2)){break e}d=M[f+76>>2];if(!d){break e}while(1){if(!d){break e}h:{a=M[d+4>>2];if((a|0)>=0){if(!mc(0,b,M[d>>2],a)){break h}}d=M[d+20>>2];continue}break}if(N[b+7|0]&3){break e}a=0;c=M[e>>2];c=(c|0)>0?c:0;while(1){if((a|0)==(c|0)){break e}a=a+1|0;if(M[e+24>>2]!=M[d+4>>2]){continue}break}if(M[b+40>>2]){break e}c=2;if(M[f+40>>2]){break a}a=g+12|0;D(a,0,52);K[g+12|0]=170;M[g+40>>2]=M[d+8>>2];L[g+44>>1]=M[d+12>>2];Yz(f,h,a);if(M[f+40>>2]){break a}a=L[g+46>>1];M[(M[h+20>>2]+(a<<4)|0)+4>>2]=b;L[b+34>>1]=a;M[b+40>>2]=h;break b}if(e){break d}}c=0;break a}c=0;a=M[e>>2];i=(a|0)>0?a:0;a=e+8|0;d=0;while(1){if((d|0)==(i|0)){break a}if(M[b+28>>2]==M[a+16>>2]){Yz(f,h,b);break a}else{a=a+48|0;d=d+1|0;continue}}}c=0;if(M[b+40>>2]|(N[d+26|0]&2|M[a+16>>2]!=N[b+2|0])){break a}e=h+36|0;a=M[h+32>>2];d=0;while(1){i:{c=M[e>>2];j:{if((c|0)<=(d|0)){break j}i=M[a>>2];if((i|0)==(b|0)){break j}if(mc(0,i,b,-1)){break i}c=M[e>>2]}k:{if((c|0)>(d|0)){break k}a=M[f>>2];i=N[a+84|0];c=Xz(a,M[h+32>>2],24,e,g+12|0);M[h+32>>2]=c;a=0;d=M[g+12>>2];if((d|0)<0){break k}c=c+S(d,24)|0;M[c>>2]=b;e=M[b+20>>2];if(e){a=M[e>>2]}e=re(M[f>>2],M[b+8>>2],a,i,0);M[c+4>>2]=e;i=M[b+12>>2];l:{if(!(!i|N[e+4|0]&32)){e=M[f+44>>2];M[f+44>>2]=e+1;M[c+16>>2]=e;m:{n:{if((a|0)!=1){break n}a=M[i+20>>2];if(M[a>>2]!=1){break n}if(mc(0,M[a+8>>2],M[M[b+20>>2]+8>>2],0)){break n}K[c+20|0]=0;K[c+21|0]=N[b+4|0]>>>2&1;break m}K[c+20|0]=1}K[c+22|0]=M[M[c+4>>2]+4>>2]>>>20&1;break l}M[c+16>>2]=-1}a=-1;if(!(N[c+21|0]|!(N[b+4|0]&4))){a=M[f+44>>2];M[f+44>>2]=a+1}M[c+8>>2]=a}M[b+40>>2]=h;L[b+34>>1]=d;break b}a=a+24|0;d=d+1|0;continue}}c=1}Na=g- -64|0;return c|0}function BI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=M[c+4>>2];e=O[f+16>>1];d=e&31;a:{if((e&63)>>>0>=32){e=1<<d;g=0}else{g=1<<d;e=g-1&1>>>32-d}b:{if(g&-1431655766|e&-1431655766){break b}if((b|0)==3){e=O[M[c+8>>2]+16>>1];d=e&31;if((e&63)>>>0>=32){e=1<<d;g=0}else{g=1<<d;e=g-1&1>>>32-d}if(g&-1431655766|e&-1431655766){break b}}d=O[M[c>>2]+16>>1];j=sb(f);h=Qa;f=M[c>>2];e=d&31;if((d&63)>>>0>=32){d=1<<e;g=0}else{g=1<<e;d=g-1&1>>>32-e}l=g&65537;e=d&65536;k=e;c:{if(e|l){i=Fb(f);g=od(M[c>>2]);if(!g){break b}break c}g=gb(f);if(!g){break b}if((h|0)>0|(h|0)>=0){break c}d=g;while(1){f=N[d|0];if(!f){break c}e=d+1|0;d=e;if(f>>>0>=192){while(1){d=e;e=d+1|0;if(K[d|0]<-64){continue}break}}i=i+1|0;continue}}d:{if((b|0)==3){b=sb(M[c+8>>2]);f=Qa;break d}b=M[M[M[a>>2]+20>>2]+120>>2];f=b>>31}e:{f:{if((h|0)<0){d=(i>>31)+h|0;c=i+j|0;d=c>>>0<i>>>0?d+1|0:d;if((d|0)>=0|(d|0)>0){e=c;h=d;break f}e=0;h=0;if((f|0)<0){b=0;f=0;break e}f=d+f|0;b=b+c|0;f=b>>>0<c>>>0?f+1|0:f;break f}if(h|j){e=j-1|0;h=h-!j|0;break f}e=0;h=0;c=b;d=!!c&(f|0)>=0|(f|0)>0;b=c-d|0;f=f-(c>>>0<d>>>0)|0}if((f|0)>0|(f|0)>=0){break e}c=0-(((e|0)!=0)+h|0)|0;d=0-e>>>0>b>>>0&(c|0)>=(f|0)|(c|0)>(f|0);c=d?e:0-b|0;f=d?h:0-(((b|0)!=0)+f|0)|0;d=e;b=c;e=d-c|0;h=h-((c>>>0>d>>>0)+f|0)|0}if(!(l|k)){while(1){c=N[g|0];if(!c|!(e|h)){break a}d=g+1|0;g=d;if(c>>>0>=192){while(1){g=d;d=d+1|0;if(K[g|0]<-64){continue}break}}c=e;e=c-1|0;h=h-!c|0;continue}}j=i>>31;c=j;c=e>>>0<i>>>0&(h|0)<=(c|0)|(c|0)>(h|0);d=(c?e:0)+g|0;g=i-e|0;k=g;g=b>>>0<g>>>0;e=j-((e>>>0>i>>>0)+h|0)|0;g=g&(f|0)<=(e|0)|(e|0)>(f|0);b=c?g?b:k:0;c=c?g?f:e:0;g:{if(!c&b>>>0>=2147483648|c){Ow(d,-1,a);break g}xj(a,d,b,0,-1)}}return}d=g;while(1){c=c&255;if(!(!c|!(b|f))){d=d+1|0;h:{if(c>>>0>191){e=d;while(1){d=e;e=d+1|0;c=K[d|0];if((c|0)<-64){continue}break}break h}c=N[d|0]}e=b;b=e-1|0;f=f-!e|0;continue}break}b=d-g|0;kg(a,g,b,b>>31,-1)}function as(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=M[a>>2];c=M[a+8>>2];a:{f=M[a+4>>2];if(M[f+88>>2]){b=M[f+12>>2];if(b){d=M[b>>2]}g=M[f+60>>2];b=M[e+60>>2];j=b-2|0;M[e+60>>2]=j;h=Gb(e);i=Gb(e);if(d){l=vc(e,d);m=vc(e,d)}k=b-1|0;$a(c,135,M[f+48>>2],h);gk(a,M[f+48>>2],l);b=f;while(1){if(b){$a(c,75,0,M[b+52>>2]);b=M[b+36>>2];continue}break}bb(c,23,g,j,M[f+88>>2]);o=M[c+108>>2];$a(c,135,g,i);bb(c,55,M[f+92>>2],j,i);b=N[f+20|0];b:{if((b|0)==67){break b}if((b|0)==86){bb(c,54,h,k,i);break b}j=0;p=M[f+12>>2];if(p){n=Ue(e,p,0,0);b=N[f+20|0]}if((b&255)==95){j=bb(c,54,h,0,i)}c:{if(n){gk(a,g,m);bb(c,90,m,l,d);Jc(c,n,-8);b=M[c+108>>2]+1|0;bb(c,14,b,k,b);break c}$a(c,9,0,k)}if(!j){break b}n=M[c+108>>2];M[(N[M[c>>2]+87|0]?74356:M[c+104>>2]+S(j,20)|0)+8>>2]=n}$q(a,f,g,0,M[a+20>>2]);pb(c,k);$a(c,39,g,o);b=M[c+108>>2];d:{if(N[M[c>>2]+87|0]){M[18591]=b;f=74356;break d}f=M[c+104>>2]+S(o,20)|0;M[f-12>>2]=b;f=f+20|0}M[f+8>>2]=b;zb(e,i);zb(e,h);if(d){ad(e,m,d);ad(e,l,d)}on(a,1);break a}b=f;while(1){if(!b){break a}h=M[b+44>>2];d=M[h+32>>2];e:{f:{if(!((d|0)!=50960&(d|0)!=50970)){i=M[b+60>>2];g=M[e+60>>2]-1|0;M[e+60>>2]=g;d=Gb(e);$a(c,75,0,M[b+56>>2]);g:{if(M[h+32>>2]==50960){bb(c,94,M[f+48>>2],M[b+80>>2]+1|0,d);pn(e,d,2);break g}$a(c,71,1,d)}bb(c,107,d,M[b+64>>2],d);bb(c,55,M[b+64>>2]+1|0,g,d);bb(c,30,i,0,d);bb(c,94,i,M[b+80>>2],M[b+56>>2]);break f}if((d|0)!=50726&(d|0)!=50731){break e}k=M[b+60>>2];l=M[M[M[b+72>>2]+20>>2]>>2];g=M[e+60>>2]-1|0;M[e+60>>2]=g;d=Gb(e);i=M[f+48>>2];h:{if((l|0)<=2){$a(c,75,0,M[b+56>>2]);break h}bb(c,94,i,M[b+80>>2]+2|0,M[b+56>>2])}$a(c,135,i,d);m=M[h+32>>2];i:{if((l|0)<=1){$a(c,86,d,(m|0)==50726?1:-1);break i}h=Gb(e);bb(c,94,i,M[b+80>>2]+1|0,h);bb(c,(m|0)==50726?107:108,h,d,d);zb(e,h)}bb(c,30,k,g,d);bb(c,94,k,M[b+80>>2],M[b+56>>2])}pb(c,g);zb(e,d)}b=M[b+36>>2];continue}}$a(c,10,M[a+16>>2],M[a+12>>2])}
function nw(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0;h=Na-320|0;Na=h;D(h+32|0,0,164);D(h+240|0,0,76);M[h+228>>2]=M[a+264>>2];M[a+264>>2]=h+28;M[h+28>>2]=a;if(e){M[h+272>>2]=e;K[h+251|0]=N[e+152|0]>>>2&3}a:{if(N[a+87|0]){cb(h+28|0,1162,0);i=7;M[a+64>>2]=7;break a}if(d&1){K[h+52|0]=1;L[a+308>>1]=0;M[a+304>>2]=M[a+304>>2]+1}K[h+53|0]=d;b:{if(N[a+95|0]){break b}e=0;while(1){if(M[a+20>>2]<=(e|0)){break b}c:{i=M[(M[a+16>>2]+(e<<4)|0)+4>>2];if(!i){break c}M[M[i+4>>2]+4>>2]=M[i>>2];i=Po(i,1,1);if(!i){break c}M[h>>2]=M[M[a+16>>2]+(e<<4)>>2];ae(a,i,8790,h);break a}e=e+1|0;continue}}if(M[a+412>>2]){km(a)}d:{e:{f:{g:{if(!((c|0)<0|(N[(b+c|0)-1|0]?0:c))){if(M[a+124>>2]<(c|0)){break f}e=Kd(a,b,c,0);if(e){pj(h+28|0,e);M[h+276>>2]=(M[h+276>>2]-e|0)+b;ib(a,e);break g}M[h+276>>2]=b+c;break g}pj(h+28|0,b)}if(g){M[g>>2]=M[h+276>>2]}h:{if(N[a+177|0]){break h}c=M[h+36>>2];if(!c){break h}e=M[h+276>>2]-b|0;K[c+150|0]=d;if(d<<24>>24>=0){M[c+228>>2]=0}j=c,k=Kd(M[c>>2],b,e,e>>31),M[j+200>>2]=k}i:{j:{if(N[a+87|0]){K[h+45|0]=0;M[h+40>>2]=7;break j}b=M[h+40>>2];if(!b|(b|0)==101){break i}}if(N[a+177|0]|!N[h+45|0]){break e}b=M[h+28>>2];e=0;while(1){if(M[b+20>>2]<=(e|0)){break e}f=e<<4;c=M[(f+M[b+16>>2]|0)+4>>2];k:{if(!c){break k}l:{g=N[c+8|0];if(g){break l}d=Kf(c,0,0);if(!d){break l}if((d|0)!=3082&(d|0)!=7){break e}Lb(b);M[h+40>>2]=7;break e}Gh(c,1,h+316|0);d=M[(f+M[b+16>>2]|0)+12>>2];if(M[h+316>>2]!=M[d>>2]){if(K[d+78|0]&1){M[h+40>>2]=17}rj(b,e)}if(g){break k}oo(c)}e=e+1|0;continue}}M[f>>2]=M[h+36>>2];M[a+64>>2]=0;M[a+68>>2]=-1;i=0;b=M[a+288>>2];if(!b){break d}dc(b);break d}ae(a,18,12542,0);i=qd(a,18);break a}b=M[h+36>>2];if(b){Mf(b)}i=M[h+40>>2];b=M[h+32>>2];if(b){M[h+16>>2]=b;ae(a,i,8932,h+16|0);eb(a,M[h+32>>2]);break d}Yc(a,i)}while(1){b=M[h+168>>2];if(!b){break a}M[h+168>>2]=M[b+4>>2];ib(a,b);continue}}qi(h+28|0);Na=h+320|0;return i}function gp(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Na-112|0;Na=e;K[a+177|0]=1;f=M[a+24>>2];M[e+100>>2]=0;M[e+96>>2]=25231;M[e+92>>2]=24170;i=(b|0)==1?9290:9309;M[e+88>>2]=i;M[e+84>>2]=i;M[e+80>>2]=14426;M[e+32>>2]=0;M[e+28>>2]=b;M[e+20>>2]=a;M[e+40>>2]=0;M[e+44>>2]=0;M[e+36>>2]=d;M[e+24>>2]=c;iu(e+20|0,e,e+80|0,e);M[a+24>>2]=M[a+24>>2]&(f|-65);d=M[e+32>>2];a:{b:{if(d){break b}h=M[a+16>>2];g=h+(b<<4)|0;d=M[g+4>>2];if(!d){b=M[h+28>>2];L[b+78>>1]=O[b+78>>1]|1;d=0;break a}M[M[d+4>>2]+4>>2]=M[d>>2];c:{j=N[d+8|0];if(j){break c}d=Kf(d,0,0);if(!d){break c}Xf(c,a,Yg(d));break b}d=0;while(1){if((d|0)!=5){f=d+1|0;Gh(M[g+4>>2],f,(e+48|0)+(d<<2)|0);d=f;continue}break}d:{e:{if(N[a+35|0]&2){M[e- -64>>2]=0;M[e+56>>2]=0;M[e+60>>2]=0;M[e+48>>2]=0;M[e+52>>2]=0;d=M[g+12>>2];M[d>>2]=0;break e}f=M[e+64>>2];d=M[g+12>>2];M[d>>2]=M[e+48>>2];if(!f){break e}if(!(N[a+24|0]&64|b)){d=f&3;kp(a,d?d:1);d=M[g+12>>2];break e}if(N[a+84|0]==(f&3)){break e}Xf(c,a,13663);d=1;break d}K[d+77|0]=N[a+84|0];if(!M[d+80>>2]){f=d;d=M[e+56>>2];d=(d|0)<0?(d|0)==-2147483648?2147483647:0-d|0:d;d=d?d:-2e3;M[f+80>>2]=d;gj(M[g+4>>2],d);d=M[g+12>>2]}f=M[e+52>>2];K[d+76|0]=f;f:{k=f&255;if(!k){K[d+76|0]=1;break f}if(k>>>0<5){break f}Xf(c,a,3611);d=1;break d}if(!((f|0)<4|b)){d=M[a+36>>2];M[a+32>>2]=M[a+32>>2]&-3;M[a+36>>2]=d}M[e+44>>2]=M[M[M[g+4>>2]+4>>2]+48>>2];c=M[M[a+16>>2]+(b<<4)>>2];M[e+4>>2]=i;M[e>>2]=c;c=tb(a,15124,e);f=M[a+364>>2];M[a+364>>2]=0;d=ke(a,c,4,e+20|0,0);M[a+364>>2]=f;f=M[e+32>>2];eb(a,c);g:{h:{d=d?d:f;i:{if(!d){ju(a,b);if(N[a+87|0]){break i}break g}if(!N[a+87|0]){break h}}Jf(a);h=M[a+16>>2];d=7;break d}if(!(N[a+35|0]&8)|(d|0)==7){break d}}c=M[(M[a+16>>2]+(b<<4)|0)+12>>2];L[c+78>>1]=O[c+78>>1]|1;d=0}if(j){break b}oo(M[((b<<4)+h|0)+4>>2])}if(!d){break a}if(!((d|0)!=3082&(d|0)!=7)){Lb(a)}rj(a,b)}K[a+177|0]=0;Na=e+112|0;return d}function mm(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(!b){break a}h=M[a+8>>2];g=M[a+12>>2];e=M[a+20>>2];d=e;f=M[a+16>>2];i=c+f|0;d=i>>>0<c>>>0?d+1|0:d;i=i+2|0;d=i>>>0<2?d+1|0:d;if((d|0)==(g|0)&h>>>0<=i>>>0|d>>>0>g>>>0){if(fh(a,c+2|0)){break a}e=M[a+20>>2];f=M[a+16>>2]}d=f+1|0;if(!d){e=e+1|0}M[a+16>>2]=d;M[a+20>>2]=e;K[M[a+4>>2]+f|0]=34;while(1){g=0;b:{c:{d:{e:{while(1){f:{f=g|3;if(f>>>0>=c>>>0){d=g;while(1){if(c>>>0<=d>>>0){break f}if(!N[N[b+d|0]+52896|0]){break e}d=d+1|0;continue}}if(!N[N[b+g|0]+52896|0]){d=g;break e}d=g|1;if(!N[N[d+b|0]+52896|0]){break e}d=g|2;if(!N[N[d+b|0]+52896|0]){break e}d=f;if(!N[N[d+b|0]+52896|0]){break e}g=g+4|0;continue}break}f=M[a+16>>2];d=c>>>0>g>>>0?c:g;c=M[a+20>>2];if(!d){break c}break d}if(c>>>0>d>>>0){break b}f=M[a+16>>2]}if(d){G(M[a+4>>2]+f|0,b,d)}e=M[a+20>>2];f=d+M[a+16>>2]|0;c=f>>>0<d>>>0?e+1|0:e}d=c;b=f+1|0;d=b?d:d+1|0;M[a+16>>2]=b;M[a+20>>2]=d;K[f+M[a+4>>2]|0]=34;break a}if(d){if(d){G(M[a+4>>2]+M[a+16>>2]|0,b,d)}e=M[a+20>>2];f=d+M[a+16>>2]|0;e=f>>>0<d>>>0?e+1|0:e;M[a+16>>2]=f;M[a+20>>2]=e;c=c-d|0;b=b+d|0}g:{h:{i:{g=N[b|0];if((g|0)!=92){if((g|0)==39){break i}if((g|0)!=34){break h}}i=M[a+8>>2];h=M[a+12>>2];e=M[a+20>>2];d=e;f=M[a+16>>2];j=c+f|0;d=j>>>0<c>>>0?d+1|0:d;j=j+3|0;d=j>>>0<3?d+1|0:d;if((d|0)==(h|0)&i>>>0<j>>>0|d>>>0>h>>>0){if(fh(a,c+3|0)){break a}e=M[a+20>>2];f=M[a+16>>2]}d=f+1|0;if(!d){e=e+1|0}M[a+16>>2]=d;M[a+20>>2]=e;K[M[a+4>>2]+f|0]=92;e=M[a+20>>2];f=M[a+16>>2];d=f+1|0;e=d?e:e+1|0;M[a+16>>2]=d;M[a+20>>2]=e;K[f+M[a+4>>2]|0]=g;break g}d=M[a+20>>2];f=M[a+16>>2];e=f+1|0;d=e?d:d+1|0;M[a+16>>2]=e;M[a+20>>2]=d;K[f+M[a+4>>2]|0]=39;break g}d=M[a+8>>2];f=M[a+12>>2];e=M[a+20>>2];h=c+M[a+16>>2]|0;e=h>>>0<c>>>0?e+1|0:e;h=h+7|0;e=h>>>0<7?e+1|0:e;if((e|0)==(f|0)&d>>>0<h>>>0|e>>>0>f>>>0){if(fh(a,c+7|0)){break a}}jz(a,g)}c=c-1|0;b=b+1|0;continue}}}function Uj(a,b,c){var d=0,e=0,f=0,g=0,h=0;h=Na-16|0;Na=h;a:{if(N[a+17|0]<=1){e=0;if(N[a+18|0]<2){break a}}dv(a);g=M[a+68>>2];f=M[g>>2];b:{if(!f){break b}if((f|0)==33496){mv(g);M[g>>2]=0;break b}c:{d:{e:{f:{g:{h:{d=N[a+5|0];switch(d-1|0){case 0:break f;case 2:break h;default:break g}}if(!(M[a+80>>2]|M[a+84>>2])){break d}d=Ra[M[f+16>>2]](g,0,0)|0;if(d){break c}if(!N[a+8|0]){break d}d=0;b=N[a+10|0];if(!b){break c}d=M[a+68>>2];d=Ra[M[M[d>>2]+20>>2]](d,b)|0;break c}if(!N[a+4|0]|d>>>0>4){break e}}d=1;d=b?d:N[a+12|0]!=0;i:{if(!(M[a+80>>2]|M[a+84>>2])){d=0;break i}e=M[a+176>>2];b=M[a+180>>2];j:{if((!(e|b)|d)==1){d=Ra[M[f+16>>2]](g,0,0)|0;break j}d=Ra[M[f+12>>2]](g,33584,28,0,0)|0}if(d){break i}d=0;if(!N[a+7|0]){d=M[a+68>>2];d=Ra[M[M[d>>2]+20>>2]](d,N[a+10|0]|16)|0}if(!e&(b|0)<=0|(b|0)<0|d){break i}d=M[a+68>>2];d=Ra[M[M[d>>2]+24>>2]](d,h+8|0)|0;if(d){break i}d=0;f=M[h+12>>2];if((b|0)>=(f|0)&e>>>0>=P[h+8>>2]|(b|0)>(f|0)){break i}d=M[a+68>>2];d=Ra[M[M[d>>2]+16>>2]](d,e,b)|0}M[a+80>>2]=0;M[a+84>>2]=0;break b}b=N[a+12|0];Ra[M[f+4>>2]](g)|0;d=0;M[g>>2]=0;if(b){break b}b=M[a>>2];e=M[b+28>>2];if(!e){break b}d=Ra[e|0](b,M[a+188>>2],N[a+9|0])|0;break b}d=0}M[a+80>>2]=0;M[a+84>>2]=0}dg(M[a+60>>2]);M[a+48>>2]=0;M[a+60>>2]=0;if(!d){k:{l:{if(!N[a+15|0]){if(!dz(a,c)){break l}}qq(M[a+228>>2]);e=M[a+228>>2];break k}e=M[a+228>>2];b=e;while(1){b=M[b>>2];if(b){L[b+28>>1]=O[b+28>>1]&65523;b=b+40|0;continue}break}M[e+8>>2]=M[e+4>>2]}cv(e,M[a+28>>2])}b=M[a+232>>2];m:{if(b){Vo(b);break m}if(!c|d){break m}d=0;b=M[a+28>>2];if(b>>>0>=P[a+36>>2]){break m}d=lq(a,b)}n:{if(!c|d){break n}b=M[a+64>>2];c=M[b>>2];if(c){d=Ra[M[c+40>>2]](b,22,0)|0;if((d|0)!=12){break n}}d=0}b=0;o:{if(N[a+4|0]){break o}c=M[a+232>>2];if(c){b=0;if(!bv(c,0)){break o}}b=Og(a,1)}K[a+20|0]=0;K[a+17|0]=1;e=d?d:b}Na=h+16|0;return e}function gw(a,b){var c=0;c=Na-16|0;Na=c;a:{if(!(!M[16918]|(((a&63)>>>0<32?1<<a:0)&16842752)!=0&a>>>0<=63)){_c(181973);break a}M[c+12>>2]=b;b:{switch(a-4|0){case 0:a=M[c+12>>2];M[c+12>>2]=a+4;a=M[a>>2];b=M[a+4>>2];M[16874]=M[a>>2];M[16875]=b;b=M[a+28>>2];M[16880]=M[a+24>>2];M[16881]=b;b=M[a+20>>2];M[16878]=M[a+16>>2];M[16879]=b;b=M[a+12>>2];M[16876]=M[a+8>>2];M[16877]=b;break a;case 1:if(!M[16874]){mx()}a=M[c+12>>2];M[c+12>>2]=a+4;b=M[16875];a=M[a>>2];M[a>>2]=M[16874];M[a+4>>2]=b;b=M[16881];M[a+24>>2]=M[16880];M[a+28>>2]=b;b=M[16879];M[a+16>>2]=M[16878];M[a+20>>2]=b;b=M[16877];M[a+8>>2]=M[16876];M[a+12>>2]=b;break a;case 5:a=M[c+12>>2];M[c+12>>2]=a+4;M[16866]=M[a>>2];break a;case 23:a=M[c+12>>2];M[c+12>>2]=a+4;K[67472]=M[a>>2];break a;case 3:a=M[c+12>>2];M[c+12>>2]=a+4;M[16912]=M[a>>2];M[16913]=M[a+4>>2];M[c+12>>2]=a+12;M[16914]=M[a+8>>2];break a;case 20:a=M[c+12>>2];M[c+12>>2]=a+4;M[M[a>>2]>>2]=168;break a;case 14:a=M[c+12>>2];M[c+12>>2]=a+4;G(67564,M[a>>2],52);break a;case 15:if(!M[16893]){Qw()}a=M[c+12>>2];M[c+12>>2]=a+4;G(M[a>>2],67564,52);break a;case 9:a=M[c+12>>2];M[c+12>>2]=a+4;M[16871]=M[a>>2];M[c+12>>2]=a+8;M[16872]=M[a+4>>2];break a;case 12:a=M[c+12>>2];M[c+12>>2]=a+4;b=M[a>>2];M[c+12>>2]=a+8;M[16926]=M[a+4>>2];M[16925]=b;break a;case 13:a=M[c+12>>2];M[c+12>>2]=a+4;K[67470]=M[a>>2];break a;case 16:a=M[c+12>>2];M[c+12>>2]=a+4;K[67471]=M[a>>2];break a;case 18:M[16908]=0;M[16909]=0;M[16910]=0;M[16911]=0;M[c+12>>2]=(M[c+12>>2]+7&-8)+16;break a;case 21:a=M[c+12>>2];M[c+12>>2]=a+4;M[16917]=M[a>>2];break a;case 22:a=M[c+12>>2];M[c+12>>2]=a+4;M[16873]=M[a>>2];break a;case 25:a=M[c+12>>2]+7&-8;M[c+12>>2]=a+8;b=M[a+4>>2];M[16928]=M[a>>2];M[16929]=b;break a;case 26:a=M[c+12>>2];M[c+12>>2]=a+4;M[M[a>>2]>>2]=0;break;case 10:break a;default:break b}}}Na=c+16|0}function Kq(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;f=Na-32|0;Na=f;M[f+28>>2]=0;e=M[c>>2]+d|0;a:{if((N[e|0]&15)!=12){g=c;c=f+28|0;d=jc(g,d,c);i=M[f+28>>2];$e(a,b,jc(a,b,c)+M[f+28>>2]|0,e,d+i|0);h=N[a+35|0]?3:0;break a}if((N[M[a>>2]+b|0]&15)!=12){$e(a,jc(a,b,f+28|0)+b|0,M[f+28>>2],0,0);e=M[a>>2]+b|0;K[e|0]=N[e|0]&240|12}b:{e=f+28|0;i=jc(c,d,e);if(!i){break b}l=M[f+28>>2];e=jc(a,b,e);if(!e){h=1;break a}i=d+i|0;o=l+i|0;l=b+e|0;B=l+M[f+28>>2]|0;c:{while(1){e=i;if(e>>>0<o>>>0){m=M[c>>2];d=N[e+m|0]&15;if(d-11>>>0<4294967292){break b}p=jc(c,e,f+16|0);if(!p){break b}q=M[f+16>>2];g=e+p|0;k=q+g|0;if(o>>>0<=k>>>0){break b}r=jc(c,k,f+12|0);if(!r){break b}w=M[f+12>>2];i=w+(k+r|0)|0;if(i>>>0>o>>>0){break b}C=(d|0)==7|(d|0)==10;D=g+m|0;x=M[a+40>>2];j=x+B|0;d=l;d:{while(1){g=d;if(d>>>0>=j>>>0){break d}h=1;y=M[a>>2];s=N[y+d|0]&15;if(s-11>>>0<4294967292){break a}t=jc(a,d,f+24|0);if(!t){break a}u=M[f+24>>2];z=d+t|0;n=u+z|0;if(n>>>0>=j>>>0){break a}v=jc(a,n,f+20|0);if(!v){break a}A=M[f+20>>2];d=A+(n+v|0)|0;if(j>>>0<d>>>0){break a}if(!oz(D,q,C,y+z|0,u,(s|0)==7|(s|0)==10)){continue}break}if(!(N[k+m|0]&15)){$e(a,g,((t+v|0)+u|0)+A|0,0,0);if(!N[a+35|0]){continue}break c}M[a+40>>2]=0;h=Kq(a,n,c,k);if(h){break a}M[a+40>>2]=M[a+40>>2]+x;continue}g=N[k+m|0]&15;if(!g){continue}d=p+q|0;if((g|0)!=12){g=r+w|0;$e(a,j,0,0,g+d|0);if(N[a+35|0]){break c}if(d){G(M[a>>2]+j|0,e+M[c>>2]|0,d)}if(!g){continue}G(d+(M[a>>2]+j|0)|0,M[c>>2]+k|0,g);continue}$e(a,j,0,0,d+1|0);if(N[a+35|0]){break c}if(d){G(M[a>>2]+j|0,e+M[c>>2]|0,d)}d=d+j|0;K[d+M[a>>2]|0]=0;e=M[a+40>>2];M[a+40>>2]=0;h=Kq(a,d,c,k);if(h){break a}M[a+40>>2]=e+M[a+40>>2];continue}break}if(M[a+40>>2]){Hq(a,b)}h=N[a+35|0]?3:0;break a}h=3;break a}h=2}Na=f+32|0;return h}function ry(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=Na-32|0;Na=g;a:{m=M[a>>2];if(M[m+40>>2]){break a}p=(d|0)>0?d:0;d=0;while(1){if((d|0)!=(p|0)){e=S(d,24)+c|0;if(M[e+12>>2]==(b|0)){n=n+1|0;f=M[e+16>>2]+f|0}d=d+1|0;continue}break}e=0;if(!f|(n|0)<2){break a}j=M[a+60>>2];b:{if(j){break b}M[g+16>>2]=0;M[g+20>>2]=0;M[g+8>>2]=0;M[g+12>>2]=0;c:{e=_x(m,g+28|0);if(!e){i=M[g+28>>2];d=Ye(i,0);d:{if(!d){break d}f=Wd(i,0)+d|0;d=Ul(d,f,g+16|0)+d|0;while(1){if(d>>>0<f>>>0){d=Ul(d,f,g+8|0)+d|0;continue}break}f=M[g+20>>2];h=f;d=M[g+16>>2];if(!(f|d)){break d}e=M[g+8>>2];j=M[g+12>>2];if(e|j){break c}}wb(i);e=267}j=0;break b}M[a+64>>2]=d;M[a+68>>2]=h;f=M[m+244>>2];h=_J(e,j,d,h);e=f+h|0;j=f>>31;d=j+Qa|0;s=a,t=_J(e,e>>>0<h>>>0?d+1|0:d,f,j),M[s+60>>2]=t;e=wb(i);j=M[a+60>>2]}q=n-1|0;i=1;while(1){if((k|0)>=(n|0)){break a}d=0;f=0;if(e){break a}while(1){if((d|0)!=(p|0)){e=S(d,24)+c|0;if(!(!M[e+8>>2]|M[e+12>>2]!=(b|0)|(M[e+16>>2]>=M[f+16>>2]?f:0))){f=e}d=d+1|0;continue}break}e:{f:{if(!k){i=i<<2;break f}d=(i|0)/4|0;if(M[f+16>>2]>=(S(((d+o|0)-1|0)/(d|0)|0,j)|0)){e=M[f+20>>2];h=M[f+8>>2];d=Bb(16,0);if(d){M[d+4>>2]=0;M[d+8>>2]=0;M[d>>2]=h;M[d+12>>2]=0;l=M[a+28>>2];M[d+4>>2]=e;M[d+8>>2]=l;M[a+28>>2]=d;M[h+16>>2]=d;e=0}else{e=7}aq(M[h+20>>2]);M[h+20>>2]=0;break e}i=k>>>0<12?i<<2:i;e=0;if((k|0)==(q|0)|M[M[f>>2]+64>>2]<2){break e}}d=M[f+8>>2];M[g+8>>2]=0;M[g+28>>2]=0;e=Zx(m,d,M[f+20>>2],g+8|0,g+28|0);if(e){break e}e=Yx(m,M[f>>2],M[f+4>>2],M[g+28>>2],M[g+8>>2]);if(e){break e}e=0;h=0;g:{l=M[f>>2];d=M[l>>2];if(!d){break g}l=M[l+4>>2]+d|0;while(1){if(d>>>0>=l>>>0){break g}while(1){r=K[d|0];d=d+1|0;if((r|0)<0){continue}break}M[g+16>>2]=d;xe(0,g+16|0);h=h+1|0;d=M[g+16>>2];continue}}o=k?(h|0)<(o|0)?h:o:h}M[f+8>>2]=0;k=k+1|0;continue}}Na=g+32|0;return e}function KC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;g=Na-32|0;Na=g;m=M[a+8>>2];k=(m|0)<=0;f=m;h=(c>>31)+e|0;a:{b:{c:{j=c+d|0;h=j>>>0<c>>>0?h+1|0:h;if((h|0)<0){f=1}else{f=(h|0)<=0&f>>>0>=j>>>0}if(!(f|k)){k=M[a+16>>2];n=M[a+20>>2];o=M[a+12>>2];r=M[a+4>>2];v=M[a>>2];f=M[a+44>>2];M[g+24>>2]=M[a+40>>2];M[g+28>>2]=f;f=M[a+36>>2];M[g+16>>2]=M[a+32>>2];M[g+20>>2]=f;f=M[a+28>>2];M[g+8>>2]=M[a+24>>2];M[g+12>>2]=f;w=M[a+60>>2];s=M[a+56>>2];p=M[a+52>>2];t=M[a+48>>2];D(a,0,64);d:{i=Ra[M[p+24>>2]](p,s,a,t&17334143,0)|0;if(i){break d}f=r;j=o;while(1){if(!j){break c}h=k-l|0;i=(f>>31)+q|0;u=f+l|0;i=u>>>0<f>>>0?i+1|0:i;f=k>>>0<u>>>0&(i|0)>=(n|0)|(i|0)>(n|0)?h:f;i=Ra[M[M[a>>2]+12>>2]](a,j+4|0,f,l,q)|0;if(i){break d}h=(f>>31)+q|0;l=f+l|0;q=l>>>0<f>>>0?h+1|0:h;j=M[j>>2];continue}}b=M[a>>2];if(b){Ra[M[b+4>>2]](a)|0}M[a+16>>2]=k;M[a+20>>2]=n;M[a+12>>2]=o;M[a+8>>2]=m;M[a+4>>2]=r;M[a>>2]=v;c=M[g+28>>2];b=a+24|0;M[b+16>>2]=M[g+24>>2];M[b+20>>2]=c;c=M[g+20>>2];M[b+8>>2]=M[g+16>>2];M[b+12>>2]=c;c=M[g+12>>2];M[b>>2]=M[g+8>>2];M[b+4>>2]=c;M[a+60>>2]=w;M[a+56>>2]=s;M[a+52>>2]=p;M[a+48>>2]=t;break a}if(!!d&(e|0)>=0|(e|0)>0){if(M[a+16>>2]==(d|0)&M[a+20>>2]==(e|0)){break b}Zo(a,d,e);break b}if(d|e){break b}d=M[a+12>>2];if(!d){break b}if(c){G(d+4|0,b,c)}break a}il(o);i=Ra[M[M[a>>2]+12>>2]](a,b,c,d,e)|0;break a}while(1){if((c|0)<=0){break a}d=M[a+24>>2];h=M[a+4>>2];e=h;e=$J(M[a+16>>2],M[a+20>>2],e,e>>31);e:{if(e|Qa){f=d;break e}f=tc(h+4|0);if(!f){i=3082;break a}M[f>>2]=0;f:{if(d){M[d>>2]=f;break f}M[a+12>>2]=f}M[a+24>>2]=f}d=h-e|0;d=(c|0)<(d|0)?c:d;if(d){G((e+f|0)+4|0,b,d)}e=M[a+20>>2]+(d>>31)|0;f=d+M[a+16>>2]|0;e=f>>>0<d>>>0?e+1|0:e;M[a+16>>2]=f;M[a+20>>2]=e;c=c-d|0;b=b+d|0;continue}}Na=g+32|0;return i|0}function HA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;f=Na-608|0;Na=f;h=M[a>>2];j=M[a+8>>2];m=M[a+4>>2];l=M[m+24>>2];g=M[m+12>>2];D(f+112|0,0,56);a:{q=M[h+4>>2]+S(N[j+16|0],48)|0;if(N[q+20|0]&16){break a}v=S(g,48)+l|0;w=M[q+24>>2];s=f+8|0;t=f- -64|0;r=f+120|0;while(1){if(l>>>0>=v>>>0|i){break a}i=0;b:{if(!(N[l+13|0]&2)){break b}h=M[l+24>>2];if(!(M[j+8>>2]&M[h+416>>2]|M[j+12>>2]&M[h+420>>2])){break b}k=M[h+24>>2];h=M[h+12>>2];g=M[a+12>>2];M[f+176>>2]=M[a+8>>2];M[f+180>>2]=g;g=M[a+20>>2];M[f+184>>2]=M[a+16>>2];M[f+188>>2]=g;g=M[a+4>>2];M[f+168>>2]=M[a>>2];M[f+172>>2]=g;x=S(h,48)+k|0;M[f+180>>2]=f+56;g=1;while(1){c:{d:{e:{if(k>>>0<x>>>0){if(N[k+13|0]&4){i=M[k+24>>2]}else{if(M[k+20>>2]!=(w|0)){break c}i=M[m>>2];M[f+216>>2]=k;M[f+212>>2]=1;M[f+204>>2]=1;K[f+200|0]=44;M[f+196>>2]=m;M[f+192>>2]=i;i=f+192|0}L[f+56>>1]=0;M[f+172>>2]=i;f:{if(N[M[q+16>>2]+43|0]==1){i=JA(f+168|0,b,c,d,e);break f}i=IA(f+168|0,b,c)}if(!i){i=HA(f+168|0,b,c,d,e)}n=O[f+56>>1];if(!n){L[f+112>>1]=0;h=0;break e}if(g){L[f+112>>1]=n;h=n<<4;if(!h){break d}G(r,t,h);break d}u=O[f+112>>1];h=u<<4;if(h){G(s,r,h)}o=0;L[f+112>>1]=0;while(1){if((o|0)==(u|0)){break d}g=(o<<4)+s|0;y=L[g+10>>1];z=L[g+8>>1];h=M[g>>2];A=M[g+4>>2];g=0;while(1){if((g|0)!=(n|0)){p=(g<<4)+t|0;fA(f+112|0,M[p>>2]|h,A|M[p+4>>2],ie(z,L[p+8>>1]),ie(y,L[p+10>>1]));g=g+1|0;continue}break}o=o+1|0;continue}}h=O[f+112>>1]}L[j+44>>1]=1;M[M[j+52>>2]>>2]=l;g=0;L[j+18>>1]=0;M[j+40>>2]=8192;K[j+17|0]=0;M[j+32>>2]=0;M[j+36>>2]=0;M[j+24>>2]=0;M[j+28>>2]=0;while(1){if(g>>>0>=h>>>0|i){break b}i=(g<<4)+r|0;L[j+20>>1]=O[i+8>>1]+1;L[j+22>>1]=O[i+10>>1];k=M[i+4>>2];M[j>>2]=M[i>>2];M[j+4>>2]=k;g=g+1|0;i=hk(a,j);continue}}g=0}k=k+48|0;continue}}l=l+48|0;continue}}Na=f+608|0;return i}function mc(a,b,c,d){var e=0,f=0,g=0,h=0;if(!(c?b:0)){return(b|0)!=(c|0)?2:0}if(!(!a|N[b|0]!=157)){d=Na-16|0;Na=d;M[d+12>>2]=0;a:{if(N[c|0]==157&O[b+32>>1]==O[c+32>>1]){break a}e=2;f=M[a>>2];if(N[f+34|0]&128){break a}oj(f,c,1,65,d+12|0);c=M[d+12>>2];if(!c){break a}e=M[a+8>>2];b=L[b+32>>1];M[e+228>>2]=M[e+228>>2]|((b|0)>31?-2147483648:1<<b-1);a=yr(M[a+244>>2],b);if(a){e=O[a+16>>1];b=e&31;if((e&63)>>>0>=32){e=1<<b;f=0}else{f=1<<b;e=f-1&1>>>32-b}if(f&262148|e&262144){gb(a)}e=Ih(a,c,0)?2:0}else{e=2}Xc(c);Xc(a)}Na=d+16|0;return e}b:{c:{e=M[c+4>>2];f=M[b+4>>2];g=e|f;d:{e:{if(g&2048){if(!(e&f&2048)){break b}if(M[b+8>>2]==M[c+8>>2]){break e}break b}e=N[b|0];f=N[c|0];if(!((e|0)!=72&(f|0)==(e|0))){if((e|0)==114){if(mc(a,M[b+12>>2],c,d)>>>0<2){break c}f=N[c|0]}if((f|0)==114){if(mc(a,b,M[c+12>>2],d)>>>0<2){break c}}f=2;if(N[b|0]!=170|N[c|0]!=168|M[c+28>>2]>=0){break d}e=170;if(M[b+28>>2]!=(d|0)){break d}}h=M[b+8>>2];f:{if(!h){break f}g:{h:{switch(e-169|0){default:if((e|0)==114){break g}if((e|0)==122){break e}case 1:case 2:if((e&253)==168){break f}e=M[c+8>>2];if(!e){break f}if(Wc(h,e)){break b}break f;case 0:case 3:break h}}f=2;if(hb(h,M[c+8>>2])){break d}e=M[b+4>>2]&16777216;if((K[c+7|0]&1)!=(e>>>24|0)){break d}if(!e){break f}if(!lB(a,M[b+44>>2],M[c+44>>2],1)){break f}break d}if(hc(h,M[c+8>>2])){break b}}f=2;if((M[c+4>>2]^M[b+4>>2])&1028){break d}if(g&65536){break e}if(g&4096){break d}if(!(g&32)){if(mc(a,M[b+12>>2],M[c+12>>2],d)){break d}}if(mc(a,M[b+16>>2],M[c+16>>2],d)){break d}if(Qf(M[b+20>>2],M[c+20>>2],d)){break d}a=N[b|0];if(g&16384|((a|0)==118|(a|0)==171)){break e}if((a|0)==175&N[b+2|0]!=N[c+2|0]|O[b+32>>1]!=O[c+32>>1]){break d}if((a|0)==50){break e}a=M[b+28>>2];if((a|0)==(d|0)){break e}if((a|0)!=M[c+28>>2]){break d}}f=0}return f}return 1}return 2}function ds(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;a:{if(M[a+40>>2]){break a}j=M[a+8>>2];K[c|0]=1;g=M[c+32>>2];while(1){if(M[c+36>>2]>(p|0)){e=M[g>>2];n=M[e+20>>2];m=0;if(K[e+7|0]&1){e=M[M[e+44>>2]+40>>2];if(!(!(M[M[g+4>>2]+4>>2]&32)|(!M[c+28>>2]|!b))){if(!l){l=M[a+48>>2]+1|0;M[a+48>>2]=l}$a(j,80,b,l)}m=M[a+60>>2]-1|0;M[a+60>>2]=m;Dc(a,e,m,16)}b:{if(M[g+16>>2]>=0){f=M[M[M[g>>2]+12>>2]+20>>2];i=M[n>>2];o=(((M[f>>2]+!N[g+21|0]|0)+(N[g+20|0]?i:0)|0)+(N[g+22|0]?i:0)|0)+1|0;e=vc(a,o);kf(a,f,e,0,1);h=M[f>>2];if(!N[g+21|0]){$a(j,126,M[g+16>>2],e+h|0);h=h+1|0}c:{if(!N[g+20|0]){f=e;break c}f=e+h|0;kf(a,n,f,0,1);h=h+i|0}if(!N[g+22|0]){break b}q=N[g+20|0]?f:e;k=0;r=(i|0)>0?i:0;while(1){if((k|0)==(r|0)){break b}$a(j,181,k+q|0,e+h|0);h=h+1|0;k=k+1|0;continue}}if(!n){i=0;e=0;o=0;f=0;break b}o=0;i=M[n>>2];e=vc(a,i);kf(a,n,e,0,1);f=e}h=M[g+8>>2];if(!(!n|(h|0)<0)){if(!m){m=M[a+60>>2]-1|0;M[a+60>>2]=m}s=g,t=uA(a,d,h,m,n,f),M[s+8>>2]=t}d:{if(M[g+16>>2]>=0){f=o-1|0;i=f+e|0;bb(j,97,e,f,i);lb(j,138,M[g+16>>2],i,e,f);break d}if(N[M[g+4>>2]+4|0]&32){h=n+8|0;f=0;k=0;while(1){if(!((k|0)>=(i|0)|f)){k=k+1|0;f=Fd(a,M[h>>2]);h=h+16|0;continue}break}f=f?f:M[M[a>>2]+8>>2];e:{if(l){break e}if(!M[c+28>>2]){l=0;break e}l=M[a+48>>2]+1|0;M[a+48>>2]=l}nb(j,85,l,0,0,f,-2)}bb(j,162,0,e,M[c+24>>2]+(M[c+12>>2]+p|0)|0);Jc(j,M[g+4>>2],-7);f=M[j+108>>2];if((f|0)>0){L[(M[j+104>>2]+S(f,20)|0)-18>>1]=i}o=i}ad(a,e,o);if(m){pb(j,m)}if(M[a+40>>2]){break a}g=g+24|0;p=p+1|0;continue}break}f:{if(!l){e=0;if(!b){break f}l=b;if(!M[c+28>>2]){break f}}e=fb(j,16,l)}h=M[c+20>>2];k=0;while(1){if(M[c+28>>2]>(k|0)){kc(a,M[h+4>>2],M[c+12>>2]+k|0);if(M[a+40>>2]){break a}h=h+16|0;k=k+1|0;continue}break}K[c|0]=0;if(!e){break a}gn(j,e)}}function UD(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=Na-16|0;Na=g;a:{if(!a){break a}b=M[a+204>>2];if(b){break a}b=0;m=M[a+200>>2];if(!m){break a}i=M[a>>2];M[g+12>>2]=-1;b=Bb(24,0);if(b){f=i?M[i+120>>2]:1e9;L[b+20>>1]=0;M[b+16>>2]=0;M[b+12>>2]=f;M[b+8>>2]=0;M[b>>2]=0;M[b+4>>2]=0}else{b=67744}c=b;f=-1;while(1){b=f;b:{d=n+m|0;h=N[d|0];if(!(N[c+20|0]|!h)){j=_h(d,g+12|0);f=M[g+12>>2];if((j|0)>0){break b}b=f}if((b|0)!=1){Ab(c,23198,1)}b=a;a=0;if(!(!c|(c|0)==67744)){a=Rd(c);ab(c)}f=b;b=a;M[f+204>>2]=b;break a}l=(b|0)==184?l:b;c:{d:{e:{if(f-154>>>0<4){break e}f:{g:{switch(f-22|0){default:h:{i:{j:{switch(f-118|0){case 0:break e;case 1:case 2:case 3:break i;case 4:break h;default:break j}}if(f-184>>>0<2){break c}if((f|0)==60){break f}if((f|0)!=139){break i}e=0}if(N[h+31408|0]&70){up(c)}b=M[c+16>>2];Ab(c,d,j);while(1){if(P[c+16>>2]<=b>>>0){break c}h=M[c+4>>2]+b|0;d=N[h|0];K[h|0]=d&(N[d+31408|0]^-1|223);b=b+1|0;continue}}if((l|0)!=45&(l|0)!=19){break e}Ab(c,20300,5);break c;case 0:k=k+1|0;if((l|0)==50){e=M[c+16>>2];o=k}Ab(c,27788,1);break c;case 1:break g}}if(!((k|0)!=(o|0)|(e|0)<=0)){M[c+16>>2]=e+1;Ab(c,21315,5);e=0}Ab(c,27767,1);k=k-1|0;break c}b=M[c+16>>2];k:{if(K[h+31408|0]<0){e=Kd(i,d,j,0);M[g+8>>2]=0;if(!e){break d}zf(e);l:{m:{n:{o:{if(N[d|0]!=34){break o}d=M[a+208>>2];if(!d){break o}while(1){if(!d){break o}if(!Wc(e,d+4|0)){break n}d=M[d>>2];continue}}d=jb(e);if((_h(e,g+8|0)|0)!=(d|0)|M[g+8>>2]!=60){break m}up(c);Ab(c,e,d);break l}Ab(c,21953,1);ib(i,e);break d}M[g>>2]=e;rb(c,29425,g)}ib(i,e);break k}up(c);Ab(c,d,j)}while(1){if(P[c+16>>2]<=b>>>0){break d}e=M[c+4>>2]+b|0;K[e|0]=N[N[e|0]+31024|0];b=b+1|0;continue}}Ab(c,21953,1);break c}e=0}n=j+n|0;continue}}Na=g+16|0;return b|0}function AD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=Na-128|0;Na=e;h=12;a:{b:{c:{d:{switch(b-1|0){default:e:{switch(b-40|0){case 0:break c;case 3:break e;default:break a}}h=0;Ra[M[16948]](M[a+12>>2])|0;M[a+12>>2]=-1;break a;case 0:M[c>>2]=N[a+16|0];break b;case 3:M[c>>2]=M[a+20>>2];break b;case 5:M[a+40>>2]=M[c>>2];break b;case 4:if(M[a+40>>2]<=0){break b}g=M[c>>2];c=M[c+4>>2];h=0;if(Ra[M[16960]](M[a+12>>2],e+32|0)|0){h=1802;break a}b=M[a+40>>2];g=b+g|0;f=c;c=b>>31;d=f+c|0;f=g-1|0;d=(b>>>0>g>>>0?d+1|0:d)-!g|0;g=$J(f,d,b,c);c=f-g|0;k=d-(Qa+(g>>>0>f>>>0)|0)|0;f=k;l=M[e+60>>2];g=l;n=c;d=M[e+56>>2];if((f|0)<=(g|0)&c>>>0<=d>>>0|(g|0)>(f|0)){break a}g=c-1|0;i=M[e+64>>2];c=g+i|0;o=f-!n|0;m=i>>31;f=o+m|0;f=c>>>0<i>>>0?f+1|0:f;j=$J(d,l,i,m)^-1;b=j+d|0;d=(Qa^-1)+l|0;d=b>>>0<j>>>0?d+1|0:d;while(1){d=d+m|0;b=b+i|0;d=b>>>0<i>>>0?d+1|0:d;if((f|0)<=(d|0)&b>>>0>=c>>>0|(d|0)>(f|0)){break a}j=b>>>0<n>>>0&(d|0)<=(k|0)|(d|0)<(k|0);b=j?b:g;d=j?d:o;if((Ov(a,b,d,30808,1)|0)==1){continue}break};h=778;break a;case 9:Mv(a,4,c);break b;case 12:Mv(a,16,c);break b;case 11:M[e>>2]=M[M[a+4>>2]+16>>2];p=c,q=Hb(8932,e),M[p>>2]=q;break b;case 15:h=0;b=M[M[a+4>>2]+8>>2];b=Bb(b,b>>31);if(!b){break a}mu(M[M[a+4>>2]+8>>2],b);M[c>>2]=b;break a;case 1:case 2:case 6:case 7:case 8:case 10:case 13:case 14:case 16:case 17:case 18:break a;case 19:break d}}p=c,q=Lv(a),M[p>>2]=q;break b}h=0;M[c>>2]=0;a=M[a+36>>2];if(!a){break a}a=M[a>>2];M[e+56>>2]=0;M[e+60>>2]=0;M[e+48>>2]=5;M[e+52>>2]=0;M[e+40>>2]=123;M[e+44>>2]=0;M[e+32>>2]=0;M[e+36>>2]=0;L[e+32>>1]=1;a=M[a+12>>2];M[e+16>>2]=e+32;if((Ra[M[16966]](a,12,e+16|0)|0)<0){h=3850;break a}M[c>>2]=O[e+32>>1]!=2;break a}h=0}Na=e+128|0;return h|0}function Qq(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Na-16|0;Na=g;d=M[a+44>>2];a:{if(d){break a}e=M[16930];if(e){d=10;if(Ra[e|0](400)|0){break a}}b:{if(N[a+17|0]<3){break b}c:{if(!dz(a,1)){xq(M[a+96>>2]);break c}d:{if(M[a+232>>2]){M[g+8>>2]=0;d=uq(M[a+228>>2]);if(!d){Ra[M[a+220>>2]](a,1,g+8|0,0)|0;d=M[g+8>>2];M[d+16>>2]=0}d=Vy(a,d,M[a+28>>2],1);sd(M[g+8>>2]);if(d){break d}qq(M[a+228>>2]);break d}if(!(N[a+19|0]|!M[a+28>>2])){d=Ra[M[a+220>>2]](a,1,g+8|0,0)|0;e:{if(d){break e}d=ac(M[g+8>>2]);if(d){break e}pq(M[g+8>>2]);K[a+19|0]=1;d=0}sd(M[g+8>>2]);if(d){break a}}f:{if(!b|N[a+5|0]==4){break f}d=M[a+68>>2];if(!M[d>>2]){break f}K[a+20|0]=1;while(1){e=K[b+h|0];if(e){h=h+1|0;i=e+i|0;continue}break}g:{if(!N[a+8|0]){f=M[a+80>>2];e=M[a+84>>2];break g}f=bm(a);M[a+80>>2]=f;e=Qa;M[a+84>>2]=e}d=ji(d,f,e,M[a+164>>2]);if(d){break a}d=M[a+68>>2];f=f+4|0;e=f>>>0<4?e+1|0:e;d=Ra[M[M[d>>2]+12>>2]](d,b,h,f,e)|0;if(d){break a}d=M[a+68>>2];f=f+h|0;e=f>>>0<h>>>0?e+1|0:e;d=ji(d,f,e,h);if(d){break a}d=e;j=f+4|0;d=j>>>0<4?d+1|0:d;d=ji(M[a+68>>2],j,d,i);if(d){break a}d=M[a+68>>2];f=f+8|0;e=f>>>0<8?e+1|0:e;d=Ra[M[M[d>>2]+12>>2]](d,33572,8,f,e)|0;if(d){break a}e=M[a+84>>2];f=h+20|0;d=f;f=f+M[a+80>>2]|0;e=d>>>0>f>>>0?e+1|0:e;M[a+80>>2]=f;M[a+84>>2]=e;e=M[a+68>>2];d=Ra[M[M[e>>2]+24>>2]](e,g+8|0)|0;if(d){break a}f=M[a+84>>2];h=M[g+12>>2];e=M[a+80>>2];if((f|0)>=(h|0)&e>>>0>=P[g+8>>2]|(f|0)>(h|0)){break f}h=M[a+68>>2];d=Ra[M[M[h>>2]+16>>2]](h,e,f)|0;if(d){break a}}d=Dy(a,0);if(d){break a}d=zy(a,uq(M[a+228>>2]));if(d){break a}qq(M[a+228>>2]);e=M[a+28>>2];if(e>>>0>P[a+36>>2]){d=lq(a,e-((e|0)==M[a+164>>2])|0);if(d){break a}}if(c){break c}d=Pq(a,b)}if(d){break a}}if(M[a+232>>2]){break b}K[a+17|0]=5}d=0}Na=g+16|0;return d}function oq(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=Na-32|0;Na=h;i=K[d|0];a:{if((i|0)<0){yc(d,h+12|0);break a}M[h+12>>2]=i}j=267;b:{i=h+24|0;m=Ic(d,i)+d|0;k=Ic(m,i)+m|0;p=d+e|0;if(k>>>0>p>>>0){break b}m=g;e=0;i=0;n=f;while(1){c:{d:{if(k>>>0<p>>>0){if(!(m|n)){j=0;break d}j=0;M[h+16>>2]=0;e:{if(l&1){j=K[k|0];f:{if((j|0)<0){l=yc(k,h+16|0);j=M[h+16>>2];break f}M[h+16>>2]=j;l=1}if((j|0)>(i|0)){break e}k=k+l|0}i=K[k|0];g:{if((i|0)<0){i=yc(k,h+20|0);break g}M[h+20>>2]=i;i=1}o=i+k|0;if((o-d|0)<(j|0)){break e}k=M[h+20>>2];if((k|0)>(p-o|0)|!k){break e}i=(k>>31)+(j>>31)|0;l=j+k|0;i=l>>>0<j>>>0?i+1|0:i;if((i|0)<=(r|0)&l>>>0<=s>>>0|(i|0)<(r|0)){i=e;break c}i=i<<1|l>>>31;r=i;s=l<<1;i=Mc(e,s,i);if(i){break c}j=7;break d}j=267;break d}if(n){d=M[h+28>>2];M[n>>2]=M[h+24>>2];M[n+4>>2]=d}j=0;if(!m){break d}d=M[h+28>>2];M[m>>2]=M[h+24>>2];M[m+4>>2]=d}ab(e);break b}e=i;if(k){G(j+i|0,o,k)}i=j+k|0;q=Qb(b,e,(c|0)>(i|0)?i:c);l=M[h+24>>2];j=M[h+28>>2];h:{if(n){if(q|(c|0)>=(i|0)?(q|0)>=0:0){break h}M[n>>2]=l;M[n+4>>2]=j;j=M[h+28>>2];l=M[h+24>>2]}n=0;if(!m|(q|0)>=0){break h}M[m>>2]=l;M[m+4>>2]=j;m=0}k=k+o|0;l=l+1|0;j=l?j:j+1|0;M[h+24>>2]=l;M[h+28>>2]=j;l=1;continue}}i:{if(j){break i}i=M[h+12>>2];if((i|0)<2){break i}M[h+24>>2]=0;M[h+20>>2]=0;j:{k:{if(!f|!g){break k}d=M[f>>2];e=M[f+4>>2];if((d|0)==M[g>>2]&(e|0)==M[g+4>>2]){break k}j=dh(a,d,e,h+24|0,h+20|0);if(!j){j=oq(a,b,c,M[h+24>>2],M[h+20>>2],f,0)}ab(M[h+24>>2]);M[h+24>>2]=0;f=0;d=0;if(j){break j}}d=f?f:g;j=dh(a,M[d>>2],M[d+4>>2],h+24|0,h+20|0);d=M[h+24>>2];l:{if(j){break l}j=267;e=K[d|0];if((e|0)<0){yc(d,h+16|0);e=M[h+16>>2]}if((e|0)>=(i|0)){break l}j=oq(a,b,c,d,M[h+20>>2],f,g);d=M[h+24>>2]}}ab(d)}Na=h+32|0;return j}function hm(a,b,c){var d=0,e=0,f=0,g=0;a:{b:{c:{while(1){if(b>>>0<=1){M[c>>2]=629145;break a}d:{e:{d=N[a+1|0];switch(d-10|0){case 0:case 3:break d;case 1:case 2:break c;default:break e}}if((d|0)==226){break d}f:{g:{h:{i:{j:{k:{l:{m:{n:{switch(d-110|0){default:o:{p:{switch(d-47|0){case 0:break o;case 1:break g;default:break p}}q:{switch(d-98|0){case 0:break m;case 4:break l;case 1:case 2:case 3:break c;default:break q}}if((d|0)==34|(d|0)==39){break o}if((d|0)!=92){break c}}M[c>>2]=d;break b;case 1:case 2:case 3:case 5:case 9:break c;case 0:break k;case 4:break j;case 6:break i;case 7:break n;case 8:break h;case 10:break f}}if(b>>>0<=5){M[c>>2]=629145;break a}r:{d=kz(a+2|0);if((d&64512)!=55296|b>>>0<12|N[a+6|0]!=92|N[a+7|0]!=117){break r}a=kz(a+8|0);if((a&64512)!=56320){break r}M[c>>2]=(d<<10&1047552|a&1023)+65536;b=12;break a}M[c>>2]=d;b=6;break a}M[c>>2]=8;break b}M[c>>2]=12;break b}M[c>>2]=10;break b}M[c>>2]=13;break b}M[c>>2]=9;break b}M[c>>2]=11;break b}M[c>>2]=0;break b}if(b>>>0<=3){M[c>>2]=629145;break a}b=4;e=c;c=N[a+3|0];a=N[a+2|0];M[e>>2]=((c<<1<<24>>24>>>7&9)+c&15|(a<<1<<24>>24>>>7&9)+a<<4)&255;break a}d=0;while(1){s:{e=d;d=d+1|0;if(d>>>0>=b>>>0){break s}f=a+e|0;if(N[f|0]!=92){break s}t:{u:{v:{d=N[a+d|0];switch(d-10|0){case 1:case 2:break s;case 0:break v;case 3:break u;default:break t}}d=e+2|0;continue}d=e+2|0;if(d>>>0>=b>>>0){continue}d=N[a+d|0]==10?e+3|0:d;continue}if((d|0)!=226){break s}d=e+3|0;if(N[f+2|0]!=128|d>>>0>=b>>>0|(N[a+d|0]&254)!=168){break s}d=e+4|0;continue}break}if(!e){M[c>>2]=629145;break a}if((b|0)==(e|0)){M[c>>2]=0;break a}b=b-e|0;a=a+e|0;if(N[a|0]==92){g=e+g|0;continue}break}b=Cq(a,b,c)+e|0;break a}M[c>>2]=629145}b=2}return b+g|0}function Ly(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=Na-16|0;Na=f;a:{b:{c=M[b+72>>2];if(c){c=c+M[b+76>>2]|0}else{c=M[b+40>>2]}if(!(M[b+40>>2]+M[b+44>>2]>>>0>c>>>0?c:0)){c:{c=M[b+56>>2];d:{if(c){d=M[c>>2];ab(M[b+40>>2]);a=0;M[b+40>>2]=0;if(!d){break a}g=M[d+8>>2];h=M[g>>2];a=M[b+64>>2];c=M[d+16>>2];if((c|0)>=M[b+68>>2]){ab(a);a=c>>31<<1|c>>>31;e=(c<<1)+2|0;a=e>>>0<2?a+1|0:a;a=Bb(e,a);M[b+64>>2]=a;if(!a){break b}M[b+68>>2]=(c<<1)+2}if(c){G(a,M[d+12>>2],c)}K[c+M[b+64>>2]|0]=0;M[b+60>>2]=c;a=h+1|0;c=Bb(a,a>>31);if(!c){break b}if(a){G(c,M[g+4>>2],a)}M[b+72>>2]=c;M[b+44>>2]=a;M[b+76>>2]=a;M[b+40>>2]=c;M[b+56>>2]=M[b+56>>2]+4;break d}nq(b);d=M[b+32>>2];c=M[b+36>>2];e=M[b+20>>2];if(d>>>0<P[b+16>>2]&(c|0)<=(e|0)|(c|0)<(e|0)){break c}}a=0;break a}d=d+1|0;c=d?c:c+1|0;M[b+32>>2]=d;M[b+36>>2]=c;a=dh(a,d,c,b+40|0,b+44|0);if(a){break a}c=M[b+40>>2]}a=am(b,c,20);if(a){break a}a=K[c|0];e:{if((a|0)<0){a=yc(c,f+12|0);break e}M[f+12>>2]=a;a=1}d=a+c|0;c=K[d|0];f:{if((c|0)<0){a=yc(d,f+8|0);c=M[f+8>>2];break f}M[f+8>>2]=c;a=1}g:{if((c|0)<=0){break g}g=a+d|0;if(((M[b+40>>2]+M[b+44>>2]|0)-g|0)<(c|0)){break g}e=M[f+12>>2];if((e|0)>M[b+60>>2]){break g}a=e>>31;d=c+e|0;a=d>>>0<c>>>0?a+1|0:a;h=M[b+68>>2];i=h>>>0<d>>>0;h=h>>31;if(i&(h|0)<=(a|0)|(a|0)>(h|0)){a=a<<1|d>>>31;d=d<<1;a=Mc(M[b+64>>2],d,a);if(!a){break b}M[b+68>>2]=d;M[b+64>>2]=a}a=am(b,g,c+10|0);if(a){break a}if(c){G(e+M[b+64>>2]|0,g,c)}M[b+60>>2]=c+e;d=c+g|0;c=K[d|0];h:{if((c|0)<0){a=yc(d,b+76|0);c=M[b+76>>2];break h}M[b+76>>2]=c;a=1}M[b+80>>2]=0;d=a+d|0;M[b+72>>2]=d;if((M[b+40>>2]+(M[b+44>>2]-d|0)|0)<(c|0)){break g}if(!M[b+48>>2]){a=267;if(N[(c+d|0)-1|0]){break a}}a=c?0:267;break a}a=267;break a}a=7}Na=f+16|0;return a}function Sn(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0;j=Na-32|0;Na=j;h=M[a>>2];a:{b:{if(!(!N[h+177|0]|M[h+172>>2]!=1)){i=N[h+176|0];c=_b(h,(i|0)==1?9290:9309);break b}b=Tf(a,b,c,j+28|0);if((b|0)<0){break a}c:{if(!d){i=b;break c}i=1;if(!M[c+4>>2]|(b|0)==1){break c}cb(a,16339,0);break a}b=M[j+28>>2];c=zc(h,b);if(N[a+224|0]<2){break b}c=Ce(a,c,b)}k=M[b+4>>2];M[a+204>>2]=M[b>>2];M[a+208>>2]=k;if(!c){break a}d:{if(Gk(a,c,e?1856:14426,c)){break d}d=N[h+176|0]==1?1:d;k=M[M[h+16>>2]+(i<<4)>>2];if(gc(a,18,(d|0)==1?9290:9309,0,k)){break d}if(!f){if(gc(a,N[(d+(e<<1)|0)+50660|0],c,0,k)){break d}}e:{f:{if(N[a+224|0]){break f}d=M[M[h+16>>2]+(i<<4)>>2];if(de(a)){break d}k=Hc(h,c,d);if(k){if(g){break e}d=N[k+43|0];M[j+20>>2]=b;M[j+16>>2]=(d|0)==2?1856:14426;cb(a,3803,j+16|0);break d}if(!nf(h,c,d)){break f}M[j>>2]=c;cb(a,7174,j);break d}b=ub(h,64,0);if(!b){M[a+12>>2]=7;M[a+40>>2]=M[a+40>>2]+1;break d}L[b+32>>1]=65535;M[b>>2]=c;c=M[(M[h+16>>2]+(i<<4)|0)+12>>2];L[b+38>>1]=200;M[b+24>>2]=1;M[b+60>>2]=c;M[a+252>>2]=b;if(N[h+177|0]){break a}b=Cb(a);if(!b){break a}jd(a,1,i);if(f){Ub(b,170)}c=M[a+48>>2];d=c+2|0;M[a+104>>2]=d;g=c+1|0;M[a+100>>2]=g;c=c+3|0;M[a+48>>2]=c;bb(b,99,i,c,2);se(b,i);k=fb(b,16,c);bb(b,100,i,2,M[h+32>>2]&2?1:4);bb(b,100,i,5,N[h+84|0]);h=M[b+108>>2];M[(N[M[b>>2]+87|0]?74356:M[b+104>>2]+S(k,20)|0)+8>>2]=h;g:{if(e|f){$a(b,71,0,d);break g}l=a,m=bb(b,147,i,d,1),M[l+148>>2]=m}d=Cb(a);Dd(a,i,1,1,9309);lb(d,113,0,1,i,5);if(!M[a+44>>2]){M[a+44>>2]=1}$a(b,127,0,g);nb(b,77,6,c,0,50664,-1);bb(b,128,0,c,g);a=M[b+108>>2];if((a|0)>0){L[(M[b+104>>2]+S(a,20)|0)-18>>1]=8}Ub(b,122);break a}ud(a,i);Ek(a)}K[a+17|0]=1;ib(h,c)}Na=j+32|0}function Uy(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;i=Na-16|0;Na=i;j=M[M[a>>2]+12>>2];b=M[a+108>>2];f=M[a+104>>2]+1|0;b=f?b:b+1|0;M[a+104>>2]=f;M[a+108>>2]=b;b=M[a+116>>2];g=M[a+112>>2];f=g+1|0;f=(b|0)>(f|0)?b:f;a:{b:{while(1){g=g+1|0;if((b|0)<=(g|0)){break b}d=M[a+120>>2]+(g<<4)|0;e=M[d>>2];d=M[d+4>>2];if((d|0)<0){h=1}else{h=!e&(d|0)<=0}if(h){continue}break}M[a+112>>2]=g;j=0;break a}M[a+112>>2]=f;j=li(j,a+8|0);if((j|0)==100){l=M[a+64>>2];m=M[a+68>>2];c:{b=M[a+88>>2];if(!b){break c}j=0;h=b;b=M[a+92>>2];f=M[a+60>>2];g=Qb(h,M[a+56>>2],(b|0)<(f|0)?b:f);if(g|(b|0)>=(f|0)?(g|0)>=0:0){break c}M[a+100>>2]=1;break a}j=7;if(Ty(a,2)){break a}g=0;b=M[a+116>>2]<<4;if(b){D(M[a+120>>2],0,b)}d=0;f=0;while(1){if((g|0)<(m|0)){M[i+8>>2]=0;M[i+12>>2]=0;n=Ic(g+l|0,i+8|0);d:{e:{f:{g:{h:{switch(c|0){case 2:b=M[i+8>>2];e=M[i+12>>2];break g;case 0:b=M[a+120>>2];d=b;c=M[b>>2];b=M[b+4>>2];c=c+1|0;b=c?b:b+1|0;M[d>>2]=c;M[d+4>>2]=b;c=1;d=0;break d;case 1:break h;default:break f}}c=M[i+12>>2];e=c;b=M[i+8>>2];if(b>>>0<2&(c|0)<=0|(c|0)<0){break g}c=M[a+120>>2];h=c;k=M[c+16>>2];c=M[c+20>>2];k=k+1|0;c=k?c:c+1|0;M[h+16>>2]=k;M[h+20>>2]=c}if(!e&b>>>0<=1){c=0;if(b-1|0){break d}c=3;break d}b=M[a+120>>2];c=b+(d<<4)|0;e=c+24|0;h=M[c+24>>2];c=M[c+28>>2];h=h+1|0;c=h?c:c+1|0;M[e>>2]=h;M[e+4>>2]=c;c=M[b+12>>2];e=M[b+8>>2]+1|0;c=e?c:c+1|0;M[b+8>>2]=e;M[b+12>>2]=c;break e}d=M[i+8>>2];if((d|0)<=0){f=267;break d}if(Ty(a,d+2|0)){break a}b=M[a+120>>2]+(d<<4)|0;c=b;e=M[b+16>>2];b=M[b+20>>2];e=e+1|0;b=e?b:b+1|0;M[c+16>>2]=e;M[c+20>>2]=b}c=2}g=g+n|0;continue}break}M[a+112>>2]=0;j=f;break a}M[a+100>>2]=1}Na=i+16|0;return j|0}function BH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=Na-128|0;Na=d;a:{if((b|0)<2){break a}g=Hf(a,M[c>>2],0);if(!g){break a}i=M[M[a+4>>2]+8>>2];M[d>>2]=a;L[d+24>>1]=1;M[d+16>>2]=0;M[d+20>>2]=0;M[d+8>>2]=100;M[d+12>>2]=0;k=d+26|0;M[d+4>>2]=k;l=(b|0)==2;if(!l){bc(d,91)}n=i&10;o=i&1;p=i&3;j=1;while(1){b:{c:{d:{e:{f:{g:{h:{i:{if((b|0)!=(j|0)){e=(j<<2)+c|0;f=gb(M[e>>2]);if(!f){break b}h=jb(f);if(N[f|0]==36){e=Pe(g,0,f+1|0,0);break f}if(!p){break e}M[d>>2]=a;L[d+24>>1]=1;M[d+16>>2]=0;M[d+20>>2]=0;M[d+8>>2]=100;M[d+12>>2]=0;M[d+4>>2]=k;j:{e=O[M[e>>2]+16>>1];if(!(((e&63)>>>0<32?1<<e:0)&1347440720)){e=0;while(1){if((e|0)==(h|0)){break i}m=N[e+f|0];e=e+1|0;if(N[m+31408|0]&6|(m|0)==95){continue}break}if(N[f|0]!=91|h>>>0<3|N[(f+h|0)-1|0]!=93){break j}break h}Nc(d,18441,1);if(N[f|0]==45){Nc(d,29255,1)}af(d,f,h);Nc(d,18439,2);break g}Nc(d,30009,2);af(d,f,h);Nc(d,30010,1);break g}if((b|0)==2){break b}bc(d,93);bf(d,0,0);if(i&8){break b}a=M[a>>2];K[a+19|0]=74;L[a+16>>1]=O[a+16>>1]|2048;break b}Nc(d,25068,1)}af(d,f,h)}Lq(d);e=Pe(g,0,M[d+4>>2],0);rg(d)}if(P[g+4>>2]>e>>>0){if((b|0)!=2){break d}if(o){L[d+24>>1]=1;M[d+16>>2]=0;M[d+20>>2]=0;M[d+8>>2]=100;M[d+12>>2]=0;M[d+4>>2]=k;M[d>>2]=a;Ff(g,e,d);bf(d,0,0);rg(d);e=M[a>>2];K[e+19|0]=74;L[e+16>>1]=O[e+16>>1]|2048;break c}nm(g,e,a,0);if((N[M[g>>2]+e|0]&15)>>>0<11|n){break c}e=M[a>>2];K[e+19|0]=74;L[e+16>>1]=O[e+16>>1]|2048;break c}k:{switch(e+2|0){case 0:if(l){break b}rm(d);Nc(d,11727,4);break c;case 1:break k;default:break e}}Pb(a,20034,-1);break b}$j(a,f);break b}rm(d);Ff(g,e,d)}j=j+1|0;continue}break}rg(d);bd(g)}Na=d+128|0}function JH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=Na-160|0;Na=b;d=b+112|0;a:{if(sg(a,1,c,d)){break a}h=c+4|0;c=b- -64|0;if(sg(a,1,h,c)){break a}cf(d);cf(c);i=M[b+116>>2];d=i;e=M[b+68>>2];f=M[b+112>>2];b:{if((d|0)>=(e|0)&f>>>0>=P[b+64>>2]|(d|0)>(e|0)){d=M[b+120>>2];e=M[b+72>>2];if((d|0)!=(e|0)){K[b+104|0]=0;M[b+72>>2]=d;Cc(c)}g=M[b+124>>2];c=g-M[b+76>>2]|0;j=c>>31;c=(c|0)<0?c+12|0:c;if(c){K[b+104|0]=0;M[b+76>>2]=g;Cc(b- -64|0)}g=(d-e|0)+j|0;while(1){e=M[b+64>>2];h=M[b+68>>2];d=h;if(f>>>0<e>>>0&(i|0)<=(d|0)|(d|0)>(i|0)){d=M[b+76>>2];M[b+76>>2]=d-1;if((d|0)<=1){M[b+76>>2]=12;M[b+72>>2]=M[b+72>>2]-1}d=(c|0)<=0;c=d?11:c-1|0;g=g-d|0;K[b+104|0]=0;Cc(b- -64|0);continue}break}j=43;d=f-e|0;f=i-((f>>>0<e>>>0)+h|0)|0;break b}e=M[b+72>>2];d=M[b+120>>2];if((e|0)!=(d|0)){K[b+104|0]=0;M[b+72>>2]=d;Cc(b- -64|0)}g=M[b+124>>2];c=M[b+76>>2]-g|0;j=c>>31;c=(c|0)<0?c+12|0:c;if(c){K[b+104|0]=0;M[b+76>>2]=g;Cc(b- -64|0)}g=(e-d|0)+j|0;while(1){e=M[b+64>>2];h=M[b+68>>2];d=h;if(e>>>0<f>>>0&(d|0)<=(i|0)|(d|0)<(i|0)){d=M[b+76>>2];M[b+76>>2]=d+1;if((d|0)>=12){M[b+76>>2]=1;M[b+72>>2]=M[b+72>>2]+1}d=(c|0)<=0;c=d?11:c-1|0;g=g-d|0;K[b+104|0]=0;Cc(b- -64|0);continue}break}j=45;d=e-f|0;f=h-((f>>>0>e>>>0)+i|0)|0}K[b+153|0]=0;K[b+154|0]=0;M[b+140>>2]=0;f=f+34621|0;d=d-816922112|0;f=d>>>0<3478045184?f+1|0:f;M[b+112>>2]=d;M[b+116>>2]=f;cf(b+112|0);d=M[b+136>>2];M[b+16>>2]=M[b+132>>2];M[b+20>>2]=d;R[b+24>>3]=R[b+144>>3];L[b+60>>1]=0;M[b+56>>2]=0;M[b+48>>2]=0;M[b+52>>2]=100;M[b+40>>2]=0;M[b+44>>2]=0;M[b>>2]=j;M[b+4>>2]=g;M[b+8>>2]=c;M[b+12>>2]=M[b+128>>2]-1;c=b+40|0;rb(c,12802,b);wm(a,c)}Na=b+160|0}function sA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=Na-240|0;Na=f;g=M[a+132>>2];a:{if(N[(g?g:a)+223|0]!=2){break a}g=74356;h=M[a+8>>2];if(!N[M[h>>2]+87|0]){g=M[h+104>>2]+S(b,20)|0}h=M[a>>2];if(N[h+87|0]){break a}j=S(N[d+60|0],48)+c|0;c=j+8|0;b=1;d=M[d+80>>2];a=M[d+40>>2];i=a&48;b=i|!(O[d+24>>1]?a&1024:1)?b:(e&3)!=0;L[f+236>>1]=256;M[f+232>>2]=0;M[f+224>>2]=100;M[f+228>>2]=1e9;M[f+216>>2]=h;M[f+100>>2]=c;M[f+96>>2]=b?20356:20129;M[f+220>>2]=f+112;rb(f+216|0,19336,f+96|0);b:{if(!(a&1280)){c=M[d+32>>2];c:{d:{if(N[M[j+16>>2]+28|0]&128){if(((N[c+55|0]|N[c+56|0]<<8)&3)==2){break d}}b=18723;if(a&131072){break c}b=18756;if(a&16384){break c}b=a&67108928?7307:7316;break c}if(!b){break b}b=18603}a=f+216|0;Ab(a,30593,7);M[f+16>>2]=M[c>>2];rb(a,b,f+16|0);b=O[d+46>>1];e=M[d+32>>2];c=O[d+24>>1];if(!(c|N[d+40|0]&48)){break b}Ab(a,27787,2);a=0;while(1){if((a|0)!=(c|0)){i=ar(e,a);if(a){Ab(f+216|0,30637,5)}M[f>>2]=i;rb(f+216|0,a>>>0<b>>>0?25352:21197,f);a=a+1|0;continue}break}b=c;a=M[d+40>>2];if(a&32){aA(f+216|0,e,O[d+26>>1],c,c,21982);b=1;a=M[d+40>>2]}if(a&16){aA(f+216|0,e,O[d+28>>1],c,b,22019)}Ab(f+216|0,27767,1);break b}if(!(!(a&256)|!(a&15))){M[f+80>>2]=15195;c=f+216|0;rb(c,6465,f+80|0);b=61;e:{if(a&5){break e}if((i|0)==48){M[f+64>>2]=15195;rb(c,7430,f- -64|0);b=60;break e}b=a&32?62:60}M[f+48>>2]=b;rb(f+216|0,26291,f+48|0);break b}if(!(a&1024)){break b}a=f+216|0;Sd(a,30222);b=N[d+28|0];c=M[d+24>>2];M[f+36>>2]=M[d+32>>2];M[f+32>>2]=c;rb(a,b&4?6170:6178,f+32|0)}if(N[j+20|0]&8){rb(f+216|0,20085,0)}eb(h,M[g+16>>2]);K[g+1|0]=250;k=g,l=Rd(f+216|0),M[k+16>>2]=l}Na=f+240|0}function sz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Na+-64|0;Na=f;h=Hf(a,M[c>>2],(b|0)!=1);a:{if(!h){break a}n=b-1|0;o=d-2|0;b=1;b:{while(1){if(b>>>0<n>>>0){j=(b<<2)+c|0;l=M[j>>2];i=O[l+16>>1];e=i&31;if((i&63)>>>0>=32){i=1<<e;k=0}else{k=1<<e;i=k-1&1>>>32-e}c:{if(k&-1431655766|i&-1431655766){break c}i=gb(l);if(!i){$b(a);bd(h);break a}if(N[i|0]!=36){break b}e=M[j+4>>2];g=O[e+16>>1];D(f+8|0,0,56);M[f+24>>2]=M[M[a>>2]+20>>2];d:{e:{f:{g:{h:{switch(N[(g&63)+31312|0]-1|0){case 3:if(Zj(e)){p=f,q=od(e),M[p+8>>2]=q;p=f,q=Fb(e),M[p+12>>2]=q;break g}Pb(a,5360,-1);break f;case 2:g=gb(e);j=Fb(e);if(!g){break f}if(!(!(N[e+17|0]&8)|N[e+19|0]!=74)){M[f+28>>2]=j;M[f+20>>2]=g;e=f+8|0;if(!om(e,a)){break g}Pb(a,20034,-1);eb(M[f+24>>2],M[f+8>>2]);D(e,0,56);break f}yd(f+8|0,10,j,g);break g;case 1:m=Kb(e);if(m!=m){yd(f+8|0,0,0,0);break g}g=Fb(e);e=gb(e);if(!e){break f}i:{j=N[e|0];if((j|0)!=45){if((j|0)!=73){break i}yd(f+8|0,5,5,23216);break g}if(N[e+1|0]!=73){break i}yd(f+8|0,5,6,23215);break g}yd(f+8|0,5,g,e);break g;case 0:break h;default:break e}}g=Fb(e);e=gb(e);if(!e){break f}yd(f+8|0,3,g,e)}if(!N[f+43|0]){break d}$b(a)}Gf(f+8|0);bd(h);break a}M[f+12>>2]=1;M[f+8>>2]=74376}j:{if(!N[i+1|0]){g=0;k:{switch(o|0){case 0:case 2:break k;default:break j}}$e(h,0,M[h+4>>2],M[f+8>>2],M[f+12>>2]);break j}K[h+39|0]=d;M[h+44>>2]=M[f+12>>2];e=M[f+8>>2];M[h+40>>2]=0;M[h+52>>2]=e;g=Pe(h,0,i+1|0,0)}Gf(f+8|0);if((g|0)==-2){break c}if(g>>>0>4294967292){break b}}b=b+2|0;continue}break}Mq(a,h);bd(h);break a}bd(h);if((g|0)==-1){Pb(a,20034,-1);break a}$j(a,i)}Na=f- -64|0}function $q(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;n=d?161:162;o=d^1;p=e+1|0;k=M[a>>2];f=Cb(k);g=b;while(1){if(g){a=0;l=M[g+44>>2];i=0;a:{if(N[g+96|0]){break a}h=M[M[g+72>>2]+20>>2];i=0;if(!h){break a}i=M[h>>2]}h=(i|0)>0?i:0;while(1){if((a|0)!=(h|0)){b:{if(!((a|0)==1&M[l+32>>2]==50960)){bb(f,94,c,M[g+80>>2]+a|0,a+e|0);break b}bb(f,94,M[b+48>>2],M[g+80>>2]+1|0,p)}a=a+1|0;continue}break}c:{if(!M[g+40>>2]){m=0;break c}a=Gb(k);bb(f,94,c,M[g+80>>2]+i|0,a);m=bb(f,17,a,0,1);zb(k,a)}d:{if(!(M[b+88>>2]|!(N[l+5|0]&16)|N[g+17|0]==91)){l=fb(f,51,e);e:{if(!d){$a(f,86,M[g+64>>2]+1|0,1);$a(f,81,e,M[g+64>>2]);a=M[g+64>>2];bb(f,97,a,2,a+2|0);$a(f,138,M[g+60>>2],M[g+64>>2]+2|0);a=M[f+108>>2];h=N[M[f>>2]+87|0];break e}lb(f,23,M[g+60>>2],0,e,1);fb(f,130,M[g+60>>2]);a=M[f+108>>2];h=N[M[f>>2]+87|0];M[(h?74356:(M[f+104>>2]+S(a,20)|0)-40|0)+8>>2]=a}M[(h?74356:M[f+104>>2]+S(l,20)|0)+8>>2]=a;break d}a=M[g+64>>2];if(a){$a(f,86,a+o|0,1);break d}if(M[l+16>>2]==94){break d}h=e;f:{if(!N[g+96|0]){break f}a=M[f+108>>2];i=M[M[M[g+72>>2]+20>>2]>>2];h=vc(k,i);kf(k,M[M[g+72>>2]+20>>2],h,0,0);j=M[f+108>>2];q=(a|0)>(j|0)?a:j;while(1){if((a|0)==(q|0)){break f}j=74356;j=N[M[f>>2]+87|0]?j:M[f+104>>2]+S(a,20)|0;if(!(N[j|0]!=94|M[j+4>>2]!=M[b+48>>2])){M[j+4>>2]=c}a=a+1|0;continue}}if(N[l+4|0]&32){nb(f,85,0,0,0,Lf(k,M[M[M[g+72>>2]+20>>2]+8>>2]),-2)}bb(f,n,d,h,M[g+52>>2]);Jc(f,l,-7);a=M[f+108>>2];if((a|0)>0){L[(M[f+104>>2]+S(a,20)|0)-18>>1]=i}if(!N[g+96|0]){break d}ad(k,h,i)}if(m){M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(m,20)|0)+8>>2]=M[f+108>>2]}g=M[g+36>>2];continue}break}}function ti(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;i=a+28|0;j=a+72|0;c=N[a+25|0];f=M[a+4>>2];h=M[a+16>>2];a:while(1){b=(c&255)-1|0;k=M[(b<<2)+i>>2];l=L[(b<<1)+j>>1];n=(l|0)!=-2;b:while(1){c=M[f+24>>2]+S(h,48)|0;while(1){c:{if(M[f+12>>2]>(h|0)){if(M[c+20>>2]!=(k|0)|M[c+24>>2]!=(l|0)){break c}if(!n){if(Bm(M[M[c>>2]+12>>2],M[a+12>>2],k)){break c}}if(K[M[c>>2]+4|0]&1&N[a+25|0]>=2){break c}e=O[c+12>>1];d:{if(!(e&2048)){break d}g=N[a+26|0];if(g>>>0>10){break d}d=$c(M[M[c>>2]+16>>2]);if(!d|N[d|0]!=168|N[d+4|0]&32){break d}b=0;while(1){if((b|0)!=(g|0)){if(M[(b<<2)+i>>2]==M[d+28>>2]&O[(b<<1)+j>>1]==O[d+32>>1]){break d}b=b+1|0;continue}break}M[(g<<2)+i>>2]=M[d+28>>2];L[(g<<1)+j>>1]=O[d+32>>1];K[a+26|0]=g+1;e=O[c+12>>1]}if(!(M[a+20>>2]&e)){break c}if(!(!M[a+8>>2]|e&256)){g=K[a+24|0];m=M[M[f>>2]>>2];e:{if(e&1){e=Na+-64|0;Na=e;d=M[c>>2];b=M[d+12>>2];if(ze(b)){o=M[c+28>>2];K[e+12|0]=54;M[e+16>>2]=0;p=M[b+20>>2];b=(o<<4)-16|0;M[e+24>>2]=M[(p+b|0)+8>>2];M[e+28>>2]=M[(b+M[M[d+20>>2]+28>>2]|0)+8>>2];d=e+12|0}b=0;f:{if(!er(d,g<<24>>24)){break f}d=Ug(m,d);b=33696;if(!d){break f}b=M[d>>2]}Na=e- -64|0;if(b){break e}break c}b=M[c>>2];if(!er(b,g<<24>>24)){break c}b=Ug(m,b);if(!b){b=33696;break e}b=M[b>>2]}if(hb(b,M[a+8>>2])){break c}e=O[c+12>>1]}g:{if(!(e&130)){break g}b=M[M[c>>2]+16>>2];if(!b|N[b|0]!=168|M[b+28>>2]!=M[i>>2]){break g}if(O[b+32>>1]==O[j>>1]){break c}}M[a+4>>2]=f;M[a+16>>2]=h+1;return c}h=0;f=M[f+4>>2];if(f){continue b}b=N[a+25|0];if(b>>>0>=N[a+26|0]){return 0}c=b+1|0;K[a+25|0]=c;f=M[a>>2];continue a}c=c+48|0;h=h+1|0;continue}}}}function Yl(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Na-16|0;Na=g;c=M[a>>2];a:{b:{c:{if(!b){f=1;break c}k=M[c>>2];d:{if(k-3>>>0<=1){d=b<<2;j=Bb(d,0);if(!j){f=7;break c}if(d){D(j,0,d)}e=c;while(1)if(M[e>>2]!=(k|0)){M[g+12>>2]=e;m=b-1|0;d=0;e:{f:{while(1){h=M[e+8>>2];M[e+8>>2]=0;i=0;if(h){M[h+12>>2]=0;i=c}g:{f=Yl(g+12|0,m);if(!f){e=0;c=M[g+12>>2];while(1){if(!(!c|(b|0)<=(e|0))){l=(e<<2)+j|0;f=M[l>>2];h:{if(!f){f=c;c=0;break h}M[d+16>>2]=c;M[d+12>>2]=f;M[f+8>>2]=d;M[c+8>>2]=d;n=M[d+8>>2];f=0;M[d+8>>2]=0;c=d;d=n}M[l>>2]=f;e=e+1|0;continue}break}if(!c){break g}Le(c);f=18}e=0;b=(b|0)>0?b:0;while(1){if((b|0)==(e|0)){break f}Le(M[(e<<2)+j>>2]);e=e+1|0;continue}}if(h){c=h+16|0;while(1){e=M[c>>2];c=e+12|0;if(M[e>>2]==(k|0)){continue}break}M[g+12>>2]=e;c=M[h+16>>2];f=M[h+8>>2];M[c+8>>2]=f;if(f){M[f+12>>2]=c;c=i}M[h+8>>2]=d;d=h;continue}break}f=0;i=(b|0)>0?b:0;c=0;e=0;while(1){if((e|0)==(i|0)){break e}h=(e<<2)+j|0;b=M[h>>2];i:{if(!b){break i}if(!c){M[b+8>>2]=0;c=b;break i}M[d+16>>2]=c;b=M[h>>2];M[d+12>>2]=b;M[b+8>>2]=d;M[c+8>>2]=d;b=M[d+8>>2];M[d+8>>2]=0;c=d;d=b}e=e+1|0;continue}}while(1){if(d){b=M[d+8>>2];ab(d);d=b;continue}break}c=i}ab(j);break d}else{e=M[e+12>>2];continue}}if((k|0)!=2){break b}i=M[c+12>>2];M[g+8>>2]=i;d=M[c+16>>2];M[g+4>>2]=d;M[c+12>>2]=0;M[c+16>>2]=0;M[i+8>>2]=0;M[d+8>>2]=0;j:{b=b-1|0;f=Yl(g+8|0,b);if(!f){f=Yl(g+4|0,b);d=M[g+4>>2];if(!f){break j}}Le(d);Le(M[g+8>>2]);break d}b=M[g+8>>2];M[c+12>>2]=b;M[b+8>>2]=c;M[c+16>>2]=d;M[d+8>>2]=c;f=0}if(!f){break b}}Le(c);c=0;break a}f=0}M[a>>2]=c;Na=g+16|0;return f}function Fs(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;m=Na-32|0;Na=m;o=M[a>>2];k=M[a+252>>2];a:{if(!k|N[a+224|0]==1){break a}b:{if(!b){j=1;f=L[k+34>>1];if((f|0)<=0){break a}if(!d|M[d>>2]==1){break b}e=M[(M[k+4>>2]+S(f,12)|0)-12>>2];M[m+20>>2]=c;M[m+16>>2]=e;cb(a,19101,m+16|0);break a}j=M[b>>2];if(!d|(j|0)==M[d>>2]){break b}cb(a,14338,0);break a}g=(M[c+4>>2]+(j<<3)|0)+37|0;f=0;c:{if(!d){break c}l=M[d>>2];p=(l|0)>0?l:0;n=d+12|0;while(1){if((h|0)==(p|0)){break c}l=jb(M[n+(h<<4)>>2])+1|0;g=g+l|0;f=l>>>0>g>>>0?f+1|0:f;h=h+1|0;continue}}f=ub(o,g,f);if(!f){break a}M[f>>2]=k;g=M[k+48>>2];l=f+36|0;i=l+(j<<3)|0;M[f+8>>2]=i;M[f+4>>2]=g;if(N[a+224|0]>=2){Ce(a,i,c)}g=M[c+4>>2];if(g){G(i,M[c>>2],g)}g=0;K[i+M[c+4>>2]|0]=0;zf(i);p=M[c+4>>2];M[f+20>>2]=j;d:{e:{if(b){n=(j|0)>0?j:0;r=b+12|0;while(1){if((g|0)==(n|0)){break e}h=0;c=L[k+34>>1];s=(c|0)>0?c:0;c=r+(g<<4)|0;while(1){if((h|0)==(s|0)){break d}q=M[c>>2];if(hb(M[M[k+4>>2]+S(h,12)>>2],q)){h=h+1|0;continue}break}c=(g<<3)+l|0;M[c>>2]=h;if(N[a+224|0]>=2){kd(a,c,q)}g=g+1|0;continue}}M[l>>2]=L[k+34>>1]-1}f:{if(!d){break f}g=i+p|0;j=(j|0)>0?j:0;p=d+12|0;h=0;while(1){if((h|0)==(j|0)){break f}n=p+(h<<4)|0;i=M[n>>2];c=jb(i);g=g+1|0;M[((h<<3)+l|0)+4>>2]=g;if(N[a+224|0]>=2){kd(a,g,i);i=M[n>>2]}if(c){G(g,i,c)}g=c+g|0;K[g|0]=0;h=h+1|0;continue}}K[f+25|0]=e;K[f+24|0]=0;K[f+26|0]=e>>>8;a=wd(M[k+60>>2]+56|0,M[f+8>>2],f);if((a|0)==(f|0)){Lb(o);i=f;break a}if(a){M[f+12>>2]=a;M[a+16>>2]=f}M[k+48>>2]=f;i=0;break a}M[m>>2]=M[c>>2];cb(a,10379,m);i=f}eb(o,i);xb(o,b);xb(o,d);Na=m+32|0}function Vx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=Na-48|0;Na=d;M[d+44>>2]=M[a>>2];h=M[b>>2];M[d+40>>2]=h;M[d+36>>2]=M[c>>2];while(1){a:{b:{c:{d:{e:{f:{g:{e=N[h|0];h:{i:{if(!e){f=M[d+36>>2];if(!N[f|0]){break e}f=2147483647;break i}f=0;if((e|0)!=1){break i}f=K[h+1|0];if((f|0)<0){yc(h+1|0,d+32|0);f=M[d+32>>2]}if(!f){break h}}e=2147483647;j:{g=M[d+36>>2];switch(N[g|0]){case 0:break f;case 1:break j;default:break g}}e=K[g+1|0];if((e|0)<0){yc(g+1|0,d+28|0);e=M[d+28>>2]}if(e){break f}}e=267;break a}e=0}if((e|0)!=(f|0)){break c}M[d+16>>2]=0;M[d+20>>2]=0;M[d+8>>2]=0;M[d+12>>2]=0;M[d>>2]=0;M[d+4>>2]=0;f=_p(d+44|0,f);M[d+36>>2]=f+g;M[d+40>>2]=f+h;gi(d+40|0,d+16|0);gi(d+36|0,d+8|0);e=M[d+20>>2];h=e;f=M[d+16>>2];if((e|0)>=0&f>>>0>=2|(e|0)>0){e=M[d+8>>2];g=M[d+12>>2];if(e>>>0>1&(g|0)>=0|(g|0)>0){break d}}f=M[d+36>>2];h=M[d+40>>2]}g=M[d+44>>2];M[d+44>>2]=g+1;e=0;K[g|0]=0;M[a>>2]=M[d+44>>2];M[b>>2]=h+1;M[c>>2]=f+1;break a}while(1){i=(h|0)<=(g|0)&e>>>0>f>>>0|(h|0)<(g|0);Ux(d+44|0,d,i?f:e,i?h:g);i=M[d>>2];j=M[d+4>>2]-(i>>>0<2)|0;i=i-2|0;M[d>>2]=i;M[d+4>>2]=j;k:{if((e|0)==(f|0)&(h|0)==(g|0)){Sl(d+40|0,d+16|0);Sl(d+36|0,d+8|0);break k}if((h|0)<=(g|0)&e>>>0>f>>>0|(h|0)<(g|0)){Sl(d+40|0,d+16|0);break k}Sl(d+36|0,d+8|0)}f=M[d+16>>2];h=M[d+20>>2];e=M[d+8>>2];g=M[d+12>>2];if((f|0)!=-1|(h|0)!=2147483647|((e|0)!=-1|(g|0)!=2147483647)){continue}break}break b}if((e|0)>(f|0)){e=d+44|0;k=d,l=_p(e,f)+h|0,M[k+40>>2]=l;Ef(e,d+40|0);break b}f=d+44|0;k=d,l=_p(f,e)+g|0,M[k+36>>2]=l;Ef(f,d+36|0)}h=M[d+40>>2];continue}break}Na=d+48|0;return e}function tp(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=Na-80|0;Na=g;i=M[b+44>>2];M[g+60>>2]=0;h=a+404|0;j=M[b+48>>2];a:{b:{while(1){f=M[h>>2];if(!f){break b}h=f+8|0;if(M[f+4>>2]!=(b|0)){continue}break}M[g+48>>2]=M[b>>2];n=e,o=tb(a,7485,g+48|0),M[n>>2]=o;h=6;break a}h=7;k=_b(a,M[b>>2]);if(!k){break a}f=zd(28,0);c:{if(!f){Lb(a);break c}K[f+18|0]=1;M[f+4>>2]=c;M[f>>2]=a;n=M[b+48>>2],o=M[M[a+16>>2]+(Mb(a,M[b+60>>2])<<4)>>2],M[n+4>>2]=o;M[g+64>>2]=f;M[g+68>>2]=b;h=M[a+404>>2];M[g+76>>2]=0;M[g+72>>2]=h;M[a+404>>2]=g- -64;M[b+24>>2]=M[b+24>>2]+1;h=Ra[d|0](a,M[c+12>>2],i,j,f+8|0,g+60|0)|0;Id(a,b);M[a+404>>2]=M[g+72>>2];if(h){if((h|0)==7){Lb(a)}b=M[g+60>>2];d:{if(!b){M[g>>2]=k;n=e,o=tb(a,8692,g),M[n>>2]=o;break d}M[g+16>>2]=b;n=e,o=tb(a,8932,g+16|0),M[n>>2]=o;ab(M[g+60>>2])}ib(a,f);break c}h=0;d=M[f+8>>2];if(!d){break c}M[d>>2]=0;M[d+4>>2]=0;M[d+8>>2]=0;M[M[f+8>>2]>>2]=M[c>>2];h=1;M[c+8>>2]=M[c+8>>2]+1;M[f+12>>2]=1;if(!M[g+76>>2]){M[g+32>>2]=k;n=e,o=tb(a,8820,g+32|0),M[n>>2]=o;_f(f);break c}M[f+24>>2]=M[b+52>>2];M[b+52>>2]=f;d=0;c=0;while(1){if((d|0)<L[b+34>>1]){h=0;l=S(d,12);i=pl(l+M[b+4>>2]|0,30808);j=jb(i);e:{f:{while(1){if((h|0)==(j|0)){break f}g:{f=h+i|0;if(!(Eb(11433,f,6)|(N[f-1|0]!=32?h:0))){e=N[f+6|0];if((e|32)==32){break g}}h=h+1|0;continue}break}c=e?7:6;e=h;while(1){m=c+e|0;if(m>>>0<=j>>>0){K[e+i|0]=N[i+m|0];e=e+1|0;continue}break}if(!(N[f|0]|!h)){K[f-1|0]=0}c=M[b+4>>2]+l|0;L[c+10>>1]=O[c+10>>1]|2;c=1024;e=2;break e}e=c}M[b+28>>2]=e|M[b+28>>2];d=d+1|0;continue}break}h=0}ib(a,k)}Na=g+80|0;return h}function ro(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;i=Na-16|0;Na=i;a:{b:{c:{d:{e:{if(!N[a+12|0]){l=d+2|0;if((l|0)<=M[a+20>>2]){break e}}f:{if(!e){e=c;break f}if(!d){break f}G(e,c,d)}c=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);K[e|0]=c;K[e+1|0]=c>>>8;K[e+2|0]=c>>>16;K[e+3|0]=c>>>24;c=N[a+12|0];K[a+12|0]=c+1;M[((c<<2)+a|0)+36>>2]=e;L[((c<<1)+a|0)+28>>1]=b;break d}e=ac(M[a+72>>2]);if(e){break a}e=N[a+9|0];j=M[a+56>>2];M[i+12>>2]=0;h=e+j|0;g=N[h+5|0]<<8|N[h+6|0];k=O[a+18>>1]+(O[a+24>>1]<<1)|0;g:{if(g>>>0<k>>>0){e=72625;if(g){break b}g=65536;if(M[M[a+52>>2]+40>>2]==65536){break g}break b}e=72628;if(M[M[a+52>>2]+40>>2]<(g|0)){break b}}h:{i:{j:{if(!N[h+2|0]){if(!N[h+1|0]){break i}if(k+2>>>0<=g>>>0){break j}break i}if(k+2>>>0>g>>>0){break i}}e=uo(a,d,i+12|0);if(e){e=e-j|0;if((k|0)>=(e|0)){break c}break h}e=M[i+12>>2];if(e){break a}}if((k+l|0)>(g|0)){e=M[a+20>>2]-l|0;e=to(a,(e|0)>=4?4:e);if(e){break a}g=((N[h+6|0]|N[h+5|0]<<8)-1&65535)+1|0}e=g-d|0;g=e<<8|(e&65280)>>>8;K[h+5|0]=g;K[h+6|0]=g>>>8}h=e>>>8|0;M[a+20>>2]=M[a+20>>2]-(l&65535);g=e+j|0;d=d-4|0;if(d){G(g+4|0,c+4|0,d)}d=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);K[g|0]=d;K[g+1|0]=d>>>8;K[g+2|0]=d>>>16;K[g+3|0]=d>>>24;d=M[a+64>>2]+(b<<1)|0;b=O[a+24>>1]-b<<1;if(b){G(d+2|0,d,b)}K[d+1|0]=e;K[d|0]=h;L[a+24>>1]=O[a+24>>1]+1;d=N[a+9|0]+j|0;b=N[d+4|0]+1|0;K[d+4|0]=b;if((b|0)!=(b&255)){b=N[a+9|0]+j|0;K[b+3|0]=N[b+3|0]+1}if(!N[M[a+52>>2]+17|0]){break d}M[i+8>>2]=0;cj(a,a,c,i+8|0);e=M[i+8>>2];if(e){break a}}e=0;break a}e=db(72645);break a}e=db(e)}Na=i+16|0;return e}function nv(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=M[a+104>>2];g=(e|0)>0?e:0;f=M[a+156>>2];e=M[a+168>>2];c=M[a+224>>2];while(1){if((b|0)!=(g|0)){d=M[a+100>>2]+S(b,48)|0;if(!(M[d+8>>2]|M[d+12>>2])){h=M[a+84>>2];M[d+8>>2]=M[a+80>>2];M[d+12>>2]=h}b=b+1|0;continue}break}b=bm(a);M[a+88>>2]=b;d=Qa;M[a+92>>2]=d;M[a+80>>2]=b;M[a+84>>2]=d;g=e>>>0>f>>>0;a:{b:{if(!(N[a+7|0]|N[a+5|0]==4)){b=M[a+64>>2];d=M[b>>2];if(!d){break b}if(!(Ra[M[d+48>>2]](b)&512)){break b}}K[c+8|0]=255;K[c+9|0]=255;K[c+10|0]=255;K[c+11|0]=255;K[c|0]=217;K[c+1|0]=213;K[c+2|0]=5;K[c+3|0]=249;K[c+4|0]=32;K[c+5|0]=161;K[c+6|0]=99;K[c+7|0]=215;break a}K[c|0]=0;K[c+1|0]=0;K[c+2|0]=0;K[c+3|0]=0;K[c+4|0]=0;K[c+5|0]=0;K[c+6|0]=0;K[c+7|0]=0;K[c+8|0]=0;K[c+9|0]=0;K[c+10|0]=0;K[c+11|0]=0}if(N[a+5|0]!=4){pe(4,a+52|0)}b=M[a+52>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[c+12|0]=b;K[c+13|0]=b>>>8;K[c+14|0]=b>>>16;K[c+15|0]=b>>>24;b=M[a+32>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[c+16|0]=b;K[c+17|0]=b>>>8;K[c+18|0]=b>>>16;K[c+19|0]=b>>>24;b=M[a+156>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[c+20|0]=b;K[c+21|0]=b>>>8;K[c+22|0]=b>>>16;K[c+23|0]=b>>>24;b=M[a+168>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[c+24|0]=b;K[c+25|0]=b>>>8;K[c+26|0]=b>>>16;K[c+27|0]=b>>>24;d=0;e=g?f:e;b=e-28|0;if(b){D(c+28|0,0,b)}b=0;while(1){if(!(P[a+156>>2]<=b>>>0|d)){f=M[a+68>>2];d=Ra[M[M[f>>2]+12>>2]](f,c,e,M[a+80>>2],M[a+84>>2])|0;f=M[a+84>>2];g=M[a+80>>2]+e|0;f=e>>>0>g>>>0?f+1|0:f;M[a+80>>2]=g;M[a+84>>2]=f;b=b+e|0;continue}break}return d}function Nm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Na-48|0;Na=f;j=M[a>>2];M[f+32>>2]=0;M[f+36>>2]=0;M[f+24>>2]=0;M[f+28>>2]=0;if(b){h=M[b>>2];e=(h|0)>=32767?32767:h;h=ub(j,S(h,12),0)}else{h=0}L[c>>1]=e;M[d>>2]=h;n=(e|0)>0?e:0;o=b+8|0;i=h;while(1){a:{b:{c:{d:{e:{f:{if((l|0)!=(n|0)){if(!M[a+40>>2]){break f}n=l}Bf(f+24|0);if(!M[a+40>>2]){break d}e=0;while(1){if((e|0)==(n|0)){break e}eb(j,M[S(e,12)+h>>2]);e=e+1|0;continue}}k=(l<<4)+o|0;g=M[k+4>>2];if(N[k+9|0]&3?0:g){break c}e=$c(M[k>>2]);while(1){b=N[e|0];if((b|0)!=142){g:{if((b|0)!=60){if(N[e+7|0]&3|(b|0)!=168){break g}b=M[e+44>>2];if(!b){break g}h:{e=L[e+32>>1];if((e|0)>=0){break h}e=L[b+32>>1];if((e|0)>=0){break h}g=15195;break c}g=M[M[b+4>>2]+S(e,12)>>2];break g}g=M[e+8>>2]}if(!g){break b}break c}else{e=M[e+16>>2];continue}}}eb(j,h);M[d>>2]=0;L[c>>1]=0}Na=f+48|0;return}if(ss(g)){break b}b=_b(j,g);break a}M[f+16>>2]=l+1;b=tb(j,16709,f+16|0)}M[f+44>>2]=0;while(1){i:{if(!b){break i}m=Sc(f+24|0,b);if(!m){break i}if(N[m+9|0]&128){L[i+10>>1]=O[i+10>>1]|1024}m=jb(b);e=m;if(e){while(1){j:{if(e>>>0<=1){g=N[b|0];e=0;break j}e=e-1|0;g=N[e+b|0];if(g-58>>>0>4294967285){continue}}break}e=(g&255)==58?e:m}else{e=0}M[f>>2]=e;M[f+4>>2]=b;b=M[f+44>>2]+1|0;M[f+44>>2]=b;M[f+8>>2]=b;b=tb(j,1912,f);Om(a);if(P[f+44>>2]<4){continue}pe(4,f+44|0);continue}break}M[i>>2]=b;p=i,q=Uf(b),K[p+7|0]=q;if(K[k+10|0]&1){L[i+10>>1]=O[i+10>>1]|1024}k:{if(!b){break k}if((wd(f+24|0,b,k)|0)!=(k|0)){break k}Lb(j)}i=i+12|0;l=l+1|0;continue}}function to(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;i=O[a+18>>1];l=O[a+24>>1];n=i+(l<<1)|0;f=M[a+52>>2];d=M[f+40>>2];a:{b:{g=M[a+56>>2];h=g+N[a+9|0]|0;if(N[h+7|0]>(b|0)){j=d-4|0;break b}j=d-4|0;k=N[h+2|0]|N[h+1|0]<<8;if((j|0)<(k|0)){return db(72425)}if(!k){break b}b=g+k|0;e=N[b|0]<<8|N[b+1|0];if(e>>>0>j>>>0){return db(72428)}if(e){c=g+e|0;if(N[c|0]|N[c+1|0]){break b}}c=N[h+6|0]|N[h+5|0]<<8;if(c>>>0>=k>>>0){return db(72436)}f=N[b+3|0]|N[b+2|0]<<8;b=k+f|0;c:{if(e){if(b>>>0>e>>>0){return db(72439)}m=d;d=g+e|0;j=N[d+2|0]<<8|N[d+3|0];if((m|0)<(e+j|0)){return db(72441)}d=e-b|0;if(d){b=b+g|0;G(b+j|0,b,d)}f=f+j|0;break c}j=0;if((b|0)<=(d|0)){break c}return db(72445)}d=c+f|0;b=k-c|0;if(b){G(d+g|0,c+g|0,b)}o=g+n|0;c=g+i|0;while(1){if(c>>>0<o>>>0){b=f;l=N[c+1|0]|N[c|0]<<8;d:{if(l>>>0>=k>>>0){b=j;if(e>>>0<=l>>>0){break d}}b=b+l|0;b=b<<8|(b&65280)>>>8;K[c|0]=b;K[c+1|0]=b>>>8}c=c+2|0;continue}break}b=N[h+7|0];break a}e:{if(!l){break e}b=N[h+5|0]<<8;c=N[h+6|0];k=M[M[f>>2]+224>>2];if(d){G(k,g,d)}o=b|c;m=g+i|0;c=0;b=d;while(1){if((c|0)==(l|0)){d=b;break e}f=(c<<1)+m|0;i=N[f|0]<<8|N[f+1|0];if((i|0)>(j|0)){return db(72478)}p=k+i|0;e=Ra[M[a+76>>2]](a,p)|0;b=b-e|0;if(!((o|0)<=(b|0)&(e+i|0)<=(d|0))){return db(72484)}i=b<<8|(b&65280)>>>8;K[f|0]=i;K[f+1|0]=i>>>8;if(e){G(b+g|0,p,e)}c=c+1|0;continue}}K[h+7|0]=0;b=0}m=M[a+20>>2];a=d-n|0;if((m|0)!=(a+b|0)){return db(72498)}K[h+1|0]=0;K[h+2|0]=0;b=d<<8|(d&65280)>>>8;K[h+5|0]=b;K[h+6|0]=b>>>8;if(a){D(g+n|0,0,a)}return 0}function DF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;c=Na-32|0;Na=c;Nj(a);a:{b:{if(!b){break b}f=a+168|0;D(f,0,56);M[a+192>>2]=1;M[a+184>>2]=M[a+36>>2];g=Zj(M[e>>2]);d=M[e>>2];c:{d:{if(g){h=a,i=Fb(d),M[h+172>>2]=i;h=a,i=od(M[e>>2]),M[h+168>>2]=i;break d}h=a,i=gb(d),M[h+180>>2]=i;h=a,i=Fb(M[e>>2]),M[h+188>>2]=i;if(!M[a+180>>2]){M[a+8>>2]=0;M[a+12>>2]=0;break b}if(!om(f,0)){break d}if(N[a+203|0]){break c}ab(M[M[a>>2]+8>>2]);b=Hb(20034,0);M[M[a>>2]+8>>2]=b;Nj(a);e=M[M[a>>2]+8>>2]?1:7;break a}e:{if((b|0)==3){d=gb(M[e+4>>2]);if(!d){break b}if(N[d|0]!=36){ab(M[M[a>>2]+8>>2]);M[c+16>>2]=d;b=Hb(19979,c+16|0);M[M[a>>2]+8>>2]=b;Nj(a);e=M[M[a>>2]+8>>2]?1:7;break a}h=a,i=jb(d),M[h+16>>2]=i;f:{g:{if(!N[d+1|0]){b=0;K[a+20|0]=0;break g}b=Pe(f,0,d+1|0,0);if(b>>>0>=4294967293){if((b|0)==-2){e=0;K[a+20|0]=0;M[a+8>>2]=0;M[a+12>>2]=0;break a}ab(M[M[a>>2]+8>>2]);M[c>>2]=d;b=Hb(19979,c);M[M[a>>2]+8>>2]=b;Nj(a);e=M[M[a>>2]+8>>2]?1:7;break a}e=M[a+216>>2];if(e){K[a+20|0]=12;M[a+8>>2]=e;break f}K[a+20|0]=11}M[a+8>>2]=b}af(a+40|0,d,M[a+16>>2]);break e}b=0;K[a+20|0]=0;M[a+8>>2]=0;M[a+16>>2]=1;af(a+40|0,29253,1)}e=0;M[a+24>>2]=0;d=jc(f,b,c+28|0)+b|0;M[a+12>>2]=d+M[c+28>>2];f=M[a+168>>2]+b|0;if(N[a+21|0]|(N[f|0]&15)>>>0<11){break a}M[a+8>>2]=d;K[a+20|0]=N[f|0]&15;d=ub(M[a+36>>2],24,0);M[a+32>>2]=d;if(!d){break c}M[a+24>>2]=1;M[a+28>>2]=1;M[d+16>>2]=0;M[d+20>>2]=0;M[d+8>>2]=M[a+12>>2];a=M[a+8>>2];M[d+4>>2]=b;M[d>>2]=a;break a}e=7;break a}e=0}Na=c+32|0;return e|0}function zh(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;j=Na-16|0;Na=j;a:{b:{if(N[a|0]){break b}h=N[a+1|0];if(!(h&2)){break b}g=M[a+32>>2];f=M[a+36>>2];if((g|0)==(b|0)&(f|0)==(c|0)){f=0;M[e>>2]=0;break a}if((c|0)<=(f|0)&b>>>0<=g>>>0|(c|0)<(f|0)){break b}if(h&8){M[e>>2]=-1;f=0;break a}g=g+1|0;f=g?f:f+1|0;if((b|0)!=(g|0)|(c|0)!=(f|0)){break b}M[e>>2]=0;f=vj(a);if((f|0)==101){break b}if(f){break a}Ng(a);f=0;if((b|0)==M[a+32>>2]&(c|0)==M[a+36>>2]){break a}}f=Zf(a);if((f|0)!=16){if(f){break a}p=d^1;while(1){i=M[a+116>>2];m=O[i+24>>1];k=m-1|0;g=k>>p;n=M[i+64>>2];o=O[i+26>>1];q=M[i+68>>2];h=0;r=N[i+2|0];c:{d:{e:{f:{while(1){d=(g<<1)+n|0;f=((N[d|0]<<8|N[d+1|0])&o)+q|0;g:{if(!r){break g}while(1){d=f+1|0;if(K[f|0]>=0){f=d;break g}f=d;if(f>>>0<P[i+60>>2]){continue}break}f=db(76598);break a}Ph(f,j+8|0);h:{d=M[j+8>>2];l=M[j+12>>2];f=l;i:{if(d>>>0<b>>>0&(f|0)<=(c|0)|(c|0)>(f|0)){h=g+1|0;if((g|0)<(k|0)){break i}d=-1;break e}if((c|0)>=(l|0)&b>>>0>=d>>>0|(c|0)>(l|0)){break h}if((g|0)<=(h|0)){break f}k=g-1|0}g=h+k>>1;continue}break}L[a+70>>1]=g;if(!N[i+8|0]){h=g;break d}f=0;L[a+50>>1]=0;M[a+32>>2]=d;M[a+36>>2]=l;K[a+1|0]=N[a+1|0]|2;M[e>>2]=0;break a}d=1}if(!N[i+8|0]){break d}L[a+70>>1]=g;M[e>>2]=d;f=0;break c}d=M[i+56>>2];if((h|0)>=(m|0)){d=(d+N[i+9|0]|0)+8|0}else{f=(h<<1)+n|0;d=d+((N[f|0]<<8|N[f+1|0])&o)|0}d=mb(d);L[a+70>>1]=h;f=Ig(a,d);if(!f){continue}}break}L[a+50>>1]=0;break a}M[e>>2]=-1;f=0}Na=j+16|0;return f}function fz(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;c=M[a+20>>2];a:{if(N[c+17|0]==2){b=M[c+44>>2];if(b){break a}b:{if(M[c+232>>2]|N[c+5|0]==2){break b}d=M[c>>2];b=kj(M[c+28>>2]);M[c+60>>2]=b;if(!b){return 7}b=M[c+68>>2];c:{d:{if(M[b>>2]){break d}if(N[c+5|0]==4){D(b+8|0,0,56);M[b>>2]=33496;M[b+4>>2]=1020;M[b+8>>2]=-1;break d}g=M[16873];e=N[c+12|0];b=Av(c);if(!b){b=vv(d,M[c+188>>2],M[c+68>>2],e?4126:2054,e?g:0)}if(b){break c}}M[c+80>>2]=0;M[c+84>>2]=0;K[c+20|0]=0;M[c+48>>2]=0;M[c+88>>2]=0;M[c+92>>2]=0;b=nv(c);if(!b){break b}}dg(M[c+60>>2]);M[c+80>>2]=0;M[c+84>>2]=0;M[c+60>>2]=0;return b}K[c+17|0]=3}bl(a);b=M[c+60>>2];e:{if(!b){break e}d=b;b=M[a+24>>2];if(ol(d,b)){break e}if(b>>>0<=P[c+32>>2]){e=M[a+20>>2];b=M[e+84>>2];f=M[e+80>>2];g=M[a+4>>2];h=_u(e,g);L[a+28>>1]=O[a+28>>1]|8;d=ji(M[e+68>>2],f,b,M[a+24>>2]);f:{if(d){break f}d=M[e+68>>2];f=f+4|0;b=f>>>0<4?b+1|0:b;d=Ra[M[M[d>>2]+12>>2]](d,g,M[e+168>>2],f,b)|0;if(d){break f}b=M[e+172>>2]+b|0;d=f;f=M[e+168>>2];d=d+f|0;d=ji(M[e+68>>2],d,d>>>0<f>>>0?b+1|0:b,h);if(d){break f}M[e+48>>2]=M[e+48>>2]+1;g=M[e+80>>2];d=g+M[e+168>>2]|0;b=M[e+172>>2]+M[e+84>>2]|0;b=d>>>0<g>>>0?b+1|0:b;d=d+8|0;b=d>>>0<8?b+1|0:b;M[e+80>>2]=d;M[e+84>>2]=b;d=Tg(M[e+60>>2],M[a+24>>2])|bp(e,M[a+24>>2])}b=d;if(!b){break e}break a}if(N[c+17|0]==4){break e}L[a+28>>1]=O[a+28>>1]|8}L[a+28>>1]=O[a+28>>1]|4;if(M[c+104>>2]<=0){b=0}else{b=em(a)}a=M[a+24>>2];if(a>>>0<=P[c+28>>2]){break a}M[c+28>>2]=a}return b}function Zx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=Na-160|0;Na=g;l=M[b+20>>2];D(g+24|0,0,128);f=M[b+8>>2];h=M[b+12>>2];j=M[a+24>>2];M[g+16>>2]=c;M[g+20>>2]=(h?32:0)|(f?11:3)|((c|0)<(j|0)?4:0);M[g+8>>2]=M[b>>2];M[g+12>>2]=M[b+4>>2];m=g+88|0;f=Vj(a,l,g+8|0);a:while(1){b:{c:{d:{e:{if(f){break e}f=li(a,l);if((f|0)==100){break b}if(f){break e}c=f;while(1){if((c|0)==16){break d}f:{i=c<<2;j=i+(g+24|0)|0;h=M[j>>2];g:{if(!h){break g}if(!k){f=M[i+m>>2];M[j>>2]=0;k=h;break g}f=Wx(N[a+239|0],h,M[i+m>>2],k,f,g+152|0,g+156|0);if(f){break f}ab(M[j>>2]);ab(k);M[j>>2]=0;f=M[g+156>>2];k=M[g+152>>2]}c=c+1|0;continue}break}ab(k)}c=0;while(1){if((c|0)==16){break c}ab(M[(g+24|0)+(c<<2)>>2]);c=c+1|0;continue}}M[e>>2]=k;M[d>>2]=f;f=0}aq(l);M[b+20>>2]=0;Na=g+160|0;return f}i=M[l+60>>2];j=M[l+56>>2];c=0;h:{if(M[g+24>>2]){h=j;while(1){if((c|0)==16){break h}f=c<<2;n=f+(g+24|0)|0;o=M[n>>2];if(!o){M[n>>2]=h;M[f+m>>2]=i;break h}p=f+m|0;f=Wx(N[a+239|0],h,i,o,M[p>>2],g+156|0,g+152|0);if(f){if((h|0)==(j|0)){continue a}ab(h);continue a}if((h|0)!=(j|0)){ab(h)}ab(o);M[n>>2]=0;i=M[g+152>>2];h=M[g+156>>2];if((c|0)==15){M[n>>2]=h;M[p>>2]=i}c=c+1|0;continue}}c=i>>31;f=i+11|0;c=f>>>0<11?c+1|0:c;c=Bb(f,c);M[g+88>>2]=i;M[g+24>>2]=c;f=7;if(!c){continue}if(i){G(c,j,i)}c=c+i|0;K[c|0]=0;K[c+1|0]=0;K[c+2|0]=0;K[c+3|0]=0;K[c+4|0]=0;K[c+5|0]=0;K[c+6|0]=0;K[c+7|0]=0;f=0;K[c+8|0]=0;K[c+9|0]=0;continue}f=0;continue}}function Tz(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;j=Cb(a);m=M[a+60>>2]-1|0;M[a+60>>2]=m;k=M[a+44>>2];if((h|0)<0){$a(j,49,N[e+24|0],m)}n=k-1|0;o=g+1|0;k=0;while(1){l=M[e+20>>2];if((k|0)<(l|0)){$a(j,51,Pc(M[e>>2],L[(k<<2)+f>>1])+o|0,m);k=k+1|0;continue}break}a:{if(i){break a}if(!d){d=Gb(a);$a(j,81,Pc(M[e>>2],L[f>>1])+o|0,d);f=$a(j,13,d,0);b:{if((h|0)!=1|M[e>>2]!=(c|0)){break b}bb(j,54,g,m,d);g=M[j+108>>2];if((g|0)<=0){break b}L[(M[j+104>>2]+S(g,20)|0)-18>>1]=144}Pd(a,n,b,c,102);bb(j,31,n,0,d);Xb(j,m);b=M[j+108>>2];c:{if(N[M[j>>2]+87|0]){M[18591]=b;c=74356;break c}c=M[j+104>>2];M[(c+S(b,20)|0)-32>>2]=b;c=c+S(f,20)|0}M[c+8>>2]=b;zb(a,d);break a}i=vc(a,l);bb(j,102,n,M[d+44>>2],b);Ld(a,d);k=0;b=(l|0)>0?l:0;while(1){q=M[e>>2];if((b|0)!=(k|0)){$a(j,80,Pc(q,L[(k<<2)+f>>1])+o|0,i+k|0);k=k+1|0;continue}break}if(!((h|0)!=1|(c|0)!=(q|0))){q=(M[j+108>>2]+l|0)+1|0;k=0;while(1){if((b|0)!=(k|0)){r=Pc(M[e>>2],L[(k<<2)+f>>1])+o|0;p=O[M[d+4>>2]+(k<<1)>>1];bb(j,53,r,q,(s=g,t=Pc(M[d+12>>2],p<<16>>16)+o|0,u=(p|0)==O[c+32>>1],u?s:t));p=M[j+108>>2];if((p|0)>0){L[(M[j+104>>2]+S(p,20)|0)-18>>1]=16}k=k+1|0;continue}break}Xb(j,m)}nb(j,96,i,l,0,zi(M[a>>2],d),l);lb(j,29,n,m,i,l);ad(a,i,l)}b=N[e+24|0];d:{e:{if(b){break e}if(!(N[a+20|0]|(M[a+132>>2]|N[M[a>>2]+34|0]&8))){Ii(a,787,2,0,-1,4);break d}if((h|0)<=0){break e}c=M[a+132>>2];K[(c?c:a)+21|0]=1}$a(j,158,b,h)}pb(j,m);fb(j,122,n)}function ir(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=M[b>>2];p=M[n>>2];j=K[b+32|0]&1;k=p+!j|0;o=k+f|0;m=M[b+4>>2];if(g){i=d-g|0}else{i=M[a+48>>2];M[a+48>>2]=i+o;i=i+1|0}l=M[c+12>>2];a:{if(l){l=l+1|0;break a}l=M[c+8>>2]}h=M[a+8>>2];q=M[a+60>>2]-1|0;M[a+60>>2]=q;M[b+24>>2]=q;kf(a,n,i,e,e?5:1);if(!j){$a(h,126,M[b+8>>2],i+p|0)}if(!((f|0)<=0|g)){Di(a,d,i+k|0,f)}g=0;f=0;b:{if((m|0)>0){f=Zz(a,b,c,i,o);k=M[b+4>>2];d=M[a+48>>2];M[a+48>>2]=k+d;n=d+1|0;c:{if(!j){d=fb(h,17,i+p|0);break c}d=fb(h,120,M[b+8>>2])}bb(h,90,n,i,M[b+4>>2]);e=74356;e=N[M[h>>2]+87|0]?e:M[h+104>>2]+S(M[b+20>>2],20)|0;if(N[M[a>>2]+87|0]){break b}M[e+8>>2]=o-k;j=M[e+16>>2];k=O[j+6>>1];if(k){D(M[j+16>>2],0,k)}Vd(h,-1,j,-8);r=e,s=Ue(a,M[b>>2],m,O[j+8>>1]+(O[j+6>>1]^-1)|0),M[r+16>>2]=s;k=M[h+108>>2];e=k+1|0;bb(h,14,e,0,e);e=M[a+60>>2]-1|0;M[a+60>>2]=e;M[b+16>>2]=e;j=M[a+48>>2]+1|0;M[a+48>>2]=j;M[b+12>>2]=j;$a(h,10,j,e);fb(h,146,M[b+8>>2]);if(l){$a(h,17,l,M[b+24>>2])}e=M[h+108>>2];M[(N[M[h>>2]+87|0]?74356:M[h+104>>2]+S(d,20)|0)+8>>2]=e;Di(a,i,n,M[b+4>>2]);e=M[h+108>>2];M[(N[M[h>>2]+87|0]?74356:M[h+104>>2]+S(k,20)|0)+8>>2]=e}if(l){d=M[b+8>>2];$a(h,60,l,M[h+108>>2]+4|0);$a(h,32,d,0);g=lb(h,40,d,0,i+m|0,p-m|0);fb(h,130,d)}if(!f){f=Zz(a,b,c,i,o)}lb(h,K[b+32|0]&1?139:138,M[b+8>>2],f,i+m|0,o-m|0);if(!g){break b}b=M[b+28>>2];if(!b){b=M[h+108>>2]}M[(N[M[h>>2]+87|0]?74356:M[h+104>>2]+S(g,20)|0)+8>>2]=b}}function nc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=M[a+8>>2];g=M[a+4>>2];k=N[g+16|0];h=M[a>>2];i=M[h+60>>2]-1|0;M[h+60>>2]=i;f=(b|0)==2;if(!(f&N[g+17|0]==91)){a:{b:{if((c|0)<=0){break b}if((k|0)==90){l=M[e+108>>2];if(f){if(N[g+17|0]==87){Ci(a,56,M[a+40>>2],c,M[a+32>>2],i);break a}Ci(a,58,M[a+32>>2],c,M[a+40>>2],i);break a}Ci(a,55,M[a+48>>2],c,M[a+40>>2],i);break b}bb(e,50,c,i,1)}if(M[g+88>>2]|(b|0)!=1){break a}on(a,0)}m=M[e+108>>2];if(!(!c|N[g+17|0]!=N[g+18|0]|N[g+16|0]!=90)){j=Gb(h);c=Gb(h);c:{d:{if((b|0)==2){$a(e,135,M[a+32>>2],j);$a(e,135,M[a+48>>2],c);f=c;break d}if(!M[a+28>>2]){break c}$a(e,135,M[a+48>>2],j);f=M[a+28>>2]}bb(e,58,f,i,j)}zb(h,j);zb(h,c)}e:{f:{switch(b-1|0){case 0:j=M[a+44>>2];c=M[a+40>>2];as(a);break e;case 1:j=M[a+36>>2];c=M[a+32>>2];f=M[g+88>>2];if(f){$a(e,86,f,1);break e}$q(a,g,c,1,M[a+20>>2]);break e;default:break f}}j=M[a+52>>2];c=M[a+48>>2];if(M[g+88>>2]){$a(e,86,M[g+92>>2],1);break e}$q(a,g,c,0,M[a+20>>2])}g:{if(M[a+24>>2]!=(b|0)){b=M[e+108>>2];break g}fb(e,130,c);b=M[e+108>>2];if((b|0)<=0){break g}L[(M[e+104>>2]+S(b,20)|0)-18>>1]=2}h:{i:{if(!d){d=b;b=(k|0)==77;$a(e,39,c,d+(b?1:2)|0);if(b){break h}$a(e,9,0,i);break i}$a(e,39,c,b+2|0);n=Ub(e,9);if((k|0)==77){break h}}d=0;b=a;f=M[g+12>>2];a=0;j:{if(!f){break j}f=M[f>>2];a=0;if(!f){break j}d=f;a=vc(h,f)}gk(b,c,a);$r(h,M[g+12>>2],a,j,m);ad(h,a,d)}if(l){$a(e,9,0,l)}pb(e,i)}return n}function iq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;c=Na-32|0;Na=c;g=M[b>>2];M[c>>2]=g;if(!g){j=a+28|0;a:{if(!M[a+28>>2]){break a}g=Wl(0,a);M[c>>2]=g;if(g){break a}b:{if(!M[j>>2]){break b}k=M[a>>2];p=M[k+36>>2];q=M[p>>2];s=dd(M[a+12>>2],0);t=Qa;while(1){g=M[k+24>>2];l=g>>31;d=!f;c:{while(1){if(!(d&1)|(g>>>0<=h>>>0&(e|0)>=(l|0)|(e|0)>(l|0))){break c}if(N[M[k+32>>2]+h|0]){h=h+1|0;e=h?e:e+1|0;d=1;continue}break}d=M[a+12>>2];g=h+1|0;l=g?e:e+1|0;d=ff(d,g);f=pg(p,M[a+20>>2],d,-1,c+24|0);n=M[c+24>>2];d:while(1){if(!f){M[c+16>>2]=0;M[c+12>>2]=0;M[c+8>>2]=0;M[c+4>>2]=0;f=Ra[M[q+20>>2]](n,c+20|0,c+16|0,c+12|0,c+8|0,c+4|0)|0;M[c+28>>2]=f;d=j;while(1){d=M[d>>2];if(!d|f){continue d}m=M[d>>2];f=0;i=M[d+4>>2];e:{if(((h|0)!=(i|0)|(e|0)!=0)&(i|0)<M[k+24>>2]){break e}i=M[c+4>>2];if(i?M[m+12>>2]:0){break e}o=M[m+4>>2];r=M[c+16>>2];if((o|0)!=(r|0)&(!M[m+8>>2]|(o|0)>=(r|0))){break e}if(Qb(M[c+20>>2],M[m>>2],o)){break e}Qx(d+12|0,s,t,h,e,i,i>>31,c+28|0);f=M[c+28>>2]}d=d+8|0;continue}}break}if(n){Ra[M[q+16>>2]](n)|0}if((f|0)==101){M[c+28>>2]=0;f=0}h=g;e=l;continue}break}d=j;while(1){e=M[d>>2];if(!e|f){break b}if(M[e+12>>2]){f=Rj(e+12|0,0,0)}else{f=0}d=e+8|0;continue}}M[c>>2]=f}e=fi(a,M[a+16>>2],c);while(1){a=M[j>>2];if(a){ab(M[a+12>>2]);M[a+12>>2]=0;j=a+8|0;continue}break}a=M[c>>2];M[b>>2]=a;d=!(a|e)}Na=c+32|0;return d}function um(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=Na-48|0;Na=d;h=M[a>>2];c=M[a+260>>2];M[d+40>>2]=0;M[d+44>>2]=0;M[d+32>>2]=0;M[d+36>>2]=0;M[d+24>>2]=0;M[d+28>>2]=0;M[d+16>>2]=0;M[d+20>>2]=0;M[d+12>>2]=a;b=Hc(h,M[c+4>>2],M[M[h+16>>2]+(Mb(h,M[c+24>>2])<<4)>>2]);M[a+136>>2]=b;K[a+162|0]=N[c+8|0];a:{b:{if(!b){break b}if(!lf(a,b)){break b}b=1;break a}f=M[c+12>>2];b=0;if(!f){break a}b=id(d+12|0,f)}g=c+28|0;while(1){c:{if(b){break c}e=M[g>>2];if(!e){break c}b=M[e+8>>2];d:{e:{if(!b){break e}je(a,b,d+12|0);if(!M[a+40>>2]){break e}b=M[a+12>>2];if(b){break d}}if(!M[e+12>>2]){b=0;break d}i=zm(a,e);if(!i){b=7;break d}c=td(a,M[e+24>>2],i,0,0,0,0,0,0);f:{if(c){Fz(M[e+24>>2],1);je(a,c,0);Fz(M[e+24>>2],0);j=M[a+40>>2];f=(j|0)!=0;if(M[e+24>>2]){M[c+28>>2]=0}b=0;M[c+32>>2]=0;pc(h,c);g=M[e+16>>2];c=g?1:f;if(!g|j){break f}while(1)if(M[g>>2]<=(b|0)){c=f;break f}else{c=S(b,48)+g|0;if(N[c+21|0]&4){je(a,M[M[c+52>>2]>>2],0);g=M[e+16>>2]}b=b+1|0;continue}}i=0;M[e+24>>2]=0;c=7}b=N[h+87|0];M[d+16>>2]=i;b=b?7:c;g:{if(b){break g}c=M[e+20>>2];if(c){b=1;if(id(d+12|0,c)){break g}}b=Te(d+12|0,M[e+24>>2])}c=M[e+32>>2];if(!(!c|b)){M[c+32>>2]=i;M[d+36>>2]=512;M[d+20>>2]=c;b=1;f=d+12|0;h:{if(Te(f,M[c>>2])){break h}if(Te(f,M[c+8>>2])){break h}if(id(f,M[c+12>>2])){break h}b=id(f,M[c+4>>2])}M[d+36>>2]=0}M[d+16>>2]=0;Gc(h,i)}g=e+40|0;continue}break}Na=d+48|0;return b}function tF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((b|0)==2){a:{if((Sb(M[c>>2])|0)!=5){if((Sb(M[c+4>>2])|0)!=5){break a}}Yb(a);return}k=a;e=Kb(M[c>>2]);C(+e);a=x(1)|0;a=a&2147483647;b=!(x(0)|0)&(a|0)==2146435072|a>>>0<2146435072;g=Kb(M[c+4>>2]);C(+g);a=x(1)|0;a=a&2147483647;b:{if(!(b&(!(x(0)|0)&(a|0)==2146435072|a>>>0<2146435072))){d=e+g;break b}C(+g);b=x(1)|0;a=x(0)|0;c=a;if(!(a|b-1072693248)){d=Ip(e);break b}C(+e);a=x(1)|0;f=x(0)|0;j=b>>>30&2;h=j|a>>>31;a=a&2147483647;c:{if(!(a|f)){d:{switch(h-2|0){case 0:d=3.141592653589793;break b;case 1:break d;default:break c}}d=-3.141592653589793;break b}C(1.5707963267948966);f=x(1)|0;i=x(0)|0;C(+e);l=x(1)|0;x(0)|0;z(0,i|0);z(1,f&2147483647|l&-2147483648);b=b&2147483647;d=+B();if(!(b|c)){break b}e:{if((b|0)==2146435072){if((a|0)!=2146435072){break e}d=R[(h<<3)+63408>>3];break b}C(1.5707963267948966);c=x(1)|0;i=x(0)|0;C(+e);f=x(1)|0;x(0)|0;z(0,i|0);z(1,c&2147483647|f&-2147483648);d=+B();if(!((a|0)!=2146435072&a>>>0<=b+67108864>>>0)){break b}f:{if(j){d=0;if(b>>>0>a+67108864>>>0){break f}}d=Ip(U(e/g))}e=d;g:{switch(h-1|0){case 0:d=-e;break b;case 1:d=3.141592653589793-(e+-12246467991473532e-32);break b;case 2:break g;default:break c}}d=e+-12246467991473532e-32+-3.141592653589793;break b}e=R[(h<<3)+63440>>3]}d=e}Zb(k,d);return}ba(23737,17968,570,17897);I()}function hk(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=M[a+20>>2];a:{if(!c){c=101;a=M[a+12>>2];if(!a){break a}L[a>>1]=0;return 101}f=M[a>>2];g=M[M[f>>2]>>2];M[a+20>>2]=c-1;c=M[f+60>>2];if(!(!c|!(M[b+40>>2]&512))){h=N[b+16|0];while(1){b:{if(!(N[c+41|0]&2)|N[c+16|0]!=(h|0)){break b}c:{if(dA(c,b)){e=L[c+20>>1];d=L[b+20>>1];L[b+20>>1]=(e|0)<(d|0)?e:d;e=L[b+22>>1];d=L[c+22>>1];d=(e|0)<(d|0)?e:d-1|0;break c}if(!dA(b,c)){break b}e=L[c+20>>1];d=L[b+20>>1];L[b+20>>1]=(e|0)>(d|0)?e:d;e=L[b+22>>1];d=L[c+22>>1];d=(e|0)>(d|0)?e:d+1|0}L[b+22>>1]=d}c=M[c+56>>2];if(c){continue}break}}a=M[a+12>>2];if(a){c=0;if(!O[b+44>>1]){break a}fA(a,M[b>>2],M[b+4>>2],L[b+20>>1],L[b+22>>1]);return 0}c=cA(f+60|0,b);if(!c){return 0}d:{e:{a=M[c>>2];if(!a){a=Ob(g,72,0);M[c>>2]=a;if(a){break e}return 7}c=a+56|0;while(1){if(!M[c>>2]){break d}c=cA(c,b);if(!c){break d}f=M[c>>2];if(!f){break d}M[c>>2]=M[f+56>>2];mA(g,f);continue}}L[a+48>>1]=3;L[a+44>>1]=0;M[a+56>>2]=0;M[a+40>>2]=0;M[a+52>>2]=a+60}eA(g,a);f:{g:{c=O[b+44>>1];if(c>>>0<=O[a+48>>1]){break g}if(!si(g,a,c)){break g}D(a,0,48);c=7;break f}G(a,b,48);c=O[a+44>>1]<<2;if(c){G(M[a+52>>2],M[b+52>>2],c)}g=M[b+40>>2];if(g&1024){K[b+28|0]=N[b+28|0]&254;c=0;break f}c=0;if(!(g&16384)){break f}M[b+32>>2]=0;c=0}if(N[a+41|0]&4){break a}b=M[a+32>>2];if(!b|((N[b+55|0]|N[b+56|0]<<8)&3)!=3){break a}M[a+32>>2]=0}return c}function CD(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=Na-32|0;Na=c;f=N[a+16|0];a:{if((f|0)>=(b|0)){break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{e=M[a+8>>2];g=N[e+28|0];l:{if((f|0)!=(g|0)){d=5;if(b>>>0>1){break a}if(g>>>0<=2){break l}break a}if((b|0)!=1){break k}}if((g-1&255)>>>0<=1){K[a+16|0]=1;M[e+20>>2]=M[e+20>>2]+1;M[e+24>>2]=M[e+24>>2]+1;break b}d=0;L[c+2>>1]=0;M[c+16>>2]=1;M[c+20>>2]=0;break j}L[c+2>>1]=0;M[c+16>>2]=1;M[c+20>>2]=0;if((b|0)!=4){break f}d=1;if((f|0)!=2){break i}}L[c>>1]=d;f=M[16864];M[c+8>>2]=f;M[c+12>>2]=f>>31;if(Sg(a,c)){d=5;e=M[18595];b=ml(e);if((b|0)==5){break a}M[a+20>>2]=e;d=b;break a}if((b|0)!=4){break h}K[a+16|0]=3;K[e+28|0]=3;if(!d){break g}}d=5;if(M[e+20>>2]>1){break a}L[c>>1]=1;d=510;g=2;f=0;break e}if(d){break f}}M[c+16>>2]=510;M[c+20>>2]=0;d=M[16864]+2|0;M[c+8>>2]=d;M[c+12>>2]=d>>31;d=0;f=0;if(Sg(a,c)){f=M[18595];d=ml(f)}M[c+16>>2]=1;M[c+20>>2]=0;L[c>>1]=2;g=M[16864];M[c+8>>2]=g;M[c+12>>2]=g>>31;m:{if(!(!Sg(a,c)|d)){f=M[18595];d=2058;break m}if(!d){break d}if((d|0)==5){break a}}M[a+20>>2]=f;break a}g=(b|0)==2;d=g?1:510;L[c>>1]=1;g=g?1:2;f=0}M[c+16>>2]=d;M[c+20>>2]=f;d=g+M[16864]|0;M[c+8>>2]=d;M[c+12>>2]=d>>31;if(!Sg(a,c)){break c}d=5;e=M[18595];b=ml(e);if((b|0)==5){break a}M[a+20>>2]=e;d=b;break a}M[e+20>>2]=1;M[e+24>>2]=M[e+24>>2]+1}K[a+16|0]=b;K[e+28|0]=b}d=0}Na=c+32|0;return d|0}function xr(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=Na-48|0;Na=k;n=M[a>>2];if(!(N[n+87|0]|N[a+224|0]>1)){while(1){l=c;c=M[c+52>>2];if(c){continue}break}c=M[l+28>>2];D(k+12|0,0,36);M[k+16>>2]=M[l+32>>2];p=c+8|0;f=M[b+4>>2];while(1){if(L[b+34>>1]>(o|0)){M[b+28>>2]=M[b+28>>2]|O[f+10>>1]&98;j=0;i=o<<4;m=M[i+p>>2];e=rc(m);c=l;a:{b:{while(1){c:{K[f+5|0]=e;if(e<<24>>24>64){break c}if(M[c+56>>2]){j=rr(M[(i+M[c+28>>2]|0)+8>>2])|j;c=M[c+56>>2];e=rc(M[(i+M[c+28>>2]|0)+8>>2]);continue}else{c=d;break b}}break}g=65;if((e&255)==65){break a}h=M[c+56>>2];if((c|0)==(l|0)){g=e;if(!h){break a}}while(1){if(h){j=rr(M[(i+M[h+28>>2]|0)+8>>2])|j;h=M[h+56>>2];continue}break}c=65;g=K[f+5|0];if(j&1&(g|0)==66){break b}e=(g|0)<67;if(!(j&2?e:1)){break b}if(e){break a}c=70;if(N[m|0]!=36){break a}}K[f+5|0]=c;g=c}e=Km(k+12|0,m);d:{e:{if(e){if((g&255)==(Si(e,0)&255)){break e}g=N[f+5|0]}e=20154;c=1;f:{g=g&255;switch(g-67|0){case 0:case 3:break e;default:break f}}while(1){if((c|0)==6){break d}if((g|0)!=N[c+50864|0]){c=c+1|0;continue}break}e=M[(c<<2)+68240>>2];if(!e){break d}}h=M[f>>2];i=jb(e);g=jb(h);h=Zi(n,h,(i+g|0)+2|0,0);M[f>>2]=h;L[f+10>>1]=O[f+10>>1]&65019;if(!h){break d}c=i+1|0;if(c){G((g+h|0)+1|0,e,c)}L[f+10>>1]=O[f+10>>1]|4}c=Fd(a,m);if(c){As(n,f,M[c>>2])}f=f+12|0;o=o+1|0;continue}break}L[b+40>>1]=1}Na=k+48|0}function vG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(M[a+56>>2]){return 1}M[b+40>>2]=0;M[b+44>>2]=1095963344;M[b+20>>2]=0;c=M[b>>2];m=(c|0)>0?c:0;h=-1;i=-1;j=-1;f=-1;c=0;while(1){a:{b:{c:{if((c|0)!=(m|0)){d=M[b+4>>2]+S(c,12)|0;if(!N[d+5|0]){if(N[d+4|0]!=64){break a}M[b+48>>2]=0;M[b+52>>2]=262144;M[b+40>>2]=-981572454;M[b+44>>2]=1246829326;M[b+20>>2]=0;return 0}g=M[d>>2];l=(g|0)<0;if(l){k=1}else{k=(M[a+24>>2]+1|0)==(g|0)}d=N[d+4|0];if(!(!k|((d|0)!=2|(f|0)>=0))){M[b+40>>2]=0;M[b+44>>2]=1072693248;e=1;M[b+20>>2]=1;f=c;break c}if((d|0)==2){break c}if((d|0)!=64){break b}d=64;if(M[a+24>>2]<(g|0)|l){break b}M[b+40>>2]=0;M[b+44>>2]=1073741824;e=g+2|0;M[b+20>>2]=e;f=c;break b}c=1;if((e|0)==1){M[b+56>>2]=M[b+56>>2]|1}if((f|0)>=0){c=M[b+16>>2]+(f<<3)|0;K[c+4|0]=1;M[c>>2]=1;c=2}if((h|0)>=0){e=e|65536;M[b+20>>2]=e;M[M[b+16>>2]+(h<<3)>>2]=c;c=c+1|0}if((i|0)>=0){e=e|131072;M[b+20>>2]=e;M[M[b+16>>2]+(i<<3)>>2]=c;c=c+1|0}if((j|0)>=0){M[b+20>>2]=e|262144;M[M[b+16>>2]+(j<<3)>>2]=c}if(M[b+8>>2]!=1){return 0}c=M[b+12>>2];f=M[c>>2];if(!((f|0)>=0&(f|0)!=(M[a+24>>2]+1|0))){a=N[c+4|0];M[b+32>>2]=1;M[b+24>>2]=a?20562:20976}return 0}d=2;h=(M[a+24>>2]+2|0)==(g|0)?c:h}if(!k){break a}d:{switch(cK(d-4|0,30)|0){case 1:case 3:j=c;break a;case 0:case 7:break d;default:break a}}i=c}c=c+1|0;continue}}function Dy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=Na-32|0;Na=e;c=ov(a);a:{if(c){break a}b:{if(N[a+7|0]){break b}c=M[a+68>>2];h=M[c>>2];if(!(!h|N[a+5|0]==4)){f=M[a+64>>2];g=M[f>>2];c:{d:{if(!g){f=0;break d}f=Ra[M[g+48>>2]](f)|0;d=1;if(f&512){break c}c=M[a+68>>2];h=M[c>>2]}M[e+8>>2]=-117058087;M[e+12>>2]=-681336544;d=M[a+48>>2];M[e+16>>2]=d<<24|(d&65280)<<8|(d>>>8&65280|d>>>24);d=bm(a);g=Qa;c=Ra[M[h+8>>2]](c,e+24|0,8,d,g)|0;e:{if(!c){if((N[e+24|0]|N[e+25|0]<<8|(N[e+26|0]<<16|N[e+27|0]<<24))!=-117058087|(N[e+28|0]|N[e+29|0]<<8|(N[e+30|0]<<16|N[e+31|0]<<24))!=-681336544){break e}c=M[a+68>>2];c=Ra[M[M[c>>2]+12>>2]](c,33580,1,d,g)|0}if((c|0)==522){break e}if(c){break a}}f:{if(!N[a+8|0]|f&1024){break f}d=N[a+10|0];if(!d){break f}c=M[a+68>>2];c=Ra[M[M[c>>2]+20>>2]](c,d)|0;if(c){break a}}c=M[a+68>>2];c=Ra[M[M[c>>2]+12>>2]](c,e+8|0,12,M[a+88>>2],M[a+92>>2])|0;if(c){break a}d=0}g:{if(f&1024){break g}c=N[a+10|0];c=((c|0)==3?16:0)|c;if(!c){break g}f=M[a+68>>2];c=Ra[M[M[f>>2]+20>>2]](f,c)|0;if(c){break a}}c=M[a+84>>2];M[a+88>>2]=M[a+80>>2];M[a+92>>2]=c;if(d|!b){break b}M[a+48>>2]=0;c=nv(a);if(!c){break b}break a}b=M[a+84>>2];M[a+88>>2]=M[a+80>>2];M[a+92>>2]=b}d=M[a+228>>2];c=d;while(1){b=M[c>>2];if(b){L[b+28>>1]=O[b+28>>1]&65527;c=b+40|0;continue}break}M[d+8>>2]=M[d+4>>2];K[a+17|0]=4;c=0}Na=e+32|0;return c}function Dc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;h=Na-16|0;Na=h;f=M[a+8>>2];M[h+12>>2]=0;if(!(!b|!f)){e=N[b|0];g=(e+1^1)-1|0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{switch(e-43|0){default:if((e|0)==19){break i}if((e|0)!=175){break b}e=0;g=N[b+2|0]==46;d=g?0:16;f=M[b+12>>2];if((vi(M[b+16>>2])|0)==(g|0)){break h}Dc(a,f,c,d);break a;case 0:case 1:break j;case 2:case 3:break g;case 4:case 5:break b;case 6:break d;case 7:break c;case 8:case 9:break e;case 10:case 11:case 12:case 13:case 14:case 15:break f}}g=Qm(b);if((g|0)!=(b|0)){Dc(a,g,c,d);e=0;break a}if((e|0)==44){Dc(a,M[b+12>>2],c,d);Dc(a,M[b+16>>2],c,d);e=0;break a}e=M[a+60>>2]-1|0;M[a+60>>2]=e;Re(a,M[b+12>>2],e,d^16);Dc(a,M[b+16>>2],c,d);pb(f,e);e=0;break a}Re(a,M[b+12>>2],c,d);e=0;break a}Re(a,f,c,d);break a}g=(e|0)==45?53:54;d=128}e=M[b+12>>2];if(ze(e)){break b}e=Oc(a,e,h+12|0);f=Oc(a,M[b+16>>2],h+8|0);Sm(a,M[b+12>>2],M[b+16>>2],g,e,f,c,d,M[b+4>>2]>>>10&1);e=M[h+8>>2];break a}b=Oc(a,M[b+12>>2],h+12|0);Kr(f,b);$a(f,g,b,c);e=0;break a}Fr(a,b,c,74,d);e=0;break a}if(d){Wm(a,b,c,c);e=0;break a}d=M[a+60>>2]-1|0;M[a+60>>2]=d;Wm(a,b,c,d);pb(f,d);e=0;break a}g=M[b+4>>2];if((g&536870913)==536870912){Xb(f,c);e=0;break a}e=0;if((g&268435457)==268435456){break a}bb(f,17,Oc(a,b,h+12|0),c,(d|0)!=0)}zb(a,M[h+12>>2]);zb(a,e)}Na=h+16|0}function Cj(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;a:{b:{c:{C(+a);b=x(1)|0;x(0)|0;d:{e:{e=b&2147483647;if(e>>>0>=1078159482){C(+a);e=x(1)|0;e=e&2147483647;if((e|0)==2146435072&(x(0)|0)!=0|e>>>0>2146435072){break a}if((b|0)<0){return-1}if(!(a>709.782712893384)){break e}return a*898846567431158e293}if(e>>>0<1071001155){break c}if(e>>>0>1072734897){break e}if((b|0)>0|(b|0)>=0){b=1;c=1.9082149292705877e-10;g=a+-.6931471803691238;break d}b=-1;c=-1.9082149292705877e-10;g=a+.6931471803691238;break d}C(.5);b=x(1)|0;h=x(0)|0;C(+a);e=x(1)|0;x(0)|0;z(0,h|0);z(1,b&2147483647|e&-2147483648);c=a*1.4426950408889634+ +B();if(U(c)<2147483647){b=~~c}else{b=-2147483648}d=+(b|0);c=d*1.9082149292705877e-10;g=a+d*-.6931471803691238}a=g;a=a-c;c=g-a-c;break b}if(e>>>0<1016070144){break a}b=0}f=a*.5;d=a*f;g=d*(d*(d*(d*(d*-2.0109921818362437e-7+4008217827329362e-21)+-793650757867488e-19)+.0015873015872548146)+-.03333333333333313)+1;f=3-g*f;f=d*((g-f)/(6-a*f));if(!b){return a-(a*f-d)}c=a*(f-c)-c-d;f:{switch(b+1|0){case 0:return(a-c)*.5+-.5;case 2:if(a<-.25){return(c-(a+.5))*-2}a=a-c;return a+a+1;default:break f}}z(0,0);z(1,b+1023<<20);d=+B();if(b>>>0>=57){a=a-c+1;return((b|0)==1024?(a+a)*898846567431158e293:a*d)+-1}z(0,0);z(1,1023-b<<20);f=+B();a=(b>>>0<=19?1-f+(a-c):a-(c+f)+1)*d}return a}function Re(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;h=Na-16|0;Na=h;f=M[a+8>>2];M[h+12>>2]=0;if(!(!b|!f)){a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{e=N[b|0];switch(e-43|0){case 0:case 1:break j;case 2:case 3:break g;case 4:case 5:break b;case 6:break d;case 7:break c;case 8:case 9:break e;case 10:case 11:case 12:case 13:case 14:case 15:break f;default:break k}}if((e|0)==19){break i}if((e|0)!=175){break b}e=0;g=N[b+2|0]==46;d=g?16:0;f=M[b+12>>2];if((vi(M[b+16>>2])|0)==(g|0)){break h}Re(a,f,c,d);break a}g=Qm(b);if((g|0)!=(b|0)){Re(a,g,c,d);e=0;break a}if((e|0)==44){e=M[a+60>>2]-1|0;M[a+60>>2]=e;Dc(a,M[b+12>>2],e,d^16);Re(a,M[b+16>>2],c,d);pb(f,e);e=0;break a}Re(a,M[b+12>>2],c,d);Re(a,M[b+16>>2],c,d);e=0;break a}Dc(a,M[b+12>>2],c,d);e=0;break a}Dc(a,f,c,d);break a}e=(e|0)==45?54:53;d=128}g=M[b+12>>2];if(ze(g)){break b}f=Oc(a,g,h+12|0);g=Oc(a,M[b+16>>2],h+8|0);Sm(a,M[b+12>>2],M[b+16>>2],e,f,g,c,d,M[b+4>>2]>>>10&1);e=M[h+8>>2];break a}b=Oc(a,M[b+12>>2],h+12|0);Kr(f,b);$a(f,e,b,c);e=0;break a}Fr(a,b,c,82,d);e=0;break a}e=M[a+60>>2]-1|0;M[a+60>>2]=e;Wm(a,b,e,d?c:e);Xb(f,c);pb(f,e);e=0;break a}g=M[b+4>>2];if((g&268435457)==268435456){Xb(f,c);e=0;break a}e=0;if((g&536870913)==536870912){break a}bb(f,16,Oc(a,b,h+12|0),c,(d|0)!=0)}zb(a,M[h+12>>2]);zb(a,e)}Na=h+16|0}function zy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Na-16|0;Na=h;d=M[a+64>>2];a:{if(!M[d>>2]){e=M[a>>2];e=Ra[M[e+24>>2]](e,0,d,M[a+152>>2]&17334113|30,0)|0;if(e){break a}}e=0;c=M[a+40>>2];d=M[a+28>>2];if(c>>>0>=d>>>0|!M[b+16>>2]&c>>>0>=P[b+24>>2]){break a}k=h,l=ZJ(M[a+168>>2],M[a+172>>2],d,0),M[k+8>>2]=l;M[h+12>>2]=Qa;c=M[a+64>>2];f=M[c>>2];if(f){Ra[M[f+40>>2]](c,5,h+8|0)|0;d=M[a+28>>2]}M[a+40>>2]=d}while(1){if(!(!b|e)){e=0;f=M[b+24>>2];if(!(N[b+28|0]&16|f>>>0>P[a+28>>2])){d=M[a+168>>2];e=ZJ(d,M[a+172>>2],f-1|0,0);g=Qa;i=(f|0)!=1;if(!i){pq(b);d=M[a+168>>2]}j=M[a+64>>2];c=M[b+4>>2];e=Ra[M[M[j>>2]+12>>2]](j,c,d,e,g)|0;if(!i){d=N[c+28|0]|N[c+29|0]<<8|(N[c+30|0]<<16|N[c+31|0]<<24);g=N[c+24|0]|N[c+25|0]<<8|(N[c+26|0]<<16|N[c+27|0]<<24);K[a+112|0]=g;K[a+113|0]=g>>>8;K[a+114|0]=g>>>16;K[a+115|0]=g>>>24;K[a+116|0]=d;K[a+117|0]=d>>>8;K[a+118|0]=d>>>16;K[a+119|0]=d>>>24;d=N[c+36|0]|N[c+37|0]<<8|(N[c+38|0]<<16|N[c+39|0]<<24);c=N[c+32|0]|N[c+33|0]<<8|(N[c+34|0]<<16|N[c+35|0]<<24);K[a+120|0]=c;K[a+121|0]=c>>>8;K[a+122|0]=c>>>16;K[a+123|0]=c>>>24;K[a+124|0]=d;K[a+125|0]=d>>>8;K[a+126|0]=d>>>16;K[a+127|0]=d>>>24}if(f>>>0>P[a+36>>2]){M[a+36>>2]=f}M[a+208>>2]=M[a+208>>2]+1;pv(M[a+96>>2],f,M[b+4>>2])}b=M[b+16>>2];continue}break}Na=h+16|0;return e}function Yx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Na-48|0;Na=f;a:{if(!d){ab(M[b>>2]);M[b>>2]=0;M[b+4>>2]=0;e=0;break a}g=M[b+44>>2];if((g|0)<0){M[b+4>>2]=e;M[b>>2]=d;e=0;break a}k=M[b>>2];if(!k){ab(d);e=0;break a}i=M[b+4>>2];b:{if((c|0)>(g|0)){n=c-g|0;g=d;h=e;break b}n=g-c|0;g=k;h=i;k=d;i=e}j=N[a+239|0];M[f+40>>2]=0;M[f+44>>2]=0;M[f+32>>2]=0;M[f+36>>2]=0;M[f+24>>2]=0;M[f+28>>2]=0;M[f+20>>2]=k;M[f+16>>2]=g;M[f+8>>2]=0;a=g;c:{d:{if(!j){break d}a=h>>31;d=h+10|0;a=d>>>0<10?a+1|0:a;a=Bb(d,a);if(a){break d}e=7;break c}M[f+12>>2]=a;l=i+k|0;we(f+20|0,l,0,f+40|0);m=g+h|0;we(f+16|0,m,0,f+32|0);while(1){if(!(!M[f+20>>2]|!M[f+16>>2])){d=M[f+40>>2];e=M[f+32>>2];h=M[f+44>>2];i=M[f+36>>2];e=(d>>>0>e>>>0&(h|0)>=(i|0)|(h|0)>(i|0))-(d>>>0<e>>>0&(h|0)<=(i|0)|(h|0)<(i|0))|0;e=j?0-e|0:e;if(!e){e=M[f+8>>2];i=M[f+24>>2];p=M[f+28>>2];q=M[f+12>>2];o=f+12|0;Tl(o,j,f+24|0,f+8|0,d,h);if(!hi(o,n,0,1,f+20|0,f+16|0)){M[f+24>>2]=i;M[f+28>>2]=p;M[f+12>>2]=q;M[f+8>>2]=e}we(f+20|0,l,j,f+40|0);we(f+16|0,m,j,f+32|0);continue}if((e|0)<0){d=f+20|0;xe(0,d);we(d,l,j,f+40|0)}else{d=f+16|0;xe(0,d);we(d,m,j,f+32|0)}continue}break}h=M[f+12>>2]-a|0;e=0;if(!j){break c}ab(g);g=a}ab(k);M[b+4>>2]=h;M[b>>2]=g}if(M[b+44>>2]<(c|0)){M[b+44>>2]=c}Na=f+48|0;return e}function kh(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=Na+-64|0;Na=e;a:{if(!b){break a}c=M[b+4>>2];if(!(!(c&3)|M[b+36>>2]!=M[a+4>>2])){M[b+36>>2]=M[a+8>>2]}d=N[b|0];b:{c:{if((d|0)!=179){if(c&32|(d|0)!=168|M[b+28>>2]!=M[a+4>>2]){break c}d=M[a>>2];h=L[b+32>>1];c=M[(M[a+16>>2]+(h<<4)|0)+8>>2];if(ze(c)){gB(d,c);break b}g=M[d>>2];d:{if(!M[a+12>>2]){break d}e:{if(N[c|0]!=168){f=M[a+8>>2];break e}f=M[a+8>>2];if((f|0)==M[c+28>>2]){break d}}d=e+12|0;D(d,0,52);L[e+44>>1]=65437;M[e+40>>2]=f;M[e+24>>2]=c;K[e+12|0]=179;M[e+16>>2]=262144;c=d}c=qb(g,c,0);if(!N[g+87|0]){if(M[a+12>>2]){M[c+4>>2]=M[c+4>>2]|2097152}if(N[c|0]==171){d=vi(c);K[c|0]=156;M[c+8>>2]=d;M[c+4>>2]=M[c+4>>2]|2048}f=Fd(M[a>>2],c);d=Fd(M[a>>2],M[(M[a+20>>2]+(h<<4)|0)+8>>2]);f:{if((f|0)==(d|0)){f=N[c|0];if((f|0)==114|(f|0)==168){break f}}c=ui(M[a>>2],c,d?M[d>>2]:33696)}M[c+4>>2]=M[c+4>>2]&-513;a=M[b+4>>2]&3;if(a){oh(c,M[b+36>>2],a)}me(g,b);break a}kb(g,c);break b}if(M[b+28>>2]!=M[a+4>>2]){break c}M[b+28>>2]=M[a+8>>2]}i=b,j=kh(a,M[b+12>>2]),M[i+12>>2]=j;i=b,j=kh(a,M[b+16>>2]),M[i+16>>2]=j;c=M[b+20>>2];g:{if(N[b+5|0]&16){kn(a,c,1);break g}jh(a,c)}if(!(K[b+7|0]&1)){break b}c=M[b+44>>2];i=c,j=kh(a,M[c+40>>2]),M[i+40>>2]=j;jh(a,M[c+8>>2]);jh(a,M[c+12>>2])}c=b}Na=e- -64|0;return c}function AF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;e=Na-16|0;Na=e;a:{b:{switch(c|0){case 0:c=M[a+24>>2];if(!c){if(M[a+16>>2]==1){break a}d=rx(a);c=M[a+16>>2];if((d|0)==(c|0)){break a}c=c-d|0;a=d+M[a+44>>2]|0;if(N[a|0]==91){ig(a+1|0,e+8|0,c-1|0,1);ic(b,M[e+8>>2],M[e+12>>2]);break a}d=a+1|0;if(N[d|0]==34){vb(b,a+2|0,c-3|0,-1);break a}vb(b,d,c-1|0,-1);break a}if(N[a+20|0]==12){nm(a+168|0,M[a+8>>2],b,1);break a}a=(M[a+32>>2]+S(c,24)|0)-8|0;ic(b,M[a>>2],M[a+4>>2]);break a;case 1:c=Mj(a);nm(a+168|0,c,b,1);if((N[c+M[a+168>>2]|0]&15)>>>0<11){break a}a=M[b>>2];K[a+19|0]=74;L[a+16>>1]=O[a+16>>1]|2048;break a;case 2:vb(b,M[((N[Mj(a)+M[a+168>>2]|0]&15)<<2)+53536>>2],-1,0);break a;case 3:c=Mj(a);if((N[c+M[a+168>>2]|0]&15)>>>0>10){break a}nm(a+168|0,c,b,1);break a;case 4:ic(b,M[a+8>>2],0);break a;case 5:c=M[a+24>>2];if(!c|!N[a+21|0]){break a}ic(b,M[(M[a+32>>2]+S(c,24)|0)-24>>2],0);break a;case 6:d=M[a+60>>2];f=d;c=M[a+56>>2];g=c;if(M[a+24>>2]){tx(a);d=M[a+60>>2];c=M[a+56>>2]}kg(b,M[a+44>>2],c,d,-1);M[a+56>>2]=g;M[a+60>>2]=f;break a;case 7:c=rx(a);kg(b,M[a+44>>2],c,0,-1);break a;default:vb(b,M[a+44>>2],M[a+16>>2],0);break a;case 8:break b}}c=M[a+180>>2];if(!c){te(b,M[a+168>>2],M[a+172>>2],-1);break a}vb(b,c,-1,-1)}Na=e+16|0;return 0}function VF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Na-16|0;Na=f;j=M[c+28>>2]+S(S(M[c+4>>2],b),12)|0;d=M[c>>2];h=M[d>>2];a:{if(!(!N[a+34|0]|M[M[a+8>>2]>>2]==1)){b=0;while(1){if(M[h+24>>2]<=(b|0)){break a}a=S(b,12)+j|0;c=M[d+64>>2];M[a+8>>2]=c;M[a+4>>2]=c;b=b+1|0;continue}}if(!M[a+40>>2]){g=M[d+32>>2];l=M[d+36>>2];b=a;while(1){c=b;b=M[c+8>>2];if(N[c+34|0]|M[b>>2]==1?b:0){continue}break}i=N[c+32|0];b=M[c+24>>2];m=M[c+28>>2];e=Df(c,124,h);M[f+12>>2]=e;if(e){break a}Oj(d,c,f+12|0);while(1){e=M[f+12>>2];if(!(e|N[d+6|0])){while(1){if(!N[d+7|0]){wb(M[d+12>>2])}k=f+12|0;pd(d,c,k);e=N[c+32|0];M[d+88>>2]=1;K[d+7|0]=1;K[d+6|0]=e;n=M[c+28>>2];M[d+32>>2]=M[c+24>>2];M[d+36>>2]=n;if(!(M[c>>2]!=1|e)){if(iq(d,k)){continue}}break}if(M[f+12>>2]|N[d+6|0]){continue}xx(c,M[h+24>>2]);continue}break}M[d+32>>2]=g;M[d+36>>2]=l;K[d+6|0]=0;b:{if(i){K[c+32|0]=i;break b}Oj(d,c,f+12|0);while(1){pd(d,c,f+12|0);if(N[c+32|0]){M[f+12>>2]=267;e=267}else{e=M[f+12>>2]}if(M[c+24>>2]==(b|0)&(m|0)==M[c+28>>2]){break b}if(!e){continue}break}}if(e){break a}}e=0;c=0;while(1){if(M[h+24>>2]<=(c|0)){break a}b=S(c,12);g=b+4|0;i=g+j|0;d=g;g=M[a+40>>2];M[i>>2]=M[d+g>>2];b=b+8|0;M[b+j>>2]=M[b+g>>2];c=c+1|0;continue}}Na=f+16|0;return e|0}function lf(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{if(N[b+43|0]!=1){c=0;if(L[b+34>>1]>0){break a}}e=Na-48|0;Na=e;c=M[a>>2];b:{if(N[b+43|0]==1){M[c+56>>2]=M[c+56>>2]+1;c:{if(Gd(c,b)){break c}d=Sc(c+388|0,M[M[b+48>>2]>>2]);if(!d){M[e>>2]=M[M[b+48>>2]>>2];cb(a,8406,e);d=1;break c}M[e+44>>2]=0;d=tp(c,b,d,M[M[d>>2]+8>>2],e+44|0);b=M[e+44>>2];if(d){M[e+16>>2]=b;cb(a,8932,e+16|0);M[a+12>>2]=d}eb(c,b)}M[c+56>>2]=M[c+56>>2]-1;break b}if(L[b+34>>1]<0){M[e+32>>2]=M[b>>2];cb(a,15999,e+32|0);d=1;break b}g=le(c,M[b+44>>2],0);d:{if(!g){h=1;break d}j=N[a+224|0];K[a+224|0]=0;k=M[a+44>>2];l=M[a+112>>2];vk(a,M[g+32>>2]);i=b+34|0;L[i>>1]=65535;L[c+308>>1]=0;d=M[c+364>>2];M[c+364>>2]=0;h=1;M[c+304>>2]=M[c+304>>2]+1;f=Bn(a,g,64);M[c+364>>2]=d;M[a+112>>2]=l;M[a+44>>2]=k;e:{if(!f){L[i>>1]=0;break e}d=M[b+16>>2];if(d){Nm(a,d,i,b+4|0);h=0;if(M[a+40>>2]|M[M[g+28>>2]>>2]!=L[i>>1]){break e}xr(a,b,g,64);break e}L[b+34>>1]=O[f+34>>1];M[b+4>>2]=M[f+4>>2];M[b+28>>2]=M[b+28>>2]|M[f+28>>2]&98;h=0;M[f+4>>2]=0;L[f+34>>1]=0}L[b+36>>1]=O[b+34>>1];Id(c,f);pc(c,g);d=M[c+304>>2]-1|0;M[c+304>>2]=d;L[c+308>>1]=d?0:O[c+310>>1];K[a+224|0]=j}d=M[b+60>>2];L[d+78>>1]=O[d+78>>1]|2;if(N[c+87|0]){Vn(c,b)}d=M[a+40>>2]+h|0}Na=e+48|0;c=d}return c}function qm(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(N[a+8|0]==2){d=M[a+4>>2];M[d+4>>2]=M[a>>2];a:{if(!N[d+17|0]){break a}l=M[d>>2];cq(d);if(N[d+18|0]){break a}b:{e=M[d+48>>2];if((e|0)!=(Zd(d,e)|0)){i=M[d+36>>2];if(((P[16864]/(i>>>0)|0)+1|0)!=(e|0)){break b}}return db(74965)}g=mb(M[M[d+12>>2]+56>>2]+36|0);c=g;c:{h=M[a>>2];j=M[h+260>>2];if(!j){break c}c=M[h+20>>2];c=(c|0)>0?c:0;k=M[h+16>>2];while(1){d:{m=M[h+252>>2];if((c|0)!=(f|0)){if(M[((f<<4)+k|0)+4>>2]!=(a|0)){break d}c=f}a=Ra[j|0](m,M[(c<<4)+k>>2],e,g,i)|0;c=a>>>0<g>>>0?a:g;if(!c){break a}break c}f=f+1|0;continue}}a=Ox(d,e,c);if(a>>>0>e>>>0){return db(74992)}f=0;if(a>>>0<e>>>0){f=ng(d,0,0)}h=(c|0)==(g|0);while(1){if(!(a>>>0>=e>>>0|f)){f=Cx(d,a,e,h);e=e-1|0;continue}break}if(!(!g|(f|0)!=101&(f|0)!=0)){f=ac(M[M[d+12>>2]+72>>2]);if((c|0)==(g|0)){c=M[M[d+12>>2]+56>>2];K[c+32|0]=0;K[c+33|0]=0;K[c+34|0]=0;K[c+35|0]=0;c=M[M[d+12>>2]+56>>2];K[c+36|0]=0;K[c+37|0]=0;K[c+38|0]=0;K[c+39|0]=0}c=M[M[d+12>>2]+56>>2];e=a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24);K[c+28|0]=e;K[c+29|0]=e>>>8;K[c+30|0]=e>>>16;K[c+31|0]=e>>>24;M[d+48>>2]=a;K[d+19|0]=1}if(!f){break a}Tp(l);return f}a=M[d>>2];if(N[d+19|0]){M[a+28>>2]=M[d+48>>2]}a=Qq(a,b,0)}else{a=0}return a}function Bd(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if(!b){dc(a);return 0}m=M[a+20>>2];if(m){l=M[m+120>>2];i=l>>31}else{l=1e9;i=0}a:{b:{c:{if((d|0)<0){j=1;if((e|0)==1){break c}while(1){k=514;if(g>>>0>l>>>0&(h|0)>=(i|0)|(h|0)>(i|0)){break b}c=b+g|0;if(!(N[c+1|0]|N[c|0])){break b}g=g+2|0;h=g>>>0<2?h+1|0:h;continue}}k=e?2:16;j=e>>>0<=1?1:e;g=c;h=d;break a}g=yb(b);k=514;break a}j=e}if(g>>>0>l>>>0&(h|0)>=(i|0)|(h|0)>(i|0)){d:{if(f+1>>>0<2){break d}if((f|0)==5){ib(m,b);break d}Ra[f|0](b)}dc(a);Ap(M[a+20>>2],18);return 18}e:{f:{if((f|0)==-1){d=(d|0)<0;c=d?(j|0)==1?1:2:0;d=h;c=c+g|0;d=c>>>0<g>>>0?d+1|0:d;if(bi(a,(d|0)<=0&c>>>0<=32|(d|0)<0?32:c)){break e}if(!c){break f}G(M[a+8>>2],b,c);break f}gd(a);M[a+8>>2]=b;if((f|0)==5){M[a+32>>2]=b;n=a,o=uf(M[a+20>>2],b),M[n+24>>2]=o;break f}M[a+36>>2]=f;k=(f?4096:8192)|k}K[a+18|0]=j;L[a+16>>1]=k;b=g&2147483647;M[a+12>>2]=b;g:{if(j>>>0<2|b>>>0<2){break g}b=M[a+8>>2];c=N[b+1|0];b=N[b|0];if((b|0)!=255|(c|0)!=254){if((b|0)!=254|(c|0)!=255){break g}b=3}else{b=2}if(lg(a)){break e}d=M[a+12>>2]-2|0;M[a+12>>2]=d;if(d){c=M[a+8>>2];G(c,c+2|0,d)}K[M[a+8>>2]+M[a+12>>2]|0]=0;K[(M[a+8>>2]+M[a+12>>2]|0)+1|0]=0;K[a+18|0]=b;L[a+16>>1]=O[a+16>>1]|512}return 0}return 7}function ho(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=b+c|0;d=N[a+9|0];m=d+1|0;a:{h=M[a+56>>2];j=d+h|0;b:{if(!(N[j+2|0]|N[h+m|0])){i=m;d=c;break b}d=m;c:{while(1){i=d;k=d&65535;n=k+h|0;g=N[n|0];o=N[n+1|0];d=o|g<<8;if(d>>>0>=b>>>0){break c}if(d>>>0>k>>>0){continue}break}if(!(d&65535)){break c}return db(72724)}d=d&65535;p=M[M[a+52>>2]+40>>2];if(d>>>0>p-4>>>0){return db(72729)}d:{if(!(!d|d>>>0>e+3>>>0)){if(d>>>0<e>>>0){return db(72741)}g=d+h|0;f=d+(N[g+2|0]<<8|N[g+3|0])|0;if(p>>>0<f>>>0){return db(72744)}l=d-e|0;o=N[g+1|0];g=N[g|0];d=f-b|0;break d}f=e;d=c}e:{if(m>>>0>=k>>>0){break e}e=k+(N[n+3|0]|N[n+2|0]<<8)|0;if(e+3>>>0<b>>>0){break e}if(b>>>0<e>>>0){break a}d=f-i|0;l=(b-e|0)+l|0;b=i}e=N[j+7|0];if(e>>>0<(l&255)>>>0){return db(72763)}K[j+7|0]=e-l;e=f}f=b&65535;l=N[j+6|0]|N[j+5|0]<<8;f:{if(!(N[M[a+52>>2]+24|0]&12)){break f}k=d&65535;if(!k){break f}D(f+h|0,0,k)}g:{if(f>>>0<=l>>>0){if(f>>>0<l>>>0){return db(72777)}if((i&65535)!=(m|0)){return db(72778)}b=h+m|0;K[b+1|0]=o;K[b|0]=g;K[j+6|0]=e;K[j+5|0]=e>>>8;break g}i=(i&65535)+h|0;b=b<<8|(b&65280)>>>8;K[i|0]=b;K[i+1|0]=b>>>8;b=f+h|0;K[b+3|0]=d;K[b+2|0]=d>>>8;K[b+1|0]=o;K[b|0]=g}M[a+20>>2]=M[a+20>>2]+c;return 0}return db(72757)}function jm(a){var b=0,c=0,d=0,e=0;while(1){a:{b:{c:{d:{e:{f:{g:{h:{i:{d=a+c|0;b=N[d|0];if(b-9>>>0>=5){j:{switch(b-225|0){case 0:break g;case 1:break f;case 2:break e;default:break j}}if((b|0)==239){break d}if((b|0)==47){break i}if((b|0)==194){break h}if((b|0)!=32){break c}}c=c+1|0;continue}b=N[d+1|0];if((b|0)!=47){if(!N[d+2|0]|(b|0)!=42){break c}e=c+3|0;while(1){k:{d=a+e|0;b=N[d|0];l:{if((b|0)!=47){if(b){break l}break c}if(N[d-1|0]==42){break k}}e=e+1|0;continue}break}c=e+1|0;continue}c=c+2|0;while(1){b=a+c|0;e=N[b|0];m:{if((e|0)!=226){b=c;n:{switch(e-10|0){case 0:case 3:break a;case 1:case 2:break m;default:break n}}if(e){break m}break a}if(N[b+1|0]!=128){break m}b=c+2|0;e=N[b+a|0];if((e&254)==168){break a}}c=c+1|0;continue}}if(N[d+1|0]!=160){break c}c=c+2|0;continue}if(N[d+1|0]!=154|N[d+2|0]!=128){break c}break b}o:{switch(N[d+1|0]-128|0){case 0:b=N[d+2|0];if(b<<24>>24>=0){break c}if(b>>>0<139){break b}b=b-168|0;if(b>>>0>7){break c}if(1<<b&131){break b}break c;case 1:break o;default:break c}}if(N[d+2|0]==159){break b}break c}if(N[d+1|0]!=128){break c}if(N[d+2|0]==128){break b}break c}if(N[d+1|0]!=187){break c}if(N[d+2|0]==191){break b}}return c}c=c+3|0;continue}c=((e|0)!=0)+b|0;continue}}function ve(){var a=0,b=0,c=0,d=0,e=0,f=0;a:{b:{if(M[16918]){break b}M[16920]=1;if(!M[16921]){if(!M[16874]){mx()}M[18544]=8;if(!(!(!M[16912]|M[16913]<512)&M[16914]>0)){M[16912]=0;M[16913]=0}b=Ra[M[16879]](M[16881])|0;if(b){break a}}M[16921]=1;if(!M[16924]){M[16924]=8}c=M[16923]+1|0;M[16923]=c;if(!(M[16918]|M[16919])){M[16919]=1;D(74084,0,92);Aj(71072,5);Aj(71280,15);Aj(71888,10);Aj(72288,34);Aj(68272,70);c:{if(!M[16922]){a=M[16893];if(!a){Qw();a=M[16893]}a=Ra[a|0](M[16892])|0;if(a){break c}}a=1;M[16922]=1;b=tc(10);if(!b){a=7;break c}ab(b);b=0;while(1){if((b|0)!=4){Kw(S(b,88)+67104|0,!b);b=b+1|0;continue}break}e=68128,f=gx(19595),M[e>>2]=f;e=68132,f=gx(19602),M[e>>2]=f;d=Xl(0);if(!d){break c}b=M[d+4>>2];M[17043]=d;M[17039]=b>>>0<=12?12:b;a=Kw(68152,0);if(a){break c}if(M[18569]){a=M[16912];c=a?M[16914]:0;M[18579]=c;M[18573]=c;d=c?M[16913]&-8:0;M[18572]=d;M[18575]=a;M[18574]=(c|0)>90?10:((c|0)/10|0)+1|0;M[18580]=0;M[18578]=0;b=0;while(1){if(c){M[a>>2]=b;M[18578]=a;c=c-1|0;b=a;a=d+b|0;continue}break}M[18576]=a}a=0;M[16918]=1}M[16919]=0;c=M[16923]}M[16923]=c-1;if((c|0)>1){break b}M[16924]=0}return a}M[18550]=0;M[18551]=0;M[18548]=0;M[18549]=0;M[18546]=0;M[18547]=0;M[18544]=0;M[18545]=0;return b}function Xx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Na-16|0;Na=e;h=M[a>>2];d=0;a:{if(!b){break a}d=0;if(N[a+52|0]!=N[h+239|0]){break a}a=M[c+64>>2];d=0;if((a|0)>4){break a}d=(a|0)>0}i=c+72|0;b=0;a=0;b:{c:{while(1){if(!d){break c}if(M[c+64>>2]>(a|0)){d=S(a,24)+i|0;f=M[d+20>>2];d:{if(M[d+12>>2]){b=f?1:b;d=0;break d}d=1;if(!f){break d}b=1;d=M[f+44>>2]!=0}a=a+1|0;continue}break}if(!b){break c}a=M[c+68>>2];m=(a|0)>=M[h+24>>2]?-1:a;f=0;n=1;b=0;while(1){if(M[c+64>>2]<=(f|0)|b){break b}a=S(f,24)+i|0;d=M[a+20>>2];e:{if(d){j=N[h+239|0];g=M[d+4>>2];k=M[a>>2];l=M[a+4>>2];b=Qy(h,d,k,l);if(b){break e}j=j?108:109;a=0;b=(g|0)>0?g:0;f:{while(1){if((a|0)==(b|0)){break f}g:{g=M[M[d>>2]+(a<<2)>>2];if(!M[g+40>>2]){break g}if(Ky(g,k,l)){break g}a=a+1|0;continue}break}b=a}M[d+8>>2]=b;a=0;while(1){h:{g=M[d>>2];if((a|0)>=(b|0)){break h}b=Hy(h,M[g+(a<<2)>>2]);if(b){break e}a=a+1|0;b=M[d+8>>2];continue}break}ki(g,a,a,j);M[d+32>>2]=m}b=0}f=f+1|0;continue}}b=0;a=0;while(1){if(M[c+64>>2]<=(a|0)|b){break b}b=S(a,24)+i|0;i:{if(!M[b+20>>2]){b=0;break i}M[e+12>>2]=0;M[e+8>>2]=0;b=Zx(h,b,M[c+68>>2],e+12|0,e+8|0);if(b){break i}b=Yx(h,c,a,M[e+8>>2],M[e+12>>2])}a=a+1|0;continue}}M[c+40>>2]=n;Na=e+16|0;return b}function $h(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;a:{switch(b|0){case 10:M[c+12>>2]=0;L[c+16>>1]=1025;M[c>>2]=0;return;case 0:case 11:L[c+16>>1]=1;return;case 1:a=K[a|0];b=a>>31;L[c+16>>1]=4;M[c>>2]=a;M[c+4>>2]=b;return;case 2:b=N[a+1|0];a=K[a|0];L[c+16>>1]=4;a=b|a<<8;M[c>>2]=a;M[c+4>>2]=a>>31;return;case 3:b=N[a+2|0];e=N[a+1|0];a=K[a|0];L[c+16>>1]=4;a=b|(e<<8|a<<16);M[c>>2]=a;M[c+4>>2]=a>>31;return;case 4:a=N[a|0]|N[a+1|0]<<8|(N[a+2|0]<<16|N[a+3|0]<<24);L[c+16>>1]=4;a=a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24);M[c>>2]=a;M[c+4>>2]=a>>31;return;case 5:h=N[a+1|0];i=K[a|0];d=N[a+5|0];b=N[a+4|0];f=N[a+3|0];e=N[a+2|0];L[c+16>>1]=4;g=d;d=f;a=d>>>16|0;f=d<<16;d=a;a=e;e=a>>>8|0;f=a<<24|f;a=b>>>24|0;M[c>>2]=g|(f|b<<8);M[c+4>>2]=a|(e|d)|(h|i<<8);return;case 6:case 7:d=N[a+5|0];e=d>>>16|0;h=d<<16;f=e;d=N[a+4|0];e=d>>>8|0;h=d<<24|h;i=e|f;d=N[a+1|0];e=d>>>16|0;g=d<<16;d=N[a|0];g=d<<24|g;d=N[a+2|0];d=N[a+3|0]|d<<8;e=d|g;d=h|N[a+7|0];f=e|i;e=N[a+6|0];a=e>>>24|0;e=e<<8|d;a=a|f;L[c+16>>1]=(b|0)==6?4:(g&2146435072)!=2146435072?8:e|a&1048575?1:8;M[c>>2]=e;M[c+4>>2]=a;return;case 8:case 9:L[c+16>>1]=4;M[c>>2]=b-8;M[c+4>>2]=0;return;default:break a}}M[c+8>>2]=a;M[c+12>>2]=b-12>>>1;L[c+16>>1]=O[((b&1)<<1)+34688>>1]}function xn(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=Na-16|0;Na=l;g=M[b+12>>2];i=M[a+44>>2];M[a+44>>2]=i+2;d=M[b>>2];f=M[a>>2];e=M[f+16>>2];j=Mb(f,M[b+24>>2]);a:{if(gc(a,27,d,0,M[e+(j<<4)>>2])){break a}Dd(a,j,M[g+20>>2],1,M[g>>2]);d=Cb(a);if(!d){break a}f=(c|0)<0?M[b+44>>2]:c;k=tk(a,b);h=M[a+44>>2];M[a+44>>2]=h+1;e=O[b+50>>1];if(k){M[k>>2]=M[k>>2]+1}nb(d,119,h,0,e,k,-8);Pd(a,i,j,g,102);e=$a(d,36,i,0);g=Gb(a);m=M[a+132>>2];K[(m?m:a)+20|0]=1;Xm(a,b,i,g,0,l+12|0,0,0);$a(d,139,h,g);Ir(a,M[l+12>>2]);$a(d,39,i,e+1|0);m=M[d+108>>2];M[(N[M[d>>2]+87|0]?74356:M[d+104>>2]+S(e,20)|0)+8>>2]=m;if((c|0)<0){$a(d,145,f,j)}e=i+1|0;nb(d,113,e,f,j,k,-8);f=M[d+108>>2];if((f|0)>0){L[(M[d+104>>2]+S(f,20)|0)-18>>1]=(c|0)>=0?17:1}k=$a(d,34,h,0);b:{if(N[b+54|0]){c=Xb(d,1);f=M[d+108>>2];lb(d,132,h,c,g,O[b+50>>1]);pr(a,2,b);j=M[d+108>>2];M[(N[M[d>>2]+87|0]?74356:M[d+104>>2]+S(c,20)|0)+8>>2]=j;break b}c=M[a+132>>2];K[(c?c:a)+21|0]=1;f=M[d+108>>2]}bb(d,133,h,g,e);if(!(N[b+56|0]&4)){fb(d,137,e)}$a(d,138,e,g);b=M[d+108>>2];if((b|0)>0){L[(M[d+104>>2]+S(b,20)|0)-18>>1]=16}zb(a,g);$a(d,37,h,f);b=M[d+108>>2];M[(N[M[d>>2]+87|0]?74356:M[d+104>>2]+S(k,20)|0)+8>>2]=b;fb(d,122,i);fb(d,122,e);fb(d,122,h)}Na=l+16|0}function XJ(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{e=b;if(e){if(!c){break j}if(!d){break i}e=V(d)-V(e)|0;if(e>>>0<=31){break h}break b}if((d|0)==1|d>>>0>1){break b}b=(a>>>0)/(c>>>0)|0;Oa=a-S(b,c)|0;Pa=0;Qa=0;return b}if(!a){break g}if(!d){break f}f=d-1|0;if(f&d){break f}Oa=a;Pa=e&f;a=e>>>YJ(d)|0;Qa=0;return a}f=c-1|0;if(!(f&c)){break e}k=(V(c)+33|0)-V(e)|0;g=0-k|0;break c}k=e+1|0;g=63-e|0;break c}Oa=0;a=(e>>>0)/(d>>>0)|0;Pa=e-S(a,d)|0;Qa=0;return a}e=V(d)-V(e)|0;if(e>>>0<31){break d}break b}Oa=a&f;Pa=0;if((c|0)==1){break a}c=YJ(c);d=c&31;if((c&63)>>>0>=32){e=0;a=b>>>d|0}else{e=b>>>d|0;a=((1<<d)-1&b)<<32-d|a>>>d}Qa=e;return a}k=e+1|0;g=63-e|0}f=a;e=k&63;h=e&31;if((e&63)>>>0>=32){e=0;f=b>>>h|0}else{e=b>>>h|0;f=((1<<h)-1&b)<<32-h|f>>>h}h=g&63;g=a;i=h&31;if((h&63)>>>0>=32){j=a<<i;a=0}else{j=(1<<i)-1&g>>>32-i|b<<i;a=g<<i}b=j;if(k){g=d-1|0;l=c-1|0;g=(l|0)!=-1?g+1|0:g;h=l;while(1){e=e<<1|f>>>31;f=f<<1|b>>>31;l=e;i=g-(e+(f>>>0>h>>>0)|0)|0;m=i>>31;j=m;e=f;i=c&j;f=e-i|0;e=l-((d&j)+(e>>>0<i>>>0)|0)|0;j=b<<1|a>>>31;a=n|a<<1;b=j|o;l=m&1;n=l;k=k-1|0;if(k){continue}break}}Oa=f;Pa=e;j=b<<1|a>>>31;a=l|a<<1;Qa=j|o;return a}Oa=a;Pa=b;a=0;b=0}Qa=b;return a}function fJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;a:{d=M[c>>2];e=O[d+16>>1];f=e&31;if((e&63)>>>0>=32){e=1<<f;g=0}else{g=1<<f;e=g-1&1>>>32-f}if(g&-1431655766|e&-1431655766){break a}j=gb(d);if(!j){break a}e=Fb(M[c>>2]);b:{c:{if((b|0)==1){k=52684;g=52688;h=1;break c}f=gb(M[c+4>>2]);if(!f){break a}c=f;while(1){g=N[c|0];if(g){d=c+1|0;c=d;if(g>>>0>=192){while(1){c=d;d=c+1|0;if(K[c|0]<-64){continue}break}}h=h+1|0;continue}break}if(!h){break b}g=hh(a,h<<3,h>>>29|0);if(!g){break a}k=(h<<2)+g|0;h=0;while(1){if(N[f|0]){i=h<<2;M[i+g>>2]=f;d=f+1|0;c=d;if(N[f|0]>=192){while(1){c=d;d=c+1|0;if(K[c|0]<-64){continue}break}}M[i+k>>2]=c-f;h=h+1|0;f=c;continue}break}if(!h){break b}}f=M[M[a+4>>2]+8>>2];d:{if(!(f&1)|!e){break d}while(1){c=0;d=0;while(1){e:{if((c|0)==(h|0)){break e}i=c<<2;d=M[i+k>>2];if(e>>>0>=d>>>0){if(!Qb(j,M[g+i>>2],d)){break e}}c=c+1|0;continue}break}if(c>>>0>=h>>>0){break d}j=d+j|0;e=e-d|0;if(e){continue}break}e=0}f:{if(!(f&2)|!e){break f}while(1){f=e;c=0;while(1){if((c|0)==(h|0)){e=f;break f}g:{i=c<<2;d=M[i+k>>2];if(d>>>0<=f>>>0){e=f-d|0;if(!Qb(j+e|0,M[g+i>>2],d)){break g}}c=c+1|0;continue}break}if(e){continue}break}e=0}if((b|0)==1){break b}ab(g)}vb(a,j,e,-1)}}function av(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;g=Na-16|0;Na=g;j=bm(a);M[a+80>>2]=j;i=Qa;M[a+84>>2]=i;h=101;k=M[a+156>>2];l=k+j|0;k=k>>>0>l>>>0?i+1|0:i;a:{if(c>>>0<l>>>0&(d|0)<=(k|0)|(d|0)<(k|0)){break a}if(!(!b&(M[a+88>>2]==(j|0)&M[a+92>>2]==(i|0)))){b=M[a+68>>2];h=Ra[M[M[b>>2]+8>>2]](b,g+8|0,8,j,i)|0;if(h){break a}h=101;if((N[g+8|0]|N[g+9|0]<<8|(N[g+10|0]<<16|N[g+11|0]<<24))!=-117058087|(N[g+12|0]|N[g+13|0]<<8|(N[g+14|0]<<16|N[g+15|0]<<24))!=-681336544){break a}}c=M[a+68>>2];b=i;d=j+8|0;b=d>>>0<8?b+1|0:b;h=sf(c,d,b,e);if(h){break a}c=M[a+68>>2];b=i;d=j+12|0;b=d>>>0<12?b+1|0:b;h=sf(c,d,b,a+52|0);if(h){break a}b=M[a+68>>2];c=j+16|0;k=c>>>0<16?i+1|0:i;h=sf(b,c,k,f);if(h){break a}b=M[a+84>>2];d=b;c=M[a+80>>2];b:{if(b|c){b=M[a+156>>2];h=0;break b}c=M[a+68>>2];b=i;d=j+20|0;b=d>>>0<20?b+1|0:b;h=sf(c,d,b,g);if(h){break a}b=M[a+68>>2];c=j+24|0;i=c>>>0<24?i+1|0:i;h=sf(b,c,i,g+4|0);if(h){break a}e=M[g+4>>2];if(!e){e=M[a+168>>2];M[g+4>>2]=e}h=101;if(e-65537>>>0<4294902271){break a}b=M[g>>2];if(e+131071&e|b-65537>>>0<4294901791|b+131071&b){break a}h=Xh(a,g+4|0,-1);M[a+156>>2]=b;c=M[a+80>>2];d=M[a+84>>2]}e=b;b=b+c|0;k=e>>>0>b>>>0?d+1|0:d;M[a+80>>2]=b;M[a+84>>2]=k}Na=g+16|0;return h}function ke(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Na-16|0;Na=g;M[g+8>>2]=0;a:{if(!jB(a)){b=_c(137269);break a}Yc(a,0);b=b?b:30808;b:{c:{while(1){if(!(!N[b|0]|h)){h=th(a,b,-1,g+8|0,g+12|0);if(h){continue}i=0;b=0;j=0;k=0;f=M[g+8>>2];if(!f){h=0;b=M[g+12>>2];continue}while(1){d:{h=Db(f);e:{if(!c){break e}f:{g:{h:{if((h|0)!=100){if((h|0)!=101|b){break d}if(K[a+33|0]&1){break h}break d}if(b){break g}}b=0;j=0;j=f?O[f+144>>1]:j;i=md(a,j<<3|4,0);if(!i){break c}while(1){if((b|0)!=(j|0)){m=(b<<2)+i|0,n=Mm(f,b),M[m>>2]=n;b=b+1|0;continue}break}if((h|0)!=100){break f}}b=0;k=(j<<2)+i|0;while(1){if((b|0)!=(j|0)){l=ff(f,b);M[(b<<2)+k>>2]=l;i:{if(l){break i}if((lh(f,b)|0)==5){break i}Lb(a);h=100;b=i;break c}b=b+1|0;continue}break}M[(j<<2)+k>>2]=0}b=1;l=Ra[c|0](d,j,k,i)|0;f=M[g+8>>2];if(!l){break e}Mf(f);M[g+8>>2]=0;h=4;Yc(a,4);break b}if((h|0)==100){continue}}break}h=Mf(f);M[g+8>>2]=0;f=M[g+12>>2];while(1){b=f;f=b+1|0;if(K[N[b|0]+31408|0]&1){continue}break}eb(a,i);continue}break}b=0;f=M[g+8>>2]}if(f){Mf(f)}i=b}eb(a,i);b=qd(a,h);if(!(!e|!b)){c=_b(0,yg(a));M[e>>2]=c;if(c){break a}b=7;Yc(a,7);break a}if(!e){break a}M[e>>2]=0}Na=g+16|0;return b|0}function ig(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;a:{if((d|0)==1){g=1;d=a;break a}e=3-d|0;c=c&-2;while(1){if(!(N[a+e|0]|(c|0)<=(e|0))){e=e+2|0;continue}break}k=(c|0)>(e|0);c=e^1;g=2;d=(d&1)+a|0}a=a+c|0;b:{while(1){j=1;if(a>>>0<=d>>>0){break b}c=N[d|0];if(K[c+31408|0]&1){d=d+g|0;continue}break}c:{switch(c-43|0){case 2:d=d+g|0;j=0;break b;case 0:break c;default:break b}}d=d+g|0}e=d;while(1){if(N[e|0]==48&a>>>0>e>>>0){e=e+g|0;continue}else{c=0;while(1){d:{f=c+e|0;l=f>>>0>=a>>>0;if(l){break d}f=N[f|0];if((f-48&255)>>>0>9){break d}c=c+g|0;i=ZJ(h,i,10,0);h=f&255;i=i+h|0;f=Qa;f=h>>>0>i>>>0?f+1|0:f;h=i-48|0;i=f-(i>>>0<48)|0;continue}break}f=j?i:0-(((h|0)!=0)+i|0)|0;m=j?h:0-h|0;h=(i|0)<0;M[b>>2]=h?j?-1:0:m;M[b+4>>2]=h?j?2147483647:-2147483648:f;e:{if(!((d|0)!=(e|0)|c)){k=-1;break e}if(k|l){break e}d=c;while(1){k=1;if(!(K[N[d+e|0]+31408|0]&1)){break e}d=d+g|0;if(a>>>0>e+d>>>0){continue}break}k=0}d=S(g,19);f:{if(d>>>0>c>>>0){break f}a=1;if(c>>>0<=d>>>0){d=0;a=0;while(1){if(!(d>>>0>17|a)){a=S(K[S(d,g)+e|0]-K[d+24532|0]|0,10);d=d+1|0;continue}break}a=a?a:K[S(g,18)+e|0]-56|0;if((a|0)<0){break f}}M[b>>2]=j?-1:0;M[b+4>>2]=j?2147483647:-2147483648;k=a?2:j?3:k}}break}return k}function bo(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;j=Na-16|0;Na=j;d=M[a>>2];h=M[a+4>>2];e=M[a+44>>2];a:{b:{if(e){M[c>>2]=d+e;f=(b>>31)+h|0;c=b;b=b+d|0;f=c>>>0>b>>>0?f+1|0:f;M[a>>2]=b;M[a+4>>2]=f;break b}f=M[a+40>>2];g=f>>31;e=$J(d,h,f,g);if(!(e|Qa)){i=M[a+8>>2];k=i-d|0;l=f;m=f>>>0>k>>>0;f=M[a+12>>2]-(h+(d>>>0>i>>>0)|0)|0;f=m&(f|0)<=(g|0)|(f|0)<(g|0)?k:l;g=M[a+24>>2];d=Ra[M[M[g>>2]+8>>2]](g,M[a+36>>2],f,d,h)|0;if(d){break a}f=M[a+40>>2]}h=e;g=f-e|0;if((g|0)>=(b|0)){M[c>>2]=e+M[a+36>>2];c=M[a+4>>2]+(b>>31)|0;f=b;b=b+M[a>>2]|0;c=f>>>0>b>>>0?c+1|0:c;M[a>>2]=b;M[a+4>>2]=c;break b}e=M[a+16>>2];c:{if((e|0)>=(b|0)){d=M[a+28>>2];break c}f=e>>31<<1|e>>>31;d=(e|0)<64;e=d?128:e<<1;d=d?0:f;k=b>>31;while(1){i=d;f=e;d=d<<1|e>>>31;e=e<<1;if((i|0)<=(k|0)&b>>>0>f>>>0|(i|0)<(k|0)){continue}break}d=Ud(M[a+28>>2],f,i);if(!d){d=7;break a}M[a+28>>2]=d;M[a+16>>2]=f}if(g){G(d,h+M[a+36>>2]|0,g)}e=M[a+4>>2]+(g>>31)|0;d=g+M[a>>2]|0;e=d>>>0<g>>>0?e+1|0:e;M[a>>2]=d;M[a+4>>2]=e;e=b-g|0;while(1){if((e|0)>0){M[j+12>>2]=0;d=M[a+40>>2];f=(d|0)>(e|0)?e:d;d=bo(a,f,j+12|0);if(d){break a}if(f){G(M[a+28>>2]+(b-e|0)|0,M[j+12>>2],f)}e=e-f|0;continue}break}M[c>>2]=M[a+28>>2]}d=0}Na=j+16|0;return d}function Cc(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{if(N[a+40|0]){break a}b:{c:{d:{if(!N[a+41|0]){c=2e3;b=1;d=1;break d}c=M[a+8>>2];if(c-1e4>>>0<4294952583){break c}b=M[a+16>>2];d=M[a+12>>2]}i=N[a+44|0];if(!(i&1)){break b}}D(a,0,48);K[a+44|0]=2;return}K[a+40|0]=1;f=(d|0)<3;g=c-f|0;c=g+4800&65535;e=(+(((((((S(f?d+12|0:d,306001)+306001|0)/1e4|0)+b|0)+((S(g,36525)+172251900>>>0)/100|0)|0)-((c>>>0)/100|0)|0)+((c>>>0)/400|0)|0)+38|0)+-1524.5)*864e5;if(U(e)<0x8000000000000000){d=~~e>>>0;if(U(e)>=1){b=~~(e>0?W(Y(e*2.3283064365386963e-10),4294967295):Z((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}}else{d=0;b=-2147483648}c=b;M[a>>2]=d;M[a+4>>2]=c;if(!N[a+42|0]){break a}b=S(M[a+24>>2],6e4)+S(M[a+20>>2],36e5)|0;g=b;f=b>>31;e=R[a+32>>3]*1e3+.5;if(U(e)<0x8000000000000000){b=~~e>>>0;if(U(e)>=1){h=~~(e>0?W(Y(e*2.3283064365386963e-10),4294967295):Z((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{h=0}}else{b=0;h=-2147483648}c=h+c|0;b=b+d|0;d=(b>>>0<d>>>0?c+1|0:c)+f|0;c=b+g|0;d=c>>>0<b>>>0?d+1|0:d;M[a>>2]=c;M[a+4>>2]=d;b=M[a+28>>2];if(!b){break a}K[a+41|0]=0;K[a+42|0]=0;M[a+28>>2]=0;K[a+44|0]=i&230|8;b=S(b,6e4);M[a>>2]=c-b;M[a+4>>2]=d-((b>>31)+(c>>>0<b>>>0)|0)}}function co(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=Na+-64|0;Na=d;M[d+8>>2]=0;M[d+12>>2]=0;f=M[a+4>>2];b=M[a+12>>2];a:{if((f|0)>=(b|0)&P[a>>2]>=P[a+8>>2]|(b|0)<(f|0)){b:{c=M[a+48>>2];c:{if(c){o=M[c+4>>2];b=M[c+12>>2];p=b;l=M[c+8>>2];zt(M[c+48>>2],d+24|0,M[M[M[c>>2]+12>>2]+12>>2],l,b);f=c+48|0;while(1){d:{if(e){break d}m=M[o+12>>2]+S(M[M[o+8>>2]+4>>2],56)|0;if(!M[m+24>>2]){break d}b=M[d+40>>2];k=b;g=b>>31;j=M[m+20>>2];b=M[d+48>>2];i=j+b|0;n=j>>31;h=n+M[d+52>>2]|0;h=(b>>>0>i>>>0?h+1|0:h)+g|0;b=i+k|0;h=b>>>0<i>>>0?h+1|0:h;k=b;b=Bh(j,n);g=b;k=k+b|0;b=(b>>31)+h|0;b=g>>>0>k>>>0?b+1|0:b;g=M[c+16>>2];h=g+l|0;i=(g>>31)+p|0;i=h>>>0<g>>>0?i+1|0:i;if(h>>>0<k>>>0&(i|0)<=(b|0)|(b|0)>(i|0)){break d}b=d+24|0;fo(b,j,n);eo(b,M[m+32>>2],j);e=au(M[c+4>>2],d+20|0);continue}break}l=yt(d+24|0,c+56|0);j=M[f+12>>2];g=M[f+8>>2];M[c+40>>2]=g;M[c+44>>2]=j;b=M[f+4>>2];M[c+32>>2]=M[f>>2];M[c+36>>2]=b;e=e?e:l;b=M[c+8>>2];f=M[c+12>>2];if((b|0)==(g|0)&(f|0)==(j|0)){M[c+20>>2]=1}if(e){break c}if(!M[c+20>>2]){break b}}e=0}Hu(a);break a}e=wt(M[c>>2],a,c+32|0,b,f);if(e){break a}}e=vt(a,d+8|0);if(e){break a}b=M[d+8>>2];M[a+20>>2]=b;e=bo(a,b,a+32|0)}Na=d- -64|0;return e}function zr(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;i=Na-16|0;Na=i;a:{if(d){l=134217728;f=-1;e=M[d>>2];break a}b:{if(c){f=-1;e=_A(b);break b}e=56;if(N[b+5|0]&8){break b}g=M[b+8>>2];if(!g){break b}e=yb(g)&1073741823;f=e+1|0;e=e+60&2147483640}e=Ob(a,e,e>>31)}M[i+12>>2]=e;c:{if(!e){break c}j=ZA(b,c);d:{if((f|0)>=0){break d}f=0;if(N[b+5|0]&8){break d}g=M[b+8>>2];if(!g){break d}f=jb(g)+1|0}e:{if(c){g=j&4095;if(!g){break e}G(e,b,g);break e}g=52;h=M[b+4>>2];h=h&65536?12:h&16384?28:52;if(h){G(e,b,h)}if(h>>>0>51){break e}k=52-h|0;if(!k){break e}D(e+h|0,0,k)}h=M[e+4>>2]&-134299649|(j&81920|l);M[e+4>>2]=h;if(f){h=e+g|0;M[e+8>>2]=h;if(f){G(h,M[b+8>>2],f)}h=M[e+4>>2];g=f+g|0}M[i+12>>2]=(g+7&-8)+e;g=M[b+4>>2];if((g|h)&8454144){break c}f=M[b+20>>2];f:{if(g&4096){f=le(a,f,c);break f}f=xc(a,f,N[b|0]!=146?c:0)}M[e+20>>2]=f;if(K[b+7|0]&1){m=e,n=bB(a,e,M[b+44>>2]),M[m+44>>2]=n}f=M[b+12>>2];g=N[b|0];g:{if(c){h:{if((g|0)==178){break h}if(!f){f=0;break h}f=zr(a,f,1,i+12|0)}M[e+12>>2]=f;b=M[b+16>>2];c=0;if(!b){break g}c=zr(a,b,1,i+12|0);break g}c=e;if((g|0)!=178){f=qb(a,f,0)}M[c+12>>2]=f;c=qb(a,M[b+16>>2],0)}M[e+16>>2]=c}if(d){M[d>>2]=M[i+12>>2]}Na=i+16|0;return e}function Sq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;l=Na-32|0;Na=l;s=jb(d);k=jb(c);f=k;n=M[M[a>>2]+20>>2];a:{b:{c:{d:{e:{if(d){M[l+16>>2]=d;p=tb(n,30759,l+16|0);if(p){break e}g=7;break a}h=f>>>31|0;f=f<<1|1;i=ub(n,ZJ(f,h,3,0),Qa);if(i){break d}g=7;break b}h=M[b+4>>2];q=jb(p)-1|0;g=q;g=ZJ(h,h>>31,g,g>>31);h=g+f|0;f=Qa;f=g>>>0>h>>>0?f+1|0:f;h=h+1|0;f=h?f:f+1|0;i=ub(n,h,f);m=0;if(i){break c}g=7;break b}t=((k<<2)+i|0)+2|0;m=f+i|0}if(k){G(i,c,k)}u=k<<1;f:while(1){g:{g=M[b>>2];f=g;if(!f){break g}while(1){f=M[f+12>>2];if(f){g=P[f+4>>2]>P[g+4>>2]?f:g;continue}else{f=b;while(1){h=f;j=M[f>>2];f=j+12|0;if((g|0)!=(j|0)){continue}break}M[h>>2]=M[g+12>>2];j=M[g+4>>2];h:{if(d){if(!(!(N[N[j|0]+31408|0]&70)|e)){f=s;h=d;break h}f=(N[M[g+8>>2]+j|0]==34)+q|0;h=p;break h}f=M[g+8>>2];if(f){G(m,j,f)}K[M[g+8>>2]+m|0]=0;zf(m);f=N[M[g+4>>2]+M[g+8>>2]|0];M[l>>2]=m;M[l+4>>2]=(f|0)==39?30777:30808;h=vd(u,t,6165,l);f=jb(h);j=M[g+4>>2]}j=j-c|0;o=M[g+8>>2];if((o|0)!=(f|0)){o=j+o|0;r=k-o|0;if(r){G((j+i|0)+f|0,i+o|0,r)}k=(f-M[g+8>>2]|0)+k|0;K[k+i|0]=0}if(f){G(j+i|0,h,f)}eb(n,g);continue f}}}break}vb(a,i,-1,-1);ib(n,i);g=0}ab(p)}Na=l+32|0;return g}function iu(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;f=Na-16|0;Na=f;e=M[a+8>>2];b=M[a>>2];M[b+24>>2]=M[b+24>>2]|64;d=0;a:{if(!c){break a}d=1;M[a+20>>2]=M[a+20>>2]+1;if(N[b+87|0]){yh(a,c,0);break a}b:{h=M[c+12>>2];if(!h){break b}d=M[c+16>>2];c:{if(d){g=N[d|0];if(!((g&223)!=67|(N[d+1|0]&223)!=82)){g=N[b+176|0];K[b+176|0]=e;d:{e:{if(Nt(h,b+172|0)){d=M[a+24>>2];if(d>>>0>=P[b+172>>2]|!d){break d}if(N[67473]){break e}break d}if(!N[67473]){break d}}yh(a,c,14654)}M[b+180>>2]=c;K[b+178|0]=N[b+178|0]&254;d=0;M[f+12>>2]=0;nw(b,M[c+16>>2],-1,0,0,f+12|0,0);K[b+176|0]=g;e=M[b+64>>2];f:{if(!e|K[b+178|0]&1){break f}if((e|0)>M[a+12>>2]){M[a+12>>2]=e}g:{switch(e-7|0){case 0:Lb(b);break f;case 2:break f;default:break g}}if((e&255)==6){break f}yh(a,c,yg(b))}M[b+180>>2]=68240;cd(M[f+12>>2]);break a}d=M[c+4>>2];if(g|!d){break b}break c}d=M[c+4>>2];if(!d){break b}}b=nf(b,d,M[M[b+16>>2]+(e<<4)>>2]);h:{if(!b){yh(a,c,1574);break h}i:{j:{if(!Nt(M[c+12>>2],b+44|0)){break j}d=M[b+44>>2];if(d>>>0<2|d>>>0>P[a+24>>2]){break j}d=0;if(!Lt(b)){break a}if(N[67473]){break i}break a}d=0;if(!N[67473]){break a}}yh(a,c,14654)}d=0;break a}d=0;yh(a,c,0)}Na=f+16|0;return d|0}function CF(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Na-16|0;Na=f;e=a+168|0;a:{b:{if(N[a+21|0]){c=Mj(a);b=N[c+M[a+168>>2]|0];g=jc(e,c,f+12|0);c:{h=(b&15)-13>>>0<4294967294;d:{if(!h){b=M[a+24>>2];d=M[a+28>>2];e:{if(b>>>0<d>>>0){d=M[a+32>>2];break e}b=(d<<1)+3|0;d=ld(M[a+36>>2],M[a+32>>2],ZJ(b,0,24,0),Qa);if(!d){break c}M[a+32>>2]=d;M[a+28>>2]=b;b=M[a+24>>2]}i=M[a+8>>2];d=S(b,24)+d|0;M[d+4>>2]=c;M[d>>2]=i;i=M[f+12>>2];M[d+16>>2]=-1;M[d+20>>2]=-1;c=c+g|0;M[d+8>>2]=i+c;M[d+12>>2]=M[a+56>>2];d=0;if(!(!b|!N[a+20|0])){tx(a);d=N[a+65|0]?7:0;b=M[a+24>>2]}M[a+8>>2]=c;b=b+1|0;M[a+24>>2]=b;break d}c=M[f+12>>2]+(c+g|0)|0;M[a+8>>2]=c;b=M[a+24>>2]}f:{g:{while(1){if(b){g=M[a+32>>2]+S(b,24)|0;if(P[g-16>>2]>c>>>0){break g}b=b-1|0;M[a+24>>2]=b;M[a+56>>2]=M[g-12>>2];M[a+60>>2]=0;h=0;continue}break}c=0;if(!h){break f}break b}if(h){break b}c=N[M[e>>2]+M[g-20>>2]|0]&15}K[a+20|0]=c;break b}d=7;break a}b=Mj(a);j=a,k=(jc(e,b,f+8|0)+b|0)+M[f+8>>2]|0,M[j+8>>2]=k}h:{if(N[a+20|0]!=11){break h}b=M[a+24>>2];if(!b){break h}b=(M[a+32>>2]+S(b,24)|0)-8|0;c=b;e=M[b>>2];b=M[b+4>>2];e=e+1|0;b=e?b:b+1|0;M[c>>2]=e;M[c+4>>2]=b}M[a+4>>2]=M[a+4>>2]+1}Na=f+16|0;return d|0}function XC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;if(!b){return db(62853)|0}e=M[a+228>>2];e=Ra[M[16898]](M[e+52>>2],b,N[e+41|0]&3)|0;a:{if(!e){g=7;f=M[a+228>>2];if(N[f+41|0]==2){break a}b:{if((Ra[M[16897]](M[f+52>>2])|0)<=M[f+28>>2]){break b}e=f+8|0;c:{d:{while(1){e=M[e>>2];if(e){if(!(M[e+32>>2]|M[e+36>>2]|N[e+28|0]&8)){break d}e=e+44|0;continue}break}M[f+8>>2]=0;e=f+4|0;while(1){e=M[e>>2];if(!e){break b}if(!(M[e+32>>2]|M[e+36>>2])){break c}e=e+44|0;continue}}M[f+8>>2]=e}g=Ra[M[f+44>>2]](M[f+48>>2],e)|0;if((g|0)==5){break b}if(g){break a}}g=7;e=Ra[M[16898]](M[f+52>>2],b,2)|0;if(!e){break a}}e=To(M[a+228>>2],b,e);M[c>>2]=e;e:{d=d&1;f:{if(!(d|!M[e+20>>2])){M[a+200>>2]=M[a+200>>2]+1;break f}if(M[a+164>>2]==(b|0)){g=db(62885);break e}M[e+20>>2]=a;if(!(!(d|!M[M[a+64>>2]>>2])&P[a+28>>2]>=b>>>0)){if(P[a+160>>2]<b>>>0){g=13;if(P[a+28>>2]<b>>>0){break e}ll(e);break a}g:{if(!d){break g}c=M[18582];if(c){Ra[c|0]()}if(P[a+32>>2]>=b>>>0){Tg(M[a+60>>2],b)}bp(a,b);b=M[18583];if(!b){break g}Ra[b|0]()}a=M[a+168>>2];if(!a){break f}D(M[e+4>>2],0,a);return 0}M[a+204>>2]=M[a+204>>2]+1;g=gv(e);if(g){break e}}return 0}el(e)}fv(a);M[c>>2]=0;return g|0}function ok(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=Na-48|0;Na=d;a:{if(M[a+40>>2]){break a}f=M[a+8>>2];e=M[b+20>>2];c=M[b+4>>2];if(c&33554432){M[d+16>>2]=M[e+16>>2];fc(a,0,17492,d+16|0);$a(f,10,M[b+48>>2],M[b+44>>2]);g=M[b+28>>2];break a}M[b+4>>2]=c|33554432;g=1;c=M[a+48>>2]+1|0;M[a+48>>2]=c;M[b+48>>2]=c;k=b,l=$a(f,74,0,c)+1|0,M[k+44>>2]=l;if(!(N[b+4|0]&64)){j=Ub(f,15)}M[d+4>>2]=M[e+16>>2];M[d>>2]=j?30808:30643;fc(a,1,17471,d);h=N[b|0]!=139;g=h?g:M[M[e+28>>2]>>2];c=M[a+48>>2];M[d+36>>2]=0;M[d+40>>2]=0;M[d+28>>2]=0;M[d+32>>2]=0;i=c+1|0;M[d+24>>2]=i;c=c+g|0;M[a+48>>2]=c;b:{if(!h){M[d+36>>2]=g;M[d+32>>2]=i;bb(f,75,0,i,c);c=10;break b}$a(f,71,0,i);c=3}K[d+20|0]=c;h=M[a>>2];c:{if(M[e+60>>2]){c=wc(h,156,25046);if(c){K[c+1|0]=67;c=ob(a,53,qb(h,M[M[e+60>>2]+12>>2],0),c)}else{c=0}xi(a,M[M[e+60>>2]+12>>2]);M[M[e+60>>2]+12>>2]=c;break c}k=e,l=ob(a,149,wc(h,156,24170),0),M[k+60>>2]=l}g=0;M[e+8>>2]=0;if(Rc(a,e,d+20|0)){K[b+2|0]=N[b|0];K[b|0]=182;break a}g=M[d+24>>2];M[b+28>>2]=g;if(j){c=M[f+108>>2];M[(N[M[f>>2]+87|0]?74356:M[f+104>>2]+S(j,20)|0)+8>>2]=c}bb(f,67,M[b+48>>2],M[b+44>>2],1);M[a+32>>2]=0;K[a+19|0]=0}Na=d+48|0;return g}function gv(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=Na-16|0;Na=e;c=M[a+20>>2];M[e+12>>2]=0;a:{b:{c:{b=M[c+232>>2];if(!b){break c}b=ap(b,M[a+24>>2],e+12|0);if(b){break a}d=M[e+12>>2];if(!d){break c}b=M[c+232>>2];f=M[b+8>>2];h=M[a+4>>2];g=M[c+168>>2];b=O[b+66>>1];b=(b<<16|b)&130560;g=(b|0)>(g|0)?g:b;d=ZJ(b|24,0,d-1|0,0);b=Qa;d=d+56|0;b=d>>>0<56?b+1|0:b;b=Ra[M[M[f>>2]+8>>2]](f,h,g,d,b)|0;break b}b=M[c+64>>2];f=M[a+4>>2];d=M[c+168>>2];h=ZJ(d,M[c+172>>2],M[a+24>>2]-1|0,0);b=Ra[M[M[b>>2]+8>>2]](b,f,d,h,Qa)|0;b=(b|0)!=522?b:0}if(M[a+24>>2]!=1){break a}if(b){M[c+112>>2]=-1;M[c+116>>2]=-1;M[c+120>>2]=-1;M[c+124>>2]=-1;break a}a=M[a+4>>2];b=N[a+28|0]|N[a+29|0]<<8|(N[a+30|0]<<16|N[a+31|0]<<24);d=N[a+24|0]|N[a+25|0]<<8|(N[a+26|0]<<16|N[a+27|0]<<24);K[c+112|0]=d;K[c+113|0]=d>>>8;K[c+114|0]=d>>>16;K[c+115|0]=d>>>24;K[c+116|0]=b;K[c+117|0]=b>>>8;K[c+118|0]=b>>>16;K[c+119|0]=b>>>24;b=N[a+36|0]|N[a+37|0]<<8|(N[a+38|0]<<16|N[a+39|0]<<24);a=N[a+32|0]|N[a+33|0]<<8|(N[a+34|0]<<16|N[a+35|0]<<24);K[c+120|0]=a;K[c+121|0]=a>>>8;K[c+122|0]=a>>>16;K[c+123|0]=a>>>24;K[c+124|0]=b;K[c+125|0]=b>>>8;K[c+126|0]=b>>>16;K[c+127|0]=b>>>24;b=0}Na=e+16|0;return b}function xh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{if(!b){break a}d=M[b>>2];d=(d|0)<=0?56:S(d,48)|8;h=Ob(a,d,d>>31);if(!h){break a}d=M[b>>2];M[h>>2]=d;M[h+4>>2]=d;l=b+8|0;m=h+8|0;while(1){if((d|0)<=(k|0)){return h}e=S(k,48);d=e+m|0;f=e+l|0;M[d+12>>2]=M[f+12>>2];b:{if(N[f+13|0]&4){g=md(a,16,0);if(g){j=M[f+44>>2];i=M[j>>2];e=M[j+4>>2];M[g>>2]=i;M[g+4>>2]=e;e=M[j+12>>2];M[g+8>>2]=M[j+8>>2];M[g+12>>2]=e;e=le(a,i,c);M[g>>2]=e;if(e){break b}ib(a,g)}e=(N[d+13|0]|N[d+14|0]<<8)&65531;K[d+13|0]=e;K[d+14|0]=e>>>8;g=0;break b}g=M[f+44>>2];if(K[f+15|0]&1){break b}g=_b(a,g)}M[d+44>>2]=g;n=d,o=_b(a,M[f>>2]),M[n>>2]=o;n=d,o=_b(a,M[f+4>>2]),M[n+4>>2]=o;M[d+16>>2]=M[f+16>>2];e=N[d+13|0]|N[d+14|0]<<8;c:{if(e&2){n=d,o=_b(a,M[f+32>>2]),M[n+32>>2]=o;break c}if(e&8){n=d,o=xc(a,M[f+32>>2],c),M[n+32>>2]=o;break c}M[d+32>>2]=M[f+32>>2]}e=M[f+36>>2];M[d+36>>2]=e;if(N[d+14|0]&2){M[e>>2]=M[e>>2]+1}e=M[f+8>>2];M[d+8>>2]=e;if(e){M[e+24>>2]=M[e+24>>2]+1}e=M[f+40>>2];d:{if(N[f+14|0]&8){i=aB(a,e);break d}i=qb(a,e,c)}M[d+40>>2]=i;e=M[f+28>>2];M[d+24>>2]=M[f+24>>2];M[d+28>>2]=e;k=k+1|0;d=M[b>>2];continue}}return 0}function Zr(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=M[a+8>>2];l=M[i+108>>2];j=M[a+60>>2]-1|0;M[a+60>>2]=j;if(f){m=fb(i,17,f);n=M[c+16>>2];k=M[c+12>>2];if(g){M[g>>2]=M[g>>2]+1}o=k;k=f+1|0;g=nb(i,90,o,k,n,g,-8)+2|0;bb(i,14,g,j,g);g=M[i+108>>2];M[(N[M[i>>2]+87|0]?74356:M[i+104>>2]+S(m,20)|0)+8>>2]=g;bb(i,80,M[c+12>>2],k,M[c+16>>2]-1|0);$a(i,71,1,f)}if(N[M[a>>2]+87|0]){l=0}else{Ei(i,M[b+12>>2],j);a:{b:{switch(N[d|0]-10|0){case 2:g=Gb(a);f=Gb(a);bb(i,97,M[c+12>>2],M[c+16>>2],g);$a(i,127,M[d+4>>2],f);bb(i,128,M[d+4>>2],g,f);c=M[i+108>>2];if((c|0)>0){L[(M[i+104>>2]+S(c,20)|0)-18>>1]=8}zb(a,f);zb(a,g);break a;case 1:g=Gb(a);f=M[c+16>>2];nb(i,97,M[c+12>>2],f,g,M[d+20>>2],f);lb(i,138,M[d+4>>2],g,M[c+12>>2],M[c+16>>2]);d=M[d+8>>2];if((d|0)>0){lb(i,183,d,0,M[c+12>>2],M[c+16>>2]);fc(a,0,19609,0)}zb(a,g);break a;case 0:Di(a,M[c+12>>2],M[d+4>>2],M[c+16>>2]);break a;case 3:f=M[c+16>>2];g=M[d+12>>2];if(!g){g=vc(a,f);M[d+12>>2]=g;f=M[c+16>>2];M[d+16>>2]=f}Di(a,M[c+12>>2],g,f);fb(i,12,M[d+4>>2]);break a;default:break b}}$a(i,84,M[c+12>>2],M[c+16>>2])}a=M[b+8>>2];if(a){$a(i,61,a,h)}pb(i,j);fb(i,67,e)}return l}function zC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=(N[b|0]&63)+b|0;a:{b:{switch(N[b+1|0]-1|0){case 1:e=N[d+1|0]|K[d|0]<<8;f=e>>31;break a;case 2:e=N[d+2|0]|(N[d+1|0]<<8|K[d|0]<<16);f=e>>31;break a;case 3:e=N[d|0]|N[d+1|0]<<8|(N[d+2|0]<<16|N[d+3|0]<<24);e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);f=e>>31;break a;case 4:e=N[d+3|0];g=e>>>16|0;h=e<<16;f=g;e=N[d+2|0];g=e>>>8|0;h=e<<24|h;f=f|g;e=N[d+4|0];g=e>>>24|0;i=N[d+5|0]|(e<<8|h);f=f|g;g=N[d+1|0]|K[d|0]<<8;e=i;f=f|g;break a;case 5:e=N[d+4|0]|N[d+5|0]<<8|(N[d+6|0]<<16|N[d+7|0]<<24);f=N[d|0]|N[d+1|0]<<8|(N[d+2|0]<<16|N[d+3|0]<<24);h=f<<24|(f&65280)<<8;d=f&16711680;g=d<<24;d=d>>>8|0;j=g;i=f&-16777216;g=i>>>24|0;e=j|i<<8|(((e&255)<<24|f>>>8)&-16777216|((e&16777215)<<8|f>>>24)&16711680|(e>>>8&65280|e>>>24));j=d|g|h;g=0;f=j|(g|g);break a;case 8:e=1;break a;default:return Xi(a,b,c)|0;case 0:break b;case 7:break a}}e=K[d|0];f=e>>31}g=M[c+8>>2];d=M[c+12>>2];if(g>>>0>e>>>0&(d|0)>=(f|0)|(d|0)>(f|0)){return K[c+24|0]}if((d|0)<=(f|0)&e>>>0>g>>>0|(d|0)<(f|0)){return K[c+25|0]}if(O[c+20>>1]>=2){return Eh(a,b,c,1)|0}K[c+26|0]=1;return K[c+22|0]}function HI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;b=Na-96|0;Na=b;d=M[M[a>>2]+20>>2];e=M[d+120>>2];L[b+84>>1]=0;M[b+80>>2]=0;M[b+76>>2]=e;M[b+64>>2]=d;M[b+68>>2]=0;M[b+72>>2]=0;a:{b:{c:{d:{e:{f:{c=M[c>>2];switch(N[(O[c+16>>1]&63)+31312|0]-1|0){case 0:break e;case 1:break f;case 2:break c;case 3:break d;default:break b}}g=Kb(c);R[b+16>>3]=g;c=b- -64|0;rb(c,12680,b+16|0);d=M[b+80>>2];if(!d){break a}e=M[b+68>>2];K[e+d|0]=0;Jd(e,b+88|0,d,1);if(R[b+88>>3]==g){break a}ag(c);R[b>>3]=g;rb(c,14949,b);break a}k=b,l=sb(c),M[k+32>>2]=l;M[b+36>>2]=Qa;rb(b- -64|0,15078,b+32|0);break a}j=od(c);h=b- -64|0;d=Fb(c);c=d>>31<<1|d>>>31;e=d<<1;f=e+4|0;c=f>>>0<4?c+1|0:c;nl(h,f,c);if(N[b+84|0]){break a}c=0;h=(d|0)>0?d:0;d=M[b+68>>2];while(1){if((c|0)!=(h|0)){f=d+(c<<1)|0;i=c+j|0;K[f+2|0]=N[(N[i|0]>>>4|0)+52736|0];K[f+3|0]=N[(N[i|0]&15)+52736|0];c=c+1|0;continue}break}c=d+e|0;K[c+2|0]=39;K[c+3|0]=0;K[d|0]=88;K[d+1|0]=39;M[b+80>>2]=e+3;break a}k=b,l=gb(c),M[k+48>>2]=l;rb(b- -64|0,19994,b+48|0);break a}Ab(b- -64|0,20301,4)}vb(a,Rd(b- -64|0),M[b+80>>2],5);c=N[b+84|0];if(c){Yb(a);ee(a,c)}Na=b+96|0}function yz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=Na-80|0;Na=d;e=b;b=d+32|0;a:{if(sg(a,e,c,b)){break a}cf(b);K[d+5|0]=45;K[d+8|0]=45;K[d+11|0]=32;K[d+14|0]=58;b=M[d+44>>2];c=(b|0)/10|0;K[d+6|0]=((c|0)%10|0)+48;e=M[d+48>>2];f=(e|0)/10|0;K[d+9|0]=((f|0)%10|0)+48;h=M[d+52>>2];i=(h|0)/10|0;K[d+12|0]=((i|0)%10|0)+48;K[d+7|0]=(b-S(c,10)|0)+48;K[d+10|0]=(e-S(f,10)|0)+48;K[d+13|0]=(h-S(i,10)|0)+48;f=M[d+40>>2];b=f>>31;b=(b^f)-b|0;c=(b>>>0)/10|0;K[d+3|0]=(c>>>0)%10|48;K[d+2|0]=((b>>>0)/100>>>0)%10|48;K[d+1|0]=((b>>>0)/1e3>>>0)%10|48;K[d+4|0]=b-S(c,10)|48;b=M[d+56>>2];K[d+17|0]=58;c=b;b=(b|0)/10|0;K[d+16|0]=(c-S(b,10)|0)+48;K[d+15|0]=((b|0)%10|0)+48;g=R[d+64>>3];b:{if(N[d+76|0]&4){K[d+24|0]=0;g=g*1e3+.5;if(U(g)<2147483647){b=~~g}else{b=-2147483648}K[d+21|0]=(((b|0)/100|0)%10|0)+48;c=(b|0)/10|0;K[d+22|0]=((c|0)%10|0)+48;K[d+23|0]=(b-S(c,10)|0)+48;e=(b|0)/1e3|0;c=(b|0)/1e4|0;h=46;b=24;break b}e=U(g)<2147483647?~~g:-2147483648;c=(e|0)/10|0;h=0;b=20}K[d+20|0]=h;K[d+19|0]=((e|0)%10|0)+48;K[d+18|0]=((c|0)%10|0)+48;if((f|0)<0){K[d|0]=45;vb(a,d,b,-1);break a}vb(a,d|1,b-1|0,-1)}Na=d+80|0}function Yp(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Na-16|0;Na=g;a:{b:{c:{d:{e:{f=M[b>>2];if(!f){k=M[a+232>>2];break e}e=M[f+32>>2];j=M[f+16>>2];i=Qj(j,M[f+20>>2],c,d);h=d-i|0;if((h|0)<=0){d=267;break a}m=i>>31;l=(_d(i,m)+(e+h|0)|0)+_d(h,0)|0;k=M[a+232>>2];if((l|0)>(k|0)){if(j){break e}a=Bb(l,l>>31);M[f+36>>2]=a;if(!a){break d}j=M[f+16>>2]}if(j){e=uc(M[f+36>>2]+e|0,i,m)+e|0}a=uc(M[f+36>>2]+e|0,h,0)+e|0;if(h){G(a+M[f+36>>2]|0,c+i|0,h)}M[f+32>>2]=a+h;M[f+12>>2]=M[f+12>>2]+1;e=M[f+28>>2];if(M[f+24>>2]<(d|0)){a=d<<1;e=Mc(e,a,d>>31<<1|d>>>31);if(!e){break d}M[f+28>>2]=e;M[f+24>>2]=a}M[f+16>>2]=e;if(d){G(e,c,d)}M[f+20>>2]=d;d=0;break a}e=Bb(k+40|0,0);M[g+12>>2]=e;if(!e){break d}M[e>>2]=0;M[e+4>>2]=0;M[e+32>>2]=11;M[e+24>>2]=0;M[e+28>>2]=0;M[e+16>>2]=0;M[e+20>>2]=0;M[e+8>>2]=0;M[e+12>>2]=0;M[e+36>>2]=e+40;if(!f){break c}M[g+8>>2]=M[f>>2];d=Yp(a,g+8|0,c,d);a=M[g+8>>2];if(!M[f>>2]){M[f>>2]=a}M[f+4>>2]=e;c=M[f+8>>2];M[e>>2]=a;M[e+8>>2]=c;M[e+28>>2]=M[f+28>>2];M[e+24>>2]=M[f+24>>2];M[f+28>>2]=0;break b}d=7;break a}M[e+8>>2]=e;d=Yp(a,g+12|0,c,d);e=M[g+12>>2]}M[b>>2]=e}Na=g+16|0;return d}function hs(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Na-32|0;Na=h;a:{if(!c|M[b+4>>2]&33562624){break a}i=S(e,48)+d|0;if(N[(i+8|0)+12|0]&80){break a}b:{c:{if(M[b+52>>2]){f=b;while(1){if(f){d:{switch(N[f|0]-136|0){default:g=1;break;case 0:case 3:break d}}if(M[f+68>>2]){break b}f=M[f+52>>2];continue}break}if(!g){break c}g=b;while(1){if(!g){break c}j=M[g+28>>2];l=j+8|0;f=0;while(1){if(M[j>>2]>(f|0)){k=Fd(a,M[(f<<4)+l>>2]);if(M[k+12>>2]!=15?k:0){break b}f=f+1|0;continue}break}g=M[g+52>>2];continue}}f=M[b+68>>2];if(!f){break c}if(!M[f+8>>2]){break b}}f=0;if(M[b+60>>2]){break a}while(1){if(N[c|0]==44){f=hs(a,b,M[c+16>>2],d,e)+f|0;c=M[c+12>>2];continue}break}if(!or(c,d,e,1)){break a}M[b+4>>2]=M[b+4>>2]|16777216;d=f+1|0;while(1){if(!b){f=d;break a}g=qb(M[a>>2],c,0);Gi(g,-1,1);M[h+8>>2]=a;e=M[i+24>>2];M[h+20>>2]=0;M[h+16>>2]=e;M[h+12>>2]=e;M[h+24>>2]=M[b+28>>2];m=h,n=Xr(b),M[m+28>>2]=n;e=kh(h+8|0,g);e:{g=M[b+68>>2];if(!g){break e}if(LA(a,e,M[g+8>>2])){break e}kb(M[a>>2],e);break a}g=(M[b+4>>2]&8)+b|0;m=g,n=ce(a,M[g+36>>2],e),M[m+36>>2]=n;b=M[b+52>>2];continue}}f=0}Na=h+32|0;return f}function Wx(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Na-48|0;Na=h;M[h+40>>2]=0;M[h+44>>2]=0;M[h+32>>2]=0;M[h+36>>2]=0;M[h+24>>2]=0;M[h+28>>2]=0;M[h+20>>2]=b;M[h+16>>2]=d;M[h+8>>2]=0;M[f>>2]=0;M[g>>2]=0;i=(c>>31)+(e>>31)|0;j=c+e|0;i=j>>>0<e>>>0?i+1|0:i;j=j+17|0;i=j>>>0<17?i+1|0:i;i=Bb(j,i);a:{if(!i){b=7;break a}M[h+12>>2]=i;j=b+c|0;we(h+20|0,j,0,h+40|0);l=d+e|0;we(h+16|0,l,0,h+32|0);b:{c:{while(1){m=M[h+20>>2];n=M[h+16>>2];if(!(m|n)){break c}d:{b=M[h+40>>2];c=M[h+32>>2];d=M[h+44>>2];e=M[h+36>>2];k=(b>>>0>c>>>0&(d|0)>=(e|0)|(d|0)>(e|0))-(b>>>0<c>>>0&(d|0)<=(e|0)|(d|0)<(e|0))|0;k=a?0-k|0:k;if(!(k|(!m|!n))){c=h+12|0;Tl(c,a,h+24|0,h+8|0,b,d);b=c;c=h+20|0;d=h+16|0;b=Vx(b,c,d);if(b){break d}we(c,j,a,h+40|0);we(d,l,a,h+32|0);continue}if(!((m|0)!=0&(k|0)<0?0:n)){c=h+12|0;Tl(c,a,h+24|0,h+8|0,b,d);b=h+20|0;xe(c,b);we(b,j,a,h+40|0);continue}b=h+12|0;Tl(b,a,h+24|0,h+8|0,c,e);c=b;b=h+16|0;xe(c,b);we(b,l,a,h+32|0);continue}break}ab(i);a=0;i=0;break b}a=M[h+12>>2];K[a|0]=0;K[a+1|0]=0;K[a+2|0]=0;K[a+3|0]=0;K[a+4|0]=0;K[a+5|0]=0;K[a+6|0]=0;K[a+7|0]=0;b=0}M[f>>2]=i;M[g>>2]=a-i}Na=h+48|0;return b}function wi(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=Na-16|0;Na=k;m=M[c+40>>2];a:{b:{h=M[c+20>>2];c:{d:{if((h|0)==1){e=L[b+32>>1];if((e|0)<0){break d}if(!m){break c}if(hb(M[M[b+4>>2]+S(e,12)>>2],m)){break d}break a}if(!e){break d}f=Ob(M[a>>2],h<<2,0);if(!f){break b}M[e>>2]=f}o=c+36|0;n=(h|0)>0?h:0;e=b+8|0;while(1){e:{f:{g:{h:{g=M[e>>2];if(g){if(M[g+36>>2]|(!N[g+54|0]|O[g+50>>1]!=(h|0))){break f}if(!m){break h}i=0;while(1){if((i|0)==(n|0)){i=n;break g}e=L[M[g+4>>2]+(i<<1)>>1];if((e|0)<0){break g}p=i<<2;j=M[p+M[g+32>>2]>>2];e=M[b+4>>2]+S(e,12)|0;l=eg(e);if(hb(j,l?l:33696)){break g}l=M[e>>2];e=0;while(1){if((e|0)==(h|0)){break g}j=e<<3;e=e+1|0;j=j+o|0;if(hb(M[j+4>>2],l)){continue}break}if(f){M[f+p>>2]=M[j>>2]}i=i+1|0;continue}}if(!N[a+165|0]){b=M[M[c>>2]>>2];M[k+4>>2]=M[c+8>>2];M[k>>2]=b;cb(a,29350,k)}eb(M[a>>2],f);break b}if(((N[g+55|0]|N[g+56|0]<<8)&3)!=2){break f}if(!f){break e}e=0;while(1){if((e|0)==(n|0)){break e}M[(e<<2)+f>>2]=M[(e<<3)+o>>2];e=e+1|0;continue}}if((i|0)==(h|0)){break e}}e=g+20|0;continue}break}M[d>>2]=g}f=0;break a}f=1}Na=k+16|0;return f}function zJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;h=N[b|0];g=M[a>>2];a:{b:{c:{d=M[a+24>>2];if(!M[d+16>>2]){break c}if((h|0)!=168){break b}a=0;e=M[d+4>>2];f=M[e>>2];c=(f|0)>0?f:0;e=e+24|0;while(1){d:{if((a|0)!=(c|0)){if(M[b+28>>2]!=M[e+S(a,48)>>2]){break d}}else{a=c}if((a|0)==(f|0)){break b}break c}a=a+1|0;continue}}e:{f:{switch(h-168|0){case 4:if(!(K[b+7|0]&1)){break b}c=d;while(1){a=M[c>>2];if(!a){break e}c=a+36|0;if((a|0)!=M[b+44>>2]){continue}break};return 1;case 2:case 3:break b;case 0:case 1:break e;default:break f}}if((h|0)!=179){break b}}f=2;a=M[g>>2];if(N[a+87|0]){break a}g:{h:{c=M[d+8>>2];if(c){a=0;while(1){if(M[c>>2]>(a|0)){if(!mc(0,M[((a<<4)+c|0)+8>>2],b,-1)){break h}a=a+1|0;c=M[d+8>>2];continue}break}a=M[g>>2]}a=qb(a,b,0);if(!(!a|N[a|0]!=169)){K[a|0]=172}c=Wb(g,M[d+8>>2],a);M[d+8>>2]=c;a=-1;e=1;break g}c=M[d+8>>2];e=0}if(c){c=M[b+4>>2];M[b+4>>2]=c|134217728;me(M[g>>2],b);D(b,0,52);K[b|0]=168;if(e){a=M[M[d+8>>2]>>2]-1|0}L[b+32>>1]=a;M[b+28>>2]=M[M[d>>2]+48>>2];a=M[d+12>>2];M[b+4>>2]=c&512;M[b+44>>2]=a}if(N[M[g>>2]+87|0]){break a}}f=0}return f|0}function gt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=Na+-64|0;Na=d;e=M[a+252>>2];a:{if(!e){break a}f=M[a>>2];ht(a);M[a+268>>2]=0;if(M[e+44>>2]<=0){break a}if(!N[f+177|0]){c=M[a+132>>2];K[(c?c:a)+21|0]=1;if(b){M[a+208>>2]=M[b+4>>2]+(M[b>>2]-M[a+204>>2]|0)}M[d+48>>2]=a+204;c=tb(f,19164,d+48|0);b=M[f+16>>2];g=Mb(f,M[e+60>>2]);h=M[b+(g<<4)>>2];b=M[e>>2];M[d+32>>2]=M[a+100>>2];M[d+28>>2]=c;M[d+24>>2]=b;M[d+20>>2]=b;M[d+16>>2]=h;sc(a,16992,d+16|0);b=Cb(a);Sf(a,g);Ub(b,166);h=M[e>>2];M[d+4>>2]=c;M[d>>2]=h;uh(b,g,tb(f,19684,d),0);eb(f,c);c=a;a=M[a+48>>2]+1|0;M[c+48>>2]=a;Uc(b,a,M[e>>2]);$a(b,171,g,a);break a}j=M[e>>2];k=M[e+60>>2];b:{g=Sc(f+388|0,M[M[e+48>>2]>>2]);if(!g){break b}b=M[g>>2];if(!b|M[b>>2]<3|!M[b+92>>2]){break b}h=jb(M[e>>2]);b=M[e+60>>2]+16|0;while(1){b=M[b>>2];if(!b){break b}c=M[b+8>>2];if(N[c+43|0]|N[c+29|0]&16){continue}i=M[c>>2];if(Eb(i,M[e>>2],h)){continue}i=h+i|0;if(N[i|0]!=95){continue}if(!(Ra[M[M[g>>2]+92>>2]](i+1|0)|0)){continue}M[c+28>>2]=M[c+28>>2]|4096;continue}}if(wd(k+8|0,j,e)){Lb(f);break a}M[a+252>>2]=0}Na=d- -64|0}function qk(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Na-32|0;Na=g;Eg(M[a+8>>2],c,b);a:{if(!(N[c+28|0]&64)){break a}d=74356;e=M[a+8>>2];if(!N[M[e>>2]+87|0]){d=(M[e+104>>2]+S(M[e+108>>2],20)|0)-20|0}b:{switch(N[d|0]-95|0){case 1:e=M[d+16>>2];d=0;while(1){h=e+f|0;if(!N[h|0]){break a}i=O[(M[c+4>>2]+S(d,12)|0)+10>>1];if(!(i&32)){if(i&64){K[h|0]=64}f=f+1|0}d=d+1|0;continue};case 0:break b;default:break a}}M[d+12>>2]=1}d=0;h=L[c+34>>1];e=(h|0)>0?h:0;while(1){if((d|0)!=(e|0)){i=M[c+4>>2]+S(d,12)|0;f=O[i+10>>1];if(f&96){L[i+10>>1]=f|128}d=d+1|0;continue}break}M[g+12>>2]=0;M[g+16>>2]=0;M[g+8>>2]=78;M[g+28>>2]=c;M[a+56>>2]=0-b;e=0;d=0;f=0;c:while(1){j=h<<16>>16;while(1){i=d;h=e;if((f|0)<(j|0)){d=M[c+4>>2]+S(f,12)|0;e=O[d+10>>1];d:{if(e&128){L[d+10>>1]=e|256;L[g+24>>1]=0;Nb(g+4|0,Tc(c,d));L[d+10>>1]=O[d+10>>1]&65279;if(N[g+24|0]&128){e=h;break d}Hr(a,c,d,Pc(c,f<<16>>16)+b|0);L[d+10>>1]=O[d+10>>1]&65407;e=1}else{e=h}d=i}f=f+1|0;h=O[c+34>>1];continue c}if(i){e=0;d=0;f=0;if(h){continue}}break}break}if(i){M[g>>2]=M[i>>2];cb(a,29507,g)}M[a+56>>2]=0;Na=g+32|0}function ly(a,b,c){var d=0,e=0,f=0,g=0,h=0;f=Na-16|0;Na=f;h=c;a:{b:{if(M[a+40>>2]){a=M[((M[a+24>>2]<<2)+b|0)+12>>2];c=O[a+16>>1];e=c&31;if((c&63)>>>0>=32){d=1<<e;c=0}else{c=1<<e;d=c-1&1>>>32-e}if(c&-1431655766|d&-1431655766){a=M[b+4>>2];b=O[a+16>>1];c=b&31;if((b&63)>>>0>=32){b=0}else{b=1<<c}c=b}if(!(c&1347440720)){c=19;break a}c=0;a=sb(a);b=Qa;break b}c=Tb(a,18,f+12|0,b+4|0);if(c){break a}if(M[a+44>>2]){d=M[f+12>>2];e=M[a+24>>2];c=sb(M[((e<<2)+b|0)+16>>2]);c=fd(d,e+2|0,c);if(c){break a}}e=M[((M[a+24>>2]<<2)+b|0)+12>>2];c=O[e+16>>1];d=c&31;if((c&63)>>>0>=32){d=1<<d;c=0}else{c=1<<d;d=c-1&1>>>32-d}c:{if(c&-1431655766|d&-1431655766){b=M[f+12>>2];break c}c=O[M[b>>2]+16>>1];d=c&31;d:{if((c&63)>>>0>=32){c=1<<d;g=0}else{g=1<<d;c=g-1&1>>>32-d}if(!(g&-1431655766|c&-1431655766)){break d}b=O[M[b+4>>2]+16>>1];c=b&31;if((b&63)>>>0>=32){d=1<<c;b=0}else{b=1<<c;d=b-1&1>>>32-c}if(b&-1431655766|d&-1431655766){break d}c=1;break a}b=M[f+12>>2];c=vp(b,1,e);if(c){break a}}Db(b);c=wb(b);b=M[a+12>>2];a=M[b+40>>2];b=M[b+44>>2]}M[h>>2]=a;M[h+4>>2]=b}Na=f+16|0;return c}function le(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=Na-32|0;Na=f;M[f>>2]=0;i=f;while(1){a:{b:{if(!b){break b}d=Ob(a,76,0);if(!d){break b}k=d,l=xc(a,M[b+28>>2],c),M[k+28>>2]=l;k=d,l=xh(a,M[b+32>>2],c),M[k+32>>2]=l;k=d,l=qb(a,M[b+36>>2],c),M[k+36>>2]=l;k=d,l=xc(a,M[b+40>>2],c),M[k+40>>2]=l;k=d,l=qb(a,M[b+44>>2],c),M[k+44>>2]=l;k=d,l=xc(a,M[b+48>>2],c),M[k+48>>2]=l;h=N[b|0];M[d+56>>2]=e;K[d|0]=h;M[d+52>>2]=0;e=qb(a,M[b+60>>2],c);M[d+8>>2]=0;M[d+12>>2]=0;M[d+60>>2]=e;e=M[b+4>>2];M[d+20>>2]=-1;M[d+24>>2]=-1;M[d+4>>2]=e&-33;L[d+2>>1]=O[b+2>>1];e=cB(a,M[b+64>>2]);M[d+68>>2]=0;M[d+64>>2]=e;e=M[b+72>>2];M[f+4>>2]=0;h=d+52|0;g=f+4|0;while(1){c:{if(!e){break c}j=g;g=bB(a,0,e);M[j>>2]=g;if(!g){break c}g=g+36|0;e=M[e+36>>2];continue}break}M[d+72>>2]=M[f+4>>2];e=N[a+87|0];d:{if(M[b+68>>2]){if(e&255){M[d+16>>2]=M[b+16>>2];break d}M[f+16>>2]=0;M[f+12>>2]=39;M[f+8>>2]=40;M[f+28>>2]=d;M[f+4>>2]=0;oc(f+4|0,d);e=N[a+87|0]}M[d+16>>2]=M[b+16>>2];if(!(e&255)){break a}}M[d+56>>2]=0;pc(a,d)}Na=f+32|0;return M[f>>2]}M[i>>2]=d;b=M[b+52>>2];i=h;e=d;continue}}function hu(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=Na-32|0;Na=d;f=M[a+4>>2];M[f+4>>2]=M[a>>2];a:{b:{c:{d:{if(N[f+17|0]){cq(f);Gh(a,4,d+24|0);g=M[d+24>>2];if(g>>>0>P[f+48>>2]){break c}h=M[16864];while(1){e=g;g=e+1|0;if((g|0)==(Zd(f,g)|0)|(e|0)==((h>>>0)/P[f+36>>2]|0)){continue}break}M[d+24>>2]=g;e=rf(f,d+12|0,d+16|0,g,1);M[d+20>>2]=e;if(e){break a}h=M[d+16>>2];e:{if((h|0)!=(g|0)){K[d+11|0]=0;M[d+4>>2]=0;e=ng(f,0,0);Rb(M[d+12>>2]);if(e){break a}e=xd(f,g,d+28|0,0);if(e){break a}e=ej(f,g,d+11|0,d+4|0);f:{i=N[d+11|0];g:{if((i-1&255)>>>0<=1){e=db(80827);break g}if(!e){break f}}h=M[d+28>>2];break b}j=M[d+28>>2];e=Lo(f,j,i,M[d+4>>2],h,0);Rb(j);if(e){break a}e=xd(f,g,d+28|0,0);if(e){break a}h=M[d+28>>2];e=ac(M[h+72>>2]);M[d+20>>2]=e;if(!e){break e}break b}h=M[d+12>>2];M[d+28>>2]=h}Hd(f,g,1,0,d+20|0);e=M[d+20>>2];if(e){break b}e=ek(a,4,g);M[d+20>>2]=e;if(e){break b}break d}e=rf(f,d+28|0,d+24|0,1,0);M[d+20>>2]=e;if(e){break a}h=M[d+28>>2]}Oh(h,c&1?13:10);sd(M[h+72>>2]);M[b>>2]=M[d+24>>2];e=0;break a}e=db(80779);break a}Rb(h)}Na=d+32|0;return e}function vz(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=Na-96|0;Na=c;D(c+52|0,0,44);Cc(a);d=M[a>>2];f=d-947587585|0;e=M[a+4>>2];g=e-((d>>>0<947587585)+49596|0)|0;a:{if((g|0)==-500&f>>>0<=98047998|g>>>0<4294966796){G(c,a,48);cf(c);K[c+40|0]=0;e=M[c+8>>2];g=((e|0)%4|0)+2e3|0;M[c+8>>2]=g;Cc(c);d=_J(M[c>>2],M[c+4>>2],1e3,0);f=Qa;e=(e-g|0)+1900|0;break a}d=aK(d,e,1e3,0);f=Qa;e=1900}M[c>>2]=d-413362496;M[c+4>>2]=f-((d>>>0<413362496)+49|0);if(!(K[74944]&1)){Ea(74928,74932,74960,74992);M[18735]=74992;M[18734]=74960;K[74944]=1}na(M[c>>2],M[c+4>>2],74884);M[18731]=M[(M[18729]?74940:74936)>>2];d=74884;b:{c:{d:{if(M[16931]){f=M[16932];if(!f){break d}d=c+52|0;if(Ra[f|0](c,d)|0){break d}break c}break c}Pb(b,14432,-1);a=1;break b}G(c+52|0,d,44);M[a+8>>2]=e+M[c+72>>2];M[a+12>>2]=M[c+68>>2]+1;M[a+16>>2]=M[c+64>>2];M[a+20>>2]=M[c+60>>2];M[a+24>>2]=M[c+56>>2];b=M[c+52>>2];K[a+41|0]=1;K[a+42|0]=1;K[a+40|0]=0;K[a+44|0]=N[a+44|0]&252;M[a+28>>2]=0;h=a,i=(+($J(M[a>>2],M[a+4>>2],1e3,0)>>>0)+ +(Qa|0)*4294967296)*.001+ +(b|0),R[h+32>>3]=i;a=0}Na=c+96|0;return a}function Ih(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;d=O[b+16>>1];f=O[a+16>>1];e=d|f;if(e&1){return(d&1)-(f&1)|0}a:{b:{c:{if(e&44){c=d&f;if(c&36){c=M[a>>2];d=M[b>>2];a=M[a+4>>2];b=M[b+4>>2];if(c>>>0<d>>>0&(a|0)<=(b|0)|(a|0)<(b|0)){break a}return c>>>0>d>>>0&(a|0)>=(b|0)|(a|0)>(b|0)}if(c&8){g=R[a>>3];h=R[b>>3];if(g<h){break a}return g>h}if(f&36){if(d&8){return Wi(M[a>>2],M[a+4>>2],R[b>>3])}c=-1;if(!(d&36)){break c}d=M[a>>2];f=M[b>>2];a=M[a+4>>2];b=M[b+4>>2];if(d>>>0<f>>>0&(a|0)<=(b|0)|(a|0)<(b|0)){break c}return d>>>0>f>>>0&(a|0)>=(b|0)|(a|0)>(b|0)}if(!(f&8)){break b}if(!(d&36)){break a}return 0-Wi(M[b>>2],M[b+4>>2],R[a>>3])|0}d:{if(!(e&2)){break d}if(!(f&2)){break b}if(!(d&2)){break a}if(!c){break d}return Tt(a,b,c,0)}d=M[b+12>>2];f=M[a+12>>2];c=O[b+16>>1];e=O[a+16>>1];e:{if((c|e)&1024){i=c;c=e&1024;e=M[a>>2]-M[b>>2]|0;if(i&c){break e}if(c){e=-1;if(!po(M[b+8>>2],d)){break e}e=M[a>>2]-d|0;break e}e=1;if(!po(M[a+8>>2],f)){break e}e=f-M[b>>2]|0;break e}a=Qb(M[a+8>>2],M[b+8>>2],(d|0)>(f|0)?f:d);e=a?a:f-d|0}c=e}return c}return 1}return-1}function _n(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=Na-4208|0;Na=e;while(1){g=c;while(1){h=b+g|0;d=N[h|0];if(!(!d|(d|0)==47)){g=g+1|0;continue}break}a:{if((c|0)>=(g|0)){break a}f=g-c|0;b:{d=b+c|0;if(N[d|0]!=46){c=M[a+16>>2];break b}if((f|0)==1){break a}c=M[a+16>>2];if((f|0)!=2|N[d+1|0]!=46){break b}if((c|0)<2){break a}d=M[a+8>>2];while(1){c=c-1|0;M[a+16>>2]=c;if(N[c+d|0]!=47){continue}break}break a}if(M[a+12>>2]<=((c+f|0)+2|0)){M[a>>2]=1;break a}M[a+16>>2]=c+1;K[M[a+8>>2]+c|0]=47;if(f){G(M[a+8>>2]+M[a+16>>2]|0,d,f)}c=M[a+16>>2]+f|0;M[a+16>>2]=c;if(M[a>>2]){break a}K[c+M[a+8>>2]|0]=0;d=M[a+8>>2];if(Ra[M[17026]](d,e+4112|0)|0){if(M[18595]==44){break a}i=a,j=Qd(ne(45239),3578,d,45239),M[i>>2]=j;break a}if((M[e+4116>>2]&61440)!=40960){break a}c=M[a+4>>2];M[a+4>>2]=c+1;c:{d:{if((c|0)>=201){c=ne(45245);break d}c=Ra[M[17023]](d,e,4096)|0;if(c-4096>>>0>4294963200){break c}c=Qd(ne(45250),11972,d,45250)}M[a>>2]=c;break a}K[c+e|0]=0;M[a+16>>2]=N[e|0]!=47?M[a+16>>2]+(f^-1)|0:0;_n(a,e)}c=g+1|0;if(N[h|0]){continue}break}Na=e+4208|0}function Yy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;h=c+d|0;f=c;while(1){a:{if(f>>>0<h>>>0){d=f+1|0;e=N[f|0];if(e>>>0<192){f=d;break a}e=N[e+33440|0];while(1){b:{if(d>>>0>=h>>>0){d=h}else{f=N[d|0];if((f&192)==128){break b}}f=d;e=(e&-2)==65534?65533:e>>>0<128?65533:(e&-2048)==55296?65533:e;break a}e=f&63|e<<6;d=d+1|0;continue}}c:{if(!g){break c}i=Mc(M[a+12>>2],M[a+8>>2]+g<<2,0);if(!i){return 7}f=M[a+8>>2];d:while(1){e:{if(c>>>0<h>>>0){d=c+1|0;e=N[c|0];if(e>>>0<192){c=d;break e}e=N[e+33440|0];while(1){f:{if(d>>>0>=h>>>0){c=h}else{c=N[d|0];if((c&192)==128){break f}c=d}e=(e&-2)==65534?65533:e>>>0<128?65533:(e&-2048)==55296?65533:e;break e}e=c&63|e<<6;d=d+1|0;continue}}M[a+8>>2]=f;M[a+12>>2]=i;break c}if((rq(e)|0)==(b|0)){continue}if(sq(e)){continue}d=0;g=(f|0)>0?f:0;while(1){g:{if((d|0)!=(g|0)){if(M[(d<<2)+i>>2]<(e|0)){break g}g=d}d=f;while(1){if((d|0)>(g|0)){j=(d<<2)+i|0;M[j>>2]=M[j-4>>2];d=d-1|0;continue}break}M[(g<<2)+i>>2]=e;f=f+1|0;continue d}d=d+1|0;continue}}}return 0}if((rq(e)|0)==(b|0)){continue}g=!sq(e)+g|0;continue}}function _l(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Na-16|0;Na=h;i=M[d>>2];a:{if(!i){i=1;g=a?-1:1;l=a?-1:0;M[h+4>>2]=b;c=b+c|0;a=0;while(1){if(b>>>0<c>>>0){a=Ic(b,h+8|0)+b|0;M[h+4>>2]=a;b=M[h+8>>2];n=M[h+12>>2];xe(0,h+4|0);i=ZJ(i,j,b,n);b=m+Qa|0;j=k;k=i+k|0;m=j>>>0>k>>>0?b+1|0:b;b=M[h+4>>2];while(1){if(!(N[b|0]|b>>>0>=c>>>0)){b=b+1|0;continue}break}M[h+4>>2]=b;i=g;j=l;continue}break}M[f>>2]=c-a;M[d>>2]=a;M[e>>2]=k;M[e+4>>2]=m;break a}j=i-2|0;while(1){if(!(b>>>0>j>>>0|K[j|0]>=0)){j=j-1|0;continue}break}i=j+1|0;Ic(i,h+8|0);c=M[h+8>>2];l=0-c|0;k=a?c:l;l=k+M[e>>2]|0;m=M[h+12>>2];a=M[e+4>>2]+(a?m:0-(m+((c|0)!=0)|0)|0)|0;M[e>>2]=l;M[e+4>>2]=l>>>0<k>>>0?a+1|0:a;b:{if((b|0)!=(i|0)){e=-1;while(1){c:{a=e+j|0;if(a>>>0<=b>>>0){c=0;break c}e=e-1|0;c=N[a|0];if(!c){continue}}break}d:{e:{while(1){a=e+j|0;if(b>>>0<a>>>0){g=c<<24>>24;c=N[a|0];if(!(g|c&128)){break e}e=e-1|0;continue}break}if(c&255|(e|0)>-2){break d}}a=a+2|0}while(1){b=K[a|0];a=a+1|0;if((b|0)<0){continue}break}M[f>>2]=i-a;i=a;break b}K[g|0]=1}M[d>>2]=i}Na=h+16|0}function Oq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=Na+-64|0;Na=c;M[c+32>>2]=c+52;M[c+36>>2]=c+48;d=1;a:{if((If(a,14933,c+32|0)|0)!=2){break a}b:{if(N[a+5|0]==58){M[c+16>>2]=c+44;d=1;if((If(a+6|0,14953,c+16|0)|0)!=1){break a}f=a+8|0;e=0;if(N[a+8|0]!=46){break b}d=N[a+9|0];e=0;if(d-58>>>0<4294967286){break b}f=a+9|0;e=1;while(1){if(d-58>>>0>=4294967286){e=e*10;g=g*10+ +(d<<24>>24)+-48;d=N[f+1|0];f=f+1|0;continue}break}e=g/e;e=e>.999?.999:e;break b}f=a+5|0;M[c+44>>2]=0;e=0}K[b+40|0]=0;K[b+42|0]=1;h=N[b+44|0];K[b+44|0]=h&254;M[b+20>>2]=M[c+52>>2];M[b+24>>2]=M[c+48>>2];R[b+32>>3]=e+ +M[c+44>>2];while(1){a=f;f=a+1|0;if(K[N[a|0]+31408|0]&1){continue}break}M[b+28>>2]=0;i=-1;c:{d:{e:{f:{d=N[a|0];switch(d-43|0){case 0:break e;case 2:break d;default:break f}}if((d&223)==90){K[b+44|0]=h&230|8;break c}d=(d|0)!=0;break a}i=1}M[c+4>>2]=c+56;M[c>>2]=c+60;d=1;if((If(f,14941,c)|0)!=2){break a}M[b+28>>2]=S(M[c+56>>2]+S(M[c+60>>2],60)|0,i);f=a+6|0}while(1){a=N[f|0];f=f+1|0;if(K[a+31408|0]&1){continue}break}d=(a|0)!=0}Na=c- -64|0;return d}function sy(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;k=Na-16|0;Na=k;while(1){a:{b:{c:{if(M[f>>2]){break c}d:{switch(M[c>>2]-2|0){default:g=M[c+12>>2];break a;case 0:break c;case 2:break b;case 3:break d}}l=M[c+20>>2];r=l+72|0;c=0;e:while(1){if(M[l+64>>2]<=(m|0)|c){break c}h=M[d>>2];M[d>>2]=h+24;M[h+12>>2]=b;M[h+4>>2]=m;M[h>>2]=l;c=S(m,24)+r|0;M[h+8>>2]=c;M[h+20>>2]=M[l+68>>2];o=M[c+20>>2];p=M[a>>2];q=M[p+244>>2];c=0;e=0;n=0;while(1){f:{g:{if(!(M[o+4>>2]<=(e|0)|c)){i=M[M[o>>2]+(e<<2)>>2];if(M[i+56>>2]|N[i+5|0]){break g}j=M[i+8>>2];g=M[i+12>>2];while(1){c=M[i+20>>2];if(P[i+16>>2]<j>>>0&(c|0)<=(g|0)|(c|0)<(g|0)){break g}c=dh(p,j,g,0,k+12|0);if(c){break f}c=M[k+12>>2];if((c+35|0)>(q|0)){n=((c+34|0)/(q|0)|0)+n|0}j=j+1|0;g=j?g:g+1|0;continue}}M[h+16>>2]=n;M[f>>2]=c;m=m+1|0;continue e}c=0}e=e+1|0;continue}}}Na=k+16|0;return}b=M[e>>2];g=M[c+12>>2];M[b>>2]=g;M[e>>2]=b+4;b=g}sy(a,b,g,d,e,f);g=M[c>>2];c=M[c+16>>2];if((g|0)!=4){continue}b=M[e>>2];M[b>>2]=c;M[e>>2]=b+4;b=c;continue}}function iB(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;a:{e=O[a+20>>1];b:{c:{if(!(!(K[b+4|0]&1)|(e|0)!=2)){break c}d:{e:{f:{g:{h:{c=N[b|0];switch(c-168|0){case 8:case 11:break c;case 0:case 1:case 2:break e;case 3:case 5:case 6:case 7:case 9:case 10:break b;case 4:break g;default:break h}}if((c|0)==60){break f}if((c|0)==72|(c|0)==142){break c}if((c|0)==157){break d}break a}c=M[b+4>>2];if(!(!(c&1048576)&e>>>0<=3|c&16777216)){if((e|0)!=5){break a}M[b+4>>2]=c|1073741824;break a}if(M[a>>2]){c=0;i:{j:{k:{if(K[b+6|0]&1){break k}d=M[b+20>>2];if(!d){break k}c=M[d>>2];ec(a,d);if(!O[a+20>>1]){break j}}d=M[M[a>>2]>>2];c=re(d,M[b+8>>2],c,N[d+84|0],0);if(!(!c|M[c+20>>2]|!(N[c+5|0]&40))){c=1;if(!(K[b+7|0]&1)){break i}}L[a+20>>1]=0}c=2}return c|0}break c}d=1;if(Ck(b)){break b}}c=O[a+20>>1];if(N[b+4|0]&32){d=0;if((c|0)==2){break c}break b}if((c|0)!=3){break c}d=0;if(M[b+28>>2]==M[a+24>>2]){break b}break c}l:{switch(e-4|0){case 1:K[b|0]=122;break a;case 0:break l;default:break b}}}L[a+20>>1]=0;d=2}return d|0}return 0}function yf(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;g=Na-48|0;Na=g;e=M[a>>2];a:{b:{if(!(N[e+24|0]&16)){if(de(a)){break b}}f=Hc(e,c,d);c:{if(!f){d:{e:{f:{if(N[e+177|0]|N[a+25|0]&4){break f}f=Sc(e+388|0,c);if(!f){if(Eb(c,18309,7)){break f}f=vw(c+7|0);if(!f|!(N[f+5|0]&48)){break f}f=uw(e,c,35232,f,0);if(!f){break f}}i=M[f>>2];M[g+44>>2]=0;if(M[f+20>>2]){break d}h=M[a>>2];e=M[i+4>>2];if((e|0)!=M[i+8>>2]?e:0){break f}e=ub(h,64,0);if(!e){break f}j=_b(h,M[f+4>>2]);M[e>>2]=j;if(j){break e}ib(h,e)}if(b>>>0>1){break b}K[a+17|0]=1;break c}M[f+20>>2]=e;K[e+43|0]=1;M[e+24>>2]=1;b=M[M[h+16>>2]+12>>2];L[e+32>>1]=65535;M[e+60>>2]=b;M[e+28>>2]=M[e+28>>2]|32768;Wg(a,e,_b(h,j));Wg(a,e,0);Wg(a,e,_b(h,M[e>>2]));if(!tp(h,e,f,M[i+8>>2],g+44|0)){break d}b=M[g+44>>2];M[g+32>>2]=b;cb(a,8932,g+32|0);eb(h,b);Kp(h,f)}f=M[f+20>>2];break a}if(!(N[a+25|0]&4)|N[f+43|0]!=1){break a}}b=b&1?1759:14324;if(d){M[g+24>>2]=c;M[g+20>>2]=d;M[g+16>>2]=b;cb(a,6397,g+16|0);break b}M[g+4>>2]=c;M[g>>2]=b;cb(a,7843,g)}f=0}Na=g+48|0;return f}function cF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((b|0)==1){if((Sb(M[c>>2])|0)==5){Yb(a);return}e=Kb(M[c>>2]);M[18595]=0;n=a;C(+e);a=x(1)|0;c=x(0)|0;a:{b:{c:{d:{if((a|0)<1048575|(a|0)<=1048575){d=-1/(e*e);if(e==0){break a}if((a|0)>0|(a|0)>=0){break d}d=(e-e)/0;break a}if(a>>>0>2146435071){break b}b=-1023;if((a|0)!=1072693248){break c}a=1072693248;if(c){break c}d=0;break a}b=-1077;C(+(e*0x40000000000000));a=x(1)|0;c=x(0)|0}a=a+614242|0;m=+((a>>>20|0)+b|0);h=m*.30102999566361177;d=h;z(0,c|0);z(1,(a&1048575)+1072079006|0);f=+B()+-1;i=f*(f*.5);j=f/(f+2);k=j*j;g=k*k;C(+(f-i));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);l=+B();e=l*.4342944818781689;d=d+e;o=d;h=e+(h-d);d=j*(i+(g*(g*(g*.15313837699209373+.22222198432149784)+.3999999999940942)+k*(g*(g*(g*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+(f-l-i);e=o+(h+(d*.4342944818781689+(m*3694239077158931e-28+(d+l)*25082946711645275e-27)))}d=e}Zb(n,d);return}ba(23875,17968,473,17906);I()}function BA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=M[b+80>>2];f=O[m+46>>1];l=M[m+32>>2];h=O[m+24>>1];n=h+d|0;k=M[a+48>>2];M[a+48>>2]=n+k;j=k+1|0;i=M[a+8>>2];d=M[a>>2];l=_b(d,zi(d,l));a:{if(!f){f=0;break a}g=M[b+8>>2];d=0;bb(i,75,0,j,f+k|0);fb(i,c?32:36,g);k=Ub(i,9);o=b,p=lb(i,c?21:24,g,0,j,f),M[o+20>>2]=p;M[(N[M[i>>2]+87|0]?74356:M[i+104>>2]+S(k,20)|0)+8>>2]=M[i+108>>2];while(1){if((d|0)==(f|0)){break a}bb(i,94,g,d,d+j|0);d=d+1|0;continue}}k=f>>>0>h>>>0?f:h;while(1){if((f|0)!=(k|0)){g=M[M[m+52>>2]+(f<<2)>>2];h=f+j|0;d=Hm(a,g,b,f,c,h);b:{if((d|0)==(h|0)){break b}if((n|0)==1){zb(a,j);j=d;break b}$a(i,80,d,h)}d=O[g+12>>1];c:{if(d&1){if(!(N[M[g>>2]+5|0]&16)|!l){break c}K[f+l|0]=65;break c}if(d&256){break c}d=M[M[g>>2]+16>>2];d:{if(N[g+11|0]&8){break d}if(!hf(d)){break d}$a(i,51,f+j|0,M[b+12>>2])}if(M[a+40>>2]){break c}g=f+l|0;e:{if((mh(d,K[g|0])|0)!=65){h=K[g|0];break e}K[g|0]=65;h=65}if(!$z(d,h<<24>>24)){break c}K[g|0]=65}f=f+1|0;continue}break}M[e>>2]=l;return j}function IC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=K[b|0];i=d&255;a:{if((d|0)>=0){g=b;break a}i=i&127;while(1){d=f+1|0;g=d+b|0;e=K[g|0];i=e&127|i<<7;if((e|0)>=0){break a}e=f>>>0<7;f=d;if(e){continue}break}}e=K[g+1|0];d=e&255;f=0;h=g+1|0;b:{if((e|0)>=0){break b}f=d>>>25|0;e=K[g+2|0];d=e&255^d<<7;if((e|0)<0){f=f<<7|d>>>25;e=K[g+3|0];d=e&255^d<<7;if((e|0)<0){f=f<<7|d>>>25;e=K[g+4|0];d=e&255^d<<7^270548992;h=g+4|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=K[g+5|0];d=e&255^d<<7^16384;h=g+5|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=K[g+6|0];d=e&255^d<<7^16384;h=g+6|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=K[g+7|0];d=e&255^d<<7^16384;h=g+7|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=K[g+8|0];d=e&255^d<<7^16384;h=g+8|0;if((e|0)>=0){break b}f=f<<8|d>>>24;d=(N[g+9|0]|d<<8)^32768;h=g+9|0;break b}d=d^2113536;h=g+3|0;break b}d=d&16383;f=0;h=g+2|0}e=h;M[c+12>>2]=i;M[c>>2]=d;M[c+4>>2]=f;f=e+1|0;M[c+8>>2]=f;if(O[a+14>>1]>=i>>>0){L[c+16>>1]=i;a=(f-b|0)+i|0;L[c+18>>1]=a&65532?a:4;return}Yu(a,b,c)}function wd(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=Na-16|0;Na=f;d=ut(a,b,f+12|0);e=M[d+8>>2];a:{if(e){if(!c){b=M[d>>2];g=M[f+12>>2];c=M[d+4>>2];b:{if(c){M[c>>2]=b;break b}M[a+8>>2]=b}if(b){M[b+4>>2]=c}c=M[a+12>>2];if(c){c=c+(g<<3)|0;if((d|0)==M[c+4>>2]){M[c+4>>2]=b}M[c>>2]=M[c>>2]-1}ab(d);b=M[a+4>>2]-1|0;M[a+4>>2]=b;if(b){break a}Bf(a);break a}M[d+12>>2]=b;M[d+8>>2]=c;break a}if(!c){e=0;break a}g=lc(16,0);if(!g){e=c;break a}M[g+8>>2]=c;M[g+12>>2]=b;c=M[a+4>>2]+1|0;M[a+4>>2]=c;c:{if(c>>>0<10){break c}e=M[a>>2];if(c>>>0<=e<<1>>>0){break c}c=c<<4>>>0>1024?128:c<<1;if((c|0)==(e|0)){break c}e=M[18582];if(e){Ra[e|0]()}d=lc(c<<3,0);c=M[18583];if(c){Ra[c|0]()}if(!d){break c}ab(M[a+12>>2]);M[a+12>>2]=d;c=Ra[M[16877]](d)|0;h=c>>>3|0;M[a>>2]=h;c=c&-8;if(c){D(d,0,c)}c=M[a+8>>2];M[a+8>>2]=0;while(1){if(c){e=M[c>>2];tt(a,d+((ao(M[c+12>>2])>>>0)%(h>>>0)<<3)|0,c);c=e;continue}break}i=f,j=(ao(b)>>>0)%P[a>>2]|0,M[i+12>>2]=j}e=0;b=a;a=M[a+12>>2];tt(b,a?a+(M[f+12>>2]<<3)|0:0,g)}Na=f+16|0;return e}function DI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;s=M[M[a>>2]+20>>2];a:{m=gb(M[c>>2]);if(!m){break a}j=Fb(M[c>>2]);n=gb(M[c+4>>2]);if(!n){break a}if(!N[n|0]){vb(a,m,j,-1);return}k=Fb(M[c+4>>2]);r=gb(M[c+8>>2]);if(!r){break a}l=Fb(M[c+8>>2]);f=j+1|0;h=f>>31;g=hh(a,f,h);if(!g){break a}t=k-1|0;u=j-k|0;o=j^-1;v=o>>31;p=l-k|0;w=p>>31;c=0;b=0;while(1){b:{c:{if((c|0)<=(u|0)){d:{d=c+m|0;e=N[d|0];if((e|0)==N[n|0]){if(!Qb(d,n,k)){break d}}K[g+i|0]=e;i=i+1|0;break b}e:{if((k|0)<(l|0)){d=M[s+120>>2];e=d;d=d>>31;h=h+w|0;f=f+p|0;h=f>>>0<p>>>0?h+1|0:h;q=f-1>>>0>e>>>0;e=h-!f|0;if(q&(e|0)>=(d|0)|(d|0)<(e|0)){_g(a);ab(g);return}d=b;b=d+1|0;if(!(b&d)){break e}}d=g;break c}d=h+v|0;e=f+o|0;d=(f>>31)+(e>>>0<o>>>0?d+1|0:d)|0;q=e;e=e+f|0;d=q>>>0>e>>>0?d+1|0:d;d=Ud(g,e,d);if(d){break c}$b(a);ab(g);return}b=j-c|0;if(b){G(g+i|0,c+m|0,b)}b=b+i|0;K[b+g|0]=0;vb(a,g,b,1);break a}if(l){G(d+i|0,r,l)}c=c+t|0;g=d;i=i+l|0}c=c+1|0;continue}}}function Yt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;i=Na-16|0;Na=i;M[b+4>>2]=a;c=M[b>>2];l=(c|0)>0?c:0;a:{while(1){if((h|0)!=(l|0)){k=M[b+12>>2]+S(h,56)|0;d=M[k+48>>2];if(d){e=M[d>>2];f=M[M[e+12>>2]+24>>2];c=Yt(e,M[d+4>>2]);if(c){break a}g=M[d+16>>2];m=g>>31;c=M[e+64>>2];b:{if(c){j=M[e+76>>2];f=M[e+72>>2];break b}c=f;f=e- -64|0;c=At(c,f);M[e+72>>2]=0;M[e+76>>2]=0;if(c){break a}c=M[f>>2];j=0;f=0}M[d+8>>2]=f;M[d+12>>2]=j;M[d+48>>2]=c;c=j+m|0;d=f+g|0;c=d>>>0<f>>>0?c+1|0:c;M[e+72>>2]=d;M[e+76>>2]=c;c=co(k);if(c){break a}}h=h+1|0;continue}break}c=M[b>>2];while(1){if((c|0)>=2){e=c-1|0;d=c;c=M[b>>2]/2|0;c:{if((d|0)>(c|0)){d=e-c<<1;c=d|1;break c}c=M[b+8>>2]+(e<<3)|0;d=M[c>>2];c=M[c+4>>2]}g=M[b+12>>2];f=g+S(d,56)|0;d:{if(!M[f+24>>2]){break d}g=g+S(c,56)|0;if(!M[g+24>>2]){c=d;break d}h=M[b+4>>2];M[i+12>>2]=0;c=(Ra[M[h+40>>2]](h,i+12|0,M[f+32>>2],M[f+20>>2],M[g+32>>2],M[g+20>>2])|0)<=0?d:c}M[M[b+8>>2]+(e<<2)>>2]=c;c=e;continue}break}c=N[M[a+16>>2]+23|0]}Na=i+16|0;return c}function fI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;b=Na-352|0;Na=b;f=M[M[a>>2]+20>>2];d=gb(M[c>>2]);g=gb(M[c+4>>2]);i=M[f+364>>2];M[f+364>>2]=0;Fe(f);if(!(!d|!g)){h=b- -64|0;d=fk(h,d,f,g,0);a:{if(!d){M[b+48>>2]=0;M[b+52>>2]=0;M[b+56>>2]=0;M[b+32>>2]=0;M[b+40>>2]=0;M[b+44>>2]=0;M[b+24>>2]=0;M[b+28>>2]=0;M[b+20>>2]=96;M[b+16>>2]=100;M[b+36>>2]=b+40;M[b+12>>2]=h;d=M[b+316>>2];b:{c:{if(d){if(N[d+43|0]==2){e=M[d+44>>2];M[e+4>>2]=M[e+4>>2]&-2097153;M[b+76>>2]=0;je(h,e,0);d=N[f+87|0]?7:M[b+76>>2];if(d){break b}oc(b+12|0,e);break c}ec(b+12|0,M[d+16>>2]);d=0;while(1){e=M[b+316>>2];if(L[e+34>>1]<=(d|0)){break c}Nb(b+12|0,Tc(e,M[e+4>>2]+S(d,12)|0));d=d+1|0;continue}}d=M[b+320>>2];if(d){e=b+12|0;ec(e,M[d+40>>2]);Nb(e,M[M[b+320>>2]+36>>2]);break c}d=um(b- -64|0);if(d){break b}Tq(b+12|0,M[b+324>>2])}d=Sq(a,b+40|0,g,0,0)}tm(f,M[b+40>>2]);if(!d){break a}}if(!((d|0)!=1|(M[f+32>>2]&268435457)!=1)){He(a,M[c+4>>2]);break a}ee(a,d)}dk(b- -64|0)}M[f+364>>2]=i;Na=b+352|0}function Lp(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{b:{c=Ij(a)&2047;e=Ij(5551115123125783e-32);if(c-e>>>0<Ij(512)-e>>>0){h=c;break b}if(c>>>0<e>>>0){return a+1}if(Ij(1024)>>>0>c>>>0){break b}C(+a);e=x(1)|0;b=0;if(!(x(0)|0)&(e|0)==-1048576){break a}if(Ij(Infinity)>>>0<=c>>>0){return a+1}if((e|0)<0){return hx(12882297539194267e-247)}return hx(3105036184601418e216)}b=R[7369];f=a*R[7368]+b;b=f-b;a=b*R[7371]+(b*R[7370]+a);b=a*a;g=b*b*(a*R[7375]+R[7374]);b=b*(a*R[7373]+R[7372]);C(+f);x(1)|0;c=x(0)|0;d=c<<4&2032;a=g+(b+(R[d+59056>>3]+a));d=d+59064|0;e=0+M[d>>2]|0;d=M[d+4>>2]+(c<<13)|0;d=e>>>0<i>>>0?d+1|0:d;if(!h){c:{if(!(c&-2147483648)){z(0,e|0);z(1,d-1058013184|0);b=+B();a=(b*a+b)*5486124068793689e288;break c}z(0,e|0);z(1,d+1071644672|0);b=+B();f=b*a;a=f+b;if(a<1){c=Na-16|0;M[c+8>>2]=0;M[c+12>>2]=1048576;R[c+8>>3]=R[c+8>>3]*22250738585072014e-324;g=a+1;a=g+(f+(b-a)+(a+(1-g)))+-1;a=a==0?0:a}a=a*22250738585072014e-324}return a}z(0,e|0);z(1,d|0);b=+B();b=b*a+b}return b}function jy(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;i=Na-16|0;Na=i;a:{if(M[a>>2]){break a}j=M[b+24>>2]+2|0;g=Bb(ZJ(j,j>>31,14,0),Qa);if(!g){M[a>>2]=7;break a}f=Tb(b,22,i+4|0,0);if(f){ab(g);M[a>>2]=f;break a}k=M[i+4>>2];Jb(k,1,0,0);b:{if((Db(k)|0)==100){l=Ye(k,0);f=0;c:{m=Wd(k,0);if(!m|K[(l+m|0)-1|0]<0){break c}while(1){if((f|0)>=(j|0)|(h|0)>=(m|0)){break c}n=Ic(h+l|0,i+8|0);M[(f<<2)+g>>2]=M[i+8>>2];f=f+1|0;h=h+n|0;continue}}h=(f|0)>(j|0)?f:j;while(1){if((f|0)==(h|0)){break b}M[(f<<2)+g>>2]=0;f=f+1|0;continue}}f=j<<2;if(!f){break b}D(g,0,f)}f=wb(k);if(f){ab(g);M[a>>2]=f;break a}k=(j<<2)+g|0;f=M[g>>2];h=f+e|0;M[g>>2]=(e|0)<0?f>>>0>=0-e>>>0?h:0:h;f=0;while(1){if((f|0)<=M[b+24>>2]){e=f<<2;f=f+1|0;h=(f<<2)+g|0;l=M[e+c>>2]+M[h>>2]|0;e=l-M[d+e>>2]|0;M[h>>2]=e>>>0<=l>>>0?e:0;continue}break}Nx(j,g,k,i+8|0);b=Tb(b,23,i+4|0,0);if(b){ab(g);M[a>>2]=b;break a}b=M[i+4>>2];Jb(b,1,0,0);jg(b,2,k,M[i+8>>2],0);Db(b);o=a,p=wb(b),M[o>>2]=p;Ge(b,1);ab(g)}Na=i+16|0}function ty(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{while(1){if(M[e>>2]|!b){break a}b:{f=M[b>>2];if((f|0)==5){d=c;l=M[c>>2];c=M[M[b+20>>2]+64>>2];M[d>>2]=l+c;o=(c|0)>0?c:0;while(1){c=M[b+20>>2];if((m|0)==(o|0)){break b}c=c+S(m,24)|0;l=c;n=M[c+80>>2];i=M[c+76>>2];k=M[c+72>>2];g=tc(64);c:{if(!g){M[c+92>>2]=0;h=7;break c}f=M[a>>2];d:{e:{if(!n){break e}h=7;j=0;c=1;d=1;while(1){f:{if(!j){if(M[f+260>>2]>(d|0)){break f}c=0}d=1;j=i+1|0;while(1){if(c){break d}if(M[f+260>>2]<=(d|0)){break e}c=0;g:{if((j|0)!=M[M[f+264>>2]+S(d,24)>>2]){break g}c=1;h=mi(f,M[a+20>>2],d,-2,k,i,1,0,g);if(h){break g}h=Ry(f,M[a+20>>2],0,-2,k,i,0,0,g)}d=d+1|0;continue}}j=0;if(M[M[f+264>>2]+S(d,24)>>2]==(i|0)){h=mi(f,M[a+20>>2],d,-2,k,i,0,0,g);M[g+44>>2]=1;j=1}d=d+1|0;continue}}h=mi(f,M[a+20>>2],0,-2,k,i,n,0,g);M[g+44>>2]=!n}M[l+92>>2]=g;m=m+1|0;if(!h){continue}}break}M[e>>2]=h;return}M[d>>2]=M[d>>2]+((f|0)==4);ty(a,M[b+12>>2],c,d,e);b=M[b+16>>2];continue}break}M[c+44>>2]=-1}}function cr(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=Na-16|0;Na=g;j=(M[b+8>>2]|M[b>>2])^-1;k=(M[b+12>>2]|M[b+4>>2])^-1;e=M[a+24>>2];h=M[a+20>>2];while(1){if((h|0)>0){d=M[e+40>>2];f=M[e+44>>2];a:{if(j&d|k&f|(!(d&M[b+8>>2]|f&M[b+12>>2])|N[e+10|0]&2)){break a}d=O[b+44>>1];while(1){if(d){d=d-1|0;f=M[M[b+52>>2]+(d<<2)>>2];if(!f){continue}if((e|0)==(f|0)){break a}f=M[f+16>>2];if((f|0)<0|(M[a+24>>2]+S(f,48)|0)!=(e|0)){continue}break a}break}Om(M[M[a>>2]>>2]);b:{if(M[b+8>>2]!=M[e+40>>2]|M[b+12>>2]!=M[e+44>>2]){break b}if(!(N[e+12|0]&63)){if(N[(M[M[a>>2]+4>>2]+S(N[b+16|0],48)|0)+20|0]&72){break b}}M[b+40>>2]=M[b+40>>2]|8388608}d=O[b+22>>1];f=L[e+8>>1];if((f|0)<=0){L[b+22>>1]=d+f;break a}L[b+22>>1]=d-1;if(!(N[e+12|0]&130)){break a}d=M[M[e>>2]+16>>2];M[g+12>>2]=0;d=gf(d,g+12|0,0);d=d?M[g+12>>2]+1>>>0<3?10:20:20;if(d>>>0<=(i&65535)>>>0){break a}L[e+10>>1]=O[e+10>>1]|8192;i=d}e=e+48|0;h=h-1|0;continue}break}a=c-(i&65535)|0;if((a|0)<L[b+22>>1]){L[b+22>>1]=a}Na=g+16|0}function Fd(a,b){var c=0,d=0,e=0,f=0,g=0;f=M[a>>2];a:{b:while(1){c=b;d=0;if(!c){break a}b=N[c|0];if((b|0)==176){b=N[c+2|0]}c:{d:{e:{f:{g:{h:{i:{b=b&255;switch(b-168|0){case 0:break g;case 1:case 3:case 4:case 6:case 7:case 8:break d;case 2:break h;case 5:break f;case 9:break e;default:break i}}if((b|0)==36){break f}if((b|0)==78){break g}if((b|0)!=114){break d}c=Un(a,N[f+84|0],0,M[c+8>>2]);break c}if(!M[c+44>>2]){break d}}b=L[c+32>>1];d=0;if((b|0)<0){break a}c=wf(f,N[f+84|0],eg(M[M[c+44>>2]+4>>2]+S(b,12)|0),0);break c}b=M[c+12>>2];continue}b=M[M[c+20>>2]+8>>2];continue}e=M[c+4>>2];d=0;if(!(e&512)){break a}b=M[c+12>>2];if(N[b+5|0]&2?b:0){continue}d=M[c+16>>2];b=d;if(e&4096){continue}e=M[c+20>>2];if(N[f+87|0]|!e){continue}c=0;b=M[e>>2];g=(b|0)>0?b:0;e=e+8|0;while(1){if((c|0)==(g|0)){b=d;continue b}b=c<<4;c=c+1|0;b=M[b+e>>2];if(!(N[b+5|0]&2)){continue}break}continue}break}d=0;if(!c){break a}if(M[c+12>>2]){return c}d=Un(a,N[M[a>>2]+84|0],c,M[c>>2])?c:0}return d}function Rl(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;f=Na-16|0;Na=f;h=M[a+28>>2];M[f+12>>2]=0;M[f+4>>2]=0;b=M[a+16>>2];c=M[a+20>>2];if(!(!h|!(b|c))){b=b+1|0;c=b?c:c+1|0;M[a+16>>2]=b;M[a+20>>2]=c}c=M[a+8>>2];d=M[a+4>>2];a:{if((c|0)>=(d|0)){c=0;M[a>>2]=0;break a}g=M[a>>2];if(h){e=c+g|0;b=K[e|0];b:{if((b|0)<0){b=yc(e,f+12|0);break b}M[f+12>>2]=b;b=1}c=b+c|0;M[a+8>>2]=c}e=c+g|0;b=K[e|0];c:{if((b|0)<0){b=yc(e,f+8|0);break c}M[f+8>>2]=b;b=1}b=b+c|0;M[a+8>>2]=b;c=267;g=M[f+12>>2];if((g|0)>(h|0)){break a}b=d-b|0;d=M[f+8>>2];if((b|0)<(d|0)|!d){break a}e=d+g|0;fe(a+24|0,e,f+4|0);c=M[f+4>>2];if(c){break a}c=0;b=M[a+24>>2];if(!b){break a}if(d){G(b+g|0,M[a>>2]+M[a+8>>2]|0,d)}M[a+28>>2]=e;e=d+M[a+8>>2]|0;M[a+8>>2]=e;if(M[a+16>>2]|M[a+20>>2]){break a}c=M[a>>2]+e|0;d=K[c|0];d:{if((d|0)<0){c=yc(c,a+40|0);d=M[a+40>>2];e=M[a+8>>2];break d}M[a+40>>2]=d;c=1}b=c+e|0;M[a+8>>2]=b;c=267;if((M[a+4>>2]-b|0)<(d|0)){break a}M[a+8>>2]=b+d;M[a+36>>2]=b+M[a>>2];c=0}Na=f+16|0;return c}function wD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=5130;a:{f=M[a+36>>2];if(!f){break a}g=M[f>>2];if(!g){break a}h=b+c|0;i=(1<<h)+(-1<<b)|0;g=g+36|0;b:{c:{d:{e:{f:{g:{if(d&1){e=O[f+10>>1];if((e|O[f+12>>1])&i){break g}}e=0;switch(d-6|0){case 0:break e;case 4:break f;default:break a}}h:{if(!(d&4)){break h}d=g+(b<<2)|0;h=M[d>>2];if((h|0)<2){break h}M[d>>2]=h-1;L[f+10>>1]=e&(i^-1);break b}e=ij(a,2,b+120|0,c);if(e){break a}a=c<<2;if(a){D(g+(b<<2)|0,0,a)}a=i^-1;L[f+10>>1]=a&O[f+10>>1];L[f+12>>1]=a&O[f+12>>1];return 0}d=(b|0)>(h|0)?b:h;e=b;while(1){if((d|0)!=(e|0)){h=e<<2;e=e+1|0;if(!M[g+h>>2]){continue}break d}break}e=ij(a,1,b+120|0,c);if(e){break a}L[f+12>>1]=O[f+12>>1]|i;while(1){if((b|0)==(d|0)){break b}M[g+(b<<2)>>2]=-1;b=b+1|0;continue}}d=O[f+10>>1];if(d&i){break a}g=g+(b<<2)|0;e=M[g>>2];if((e|0)>=0){break c}}return 5}if(!e){e=ij(a,0,b+120|0,c);if(e){break a}e=M[g>>2];d=O[f+10>>1]}L[f+10>>1]=d|i;M[g>>2]=e+1}return 0}return e|0}function qj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=Na-304|0;Na=c;d=b;a:{while(1){if((f|0)!=2){M[c+16>>2]=0;while(1){d=_h(d,c+16|0)+d|0;e=M[c+16>>2];if((e&-2)==184){continue}break}if((e|0)!=N[f+30779|0]){ae(a,1,9107,0);a=1;break a}else{f=f+1|0;continue}}break}f=M[a+404>>2];if(!(M[f+12>>2]?0:f)){Yc(a,_c(157358));a=_c(157360);break a}d=M[f+4>>2];g=c+16|0;xm(g,a);K[c+181|0]=1;K[c+240|0]=1;h=N[a+177|0];e=0;K[a+177|0]=0;L[c+176>>1]=1;b:{if(!pj(g,b)){c:{if(M[d+4>>2]){break c}b=M[c+268>>2];M[d+4>>2]=M[b+4>>2];xb(a,M[b+52>>2]);e=O[b+34>>1];L[d+36>>1]=e;L[d+34>>1]=e;M[d+28>>2]=M[d+28>>2]|M[b+28>>2]&640;e=0;M[b+4>>2]=0;L[b+34>>1]=0;if(!(!(N[b+28|0]&128)|!M[M[M[M[f>>2]+4>>2]>>2]+52>>2])){e=O[qc(b)+50>>1]!=1}g=M[b+8>>2];if(!g){break c}M[d+8>>2]=g;M[b+8>>2]=0;M[g+12>>2]=d}M[f+12>>2]=1;break b}b=M[c+20>>2];M[c>>2]=b;ae(a,1,b?8932:0,c);eb(a,M[c+20>>2]);e=1}K[c+240|0]=0;b=M[c+24>>2];if(b){Mf(b)}Id(a,M[c+268>>2]);qi(c+16|0);K[a+177|0]=h;a=qd(a,e)}Na=c+304|0;return a}function hI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=Na-336|0;Na=b;d=M[M[a>>2]+20>>2];j=gb(M[c>>2]);l=gb(M[c+4>>2]);g=sb(M[c+16>>2]);h=M[d+32>>2];m=gb(M[c+20>>2]);f=sb(M[c+24>>2]);n=M[d+364>>2];M[d+364>>2]=0;if(!(!j|!l)){e=M[d+32>>2];i=M[d+36>>2];if(f){M[d+32>>2]=e&-1610612737;M[d+36>>2]=i}k=b+48|0;g=fk(k,j,d,l,g);f=M[d+36>>2];M[d+32>>2]=M[d+32>>2]|e&1610612736;M[d+36>>2]=f;i=1;a:{b:{if(g){break b}e=0;g=e;c:{h=h&67108864;if(e|h){break c}e=M[b+300>>2];if(!e|N[e+43|0]!=2){break c}M[b+40>>2]=0;M[b+44>>2]=0;M[b+32>>2]=0;M[b+36>>2]=0;M[b+24>>2]=0;M[b+28>>2]=0;M[b+16>>2]=0;M[b+20>>2]=0;M[b+12>>2]=k;je(k,M[e+44>>2],b+12|0);i=M[b+88>>2]!=0&M[b+60>>2]!=0;break b}f=M[b+308>>2];if(!f){break a}e=d;if(!(g|h)){if(um(b+48|0)){break b}f=M[b+308>>2]}if((Mb(e,M[f+24>>2])|0)!=(Hg(d,j)|0)){break a}Ac(a,1);break a}if(!i|!m|(M[d+32>>2]&268435457)==1){break a}Rq(a,m,M[c+8>>2],M[c+12>>2],b+48|0)}dk(b+48|0)}M[d+364>>2]=n;Na=b+336|0}function Dt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=M[d+56>>2];g=k+N[d+9|0]|0;f=N[g+5|0]<<8|N[g+6|0];h=M[d+52>>2];i=M[h+40>>2];f=i>>>0>=f>>>0?f:0;n=f+k|0;o=M[M[h>>2]+224>>2];l=M[d+64>>2];h=i-f|0;if(h){G(f+o|0,n,h)}p=a+40|0;h=i+k|0;while(1){f=e;e=e+1|0;if(M[(f<<2)+p>>2]<=(b|0)){continue}break}s=a+16|0;t=b+c|0;i=h;while(1){e=f<<2;u=e+p|0;q=M[e+s>>2];a:{while(1){e=M[M[a+8>>2]+(b<<2)>>2];m=O[M[a+12>>2]+(b<<1)>>1];j=e+m|0;b:{c:{if(!(e>>>0<n>>>0|e>>>0>=h>>>0)){if(h>>>0>=j>>>0){break c}return db(78380)}if(j>>>0<=q>>>0|e>>>0>=q>>>0){break b}return db(78385)}e=(e-k|0)+o|0}i=i-m|0;j=i-k|0;r=j<<8|(j&65280)>>>8;K[l|0]=r;K[l+1|0]=r>>>8;l=l+2|0;if(l>>>0>i>>>0){return db(78391)}if(m){G(i,e,m)}b=b+1|0;if((t|0)<=(b|0)){break a}if(M[u>>2]>(b|0)){continue}break}f=f+1|0;continue}break}K[d+12|0]=0;L[d+24>>1]=c;K[g+1|0]=0;K[g+2|0]=0;K[g+3|0]=N[d+25|0];a=N[d+24|0];K[g+7|0]=0;K[g+6|0]=j;K[g+5|0]=j>>>8;K[g+4|0]=a;return 0}function Ip(a){var b=0,c=0,d=0,e=0,f=0,g=0;C(+a);e=x(1)|0;x(0)|0;d=e&2147483647;if(d>>>0>=1141899264){C(1.5707963267948966);e=x(1)|0;d=x(0)|0;C(+a);b=x(1)|0;x(0)|0;z(0,d|0);z(1,e&2147483647|b&-2147483648);g=+B();C(+a);b=x(1)|0;e=x(0)|0;b=b&2147483647;return(b|0)==2146435072&(e|0)!=0|b>>>0>2146435072?a:g}a:{b:{if(d>>>0<=1071382527){b=-1;if(d>>>0>=1044381696){break b}break a}a=U(a);if(d>>>0<=1072889855){if(d>>>0<=1072037887){a=(a+a+-1)/(a+2);b=0;break b}a=(a+-1)/(a+1);b=1;break b}if(d>>>0<=1073971199){a=(a+-1.5)/(a*1.5+1);b=2;break b}a=-1/a;b=3}f=a*a;c=f*f;g=c*(c*(c*(c*(c*-.036531572744216916+-.058335701337905735)+-.0769187620504483)+-.11111110405462356)+-.19999999999876483);f=f*(c*(c*(c*(c*(c*.016285820115365782+.049768779946159324)+.06661073137387531)+.09090887133436507)+.14285714272503466)+.3333333333333293);if(d>>>0<=1071382527){return a-a*(g+f)}b=b<<3;a=R[b+63344>>3]-(a*(g+f)-R[b+63376>>3]-a);a=(e|0)<0?-a:a}return a}function Sz(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=Na-48|0;Na=i;l=M[a>>2];m=Cb(a);if((h|0)<0){o=$a(m,49,N[e+24|0],0)}n=e+36|0;while(1){if((j|0)<M[e+20>>2]){k=ce(a,k,ob(a,54,Xq(a,c,g,(d?L[M[d+4>>2]+(j<<1)>>1]:65535)<<16>>16),wc(l,60,M[M[M[e>>2]+4>>2]+S(L[(f?(j<<2)+f|0:n)>>1],12)>>2])));j=j+1|0;continue}break}if(!(M[e>>2]!=(c|0)|(h|0)<=0)){a:{b:{if(N[c+28|0]&128){f=0;j=0;while(1){if(O[d+50>>1]<=j>>>0){break b}n=f;f=L[M[d+4>>2]+(j<<1)>>1];f=ce(a,n,ob(a,45,Xq(a,c,g,f),wc(l,60,M[M[c+4>>2]+S(f,12)>>2])));j=j+1|0;continue}}f=Xq(a,c,g,-1);g=M[b+24>>2];d=wc(l,168,0);if(d){L[d+32>>1]=65535;M[d+28>>2]=g;M[d+44>>2]=c}c=ob(a,53,f,d);break a}c=ob(a,19,f,0)}k=ce(a,k,c)}M[i+44>>2]=0;M[i+36>>2]=0;M[i+40>>2]=0;M[i+28>>2]=0;M[i+32>>2]=0;M[i+20>>2]=0;M[i+24>>2]=0;M[i+16>>2]=b;M[i+12>>2]=a;id(i+12|0,k);c:{if(M[a+40>>2]){break c}a=jf(a,b,k,0,0,0,0,0);$a(m,158,N[e+24|0],h);if(!a){break c}Cd(a)}kb(l,k);if(o){gn(m,o)}Na=i+48|0}function Ro(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;d=Na-32|0;Na=d;K[b|0]=0;e=Ra[M[M[a>>2]+24>>2]](a,d+16|0)|0;a:{if(e){break a}f=M[d+16>>2];h=f>>>0<16;g=M[d+20>>2];if(h&(g|0)<=0|(g|0)<0){break a}e=sf(a,f-16|0,g-h|0,d+28|0);if(e){break a}e=0;f=M[d+28>>2];if(f>>>0>=c>>>0|!f){break a}c=M[d+16>>2];g=c-16|0;h=M[d+20>>2];i=h-(c>>>0<16)|0;if((i|0)<0){g=1}else{g=(i|0)<=0&f>>>0>g>>>0}if(g){break a}e=sf(a,c-12|0,h-(c>>>0<12)|0,d+12|0);if(e){break a}c=M[d+16>>2];e=Ra[M[M[a>>2]+8>>2]](a,d+4|0,8,c-8|0,M[d+20>>2]-(c>>>0<8)|0)|0;if(e){break a}e=0;if((N[d+4|0]|N[d+5|0]<<8|(N[d+6|0]<<16|N[d+7|0]<<24))!=-117058087|(N[d+8|0]|N[d+9|0]<<8|(N[d+10|0]<<16|N[d+11|0]<<24))!=-681336544){break a}c=M[d+16>>2];g=c-f|0;e=Ra[M[M[a>>2]+8>>2]](a,b,f,g-16|0,(M[d+20>>2]-(c>>>0<f>>>0)|0)-(g>>>0<16)|0)|0;if(e){break a}a=0;c=M[d+12>>2];while(1){if((a|0)!=(f|0)){c=c-K[a+b|0]|0;a=a+1|0;continue}break}e=0;a=(c?0:f)+b|0;K[a|0]=0;K[a+1|0]=0}Na=d+32|0;return e}function tE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=Na-128|0;Na=d;a:{b:{switch(b-1|0){default:if((b|0)==9){break a}break;case 0:case 2:break a;case 1:break b}}M[d+120>>2]=c+4;e=M[c>>2]}c:{d:{if(b>>>0>16){break d}if(!(1<<b&110592)){if((b|0)!=9){if((b|0)!=14){break d}M[d+16>>2]=e;M[d+20>>2]=0;a=Bc(ca(a|0,14,d+16|0)|0);break c}M[d+48>>2]=d+120;M[d+52>>2]=0;b=ca(a|0,16,d+48|0)|0;if((b|0)==-28){M[d+32>>2]=e;M[d+36>>2]=0;b=ca(a|0,9,d+32|0)|0}if(b){a=Bc(b);break c}a=M[d+124>>2];a=M[d+120>>2]==2?0-a|0:a;break c}M[d+112>>2]=e;M[d+116>>2]=0;a=Bc(ca(a|0,b|0,d+112|0)|0);break c}if((b|0)!=1030){M[d>>2]=(b|0)==4?e|32768:e;M[d+4>>2]=0;a=Bc(ca(a|0,b|0,d|0)|0);break c}M[d+96>>2]=e;M[d+100>>2]=0;b=ca(a|0,1030,d+96|0)|0;if((b|0)!=-28){a=Bc(b);break c}M[d+80>>2]=0;M[d+84>>2]=0;b=ca(a|0,1030,d+80|0)|0;if((b|0)!=-28){if((b|0)>=0){fa(b|0)|0}a=Bc(-28);break c}M[d+64>>2]=e;M[d+68>>2]=0;a=Bc(ca(a|0,0,d- -64|0)|0)}Na=d+128|0;return a|0}function YI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=M[c>>2];b=O[g+16>>1];d=b&31;if((b&63)>>>0>=32){b=1<<d;e=0}else{e=1<<d;b=e-1&1>>>32-d}d=b;i=e;b=O[M[c+4>>2]+16>>1];e=b&31;if((b&63)>>>0>=32){b=1<<e;f=0}else{f=1<<e;b=f-1&1>>>32-e}f=i|f;b=b|d;if(!(f&-1431655766|b&-1431655766)){e=Fb(g);g=1;a:{b:{h=Fb(M[c+4>>2]);if((h|0)<=0){c=0;break b}c:{d:{e:{f:{g:{h:{d=b&-65537;i=d;k=f&-65538;i:{if(!(d|k)){b=od(M[c>>2]);d=od(M[c+4>>2]);break i}d=M[c>>2];if(f&65537|b&65536){break h}b=gb(d);d=gb(M[c+4>>2])}if(d){break e}break g}j=yj(d);b=gb(j);if(b){break f}}c=0;break c}e=Fb(j);c=yj(M[c+4>>2]);d=gb(c);if(!d){break c}h=Fb(c);break d}if(!e){c=0;break d}c=0;if(!b){break c}}f=N[d|0];j:while(1){if((e|0)<(h|0)){g=0;break b}k:{if(N[b|0]!=(f|0)){break k}if(Qb(b,d,h)){break k}break b}g=g+1|0;while(1){b=b+1|0;e=e-1|0;if(!(i|k)){continue j}if(K[b|0]<-64){continue}break}continue}}$b(a);break a}Ac(a,g)}Xc(j);Xc(c)}}function JE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if((b|0)==1){d=Xg(M[c>>2]);if((d|0)!=5){a:{b:{c:{a=Ib(a,64);d:{if(!M[a+56>>2]){b=Jl(12);M[a+56>>2]=b;if((d|0)!=1){break c}M[b+4>>2]=435;M[a+48>>2]=0;M[a+52>>2]=0;b=M[a+20>>2];d=M[a+16>>2]+1|0;b=d?b:b+1|0;M[a+16>>2]=d;M[a+20>>2]=b;break d}b=M[a+20>>2];d=M[a+16>>2]+1|0;b=d?b:b+1|0;M[a+16>>2]=d;M[a+20>>2]=b;if(M[a+48>>2]|M[a+52>>2]){break b}}b=sb(M[c>>2]);d=Qa;c=Jl(8);M[c>>2]=b;M[c+4>>2]=d;break a}M[a+48>>2]=1;M[a+52>>2]=0;M[b+4>>2]=436;b=M[a+20>>2];d=M[a+16>>2]+1|0;b=d?b:b+1|0;M[a+16>>2]=d;M[a+20>>2]=b}e=Kb(M[c>>2]);c=Jl(8);R[c>>3]=e}a=M[a+56>>2];b=M[a+4>>2];while(1){e:{d=M[a>>2];if(!d){b=Jl(24);M[b+16>>2]=1;M[b+20>>2]=0;M[b+8>>2]=c;M[a>>2]=b;break e}d=Ra[b|0](M[d+8>>2],c)|0;if(d){a=M[a>>2]+((d|0)<=0?4:0)|0;continue}else{a=M[a>>2];d=M[a+16>>2];b=M[a+20>>2];d=d+1|0;b=d?b:b+1|0;M[a+16>>2]=d;M[a+20>>2]=b;Ie(c)}}break}}return}ba(23875,17968,1418,9993);I()}function ns(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=Na+-64|0;Na=d;a:{if(N[a+16|0]){break a}g=M[a>>2];f=M[a+8>>2];while(1){c=b;b=M[b+52>>2];if(b){continue}break}k=M[c+32>>2];h=M[c+28>>2];K[a+16|0]=1;b=M[g+32>>2];_m(f,M[h>>2]);j=h+8|0;l=b&68;m=b&4;b=0;while(1){c=M[h>>2];if((b|0)<(c|0)){i=(b<<4)+j|0;c=M[i>>2];e=M[i+4>>2];b:{if(!(!e|N[i+9|0]&3)){Nf(f,b,0,e,-1);break b}if(!(!(n|l)|N[c|0]!=168)){e=M[c+44>>2];c:{d:{c=L[c+32>>1];if((c|0)>=0){break d}c=L[e+32>>1];if((c|0)>=0){break d}c=15195;break c}c=M[M[e+4>>2]+S(c,12)>>2]}if(n|m){e=M[e>>2];M[d+20>>2]=c;M[d+16>>2]=e;Nf(f,b,0,tb(g,6429,d+16|0),5);break b}Nf(f,b,0,c,-1);break b}e:{if(!e){M[d>>2]=b+1;c=tb(g,16709,d);break e}c=_b(g,e)}Nf(f,b,0,c,5)}b=b+1|0;continue}break}f=M[a+8>>2];b=0;M[d+40>>2]=0;M[d+28>>2]=a;M[d+32>>2]=k;while(1){if((b|0)>=(c|0)){break a}Nf(f,b,1,Km(d+28|0,M[(b<<4)+j>>2]),-1);b=b+1|0;c=M[h>>2];continue}}Na=d- -64|0}function ac(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=M[a+20>>2];if(!(!(N[a+28|0]&4)|P[b+28>>2]<P[a+24>>2])){if(!M[b+104>>2]){return 0}return em(a)}c=M[b+44>>2];if(!c){if(P[b+156>>2]>P[b+168>>2]){h=Na-16|0;Na=h;d=M[a+20>>2];K[d+21|0]=N[d+21|0]|4;i=M[a+24>>2];c=_J(M[d+156>>2],0,M[d+168>>2],M[d+172>>2]);e=i-1&0-c;b=M[d+28>>2];if(b>>>0<i>>>0){c=i-e|0}else{c=b>>>0<c+e>>>0?b-e|0:c}i=e+1|0;while(1){if(!((c|0)<=(f|0)|g)){a:{b:{c:{b=f+i|0;if((b|0)!=M[a+24>>2]){if(Vv(M[d+60>>2],b)){break c}}g=0;if((b|0)==M[d+164>>2]){break a}g=Ra[M[d+220>>2]](d,b,h+12|0,0)|0;if(g){break a}g=fz(M[h+12>>2]);e=M[h+12>>2];break b}e=Qh(d,b);M[h+12>>2]=e;g=0;if(!e){break a}}b=O[e+28>>1];xg(e);j=b&8?1:j}f=f+1|0;continue}break}d:{if(!j|g){break d}f=0;a=(c|0)>0?c:0;while(1){if((a|0)==(f|0)){break d}c=Qh(d,f+i|0);if(c){L[c+28>>1]=O[c+28>>1]|8;xg(c)}f=f+1|0;continue}}K[d+21|0]=N[d+21|0]&251;Na=h+16|0;return g}c=fz(a)}return c}function QJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;e=1;c=M[b+4>>2];a:{if(c&1|(O[a+22>>1]?c&2:0)){break a}b:{c:{d:{e:{f:{g:{d=N[b|0];switch(d-43|0){case 2:case 3:case 8:case 9:break a;case 0:case 1:break f;case 4:case 5:break b;case 6:break d;case 7:break e;case 10:case 11:case 12:case 13:case 14:case 15:break c;default:break g}}h:{switch(d-168|0){default:if((d|0)!=158){break b}break a;case 4:case 7:case 9:break a;case 1:case 2:case 3:case 5:case 6:case 8:break b;case 0:break h}}if(M[a+24>>2]!=M[b+28>>2]){break a}L[a+20>>1]=1;return 2}hB(a,M[b+12>>2],M[b+16>>2]);return 1}if(c&4096|M[M[b+20>>2]>>2]<=0){break a}Nb(a,M[b+12>>2]);return 1}Nb(a,M[b+12>>2]);c=a;a=M[b+20>>2];hB(c,M[a+8>>2],M[a+24>>2]);return 1}a=M[b+16>>2];b=M[b+12>>2];i:{if(N[b|0]!=168){break i}b=M[b+44>>2];if(!b){break i}if(N[b+43|0]==1){break a}}if(N[a|0]!=168){break b}a=M[a+44>>2];if(!a){break b}if(N[a+43|0]==1){break a}}e=0}return e|0}function Ct(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Na-96|0;Na=f;c=b+c|0;o=(b|0)>(c|0)?b:c;k=M[a+56>>2];m=M[M[a+52>>2]+40>>2];p=k+m|0;q=(N[a+10|0]+(N[a+9|0]+k|0)|0)+8|0;while(1){a:{b:{c:{d:{if((b|0)==(o|0)){c=0;b=(e|0)>0?e:0;while(1){if((b|0)==(c|0)){break d}d=c<<2;e=M[d+(f+48|0)>>2];ho(a,e&65535,M[d+f>>2]-e&65535);c=c+1|0;continue}}c=M[M[d+8>>2]+(b<<2)>>2];if(c>>>0<q>>>0|c>>>0>=p>>>0){break a}h=c-k&65535;i=h+O[M[d+12>>2]+(b<<1)>>1]|0;c=0;j=(e|0)>0?e:0;e:{while(1){if((c|0)==(j|0)){break e}g=c<<2;n=g+(f+48|0)|0;if(M[n>>2]==(i|0)){M[n>>2]=h;break b}c=c+1|0;g=f+g|0;if(M[g>>2]!=(h|0)){continue}break}M[g>>2]=i;break b}c=0;if((e|0)>=10){while(1){if((c|0)!=(e|0)){j=c<<2;g=M[j+(f+48|0)>>2];ho(a,g&65535,M[f+j>>2]-g&65535);c=c+1|0;continue}break}e=0}c=e<<2;M[c+f>>2]=i;M[c+(f+48|0)>>2]=h;if(i>>>0<=m>>>0){break c}l=0}Na=f+96|0;return l}e=e+1|0}l=l+1|0}b=b+1|0;continue}}function aC(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Na-16|0;Na=g;e=M[a+24>>2];j=M[M[e>>2]>>2];m=Hg(j,M[e+40>>2]);k=M[b+32>>2];a:{if(!k){break a}n=e+4|0;l=k+8|0;c=l;b:{while(1){if(M[k>>2]>(f|0)){c:{if(N[e+36|0]){break c}d=N[c+13|0]|N[c+14|0]<<8;if(d&4){break c}i=N[c+15|0];d:{if(i&1){break d}h=M[c+44>>2];if(!h){break d}if((Hg(j,h)|0)!=(m|0)){a=M[e>>2];b=M[e+48>>2];c=M[e+44>>2];M[g+8>>2]=h;M[g>>2]=c;M[g+4>>2]=b;cb(a,6820,g);break b}eb(j,h);d=N[c+13|0]|N[c+14|0]<<8|1024;K[c+13|0]=d;K[c+14|0]=d>>>8;i=N[c+15|0]|2;K[c+15|0]=i}h=M[e+32>>2];K[c+15|0]=i|1;d=d|256;K[c+13|0]=d;K[c+14|0]=d>>>8;M[c+44>>2]=h}d=S(f,48)+l|0;if(!(N[d+14|0]&8)){if(Nb(n,M[d+40>>2])){break b}}c=c+48|0;f=f+1|0;continue}break}c=0;if(!M[b+64>>2]){break a}f=0;while(1){e=M[b+64>>2];if(M[e>>2]<=(f|0)){break a}d=S(f,24);f=f+1|0;if(!oc(a,M[(e+d|0)+20>>2])){continue}break}}c=2}Na=g+16|0;return c|0}function my(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Na-16|0;Na=e;M[e+4>>2]=b;M[e+12>>2]=b;f=Tb(a,7,e+8|0,e+12|0);g=M[e+8>>2];a:{b:{c:{if(f){break c}j=(Db(g)|0)!=100;if(j){break b}k=dq(a,g);f=hq(a,1,k,dd(g,0),Qa);h=1;while(1){if(f){break c}if(M[a+24>>2]<(h|0)){break b}f=0;i=h-1|0;if(!N[i+M[a+32>>2]|0]){f=gq(a,k,ff(g,h),-1,(i<<2)+d|0);i=Wd(g,h);l=(M[a+24>>2]<<2)+d|0;M[l>>2]=i+M[l>>2]}h=h+1|0;continue}}wb(g);M[e>>2]=f;break a}f=wb(g);M[e>>2]=f;if(f|j){break a}M[e+12>>2]=b;d:{if(M[a+40>>2]){M[e>>2]=0;M[c>>2]=M[c>>2]-1;break d}f=1;b=Tb(a,1,e+8|0,e+12|0);if(b){M[e>>2]=b;break a}b=M[e+8>>2];if((Db(b)|0)==100){f=!Md(b,0)}b=wb(b);M[e>>2]=b;if(b){break a}if(!f){m=e,n=ny(a,1),M[m>>2]=n;M[c>>2]=0;a=(M[a+24>>2]<<3)+8|0;if(!a){break a}D(d,0,a);break a}b=M[a+40>>2];M[c>>2]=M[c>>2]-1;if(b){break d}bh(e,a,0,e+4|0)}if(!N[a+238|0]){break a}bh(e,a,19,e+4|0)}Na=e+16|0;return M[e>>2]}function sI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;a:{e=O[M[c>>2]+16>>1];d=e&31;if((e&63)>>>0>=32){e=1<<d;f=0}else{f=1<<d;e=f-1&1>>>32-d}if(f&-1431655766|e&-1431655766){break a}d=Ib(a,36);if(!d){break a}e=M[d+12>>2];M[d+12>>2]=M[M[M[a>>2]+20>>2]+120>>2];b:{if((b|0)==1){if(e){Wh(d,1,44);break b}M[d+28>>2]=1;break b}a=M[c+4>>2];c:{d:{e:{if(e){a=gb(a);e=Fb(M[c+4>>2]);f:{if(!a){e=0;break f}Ab(d,a,e)}a=M[d+32>>2];if(M[d+28>>2]==(e|0)){if(!a){break b}f=d+32|0;break e}f=d+32|0;if(a){break e}b=Bb((M[d+24>>2]<<2)+4|0,0);if(!b){break c}a=M[d+24>>2];g=((a|0)<=1?1:a)-1|0;a=0;while(1){if((a|0)==(g|0)){break d}M[(a<<2)+b>>2]=M[d+28>>2];a=a+1|0;continue}}h=d,i=Fb(a),M[h+28>>2]=i;break b}b=Mc(a,M[d+24>>2]<<2,0);if(!b){break c}}a=M[d+24>>2];if((a|0)>0){M[((a<<2)+b|0)-4>>2]=e}M[f>>2]=b;break b}Sh(d,7)}M[d+24>>2]=M[d+24>>2]+1;a=gb(M[c>>2]);b=Fb(M[c>>2]);if(!a){break a}Ab(d,a,b)}}function fn(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=M[a+60>>2]-1|0;M[a+60>>2]=n;s=N[b+28|0]&128?28:31;l=M[a+8>>2];if(!j){lb(l,s,d,n,f,g)}if(rk(a,b,0,0)|c){p=Sr(a,c,0,0,3,b,i);r=MB(a,b);q=M[a+48>>2];o=q+1|0;M[a+48>>2]=o+L[b+34>>1];$a(l,80,f,o);q=q+2|0;p=p|r;r=(p|0)==-1;while(1){if(L[b+34>>1]>(m|0)){if(!(!r&(!(p>>>m&1)|m>>>0>31))){Ed(l,b,d,m,Pc(b,m<<16>>16)+q|0)}m=m+1|0;continue}break}m=M[l+108>>2];yi(a,c,129,0,1,b,o,i,n);if((m|0)<M[l+108>>2]){lb(l,s,d,n,f,g);k=-1}bn(a,b,o,0,0,0)}a:{if(N[b+43|0]==2){break a}Rr(a,b,d,e,0,k);$a(l,130,d,h);b:{if(N[a+18|0]){if(hc(M[b>>2],23800)){break b}}Jc(l,b,-5)}c:{if(!j){break c}e=M[l+108>>2];if((e|0)<=0){break c}L[(M[l+104>>2]+S(e,20)|0)-18>>1]=4}if(!((d|0)==(k|0)|(k|0)<0)){fb(l,130,k)}d=M[l+108>>2];if((d|0)<=0){break a}L[(M[l+104>>2]+S(d,20)|0)-18>>1]=(j|0)==2?2:0}KB(a,b,0,o,0,0);if(c){yi(a,c,129,0,2,b,o,i,n)}pb(l,n)}function vj(a){var b=0,c=0,d=0;L[a+50>>1]=0;K[a+1|0]=N[a+1|0]&249;a:{if(N[a|0]){break a}b=O[a+70>>1];c=b+1|0;L[a+70>>1]=c;d=M[a+116>>2];if(O[d+24>>1]<=(c&65535)>>>0){L[a+70>>1]=b;break a}if(N[d+8|0]){a=0}else{a=wo(a)}return a}c=N[a|0];b:{c:{if(!c){break c}if(c>>>0>=3){b=sj(a);if(b){break b}c=N[a|0]}b=101;d:{switch(c-1|0){case 1:break d;case 0:break b;default:break c}}b=0;K[a|0]=0;if(M[a+4>>2]>0){break b}}d=O[a+70>>1]+1|0;L[a+70>>1]=d;b=M[a+116>>2];e:{f:{g:{c=M[16930];if(!c){break g}if(!(Ra[c|0](412)|0)){break g}K[b|0]=0;break f}if(N[b|0]){break e}}b=db(77056);break b}c=N[b+8|0];h:{i:{if(O[b+24>>1]<=(d&65535)>>>0){if(!c){b=Ig(a,mb((M[b+56>>2]+N[b+9|0]|0)+8|0));if(!b){break i}break b}while(1){if(!N[a+68|0]){K[a|0]=1;b=101;break b}Ao(a);b=M[a+116>>2];if(O[a+70>>1]>=O[b+24>>1]){continue}break}if(!N[b+1|0]){break h}b=vj(a);break b}if(c){break h}}b=wo(a);break b}b=0}return b}function Cx(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;f=Na-32|0;Na=f;a:{b:{if((Zd(a,c)|0)==(c|0)|((P[16864]/P[a+36>>2]|0)+1|0)==(c|0)){break b}if(!mb(M[M[a+12>>2]+56>>2]+36|0)){e=101;break a}e=ej(a,c,f+31|0,f+24|0);if(e){break a}c:{d:{e:{g=N[f+31|0];switch(g-1|0){case 0:break e;case 1:break d;default:break c}}e=db(74794);break a}if(d){break b}e=rf(a,f+16|0,f+20|0,c,1);if(e){break a}Rb(M[f+16>>2]);break b}e=xd(a,c,f+16|0,0);if(e){break a}h=d?0:b;i=d?0:2;while(1){j=M[a+48>>2];e=rf(a,f+12|0,f+20|0,h,i);if(e){Rb(M[f+16>>2]);break a}Rb(M[f+12>>2]);e=M[f+20>>2];if(e>>>0>j>>>0){Rb(M[f+16>>2]);e=db(74846);break a}if(b>>>0<e>>>0?d:0){continue}break}b=M[f+16>>2];e=Lo(a,b,g,M[f+24>>2],e,d);Rb(b);if(e){break a}}e=0;if(d){break a}b=(P[16864]/P[a+36>>2]|0)+2|0;while(1){d=(b|0)==(c|0);c=c-1|0;if(d){continue}if((Zd(a,c)|0)==(c|0)){continue}break}M[a+48>>2]=c;K[a+19|0]=1}Na=f+32|0;return e}function TI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;h=Na-32|0;Na=h;a:{if((b|0)==2){f=M[c+4>>2];d=O[f+16>>1];b=d&31;if((d&63)>>>0>=32){d=1<<b;g=0}else{g=1<<b;d=g-1&1>>>32-b}if(g&-1431655766|d&-1431655766){break a}b=sb(f);d=Qa;f=(d|0)>=0&b>>>0>=30|(d|0)>0;b=f?30:b;d=f?0:d;f=d;g=b;b=!!b&(d|0)>=0|(d|0)>0;d=b?g:0;f=b?f:0}g=M[c>>2];c=O[g+16>>1];b=c&31;if((c&63)>>>0>=32){c=1<<b;b=0}else{i=1<<b;c=i-1&1>>>32-b;b=i}if(b&-1431655766|c&-1431655766){break a}e=Kb(g);b:{if(U(e)>4503599627370496){break b}if(!(d|f)){e=e+(e<0?-.5:.5);if(U(e)<0x8000000000000000){b=~~e>>>0;if(U(e)>=1){c=~~(e>0?W(Y(e*2.3283064365386963e-10),4294967295):Z((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{c=0}}else{b=0;c=-2147483648}e=+(b>>>0)+ +(c|0)*4294967296;break b}R[h+8>>3]=e;M[h>>2]=d;b=Hb(12849,h);if(!b){$b(a);break a}Jd(b,h+24|0,jb(b),1);ab(b);e=R[h+24>>3]}Zb(a,e)}Na=h+32|0}function Wj(a,b,c,d){var e=0,f=0,g=0,h=0;a:{if(N[a|0]==1){g=wq(b,c)}else{g=vq(b,c)}f=g&M[a+12>>2]-1;e=$y(a,b,c,f);b:{if(e){h=M[e+8>>2];if(!d){b=M[e>>2];c=M[e+4>>2];c:{if(c){M[c>>2]=b;break c}M[a+8>>2]=b}if(b){M[b+4>>2]=c}c=M[a+16>>2]+(f<<3)|0;if((e|0)==M[c+4>>2]){M[c+4>>2]=b}b=M[c>>2];M[c>>2]=b-1;if((b|0)<=1){M[c+4>>2]=0}d:{if(!N[a+1|0]){break d}b=M[e+12>>2];if(!b){break d}ab(b)}ab(e);b=M[a+4>>2];M[a+4>>2]=b-1;if((b|0)>1){break b}cm(a);return h}M[e+8>>2]=d;return h}if(!d){break b}e:{e=M[a+12>>2];f:{if(!e){if(_y(a,8)){break f}e=M[a+12>>2]}if(M[a+4>>2]<(e|0)){break e}if(!_y(a,e<<1)){break e}}M[a+4>>2]=0;break a}e=Oe(20,0);if(!e){break a}g:{if(!(!b|!N[a+1|0])){f=Oe(c,c>>31);M[e+12>>2]=f;if(!f){ab(e);break a}if(!c){break g}G(f,b,c);break g}M[e+12>>2]=b}M[e+16>>2]=c;M[a+4>>2]=M[a+4>>2]+1;Zy(a,M[a+16>>2]+((M[a+12>>2]-1&g)<<3)|0,e);M[e+8>>2]=d}return h}return d}function Af(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;a:{b:{c:{g=N[a|0];if((g|0)==45){a=a+1|0;h=-1;break c}if((g|0)!=48){if((g|0)!=43){break c}a=a+1|0;break c}if(!(N[N[a+2|0]+31408|0]&8)|(N[a+1|0]|32)!=120){break c}c=a+2|0;while(1){e=c;c=c+1|0;if(N[e|0]==48){continue}break}c=0;a=0;while(1){d:{if((c|0)==8){break d}d=N[c+e|0];if(!(N[d+31408|0]&8)){break d}a=d+(d<<1<<24>>24>>>7&9)&15|a<<4;c=c+1|0;continue}break}if((a|0)<0){break a}if(!(N[N[c+e|0]+31408|0]&8)){break b}break a}c=N[a|0];if(c-58>>>0<4294967286){break a}while(1){if((c&255)!=48){e:{c=0;while(1){if((c|0)==11){break e}f=N[a+c|0];if((f-48&255)>>>0>9){break e}f=f&15;e=ZJ(e,d,10,0)+f|0;d=Qa;d=e>>>0<f>>>0?d+1|0:d;c=c+1|0;continue}}}else{c=N[a+1|0];a=a+1|0;continue}break}f=0;c=c>>>0>10;a=d+h|0;d=e+h|0;a=d>>>0<h>>>0?a+1|0:a;if(d>>>0>2147483647&(a|0)>=0|(a|0)>0|c){break a}a=(g|0)==45?0-e|0:e}M[b>>2]=a;f=1}return f}function xo(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Na-32|0;Na=g;a:{if(P[a+48>>2]<b>>>0){e=db(80917);break a}e=Ui(a,b,g+28|0,0);if(e){break a}f=M[g+28>>2];b:{if(!(N[a+16|0]&4|M[M[f+72>>2]+32>>2]==(((b|0)==1?2:1)|0))){e=db(80924);break b}i=N[f+9|0];b=0;while(1){e=O[f+24>>1];if(e>>>0>b>>>0){e=M[f+64>>2]+(b<<1)|0;h=M[f+56>>2]+(O[f+26>>1]&(N[e|0]<<8|N[e+1|0]))|0;if(!N[f+8|0]){e=xo(a,mb(h),1,d);if(e){break b}}Ra[M[f+80>>2]](f,h,g);if(M[g+12>>2]!=O[g+16>>1]){e=vo(f,h,g);if(e){break b}}b=b+1|0;continue}break}M[g+24>>2]=0;c:{d:{if(!N[f+8|0]){e=xo(a,mb((M[f+56>>2]+i|0)+8|0),1,d);M[g+24>>2]=e;if(e){break b}if(N[f+1|0]|!d){break c}e=O[f+24>>1];break d}if(!d){break c}}a=M[d+4>>2];b=e&65535;e=b+M[d>>2]|0;a=e>>>0<b>>>0?a+1|0:a;M[d>>2]=e;M[d+4>>2]=a}if(c){Fh(f,g+24|0);e=M[g+24>>2];break b}e=ac(M[f+72>>2]);if(e){break b}Oh(f,N[M[f+56>>2]+i|0]|8);e=0}Rb(f)}Na=g+32|0;return e}function Gm(a){var b=0,c=0,d=0,e=0,f=0;a:{if(N[a+97|0]!=167){break a}if(px(a)){break a}ah(a,0);Kj(a);while(1){c=M[a+16>>2];if((b|0)<M[a+20>>2]){d=c+(b<<4)|0;c=M[d+4>>2];b:{if(!c){break b}Cf(c);M[d+4>>2]=0;if((b|0)==1){break b}M[d+12>>2]=0}b=b+1|0;continue}break}c=M[c+28>>2];if(c){Yj(c)}km(a);Eq(a);d=a+424|0;while(1){d=M[d>>2];if(d){b=M[d+8>>2];while(1){lx(a,b);c=M[b+12>>2];eb(a,b);b=c;if(b){continue}break}continue}break}Bf(a+416|0);e=a+440|0;while(1){e=M[e>>2];if(e){f=M[e+8>>2];b=0;while(1){if((b|0)!=3){d=S(b,20)+f|0;c=M[d+16>>2];if(c){Ra[c|0](M[d+8>>2])}b=b+1|0;continue}break}eb(a,f);continue}break}Bf(a+432|0);b=a+396|0;while(1){b=M[b>>2];if(b){c=M[b+8>>2];Kp(a,c);Hp(a,c);continue}break}Bf(a+388|0);Yc(a,0);Xc(M[a+288>>2]);K[a+97|0]=213;eb(a,M[M[a+16>>2]+28>>2]);c=M[a+256>>2];if(c){Ra[c|0](M[a+252>>2])}K[a+97|0]=206;if(N[a+312|0]){ab(M[a+352>>2])}ab(a)}}function BG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;m=M[a>>2]+4|0;g=M[a+12>>2];h=M[a+8>>2];l=M[a+4>>2];a:{b:while(1){if((g|0)>=(h|0)){return 101}i=0-g|0;c:{while(1){j=h;if((g|0)==(h|0)){break c}j=K[g+l|0];if(!((j|0)<0|!N[j+m|0])){g=g+1|0;M[a+12>>2]=g;i=i-1|0;continue}break}j=g}k=(g|0)>(h|0)?g:h;i=g+i|0;while(1){d:{e:{if((g|0)!=(k|0)){n=K[g+l|0];if((n|0)<0|!N[m+n|0]){break e}k=g}if((k|0)<=(j|0)){continue b}h=k-j|0;if((h|0)<=M[a+24>>2]){break a}g=h+20|0;M[a+24>>2]=g;g=Mc(M[a+20>>2],g,g>>31);if(g){break d}return 7}g=g+1|0;M[a+12>>2]=g;i=i+1|0;continue}break}break}M[a+20>>2]=g}g=0;i=(i|0)>0?i:0;l=j+l|0;while(1){if((g|0)!=(i|0)){k=N[g+l|0];K[M[a+20>>2]+g|0]=(k-65&255)>>>0<26?k+32|0:k;g=g+1|0;continue}break}M[b>>2]=M[a+20>>2];M[c>>2]=h;M[d>>2]=j;M[e>>2]=M[a+12>>2];b=a;a=M[a+16>>2];M[b+16>>2]=a+1;M[f>>2]=a;return 0}function rr(a){var b=0,c=0,d=0,e=0,f=0;while(1){a:{b=a;b:{if(!b){a=0;break b}c:{d:{e:{f:{g:{h:{i:{c=N[b|0];switch(c-155|0){case 0:break f;case 1:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 16:case 19:case 20:case 21:break c;case 2:case 14:case 17:break d;case 3:break g;case 13:case 15:case 22:case 23:break h;case 18:case 24:break a;default:break i}}a=2;j:{switch(c-112|0){case 6:break b;case 1:case 3:case 4:case 5:break c;case 2:break a;case 0:break e;default:break j}}a=0;if((c|0)==122){continue}if((c|0)==36){break h}if((c|0)!=139){break c}}a=rc(b);a=(a|0)>66?5:(a|0)==66?6:7;break b}e=M[b+20>>2];c=e+8|0;b=1;a=0;while(1){d=M[e>>2];if((b|0)<(d|0)){a=rr(M[c+(b<<4)>>2])|a;b=b+2|0;continue}break}if(!(d&1)){break b}f=a|f;a=M[(c+(d<<4)|0)-16>>2];continue}a=4;break b}a=6;break b}a=7;break b}a=1}return a|f}a=M[b+12>>2];continue}}function Ai(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{b:{c:{if(!M[b+56>>2]){h=M[M[M[a>>2]+16>>2]+28>>2];if(!h|!M[h+48>>2]){break c}}if(!N[a+165|0]){break b}}a=0;if(!e){break a}M[e>>2]=0;return 0}k=d;i=Na-16|0;Na=i;d=b;d:{e:{b=ps(a,b);if(!b){break e}h=a;f:{if(N[M[a>>2]+34|0]&4){break f}f=M[d+56>>2];if(!f){break f}if((b|0)==(f|0)){break e}a=b;while(1){g=a;a=M[a+32>>2];if((a|0)!=(f|0)?a:0){continue}break}M[g+32>>2]=0}l=(c|0)==129?20394:20401;g=0;m=(c|0)==128;n=(c|0)!=130;a=b;while(1){g:{h:{f=N[a+8|0];if((f|0)!=(c|0)){break h}if(!Yq(M[a+16>>2],k)){break h}g=N[a+9|0]|g;break g}if((f|0)==151){K[a+8|0]=c;j=N[d+43|0]!=1;f=j?2:1;if(!(m|j)){M[i>>2]=l;cb(h,5641,i);f=1}K[a+9|0]=f;g=g|f;break g}if(M[h+132>>2]|(!N[a+10|0]|n|(f|0)!=128)){break g}g=N[a+9|0]|g}a=M[a+32>>2];if(a){continue}break}break d}b=0}if(e){M[e>>2]=g}Na=i+16|0;a=g?b:0}return a}function $l(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Na-16|0;Na=f;e=M[b+80>>2];M[f+12>>2]=e;a:{if(!(!N[a+239|0]|!M[b+56>>2])){K[f+11|0]=0;if(c){M[c>>2]=e;M[d>>2]=M[b+84>>2]-1}_l(0,M[b+72>>2],M[b+76>>2],f+12|0,b+88|0,b+84|0,f+11|0);M[b+80>>2]=N[f+11|0]?0:M[f+12>>2];break a}h=M[b+72>>2]+M[b+76>>2]|0;while(1){g=N[e|0];if(g|i){i=g&128;e=e+1|0;continue}if(!(!M[b+52>>2]|M[b+40>>2]+M[b+48>>2]>>>0>e>>>0)){g=Jy(b);if(!g){continue}break a}break}e=e+1|0;M[f+12>>2]=e;if(c){g=c;c=M[b+80>>2];M[g>>2]=c;M[d>>2]=(c^-1)+e}b:{while(1){if(e>>>0<h>>>0){if(N[e|0]){break b}e=e+1|0;continue}break}g=0;M[b+80>>2]=0;break a}M[f+12>>2]=e;g=am(b,e,10);if(g){break a}j=b,k=Ic(e,f)+e|0,M[j+80>>2]=k;c=M[f>>2];a=N[a+239|0];e=a?0-c|0:c;d=e+M[b+88>>2]|0;g=(c|0)!=0;c=M[f+4>>2];a=M[b+92>>2]+(a?0-(g+c|0)|0:c)|0;M[b+88>>2]=d;M[b+92>>2]=d>>>0<e>>>0?a+1|0:a;g=0}Na=f+16|0;return g}function cs(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c=M[b+32>>2];d=M[a+8>>2];while(1){if(!(M[a+40>>2]|M[b+36>>2]<=(i|0))){k=M[M[c>>2]+20>>2];if(M[c+16>>2]>=0){h=M[k>>2];j=vc(a,h);g=N[c+20|0]?M[M[M[M[c>>2]+12>>2]+20>>2]>>2]+!N[c+21|0]|0:0;l=fb(d,36,M[c+16>>2]);f=h-1|0;e=f;while(1){if((e|0)>=0){bb(d,94,M[c+16>>2],e+g|0,e+j|0);e=e-1|0;continue}break}if(N[c+22|0]){e=Gb(a);g=!(N[c+20|0]?1:N[c+21|0])+(g+h|0)|0;while(1){if((f|0)>=0){bb(d,94,M[c+16>>2],f+g|0,e);$a(d,182,e,f+j|0);f=f-1|0;continue}break}zb(a,e)}bb(d,162,0,j,M[b+24>>2]+(M[b+12>>2]+i|0)|0);Jc(d,M[c+4>>2],-7);g=M[d+108>>2];if((g|0)>0){L[(M[d+104>>2]+S(g,20)|0)-18>>1]=h}$a(d,39,M[c+16>>2],l+1|0);f=M[d+108>>2];M[(N[M[d>>2]+87|0]?74356:M[d+104>>2]+S(l,20)|0)+8>>2]=f;ad(a,j,h)}$a(d,165,M[b+24>>2]+(M[b+12>>2]+i|0)|0,k?M[k>>2]:0);Jc(d,M[c+4>>2],-7);c=c+24|0;i=i+1|0;continue}break}}function QF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Na-16|0;Na=h;M[h+12>>2]=0;a=qj(a,25516);if(!a){j=14117;g=c-3|0;a:{b:{if(!g){break b}k=d+12|0;d=0;l=(g|0)>0?g:0;a=0;while(1){if((a|0)!=(l|0)){d=(yb(M[(a<<2)+k>>2])+d|0)+1|0;a=a+1|0;continue}break}a=g<<2;i=Bb(a+d|0,0);if(!i){i=0;a=7;break a}a=a+i|0;d=0;while(1){if((d|0)!=(l|0)){g=d<<2;m=g+k|0;n=yb(M[m>>2]);M[g+i>>2]=a;g=n+1|0;if(g){G(a,M[m>>2],g)}ni(a);d=d+1|0;a=a+g|0;continue}break}if((c|0)<4){break b}j=M[i>>2]}a=1;d=Zl(b,j,yb(j)+1|0);if(!d){M[h>>2]=j;$d(f,7850,h);break a}c:{a=(c|0)>4;a=Ra[M[d+4>>2]]((a?c:4)-4|0,a?i+4|0:0,h+12|0)|0;d:{if(a){c=M[h+12>>2];break d}b=tc(20);c=M[h+12>>2];if(b){break c}a=7}if(!c){break a}Ra[M[d+8>>2]](c)|0;break a}M[b>>2]=0;M[b+4>>2]=0;M[b+16>>2]=c;M[b+12>>2]=d;a=0;M[b+8>>2]=0;M[e>>2]=b}ab(i)}Na=h+16|0;return a|0}function Pm(a,b,c,d,e){var f=0,g=0;while(1){if(!mc(a,b,c,d)){return N[c|0]!=122}g=0;a:{b:{c:{d:{e:{f:{g:{h:{f=N[b|0];switch(f-103|0){case 0:case 6:case 7:case 8:break f;case 1:case 2:case 3:case 4:case 5:case 9:break g;case 10:break c;case 11:break a;case 12:break b;default:break h}}i:{switch(f-49|0){default:switch(f-173|0){case 3:case 4:case 5:case 6:case 7:break c;case 0:case 1:case 8:break a;case 2:break e;default:break d};case 1:if(!e){break b}e=1;if(N[b+5|0]&16){break c}break a;case 4:case 5:case 6:case 7:case 8:case 9:break g;case 2:case 3:break c;case 0:break i}}if(e){break c}g=1;f=M[b+20>>2];if(Pm(a,M[f+8>>2],c,d,1)){break c}e=1;if(!Pm(a,M[f+24>>2],c,d,1)){break a}break c}e=1}if(!Pm(a,M[b+16>>2],c,d,e)){break a}return 1}if(e){break c}e=1;if(N[b+2|0]==45){break a}break c}if((f|0)==19){break b}}return g}e=1}b=M[b+12>>2];continue}}function Cs(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=Na-16|0;Na=j;f=M[a+252>>2];a:{if(!f){break a}g=M[f+28>>2];if(g&4){M[j>>2]=M[f>>2];cb(a,1305,j);break a}M[f+28>>2]=g|4;b:{if(!b){g=L[f+34>>1]-1|0;k=M[f+4>>2]+S(g,12)|0;yn(a,k);h=1;break b}l=M[b>>2];n=(l|0)>0?l:0;o=b+8|0;g=-1;while(1){c:{if((m|0)!=(n|0)){i=Rf(M[(m<<4)+o>>2]);rs(i);if(N[i|0]!=60){break c}g=0;h=L[f+34>>1];h=(h|0)>0?h:0;p=M[i+8>>2];while(1){if((g|0)==(h|0)){g=h;break c}i=M[f+4>>2]+S(g,12)|0;if(hb(p,M[i>>2])){g=g+1|0;continue}else{yn(a,i);k=i;break c}}}h=(l|0)==1;break b}m=m+1|0;continue}}if(!(!h|!k|(e|0)==1|(N[k+4|0]&-16)!=64)){if(!(!b|N[a+224|0]<2)){kd(a,f+32|0,Rf(M[b+8>>2]))}K[f+42|0]=c;L[f+32>>1]=g;M[f+28>>2]=M[f+28>>2]|d<<3;if(b){K[a+222|0]=N[b+16|0]}Fk(a,b);break a}if(d){cb(a,18533,0);break a}Ni(a,0,0,0,b,c,0,0,e,0,2);b=0}xb(M[a>>2],b);Na=j+16|0}function Hc(a,b,c){var d=0,e=0,f=0;a:{b:{c:{if(c){d=M[a+20>>2];f=(d|0)>0?d:0;d:{while(1){if((e|0)!=(f|0)){d=M[a+16>>2];if(!hb(c,M[d+(e<<4)>>2])){break d}e=e+1|0;continue}break}d=0;if(hb(c,11364)){break a}d=M[a+16>>2];e=0}d=Sc(M[((e<<4)+d|0)+12>>2]+8|0,b);if(d){break a}d=0;if(Eb(b,18301,7)){break a}b=b+7|0;if((e|0)==1){if(!hb(b,18194)){break c}if(!hb(b,18213)){break c}if(hb(b,9316)){break a}break c}if(hb(b,18213)){break a}e=(M[a+16>>2]+(e<<4)|0)+12|0;a=9309;break b}d=Sc(M[M[a+16>>2]+28>>2]+8|0,b);if(d){break a}d=Sc(M[M[a+16>>2]+12>>2]+8|0,b);if(d){break a}e=2;while(1){if(M[a+20>>2]>(e|0)){c=e<<4;e=e+1|0;d=Sc(M[(M[a+16>>2]+c|0)+12>>2]+8|0,b);if(!d){continue}break a}break}d=0;if(Eb(b,18301,7)){break a}b=b+7|0;if(!hb(b,18213)){e=M[a+16>>2]+12|0;a=9309;break b}if(hb(b,18194)){break a}}e=M[a+16>>2]+28|0;a=9290}d=Sc(M[e>>2]+8|0,a)}return d}function Qx(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;k=Na-16|0;Na=k;i=M[a>>2];M[k+12>>2]=i;m=k+12|0;a:{b:{if(i){j=M[i+16>>2];l=M[i+20>>2];if((j|0)==(b|0)&(l|0)==(c|0)){break b}M[i>>2]=M[i>>2]+1;i=b-j|0;j=c-((b>>>0<j>>>0)+l|0)|0}else{i=b;j=c}j=Rj(m,i,j);i=M[k+12>>2];if(j){break a}M[i+32>>2]=0;M[i+36>>2]=0;M[i+24>>2]=-1;M[i+28>>2]=-1;M[i+16>>2]=b;M[i+20>>2]=c}c:{d:{if(!!d&(e|0)>=0|(e|0)>0){if((d|0)==M[i+24>>2]&(e|0)==M[i+28>>2]){break d}j=Rj(k+12|0,1,0);if(j){i=M[k+12>>2];break a}j=Rj(k+12|0,d,e);i=M[k+12>>2];if(j){break a}M[i+32>>2]=0;M[i+36>>2]=0;M[i+24>>2]=d;M[i+28>>2]=e;break d}if((e|0)<0){break c}}c=k+12|0;b=M[i+32>>2];d=f-b|0;b=g-(M[i+36>>2]+(b>>>0>f>>>0)|0)|0;d=d+2|0;b=d>>>0<2?b+1|0:b;j=Rj(c,d,b);i=M[k+12>>2];if(j){break a}M[i+32>>2]=f;M[i+36>>2]=g}j=0}M[h>>2]=j;Na=k+16|0;if(M[a>>2]==(i|0)){a=0}else{M[a>>2]=i;a=1}return a}function Id(a,b){var c=0,d=0,e=0;a:{if(!b){break a}if(!M[a+528>>2]){c=M[b+24>>2]-1|0;M[b+24>>2]=c;if(c){break a}}c=a;d=b;a=M[d+8>>2];while(1){if(a){b=M[a+20>>2];if(!(M[c+528>>2]|N[d+43|0]==1)){wd(M[a+24>>2]+24|0,M[a>>2],0)}Xk(c,a);a=b;continue}break}b:{c:{switch(N[d+43|0]){case 0:a=M[d+48>>2];while(1){if(!a){break b}d:{if(M[c+528>>2]){break d}b=M[a+12>>2];e=M[a+16>>2];e:{if(e){M[e+12>>2]=b;break e}wd(M[d+60>>2]+56|0,M[(b?b:a)+8>>2],b);b=M[a+12>>2]}if(!b){break d}M[b+16>>2]=M[a+16>>2]}Vi(c,M[a+28>>2]);Vi(c,M[a+32>>2]);b=M[a+4>>2];ib(c,a);a=b;continue};case 1:if(!M[c+528>>2]){xu(0,d)}if(!M[d+48>>2]){break b}a=0;while(1){if(M[d+44>>2]>(a|0)){if((a|0)!=1){eb(c,M[M[d+48>>2]+(a<<2)>>2])}a=a+1|0;continue}break};eb(c,M[d+48>>2]);break b;default:break c}}pc(c,M[d+44>>2])}Vn(c,d);eb(c,M[d>>2]);eb(c,M[d+12>>2]);xb(c,M[d+16>>2]);ib(c,d)}}function Yz(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=Na-16|0;Na=i;d=M[b+24>>2];j=(d|0)>0?d:0;f=b+24|0;h=M[b+20>>2];d=h;a:{b:{while(1){if((g|0)!=(j|0)){if(M[d+4>>2]==(c|0)){break a}if(!(M[d+8>>2]!=M[c+28>>2]|O[d+12>>1]!=O[c+32>>1])){e=N[c|0];if((e|0)!=179){break b}}d=d+16|0;g=g+1|0;continue}break}a=Xz(M[a>>2],h,16,f,i+12|0);M[b+20>>2]=a;g=M[i+12>>2];if((g|0)<0){break a}a=a+(g<<4)|0;M[a>>2]=M[c+44>>2];h=M[c+28>>2];M[a+8>>2]=h;j=O[c+32>>1];M[a+4>>2]=c;L[a+12>>1]=j;e=M[b+16>>2];c:{d:{if(!e|N[c|0]==179){break d}d=0;f=M[e>>2];k=(f|0)>0?f:0;e=e+8|0;while(1){if((d|0)==(k|0)){break d}f=M[e>>2];if(!(!(N[f|0]!=168|(h|0)!=M[f+28>>2])&(j|0)==O[f+32>>1])){e=e+16|0;d=d+1|0;continue}break}L[a+14>>1]=d;if(d<<16>>16>=0){break c}}d=O[b+2>>1];L[b+2>>1]=d+1;L[a+14>>1]=d}e=N[c|0]}M[c+40>>2]=b;if((e|0)==168){K[c|0]=170}L[c+34>>1]=g}Na=i+16|0}function Iz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=Na-16|0;Na=h;e=M[M[M[a+24>>2]+4>>2]+36>>2];f=M[M[a+4>>2]+4>>2];j=M[f+36>>2];o=(e|0)<(j|0)?e:j;q=e;k=e>>31;l=ZJ(e,k,b,0);i=l-e|0;m=Qa;e=m-((e>>>0>l>>>0)+k|0)|0;p=M[f>>2];n=j>>31;b=0;while(1){if(!((e|0)>=(m|0)&i>>>0>=l>>>0|(e|0)>(m|0)|b)){b=0;M[h+12>>2]=0;f=_J(i,e,j,n);g=Qa;if((f|0)!=(P[16864]/P[M[M[a+4>>2]+4>>2]+36>>2]|0)){b=Ra[M[p+220>>2]](p,f+1|0,h+12|0,0)|0;a:{if(b){break a}b=ac(M[h+12>>2]);if(b){break a}b=$J(i,e,q,k);f=M[M[h+12>>2]+4>>2]+(i-ZJ(j,n,f,g)|0)|0;if(o){G(f,b+c|0,o)}b=0;K[M[M[h+12>>2]+8>>2]]=0;if(e|i|d){break a}g=M[M[M[a+24>>2]+4>>2]+48>>2];g=g<<24|(g&65280)<<8|(g>>>8&65280|g>>>24);K[f+28|0]=g;K[f+29|0]=g>>>8;K[f+30|0]=g>>>16;K[f+31|0]=g>>>24}sd(M[h+12>>2])}e=e+n|0;i=i+j|0;e=i>>>0<j>>>0?e+1|0:e;continue}break}Na=h+16|0;return b}function PG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(M[b+8>>2]!=1){break a}a=M[b+12>>2];if(M[a>>2]|N[a+4|0]){break a}M[b+32>>2]=1}a=M[b>>2];j=(a|0)>0?a:0;g=-1;h=-1;f=-1;i=-1;while(1){if((c|0)!=(j|0)){d=M[b+4>>2]+S(c,12)|0;if(N[d+5|0]){a=N[d+4|0];d=M[d>>2];if(!d){h=(a|0)==8?c:(a|0)==16?c:h;i=(a|0)==2?c:i;g=(a|0)==32?c:(a|0)==4?c:g}f=(d|0)==4?(a|0)==2?c:f:f}c=c+1|0;continue}break}b:{if((i|0)>=0){M[b+20>>2]=1;M[M[b+16>>2]+(i<<3)>>2]=1;M[b+40>>2]=0;M[b+44>>2]=1075052544;c=2;e=5;break b}M[b+40>>2]=0;M[b+44>>2]=1087604736;M[b+20>>2]=0;c:{if((g|0)<0){c=1;e=2e4;a=4;break c}c=2;M[b+20>>2]=2;M[M[b+16>>2]+(g<<3)>>2]=1;M[b+40>>2]=0;M[b+44>>2]=1086556160;e=1e4;a=6}if((h|0)<0){break b}M[b+20>>2]=a;M[M[b+16>>2]+(h<<3)>>2]=c;e=e*.5;R[b+40>>3]=e;c=c+1|0}if((f|0)>=0){M[M[b+16>>2]+(f<<3)>>2]=c;R[b+40>>3]=e+-1}return 0}function Kx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;g=Na-32|0;Na=g;f=Tb(a,37,g+28|0,0);a:{if(f){break a}i=M[g+28>>2];h=c;f=b+1|0;h=f?h:h+1|0;Jb(i,1,f,h);h=_J(b,c,1024,0);Jb(i,2,h<<10|1023,Qa<<10|h>>>22);e=_J(ZJ(d,e,3,0),Qa,2,0);k=Qa;while(1){b:{h=j;if((Db(i)|0)!=100){break b}M[g+16>>2]=0;M[g+20>>2]=0;Ix(i,2,g+8|0,g+16|0);h=0;j=M[g+20>>2];f=j;d=M[g+16>>2];if(!d&(f|0)<=0|(f|0)<0){break b}j=1;if((f|0)<=(k|0)&d>>>0<=e>>>0|(f|0)<(k|0)){continue}}break}f=wb(i);if(!h){break a}M[g+16>>2]=0;M[g+8>>2]=0;if(f){break a}f=Tb(a,38,g+16|0,0);if(f){break a}f=Tb(a,39,g+8|0,0);if(f){break a}Jb(i,1,b,c);a=M[g+16>>2];h=0;c:{while(1){if((Db(i)|0)!=100){break c}fd(a,1,h);fd(a,2,Md(i,0));fd(a,3,Md(i,1));Db(a);h=h+1|0;f=wb(a);if(!f){continue}break}wb(i);break a}f=wb(i);if(f){break a}a=M[g+8>>2];Jb(a,1,b,c);Db(a);f=wb(a)}Na=g+32|0;return f}function Iq(a,b){var c=0,d=0,e=0,f=0,g=0;f=Na-16|0;Na=f;c=M[a+4>>2];e=M[a>>2];d=jc(e,b,f+12|0);a:{if(!d){K[c+25|0]=N[c+25|0]|2;b=M[e+4>>2]+1|0;break a}b:{c:{d:{switch((N[M[e>>2]+b|0]&15)-11|0){case 0:g=M[f+12>>2];bc(c,91);e=b+d|0;b=g+e|0;if(b>>>0>e>>>0){bc(c,10);M[a+16>>2]=M[a+16>>2]+1;while(1){e:{if(N[c+25|0]){break e}fm(a);e=Iq(a,e);if(e>>>0>=b>>>0){break e}Nc(c,30782,2);continue}break}bc(c,10);M[a+16>>2]=M[a+16>>2]-1;fm(a)}bc(c,93);break a;case 1:g=M[f+12>>2];bc(c,123);d=b+d|0;b=g+d|0;if(b>>>0<=d>>>0){break b}bc(c,10);M[a+16>>2]=M[a+16>>2]+1;while(1){if(N[c+25|0]){break c}fm(a);d=Ff(e,d,c);if(d>>>0>b>>>0){K[c+25|0]=N[c+25|0]|2;break c}Nc(c,30745,2);d=Iq(a,d);if(d>>>0>=b>>>0){break c}Nc(c,30782,2);continue};default:break d}}b=Ff(e,b,c);break a}bc(c,10);M[a+16>>2]=M[a+16>>2]-1;fm(a)}bc(c,125)}Na=f+16|0;return b}function Bx(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;e=Na-16|0;Na=e;a:{while(1){d=0;if(N[a+32|0]){break a}c=M[b>>2];if(M[a+24>>2]!=M[c+32>>2]|M[a+28>>2]!=M[c+36>>2]){break a}d=M[a+12>>2];if(d){d=Bx(d,b);if(d){break a}a=M[a+16>>2];continue}break}i=M[c>>2];h=M[a+20>>2];d=M[h+28>>2];M[e+12>>2]=d;a=M[a+36>>2];c=M[b+4>>2];f=(c+31|0)/32|0;g=c;c=N[b+24|0];f=(c|0)!=121?f:g;b:{if(!d){break b}d=S(a,f);a=0;g=(c|0)!=121;while(1){c=yx(e+12|0);f=M[h+68>>2];c:{if((f|0)!=(a|0)&(f|0)<M[i+24>>2]){break c}if(!g){M[(M[b+28>>2]+(d<<2)|0)+(a<<2)>>2]=c;break c}if(!c){break c}c=(M[b+28>>2]+(d<<2)|0)+((a+1|0)/32<<2)|0;M[c>>2]=M[c>>2]|1<<a}a=M[e+12>>2];if(N[a|0]!=1){break b}c=a+1|0;a=K[a+1|0];d:{if((a|0)<0){f=yc(c,e+8|0);a=M[e+8>>2];break d}M[e+8>>2]=a;f=1}M[e+12>>2]=c+f;if(M[b+4>>2]>(a|0)){continue}break}d=267;break a}d=0}Na=e+16|0;return d}function pC(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;c=Na-272|0;Na=c;L[c+268>>1]=0;M[c+260>>2]=0;M[c+264>>2]=0;M[c+256>>2]=200;M[c+248>>2]=0;M[c+252>>2]=c+48;Sd(c+248|0,1657);d=N[b+6|0];g=40;while(1){if(h>>>0<N[b+7|0]){M[c>>2]=g;M[c+4>>2]=M[(d<<2)+36400>>2];rb(c+248|0,29476,c);d=d+1|0;h=h+1|0;g=44;continue}break}if(!h){M[c+32>>2]=M[b>>2];rb(c+248|0,29483,c+32|0);h=1}g=0;d=N[b+5|0];if(d&32){Sd(c+248|0,20102);g=1;d=N[b+5|0]}if((d&255)>>>0>=64){Sd(c+248|0,20114);g=g+1|0}d=c+248|0;Ab(d,27767,1);Rd(d);i=qj(a,c+48|0);a:{b:{if(!i){d=tc(24);if(!d){i=7;break b}f=d+16|0;M[f>>2]=0;M[f+4>>2]=0;M[d+8>>2]=0;M[d+12>>2]=0;M[d>>2]=0;M[d+4>>2]=0;M[d+16>>2]=b;K[d+21|0]=h;M[d+12>>2]=a;K[d+20|0]=g;i=0;break a}j=c,k=yg(a),M[j+16>>2]=k;j=f,k=Hb(8932,c+16|0),M[j>>2]=k}d=0}M[e>>2]=d;Na=c+272|0;return i|0}function st(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;while(1){a:{f=N[a|0];if(!f){break a}e=0;g=0;if(b>>>0<=h>>>0){break a}while(1){if((f-48&255)>>>0<=9){g=ZJ(e,g,10,0);e=f&255;f=g+e|0;g=Qa;g=f>>>0<e>>>0?g+1|0:g;e=f-48|0;g=g-(f>>>0<48)|0;f=N[a+1|0];a=a+1|0;continue}break}i=(h<<1)+c|0,j=Td(e,g),L[i>>1]=j;h=h+1|0;a=(N[a|0]==32)+a|0;continue}break}e=(N[d+55|0]|N[d+56|0]<<8)&-69;K[d+55|0]=e;K[d+56|0]=e>>>8;h=N[a|0];b:while(1){if(h&255){c:{if(rp(25087,a)){if(!rp(25098,a)){f=Xe(a+3|0);i=d,j=Td((f|0)<=2?2:f,0),L[i+48>>1]=j;break c}if(rp(25075,a)){break c}e=e|64}else{e=e|4}K[d+55|0]=e;K[d+56|0]=e>>>8}while(1)if((N[a|0]|32)==32){f=a;while(1){a=f;f=a+1|0;h=N[a|0];if((h|0)==32){continue}break}continue b}else{a=a+1|0;continue}}break}a=L[c>>1];if(!((a|0)<67|(a|0)>L[((b<<1)+c|0)-2>>1])){a=e|256;K[d+55|0]=a;K[d+56|0]=a>>>8}}function bg(a,b,c,d,e){var f=0,g=0;if(d){f=M[d+4>>2];d=M[d>>2]}else{d=0}g=b+c|0;a:{if(!a){while(1){a=M[b>>2];d=(d+f|0)+(a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24))|0;a=M[b+4>>2];f=d+((a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24))+f|0)|0;b=b+8|0;if(g>>>0>b>>>0){continue}break a}}if(!(c&63)){while(1){a=M[b>>2]+(d+f|0)|0;c=a+(M[b+4>>2]+f|0)|0;a=c+(a+M[b+8>>2]|0)|0;c=(c+M[b+12>>2]|0)+a|0;a=c+(a+M[b+16>>2]|0)|0;c=(c+M[b+20>>2]|0)+a|0;a=c+(a+M[b+24>>2]|0)|0;c=(c+M[b+28>>2]|0)+a|0;a=c+(a+M[b+32>>2]|0)|0;c=(c+M[b+36>>2]|0)+a|0;a=c+(a+M[b+40>>2]|0)|0;c=(c+M[b+44>>2]|0)+a|0;d=c+M[b+52>>2]|0;c=c+(a+M[b+48>>2]|0)|0;a=d+c|0;d=a+(c+M[b+56>>2]|0)|0;f=d+(a+M[b+60>>2]|0)|0;b=b- -64|0;if(g>>>0>b>>>0){continue}break a}}while(1){d=M[b>>2]+(d+f|0)|0;f=d+(M[b+4>>2]+f|0)|0;b=b+8|0;if(g>>>0>b>>>0){continue}break}}M[e+4>>2]=f;M[e>>2]=d}function Xh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Na-16|0;Na=g;f=M[b>>2];a:{b:{c:{if(M[a+28>>2]?N[a+15|0]:0){break c}e=M[a+228>>2];if(!f|(M[e+16>>2]|M[e+20>>2])|M[a+168>>2]==(f|0)){break c}M[g+8>>2]=0;M[g+12>>2]=0;d:{if(!N[a+17|0]){break d}e=M[a+64>>2];d=M[e>>2];if(!d){break d}d=Ra[M[d+24>>2]](e,g+8|0)|0;if(!d){break d}e=0;break b}e=fj(f+8|0);if(!e){e=0;d=7;break b}d=e+f|0;K[d|0]=0;K[d+1|0]=0;K[d+2|0]=0;K[d+3|0]=0;K[d+4|0]=0;K[d+5|0]=0;K[d+6|0]=0;K[d+7|0]=0;Qg(a);d=Ev(M[a+228>>2],f);if(d){break b}tf(M[a+224>>2]);M[a+224>>2]=e;e=M[g+8>>2];d=M[g+12>>2];M[a+168>>2]=f;M[a+172>>2]=0;h=e;e=e+f|0;d=h>>>0>e>>>0?d+1|0:d;i=a,j=_J(e-1|0,d-!e|0,f,0),M[i+28>>2]=j;M[a+164>>2]=(P[16864]/(f>>>0)|0)+1}M[b>>2]=M[a+168>>2];if((c|0)<0){c=O[a+150>>1]}L[a+150>>1]=c;d=0;break a}tf(e);M[b>>2]=M[a+168>>2]}Na=g+16|0;return d}function Vk(a){var b=0,c=0,d=0;L[a+50>>1]=0;K[a+1|0]=N[a+1|0]&241;a:{b:{if(N[a|0]){break b}b=O[a+70>>1];if(!b){break b}if(N[M[a+116>>2]+8|0]){break a}}c=N[a|0];c:{d:{if(!c){break d}if(c>>>0>=3){b=sj(a);if(b){break c}c=N[a|0]}b=101;e:{switch(c-1|0){case 1:break e;case 0:break c;default:break d}}b=0;K[a|0]=0;if(M[a+4>>2]<0){break c}}b=M[a+116>>2];f:{g:{h:{c=M[16930];if(!c){break h}if(!(Ra[c|0](412)|0)){break h}K[b|0]=0;break g}if(N[b|0]){break f}}b=db(77149);break c}if(!N[b+8|0]){c=M[b+56>>2];d=O[b+26>>1];b=M[b+64>>2]+(O[a+70>>1]<<1)|0;b=Ig(a,mb(c+(d&(N[b|0]<<8|N[b+1|0]))|0));if(b){break c}b=Ft(a);break c}i:{while(1){b=O[a+70>>1];if(b){break i}if(N[a+68|0]){Ao(a);continue}break}K[a|0]=1;b=101;break c}L[a+70>>1]=b-1;b=0;c=M[a+116>>2];if(!N[c+1|0]|N[c+8|0]){break c}b=Vk(a)}return b}L[a+70>>1]=b-1;return 0}function Jp(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{C(+a);b=x(1)|0;e=x(0)|0;b:{c:{d:{if((b|0)<1071284857|(b|0)<=1071284857){if((b|0)==-1074790400|b>>>0>3220176896){d=-Infinity;if(a==-1){break b}return(a-a)/0}if(((b&2147483647)<<1|e>>>31)>>>0<2034237440){break a}if((b|0)==-1076707643|b>>>0>3218259653){break d}d=0;break c}if(b>>>0>2146435071){break a}}c=a+1;C(+c);b=x(1)|0;e=x(0)|0;b=b+614242|0;h=b>>>0<=1129316351?(b>>>0>1074790399?a-c+1:a-(c+-1))/c:0;z(0,e|0);z(1,(b&1048575)+1072079006|0);a=+B()+-1;d=+((b>>>20|0)-1023|0)}f=a/(a+2);g=f*f;c=g*g;i=a;a=a*(a*.5);d=d*.6931471803691238+(i+(f*(a+(c*(c*(c*.15313837699209373+.22222198432149784)+.3999999999940942)+g*(c*(c*(c*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+(d*1.9082149292705877e-10+h)-a))}return d}return a}function WC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;M[c>>2]=0;M[c+4>>2]=0;M[c+8>>2]=0;a:{b:{c:{i=jb(b);if(i>>>0<2){break c}a=N[b|0];if((a|0)!=92&(a|0)!=47){break c}a=M[18554];g=(a|0)>0?a:0;h=M[18555];d:{while(1){if((f|0)==(g|0)){break d}a=f<<2;f=f+1|0;a=M[a+h>>2];if(Wc(M[a+52>>2],b)){continue}break}M[a+48>>2]=M[a+48>>2]+1;break b}a=lc(i+59|0,0);f=7;if(!a){break a}f=Ud(M[18555],(M[18554]<<2)+4|0,0);if(!f){ab(a);return 7}g=M[18554];M[18554]=g+1;M[f+(g<<2)>>2]=a;M[18555]=f;D(a,0,56);M[a+36>>2]=3;f=M[16929];g=M[16928];h=a+56|0;M[a+52>>2]=h;M[a+16>>2]=g;M[a+20>>2]=f;f=i+1|0;if(f){G(h,b,f)}M[a+48>>2]=1;M[a+28>>2]=8;break b}a=lc(56,0);if(!a){return 7}D(a,0,56);M[a+36>>2]=3;b=M[16929];M[a+16>>2]=M[16928];M[a+20>>2]=b}M[c+4>>2]=a;if(e){M[e>>2]=d|128}M[c>>2]=33412;f=0}return f|0}function Si(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;f=Na-16|0;Na=f;d=67;a:{b:{c:{d:{e:while(1){h=d-67|0;while(1){f:{g=N[a|0];if(g){a=a+1|0;g:{c=N[g+31024|0]|c<<8;if((c|0)!=1651273570){if((c|0)==1667785074){d=66;e=a;continue e}if((c|0)!=1952807028&(c|0)!=1668050786){break g}d=66;continue e}h:{switch(h|0){case 0:case 2:break h;default:break g}}e=N[a|0]==40?a:e;d=65;continue e}if((c|0)!=1919246700&(c|0)!=1718382433&(c|0)!=1685026146|(d|0)!=67){break f}d=69;continue e}if(!b){break a}a=0;M[f+12>>2]=0;if(d>>>0>66){break b}if(e){break d}a=4;break b}if((c&16777215)!=6909556){continue}break}break}if(b){break c}d=68;break a}while(1){c=N[e|0];if(!c){break b}if(c-58>>>0>=4294967286){Af(e,f+12|0);a=M[f+12>>2]/4|0;break b}else{e=e+1|0;continue}}}a=0;d=68}K[b+6|0]=((a|0)>=254?254:a)+1}Na=f+16|0;return d<<24>>24}function kA(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;e=N[c|0];if(!((e|0)!=177|d-55>>>0>3)){c=M[M[c+20>>2]+8>>2];e=N[c|0]}a:{if((e|0)!=168){d=M[a>>2];h=(d|0)>0?d:0;e=a+16|0;while(1){if((g|0)==(h|0)){break a}d=M[e+S(g,48)>>2]+8|0;b:{while(1){f=M[d>>2];if(!f){break b}d=f+20|0;if(!M[f+40>>2]){continue}break}i=a+8|0;c:{while(1){e=i+S(g,48)|0;d=M[e+8>>2]+8|0;h=M[e+16>>2];while(1){f=M[d>>2];if(f){d:{if(!M[f+40>>2]){break d}d=0;while(1){if(O[f+50>>1]<=d>>>0){break d}e:{if(O[M[f+4>>2]+(d<<1)>>1]!=65534){break e}e=d<<4;if(Bm(c,M[(e+M[f+40>>2]|0)+8>>2],h)){break e}if(Nd(0,M[(e+M[f+40>>2]|0)+8>>2])){break e}M[b+4>>2]=-2;M[b>>2]=h;a=1;break c}d=d+1|0;continue}}d=f+20|0;continue}break}g=g+1|0;if((g|0)<M[a>>2]){continue}break}a=0}return a}g=g+1|0;continue}}M[b>>2]=M[c+28>>2];M[b+4>>2]=L[c+32>>1];i=1}return i}function NB(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;g=Na-32|0;Na=g;h=M[e+16>>2];j=M[a>>2];i=xh(j,e,0);k=qb(j,f,0);if(i){M[i+24>>2]=-1;e=M[i+16>>2];M[e+24>>2]=M[e+24>>2]-1;M[i+16>>2]=0}a:{if(c){e=0;f=0;while(1){if(f>>>0<O[c+50>>1]){e=Wb(a,e,cn(a,L[M[c+4>>2]+(f<<1)>>1]));f=f+1|0;continue}break}h=N[h+43|0]==1?14:15;break a}e=N[h+43|0];if((e|0)==2){e=0;f=0;while(1)if(L[h+34>>1]<=(f|0)){h=14;break a}else{e=Wb(a,e,cn(a,f));f=f+1|0;continue}}h=(e|0)==1?14:15;e=ob(a,76,0,0);e=ed(M[a>>2],e)}b:{if(!d){break b}l=d+8|0;f=0;while(1){if(M[d>>2]<=(f|0)){break b}e=Wb(a,e,qb(j,M[(f<<4)+l>>2],0));f=f+1|0;continue}}d=td(a,e,i,k,0,0,0,276955136,0);if(d){M[d+4>>2]=M[d+4>>2]|134217728}M[g+24>>2]=0;M[g+16>>2]=0;M[g+20>>2]=0;M[g+8>>2]=b;K[g+4|0]=h;M[g+12>>2]=c?O[c+50>>1]:-1;Rc(a,d,g+4|0);pc(j,d);Na=g+32|0}function rv(a,b,c,d,e){K[e+7|0]=c;K[e+3|0]=b;K[e+6|0]=c>>>8;K[e+5|0]=c>>>16;K[e+4|0]=c>>>24;K[e+2|0]=b>>>8;K[e+1|0]=b>>>16;K[e|0]=b>>>24;if(!M[a+104>>2]){b=M[a+88>>2];c=M[a+84>>2];K[e+8|0]=c;K[e+9|0]=c>>>8;K[e+10|0]=c>>>16;K[e+11|0]=c>>>24;K[e+12|0]=b;K[e+13|0]=b>>>8;K[e+14|0]=b>>>16;K[e+15|0]=b>>>24;c=!N[a+65|0];b=a+76|0;bg(c,e,8,b,b);bg(c,d,M[a+36>>2],b,b);b=M[a+76>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);K[e+16|0]=b;K[e+17|0]=b>>>8;K[e+18|0]=b>>>16;K[e+19|0]=b>>>24;a=M[a+80>>2];a=a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24);K[e+20|0]=a;K[e+21|0]=a>>>8;K[e+22|0]=a>>>16;K[e+23|0]=a>>>24;return}K[e+8|0]=0;K[e+9|0]=0;K[e+10|0]=0;K[e+11|0]=0;K[e+12|0]=0;K[e+13|0]=0;K[e+14|0]=0;K[e+15|0]=0;K[e+16|0]=0;K[e+17|0]=0;K[e+18|0]=0;K[e+19|0]=0;K[e+20|0]=0;K[e+21|0]=0;K[e+22|0]=0;K[e+23|0]=0}function Ci(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=M[a>>2];g=Cb(h);m=M[M[a+4>>2]+12>>2];i=Gb(h);j=Gb(h);l=M[h+48>>2]+1|0;M[h+48>>2]=l;k=M[h+60>>2]-1|0;M[h+60>>2]=k;gk(a,c,i);gk(a,e,j);c=N[m+16|0];e=c&1;a=e?(b|0)==58?56:(b|0)==55?57:58:b;if(c&2){c=fb(g,52,i);a:{b:{switch(a-55|0){case 3:$a(g,9,0,f);break a;case 0:$a(g,52,j,f);break a;case 1:break b;default:break a}}$a(g,51,j,f)}$a(g,9,0,k);M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(c,20)|0)+8>>2]=M[g+108>>2];$a(g,51,j,(a|0)==55?k:(a|0)==58?k:f)}nb(g,118,0,l,0,30808,-1);c=bb(g,58,l,0,i);if((b|0)==58){bb(g,a,j,f,i)}bb(g,e?108:107,d,i,i);d=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(c,20)|0)+8>>2]=d;bb(g,a,j,f,i);Jc(g,Lf(h,M[m+8>>2]),-2);a=M[g+108>>2];if((a|0)>0){L[(M[g+104>>2]+S(a,20)|0)-18>>1]=128}pb(g,k);zb(h,i);zb(h,j)}function Km(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=Na-48|0;Na=d;c=N[b|0];a:{if((c|0)!=139){if((c|0)!=168){b=0;break a}f=L[b+32>>1];while(1){c=0;b:{while(1){if(!a|c){break b}c=0;e=M[a+4>>2];g=M[e>>2];g=(g|0)>0?g:0;j=e+24|0;c:{while(1){if((c|0)==(g|0)){break c}i=S(c,48);if(M[i+j>>2]!=M[b+28>>2]){c=c+1|0;continue}break}e=e+i|0;c=M[e+16>>2];h=0;if(!(N[e+21|0]&4)){continue}h=M[M[e+52>>2]>>2];continue}break}a=M[a+12>>2];continue}break}b=0;if(!c){break a}if(h){c=M[h+28>>2];if(M[c>>2]<=(f|0)){break a}b=M[(c+(f<<4)|0)+8>>2];M[d+16>>2]=M[h+32>>2];M[d+24>>2]=a;M[d+12>>2]=M[a>>2];b=Km(d+12|0,b);break a}if((f|0)<0){b=19635;break a}b=pl(M[c+4>>2]+S(f,12)|0,0);break a}b=M[b+20>>2];c=M[M[b+28>>2]+8>>2];M[d+16>>2]=M[b+32>>2];M[d+24>>2]=a;M[d+12>>2]=M[a>>2];b=Km(d+12|0,c)}Na=d+48|0;return b}function OE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;a:{if((b|0)==2){if((Sb(M[c>>2])|0)==5){Yb(a);return}i=gb(M[c>>2]);g=sb(M[c+4>>2]);b=Qa;h=b;if((b|0)<0){Pb(a,9163,-1);return}b=Op(i);j=b;l=b>>31;c=l;b:{if((h|0)<=(c|0)&g>>>0<=b>>>0|(c|0)>(h|0)){b=Nl(i);if(!b){break a}vb(a,b,-1,-1);break b}m=yb(i);b=tc((m+(g-b|0)|0)+1|0);if(!b){break a}e=g-j|0;c=h-(l+(g>>>0<j>>>0)|0)|0;d=c>>>1|0;f=((c&1)<<31|e>>>1)+1|0;k=f?d:d+1|0;e=1;d=0;c=b;while(1){if((e|0)!=(f|0)|(d|0)!=(k|0)){K[c|0]=32;e=e+1|0;d=e?d:d+1|0;c=c+1|0;continue}break}e=f;d=0;c=$g(c,i)+m|0;while(1){f=d+l|0;k=e+j|0;f=k>>>0<j>>>0?f+1|0:f;if((f|0)<=(h|0)&g>>>0>=k>>>0|(f|0)<(h|0)){K[c|0]=32;e=e+1|0;d=e?d:d+1|0;c=c+1|0;continue}break}K[c|0]=0}vb(a,b,-1,-1);ab(b);return}ba(23737,17968,880,17888);I()}$b(a)}function lu(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Na-48|0;Na=e;k=M[a+20>>2];f=d;a:{while(1){b:{if(!c|!M[a+16>>2]){break b}if($n(a,c)){break b}h=f-1|0;g=M[a+4>>2];if(Ra[M[g+220>>2]](g,c,e+44|0,0)|0){M[e+32>>2]=c;Vc(a,1973,e+32|0);break a}else{i=M[M[e+44>>2]+4>>2];c:{d:{e:{if(b){j=mb(i+4|0);g=M[a>>2];if(N[g+17|0]){Jg(a,c,2,0);g=M[a>>2]}if((M[g+40>>2]>>>2|0)-2>>>0<j>>>0){break e}c=0;g=(j|0)>0?j:0;l=i+8|0;while(1){if((c|0)!=(g|0)){f=mb((c<<2)+l|0);if(N[M[a>>2]+17|0]){Jg(a,f,2,0)}$n(a,f);c=c+1|0;continue}break}f=h-j|0;break c}if(!N[M[a>>2]+17|0]|!h){break d}Jg(a,mb(i),4,c);break d}M[e+16>>2]=c;Vc(a,2072,e+16|0);f=f-2|0;break c}f=h}c=mb(i);sd(M[e+44>>2]);continue}}break}h=f}if(!(!h|M[a+20>>2]!=(k|0))){M[e>>2]=b?12919:12315;M[e+8>>2]=d;M[e+4>>2]=d-h;Vc(a,2148,e)}Na=e+48|0}function oc(a,b){var c=0,d=0,e=0,f=0;a:{if(!b|!M[a+8>>2]){break a}while(1){c=Ra[M[a+8>>2]](a,b)|0;if(c){return c&2}f=2;if(ec(a,M[b+28>>2])){break a}if(Nb(a,M[b+36>>2])){break a}if(ec(a,M[b+40>>2])){break a}if(Nb(a,M[b+44>>2])){break a}if(ec(a,M[b+48>>2])){break a}if(Nb(a,M[b+60>>2])){break a}d=M[b+72>>2];b:{if(!d){break b}c=M[a+12>>2];c:{if((c|0)==13){break c}e=M[a>>2];if(e){if((c|0)==41|N[e+224|0]>1){break c}break b}if((c|0)!=41){break b}}if(kB(a,d,0)){break a}}d:{c=M[b+32>>2];if(!c){break d}d=c+8|0;e=M[c>>2];while(1){if((e|0)<=0){break d}c=N[d+13|0]|N[d+14|0]<<8;if(c&4){if(oc(a,M[M[d+44>>2]>>2])){break a}c=N[d+13|0]|N[d+14|0]<<8}if(c&8){if(ec(a,M[d+32>>2])){break a}}d=d+48|0;e=e-1|0;continue}}c=M[a+12>>2];if(c){Ra[c|0](a,b)}b=M[b+52>>2];if(b){continue}break}f=0}return f}function Tm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;h=Na-16|0;Na=h;a:{while(1){b:{if(!mc(a,b,c,d)){break b}f=N[c|0];if((f|0)==43){if(Tm(a,b,M[c+12>>2],d)){break b}if(Tm(a,b,M[c+16>>2],d)){break b}f=N[c|0]}if((f|0)==52){if(Pm(a,b,M[c+12>>2],d,0)){break b}}f=0;e=N[b|0];c:{if((e|0)!=158){if((e|0)!=172){break a}e=M[b+8>>2];if((N[e|0]|32)!=105){break a}g=M[b+20>>2];if(!g){break a}i=M[a>>2];e=re(i,e,M[g>>2],N[i+84|0],0);if(!e|!(N[e+6|0]&64)){break a}if(M[e+8>>2]==5){break c}break a}if(M[b+12>>2]){break a}}d:{e:{e=M[b+20>>2];switch(M[e>>2]-2|0){case 0:break d;case 1:break e;default:break a}}g=M[e+40>>2];f=N[g|0];if((f|0)==122){break d}if((f|0)==171){if(!vi(g)){break d}}M[h+12>>2]=1;f=0;if(!gf(g,h+12|0,0)|M[h+12>>2]){break a}e=M[b+20>>2]}b=M[e+8>>2];continue}break}f=1}Na=h+16|0;return f}function em(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=M[a+20>>2];b=M[d+104>>2];h=(b|0)>0?b:0;f=M[a+24>>2];a:{while(1){if((e|0)==(h|0)){break a}b:{c:{g=M[d+100>>2];i=g+S(e,48)|0;if(P[i+20>>2]<f>>>0){break c}if(ol(M[i+16>>2],f)){break c}while(1){e=e+1|0;if((b|0)<=(e|0)){break b}M[(S(e,48)+g|0)+28>>2]=0;continue}}e=e+1|0;continue}break}e=N[d+5|0];if((e|0)!=2){c=M[d+72>>2];if(!M[c>>2]){f=M[d>>2];if(N[d+22|0]|(e|0)==4){b=-1}else{b=M[16873]}c=vv(f,0,c,8222,b);if(c){break a}f=M[a+24>>2];c=M[d+72>>2]}e=M[a+4>>2];h=M[d+56>>2];b=M[d+172>>2];g=M[d+168>>2]+4|0;b=g>>>0<4?b+1|0:b;h=ZJ(h,0,g,b);b=Qa;c=ji(c,h,b,f);if(c){break a}f=M[d+72>>2];g=M[d+168>>2];c=b;b=h+4|0;c=b>>>0<4?c+1|0:c;c=Ra[M[M[f>>2]+12>>2]](f,e,g,b,c)|0;if(c){break a}f=M[a+24>>2]}M[d+56>>2]=M[d+56>>2]+1;c=bp(d,f)}return c}function Zw(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;C(+a);h=x(1)|0;x(0)|0;g=h&2147483640;g=(g|0)==1072010279|g>>>0<1072010279;if(!g){i=(h|0)>0|(h|0)>=0;a=.7853981633974483-U(a)+(3061616997868383e-32-(i?b:-b));b=0}e=a*a;d=a*e;j=d*.3333333333333341;f=d;d=e*e;e=j+(e*(f*(d*(d*(d*(d*(d*-18558637485527546e-21+7817944429395571e-20)+.0005880412408202641)+.0035920791075913124)+.021869488294859542)+.13333333333320124+e*(d*(d*(d*(d*(d*2590730518636337e-20+7140724913826082e-20)+.0002464631348184699)+.0014562094543252903)+.0088632398235993)+.05396825397622605))+b)+b);b=a+e;if(!g){f=b*b;d=b;b=+(1-(c<<1)|0);a=a+(e-f/(d+b));a=b-(a+a);return i?a:-a}if(c){f=-1/b;C(+f);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();C(+b);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);b=+B();b=f*(d*(e-(b-a))+(d*b+1))+d}return b}function VE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{b:{c:{if((b&-2)==2){d:{if((Sb(M[c>>2])|0)!=5){if((Sb(M[c+4>>2])|0)!=5){break d}}Yb(a);return}f=gb(M[c>>2]);if(!f){break a}d=gb(M[c+4>>2]);if((b|0)==3){b=sb(M[c+8>>2]);i=((b|0)<=1?1:b)-1|0}if(!N[f|0]){break b}while(1){if(!Ke(d)|(e|0)==(i|0)){break c}e=e+1|0;while(1){b=K[d+1|0];d=d+1|0;if((b|0)<-64){continue}break}continue}}ba(23727,17968,1038,17604);I()}e=0;while(1){c=f;b=d;if(!Ke(b)){break b}while(1){g=Ke(c);l=Ke(b);while(1){h=K[c+1|0];j=c+1|0;c=j;if((h|0)<-64){continue}break}c=b;while(1){h=K[c+1|0];b=c+1|0;c=b;if((h|0)<-64){continue}break}if(g){c=j;if((g|0)==(l|0)){continue}}break}if(g){while(1){b=K[d+1|0];d=d+1|0;if((b|0)<-64){continue}break}k=k+1|0;continue}break}e=(i+k|0)+1|0}Ac(a,e)}}function qp(a,b,c){a=M[a+4>>2];a:{switch(b-206|0){case 0:case 35:case 36:case 48:case 50:pc(M[a>>2],M[c>>2]);return;case 12:case 13:case 42:case 44:case 64:case 75:case 77:case 80:case 87:case 92:case 109:kb(M[a>>2],M[c>>2]);return;case 17:case 27:case 28:case 40:case 43:case 45:case 49:case 51:case 58:case 65:case 74:case 76:case 108:xb(M[a>>2],M[c>>2]);return;case 34:case 41:case 53:case 54:case 59:Gc(M[a>>2],M[c>>2]);return;case 37:Nk(M[a>>2],M[c>>2]);return;case 47:case 104:io(M[a>>2],M[c>>2]);return;case 60:case 67:ye(M[a>>2],M[c>>2]);return;case 70:case 105:case 106:case 107:case 110:Ok(M[a>>2],M[c>>2]);return;case 83:case 88:On(M[a>>2],M[c>>2]);return;case 85:ye(M[a>>2],M[c+4>>2]);return;case 112:case 113:case 114:kb(M[a>>2],M[c+4>>2]);break;default:break a}}}function py(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=Na-16|0;Na=e;a:{if(O[a+4>>1]<=1){c=M[a>>2];M[c+56>>2]=M[c+56>>2]+1;b:{if((Db(M[a+12>>2])|0)!=100){K[a+6|0]=1;b=wb(M[a+12>>2]);break b}g=a,h=dd(M[a+12>>2],0),M[g+32>>2]=h;M[a+36>>2]=Qa;b=0}M[c+56>>2]=M[c+56>>2]-1;break a}M[e+12>>2]=0;b=M[a+16>>2];c:{if(b){while(1){if(!N[a+7|0]){wb(M[a+12>>2])}d=e+12|0;pd(a,b,d);c=N[b+32|0];M[a+88>>2]=1;K[a+7|0]=1;K[a+6|0]=c;f=M[b+28>>2];M[a+32>>2]=M[b+24>>2];M[a+36>>2]=f;if(!c){if(iq(a,d)){continue}}break}b=M[e+12>>2];if(b){break a}break c}K[a+6|0]=1}b=M[a+32>>2];c=M[a+36>>2];d:{e:{if(!N[a+52|0]){d=P[a+80>>2]<b>>>0;b=M[a+84>>2];if(d&(b|0)<=(c|0)|(b|0)<(c|0)){break e}break d}d=M[a+76>>2];if((d|0)<=(c|0)&P[a+72>>2]<=b>>>0|(c|0)>(d|0)){break d}}K[a+6|0]=1}b=0}Na=e+16|0;return b|0}function xw(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Na-48|0;Na=g;f=M[a+16>>2];Fc(M[f+88>>2]+40|0,b,c);a:{if(M[f+32>>2]>=5){M[f+32>>2]=4;e=bs(f);break a}e=Db(M[a+16>>2])}b:{if((e|0)==100){e=11727;c:{c=O[a+8>>1];f=M[M[f+96>>2]>>2];if(c>>>0<O[f+54>>1]){b=f+84|0;e=M[b+(c<<2)>>2];if(e>>>0>11){break c}e=e?(e|0)==7?11949:9716:11727}b=M[a+20>>2];M[g>>2]=e;b=tb(b,6928,g);cd(M[a+16>>2]);M[a+16>>2]=0;e=1;break b}M[a+4>>2]=M[(L[f+52>>1]+c<<2)+b>>2];M[a>>2]=e>>>0>=128?e-12>>>1|0:N[e+34560|0];b=a;a=M[f+36>>2];M[b+12>>2]=a;K[a+1|0]=N[a+1|0]|16;K[M[a+8>>2]+11|0]=1;b=0;e=0;break b}f=M[a+16>>2];if(!f){b=0;break b}e=cd(f);M[a+16>>2]=0;a=M[a+20>>2];if(!e){M[g+16>>2]=b;M[g+20>>2]=c;e=1;b=tb(a,15063,g+16|0);break b}h=g,i=yg(a),M[h+32>>2]=i;b=tb(a,8932,g+32|0)}M[d>>2]=b;Na=g+48|0;return e}function Ph(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;d=N[a|0];e=d<<24>>24;a:{if((e|0)>=0){a=0;c=1;break a}c=K[a+1|0];if((c|0)>=0){d=e&127;a=d>>>25|0;d=c&255|d<<7;c=2;break a}c=c&255;e=K[a+2|0];d=(e&127|d<<14)&2080895;if((e|0)>=0){d=d|c<<7&16256;a=0;c=3;break a}e=K[a+3|0];c=(e&127|c<<14)&2080895;if((e|0)>=0){d=c|d<<7;a=0;c=4;break a}g=N[a+4|0];e=g|d<<14;h=g<<24>>24;if((h|0)>=0){a=d>>>18|0;d=c<<7|e;c=5;break a}f=K[a+5|0];g=f&255|c<<14;d=c|d<<7;if((f|0)>=0){a=d>>>18|0;d=e<<7&266354560|g;c=6;break a}f=K[a+6|0];c=f&255|e<<14;if((f|0)>=0){a=d>>>11|0;d=c&-266354561|g<<7&266354560;c=7;break a}f=K[a+7|0];e=f&255|g<<14;c=c&2080895;if((f|0)>=0){a=d>>>4|0;d=e&-266354561|c<<7;c=8;break a}c=e<<8&532709120|(N[a+8|0]|c<<15);a=h>>>3&15|d<<4;d=c|0;c=9}M[b>>2]=d;M[b+4>>2]=a;return c}function jc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{b:{g=M[a+4>>2];if(g>>>0<b>>>0){break b}j=M[a>>2];e=j+b|0;f=N[e|0];d=f>>>4|0;i=1;c:{if(f>>>0<=191){break c}d:{switch(d-12|0){case 0:f=0;d=b+1|0;if(d>>>0>=g>>>0){break a}d=N[d+j|0];i=2;break c;case 1:f=0;d=b+2|0;if(d>>>0>=g>>>0){break a}d=N[d+j|0]|N[e+1|0]<<8;i=3;break c;case 2:f=0;d=b+4|0;if(d>>>0>=g>>>0){break a}d=N[d+j|0]|(N[e+2|0]<<16|N[e+1|0]<<24|N[e+3|0]<<8);i=5;break c;default:break d}}d=b+8|0;if(N[e+1|0]|d>>>0>=g>>>0|(N[e+2|0]|N[e+3|0])){break b}f=0;if(N[e+4|0]){break a}d=N[d+j|0]|(N[e+6|0]<<16|N[e+5|0]<<24|N[e+7|0]<<8);i=9}f=i;e=b+d|0;b=e>>>0<b>>>0?1:h;h=e+f|0;b=h>>>0<e>>>0?b+1|0:b;if(!b&h>>>0<=g>>>0){h=d;break a}a=!b&g-M[a+40>>2]>>>0<h>>>0|(b|0)!=0;f=a?0:f;h=a?0:d;break a}f=0}M[c>>2]=h;return f}function es(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Na-32|0;Na=f;a:{c=M[b+24>>2]+M[b+36>>2]|0;if(M[a+40>>2]|!c){break a}h=M[a+8>>2];d=M[b+12>>2];bb(h,75,0,d,(c+d|0)-1|0);c=M[b+32>>2];while(1){if(M[b+36>>2]<=(i|0)){break a}b:{if(M[c+8>>2]<0){break b}d=M[M[c>>2]+20>>2];if(!(M[d>>2]==1?d:0)){cb(a,2851,0);M[c+8>>2]=-1;break b}d=Ue(a,d,0,0);j=c,k=nb(h,117,M[c+8>>2],0,0,d,-8),M[j+12>>2]=k;M[f+16>>2]=M[M[c+4>>2]+32>>2];fc(a,0,25863,f+16|0)}if(M[c+16>>2]>=0){d=!N[c+21|0];e=M[c>>2];g=M[e+12>>2];d=N[c+20|0]?M[M[e+20>>2]>>2]+d|0:d;g=M[g+20>>2];d=N[c+22|0]?M[M[e+20>>2]>>2]+d|0:d;e=Ue(a,g,0,d);if(!(N[c+21|0]|M[a+40>>2])){L[e+6>>1]=O[e+6>>1]+1}nb(h,117,M[c+16>>2],M[g>>2]+d|0,0,e,-8);M[f>>2]=M[M[c+4>>2]+32>>2];fc(a,0,25830,f)}c=c+24|0;i=i+1|0;continue}}Na=f+32|0}function Kh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Na-48|0;Na=e;a:{if(bi(a,32)){K[a+18|0]=0;a=7;break a}j=M[a+8>>2];d=O[a+16>>1];b:{if(d&4){g=M[a>>2];d=M[a+4>>2];l=d;K[e+37|0]=0;h=d;i=g;d=d>>31;g=d;f=i^d;d=f-d|0;h=(g^h)-((f>>>0<g>>>0)+g|0)|0;f=20;while(1){g=aK(d,h,10,0);i=Qa;m=(e+16|0)+f|0,n=d-ZJ(g,i,10,0)|48,K[m|0]=n;if(!(!h&d>>>0<10)){f=f-1|0;d=g;h=i;continue}break}if((l|0)<0){f=f-1|0;K[f+(e+16|0)|0]=45}d=22-f|0;if(d){G(j,(e+16|0)+f|0,d)}f=21-f|0;break b}L[e+36>>1]=0;M[e+28>>2]=0;M[e+32>>2]=0;M[e+16>>2]=0;M[e+20>>2]=j;M[e+24>>2]=32;if(d&32){k=+P[a>>2]+ +M[a+4>>2]*4294967296}else{k=R[a>>3]}R[e>>3]=k;rb(e+16|0,12688,e);f=M[e+32>>2];K[j+f|0]=0}M[a+12>>2]=f;K[a+18|0]=1;d=O[a+16>>1]|514;L[a+16>>1]=c?d&65491:d;Yd(a,b);a=0}Na=e+48|0;return a}function IJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;e=Na-16|0;Na=e;a:{if(!M[b+52>>2]){break a}d=M[b+48>>2];if(!d){break a}c=b;while(1){if(!c){break a}b:{switch(N[c|0]-136|0){case 0:case 3:c=M[c+52>>2];continue;default:break b}}break}if(O[d+20>>1]){break a}f=d+8|0;c=M[d>>2];while(1){if((c|0)<=0){break a}c=c-1|0;if(!(N[M[f+(c<<4)>>2]+5|0]&2)){continue}break}g=2;c=M[a>>2];d=M[c>>2];a=ub(d,76,0);if(!a){break a}M[e+8>>2]=0;M[e+12>>2]=0;f=Ve(c,0,0,0,e+8|0,a,0);if(M[c+40>>2]){Gc(d,f);break a}G(a,b,76);M[b+32>>2]=f;g=0;d=wc(d,180,0);c=ed(M[c>>2],d);M[b+36>>2]=0;K[b|0]=139;M[b+28>>2]=c;M[a+48>>2]=0;M[a+40>>2]=0;M[a+44>>2]=0;M[b+72>>2]=0;M[b+64>>2]=0;M[b+52>>2]=0;M[b+56>>2]=0;M[b+4>>2]=M[b+4>>2]&-65793|65536;M[M[a+52>>2]+56>>2]=a;M[a+60>>2]=0}Na=e+16|0;return g|0}function Tg(a,b){var c=0,d=0,e=0;a:{b:{if(a){c=b-1|0;c:{while(1){if(P[a>>2]>=4001){b=M[a+8>>2];if(!b){break c}d=(c>>>0)/(b>>>0)|0;c=c-S(d,b)|0;d=(d<<2)+a|0;a=M[d+12>>2];if(a){continue}a=kj(b);M[d+12>>2]=a;if(a){continue}break a}break}a=(c>>>3|0)+a|0;K[a+12|0]=N[a+12|0]|1<<(c&7);return 0}e=c+1|0;d=a+12|0;b=(c>>>0)%125|0;c=M[d+(b<<2)>>2];d:{if(c){while(1){if((c|0)==(e|0)){return 0}b=b+1|0;b=b>>>0<=124?b:0;c=M[d+(b<<2)>>2];if(c){continue}break}c=M[a+4>>2];if(c>>>0<62){break d}break b}c=M[a+4>>2];if(c>>>0>=124){break b}}M[a+4>>2]=c+1;M[d+(b<<2)>>2]=e}return 0}c=lc(500,0);if(!c){break a}G(c,d,500);b=0;D(d,0,500);M[a+8>>2]=(M[a>>2]+124>>>0)/125;d=Tg(a,e);while(1){if((b|0)!=125){e=M[c+(b<<2)>>2];if(e){d=Tg(a,e)|d}b=b+1|0;continue}break}ab(c);return d}return 7}function gD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=M[a+4>>2];i=M[f+36>>2];if(i&4){return 778}a=(c>>31)+e|0;k=c+d|0;a=k>>>0<c>>>0?a+1|0:a;g=M[f>>2];h=M[f+4>>2];a:{if(g>>>0<k>>>0&(h|0)<=(a|0)|(a|0)>(h|0)){j=M[f+12>>2];if(k>>>0>P[f+8>>2]&(a|0)>=(j|0)|(a|0)>(j|0)){h=13;if(!(i&2)|M[f+32>>2]>0){break a}g=M[f+16>>2];i=M[f+20>>2];if(g>>>0<k>>>0&(i|0)<=(a|0)|(a|0)>(i|0)){break a}j=k<<1;h=j;l=g;j=g>>>0>j>>>0;g=a<<1|k>>>31;j=j&(g|0)<=(i|0)|(g|0)<(i|0);h=j?h:l;g=j?g:i;i=Ud(M[f+24>>2],h,g);if(!i){return 3082}M[f+8>>2]=h;M[f+12>>2]=g;M[f+24>>2]=i;h=M[f+4>>2];g=M[f>>2]}b:{if((e|0)<=(h|0)&d>>>0<=g>>>0|(e|0)<(h|0)){break b}e=d-g|0;if(!e){break b}D(g+M[f+24>>2]|0,0,e)}M[f>>2]=k;M[f+4>>2]=a}if(c){G(M[f+24>>2]+d|0,b,c)}h=0}return h|0}function Qv(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=Na-32|0;Na=c;g=N[a+16|0];a:{if((g|0)<=(b|0)){break a}e=M[a+8>>2];b:{if(g>>>0>=2){c:{if((b|0)!=1){break c}M[c+16>>2]=510;M[c+20>>2]=0;M[c>>2]=0;d=M[16864]+2|0;M[c+8>>2]=d;M[c+12>>2]=d>>31;if(!Sg(a,c)){break c}M[a+20>>2]=M[18595];d=2314;break a}M[c>>2]=2;M[c+16>>2]=2;M[c+20>>2]=0;d=M[16864];M[c+8>>2]=d;M[c+12>>2]=d>>31;if(Sg(a,c)){break b}K[e+28|0]=1}if(!b){d=M[e+20>>2]-1|0;M[e+20>>2]=d;g=1;f=0;d:{if(d){break d}M[c+16>>2]=0;M[c+20>>2]=0;M[c+8>>2]=0;M[c+12>>2]=0;M[c>>2]=2;if(!Sg(a,c)){K[e+28|0]=0;f=0;break d}M[a+20>>2]=M[18595];g=0;K[e+28|0]=0;K[a+16|0]=0;f=2058}d=f;f=e;e=M[e+24>>2]-1|0;M[f+24>>2]=e;if(!e){Pv(a)}if(!g){break a}}K[a+16|0]=b;d=0;break a}M[a+20>>2]=M[18595];d=2058}Na=c+32|0;return d|0}function jx(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;if(a>>>0<=8){return Je(b)|0}c=16;d=a>>>0<=16?16:a;a:{if(!(d-1&d)){a=d;break a}while(1){a=c;c=a<<1;if(a>>>0<d>>>0){continue}break}}b:{if(-64-a>>>0<=b>>>0){M[18595]=48;b=0;break b}d=b>>>0<11?16:b+11&-8;c=Je((d+a|0)+12|0);b=0;if(!c){break b}b=c-8|0;c:{if(!(c&a-1)){a=b;break c}f=c-4|0;g=M[f>>2];e=a;a=((a+c|0)-1&0-a)-8|0;a=(a-b>>>0<=15?e:0)+a|0;c=a-b|0;e=(g&-8)-c|0;if(!(g&3)){b=M[b>>2];M[a+4>>2]=e;M[a>>2]=b+c;break c}M[a+4>>2]=e|M[a+4>>2]&1|2;e=a+e|0;M[e+4>>2]=M[e+4>>2]|1;M[f>>2]=c|M[f>>2]&1|2;e=b+c|0;M[e+4>>2]=M[e+4>>2]|1;Kl(b,c)}b=M[a+4>>2];d:{if(!(b&3)){break d}c=b&-8;if(c>>>0<=d+16>>>0){break d}M[a+4>>2]=d|b&1|2;b=a+d|0;d=c-d|0;M[b+4>>2]=d|3;c=a+c|0;M[c+4>>2]=M[c+4>>2]|1;Kl(b,d)}b=a+8|0}return b|0}function LG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c=Na-32|0;Na=c;j=1;g=M[a>>2];a:{if((b|0)==1){h=3;f=-1;break a}l=1;i=b>>>1&1;f=b&4;j=f?i?2:1:i;h=19;f=f?i:-1}k=M[g+12>>2];g=a+8|0;eh(g);ab(M[a+72>>2]);ab(M[a+120>>2]);ab(M[a+88>>2]);D(g,0,120);M[a+84>>2]=h;h=a+72|0;b:{c:{d:{if(!i&(b|0)!=1){break d}b=gb(M[e>>2]);if(!b){break d}M[c+16>>2]=b;b=Hb(8932,c+16|0);M[h>>2]=b;if(!b){break c}m=a,n=yb(b),M[m+76>>2]=n}b=0;if((f|0)>=0){m=c,n=gb(M[(f<<2)+e>>2]),M[m>>2]=n;f=Hb(8932,c);M[a+88>>2]=f;if(!f){break c}m=a,n=yb(f),M[m+92>>2]=n}if((d|0)>(j|0)){b=sb(M[(j<<2)+e>>2]);b=(b|0)>0?b:0}M[a+96>>2]=b;b=mi(k,b,0,-2,M[a+72>>2],M[a+76>>2],0,l,g);if(b){break b}b=Vj(k,g,h);if(b){break b}b=Uy(a);break b}b=7}Na=c+32|0;return b|0}function au(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Na-16|0;Na=g;i=M[a+4>>2];h=M[M[a+8>>2]+4>>2];d=co(M[a+12>>2]+S(h,56)|0);if(!d){M[g+12>>2]=0;c=M[a+12>>2];e=c+S(h|1,56)|0;f=S(h&65534,56)+c|0;d=(M[a>>2]+h|0)/2|0;while(1){if((d|0)>0){a:{b:{if(!M[f+24>>2]){break b}c:{d:{if(!M[e+24>>2]){break d}c=Ra[M[i+40>>2]](i,g+12|0,M[f+32>>2],M[f+20>>2],M[e+32>>2],M[e+20>>2])|0;if((c|0)<0){break d}if(c|e>>>0<=f>>>0){break c}}e=M[a+8>>2];c=M[a+12>>2];M[e+(d<<2)>>2]=(f-c|0)/56;e=M[e+((d^1)<<2)>>2];M[g+12>>2]=0;e=S(e,56)+c|0;break a}if(!M[f+24>>2]){break b}M[g+12>>2]=0}f=M[a+8>>2];c=M[a+12>>2];M[f+(d<<2)>>2]=(e-c|0)/56;f=S(M[f+((d^1)<<2)>>2],56)+c|0}d=d>>>1|0;continue}break}M[b>>2]=!M[(S(M[M[a+8>>2]+4>>2],56)+c|0)+24>>2];d=N[M[i+16>>2]+23|0]}Na=g+16|0;return d}function Th(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=M[a+52>>2];b=M[a+56>>2]+N[a+9|0]|0;if(Zu(a,N[b|0])){return db(73006)}c=M[d+36>>2];K[a+12|0]=0;L[a+26>>1]=c-1;e=M[a+56>>2];f=N[a+10|0];M[a+68>>2]=e+f;M[a+60>>2]=c+e;M[a+64>>2]=(b+f|0)+8;L[a+18>>1]=(f+N[a+9|0]|0)+8;b=N[b+3|0]|N[b+4|0]<<8;b=b<<8|b>>>8;L[a+24>>1]=b;if((c-8>>>0)/6>>>0<(b&65535)>>>0){return db(73020)}K[a|0]=1;M[a+20>>2]=-1;if(N[M[d+4>>2]+34|0]&32){b=0;e=M[M[a+52>>2]+40>>2];f=e+(N[a+8|0]?-4:-5)|0;h=M[a+56>>2];c=O[a+18>>1];i=h+c|0;j=c+(O[a+24>>1]<<1)|0;c=0;a:{b:{while(1){if(O[a+24>>1]<=c>>>0){break a}d=(c<<1)+i|0;d=N[d|0]<<8|N[d+1|0];g=72969;if(d>>>0<j>>>0|(d|0)>(f|0)){break b}c=c+1|0;if((e|0)>=((Ra[M[a+76>>2]](a,d+h|0)|0)+d|0)){continue}break}g=72974}b=db(g)}}else{b=0}return b}function rl(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0;a:{if(!(!b|(h?f:0)|((!h|0)==((g|0)!=0|0)|c-1001>>>0<4294966294|!i^!j))){if(jb(b)>>>0<256){break a}}return _c(183429)}m=d&54003712;b:{c:{d:{e:{f:{d=d&7;switch(d-1|0){case 0:case 1:case 2:break c;case 3:break f;case 4:break e;default:break d}}d=2;break c}l=rl(a,b,c,m|1,e,f,g,h,i,j,k);if(l){break b}l=rl(a,b,c,m|2,e,f,g,h,i,j,k);if(l){break b}d=3;break c}d=1}l=0;n=re(a,b,c,d,0);g:{if(!(!n|(M[n+4>>2]&3)!=(d|0)|L[n>>1]!=(c|0))){if(M[a+184>>2]){ae(a,5,4070,0);return 5}gg(a,0);break g}if(!(f|h)){break b}}b=re(a,b,c,d,1);if(!b){return 7}lx(a,b);if(k){M[k>>2]=M[k>>2]+1}M[b+36>>2]=k;M[b+28>>2]=j;M[b+24>>2]=i;M[b+20>>2]=h;M[b+8>>2]=e;L[b>>1]=c;M[b+16>>2]=f?f:g;M[b+4>>2]=(M[b+4>>2]&3|m)^2097152}return l}function kC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;b=Na-80|0;Na=b;f=M[a>>2];Wn(a);c=0;i=(d|0)>0?d:0;h=a+16|0;d=!(N[M[f+16>>2]+5|0]&32);a:{b:{while(1){if((c|0)!=(i|0)){g=gb(M[(c<<2)+e>>2]);if(g){M[b+48>>2]=g;g=Hb(8932,b+48|0);M[(d<<2)+h>>2]=g;if(!g){break b}}d=d+1|0;c=c+1|0;continue}break}c=M[M[f+12>>2]+124>>2];L[b+76>>1]=0;M[b+72>>2]=0;M[b+68>>2]=c;M[b+64>>2]=0;M[b+56>>2]=0;M[b+60>>2]=0;c=b+56|0;Sd(c,30655);d=M[a+20>>2];if(d){M[b+32>>2]=d;rb(c,25063,b+32|0)}c=b+56|0;Sd(c,M[M[f+16>>2]>>2]);d=M[h>>2];if(d){M[b+16>>2]=d;rb(c,19744,b+16|0)}d=Rd(b+56|0);if(!d){break b}c=th(M[f+12>>2],d,-1,a+4|0,0);ab(d);if(c){j=b,k=yg(M[f+12>>2]),M[j>>2]=k;j=f,k=Hb(8932,b),M[j+8>>2]=k;break a}c=qt(a);break a}c=7}Na=b+80|0;return c|0}function Ve(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0;i=Na-16|0;Na=i;j=M[a>>2];a:{b:{c:{d:{if(!g|b){break d}if(M[g>>2]){b=20082}else{if(!M[g+4>>2]){break d}b=20363}M[i>>2]=b;cb(a,6892,i);break c}b=Od(a,b,c,d);if(b){h=(S(M[b>>2],48)+b|0)-40|0;e:{if(N[a+224|0]<2){break e}k=M[h>>2];if(!k){break e}Ce(a,k,(M[d>>2]?d:0)?d:c)}if(M[e+4>>2]){l=h,m=zc(j,e),M[l+4>>2]=m}f:{if(!f){break f}if(!sh(a,h,f,0)|!(N[f+5|0]&8)){break f}a=N[h+13|0]|N[h+14|0]<<8|16384;K[h+13|0]=a;K[h+14|0]=a>>>8}if(!g){M[h+40>>2]=0;break a}if(M[g+4>>2]){a=N[h+13|0]|N[h+14|0]<<8|2048;K[h+13|0]=a;K[h+14|0]=a>>>8;M[h+40>>2]=M[g+4>>2];break a}M[h+40>>2]=M[g>>2];break a}if(!g){break b}}a=M[g>>2];if(a){me(j,a);break b}a=M[g+4>>2];if(!a){break b}ye(j,a)}pc(j,f);b=0}Na=i+16|0;return b}function Uq(a){var b=0,c=0,d=0,e=0,f=0;a:{if(M[a+48>>2]){break a}e=M[a+12>>2];b=M[e+56>>2];f=ac(M[e+72>>2]);if(f){break a}f=0;c=M[8407];d=M[8406];K[b+8|0]=d;K[b+9|0]=d>>>8;K[b+10|0]=d>>>16;K[b+11|0]=d>>>24;K[b+12|0]=c;K[b+13|0]=c>>>8;K[b+14|0]=c>>>16;K[b+15|0]=c>>>24;c=M[8405];d=M[8404];K[b|0]=d;K[b+1|0]=d>>>8;K[b+2|0]=d>>>16;K[b+3|0]=d>>>24;K[b+4|0]=c;K[b+5|0]=c>>>8;K[b+6|0]=c>>>16;K[b+7|0]=c>>>24;K[b+16|0]=M[a+36>>2]>>>8;K[b+17|0]=O[a+38>>1];K[b+18|0]=1;K[b+19|0]=1;c=M[a+40>>2];d=M[a+36>>2];K[b+21|0]=64;K[b+22|0]=32;K[b+23|0]=32;K[b+20|0]=d-c;D(b+24|0,0,76);Oh(e,13);L[a+24>>1]=O[a+24>>1]|2;K[b+55|0]=N[a+17|0];K[b+54|0]=0;K[b+52|0]=0;K[b+53|0]=0;K[b+67|0]=N[a+18|0];K[b+66|0]=0;K[b+64|0]=0;K[b+65|0]=0;M[a+48>>2]=1;K[b+31|0]=1}return f}function rc(a){var b=0,c=0;a:{b:while(1){b=K[a|0];while(1){c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{b=b&255;switch(b-168|0){case 0:break k;case 1:break e;case 2:break j;default:break l}}m:{switch(b-177|0){case 0:break f;case 1:break g;default:break m}}if((b|0)==36){break h}if((b|0)!=139){break e}a=M[M[a+20>>2]+28>>2]+8|0;break d}c=M[a+44>>2];break i}c=M[a+44>>2];if(!c){break e}}a=L[a+32>>1];b=68;if((a|0)<0|(a|0)>=L[c+34>>1]){break a}b=K[(M[c+4>>2]+S(a,12)|0)+5|0];break a}b=Si(M[a+8>>2],0);break a}a=(M[M[M[a+12>>2]+20>>2]+28>>2]+(L[a+32>>1]<<4)|0)+8|0;break d}a=M[a+20>>2]+8|0;break d}if(!((N[a+5|0]|N[a+6|0]<<8)&1056)){break c}a=a+12|0}a=M[a>>2];continue b}if((b|0)==176){b=N[a+2|0];if((b|0)!=176){continue}}break}break}b=K[a+1|0]}return b<<24>>24}function lc(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;a:{b=b-(a>>>0<2147483392)|0;b:{if((b|0)==-1&a-2147483392>>>0<2147483905|(b|0)!=-1){break b}if(M[16866]){d=Ra[M[16878]](a)|0;if(a>>>0>P[18479]){M[18479]=a}a=M[18547];f=a;c=M[18546];c:{if(!c&(a|0)<=0|(a|0)<0){break c}a=M[18464];b=c-d|0;e=f;f=d>>31;c=e-(f+(c>>>0<d>>>0)|0)|0;if((c|0)<0){b=1}else{b=(c|0)<=0&a>>>0>=b>>>0}if(b){M[18550]=1;e=M[18548];b=e-d|0;c=M[18549];g=!(c|e);c=c-((d>>>0>e>>>0)+f|0)|0;if((c|0)>0){a=1}else{a=a>>>0<b>>>0&(c|0)>=0}if(g|a){break c}break b}M[18550]=0}b=Ra[M[16874]](d)|0;if(!b){break b}a=(Ra[M[16877]](b)|0)+M[18464]|0;M[18464]=a;if(a>>>0>P[18474]){M[18474]=a}a=M[18473]+1|0;M[18473]=a;if(a>>>0<=P[18483]){break a}M[18483]=a;break a}h=Ra[M[16874]](a)|0}return h}return b}function gq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Na-32|0;Na=f;M[f+28>>2]=0;M[f+24>>2]=0;M[f+20>>2]=0;M[f+12>>2]=0;a:{if(!c){M[e>>2]=0;break a}g=M[a+36>>2];j=M[g>>2];g=pg(g,b,c,-1,f+8|0);if(g){break a}m=M[j+20>>2];k=M[f+8>>2];b=0;c=0;b:while(1){c:{if(c){break c}c=Ra[m|0](k,f+16|0,f+12|0,f+28|0,f+24|0,f+20|0)|0;if(c){break c}c=1;h=M[f+20>>2];b=(b|0)>(h|0)?b:h+1|0;if((h|0)<0){break c}i=M[f+16>>2];if(!i){break c}l=M[f+12>>2];if((l|0)<=0){break c}g=1;c=Hx(a,d,h,M[a+264>>2]+4|0,i,l);while(1){if(M[a+260>>2]<=(g|0)|c){continue b}c=0;h=M[a+264>>2]+S(g,24)|0;i=M[h>>2];if((i|0)<=M[f+12>>2]){c=Hx(a,d,M[f+20>>2],h+4|0,M[f+16>>2],i)}g=g+1|0;continue}}break}Ra[M[j+16>>2]](k)|0;M[e>>2]=M[e>>2]+b;g=(c|0)!=101?c:0}Na=f+32|0;return g}function PI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;e=Na-16|0;Na=e;d=gb(M[c>>2]);M[e+8>>2]=d;f=Fb(M[c>>2]);a:{if((b|0)!=2){h=30808;b=0;break a}h=gb(M[c+4>>2]);b=Fb(M[c+4>>2])}b:{if(!d|!h){break b}c:{c=((f|0)/2|0)+1|0;g=hh(a,c,c>>31);if(!g){f=0;break c}i=b+h|0;f=g;while(1){b=N[d|0];if(!b){break c}d:{if(!(N[b+31408|0]&8)){e:{if(b<<24>>24>=0){M[e+8>>2]=d+1;break e}b=nd(e+8|0)}M[e+12>>2]=h;while(1){c=M[e+12>>2];if(c>>>0>=i>>>0){break d}d=K[c|0];f:{if((d|0)>=0){M[e+12>>2]=c+1;break f}d=nd(e+12|0)}if((b|0)!=(d|0)){continue}break}d=M[e+8>>2];continue}c=d+2|0;M[e+8>>2]=c;d=N[d+1|0];if(!(N[d+31408|0]&8)){break d}K[f|0]=d+(d<<25>>31&9)&15|(b<<25>>31&9)+b<<4;f=f+1|0;d=c;continue}break}ab(g);break b}te(a,g,f-g|0,1)}Na=e+16|0}function gI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=Na-304|0;Na=b;e=M[M[a>>2]+20>>2];d=sb(M[c>>2]);h=gb(M[c+4>>2]);f=sb(M[c+8>>2]);c=M[M[e+16>>2]+(d<<4)>>2];j=M[e+364>>2];M[e+364>>2]=0;c=fk(b+16|0,c,e,h,(d|0)==1);a:{if(c){break a}b:{c=M[b+268>>2];c:{if(!c){break c}d=L[c+34>>1];if((d|0)==1){break c}if((d|0)>(f|0)){break b}}c=db(119043);break a}g=b+16|0;i=S(f,12);d=hd(g,0,M[i+M[c+4>>2]>>2]);d:{if((f|0)<(L[c+34>>1]-1|0)){f=M[hd(g,0,M[(i+M[c+4>>2]|0)+12>>2])+4>>2];c=M[d+4>>2];break d}f=M[c+44>>2]+h|0;c=M[d+4>>2];while(1){g=N[c|0];if(!g|(g|0)==44){break d}c=c-1|0;M[d+4>>2]=c;continue}}M[b+8>>2]=f;M[b+4>>2]=h;M[b>>2]=c-h;c=tb(e,6096,b);vb(a,c,-1,-1);ab(c);c=0}dk(b+16|0);M[e+364>>2]=j;if(c){ee(a,c)}Na=b+304|0}function Tx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=Na-16|0;Na=h;a:{b:{j=M[b+8>>2];if(!j){break b}m=N[a+239|0]?108:109;i=M[b>>2];g=i;while(1){if(!M[M[g>>2]+80>>2]){break b}f=M[i>>2];k=M[f+88>>2];l=M[f+92>>2];g=1;f=$l(a,f,h+12|0,h+8|0);c:{while(1){if(!((g|0)>=(j|0)|f)){f=M[(g<<2)+i>>2];if(!M[f+80>>2]|(M[f+88>>2]!=(k|0)|(l|0)!=M[f+92>>2])){break c}g=g+1|0;f=$l(a,f,0,0);continue}break}if(f){break a}}ki(M[b>>2],j,g,m);g=M[h+8>>2];if(!(!M[M[i>>2]+56>>2]|(g|0)<=0)){f=Iy(b,M[h+12>>2],g+1|0,0);if(f){break a}M[h+12>>2]=M[b+16>>2]}f=M[b+32>>2];if((f|0)>=0){Fy(f,1,h+12|0,h+8|0);g=M[h+8>>2]}if((g|0)>0){M[d>>2]=M[h+12>>2];M[c>>2]=k;M[c+4>>2]=l;M[e>>2]=g;f=0;break a}else{g=M[b>>2];continue}}}f=0;M[d>>2]=0}Na=h+16|0;return f}function Pt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=M[a+116>>2];d=M[a+40>>2];e=O[a+48>>1];if(!(P[c+60>>2]>=d+e>>>0&d>>>0>=M[c+56>>2]+O[c+18>>1]>>>0)){return db(80057)}f=e;e=M[b+32>>2]+M[b+28>>2]|0;if((f|0)==(e|0)){return Mk(c,d,b,0,e)}e=Na-16|0;Na=e;d=M[b+32>>2];g=M[b+28>>2];f=M[a+116>>2];M[e+12>>2]=f;c=Mk(f,M[a+40>>2],b,0,O[a+48>>1]);a:{if(c){break a}g=d+g|0;d=O[a+48>>1];h=mb(d+M[a+40>>2]|0);i=M[f+52>>2];f=M[i+40>>2]-4|0;while(1){c=xd(i,h,e+12|0,0);if(c){break a}a=M[e+12>>2];b:{if(!(M[M[a+72>>2]+32>>2]==1&!N[a|0])){c=db(80029);break b}c:{if(g>>>0>d+f>>>0){c=M[a+56>>2];h=mb(c);break c}f=g-d|0;c=M[a+56>>2]}c=Mk(a,c+4|0,b,d,f)}sd(M[a+72>>2]);if(c){break a}d=d+f|0;if((g|0)>(d|0)){continue}break}c=0}Na=e+16|0;return c}function lq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Na-16|0;Na=g;e=M[a+64>>2];c=M[e>>2];a:{if(!c|(N[a+17|0]-4&255)>>>0>252){break a}f=M[a+168>>2];d=Ra[M[c+24>>2]](e,g+8|0)|0;j=f>>31;e=ZJ(f,j,b,0);c=Qa;i=c;M[g>>2]=e;M[g+4>>2]=c;if(d){break a}d=0;c=M[g+8>>2];h=M[g+12>>2];if((e|0)==(c|0)&(i|0)==(h|0)){break a}b:{c:{if((i|0)<=(h|0)&c>>>0>e>>>0|(i|0)<(h|0)){f=M[a+64>>2];d=Ra[M[M[f>>2]+16>>2]](f,e,i)|0;break c}d=h+j|0;h=c;c=c+f|0;d=h>>>0>c>>>0?d+1|0:d;if(c>>>0>e>>>0&(d|0)>=(i|0)|(d|0)>(i|0)){break b}e=M[a+224>>2];d=f;if(f){D(e,0,f)}c=M[a+64>>2];Ra[M[M[c>>2]+40>>2]](c,5,g)|0;h=M[a+64>>2];c=M[g>>2];d=Ra[M[M[h>>2]+12>>2]](h,e,d,c-f|0,M[g+4>>2]-(j+(c>>>0<f>>>0)|0)|0)|0}if(d){break a}}M[a+36>>2]=b;d=0}Na=g+16|0;return d}function YG(a){a=a|0;var b=0,c=0;c=lw(a,1426,56832);a:{if(c){break a}b=tc(24);if(!b){return 7}M[b+4>>2]=0;M[b+8>>2]=0;L[b>>1]=257;M[b+12>>2]=0;M[b+16>>2]=0;M[b+20>>2]=0;c=7;b:{if(Wj(b,14117,7,57104)){break b}if(Wj(b,9323,7,57132)){break b}if(Wj(b,23883,10,53948)){break b}c=sl(a,9245,1,524289,b,102,0,0);if(c){break b}c=sl(a,9245,2,524289,b,102,0,0);if(c){break b}c=Yh(a,3420,-1);if(c){break b}c=Yh(a,4201,1);if(c){break b}c=Yh(a,10208,1);if(c){break b}c=Yh(a,10208,2);if(c){break b}c=Yh(a,12937,1);if(c){break b}M[b+20>>2]=M[b+20>>2]+1;c=vl(a,23625,53848,b,103);if(c){break a}M[b+20>>2]=M[b+20>>2]+1;c=vl(a,23496,53848,b,103);if(c){break a}M[b+20>>2]=M[b+20>>2]+1;return vl(a,12924,57556,b,103)|0}cm(b);ab(b)}return c|0}function ck(a){var b=0,c=0,d=0,e=0,f=0;if(!N[a+41|0]){a:{if(!N[a+40|0]){M[a+8>>2]=2e3;M[a+12>>2]=1;b=1;c=16;break a}b=M[a+4>>2];c=M[a>>2];if((b|0)==108096&c>>>0>=275971584|b>>>0>108096){D(a,0,48);K[a+44|0]=2;return}c=c+432e5|0;b=c>>>0<432e5?b+1|0:b;c=aK(c,b,864e5,0);d=(+(c>>>0)+32044.75)/36524.25;if(U(d)<2147483647){b=~~d}else{b=-2147483648}c=((b+c|0)+((b+48|0)/-4|0)|0)+1498|0;d=(+(c|0)+-122.1)/365.25;if(U(d)<2147483647){b=~~d}else{b=-2147483648}c=c-((S(b&32767,36525)>>>0)/100|0)|0;d=+(c|0)/30.6001;if(U(d)<2147483647){e=~~d}else{e=-2147483648}f=((e|0)<14?-1:-13)+e|0;M[a+12>>2]=f;d=+(e|0)*30.6001;if(U(d)<2147483647){e=~~d}else{e=-2147483648}M[a+16>>2]=c-e;b=((f|0)>2?-4716:-4715)+b|0;c=8}M[c+a>>2]=b;K[a+41|0]=1}}function aj(a,b){var c=0,d=0,e=0;if(N[b+5|0]&16){c=M[b+80>>2];M[b+80>>2]=0;K[b+5|0]=N[b+5|0]&239;d=M[c>>2];if(d){Zg(d);M[c>>2]=0}ib(M[a>>2],c);aj(a,b);return}a:{b:{switch(N[b|0]){case 1:c=M[b+36>>2];if(!c){break a}a=M[a>>2];Iu(a,c);ab(M[c+44>>2]);ib(a,c);M[b+36>>2]=0;return;case 0:c=M[b+36>>2];e=M[c+8>>2];if(!e){break a}d=M[c+20>>2];M[M[e+4>>2]+4>>2]=M[e>>2];a=M[d+8>>2];c:{if((c|0)==(a|0)){M[d+8>>2]=M[c+24>>2];break c}while(1){b=M[a+24>>2];if((b|0)==(c|0)){M[a+24>>2]=M[c+24>>2];break c}a=b;if(b){continue}break}}Nh(c);Oo(d);ab(M[c+12>>2]);ab(M[c+16>>2]);if(!(M[d+8>>2]|!(N[d+16|0]&4))){Cf(e)}M[c+8>>2]=0;return;case 2:break b;default:break a}}b=M[b+36>>2];a=M[b>>2];M[a+4>>2]=M[a+4>>2]-1;Ra[M[M[a>>2]+28>>2]](b)|0}}function sw(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=M[b>>2];f=M[a+12>>2];h=M[f+68>>2];L[a+152>>1]=O[a+152>>1]&65343|64;g=M[a+104>>2]+S(M[a+108>>2],20)|0;while(1){c=g;g=c-20|0;d=N[g|0];if(d>>>0>64){continue}a:{b:{c:{d:{e:{f:{g:{switch(d|0){case 0:case 1:break f;case 2:break g;case 3:case 4:case 5:break e;case 6:break c;case 7:break d;case 8:break a;default:break b}}if(!M[c-12>>2]){break f}L[a+152>>1]=O[a+152>>1]&65471}L[a+152>>1]=O[a+152>>1]|128;continue}L[a+152>>1]=O[a+152>>1]&65343|128;continue}c=M[c-12>>2];e=(c|0)>(e|0)?c:e;continue}d=M[c-36>>2];e=(e|0)<(d|0)?d:e}c=c-12|0;d=M[c>>2];if((d|0)>=0){continue}M[c>>2]=M[((d^-1)<<2)+h>>2];continue}break}if(h){cc(M[a>>2],M[f+68>>2]);M[f+68>>2]=0}M[f+60>>2]=0;M[b>>2]=e}function RA(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Na-48|0;Na=e;h=c+8|0;k=M[a>>2];l=M[M[b+28>>2]>>2];a:{while(1){if(M[c>>2]>(j|0)){i=M[h>>2];f=$c(i);b:{if(!f){break b}c:{if(N[d|0]!=71){g=QA(M[b+28>>2],f);M[e+12>>2]=g;if((g|0)>0){break c}}if(gf(f,e+12|0,0)){g=M[e+12>>2];if(g-65536>>>0>4294901760){break c}ur(k,d,j+1|0,l,f);f=1;break a}g=0;L[h+12>>1]=0;f=1;if(id(a,i)){break a}while(1){f=M[b+28>>2];if(M[f>>2]<=(g|0)){break b}if(!mc(0,i,M[(f+(g<<4)|0)+8>>2],-1)){if(M[b+68>>2]){M[e+32>>2]=0;M[e+36>>2]=0;M[e+24>>2]=0;M[e+28>>2]=0;M[e+16>>2]=0;M[e+20>>2]=0;M[e+40>>2]=b;M[e+20>>2]=88;Nb(e+16|0,i)}L[h+12>>1]=g+1}g=g+1|0;continue}}L[h+12>>1]=g}h=h+16|0;j=j+1|0;continue}break}f=mn(k,b,c,d)}Na=e+48|0;return f}function Ud(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;if(!a){return lc(b,c)}if(!(b|c)){ab(a);return 0}a:{b:{if(!c&b>>>0>2147483391|c){break b}h=Ra[M[16877]](a)|0;f=Ra[M[16878]](b)|0;if((h|0)==(f|0)){return a}if(M[16866]){if(b>>>0>P[18479]){M[18479]=b}c=f-h|0;c:{if((c|0)<=0){break c}b=M[18464];d=M[18546];e=d-c|0;d=M[18547]-(c>>>0>d>>>0)|0;if((d|0)>0){g=1}else{g=b>>>0<e>>>0&(d|0)>=0}if(g){break c}d=M[18549];g=d;e=M[18548];if(!e&(d|0)<=0|(d|0)<0){break c}d=e-c|0;c=g-(c>>>0>e>>>0)|0;if((c|0)<0){b=1}else{b=(c|0)<=0&b>>>0>=d>>>0}if(b){break b}}a=Ra[M[16876]](a,f)|0;if(!a){break b}b=Ra[M[16877]](a)|0;b=M[18464]+(b-h|0)|0;M[18464]=b;if(b>>>0<=P[18474]){break a}M[18474]=b;break a}i=Ra[M[16876]](a,f)|0}return i}return a}function Dq(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(N[a+35|0]){break a}g=M[a>>2];e=g+b|0;d=N[e|0];f=d>>>4|0;f=d>>>0>=192?(f|0)==12?-1:(f|0)==13?-2:-4:0;d=0;b:{if(c>>>0<12){break b}if(c>>>0<256){j=1;d=1;break b}i=c>>>0<65536;d=i?2:4}d=d+f|0;if(d){f=M[a+4>>2];h=d+f|0;c:{if((d|0)>0){if(P[a+8>>2]<h>>>0){if(Xj(a,h)){break a}g=M[a>>2];f=M[a+4>>2]}e=b+g|0;b=(b^-1)+f|0;if(!b){break c}f=e+1|0;G(f+d|0,f,b);break c}b=(d+(b^-1)|0)+f|0;if(!b){break c}G(e+1|0,(e-d|0)+1|0,b)}M[a+4>>2]=h}a=N[e|0]&15;if(c>>>0<=11){K[e|0]=a|c<<4;return d}if(j){K[e+1|0]=c;K[e|0]=a|192;return d}if(i){K[e+2|0]=c;K[e+1|0]=c>>>8;K[e|0]=a|208;return d}K[e+4|0]=c;K[e+3|0]=c>>>8;K[e+2|0]=c>>>16;K[e+1|0]=c>>>24;K[e|0]=a|224;return d}return 0}function Zf(a){var b=0,c=0;a:{b:{c:{c=K[a+68|0];d:{if((c|0)>=0){b=M[a+116>>2];if(!c){break d}qf(b);c=a+120|0;while(1){b=N[a+68|0]-1|0;K[a+68|0]=b;if(!(b&255)){break c}qf(M[c+(b<<24>>24<<2)>>2]);continue}}b=M[a+64>>2];if(!b){break a}c=N[a|0];if(c>>>0>=3){if((c|0)==4){return M[a+4>>2]}_k(a);b=M[a+64>>2]}b=Ui(M[a+20>>2],b,a+116|0,N[a+2|0]);if(b){K[a|0]=1;return b}K[a+68|0]=0;b=M[a+116>>2];K[a+69|0]=N[b+1|0]}if(N[b+1|0]==(!M[a+112>>2]|0)?N[b|0]:0){break b}return db(76337)}b=M[a+120>>2];M[a+116>>2]=b}L[a+50>>1]=0;L[a+70>>1]=0;K[a+1|0]=N[a+1|0]&241;if(O[b+24>>1]){K[a|0]=0;return 0}if(!N[b+8|0]){if(M[b+4>>2]!=1){return db(76349)}b=mb((M[b+56>>2]+N[b+9|0]|0)+8|0);K[a|0]=0;return Ig(a,b)}}K[a|0]=1;return 16}function wt(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0;f=M[16930];a:{if(f){g=266;if(Ra[f|0](201)|0){break a}}if(M[b+44>>2]){M[b+44>>2]=0}M[b>>2]=d;M[b+4>>2]=e;f=M[c+12>>2];g=M[c+8>>2];M[b+8>>2]=g;M[b+12>>2]=f;c=M[c>>2];M[b+24>>2]=c;i=g;g=M[a+12>>2];h=M[M[g+24>>2]+168>>2];i=i>>>0>h>>>0;h=h>>31;if(!(i&(h|0)<=(f|0)|(f|0)>(h|0)|M[M[c>>2]>>2]<3)){M[b+44>>2]=0;g=M[a+12>>2]}f=M[g+12>>2];a=d;d=f>>31;a=$J(a,e,f,d);e=Qa;g=0;c=M[b+36>>2];if(!c){c=lc(f,d);M[b+40>>2]=f;M[b+36>>2]=c;g=c?0:7}if(!(a|e)|g){break a}h=M[b+24>>2];i=a+c|0;c=M[b+8>>2];d=M[b>>2];e=c-d|0;g=M[b+12>>2];j=M[b+4>>2];b=f-a|0;a=(b>>31)+j|0;f=b+d|0;a=f>>>0<b>>>0?a+1|0:a;g=Ra[M[M[h>>2]+8>>2]](h,i,c>>>0<f>>>0&(a|0)>=(g|0)|(a|0)>(g|0)?e:b,d,j)|0}return g}function vF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((b|0)==1){if((Sb(M[c>>2])|0)==5){Yb(a);return}e=Kb(M[c>>2]);M[18595]=0;h=a;C(+e);a=x(1)|0;c=x(0)|0;b=a&2147483647;a:{if(b>>>0>=1072693248){d=e*1.5707963267948966+752316384526264e-51;if(!(b-1072693248|c)){break a}d=0/(e-e);break a}b:{if(b>>>0<=1071644671){if(b+-1048576>>>0<1044381696){break b}d=e*Gj(e*e)+e;break a}d=(1-U(e))*.5;f=$(d);e=Gj(d);c:{if(b>>>0>=1072640819){d=f*e+f;d=1.5707963267948966-(d+d+-6123233995736766e-32);break c}C(+f);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);g=+B();d=(d-g*g)/(f+g);d=.7853981633974483-(g+g)-((f+f)*e-(6123233995736766e-32-(d+d)))+.7853981633974483}e=(a|0)<0?-d:d}d=e}Zb(h,d);return}ba(23875,17968,379,17725);I()}function pz(a,b){var c=0,d=0,e=0,f=0,g=0;c=yp(a);a:{if(!c){f=7;c=M[M[a>>2]+20>>2];e=ub(c,24,0);if(!e){break a}M[e>>2]=c;d=M[a+12>>2];c=d+236|0;b:{c:{d:{e:{while(1){c=M[c>>2];if(c){if(M[c+4>>2]==-429938){break e}c=c+16|0;continue}break}c=ub(M[d>>2],20,0);if(!c){break c}g=M[a+16>>2];M[c+4>>2]=-429938;M[c>>2]=g;M[c+16>>2]=M[d+236>>2];M[d+236>>2]=c;if(M[a+20>>2]){break d}M[a+20>>2]=-1;break d}d=M[c+12>>2];if(!d){break d}Ra[d|0](M[c+8>>2])}M[c+12>>2]=101;M[c+8>>2]=e;break b}mz(e)}c=yp(a);if(!c){break a}}a=M[c+4>>2];if((a|0)>=4){bd(M[c+8>>2]);a=M[c+16>>2];M[c+8>>2]=M[c+12>>2];M[c+12>>2]=a;M[c+16>>2]=M[c+20>>2];a=3}L[b+38>>1]=1;M[b+24>>2]=M[b+24>>2]+1;M[((a<<2)+c|0)+8>>2]=b;M[c+4>>2]=a+1;f=0}return f}function lr(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;a:{g=N[c|0];if((g|0)==44){lr(a,b,M[c+16>>2],d,e,f);c=M[c+12>>2];g=N[c|0]}if((g|0)!=54&(g|0)!=45){break a}g=M[c+12>>2];if(N[g|0]!=168){break a}h=M[c+16>>2];if(!Nd(0,h)){break a}c=Ug(a,c);if(M[c+12>>2]!=15?c:0){break a}c=L[g+32>>1];if((c|0)<0){break a}i=N[(M[M[b+12>>2]+4>>2]+S(c,12)|0)+5|0];if(i>>>0<66){break a}if(f){c=M[a>>2];b=md(c,24,0);if(!b){break a}d=N[f+12|0];j=b,k=qb(c,h,0),M[j>>2]=k;c=M[f+16>>2];M[b+8>>2]=e;M[b+4>>2]=c;c=L[g+32>>1];K[b+16|0]=(d&72)!=0;M[b+12>>2]=c;c=M[a+80>>2];K[b+17|0]=i;M[b+20>>2]=c;M[a+80>>2]=b;if(c){break a}rd(a,91,a+80|0);return}if(c>>>0>62){break a}a=M[d>>2];b=M[d+4>>2];j=d,k=dK(-2,-1,c)&a,M[j>>2]=k;M[d+4>>2]=Qa&b}}function Pz(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=M[b+40>>2];i=M[a>>2];g=M[a+8>>2];j=an(b,d);a:{if(!d|(e|0)==(h|0)){break a}if(!(N[c+28|0]&128)){d=Gb(a);$a(g,142,e,d);bb(g,30,h,0,d);zb(a,d);break a}f=M[a+48>>2];l=qc(c);k=O[l+50>>1];M[a+48>>2]=f+k;m=f+1|0;f=0;while(1){if((f|0)!=(k|0)){bb(g,94,e,We(d,L[M[l+4>>2]+(f<<1)>>1]),f+m|0);f=f+1|0;continue}break}d=lb(g,29,h,0,m,k);nb(g,70,11,2,0,13646,-1);e=M[a+132>>2];K[(e?e:a)+21|0]=1;e=M[g+108>>2];M[(N[M[g>>2]+87|0]?74356:M[g+104>>2]+S(d,20)|0)+8>>2]=e}f=0;d=xh(i,M[b+32>>2],0);while(1){if(L[c+34>>1]>(f|0)){if(N[(M[c+4>>2]+S(f,12)|0)+5|0]==69){fb(g,87,M[b+36>>2]+f|0)}f=f+1|0;continue}break}Gn(a,d,xc(i,M[j+8>>2],0),qb(i,M[j+12>>2],0),2,j)}function jJ(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=Na-48|0;Na=b;f=od(M[c>>2]);d=M[f+32>>2];c=0;L[b+44>>1]=0;M[b+40>>2]=0;M[b+32>>2]=0;M[b+24>>2]=0;M[b+28>>2]=0;M[b+36>>2]=S(d,100)+100;d=(N[f+36|0]?8:16)+f|0;e=M[d+4>>2];M[b+16>>2]=M[d>>2];M[b+20>>2]=e;rb(b+24|0,1873,b+16|0);while(1){if((c|0)<M[f+32>>2]){e=M[f+20>>2];h=e;l=M[f+16>>2];i=ZJ(l,e,10,0);g=Qa;d=M[f+40>>2]+(c<<3)|0;e=M[d>>2];d=M[d+4>>2];n=d;j=e+1|0;d=j?d:d+1|0;k=ZJ(j,d,11,0);m=Qa;i=(m|0)==(g|0)&i>>>0>k>>>0|g>>>0>m>>>0?2:1;k=0;g=h+n|0;h=e;e=e+l|0;g=h>>>0>e>>>0?g+1|0:g;d=aK(e,g,j,d);h=d;e=Qa;d=!e&(d|0)==2;M[b>>2]=d?i:h;M[b+4>>2]=d?k:e;rb(b+24|0,1872,b);c=c+1|0;continue}break}wm(a,b+24|0);Na=b+48|0}function Jj(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;C(+a);b=x(1)|0;e=x(0)|0;a:{b:{c:{if((b|0)<1048575|(b|0)<=1048575){if(a==0){return-1/(a*a)}if((b|0)>0|(b|0)>=0){break c}return(a-a)/0}if(b>>>0>2146435071){break a}f=-1023;if((b|0)!=1072693248){break b}b=1072693248;if(e){break b}return 0}f=-1077;C(+(a*0x40000000000000));b=x(1)|0;e=x(0)|0}b=b+614242|0;g=+((b>>>20|0)+f|0);d=g*.6931471803691238;z(0,e|0);z(1,(b&1048575)+1072079006|0);a=+B()+-1;c=a/(a+2);h=d;i=a;j=c;d=a*(a*.5);c=c*c;a=c*c;a=h+(i+(j*(d+(a*(a*(a*.15313837699209373+.22222198432149784)+.3999999999940942)+c*(a*(a*(a*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+g*1.9082149292705877e-10-d))}return a}function Xm(a,b,c,d,e,f,g,h){var i=0,j=0,k=0;j=M[a+8>>2];a:{if(!f){break a}i=M[b+36>>2];if(i){g=M[a+60>>2]-1|0;M[a+60>>2]=g;M[f>>2]=g;M[a+56>>2]=c+1;MA(a,i,M[f>>2]);g=0;M[a+56>>2]=0;break a}M[f>>2]=0}b:{if(e){e=50;if(N[b+55|0]&8){break b}}e=52}i=O[e+b>>1];e=vc(a,i);f=0;c:{if(!g){break c}if((e|0)==(h|0)){f=g;if(!M[g+36>>2]){break c}}f=0}g=0;while(1){if((g|0)!=(i|0)){d:{e:{if(!f){break e}h=g<<1;k=O[h+M[f+4>>2]>>1];if((k|0)==65534){break e}if(O[h+M[b+4>>2]>>1]==(k|0)){break d}}Jr(a,b,c,g,e+g|0);if(L[M[b+4>>2]+(g<<1)>>1]<0){break d}h=M[j+108>>2];if((h|0)<=0){break d}h=h-1|0;if(N[M[j+104>>2]+S(h,20)|0]!=87){break d}be(j,h)}g=g+1|0;continue}break}if(d){bb(j,97,e,i,d)}ad(a,e,i);return e}function re(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=jb(b);l=a+416|0;f=Sc(l,b);while(1){if(f){i=aw(f,c,d);j=i>>>0>h>>>0;h=j?i:h;g=j?f:g;f=M[f+12>>2];continue}break}a:{b:{c:{d:{if(e){break d}if(g){f=0;if(!(N[a+24|0]&2)){break c}}h=0;f=$v((N[N[b|0]+31024|0]+k>>>0)%23|0,b);while(1){if(!f){break d}i=aw(f,c,d);j=i>>>0>h>>>0;h=j?i:h;g=j?f:g;f=M[f+12>>2];continue}}if(!(!e|h>>>0>5)){e=ub(a,k+41|0,0);if(!e){break b}M[e+4>>2]=d;L[e>>1]=c;f=e+40|0;M[e+32>>2]=f;c=k+1|0;if(c){G(f,b,c)}while(1){b=N[f|0];if(b){K[f|0]=N[b+31024|0];f=f+1|0;continue}break}b=wd(l,M[e+32>>2],e);if((b|0)==(e|0)){ib(a,e);Lb(a);break b}M[e+12>>2]=b;return e}if(!g){break b}f=e}if(f|M[g+16>>2]){break a}}g=0}return g}function iG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=Na-80|0;Na=c;f=M[a+12>>2];d=fy(a);M[c+76>>2]=d;if(!d){h=c,i=Sj(a),M[h+76>>2]=i}K[a+240|0]=1;if(!M[a+40>>2]){d=M[a+20>>2];e=M[a+16>>2];M[c+72>>2]=b;M[c+64>>2]=e;M[c+68>>2]=d;Me(c+76|0,f,22941,c- -64|0)}if(N[a+238|0]){d=M[a+20>>2];e=M[a+16>>2];M[c+56>>2]=b;M[c+48>>2]=e;M[c+52>>2]=d;Me(c+76|0,f,23147,c+48|0)}if(N[a+237|0]){d=M[a+20>>2];e=M[a+16>>2];M[c+40>>2]=b;M[c+32>>2]=e;M[c+36>>2]=d;Me(c+76|0,f,22994,c+32|0)}d=M[a+20>>2];e=M[a+16>>2];M[c+24>>2]=b;M[c+16>>2]=e;M[c+20>>2]=d;d=c+76|0;Me(d,f,23041,c+16|0);e=M[a+20>>2];g=M[a+16>>2];M[c+8>>2]=b;M[c>>2]=g;M[c+4>>2]=e;Me(d,f,23095,c);K[a+240|0]=0;Na=c+80|0;return M[c+76>>2]}function Fo(a,b){var c=0,d=0;c=N[a+5|0];a:{b:{if(!N[a+15|0]){break b}switch(b-2|0){case 0:case 2:break b;default:break a}}if((b|0)==(c|0)){break a}K[a+5|0]=b;if(!(N[a+4|0]|(b&1|(c&5)!=1))){c=M[a+68>>2];b=M[c>>2];if(b){Ra[M[b+4>>2]](c)|0;M[c>>2]=0}if(N[a+18|0]>=2){c=M[a>>2];b=M[c+28>>2];if(!b){break a}Ra[b|0](c,M[a+188>>2],0)|0;break a}b=0;d=N[a+17|0];if(d){c=d}else{b=Wu(a);c=N[a+17|0]}if((c|0)==1){b=$f(a,2)}c:{if(b){break c}c=M[a>>2];b=M[c+28>>2];if(b){Ra[b|0](c,M[a+188>>2],0)|0}if((d|0)!=1){break c}Og(a,1);break a}if(d){break a}kl(a);break a}d:{switch(b-2|0){case 0:case 2:break d;default:break a}}c=M[a+68>>2];b=M[c>>2];if(!b){break a}Ra[M[b+4>>2]](c)|0;M[c>>2]=0}return N[a+5|0]}function LC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;h=(c>>31)+e|0;j=c+d|0;h=j>>>0<c>>>0?h+1|0:h;i=M[a+20>>2];if((h|0)<=(i|0)&P[a+16>>2]>=j>>>0|(h|0)<(i|0)){a:{if(!(!!(d|e)&((d|0)==M[a+32>>2]&(e|0)==M[a+36>>2]))){f=a+12|0;while(1){f=M[f>>2];if(!f){f=0;break a}i=M[a+4>>2];k=i+k|0;g=(i>>31)+g|0;g=i>>>0>k>>>0?g+1|0:g;if((e|0)>=(g|0)&d>>>0>=k>>>0|(e|0)>(g|0)){continue}break}break a}f=M[a+40>>2]}g=d;d=M[a+4>>2];d=$J(g,e,d,d>>31);while(1){g=M[a+4>>2]-d|0;e=(c|0)<(g|0)?c:g;if(e){G(b,(d+f|0)+4|0,e)}c=c-g|0;b:{if((c|0)<0){break b}f=M[f>>2];if(!c){break b}b=b+e|0;d=0;if(f){continue}}break}M[a+40>>2]=f;M[a+32>>2]=f?j:0;M[a+36>>2]=f?h:0;a=0}else{a=522}return a|0}function Tu(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;e=Na-16|0;Na=e;a:{if(N[a+4|0]){c=Su(a);if(c){break a}h=N[a+4|0]?2:0}c=M[a+176>>2];i=M[a+180>>2];g=M[a+236>>2];f=M[a+64>>2];d=M[a>>2];M[a+232>>2]=0;b=zd(M[d+4>>2]+120|0,0);if(!b){c=7;break a}M[b>>2]=d;L[b+40>>1]=65535;M[b+4>>2]=f;M[b+108>>2]=g;M[b+16>>2]=c;M[b+20>>2]=i;L[b+48>>1]=257;K[b+43|0]=h;c=b+120|0;M[b+8>>2]=c;M[e+12>>2]=524294;c=Ra[M[d+24>>2]](d,g,c,524294,e+12|0)|0;if(!c){if(K[e+12|0]&1){K[b+46|0]=1}c=M[f>>2];b:{if(!c){break b}c=Ra[M[c+48>>2]](f)|0;if(c&1024){K[b+48|0]=0}if(!(c&4096)){break b}K[b+49|0]=0}M[a+232>>2]=b;c=0;break a}Wo(b,0);a=M[b+8>>2];d=M[a>>2];if(d){Ra[M[d+4>>2]](a)|0;M[a>>2]=0}ab(b)}Na=e+16|0;return c}function lC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;a=Na-16|0;Na=a;if(b){D(c,0,b)}M[18553]=42;d=Ah(11543,0,0);a:{if((d|0)>=0){while(1){if((Ra[M[16969]](d,c,b)|0)<0&M[18595]==27){continue}break}Wf(0,d,45415);break a}e=+ea()/1e3;if(U(e)<0x8000000000000000){b=~~e>>>0;if(U(e)>=1){d=~~(e>0?W(Y(e*2.3283064365386963e-10),4294967295):Z((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{d=0}}else{b=0;d=-2147483648}f=a+8|0;if(f){M[f>>2]=b;M[f+4>>2]=d}b=M[a+12>>2];d=M[a+8>>2];K[c|0]=d;K[c+1|0]=d>>>8;K[c+2|0]=d>>>16;K[c+3|0]=d>>>24;K[c+4|0]=b;K[c+5|0]=b>>>8;K[c+6|0]=b>>>16;K[c+7|0]=b>>>24;b=M[18553];K[c+8|0]=b;K[c+9|0]=b>>>8;K[c+10|0]=b>>>16;K[c+11|0]=b>>>24;b=12}Na=a+16|0;return b|0}function Un(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;h=Na-16|0;Na=h;e=M[a>>2];a:{b:{if(!c){c=wf(e,b,d,0);if(!c){break b}}if(M[c+12>>2]){break a}}c:{if(M[e+276>>2]){c=_b(e,d);if(!c){break c}Ra[M[e+276>>2]](M[e+284>>2],e,b,c);ib(e,c)}if(!M[e+280>>2]){break c}c=tg(e);ym(c,d,0);f=zj(c,2);if(f){Ra[M[e+280>>2]](M[e+284>>2],e,N[e+84|0],f)}Xc(c)}c=0;d:{e:{f=wf(e,b,d,0);if(!f){break e}if(M[f+12>>2]){break d}i=M[f>>2];b=0;while(1){if((b|0)==3){break e}g=b+36628|0;b=b+1|0;g=wf(e,N[g|0],i,0);if(!M[g+12>>2]){continue}break}a=M[g+4>>2];M[f>>2]=M[g>>2];M[f+4>>2]=a;a=M[g+12>>2];M[f+8>>2]=M[g+8>>2];M[f+12>>2]=a;M[f+16>>2]=0;break d}M[h>>2]=d;cb(a,8578,h);M[a+12>>2]=257;break a}c=f}Na=h+16|0;return c}function Um(a,b,c){var d=0,e=0,f=0;a:{e=M[a+72>>2];if(!e|(c|0)>=0){break a}d=e+8|0;f=M[e>>2];while(1){if((f|0)<=0){break a}b:{if(N[d+9|0]&8){if(!mc(0,M[d>>2],b,-1)){break b}}f=f-1|0;d=d+16|0;continue}break}return M[d+12>>2]}d=qb(M[a>>2],b,0);if(!(!d|!(N[d+4|0]&8))){e=M[a+8>>2];f=Ub(e,15);K[a+23|0]=0;b=M[a>>2];if(!N[b+87|0]){if((c|0)<0){c=M[a+48>>2]+1|0;M[a+48>>2]=c}kc(a,d,c);b=M[a>>2]}K[a+23|0]=1;me(b,d);b=M[e+108>>2];M[(N[M[e>>2]+87|0]?74356:M[e+104>>2]+S(f,20)|0)+8>>2]=b;return c}b=Wb(a,e,d);if(b){d=b+(M[b>>2]<<4)|0;e=d+1|0;f=(N[d+1|0]|N[d+2|0]<<8)&65527|c>>>28&8;K[e|0]=f;K[e+1|0]=f>>>8;if((c|0)<0){c=M[a+48>>2]+1|0;M[a+48>>2]=c}M[(d-8|0)+12>>2]=c}M[a+72>>2]=b;return c}function Tk(a,b,c,d,e){var f=0;if(N[a+9|0]){M[M[a+4>>2]+4>>2]=M[a>>2]}f=M[a+4>>2];a:{if(b>>>0<=1){if(!b){a=db(75456);break a}b=M[f+48>>2]!=0}M[e+112>>2]=d;K[e+68|0]=255;M[e+64>>2]=b;M[e+20>>2]=f;M[e+8>>2]=a;d=0;K[e+1|0]=0;a=f+8|0;while(1){a=M[a>>2];if(a){if(M[a+64>>2]==(b|0)){K[a+1|0]=N[a+1|0]|32;K[e+1|0]=32;d=32}a=a+24|0;continue}break}K[e|0]=1;M[e+24>>2]=M[f+8>>2];M[f+8>>2]=e;b:{if(c){K[e+2|0]=0;K[e+1|0]=d|1;if(M[f+84>>2]){break b}a=fj(M[f+36>>2]);M[f+84>>2]=a;c:{if(!a){a=M[f+8>>2];M[f+8>>2]=M[a+24>>2];D(a,0,200);a=7;break c}K[a|0]=0;K[a+1|0]=0;K[a+2|0]=0;K[a+3|0]=0;K[a+4|0]=0;K[a+5|0]=0;K[a+6|0]=0;K[a+7|0]=0;M[f+84>>2]=M[f+84>>2]+4;a=0}break a}K[e+2|0]=2}a=0}return a}function $t(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;g=Na-256|0;Na=g;e=M[a+12>>2];a:{if(!M[a+16>>2]){c=Uk(M[e+28>>2]);M[a+16>>2]=c;d=7;if(!c){break a}e=M[a+12>>2];d=O[M[e+28>>2]+6>>1];K[c+23|0]=0;L[c+20>>1]=d}c=M[b>>2];d=N[e+68|0];M[a+40>>2]=(d|0)==1?35:(d|0)==2?36:37;D(g,0,256);while(1){if(c){f=M[b+4>>2];b:{if(f){d=0;if((c|0)==(f|0)){break b}d=f+M[c+4>>2]|0;break b}d=M[c+4>>2]}e=0;M[c+4>>2]=0;while(1){h=(e<<2)+g|0;f=M[h>>2];if(f){c=Bt(a,c,f);M[h>>2]=0;e=e+1|0;continue}break}M[h>>2]=c;c=d;continue}else{e=0;c=0;while(1){if((e|0)!=64){d=M[(e<<2)+g>>2];c:{if(!d){break c}if(!c){c=d;break c}c=Bt(a,c,d)}e=e+1|0;continue}break}M[b>>2]=c;d=N[M[a+16>>2]+23|0]}break}}Na=g+256|0;return d}function wF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((b|0)==1){if((Sb(M[c>>2])|0)==5){Yb(a);return}e=Kb(M[c>>2]);M[18595]=0;g=a;C(+e);a=x(1)|0;b=x(0)|0;c=a&2147483647;a:{if(c>>>0>=1072693248){f=(a|0)>0|(a|0)>=0?0:3.141592653589793;if(!(c-1072693248|b)){break a}f=0/(e-e);break a}b:{if(c>>>0<=1071644671){f=1.5707963267948966;if(c>>>0<1012924417){break b}f=6123233995736766e-32-e*Gj(e*e)-e+1.5707963267948966;break a}if((a|0)<0){d=(e+1)*.5;e=$(d);d=1.5707963267948966-(e+(e*Gj(d)+-6123233995736766e-32));f=d+d;break a}d=(1-e)*.5;e=$(d);h=e*Gj(d);C(+e);a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);f=d;d=+B();d=h+(f-d*d)/(e+d)+d;f=d+d}}Zb(g,f);return}ba(23875,17968,378,17654);I()}function Bs(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;h=Na-16|0;Na=h;a:{b:{c:{e=M[a+252>>2];d:{if(!e){break d}if(N[a+224|0]==1){cb(a,5126,0);break d}i=M[e+4>>2]+S(L[e+34>>1],12)|0;d=i-12|0;e:{if(O[i-4>>1]){break e}if(!c){break c}f:{switch(M[c+4>>2]-6|0){case 0:if(Eb(15795,M[c>>2],6)){break e}g=64;break b;case 1:break f;default:break e}}if(!Eb(11863,M[c>>2],7)){break c}}M[h>>2]=M[d>>2];cb(a,29578,h)}c=b;break a}L[e+36>>1]=O[e+36>>1]-1;g=32}c=i-2|0;f=O[c>>1];L[c>>1]=f|g;M[e+28>>2]=g|M[e+28>>2];if(f&1){yn(a,d)}c=0;g=d;d=0;g:{if(!b){break g}f=N[b|0];if((f|0)==60){b=ob(a,173,b,0);d=0;if(!b){break g}f=N[b|0]}if((f&255)!=72){K[b+1|0]=N[i-7|0]}d=b}Cn(a,e,g,d)}kb(M[a>>2],c);Na=h+16|0}function kf(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=d-1|0;d=b+8|0;k=e&1;l=k^81;e=N[a+23|0]?e:e&253;n=e&2;o=e&8;p=e&4;h=M[b>>2];g=M[a+8>>2];e=0;while(1){if((e|0)<(h|0)){b=M[d>>2];a:{b:{if(!p){break b}f=O[d+12>>1];if(!f){break b}if(o){h=h-1|0;e=e-1|0;break a}$a(g,l,f+m|0,c+e|0);break a}c:{if(!n){break c}if(!Vm(a,b)){break c}Um(a,b,c+e|0);break a}f=c+e|0;i=Se(a,b,f);if((i|0)==(f|0)){break a}d:{if(!k){break d}b=74356;if(!N[M[g>>2]+87|0]){b=(M[g+104>>2]+S(M[g+108>>2],20)|0)-20|0}if(N[b|0]!=80){break d}j=M[b+12>>2]+1|0;if(O[b+2>>1]|((j+M[b+4>>2]|0)!=(i|0)|(f|0)!=(M[b+8>>2]+j|0))){break d}M[b+12>>2]=j;break a}$a(g,l,i,f)}d=d+16|0;e=e+1|0;continue}break}}function Zu(a,b){var c=0;c=M[a+52>>2];K[a+11|0]=N[c+21|0];a:{b:{if(b>>>0>=10){K[a+8|0]=1;K[a+10|0]=0;c:{switch(b-10|0){case 3:M[a+80>>2]=23;M[a+76>>2]=24;K[a+1|0]=1;K[a+2|0]=1;break b;case 0:M[a+80>>2]=25;M[a+76>>2]=26;break a;default:break c}}M[a+80>>2]=25;M[a+76>>2]=26;K[a+1|0]=0;K[a+2|0]=0;return db(72832)}K[a+8|0]=0;K[a+10|0]=4;d:{switch(b-2|0){case 0:M[a+80>>2]=25;M[a+76>>2]=27;break a;case 3:M[a+80>>2]=28;M[a+76>>2]=29;K[a+1|0]=1;K[a+2|0]=0;break b;default:break d}}M[a+80>>2]=25;M[a+76>>2]=27;K[a+1|0]=0;K[a+2|0]=0;return db(72856)}L[a+14>>1]=O[c+30>>1];L[a+16>>1]=O[c+32>>1];return 0}K[a+1|0]=0;K[a+2|0]=0;L[a+14>>1]=O[c+26>>1];L[a+16>>1]=O[c+28>>1];return 0}function Az(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=Na+-64|0;Na=d;e=b;b=d+16|0;if(!sg(a,e,c,b)){zz(b);K[d+2|0]=58;K[d+5|0]=58;b=M[d+36>>2];c=(b|0)/10|0;K[d|0]=((c|0)%10|0)+48;e=M[d+40>>2];g=(e|0)/10|0;K[d+3|0]=((g|0)%10|0)+48;K[d+1|0]=(b-S(c,10)|0)+48;K[d+4|0]=(e-S(g,10)|0)+48;f=R[d+48>>3];a:{if(N[d+60|0]&4){K[d+12|0]=0;f=f*1e3+.5;if(U(f)<2147483647){c=~~f}else{c=-2147483648}K[d+9|0]=(((c|0)/100|0)%10|0)+48;b=(c|0)/10|0;K[d+10|0]=((b|0)%10|0)+48;K[d+11|0]=(c-S(b,10)|0)+48;b=(c|0)/1e3|0;e=12;g=46;c=(c|0)/1e4|0;break a}e=8;g=0;b=U(f)<2147483647?~~f:-2147483648;c=(b|0)/10|0}K[d+8|0]=g;K[d+7|0]=((b|0)%10|0)+48;K[d+6|0]=((c|0)%10|0)+48;vb(a,d,e,-1)}Na=d- -64|0}function Kg(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;f=M[a+88>>2];f=(b|0)>0?S(M[a+20>>2]-b|0,40)+f|0:f;i=(c<<3)+88|0;h=i+(d?0:200)|0;g=M[a+96>>2];e=b<<2;j=M[g+e>>2];if(j){aj(a,j);g=M[a+96>>2];M[e+g>>2]=0}e=M[f+24>>2];a:{if((e|0)>=(h|0)){e=M[f+32>>2];break a}if((e|0)>0){ib(M[f+20>>2],M[f+32>>2])}e=md(M[f+20>>2],h,h>>31);M[f+8>>2]=e;M[f+32>>2]=e;if(!e){M[f+24>>2]=0;return 0}M[f+24>>2]=h;g=M[a+96>>2]}M[(b<<2)+g>>2]=e;M[e>>2]=0;M[e+4>>2]=0;M[e+24>>2]=0;M[e+28>>2]=0;M[e+16>>2]=0;M[e+20>>2]=0;M[e+8>>2]=0;M[e+12>>2]=0;M[e+64>>2]=((c<<2)+e|0)+84;L[e+52>>1]=c;K[e|0]=d;if(!d){a=M[f+8>>2]+i|0;M[e+36>>2]=a;M[a+16>>2]=0;M[a+8>>2]=0;M[a+12>>2]=0;M[a>>2]=0;M[a+4>>2]=0}return e}function qh(a,b,c){var d=0,e=0,f=0,g=0;d=M[a+24>>2];a:{b:{c:{if(!(!c|(d|0)<=0)){d=M[a+32>>2];e=M[a+8>>2];if((d|0)!=(e|0)){break c}c=b>>31;d=M[a+20>>2];d:{if(d){d=Zi(d,e,b,c);M[a+32>>2]=d;break d}d=Ud(e,b,c);M[a+32>>2]=d;if(d){break d}ab(M[a+8>>2]);d=M[a+32>>2]}M[a+8>>2]=d;b=1;break a}if((d|0)<=0){break b}d=M[a+32>>2]}ib(M[a+20>>2],d)}d=md(M[a+20>>2],b,b>>31);M[a+32>>2]=d;b=!c}if(!d){dc(a);M[a+24>>2]=0;M[a+8>>2]=0;return 7}f=a,g=uf(M[a+20>>2],d),M[f+24>>2]=g;e:{if(b){break e}b=M[a+8>>2];if(!b){break e}c=M[a+12>>2];if(!c){break e}G(M[a+32>>2],b,c)}b=O[a+16>>1];if(b&4096){Ra[M[a+36>>2]](M[a+8>>2]);b=O[a+16>>1]}L[a+16>>1]=b&36863;M[a+8>>2]=M[a+32>>2];return 0}function nl(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{if(N[a+20|0]){b=0}else{e=M[a+12>>2];if(!e){Sh(a,18);return M[a+8>>2]+(M[a+16>>2]^-1)|0}g=N[a+21|0]&4?M[a+4>>2]:g;f=M[a+16>>2];d=f+b|0;c=d>>>0<f>>>0?c+1|0:c;d=d+1|0;c=d?c:c+1|0;h=d;i=c;d=d+f|0;c=h>>>0>d>>>0?c+1|0:c;f=c;j=d;d=d>>>0>e>>>0&(c|0)>=0|(c|0)>0;c=d?h:j;d=d?i:f;if((d|0)>0){d=1}else{d=c>>>0>e>>>0&(d|0)>=0}if(d){ag(a);Sh(a,18);return 0}M[a+8>>2]=c;e=0;d=M[a>>2];b:{if(d){c=ld(d,g,c,e);break b}c=Ud(g,c,e)}if(!c){break a}c:{if(N[a+21|0]&4){break c}e=M[a+16>>2];if(!e|!e){break c}G(c,M[a+4>>2],e)}M[a+4>>2]=c;k=a,l=uf(M[a>>2],c),M[k+8>>2]=l;K[a+21|0]=N[a+21|0]|4}return b}ag(a);Sh(a,7);return 0}function oA(a,b,c){var d=0,e=0,f=0,g=0;d=Na-176|0;Na=d;g=M[a+8>>2];b=M[b+4>>2];e=N[c+60|0];f=M[a>>2];L[d+172>>1]=256;M[d+168>>2]=0;M[d+160>>2]=100;M[d+164>>2]=1e9;M[d+152>>2]=f;e=b+S(e,48)|0;M[d+32>>2]=e+8;M[d+156>>2]=d+48;f=d+152|0;rb(f,27769,d+32|0);a:{b:{b=M[c+80>>2];if(K[b+41|0]&1){b=M[e+16>>2];c=L[b+32>>1];if((c|0)<0){break b}M[d+16>>2]=M[M[b+4>>2]+S(c,12)>>2];rb(f,21197,d+16|0);break a}c=O[b+46>>1];while(1){if(O[b+24>>1]<=c>>>0){break a}e=ar(M[b+32>>2],c);if(O[b+46>>1]<c>>>0){Ab(d+152|0,30637,5)}M[d>>2]=e;rb(d+152|0,21197,d);c=c+1|0;continue}}rb(d+152|0,21218,0)}b=d+152|0;Ab(b,27767,1);b=Rd(b);nb(g,188,M[g+108>>2],M[a+236>>2],0,b,-6);Na=d+176|0}function uo(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=M[a+56>>2];h=N[a+9|0];g=h+1|0;d=f+g|0;d=N[d|0]<<8|N[d+1|0];i=M[M[a+52>>2]+40>>2];j=i-b|0;a:{b:{while(1){a=d;if((d|0)>(j|0)){break b}d=d+f|0;e=(N[d+2|0]<<8|N[d+3|0])-b|0;if((e|0)>=0){if(e>>>0<=3){a=f+h|0;if(N[a+7|0]>57){break a}b=f+g|0;c=N[d|0]|N[d+1|0]<<8;K[b|0]=c;K[b+1|0]=c>>>8;K[a+7|0]=N[a+7|0]+e;return d}a=a+e|0;if(a>>>0>j>>>0){k=c,l=db(72555),M[k>>2]=l;return 0}b=e<<8|(e&65280)>>>8;K[d+2|0]=b;K[d+3|0]=b>>>8;return a+f|0}g=a;d=N[d+1|0]|N[d|0]<<8;if(a>>>0<d>>>0){continue}break}if(!d){break a}k=c,l=db(72570),M[k>>2]=l;return 0}if((a|0)<=(i-4|0)){break a}k=c,l=db(72577),M[k>>2]=l}return 0}function tj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=Na-16|0;Na=f;g=M[a+8>>2];h=M[a+12>>2];i=N[a+18|0];c=Jd(g,f+8|0,h,i);if((c|0)>0){d=R[f+8>>3];a:{b:{if((c|0)!=1){break b}c=0;e=-2147483648;c:{if(d<-0x7ffffffffffffc00){break c}c=-1;e=2147483647;if(d>0x7ffffffffffffc00){break c}if(U(d)<0x8000000000000000){c=~~d>>>0;if(U(d)>=1){e=~~(d>0?W(Y(d*2.3283064365386963e-10),4294967295):Z((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}}else{c=0;e=-2147483648}}d:{if(Bw(d,c,e)){M[a>>2]=c;M[a+4>>2]=e;break d}if(ig(g,a,h,i)){break b}}c=O[a+16>>1]|4;break a}R[a>>3]=d;c=O[a+16>>1]|8;L[a+16>>1]=c;if(!b){break a}Aw(a);c=O[a+16>>1]}L[a+16>>1]=c&65533}Na=f+16|0}function Vq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Na-48|0;Na=f;m=M[a>>2];i=Cb(a);a:{if(!i){break a}l=M[m+16>>2]+(b<<4)|0;while(1){if((h|0)!=3){g=(f+33|0)+h|0;K[g|0]=0;n=(h<<3)+51712|0;j=M[n>>2];k=Hc(m,j,M[l>>2]);b:{if(!k){if(h){break b}k=M[l>>2];M[f+8>>2]=M[n+4>>2];M[f+4>>2]=j;M[f>>2]=k;sc(a,25303,f);M[f+36>>2]=M[a+104>>2];K[g|0]=16;break b}g=M[k+20>>2];M[(f+36|0)+(h<<2)>>2]=g;Dd(a,b,g,1,j);if(d){g=M[l>>2];M[f+28>>2]=d;M[f+24>>2]=e;M[f+20>>2]=j;M[f+16>>2]=g;sc(a,19654,f+16|0);break b}$a(i,145,g,b)}h=h+1|0;continue}break}lb(i,113,c,M[f+36>>2],b,3);a=M[i+108>>2];if((a|0)<=0){break a}L[(M[i+104>>2]+S(a,20)|0)-18>>1]=N[f+33|0]}Na=f+48|0}function Ic(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c=K[a|0];if((c|0)>=0){M[b>>2]=c&255;M[b+4>>2]=0;return 1}d=K[a+1|0];c=c&127|(d&255)<<7;if((d|0)>=0){M[b>>2]=c;M[b+4>>2]=0;return 2}d=K[a+2|0];c=c&16383|(d&255)<<14;if((d|0)>=0){M[b>>2]=c;M[b+4>>2]=0;return 3}d=K[a+3|0];c=c&2097151|(d&255)<<21;if((d|0)>=0){M[b>>2]=c;M[b+4>>2]=0;return 4}l=a+10|0;g=a+4|0;d=c&268435455;f=28;c=0;while(1){a:{if(!c&f>>>0>63|c){g=l;break a}j=K[g|0];e=j&127;i=f&31;if((f&63)>>>0>=32){k=e<<i;e=0}else{k=(1<<i)-1&e>>>32-i;e=e<<i}e=e+d|0;h=h+k|0;h=d>>>0>e>>>0?h+1|0:h;d=e;f=f+7|0;c=f>>>0<7?c+1|0:c;g=g+1|0;if((j|0)<0){continue}}break}M[b>>2]=d;M[b+4>>2]=h;return g-a|0}function GF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Na-16|0;M[d+8>>2]=-1;M[d+12>>2]=-1;a=M[b>>2];i=(a|0)>0?a:0;a=M[b+4>>2];while(1){if((c|0)!=(i|0)){e=M[a>>2];a:{if((e|0)<8){break a}f=e-8|0;e=1<<f;if(!N[a+5|0]){g=e|g;break a}if(N[a+4|0]!=2){break a}M[(d+8|0)+(f<<2)>>2]=c;h=e|h}a=a+12|0;c=c+1|0;continue}break}b:{if(M[b+8>>2]<=0){break b}a=M[b+12>>2];if(M[a>>2]>=0|N[a+4|0]){break b}M[b+32>>2]=1}a=19;if(!((h^-1)&g)){a=0;e=M[d+8>>2];c=0;c:{if((e|0)<0){break c}M[b+40>>2]=0;M[b+44>>2]=1072693248;c=e<<3;e=M[b+16>>2];c=c+e|0;K[c+4|0]=1;M[c>>2]=1;d=M[d+12>>2];c=1;if((d|0)<0){break c}d=e+(d<<3)|0;K[d+4|0]=1;M[d>>2]=2;c=3}M[b+20>>2]=c}return a|0}function Jq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;if(!N[a+6|0]|M[a+104>>2]>=(b|0)){a=c}else{c=M[a+104>>2];h=7;a:{f=Ud(M[a+100>>2],S(b,48),0);if(!f){break a}e=S(b-c|0,48);if(e){D(S(c,48)+f|0,0,e)}M[a+100>>2]=f;i=(b|0)<(c|0)?c:b;while(1){if((c|0)==(i|0)){h=0;break a}d=S(c,48)+f|0;e=M[a+28>>2];M[d+20>>2]=e;b:{if(M[M[a+68>>2]>>2]){b=M[a+80>>2];g=M[a+84>>2];if(!!b&(g|0)>=0|(g|0)>0){break b}}b=M[a+156>>2];g=0}M[d>>2]=b;M[d+4>>2]=g;M[d+24>>2]=M[a+56>>2];b=kj(e);M[d+28>>2]=1;M[d+16>>2]=b;if(!b){break a}b=M[a+232>>2];if(b){M[d+32>>2]=M[b+68>>2];M[d+36>>2]=M[b+76>>2];M[d+40>>2]=M[b+80>>2];M[d+44>>2]=M[b+112>>2]}c=c+1|0;M[a+104>>2]=c;continue}}a=h}return a}function Tb(a,b,c,d){var e=0,f=0,g=0,h=0;e=Na-48|0;Na=e;a:{b:{c:{h=(b<<2)+a|0;g=M[h+60>>2];if(!g){d:{e:{if((b|0)!=7){if((b|0)!=18){break e}b=M[a+20>>2];f=M[a+16>>2];M[e+24>>2]=M[a+228>>2];M[e+16>>2]=f;M[e+20>>2]=b;f=5;b=Hb(25360,e+16|0);break d}M[e+32>>2]=M[a+224>>2];f=1;b=Hb(21202,e+32|0);break d}f=M[a+20>>2];M[e>>2]=M[a+16>>2];M[e+4>>2]=f;f=5;b=Hb(M[(b<<2)+56944>>2],e)}if(!b){break c}f=wl(M[a+12>>2],b,f,e+44|0);ab(b);g=M[e+44>>2];M[h+60>>2]=g}if(!d){break a}if(!g){g=0;h=0;break b}h=L[g+16>>1];break b}g=0;f=7;h=0;if(!d){break a}}b=0;while(1){if((b|0)>=(h|0)|f){break a}a=b+1|0;f=vp(g,a,M[(b<<2)+d>>2]);b=a;continue}}M[c>>2]=g;Na=e+48|0;return f}function HD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;h=b;g=c;while(1){a:{b:{ex(M[a+12>>2],d,e);c:{d:{e:{f:{f=Qa;if((f|0)>0){f=1}else{f=(f|0)>=0}if(f){f=Ra[M[16969]](M[a+12>>2],h,g)|0;g:{if((g|0)==(f|0)){f=g;break g}if((f|0)<0){j=M[18595];if((j|0)==27){continue}M[a+20>>2]=j;i=0;break g}if(f){break b}f=0}d=f+i|0;if((d|0)!=(c|0)){break f}break a}f=M[18595];M[a+20>>2]=f;if((c|0)==-1){break a}break e}if((d|0)>=0){break d}f=M[a+20>>2]}a=8458;if((f|0)==29|(f|0)==60|(f|0)==68){break c}return 266}M[a+20>>2]=0;a=c-d|0;if(a){D(b+d|0,0,a)}a=522}return a|0}h=f+h|0;i=f+i|0;g=g-f|0;d=d+f|0;e=d>>>0<f>>>0?e+1|0:e;continue}break}return 0}function Px(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;f=Na-32|0;Na=f;j=M[d>>2];g=M[e+64>>2];h=M[e+28>>2];M[f+12>>2]=h;M[f+8>>2]=h;M[f+28>>2]=b;k=M[c>>2];M[f+24>>2]=b;i=f+12|0;hi(f+24|0,a+g|0,0,0,c,i);g=M[f+24>>2];M[f+20>>2]=g;M[f+16>>2]=g;M[c>>2]=k;M[f+12>>2]=h;hi(f+20|0,a+j|0,1,0,i,c);a=M[f+20>>2];a:{b:{c:{if((b|0)!=(g|0)){if((a|0)==(g|0)){break c}Vx(f+8|0,f+28|0,f+16|0);break b}if((a|0)!=(b|0)){xe(f+8|0,f+16|0);break b}a=0;break a}xe(f+8|0,f+28|0)}b=M[e+28>>2];a=M[f+8>>2]+(b^-1)|0;d:{if((a|0)<0){break d}g=M[e+32>>2];if((g|0)<(a|0)){break d}g=g-a|0;if(g){D(a+b|0,0,g)}M[e+32>>2]=a;b=M[e+28>>2]}M[c>>2]=b;M[d>>2]=M[e+64>>2];a=1}Na=f+32|0;return a}function oC(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;d=Na-16|0;M[b+40>>2]=0;M[b+44>>2]=1072693248;a:{if(!N[a+20|0]){break a}c=M[b+4>>2];M[d+8>>2]=0;M[d+12>>2]=0;e=M[b>>2];e=(e|0)>0?e:0;while(1){if((e|0)!=(f|0)){g=M[c>>2];h=N[a+21|0];if(!(N[c+4|0]!=2|(g|0)<(h|0))){if(!N[c+5|0]){return 19}M[(d+8|0)+(g-h<<2)>>2]=f+1}c=c+12|0;f=f+1|0;continue}break}a=M[d+8>>2];if(!a){M[b+48>>2]=2147483647;M[b+52>>2]=0;M[b+40>>2]=-4194304;M[b+44>>2]=1105199103;break a}c=a<<3;a=M[b+16>>2];c=(c+a|0)-8|0;K[c+4|0]=1;M[c>>2]=1;M[b+48>>2]=20;M[b+52>>2]=0;M[b+40>>2]=0;M[b+44>>2]=1077149696;b=M[d+12>>2];if(b){a=(a+(b<<3)|0)-8|0;K[a+4|0]=1;M[a>>2]=2}return 0}return 0}function go(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=Na-16|0;Na=l;a:{if((f|0)>0){q=e+f|0;j=M[c>>2];m=M[a+56>>2];o=g+40|0;while(1){f=h;h=h+1|0;i=f<<2;if(M[i+o>>2]<=(e|0)){continue}break}p=g+16|0;i=M[i+p>>2];while(1){h=O[M[g+12>>2]+(e<<1)>>1];b:{c:{d:{if(N[m+1|0]|N[m+2|0]){k=uo(a,h,l+12|0);if(k){break d}}if((h|0)>(j-b|0)){break c}j=j-h|0;k=j}n=M[M[g+8>>2]+(e<<2)>>2];if(n>>>0>=i>>>0|h+n>>>0<=i>>>0){break b}db(78477)}a=1;break a}if(h){G(k,n,h)}h=k-m|0;h=h<<8|(h&65280)>>>8;K[d|0]=h;K[d+1|0]=h>>>8;e=e+1|0;if((q|0)>(e|0)){if(M[(f<<2)+o>>2]<=(e|0)){f=f+1|0;i=M[(f<<2)+p>>2]}d=d+2|0;continue}break}M[c>>2]=j}a=0}Na=l+16|0;return a}function hn(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;if(N[b+43|0]==1){M[h>>2]=-999;M[g>>2]=-999;return 0}j=M[a>>2];k=Mb(j,M[b+60>>2]);l=M[a+8>>2];e=(e|0)<0?M[a+44>>2]:e;M[g>>2]=e;i=e+1|0;a:{if(!(N[b+28|0]&128|(N[f|0]?0:f))){Pd(a,e,k,b,c);break a}if(N[j+95|0]){break a}Dd(a,k,M[b+20>>2],(c|0)==113,M[b>>2])}M[h>>2]=i;j=f+1|0;e=b+8|0;h=0;while(1){e=M[e>>2];if(e){if(!(!(N[b+28|0]&128)|((N[e+55|0]|N[e+56|0]<<8)&3)!=2)){M[g>>2]=i;d=0}b:{if(N[h+j|0]?0:f){break b}bb(l,c,i,M[e+44>>2],k);Ld(a,e);m=M[l+108>>2];if((m|0)<=0){break b}L[(M[l+104>>2]+S(m,20)|0)-18>>1]=d&255}i=i+1|0;h=h+1|0;e=e+20|0;continue}break}if(M[a+44>>2]<(i|0)){M[a+44>>2]=i}return h}function Yj(a){a=a|0;var b=0,c=0;c=Na-576|0;Na=c;D(c+8|0,0,536);b=M[a+20>>2];M[c+568>>2]=M[a+16>>2];M[c+572>>2]=b;b=M[a+12>>2];M[c+560>>2]=M[a+8>>2];M[c+564>>2]=b;b=M[a+52>>2];M[c+552>>2]=M[a+48>>2];M[c+556>>2]=b;b=M[a+44>>2];M[c+544>>2]=M[a+40>>2];M[c+548>>2]=b;M[a+40>>2]=0;M[a+44>>2]=0;M[a+48>>2]=0;M[a+52>>2]=0;Bf(a+24|0);b=M[c+552>>2];while(1){if(b){Vh(c+8|0,M[b+8>>2]);b=M[b>>2];continue}break}Bf(c+544|0);M[a+8>>2]=0;M[a+12>>2]=0;M[a+16>>2]=0;M[a+20>>2]=0;b=M[c+568>>2];while(1){if(b){Id(c+8|0,M[b+8>>2]);b=M[b>>2];continue}break}Bf(c+560|0);Bf(a+56|0);M[a+72>>2]=0;b=O[a+78>>1];if(b&1){M[a+4>>2]=M[a+4>>2]+1}L[a+78>>1]=b&65526;Na=c+576|0}function gf(a,b,c){var d=0,e=0,f=0;e=Na-16|0;Na=e;a:{b:{while(1){if(!a){break a}if(N[a+5|0]&8){M[b>>2]=M[a+8>>2];break b}c:{d:{e:{d=N[a|0];switch(d-173|0){case 0:break d;case 1:break c;default:break e}}if(!c|(d|0)!=157){break a}d=M[c+8>>2];if(!d|N[M[c>>2]+34|0]&128){break a}a=L[a+32>>1];M[d+228>>2]=M[d+228>>2]|((a|0)>31?-2147483648:1<<a-1);c=yr(M[c+244>>2],a);if(!c){break a}a=O[c+16>>1];f:{if(!(((a&63)>>>0<32?1<<a:0)&1347440720)){break f}a=sb(c);d=Qa;if(!d&a>>>0>2147483647|d){break f}M[b>>2]=a;f=1}Xc(c);break a}a=M[a+12>>2];c=0;continue}break}M[e+12>>2]=0;if(!gf(M[a+12>>2],e+12|0,0)){break a}M[b>>2]=0-M[e+12>>2]}f=1}Na=e+16|0;return f}function HC(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=K[b|0];e=c&255;a:{if((c|0)>=0){c=b;break a}e=e&127;while(1){f=d+1|0;c=f+b|0;g=K[c|0];e=g&127|e<<7;if((g|0)>=0){break a}g=d>>>0<7;d=f;if(g){continue}break}}d=c+2|0;b:{if(K[c+1|0]>=0){break b}d=c+3|0;if(K[c+2|0]>=0){break b}d=c+4|0;if(K[c+3|0]>=0){break b}d=c+5|0;if(K[c+4|0]>=0){break b}d=c+6|0;if(K[c+5|0]>=0){break b}d=c+7|0;if(K[c+6|0]>=0){break b}d=c+8|0;if(K[c+7|0]>=0){break b}d=(K[c+8|0]<0?10:9)+c|0}f=O[a+14>>1];c:{if(f>>>0>=e>>>0){a=(e-b|0)+d|0;a=a>>>0<=4?4:a;break c}c=O[a+16>>1];a=((e-c>>>0)%(M[M[a+52>>2]+40>>2]-4>>>0)|0)+c|0;a=((d-b|0)+(a>>>0>f>>>0?c:a)|0)+4|0}return a&65535}function Eg(a,b,c){var d=0,e=0,f=0,g=0;if(K[b+30|0]&1){if(!c){Jc(a,b,-5);e=74356;if(!N[M[a>>2]+87|0]){e=(M[a+104>>2]+S(M[a+108>>2],20)|0)-20|0}K[e|0]=95;bb(a,97,M[e+4>>2],M[e+8>>2],M[e+12>>2]);return}$a(a,95,c,L[b+36>>1]);Jc(a,b,-5);return}a:{d=M[b+12>>2];if(d){break a}f=L[b+34>>1];d=f>>31;f=f+1|0;d=f?d:d+1|0;d=lc(f,d);if(d){while(1)if(L[b+34>>1]<=(e|0)){while(1){b:{K[d+g|0]=0;if((g|0)<=0){break b}g=g-1|0;if(K[g+d|0]<66){continue}}break}M[b+12>>2]=d;break a}else{f=M[b+4>>2]+S(e,12)|0;if(!(N[f+10|0]&32)){K[d+g|0]=N[f+5|0];g=g+1|0}e=e+1|0;continue}}Lb(M[a>>2]);return}b=yb(d)&1073741823;if(b){if(c){nb(a,96,c,b,0,d,b);return}Vd(a,-1,d,b)}}function Ut(a){var b=0,c=0,d=0,e=0;e=Na-16|0;Na=e;c=O[a+16>>1];if(!(c&45)){a:{b:{c:{if(Jd(M[a+8>>2],a,M[a+12>>2],N[a+18|0])>>>0>1){break c}if((ig(M[a+8>>2],e+8|0,M[a+12>>2],N[a+18|0])|0)>1){break c}c=M[e+8>>2];b=M[e+12>>2];break b}c=0;d=R[a>>3];b=-2147483648;d:{if(d<-0x7ffffffffffffc00){break d}c=-1;b=2147483647;if(d>0x7ffffffffffffc00){break d}if(U(d)<0x8000000000000000){c=~~d>>>0;if(U(d)>=1){b=~~(d>0?W(Y(d*2.3283064365386963e-10),4294967295):Z((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}}else{c=0;b=-2147483648}}if(Bw(d,c,b)){break b}b=8;break a}M[a>>2]=c;M[a+4>>2]=b;b=4}c=b|O[a+16>>1]&-3520}L[a+16>>1]=c&64493;Na=e+16|0}function Qr(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=i?16:0;q=o|g&2|1;j=b+8|0;k=M[a+8>>2];while(1){m=M[j>>2];if(m){l=(n<<2)+f|0;j=M[l>>2];a:{if(!j){break a}if(M[m+36>>2]){$a(k,51,j,M[k+108>>2]+2|0)}j=o;p=N[m+55|0]|N[m+56|0]<<8;j=(p&3)==2?N[b+28|0]&128?q:j:j;l=M[l>>2];lb(k,138,d+n|0,l,l+1|0,O[(p&8?50:52)+m>>1]);l=M[k+108>>2];if((l|0)<=0){break a}L[(M[k+104>>2]+S(l,20)|0)-18>>1]=j}n=n+1|0;j=m+20|0;continue}break}b:{if(N[b+28|0]&128){break b}d=N[a+18|0];bb(k,128,c,M[(n<<2)+f>>2],e);if(!N[a+18|0]){Jc(k,b,-5)}a=M[k+108>>2];if((a|0)<=0){break b}b=(M[k+104>>2]+S(a,20)|0)-18|0;a=d?0:g?g|1:33;a=h?a|8:a;L[b>>1]=(i?a|16:a)&255}}function Ex(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;g=Na-80|0;Na=g;M[g+24>>2]=0;M[g+16>>2]=0;M[g+20>>2]=0;M[g+12>>2]=0;a:{if((b|0)<=0){h=267;break a}i=N[a|0];fe(c,b,g+12|0);h=M[g+12>>2];if(h){break a}M[c+4>>2]=0;h=Vp(g+32|0,a,b);k=(i|0)!=0;while(1){b:{if(!M[g+32>>2]|h){break b}b=M[g+60>>2];h=M[g+56>>2];c:{if(!M[c+4>>2]){i=Gx(h,b,d,e);if((i|0)<0|!i&k){break c}i=M[g+48>>2];j=M[g+52>>2];Dx(c,K[a|0],i,j);M[f>>2]=i;M[f+4>>2]=j}h=Fx(c,g+16|0,h,b,M[g+68>>2],M[g+72>>2]);if(h){break b}}h=Rl(g+32|0);continue}break}if(!M[c+4>>2]){d=K[a|0];b=M[g+48>>2];a=M[g+52>>2];Dx(c,d,b,a);M[f>>2]=b;M[f+4>>2]=a}ab(M[g+56>>2]);ab(M[g+16>>2])}Na=g+80|0;return h}function xC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;d=Na-80|0;Na=d;a:{if(!c){break a}b=M[c>>2];if(!b|!M[c+8>>2]){break a}b=Hc(M[a>>2],b,M[a+4>>2]);if(!b){break a}b:{e=M[c+4>>2];if(!e){c=M[c+8>>2];break b}c:{if(!hc(M[c>>2],e)){a=qc(b);break c}a=nf(M[a>>2],e,M[a+4>>2])}c=M[c+8>>2];if(!a){break b}e=(N[a+55|0]|N[a+56|0]<<8)&65531;K[a+55|0]=e;K[a+56|0]=e>>>8;st(c,O[a+50>>1]+1|0,M[a+8>>2],a);c=N[a+55|0]|N[a+56|0]<<8|128;K[a+55|0]=c;K[a+56|0]=c>>>8;if(M[a+36>>2]){break a}L[b+38>>1]=O[M[a+8>>2]>>1];M[b+28>>2]=M[b+28>>2]|16;break a}L[d+56>>1]=O[b+40>>1];st(c,1,b+38|0,d+8|0);L[b+40>>1]=O[d+56>>1];M[b+28>>2]=M[b+28>>2]|16}Na=d+80|0;return 0}function fw(a,b){var c=0,d=0,e=0;if(a){if(!xl(a)){return _c(182778)}if(N[a+94|0]&8){Ra[M[a+212>>2]](8,M[a+216>>2],a,0)|0}Fe(a);while(1){if((d|0)<M[a+20>>2]){a:{c=M[(M[a+16>>2]+(d<<4)|0)+12>>2];if(!c){break a}c=c+16|0;while(1){c=M[c>>2];if(!c){break a}e=M[c+8>>2];if(N[e+43|0]!=1){continue}ew(a,e);continue}}d=d+1|0;continue}break}c=a+396|0;while(1){c=M[c>>2];if(c){d=M[M[c+8>>2]+20>>2];if(!d){continue}ew(a,d);continue}break}km(a);dw(a);b:{if(b){break b}if(!px(a)){break b}ae(a,5,4793,0);return 5}while(1){b=M[a+532>>2];if(b){M[a+532>>2]=M[b>>2];c=M[b+8>>2];if(c){Ra[c|0](M[b+4>>2])}ab(b);continue}break}K[a+97|0]=167;Gm(a)}return 0}function fl(a,b,c){var d=0,e=0,f=0,g=0;a:{if(M[a+24>>2]>(b|0)){d=M[M[a+32>>2]+(b<<2)>>2];M[c>>2]=d;e=0;if(d){break a}}e=c;b:{if(M[a+24>>2]<=(b|0)){c=b+1|0;d=Ud(M[a+32>>2],c<<2,0);if(!d){c=7;a=0;break b}f=M[a+24>>2];g=c-f<<2;if(g){D(d+(f<<2)|0,0,g)}M[a+24>>2]=c;M[a+32>>2]=d}c:{if(N[a+43|0]==2){c=zd(32768,0);M[M[a+32>>2]+(b<<2)>>2]=c;c=c?0:7;break c}c=M[a+4>>2];c=Ra[M[M[c>>2]+52>>2]](c,b,32768,N[a+44|0],M[a+32>>2]+(b<<2)|0)|0;if(!c){c=0;if(!b){break c}d=M[16930];if(!d){break c}if(!(Ra[d|0](600)|0)){break c}c=7;break c}if((c&255)!=8){break c}K[a+46|0]=N[a+46|0]|2;c=(c|0)!=8?c:0}a=M[M[a+32>>2]+(b<<2)>>2]}M[e>>2]=a;e=c}return e}function QH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;a:{e=Ib(a,16);if(!e){break a}b:{c:{d:{switch(Xg(M[c+4>>2])-1|0){case 0:g=sb(M[c+4>>2]);b=Qa;break c;case 1:break d;default:break b}}d=Kb(M[c+4>>2]);if(U(d)<0x8000000000000000){g=~~d>>>0;if(U(d)>=1){b=~~(d>0?W(Y(d*2.3283064365386963e-10),4294967295):Z((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}}else{b=-2147483648}if(+(g>>>0)+ +(b|0)*4294967296!=d){break b}}if(!g&(b|0)<=0|(b|0)<0){break b}f=M[e+4>>2];h=M[e>>2]+1|0;f=h?f:f+1|0;M[e>>2]=h;M[e+4>>2]=f;if((g|0)!=(h|0)|(b|0)!=(f|0)){break a}b=yj(M[c>>2]);M[e+8>>2]=b;if(b){break a}$b(a);return}Pb(a,9519,-1)}}function Kz(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=(b|0)>0?b:0;while(1){if((h|0)!=(k|0)){i=Fb(M[(h<<2)+c>>2]);g=i+g|0;f=(i>>31)+f|0;f=g>>>0<i>>>0?f+1|0:f;h=h+1|0;continue}break}l=d>>31;b=b-1|0;h=ZJ(d,l,b,b>>31);b=f+Qa|0;f=g+h|0;b=f>>>0<g>>>0?b+1|0:b;f=f+1|0;b=f?b:b+1|0;b=Bb(f,b);if(b){g=0;f=0;h=0;while(1){if((h|0)!=(k|0)){j=(h<<2)+c|0;i=Fb(M[j>>2]);a:{if((i|0)<=0){break a}j=gb(M[j>>2]);if(!j){break a}if(!(!g&(f|0)<=0|(f|0)<0|(d|0)<=0)){if(d){G(b+g|0,e,d)}f=f+l|0;g=d+g|0;f=g>>>0<d>>>0?f+1|0:f}if(i){G(b+g|0,j,i)}f=(i>>31)+f|0;j=g;g=g+i|0;f=j>>>0>g>>>0?f+1|0:f}h=h+1|0;continue}break}K[b+g|0]=0;kg(a,b,g,f,1);return}$b(a)}function bf(a,b,c){var d=0,e=0,f=0,g=0;d=N[a+25|0];a:{if(!d){d=M[a>>2];if(N[M[d+4>>2]+8|0]&8){Bq(a);break a}if(N[a+24|0]){kg(d,M[a+4>>2],M[a+16>>2],M[a+20>>2],-1);break a}b:{if(Lq(a)){if(!(!M[b+8>>2]|(N[b+36|0]|!b))){e=M[a+4>>2];d=e-8|0;f=d;g=M[d>>2];d=M[d+4>>2];g=g+1|0;d=g?d:d+1|0;M[f>>2]=g;M[f+4>>2]=d;M[b+12>>2]=e;d=M[a+16>>2];K[b+36|0]=1;M[b+20>>2]=d;if((pz(c,b)|0)==7){break b}}d=M[a>>2];f=M[a+4>>2];b=f-8|0;c=b;e=M[b>>2];b=M[b+4>>2];e=e+1|0;b=e?b:b+1|0;M[c>>2]=e;M[c+4>>2]=b;kg(d,f,M[a+16>>2],M[a+20>>2],9);break a}$b(M[a>>2]);break a}$b(c);break a}if(d&1){$b(M[a>>2]);break a}if(!(d&2)){break a}Pb(M[a>>2],20034,-1)}rg(a)}function yy(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=Na-16|0;Na=c;a=M[M[a>>2]+20>>2];M[c>>2]=-1;M[c+12>>2]=0;M[c+4>>2]=c+12;f=Na-16|0;Na=f;M[f+12>>2]=c;a:{while(1){if((e|0)==21){break a}b=e<<4;e=e+1|0;b=b+32800|0;if(M[b>>2]!=1004){continue}break}d=M[f+12>>2];M[f+12>>2]=d+4;g=M[d>>2];M[f+12>>2]=d+8;e=M[a+32>>2];h=M[a+36>>2];i=M[d+4>>2];b:{c:{if((g|0)>0){g=h|M[b+12>>2];d=e|M[b+8>>2];break c}if(g){break b}g=(M[b+12>>2]^-1)&h;d=(M[b+8>>2]^-1)&e}M[a+32>>2]=d;M[a+36>>2]=g;if((e|0)==(d|0)&(g|0)==(h|0)){break b}gg(a,0)}if(!i){break a}M[i>>2]=(M[b+8>>2]&M[a+32>>2]|M[b+12>>2]&M[a+36>>2])!=0}Na=f+16|0;Na=c+16|0;return M[c+12>>2]}function fh(a,b){var c=0,d=0,e=0,f=0,g=0;d=M[a+12>>2];c=d;e=M[a+8>>2];d=c<<1|e>>>31;g=d;f=b+e|0;d=f>>>0<e>>>0?c+1|0:c;f=f+10|0;d=f>>>0<10?d+1|0:d;c=!c&b>>>0<e>>>0|(c|0)!=0;b=c?e<<1:f;d=c?g:d;a:{b:{c:{if(N[a+24|0]){c=1;if(N[a+25|0]){break b}c=zo(b,d);if(!c){K[a+25|0]=N[a+25|0]|1;b=M[a>>2];if(b){$b(b)}rg(a);return 7}e=M[a+16>>2];if(e){G(c,M[a+4>>2],e)}K[a+24|0]=0;M[a+4>>2]=c;break c}e=M[a+4>>2]-8|0;c=d;g=b+9|0;c=g>>>0<9?c+1|0:c;c=Mc(e,g,c);if(!c){break a}M[a+4>>2]=c+8}M[a+8>>2]=b;M[a+12>>2]=d;c=0}return c}ab(e);K[a+24|0]=1;M[a+16>>2]=0;M[a+20>>2]=0;M[a+8>>2]=100;M[a+12>>2]=0;M[a+4>>2]=a+26;K[a+25|0]=N[a+25|0]|1;return 7}function ln(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;f=Na-16|0;Na=f;a:{e=M[b>>2];g=e+c|0;if(g>>>0>P[b+4>>2]){b:{c:{if((g|0)>=200){M[f>>2]=200;cb(a,17519,f);break c}g=M[a>>2];h=e>>31<<1|e>>>31;i=e<<1;e=i+c|0;a=h+(c>>31)|0;a=e>>>0<i>>>0?a+1|0:a;h=(a|0)>=0&e>>>0>=200|(a|0)>0;e=h?200:e;b=ld(g,b,ZJ(e,h?0:a,48,0)|8,Qa);if(b){break b}}b=0;break a}M[b+4>>2]=e;e=M[b>>2]}a=b+8|0;while(1){if((d|0)<(e|0)){e=e-1|0;G(a+S(e+c|0,48)|0,a+S(e,48)|0,48);continue}break}M[b>>2]=M[b>>2]+c;e=S(c,48);if(e){D(a+S(d,48)|0,0,e)}a=c+d|0;a=(a|0)<(d|0)?d:a;c=b+24|0;while(1){if((a|0)==(d|0)){break a}M[c+S(d,48)>>2]=-1;d=d+1|0;continue}}Na=f+16|0;return b}function ey(a){var b=0,c=0,d=0,e=0;c=M[a>>2];b=M[a+4>>2];K[b+19|0]=0;a:{if(!N[a+8|0]){break a}if(M[c+188>>2]>=2){b:{if(M[b+80>>2]!=(a|0)){break b}M[b+80>>2]=0;L[b+24>>1]=O[b+24>>1]&65343;d=b+76|0;while(1){c=M[d>>2];if(!c){break b}K[c+8|0]=1;d=c+12|0;continue}}K[a+8|0]=1;return}c=b+76|0;while(1){d=M[c>>2];if(d){if(M[d>>2]!=(a|0)){c=d+12|0;continue}M[c>>2]=M[d+12>>2];if(M[d+4>>2]==1){continue}ab(d);continue}break}c:{d:{if(M[b+80>>2]==(a|0)){M[b+80>>2]=0;c=M[b+44>>2];e=65343;break d}c=2;e=65407;d=M[b+44>>2];if((d|0)!=2){break c}}L[b+24>>1]=O[b+24>>1]&e;d=c}c=d-1|0;M[b+44>>2]=c;if(c){break a}K[b+20|0]=0}K[a+8|0]=0;Oo(b)}function Wp(a,b,c,d,e,f,g,h){var i=0,j=0;i=(c>>31)+f|0;j=c;c=c+e|0;i=j>>>0>c>>>0?i+1|0:i;j=c;c=f<<3|e>>>29;f=e<<3;e=j+f|0;c=c+i|0;c=e>>>0<f>>>0?c+1|0:c;f=c+(d>>31)|0;j=d;d=d+e|0;f=j>>>0>d>>>0?f+1|0:f;c=c<<3|e>>>29;e=e<<3;d=e+d|0;c=c+f|0;c=d>>>0<e>>>0?c+1|0:c;i=c+(g>>31)|0;e=d+g|0;i=e>>>0<g>>>0?i+1|0:i;c=c<<3|d>>>29;f=e;e=d<<3;d=f+e|0;c=c+i|0;c=d>>>0<e>>>0?c+1|0:c;f=c+(h>>31)|0;e=d+h|0;f=e>>>0<h>>>0?f+1|0:f;c=c<<3|d>>>29;d=d<<3;e=d+e|0;c=c+f|0;f=d>>>0>e>>>0?c+1|0:c;c=0;g=(b|0)>0?b:0;while(1){if((c|0)!=(g|0)){d=K[a+c|0];b=ZJ(e,f,9,0);e=d+b|0;i=Qa+(d>>31)|0;f=b>>>0>e>>>0?i+1|0:i;c=c+1|0;continue}break}Qa=f;return e}function tH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;e=Na+-64|0;Na=e;d=1;a:{b:{if((b|0)==2){b=sb(M[c+4>>2]);d=b-1|0;f=Qa-!b|0;if(!f&d>>>0>14|f){break b}d=b}c:{d:{e:{b=M[c>>2];switch(N[(O[b+16>>1]&63)+31312|0]-4|0){case 0:break e;case 1:break a;default:break d}}if(!Zj(b)){break d}if(d&4){b=1;break c}if(!(d&8)){b=0;break c}D(e+16|0,0,48);g=e,h=od(M[c>>2]),M[g+8>>2]=h;b=Fb(M[c>>2]);M[e+12>>2]=b;b=!pm(e+8|0,0,b,1);break c}b=0;if(!(d&3)){break c}c=Hf(a,M[c>>2],2);if(c){f:{if(N[c+35|0]){$b(a);break f}if(N[c+34|0]|!(N[c+37|0]?d&2:1)){break f}b=1}bd(c);break c}$b(a)}Ac(a,b);break a}Pb(a,23426,-1)}Na=e- -64|0}function Yf(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=O[a+24>>1];k=N[a+10|0];f=M[a+56>>2];g=N[a+9|0];b=f+g|0;c=(N[b+5|0]<<8|N[b+6|0])-1&65535;d=(c+N[b+7|0]|0)+1|0;e=M[M[a+52>>2]+40>>2];a:{b:{b=N[b+2|0]|N[b+1|0]<<8;if(!b){break b}if(b>>>0<=c>>>0){break a}l=e-4|0;w